<?php

namespace App\Exports;

use App\CoursesCurriculum;
use App\CoursesQuestions;
use App\CoursesViews;
use App\Rating;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class CoursesViewExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {

        $request =Request();
        $data = $request->input();

        $cvs = CoursesViews::join('courses', function($join)
        {
            $join->on('courses.id','=','courses_views.course_id')->where('courses.show_on','!=','medical');
        })
            ->leftjoin('instractors','instractors.id','=','courses.instractor')
            ->select('courses_views.course_id',
                'courses.name as course_name',
                'instractors.name AS instructor_name',
                DB::raw('COUNT(course_id) AS count'))

            ->groupBy('courses_views.course_id')
        ;
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $cvs = $cvs->where('courses_views.id', '=', $id);
        }
        if (isset($data['count']) && !empty($data['count'])) {
            $count = $data['count'];
            $cvs = $cvs->where('courses_views.count', '=', $count);
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $cvs = $cvs->where('courses.id','=', $course);
        }
        if (isset($data['instractor']) && !empty($data['instractor'])) {
            $instractor = $data['instractor'];
            $cvs = $cvs->where('courses.instractor','=', $instractor);
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $cvs = $cvs->whereBetween('courses_views.createdtime', [$created_time_from .' 00:00:00', $created_time_to.' 23:59:59']);
        }
        return $cvs->get();


    }
    public function headings()
    {
        return [
            '#',
            'Course Name',
            'Instructor Name',
            'Count',
        ];
    }
}
