<?php

namespace App\Exports;

use App\CoursesCurriculum;
use App\CoursesQuestions;
use App\Rating;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class CoursesRatingExport implements FromCollection, WithHeadings

{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $request =Request();
        $data=$request->input();
        $rating = Rating::join('users','users.id','=','rating.rating_userid')
            ->join('courses','courses.id','rating.rating_id')
            ->where('rating.rating_type','courses')
            ->select('rating.id',
                'rating.rating_userid',
                'users.Email as user_email',
                'courses.name as course_name',
                'rating.rating_question1',
                'rating.rating_question2',
                'rating.rating_question3',
                'rating.rating_question4',
                'rating.rating_count',
                'rating.comment',
                );
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $rating = $rating->where('rating.id', '=', $id);
        }
        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $user_id = $data['user_id'];
            $rating = $rating->where('rating.rating_userid', 'LIKE', "%$user_id%");
        }
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $user_email = $data['user_email'];
            $rating = $rating->where('users.Email', 'LIKE', "%$user_email%");
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $rating = $rating->where('courses.name', 'LIKE', "%$course%");
        }
        if (isset($data['rating_question1']) && !empty($data['rating_question1'])) {
            $rating_msg = $data['rating_question1'];
            $rating = $rating->where('rating.rating_question1', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question2']) && !empty($data['rating_question2'])) {
            $rating_msg = $data['rating_question2'];
            $rating = $rating->where('rating.rating_question2', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question3']) && !empty($data['rating_question3'])) {
            $rating_msg = $data['rating_question3'];
            $rating = $rating->where('rating.rating_question3', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating_question4']) && !empty($data['rating_question4'])) {
            $rating_msg = $data['rating_question4'];
            $rating = $rating->where('rating.rating_question4', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating_msg = $data['rating'];
            $rating = $rating->where('rating.rating_count', 'LIKE', "%$rating_msg%");
        }
        if (isset($data['comment']) && !empty($data['comment'])) {
            $comment = $data['comment'];
            $rating = $rating->where('rating.comment', 'LIKE', "%$comment%");
        }

        return $rating->get();


    }
    public function headings()
    {
        return [
            '#',
            'User ID',
            'User Name',
            'Course Name',
            'ما مدى رضاك عن طريقه عرض المحاضر للماده التدريبيه',
            'ما مدى استفادتك من المحتوي',
            'ما مدى رضاك عن جوده التصوير',
            'ما مدى رضاك عن الكورس بشكل عام',
            'Rating Avg',
            'Comment',

        ];
    }
}
