<?php $__env->startSection('content'); ?>
    <div class="page-content" id="loadingPageContent">
        <div class="row">
            <div class="col-md-12">
                <div class="portlet light portlet-fit portlet-datatable">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="icon-settings font-green"></i>
                            <span class="caption-subject font-green sbold uppercase">CRM New MBA Report</span>
                        </div>
                        <div class="pull-right">
                            <?php echo e(Form::open(['method'=>'POST','url'=>request()->fullUrl(),'id'=>'exportForm','style'=>'display: inline;'])); ?>

                            <input type="hidden" name="export" value="true">
                            <button type="submit" class="btn btn-info">Export</button>
                            <?php echo e(Form::close()); ?>

                            <button class="btn btn-success" id="generateData">Generate Data</button>
                        </div>
                        <div class="actions"></div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-container">
                            <div id="datatable_ajax_wrapper"
                                 class="dataTables_wrapper dataTables_extended_wrapper no-footer">
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered table-hover table-checkable"
                                           id="datatable_ajax">
                                        <thead>
                                        <tr role="row" class="heading">
                                            <th width="10%">#</th>
                                            <th>CRM</th>
                                            <th>Organization Name</th>
                                            <th>Primary Phone</th>
                                            <th>Primary Email</th>
                                            <th>Customer Status</th>
                                            <th>Assigned To</th>
                                            <th>Expiry Date</th>
                                            <th>Subscrip Type</th>
                                            <th>Customer type</th>
                                            <th>Last Comment Date</th>
                                            <th>Code</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Certificate Date</th>
                                            <th></th>
                                        </tr>
                                        <tr role="row" class="filter">
                                            <td>
                                                <input type="hidden" id="_token" name="_token" value="<?php echo e(csrf_token()); ?>">
                                            </td>
                                            <td>
                                                <select class="form-control form-filter input-sm sel2" name="crm" id="crm">
                                                    <option value="">Select CRM Type</option>
                                                    <option value="KSA">KSA</option>
                                                    <option value="EGY">EGY</option>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="name">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="phone">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="email">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="customer_status">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="assign_to">
                                            </td>
                                            <td>
                                                <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="date_from" placeholder="From">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                                <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="date_to" placeholder="To">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="subscrip_type">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="customer_type">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="last_commment_date">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control form-filter input-sm" name="code">
                                            </td>
                                            <td>
                                                <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="start_date_from" placeholder="From">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                                <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="start_date_to" placeholder="To">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="end_date_from" placeholder="From">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                                <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="end_date_to" placeholder="To">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="certificate_date_from" placeholder="From">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                                <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                    <input type="text" class="form-control form-filter input-sm"
                                                           name="certificate_date_to" placeholder="To">
                                                    <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="margin-bottom-5">
                                                    <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                        <i class="fa fa-search"></i> <?php echo e(Lang::get('main.search')); ?></button>
                                                </div>
                                                <button class="btn btn-sm red btn-outline filter-cancel">
                                                    <i class="fa fa-times"></i> <?php echo e(Lang::get('main.reset')); ?></button>
                                            </td>

                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footerScript'); ?>
    <script>
        <?php if($hasData): ?>
        $("#loadingPageContent").addClass('loading-gif');
        Swal.fire('Error', 'please waiting for data update', 'error');
        <?php endif; ?>
        $(document).on('click','#generateData',function(){
            $(this).attr('disabled','disabled');
            $("#loadingPageContent").addClass('loading-gif');
            $.ajax({
                type: "GET",
                cache: false,
                url: "<?php echo e(URL('admin/updateNewMbaDataForReport')); ?>",
                success: function(res) {
                    $("#loadingPageContent").addClass('loading-gif');
                },
            });
        });
        $(".form-filter").each(function(){
            let name=$(this).attr('name');
            let value=$(this).val();
            $("#exportForm").append('<input type="hidden" name="'+name+'" value="'+value+'">');
        });
        $(document).on('click','.filter-submit',function(){
            $(".form-filter").each(function(){
                let name=$(this).attr('name');
                let value=$(this).val();
                $("#exportForm input[name='"+name+"']").val(value);
            });
        })
        var token = "<?php echo e(csrf_token()); ?>";
        var grid = new Datatable();
        grid.setAjaxParam("_token", "<?php echo e(csrf_token()); ?>");
        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: 'Loading...',
            dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options

                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                // So when dropdowns used the scrollable div should be removed.
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                "lengthMenu": [
                    [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> -1 <?php endif; ?>],
                    [10, 20, 50, 100, 150, <?php if(PerUser('view_all_rows')): ?> "All" <?php endif; ?>] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": "<?php echo e(request()->fullUrl()); ?>", // ajax source
                },
                "order": [
                    [0, "desc"]
                ],// set first column as a default sort by asc
                dom: 'lfrtip',
                buttons: [
                    {extend: 'print', className: 'btn dark btn-outline'},
                    {extend: 'pdf', className: 'btn green btn-outline'},
                    {extend: 'csv', className: 'btn purple btn-outline '}
                ],
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>