<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Models\ModulesUsersSummary;

if(version_compare(PHP_VERSION, '7.2.0', '>=')) {
    error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
}

/*****************************************************************/

Route::get('/loginAsUser/{id}', function ($id) {
    Auth::loginUsingId($id);
    return Redirect::to('/admin');
    //return view('welcome');
});
Route::get('/db', function() {
//    $result= DB::connection('mysql2')->select("select modules_users_summary.*,mba.name AS module_name,users.Email AS user_email,users.FullName AS user_name,users.Mobile AS user_phone, modules_users_projects.correction_date from `modules_users_summary` left join `users` on `users`.`id` = `modules_users_summary`.`user_id` inner join `mba` on `mba`.`id` = `modules_users_summary`.`module_id` left join `modules_users_projects` on `modules_users_projects`.`user_id` = `modules_users_summary`.`user_id` and `modules_users_projects`.`project_id` = `modules_users_summary`.`project_id` limit 5 ");
//    $result= DB::connection('mysql3')->statement("ALTER TABLE `medical_charge_transactions_suspend_log` ADD `diploma_id` INT(11) NULL AFTER `user_id`;
//");
    $result= DB::connection('mysql3')->select("select * from diploma_certificates");

    print_r($result);
});


Route::get('/', function () {
    return Redirect::to('/admin');
    //return view('welcome');
});

//Clear Cache facade value:
Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    return '<h1>Cache facade value cleared</h1>';
});

//Reoptimized class loader:
Route::get('/optimize', function() {
    $exitCode = Artisan::call('optimize');
    return '<h1>Reoptimized class loader</h1>';
});

//Route cache:
Route::get('/route-cache', function() {
    $exitCode = Artisan::call('route:cache');
    return '<h1>Routes cached</h1>';
});

//Clear Route cache:
Route::get('/route-clear', function() {
    $exitCode = Artisan::call('route:clear');
    return '<h1>Route cache cleared</h1>';
});

//Clear View cache:
Route::get('/view-clear', function() {
    $exitCode = Artisan::call('view:clear');
    return '<h1>View cache cleared</h1>';
});

//Clear Config cache:
Route::get('/config-cache', function() {
    $exitCode = Artisan::call('config:cache');
    return '<h1>Clear Config cleared</h1>';
});

//Clear Config cache:
Route::get('/config-clear', function() {
    $exitCode = Artisan::call('config:clear');
    return '<h1>Clear Config cleared</h1>';
});
/*auth routes*/

Route::group(['prefix' => 'CRONJOB'],function(){
   Route::get('generateNewMbaSummaryTotalProgress',function(){
        foreach (\App\Models\NewMbaModulesUsersSummary::select('new_mba_modules_users_summary.*','users.Email AS user_email')->join('users','users.id','=','new_mba_modules_users_summary.user_id')->get() as $summary){
            $statistics = modules_statistics('new_mba', $summary->user_email);
            $totalProgress = ((($summary->progress * $statistics->max_progress) + ($summary->project * $statistics->max_project) + ($summary->exam_part_1 * $statistics->max_exam_part1) + ($summary->exam_part_2 * $statistics->max_exam_part2)) / 100);
            $summary->total_progress=$totalProgress>100?100:$totalProgress;
            $summary->save();
        }
   });
    Route::get('generateMbaSummaryTotalProgress',function(){
        foreach (\App\Models\ModulesUsersSummary::select('modules_users_summary.*','users.Email AS user_email')->join('users','users.id','=','modules_users_summary.user_id')->get() as $summary){
            $statistics = modules_statistics('mba', $summary->user_email);
            $totalProgress = ((($summary->progress * $statistics->max_progress) + ($summary->project * $statistics->max_project) + ($summary->exam * $statistics->max_exam)) / 100);
            $summary->total_progress=$totalProgress>100?100:$totalProgress;
            $summary->save();
        }
    });
    Route::get('updateCourseDuration',function(){
        foreach (\App\Models\Courses::pluck('id')->toArray() as $id){
            \Illuminate\Support\Facades\DB::connection('mysql2')->select("UPDATE courses SET duration=(SELECT SUM(new_duration) FROM (SELECT DISTINCT cources_curriculum.id,duration,
 CASE
            WHEN duration LIKE '%دقيقة%' THEN CAST(SUBSTRING_INDEX(duration, ' ', 1) AS UNSIGNED)*60
            WHEN duration LIKE '%دقيقية%' THEN CAST(SUBSTRING_INDEX(duration, ' ', 1) AS UNSIGNED)*60
            WHEN duration LIKE '%دقائق%' THEN CAST(SUBSTRING_INDEX(duration, ' ', 1) AS UNSIGNED)*60
            WHEN duration LIKE '%:%' THEN (MINUTE(STR_TO_DATE(duration, '%i:%s'))*60)+SECOND(STR_TO_DATE(duration, '%i:%s'))
            ELSE 0
        END AS new_duration

FROM `cources_curriculum` INNER JOIN courses_sections ON courses_sections.id=cources_curriculum.id WHERE courses_sections.course_id ='$id' AND cources_curriculum.deleted_at IS NULL AND cources_curriculum.published='yes' AND courses_sections.deleted_at IS NULL AND courses_sections.published='yes' AND cources_curriculum.type='default') AS dd) WHERE id='$id';");
        }
    });
});
Auth::routes();
Route::get('admin/logout', 'Auth\LoginController@logout')->name('logout');

Route::post('admin/send_feedback', ['uses'=>'Admin\AdminController@send_feedback']);

Route::post('admin/getStates',['uses'=>'Admin\StatesController@getStates']);



 Route::get('admin/updateMbaDataForReport','Admin\MbaReportController@updateMbaDataForReport')->name('crm_reports_mba');
 Route::get('admin/updateNewMbaDataForReport','Admin\MbaReportController@updateNewMbaDataForReport')->name('crm_reports_new_mba');
 Route::get('admin/updateDiplomasDataForReport','Admin\MbaReportController@updateDiplomasDataForReport')->name('crm_reports_diplomas');


Route::group(['middleware' => 'PermissionsAuth'], function () {
    /*home page admin route*/
    Route::get('/admin', 'Admin\AdminController@home');
    Route::group(['prefix' => 'admin'], function () {
        /*users routes*/
        Route::resource('users', 'Admin\UsersController',['names'=>['create'=>'users_add','store'=>'users_add','index'=>'users','edit'=>'users_edit','update'=>'users_edit','destroy'=>'users_delete']]);
        Route::post('users/activation', ['uses'=>'Admin\UsersController@activation','as'=>'users_active']);
        Route::get('edit_profile/{id}', ['uses' => 'Admin\UsersController@edit_profile', 'as' => 'user_edit']);
        Route::post('edit_profile/{id}', ['uses' => 'Admin\UsersController@update_profile', 'as' => 'user_edit']);

        /*profiles permission routes*/
        Route::resource('profiles', 'Admin\ProfilesController',['names'=>['create'=>'profiles_add','store'=>'profiles_add','index'=>'profiles','edit'=>'profiles_edit','update'=>'profiles_edit','destroy'=>'profiles_delete']]);
        Route::post('profiles/activation', ['uses'=>'Admin\ProfilesController@activation','as'=>'profiles_active']);

        /*profile routes*/
        Route::get('profile', ['uses'=>'Admin\AdminController@profile','as'=>'profile']);
        Route::post('profile', ['uses'=>'Admin\AdminController@profilePost','as'=>'profile']);
        /*profile routes*/
        Route::get('system', ['uses'=>'Admin\AdminController@system','as'=>'system']);
        Route::post('system', ['uses'=>'Admin\AdminController@systemPost','as'=>'system']);

        Route::get('annual_report', ['uses' => 'Admin\AdminController@annual_report', 'as' => 'annual_view']);
        Route::post('annual_report_export', ['uses' => 'Admin\AdminController@annual_report_search', 'as' => 'annual_view']);
        Route::post('annual_report_search', ['uses' => 'Admin\AdminController@annual_report_search', 'as' => 'annual_view']);

        Route::get('diploma_report', ['uses' => 'Admin\AdminController@diploma_report', 'as' => 'diploma_report_view']);
        Route::post('diploma_report_export', ['uses' => 'Admin\AdminController@diploma_report_export', 'as' => 'diploma_report_view']);
        Route::post('diploma_report_search', ['uses' => 'Admin\AdminController@diploma_report_search', 'as' => 'diploma_report_view']);

        Route::get('training_program_report', ['uses' => 'Admin\AdminController@training_program_report', 'as' => 'training_program_report_view']);
        Route::get('training_program_report_export', ['uses' => 'Admin\AdminController@training_program_report_export', 'as' => 'training_program_report_view']);
        Route::post('training_program_report_search', ['uses' => 'Admin\AdminController@training_program_report_search', 'as' => 'training_program_report_view']);

        Route::get('courses_report', ['uses' => 'Admin\AdminController@courses_report', 'as' => 'courses_report_view']);
        Route::post('courses_report_search', ['uses' => 'Admin\AdminController@courses_report_search', 'as' => 'courses_report_view']);

          Route::get('courses_watching_report', ['uses' => 'Admin\AdminController@courses_watching_report', 'as' => 'courses_watching_report_view']);
        Route::post('courses_watching_report_search', ['uses' => 'Admin\AdminController@courses_watching_report_search', 'as' => 'courses_watching_report_view']);

        Route::get('mba_courses_report', ['uses' => 'Admin\AdminController@mba_courses_report', 'as' => 'mba_courses_report_view']);
        Route::post('mba_courses_report_search', ['uses' => 'Admin\AdminController@mba_courses_report_search', 'as' => 'mba_courses_report_view']);

        Route::get('books_report', ['uses' => 'Admin\AdminController@books_report', 'as' => 'books_report_view']);
        Route::post('books_report_search', ['uses' => 'Admin\AdminController@books_report_search', 'as' => 'books_report_view']);
        Route::get('bookdownload/{book}', ['uses' => 'Admin\AdminController@download_book', 'as' => 'books_report_view']);

        Route::get('successstories_report', ['uses' => 'Admin\AdminController@successstories_report', 'as' => 'successstories_report_view']);
        Route::post('successstories_report_search', ['uses' => 'Admin\AdminController@successstories_report_search', 'as' => 'successstories_report_view']);

        Route::get('workshops_report', ['uses' => 'Admin\AdminController@workshops_report', 'as' => 'workshops_report_view']);
        Route::post('workshops_report_search', ['uses' => 'Admin\AdminController@workshops_report_search', 'as' => 'workshops_report_view']);

        Route::get('webinars_report', ['uses' => 'Admin\AdminController@webinars_report', 'as' => 'webinars_report_view']);
        Route::post('webinars_report_search', ['uses' => 'Admin\AdminController@webinars_report_search', 'as' => 'webinars_report_view']);

        Route::get('articles_report', ['uses' => 'Admin\AdminController@articles_report', 'as' => 'articles_report_view']);
        Route::post('articles_report_search', ['uses' => 'Admin\AdminController@articles_report_search', 'as' => 'articles_report_view']);

        Route::get('diplomas_report', ['uses' => 'Admin\AdminController@diplomas_report', 'as' => 'diplomas_report_view']);
        Route::post('diplomas_report_search', ['uses' => 'Admin\AdminController@diplomas_report_search', 'as' => 'diplomas_report_view']);


        Route::get('training_programs_report', ['uses' => 'Admin\AdminController@training_programs_report', 'as' => 'training_programs_report_view']);
        Route::post('training_programs_report_search', ['uses' => 'Admin\AdminController@training_programs_report_search', 'as' => 'training_programs_report_view']);
        Route::post('training_programs_report_export', ['uses' => 'Admin\AdminController@training_programs_report_search', 'as' => 'training_programs_report_export']);

        Route::get('international_diplomas_report', ['uses' => 'Admin\AdminController@international_diplomas_report', 'as' => 'international_diplomas_report_view']);
        Route::post('international_diplomas_report_search', ['uses' => 'Admin\AdminController@international_diplomas_report_search', 'as' => 'international_diplomas_report_view']);
        Route::post('international_diplomas_report_export', ['uses' => 'Admin\AdminController@international_diplomas_report_search', 'as' => 'international_diplomas_report_export']);

        Route::get('mbas_report', ['uses' => 'Admin\AdminController@mbas_report', 'as' => 'mbas_report_view']);
        Route::post('mbas_report_search', ['uses' => 'Admin\AdminController@mbas_report_search', 'as' => 'mbas_report_view']);


        Route::post('getDiplomasSupplementaryTestsAjax', ['uses' => 'Admin\AdminController@getDiplomasSupplementaryTestsAjax','as' => 'dashboard_diplomas_charges_supplementary_tests']);

        Route::get('feedback_report', ['uses' => 'Admin\AdminController@feedback_report', 'as' => 'feedback_report_view']);
        Route::post('feedback_report_search', ['uses' => 'Admin\AdminController@feedback_report_search', 'as' => 'feedback_report_view']);

        Route::get('diploma_exam_report', ['uses' => 'Admin\AdminController@diploma_exam_report', 'as' => 'diploma_exam_report_view']);
        Route::post('diploma_exam_report_search', ['uses' => 'Admin\AdminController@diploma_exam_report_search', 'as' => 'diploma_exam_report_view']);
        Route::post('diploma_exam_report_export', ['uses' => 'Admin\AdminController@diploma_exam_report_export', 'as' => 'diploma_exam_report_export']);

        Route::get('diploma_not_exam_report', ['uses' => 'Admin\AdminController@diploma_not_exam_report', 'as' => 'diploma_not_exam_report_view']);
        Route::post('diploma_not_exam_report_search', ['uses' => 'Admin\AdminController@diploma_not_exam_report_search', 'as' => 'diploma_not_exam_report_view']);
        Route::post('diploma_not_exam_report_export', ['uses' => 'Admin\AdminController@diploma_not_exam_report_export', 'as' => 'diploma_not_exam_report_export']);


        Route::get('training_program_exam_report', ['uses' => 'Admin\AdminController@training_program_exam_report', 'as' => 'training_program_exam_report_view']);
        Route::post('training_program_exam_report_search', ['uses' => 'Admin\AdminController@training_program_exam_report_search', 'as' => 'training_program_exam_report_view']);
        Route::post('training_program_exam_report_export', ['uses' => 'Admin\AdminController@training_program_exam_report_export', 'as' => 'training_program_exam_report_export']);

        Route::get('training_program_not_exam_report', ['uses' => 'Admin\AdminController@training_program_not_exam_report', 'as' => 'training_program_not_exam_report_view']);
        Route::post('training_program_not_exam_report_search', ['uses' => 'Admin\AdminController@training_program_not_exam_report_search', 'as' => 'training_program_not_exam_report_view']);

        Route::get('mba_report', ['uses' => 'Admin\AdminController@mba_report', 'as' => 'mba_report_view']);

        /* Start Exporting MBA Reports */

        Route::get('mba_report_statistics/{user_id}', ['uses' => 'Admin\AdminController@exportMbaStatistics', 'as' => 'mba_report_statistics']);
        Route::get('mba_report_views/{user_id}', ['uses' => 'Admin\AdminController@exportMbaViews', 'as' => 'mba_report_views']);
        Route::get('mba_report_tests/{user_id}', ['uses' => 'Admin\AdminController@exportMbaTests', 'as' => 'mba_report_tests']);
        Route::get('mba_report_trainings/{user_id}', ['uses' => 'Admin\AdminController@exportMbaTrainings', 'as' => 'mba_report_trainings']);
        Route::get('mba_report_courses_reports/{user_id}', ['uses' => 'Admin\AdminController@exportMbaCoursesReport', 'as' => 'mba_report_courses_reports']);

        /* End Exporting MBA Reports */

        /* Start Exporting New MBA Reports */

        Route::get('new_mba_report_statistics/{user_id}', ['uses' => 'Admin\AdminController@exportNewMbaStatistics', 'as' => 'new_mba_report_statistics']);
        Route::get('new_mba_category_report_statistics/{user_id}', ['uses' => 'Admin\AdminController@exportNewMbaCategoryStatistics', 'as' => 'new_mba_report_statistics']);
        Route::get('new_mba_report_views/{user_id}', ['uses' => 'Admin\AdminController@exportNewMbaViews', 'as' => 'new_mba_report_views']);
        Route::get('new_mba_report_tests1/{user_id}', ['uses' => 'Admin\AdminController@exportNewMbaTests1', 'as' => 'new_mba_report_tests']);
        Route::get('new_mba_report_tests2/{user_id}', ['uses' => 'Admin\AdminController@exportNewMbaTests2', 'as' => 'new_mba_report_tests']);
        Route::get('new_mba_report_trainings/{user_id}', ['uses' => 'Admin\AdminController@exportNewMbaTrainings', 'as' => 'new_mba_report_trainings']);
        Route::get('new_mba_report_courses_reports/{user_id}', ['uses' => 'Admin\AdminController@exportNewMbaCoursesReport', 'as' => 'new_mba_report_courses_reports']);

        /* End Exporting New MBA Reports */


        Route::post('mba_report_search', ['uses' => 'Admin\AdminController@mba_report_search', 'as' => 'mba_report_view']);

        /* Start [ mba report ] New Routes */

        Route::get('new_mba_report', ['uses' => 'Admin\AdminController@new_mba_report', 'as' => 'new_mba_report_view']);
        Route::post('new_mba_report_search', ['uses' => 'Admin\AdminController@new_mba_report_search', 'as' => 'new_mba_report_view']);


        /* Start [ dba preliminary report ] New Routes */

        Route::get('dba_preliminary_report', ['uses' => 'Admin\AdminController@dba_preliminary_report', 'as' => 'dba_preliminary_report_view']);
        Route::post('dba_preliminary_report_search', ['uses' => 'Admin\AdminController@dba_preliminary_report_search', 'as' => 'dba_preliminary_report_view']);
  /* Start [ dba report ] New Routes */

        Route::get('dba_report', ['uses' => 'Admin\AdminController@dba_report', 'as' => 'dba_report_view']);
        Route::post('dba_report_search', ['uses' => 'Admin\AdminController@dba_report_search', 'as' => 'dba_report_view']);


        Route::get('dba_certificates_report', ['uses' => 'Admin\AdminController@dba_certificates_report', 'as' => 'dba_certificates_report_view']);
        Route::post('dba_certificates_report_search', ['uses' => 'Admin\AdminController@dba_certificates_report_search', 'as' => 'dba_certificates_report_view']);

        /* End [ mba report ] New Routes */

        Route::get('alex_event_payment', ['uses' => 'Admin\AdminController@alex_event_payment', 'as' => 'alex_event_payment_view']);
        Route::post('alex_event_payment_search', ['uses' => 'Admin\AdminController@alex_event_payment_search', 'as' => 'alex_event_payment_view']);

        Route::get('mba_users_summary', ['uses' => 'Admin\AdminController@mba_users_summary', 'as' => 'mba_users_summary_view']);
        Route::post('mba_users_summary_search', ['uses' => 'Admin\AdminController@mba_users_summary_search', 'as' => 'mba_users_summary_view']);

        /* Start New MBA Users Summary Routes */
        Route::get('new_mba_users_summary', ['uses' => 'Admin\AdminController@new_mba_users_summary', 'as' => 'new_mba_users_summary_view']);
        Route::post('new_mba_users_summary_search', ['uses' => 'Admin\AdminController@new_mba_users_summary_search', 'as' => 'new_mba_users_summary_view']);
        /* End New MBA Users Summary Routes*/

        Route::get('crm_apis', ['uses' => 'Admin\AdminController@crm_apis', 'as' => 'crm_apis_view']);

        Route::get('life_time_report', ['uses' => 'Admin\AdminController@life_time_report', 'as' => 'life_time_report_view']);
        Route::post('life_time_report_search', ['uses' => 'Admin\AdminController@life_time_report_search', 'as' => 'life_time_report_view']);

        Route::get('life_time_customer_report_per_course', ['uses' => 'Admin\AdminController@life_time_customer_report_per_course', 'as' => 'life_time_customer_report_per_course_view']);
        Route::post('life_time_customer_report_per_course_search', ['uses' => 'Admin\AdminController@life_time_customer_report_per_course_search', 'as' => 'life_time_customer_report_per_course_view']);
        Route::get('life_time_customer_report_per_course_export', ['uses' => 'Admin\AdminController@life_time_customer_report_per_course_export', 'as' => 'life_time_customer_report_per_course_export']);

        Route::post('changeLifeTime', ['uses' => 'Admin\AdminController@changeLifeTime', 'as' => 'life_time_report_view']);

        Route::get('diploma', ['uses' => 'Admin\AdminController@diploma', 'as' => 'diploma_view']);
        Route::post('getDiplomaSummaryDate', ['uses' => 'Admin\AdminController@getDiplomaSummaryDate', 'as' => 'diploma_view']);

        Route::get('user_diplomas_report', ['uses' => 'Admin\AdminController@user_diplomas_report', 'as' => 'user_diplomas_report_view']);
        Route::get('user_yotta_diplomas_report', ['uses' => 'Admin\AdminController@user_yotta_diplomas_report', 'as' => 'user_diplomas_report_view']);
        Route::post('searchForUser', ['uses' => 'Admin\AdminController@searchForUser', 'as' => 'user_diplomas_report_view']);
        Route::post('searchForYottaUser', ['uses' => 'Admin\AdminController@searchForYottaUser', 'as' => 'user_diplomas_report_view']);
        Route::post('getUserDiplomaReport', ['uses' => 'Admin\AdminController@getUserDiplomaReport', 'as' => 'user_diplomas_report_view']);
        Route::post('getUserYottaDiplomaReport', ['uses' => 'Admin\AdminController@getUserYottaDiplomaReport', 'as' => 'user_diplomas_report_view']);
        Route::post('generateDiplomaCertificate', ['uses' => 'Admin\AdminController@generateDiplomaCertificate', 'as' => 'user_diplomas_report_view']);



        Route::post('generateYottaDiplomaCertificate', ['uses' => 'Admin\AdminController@generateYottaDiplomaCertificate', 'as' => 'dashboard_yotta']);
        Route::get('user_international_diplomas_report', ['uses' => 'Admin\AdminController@user_international_diplomas_report', 'as' => 'user_international_diplomas_report_view']);
        Route::post('searchInternationalForUser', ['uses' => 'Admin\AdminController@searchInternationalForUser', 'as' => 'user_international_diplomas_report_view']);
        Route::post('getUserInternationalDiplomaReport', ['uses' => 'Admin\AdminController@getUserInternationalDiplomaReport', 'as' => 'user_international_diplomas_report_view']);
        Route::post('generateInternationalDiplomaCertificate', ['uses' => 'Admin\AdminController@generateInternationalDiplomaCertificate', 'as' => 'user_international_diplomas_report_view']);

        Route::get('user_diplomas_courses_certificates_report/{user_id}/{diploma_id}', ['uses' => 'Admin\AdminController@export_user_diplomas_courses_certificates_report', 'as' => 'user_diplomas_courses_certificates_report']);


        Route::get('training_program', ['uses' => 'Admin\AdminController@training_program', 'as' => 'training_program_view']);
        Route::post('getTrainingProgramSummaryDate', ['uses' => 'Admin\AdminController@getTrainingProgramSummaryDate', 'as' => 'training_program_view']);

        Route::get('user_training_programs_report', ['uses' => 'Admin\AdminController@user_training_programs_report', 'as' => 'user_training_programs_report_view']);
        Route::get('user_training_programs_courses_certificates_report/{user_id}/{training_program_id}', ['uses' => 'Admin\AdminController@export_user_training_programs_courses_certificates_report', 'as' => 'user_training_programs_courses_certificates_report']);
        Route::post('training_program_searchForUser', ['uses' => 'Admin\AdminController@TrainingProgramsearchForUser', 'as' => 'user_training_programs_report_view']);
        Route::post('getUserTrainingProgramReport', ['uses' => 'Admin\AdminController@getUserTrainingProgramReport', 'as' => 'user_training_programs_report_view']);
        Route::post('generateTrainingProgramCertificate', ['uses' => 'Admin\AdminController@generateTrainingProgramCertificate', 'as' => 'user_training_programs_report_view']);
        ///Mba Summery
        Route::get('mba_user_summery',['uses'=>'Admin\MbaSummeryController@index','as'=>'mba_user_summery']);
        Route::post('mba_user_summery/search',['uses'=>'Admin\MbaSummeryController@searchForUser','as'=>'mba_user_summery']);
        Route::post('mba_user_summery/get-summery',['uses'=>'Admin\MbaSummeryController@getUserSummery','as'=>'mba_user_summery']);
        Route::post('mba_user_summery/get-answers',['uses'=>'Admin\MbaSummeryController@getUseranswers','as'=>'mba_user_summery']);
        Route::post('mba_user_summery/get-questions',['uses'=>'Admin\MbaSummeryController@getUserQuestions','as'=>'mba_user_summery']);
        Route::post('mba_user_summery/export-summery',['uses'=>'Admin\MbaSummeryController@exportSummery','as'=>'mba_user_summery']);
        Route::post('mba_user_summery/export-answers',['uses'=>'Admin\MbaSummeryController@exportanswers','as'=>'mba_user_summery']);
        Route::post('mba_user_summery/export-questions',['uses'=>'Admin\MbaSummeryController@exportquestions','as'=>'mba_user_summery']);
        // Route::post('mba_user_summery/get-summery',['uses'=>'Admin\MbaSummeryController@getUserSummery','as'=>'mba_user_summery']);
        ///new Mba Summery
        Route::get('new_mba_user_summery',['uses'=>'Admin\NewMbaSummeryController@index','as'=>'new_mba_user_summery']);
        Route::post('new_mba_user_summery/search',['uses'=>'Admin\NewMbaSummeryController@searchForUser','as'=>'new_mba_user_summery']);
        Route::post('new_mba_user_summery/get-summery',['uses'=>'Admin\NewMbaSummeryController@getUserSummery','as'=>'new_mba_user_summery']);
        Route::post('new_mba_user_summery/get-answers',['uses'=>'Admin\NewMbaSummeryController@getUseranswers','as'=>'new_mba_user_summery']);
        Route::post('new_mba_user_summery/get-questions',['uses'=>'Admin\NewMbaSummeryController@getUserQuestions','as'=>'new_mba_user_summery']);
        Route::post('new_mba_user_summery/export-summery',['uses'=>'Admin\NewMbaSummeryController@exportSummery','as'=>'new_mba_user_summery']);
        Route::post('new_mba_user_summery/export-answers',['uses'=>'Admin\NewMbaSummeryController@exportanswers','as'=>'new_mba_user_summery']);
        Route::post('new_mba_user_summery/export-questions',['uses'=>'Admin\NewMbaSummeryController@exportquestions','as'=>'new_mba_user_summery']);
        // Route::post('mba_user_summery/get-summery',['uses'=>'Admin\MbaSummeryController@getUserSummery','as'=>'mba_user_summery']);

        Route::get('companies', ['uses' => 'Admin\AdminController@companies', 'as' => 'companies']);
        Route::post('addNewCompany', ['uses' => 'Admin\AdminController@addNewCompany', 'as' => 'companies_company_add']);
        Route::post('addCompanyPeriod', ['uses' => 'Admin\AdminController@addCompanyPeriod', 'as' => 'companies_period_add']);
        Route::post('searchForAdminMembersCompany', ['uses' => 'Admin\AdminController@searchForAdminMembersCompany', 'as' => 'companies']);
        Route::post('searchForExistAdminMembersCompany', ['uses' => 'Admin\AdminController@searchForExistAdminMembersCompany', 'as' => 'companies']);
        Route::post('showChargeTransactionsAdminMember', ['uses' => 'Admin\AdminController@showChargeTransactionsAdminMember', 'as' => 'companies']);
        Route::post('addChargeToUser', ['uses' => 'Admin\AdminController@addChargeToUser', 'as' => 'companies']);
        Route::post('addAdminCompany', ['uses' => 'Admin\AdminController@addAdminCompany', 'as' => 'companies_admin_add']);
        Route::post('removeAdmin', ['uses' => 'Admin\AdminController@removeAdmin', 'as' => 'companies_admin_remove']);
        Route::post('addMemberCompany', ['uses' => 'Admin\AdminController@addMemberCompany', 'as' => 'companies_member_add']);
        Route::post('removeMember', ['uses' => 'Admin\AdminController@removeMember', 'as' => 'companies_member_remove']);
        Route::post('makeCompanySuspend', ['uses' => 'Admin\AdminController@makeCompanySuspend','as' => 'companies_suspend']);


        Route::post('getCustomerData', ['uses' => 'Admin\AdminController@getCustomerData', 'as' => 'dashboard']);
        Route::get('dashboard_yotta', ['uses' => 'Admin\AdminController@dashboard_yotta', 'as' => 'dashboard_yotta']);
        Route::post('getYottaCustomerData', ['uses' => 'Admin\AdminController@getYottaCustomerData', 'as' => 'dashboard_yotta']);
        Route::post('getyottaDiplomaSuspendCustomerData', ['uses' => 'Admin\AdminController@getyottaDiplomaSuspendCustomerData','as' => 'dashboard_yotta']);
        Route::post('yottadiplomaMakeSuspend', ['uses' => 'Admin\AdminController@yottadiplomaMakeSuspend','as' => 'dashboard_yotta']);
        Route::post('checkCorporateCode', ['uses' => 'Admin\AdminController@checkCorporateCode', 'as' => 'dashboard_corporate_code']);
        Route::post('getUserCertificates', ['uses' => 'Admin\AdminController@getUserCertificates', 'as' => 'dashboard_certificates']);
        Route::post('saveCertificateName', ['uses' => 'Admin\AdminController@saveCertificateName', 'as' => 'dashboard_certificates']);
        Route::post('getYottaUserCertificates', ['uses' => 'Admin\AdminController@getYottaUserCertificates', 'as' => 'dashboard_yotta']);
        Route::post('saveYottaCertificateName', ['uses' => 'Admin\AdminController@saveYottaCertificateName', 'as' => 'dashboard_yotta']);
        Route::post('getMbaSummaryAjax', ['uses' => 'Admin\AdminController@getMbaSummaryAjax','as' => 'dashboard_mba_reports']);
        Route::post('getDbaSummaryAjax', ['uses' => 'Admin\AdminController@getDbaSummaryAjax','as' => 'dashboard_dba_reports']);
        Route::post('getNewMbaSummaryAjax', ['uses' => 'Admin\AdminController@getNewMbaSummaryAjax','as' => 'dashboard_new_mba_reports']);
        Route::post('getNewMbaProjectSummaryAjax', ['uses' => 'Admin\AdminController@getNewMbaProjectSummaryAjax','as' => 'dashboard_new_mba_reports']);
        Route::post('getNewMbaCategorySummaryAjax', ['uses' => 'Admin\AdminController@getNewMbaCategorySummaryAjax','as' => 'dashboard_new_mba_reports']);
        Route::post('getMbaPercentageAjax', ['uses' => 'Admin\AdminController@getMbaPercentageAjax','as' => 'dashboard_mba_reports']);
        Route::post('getDbaPercentageAjax', ['uses' => 'Admin\AdminController@getDbaPercentageAjax','as' => 'dashboard_dba_reports']);
        Route::post('getNewMbaPercentageAjax', ['uses' => 'Admin\AdminController@getNewMbaPercentageAjax','as' => 'dashboard_new_mba_reports']);
        Route::post('getMbaPercentagesAjax', ['uses' => 'Admin\AdminController@getMbaPercentagesAjax','as' => 'dashboard_new_mba_reports']);
        Route::post('getMbaExamsAjax', ['uses' => 'Admin\AdminController@getMbaExamsAjax','as' => 'dashboard_mba_reports']);
        Route::post('getNewMbaExams1Ajax', ['uses' => 'Admin\AdminController@getNewMbaExams1Ajax','as' => 'dashboard_new_mba_reports']);
        Route::post('getNewMbaExams2Ajax', ['uses' => 'Admin\AdminController@getNewMbaExams2Ajax','as' => 'dashboard_new_mba_reports']);
        Route::post('getMbaTrainingsAjax', ['uses' => 'Admin\AdminController@getMbaTrainingsAjax','as' => 'dashboard_mba_reports']);
        Route::post('getNewMbaTrainingsAjax', ['uses' => 'Admin\AdminController@getNewMbaTrainingsAjax','as' => 'dashboard_new_mba_reports']);
        Route::post('getLiteReportAjax', ['uses' => 'Admin\AdminController@getLiteReportAjax','as' => 'dashboard_lite_report']);
        Route::post('getCoursesReportAjax', ['uses' => 'Admin\AdminController@getCoursesReportAjax','as' => 'dashboard_courses_report']);
        Route::post('getYottaCoursesReportAjax', ['uses' => 'Admin\AdminController@getYottaCoursesReportAjax','as' => 'dashboard_yotta']);
        Route::post('getDemoLogAjax', ['uses' => 'Admin\AdminController@getDemoLogAjax','as' => 'dashboard_demo_log']);
        Route::post('getCompaniesChargesAjax', ['uses' => 'Admin\AdminController@getCompaniesChargesAjax','as' => 'dashboard_companies_charges']);
        Route::post('getCoursesExamsAjax', ['uses' => 'Admin\AdminController@getCoursesExamsAjax','as' => 'dashboard_courses_report']);
        Route::post('getYottaCoursesExamsAjax', ['uses' => 'Admin\AdminController@getYottaCoursesExamsAjax','as' => 'dashboard_yotta']);
        Route::post('getCoursesTrainingsAjax', ['uses' => 'Admin\AdminController@getCoursesTrainingsAjax','as' => 'dashboard_courses_report']);
        Route::post('getDiplomasChargesAjax', ['uses' => 'Admin\AdminController@getDiplomasChargesAjax','as' => 'dashboard_diplomas_charges_view']);
        Route::post('getPackagesChargesAjax', ['uses' => 'Admin\AdminController@getPackagesChargesAjax','as' => 'dashboard_packages_charges_view']);
        Route::post('getCustomChargesAjax', ['uses' => 'Admin\AdminController@getCustomChargesAjax','as' => 'dashboard_custom_charges_view']);
        Route::post('getCompaniesDiplomasChargesAjax', ['uses' => 'Admin\AdminController@getCompaniesDiplomasChargesAjax','as' => 'dashboard_diplomas_companies_charges_view']);
        Route::post('getTrainingProgramsChargesAjax', ['uses' => 'Admin\AdminController@getTrainingProgramsChargesAjax','as' => 'dashboard_training_program_charges_view']);
        Route::post('getSuspendTrainingProgramLogAjax', ['uses' => 'Admin\AdminController@getSuspendTrainingProgramLogAjax','as' => 'dashboard_training_program_suspend']);

        Route::post('getUsersSuspendAjax', ['uses' => 'Admin\AdminController@getUsersSuspendAjax','as' => 'dashboard_view_users_suspend_log']);
        Route::post('getSuspendLogAjax', ['uses' => 'Admin\AdminController@getSuspendLogAjax','as' => 'dashboard_view_suspend_log']);
        Route::post('getPackageSuspendLogAjax', ['uses' => 'Admin\AdminController@getPackageSuspendLogAjax','as' => 'dashboard_package_view_suspend_log']);
        Route::post('getCustomSuspendLogAjax', ['uses' => 'Admin\AdminController@getCustomSuspendLogAjax','as' => 'dashboard_custom_view_suspend_log']);
        Route::post('getMbaChargesAjax', ['uses' => 'Admin\AdminController@getMbaChargesAjax','as' => 'dashboard_mba_charges_view']);

        Route::post('getPreparatoryMbaChargesAjax', ['uses' => 'Admin\AdminController@getPreparatoryMbaChargesAjax','as' => 'dashboard_preparatory_mba_charges_view']);

        Route::post('mbaopenexam', ['uses' => 'Admin\AdminController@openmbaexamAjax','as' => 'dashboard_mba_open_exam']);
        Route::post('newmbaopenexam', ['uses' => 'Admin\AdminController@opennewmbaexamAjax','as' => 'dashboard_mba_open_exam']);
        Route::post('getNewMbaChargesAjax', ['uses' => 'Admin\AdminController@getNewMbaChargesAjax','as' => 'dashboard_new_mba_charges_view']);
        Route::post('getNewMbaCategoriesChargesAjax', ['uses' => 'Admin\AdminController@getNewMbaCategoriesChargesAjax','as' => 'dashboard_new_mba_categories_charges_view']);
        Route::post('getChargesAjax', ['uses' => 'Admin\AdminController@getChargesAjax','as' => 'dashboard_charges_view']);


        Route::post('getDBAPreliminaryChargesAjax', ['uses' => 'Admin\AdminController@getDBAPreliminaryChargesAjax','as' => 'dashboard_dba_preliminary_charges_view']);
        Route::post('getDBAChargesAjax', ['uses' => 'Admin\AdminController@getDBAChargesAjax','as' => 'dashboard_dba_charges_view']);
        Route::post('getDBAChecklistsAjax', ['uses' => 'Admin\AdminController@getDBAChecklistsAjax','as' => 'dashboard_dba_checklists']);
        Route::post('getLiveDiplomasSelectorAjax', ['uses' => 'Admin\AdminController@getLiveDiplomasSelectorAjax','as' => 'dashboard_live_diplomas_certificate']);
        Route::post('generateLiveDiplomasCertificate', ['uses' => 'Admin\AdminController@generateLiveDiplomasCertificate','as' => 'dashboard_live_diplomas_certificate']);
        Route::post('editDBAChecklists', ['uses' => 'Admin\AdminController@editDBAChecklists','as' => 'dashboard_dba_checklists']);






        Route::post('getCvHrInterviewChargesAjax', ['uses' => 'Admin\AdminController@getCvHrInterviewChargesAjax','as' => 'dashboard_consultant_charge_transaction_button']);
        Route::post('getTechnicalInterviewChargesAjax', ['uses' => 'Admin\AdminController@getTechnicalInterviewChargesAjax','as' => 'dashboard_consultant_charge_transaction_button']);
        Route::post('getCareerCoachingChargesAjax', ['uses' => 'Admin\AdminController@getCareerCoachingChargesAjax','as' => 'dashboard_consultant_charge_transaction_button']);
        Route::post('getUsersCvHrInterviewSuspendAjax', ['uses' => 'Admin\AdminController@getUsersCvHrInterviewSuspendAjax','as' => 'dashboard_consultant_charge_transaction_button']);
        Route::post('getUsersTechnicalInterviewSuspendAjax', ['uses' => 'Admin\AdminController@getUsersTechnicalInterviewSuspendAjax','as' => 'dashboard_consultant_charge_transaction_button']);
        Route::post('getUsersCareerCoachingSuspendAjax', ['uses' => 'Admin\AdminController@getUsersCareerCoachingSuspendAjax','as' => 'dashboard_consultant_charge_transaction_button']);


        Route::post('suspendConsultantChargeTransaction', ['uses' => 'Admin\AdminController@suspendConsultantChargeTransaction', 'as' => 'dashboard_consultant_charge_transaction_button']);

        Route::delete('delete_consultant_cv_hr_interview_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteConsultantChargeTransaction', 'as' => 'dashboard_consultant_charge_transaction_button']);



        Route::post('getInternationalDiplomasChargesAjax', ['uses' => 'Admin\AdminController@getInternationalDiplomasChargesAjax','as' => 'dashboard_international_diplomas_charges_view']);
        Route::post('openDiplomaCourses', ['uses' => 'Admin\AdminController@openDiplomaCourses','as' => 'dashboard_open_diploma_courses']);
        Route::post('openyottaDiplomaCourses', ['uses' => 'Admin\AdminController@openyottaDiplomaCourses','as' => 'dashboard_yotta']);
        Route::post('openTrainingProgramCourses', ['uses' => 'Admin\AdminController@openTrainingProgramCourses','as' => 'dashboard_open_training_program_courses']);

        Route::post('openInternationalDiplomaCourses', ['uses' => 'Admin\AdminController@openInternationalDiplomaCourses','as' => 'dashboard_open_international_diploma_courses']);
        Route::post('getMedicalChargeTransactionsAjax', ['uses' => 'Admin\AdminController@getMedicalChargeTransactionsAjax','as' => 'dashboard_medical_charge_view']);
        Route::post('getMedicalDiplomaChargeTransactionsAjax', ['uses' => 'Admin\AdminController@getMedicalDiplomaChargeTransactionsAjax','as' => 'dashboard_yotta']);
        Route::post('getGiftCourseChargeTransactionsAjax', ['uses' => 'Admin\AdminController@getGiftCourseChargeTransactionsAjax','as' => 'dashboard_gift_course_charge_view']);
        Route::post('getFreeCourseChargeTransactionsAjax', ['uses' => 'Admin\AdminController@getFreeCourseChargeTransactionsAjax','as' => 'dashboard_free_course_charge_view']);
        Route::post('getGiftBookChargeTransactionsAjax', ['uses' => 'Admin\AdminController@getGiftBookChargeTransactionsAjax','as' => 'dashboard_gift_book_charge_view']);
        Route::post('suspendMedicalChargeTransaction', ['uses' => 'Admin\AdminController@suspendMedicalChargeTransactionAjax','as' => 'dashboard_medical_charge_view']);
        Route::post('suspendGiftCourseChargeTransaction', ['uses' => 'Admin\AdminController@suspendGiftCourseChargeTransactionAjax','as' => 'dashboard_gift_course_charge_view']);
        Route::post('suspendGiftBookChargeTransaction', ['uses' => 'Admin\AdminController@suspendGiftBookChargeTransactionAjax','as' => 'dashboard_gift_book_charge_view']);

        Route::post('getRenewalDiplomasAjax', ['uses' => 'Admin\AdminController@getRenewalDiplomasAjax','as' => 'dashboard_renewal_diploma_charge']);
        Route::post('getRenewalInternationalDiplomasAjax', ['uses' => 'Admin\AdminController@getRenewalInternationalDiplomasAjax','as' => 'dashboard_renewal_international_diploma_charge']);




        Route::post('getBlockedUserSessionsAjax', ['uses' => 'Admin\AdminController@getBlockedUserSessionsAjax','as' => 'blocked_user_sessions']);
        Route::post('getYottaBlockedUserSessionsAjax', ['uses' => 'Admin\AdminController@getYottaBlockedUserSessionsAjax','as' => 'blocked_user_sessions']);
        Route::post('getYotaBlockedUserHistoryAjax', ['uses' => 'Admin\AdminController@getYotaBlockedUserHistoryAjax','as' => 'blocked_user_history']);
        Route::post('getBlockedUserHistoryAjax', ['uses' => 'Admin\AdminController@getBlockedUserHistoryAjax','as' => 'blocked_user_history']);
        Route::post('unblockUser', ['uses' => 'Admin\AdminController@unblockUser','as' => 'blocked_unblock']);
        Route::post('blockMakeException', ['uses' => 'Admin\AdminController@blockMakeException','as' => 'blocked_make_exception']);

        Route::post('getCoursesExamsTrainingsAjax', ['uses' => 'Admin\AdminController@getCoursesExamsTrainingsAjax','as' => 'dashboard_mba_reports']);
        Route::post('getDbaCoursesExamsTrainingsAjax', ['uses' => 'Admin\AdminController@getDbaCoursesExamsTrainingsAjax','as' => 'dashboard_dba_reports']);
        Route::post('getDbaGenerateCertificateFormAjax', ['uses' => 'Admin\AdminController@getDbaGenerateCertificateFormAjax','as' => 'dashboard_dba_generate_certificate']);
        Route::post('generateDBACertificate', ['uses' => 'Admin\AdminController@generateDBACertificate','as' => 'dashboard_dba_generate_certificate']);

        Route::post('getNewCoursesExamsTrainingsAjax', ['uses' => 'Admin\AdminController@getNewCoursesExamsTrainingsAjax','as' => 'dashboard_new_mba_reports']);

        Route::post('getDiplomaSuspendCustomerData', ['uses' => 'Admin\AdminController@getDiplomaSuspendCustomerData','as' => 'dashboard_diploma_suspend']);
        Route::post('diplomaMakeSuspend', ['uses' => 'Admin\AdminController@diplomaMakeSuspend','as' => 'dashboard_diploma_suspend']);
         Route::post('getPackageSuspendCustomerData', ['uses' => 'Admin\AdminController@getPackageSuspendCustomerData','as' => 'dashboard_package_suspend']);
         Route::post('getCustomSuspendCustomerData', ['uses' => 'Admin\AdminController@getCustomSuspendCustomerData','as' => 'dashboard_custom_suspend']);
        Route::post('packageMakeSuspend', ['uses' => 'Admin\AdminController@packageMakeSuspend','as' => 'dashboard_package_suspend']);
        Route::post('customMakeSuspend', ['uses' => 'Admin\AdminController@customMakeSuspend','as' => 'dashboard_custom_suspend']);
        Route::post('getTrainingprogramSuspendCustomerData', ['uses' => 'Admin\AdminController@getTrainingprogramSuspendCustomerData','as' => 'dashboard_diploma_suspend']);
        Route::post('trainingprogramMakeSuspend', ['uses' => 'Admin\AdminController@trainingprogramMakeSuspend','as' => 'dashboard_diploma_suspend']);
        Route::post('getInternationalDiplomaSuspendCustomerData', ['uses' => 'Admin\AdminController@getInternationalDiplomaSuspendCustomerData','as' => 'dashboard_international_diploma_suspend']);
        Route::post('internationalDiplomaMakeSuspend', ['uses' => 'Admin\AdminController@internationalDiplomaMakeSuspend','as' => 'dashboard_international_diploma_suspend']);
        Route::post('getListUserCoursesAjax', ['uses' => 'Admin\AdminController@getListUserCoursesAjax','as' => 'dashboard_list_courses']);
//        Route::post('addUserCourse', ['uses' => 'Admin\AdminController@addUserCourse','as' => 'dashboard_add_courses']);
        Route::post('getDiplomaGenerateCerCustomerData', ['uses' => 'Admin\AdminController@getDiplomaGenerateCerCustomerData','as' => 'dashboard_diploma_generate_cer']);
        Route::post('diplomaMakeCertificate', ['uses' => 'Admin\AdminController@diplomaMakeCertificate','as' => 'dashboard_diploma_generate_cer']);
        Route::post('checkPromotionCode', ['uses' => 'Admin\AdminController@checkPromotionCode','as' => 'dashboard_charge']);
        Route::post('createonlinelink', ['uses' => 'Admin\AdminController@createonlinelink','as' => 'dashboard_online_link']);
        Route::post('creatembalink', ['uses' => 'Admin\AdminController@creatembalink','as' => 'dashboard_mba_link']);
        Route::post('GeneratePaymentLink', ['uses' => 'Admin\AdminController@GeneratePaymentLink','as' => 'dashboard_ksa_link']);
        Route::post('makeUserSuspend', ['uses' => 'Admin\AdminController@makeUserSuspend','as' => 'dashboard_suspend']);
        Route::post('suspendLiteVersion', ['uses' => 'Admin\AdminController@suspendLiteVersion','as' => 'dashboard_suspend_lite_version']);
        Route::post('suspendChargeTransaction', ['uses' => 'Admin\AdminController@suspendChargeTransaction','as' => 'dashboard_suspend_charge_button']);
        Route::post('visitSite', ['uses' => 'Admin\AdminController@visitSite','as' => 'dashboard_visit']);
        Route::post('resetPassword', ['uses' => 'Admin\AdminController@resetPassword','as' => 'dashboard_reset_password']);
        Route::post('yottaresetPassword', ['uses' => 'Admin\AdminController@yottaresetPassword','as' => 'dashboard_yotta']);
        Route::post('lifeTime', ['uses' => 'Admin\AdminController@lifeTimeAjax','as' => 'dashboard_life_time']);
        Route::post('saveNewPhone', ['uses' => 'Admin\AdminController@saveNewPhone','as' => 'dashboard_mobile']);
        Route::post('saveNewEmail', ['uses' => 'Admin\AdminController@saveNewEmail','as' => 'dashboard_email']);
        Route::post('addPhotoshopCourse', ['uses' => 'Admin\AdminController@addPhotoshopCourse','as' => 'dashboard_photoshop']);
        Route::post('addPMPCourse', ['uses' => 'Admin\AdminController@addPMPCourse','as' => 'dashboard_pmp']);
        Route::post('addExamException', ['uses' => 'Admin\AdminController@addExamException','as' => 'dashboard_open_exams_exceptions']);
        Route::post('openExamForCourse', ['uses' => 'Admin\AdminController@openExamForCourse','as' => 'dashboard_open_exam']);
        Route::post('removeSessionUser', ['uses' => 'Admin\AdminController@removeSessionUser','as' => 'blocked_user_sessions']);
        Route::post('sendCustomerCredentials', ['uses' => 'Admin\AdminController@sendCustomerCredentials','as' => 'dashboard_credentials']);
        Route::get('getAgents', ['uses' => 'Admin\AdminController@getAgents', 'as' => 'dashboard_lite_charge']);

        Route::post('addCertificateRequest', ['uses' => 'Admin\AdminController@addCertificateRequest','as' => 'certificates_requests_add']);
        Route::post('moccylance', ['uses' => 'Admin\AdminController@moccylance','as' => 'dashboard_moccylance']);
        Route::get('certificates_requests', ['uses' => 'Admin\AdminController@certificates_requests', 'as' => 'certificates_requests_view']);
        Route::post('certificates_requests_search', ['uses' => 'Admin\AdminController@certificates_requests_search', 'as' => 'certificates_requests_view']);
        Route::get('certificates_requests_export', ['uses' => 'Admin\AdminController@certificates_requests_export', 'as' => 'certificates_requests_export']);

        Route::post('certificates_requests/change_status', ['uses' => 'Admin\AdminController@certificatesRequestsChangeStatus', 'as' => 'certificates_requests_edit']);
        Route::get('certificates_requests/{id}/view', ['uses' => 'Admin\AdminController@certificatesRequestsView', 'as' => 'certificates_requests_view_edit']);
        Route::get('certificates_requests/{id}/edit', ['uses' => 'Admin\AdminController@certificatesRequestsEdit', 'as' => 'certificates_requests_edit']);
        Route::post('certificates_requests/{id}/edit', ['uses' => 'Admin\AdminController@doCertificatesRequestsEdit', 'as' => 'certificates_requests_edit']);
        Route::post('certificates_requests/{id}/addComment', ['uses' => 'Admin\AdminController@addCertificatesRequestComment', 'as' => 'certificates_requests_edit']);

        Route::any('certificates_requests/change_status','Admin\AdminController@certificates_requests_change_status')->name('certificates_requests_change_status');


        Route::post('getCertificatesByProduct', ['uses' => 'Admin\AdminController@getCertificatesByProduct', 'as' => 'certificates_requests_add']);
        Route::post('getCertificateDate', ['uses' => 'Admin\AdminController@getCertificateDate', 'as' => 'certificates_requests_add']);
        Route::post('getDiplomaDates', ['uses' => 'Admin\AdminController@getDiplomaDates', 'as' => 'certificates_requests_add']);


        Route::post('activeCharge', ['uses' => 'Admin\AdminController@activeCharge', 'as' => 'dashboard_active_charge_button']);

        Route::delete('delete_yotta_medical_diplomas_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteYotaMedicalDiplomaChargeTransaction', 'as' => 'dashboard_diplomas_charges_delete']);
        Route::delete('delete_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteChargeTransaction', 'as' => 'dashboard_charges_delete']);



        Route::delete('delete_gift_course_charge_transactions/{charge_id}',['uses' => 'Admin\AdminController@deleteGiftCourseChargeTransaction', 'as' => 'dashboard_charges_delete']);
        Route::delete('delete_books_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteGiftBookChargeTransaction', 'as' => 'dashboard_charges_delete']);




        Route::delete('delete_diplomas_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteDiplomasChargeTransaction', 'as' => 'dashboard_diplomas_charges_delete']);
        Route::delete('delete_training_program_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteTrainingProgramChargeTransaction', 'as' => 'dashboard_diplomas_charges_delete']);
        Route::delete('delete_mba_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteMbaChargeTransaction', 'as' => 'dashboard_mba_charges_delete']);
        Route::delete('delete_preparatory_mba_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deletePreparatoryMbaChargeTransaction', 'as' => 'dashboard_preparatory_mba_charges_delete']);
        Route::delete('delete_new_mba_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteNewMbaChargeTransaction', 'as' => 'dashboard_new_mba_charges_delete']);
        Route::post('editchargecategory',['uses' => 'Admin\AdminController@editchargecategory', 'as' => 'dashboard_new_mba_charges_delete']);
        Route::post('editGender',['uses' => 'Admin\AdminController@editGender', 'as' => 'dashboard_gender_change']);
        Route::delete('delete_new_mba_categories_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteNewMbaCategoriesChargeTransaction', 'as' => 'dashboard_new_mba_categories_charges_delete']);
        Route::delete('delete_international_diplomas_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteInternationalDiplomasChargeTransaction', 'as' => 'dashboard_international_diplomas_charges_delete']);
        Route::post('change_user_diploma_charge_transaction',['uses' => 'Admin\AdminController@changeUserDiplomaChargeTransaction', 'as' => 'dashboard_diplomas_charges_edit']);
        Route::post('change_user_medical_diploma_charge_transaction',['uses' => 'Admin\AdminController@changeUserMedicalDiplomaChargeTransaction', 'as' => 'dashboard_diplomas_charges_edit']);
        Route::post('change_count_custom_charge_transaction',['uses' => 'Admin\AdminController@changeCountCustomChargeTransaction', 'as' => 'dashboard_custom_charges_edit']);
        Route::delete('delete_packages_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deletePackagesChargeTransaction', 'as' => 'dashboard_packages_charges_delete']);
        Route::delete('delete_custom_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteCustomChargeTransaction', 'as' => 'dashboard_custom_charges_delete']);


        Route::get('check_users_diplomas','Admin\CheckUsersController@index')->name('check_users_diplomas');
        Route::post('check_users_diplomas/store','Admin\ChegetSuspendLogAjaxckUsersController@store')->name('check_users_diplomas');


        Route::post('addDemoToUser','Admin\AdminController@addDemoToUser')->name('dashboard_add_demo');

        Route::get('diplomas_users_reports','Admin\AdminController@diploma_charge_report')->name('diplomas_users_reports');
        Route::post('diplomas_users_reports_search','Admin\AdminController@diploma_report_charge_search')->name('diplomas_users_reports');
        Route::get('diplomas_users_reports_export','Admin\AdminController@diploma_report_charge_export')->name('diplomas_users_reports_export');


        Route::get('export_ibn_rushd_data','Admin\AdminController@exportIbnRushdData')->name('export_ibn_rushd_data');
        Route::post('export_ibn_rushd_data','Admin\AdminController@exportIbnRushdDataPost')->name('export_ibn_rushd_data');


        Route::get('pluck_marketing_gift','Admin\AdminController@pluckMarketingGift')->name('pluck_marketing_gift');
        Route::post('pluck_marketing_gift','Admin\AdminController@pluckMarketingGiftPost')->name('pluck_marketing_gift');


        Route::delete('delete_dba_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteDBAChargeTransaction', 'as' => 'dashboard_dba_charges_delete']);
        Route::delete('delete_dba_preliminary_charge_transaction/{charge_id}',['uses' => 'Admin\AdminController@deleteDBAPreliminaryChargeTransaction', 'as' => 'dashboard_dba_preliminary_charges_delete']);






        Route::post('crm_report/mba_reports','Admin\MbaReportController@mbaReports')->name('crm_reports_mba');
        Route::get('crm_report/mba_reports','Admin\MbaReportController@mbaReports')->name('crm_reports_mba');
        Route::post('crm_report/new_mba_reports','Admin\MbaReportController@newMbaReports')->name('crm_reports_new_mba');
        Route::get('crm_report/new_mba_reports','Admin\MbaReportController@newMbaReports')->name('crm_reports_new_mba');


        Route::post('crm_report/diplomas_reports','Admin\MbaReportController@diplomasReports')->name('crm_reports_diplomas');
        Route::get('crm_report/diplomas_reports','Admin\MbaReportController@diplomasReports')->name('crm_reports_diplomas');




    });

});

