<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::group(['middleware' => 'PowerBI','prefix' => 'POWER_BI'],function(){
    Route::get('course_user_report_api/{token}', ['uses' => 'Api\BowerBIController@course_user_report_api']);
    Route::get('courses_report_api/{token}', ['uses' => 'Api\BowerBIController@courses_report_api']);
    Route::get('diplomas_report_api/{token}', ['uses' => 'Api\BowerBIController@diplomas_report_api']);
    Route::get('diploma_user_report_api/{token}', ['uses' => 'Api\BowerBIController@diploma_user_report_api']);
    Route::get('mba_user_report_api/{token}', ['uses' => 'Api\BowerBIController@mba_user_report_api']);
    Route::get('mba_report_api/{token}', ['uses' => 'Api\BowerBIController@mba_report_api']);
//    Route::get('new_mba_report_api/{token}', ['uses' => 'Admin\AdminController@new_mba_report_api']);
    Route::get('new_mba_user_report_api/{token}', ['uses' => 'Api\BowerBIController@new_mba_user_report_api']);
    Route::get('new_mba_users_summary/{token}', ['uses' => 'Api\BowerBIController@new_mba_users_summary']);
    Route::get('customers/{token}', ['uses' => 'Api\BowerBIController@customers']);
    Route::get('courses_ratings/{token}', ['uses' => 'Api\BowerBIController@coursesRatings']);
    Route::get('user_survey/{token}', ['uses' => 'Api\BowerBIController@userSurvey']);
});



Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
