@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection

@section('content')
<style>
    #datatable_ajax_filter {
        display: none;
    }
</style>
<div class="page-content">
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <!--    <h1 class="page-title">-->
    <!--        <i class="icon-settings font-dark"></i>-->
    <!--        <span class="caption-subject font-dark sbold uppercase">Report</span>-->
    <!--    </h1>-->
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @if(PerUser('mba_users_summary'))
    <div class="row">
        <div class="col-md-12">
            <div class="portlet light portlet-fit portlet-datatable">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-green"></i>
                        <span class="caption-subject font-green sbold uppercase">Mba Summary</span>
                    </div>
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn red btn-outline btn-circle" href="javascript:;" data-toggle="dropdown" aria-expanded="false">
                                <i class="fa fa-share"></i>
                                <span class="hidden-xs"> Trigger Tools </span>
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right" id="sample_3_tools">
                                <li>
                                    <a href="javascript:;" data-action="0" class="tool-action">
                                        <i class="icon-printer"></i> Print</a>
                                </li>
                                <li>
                                    <a href="javascript:;" data-action="1" class="tool-action">
                                        <i class="icon-check"></i> Copy</a>
                                </li>
                                <li>
                                    <a href="javascript:;"  data-action="2" class="tool-action">
                                        <i class="icon-doc"></i> PDF</a>
                                </li>
                                <li>
                                    <a href="javascript:;" data-action="3" class="tool-action">
                                        <i class="icon-paper-clip"></i> Excel</a>
                                </li>
                                <li>
                                    <a href="javascript:;" data-action="4" class="tool-action">
                                        <i class="icon-cloud-upload"></i> CSV</a>
                                </li>
                                <li class="divider"> </li>
                                <li>
                                    <a href="javascript:;" data-action="5" class="tool-action">
                                        <i class="icon-refresh"></i> Reload</a>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-container">
                        <div id="datatable_ajax_wrapper"
                             class="dataTables_wrapper dataTables_extended_wrapper no-footer">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover table-checkable"
                                       id="datatable_ajax">
                                    <thead>
                                    <tr role="row" class="heading">
                                        <th width="10%"> # </th>
                                        <th width="10%">name</th>
                                        <th width="10%">Email</th>
                                        <th width="10%">Created Time</th>
                                        <th width="10%">Completed</th>
                                        <th width="10%">MBA</th>
                                        <th width="10%">Project</th>
                                        <th width="10%">Progress</th>
                                        <th width="10%">Exam</th>
                                        <th width="10%">Total</th>
                                        <th width="10%">Project Correction Date</th>
                                        <th width="10%"></th>
                                    </tr>
                                    <tr role="row" class="filter">
                                        <td>
                                            <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="name">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="email">
                                        </td>
                                        <td>
                                            <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="created_time_from" placeholder="From">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                            <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="created_time_to" placeholder="To">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                        </td>
                                        <td></td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="mba">
                                        </td>
                                        <td>
                                            <input type="number" min="0" max="100" placeholder="from" class="form-control form-filter input-sm" name="project_from">
                                            <input type="number" min="0" max="100" placeholder="to" class="form-control form-filter input-sm" name="project_to">
                                        </td>
                                        <td>
                                            <input type="number" min="0" max="100" placeholder="from" class="form-control form-filter input-sm" name="progress_from">
                                            <input type="number" min="0" max="100" placeholder="to" class="form-control form-filter input-sm" name="progress_to">
                                        </td>
                                        <td>
                                            <input type="number" min="0" max="100" class="form-control form-filter input-sm" name="exam_from">
                                            <input type="number" min="0" max="100" class="form-control form-filter input-sm" name="exam_to">
                                        </td>
                                        <td></td>

                                        <td>
                                            <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="correction_date_from" placeholder="From">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                            <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="correction_date_to" placeholder="To">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                        </td>

                                        <td>
                                            <div class="margin-bottom-5">
                                                <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                    <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                            </div>
                                            <button class="btn btn-sm red btn-outline filter-cancel">
                                                <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                                        </td>

                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>

    </div>
    @endif
</div>

@if(PerUser('mba_users_summary'))
<script>
    $(document).ready(function () {
        $('.fromToDate').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
        var grid = new Datatable();
        grid.setAjaxParam("_token", "{{ csrf_token() }}");
        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: 'Loading...',
            dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options

                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                // So when dropdowns used the scrollable div should be removed.
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                "lengthMenu": [
                    [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                    [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": "{{ URL('admin/mba_users_summary_search') }}", // ajax source
                },
                "order": [
                    [0, "desc"]
                ],// set first column as a default sort by asc
                dom: 'Blfrtip',
                buttons: [
                    {extend: 'print', className: 'btn dark btn-outline'},
                    {extend: 'pdf', className: 'btn green btn-outline'},
                    {extend: 'csv', className: 'btn purple btn-outline '}
                ],
            }
        });
    });

</script>
@endif
@endsection
