<div class="portlet-body">
    <div class="table-container">
        <div id="datatable_ajax_wrapper"
             class="dataTables_wrapper dataTables_extended_wrapper no-footer">
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover table-checkable"
                       id="datatable_ajax">
                    <thead>
                    <tr role="row" class="heading">
                        <th>ID</th>
                        <th>{{ Lang::get('main.mba') }}</th>
                        <th>{{ Lang::get('main.exam_result') }}</th>
                        <th>{{ Lang::get('main.progress%') }}</th>
                        <th>{{ Lang::get('main.procentage') }}</th>
                        
                        <th></th>
                    </tr>
                    <tr role="row" class="filter">
                        <td>
                            <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                            <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                            <input type="hidden" id="email" name="email" value=""/>
                        </td>
                            <td>
                                <select name="module_id" class="module_name sel2 form-control form-filter">
                                    <option value=" ">{{ Lang::get('main.mba') }} {{ Lang::get('main.mba') }}</option>
                                    @foreach($modules as $id=>$value)
                                        <option value="{{$value}}">{{$id}}</option>
                                    @endforeach
                                </select>
                            </td>
                      
                        <td>
                    
                        </td>
                        <td>
                    
                        </td>
                        <td>
                    
                        </td>
                        <td>
                            <div class="margin-bottom-5">
                                <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                    <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                            </div>
                            <button class="btn btn-sm red btn-outline filter-cancel">
                                <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                        </td>
                 
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('.fromToDate').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
        var token = "{{ csrf_token() }}";
        var grid = new Datatable();
        grid.setAjaxParam("_token", "{{ csrf_token() }}");
        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: 'Loading...',
            dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options

                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                // So when dropdowns used the scrollable div should be removed.
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                "lengthMenu": [
                    [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                    [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": "{{ URL('admin/mba_user_summery/get-summery') }}", // ajax source
                },
                "order": [
                    [0, "desc"]
                ],// set first column as a default sort by asc
                dom: 'Blfrtip',
                buttons: [
                    {extend: 'print', className: 'btn dark btn-outline'},
                    {extend: 'pdf', className: 'btn green btn-outline'},
                    {extend: 'csv', className: 'btn purple btn-outline '}
                ],
            }
        });
    });

</script>