<!DOCTYPE html>
<!--[if IE 8]>
<html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]>
<html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
<!--<![endif]-->
@include('auth.include.login_head')


<body class="login">
<!-- BEGIN LOGO -->
<!-- END LOGO -->
<!-- BEGIN LOGIN -->
<style>
    .login-loading{
        display: none;
    }
</style>
<div class="content">
    <!-- BEGIN LOGIN FORM -->

    <form class="login-form" action="{{ route('login') }}" id="login-form" method="post">
        {{ csrf_field() }}
        <div class="logo">
            <a href="{{ URL('/') }}">
                <img src="{{asset('img/logo.png')}}" alt=""/> </a>
            <h3 class="sign">Sign In</h3>
            <img class="login-loading" src="{{asset('img/loading.svg')}}" alt="">
            <h5 class="continue">To Continue To support tool</h5>
        </div>
        <div class="form-body">
            <div class="form-error">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <input type="text" class="form-control" name="username" id="form_control_1">
                    <label for="form_control_1"><span
                                style="background: #fff; position: absolute;left: 15px; top: -10px; padding: 0 3px;">Username</span></label>
                </div>
            </div>

            <div class="form-error">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <input type="password" class="form-control" name="password" id="form_control_1">
                    <label for="form_control_1"><span
                                style="background: #fff; position: absolute;left: 15px; top: -10px; padding: 0 3px;">Password</span></label>
                </div>
            </div>

            <button type="submit" class="btn blue pull-right login-button">Login</button>
        </div>
        <div id="errors" style="padding-top: 10px; text-transform: capitalize; color: red; font-weight: bold"></div>
    </form>

    <!-- END LOGIN FORM -->
    <!-- BEGIN FORGOT PASSWORD FORM -->
    <!--    <form class="forget-form" action="index.html" method="post">-->
    <!--        <h3>Forget Password ?</h3>-->
    <!--        <p> Enter your e-mail address below to reset your password. </p>-->
    <!--        <div class="form-group">-->
    <!--            <div class="input-icon">-->
    <!--                <i class="fa fa-envelope"></i>-->
    <!--                <input class="form-control placeholder-no-fix" type="text" autocomplete="off" placeholder="Email"-->
    <!--                       name="email"/></div>-->
    <!--        </div>-->
    <!--        <div class="form-actions">-->
    <!--            <button type="button" id="back-btn" class="btn grey-salsa btn-outline"> Back</button>-->
    <!--            <button type="submit" class="btn green pull-right"> Submit</button>-->
    <!--        </div>-->
    <!--    </form>-->
    <!-- END FORGOT PASSWORD FORM -->
</div>

@include('auth.include.login_footer')

<script>
    var formTag = $('#login-form');
    var form = formTag.serialize();
    var url = formTag.attr('action');
    formTag.validate({
        errorPlacement: function (error, element) {
            $(element)
                .closest(".form-error")
                .append(error);
        },
        errorElement: "span",
        rules: {
            username: {
                required: true,
                minlength: 2
            },
            password: {
                required: true,
                minlength: 2
            }

        },
        highlight: function (element) {

            $(element)
                .closest(".form-group")
                .removeClass('border-focus')
                .addClass('border-error')
                .find('span').removeClass('label-focus')
                .addClass('label-error');
        },
        success: function (element) {
            //console.log(element);
            $(element)
                .closest(".form-group")
                .removeClass('border-error')
                .addClass('border-focus')
                .find('span').removeClass('label-error')
                .addClass('label-focus');
        },
        submitHandler: function (form) {
            $('.login-loading').show();
            $('.login-button').attr('disabled',true);
            $.ajax({
                url: form.action,
                type: form.method,
                data: $(form).serialize(),
                success: function (msg) {
                    if (msg == 2) {
                        $("#errors").remove();
                        window.location.href = "{{url('existMobileCSVFile')}}";
                    }
                    else if (msg == 3) {
                        $("#errors").remove();
                        window.location.href = "{{url('/')}}";
                    }
                    else {
                        $("#errors").html('Username Or Password Is Wrong');
                    }
                    $('.login-loading').hide();
                    $('.login-button').attr('disabled',false);
                }
            });
        }
    });


    // $(document).on('submit', "#login-form", function () {
    //     console.log('fddfdfdf');
    //     $.ajax({
    //         type: "POST",
    //         url: "admin/login",
    //         data: $("#login-form").serialize(),
    //         success: function (msg) {
    //             $("#errors").html(msg);
    //         }
    //     });
    // });
</script>

</body>

</html>
