@extends('auth.layouts.app')
@section('pageTitle')
    <title>{{ Lang::get('main.home_page_title') }}</title>
@endsection
@section('contentHeader')
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    {{--<div class="page-bar">--}}
        {{--<ul class="page-breadcrumb">--}}
            {{--<li>--}}
                {{--<a href="{{ URL('/admin') }}">{{ Lang::get('main.dashboard') }}</a>--}}
                {{--<i class="fa fa-circle"></i>--}}
            {{--</li>--}}
            {{--<li>--}}
                {{--<span>{{ Lang::get('main.diploma_report') }}</span>--}}
            {{--</li>--}}
        {{--</ul>--}}
    {{--</div>--}}
    {{--<div class="clearfix"></div>--}}

    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    {{--<h1 class="page-title"> {{ Lang::get('main.diploma_report') }}--}}
        {{--<small>{{ Lang::get('main.view') }}</small>--}}
    {{--</h1>--}}
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
@endsection

@section('content')
<style>
    #datatable_ajax_filter {
        display: block;
        margin-right: 2%;
    }
    /*.page-wrapper-middle > .page-container >.page-content-wrapper >.page-content{*/
    /*    background: #eff3f7;*/
    /*}*/
</style>
<div class="page-content">
    <!-- BEGIN PAGE HEADER-->
    <!-- BEGIN PAGE BAR -->
    <!-- END PAGE BAR -->
    <!-- BEGIN PAGE TITLE-->
    <!--    <h1 class="page-title">-->
    <!--        <i class="icon-settings font-dark"></i>-->
    <!--        <span class="caption-subject font-dark sbold uppercase">Report</span>-->
    <!--    </h1>-->
    <!-- END PAGE TITLE-->
    <!-- END PAGE HEADER-->
    @if(PerUser('certificates_requests_dashboard'))
        <div class="row widget-row">
            <div class="col-md-12">
                <!-- BEGIN SAMPLE TABLE PORTLET-->
                <div class="portlet box green">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-cogs"></i>Report Total</div>
                        <div class="tools">
                            <a href="javascript:;" class="collapse"> </a>
                        </div>
                    </div>
                    <div class="portlet-body flip-scroll">
                        <table class="table table-bordered table-striped table-condensed flip-content">
                            <thead class="flip-content">
                            <tr>
                                <th width="20%">
                                    نوع الاعتماد
                                </th>
                                <th class="numeric"> Total </th>
                                @foreach($status as $s)
                                <th class="numeric"> Total {{ $s }} </th>
                                @endforeach
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($certificatesData as $data)
                            <tr>

                                    <td> {{$data->certificate}} </td>
                                    <td class="numeric"> {{ $data->totalCount }} </td>
                                    @foreach($status as $s)
                                        @php($sWithoutSpaces=str_replace(' ','_',$s))
                                        <td class="numeric"> {{ $data->$sWithoutSpaces }} </td>
                                    @endforeach

                            </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- END SAMPLE TABLE PORTLET-->
            </div>
        </div>
    @endif
    @if(PerUser('certificates_requests_export'))
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group pull-right">
                    <form action="{{ URL('admin/certificates_requests_export') }}" method="GET" id="exportForm">
                        <button class="btn green" type="submit"> {{ Lang::get('main.export') }}</button>
                    </form>
                </div>
            </div>
        </div>
    @endif

    @if(PerUser('certificates_requests_view'))
    <div class="row">
        <div class="col-md-12">
            <div class="portlet light portlet-fit portlet-datatable">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-green"></i>
                        <span class="caption-subject font-green sbold uppercase">Certificates Requests</span>
                    </div>
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn red btn-outline btn-circle" href="javascript:;" data-toggle="dropdown" aria-expanded="false">
                                <i class="fa fa-share"></i>
                                <span class="hidden-xs"> Trigger Tools </span>
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right" id="sample_3_tools">
                                <li>
                                    <a href="javascript:;" data-action="0" class="tool-action">
                                        <i class="icon-printer"></i> Print</a>
                                </li>
                                <li>
                                    <a href="javascript:;" data-action="1" class="tool-action">
                                        <i class="icon-check"></i> Copy</a>
                                </li>
                                <li>
                                    <a href="javascript:;"  data-action="2" class="tool-action">
                                        <i class="icon-doc"></i> PDF</a>
                                </li>
                                <li>
                                    <a href="javascript:;" data-action="3" class="tool-action">
                                        <i class="icon-paper-clip"></i> Excel</a>
                                </li>
                                <li>
                                    <a href="javascript:;" data-action="4" class="tool-action">
                                        <i class="icon-cloud-upload"></i> CSV</a>
                                </li>
                                <li class="divider"> </li>
                                <li>
                                    <a href="javascript:;" data-action="5" class="tool-action">
                                        <i class="icon-refresh"></i> Reload</a>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-container">
                        <div id="datatable_ajax_wrapper"
                             class="dataTables_wrapper dataTables_extended_wrapper no-footer">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover table-checkable"
                                       id="datatable_ajax">
                                    <thead>
                                    <tr role="row" class="heading">
                                        <th>ID</th>
                                        <th>{{ Lang::get('main.country') }}</th>
                                        <th>{{ Lang::get('main.state') }}</th>
                                        <th>{{ Lang::get('main.name') }}</th>
                                        <th>{{ Lang::get('main.gender') }}</th>
                                        <th>{{ Lang::get('main.contact') }}</th>
                                        <th>{{ Lang::get('main.email') }}</th>
                                        <th>{{ Lang::get('main.product') }}</th>
                                        <th>{{ Lang::get('main.certificate') }}</th>
                                        <th>{{ Lang::get('main.customer_name_on_certificate') }}</th>
                                        <th>{{ Lang::get('main.request_date') }}</th>
                                        <th>{{ Lang::get('main.request_status') }}</th>
{{--                                        <th>{{ Lang::get('main.date_of_completion') }}</th>--}}
                                        <th>{{ Lang::get('main.certification_code') }}</th>
                                        <th>{{ Lang::get('main.certificate_date') }}</th>
                                        <th>{{ Lang::get('main.last_comment') }}</th>
                                        <th>{{ Lang::get('main.done_date') }}</th>
                                        <th>{{ Lang::get('main.cancelled_date') }}</th>
                                        <th>{{ Lang::get('main.address') }}</th>
                                        <th>{{ Lang::get('main.product_id') }}</th>
                                        <th>{{ Lang::get('main.added_by') }}</th>
                                        <th>{{ Lang::get('main.diploma_start_date') }}</th>
                                        <th>{{ Lang::get('main.diploma_end_date') }}</th>
                                        <th>{{ Lang::get('main.hours_count') }}</th>
                                        <th></th>
                                    </tr>
                                    <tr role="row" class="filter">
                                        <td>
                                            <input type="hidden" id="_token" name="_token" value="{{ csrf_token() }}">
                                            <input type="number" min="1" class="form-control form-filter input-sm" name="id">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="country">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="state">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="customer_name">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="customer_gender">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="customer_contact">
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="customer_email">
                                        </td>
                                        <td>
                                            <select name="product" class="module_name sel2 form-control form-filter">
                                                <option value=" ">{{ Lang::get('main.product') }}</option>
                                                <option value="MBA">MBA</option>
                                                <option value="Courses">Courses</option>
                                                <option value="Diplomas">Diplomas</option>
                                                <option value="New Mba">New Mba</option>
                                                <option value="DBA Preliminary">DBA Preliminary</option>
                                                {{--<option value="دبلومة الموارد البشرية">دبلومة الموارد البشرية</option>--}}
                                                {{--<option value="دبلومة إدارة الأعمال">دبلومة إدارة الأعمال</option>--}}
                                                {{--<option value="دبلومة التسويق الإلكتروني">دبلومة التسويق الإلكتروني</option>--}}
                                                {{--<option value="دبلومة المحاسبة">دبلومة المحاسبة</option>--}}
                                                {{--<option value="دبلومة ريادة الأعمال">دبلومة ريادة الأعمال</option>--}}
                                                {{--<option value="دبلومة إدارة المشروعات">دبلومة إدارة المشروعات</option>--}}
                                                {{--<option value="دبلومة التسويق">دبلومة التسويق</option>--}}
                                            </select>
                                        </td>
                                        <td>
                                            <select name="certificate" class="module_name sel2 form-control form-filter">
                                                <option value=" ">{{ Lang::get('main.certificate') }}</option>
                                                <option value="EBU">EBU</option>
                                                <option value="جمعية ريادة الأعمال">جمعية ريادة الأعمال</option>
                                                <option value="SSBM">SSBM</option>
                                                <option value="اعمل بيزنس">اعمل بيزنس</option>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="customer_name_on_certificate">
                                        </td>
                                        <td>
                                            <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="request_time_from" placeholder="From">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                            <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="request_time_to" placeholder="To">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                        </td>
                                        <td>
                                            <select name="request_status" class="module_name sel2 form-control form-filter">
                                                <option value=" ">{{ Lang::get('main.request_status') }}</option>
                                                <option value="opened">opened</option>
                                                <option value="closed">closed</option>
                                                <option value="done">done</option>
                                                <option value="cancelled">cancelled</option>
                                                <option value="Prepared EGY">Prepared EGY</option>
                                                <option value="Prepared KSA">Prepared KSA</option>
                                                <option value="Delivered to Customer">Delivered to Customer</option>
                                            </select>
                                        </td>

                                        {{--<td>--}}
                                            {{--<div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">--}}
                                                {{--<input type="text" class="form-control form-filter input-sm"--}}
                                                       {{--name="completion_time_from" placeholder="From">--}}
                                                {{--<span class="input-group-btn">--}}
                                            {{--<button class="btn btn-sm default" type="button">--}}
                                                {{--<i class="fa fa-calendar"></i>--}}
                                            {{--</button>--}}
                                        {{--</span>--}}
                                            {{--</div>--}}
                                            {{--<div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">--}}
                                                {{--<input type="text" class="form-control form-filter input-sm"--}}
                                                       {{--name="completion_time_to" placeholder="To">--}}
                                                {{--<span class="input-group-btn">--}}
                                            {{--<button class="btn btn-sm default" type="button">--}}
                                                {{--<i class="fa fa-calendar"></i>--}}
                                            {{--</button>--}}
                                        {{--</span>--}}
                                            {{--</div>--}}
                                        {{--</td>--}}
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="certification_code">
                                        </td>
                                        <td>
                                            <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="certificate_date_from" placeholder="From">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                            <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="certificate_date_to" placeholder="To">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                        </td>
                                        <td>
                                        </td>
                                        <td>
                                            <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="done_time_from" placeholder="From">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                            <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="done_time_to" placeholder="To">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group date fromToDate margin-bottom-5" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="cancelled_time_from" placeholder="From">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                            <div class="input-group date fromToDate" data-date-format="yyyy-mm-dd">
                                                <input type="text" class="form-control form-filter input-sm"
                                                       name="cancelled_time_to" placeholder="To">
                                                <span class="input-group-btn">
                                            <button class="btn btn-sm default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                            </div>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="address">
                                        </td>
                                        <td></td>
                                        <td>
                                            <input type="text" class="form-control form-filter input-sm" name="added_by">
                                        </td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>
                                            <div class="margin-bottom-5">
                                                <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                    <i class="fa fa-search"></i> {{ Lang::get('main.search') }}</button>
                                            </div>
                                            <button class="btn btn-sm red btn-outline filter-cancel">
                                                <i class="fa fa-times"></i> {{ Lang::get('main.reset') }}</button>
                                        </td>

                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>

    </div>
    @endif
<style>

    .agenda-cont {
        position: fixed;
        right: 0;
        top: 0;
        bottom: 0;
        z-index: 5;
        width: 0;
        transition: .6s ease-in-out;
        background-color: #ddd
    }

    .agenda-cont.active {
        width: 350px;
        height: 350px
    }
   
</style>

    <div class="md-custom-header">
        <div id="demo-custom-header"></div>
    </div>
    <div class="agenda-cont" >
<br><br><br><br><br>
    <div id="status">
          <select id="newoption" name="request_status" class="module_name sel2 form-control form-filter">
                                                <option value=" ">{{ Lang::get('main.request_status') }}</option>
                                                <option value="opened">opened</option>
                                                <option value="closed">closed</option>
                                                <option value="done">done</option>
                                                <option value="cancelled">cancelled</option>
                                                <option value="Prepared EGY">Prepared EGY</option>
                                                <option value="Prepared KSA">Prepared KSA</option>
                                                <option value="Delivered to Customer">Delivered to Customer</option>
                                            </select>


                    
    
    </div>
    <div class="row" style="padding-top: 80px;"> 
        <div class="col-md-12"> 
            <div class="col-md-6"> 
<input type="hidden" id="editid">
        <button onclick="certificates_requests_change_status()" class="btn btn-primary"> save</button>
            </div>
            <div class="col-md-6"> 
                <button class="btn btn-danger closeedit"> cancel</button>
        
            </div>
        
        </div>

    </div>
    </div>


</div>



	    
	

<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

@if(PerUser('certificates_requests_view'))
<script>
    $(document).ready(function () {
        @if(PerUser('certificates_requests_export'))
        $('.form-filter').each(function(){
            $("#exportForm").append('<input type="hidden" name="'+$(this).attr('name')+'"/>');
        })
        $(document).on('click','.filter-submit,.filter-cancel',function(){
            $('.form-filter').each(function(){
                $("#exportForm "+"[name='"+$(this).attr('name')+"']").val($(this).val());
            })
        });
        @endif
        $('.fromToDate').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
        var token = "{{ csrf_token() }}";
        var grid = new Datatable();
        grid.setAjaxParam("_token", "{{ csrf_token() }}");
        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            "loadingMessage": 'Loading...',
            "dataTable": { // here you can define a typical datatable settings from http://datatables.net/usage/options
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js).
                // So when dropdowns used the scrollable div should be removed.
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.
                "lengthMenu": [
                    [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) -1 @endif],
                    [10, 20, 50, 100, 150, @if(PerUser('view_all_rows')) "All" @endif] // change per page values here
                ],
                // default record count per page
                "pageLength": 50,
                "ajax": {
                    "url": "{{ URL('admin/certificates_requests_search') }}", // ajax source
                },
                "order": [
                    [0, "desc"]
                ],// set first column as a default sort by asc
                dom: 'Blfrtip',
                buttons: [
                    {extend: 'print', className: 'btn dark btn-outline'},
                    {extend: 'pdf', className: 'btn green btn-outline'},
                    {extend: 'csv', className: 'btn purple btn-outline '}
                ],
            },
            onDataLoad: function( settings ) {
                console.log(settings);
                $('.edit-status').editable({
                    source: [
                        @if(PerUser('certificates_requests_change_status'))
                        {value: 'opened', text: 'opened'},
                        {value: 'closed', text: 'closed'},
                        {value: 'done', text: 'done'},
                        {value: 'cancelled', text: 'cancelled'},
                        {value: 'Prepared EGY', text: 'Prepared EGY'},
                        {value: 'Prepared KSA', text: 'Prepared KSA'},
                        {value: 'Delivered to Customer', text: 'Delivered to Customer'},
                        @elseif(PerUser('certificates_requests_canceled_only'))
                        {value: 'opened', text: 'opened'},
                        {value: 'closed', text: 'closed'},
                        {value: 'cancelled', text: 'cancelled'},
                        @endif

                    ],
                    url: '{{URL::to("admin/certificates_requests/change_status")}}',
                    title: 'Update',
                    success: function (response, newValue) {
                        swal.fire("Request status updated!", "success");
                        // grid.getDataTable().ajax.reload()
                    }
                });
            }
        });

        @if(PerUser('certificates_requests_edit'))
        $(document).on('click','.certificates-requests-cancel-link',function(){
            var id=$(this).attr('data-id');
                $.ajax({
                    type: "POST",
                    url: "{{ URL('admin/certificates_requests/change_status') }}",
                    data: {"status": 'cancelled', "id": id,_token:token},
                    success: function (msg) {
                        window.location.reload();
                    }
                });
        });
        $(document).on('click','.certificates-requests-done-link',function(){
            var id=$(this).attr('data-id');
            $.ajax({
                type: "POST",
                url: "{{ URL('admin/certificates_requests/change_status') }}",
                data: {"status": 'done', "id": id,_token:token},
                success: function (msg) {
                    window.location.reload();
                }
            });
        });
        @endif


        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            }
        });

        

    });

</script>
@endif
@endsection
