﻿// (c) ammap.com | SVG (in JSON format) map of Yemen - Low
// areas: {id:"YE-AB"},{id:"YE-AD"},{id:"YE-AM"},{id:"YE-BA"},{id:"YE-DA"},{id:"YE-DH"},{id:"YE-HD"},{id:"YE-HJ"},{id:"YE-HU"},{id:"YE-IB"},{id:"YE-JA"},{id:"YE-LA"},{id:"YE-MA"},{id:"YE-MR"},{id:"YE-MW"},{id:"YE-RA"},{id:"YE-SA"},{id:"YE-SD"},{id:"YE-SH"},{id:"YE-SN"},{id:"YE-TA"}
AmCharts.maps.yemenLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"41.813829",
				"topLatitude":"19.005793",
				"rightLongitude":"54.536421",
				"bottomLatitude":"12.124339"
			}
		},
		"g":{
			"path":[
				{
					"id":"YE-AB",
					"title":"Abyān",
					"d":"M204.77,390.11L202.18,385.15L202.51,382.52L204.98,381.04L207.28,377.91L211.07,365.72L215.03,364.07L215.69,361.43L212.23,357.65L209.59,356.33L211.24,352.87L215.03,349.08L215.85,346.61L214.7,345.46L210.41,346.28L209.1,344.3L210.25,343.15L214.53,342.82L214.37,340.35L213.21,339.36L213.54,337.05L214.86,336.07L217.83,336.56L219.64,335.9L219.31,334.25L217.99,333.27L217.5,331.29L218.16,329.97L218.16,329.97L222.44,330.14L222.44,330.14L225.4,329.64L227.05,331.12L228.86,329.97L232.82,329.97L235.45,333.76L241.22,333.6L243.52,332.44L246.16,328.98L256.54,323.22L257.85,323.22L258.18,317.95L261.15,316.79L262.47,309.21L264.84,306.99L264.84,306.99L264.84,306.99L264.84,306.99L271.59,303.04L271.59,303.04L275.38,302.71L278.68,304.36L282.3,309.46L282.79,311.6L280.82,316.05L279.17,317.7L279.01,319.51L288.72,318.03L290.21,318.85L293.17,317.2L293.17,317.2L296.8,314.9L297.62,311.77L297.62,311.77L299.07,310.62L299.07,310.62L303.52,310.94L307.8,310.12L314.39,313.09L319.99,313.09L320.98,315.23L323.12,312.26L323.12,312.26L323.94,310.45L326.41,310.12L328.23,311.11L328.23,317.7L333.33,320.99L333.33,320.99L334.49,339.69L334.49,339.69L335.47,341.67L334.49,345.13L334.49,345.13L334.6,348.62L317.04,352.93L311.91,356.25L303.47,359.72L298.43,358.9L288.21,360.86L276.09,359.17L265.87,360.44L261.72,360.05L239.36,364.52L232.25,370.68L226.42,378.73L222.04,383.05L211.63,385.42L206.98,387.68z"
				},
				{
					"id":"YE-AD",
					"title":"'Adan",
					"d":"M204.08,391.25l-2.85,6.46l-0.38,2.45l0.88,1.76l-0.73,-0.37l-0.41,0.92l-4.13,-1.6l0.24,-0.76l3.2,-0.73l-0.97,-2.25l0.95,-0.18l-1.81,-0.79l-0.4,2.17l-0.67,-1.11l-2.39,0.23l-2.09,1.15l-0.97,2.56l-0.92,-0.67l0.35,-0.86l-1.92,-0.04l-0.59,1.53l5.03,0.53l-0.33,1.29l-1.7,-0.19v1.15l-2.89,0.46l-2.28,-3.05l-2.3,-0.02l-2.93,2.08l0.13,-1.67l-1.92,-1.87l-6.25,-1.43l-5.05,2.26l-5.83,7.1l-1.5,-0.65l0,0l0.67,-3.15l3.79,-5.44l5.77,-2.64l17.46,-0.82l5.27,-2.8l10.52,-1.09l0,0L204.08,391.25z"
				},
				{
					"id":"YE-AM",
					"title":"'Amrān",
					"d":"M115.1,223.89L115.1,222.57L115.1,222.57L116.75,221.91L116.75,221.91L116.26,220.59L114.94,220.1L114.94,220.1L114.61,218.12L114.61,218.12L115.27,215.98L117.57,215.65L118.56,216.8L120.05,216.48L120.05,212.85L121.53,212.19L121.53,212.19L121.36,210.38L121.36,210.38L119.06,210.38L118.89,205.77L118.89,205.77L120.38,205.93L120.38,205.93L118.89,202.8L119.06,198.03L118.07,195.72L116.26,194.4L111.32,198.36L110.66,196.54L113.13,194.57L113.13,194.57L113.95,192.92L113.95,192.92L110,186.99L110.33,181.55L108.52,179.91L108.52,179.91L106.87,178.59L107.2,175.62L107.2,175.62L106.04,169.69L107.2,168.05L107.2,168.05L108.19,166.73L108.19,166.73L107.95,154.43L109.21,153.8L109.21,153.8L116.78,152.48L122.55,149.68L122.55,149.68L126.5,151.33L129.96,151.66L129.96,151.66L135.56,152.64L140.26,152.44L140.26,152.44L140.24,152.48L140.24,152.48L145.35,153.96L147.16,152.97L148.64,154.13L148.64,154.13L149.79,157.09L153.91,160.88L153.91,160.88L154.24,165.33L153.09,166.32L152.92,174.22L152.92,174.22L155.73,174.22L155.07,179.49L153.75,181.47L154.41,184.93L156.05,186.74L156.05,186.74L158.36,187.4L158.36,190.86L158.36,190.86L158.52,191L158.52,191L156.85,192.59L153.22,192.75L151.24,194.73L147.46,194.73L145.97,201.98L148.28,204.29L145.81,209.15L142.84,211.62L143.01,215.24L144.49,215.9L143.83,217.55L141.36,218.21L140.37,220.35L137.57,222.32L134.44,222.98L134.28,219.69L131.64,221.17L131.48,225.12L131.48,225.12L125.48,222.73L124.66,221.42L123.34,221.58L122.85,223.89L119.55,224.88L118.07,223.56L116.09,223.56L116.09,223.56z"
				},
				{
					"id":"YE-BA",
					"title":"Al Bayḑā'",
					"d":"M222.18,330.13L222.01,321.73L220.86,320.09L218.88,319.92L213.61,325.69L211.3,325.85L210.81,324.7L208.17,324.54L208.17,324.54L208.01,320.91L208.01,320.91L205.54,317.78L202.24,317.62L201.91,313.99L198.29,310.04L198.13,308.56L189.07,308.56L186.27,310.7L183.14,308.23L181.16,311.69L181.16,311.69L178.19,311.69L178.19,311.69L174.24,310.53L173.91,306.74L175.23,306.58L175.39,304.27L174.24,303.62L174.24,303.62L172.92,303.29L172.92,301.31L174.41,299.83L178.19,299.83L179.51,293.24L182.31,292.41L182.15,289.61L180.66,287.97L180.34,281.87L182.15,279.07L188.24,275.45L188.24,275.45L190.38,272.81L190.38,272.81L192.93,271.91L192.93,271.91L192.95,271.99L192.95,271.99L201.35,269.85L203.17,283.85L204.65,288.3L210.25,291.1L210.74,288.95L212.72,287.31L217.83,289.12L218.32,287.64L215.85,285.82L216.84,284.51L219.8,286.48L221.78,286.32L223.59,282.04L225.4,283.02L225.07,285L228.7,285L231,278.58L230.85,276.27L230.85,276.27L239.31,276.52L239.31,276.52L239.8,284.42L239.8,284.42L246.56,284.92L250.18,291.84L251.5,296.61L251.5,296.61L251.5,301.89L258.91,300.9L264.84,306.99L264.84,306.99L262.47,309.21L261.15,316.79L258.18,317.95L257.85,323.22L256.54,323.22L246.16,328.98L243.52,332.44L241.22,333.6L235.45,333.76L232.82,329.97L228.86,329.97L227.05,331.12L225.4,329.64L222.44,330.14L222.44,330.14z"
				},
				{
					"id":"YE-DA",
					"title":"Aḑ Ḑāli'",
					"d":"M208.17,324.39L206.2,329.81L204.06,332.28L194.83,339.52L192.2,340.02L190.38,341.67L188.57,340.68L185.77,340.68L188.57,349.9L185.44,349.9L184.78,348.75L183.14,348.75L180.83,350.89L176.22,351.88L174.41,350.56L172.26,352.21L168.8,350.23L168.8,350.23L166.66,346.94L159.58,346.77L159.25,344.3L161.06,343.64L160.73,339.52L160.73,339.52L159.09,337.05L159.09,337.05L159.42,334.91L165.02,328.65L164.36,326.18L168.64,323.88L172.26,323.88L173.75,322.39L171.44,321.73L170.29,320.09L171.44,318.27L173.25,317.62L173.42,314.65L176.55,314.98L178.36,313.66L178.28,311.69L178.28,311.69L181.16,311.69L181.16,311.69L183.14,308.23L186.27,310.7L189.07,308.56L198.13,308.56L198.29,310.04L201.91,313.99L202.24,317.62L205.54,317.78L208.01,320.91L208.01,320.91z"
				},
				{
					"id":"YE-DH",
					"title":"Dhamār",
					"d":"M120.79,316.67L119.45,317.86L119.45,317.86L117.64,319.02L115.01,319.02L111.22,315.06L107.92,314.9L107.92,314.9L105.78,313.58L105.29,311.11L107.1,310.12L107.76,308.31L107.76,308.31L102.98,300.9L102.98,299.08L102.98,299.08L107.1,298.76L107.1,298.76L107.26,300.07L108.75,300.07L109.57,298.43L112.86,296.45L114.51,293.15L118.3,292.66L118.96,293.98L122.25,293.81L127.19,290.85L131.81,286.24L132.14,284.59L130,281.95L130.49,278.82L121.26,270.92L120.91,268.71L120.91,268.71L121.26,268.77L121.26,268.77L121.26,267.29L126.04,267.29L126.21,268.61L128.02,268.61L130.49,266.47L130.98,264.66L132.96,264.33L135.43,261.53L137.08,261.53L137.24,259.88L138.73,258.56L145.97,258.89L150.59,262.68L157.5,263.17L158.33,262.02L157.34,261.36L157.34,259.71L159.32,259.71L162.78,262.85L168.38,261.53L171.01,259.22L179.08,257.57L180.57,258.23L180.4,267.46L184.68,268.77L187.15,273.55L188.97,274.55L188.97,274.55L188.24,275.45L188.24,275.45L182.15,279.07L180.34,281.87L180.66,287.97L182.15,289.61L182.31,292.41L179.51,293.24L178.19,299.83L174.41,299.83L172.92,301.31L172.92,303.29L174.24,303.62L174.24,303.62L171.01,306L169.36,303.7L165.41,303.53L163.76,300.73L160.96,300.73L157.67,299.08L153.72,298.43L150.09,294.31L148.28,293.81L147.13,298.43L144,298.59L143.5,299.91L141.2,299.91L141.2,293.15L139.71,293.15L135.27,299.08L133.62,299.41L132.3,301.06L130.82,300.9L130.16,302.21L131.31,302.71L132.47,306L130.16,308.64L125.22,311.27L125.38,308.64L123.08,308.64L121.92,315.39L120.77,316.55L120.77,316.55z"
				},
				{
					"id":"YE-HD",
					"title":"Ḩaḑramawt",
					"d":"M698.72,438.74l2.31,0.4l0.78,2.53l-1.76,0.53l-5,-2.57L698.72,438.74zM639.43,434.69l4.06,0.53l3.27,2.09l4.77,-0.25l2.56,1.11l4.65,-0.55l-1.71,1.18l0.71,1.48l-5.17,0.53l-3.63,-0.63l-0.9,-1.58l-7.82,-1.28l-2.25,-1.65L639.43,434.69zM730.24,404.92l3.91,1.02l2.82,-0.26l6.81,5.07l4.74,1.62l3.36,-3.29l4.2,0.6l2.99,-0.66l4.48,-1.81l0.97,-1.57l4.51,2.43l2.01,-0.72l1.51,1.83l-0.5,0.49l2.96,-0.08l1.64,1.53l4.43,0.73l7.06,3.78l2.38,-0.78l1.34,0.13L792,415.85l-5.21,1.35l-0.4,2.26l-2.09,1.14l-10.72,2.4l-1.11,2.08l-5,2.8l-6.19,-0.04l-2.01,1.52l-5.02,-0.35l-8.8,1.78l-6.78,0.12l-8.23,-2.27l-1.59,-2.87l-3.73,-3.68l-9.65,-5.53l0.78,-0.88l1.26,0.34l3.44,-1.28l0.14,-6l4.43,-1.14l1.09,-1.78L730.24,404.92zM353.44,122.21l-16.94,10.75l-12.7,-0.65l0,0l0.03,39.44l0,0l-42.1,47.47l0,0l37.5,-3.85l0,0l22.15,-0.65l22.8,-2.93l14.33,0.98l-8.14,12.7l0,0l-8.47,8.14l0,0l-1.63,11.73l-2.6,4.23l0,0l7.17,4.23l0,0l-0.33,3.91l-1.95,2.93l0,0l-8.79,4.89l0,0l-3.26,2.61l9.45,11.07l-0.33,4.89h2.61l0,0l11.73,6.19l6.19,0.98l1.95,3.91l9.12,6.84l0,0l0.33,2.61l1.96,2.93l0,0l8.79,3.26h6.19l5.21,-2.28v2.93l0,0l2.61,0.98l2.93,3.26l0,0l2.76,4.36l0,0l6.47,-0.12l3.81,-4.31l2.3,-1.1l4.2,-4.61l0.36,-2.39l3.17,-1.19l1.89,-2.89l2.8,-0.87l-0.69,-2.39l2.04,-4.7l5.5,-6.05h2.47l1.64,1.26l0.45,-2.48l5.31,-3.16l22.14,-10.2l14.49,-3.7l5.21,-2.35l4.67,-0.07l0.76,2.06l5.41,-1.96l4.1,0.37l0.87,-1.39l4.15,-2.47l3.77,-1.48l0.85,0.62l2.61,-2.92l6.43,-3.84l20.37,-4.27l0,0l-8.77,-16.35l-3.66,-0.24l-0.98,-1.47l-10.02,-4.4l-10.75,-2.2l-0.24,-2.2l1.96,-0.49l-0.24,-5.13l-6.6,-1.95l-1.47,-1.95l3.18,-19.05l3.91,-4.89l0.98,-3.18l-3.42,-4.64l-2.69,-1.95l1.47,-5.62l3.66,-7.57l-0.24,-4.4l2.93,-4.4l-2.2,-1.47l-0.24,-2.93l3.91,-5.13l3.67,-2.44l5.37,-1.47l4.89,-0.24l3.42,-1.71l4.64,-4.4l0.24,-4.15l4.15,-3.42l14.17,-9.04l4.15,-1.95l2.93,-0.24l1.71,-4.64l8.8,-9.28l13.19,-28.83l4.64,-31.02l7.57,-12.7l2.2,-6.11l4.64,-8.31l13.68,-17.1L636.25,0l0,0l-74.35,14.73l-104.56,11.4l-57.98,28.34l-37.78,46.25L353.44,122.21z"
				},
				{
					"id":"YE-HJ",
					"title":"Ḩajjah",
					"d":"M87.04,153.23L88.2,153.15L88.2,153.15L90.92,154.13L90.92,154.13L92.57,155.28L95.37,155.61L95.37,155.61L102.78,153.14L107.89,154.46L107.89,154.46L108.19,166.73L108.19,166.73L107.2,168.05L107.2,168.05L106.04,169.69L107.2,175.62L107.2,175.62L106.87,178.59L108.52,179.91L108.52,179.91L110.33,181.55L110,186.99L113.95,192.92L113.95,192.92L113.13,194.57L113.13,194.57L110.66,196.54L111.32,198.36L116.26,194.4L118.07,195.72L119.06,198.03L118.89,202.8L120.38,205.93L120.38,205.93L118.89,205.77L118.89,205.77L119.06,210.38L121.36,210.38L121.36,210.38L121.53,212.19L121.53,212.19L120.05,212.85L120.05,216.48L118.56,216.8L117.58,215.65L115.27,215.98L114.61,218.12L114.61,218.12L114.94,220.1L114.94,220.1L116.26,220.59L116.75,221.91L116.75,221.91L115.1,222.57L115.1,222.57L115.1,223.89L113.62,224.38L106.87,223.06L106.87,223.06L90.3,226.03L90.3,226.03L89.14,225.54L89.14,219.93L87.83,218.95L87.99,217.46L89.31,217.46L88.98,213.67L87.99,212.85L88.15,210.87L90.3,208.57L90.3,202.64L88.81,201.65L86.51,201.81L77.28,205.6L69.87,206.59L63.94,202.97L62.14,202.9L62.14,202.9L63.68,191.37L62.5,186.18L62.81,183.14L61.45,179.78L61.08,173.62L58.6,169.67L59.43,168.69L67.88,169.92L70.87,169.17L70.12,164.28L73.14,162.12L81.12,160.03L81.03,158.12L82.89,153.17L82.1,151.54L83.29,151.23z"
				},
				{
					"id":"YE-HU",
					"title":"Al Ḩudaydah",
					"d":"M60.1,337l-0.09,3.18l-1.37,0.64l-1.19,2.71l-1.66,0.14l-1,1.63l-1.19,0.18l-0.57,-1.31l2.23,-1.84l0.28,-2.12L60.1,337zM61.81,330.87l-0.79,2.05l-1.16,0.46l0.31,-1.65L61.81,330.87zM58.98,318.49l2.06,2.75l-1.25,6.41l0.8,0.99l-0.67,0.53l-0.33,-1.19l-1.57,0.8l0.88,-2.51l-2.02,-0.16l-3.25,-3.26l1.87,-2.39L58.98,318.49zM67.92,282.73l1.07,1.6l1.21,-0.07l-1.31,0.41l-1.37,-1.33L67.92,282.73zM22.57,254.1l1.19,2.1l-1.05,1.25l-1.19,-2.13L22.57,254.1zM50.88,229.86l1.06,1.8l-2.16,-0.43l-0.95,1.23l1.21,-0.5l-0.05,1.37l-2.51,0.36l1.23,0.7l2.68,-1.03l-1.69,4.15l0.35,2.3l-1.57,2.51l-0.92,0.09l-2.59,-2.4l1.8,-2.48l-0.73,-3.23l2.89,-2.8l-0.35,-0.61L50.88,229.86zM42.93,226.75l1.8,0.45l-1.19,1.46l-0.88,-0.34l0.83,-0.98l-1.92,0.32L42.93,226.75zM34.49,224.93l0.71,0.28l-0.09,1.93l1.92,2.03l-1.94,-1.5l-1.23,-2.53L34.49,224.93zM1.63,223.42l0.61,1.59l-1.64,0.66l-0.57,-1.11L1.63,223.42zM48.91,217.4l2.46,1.63l-2.54,0.41l-0.88,-1.69L48.91,217.4zM29.89,213.35l0.81,3.62l-1.54,-1.78L29.89,213.35zM35.82,211.21l3.08,1.77l2.79,0.25l0.04,0.77l-6.21,0.3l-0.47,-2.62L35.82,211.21zM50.6,209.76l-0.45,1.68l-1.23,0.57l0.64,-1.8L50.6,209.76zM62.14,202.9l1.8,0.07l5.93,3.62l7.41,-0.99l9.23,-3.79l2.31,-0.16l1.48,0.99v5.93l-2.14,2.31l-0.16,1.98l0.99,0.82l0.33,3.79H87.99l-0.16,1.48l1.32,0.99v5.6l1.15,0.49l0,0l-0.16,2.31l0.99,0.99l0,0l0.82,1.48l-1.98,1.32l0,0l0.49,5.93l10.54,10.05l0,0l0.99,3.46l0,0l4.45,2.8l0,0l0.17,2.72l0,0l4.45,1.32l0,0h2.97l1.65,1.65l0,0l-1.48,1.81l0,0l-0.33,0.66l0,0l-4.78,-0.16l-0.82,2.47l-1.65,1.65l-2.31,0.49l-1.65,4.28l2.47,4.78l-1.81,2.31l-0.33,4.94l2.14,1.98l2.31,8.4l0,0l0.66,3.13l-1.15,0.49l0,0v1.48l0,0l-3.95,0.33l0,0v1.81l4.78,7.41l0,0l-0.66,1.81l-1.81,0.99l0.5,2.47l2.14,1.32l0,0l3.29,0.16l3.79,3.95h2.64l1.81,-1.15l0,0l1.34,-1.19l0.31,1.85l0,0l1.32,0.66l0,0l-3.29,2.14l0,0l0.33,2.47l-1.15,1.81l-2.96,-2.47l-0.99,1.32l2.47,4.45l-2.59,0.12l0,0l-0.04,-0.12l0,0h-1.81l-2.14,1.32l-2.47,-0.49l-3.62,0.82l-0.82,4.78l0.49,1.48l-2.96,0.33l-0.99,3.46l-1.32,1.15l-6.85,2.56l0,0l-3.42,-9.88l0.14,-3.68l-4.63,-4.66l-0.9,-3.54l-2.96,-3.56l0.66,-1.49l-1.25,-2.36l-1.35,-7.21l-4.32,-10.18l-2.08,-8.2l-1.28,-0.92l0.03,-1.7l0.52,1.9l1.11,0.32l0.37,2.72l0.88,0.03l1.71,3.34l0.05,-1.63l-1.19,-0.91l0.96,-0.62l-0.81,-0.75l0.73,-2.73l-1.62,-1.3l0.9,-0.53l-1.12,-5.9l-2.16,-3.52v-3.87l-4.17,-4.92l-0.83,-2.84l0.42,-1.58l1.52,1.6l-0.92,0.59l0.71,2.69l0.23,-1.58l1.45,-0.3l-0.67,1.21l1.28,2.92l0.55,-2.93l-0.86,-1.14l1.02,0.78l0.38,-0.53l-0.5,-2.93l-1.71,-4.18l-2.85,-2.46l-0.52,-3.88l0.64,-1.94l-1.83,-2.78l-3.84,-2.12l-6.43,-1.78l-0.95,2.24h-1.49l-2.54,-2.97l0.64,-1.67l1.94,1.25l2.54,-0.69l0.57,-1.85l-1.23,-2.58l1.33,-1.19l0.52,-2.08l0.45,0.91l-1.02,2.69l1.87,-0.12l0.85,2.46l1.71,-0.23l0.42,2.55l1.02,-0.09l1.56,-2.4l-1.05,-1.8l-1.07,-0.14l1.23,-2.94l-2.16,-4.44l0.93,-2.69l-1.95,-4.49l-2.89,-1.57l1.61,-2.37l-1.88,-2.89l0.88,-3.44l-1.69,0.73l-0.28,-0.75l0.88,-2.53l1.12,0.46l-0.57,-0.95l2.46,-0.93l0.02,-1.79l1.26,-0.43l0.07,-1.37l1.14,-0.45L62.14,202.9z"
				},
				{
					"id":"YE-IB",
					"title":"Ibb",
					"d":"M174.24,303.62L175.39,304.27L175.23,306.58L173.91,306.74L174.24,310.53L178.19,311.69L178.19,311.69L178.28,311.69L178.28,311.69L178.36,313.66L176.55,314.98L173.42,314.65L173.25,317.62L171.44,318.27L170.29,320.09L171.44,321.73L173.75,322.39L172.26,323.88L168.64,323.88L164.36,326.18L165.02,328.65L159.42,334.91L159.09,337.05L159.09,337.05L160.09,338.55L160.09,338.55L155.86,342.57L153.88,342.08L151.57,339.44L148.94,341.75L147.13,341.75L147.13,339.44L143.83,339.77L141.03,337.63L140.21,339.11L135.27,336.81L130.49,336.81L130.65,335.32L132.79,333.02L131.48,331.7L129.83,332.19L127.85,335L127.03,333.51L127.69,330.38L125.38,330.55L122.75,332.85L121.43,331.04L120.28,331.54L120.11,333.51L115.01,332.69L114.84,330.88L114.84,330.88L114.22,329.02L114.22,329.02L116.82,328.9L114.35,324.45L115.33,323.14L118.3,325.61L119.45,323.79L119.12,321.32L119.12,321.32L122.42,319.18L122.42,319.18L121.1,318.52L121.1,318.52L120.77,316.55L120.77,316.55L121.92,315.39L123.08,308.64L125.38,308.64L125.22,311.27L130.16,308.64L132.47,306L131.31,302.71L130.16,302.21L130.82,300.9L132.3,301.06L133.62,299.41L135.27,299.08L139.71,293.15L141.2,293.15L141.2,299.91L143.5,299.91L144,298.59L147.13,298.43L148.28,293.81L150.09,294.31L153.72,298.43L157.67,299.08L160.96,300.73L163.76,300.73L165.41,303.53L169.36,303.7L171.01,306z"
				},
				{
					"id":"YE-JA",
					"title":"Al Jawf",
					"d":"M312.77,184.25L276.8,189.05L276.8,189.05L265.27,190.53L247.31,194.48L247.31,194.48L242.54,196.13L238.91,198.93L236.11,201.73L232.49,207.83L227.71,209.64L214.2,209.64L214.2,209.64L189.82,192.84L174.34,192.84L173.02,193.66L173.02,193.66L162.81,192.51L162.81,192.51L160.67,192.84L158.36,190.86L158.36,190.86L158.36,187.4L156.05,186.74L156.05,186.74L154.41,184.93L153.75,181.47L155.07,179.49L155.73,174.22L152.92,174.22L152.92,174.22L153.09,166.32L154.24,165.33L153.91,160.88L153.91,160.88L149.79,157.09L148.64,154.13L148.64,154.13L147.16,152.97L145.35,153.96L140.24,152.48L140.24,152.48L141.89,149.51L145.18,148.2L159.84,133.87L170.22,127.44L175,126.62L192.62,126.62L192.49,102.07L212.62,102.07L223.92,109.35L235.21,110.11L266.34,114.38L289.69,115.13L309.02,112.37L323.8,132.31L323.8,132.31L323.83,171.75L323.83,171.75z"
				},
				{
					"id":"YE-LA",
					"title":"Laḩij",
					"d":"M105.93,406.68L106.37,403.93L112.47,392.9L113.95,390.59L115.93,390.43L117.25,388.94L117.25,382.02L122.19,382.02L122.85,380.54L126.96,379.06L128.78,380.54L132.4,381.2L134.05,383.01L135.04,382.19L134.87,379.72L136.19,378.89L138.17,381.04L141.29,380.87L141.46,377.08L146.4,377.25L144.43,374.12L145.91,373.95L145.91,371.15L147.23,370.99L148.21,373.46L152.83,372.96L154.47,373.62L157.44,371.48L157.44,369.51L156.12,367.86L157.11,365.39L155.79,364.23L156.12,362.92L158.1,362.09L162.05,362.59L162.38,360.94L157.11,359.29L156.94,357.32L161.23,355.83L168.8,350.23L168.8,350.23L172.26,352.21L174.41,350.56L176.22,351.88L180.83,350.89L183.14,348.75L184.78,348.75L185.44,349.9L188.57,349.9L185.77,340.68L188.57,340.68L190.38,341.67L192.2,340.02L194.83,339.52L204.06,332.28L206.2,329.81L208.17,324.39L208.17,324.39L208.17,324.54L208.17,324.54L210.81,324.7L211.3,325.85L213.61,325.69L218.88,319.92L220.86,320.09L222.01,321.73L222.18,330.13L222.18,330.13L218.16,329.97L218.16,329.97L217.5,331.29L219.64,335.9L217.83,336.56L214.86,336.07L213.54,337.05L213.21,339.36L214.37,340.35L214.53,342.82L210.25,343.15L209.1,344.3L210.41,346.28L214.7,345.46L215.85,346.61L215.03,349.08L211.24,352.87L209.59,356.33L212.23,357.65L215.69,361.43L215.03,364.07L211.07,365.72L207.28,377.91L204.98,381.04L202.51,382.52L202.18,385.15L204.77,390.11L204.77,390.11L204.13,391.14L204.13,391.14L193.61,392.24L188.34,395.04L170.88,395.86L165.11,398.5L161.32,403.93L160.66,407.08L160.66,407.08L154.01,410.27L149.96,409.97L146.4,411.11L144.41,410.23L147.16,410.9L147.89,409.9L145.78,408.74L139.17,411.82L132.67,412.54L130.76,411.57L130.35,409.33L111.26,402.73L109.3,403.57L106.53,406.94z"
				},
				{
					"id":"YE-MA",
					"title":"Ma'rib",
					"d":"M230.85,276.27L231,278.58L228.7,285L225.07,285L225.4,283.02L223.59,282.04L221.78,286.32L219.8,286.48L216.84,284.51L215.85,285.82L218.32,287.64L217.83,289.12L212.72,287.31L210.74,288.95L210.25,291.1L204.65,288.3L203.17,283.85L201.35,269.85L192.95,271.99L192.95,271.99L192.29,270.01L192.29,270.01L191.96,267.38L195.26,262.76L196.41,258.81L203,251.89L205.8,243.82L206.13,239.87L203.99,239.54L187.02,231.47L187.02,237.73L180.43,237.4L179.61,229.49L173.68,233.11L169.23,230.81L170.06,228.34L175.99,227.18L179.28,224.38L185.87,222.08L187.19,219.93L186.36,218.12L181.75,216.64L179.28,210.55L179.61,208.07L178.46,202.47L175,194.57L173.02,193.66L173.02,193.66L173.02,193.66L173.02,193.66L174.34,192.84L189.82,192.84L214.2,209.64L214.2,209.64L227.71,209.64L232.49,207.83L236.11,201.73L238.91,198.93L242.54,196.13L247.31,194.48L247.31,194.48L265.27,190.53L276.8,189.05L276.8,189.05L312.77,184.25L312.77,184.25L281.73,219.22L281.73,219.22L281.73,219.22L281.73,219.22L260.72,232.7L260.72,232.7L247.05,242.09L247.05,242.09L244.08,243.24L241.28,247.53L236.18,251.15L236.18,251.15L229.92,260.7L229.92,260.7L230.25,266.3L228.44,270.42L228.44,270.42L228.11,276.19z"
				},
				{
					"id":"YE-MR",
					"title":"Al Mahrah",
					"d":"M559.53,253.46L550.76,237.11L547.09,236.87L546.12,235.4L536.1,231L525.35,228.81L525.11,226.61L527.06,226.12L526.82,220.99L520.22,219.03L518.75,217.08L521.93,198.02L525.84,193.14L526.82,189.96L523.4,185.32L520.71,183.37L522.17,177.75L525.84,170.18L525.6,165.78L528.53,161.38L526.33,159.92L526.08,156.98L529.99,151.85L533.66,149.41L539.03,147.95L543.92,147.7L547.34,145.99L551.98,141.59L552.22,137.44L556.38,134.02L570.54,124.98L574.7,123.03L577.63,122.78L579.34,118.14L588.13,108.86L601.32,80.03L605.97,49.01L613.54,36.31L615.74,30.2L620.38,21.89L634.06,4.79L636.25,0L636.25,0L660.85,52.35L661.09,57.44L684.56,106.32L682.14,110.91L686.98,110.43L688.43,115.51L705.37,152.05L694.46,155.16L664.94,166.67L659.99,169.71L654.25,175.39L648.78,182.34L643.29,196.79L643.54,198.93L644.84,199.95L644.12,204.24L646.76,206.67L645.97,206.78L646.76,209.07L645.86,210.46L648.18,218.56L646.35,220.06L625.94,227.61L624.62,229.04L625.42,230.62L623,229.64L614.35,232.66L612.05,234.1L611.5,235.53L612.97,237.65L605.44,238.68L601.54,240.21L598.06,242.9L595.17,243.38L594.86,244.22L592.91,243.97L580.96,248.25L580.16,248.3L580.09,247.44L579.54,248.58z"
				},
				{
					"id":"YE-MW",
					"title":"Al Maḩwīt",
					"d":"M131.48,225.12L132.3,226.94L129.83,228.25L130.49,229.9L131.81,230.23L131.81,231.71L129.34,232.87L128.51,234.51L124.89,234.51L124.06,236.49L118.96,240.44L115.17,241.27L113.69,243.41L110.72,243.74L109.4,245.22L108.91,248.51L110.06,249.34L109.4,252.14L107.43,253.13L107.43,253.13L106.44,254.36L106.44,254.36L101.99,251.56L101.99,251.56L101,248.1L101,248.1L90.46,238.05L89.97,232.12L89.97,232.12L91.94,230.81L91.12,229.32L91.12,229.32L90.13,228.34L90.3,226.03L90.3,226.03L106.87,223.06L106.87,223.06L113.62,224.38L116.09,223.56L116.09,223.56L118.07,223.56L119.55,224.88L122.85,223.89L123.34,221.58L124.66,221.42L125.48,222.73z"
				},
				{
					"id":"YE-RA",
					"title":"Raymah",
					"d":"M113.99,262.52L113.85,263.01L113.85,263.01L116.49,267.29L118.46,268.28L118.46,268.28L120.91,268.71L120.91,268.71L121.26,270.92L130.49,278.82L130,281.95L132.14,284.59L131.81,286.24L127.19,290.85L122.25,293.81L118.96,293.98L118.3,292.66L114.51,293.15L112.86,296.45L109.57,298.43L108.75,300.07L107.26,300.07L107.1,298.76L107.1,298.76L106.93,298.76L106.93,298.76L106.93,297.27L106.93,297.27L108.09,296.78L107.43,293.65L107.43,293.65L105.12,285.25L102.98,283.27L103.31,278.33L105.12,276.02L102.65,271.25L104.3,266.96L106.6,266.47L108.25,264.82L109.08,262.35L113.85,262.52L113.85,262.52z"
				},
				{
					"id":"YE-SA",
					"title":"Amanat Al Asimah",
					"d":"M161.46,221.99L162.45,223.81L162.45,223.81L159.32,222.98L158.49,224.46L155.36,224.79L154.87,227.1L151.24,230.56L153.06,237.31L151.57,239.78L148.28,239.78L147.62,236.49L146.14,236.32L145.81,234.18L147.29,231.88L144,229.74L144.99,227.76L147.46,227.76L148.94,226.61L149.93,223.31L151.24,221.66L153.22,221.5L153.72,219.69L155.53,219.69L157.34,218.37L160.3,220.02L160.3,220.02z"
				},
				{
					"id":"YE-SD",
					"title":"Şā‘dah",
					"d":"M140.26,152.44L135.56,152.64L129.96,151.66L129.96,151.66L126.5,151.33L122.55,149.68L122.55,149.68L116.78,152.48L109.21,153.8L109.21,153.8L107.89,154.46L107.89,154.46L102.78,153.14L95.37,155.61L95.37,155.61L92.57,155.28L90.92,154.13L90.92,154.13L88.2,153.15L88.2,153.15L87.66,148.27L88.24,146.8L90.83,146.6L89.97,145.05L90.36,142.77L88.53,141.91L87.93,140.41L85.13,139.79L83.03,137.31L82.59,135.28L85.3,134.01L84.84,128.94L88.95,129.42L89.93,127.77L88.45,124.81L85.5,123.94L83.73,124.67L83.51,122.79L84.81,121.87L84.72,119.25L87.48,116.77L86.72,113.4L94.78,111.06L94.37,109.61L92.9,108.99L92.9,107.81L90.09,106.19L89.93,104.87L89.93,101.91L92.24,97.63L94.38,95.81L103.61,94L105.91,94.83L111.35,99.27L117.56,106.55L121.78,106.15L123.01,107.77L126.57,108.29L129.47,107.51L134.18,108.81L136.65,105.33L141.99,104.38L143.95,106.77L145.41,104.05L160.41,102.07L166.18,101.82L170.95,104.33L174.46,103.83L176.97,102.07L192.49,102.07L192.62,126.62L175,126.62L170.22,127.44L159.84,133.87L145.18,148.2L141.89,149.51z"
				},
				{
					"id":"YE-SH",
					"title":"Shabwah",
					"d":"M334.63,348.6L334.49,345.13L334.49,345.13L335.47,341.67L334.49,339.69L334.49,339.69L333.33,320.99L333.33,320.99L328.23,317.7L328.23,311.11L326.41,310.12L323.94,310.45L323.12,312.26L323.12,312.26L320.98,315.23L319.99,313.09L314.39,313.09L307.8,310.12L303.52,310.95L299.07,310.62L299.07,310.62L297.62,311.77L297.62,311.77L296.8,314.9L293.17,317.2L293.17,317.2L290.21,318.85L288.72,318.03L279.01,319.51L279.17,317.7L280.82,316.05L282.79,311.6L282.3,309.46L278.68,304.36L275.38,302.71L271.59,303.04L271.59,303.04L264.84,306.99L264.84,306.99L264.84,306.99L264.84,306.99L258.91,300.9L251.5,301.89L251.5,296.61L251.5,296.61L250.18,291.84L246.55,284.92L239.8,284.42L239.8,284.42L239.31,276.52L239.31,276.52L228.11,276.19L228.44,270.42L228.44,270.42L230.25,266.3L229.92,260.7L229.92,260.7L236.18,251.15L236.18,251.15L241.28,247.53L244.08,243.24L247.05,242.09L247.05,242.09L260.72,232.7L260.72,232.7L281.73,219.22L281.73,219.22L319.24,215.37L319.24,215.37L341.38,214.72L364.19,211.79L378.52,212.76L370.37,225.47L370.37,225.47L361.9,233.61L361.9,233.61L360.28,245.34L357.67,249.57L357.67,249.57L364.84,253.8L364.84,253.8L364.51,257.71L362.56,260.64L362.56,260.64L353.76,265.53L353.76,265.53L350.5,268.14L359.95,279.21L359.63,284.1L362.23,284.1L362.23,284.1L373.96,290.29L380.15,291.26L382.1,295.17L391.22,302.01L391.22,302.01L391.55,304.62L393.5,307.55L393.5,307.55L402.29,310.81L408.48,310.81L413.69,308.52L413.69,311.46L413.69,311.46L416.3,312.43L419.23,315.69L419.23,315.69L421.99,320.05L421.99,320.05L418.42,320.65L413.65,323.44L412.09,321.52L409.24,322.34L405.88,321.54L405.59,322.85L403.45,324.09L402.48,323.42L400.73,324.62L398.91,323.84L396.58,325.15L395.37,322.92L390.72,320.57L386.57,319.59L382.8,320.14L373.2,327.35L366.87,328.71L362.82,331.28L359.92,334.73L347.22,345.2z"
				},
				{
					"id":"YE-SN",
					"title":"Şan‘ā'",
					"d":"M158.52,191l2.15,1.84l2.14,-0.33l0,0l10.21,1.15l0,0l1.98,0.91l3.46,7.91l1.15,5.6l-0.33,2.47l2.47,6.1l4.61,1.48l0.82,1.81l-1.32,2.14l-6.59,2.31l-3.29,2.8l-5.93,1.15l-0.82,2.47l4.45,2.31l5.93,-3.62l0.82,7.91l6.59,0.33v-6.26l16.97,8.07l2.14,0.33l-0.33,3.95l-2.8,8.07l-6.59,6.92l-1.15,3.95l-3.29,4.61l0.33,2.64l0,0l0.63,1.9l0,0l-2.54,0.9l0,0l-1.41,1.74l0,0l-1.82,-0.99l-2.47,-4.78l-4.28,-1.32l0.17,-9.22l-1.48,-0.66l-8.07,1.65l-2.64,2.31l-5.6,1.32l-3.46,-3.13h-1.98v1.65l0.99,0.66l-0.82,1.15l-6.92,-0.49l-4.61,-3.79l-7.25,-0.33l-1.48,1.32l-0.16,1.65h-1.65l-2.47,2.8l-1.98,0.33l-0.49,1.81l-2.47,2.14h-1.81l-0.16,-1.32h-4.78v1.48l0,0l-2.8,-0.49l0,0l-1.98,-0.99l-2.64,-4.28l0,0l0.33,-1.15l0,0l1.48,-1.81l0,0l-1.65,-1.65h-2.96l0,0l-4.45,-1.32l0,0l0.82,-3.95l0,0l1.98,-0.99l0.66,-2.8l-1.15,-0.82l0.49,-3.29l1.32,-1.48l2.97,-0.33l1.48,-2.14l3.79,-0.82l5.11,-3.95l0.82,-1.98h3.62l0.82,-1.65l2.47,-1.15v-1.48l-1.32,-0.33l-0.66,-1.65l2.47,-1.32l-0.82,-1.81l0,0l0.17,-3.95l2.64,-1.48l0.17,3.29l3.13,-0.66l2.8,-1.98l0.99,-2.14l2.47,-0.66l0.66,-1.65l-1.48,-0.66l-0.16,-3.62l2.97,-2.47l2.47,-4.86l-2.31,-2.31l1.48,-7.25h3.79l1.98,-1.98l3.62,-0.16L158.52,191zM157.34,218.37l-1.81,1.32h-1.81l-0.49,1.81l-1.98,0.17l-1.32,1.65l-0.99,3.29l-1.48,1.15h-2.47l-0.99,1.98l3.3,2.14l-1.48,2.31l0.33,2.14l1.48,0.17l0.66,3.29h3.29l1.48,-2.47l-1.81,-6.75l3.62,-3.46l0.49,-2.31l3.13,-0.33l0.82,-1.48l3.13,0.82l0,0l-2.14,-3.79L157.34,218.37z"
				},
				{
					"id":"YE-TA",
					"title":"Tā‘izz",
					"d":"M99.48,407.61l1.7,0.77l-0.43,1.74l-0.28,-0.76l-0.59,0.44l-0.1,-1.25l-1.11,0.14l0.78,0.81l-1.56,-0.9L99.48,407.61zM114.18,328.9l0.66,1.98l0,0l0.17,1.81l5.11,0.82l0.17,-1.98l1.15,-0.49l1.32,1.81l2.64,-2.31l2.31,-0.16l-0.66,3.13l0.82,1.48l1.98,-2.8l1.65,-0.49l1.32,1.32l-2.14,2.31l-0.16,1.48h4.78l4.94,2.31l0.82,-1.48l2.8,2.14l3.29,-0.33v2.31h1.81l2.64,-2.31l2.31,2.64l1.98,0.49l4.23,-4.02l0,0l0.65,0.97l0,0l0.33,4.12l-1.81,0.66l0.33,2.47l7.08,0.17l2.14,3.29l0,0l-7.58,5.6l-4.28,1.48l0.17,1.98l5.27,1.65l-0.33,1.65l-3.95,-0.49l-1.98,0.82l-0.33,1.32l1.32,1.15l-0.99,2.47l1.32,1.65v1.98l-2.96,2.14l-1.65,-0.66l-4.61,0.49l-0.99,-2.47l-1.32,0.17v2.8l-1.48,0.17l1.98,3.13l-4.94,-0.16l-0.16,3.79l-3.13,0.16l-1.98,-2.14l-1.32,0.82l0.17,2.47l-0.99,0.82l-1.65,-1.81l-3.62,-0.66l-1.81,-1.48l-4.12,1.48l-0.66,1.48h-4.94v6.92l-1.32,1.48l-1.98,0.17l-1.48,2.31l-6.09,11.04l-0.44,2.74l0,0l-0.66,0.76l-2.32,0.04l-1,-1.27l1.18,-1.41l-0.17,-0.3l1.61,-6.59l-5.48,-7.51l-0.54,-2.63L91.35,376.42l-3.42,-7.64l0.36,-0.64l0.69,2.01l-0.79,-2.88l1.18,-2.19l0.5,-10.62l1.25,-5.21l0.92,-0.55l-0.35,-4.4l0,0l6.85,-2.56l1.32,-1.15l0.99,-3.46l2.97,-0.33l-0.49,-1.48l0.82,-4.78l3.62,-0.82l2.47,0.49l2.14,-1.32H114.18z"
				}
			]
		}
	}
};
