﻿// (c) ammap.com | SVG (in JSON format) map of Venezuela - Low
// areas: {id:"AW"},{id:"BQ"},{id:"CW"},{id:"VE-A"},{id:"VE-B"},{id:"VE-C"},{id:"VE-D"},{id:"VE-E"},{id:"VE-F"},{id:"VE-G"},{id:"VE-H"},{id:"VE-I"},{id:"VE-J"},{id:"VE-K"},{id:"VE-L"},{id:"VE-M"},{id:"VE-N"},{id:"VE-O"},{id:"VE-P"},{id:"VE-R"},{id:"VE-S"},{id:"VE-T"},{id:"VE-U"},{id:"VE-V"},{id:"VE-W"},{id:"VE-X"},{id:"VE-Y"},{id:"VE-Z"}
AmCharts.maps.venezuelaLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-73.388293",
				"topLatitude":"12.544056",
				"rightLongitude":"-59.804557",
				"bottomLatitude":"0.644674"
			}
		},
		"g":{
			"path":[
				{
					"id":"AW",
					"title":"Aruba",
					"d":"M147.29,0.64L148.2,0L149.1,2.06L152.83,4.25L154.63,6.95L153.86,9.01L151.8,8.63L145.62,3.22z"
				},
				{
					"id":"BQ",
					"title":"Bonaire, Saint Eustachius and Saba",
					"d":"M226.99,17.12L225.83,26.14L223.77,24.72L223,19.31L217.85,16.48L217.59,14.55L220.68,13.39z"
				},
				{
					"id":"CW",
					"title":"Curaçao",
					"d":"M195.19,18.28L199.44,19.83L204.2,25.36L202.27,26.14L201.88,24.85L197.25,24.98L192.1,21.24L185.02,12.36L185.15,10.69L189.78,11.84L190.68,15.84z"
				},
				{
					"id":"VE-A",
					"title":"Distrito Capital",
					"d":"M289.74,90.15L289.49,92.84L282.82,96.67L278.25,96.67L276.21,94.75L276.21,94.75L276.77,94.07L276.77,94.07L280.72,89.38L289.49,90.12L289.49,90.12z"
				},
				{
					"id":"VE-B",
					"title":"Anzoátegui",
					"d":"M472.46,184.63L469.4,185.32L464.83,189.77L454.71,186.93L451.5,187.79L449.77,186.93L435.82,196.06L430.63,195.44L424.58,197.42L419.52,203.59L415.81,205.94L410.38,205.32L404.7,200.14L402.6,200.01L396.43,203.1L391.98,202.24L387.91,205.69L388.53,209.27L391,211L390.25,213.47L386.06,213.72L377.17,218.41L373.59,218.16L365.93,212.48L351.73,208.78L351.73,208.78L350.25,207.67L350.25,207.67L348.03,205.45L349.14,201L361.49,185.2L363.58,177.79L362.6,174.45L363.58,171L364.94,169.76L372.6,169.64L374.45,171.86L376.92,171.86L380.01,164.58L379.14,162.6L371.73,158.28L371.73,155.81L369.51,153.59L362.6,151.12L359.26,147.78L356.79,143.83L357.41,142.1L361.49,139.88L361.24,138.4L356.05,136.06L350.99,131.49L349.14,133.09L341.36,133.09L341.36,130.38L339.75,129.63L340.25,122.84L338.35,117.29L338.35,117.29L338.72,115.93L338.72,115.93L341.06,116.05L344.52,113.95L350.94,107.6L350.94,107.6L366.54,111.25L377.86,110.28L381.94,108.89L382.73,105.94L386.41,103.65L393.18,103.02L393.18,103.02L395.91,107.38L402.33,110.35L406.78,110.35L411.59,108.37L416.78,109.48L416.78,109.48L417.11,109.48L417.11,109.48L412.44,112.08L411.95,113.68L412.2,115.66L415.53,117.76L418,121.95L416.64,124.55L417.13,126.52L419.97,129.36L421.33,133.81L421.33,135.29L415.9,140.23L419.48,149.24L424.54,147.88L428.86,149.86L443.19,161.34L447.26,169.86L460.1,168.63L460.6,169.86L458.74,171.59L456.15,171.47L456.89,176.04L472.57,182.33L472.57,182.33z"
				},
				{
					"id":"VE-C",
					"title":"Apure",
					"d":"M312.03,218.41L307.46,220.8L299.72,232.82L292.97,234.63L285.4,239.56L282.44,239.4L277.83,241.38L275.69,246.97L279.47,249.94L278.98,258L276.67,260.8L274.37,267.39L274.2,272L272.89,274.3L269.92,275.78L269.1,278.09L262.3,282.97L262.3,282.97L256,280.2L246.5,278.59L242.05,279.58L240.57,282.17L238.59,282.79L231.75,281.39L229.21,283.78L227.45,282.48L223.48,283.84L219.64,282.54L211.37,283.65L209.39,285.28L189.27,280.69L186.43,281.31L182.74,287.55L180.38,287.36L179.45,284.7L174.44,286.02L172.72,284.76L172.85,282.67L164.45,275.38L163.96,272.05L151.12,257.72L143.9,247.2L134.04,249.19L132.42,246.83L127.98,245.23L125.75,242.27L110.44,242.27L104.83,247.41L102.05,247.33L100.44,245.35L80.63,245.1L79.21,243.25L76.98,243.13L68.96,246.09L61.67,246.34L54.46,238.31L53.63,234.29L55.08,231.4L51.5,228.93L45.72,227.96L45.72,227.96L46.14,227.02L54.21,226.2L58,229.33L63.43,229.65L66.23,228.67L67.71,225.37L67.71,225.37L67.8,225.08L67.8,225.08L70.82,225.08L74.28,227.71L76.91,228.04L78.23,227.05L80.04,228.04L89.43,227.05L95.35,228.21L98.64,230.84L106.38,232.98L118.3,234.13L120.61,233.31L120.94,231.99L124.06,232.16L128.01,228.37L132.46,226.56L134.6,219.97L141.18,218.99L146.45,214.54L150.4,214.38L155.34,210.59L159.79,210.92L172.3,201.54L186.95,201.7L189.26,203.18L194.03,203.51L199.63,207.3L216.25,205.82L222.35,207.13L229.26,205.32L242.6,207.63L256.38,204.21L256.38,204.21L258.17,206.28L258.17,206.28L272.66,212.53L283.03,213.19L295.38,217.31L297.35,213.52L303.44,212.04L307.39,215L310.36,215.33L311.18,217.47L311.18,217.47z"
				},
				{
					"id":"VE-D",
					"title":"Aragua",
					"d":"M260.12,115.74L257.78,114.2L252.72,113.71L254.33,103.09L253.21,100L246.42,99.51L243.58,97.41L243.71,95.68L247.21,92.61L247.21,92.61L265.69,90.5L265.69,90.5L267.51,96.79L270.97,94.69L272.82,95.93L275.04,95.31L275.04,95.31L275.09,95.29L275.09,95.29L275.27,99.51L278.23,103.71L277.12,106.42L277.98,109.39L283.29,111.61L285.76,114.08L298.97,115.06L298.97,115.06L299.15,115.06L299.15,115.06L300.38,122.47L297.54,125.81L301,129.51L301.37,131.61L300.13,132.84L301.24,138.15L296.43,145.07L282.85,138.65L282.23,135.56L286.55,134.33L288.16,131.86L288.16,129.51L284.82,126.18L281.74,124.82L274.33,118.03L270.99,118.03L265.07,115.19L260.13,115.68L260.13,115.68z"
				},
				{
					"id":"VE-E",
					"title":"Barinas",
					"d":"M256.38,204.21L242.6,207.63L229.26,205.32L222.35,207.13L216.25,205.82L199.63,207.3L194.03,203.51L189.26,203.18L186.95,201.7L172.3,201.54L159.79,210.92L155.34,210.59L150.4,214.38L146.45,214.54L141.18,218.99L134.6,219.97L132.46,226.56L128.01,228.37L124.06,232.16L120.94,231.99L120.61,233.31L118.3,234.13L106.38,232.98L98.64,230.84L95.35,228.21L89.43,227.05L82.51,228.04L78.23,227.05L76.91,228.04L74.28,227.71L70.82,225.08L67.8,225.08L67.8,225.08L68.04,224.22L68.04,224.22L72.48,222.25L89.11,225.04L83.68,219.12L84.41,212.6L84.41,212.6L85.38,211.92L85.38,211.92L93.03,207.35L103.16,197.35L104.89,190.8L102.67,185.99L105.75,183.64L107.85,176.11L113.9,169.94L118.22,168.33L119.7,165.98L124.15,163.89L123.78,162.65L126.04,159.23L126.04,159.23L127.85,159.02L127.85,159.02L137.73,158.03L140.94,159.02L140.94,159.02L142.5,159.26L142.5,159.26L153.73,167.75L160.64,170.72L167.72,170.72L175.13,174.67L177.93,174.01L180.73,175L185.67,180.76L186,182.74L187.97,183.56L188.63,184.88L186.98,187.51L193.73,192.28L198.34,198.38L200.48,199.36L202.46,199.03L202.95,190.47L205.75,187.67L209.87,186.03L213,178.46L213,178.46L212.86,176.22L212.86,176.22L225.41,177.14L230.68,176.31L235.29,179.28L235.29,179.28L235.87,179.79L235.87,179.79L237.76,181.25L237.59,184.55L244.01,187.02L249.61,193.27L254.05,195.08L253.89,198.54L256.03,203.81L256.03,203.81z"
				},
				{
					"id":"VE-F",
					"title":"Bolívar",
					"d":"M387.3,370.32L387.71,361.62L386.4,359.97L385.9,354.87L380.97,353.39L379.15,354.38L371.75,350.43L361.54,334.46L358.41,323.76L364.5,322.44L365.49,319.31L362.53,317.17L362.36,315.03L364.01,314.37L364.34,312.07L358.58,305.98L360.72,303.01L360.22,301.7L351.5,300.54L347.38,304.66L344.91,304.66L342.61,301.7L342.44,296.92L344.42,288.2L343.43,286.22L340.3,285.4L333.88,287.21L331.25,293.3L326.31,299.39L323.18,300.87L319.89,300.71L314.95,302.85L312.97,294.95L310.34,295.28L303.75,301.53L298.98,304L287.46,304.66L282.35,306.47L280.05,306.14L278.4,304.33L274.12,304.66L273.96,295.11L275.27,294.45L274.29,287.87L262.15,284.41L262.15,284.41L262.3,282.97L262.3,282.97L269.1,278.09L269.92,275.78L272.89,274.3L274.2,272L274.37,267.39L276.67,260.8L278.98,258L279.47,249.94L275.69,246.97L277.83,241.38L282.44,239.4L285.4,239.56L292.97,234.63L299.72,232.82L307.46,220.8L312.03,218.41L312.03,218.41L312.83,219.28L312.83,219.28L315.95,219.61L320.23,215.83L326.98,217.8L331.76,216.48L337.68,209.41L344.27,207.1L349.87,209.57L351.72,208.77L351.72,208.77L351.73,208.78L351.73,208.78L365.93,212.48L373.59,218.16L377.17,218.41L386.06,213.72L390.25,213.47L391,211L388.53,209.27L387.91,205.69L391.98,202.24L396.43,203.1L402.6,200.01L404.7,200.14L410.38,205.32L415.81,205.94L419.52,203.59L424.58,197.42L430.63,195.44L435.82,196.06L449.77,186.93L451.5,187.79L454.71,186.93L464.83,189.77L469.4,185.32L472.46,184.63L472.46,184.63L472.45,184.92L472.45,184.92L473.93,184.92L476.89,181.96L476.89,181.96L477.76,181.65L478.2,185.81L478.2,185.81L483.39,192.36L490.8,192.36L497.22,196.06L500.3,201.74L504.63,203.47L507.96,201.12L514.75,201L519.94,209.77L519.94,209.77L524.88,211.99L524.88,211.99L531.42,213.84L533.27,211.74L539.69,209.64L544.63,205.94L547.72,206.43L549.08,210.26L551.67,211.99L555.13,211L558.71,208.04L561.18,208.9L564.51,207.05L578.13,206.8L578.13,206.8L574.94,209.44L568.3,209.73L566.66,211.37L565.01,218.8L559.66,221.22L559.36,223.2L560.62,227.03L564.9,232.21L562.95,235.24L566.45,238.31L575.87,238.03L579.75,242.09L578.85,243.97L569.19,251.95L562.02,253.66L559.61,256.96L551.41,255.36L549.81,257.58L546.13,258.62L537.25,256.56L541.2,268.51L541.34,278.79L542.52,278.72L542.52,281.64L535.58,287.4L534.67,289.9L529.47,292.36L564.23,331.51L565.23,336.93L560.16,342.64L551.86,348.13L550.88,352.07L548.84,354.47L543.91,355.44L534.05,354.47L533.63,359.26L526.06,360.09L524.95,361.27L525.02,365.02L523.35,366.83L516.41,366.83L510.85,371.62L502.35,371.69L496.41,374.25L484.02,370.72L478.04,377.66L470.49,377.67L468.32,380.39L471.65,390.19L469.32,394.96L466.17,397.28L462.11,396.67L445.01,379.18L441.09,379.36L439.5,383.8L437.62,384.15L432.52,380.04L429.02,380.04L427.55,381.3L421.23,380.12L415.07,384.03L413.04,382.65L411.83,377.18L408.13,373.94L399.48,372.58L390.44,373.57z"
				},
				{
					"id":"VE-G",
					"title":"Carabobo",
					"d":"M247.21,92.61L243.71,95.68L243.58,97.41L246.42,99.51L253.21,100L254.33,103.09L252.72,113.71L257.78,114.2L260.12,115.74L260.12,115.74L259.76,117.9L259.76,117.9L253.21,121.86L251.49,121.73L247.9,117.9L246.42,118.03L245.44,120.25L245.44,120.25L245.44,121.61L245.44,121.61L240.87,121.86L228.03,115.81L227.78,112.6L229.75,110.37L228.4,108.4L222.96,113.34L222.96,113.34L221.85,113.09L221.85,113.09L220.62,106.55L222.96,101.85L220.49,98.52L221.48,90.62L228.94,90.12L228.94,90.12L231.89,93.12L241.54,94.01z"
				},
				{
					"id":"VE-H",
					"title":"Cojedes",
					"d":"M245.44,120.5L248.62,123.96L249.61,127.09L247.63,129.89L240.22,133.51L242.04,145.86L244.34,149.81L244.34,158.54L236.44,169.07L237.76,171.21L237.92,178.29L236.44,178.78L236.6,180.43L236.6,180.43L235.29,179.28L235.29,179.28L230.68,176.31L225.41,177.14L212.86,176.22L212.86,176.22L212.83,175.66L212.83,175.66L209.37,173.52L207.56,169.89L204.27,168.41L211.35,164.46L209.04,158.21L211.35,154.58L208.22,151.79L207.73,148.16L200.32,143.06L200.15,139.77L193.86,124.06L193.86,124.06L194.28,123.58L194.28,123.58L196.75,119.26L196.95,114.02L196.95,114.02L198.27,113.83L198.27,113.83L200.99,112.97L206.42,117.04L211.48,114.08L214.07,113.95L215.18,118.15L219.38,116.55L222.46,113.23L222.46,113.23L222.96,113.34L222.96,113.34L228.4,108.4L229.75,110.37L227.78,112.6L228.03,115.81L240.87,121.86L245.44,121.61L245.44,121.61z"
				},
				{
					"id":"VE-I",
					"title":"Falcón",
					"d":"M200.37,86.35L197.71,83.63L190.43,85.6L182.4,83.26L173.39,84.25L164.87,80.42L160.55,83.51L157.34,83.14L157.83,81.78L134.25,90.91L127.46,91.28L117.95,94.12L117.95,94.12L115.11,93.88L115.11,93.88L109.8,93.75L105.85,91.65L100.79,84L101.9,80.17L101.16,78.94L92.49,70.23L92.49,70.23L103.05,63.93L112.77,59.86L126.77,58.21L141.72,52.26L144.93,49.21L148.47,48.88L148.66,46.5L151.87,46.5L155.14,49.63L161.18,49.04L161.86,45.15L158.98,38.89L155.54,38.44L141.29,42.29L140.32,41.11L141.19,34.69L138.23,31.48L137.66,27.72L140.36,22.14L142.06,19.43L146.23,16.73L153.23,15.88L157.12,20.61L159.83,32.8L165.58,46L168.96,47.86L174.72,46L177.5,47.23L181.27,45.41L191.81,48.87L200.32,49.31L218.27,59.75L225.56,68.89L225.56,71.6L224.13,73.24L225.82,74.93L223.94,79.67L228.02,88.72L228.02,88.72L215.06,88.89L211.11,86.05L210.74,82.59L204.2,83.46L201.48,86.05L201.48,86.05z"
				},
				{
					"id":"VE-J",
					"title":"Guárico",
					"d":"M351.72,208.77L349.87,209.57L344.27,207.1L337.68,209.41L331.76,216.48L326.98,217.8L320.23,215.83L315.95,219.61L312.83,219.28L312.83,219.28L311.18,217.47L311.18,217.47L310.36,215.33L307.39,215L303.44,212.04L297.35,213.52L295.38,217.31L283.03,213.19L272.66,212.53L258.17,206.28L258.17,206.28L256.03,203.81L256.03,203.81L253.89,198.54L254.05,195.08L249.61,193.27L244.01,187.02L237.59,184.55L237.76,181.25L235.87,179.79L235.87,179.79L236.6,180.43L236.6,180.43L236.44,178.78L237.92,178.29L237.76,171.21L236.44,169.07L244.34,158.54L244.34,149.81L242.04,145.86L240.22,133.51L247.63,129.89L249.61,127.09L248.62,123.96L245.44,120.5L245.44,120.5L245.44,120.25L245.44,120.25L246.42,118.03L247.9,117.9L251.49,121.73L253.21,121.86L259.76,117.9L259.76,117.9L260.13,115.68L260.13,115.68L265.07,115.19L270.99,118.03L274.33,118.03L281.74,124.82L284.82,126.18L288.16,129.51L288.16,131.86L286.55,134.33L282.23,135.56L282.85,138.65L296.43,145.07L301.24,138.15L300.13,132.84L301.37,131.61L301,129.51L297.54,125.81L300.38,122.47L299.15,115.06L299.15,115.06L302.68,114.94L302.68,114.94L310.21,111.98L314.65,115.19L322.06,114.82L326.14,115.93L332.56,114.82L338.48,116.78L338.48,116.78L338.35,117.29L338.35,117.29L340.25,122.84L339.75,129.63L341.36,130.38L341.36,133.09L349.14,133.09L350.99,131.49L356.05,136.06L361.24,138.4L361.49,139.88L357.41,142.1L356.79,143.83L359.26,147.78L362.6,151.12L369.51,153.59L371.73,155.81L371.73,158.28L379.14,162.6L380.01,164.58L376.92,171.86L374.45,171.86L372.6,169.64L364.94,169.76L363.58,171L362.6,174.45L363.58,177.79L361.49,185.2L349.14,201L348.03,205.45L350.25,207.67L350.25,207.67z"
				},
				{
					"id":"VE-K",
					"title":"Lara",
					"d":"M196.95,114.02L196.75,119.26L194.28,123.58L194.28,123.58L193.29,124.7L193.29,124.7L189.47,127.54L185.64,128.4L183.17,127.17L183.29,121.86L181.81,120.5L176.5,128.52L177.98,131.24L176.38,131.61L174.9,129.26L173.78,129.63L174.9,133.46L171.32,131.12L169.96,131.49L171.07,134.33L169.22,132.97L166.87,133.46L164.9,140.75L160.33,140.01L159.22,140.99L156.13,138.77L158.72,135.31L158.84,132.6L156,134.2L152.92,134.08L149.95,136.8L149.95,136.8L149.21,138.9L149.21,138.9L144.89,133.59L144.89,131.61L146.5,128.77L151.07,128.03L150.33,126.55L141.81,121.98L137.11,121.73L133.29,118.77L129.95,119.76L126.74,118.65L126.74,115.81L122.54,112.1L120.94,112.84L120.2,117.04L119.07,117.34L119.07,117.34L119.1,117.14L119.1,117.14L112.06,114.55L109.35,111.46L110.09,109.85L118.48,104.67L119.35,100.47L116.51,99.24L115.22,93.89L115.22,93.89L117.95,94.12L117.95,94.12L127.46,91.28L134.25,90.91L157.83,81.78L157.34,83.14L160.55,83.51L164.87,80.42L173.39,84.25L182.4,83.26L190.43,85.6L197.71,83.63L200.37,86.35L200.37,86.35L200.12,86.42L200.12,86.42L197.53,89.26L193.58,90.12L190.98,92.47L190.61,94.82L192.71,98.15L193.82,103.95L188.89,104.08L187.53,106.92L184.32,109.14L188.14,113.46L187.53,117.9L190,119.63L191.11,120L192.22,116.3L194.44,113.95L196.54,114.08L196.54,114.08z"
				},
				{
					"id":"VE-L",
					"title":"Mérida",
					"d":"M126.04,159.23L123.78,162.65L124.15,163.89L119.7,165.98L118.22,168.33L113.9,169.94L107.85,176.11L105.75,183.64L102.67,185.99L104.89,190.8L103.16,197.35L93.03,207.35L85.38,211.92L85.38,211.92L84.14,212.78L84.14,212.78L81.55,210.31L80.69,202.16L73.9,201.05L69.08,196.48L64.27,195.37L64.39,193.52L69.08,188.33L69.33,182.04L70.44,180.8L67.64,174.62L67.64,174.62L68.65,174.28L68.65,174.28L73.71,175.39L74.58,171.81L78.16,170.33L94.7,157.12L93.39,152.23L93.39,152.23L95.45,149.64L97.48,149.71L97.48,149.71L104.27,154.4L108.59,152.55L108.59,152.55L109.96,152.66L109.96,152.66L114.77,154.82L120.2,160.38L121.93,157.79L125.75,159.27L125.75,159.27z"
				},
				{
					"id":"VE-M",
					"title":"Miranda",
					"d":"M338.48,116.78L332.56,114.82L326.14,115.93L322.06,114.82L314.65,115.19L310.21,111.98L302.68,114.94L302.68,114.94L298.97,115.06L298.97,115.06L285.76,114.08L283.29,111.61L277.98,109.39L277.12,106.42L278.23,103.71L275.27,99.51L275.09,95.29L275.09,95.29L276.21,94.75L276.21,94.75L278.25,96.67L282.82,96.67L289.49,92.84L289.74,90.15L289.74,90.15L291.84,90.37L291.84,90.37L295.17,89.14L309.74,90.12L311.1,89.75L311.6,86.61L311.6,86.61L313.45,85.19L315.8,85.37L318,87.66L322.34,88.23L320.72,90.45L321.61,92.88L335.38,104.12L350.94,107.6L350.94,107.6L344.52,113.95L341.06,116.05L338.72,115.93L338.72,115.93z"
				},
				{
					"id":"VE-N",
					"title":"Monagas",
					"d":"M486.56,126.63L484.04,131.08L484.04,131.08L482.06,133.05L482.72,135.36L482.72,135.36L484.04,139.14L483.88,145.73L487.17,148.2L487.66,154.62L494.9,156.43L498.03,154.95L498.03,154.95L499.18,155.11L499.84,157.42L499.84,157.42L500.01,163.67L498.2,169.76L491.12,176.84L486.34,179.64L480.09,180.46L480.09,180.46L476.89,181.96L476.89,181.96L473.93,184.92L472.45,184.92L472.45,184.92L472.57,182.33L472.57,182.33L456.89,176.04L456.15,171.47L458.74,171.59L460.6,169.86L460.1,168.63L447.26,169.86L443.19,161.34L428.86,149.86L424.54,147.88L419.48,149.24L415.9,140.23L421.33,135.29L421.33,133.81L419.97,129.36L417.13,126.52L416.64,124.55L418,121.95L415.53,117.76L412.2,115.66L411.95,113.68L412.44,112.08L417.11,109.48L417.11,109.48L418.01,109.48L418.01,109.48L423.94,107.14L426.41,104.54L432.21,104.42L437.64,100.59L446.53,105.66L453.08,106.52L460.36,111.21L463.57,111.95L474.19,111.46L475.67,108.62L475.38,105.14L475.38,105.14L479.02,104.93L481.07,107.13L483.99,118.04L486.77,122.11z"
				},
				{
					"id":"VE-O",
					"title":"Nueva Esparta",
					"d":"M418.72,81.5l-2.9,-0.29l-0.77,-1.16l1.16,-1.45l2.32,0.19L418.72,81.5zM408.68,79.56h-3.38l-0.77,-1.16l3.96,-0.87L408.68,79.56zM423.94,69.52l-1.45,2.41l-6.47,2.8l-4.63,0.1l-4.73,-2.99L405.98,73l-3.77,-0.1l-4.44,-2.12l0.1,-2.03l3.96,-1.83l3.67,0.19l3.57,2.9l2.7,0.29l2.99,-1.16l0.96,-2.9l3.77,-2.9l2.22,0.77L423.94,69.52z"
				},
				{
					"id":"VE-P",
					"title":"Portuguesa",
					"d":"M193.86,124.06L200.15,139.77L200.32,143.06L207.73,148.16L208.22,151.79L211.35,154.58L209.04,158.21L211.35,164.46L204.27,168.41L207.56,169.89L209.37,173.52L212.83,175.66L212.83,175.66L213,178.46L213,178.46L209.87,186.03L205.75,187.67L202.95,190.47L202.46,199.03L200.48,199.36L198.34,198.38L193.73,192.28L186.98,187.51L188.63,184.88L187.97,183.56L186,182.74L185.67,180.76L180.73,175L177.93,174.01L175.13,174.67L167.72,170.72L160.64,170.72L153.73,167.75L142.5,159.26L142.5,159.26L142.55,159.27L142.55,159.27L146.99,152.23L146.99,149.14L144.27,148.16L143.78,146.06L148.35,141.61L149.32,138.59L149.32,138.59L149.95,136.8L149.95,136.8L152.92,134.08L156,134.2L158.84,132.6L158.72,135.31L156.13,138.77L159.22,140.99L160.33,140.01L164.9,140.75L166.87,133.46L169.22,132.97L171.07,134.33L169.96,131.49L171.32,131.12L174.9,133.46L175.14,132.35L173.78,131.73L173.78,129.63L174.9,129.26L176.38,131.61L177.98,131.24L176.5,128.52L181.81,120.5L183.29,121.86L183.17,127.17L185.64,128.4L189.47,127.54L193.29,124.7L193.29,124.7z"
				},
				{
					"id":"VE-R",
					"title":"Sucre",
					"d":"M475.38,105.14L475.67,108.62L474.19,111.46L463.57,111.95L460.36,111.21L453.08,106.52L446.53,105.66L437.64,100.59L432.21,104.42L426.41,104.54L423.94,107.14L418.01,109.48L418.01,109.48L416.78,109.48L416.78,109.48L411.59,108.37L406.78,110.35L402.33,110.35L395.91,107.38L393.18,103.02L393.18,103.02L397.84,97.94L402.21,96.52L405.96,92.61L412.05,94.9L419.54,95.02L427.67,92.29L418.78,90.2L417.51,88.42L414.97,89.44L407.74,89.19L403.9,91.01L401.77,86.77L403.85,85.45L405.32,86.52L414.97,85.13L415.73,86.39L420.17,86.39L421.25,85.14L434.88,85.97L447.08,84.62L449.87,82.71L464.21,83.48L469.92,81.06L492.77,83.09L507.99,81.45L507.82,82.95L504.19,84.74L491.66,85.98L488.04,90.23L471.83,89.06L465.84,90.16L464.18,91.45L466.05,92.84L465.63,95.79L460.49,96.21L458.88,97.66L458.56,101.84L460.53,102.64L461.02,98.46L465.68,97.87L468.53,94.14L472.84,98.07L473.23,105.9z"
				},
				{
					"id":"VE-S",
					"title":"Táchira",
					"d":"M84.41,212.6L83.68,219.12L89.11,225.04L72.48,222.25L68.04,224.22L68.04,224.22L67.71,225.37L67.71,225.37L66.23,228.67L63.43,229.65L58,229.33L54.21,226.2L46.14,227.02L45.72,227.96L45.72,227.96L42.73,227.82L42.24,225.6L40.76,225.1L40.57,206.34L41.87,201.82L45.6,200.71L46.52,198.88L44.46,196.63L44.26,187.88L41.84,185.14L41.84,185.14L46.18,182.92L46.42,181.07L58.28,176.87L60.62,174.65L62.72,175.02L62.97,176.26L67.17,174.78L67.17,174.78L67.64,174.62L67.64,174.62L70.44,180.8L69.33,182.04L69.08,188.33L64.39,193.52L64.27,195.37L69.08,196.48L73.9,201.05L80.69,202.16L81.55,210.31L84.14,212.78L84.14,212.78z"
				},
				{
					"id":"VE-T",
					"title":"Trujillo",
					"d":"M149.32,138.59L148.35,141.61L143.78,146.06L144.27,148.16L146.99,149.14L146.99,152.23L142.55,159.27L142.55,159.27L140.94,159.02L140.94,159.02L137.73,158.03L127.85,159.02L127.85,159.02L125.75,159.27L125.75,159.27L121.93,157.79L120.2,160.38L114.77,154.82L109.96,152.66L109.96,152.66L110.2,152.67L110.2,152.67L110.69,150.33L108.22,145.02L102.47,143.56L102.47,143.56L103.39,130.1L103.39,130.1L108.85,131.83L113.91,130.23L116.75,124.55L120.09,123.19L118.85,118.62L118.85,118.62L119.07,117.34L119.07,117.34L120.2,117.04L120.94,112.84L122.54,112.1L126.74,115.81L126.74,118.65L129.95,119.76L133.29,118.77L137.11,121.73L141.81,121.98L150.33,126.55L151.07,128.03L146.5,128.77L144.89,131.61L144.89,133.59L149.21,138.9L149.21,138.9z"
				},
				{
					"id":"VE-U",
					"title":"Yaracuy",
					"d":"M228.02,88.72L228.94,90.12L228.94,90.12L221.48,90.62L220.49,98.52L222.96,101.85L220.62,106.55L221.85,113.09L221.85,113.09L222.46,113.23L222.46,113.23L219.38,116.55L215.18,118.15L214.07,113.95L211.48,114.08L206.42,117.04L200.99,112.97L198.27,113.83L198.27,113.83L196.54,114.08L196.54,114.08L194.44,113.95L192.22,116.3L191.11,120L190,119.63L187.53,117.9L188.14,113.46L184.32,109.14L187.53,106.92L188.89,104.08L193.82,103.95L192.71,98.15L190.61,94.82L190.98,92.47L193.58,90.12L197.53,89.26L200.12,86.42L200.12,86.42L201.48,86.05L201.48,86.05L204.2,83.46L210.74,82.59L211.11,86.05L215.06,88.89z"
				},
				{
					"id":"VE-V",
					"title":"Zulia",
					"d":"M102.47,143.56l5.76,1.46l2.47,5.31l-0.49,2.35l0,0l-1.61,-0.12l0,0l-4.32,1.85l-6.79,-4.69l0,0l0.35,-3.49L102.47,143.56zM92.49,70.23l8.66,8.71l0.74,1.23L100.79,84l5.06,7.66l3.95,2.1l5.31,0.12l0,0l0.11,0.01l0,0l1.28,5.35l2.84,1.23l-0.86,4.2l-8.4,5.19l-0.74,1.6l2.72,3.09l7.04,2.59l0,0l-0.25,1.48l0,0l1.23,4.57l-3.33,1.36l-2.84,5.68l-5.06,1.61l-5.46,-1.74l0,0l0.85,-2.54l-2.03,-7.45l-3.67,-3.97l-2.09,-0.38l-0.99,-6.42l-4.4,-3.98l-5.29,-7.88l-0.82,-3.08l1.18,-1.02l-0.17,-2.03l-3.89,-2.2l1.18,-3.05l-1.63,-8.52l4.69,0.25l1.5,-3.74l-1.38,-3.42l3.09,0.12l0.83,3.63l1.86,-0.51L92.49,70.23zM77.67,39.4l-8.68,0.93l-3.34,1.95l-2.2,4.74l0.89,6.25l1.48,0.62l3.09,6.91l3.68,4.84l5.58,1.69l-0.68,1.52l-4.57,-0.85l-0.56,1.19l2.72,1.98l1.91,7.66l3.65,2.96l-0.74,6.79l-3.5,5.65l-6.43,5.39l-2.41,7.61l-5.11,2.24l-0.68,3.38l-6.42,9.22l7.05,9.6l0.1,4.7l2.33,0.15l7.85,5.25l0.06,3.55l-2.5,0.54l-0.51,1.86l2.53,1.01l1.24,6.29l7.16,1.65l12.75,-4.4l0,0l1.31,4.89l-16.54,13.21l-3.58,1.48l-0.86,3.58l-5.06,-1.11l0,0l-1.48,0.49l0,0l-4.2,1.48l-0.25,-1.23l-2.1,-0.37l-2.35,2.22l-11.85,4.2l-0.25,1.85l-4.34,2.22l0,0l-9.23,-10.61l-5.8,-22.47l-7.29,0.25l-3.26,-7.28l-9.36,5.82L0,150.83l0.63,-2.42l3.34,-2.77l0.12,-3.83l9.01,-10.46l5.19,-9.41l-0.59,-8.07l2.69,-5.27L21.5,95.8l2.84,-6.17l5.43,-6.67l-0.02,-3.4l7.55,-10.68l0.77,-2.92l1.69,-1.69l7.95,-1.02l12.52,-22l12.67,-4.84l12.59,-2.47l5.21,-2.83l1.51,1.35l-0.68,2.37l-2.71,1.35L77.67,39.4z"
				},
				{
					"id":"VE-W",
					"title":"Dependencias Federales",
					"d":"M357.54,69.27l3.48,1.42l1.29,2.45l-1.16,1.8l-5.41,0.77l-3.86,-1.16l-0.26,-3.73l4.89,-2.19L357.54,69.27zM456.93,53.34l-1.54,1.89l-1.2,-1.2l0.52,-3.26l2.92,0.17l0.51,1.89L456.93,53.34zM398.89,36.11l-1.18,2.64l-0.69,-3.09L398.89,36.11zM319.88,35.66l-4.63,-2.57l1.42,-1.54l3.6,-0.39l1.54,-2.32l1.54,0.77l0.77,4.12L319.88,35.66zM389.27,34.5h-1.93l-1.93,-1.8l2.19,-3.73l2.58,-0.13l0.9,1.16l0.26,2.96L389.27,34.5zM301.47,27.68l0.64,5.41l-2.19,2.96l-4.38,0.52l-6.95,-1.93l8.88,-1.29l1.67,-2.83l-1.93,-2.7l-1.8,3.99l-3.86,-0.13l-2.83,-2.45l0.77,-2.32l9.27,-2.06L301.47,27.68zM265.03,26.78l-3.22,-0.26v-1.42l1.54,-0.26l-1.93,-2.06l1.54,-1.67l2.96,3.22L265.03,26.78zM256.41,21.37l-0.26,3.86l-3.86,0.64L251,23.3l2.32,-2.06l-4.38,-2.19l2.96,-0.77L256.41,21.37z"
				},
				{
					"id":"VE-X",
					"title":"Vargas",
					"d":"M311.6,86.61L311.1,89.75L309.74,90.12L295.17,89.14L291.84,90.37L291.84,90.37L289.49,90.12L289.49,90.12L280.72,89.38L276.77,94.07L276.77,94.07L275.04,95.31L275.04,95.31L272.82,95.93L270.97,94.69L267.51,96.79L265.69,90.5L265.69,90.5L272,90.07L281.68,86.72L292.88,85.51z"
				},
				{
					"id":"VE-Y",
					"title":"Delta Amacuro",
					"d":"M545.11,178.26l-2.62,-0.39l0.39,-1.96l2.22,-0.13V178.26zM540.92,177.21l-1.7,0.13l-0.26,-1.7l2.62,-0.65L540.92,177.21zM560.94,171.97l-0.65,2.22l-1.96,0.52l-0.79,-0.92v-1.31L560.94,171.97zM558.85,171.32l-1.18,-0.79l1.05,-0.92l1.05,1.05L558.85,171.32zM549.95,168.7l-3.53,4.45l-5.63,1.31l0.13,-1.96l3.01,-0.26l0.39,-1.18l-1.18,-1.57l-3.53,2.09l1.7,-3.01l7.98,-2.09l1.18,0.39L549.95,168.7zM554.27,166.61l-1.83,1.18l-0.39,-1.7L554.27,166.61zM557.15,168.57l-4.06,4.19l-2.49,0.52l2.75,-4.45l2.88,-0.13l3.27,-3.14l0.39,1.05L557.15,168.57zM549.29,164.91l-1.96,-0.26l-1.05,-2.49l4.45,-4.19l2.09,0.39l-0.26,2.75L549.29,164.91zM555.58,158.1l-3.27,-1.31l1.05,-1.05l3.27,1.7L555.58,158.1zM543.8,163.08h-1.7l1.7,-3.27l6.28,-4.84v2.22L543.8,163.08zM552.3,153.52l-2.09,0.39l-0.39,-1.05l1.83,-2.62l1.83,1.57L552.3,153.52zM558.32,152.34l1.57,0.92l-0.52,2.09l-4.58,-2.88l1.31,-3.66l1.7,0.52l-1.05,1.05L558.32,152.34zM549.98,148.66l-1.66,0.96l-0.8,-1.19l2.82,-3.81l-0.99,-5.34l1.48,-1.87l4.02,3.05l1.23,3.21L549.98,148.66zM536.73,130.36l-0.45,1.12l-1.24,-0.25l-1.46,-2.31l0.52,-0.65L536.73,130.36zM510.55,125.64l1.02,-0.7l-1.23,-1.98l1.49,-1.49l9.6,2.88l-2.52,-3.21l0.96,-2.46l5.09,3.64l6.8,8.41l15.64,3.18l2.29,10.32l-0.79,1.96l-1.86,0.86l-1.44,3.77l-8.42,2.64l-0.71,1.43l1.14,0.71l3.78,-1.71l0.34,1.15l5.73,-3.36l-2.01,5.35l-4.42,3.98l-1.21,3.43l1.71,1.71l-3.78,6.07l-1.36,4.71l0.71,1.07l8.95,4.03l2.4,-5.1l2.14,0.93l8.8,-1.84l3.92,2.37l7.13,1.02l0.86,-1.33l5.43,-0.93l-3.78,-0.86l0.02,-1.02l7.63,-0.26l8.49,2.29l6.5,4.57l4.43,6.07v2l-1.5,1.78l-2.36,-0.14l-4.93,3.14l-0.69,5.5l-1.18,0.99l-3.85,0.38l-7.38,5.23l0,0l-13.62,0.25l-3.33,1.85l-2.47,-0.86l-3.58,2.96l-3.46,0.99l-2.59,-1.73l-1.36,-3.83l-3.09,-0.49l-4.94,3.7l-6.42,2.1l-1.85,2.1l-6.54,-1.85l0,0l-4.94,-2.22l0,0l-5.19,-8.77l-6.79,0.12l-3.33,2.35l-4.32,-1.73l-3.09,-5.68l-6.42,-3.7h-7.41l-5.19,-6.54l0,0l-0.91,-4.2l2.8,-1.15l0,0l6.26,-0.82l4.77,-2.8l7.08,-7.08l1.81,-6.09l-0.16,-6.26l0,0l-0.66,-2.3l-1.15,-0.16l0,0l-3.13,1.48l-7.24,-1.81l-0.49,-6.42l-3.29,-2.47l0.16,-6.59l-1.32,-3.79l0,0l-0.66,-2.31l1.98,-1.98l0,0l2.52,-4.45l0,0l1.71,0.67l2.09,-10.81l4.66,-2.78l4.18,1.12L510.55,125.64z"
				},
				{
					"id":"VE-Z",
					"title":"Amazonas",
					"d":"M387.3,370.32L382.32,366.99L378.97,367.7L378.88,370.09L380.53,372.55L382.8,373.03L386.62,380.88L394.59,388.73L405.07,395.24L406.92,398.48L406.65,402L405.35,403.2L405.63,418.39L410.5,423.77L415.94,434.02L416.06,440.31L414.21,443.77L415.32,446.98L423.84,449.45L432.79,448.17L442.34,448.81L445.2,455.38L442.61,459.95L434.39,461.55L426.06,467.48L420.38,467.6L415.81,469.58L413.47,474.27L412.36,484.64L404.58,491.31L401.74,491.31L401.37,489.58L398.4,489.58L384.45,500.42L378.12,498.89L370.75,504.74L363.66,506.87L362.23,514.87L355.68,515.85L352.68,519.12L351.24,525.73L348.89,526.59L345.45,525.81L348.77,520.54L348.89,515.24L347.04,512.77L343.46,512.15L338.03,512.52L331.85,515.61L327.28,520.92L321.48,523.14L312.22,522.77L287.29,501.24L287.4,496.34L285.8,495.73L284.93,485.6L282.96,483.63L277.63,469.36L277.09,463.53L275.49,462.54L273.64,458.09L273.14,455.38L274.87,452.54L273.27,450.02L269.34,447.98L267.59,444.88L260.32,438.56L257.24,438.46L256.87,435.5L254.4,432.66L243.53,431.18L261.68,415.25L264.89,414.75L264.52,411.79L270.33,406.98L270.08,404.01L263.54,400.18L263.04,393.76L261.31,391.91L255.27,390.77L253.29,383.89L252.05,383.22L252.18,380.87L254.28,379.15L253.29,376.92L247.02,372.04L246.19,367.36L247.24,362.11L246.5,359.27L244.4,357.91L243.83,354.67L243.9,351.73L245.51,349.39L245.63,335.68L247.48,331.36L245.53,331.23L245.12,329.56L245.51,321.48L253.04,315.93L254.65,313.46L255.02,302.17L262.67,292.3L264.89,291.93L264.65,288.71L263.04,288.47L262.15,284.41L262.15,284.41L274.29,287.87L275.27,294.45L273.96,295.11L274.12,304.66L278.4,304.33L280.05,306.14L282.35,306.47L287.46,304.66L298.98,304L303.75,301.53L310.34,295.28L312.97,294.95L314.95,302.85L319.89,300.71L323.18,300.87L326.31,299.39L331.25,293.3L333.88,287.21L340.3,285.4L343.43,286.22L344.42,288.2L342.44,296.92L342.61,301.7L344.91,304.66L347.38,304.66L351.5,300.54L360.22,301.7L360.72,303.01L358.58,305.98L364.34,312.07L364.01,314.37L362.36,315.03L362.53,317.17L365.49,319.31L364.5,322.44L358.41,323.76L361.54,334.46L371.75,350.43L379.15,354.38L380.97,353.39L385.9,354.87L386.4,359.97L387.71,361.62z"
				}
			]
		}
	}
};
