﻿// (c) ammap.com | SVG (in JSON format) map of Palestine High
// areas: {id:"PS-JRH"},{id:"PS-JEN"},{id:"PS-TKM"},{id:"PS-TBS"},{id:"PS-NBS"},{id:"PS-QQA"},{id:"PS-SLT"},{id:"PS-RBH"},{id:"PS-JEM"},{id:"PS-BTH"},{id:"PS-HBN"},{id:"PS-NGZ"},{id:"PS-GZA"},{id:"PS-DEB"},{id:"PS-KYS"},{id:"PS-RFH"},{id:"IL"}
AmCharts.maps.palestineHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"34.228663",
				"topLatitude":"33.434207",
				"rightLongitude":"35.935383",
				"bottomLatitude":"29.496766"
			}
		},
		"g":{
			"path":[
				{
					"id":"PS-JRH",
					"title":"Jericho",
					"d":"M223.99,276.82L223.5,277.8L223.87,286.52L225.77,288.7L226.05,290.08L224.44,292.42L227.32,298.76L226.23,305.98L223.12,308.97L224.8,317.49L227.8,319.39L226.12,322.72L227.91,325.59L226.56,329.42L228.68,341.21L224.51,348.68L224.51,348.68L217.87,342.64L216.94,341.15L216.56,338.42L214.18,336.92L213.53,336.73L211.83,336.66L209.29,336.98L208.02,337.34L205.57,338.41L204.37,338.57L203.2,338.24L200.31,336.52L199.73,335.77L199.62,335.28L199.95,334.41L200.6,333.6L200.67,333L200.24,332.05L199.64,331.39L198.32,331L197.84,330.51L197.61,329.53L197.4,325.28L197.4,325.28L200.6,325.92L202.89,326.08L203.73,325.31L204.06,324.52L204.22,323.52L204.24,322.47L203.53,319.58L203.93,316.08L204.24,315.29L205.5,313.4L205.78,312.6L205.76,312.09L205.7,311.6L204.26,308.94L204.06,308.24L204,307.73L204.26,305.18L204.12,304.18L203.47,302.85L203.31,302.24L203.45,301.75L204.76,300.66L205.94,298.21L206.19,297.41L206.21,296.5L206.07,296.08L205.76,295.78L203.53,294.98L200.76,292.46L200.58,291.9L200.62,291.53L200.96,291.22L201.4,291.13L203.21,291.2L204.38,290.73L204.58,290.31L204.62,289.8L204.26,289.12L203.69,288.47L203.3,288.22L203.3,288.22L203.39,288.21L203,287.57L202.47,285.94L202.31,285.16L202.39,282.69L202.31,281.5L202.05,280.62L201,278.4L200.95,277.71L201.24,276.56L201.94,275.21L202.59,274.69L203.87,274.35L205.83,274.22L208.23,273.63L209.23,273.11L209.53,272.3L209.42,271.46L208.27,269.49L207.94,268.34L208.59,264.9L208.55,263.85L208.18,262.27L208.08,261.04L208.29,259.67L209.02,257.41L208.95,256.06L208.64,255.37L208.31,255.01L207.71,254.8L206.81,254.81L205.49,255.23L205.02,255.24L204.8,255.13L204.59,254.81L204.58,254.21L205.08,253.34L206.64,251.99L207.86,250.36L210.32,244.44L210.32,244.44L213.74,246.22L214.85,247.15L216.94,250.45L218.22,254.42L218.95,255.44L219.51,255.79L220.01,255.84L220.56,255.58L222.75,253.6L223.78,252.91L224.22,252.77L228.58,252.67L231.66,252.42L231.66,252.42L230.17,255.37L229.06,260.42L228.57,265.82L227.91,268.08L225.48,271.37L224.92,274.96z"
				},
				{
					"id":"PS-JEN",
					"title":"Jenin",
					"d":"M209.45,209.32L208.71,209.77L207.39,212.04L206.74,212.42L205.31,212.89L204.6,213.69L203.08,214.57L201.99,216.31L201.61,216.57L201,216.67L200.59,216.59L199.27,215.82L198.62,215.73L197.79,216.15L196.74,217.28L196.05,217.73L193.76,218.05L193.18,218.28L192.94,218.55L192.73,219.12L192.59,221L191.75,223.27L191.82,224.38L192.13,226.01L192.08,227.31L191.7,228.23L190.58,229.99L189.82,231.99L189.82,231.99L187.11,230.4L185.77,229.28L183.85,227.28L183.51,227.09L183.04,227.18L182.21,228.62L181.6,229.23L180.83,229.57L179.77,229.68L177.61,229.6L175.32,228.95L173.48,229.04L171.88,228.15L170.98,227.97L169.09,228.01L166.88,228.61L165.64,228.74L164.71,228.46L164.29,228.18L163.97,227.79L163.79,227.21L163.79,227.21L164.14,224.53L163.98,223.54L163.76,223.16L162.11,222.44L160.34,221.41L158.65,220.78L156.99,218.9L156.39,218.66L154.81,218.37L154.47,218.01L154.43,217.75L154.89,215.99L154.89,214.33L155.27,213.05L155.11,210.82L155.2,209.17L156.21,206.75L156.21,206.31L155.97,205.75L155.64,205.41L155.05,205.18L154.11,205.1L152.67,205.19L151.47,205.6L149.66,206.83L148.68,207.21L148.09,207.1L147.34,206.29L147.14,205.72L147.21,205.25L147.45,204.84L147.84,204.55L149.7,203.91L150.56,203.26L151.07,202.25L151.18,201.17L151.04,200.09L150.81,199.56L150.06,198.71L149.07,198.29L147.96,198.17L147.46,198.24L147.46,198.24L148.48,196.31L149.79,195.32L156.72,192.7L161.02,190.51L164.41,188.04L166.48,186.04L167.08,184.8L170.24,181.22L171.16,180.76L172.83,180.51L175.21,181.81L178.29,185L180.93,186.94L183.64,188.28L185.01,188.64L187.02,188.65L195.45,187.1L198.76,187.16L200.22,187.52L203.01,189.6L205.81,194.34L206.35,198.7L206.14,202.76L207.14,205.7L208.36,207.28L208.31,208.31z"
				},
				{
					"id":"PS-TKM",
					"title":"Tulkarm",
					"d":"M162.56,241.55L159.76,242.09L156.9,242.99L155.16,243.23L154.26,244.05L153.28,245.36L151.82,246.84L151.68,247.66L151.33,248.48L149.1,249.21L148.06,250.61L147.36,250.85L145.76,250.77L142.07,248.31L140.88,246.59L140.12,245.94L138.72,243.81L134.13,237.77L134.13,237.77L134.49,237.51L135.06,236.01L134.25,230.2L134.44,224.73L136.27,221.29L137.42,219.84L141.9,217.83L143.1,216.66L143.81,211.51L145.31,207.35L146.12,202.14L146.88,199.31L147.46,198.24L147.46,198.24L147.96,198.17L149.07,198.29L150.06,198.71L150.81,199.56L151.04,200.09L151.18,201.17L151.07,202.25L150.56,203.26L149.7,203.91L147.84,204.55L147.45,204.84L147.21,205.25L147.14,205.72L147.34,206.29L148.09,207.1L148.68,207.21L149.66,206.83L151.47,205.6L152.67,205.19L154.11,205.1L155.05,205.18L155.64,205.41L155.97,205.75L156.21,206.31L156.21,206.75L155.2,209.17L155.11,210.82L155.27,213.05L154.89,214.33L154.89,215.99L154.43,217.75L154.47,218.01L154.81,218.37L156.39,218.66L156.99,218.9L158.65,220.78L160.34,221.41L162.11,222.44L163.76,223.16L163.98,223.54L164.14,224.53L163.79,227.21L163.79,227.21L161.99,226.57L160.75,225.8L158.92,225.12L158.87,227.12L159.17,228.68L159.63,229.28L161.79,230.6L162.17,230.98L162.66,232L162.79,233.62L162.64,234.64L162.29,235.25L160.85,236.03L160.51,236.62L160.41,237.58L160.63,238.44L161.8,239.64z"
				},
				{
					"id":"PS-TBS",
					"title":"Tubas",
					"d":"M229.37,213.27L229.04,216.92L230.31,218.5L230.73,219.69L230.24,222.73L229.69,224.15L229.57,225.78L230.91,229.41L230.07,231.76L230.03,233.21L231.21,236.14L230.59,240.62L231.26,243.53L231.43,246.77L231.9,248.38L232.08,250.7L231.66,252.42L231.66,252.42L228.58,252.67L224.22,252.77L223.78,252.91L222.75,253.6L220.56,255.58L220.01,255.84L219.51,255.79L218.95,255.44L218.22,254.42L216.94,250.45L214.85,247.15L213.74,246.22L210.32,244.44L210.32,244.44L209.83,243.05L209.18,240.48L208.45,238.46L207.93,237.38L207.36,236.77L206.23,236.44L204.56,236.4L202.39,237.41L200.07,237.84L198,238.61L196.84,238.57L196.21,238.1L195.43,236.64L194.8,235.84L194.18,235.42L192.08,234.38L190.63,233.01L189.82,231.99L189.82,231.99L190.58,229.99L191.7,228.23L192.08,227.31L192.13,226.01L191.82,224.38L191.75,223.27L192.59,221L192.73,219.12L192.94,218.55L193.18,218.28L193.76,218.05L196.05,217.73L196.74,217.28L197.79,216.15L198.62,215.73L199.27,215.82L200.59,216.59L201,216.67L201.61,216.57L201.99,216.31L203.08,214.57L204.6,213.69L205.31,212.89L206.74,212.42L207.39,212.04L208.71,209.77L209.45,209.32L209.45,209.32L211.63,209.67L214.21,208.92L218.13,209.09L220.29,209.75L225.37,212.12z"
				},
				{
					"id":"PS-NBS",
					"title":"Nablus",
					"d":"M166.81,280.84L169.67,277.29L171.27,275.8L175.2,273.69L177.77,273.31L178.46,273.03L178.87,272.7L179.36,271.95L179.62,271.11L179.66,269.51L179.54,269.01L178.91,267.97L177.72,267.05L176.79,266.69L174.96,266.37L173.34,265.68L172.44,265.54L171.52,265.61L171.09,265.75L169.77,266.54L169.06,266.72L167.7,266.61L166.3,266.04L165.64,265.48L165,264.62L164.46,263.48L163.41,260.53L163.04,259.96L162.37,259.41L162.37,259.41L162.72,258.11L164.04,255.84L164.87,253.52L165.58,249.5L165.68,248.19L165.53,246.21L164.41,243.3L163.69,242.41L162.56,241.55L162.56,241.55L161.8,239.64L160.63,238.44L160.41,237.58L160.51,236.62L160.85,236.03L162.29,235.25L162.64,234.64L162.79,233.62L162.66,232L162.17,230.98L161.79,230.6L159.63,229.28L159.17,228.68L158.87,227.12L158.92,225.12L160.75,225.8L161.99,226.57L163.79,227.21L163.79,227.21L163.97,227.79L164.29,228.18L164.71,228.46L165.64,228.74L166.88,228.61L169.09,228.01L170.98,227.97L171.88,228.15L173.48,229.04L175.32,228.95L177.61,229.6L179.77,229.68L180.83,229.57L181.6,229.23L182.21,228.62L183.04,227.18L183.51,227.09L183.85,227.28L185.77,229.28L187.11,230.4L189.82,231.99L189.82,231.99L190.63,233.01L192.08,234.38L194.18,235.42L194.8,235.84L195.43,236.64L196.21,238.1L196.84,238.57L198,238.61L200.07,237.84L202.39,237.41L204.56,236.4L206.23,236.44L207.36,236.77L207.93,237.38L208.45,238.46L209.18,240.48L209.83,243.05L210.32,244.44L210.32,244.44L207.86,250.36L206.64,251.99L205.08,253.34L204.58,254.21L204.59,254.81L204.8,255.13L205.02,255.24L205.49,255.23L206.81,254.81L207.71,254.8L208.31,255.01L208.64,255.37L208.95,256.06L209.02,257.41L208.29,259.67L208.08,261.04L208.18,262.27L208.55,263.85L208.59,264.9L207.94,268.34L208.27,269.49L209.42,271.46L209.53,272.3L209.23,273.11L208.23,273.63L205.83,274.22L203.87,274.35L202.59,274.69L201.94,275.21L201.24,276.56L200.95,277.71L201,278.4L202.05,280.62L202.31,281.5L202.39,282.69L202.31,285.16L202.47,285.94L203,287.57L203.39,288.21L203.3,288.22L203.3,288.22L202.27,288.23L200.31,287.77L199.41,287.91L197.57,289.65L197.14,289.83L196.67,289.76L195.6,288.89L194.64,287.54L194.41,286.97L194.06,284.88L193.74,284.19L193.5,283.94L192.24,283.24L187.08,281.43L186.03,281.38L184.51,281.81L183.77,281.76L183.06,281.37L181.95,280.48L181.4,280.31L179.7,280.46L178.01,280.4L175.86,280.53L175.25,280.25L174.06,279.11L173.5,278.95L169.89,280.6L168.75,280.8z"
				},
				{
					"id":"PS-QQA",
					"title":"Qalqilya",
					"d":"M162.37,259.41L159.29,259.78L158.27,259.75L156.99,259.54L155.1,259.08L152.36,257.83L150.49,257.32L148.68,256.56L148.29,256.47L147.77,256.54L147.28,256.91L147.1,257.21L146.56,259.65L146.32,260.21L144.16,263.96L143.67,265.35L143.21,265.96L140.73,267.89L139.76,268.46L139.02,268.73L136.41,269.18L133.01,270.63L132.14,271.39L131.03,272.72L130.08,273.18L130.08,273.18L130.18,272.37L131.58,269.72L132.13,267.6L131.92,265L130.61,259.22L129.68,257.27L127.33,253.75L127.25,251.4L127.55,249.03L130.66,241.98L133.03,238.55L134.13,237.77L134.13,237.77L138.72,243.81L140.12,245.94L140.88,246.59L142.07,248.31L145.76,250.77L147.36,250.85L148.06,250.61L149.1,249.21L151.33,248.48L151.68,247.66L151.82,246.84L153.28,245.36L154.26,244.05L155.16,243.23L156.9,242.99L159.76,242.09L162.56,241.55L162.56,241.55L163.69,242.41L164.41,243.3L165.53,246.21L165.68,248.19L165.58,249.5L164.87,253.52L164.04,255.84L162.72,258.11z"
				},
				{
					"id":"PS-SLT",
					"title":"Salfit",
					"d":"M166.81,280.84L165.48,280.16L163.75,278.95L162.81,278.51L161.59,278.36L159.68,278.8L159.2,278.78L157.41,277.8L155.79,277.21L154.61,277.28L153.84,277.63L153.27,278.08L152.35,279.37L152.02,279.55L149.8,279.89L148.35,280.48L147.22,281.17L145.97,281.39L145.11,281.36L143.45,281.08L140.7,280.33L138.15,280.11L136.85,279.5L135.91,278.18L135.41,277.83L134.59,277.69L132.56,277.7L132.56,277.7L132.32,277.25L130.52,275.33L129.98,273.98L130.08,273.18L130.08,273.18L131.03,272.72L132.14,271.39L133.01,270.63L136.41,269.18L139.02,268.73L139.76,268.46L140.73,267.89L143.21,265.96L143.67,265.35L144.16,263.96L146.32,260.21L146.56,259.65L147.1,257.21L147.28,256.91L147.77,256.54L148.29,256.47L148.68,256.56L150.49,257.32L152.36,257.83L155.1,259.08L156.99,259.54L158.27,259.75L159.29,259.78L162.37,259.41L162.37,259.41L163.04,259.96L163.41,260.53L164.46,263.48L165,264.62L165.64,265.48L166.3,266.04L167.7,266.61L169.06,266.72L169.77,266.54L171.09,265.75L171.52,265.61L172.44,265.54L173.34,265.68L174.96,266.37L176.79,266.69L177.72,267.05L178.91,267.97L179.54,269.01L179.66,269.51L179.62,271.11L179.36,271.95L178.87,272.7L178.46,273.03L177.77,273.31L175.2,273.69L171.27,275.8L169.67,277.29z"
				},
				{
					"id":"PS-RBH",
					"title":"Ramallah",
					"d":"M197.4,325.28L196.63,325.05L196.15,325.08L194.22,325.6L193.78,325.58L193.23,325.34L192.31,323.39L191.32,322.38L190.62,320.65L190.36,320.29L189.81,320.03L188.21,319.84L186.85,319.41L185.48,317.58L184.92,317.01L184.48,316.74L182.66,316.38L181.09,315.87L180.21,315.86L179.41,316.21L178.49,317.37L178.19,317.48L177.64,317.25L176.71,316.18L175.82,315.79L172.71,315.58L171.24,316L169.04,315.26L167.87,315.54L166.73,316.38L166.15,317.48L166.2,318.88L166.1,319.48L165.8,319.77L165.21,319.92L162.1,319.84L160.45,319.03L156,319.13L154.09,319.05L153.33,318.84L151.09,317.86L150.36,317.84L149.9,318.1L149.42,318.89L149.13,321.04L148.78,321.98L146.89,323.65L146.18,324.42L146.18,324.42L143.83,325.81L140.59,329.33L136.2,330.9L131.44,330.22L128.11,328.79L126.67,323.38L128.79,320.24L137.4,318.7L138.92,313.98L138.09,310.74L134.15,307.6L131.51,304.04L131.09,299.46L133.45,294.42L132.7,292.42L133.46,291.8L133.13,290.71L133.09,289.35L134.47,286.34L134.87,283.35L134.3,281.02L132.56,277.7L132.56,277.7L134.59,277.69L135.41,277.83L135.91,278.18L136.85,279.5L138.15,280.11L140.7,280.33L143.45,281.08L145.11,281.36L145.97,281.39L147.22,281.17L148.35,280.48L149.8,279.89L152.02,279.55L152.35,279.37L153.27,278.08L153.84,277.63L154.61,277.28L155.79,277.21L157.41,277.8L159.2,278.78L159.68,278.8L161.59,278.36L162.81,278.51L163.75,278.95L165.48,280.16L166.81,280.84L166.81,280.84L168.75,280.8L169.89,280.6L173.5,278.95L174.06,279.11L175.25,280.25L175.86,280.53L178.01,280.4L179.7,280.46L181.4,280.31L181.95,280.48L183.06,281.37L183.77,281.76L184.51,281.81L186.03,281.38L187.08,281.43L192.24,283.24L193.5,283.94L193.74,284.19L194.06,284.88L194.41,286.97L194.64,287.54L195.6,288.89L196.67,289.76L197.14,289.83L197.57,289.65L199.41,287.91L200.31,287.77L202.27,288.23L203.3,288.22L203.3,288.22L203.69,288.47L204.26,289.12L204.62,289.8L204.58,290.31L204.38,290.73L203.21,291.2L201.4,291.13L200.96,291.22L200.62,291.53L200.58,291.9L200.76,292.46L203.53,294.98L205.76,295.78L206.07,296.08L206.21,296.5L206.19,297.41L205.94,298.21L204.76,300.66L203.45,301.75L203.31,302.24L203.47,302.85L204.12,304.18L204.26,305.18L204,307.73L204.06,308.24L204.26,308.94L205.7,311.6L205.76,312.09L205.78,312.6L205.5,313.4L204.24,315.29L203.93,316.08L203.53,319.58L204.24,322.47L204.22,323.52L204.06,324.52L203.73,325.31L202.89,326.08L200.6,325.92z"
				},
				{
					"id":"PS-JEM",
					"title":"Jerusalem",
					"d":"M224.51,348.68L224.31,349.04L222.72,354.06L222.72,354.06L215.83,347.08L215.06,346.51L214.3,346.14L212.12,345.47L211.38,345.4L209.65,345.88L208.27,345.91L206.71,345.55L203.68,345.29L201.41,344.61L201,344.59L200.3,344.76L197.35,346.03L196.5,346.23L194.84,346.19L193.47,345.72L192.29,345.56L190.38,346.13L188.51,347.41L187.88,347.63L185.02,348.12L183.53,347.9L182.65,347.92L179.16,349.28L177.48,349.41L176.38,349.22L175.87,348.98L170.64,345.39L170.64,345.39L172.44,342.58L172.95,335.28L169.81,332L161.82,332.04L154.37,329.04L150.91,327.38L147.11,323.87L146.18,324.42L146.18,324.42L146.89,323.65L148.78,321.98L149.13,321.04L149.42,318.89L149.9,318.1L150.36,317.84L151.09,317.86L153.33,318.84L154.09,319.05L156,319.13L160.45,319.03L162.1,319.84L165.21,319.92L165.8,319.77L166.1,319.48L166.2,318.88L166.15,317.48L166.73,316.38L167.87,315.54L169.04,315.26L171.24,316L172.71,315.58L175.82,315.79L176.71,316.18L177.64,317.25L178.19,317.48L178.49,317.37L179.41,316.21L180.21,315.86L181.09,315.87L182.66,316.38L184.48,316.74L184.92,317.01L185.48,317.58L186.85,319.41L188.21,319.84L189.81,320.03L190.36,320.29L190.62,320.65L191.32,322.38L192.31,323.39L193.23,325.34L193.78,325.58L194.22,325.6L196.15,325.08L196.63,325.05L197.4,325.28L197.4,325.28L197.61,329.53L197.84,330.51L198.32,331L199.64,331.39L200.24,332.05L200.67,333L200.6,333.6L199.95,334.41L199.62,335.28L199.73,335.77L200.31,336.52L203.2,338.24L204.37,338.57L205.57,338.41L208.02,337.34L209.29,336.98L211.83,336.66L213.53,336.73L214.18,336.92L216.56,338.42L216.94,341.15L217.87,342.64z"
				},
				{
					"id":"PS-BTH",
					"title":"Bethlehem",
					"d":"M196.33,400.35L195.39,400.67L193.89,400.65L193.11,400.4L189.85,398.85L189.04,398.34L187.45,395.5L187.12,394.55L187.18,393.56L187.86,391.7L187.73,390.75L187.37,390.2L184.72,388.04L182.35,387.02L180.73,386.54L180.13,386.17L178.64,384.26L176.91,382.42L175.01,380.94L174.63,380.26L174.6,377.78L173.18,374.57L171.27,368.86L170.78,367.92L169.18,366.04L168.83,365.9L168.59,365.95L168.24,366.47L167.94,370.23L167.63,370.88L167.14,371.26L166.38,371.57L165.5,371.61L163.68,371.29L161.61,371.11L160.81,370.88L160.02,370.5L159.5,370.06L159.05,369.4L158.79,368.68L158.97,368.16L160.44,367.45L161.09,366.63L161.29,366.02L161.26,365.45L160.61,364.46L158.7,363.25L157.46,362.74L157.08,362.76L155.86,363.31L154.88,363.5L153.89,363.4L153.34,363.15L153.11,362.95L152.79,362.32L152.45,359.87L152.03,359.12L150.91,358.29L146.92,356.37L146.92,356.37L154.37,349L161.71,345.99L170.4,345.77L170.64,345.39L170.64,345.39L175.87,348.98L176.38,349.22L177.48,349.41L179.16,349.28L182.65,347.92L183.53,347.9L185.02,348.12L187.88,347.63L188.51,347.41L190.38,346.13L192.29,345.56L193.47,345.72L194.84,346.19L196.5,346.23L197.35,346.03L200.3,344.76L201,344.59L201.41,344.61L203.68,345.29L206.71,345.55L208.27,345.91L209.65,345.88L211.38,345.4L212.12,345.47L214.3,346.14L215.06,346.51L215.83,347.08L222.72,354.06L222.72,354.06L218.98,365.83L215.34,378.32L214.99,387.31L214.87,395.65L203.48,395.48L200.76,396.44z"
				},
				{
					"id":"PS-HBN",
					"title":"Hebron",
					"d":"M127.59,372.59L129.16,369.97L134.42,364.29L137.28,361.79L145.36,357.91L146.92,356.37L146.92,356.37L150.91,358.29L152.03,359.12L152.45,359.87L152.79,362.32L153.11,362.95L153.34,363.15L153.89,363.4L154.88,363.5L155.86,363.31L157.08,362.76L157.46,362.74L158.7,363.25L160.61,364.46L161.26,365.45L161.29,366.02L161.09,366.63L160.44,367.45L158.97,368.16L158.79,368.68L159.05,369.4L159.5,370.06L160.02,370.5L160.81,370.88L161.61,371.11L163.68,371.29L165.5,371.61L166.38,371.57L167.14,371.26L167.63,370.88L167.94,370.23L168.24,366.47L168.59,365.95L168.83,365.9L169.18,366.04L170.78,367.92L171.27,368.86L173.18,374.57L174.6,377.78L174.63,380.26L175.01,380.94L176.91,382.42L178.64,384.26L180.13,386.17L180.73,386.54L182.35,387.02L184.72,388.04L187.37,390.2L187.73,390.75L187.86,391.7L187.18,393.56L187.12,394.55L187.45,395.5L189.04,398.34L189.85,398.85L193.11,400.4L193.89,400.65L195.39,400.67L196.33,400.35L196.33,400.35L194.67,401.82L188.94,406L183.36,408.48L179.07,413.31L174.04,418.46L171.51,419.98L167.37,420.76L164.14,421.04L160.41,421.68L158.02,421.13L154.38,423.02L144.44,422.38L137.39,421.79L130.17,423.59L122.34,424.62L118.06,423.47L115.29,421.18L113.36,418.05L112.89,414.05L116.24,407.32L120.06,402.39L123.51,395.84L124.15,392.34L123.4,384.14L124.92,376.57z"
				},
				{
					"id":"PS-NGZ",
					"title":"North Gaza",
					"d":"M38.64,383.51L42.96,377.27L44.82,374.27L52.31,381.24L54.66,384.71L54.68,388.58L53.15,391.29L48.16,392.48L48.16,392.48L46.32,391.41L44.81,390.36L44.07,390.12L43.01,389.98L42.55,389.69L42.09,388.92L41.94,387.87L41.71,387.23L41.18,386.48L39.2,384.33z"
				},
				{
					"id":"PS-GZA",
					"title":"Gaza",
					"d":"M32.21,407.92L32.09,405.44L31.4,402.83L30.83,401.95L30.26,401.67L27.71,400.93L24.66,400.8L24.66,400.8L25.66,399.4L27,397.83L30.79,393.64L38.64,383.51L38.64,383.51L39.2,384.33L41.18,386.48L41.71,387.23L41.94,387.87L42.09,388.92L42.55,389.69L43.01,389.98L44.07,390.12L44.81,390.36L46.32,391.41L48.16,392.48L48.16,392.48z"
				},
				{
					"id":"PS-DEB",
					"title":"Deir El Balah",
					"d":"M24.41,418.89L22.85,418.64L22.39,418.36L20.92,416.89L20.55,416.65L14.95,414.62L13.9,414.01L13.26,413.3L13.26,413.3L14.84,411.85L18.05,408.5L20.59,405.71L24.66,400.8L24.66,400.8L27.71,400.93L30.26,401.67L30.83,401.95L31.4,402.83L32.09,405.44L32.21,407.92L32.21,407.92L30.83,409.25L25.09,416.63z"
				},
				{
					"id":"PS-KYS",
					"title":"Khan Yunis",
					"d":"M15.78,441.86L14.75,439.49L13.81,435.22L13.56,434.56L13.25,434.18L12.65,433.77L9.24,432.1L6.62,430.57L1.56,426.83L0.38,426.29L0.38,426.29L5.51,421.28L11.4,414.98L13.26,413.3L13.26,413.3L13.9,414.01L14.95,414.62L20.55,416.65L20.92,416.89L22.39,418.36L22.85,418.64L24.41,418.89L24.41,418.89L23.58,421.67L24.01,427.46L24.05,432.87L22.15,436.36z"
				},
				{
					"id":"PS-RFH",
					"title":"Rafah",
					"d":"M6.72,448.8L0,426.58L0.38,426.29L0.38,426.29L1.56,426.83L6.62,430.57L9.24,432.1L12.65,433.77L13.25,434.18L13.56,434.56L13.81,435.22L14.75,439.49L15.78,441.86L15.78,441.86L14.48,442.98z"
				},
				{
					"id":"IL",
					"title":"Israel",
					"d":"M290.91,67.89l-0.32,0.86l0.39,1.11l1.95,2.21l0.19,0.89l-0.24,0.5L291.96,74l-1.94,0.23l-3.44,-0.91l-0.73,0.59l-0.41,1.07l0.87,3.58L285.81,85l0.9,2.92l1.48,13.61l3,4.16l0.59,1.43l0.02,1.12l-0.79,2.18l-0.66,1.14l-3.12,5.45l-2.52,5.56l-2.8,3l-4.23,7.59l-5.38,6.25l-0.16,-0.68l-1.09,-0.62l-3.76,1.55l-1.79,0.21l-0.86,0.73l-0.66,1.53l-0.71,2.77l-3.93,0.53l-2.48,2.51l-2.74,1.94l-1.72,0.52l-1.23,0.8l-4.27,0.3l-2.06,1.33l-4.86,2.12l-1.12,1.28l0.32,2.87l-1.95,0.77l0.08,1.25l-0.42,0.49l-1.52,0.42l-2.49,1.89l-0.23,2.09l0.54,0.63l-0.25,3.03l0.4,0.94l1.28,0.7l0.34,1.27l-0.82,1.9l-0.12,1.92l1.77,3.67l-0.17,0.43l-1.73,-0.03l-0.3,1.92l-0.79,-0.02l-1,-0.66l-0.37,0.2l0.11,1.21l1.16,1.88l-0.38,0.65l-1.74,0.37l-0.92,1.3l0.81,0.61l1.11,-0.03l1.1,2.51l1.29,0.52l0.33,0.55l-0.21,1.04l-2.13,3.83l-0.15,1.03l0.27,0.92l1.42,0.69l0.35,0.69l-0.43,0.99l-0.84,0.03l-0.59,0.53l0.43,2.69l-2.03,0.63l0.5,4.59l-0.3,0.76l-1.29,0.38l-0.17,0.33l1.64,2.78l-1.4,-0.13l-4,-1.15l-5.08,-2.37l-2.17,-0.66l-3.92,-0.17l-2.58,0.75l-2.18,-0.35l-1.14,-1.01l0.05,-1.03l-1.23,-1.58l-1,-2.94l0.21,-4.06l-0.54,-4.36l-2.8,-4.74l-2.79,-2.08l-1.46,-0.36l-3.32,-0.05l-8.43,1.55l-2.01,-0.01l-1.37,-0.36l-2.71,-1.34l-2.65,-1.94l-3.07,-3.19l-2.39,-1.3l-1.67,0.26l-0.91,0.46l-0.96,1.09l-2.21,2.5l-0.6,1.24l-2.06,2l-3.4,2.47l-4.29,2.19l-6.93,2.62l-1.31,0.99l-1.6,3l-0.76,2.83l-0.8,5.21l-1.5,4.16l-0.35,2.53l-0.36,2.62l-1.21,1.17l-4.48,2.01l-1.15,1.45l-1.83,3.44l-0.19,5.47l0.81,5.81l-0.57,1.51l-1.46,1.04l-2.37,3.43l-3.12,7.05l-0.29,2.37l0.08,2.35l2.35,3.52l0.93,1.95l1.31,5.78l0.21,2.6l-0.55,2.12l-1.4,2.65l-0.19,1.62l0.54,1.34l1.8,1.92l1.98,3.77l0.57,2.33l-0.4,2.98l-1.39,3.01l0.04,1.36l0.33,1.09l-0.76,0.62l0.76,2l-2.36,5.05l0.42,4.58l2.64,3.56l3.94,3.14l0.83,3.24l-1.53,4.72l-8.6,1.54l-0.16,0.23l-1.97,2.91l1.44,5.41l3.33,1.43l4.76,0.69l4.39,-1.58l3.24,-3.52l3.28,-1.94l3.79,3.51l3.47,1.66l7.44,3l8,-0.04l3.14,3.28l-0.52,7.3l-1.8,2.81l-0.24,0.37l-8.69,0.23l-7.35,3l-9.01,8.91l-8.08,3.88l-2.86,2.5l-5.26,5.68l-1.57,2.62l-2.67,3.98l-1.52,7.56l0.75,8.2l-0.64,3.5l-3.45,6.55l-3.82,4.93l-3.35,6.73l0.47,4l1.94,3.13l2.76,2.29l4.28,1.14l7.82,-1.03l7.23,-1.8l7.04,0.59l9.94,0.64l3.64,-1.89l2.39,0.55l3.73,-0.64l3.22,-0.27l4.15,-0.78l2.53,-1.52l5.03,-5.15l4.29,-4.83l5.58,-2.48l5.72,-4.18l6.1,-5.38l2.72,-0.96l11.39,0.16l-0.02,3.49l-0.07,10.28l-0.61,4.05l-2.83,8.09l-6.52,11.72l-1.99,4.04l-1.85,3.26l-0.88,4.04l1.97,4.28l7.69,10.35l1.37,2.94l0.86,4.18l0.17,3.12l-1.16,5.14l-1.07,3.67l-6.59,10.17l-0.7,4.08l0.4,3.26l1.41,3.9l-0.01,4.13l-2.99,2.74l-6.48,4.25l-4.61,10.16l-0.05,3.62l0.86,3.3l-0.88,4.03l-3.3,1.19l-2.57,3.11l-1.52,4.16l-0.01,8.14l-2.44,5.67l-4.23,7.72l-0.92,4.43l-2.56,2.37l-5.08,9.82l-0.41,3.29l-3.9,18.07l-1.19,3.56l-2.38,3.42l-0.69,2.69l5.97,11.21l0.91,3.1l-0.55,2.37l-3.83,4.24l-1.1,3.42l0.59,3.96l-3.29,7.29l5.4,23.89l-13.34,19.14l-3.59,14.26l0.54,15.48l-5.08,10.16l-0.77,3.72l0.5,2.95l-0.5,3.99l-2.94,12.24l0,6.66l0.45,4.17l0.05,3.85l-2.26,2.76l-3.08,2.27l-2.62,3.04l-1.85,3.71l-1.67,4.72l-0.34,-0.11l-0.72,0.05l-0.43,-0.44h-0.38l-0.14,0.55l-0.19,0.06l-0.1,0.55l-0.24,0.27l-0.05,0.27h-0.43l-0.1,0.27l-0.43,0.16l-0.19,0.38l-0.14,0.82l-0.43,0.71h-0.38v0.16l-0.53,0.6l-0.62,0.38l-0.14,0.55l-0.67,0.66v0.82l-0.43,0.27l-0.62,0.88l-0.34,0.27v0.49l-0.77,0.88L117.5,792l-4.35,-5.04l-2.27,-4.29l-0.82,-3.3l-0.69,-5.74l1.62,-5.39l0.81,-5.39l-0.78,-3.71l-3.09,-5.38l0.12,-9.51l-17.63,-49.49l0.36,-3l-5.59,-15.43l-14.84,-41.99l-3.51,-13.2l-12.03,-7.87l-0.44,-6.11l3.56,-10.05l-7.48,-8.77l0.5,-10.87l-4.99,-20.76l-15.18,-31.89L20.94,496L6.72,448.8l7.76,-5.82l7.67,-6.63l1.9,-3.49l-0.04,-5.41l-0.43,-5.79l1.51,-5.04l5.75,-7.39l17.29,-16.76l5.02,-1.19l1.53,-2.72l-0.02,-3.87l-2.35,-3.47l-7.5,-6.99l4.17,-6.77l0.72,-0.45l0.33,-0.5l-0.05,-0.11l-0.29,-0.06l0.05,-0.5l-0.14,-0.06v-0.17l0.58,-0.67v0.22l-0.43,0.5l0.48,0.11l0.1,0.17l0.14,-0.06l2.63,-4.37l0.34,-1.18l0.62,-0.45l0.96,-1.23l0.38,-0.78l-0.05,-0.28l0.53,-0.67l0.29,-0.73l0.24,-0.17l0.1,0.22h0.19l2.92,-5.21l0.53,-0.73l1.34,-2.69l0.77,-0.95l0.38,-1.12l1.92,-3.31l1.72,-3.7l0.86,-1.46l0.86,-2.07l0.29,-0.5l0.14,-0.06l-0.05,-0.17l0.48,-0.9l0.48,-1.35l0.62,-1.12l0.72,-1.68l-0.53,-0.56l-0.29,-0.95l0.05,-0.79l0.48,-1.18h0.14v0.39l-0.19,0.11l-0.29,0.67v0.95l0.62,1.07h0.38l0.1,-0.28l-0.48,-0.28v-0.17l0.19,-0.11l-0.05,-0.56l0.14,-0.17l0.05,-0.45v-0.17l-0.19,-0.11v-0.22h0.43l0.19,0.22h1.1l0.1,-0.28l0.38,-0.39l0.1,-0.22l-0.24,-0.11l-0.05,-0.28l0.05,-1.46l0.14,-0.11l0.05,0.22h0.14v-0.11l0.38,-0.22l1.42,-3.6l1.11,-2.38l1.58,-3.96l0.19,-0.84l0.53,-1.12v-0.22l0.19,-0.22l0.24,-1.23l0.29,-0.56l0.05,-0.67l0.19,-0.06l0.05,-0.22l0.14,-0.06v-0.39l0.1,-0.17h0.14l0,-0.28h0.1l0.38,-0.67l0.24,-0.11l0.05,-0.34l1.44,-2.13l1.24,-3.03l1.2,-3.15l2.11,-7.28l0.38,-1.49l0.38,-0.9l0.14,-1.29l0.38,-0.51l-0.24,-0.17l0.33,-1.12l0.29,-0.45v-0.34l0.19,-0.45l0.24,-0.28l0.14,-1.24l0.58,-0.45v-0.51l-0.19,-0.17l0.53,-0.51h0.33l0.43,-0.34l0.53,-0.84l0.34,-1.07l0.24,-0.34l0.05,-0.51l-0.1,-0.11l0.29,-0.11l-0.19,-0.28l0.14,-0.17l-0.1,-0.06l0.1,-0.39l0.72,-1.69l0.05,-0.51l0.2,-0.11l0.13,-0.34l-0.24,-0.68v-0.56l0.38,-0.28l0.19,0.06l0.29,-0.9l0.43,-0.84l-0.24,-0.45l0.05,-0.34h0.14l0.1,0.28h0.19l0.53,-1.63l0.33,-1.69l0.43,-0.56l0.14,-0.39l-0.05,-0.23l0.14,-0.11l0.48,-1.86v-0.84l0.57,-1.46l-0.1,-0.62l0.53,-0.28l-0.05,-0.45l-0.34,-0.23l0.1,-1.29l0.19,-0.17l0.29,0.11l0.1,-0.17l0.67,-2.25l0.48,-2.53l0.34,-0.58l0.29,-0.78v-0.28l-0.14,-0.17l0.05,-0.28l0.53,-1.24l0.24,-0.23l-0.05,-0.45l0.43,-0.79l0.05,-0.68l0.53,-0.79l0.1,-0.79l0.24,-0.56l-0.1,-0.56l0.38,-0.39v-0.9l0.34,-1.46l0.29,-0.45l0.48,-1.3l-0.05,-0.68l0.19,-0.28l0.24,-0.79l-0.05,-0.17l0.53,-1.41l0.04,-0.85h-0.14v-0.17l0.34,-0.56l0.1,-1.3l0.53,-1.01l0.1,-0.56l0.43,-0.96l-0.05,-0.68l0.19,0.11l0.14,-0.06l-0.1,-0.96l0.19,-1.02l0.19,-0.17l-0.05,-0.39l0.72,-3.21v-0.23l-0.24,-0.17l-0.05,-0.28l0.62,-0.34l0.05,-0.17l0.33,-1.92l0.19,-0.51v-0.68l0.29,-0.56l0.81,-3.72v-0.68l0.24,-1.24h-0.29v-0.11l0.53,-0.51l0.14,-0.34l0.1,-0.79l-0.1,-0.68l0.29,-1.13l-0.33,-0.23l0.24,-0.51l0.19,-0.11l0.38,-1.02l0.14,-0.06l0.14,-0.84l-0.1,-0.17l0.19,-0.45l0.34,-0.17l0.14,-0.45v-0.11h-0.48l0.29,-0.4v-0.28l0.24,-0.45l0.38,-0.17l-0.05,-0.17l0.1,-0.06l0.72,-3.5l0.1,-1.64l0.53,-1.58l0.29,-1.52l-0.38,-1.02h-2.11v-0.28l1.87,-0.06l0.14,-0.11l0.1,-0.45l0.19,0.17l0.05,0.4h0.57l0.05,-0.11h-0.33l-0.14,-0.17v-0.23l0.19,-0.06l0.1,-0.39v-0.23l-0.19,-0.06v-0.17l0.19,-0.06l0.05,0.17h0.14l0.24,-0.17l-0.1,-0.17l0.05,-0.62l0.53,-0.9l-0.1,-0.28l-0.29,0.11l-0.05,-0.79l0.19,-0.11v-0.45l0.19,-0.34l-0.1,-0.23l0.34,-0.4v-0.4l-0.19,-0.17l0.1,-0.68l0.38,-0.28l0.05,-0.79l0.48,-0.62l-0.48,-0.06l-0.05,-0.28h0.24l0.29,-0.62l0.38,-1.69l0.19,-0.28l0.05,-0.73l0.24,-0.45l-0.05,-0.74l-0.29,-0.06l-0.14,-0.17v-0.56l0.24,-0.74l0.38,-0.4l0.34,0.06l0.29,-0.56l-0.05,-0.23l-0.33,-0.06v-0.34l-0.24,-0.17l0.57,-1.07l-0.14,-0.28l0.05,-0.45l0.29,-0.34l0.38,-1.41l0.19,0.11l0.1,-0.23l-0.1,-0.4l0.38,-0.74l-0.1,-0.45l-0.34,-0.34v-0.34l0.34,-0.34l0.14,-0.79l-0.19,-0.11v-0.28l0.29,-0.85l0.29,-0.4l-0.14,-0.23l0.14,-0.4l-0.05,-0.96l0.19,-0.4v-0.51l-0.14,-0.11l0.19,-0.57l0.19,-1.81l0.24,-0.06l0.24,-0.57l0.1,-1.64l0.29,-1.25l0.33,-0.57l-0.29,-0.17l0.24,-1.25l-0.05,-0.91l0.43,-0.4l0.05,-0.23l0.05,-1.81l0.29,-1.87l-0.05,-1.7l0.19,-0.4v-0.17l-0.19,-0.17v-0.28l0.1,-0.11l-0.05,-0.4l0.29,-0.23l-0.05,-0.34l-0.24,-0.17v-0.45l0.29,-0.85v-0.45l0.53,-0.62v-0.28l0.38,-0.4l0.67,0.06l0.48,-0.62l0.34,-0.74l0.19,-0.85l-0.14,-0.51l0.33,-0.4l0.19,-2.1l0.38,-0.91l0.34,-3.97l0.19,-0.74v-1.76l0.1,-0.79l0.19,-0.45l0.24,-2.89l-0.19,-0.91h0.24l0.05,-0.11l0.14,-1.36l-0.05,-0.68l-0.24,-0.45h0.14l0.1,-0.17l0.14,0.17l0.14,-0.06v-0.17l-0.14,-0.06l0.14,-0.45l-0.19,-0.17l-0.14,-0.51v-1.81l0.24,-0.28l-0.19,-0.34l0.29,-0.34l0.43,0.11l1.05,-1.02l0.53,-0.11l0.62,0.06l0.86,-0.45l0.19,-0.34l0.14,-0.11l0.14,0.06l0.14,-0.23h0.43l0.62,0.28l0.43,0.79h0.43l0.24,0.23l0.86,0.34l0.53,0.06v0.17l0.24,0.28l1.29,0.06l1.25,-0.34v0.17l-0.58,0.23l-0.1,-0.11l-0.38,0.28h-0.19l-1.2,-0.11l-0.72,-0.23l-0.86,-0.62l-0.38,0.11l0.24,0.06l0.1,0.23l0.19,0.06l-0.05,0.23l1.01,0.51l0.14,0.28l0.19,0.06l0.29,0.34l0.1,0.4l0.19,-0.11v-0.57h0.19l0.09,0.51h0.24l0.1,-0.34l-0.24,-0.23v-0.23l0.05,-0.11l0.29,0.06l0.38,0.57l0.14,1.08l0.33,0.11l0.19,0.45h0.62l0.24,-0.17l0.53,-0.06l-0.14,-0.4l0.19,-0.06l0.77,0.51l0.14,0.91l0.96,-0.28l0.05,-0.17l-0.14,-0.23l-0.48,-0.06l-0.1,-0.57l-0.38,0.06l-0.29,-0.17l0.77,-0.23l1.53,-1.02l0.33,-0.06l0.19,-0.4l0.29,-0.06v-0.23l0.33,-0.17v-0.28l0.24,-0.23l0.29,-0.62l0.67,-0.62l1.01,-1.48l1.72,-4.03l0.29,-0.11l-0.1,-0.4l0.43,-1.42l0.19,-0.11l-0.05,-0.23l0.38,-1.08l0.24,-0.17l-0.1,-0.23l0.48,-1.65l-0.05,-0.23l0.43,-2.21l0.05,-2.5l-0.48,-0.98l-0.33,-0.5l-0.38,-0.28l-0.57,-0.06l-0.19,0.17v0.45l-0.34,-0.11l-0.43,0.06v-0.45l0.77,-2.04l0.1,-1.48l0.67,-2.78l0.05,-1.65l0.14,-0.34l-0.05,-0.68l0.1,-0.06v-0.57l0.19,-0.68l-0.05,-0.28l0.43,-1.08v-0.51l0.29,-0.11v-1.53l0.19,-0.17l0.14,-0.85l0.67,-1.25l-0.05,-0.8l-0.14,-0.28l0.14,-0.11v-0.74l0.24,-0.45l-0.05,-0.57l0.29,-0.63l-0.05,-0.17l0.24,-0.11l-0.1,-0.57l0.33,-0.68l0.14,-0.85l0.24,-0.45l0.1,-0.85l0.48,-0.85l-0.19,-0.11V80.4l0.48,-0.4l-0.1,-0.11l0.14,-0.46l-0.1,-0.28l0.33,-0.51l-0.1,-0.57h0.14l-0.05,-0.63l0.24,-0.17l0.05,-1.31l0.19,-0.4l0.1,-1.88l0.19,-0.34v-0.63l-0.14,-0.17v-1.94l7.69,-0.11l5.43,-0.46l6.1,1.06l0.6,-0.26l0.99,-1.07l1.99,-0.65l6.38,-0.21l6.64,-0.93l3.42,0.8l2.9,5.52l1.62,1.86l2.6,1.54l1,0.29l4.38,-1.96l4.73,-0.37l1.24,-0.66l2.94,-2.84l0.85,-1.16l1.42,-1.04l0.75,-0.08l3.04,0.73l2.92,-1.1l0.4,-0.49l0.23,-2.59l0.39,-0.86l3.28,-1.39l0.86,-2.05l0.35,-4.48l1.08,-4.98l1.1,-1.92l0.85,-2.29l-0.14,-2.49l-0.62,-2.8l0.08,-1.6l1.47,-3.35l1,-0.84l1.61,-2.13l1.65,-3.64l0.41,-0.44l1.21,0.99l4.08,5.82l0.67,0.21l0.64,-0.61l0.65,-1.62l0.81,-1.06l5,-2.35l5.28,-3.16l1.77,-1.71l2.56,-4.09l1.44,-1.3l1.07,-0.42l4.32,0.36l2.62,-0.45l3.46,-1.44l3.21,-2.61l1.01,-1.38l0.53,-1.62l0.81,-5.23l1.47,-2.36l2.62,-1.9L289.33,0l0.89,0.69l0.24,1.48l-0.62,2.61l-1.81,2.98l-3.42,3.91l-1.47,3.82l-0.53,3.72l0.83,8.33l-0.26,1.4l-1.98,3.39l1.28,1.53l2.55,2.17l1.11,1.56l0.58,0.99l1.15,4.17l0.22,2.41l-0.34,1.63l-0.65,1.67l-1.54,1.67l-0.55,1.1l0.33,2.22l1.43,0.52l2.36,0.25l1.31,0.61l3.63,5.26l-0.41,5.37L290.91,67.89z"
				}
			]
		}
	}
};
