﻿// (c) ammap.com | SVG (in JSON format) map of Oman - High
// areas: {id:"AE-SH"},{id:"AE-DU"},{id:"AE-FU"},{id:"AE-RK"},{id:"AE-NZ1"},{id:"AE-NZ2"},{id:"OM-BAN"},{id:"OM-BAS"},{id:"OM-BU"},{id:"OM-DA"},{id:"OM-MA"},{id:"OM-MU"},{id:"OM-SHN"},{id:"OM-SHS"},{id:"OM-WU"},{id:"OM-ZA"},{id:"OM-ZU"}
AmCharts.maps.omanHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"51.880933",
				"topLatitude":"26.388573",
				"rightLongitude":"59.840216",
				"bottomLatitude":"16.641322"
			}
		},
		"g":{
			"path":[
				{
					"id":"AE-SH",
					"title":"Ash Shāriqah",
					"d":"M254.06,101.03l-0.22,1.29l0,0l-0.43,0.86l0,0l-0.19,-0.09l0,0l-2.07,-0.55l-2.37,-0.32l-0.86,-1.08v-0.97l1.19,-0.97l0.11,-2.05l-0.86,-1.73l-0.86,-1.08l-0.11,-0.97l0,0l0.03,-0.71l0,0l1.05,-0.15l1.29,0.54l0.97,1.4l0,0l0.56,0.56l-0.03,0.59l0,0l-0.09,0.93l1.5,1.48l0,0l0.19,0.01l-0.84,0.96l0,0l0.11,1.19l0,0l0.97,0.32L254.06,101.03zM256.11,77.96v0.97l-0.97,0.54l-0.97,-0.43v-0.86l0.97,-0.65L256.11,77.96zM258.34,70.61l1.34,-1.2l0,0l0.15,0.96l-0.11,0.97l-0.31,0.67l-0.11,0.6l-0.43,0.09l-0.11,0.41l0.1,0.53l0.16,0.27l0.29,0.25l0.19,0.09l0.11,-0.14l0.18,-0.04l-0.19,-0.41l0.19,-0.14l0.15,0.41l0.45,0.28l-0.13,0.39l0.42,0.39l-0.02,0.09l-0.26,0.11v0.16l0.23,0.21l0.08,0.21l-0.23,0.11l-0.15,0.23l-0.29,0.21v0.14l0.11,0.11l0,0l-1.35,0.85l-0.61,0.46l-0.27,0.32l0,0l-0.09,-1.76l0,0l-0.43,-1.4l0.32,-1.62l-0.18,-1.81l0,0L258.34,70.61zM259.81,94.79l0.11,0.07l0.02,0.9l-0.06,0.05l-0.35,-0.19L259.81,94.79zM259.41,90.89l0.21,2.98l0.27,0.6l-0.35,1.04l-0.11,0.05v0.09l0.26,0.07l0.13,0.26v0.39l0.21,0.37l0.27,1.06l0,0l-1.22,0.13l0,0l-0.62,0.23l-0.29,0.46l-0.11,0.48l0,0l-0.76,-0.45l0,0l-1.44,-0.19l0,0L256,96.5v-1.51l-1.19,-2.05v-1.19l0.86,-0.86l1.83,-0.11L259.41,90.89z"
				},
				{
					"id":"AE-DU",
					"title":"Dubayy",
					"d":"M249.8,107.52L249.52,108.08L249.35,108.82L249.34,109.52L249.34,109.52L249.14,110.33L248.99,110.56L247.71,110.94L247.5,111.49L247.26,112.57L246.94,112.82L245.5,113.28L244.23,113.12L243.72,113.16L242.48,112.82L241.95,112.36L241.95,112.36L243.73,110.34L244.69,107.82L244.69,107.82L245.01,107.78L245.01,107.78L245.37,107.61L245.77,107.54L246.83,107.66L247.75,107.48z"
				},
				{
					"id":"AE-FU",
					"title":"Al Fujayrah",
					"d":"M260.21,76.61l0.1,0.07L260.17,77l-0.06,2.16l-0.39,1.31l-0.27,1.84l-0.13,2.32l0.08,0.67l-0.21,1.22l0.06,1.22l-0.05,0.9l0.15,0.65l-0.05,1.13l0.02,0.16h0.1v0.3l0,0l-1.9,-0.1l-1.83,0.11l-0.86,0.86v1.19l1.19,2.05v1.51l-0.15,1.96l0,0l-0.18,-0.02l0,0l-0.86,-0.32l0,0l-2.16,-0.11l0,0l-1.5,-1.48l0.09,-0.93l0,0l0.03,-0.59l-0.56,-0.56l0,0l-0.97,-1.4l-1.29,-0.54l-1.05,0.15l0,0l0.08,-1.88l0,0v-4.53l0.75,-2.48l0.11,-1.19l2.13,-1.1l0,0l0.06,0.21l0.19,0.19l0.6,0.27l0,0l2.08,0.41h0.42l0.4,-0.12l0,0l0.79,-0.78l1.14,-0.65l0,0l0.39,-0.28l0,0l0.63,-0.28l0.19,-0.25l0,0l0.19,-0.3l0.08,-0.39l0,0l0.06,-0.87l0.23,-0.43l0,0l0.27,-0.32l0.61,-0.46l1.35,-0.85l0,0L260.21,76.61zM255.17,105.37l-0.25,0.32l0,0l-0.6,-1.37l-0.1,-0.49l-0.4,-0.46l0,0l-0.4,-0.19l0,0l0.43,-0.86l0,0l0.18,-1.07l1.55,-0.22l1.51,0.11l0,0l0.97,0.22l0.28,0.21l0,0l0.07,0.8l0,0l-0.04,0.5l0,0l-0.33,0.42l-0.46,0.24l0,0l-1.79,0.47l0,0l0,0l0,0l-0.26,0.78l-0.2,0.34l0,0L255.17,105.37zM247.61,54.44l0.75,-0.23h0.81l0.97,0.81l0.24,0.73l0.41,0.57l0.57,0.49l0.65,0.32l0.79,0.07l0,0l1.35,-1.21l0.1,0.53l0.31,0.59l0.79,0.67l0.15,-0.04l-0.05,-0.3l0.19,-0.12l0.05,0.05l-0.16,0.12l0.03,0.12l0.45,-0.16l-0.02,-0.14l-0.26,-0.12l0.08,-0.05l0.4,0.3l0.29,0.02l1.3,0.57l0.13,-0.04l0.56,0.14l0.21,0.25l0.34,-0.11l0.14,0.12l0.08,0.69l-0.19,1.44l0.13,0.96l0.32,0.41l-0.06,0.3l0.23,0.27l0.27,0.09l0.06,0.28v0.51l-0.42,1.13L259.56,65l-0.15,0.11l-0.03,0.2l0.18,0.25l0.05,0.3l-0.08,0.18l0.13,0.28l-0.11,0.18l-0.02,0.23l0.1,0.18l-0.19,0.85l-0.06,0.76l0.11,0.51l0.27,0.09l-0.06,0.3l0,0l-1.34,1.2l0,0l-0.95,1.2l-0.43,0.34l-0.51,0.28L254.77,73l-0.48,0.32l-0.27,0.39l-0.13,0.58l0,0l-0.08,1.19l-0.19,0.44l-1.45,0.71l-0.71,0.18h-0.97l0,0l-0.56,-0.18l-0.11,-0.21l0.35,-0.6l-0.05,-0.14l-2.22,-0.62l-0.76,0.07l-1,0.9l-0.52,0.21l-0.23,0.35l-0.03,0.19l0.13,0.07l0.34,0.04l0.82,-0.16l0.27,0.02l0.19,0.09l0.31,0.55l0.6,0.16l0.84,-0.09l0.11,0.07l0.03,0.14l-0.42,0.81l-0.18,0.19l-0.6,0.25l-1.26,0.27l-0.11,0.18v0.34l0.37,1.08l-0.08,0.65l-0.15,0.12l-0.48,0.05l-0.37,0.92l-0.42,0.23l-0.53,0.11l-0.72,-0.16l-0.53,-0.21l-0.48,-0.48L242.75,82l-0.6,0.14l-0.56,0.51l-0.29,0.02l-0.4,-0.11l-0.39,-0.27l-0.66,-0.27l-1.48,0.11l-0.6,-0.07l0,0l0.03,-0.57l0.31,-1.03l-0.29,-0.97l-0.56,-1.04l0.66,-0.62l0.23,-0.11l0.31,0.02l0.58,-0.64l0.03,-0.32l-0.18,-0.73l-0.13,-0.18l-1.16,-0.6l0.32,-1.06l0.6,-1.28v-0.34l0.13,-0.46l0,0l0.42,0.27l0.31,0.35l0.11,0.43l0.31,0.39l0.39,0.19l1.64,0.28l1.24,0.6l0.66,0.09l0.97,-0.35l0.26,-0.27l0.21,-0.62l0.21,-0.3l0.13,-0.05l0.89,0.37l0.31,-0.11l0.21,-0.48l0.11,-0.57l-0.11,-1.68l-0.1,-0.11l-0.29,0.02l-1.3,0.39l-0.39,-0.02l-0.56,-0.28l-0.03,-0.44l-0.32,-0.43v-0.32l1.63,-1.58l0.45,-0.64l0.23,-0.58l-0.02,-0.35l-0.32,-0.27l-0.71,-1.05l-0.68,-0.66l-0.35,-0.03l-0.32,0.14l-0.8,0.67l-0.74,0.28l-1.22,-0.16l-1.5,0.23l-0.47,-0.02l-0.52,-0.28l-0.69,-0.05l-0.24,-0.11l-0.32,-2.09l-0.47,-1.4l0.21,-0.43l-0.5,-1.49l0.06,-0.91l0.29,-0.39l0.29,-0.21l0.4,-0.07l0.48,0.11l0.4,0.27l0.56,-0.04l0.43,-0.25l0.4,-0.05l0.56,-0.27l0.24,-0.32l0.24,-0.89l0.34,-0.34l0.53,-0.3l0.69,-0.67l0.24,-0.04l0.42,0.53l0.39,0.11l0.39,-0.11l0.34,-0.2l0.32,-0.32l0.37,-0.18l1.35,0.07l0.74,-0.23l0.55,-0.58l0,0L247.61,54.44z"
				},
				{
					"id":"AE-RK",
					"title":"Ra’s al Khaymah",
					"d":"M241.03,36.81l-0.34,0.78l0.08,0.28l-0.64,1.51l-0.1,0.07l-0.11,-0.09l-0.06,-0.21l0.32,-0.64l0.6,-1.6L241.03,36.81zM237.77,82.07l0.6,0.07l1.48,-0.11l0.66,0.27l0.39,0.27l0.4,0.11l0.29,-0.02l0.56,-0.51l0.6,-0.14l0.31,0.04l0.48,0.48l0.53,0.21l0.72,0.16l0.53,-0.11l0.42,-0.23l0.37,-0.92l0.48,-0.05l0.15,-0.12l0.08,-0.65l-0.37,-1.08v-0.34l0.11,-0.18l1.26,-0.27l0.6,-0.25l0.18,-0.19l0.42,-0.81l-0.03,-0.14l-0.11,-0.07l-0.84,0.09l-0.6,-0.16l-0.31,-0.55l-0.19,-0.09l-0.27,-0.02l-0.82,0.16l-0.34,-0.04l-0.13,-0.07l0.03,-0.19l0.23,-0.35l0.52,-0.21l1,-0.9l0.76,-0.07l2.22,0.62l0.05,0.14l-0.35,0.6l0.11,0.21l0.56,0.18l0,0l-0.5,1.31l0.4,3.08l0,0l0.08,0.29l0,0l-2.13,1.1l-0.11,1.19l-0.75,2.48v4.53l0,0l-0.11,2.59l0,0l0.11,0.97l0.86,1.08l0.86,1.73l-0.11,2.05l-1.19,0.97v0.97l0.86,1.08l2.37,0.32l2.07,0.55l0,0l0.6,0.28l0,0l0.4,0.46l0.1,0.49l0.6,1.37l0,0l-0.33,0.35l0,0l-0.42,0.12l0,0l0,0l0,0l-1.36,0.56l0,0l0,0l0,0l-0.5,0.13l0,0l-0.46,0.09l-1.01,-0.08l-0.36,0.1l0,0l-0.67,0.56l0,0l-2.05,-0.04l-0.92,0.18l-1.06,-0.12l-0.4,0.07l-0.35,0.18l0,0l-0.32,0.04l-0.29,-0.09l0,0l-0.9,-1.02l0,0l-1.29,-1.02l-0.55,-0.71l0,0l0.1,-0.16l-0.14,-0.27l0,0l-0.26,-0.47l-0.27,-0.88l0,0l-0.03,-0.99l0,0l-0.04,-0.86l-0.25,-1.31l-0.62,-1.34l0,0l-0.59,-0.37l0,0l-1.25,-0.57l-1.1,-0.07l0,-0.78l-0.24,-0.64l-0.74,-1.5l-0.47,-0.44l-0.18,-0.39l0.13,-1.06l-0.26,-1.52l1.37,-2.97l0.16,-0.55l0.19,-0.3l0.26,-0.07l0.06,-0.14l-0.61,-1.11l-0.92,-0.78l-0.23,-0.34l0.06,-1.29l0.18,-0.34l1.67,-0.76l0.13,-0.32L237.77,82.07zM241.74,35.1l0.11,0.3l-0.08,0.07l-0.13,-0.04l-0.06,0.21l-0.11,0.07l-0.16,-0.05l-0.18,0.78l-0.23,0.36l-0.06,-0.07l0.63,-1.82L241.74,35.1zM247.75,27.75l0.61,0.8l0.31,1.45l0,0l-0.25,1.39l0.02,1.34l0,0l0.25,1.14l-0.64,4.67l0,0l-0.35,0.83l0.08,0.76l-0.82,2.66l0,0l-0.13,1.03l0.02,1.16l0.9,2.31l-0.44,1.15l-0.18,1.73l0.09,3.36l0,0l0.14,0.53l0,0l0.23,0.33l0,0l-0.55,0.58l-0.74,0.23l-1.35,-0.07l-0.37,0.18l-0.32,0.32l-0.34,0.2l-0.39,0.11l-0.39,-0.11l-0.42,-0.53l-0.24,0.04L241.78,56l-0.53,0.3l-0.34,0.34l-0.24,0.89l-0.24,0.32l-0.56,0.27l-0.4,0.05l-0.43,0.25l-0.56,0.04l-0.4,-0.27l-0.48,-0.11l-0.4,0.07l-0.29,0.21l-0.29,0.39l-0.06,0.91l0.5,1.49l-0.21,0.43l0.47,1.4l0.32,2.09l0.24,0.11l0.69,0.05l0.52,0.28l0.47,0.02l1.5,-0.23l1.22,0.16l0.74,-0.28l0.8,-0.67l0.32,-0.14l0.35,0.03l0.68,0.66l0.71,1.05l0.32,0.27l0.02,0.35l-0.23,0.58l-0.45,0.64l-1.63,1.58v0.32l0.32,0.43l0.03,0.44l0.56,0.28l0.39,0.02l1.3,-0.39l0.29,-0.02l0.1,0.11l0.11,1.68l-0.11,0.57l-0.21,0.48l-0.31,0.11l-0.89,-0.37l-0.13,0.05l-0.21,0.3l-0.21,0.62l-0.26,0.27l-0.97,0.35l-0.66,-0.09l-1.24,-0.6l-1.64,-0.28l-0.39,-0.19l-0.31,-0.39l-0.11,-0.43l-0.31,-0.35l-0.42,-0.27l0,0l-0.68,-0.34l-0.31,-0.3l-0.31,-0.07l-0.71,0.07l-0.19,0.2l-0.15,0.73l-0.03,1.52l-0.61,1.24l-0.32,0.46l-0.68,-0.87l-0.69,-1.29l-0.6,-0.71l-1.24,-0.99l-0.95,-0.39L231,71.14l0.34,-0.41l0.52,-0.35l0.63,-0.74l-0.06,-0.51l-2.58,-2.32l-0.55,-0.64l-0.32,-0.83l-0.02,-1.08l0.18,-1.77l-0.1,-0.96l-0.32,-0.98l-1.19,-2.11l-0.26,-1.9l-0.13,-0.44l-0.26,-0.32l-0.5,-0.07l-0.98,0.16l-0.48,-0.12l-0.96,-1.33l1.17,-1.47l0.27,-0.55l0.32,-0.04l0.31,0.23h0.23l-0.03,-0.18l-0.21,-0.02l0.05,-0.34l0.55,0.09l0.1,-0.3l-0.5,-0.09l-0.19,-0.18l-0.15,0.2l0.03,0.25l-0.19,0.05l-0.13,0.21l-0.11,-0.02l0.34,-0.73l0.13,-0.07l0.13,0.05l0.66,-0.94l0.11,-0.34l0.15,-0.02l0.08,0.23l-0.24,0.3l-0.03,0.18l0.29,0.14L227,50.79l1.88,0.11l0.55,-0.16l0.1,-0.12l0.68,-0.02l0.89,-0.52l1.53,-1.28l0.61,-0.68l0.42,-0.68l1.17,-1.21l0.23,-0.48l0.11,-0.14l0.19,-0.05l0.23,-0.53l-0.05,-0.25l0.08,-0.14h0.06l0.1,0.36l0.02,0.36l-0.06,0.09l0.11,0.57l-0.27,0.16l-0.26,0.41l-0.26,0.16l-0.06,0.44l0.27,0.05l-0.05,-0.27l0.06,-0.07l0.08,0.02l0.1,0.21l0.08,-0.04l-0.03,-0.28l0.16,-0.02l0.37,-0.32l0.23,0.27l0.32,-0.07l-0.08,-0.41l-0.52,-0.14l-0.06,-0.18l0.08,-0.09l0.61,0.18l0.08,-0.3l-0.82,-0.07l-0.05,-0.09l0.14,-0.41l-0.13,-0.41l0.19,-0.02l0.29,-0.37l0.18,-0.09l-0.02,-0.12l0.15,-0.14l0.39,-0.18l0.76,-1.32l0.56,-0.73l0.39,-0.85l0.15,-0.12l0.06,0.07l-0.08,0.05l0.02,0.18l-0.16,0.14l-0.1,0.34l-0.77,0.94l-0.32,0.77l-0.39,0.46l-0.03,0.18l-0.37,0.09l-0.05,0.14l0.19,0.02l0.56,-0.21l0.05,-0.16l-0.06,-0.14l0.37,-0.23l0.18,-0.25l0.13,-0.46l0.68,-1.03l0.03,-0.34l0.13,-0.05l0.02,0.11l0.21,-0.04l0.03,-0.2l-0.13,-0.11l0.06,-0.09l0.16,0.12l0.08,-0.37l-0.08,-0.11h-0.11v-0.11l0.26,-0.6l0.37,-0.02l0.16,0.16l0.53,0.05l0.23,-0.2l0.18,0.04l0.1,0.18l0.24,-0.18l0.03,-0.32l-0.18,-0.04l0.29,-0.34l-0.11,-0.55l0.05,-0.11l0.37,-0.05l0.05,-0.23l-0.16,-0.32l-0.1,-0.52l0.06,-0.14l0.11,0.05l0.08,-0.11l-0.16,-0.25l0.15,-0.16l0.05,-0.3l0.14,0.02l0.11,-0.09l0.06,-0.28l-0.05,-0.44l-0.1,-0.11v-0.34l0.08,-0.11l-0.47,-0.37l0.05,-0.45l-0.34,-0.09l-0.03,-0.6l0.08,-0.02l0.06,0.18l0.02,0.36h0.34l0.32,-0.48l0.27,-0.18l0.13,-0.27l0.24,-0.05l0.55,-2.12v-0.3l0.19,-0.48l-0.02,-0.43l0.37,-1.71l0.34,-0.39l0.11,-0.03l0,0l0.85,0.18l0,0l1.16,-0.44L247.75,27.75z"
				},
				{
					"id":"AE-NZ1",
					"title":"Neutral Zone",
					"d":"M241.95,112.36L241.72,112.14L241.65,111.61L241.52,111.51L241.68,111.2L241.6,111.02L241.23,110.74L240.86,110.25L240.2,108.9L240.09,108.54L240.15,107.34L240.03,107.14L238.46,105.83L237.8,104.85L237.56,104.07L237.65,103.79L237.89,103.53L238.54,103.26L238.95,103.25L239.47,103.38L240.14,103.74L240.42,104.11L241.66,104.98L241.66,104.98L241.66,104.98L241.66,104.98L242.21,105.69L243.5,106.71L243.5,106.71L244.4,107.73L244.4,107.73L244.69,107.82L244.69,107.82L243.73,110.34z"
				},
				{
					"id":"AE-NZ2",
					"title":"Neutral Zone",
					"d":"M258.32,101.56L258.05,101.35L257.08,101.14L257.08,101.14L255.57,101.03L254.02,101.25L254.06,101.03L253.09,100.49L252.12,100.17L252.12,100.17L252.01,98.98L252.01,98.98L252.85,98.02L254.81,98.12L254.81,98.12L255.68,98.44L255.68,98.44L257.29,98.66L257.29,98.66L258.06,99.11L258.06,99.11L258.05,99.15L258.05,99.15L258.27,101.11L258.27,101.11z"
				},
				{
					"id":"OM-BAN",
					"title":"Al Bāţinah North",
					"d":"M325.94,170.5L324.03,173.21L321.33,176.62L319.18,179.16L317.8,179.93L316.04,179.98L312.63,180.7L311.69,181.58L310.75,183.07L309.93,183.9L308.77,183.95L307.17,183.79L306.62,184.28L306.24,185.22L305.41,185.49L303.65,185.55L302.33,185.71L300.78,187.31L298.16,189.52L298.16,189.52L296.9,189.01L290.21,188.76L289.08,187.75L288.7,186.36L287.94,185.35L286.71,184.61L286.17,182.58L287.44,181.82L286.68,180.93L285.61,180.44L283.78,180.56L282.52,179.8L280.87,179.42L279.23,179.8L276.96,180.05L275.95,180.56L274.06,180.3L272.92,179.04L272.04,178.41L271.16,177.15L270.78,174.88L270.4,173.74L267.5,172.23L266.87,170.59L266.61,166.8L265.86,165.29L264.47,165.03L263.58,164.02L262.32,163.64L261.44,162.64L260.18,160.62L259.04,160.11L259.04,160.11L258.79,158.6L259.8,157.59L260.56,156.58L260.18,154.94L259.17,154.31L257.65,153.55L256.64,153.3L255.47,151.77L254.66,150.44L253.7,149.32L253.86,148.04L254.5,146.93L255.39,142.24L256.25,140.55L256.25,138.63L258.17,136.72L260.08,136.72L259.29,134.96L257.85,133.53L256.41,133.05L252.66,132.96L253.06,130.17L253.38,126.35L254.66,124.59L253.54,122.68L252.43,121.56L251.63,119.96L251.15,117.89L250.19,116.61L251.15,114.7L252.27,114.22L251.63,112.63L251.31,110.87L250.19,110.87L249.34,109.52L249.34,109.52L249.35,108.82L249.52,108.08L249.8,107.52L249.8,107.52L250.47,106.96L250.47,106.96L250.83,106.85L251.84,106.94L252.3,106.84L252.3,106.84L254.58,106.04L254.58,106.04L255.33,105.12L255.33,105.12L255.53,104.77L255.79,103.99L257.57,103.51L257.57,103.51L258.03,103.27L258.36,102.85L258.36,102.85L258.4,102.35L258.4,102.35L258.27,101.11L258.27,101.11L258.05,99.15L258.05,99.15L258.17,98.63L258.46,98.17L259.07,97.93L259.07,97.93L260.3,97.81L260.3,97.81L261.15,100.84L261.39,101.55L261.53,101.74L261.76,102.62L261.97,102.77L262.02,103.33L262.15,103.7L262.34,103.84L263.39,106.54L264.17,107.76L265.01,109.34L265.35,110.63L265.69,111.42L265.98,113.22L267.28,115.88L267.67,116.9L269.69,120.65L269.92,121.31L270.13,121.5L271,123L271.69,123.91L275.08,129.22L276.87,131.12L278.56,132.76L279.46,133.44L279.56,133.65L279.95,133.72L280.27,133.95L281.18,135.55L281.8,136.34L282.05,136.83L285.38,141.73L286.22,143.19L288.17,145.86L289.2,146.96L289.91,148.52L290.16,148.67L290.36,149.1L291.05,150.14L292.8,152.24L293.82,153.31L295.96,155.17L297.82,156.66L298.13,156.8L298.28,156.77L299.68,158.06L301.27,159.34L301.99,160.18L303.78,161.79L304.46,162.32L305.97,163.25L308.99,164.72L312.55,166.1L323.77,169.55z"
				},
				{
					"id":"OM-BAS",
					"title":"Al Bāţinah South",
					"d":"M298.16,189.52L300.78,187.31L302.33,185.71L303.65,185.55L305.41,185.49L306.24,185.22L306.62,184.28L307.17,183.79L308.77,183.95L309.93,183.9L310.75,183.07L311.69,181.58L312.63,180.7L316.04,179.98L317.8,179.93L319.18,179.16L321.33,176.62L324.03,173.21L325.94,170.5L325.94,170.5L327.48,171.09L330.56,172.5L334.32,173.61L336.3,174.06L338.6,174.34L340.05,174.34L341.42,173.97L342.39,173.36L342.42,174.13L342.76,174.81L343.74,175.86L346.33,177.44L347.38,177.84L349.56,178.12L351.77,178.12L355.41,177.77L355.41,177.77L355.33,182.13L354.07,186.55L355.21,186.93L356.6,188.57L356.6,188.57L356.95,188.54L356.6,189.71L356.09,190.84L355.46,191.98L355.46,191.98L354.07,192.99L354.07,194.25L354.07,194.25L354.83,195.13L354.83,196.14L354.83,196.14L351.8,196.27L351.8,196.27L350.66,197.28L349.65,197.53L349.65,197.53L348.77,197.03L348.77,197.03L347.64,196.9L347.13,198.79L347.13,198.79L346.75,200.18L345.87,201.57L344.73,202.45L343.6,202.83L343.98,203.71L344.86,204.6L344.48,205.61L343.85,206.49L342.84,206.74L342.08,207.5L341.69,208.71L340.62,210.7L339.77,213.23L337.24,214.29L334.92,213.02L331.12,213.23L328.38,211.55L325.85,211.97L322.26,212.39L318.88,212.6L316.98,211.33L315.08,211.12L312.55,210.28L311.29,209.23L311.08,206.69L308.54,205.22L308.33,203.32L304.54,201.84L302.98,200.7L302.04,199.73L300.25,199.08L300.25,199.08L299.89,198.46L299.89,198.46L298.84,196.78L298.42,194.67L296.31,193.82L297.54,191.36L298.16,190.53z"
				},
				{
					"id":"OM-BU",
					"title":"Al Buraymī",
					"d":"M241.09,103.2L241.37,104.08L241.62,104.55L241.62,104.55L241.77,104.82L241.66,104.98L241.66,104.98L240.42,104.11L240.14,103.74L239.47,103.38L238.95,103.25L238.54,103.26L237.89,103.53L237.65,103.79L237.56,104.07L237.8,104.85L238.46,105.83L240.03,107.14L240.15,107.34L240.09,108.54L240.2,108.9L240.86,110.25L241.23,110.74L241.6,111.02L241.68,111.2L241.52,111.51L241.65,111.61L241.72,112.14L241.95,112.36L241.95,112.36L242.48,112.82L243.72,113.16L244.23,113.12L245.5,113.28L246.94,112.82L247.26,112.57L247.5,111.49L247.71,110.94L248.99,110.56L249.14,110.33L249.34,109.52L249.34,109.52L250.19,110.87L251.31,110.87L251.63,112.63L252.27,114.22L251.15,114.7L250.19,116.61L251.15,117.89L251.63,119.96L252.43,121.56L253.54,122.68L254.66,124.59L253.38,126.35L253.06,130.17L252.66,132.96L256.41,133.05L257.85,133.53L259.29,134.96L260.08,136.72L258.17,136.72L256.25,138.63L256.25,140.55L255.39,142.24L254.5,146.93L253.86,148.04L253.7,149.32L254.66,150.44L255.47,151.77L256.64,153.3L257.65,153.55L259.17,154.31L260.18,154.94L260.56,156.58L259.8,157.59L258.79,158.6L259.04,160.11L259.04,160.11L256.73,160.33L254.98,161.45L252.27,161.45L250.35,162.4L248.12,162.24L246.36,161.6L242.81,161.72L239.48,163.98L241.58,167.83L242.85,171.02L240.3,171.18L237.91,171.82L235.67,172.93L234.88,175.49L235.19,178.2L236.15,179.79L236.95,182.03L238.55,184.58L239.98,186.65L239.02,187.93L239.02,190L237.91,190.96L234.56,191.28L231.37,192.24L228.81,193.19L225.78,195.43L223.23,196.86L220.84,199.1L218.44,200.37L214.45,200.69L210.31,200.69L206.96,200.53L202.54,200.12L202.54,200.12L203.35,196.93L204.04,192.93L204.37,192.34L205.31,191.16L206.67,189.87L207.54,189.23L208,188.67L208.31,188.1L208.55,186.97L209.04,185.4L209.29,183.43L209.35,182.07L209.64,181L210.33,179.32L210.75,178.58L212.79,176.1L213.58,174.9L213.78,174.25L213.8,173.65L213.38,170.97L213.62,167.75L213.44,167.11L213.16,166.58L212.59,166.28L212.09,165.86L211.22,165.57L210.48,165.13L209.26,164.33L208.79,163.91L208.6,163.1L208.49,161.91L209.18,161.71L211.35,161.53L212.14,161.3L212.63,160.94L213.33,160.72L215.51,159.72L214.75,159.71L216.42,158.46L217.12,158.11L217.85,157.91L221.81,158.06L222.68,158.32L223.25,158.36L223.95,158.25L225.7,157.5L226.3,157.58L226.61,158.07L227.97,159.06L228.53,159.13L229.11,158.91L232.83,156.98L239.06,155.38L239.64,155.15L239.96,154.9L239.78,154.1L238.44,151.68L237.31,150.26L236.94,147.37L236.53,147.01L236.35,146.72L236.15,146.08L236.23,145.46L235.68,144.81L233.53,144.93L231.75,145.83L231.16,146.23L230.74,146.32L230.33,146.3L229.48,145.78L228.59,145.36L227.69,145.5L226.83,145.51L226.34,145.39L226.02,145.2L225.81,144.93L225.83,144.58L226.47,142.45L227.79,140.36L229.03,138.61L229.12,137.42L229.04,135.14L228.9,134.41L228.29,133.6L227.21,132.65L226.84,132.45L226.71,131.43L226.86,130.48L226.8,127.22L226.43,126.28L226.41,125.56L226.14,124.6L226.27,123.66L227.82,122.71L227.91,122.2L227.73,121.12L227.76,120.32L229.28,118.89L229.49,118.19L228.33,115.43L227.96,113.92L228.36,112.11L228.39,111.16L228.04,110.1L227.75,108.25L227.43,106.85L227.34,106.13L227.43,104.83L227.61,104.25L227.91,103.8L230.83,99.98L233.02,98.55L234.82,97.7L236.14,97.47L237.21,97.7L238.31,97.76L239.56,98.33L239.56,98.33L240.15,98.7L240.15,98.7L240.77,100.04L241.02,101.35L241.06,102.21L241.06,102.21z"
				},
				{
					"id":"OM-DA",
					"title":"Ad Dākhilīyah",
					"d":"M358.11,188.44L361.01,188.19L362.26,193.45L365.47,193.02L365.68,194.5L366.44,195.01L366.94,196.27L368.33,197.78L369.09,199.42L369.09,199.42L369.72,201.06L371.03,202.47L371.03,202.47L372.12,206.3L373.13,208.95L373.13,208.95L373.76,211.98L373.76,211.98L374.01,215.26L373.25,216.78L371.87,216.9L371.36,216.15L369.47,216.65L367.7,217.66L366.31,218.29L364.04,218.79L362.53,220.31L360.89,220.81L358.74,221.07L356.72,222.33L355.21,224.22L353.31,226.24L351.8,228.26L351.93,233.56L350.03,234.07L348.9,235.45L353.42,331.77L353.42,331.77L353.42,331.77L353.42,331.77L354.33,353.55L354.33,353.55L354.33,353.55L354.33,353.55L271.41,322.11L271.41,322.11L275.75,293.06L278.79,277.17L279.85,267.88L281.75,258.39L282.38,253.96L281.32,252.9L281.54,249.53L285.76,233.49L287.02,228.22L288.71,225.89L289.76,221.04L291.66,215.98L293.35,217.45L295.46,218.51L301.79,212.18L302.64,209.65L301.16,206.69L301.58,201.42L301.58,201.42L300.25,199.08L300.25,199.08L302.04,199.73L302.98,200.7L304.54,201.84L308.33,203.32L308.54,205.22L311.08,206.69L311.29,209.23L312.55,210.28L315.08,211.12L316.98,211.33L318.88,212.6L322.26,212.39L325.85,211.97L328.38,211.55L331.12,213.23L331.12,213.23L331.12,213.23L331.12,213.23L334.92,213.02L334.92,213.02L334.92,213.02L334.92,213.02L337.24,214.29L339.77,213.23L340.62,210.7L341.69,208.71L342.08,207.5L342.84,206.74L343.85,206.49L344.48,205.61L344.86,204.6L343.98,203.71L343.6,202.83L344.73,202.45L345.87,201.57L346.75,200.18L347.13,198.79L347.13,198.79L347.64,196.9L348.77,197.03L348.77,197.03L349.65,197.53L349.65,197.53L350.66,197.28L351.8,196.27L351.8,196.27L354.83,196.14L354.83,196.14L354.83,195.13L354.07,194.25L354.07,194.25L354.07,192.99L355.46,191.98L355.46,191.98L356.09,190.84L356.6,189.71L356.95,188.54z"
				},
				{
					"id":"OM-MA",
					"title":"Masqaţ",
					"d":"M357.16,177.7L359.86,177.8L360.51,177.92L361.78,178.26L364.19,179.13L365.71,179.81L368.83,182.4L370.36,183.38L370.97,183.67L373.14,184.39L374.25,184.62L375.89,184.56L377.21,184.76L378.92,184.6L380,184.35L381.73,183.67L382.31,183.34L382.33,182.87L382.59,182.75L382.59,182.57L382.8,182.57L382.93,182.43L382.97,182.14L383.07,182.12L383.25,182.28L383.52,182.03L383.97,182.38L384,182.78L384.37,182.97L385,182.94L385.1,182.8L385.44,182.78L385.87,182.9L386.37,182.83L386.45,182.71L386.72,182.73L387.21,182.59L387.19,182.87L387.51,182.99L387.59,183.13L387.35,183.1L387.16,183.2L387.06,183.59L387.4,183.57L387.56,183.46L387.85,183.52L387.96,183.22L388.2,183.52L388.3,183.53L388.36,183.29L388.45,183.25L388.83,183.81L389.02,183.88L389.09,183.73L389.06,183.48L388.91,183.31L388.93,183.15L389.22,183.31L389.28,183.73L389.17,183.97L389.3,184.13L389.22,184.23L389.25,184.34L389.48,184.32L389.52,184.46L389.09,184.86L389.09,184.98L389.35,185.03L389.51,185.21L389.59,185.52L389.44,185.72L389.72,185.93L389.65,186.06L389.86,186.29L389.93,186.71L390.02,186.82L390.51,186.85L390.73,186.97L391,187.3L391.12,187.3L391.28,187.15L391.7,187.22L391.73,187.29L391.58,187.41L391.65,187.57L392.15,187.43L392.26,187.58L391.86,187.71L391.78,187.81L392.07,188.33L392.53,188.13L392.68,187.67L392.76,187.99L392.84,188.09L393,188.09L393.13,188.26L393.1,188.49L394.01,189.17L394.27,189.19L394.82,189.02L396.25,189.12L396.41,189.28L396.36,189.5L396.2,189.52L396.17,189.8L396.52,190.1L396.25,190.29L396.33,190.53L396.44,190.6L396.52,190.31L396.62,190.31L396.65,190.62L396.78,190.53L396.8,190.27L396.6,190.03L396.7,189.85L396.99,189.82L397.15,190.08L397.67,189.7L397.78,189.82L398.13,189.75L398.2,189.99L398,190.24L398.7,190.5L398.63,190.67L398.31,190.64L398.46,191.02L398.87,191.28L399.07,191.62L399,191.88L399.08,191.91L399.23,191.79L399.61,192.7L399.58,193.38L399.5,193.57L399.65,194.01L399.66,194.69L399.89,196.05L400.71,196.78L400.76,197.21L401.05,197.84L401.74,198.37L402.85,199.01L403.17,199.08L403.57,199.36L403.81,199.93L404.38,200.35L404.67,200.68L404.89,200.68L405.17,200.84L405.54,201.29L405.62,201.54L405.89,201.78L406.79,202.06L407.26,202.36L407.4,202.65L407.32,202.97L407.45,203.3L407.69,203.47L407.69,203.61L407.58,203.72L407.58,204.31L407.87,205.41L408.26,206.47L408.59,207.04L408.93,207.43L409.85,207.91L410.38,208.31L411.84,209.73L411.99,210.11L412.07,210.75L411.84,211.92L412.18,213.1L413.08,214.89L414.18,216.2L415.08,216.7L415.8,217.31L415.95,218.22L416.3,219.4L416.91,220.18L418.03,221.17L418.67,221.89L419.15,222.16L419.39,222.48L420.42,222.98L421.79,223.89L423.24,224.51L423.29,224.72L423.71,225.14L424.35,226.01L425.04,227.97L409.1,229.46L409.1,229.46L408.97,226.05L408.97,226.05L409.73,221.63L408.46,220.25L406.95,220.5L406.19,221.51L406.19,221.51L404.8,223.53L403.67,222.9L401.9,221.63L400.26,221L400.26,221L398.37,220.25L396.6,219.11L396.6,219.11L394.96,217.72L394.96,217.72L391.3,216.21L390.29,214.95L388.78,214.31L387.39,212.3L386.25,210.91L386.25,210.91L385.75,210.15L385.5,208.76L385.5,208.76L380.7,208.51L379.19,207.12L377.55,206.36L377.55,206.36L376.28,205.48L374.64,204.6L373.38,203.71L372.37,202.83L372.37,202.83L370.98,202.45L369.72,201.06L369.09,199.42L369.09,199.42L368.33,197.78L366.94,196.27L366.44,195.01L365.68,194.5L365.47,193.02L362.26,193.45L361.01,188.19L358.11,188.44L358.11,188.44L356.6,188.57L356.6,188.57L355.21,186.93L354.07,186.55L355.33,182.13L355.41,177.77L355.41,177.77z"
				},
				{
					"id":"OM-MU",
					"title":"Musandam",
					"d":"M269.16,7.69l0.05,0.25l0.19,0.13l0.21,0.32l-0.06,0.36l-0.08,0.07l0.11,0.21l0.21,-0.23l0.1,0.02l0.02,0.18l-0.29,0.25l-0.56,-0.04l-0.29,0.11l-0.23,0.27l-0.29,-0.05l0.05,-0.27l0.26,0.02l0.27,-0.25l0.03,-0.23l0.13,-0.13l-0.19,-0.39V8.01l0.1,-0.18L269.16,7.69zM264.74,8.37l0.19,0.07l0.08,0.25l0.35,0.05l0.19,-0.14l0.06,0.04l-0.03,0.21l-0.21,0.18l-0.06,0.29l-0.13,-0.14l-0.58,-0.05l-0.23,-0.27l-0.02,-0.11l0.16,-0.25L264.74,8.37zM257.83,76.45l0.09,1.76l-0.23,0.42l-0.06,0.87l0,0l-0.08,0.39l-0.19,0.3l0,0l-0.19,0.25l-0.63,0.28l0,0l-0.39,0.28l0,0l-1.14,0.65l-0.79,0.78l0,0l-0.4,0.12h-0.42l-2.08,-0.41l0,0l-0.6,-0.27l-0.19,-0.19l-0.14,-0.5l0,0l-0.4,-3.08l0.5,-1.31l0,0h0.97l0.71,-0.18l1.45,-0.71l0.19,-0.44l0.08,-1.19l0,0l0.13,-0.58l0.27,-0.39l0.48,-0.32l1.67,-0.57l0.52,-0.28l0.59,-0.54l0,0l0.18,1.81l-0.32,1.62L257.83,76.45zM256.11,77.96l-0.97,-0.43l-0.97,0.65v0.86l0.97,0.43l0.97,-0.54V77.96zM260.54,7.62l0.06,0.16l-0.45,1.2l0.11,0.11l0.27,-0.04l0.11,-0.21l-0.02,-0.3l0.47,-0.16l0.02,0.57l-0.29,0.61l0.42,-0.11l0.13,-0.21l0.06,-0.41l0.11,-0.05l0.18,0.04l-0.13,0.89l0.31,-0.07l0.53,-0.98l0.23,0.25l0.16,0.3l-0.05,0.3l-0.4,-0.05l-0.05,0.09l0.06,0.23l0.18,0.11l-0.03,0.14l-0.18,0.04l0.06,0.29l-0.13,0.43l0.11,0.11l1,-0.75V9.94l0.08,-0.02l0.27,0.48l0.1,-0.21l0.26,-0.2l-0.03,0.2l-0.23,0.34l0.26,1.04l0.21,0.04l0.08,-0.18l0.21,0.04l0.05,0.11l0.15,-0.07l0.05,-0.32l0.15,-0.14l0.27,-0.09l-0.11,0.79l0.34,0.05l0.23,0.2l0.15,-0.32l0.13,-0.05l0.05,0.09l0.87,0.23l0.56,-0.25l-0.02,-0.25l-0.37,-0.3l-0.11,-0.21l0.1,-0.29l-0.24,-0.11l-0.32,0.04l-0.37,-0.38l0.02,-0.21l0.27,0.05l0.11,0.16l0.24,-0.02l0.35,0.2h0.15l0.06,-0.05l-0.06,-0.25l0.26,-0.05l0.06,-0.13V9.8l-0.14,-0.05l0.06,-0.13l0.39,0.04l0.02,0.13l-0.16,0.14l-0.03,0.75l0.32,0.52l-0.24,0.57l0.03,0.16l0.63,0.04l0.02,-0.11l0.18,-0.02l0.13,0.27l-0.11,0.29l-0.29,0.3l-0.24,0.02l-0.37,-0.23l-0.37,0.25l0.14,-0.45l-0.06,-0.18l-0.19,-0.04l-0.82,0.21l-0.48,-0.11l-0.56,0.13l-0.43,0.3l-0.24,0.36l-0.11,-0.11l0.03,-0.25l-0.08,-0.04l-0.16,0.14l-0.58,-0.02l-0.02,0.14l-0.42,0.13l-0.08,-0.18l-0.18,0.02l-0.05,0.39l0.16,0.04l0.4,0.93l-0.58,-0.05l-0.21,-0.36h-0.21l-0.4,0.07l0.03,0.32l-0.26,-0.2l-0.26,-0.02l-0.21,0.2l-0.08,0.23l0.14,0.39l0.31,-0.11l0.06,0.21l0.42,0.37l0.02,0.11l-0.06,0.29l-0.56,0.02l-0.03,0.16l-0.29,-0.04l-0.05,0.16l0.52,0.38l0.19,0.02l0.29,-0.14l-0.06,0.2l-0.45,0.14l0.43,0.45l0.5,-0.11l0.15,-0.2l0.1,0.09l0.11,0.14l-0.06,0.21l0.05,0.41l-0.1,0.18l0.06,0.09l0.51,-0.21l0.29,0.52l0.4,0.2l0.35,-0.21l0.29,-0.07l-0.05,-0.39l0.31,0.04l0.03,-0.16l-0.19,-0.18l0.08,-0.09l-0.11,-0.5l0.29,0.02l-0.02,0.34l0.18,0.27l0.74,0.04l0.11,-0.14l0.08,0.02l-0.01,0.42l0.69,-0.11l-0.23,0.2l-0.63,0.21l-0.23,0.27l0.03,0.14l0.18,0.09l-0.03,0.73l0.15,0.16l-0.02,0.13l0.35,0.36l0.06,0.32l-0.06,0.2l-0.53,0.12l-0.02,0.18l-0.16,0.01l-0.13,-0.11l0.13,-0.5l-0.31,-0.14l-0.11,0.09l-0.08,-0.04l0.45,-0.5V19.1l-0.08,-0.21l-0.16,-0.14l-0.45,-0.14l-0.43,0.21l0.02,0.23l-0.21,0.08l0.02,0.41l-0.37,-0.07l-0.15,0.05l0.31,0.54l-0.14,0.32l-0.19,-0.11l-0.02,-0.11l-0.27,-0.07l-0.1,0.14l0.26,0.14l0.05,0.11l0.11,0.87l-0.03,0.46l-0.19,0.37l0.5,0.45l0.26,-0.11v-0.2l0.11,-0.05l0.05,-0.3l0.35,-0.14l-0.06,0.36l0.64,-0.13l-0.06,0.27l0.29,0.43l-0.03,0.73l0.24,0.02l0.16,-0.18l0.23,-0.07l0.06,0.14l-0.06,0.16l0.27,0.29l-0.03,0.32l-0.35,-0.21l-0.48,0.39l-0.05,-0.09l0.1,-0.39l-0.24,-0.2l-0.35,0.16h-0.5l-0.19,-0.18l-0.19,0.04l0.02,0.2l-0.26,0.05v-0.23h-0.42l-0.16,0.27l-0.29,0.18l-0.26,-0.13l-0.02,-0.3l-0.18,-0.02l-0.13,-0.2l0.03,-0.27l-0.24,-0.45l-0.29,0.09l0.1,-0.43l0.16,-0.02v-0.21l-0.32,-0.12l0.05,-0.3l0.16,-0.34l0.15,0.11l0.16,-0.09l-0.15,-0.3l0.21,-0.39l-0.24,-0.34l-0.39,0.16L261.97,21l0.05,0.25h-0.23l-0.05,-0.16l-0.34,0.07l-0.03,0.21l-0.26,0.07l0.1,0.21l-0.05,0.43l0.23,-0.04l0.02,0.21l-0.35,0.09l-0.18,0.57l-0.37,0.04l0.16,-0.45l0.13,-0.09l0.02,-0.5l0.1,-0.09l-0.16,-0.21l-0.24,-0.13l-0.08,-0.23l0.05,-0.09l0.32,-0.04l0.14,-0.16l-0.14,-0.07l0.14,-0.25l0.25,0.04l0.2,0.18l0.27,-0.05l0.11,-0.11l-0.06,-0.11l0.08,-0.18l-0.23,-0.09l-0.05,-0.37l-0.31,-0.07l-0.32,-0.23l-0.27,-0.04l-0.29,0.13l-0.11,0.39l-0.34,-0.23l-0.15,0.05l0.05,0.45l-0.37,0.02l-0.32,0.68l0.06,0.09l0.34,-0.02l0.13,0.18l-0.27,0.37l-0.89,0.43l-0.61,-0.18l-0.37,0.48v0.18l0.5,0.32l0.02,0.18l-0.13,0.18l0.02,0.54l0.08,0.09l0.61,-0.59l0.03,-0.2l0.11,0.09l-0.24,0.66l-0.24,0.39l-0.16,-0.05l-0.1,0.11l0.06,0.14l0.19,0.04l0.15,0.2l-0.34,0.32v0.46l-0.11,0.07l-0.02,0.16l0.19,0.05l-0.27,0.36v0.23l0.35,0.04l0.5,-0.25l0.11,-0.3l-0.11,-0.11l0.02,-0.18l0.06,-0.09l0.18,-0.02l0.19,-0.68l0.13,-0.14l0.08,0.14l0.9,-0.84l0.29,0.39l-0.05,0.45l-0.16,0.04l-0.06,0.13l0.13,0.16l-0.19,0.34l-0.19,0.11l0.11,0.23l-0.03,0.16l-0.32,0.52l0.14,0.16l0.39,-0.12l0.03,0.34l0.18,0.18l0.48,-0.23l0.03,-0.11l-0.11,-0.11l-0.02,-0.16l0.05,-0.3l0.32,-0.25l0.26,-0.34l0.15,1.03l0.66,-0.62l0.13,0.05l-0.08,0.57l0.06,0.14l-0.03,0.16l-0.11,0.07l0.34,0.48l0.42,-0.11l0.76,-0.68l0.1,0.04L263.88,27l0.08,0.09l0.34,-0.23l0.1,-0.32l0.1,0.02l0.05,0.3l0.34,0.09l0.11,-0.14l0.18,0.37h0.31l0.23,-0.25l0.29,-0.04l0.02,0.18l0.15,0.09l0.02,0.09l-0.45,0.02l-0.29,0.18l-0.52,0.53l-0.1,-0.16l-0.26,0.21l-0.45,-0.07l0.06,0.21l-0.37,0.61v0.09l0.24,0.18l-0.16,0.32l0.13,0.3l-0.05,0.11l-0.47,0.05l-0.21,-0.25l-0.16,0.09l0.05,0.16l-0.1,0.05l-0.21,-0.05l-0.11,0.11l-0.37,0.02l-0.05,-0.53l-0.08,-0.02l-0.23,0.27l-0.23,-0.02l-0.27,0.07l-0.08,0.16h-0.26l-0.13,0.25h-0.15l-0.03,0.07l0.14,0.23l0.21,-0.04l0.14,0.09l-0.16,0.16l-0.16,0.04v0.09l0.15,0.05l0.02,0.16l-0.06,0.07h-0.27l-0.03,0.07l0.03,0.11l0.29,0.14l0.16,-0.02l0.29,-0.57l0.08,0.09l0.37,-0.11l-0.02,0.27l0.32,0.29l0.58,-0.16l0.21,-0.23l0.13,-0.02l-0.02,0.46h-0.16l-0.05,0.75l-0.1,0.16l0.11,0.18l0.23,0.02l-0.1,0.37l0.23,0.09l0.26,0.55l-0.13,0.05l-0.16,-0.09l-0.27,-0.37l-0.27,0.04l0.06,0.43l-0.24,0.11l-0.27,-0.07l-0.18,0.14l0.05,0.18l0.13,0.02l0.02,0.14l-0.4,0.05l-0.23,0.43l0.77,0.43l0.13,-0.13l0.13,0.05l0.05,0.16l0.39,-0.16l0.1,0.64l-0.18,0.14l-0.02,0.27l0.13,0.43l0.27,0.27l0.37,0.02l0.15,-0.23l0.27,-0.16l0.29,-0.02l0.37,-0.21l0.13,0.02l-0.24,0.14v0.12l-0.77,0.39v0.27l0.18,0.43l-0.03,0.12h-0.11l-0.32,-0.23l-0.1,-0.21h-0.58l-0.26,0.41h-0.13l-0.08,-0.18l0.06,-0.25l-0.06,-0.05L262.02,37l-0.15,-0.29l-0.35,-0.02l-0.1,0.11l0.03,1.21l-0.1,0.44l0.1,0.36l0.05,0.07l0.47,0.04l0.34,0.14l0.03,0.12l-0.06,0.23l-0.47,0.62l0.05,0.12l0.13,0.04l-0.19,0.75l-0.61,0.75l-0.69,-0.07l-0.05,-0.2l-0.58,0.27l0.05,0.41l0.29,-0.07l0.26,0.07l0.45,0.3l0.03,0.25l-0.05,0.14l-0.56,0.25l-0.22,0l-0.52,-0.3l-0.08,0.05l-0.05,0.18l0.19,0.36l0.27,0.02l0.26,0.14l-0.16,0.3l0.06,0.21l-0.05,0.2l-0.14,0.11l0.16,0.59l-0.55,0.36l-0.05,0.34l-0.43,0.59l-0.24,-0.39l-0.06,-0.53l-0.1,-0.02l-0.11,0.84l0.21,0.37l0.05,0.27l-0.24,0.36l-0.16,0.02l-0.06,0.43l-0.6,1.05l-0.56,0.37l-0.56,0.6l-0.21,0.09l0.03,-0.32l0.42,-0.57l0.06,-0.48l0.31,-0.44l0.02,-0.3l-0.19,0.04l-0.4,0.44l-0.03,0.16l0.16,0.09l-0.07,0.27l-0.55,0.37l0.03,0.3l-0.43,0.18l-1.14,1.55l-0.06,0.37l-0.15,0.2l0.02,0.23l0.71,0.12l-0.16,0.25l-0.24,0.09l0.02,0.16h0.18l0.08,0.62l-0.34,0.39l-0.21,-0.04l-0.27,0.8l-0.05,0.64l0.02,0.07h0.19l0.02,0.14l-0.18,0.09l-0.02,0.94l-1.33,1.21l0,0l-0.79,-0.07l-0.65,-0.32l-0.57,-0.49l-0.41,-0.57l-0.24,-0.73l-0.97,-0.81h-0.81l-0.75,0.23l0,0l-0.26,-0.38l0,0l-0.14,-0.53l0,0l-0.09,-3.36l0.18,-1.73l0.44,-1.15l-0.9,-2.31l-0.02,-1.16l0.13,-1.03l0,0l0.82,-2.66l-0.08,-0.76l0.35,-0.83l0,0l0.64,-4.67l-0.25,-1.14l0,0l-0.02,-1.34l0.25,-1.39l0,0l-0.31,-1.45l-0.61,-0.8l-1.5,-0.24l-1.16,0.44l0,0l-0.85,-0.18l0,0l0.29,-0.88l0.5,-0.71v-0.2l0.45,-0.3l0.9,-1.84l0.53,-0.86l0.23,-0.05l0.02,0.34l0.43,-0.07l0.27,-0.36l0.16,-0.39l0.35,-0.25l0.23,-0.79l0.16,-0.25l0.06,-0.59l-0.08,-0.27l0.16,-0.84l0.15,-0.11l0.13,-0.37l0.1,-0.48l-0.03,-0.41l0.18,-0.34l0.32,-0.29l0.26,-0.39l0.26,-0.21l0.19,-0.02l-0.06,-0.16l0.05,-0.23l0.42,-0.36h0.21l0.21,0.18l-0.08,0.61l0.06,0.45l-0.24,0.29l-0.05,0.23l0.32,-0.13l0.29,0.96l-0.19,0.3v0.14l0.18,0.21l-0.03,0.32l-0.13,0.11l0.06,0.23l0.31,-0.23l0.08,-0.77l0.19,-0.18l0.18,-0.02l0.53,0.16l-0.06,0.37l0.08,0.3l0.24,0.16h0.21l0.15,-0.09l0.02,-0.54l0.11,-0.3l0.26,-0.25l0.16,-0.07l0.43,0.14l0.11,0.23l0.11,0.04l0.08,-0.2l0.37,-0.16l0.08,-0.21l0.16,0.07v0.13l-0.29,0.8l0.05,0.43l0.15,0.05l0.19,-0.54l0.1,-0.14h0.16l0.08,0.61l-0.19,0.41l0.05,0.2l0.37,0.39l0.6,0.05l0.21,-0.09l0.02,-0.14l-0.1,-0.11l-0.37,0.09l-0.08,-0.11l-0.02,-0.21l0.14,-0.11l0.63,0.18l0.45,0.27h0.16l0.05,-0.32l0.42,-0.07l-0.02,0.45l0.13,0.23l0.37,0.09l0.14,-0.11l0.19,-0.59l-0.16,-0.25l0.26,0.04l0.05,-0.27l0.31,-0.45l0.03,-0.27l0.11,0.02l0.21,0.32l0.24,-0.02l0.69,-0.29l0.18,0.07l0.06,0.13l0.47,-0.09l-0.05,0.21l0.06,0.2l0.34,0.11l0.15,0.25l0.4,-0.05l0.05,-0.07l-0.39,-0.64l0.27,-0.04l0.29,0.11l0.13,0.16l0.18,-0.09l0.03,-0.2l-0.11,-0.14l-0.6,-0.39l-0.23,-0.05l0.02,-0.07l0.64,-0.13l-0.13,-0.61l-0.23,-0.18l-0.27,0.02l-0.06,0.11l-0.56,0.21l0.18,-0.55l-0.24,-0.38l-0.27,0.25l-0.02,0.29l-0.13,0.3h-0.08l0.06,-0.32l-0.11,-0.2l0.11,-0.27l-0.13,-0.05l-0.19,0.32l0.02,0.41l-0.08,0.23l-0.18,-0.13l-0.13,0.02l-0.1,-0.45h-0.11l-0.23,0.12l-0.11,0.34l-0.31,0.18v0.16l-0.35,0.29l-0.13,0.3l-0.16,-0.05v-0.13l-0.23,-0.18l-0.11,0.36l-0.27,0.45v0.14l-0.79,0.34l-0.6,0.07l-0.37,-0.46l0.14,-0.46l-0.24,-0.3l0.08,-0.84l0.34,-0.43l-0.03,-0.27l0.14,-0.18l0.15,-0.05l0.02,0.23h0.16l0.16,-0.27v-0.25l-0.32,-0.61l0.03,-0.07l0.23,-0.02l-0.02,-0.13l-0.23,-0.2v-0.13l0.26,-1.18l0.11,-0.14l0.24,0.16l0.27,0.52l0.39,-0.05l0.29,0.62l0.43,0.11l0.02,0.14l-0.16,0.3l0.02,0.45l0.32,0.14l0.35,0.02l0.16,-0.18l0.24,0.05v0.14l0.23,0.11l0.37,-0.52l-0.06,-0.41l-0.29,-0.02l-0.43,-0.45l0.27,-0.09l0.15,-0.16l-0.08,-0.2l-0.45,0.04l-0.43,-0.11l-0.1,0.16l-0.1,0.02v-0.79h-0.53l-0.05,-0.39l-0.16,-0.18l-0.74,-0.38l0.11,-0.43l0.63,-0.55l0.11,0.04l0.13,0.41l0.39,-0.29l0.26,-0.34h0.18l0.13,0.14l0.08,0.29l0.18,-0.16l0.16,-0.02l-0.05,-0.61l0.19,-0.46l-0.21,0.02l-0.16,-0.09l0.13,-0.18l0.08,-0.43l0.27,-0.39l0.05,-0.79l-0.11,-0.09l0.02,-0.25l0.16,-0.2l0.1,-0.5l0.27,-0.59L260.54,7.62zM259.17,8.42l0.19,0.23l0.34,0.14v0.16l-0.23,-0.02l-0.18,0.29l0.08,0.73l-0.21,1.07l-0.21,0.04l-0.16,0.25l-0.24,0.04l-0.14,-0.16l-0.03,-0.21l0.08,-1.13l0.16,-0.18l0.23,-0.55l0.39,-0.21l-0.05,-0.09l-0.21,0.05l-0.02,-0.38L259.17,8.42zM262.97,7.83l0.06,0.04L263,7.96l-0.21,0.05l-0.05,0.39l-0.23,-0.11l0.18,-0.43L262.97,7.83z"
				},
				{
					"id":"OM-SHN",
					"title":"Ash Sharqīyah North",
					"d":"M406.6,365.43l0.1,0.12h0.22l0.18,0.19l0.21,-0.02l0.02,0.19l0.24,0.24l-0.11,0.12l0.05,0.53l-0.16,0.21l0.02,0.39l-0.15,0.17l-0.13,0.38v0.36l-0.4,1.57v0.46l0.15,0.67l0.51,1.16l0.66,0.29l0.11,0.24l0.29,0.22l0.19,-0.05l0.24,0.19l-0.11,0.36l0.1,0.22l-0.16,0.14v0.14l0.1,0.29l0.23,0.21l-0.19,0.27l0.1,0.58l0.19,0.17l0.22,0.58l0.82,0.32l0.13,0.12l-0.02,0.15l-0.31,0.41l-0.37,0.32v0.15l-0.19,0.22l-0.05,0.22l-0.53,0.07l-0.55,0.39l-0.34,0.12l-0.35,0.02l-0.24,0.17l-0.39,0.08l-0.06,0.12l0.13,0.19l-0.13,0.12l-0.37,0.12l-0.31,0.21l-0.29,0.05l-0.31,0.27l-1.09,0.56l-0.71,0.53h-0.18l-0.42,0.5l0.1,0.14l-0.03,0.17l-0.35,0.1l-0.56,0.5l-0.39,0.87v0.48l0.16,0.31l-0.26,0.26l0.03,0.15l-0.1,0.27l-0.27,0.22l-0.02,0.22l-0.76,0.97l0.16,0.31l-0.05,0.41l0.08,0.26l-0.16,0.22l-0.22,0.72l0.13,0.46l-0.43,0.39l-0.47,0.8l-0.29,0.29l0.05,0.36l0.26,0.17l-0.21,0.14v0.27l0.23,0.03l0.02,0.34l0.11,0.12l-0.13,0.09l-0.19,-0.05l-0.05,0.1l-0.11,-0.03l-0.23,0.31l-0.22,0.02l-0.11,0.12l-0.05,0.36l-0.51,-0.03l-0.11,0.08l-0.08,0.24l-0.26,0.02l-0.23,0.27l-0.18,0.07l-0.21,0.26l-0.18,0.44l-0.21,0.1l-0.19,0.34l-0.1,0.34l-0.18,0.25l0.02,0.43l-0.34,0.12l-0.39,0.27l-0.27,0.43l-0.32,-0.1l-0.23,0.19l-0.26,0.03l-1.3,0.6l-0.21,0.26l0.05,0.34l-0.56,0.72l-0.82,0.03l-0.5,0.43l0.06,-0.29l-0.18,-1.02l-0.23,-0.26l0.08,-0.29l0.18,-0.24l-0.02,-0.29l-0.26,-0.46l0.16,-0.15v-0.39l-0.13,-0.38l-0.21,-0.19l0.08,-0.32l-0.15,-0.44l0.05,-0.26l0.13,-0.14v-0.2l-0.18,-0.32l0.13,-0.24v-0.2l-0.23,-0.48l0.11,-0.43l0.21,-0.31l-0.15,-0.68h0.19l0.11,-0.19l0.1,-0.97l-0.1,-0.87l0.1,-0.46l-0.11,-0.29l0.11,-0.14l0.02,-0.36l0.24,-0.12l-0.02,-0.15l0.39,-0.61l0.32,-0.21l0.05,-0.46l0.32,-0.14l0.18,-0.48l0.24,-0.12l-0.02,-0.14l0.29,0.05l0.17,-0.09v-0.12l0.19,-0.19l0.47,-0.1l0.1,-0.34l-0.05,-0.56l0.35,-0.48l0.52,-0.26l0.24,-0.31l0.06,-0.44l0.19,0.03l0.13,-0.1v-0.14l0.45,-0.65l0.15,0.07l0.08,-0.14l0.23,-0.08v0.1l-0.23,0.15l-0.05,0.17l-0.18,-0.07l-0.11,0.21l0.02,0.24l0.26,0.26l0.03,0.19l0.19,0.22l0.42,-0.15l0.4,0.03l0.32,0.14l0.11,-0.1l0.29,0.08l0.45,-0.51l0.45,-0.14l0.21,-0.36l0.28,-0.18l-0.03,-0.22l0.15,-0.38l0.03,-0.51l-0.08,-0.21l0.11,0.03l0.08,-0.14h0.1l0.21,-0.38l-0.16,-0.75l0.02,-0.36l0.18,-0.34l0.05,-1.57l0.61,-1.16l0.61,-0.87l0.34,-0.27l0.26,-0.63l0.06,-0.38l0.39,-0.43l0.42,-0.73l0.87,-0.92l0.69,-0.33l0.35,-0.29l-0.1,-1.23l0.19,-0.5l-0.27,-0.27h0.15l0.06,0.14l0.16,0.07l0.13,-0.32l0.03,-0.67l0.19,-0.38l0.03,-0.51l-0.03,-0.43l-0.13,-0.12l-0.02,-0.19l0.06,-0.07l0.42,-0.03l0.72,-0.41l0.26,0.09L406.6,365.43zM400.26,221l1.64,0.63l1.77,1.26l1.14,0.63l1.39,-2.02l0,0l0.76,-1.01l1.51,-0.25l1.26,1.39l-0.76,4.42l0,0l0.13,3.41l0,0l15.96,-1.46l0.39,0.92l-0.21,0.21l0.06,0.35l0.66,1.46l0.24,0.94l1.03,1.28l0.45,0.21l0.13,0.87l1.42,2.99l0.98,0.62l0.74,-0.1l0.18,0.05l0.26,0.26l0.39,-0.03l0.37,0.5l0.11,0.59l0.47,0.95l0.37,0.54l0.45,0.24l0.64,0.05l0.26,0.23l-0.11,0.4l0.02,0.24l0.13,0.52l0.19,0.31l0.34,0.33l2,1.18l0.27,0.42l2.72,2.57l3.01,1.92l0.14,0.29l0.4,0.23l0.02,0.23l-0.16,0.28l-0.13,-0.02l-0.24,-0.23h-0.16l-0.1,0.1l-0.34,-0.03l-0.23,0.19v-0.21l0.23,-0.31l-0.02,-0.16l-0.21,0.04l-0.58,0.62l0.13,0.14l0.26,0.02l-0.13,0.26l0.06,0.07l0.8,0.24l0.19,-0.12l0.02,-0.26l0.11,-0.12l0.14,0.12l0.31,-0.02l0.18,-0.24v-0.16l-0.09,-0.07l0.09,-0.19l0.13,-0.07l-0.13,-0.17l0.07,-0.05l0.27,0.1l1.71,0.16l0.88,-0.04l0.19,0.24l1.01,0.03l1.27,0.17l0.85,-0.02l3.3,1.11l0,0l-0.52,0.74l-1.38,0.69l-1.31,0.34l-2.27,0.83l-1.38,0.96l-1.65,0.21l-1.72,-0.55h-3.17l-0.89,0.34l-0.48,1.72l-2.07,2.89l-0.69,0.76l-1.38,0.21l-1.72,-0.28l-1.03,-1.1l-1.31,-1.03l-0.83,-0.41l-1.03,-0.28l-0.48,0.48l-0.28,1.31l0.62,1.1l0.21,1.45l0.48,2.07l0.07,1.31l0.28,0.96l-0.21,1.38l-1.93,1.45l-0.55,1.72l-0.83,0.96l-1.1,0.69l-1.24,-0.21l-1.79,-1.65l-2.55,-2.55l-1.79,-1.38l-1.79,-3.99l-1.45,-2l-1.24,-0.69l-1.65,-0.48l-1.65,-0.62l-1.65,-1.1l-1.51,-1.38l-1.17,-1.38l-0.34,-1.17l-0.28,-5.16l-1.51,-2.2l-1.79,-2.27l-1.79,-1.52l-1.65,-0.76l-1.79,-0.21l-0.55,1.17l-0.21,1.45l0.41,2.07v1.58l-0.96,1.65l-0.69,1.86l-0.48,1.03l-0.55,0.9l-0.69,2l-0.48,3.72l-0.9,0.83l-0.69,0.83l-1.24,0.41l-1.79,-0.07l-1.31,-0.62l-0.55,-1.51l0.21,-5.16l-0.21,-1.31l-0.69,-1.58l-1.65,-1.86l-1.38,-1.38l-1.24,-0.9l-1.24,-0.62l-2.13,-0.55l-1.38,-0.9l-1.03,-1.17l-1.38,-1.31l-0.69,-0.96l-0.34,-1.1l0.62,-3.3l0.41,-0.83l0.34,-1.03l-0.41,-1.45l-1.17,-1.38l-1.79,-3.51l-0.55,-1.51v-4.68l2.62,0.14l0.96,-0.62l0.62,-1.03l0.14,-1.52l0.96,-1.86l1.93,-3.03v-1.31l-0.69,-0.9l-1.31,-0.41l-1.27,-0.08l0,0l-0.54,-2.61l0,0l-1.01,-2.65l-1.09,-3.83l0,0l1.34,0.36l0,0l1.01,0.88l1.26,0.88l1.64,0.88l1.26,0.88l0,0l1.64,0.76l1.51,1.39l4.8,0.25l0,0l0.25,1.39l0.5,0.76l0,0l1.14,1.39l1.39,2.02l1.51,0.63l1.01,1.26l3.66,1.51l0,0l1.64,1.39l0,0l1.77,1.14L400.26,221z"
				},
				{
					"id":"OM-SHS",
					"title":"Ash Sharqīyah South",
					"d":"M453.27,251.18L454.65,251.46L454.8,251.6L454.78,251.93L454.51,252.19L454.65,252.38L453.77,253.29L453.77,253.75L453.86,253.87L454.48,254.11L454.81,254.39L454.62,254.49L454.69,254.8L455.52,255.11L455.6,255.25L455.83,255.34L456,255.1L456.71,254.66L457.15,254.73L457.29,254.47L456.95,254.3L456.68,254.3L456.7,254.16L456.46,253.97L455.91,253.95L455.73,253.83L455.47,253.42L455.46,253.03L455.17,252.86L455.1,252.64L454.91,252.6L454.66,252.22L454.83,252.05L454.99,251.51L455.51,251.54L455.67,251.68L456.21,251.68L456.28,251.79L456.15,251.86L456.17,251.98L456.5,252.32L456.67,252.34L457.16,252.76L457.69,252.72L457.9,252.57L457.74,252.39L457.82,252.05L457.65,251.93L457.24,251.93L456.95,252L456.7,252.24L456.6,252.24L456.54,251.87L456.42,251.82L456.47,251.72L457.52,251.53L457.81,251.37L458.37,251.35L458.58,251.46L458.68,251.68L458.66,252.24L459.11,253.73L459.22,253.9L459.77,254.25L459.82,254.59L459.93,254.7L459.93,254.97L460.14,255.34L460.29,255.34L460.35,255.96L460.53,256.26L460.45,256.67L460.59,257.02L460.64,257.45L460.83,257.76L461.01,258.44L460.99,258.61L460.29,259.06L459.69,261.12L459.69,261.43L459.8,261.74L459.95,261.97L460.09,262.02L460.17,262.31L459.83,263.23L459.72,263.84L459.75,264.3L460.13,264.7L460.01,265.76L460.14,266.69L459.72,267.75L459.37,269.08L459.19,270.56L459.32,270.84L458.32,271.53L457.07,272.65L456.87,273.07L456.89,273.29L457.05,273.41L457.05,273.55L456.76,274.04L456.12,274.83L455.36,275.28L454.54,276.73L453.69,277.77L453.35,278.54L452.21,279.69L451.68,280.46L451.21,282.03L451.37,282.46L451.53,282.53L451.56,282.71L451.29,283.28L450.98,284.23L450.52,284.83L450.55,285.26L450.42,285.69L449.83,286.69L449.74,287.21L450.11,287.61L450.2,287.99L450.13,288.31L449.83,288.92L449.57,289.18L448.49,289.92L447.49,290.83L446.25,292.44L445.43,293.68L445.4,293.85L445.5,294.11L445.82,294.44L445.75,294.87L445.42,295.11L443.19,297.31L441.42,299.33L441.02,299.9L440.43,301.47L440.39,301.95L440.64,302.33L440.57,303.15L439.12,305.6L438.83,306.22L438.83,306.44L438.95,306.53L439.04,306.84L438.8,307.36L437.92,308.9L437.06,309.95L436.68,311.04L435.55,312.91L435.12,313.29L434.79,313.74L434.44,314.46L434.36,315.13L432.46,317.54L432.11,318.57L432.16,318.74L432.38,318.95L432.77,319.04L432.81,319.36L432.56,319.96L432.35,320.2L432.03,320.31L430.43,321.18L427.15,322.64L424.61,323.57L423.82,323.97L422.06,325.12L420.33,326.61L416.37,329.67L414.79,331.01L412.34,333.48L410.53,335.85L409.29,337.1L408.48,337.63L407.64,338.39L406.6,339.74L403.91,342.79L402.46,345.14L401.3,346.74L400.76,347.68L400.63,349.02L400.93,349.58L401.16,349.65L401.16,349.86L400.9,350.32L400.93,350.66L398.92,352.7L398.02,353.93L397.51,355.47L397.51,356.19L397.59,356.52L397.36,356.48L397.23,356.74L397.23,357.19L397.46,357.77L396.94,358.02L396.48,358.54L396.14,358.62L396.15,358.37L396.62,357.58L396.46,357.05L396.65,356.95L396.65,356.79L396.49,356.6L396.28,356.57L395.85,357.1L395.03,357.7L394.92,357.92L394.63,358.2L394.59,358.35L394.77,358.59L394.77,358.76L394.58,359L394.59,359.19L394.22,359.39L393.97,359.96L393.52,360.01L393.37,359.62L393.4,359.43L393.21,359.5L393.02,359.74L393.24,359.92L393.21,360.06L393.03,360.09L392.95,360.21L392.97,360.63L393.35,360.83L393.31,360.99L393.1,361.07L393,361.28L392.28,361.4L392.03,361.55L392.24,361.7L392.68,361.72L392.55,361.86L393.11,361.81L392.79,362.06L393.1,362.08L393.31,361.88L393.4,361.53L393.39,361.16L393.48,361.05L393.71,361.82L393.93,361.88L394.25,362.11L394.66,361.98L394.74,361.84L394.96,361.72L395.11,361.72L395.27,361.94L395.51,362.03L395.22,362.22L394.64,362.15L394.24,362.25L393.92,362.83L394.35,362.83L394.38,362.95L394.63,362.88L394.67,362.59L394.85,362.63L394.88,362.8L395.08,362.61L395.51,362.49L395.96,362.15L396.77,361.84L396.72,361.55L396.96,361.09L396.91,360.85L396.52,360.42L396.48,359.98L396.59,359.53L396.78,359.26L396.52,359.27L396.44,359.17L396.62,358.91L396.85,358.85L397.1,358.54L397.44,359.02L397.52,359.48L397.38,360.9L397.41,362.11L397.22,362.37L395.66,362.71L394.85,363.5L393.9,364.8L392.87,365.35L390.86,366.65L388.64,369.23L388.64,369.33L388.75,369.35L389.06,369.21L389.57,369.26L389.75,369.42L389.62,369.42L389.49,369.69L389.69,369.72L389.85,369.95L389.7,370.19L388.94,370.84L388.82,371.13L388.53,371.26L388.38,371.52L388.19,372.13L387.74,372.96L387.82,373.55L387.77,373.76L387.63,373.91L387.61,374.18L387.42,374.34L387.29,374.34L387.11,374.68L387.14,374.85L387.27,374.87L387.24,375.24L387,375.59L386.84,376.06L386.4,376.1L386.34,376.54L386.03,376.87L385.92,377.28L385.92,377.43L386.08,377.48L386.03,377.76L385.95,377.93L385.65,378.08L385.63,378.2L385.73,378.39L386,378.29L386.06,378.54L385.37,379.51L385.19,380.08L385.05,382.13L384.71,382.35L384.58,382.52L384.6,382.72L384.52,382.83L383.96,383.1L383.86,383.54L383.67,383.73L383.49,383.8L382.91,383.78L382.76,383.87L382.59,384.23L382.09,384.31L381.96,384.52L381.98,384.94L381.56,385.08L381.12,385.78L380.79,386L380.37,386.45L380.37,386.84L380.21,386.94L379.35,386.77L378.02,386.74L377.63,386.51L377.33,386.14L377,386.17L376.6,386.04L376.04,385.56L375.27,385.08L374.86,384.96L372.98,384.98L371.74,385.32L371.02,385.66L370.24,385.58L369.99,385.71L369.78,385.69L369.57,385.54L369.52,385.44L369.6,385.25L369.46,385.06L369.23,384.99L369.02,384.77L367.56,384.11L366.67,383.99L366.06,383.51L365.88,383.07L365.9,382.9L366.08,382.74L365.88,381.84L366.08,381.63L366.25,381.68L366.59,381.34L366.62,381.07L366.96,380.61L367.06,380.21L367.23,379.91L367.23,379.58L367.36,379.22L367.8,378.47L368.02,378.32L368.35,377.6L368.25,377.55L368.36,377.36L368.49,377.4L368.57,377.28L368.72,376.29L368.72,376.29L371.63,376.55L372.06,373.18L373.11,370.64L373.11,368.32L372.06,362.2L354.33,353.55L354.33,353.55L353.42,331.77L348.9,235.45L350.03,234.07L351.93,233.56L351.8,228.26L353.31,226.24L355.21,224.22L356.72,222.33L358.74,221.07L360.89,220.81L362.53,220.31L364.04,218.79L366.31,218.29L367.7,217.66L369.47,216.65L371.36,216.15L371.87,216.9L373.25,216.78L374.01,215.26L373.76,211.98L373.76,211.98L373.67,211.56L373.67,211.56L374.94,211.64L376.25,212.06L376.94,212.95L376.94,214.26L375.01,217.29L374.05,219.15L373.91,220.66L373.29,221.69L372.32,222.31L369.71,222.18L369.71,226.86L370.26,228.37L372.05,231.88L373.22,233.26L373.63,234.71L373.29,235.74L372.88,236.57L372.26,239.87L372.6,240.97L373.29,241.94L374.67,243.24L375.7,244.42L377.07,245.31L379.21,245.86L380.45,246.48L381.69,247.38L383.06,248.75L384.72,250.61L385.41,252.19L385.61,253.5L385.41,258.67L385.96,260.18L387.26,260.8L389.05,260.87L390.29,260.46L390.98,259.63L391.88,258.8L392.36,255.09L393.05,253.09L393.6,252.19L394.08,251.16L394.77,249.3L395.73,247.65L395.73,246.07L395.32,244L395.53,242.56L396.08,241.39L397.87,241.59L399.52,242.35L401.31,243.86L403.1,246.14L404.62,248.34L404.89,253.5L405.23,254.67L406.41,256.05L407.92,257.43L409.57,258.53L411.22,259.15L412.88,259.63L414.12,260.32L415.56,262.32L417.35,266.31L419.14,267.69L421.69,270.23L423.48,271.89L424.72,272.09L425.82,271.4L426.65,270.44L427.2,268.72L429.13,267.27L429.33,265.9L429.06,264.93L428.99,263.62L428.51,261.56L428.3,260.11L427.68,259.01L427.96,257.7L428.44,257.22L429.47,257.5L430.3,257.91L431.6,258.94L432.64,260.04L434.36,260.32L435.74,260.11L436.42,259.36L438.49,256.46L438.97,254.74L439.87,254.4L443.03,254.4L444.75,254.95L446.41,254.74L447.78,253.78L450.06,252.95L451.36,252.61L452.74,251.92z"
				},
				{
					"id":"OM-WU",
					"title":"Al Wusţá",
					"d":"M354.33,353.55L372.06,362.2L373.11,368.32L373.11,370.64L372.06,373.18L371.63,376.55L368.72,376.29L368.72,376.29L369.39,375.02L369.46,373.64L369.81,372.97L370.04,373.04L369.92,372.7L370.05,372.19L369.26,371.81L367.94,371.37L367.49,371.08L366.51,370.77L366.03,370.77L365.85,370.67L365.58,370.67L365.35,370.92L364.6,371.01L364.18,371.18L363.65,371.93L362.78,372.25L362.5,372.44L361.75,373.25L361.18,373.26L359.65,373.89L359.17,374.25L358.8,374.9L358.9,375.18L358.9,376.24L358.33,377.52L358.48,377.93L358.3,379.1L358.45,379.82L358.01,380.2L357.76,380.15L357.19,380.78L356.77,380.73L355.95,380.97L354.42,381.6L353.44,382.13L352.24,382.98L351.59,383.71L351.35,384.11L351.13,384.77L351.13,385.52L351.25,386.17L351.64,386.8L351.82,386.89L352.7,386.97L352.96,387.14L352.54,388.15L352.01,389.07L351.74,389.31L350.59,389.84L348.57,391L347.46,391.77L345.75,393.49L345.61,393.76L345.59,394.29L345.35,394.73L344.33,395.77L344.16,396.13L344.01,396.99L343.82,397.41L343.75,397.8L343.92,399.64L344.09,400L344.38,400.12L344.74,400.1L344.9,400.65L344.74,401.21L344.7,402.01L343.93,404.6L343.96,404.89L344.27,405.2L344.19,405.57L343.98,405.86L343.93,406.39L343.61,407L343.47,407.6L343.53,409.28L343.09,409.88L342.4,411.09L342.15,412.47L341.1,414.44L340.94,415.17L341.16,415.5L340.47,417.26L340.17,417.83L340.26,418.15L339.37,419.3L339.28,419.83L339.39,420.12L338.93,420.82L336.56,423.5L336.14,424.25L335.89,424.93L335.77,425.41L335.77,426.7L336.17,428.06L336.43,428.38L336.87,428.7L337.19,428.72L337.49,428.55L337.62,428.96L337.88,429.18L338.14,429.2L338.27,429.04L338.46,429.04L338.27,430.44L337.78,431.37L337.98,432.44L337.01,435.46L336.87,437.33L337.11,437.77L337.22,438.26L337.66,438.48L337.82,438.71L337.83,438.94L338.09,439.06L338.32,439.35L338.51,440.55L338.77,440.88L339.01,441.03L339.41,441.96L339.86,442.17L339.89,442.88L340.26,443.52L340.68,445.69L340.52,447.29L340.17,448.05L339.68,449.48L339.47,450.68L339.47,453.88L339.67,455.1L340.05,455.76L340.47,457.58L340.67,458.17L340.97,458.66L341.47,459.15L342.05,459L342.5,459.05L343.09,459.84L343,460.86L342.6,462.11L342.66,462.84L342.56,463.76L342.68,465.04L343.14,465.58L343.66,465.55L343.59,465.75L343.69,466.99L343.92,467.83L344.2,468.43L344.62,468.97L345.22,469.14L345.3,469.43L344.56,470.05L344.19,470.19L343.87,470.58L343.61,470.39L343.43,470.61L343.38,471.1L343.22,471.24L342.87,471.32L341.37,471.27L339.54,471.56L339.04,471.93L338.46,472.52L337.88,472.67L337.41,473.01L336,473.21L324.85,473.06L320.08,473.32L314.61,473.98L311.91,474.55L309.64,475.26L307.69,475.68L306.02,476.21L299.37,477.85L298.26,478.22L297.52,478.61L296.81,478.78L295.6,479.3L293.35,480.4L290.61,481.33L288.99,482.04L286.5,483.56L285.16,484.54L284.23,485.23L283.18,486.26L282.58,486.97L282.39,487.39L281.09,488.8L277.35,493.35L276.66,493.88L276.24,494.32L276.02,494.65L275.68,494.96L275.39,495.43L275.05,496.68L275.47,496.36L275.89,495.13L276.34,494.54L275.95,495.31L275.58,496.44L275.05,497.45L274.88,498.06L274.97,498.82L274.97,499.8L275.31,502.87L275.18,503.39L274.73,504.1L273.88,506L273.69,507.96L273.81,509.14L273.69,510.13L273.35,511.42L273.28,512L273.09,512.44L272.75,512.85L272.32,513.96L270.88,516.42L270.37,518.84L270.1,519.26L270.11,520.04L270.29,520.22L270.45,520.68L270.42,521.15L270.55,521.91L270.51,522.5L270.06,522.76L269.03,523.08L268.79,523.32L268.39,524.11L268.1,524.43L267.83,524.62L267.42,524.72L266.36,525.21L265.83,525.63L265.3,525.89L263.95,526.97L263.55,527.61L263.5,528.45L263.56,528.89L263.39,529.23L262.24,530.29L261.47,530.79L260.84,531.48L259.94,531.75L259.51,532.1L259.2,532.46L259.06,532.77L259.04,533.23L259.04,533.23L238.45,497.88L219.25,466.86L198.78,435L180.64,408.23L180.64,408.23L196.4,358.07L203.08,336.44L205.07,330.33L205.05,330.1L205.18,329.9L205.18,329.9L271.41,322.11L271.41,322.11z"
				},
				{
					"id":"OM-ZA",
					"title":"Az̧ Z̧āhirah",
					"d":"M202.54,200.12L206.96,200.53L210.31,200.69L214.45,200.69L218.44,200.37L220.84,199.1L223.23,196.86L225.78,195.43L228.81,193.19L231.37,192.24L234.56,191.28L237.91,190.96L239.02,190L239.02,187.93L239.98,186.65L238.55,184.58L236.95,182.03L236.15,179.79L235.19,178.2L234.88,175.49L235.67,172.93L237.91,171.82L240.3,171.18L242.85,171.02L241.58,167.83L239.48,163.98L242.81,161.72L246.36,161.6L248.12,162.24L250.35,162.4L252.27,161.45L254.98,161.45L256.73,160.33L259.04,160.11L259.04,160.11L260.18,160.62L261.44,162.64L262.32,163.64L263.58,164.02L264.47,165.03L265.86,165.29L266.61,166.8L266.87,170.59L267.5,172.23L270.4,173.74L270.78,174.88L271.16,177.15L272.04,178.41L272.92,179.04L274.06,180.3L275.95,180.56L276.96,180.05L279.23,179.8L280.87,179.42L282.52,179.8L283.78,180.56L285.61,180.44L286.68,180.93L287.44,181.82L286.17,182.58L286.71,184.61L287.94,185.35L288.7,186.36L289.08,187.75L290.21,188.76L296.9,189.01L298.16,189.52L298.16,189.52L298.16,190.53L297.54,191.36L296.31,193.82L298.42,194.67L298.84,196.78L299.89,198.46L299.89,198.46L301.58,201.42L301.58,201.42L301.16,206.69L302.64,209.65L301.79,212.18L295.46,218.51L293.35,217.45L291.66,215.98L289.76,221.04L288.71,225.89L287.02,228.22L285.76,233.49L281.54,249.53L281.32,252.9L282.38,253.96L281.75,258.39L279.85,267.88L278.79,277.17L275.75,293.06L271.41,322.11L271.41,322.11L205.18,329.9L205.18,329.9L219.26,285.09L218.39,283.5L210.95,271.06L209.02,267.7L192.9,241.41L192.84,240.71L192.63,239.78L192.67,239.39L193.28,236.58L193.63,234.33L193.54,233.81L193.33,228.78L193.1,226.96L193.15,226.22L193.37,224.99L193.32,221.78L193.44,221.14L194.26,219.15L194.7,218.44L194.6,217.89L194.61,217.12L194.8,216.72L194.83,216.03L195.12,215.09L195.78,213.91L196.28,213.36L197.57,210.97L198.81,209.3L199.27,207.96L200.45,206.32L200.75,205.76L202.28,201.55z"
				},
				{
					"id":"OM-ZU",
					"title":"Z̧ufār",
					"d":"M180.64,408.23L198.78,435l20.47,31.86l19.2,31.02l20.59,35.35l0,0l-0.13,0.42l0.27,0.44l0,0.72l-0.18,0.2l-0.5,0.13l-1.11,-0.03l-1.11,-0.17l-0.9,-0.4l-0.39,-0.08l-0.31,-0.34l-1.38,-0.13l-0.34,-0.24h-1.01l-0.53,-0.15l-1.8,0.13l-0.42,-0.07l-0.27,-0.25l-0.97,0.37l-0.03,0.18l-0.29,0.32l-0.39,0.17l-0.63,0.13l-0.43,-0.15l-0.34,0.1l-0.68,0.02l-0.26,0.32l-0.27,0.05l-1.4,-0.27l-2.41,-0.32l-1.27,-0.02l-0.61,0.08l-0.35,-0.1l-0.29,0.12l-0.5,-0.13l-0.43,0.05l-0.69,0.29l-0.24,0.24l-0.29,0.05l-0.6,0.3l-0.21,-0.02l-0.72,0.76l-0.63,0.17l-0.08,0.15l-0.42,0.1l-0.26,-0.18l-0.4,0.29l-0.19,-0.1l-0.53,0.1l-4.28,-0.33l-0.72,-0.12l-2.99,-0.02l-0.13,0.1l-5.94,0.76l-3.35,0.62l-2.88,0.76l-3.12,1.24l-1.45,0.81l-1.67,0.67l-0.31,0.25l-0.11,0.57l-0.19,0.08l0.11,0.4l-0.18,0.24l-0.29,1.02l0.16,0.17l0.1,0.29l-0.23,0.6l-0.58,0.47l-0.63,0.3l-0.72,1.19l-0.02,1.19l0.15,0.64l-0.06,0.34l-0.21,0.27l0.03,0.39l-0.06,0.1l-0.9,0.42l-0.34,0.25l-2.17,1.14l-0.43,0.62l-0.47,0.33l-0.02,0.39l-2.17,1.36l-0.4,0.49l0.11,0.59l-0.53,0.82l-0.48,0.38l-0.23,0.4l-0.35,0.72l-0.42,1.21l-0.1,0.67l0.06,0.96l0.24,0.13l0.1,0.22l-0.03,1.22l0.26,0.75l0.37,0.54l0.42,0.27l0.42,-0.07l0.34,0.2l0.43,-0.03l0.08,-0.12l0.11,0.05l0.39,0.44l0.03,0.23l0.21,0.29l0.58,1.42l0.23,0.18l0.02,0.45l0.51,0.17l-0.13,0.22l-0.16,0l-0.19,0.22l0.11,0.67l-0.24,0.18l-0.16,0.32l0.11,0.74l-0.24,0.15l-0.11,0.25l-0.45,0.18l-0.08,0.65l0.11,0.32l-0.82,0.97l-0.1,0.45l-0.14,0.22l0.05,0.25l-0.85,0.54l-0.42,0.84l-0.05,0.6l0.72,1.11l0.5,0.32l0.1,0.33l-0.51,0.39l-0.18,0.67l-0.84,0.59l-0.24,0.57l-0.21,0.15l-0.66,0.18l-0.55,0.47l-0.4,1.05l-0.52,0.62l0.03,0.69l0.18,0.25l-0.03,0.13l-0.34,0.22l-1.74,0.18l-0.39,0.12l-0.35,0.25l-0.76,1.21l-0.35,0.3l-0.24,0.67l-0.77,1l-0.6,0.59l0.06,0.2l-0.48,0.3l-0.1,-0.1l-0.24,0.12l0.08,0.33l-0.31,0.43l-0.19,0.07l-0.6,0.5l-0.6,0.17l-0.55,0.33l-0.16,0.25l-0.03,0.22l-0.97,0.3l-0.26,0.7l-0.35,0.28l-0.02,-0.43l0.08,-0.25l-0.18,-0.3l-0.66,-0.33l-0.8,0.07l-0.45,1.19l-0.27,0.37l-1.29,0.55l-0.18,-0.02l-0.4,-0.27l-0.27,0.07v0.54l-0.16,0.15l-0.8,0.17l-0.13,-0.47l-0.52,-0.37h-0.13l-0.02,0.69l-0.21,0.15l-0.23,0.35l-0.03,0.22l-1.05,0.13l-0.26,-0.15h-0.18l-0.23,0.08v0.2l-0.14,0.13l-0.45,-0.03l-0.23,-0.17l-0.27,-0.07l-0.92,0.08l-0.39,0.2l-0.1,-0.1l-0.34,-0.02l0.06,0.18l-0.69,0.13v0.12l0.19,0.2l-0.18,0.18l-0.76,0.05l-0.43,0.13l-0.32,-0.12l-0.39,-0.42l-0.32,-0.12h-0.21l-0.26,0.38l-0.23,0.07l-0.11,-0.35h-0.18l-0.05,-0.17l-0.27,-0.22h-0.34l-0.11,0.08l0.02,0.3l-0.55,-0.13l-0.53,0.22l-0.1,-0.07v-0.12l0.15,-0.1v-0.27l-0.52,0.12l-0.06,-0.45l-0.74,-0.1l-0.37,-0.03l-0.05,0.27l-0.26,-0.17v-0.47h-0.19l-0.06,0.12l-0.29,-0.1l-0.18,-0.2l-0.06,-0.13l0.51,-0.72v-0.25l-0.24,-0.17l-0.05,-0.2l0.11,-0.23l-0.29,-0.35l-0.63,-0.35l-1.67,-0.5l-0.76,-0.13h-0.53l-0.13,0.08l-2.01,-0.05l-0.08,-0.12l-3.28,-0.22l-4.44,0.05l-0.19,0.12l-0.02,0.18l-0.19,0.05l-0.39,-0.4l-0.08,0.38l-0.31,-0.07l-0.02,-0.17l-0.11,-0.05l-1.3,-0.08l-3.36,-0.02l-4.65,0.5l-2.24,0.44l-9.3,1.4l-2.66,0.65l-0.6,0.4l-0.53,0.55l-0.45,0.95l0.13,0.12l0.15,-0.05l0.06,0.1l-0.1,0.42l0.06,0.3l0.18,0.03l0.31,-0.23l0.24,0.08l-0.02,0.2l-0.32,0.4l-0.43,0.07l-0.26,-0.08l-0.21,0.07l-0.19,0.2l-0.23,0.03l-0.18,0.13l-0.19,0.54l-0.45,0.13l-0.02,0.22l-0.35,-0.25l-0.76,0.13l-0.11,0.65l-0.1,0.03l-1.82,-0.03l-0.76,0.29l-0.51,-0.18l-0.89,0.03l-0.79,0.15l-0.14,0.18l-0.66,0.23l-0.85,0.15l-0.1,-0.12h-1.08l-2.46,0.48l-1.06,0.45l-0.08,0.08l0.06,0.28l-0.79,0.65l-0.21,0.28l-1.27,0.92l-0.19,0.23v0.23l-0.55,0.02l-0.08,0.28l-0.31,0.15l-0.13,0.17l-0.11,0.03l-0.19,-0.1l-0.24,0.1l-0.02,0.25l-0.4,0.27l-0.23,0.55l0.19,0.79l-0.16,0.22l-4.17,1.34l-0.82,0.4l-0.18,0.2l-0.32,-0.2l-4.14,-0.6l-2.56,0.38l-0.92,0.3l-3.35,0.79l-2.33,0.28l-0.95,0.25l-0.45,0.35l-0.61,0.13l-0.69,0.02l-6.31,1.74l-1.06,0.72l-0.68,0.13l-1.92,0.97l-0.6,0.43L69.54,612l-21.42,-26.35l2.07,-15.38L0,495.01l6.88,-25.76l2.3,-0.8l0.21,-0.16l1.1,-0.32l0.24,-0.16l0.96,-0.28l0.31,-0.18l1.02,-0.29l0.28,-0.19l1.06,-0.29l0.21,-0.17l0.25,0.01l0.86,-0.32l0.21,-0.17l0.63,-0.13l0.65,-0.34l0.24,0.01l0.86,-0.32l0.18,-0.16l0.24,0.01l0.98,-0.4l0.33,0.08l1.08,-0.62l0.24,0.01l0.88,-0.33l0.18,-0.14l1.06,-0.3l0.22,-0.17l2.4,-0.79l0.21,-0.16l0.78,-0.2l6.98,-2.57l16.59,-5.82l0.33,-0.18l32.66,-11.41l1.06,-0.45l1.14,-0.33l0.18,-0.14l0.49,-0.03l1.57,-0.62l6.14,-2.11l0.18,-0.14l4.08,-1.37l1.08,-0.47l5.3,-1.78l1.08,-0.38l0.18,-0.14v0.06l0.77,-0.22l1.82,-0.72l1.09,-0.31l0.24,-0.18v0.07l0.63,-0.2l0.65,-0.34l0.2,0.04l0.95,-0.34l0.14,-0.14l0.2,0.03l0.94,-0.32l0.15,-0.16l0.24,0.01l1.12,-0.48l0.46,-0.07l0.77,-0.38l0.22,0.03l0.93,-0.32l0.18,-0.17l0.24,0.01l1.07,-0.45l2.4,-0.76l0.18,-0.17l0.22,0.04l1.08,-0.48l1.17,-0.34l0.18,-0.15l0.18,0.04l1.08,-0.46l0.17,0.03l1.25,-0.53l9.29,-3.16l1.07,-0.45l0.14,0.04l2.24,-0.78l0.24,-0.15l1.04,-0.29l0.3,-0.17l1.15,-0.33l14.27,-4.99l1.31,-0.53L180.64,408.23zM229.93,559.76l0.71,0.42l0.21,0.18l0.03,0.15l0.23,0.1l0.55,-0.07l0.15,0.12l0.02,0.54l-0.27,0.3l-0.05,0.17l-0.19,0.08l-0.27,-0.02l-0.29,0.3l-0.4,-0.47l-0.15,0.25l-0.26,-0.27l0.21,-0.18l-0.13,-0.27l-0.23,0.07l-0.14,0.17l-0.24,0.05l-0.21,-0.12l-0.21,0.05l-0.03,-0.15l-0.13,-0.1l-0.06,0.29h-0.08l-0.19,-0.57v-0.08h0.13l0.02,-0.18l0.15,-0.03l0.03,0.17l0.18,-0.02l0.32,-0.5l0.14,0.02l0.24,-0.32L229.93,559.76zM241.53,557.06l0.11,0.07l0.03,0.18l0.19,0.27l-0.05,0.76l0.16,0.2l-0.05,0.37l0.19,0.47l0.58,0.07l0.19,0.15h1.19l0.05,0.27l-0.06,0.1l-0.16,0.03l-0.19,0.39l-0.98,0.25l-1.27,0.75l-0.31,0.1l-0.69,-0.07l-0.24,-0.13h-0.19l-0.02,0.22l-0.18,-0.03l-0.48,0.13l-0.11,-0.03v-0.15l-0.1,-0.1l-0.65,0.08l-0.96,-0.38l-0.24,0l-0.11,0.1l-0.74,-0.47l-0.13,-0.37h0.16v-0.15l-0.05,-0.07l-0.31,0.03l-0.03,-0.13l0.37,-0.55l1.32,-0.52l0.36,-0.05l0.03,-0.07l-0.1,-0.12l0.15,-0.13l0.29,-0.03l0.16,0.13l0.45,-0.03l0.26,-0.05l0.39,-0.27l0.39,-0.08l0.39,-0.2l0.55,-0.49l0.26,-0.39L241.53,557.06z"
				}
			]
		}
	}
};
