﻿// (c) ammap.com | SVG (in JSON format) map of Mexico
// areas: {id:"MX-AGU"},{id:"MX-BCN"},{id:"MX-BCS"},{id:"MX-CAM"},{id:"MX-CHP"},{id:"MX-CHH"},{id:"MX-COA"},{id:"MX-OCL"},{id:"MX-DIF"},{id:"MX-DUR"},{id:"MX-GUA"},{id:"MX-GRO"},{id:"MX-HID"},{id:"MX-JAL"},{id:"MX-MEX"},{id:"MX-MIC"},{id:"MX-MOR"},{id:"MX-NAY"},{id:"MX-NLE"},{id:"MX-OAX"},{id:"MX-PUE"},{id:"MX-QUE"},{id:"MX-ROO"},{id:"MX-SLP"},{id:"MX-SIN"},{id:"MX-SON"},{id:"MX-TAB"},{id:"MX-TAM"},{id:"MX-TLA"},{id:"MX-VER"},{id:"MX-YUC"},{id:"MX-ZAC"}
AmCharts.maps.mexicoLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-118.365366",
				"topLatitude":"32.719388",
				"rightLongitude":"-86.723663",
				"bottomLatitude":"14.530910"
			}
		},
		"g":{
			"path":[
				{
					"id":"MX-AGU",
					"title":"Aguascalientes",
					"d":"M390.24,367.07L387.83,363.6L393.33,352.9L399.66,349.82L401.26,347.64L408.53,352.83L410.26,357.31L410.26,357.31L410.28,359.5L412.24,361.64L407.96,363.61L404.69,367.66L400.41,368.76L396.5,366.33L392.29,365.95z"
				},
				{
					"id":"MX-BCN",
					"title":"Baja California",
					"d":"M106.2,195.13h-0.65l0,0l-2.88,1.84l-0.1,-1.51l3.7,-3.91l-0.76,2.25L106.2,195.13zM78.85,183.14l1.43,6.75l-0.64,2.99l-1.16,0.14l-1.26,-1.73l-1.96,0.27l2.81,-3.81l-0.44,-2.29L78.85,183.14zM136.99,174.58l3.51,2.45l-0.54,0.47L136.99,174.58zM145.45,173.08l0.07,1.66l-1.16,0.04l-0.35,-1.56L145.45,173.08zM2.59,160.01l-0.5,2.36l1.31,1.2l0.23,2.9l-1.41,2.31l-2.15,-7.58L2.59,160.01zM120.37,149.72l4.07,2.61l1.06,2.21l-0.47,2.03l5.08,0.95l-0.17,4.33l1.81,2.08l-0.34,1.9l-8.2,-8.21l-1.37,-0.26l-2.29,-3.56L120.37,149.72zM88.9,64.14l-2.66,0.13l-2.94,6.31l1.4,1.99l-1.11,7.6l5.69,3.84l0,0l0.45,5.74l-1.86,3.87l-0.88,9.55l1.98,3.47l-0.54,1.31l2.84,1.84l0.51,8.74l1.72,4.04l-0.92,8.77l3.35,6.44l3.13,2.55l0.42,2.76l1.26,1.04l1.51,-0.73l1.81,0.78l14.3,13.22l-0.41,2.22l2.87,4.19l-0.46,3.04l0.81,1.69l2.32,-1.69l1.43,1.21l0.51,3.04l2.41,-1.07l1.08,0.62l2.79,8.87l2.58,1.46l2.44,-0.59l1.37,0.93l-0.59,4.33l1.97,2.8l0.65,8.78l0,0l-1.51,-1.97l0,0l-31.69,-0.11l-0.17,-2.34l0.86,1.21l0.79,-1.39l-1.61,-0.41l-0.35,-1.72l1.52,-2.99l-1.81,-0.91l1.93,-6.07l-2.83,-2.82l-0.07,-2.03l-2.64,-0.52l-3.75,-6.29l-4.21,-2.36l-1.19,-3.77l-1.71,-0.12l-1.05,-2.33l-5.16,-5.1l-5.97,-1.91l-1.55,-2.51l-5.16,-3.13l-1.19,0.25L66.84,144l-0.07,-4.02l-2.71,-2.21l0.1,-8.96l-3.52,-3.79l-0.63,-2.16l0.27,1.34l-1.49,-0.35l0.27,1.44l-1.06,-2.05l-0.06,-8.88l-5.4,-5.4l-1.8,-0.27l0.74,-5.28l-1.38,-2.71l-3.94,-5.34l-4.1,-3.43l0.93,-3.25l-2.35,-2.48L42.67,87l1.25,-3.54l-6.73,-5.25l-0.93,-5.85l-3.06,-2.02l-2.14,-5.9l0.04,-1.34l60.19,-5.54l-2.25,3.02L88.9,64.14z"
				},
				{
					"id":"MX-BCS",
					"title":"Baja California Sur",
					"d":"M90.77,454.84l1.49,0.37l-1.8,0.58L90.77,454.84zM184.67,441.89l1.73,1.75l-0.85,2.17l-2.39,-2.2L184.67,441.89zM211.13,294.41l3.23,6.5l-2.27,-1.34L211.13,294.41zM159.65,290.27l3.12,0.16l2.87,2.17l0.98,3.26L159.65,290.27zM200.38,290.03l1.77,1.59l-0.93,2.03l-1.57,-2.15L200.38,290.03zM191.74,274.37l3.33,2.59l1.03,3.7l-3.11,-1.95l-1.57,-2.92L191.74,274.37zM156.07,269.79l-1.55,8.55l0.66,1.33l-1.27,1.74l3.93,8.51l-2.89,-3.11l0.98,-0.99l-0.92,-2.05l-3.25,-0.77L156.07,269.79zM190.03,257.61l0.31,3.3l-1.11,-1.84L190.03,257.61zM182.83,247.79l-0.1,2.69l-1.2,-0.74l-2.87,4.88l1.31,-6.1L182.83,247.79zM128.55,229.37l2.09,1.9l-2.93,-1.12L128.55,229.37zM157.11,214.6l1.06,1l-0.34,1.22L157.11,214.6zM162.18,209.09l0.7,0.68l-0.93,0.04L162.18,209.09zM105.55,195.13h0.65l0,0l32.41,0.1l0,0l1.51,1.97l0,0l4.35,6.44l5.88,2.74l3.62,9.47l2.6,2.1l3.94,1.2l-1.55,3.38l3.53,3.99l-0.85,3.22l3.23,4.25l1,0.75l1.55,-1.38l-3.45,-3.58l-0.91,-4.55l0.74,-0.47l6.5,5.55l0.16,4.08l2.72,0.85l-0.57,2.86l2.08,2.68l-0.28,1.8l1.98,5.16l-1,3.01l1.31,5.21l2.02,1.3l2.64,5.51l2.56,0.31l2.76,10.16l3.71,3.68l1.86,3.51l0.5,3.27l-1.61,2.7l-0.22,3.09l3.16,8.12l1.54,1.35l5.55,0.83l-2.43,0.38l0.21,1.46l1.68,-0.13l1.2,-1.81l-0.57,-4.25l2.27,-0.24l1.49,2.52l4.21,2.57l0.71,3.23l3.8,-0.58l-0.06,3.95l3.24,3.16l0.04,3.67l5.77,3.1l1.32,4.01l-1.1,5.64l-9.89,8.06l-2.72,0.7l-2.42,-2.01l-2.64,-9.87l-4.33,-7.01l-6.19,-3.28l-11.64,-11.53l-13.36,-8.24l-1.79,-4.2l-4.16,1.37l-0.58,-3.49l-1.92,-2.66l-4.57,-1.01l-0.29,-5.55l-0.62,4.69h-0.73l-0.36,-4.1l1.55,-2.12l-0.68,-2.72l1.85,-3.89l0.35,-9.03l-3.3,-10.59l-2.88,-2.3l-2.52,-4.8l-2.22,0.39l-4.55,-2.31l-6.98,-6.02l2.37,0.79l-5.1,-2.85l0.17,-1.29l-2.67,-4.05l-0.36,1.05l-1.51,-0.7l2.37,-1.72l-0.4,-4.1l-0.98,3.87l-1.63,1.01l0.06,1.83l-4.1,-1.54l0.29,-0.71l-1.44,0.22l-1.83,2.94l-1.54,0.15l-3.1,-2.34l-1.61,-3.69l-1.81,-1.34l-2.21,-0.57l-1.06,0.74l-3.46,-4.12l-7.41,-1.62l-1.33,-1.45l-0.51,-5.09l-5.67,-3.12l-2.89,-4.52l-1.29,0.49l-2.67,-1.52l-1.86,-3.59l14.47,2.08l3.81,-1.12l0.62,-1.84l0.86,0.29l-0.52,2.48l0.76,1.26l4.87,3.44l1.08,-1.96l2.1,0.72l2.45,3.09l0.59,-1.17l-1.57,-1.62l0.12,-1.05l0.81,0.24l-0.53,-3.7l-1.75,-1.44l-0.83,3.03l-3.18,1.21l-1.64,-1.24l0.85,-0.04l-0.74,-1.98l1.17,-1.74L105.55,195.13z"
				},
				{
					"id":"MX-CAM",
					"title":"Campeche",
					"d":"M671.68,444.21l-0.18,1.4l-1.61,-0.36l-1.64,2l-0.54,-0.67l-2.41,1.45l-1.63,-0.47L671.68,444.21zM700.38,390.75l-0.16,7.3l4.12,0.51l0.97,2.01l2.5,0.82l2.09,-1.55l5.3,9.33l3.86,2.1l4.34,6.07l1.22,3.89l0,0l6.64,6.06l3.41,4.67l-0.18,5.85l-1.58,1.33l-0.58,7.64l1.62,5.05l0.18,7.75l-3.01,4.1l0.25,2.46l0,0l-0.02,3.33l-45.94,-0.01l0,0l0.02,-1.64l-4.66,-1.16l-3.98,-3.11l-3.65,-0.8l-2.79,0.13l-0.27,3.84l-2.97,0.76l-5.02,-1.63l-4.34,-3.75l-3.68,-8.14l-0.98,0.38l-3.12,-2.12l-1.77,-4.63l0,0l12.96,-1.17l2.37,2.21l-0.6,1.18l-1.54,-1.33l-1.4,0.43l0.07,2.21l1.49,-1.33l2.1,1.6l6.79,1.67l6.76,-3.05l1.8,-4.55l-1.33,-1.7l-2.07,0.11l1.21,-3.28l-4.33,3.3l2.5,-2.57l11.6,-7.11l4.86,-4.53l0.82,-9.12l6.38,-7.51l-0.98,-2.71l-0.27,-11.61L700.38,390.75z"
				},
				{
					"id":"MX-CHP",
					"title":"Chiapas",
					"d":"M607.17,515.28l0.18,-0.64l0,0l1.1,0.75L607.17,515.28zM606.8,511.27l-0.01,-0.78l0,0l0.4,-3.57l-1.16,-3.78l2.19,-6.28l2.94,-2.62l1.87,-7.45l0,0l6.61,-4.88l0,0l5.77,-8.61l0.75,-7.08l2.2,-0.88l4.3,2.89l2.79,-0.09l-1.54,5.33l2.07,2.18l-0.3,1.87l2.59,0.11l2.72,3.78l10.73,-8.2l3.29,-1.19l0.5,-3.27l3.71,0.45l0.71,-1.84l1.89,1.26l2.99,-0.54l1.11,3.37l2.56,1.26l1.27,3.3l-0.75,2.66l5.84,2.39l1.1,1.79l-1.29,1.31l0,0l-0.08,1.04l1.74,1.08l1.77,-0.04l5.43,7.21l8.69,4.47l1.73,5.41l0.82,-0.1l-0.33,1.18l5.24,1.37l-0.7,9.07l-32.14,-0.27l-12.25,21.07l3.87,5l-2.2,2.24l0.13,2.49l-1.05,1.38l0.92,4.29l-1.96,3.42l-15.55,-16.48l-17.4,-15l-9.9,-6.06l1.95,-0.13l-0.98,-2.31l-4.66,-1.01L606.8,511.27z"
				},
				{
					"id":"MX-CHH",
					"title":"Chihuahua",
					"d":"M374.96,164.76L372.7,168.92L374.43,169.88L374.44,170.92L372.24,171.92L370.51,175.93L367.46,177.65L365.19,181.43L364.63,182.53L365.5,183.95L361.9,192.14L359.53,191.81L359.52,193.36L360.64,193.54L361.13,195L358.89,195.86L359.88,200.45L358.79,201.61L359.6,206.13L360.97,207.46L361.48,218.16L363.85,219.63L363.44,221.17L359.3,223.12L359.64,225.23L362.87,228.96L362.87,228.96L360.11,229.02L359.48,228.01L353.88,229.3L348.96,226.89L347.92,227.95L349.94,228.73L349.87,229.73L347.37,230.12L344.71,232.18L342.82,235.26L342.81,237.37L338.92,238.32L334.27,235.03L329.77,234.26L327.1,236.58L321.38,236.27L320.28,234.38L318.64,234.67L315.32,232.22L313.38,231.99L310.88,228.76L305.97,226.35L304.99,228.18L303.23,228.75L300.88,237.58L302.12,239.61L298.95,241.93L298.95,243.29L297.54,243.49L297.9,245.63L295.26,249.88L296.84,253.34L294.72,256.76L289.96,261.09L288.65,259.6L283.44,257.97L283.13,256.65L280.5,258.08L280.5,258.08L274.88,247.17L265.52,245.04L261.12,233.46L259.7,232.54L259.78,226.36L258.72,224.03L256.89,224.04L256.77,221.14L251.2,220.98L251.2,220.98L247.42,221.21L243.88,219.37L245.36,210.19L242.13,202.6L238.8,200.25L239.12,196.14L237.03,193.16L235.21,192.42L235.41,188.97L233.66,187.29L234.7,185.9L238.68,184.56L241.72,185.98L246.77,182.31L242.97,179.64L242.56,174.79L244.23,171.13L243.81,164.65L245.3,163.39L245.4,160.7L247.07,159.52L247.78,149.4L247.12,143.18L245.46,141.2L247.32,132.59L245.87,131.26L246.84,127.93L243.86,119.13L244.42,116.71L243.38,115.78L243.29,113.36L240.56,110.71L242.17,110.02L242.64,106.94L240.24,100.58L241.18,99.3L240.13,98.26L240.13,98.26L254.23,98.22L254.23,85.06L296.28,85.06L298.87,86L300.75,87.59L304.39,94.4L310.65,97.34L315.13,102.97L319.48,105.58L320.69,108.29L324.12,110.81L324.5,112.18L331.7,115.29L337.08,120.51L338.13,125.69L341.82,129.97L342.62,139.63L346.15,146.38L350,149.95L353.63,151.24L355.42,154.21L358.25,156.08L365.01,157.88L366.63,160.26L370.7,160.94z"
				},
				{
					"id":"MX-COA",
					"title":"Coahuila",
					"d":"M463.62,200.41L459.4,203.17L450.21,202.51L446.84,208.08L446.71,211.16L440.56,212.07L439.37,213.11L437.54,216.09L437.79,219.43L440.61,221.5L441.9,218.33L444.58,219.88L445,225.01L444.16,227.25L441.97,230.21L438.77,230.17L436.16,231.87L432.65,232.15L428.32,238.2L428.34,239.5L435.58,246.3L436.63,249.41L439.29,251.28L438.3,254.18L439.38,258.43L443.46,259.31L444.37,263.08L448.47,265.81L447.96,266.86L451.56,267.49L453.33,269.56L452.09,271.8L446.74,270.89L445.43,269.36L443.69,269.19L441.25,270.88L439.55,274.1L440.53,279.19L437.76,280.01L437.73,282.04L439.87,286.21L438.87,289.47L438.87,289.47L436.75,289L434.38,290.47L432.29,289.66L427.75,283.78L424.79,283.41L418.77,284.78L418.15,281.22L415.52,281.31L411.4,276.58L406.36,273.9L396.96,273.29L391.56,274.36L390.91,276.52L390.91,276.52L387.28,279.56L386.99,283.94L381.42,282.64L376.7,279.85L375.54,275.87L370.74,270.08L370.11,266.93L373.73,265.12L371.01,261.95L374.67,255.88L373.47,251.41L373.7,247.14L372.02,243.19L372.29,238.87L370.91,234.9L367.79,231.56L362.87,228.96L362.87,228.96L359.64,225.23L359.3,223.12L363.44,221.17L363.85,219.63L361.48,218.16L360.97,207.46L359.6,206.13L358.79,201.61L359.88,200.45L358.89,195.86L361.13,195L360.64,193.54L359.52,193.36L359.53,191.81L361.9,192.14L365.5,183.95L364.63,182.53L365.19,181.43L367.46,177.65L370.51,175.93L372.24,171.92L374.44,170.92L374.43,169.88L372.7,168.92L374.96,164.76L374.96,164.76L376.34,164.28L377.54,166.07L381.67,165.93L384.67,160.4L387.91,159.13L386.91,158.03L387.51,155.46L389.17,154L389.41,150.55L392.83,144.21L395.95,144.17L396.73,143.08L399.41,143.6L401.6,140.35L406.75,142.83L414.05,142.32L418.41,143.89L421.01,142.27L421.2,143.76L423.18,142.92L423.38,143.97L424.67,143.65L425.52,146.8L427.1,147.18L426.82,148.71L427.43,149.15L428.43,147.61L428.39,150.64L433.07,152.36L434.37,154.88L439.71,158.47L440.23,160.57L442.61,162.36L443.36,166.98L446.24,171L447.14,175.05L449.72,177.27L449.99,179.24L451.23,179.61L450.46,180.19L452.38,185.98L454.41,188.29L457.55,189.66L461.16,194.25z"
				},
				{
					"id":"MX-COL",
					"title":"Colima",
					"d":"M372.28,439.49L369.81,441.73L368.41,441.7L368.44,443.49L365.9,446.37L365.9,446.37L360.39,442.01L351.19,437.88L351.49,435.85L350.39,435.25L348.55,436.19L342.02,433.61L342.56,433.1L342.56,433.1L344.48,433.15L345.96,431.36L347.66,431.73L349.01,430.31L355.73,429.92L358.83,427.6L363.49,427.71L369.83,423.75L370.15,427.66L372.4,429.75L371.41,435.99z"
				},
				{
					"id":"MX-DIF",
					"title":"Distrito Federal",
					"d":"M488.1,436.52L484.8,437.25L483.89,436.45L481.96,437.66L479.3,436.73L479.3,436.73L476.58,431.37L479.75,428.62L482.54,424.18L484.87,429.07L488.03,432.45z"
				},
				{
					"id":"MX-DUR",
					"title":"Durango",
					"d":"M280.5,258.08L283.13,256.65L283.44,257.97L288.65,259.6L289.96,261.09L294.72,256.76L296.84,253.34L295.26,249.88L297.9,245.63L297.54,243.49L298.95,243.29L298.95,241.93L302.12,239.61L300.88,237.58L303.23,228.75L304.99,228.18L305.97,226.35L310.88,228.76L313.38,231.99L315.32,232.22L318.64,234.67L320.28,234.38L321.38,236.27L327.1,236.58L329.77,234.26L334.27,235.03L338.92,238.32L342.81,237.37L342.82,235.26L344.71,232.18L347.37,230.12L349.87,229.73L349.94,228.73L347.92,227.95L348.96,226.89L353.88,229.3L359.48,228.01L360.11,229.02L362.87,228.96L362.87,228.96L367.79,231.56L370.91,234.9L372.29,238.87L372.02,243.19L373.7,247.14L373.47,251.41L374.67,255.88L371.01,261.95L373.73,265.12L370.11,266.93L370.74,270.08L375.54,275.87L376.7,279.85L381.42,282.64L386.99,283.94L387.28,279.56L390.91,276.52L390.91,276.52L391.3,278.69L394.74,281.78L393.93,286.68L395.14,287.13L396.16,291.13L395.19,291.65L395.55,293.11L387.8,293.46L387.04,294.37L383.38,292.8L380.01,293.5L373.88,292.53L364.97,302.03L362.57,302.75L363.99,315.27L358.87,320.58L357.49,328.23L355.51,331.33L356.12,341.25L352.66,343.3L350.49,347.86L350.49,347.86L346.67,350.57L338.31,342.81L335.46,346.19L333.26,341.61L336.65,338.98L337.13,336.85L335.46,336.51L334.88,334.05L331.46,333.29L329.93,331.54L326.8,333.17L324.6,330.53L324.6,330.53L322.48,328.35L318.99,328.74L316.29,322.12L315.07,315.46L311.37,310.62L309.5,303.12L306.5,296.65L303.08,294.05L299.04,292.88L295.58,296.04L292.02,296.47L287.09,284.48L285.77,284.17L284.88,281.56L282.05,281.78L280.85,280.82L281.18,279.38L277.74,273.92L278.34,266.84L279.67,263.63L278.52,262.31L281.44,259.32z"
				},
				{
					"id":"MX-GUA",
					"title":"Guanajuato",
					"d":"M465.16,371.7L465.55,374.25L464.4,376.16L466.88,376.77L466.13,379.38L463.02,381.25L461.29,379.5L459.77,380.06L457.52,383.4L456.95,386.45L456.13,385.97L455.25,387.47L446.45,388.08L445.73,389.49L445.08,393.29L446.83,396.5L446.82,399.21L450.65,404.15L450.65,404.15L451,410.53L447.76,411.96L445.93,414.33L445.76,412.59L442.44,414.09L434.51,413.16L434,410.25L430.4,410.41L428.85,412.33L424.51,411.35L423.57,405.88L425.24,406.13L422.81,403.58L418.65,404.12L416.64,406.92L413.04,406.33L411.86,407.03L410.61,406.49L410.29,403.24L407.98,402.23L407.98,402.23L410.15,396.03L406.38,391.42L410.32,387.13L412.23,383.18L414.72,381.27L416.25,377.17L418.15,376.71L418.82,375.34L417.89,372.56L419.29,366.33L420.49,364.97L419.75,364.14L420.97,362.85L420.97,362.85L421.94,363.48L422.75,362.54L422.75,362.54L435.01,366.02L442.72,371.17L446.99,370.53L447.46,367.58L448.54,366.85L452.43,368.13L458.03,372.86L460.23,372.15L462.52,373.03z"
				},
				{
					"id":"MX-GRO",
					"title":"Guerrero",
					"d":"M449.19,436.82l0.3,2.94l-1.79,6.15l2.22,3.55l-1.91,2.54l3.5,0.72l1.79,3.04l3.17,-2.61l2.47,-0.58l-0.34,-1.98l7.33,-1l0.44,-1.56l1.76,-0.32l-0.36,-1.72l3.7,1.7l1.63,-0.37l0,0l-0.14,1.95l2.64,0.58l2.02,2.67l5.51,0.7l2.3,2.33l0,0l-0.05,1.23l2.7,1.8l1.22,2.25l2.99,-0.2l-0.62,1.77l4.21,1.78l0.12,1.07l4.28,-1.04l3.22,2.78l0,0l-1.91,5.37l2.73,6.06l0.6,4.58l-1.1,2.89l2.85,1.29l0.34,3.08l2.21,2.94l-0.92,2.88l-3.06,1.81l-0.18,1.35l-4.11,3.59l-0.46,2.02l-4.64,3.54l0,0l-5.49,-6.11l-3.3,0.54l-10.62,-3.2l-8.74,-1.22l-4.89,-2.84l0.39,-1.08l-1.35,0.71l-2,-2.17l-26.59,-9.48l-3.63,-3.95l-6.24,-2.63l-0.68,-1.93l-4.13,-1.76l-3.99,-5.57l-6.01,-2.8l-2.64,0.68l0,0l-0.71,-5.2l6.48,-2.62l2.44,0.09l-1.66,-0.29l-0.48,-5.86l0.3,-1.15l1.64,-0.82l0.53,0.82l1.22,-1.51l0.06,1.05l2.83,-0.89l3.2,2.81l5.7,-1.42l6.92,1.09l1.27,2.48l2.06,-0.98l5.76,3.36l0.77,-1.01l-2.83,-3.79l-1.52,-7.38l1.57,-1.88l0.99,1.61l4.46,-5.91L449.19,436.82z"
				},
				{
					"id":"MX-HID",
					"title":"Hidalgo",
					"d":"M496.34,374.47L497.48,375.39L497.18,378.05L499.01,379.76L504.47,380.21L507,383.63L505.14,386.09L504.81,389.99L503.36,390.22L501.56,388.83L498.2,392.39L497.04,399.43L498.21,402.02L499.59,402.88L509.02,394.88L511.31,395.48L511.31,395.48L511.38,398.48L507.61,402.38L503.99,404.23L504.69,405.64L506.81,405.16L507.27,407.35L504.92,415.23L505.62,419.96L505.62,419.96L503.24,419.46L500.97,422.14L492.87,423.9L492.87,423.9L494.34,416.6L488.53,417.21L486.81,419.79L485.92,419.68L485.07,417.01L487.03,415.88L487.67,410.26L480.46,412.65L479.93,416.4L479.24,417.16L477.11,416.15L476.94,418.39L475.73,419.38L475.43,415.55L473.18,412.39L473.88,411.4L472.37,408.27L466.95,406.75L463.14,403.87L463.14,403.87L464.15,397.33L471.89,393.83L471.26,391.81L474.38,387.63L475.41,382.75L477.06,381.32L478.27,382.03L482.38,380.74L483.66,377.61L483.66,377.61L485.92,376.86L487.06,379.26L489.48,380.32L490.83,377.94L491.75,379.25L494.66,374.45z"
				},
				{
					"id":"MX-JAL",
					"title":"Jalisco",
					"d":"M390.24,367.07L392.29,365.95L396.5,366.33L400.41,368.76L404.69,367.66L407.96,363.61L412.24,361.64L410.28,359.5L410.26,357.31L410.26,357.31L413.8,358.22L420.97,362.85L420.97,362.85L419.75,364.14L420.49,364.97L419.29,366.33L417.89,372.56L418.82,375.34L418.15,376.71L416.25,377.17L414.72,381.27L412.23,383.18L410.32,387.13L406.38,391.42L410.15,396.03L407.98,402.23L407.98,402.23L397.25,403.78L388.7,409.69L384.74,407.98L384.44,409.13L383.15,409.2L382.74,413.9L385.96,413.67L389.83,415.25L390.44,417.46L389.18,419.01L391.09,423.21L390.46,425.8L393.82,425.73L394.49,427.97L391.28,432.78L387.6,432.92L379.79,439.45L377.71,437.68L375.49,439.38L372.28,439.49L372.28,439.49L371.41,435.99L372.4,429.75L370.15,427.66L369.83,423.75L363.49,427.71L358.83,427.6L355.73,429.92L349.01,430.31L347.66,431.73L345.96,431.36L344.48,433.15L342.56,433.1L342.56,433.1L339.29,432.24L339.68,430.59L337.63,430.92L333.74,428.13L332.31,423.65L326.23,418.17L320.79,409.41L320.66,405.98L317.61,402.8L317.15,401.15L319.15,399.51L326.56,398.35L328.06,397.25L328.72,395.64L327.13,393.61L327.13,393.61L331.58,387.99L335.08,388.01L339.52,385.36L342.23,387.52L345.31,388.3L353.03,396.64L351.07,391.09L352.34,390.27L353.84,381.76L357.88,381.53L363.76,378.6L364.32,372.08L361.19,366.55L356.69,365.95L355.73,361.62L352.89,359.89L351.24,360.41L350.78,357.39L351.84,352.02L351.84,352.02L352.92,350.81L354.27,351.15L354.63,348.12L357.73,346.95L357.48,351.05L359.28,349.91L360.31,348.73L358.52,342.67L363.34,340.76L365.15,341.77L360.74,349.59L360.7,352.91L361.91,354.69L363.07,354.86L363.45,353.7L363.45,346.66L367.51,345.42L370.33,347.25L370.93,349.18L367.11,356.51L367.6,357.62L373.1,357.12L376.42,353.5L375.18,352.47L375.49,350.6L377.37,349.87L379.54,350.04L379.19,352.41L382.35,353.37L380.46,359.75L375.18,362.32L370.49,366.12L370.34,370.38L366.93,372.72L367.78,375.2L370.4,375.39L370.64,376.99L365.43,379.92L368.1,381.04L370.54,384.04L372.8,383.85L375.7,385.46L379.13,384.23L380.84,384.66L382.42,383.77L383.38,381.21L386.27,381.22L392.14,376.91L393.58,372.91L390.8,371.13z"
				},
				{
					"id":"MX-MEX",
					"title":"México",
					"d":"M463.14,403.87l3.81,2.88l5.42,1.52l1.51,3.12l-0.7,1l2.25,3.16l0.3,3.83l1.21,-1l0.17,-2.24l2.13,1.01l0.69,-0.77l0.53,-3.75l7.21,-2.39l-0.64,5.63l-1.96,1.12l0.86,2.67l0.88,0.11l1.72,-2.58l5.82,-0.61l-1.47,7.3l0,0l2.25,2.18l0,0l0.96,11.56l0,0l-3.51,2.24l-2.55,-0.94l-1.91,-2.42l0,0l-0.07,-4.07l-3.16,-3.39l-2.33,-4.88l-2.79,4.44l-3.17,2.75l2.72,5.36l0,0l-6.2,10.58l0,0l-1.63,0.37l-3.7,-1.7l0.36,1.72l-1.76,0.32l-0.44,1.56l-7.33,1l0.34,1.98l-2.47,0.58l-3.17,2.61l-1.79,-3.04l-3.5,-0.72l1.91,-2.54l-2.22,-3.55l1.79,-6.15l-0.3,-2.94l0,0l5.27,-9.84l-0.44,-5.18l-1.52,-2.42l3.24,-0.91l1.61,-3.76l-0.82,-3.86l0,0l2.55,-0.31l1.92,-2.01l-0.83,-2.69l1.78,0.17L463.14,403.87z"
				},
				{
					"id":"MX-MIC",
					"title":"Michoacán",
					"d":"M407.98,402.23L410.29,403.24L410.61,406.49L411.86,407.03L413.04,406.33L416.64,406.92L418.65,404.12L422.81,403.58L425.24,406.13L423.57,405.88L424.51,411.35L428.85,412.33L430.4,410.41L434,410.25L434.51,413.16L442.44,414.09L445.76,412.59L445.93,414.33L447.76,411.96L451,410.53L450.65,404.15L450.65,404.15L456.53,410.85L456.53,410.85L457.35,414.71L455.74,418.46L452.5,419.37L454.03,421.8L454.46,426.98L449.19,436.82L449.19,436.82L446.94,438.2L442.48,444.11L441.49,442.5L439.92,444.38L441.44,451.76L444.27,455.55L443.5,456.56L437.74,453.2L435.68,454.18L434.42,451.69L427.5,450.6L421.8,452.02L418.6,449.21L415.77,450.1L415.71,449.04L414.49,450.55L413.96,449.73L412.31,450.55L412.01,451.71L412.49,457.57L414.15,457.86L411.71,457.77L405.23,460.39L405.94,465.59L405.94,465.59L404.85,466.88L375.55,457.76L371.74,455.44L369.97,451.33L367.1,449.1L365.9,446.37L365.9,446.37L368.44,443.49L368.41,441.7L369.81,441.73L372.28,439.49L372.28,439.49L375.49,439.38L377.71,437.68L379.79,439.45L387.6,432.92L391.28,432.78L394.49,427.97L393.82,425.73L390.46,425.8L391.09,423.21L389.18,419.01L390.44,417.46L389.83,415.25L385.96,413.67L382.74,413.9L383.15,409.2L384.44,409.13L384.74,407.98L388.7,409.69L397.25,403.78z"
				},
				{
					"id":"MX-MOR",
					"title":"Morelos",
					"d":"M479.3,436.73L481.96,437.66L483.89,436.45L484.8,437.25L488.1,436.52L488.1,436.52L490.01,438.94L492.56,439.88L496.07,437.64L496.07,437.64L493.31,444.72L494.58,452.56L494.03,453.28L490.76,450.76L485.42,455.55L485.42,455.55L483.12,453.21L477.61,452.52L475.59,449.84L472.95,449.26L473.1,447.31L473.1,447.31z"
				},
				{
					"id":"MX-NAY",
					"title":"Nayarit",
					"d":"M303.72,376.47l-0.63,1.19l-0.46,-0.71L303.72,376.47zM298.54,372.12l1.96,1l-0.65,1.14l-2.68,-1.4L298.54,372.12zM293.12,366.82l2.62,0.7l0.91,2.68l-2.97,-0.89L293.12,366.82zM317.4,343.32l1.69,10.3l-3.49,-9.02l2.14,1.28L317.4,343.32zM324.6,330.53l2.2,2.64l3.13,-1.63l1.52,1.75l3.42,0.76l0.58,2.47l1.67,0.34l-0.47,2.13l-3.4,2.63l2.2,4.58l2.85,-3.38l8.35,7.77l3.82,-2.72l0,0l1.35,4.16l0,0l-1.06,5.37l0.46,3.02l1.66,-0.52l2.84,1.72l0.96,4.34l4.5,0.6l3.13,5.53l-0.56,6.52l-5.89,2.93l-4.04,0.23l-1.5,8.51l-1.27,0.82l1.96,5.55l-7.71,-8.34l-3.08,-0.79l-2.71,-2.16l-4.44,2.65l-3.51,-0.01l-4.45,5.62l0,0l-1.22,-1.75l-1.35,0.66l-3,-0.99l5.16,-7.06l1.02,0.35l1.14,-1.62l-0.44,-6.95l1.19,-3.94l-6.32,-3.7l-4.4,-8.64l-0.54,-5.86l0.8,-0.38l3.36,3.08l0.3,-1.52l-2.64,-0.88l0.11,-1.53l-1.1,0.05l-1.33,-9.83l0,0l5.56,1.81l0.13,-2.93l-2.36,-4.3L324.6,330.53z"
				},
				{
					"id":"MX-NLE",
					"title":"Nuevo León",
					"d":"M466.54,203.14L464.61,205.21L461.83,206.01L461.13,208.56L465.73,209.2L464.61,211.5L465.88,212.37L465.9,216.21L467.05,217.34L467.47,220.53L465.02,224.31L465.15,225.43L468.39,226.82L467.69,231.33L470.04,232.18L470.88,234.08L472.76,234.3L475.82,240.93L477.23,240.8L478.34,243.42L480.41,242.83L480.99,245.5L480.1,245.83L484.57,247.4L486.41,250.33L495.16,249.25L496.09,251.73L495.99,261.81L499.4,264.05L492.89,270.27L488.51,271.12L486.77,274.29L483.97,274.07L482.85,272.86L479.88,275.64L481.15,278.24L478.48,282.29L477.36,282.74L476.6,281.35L473.97,284.46L472.21,284.36L470.91,286.49L466.05,289.11L465.36,291.21L467.41,291.4L468.67,294.02L467.81,300.79L473.11,309.63L470.86,309.19L468.4,311.77L465.14,311.24L462.83,312.47L460.36,318.01L460.54,322.62L457.45,322.24L456.77,325.04L456.77,325.04L452.87,324.3L450.53,327.1L447.79,324.91L446.47,317.9L447.62,312.3L446.54,309.95L446.75,305.58L441.44,296.25L442.64,294.68L442.48,292.52L440.04,292.21L438.32,289.89L438.32,289.89L438.87,289.47L438.87,289.47L439.87,286.21L437.73,282.04L437.76,280.01L440.53,279.19L439.55,274.1L441.25,270.88L443.69,269.19L445.43,269.36L446.74,270.89L452.09,271.8L453.33,269.56L451.56,267.49L447.96,266.86L448.47,265.81L444.37,263.08L443.46,259.31L439.38,258.43L438.3,254.18L439.29,251.28L436.63,249.41L435.58,246.3L428.34,239.5L428.32,238.2L432.65,232.15L436.16,231.87L438.77,230.17L441.97,230.21L444.16,227.25L445,225.01L444.58,219.88L441.9,218.33L440.61,221.5L437.79,219.43L437.54,216.09L439.37,213.11L440.56,212.07L446.71,211.16L446.84,208.08L450.21,202.51L459.4,203.17L463.62,200.41L463.62,200.41z"
				},
				{
					"id":"MX-OAX",
					"title":"Oaxaca",
					"d":"M543.58,453.39L545.26,448.04L547.41,449.55L546.83,450.82L548.08,454.46L552.73,456.44L553.75,458.33L555.13,458.42L554.59,459.32L557.76,458.89L562.89,460.14L563.67,465.18L561.15,469.55L563.49,475.87L569.58,475.63L577.88,471.59L579.25,472.43L577.35,474.9L584.16,482.1L584.46,485.03L613.03,486.78L613.03,486.78L611.16,494.23L608.22,496.85L606.03,503.14L607.19,506.92L606.79,510.49L606.79,510.49L604.36,511.73L601.46,510.52L600.57,509.01L598.79,511.07L599.91,512.03L604.28,512.35L607.35,514.64L607.35,514.64L607.17,515.28L607.17,515.28L599.5,512.3L591.81,511.18L595.34,508.05L592.96,507.21L589.54,509.39L590.54,508.06L588.29,505.47L586.62,505.91L585.32,508.14L584.07,508.11L582.31,510.65L590.69,511.17L581.21,511.74L577.92,512.98L574.06,517.17L560.72,521.13L553.77,524.81L545.88,525.48L538.33,523.39L529.55,518.67L515.45,517.26L504.33,510.62L495.84,508.4L495.84,508.4L500.48,504.85L500.94,502.84L505.05,499.25L505.24,497.9L508.29,496.09L509.21,493.21L507,490.27L506.66,487.19L503.81,485.9L504.91,483L504.3,478.42L501.57,472.36L503.48,466.99L503.48,466.99L508.32,463.88L513.23,463.28L517.32,465.04L519.02,462.97L516.23,460.57L518.26,456.24L521.41,455.36L522.12,456.67L520.79,458.43L525.46,465.63L529.84,460.3L534.92,460.9L536.81,458.53L540.85,457.68z"
				},
				{
					"id":"MX-PUE",
					"title":"Puebla",
					"d":"M511.31,395.48L514.21,389.38L517.42,389.45L517.41,391.24L516.18,391.99L518.02,392.7L517.81,394.38L521.33,397.56L519.83,400.03L518.22,399.11L517.05,399.87L517.57,406.25L520.29,406.58L521.74,408.56L525.39,404.55L532.45,407.03L526.04,422.01L527.21,426.8L535.2,429.88L535.78,431.75L535.09,432.57L530.27,432.35L530.6,439.37L528.67,442.33L528.67,445.32L529.88,447.16L533.69,448.27L535.38,452.15L536.81,452.25L539.15,450.4L541.73,451.23L543.58,453.39L543.58,453.39L540.85,457.68L536.81,458.53L534.92,460.9L529.84,460.3L525.46,465.63L520.79,458.43L522.12,456.67L521.41,455.36L518.26,456.24L516.23,460.57L519.02,462.97L517.32,465.04L513.23,463.28L508.32,463.88L503.48,466.99L503.48,466.99L500.27,464.21L495.99,465.25L495.86,464.17L491.66,462.39L492.27,460.62L489.29,460.82L488.07,458.57L485.37,456.77L485.42,455.55L485.42,455.55L490.76,450.76L494.03,453.28L494.58,452.56L493.31,444.72L496.07,437.64L496.07,437.64L495.12,426.08L495.12,426.08L496.98,426.16L503.05,432.54L507.11,434.78L511.04,431.96L513.84,432.86L516.48,429.69L520.82,428.95L521.1,427.8L517.97,424.59L515.01,424.54L515.14,422.81L510.33,418.34L507.68,420.34L505.62,419.96L505.62,419.96L504.92,415.23L507.27,407.35L506.81,405.16L504.69,405.64L503.99,404.23L507.61,402.38L511.38,398.48z"
				},
				{
					"id":"MX-QUE",
					"title":"Querétaro",
					"d":"M483.66,377.61L482.38,380.74L478.27,382.03L477.06,381.32L475.41,382.75L474.38,387.63L471.26,391.81L471.89,393.83L464.15,397.33L463.14,403.87L463.14,403.87L461.95,406.01L460.17,405.84L461,408.53L459.08,410.54L456.53,410.85L456.53,410.85L450.65,404.15L450.65,404.15L446.82,399.21L446.83,396.5L445.08,393.29L445.73,389.49L446.45,388.08L455.25,387.47L456.13,385.97L456.95,386.45L457.52,383.4L459.77,380.06L461.29,379.5L463.02,381.25L466.13,379.38L466.88,376.77L464.4,376.16L465.55,374.25L465.16,371.7L465.16,371.7L464.57,371.13L467.11,369.86L469.84,373.41L474.85,373.52L475.91,370.75L477.75,370.34z"
				},
				{
					"id":"MX-ROO",
					"title":"Quintana Roo",
					"d":"M791.9,396.29l-2.21,4.06l-4.49,4.37l-0.54,-3.62l2.29,-3.75l2.23,0.35L791.9,396.29zM731.37,466.16l-0.25,-2.46l3.01,-4.1l-0.18,-7.75l-1.62,-5.05l0.58,-7.64l1.58,-1.33l0.18,-5.85l-3.41,-4.67l-6.64,-6.06l0,0l1.64,-4.81l3.54,-0.17l3.82,-2.44l3.62,-0.45l1.92,-1.78l1.08,0.92l1.91,-2.61l7.29,-3.02l1.75,-3.27l2.3,1.64l-0.25,-2.19l1.5,-2.76l5.36,0.1l7.96,-5.35l3.62,-8.33l-1.23,-4.17l1.49,-4.78l-0.33,-5.31l0,0l7.67,1.8l3,-1.4l0.24,-3.01l2.33,0.74l3.07,4.09l0.97,4.05l1.39,-2.39l-0.73,-1.97l0.65,0.22l-0.29,5.87l1.39,1.65l-5.28,10.53l-7.28,6.69l-4.21,6.63l-1.41,3.98l1.21,5.12l-0.58,1.37l-0.85,0.83l1.4,-2.25l-0.68,-0.97l-0.98,3.08l-2.03,0.45l-1.62,2.72l-2.43,0.42l-0.19,1.9l1.85,0.93l0.01,1.63l1.48,-1.34l2.19,0.31l0.56,-1.19l2.26,0.59l-0.74,2.5l-1.98,1.91l-0.39,-0.82l-2.46,1.48l-1.28,3.73l1.71,0.76l2.03,-2.79l1.25,-0.22l-0.34,1.4l1.32,-1.2l-2.21,2.63l-7.64,26.43l-1.37,-0.48l0.45,-3.4l-1.48,-1.17l0.19,-1.03l-3.66,-2.01l2.01,-4.2l-1.78,-5.04l-3.35,3.96l0.99,-0.18l-3.24,5.92h-4.73l-0.92,0.82L742.46,463l-3.62,3.51l0.11,1.6l-4.47,-3.5L731.37,466.16zM782.11,369.68l-4.22,2.09l-1.39,-1.28l3.12,0.45L782.11,369.68z"
				},
				{
					"id":"MX-SLP",
					"title":"San Luis Potosí",
					"d":"M438.32,289.89L440.04,292.21L442.48,292.52L442.64,294.68L441.44,296.25L446.75,305.58L446.54,309.95L447.62,312.3L446.47,317.9L447.79,324.91L450.53,327.1L452.87,324.3L456.77,325.04L456.77,325.04L459.32,330.09L459.21,336.7L460.5,338.31L470.17,340.67L471.74,338.65L476.24,341.91L480.15,348.46L486.25,348.55L486.96,347.75L488.85,348.94L491.95,348.66L491.95,348.66L492.77,349.85L499.56,351.18L501.42,355.47L497.82,356.24L497.88,359.46L495.03,359.89L496.54,360.27L496.18,362.29L498.44,364.49L493.98,367.6L494.87,370.91L496.2,371.13L496.34,374.47L496.34,374.47L494.66,374.45L491.75,379.25L490.83,377.94L489.48,380.32L487.06,379.26L485.92,376.86L483.66,377.61L483.66,377.61L477.75,370.34L475.91,370.75L474.85,373.52L469.84,373.41L467.11,369.86L464.57,371.13L465.16,371.7L465.16,371.7L462.52,373.03L460.23,372.15L458.03,372.86L452.43,368.13L448.54,366.85L447.46,367.58L446.99,370.53L442.72,371.17L435.01,366.02L422.75,362.54L422.75,362.54L425.65,355.27L424.27,351.41L427.76,342.46L425.08,339.93L419.17,345.24L414.66,345.92L412.26,341.9L408.88,340.98L402.65,336.13L403.86,329.37L402.72,323.85L404.25,321.98L406.57,322.91L409.51,322.33L410.88,319.86L416.72,316.89L420.2,311.75L424.94,310.16L427.22,305.66L426.21,304.48L427.04,301.03L430.91,299.05L432.71,295.26L435.27,294.83z"
				},
				{
					"id":"MX-SIN",
					"title":"Sinaloa",
					"d":"M255.97,275.87l1.93,1.47l0.34,4.73l-2.25,-3.29L255.97,275.87zM251.15,273.82l5.01,5.49l0.77,2.52L251.15,273.82zM229.02,240.72l1.03,0.12l0,0l-0.05,1.66l1.78,1.47l0.42,-1.78l-1.89,-2.98l0,0l0.15,-1.75l0.24,1.87l0.88,-0.77l1.69,2.76l6.2,-3.45l0.58,-3.36l4.09,-0.98l2.06,-3.86l1.86,-0.55l-0.29,-2.49l3.43,-5.67l0,0l5.56,0.16l0.12,2.9l1.84,-0.01l1.05,2.33l-0.07,6.18l1.41,0.91l4.4,11.58l9.36,2.13l5.62,10.91l0,0l0.94,1.24l-2.93,2.99l1.15,1.32l-1.33,3.21l-0.59,7.09l3.43,5.45l-0.33,1.45l1.2,0.95l2.83,-0.21l0.9,2.61l1.32,0.3l4.93,11.99l3.55,-0.42l3.46,-3.17l4.04,1.18l3.42,2.6l3,6.47l1.87,7.5l3.7,4.84l1.22,6.66l2.7,6.62l3.49,-0.39l2.12,2.18l0,0l-3.41,7.14l2.36,4.3l-0.13,2.93l-5.56,-1.81l0,0l-0.97,-4.16l0.11,7.03l-3.72,-5.81l-13.64,-13.71l1.67,0.62l-1.45,-1.15l-1.1,0.45l-2.45,-5.21l-7.06,-7.08l-2.02,-5.12l-7.52,-6.96l1.23,-0.16l-0.34,-1.11l-1.28,0.59l-14.91,-10.2l7.32,4.56l0.77,-2.05l-1.77,-3.2l-1.28,0.03l0.11,1.39l-1.12,0.24l-1.09,-1.43l-1.64,0.34l-1.81,-2.42l-4.01,-1.44l-2.1,-3.81l1.83,0.89l0.69,-1.18l-1.06,-1.19l0.41,-3.58l-1.81,-3.26l-2.45,-0.66l-2.2,-2.52h-1.64l0.11,-1.13l-1.25,-0.58l-0.63,2.07L247.9,270l-5.4,-2.7l0.15,-1.12l-1.32,0.35l-1.52,-2.32l0.24,-1.96l-2.85,-0.63l-0.6,2.89l-1.54,-1.25l-1.72,1.24l-1.83,-2.13l1.64,-1.41l1.83,0.44l1.37,-1.33l-0.34,-1.31l-2.12,0.6l-0.87,1.83l-2.36,-0.07l-2.09,-2.69l1.21,2.36l-4.46,-1.53l1.86,-0.07l0.07,-1.96l-3.18,-1.08l-0.8,-5.36l4.96,-9.86l-1.4,4.09l0.74,0.38L229.02,240.72z"
				},
				{
					"id":"MX-SON",
					"title":"Sonora",
					"d":"M230.04,240.84l-1.03,-0.12l0,0L230.04,240.84zM194.32,211.62l1.49,2.21l-1.5,-0.91L194.32,211.62zM152.25,158.81l2.21,6.5l-2.84,7.35l-6.81,-3.64l2.25,-2.09l-0.39,-3.25l1.31,-3.86L152.25,158.81zM93.33,85.85l0.79,0.76l-1.46,-0.41L93.33,85.85zM89.6,84.04l3.05,2.87l0.24,1.77l-3.42,-2.01L89.6,84.04zM240.13,98.26l1.05,1.04l-0.94,1.28l2.41,6.35l-0.47,3.09l-1.61,0.69l2.73,2.65l0.08,2.42l1.04,0.92l-0.56,2.42l2.97,8.81l-0.97,3.33l1.45,1.32l-1.86,8.61l1.66,1.98l0.67,6.22l-0.71,10.12l-1.67,1.19l-0.1,2.69l-1.49,1.27l0.41,6.47l-1.67,3.66l0.41,4.85l3.8,2.67l-5.04,3.68l-3.05,-1.42l-3.98,1.34l-1.04,1.39l1.75,1.68l-0.21,3.45l1.83,0.74l2.09,2.98l-0.33,4.11l3.34,2.35l3.23,7.58l-1.49,9.19l3.54,1.84l3.78,-0.23l0,0l-3.43,5.67l0.29,2.49l-1.86,0.55l-2.06,3.86l-4.09,0.98l-0.58,3.36l-6.2,3.45l-1.69,-2.76l-0.88,0.77l-0.24,-1.87l-0.15,1.75l0,0l-0.67,0.55l-4.78,-7.71l-2.3,-1.16l1.1,-0.2l-1.33,-1.64l-1.1,-0.46l-0.3,1.82l-3.17,0.58l-3.72,-2.03l-3.3,-6.89l1.16,1.2l-0.51,-3.29l-1.73,-1.38l-1.8,0.92l-6.01,-1.92l-4.44,-3.73l-0.01,-2.44l-1.85,-0.56l-1.87,-6.5l1.48,-1.75l-0.99,0.67l0.86,-1.89l-0.64,-2.35l1.56,-1.12l-7.18,-2.79l-1.64,0.87l0.36,1.96l-2.19,-1.44l-0.21,-1.42l-2.66,0.48l-2.47,-1.69l-2.54,-2.43l-4.53,-7.89l-6.32,-2.76l-1.32,-3.75l-4.5,-4.91l1.08,-0.65l0.53,1.17l0.62,-1.26l-4.4,-1.95l-1.67,-2.64l-1.91,-0.55l0.21,-4.05l-1.61,-1.94l-0.08,-3.61l-4.44,-1.05l0.8,-3.91l-5.05,-6.6l-2.12,-5.14l-2.07,-0.72l-0.64,-8.8l-1.95,-1.89l-1.08,-5.05l-2.41,-2.05l-2.54,-4.66l-0.91,-3.44l1.84,-7.36l-1,-3.43l-3.45,-2.43l-0.82,0.73l-8.96,-2.45l-0.82,-4.81l-6.24,-3.8l-1.74,0.72l0.38,1.07l-1.84,2.05l-2.85,-0.1l-11.08,-7.66l-5.24,-1.9l0,0l-5.69,-3.84l1.11,-7.6l-1.4,-1.99l2.94,-6.31l2.66,-0.13l0,0l93.65,34.22L240.13,98.26z"
				},
				{
					"id":"MX-TAB",
					"title":"Tabasco",
					"d":"M648.22,447.61l1.77,4.63l3.12,2.12l0.98,-0.38l3.68,8.14l4.34,3.75l5.02,1.63l2.97,-0.76l0.27,-3.84l2.79,-0.13l3.65,0.8l3.98,3.11l4.66,1.16l-0.02,1.64l0,0l-0.21,14.5l-10.56,0.18l0,0l1.29,-1.31l-1.1,-1.79l-5.84,-2.39l0.75,-2.66l-1.27,-3.3l-2.56,-1.26l-1.11,-3.37l-2.99,0.54l-1.89,-1.26l-0.71,1.84l-3.71,-0.45l-0.5,3.27l-3.29,1.19l-10.73,8.2l-2.72,-3.78l-2.59,-0.11l0.3,-1.87l-2.07,-2.18l1.54,-5.33l-2.79,0.09l-4.3,-2.89l-2.2,0.88l-0.75,7.08l-5.77,8.61l0,0l-1.93,-0.76l-1.28,-7.52l-4.53,-2.07l-3.89,-3.38l-1.16,-7.72l2.02,-0.66l-2.27,-0.39l1.89,-0.89l0,0l4.46,-1.51l0.14,1.24l2.66,-0.47l1,-1.79l3.33,0.13l0.48,-1.82l4.38,-0.99l5.38,-0.23l0.88,0.41l-0.59,1.44l2.33,-0.13l-1.45,-1.3l6.19,-0.48l5.3,-4.39L648.22,447.61z"
				},
				{
					"id":"MX-TAM",
					"title":"Tamaulipas",
					"d":"M523.63,270.67l-2.38,7.13l-0.07,-2.27L523.63,270.67zM514.93,351.99l-2,1.4l-3.14,-3.83l-4.08,-1.76l-0.72,-1.3l-2.54,0.29l-0.19,1.39l-1.98,0.44l-2.39,-1.22l-5.94,1.26l0,0l-3.1,0.27l-1.89,-1.18l-0.71,0.79l-6.11,-0.09l-3.91,-6.55l-4.5,-3.26l-1.57,2.02l-9.67,-2.36l-1.28,-1.62l0.11,-6.61l-2.55,-5.05l0,0l0.68,-2.8l3.1,0.38l-0.18,-4.61l2.47,-5.54l2.31,-1.23l3.26,0.54l2.46,-2.59l2.25,0.45l-5.3,-8.84l0.86,-6.77l-1.26,-2.63l-2.06,-0.19l0.69,-2.1l4.86,-2.62l1.31,-2.13l1.75,0.11l2.64,-3.11l0.76,1.39l1.11,-0.45l2.67,-4.06l-1.27,-2.6l2.97,-2.78l1.11,1.21l2.8,0.23l1.74,-3.18l4.38,-0.85l6.51,-6.22l-3.41,-2.24l0.11,-10.08l-0.93,-2.49l-8.75,1.08l-1.84,-2.93l-4.47,-1.57l0.9,-0.33l-0.58,-2.67l-2.07,0.59l-1.11,-2.62l-1.42,0.12l-3.06,-6.62l-1.88,-0.23l-0.85,-1.9l-2.35,-0.85l0.7,-4.51l-3.24,-1.39l-0.13,-1.12l2.46,-3.78l-0.42,-3.19l-1.15,-1.14l-0.02,-3.84l-1.27,-0.87l1.13,-2.3l-4.61,-0.64l0.7,-2.55l2.78,-0.8l1.93,-2.06l0,0l3.18,0.77l2.12,2.2l-0.38,1.72l1.18,0.53l-1.33,4.89l2.27,1.72l-0.01,6.28l4.03,4.57l2.83,8.84l1.93,1.72l-0.47,1.26l0.97,1.02l6.79,0.83l3.14,3.17l5.86,0.84l6.11,4.68l9.78,-0.2l1.08,0.95l2.89,-0.01l5.51,5.15l1.51,-0.27l0.59,-2.26l5.01,-0.62l-1.31,8.75l-5.65,11.07l-0.79,-0.25l1.56,-4.3l-3.53,-2.02l-1,1.08l1.96,1.9l-1.56,0.69l0.67,1.42l-0.77,0.28l-0.3,-1.37l-0.83,0.61l-0.37,-1.7l-1.79,-0.24l-0.62,3.01l-1.62,0.04l2.81,2.54l-2.06,5.3l2.39,1.37l-2.17,2.19l0.88,5.73l-0.87,4.23l-0.65,-1.93l-1.84,-0.37l-0.46,1.36l1.18,4.68l1.49,-2.48l0.24,3.22l-0.68,6.41l-0.97,0.25l0.89,0.43l0.7,11.07l0.29,-2.97l-0.85,24.24l-3.24,7.38l0.98,0.73l-0.35,3.79L514.93,351.99z"
				},
				{
					"id":"MX-TLA",
					"title":"Tlaxcala",
					"d":"M505.62,419.96L507.68,420.34L510.33,418.34L515.14,422.81L515.01,424.54L517.97,424.59L521.1,427.8L520.82,428.95L516.48,429.69L513.84,432.86L511.04,431.96L507.11,434.78L503.05,432.54L496.98,426.16L495.12,426.08L495.12,426.08L492.87,423.9L492.87,423.9L500.97,422.14L503.24,419.46z"
				},
				{
					"id":"MX-VER",
					"title":"Veracruz",
					"d":"M524.7,372.6l-1.55,3.03l-0.12,-1.51L524.7,372.6zM519.36,363.12l7.23,7.31l-2.88,7.67l1.45,-6.83l-5.88,-6.79l-1.86,-4.37L519.36,363.12zM491.95,348.66l5.94,-1.26l2.39,1.22l1.98,-0.44l0.19,-1.39l2.54,-0.29l0.72,1.3l4.08,1.76l3.14,3.83l2,-1.4l0,0l2.82,15.76l2.77,5.3l2.03,0.41l0.12,3.05l7.64,17.87l18.31,21.72l1.8,7.46l1.52,2.13l0.48,4.43l4.1,2.93l1.61,3.58l2.41,0.34l1.83,5.21l3.52,1.69l0.01,0.72l-3.01,-1.42l1.47,2.03l-0.96,0.7l2.64,-0.75l0.22,-1.19l4.51,1.9l9.53,0.24l3.58,3.51l6.05,1.34l1.46,3.28l2.8,2.79l0.56,2.39l2.67,1.28l11.05,-2.19l0,0l-1.89,0.89l2.27,0.39l-2.02,0.66l1.16,7.72l3.89,3.38l4.53,2.07l1.28,7.52l1.93,0.76l0,0l-6.61,4.88l0,0l-28.57,-1.75l-0.3,-2.93l-6.81,-7.19l1.9,-2.47l-1.37,-0.84l-8.31,4.05l-6.08,0.24l-2.35,-6.32l2.53,-4.37l-0.79,-5.04l-5.13,-1.25l-3.17,0.43l0.53,-0.9l-1.38,-0.09l-1.02,-1.89l-4.66,-1.99l-1.25,-3.64l0.58,-1.27l-2.15,-1.51l-1.68,5.35l0,0l-1.85,-2.17l-2.58,-0.82l-2.35,1.85l-1.43,-0.1l-1.69,-3.88l-3.81,-1.12l-1.21,-1.84v-2.98l1.93,-2.96l-0.34,-7.02l4.82,0.22l0.69,-0.82l-0.58,-1.87l-7.99,-3.08l-1.16,-4.78l6.41,-14.98l-7.06,-2.49l-3.65,4.01l-1.45,-1.97l-2.72,-0.33l-0.52,-6.38l1.17,-0.76l1.61,0.92l1.5,-2.48l-3.52,-3.17l0.21,-1.68l-1.84,-0.71l1.23,-0.76l0.01,-1.79l-3.22,-0.06l-2.9,6.09l0,0l-2.29,-0.59l-9.43,8l-1.38,-0.86l-1.17,-2.59l1.16,-7.04l3.36,-3.56l1.8,1.39l1.45,-0.23l0.33,-3.9l1.86,-2.46l-2.53,-3.42l-5.46,-0.45l-1.83,-1.71l0.3,-2.66l-1.15,-0.92l0,0l-0.13,-3.35l-1.33,-0.22l-0.89,-3.31l4.46,-3.11l-2.26,-2.2l0.36,-2.02l-1.51,-0.38l2.85,-0.43l-0.06,-3.23l3.59,-0.77l-1.85,-4.29l-6.79,-1.34L491.95,348.66z"
				},
				{
					"id":"MX-YUC",
					"title":"Yucatán",
					"d":"M771.6,372.46L771.93,377.76L770.44,382.55L771.67,386.72L768.06,395.05L760.1,400.41L754.75,400.3L753.25,403.06L753.5,405.25L751.2,403.61L749.45,406.88L742.16,409.9L740.25,412.51L739.17,411.59L737.25,413.37L733.63,413.81L729.81,416.25L726.27,416.42L724.63,421.24L724.63,421.24L723.4,417.34L719.06,411.27L715.21,409.17L709.91,399.84L707.82,401.39L705.32,400.57L704.35,398.56L700.22,398.04L700.38,390.75L700.38,390.75L701.63,386.55L699.63,390.73L699.93,389.18L702,384.84L714.34,378.68L739,374.82L744.03,372.91L744.59,371.51L753.32,370.6L756.91,368.76L764.15,370.56L765.66,371.94L770.15,372.16L766.37,371.23z"
				},
				{
					"id":"MX-ZAC",
					"title":"Zacatecas",
					"d":"M390.91,276.52L391.56,274.36L396.96,273.29L406.36,273.9L411.4,276.58L415.52,281.31L418.15,281.22L418.77,284.78L424.79,283.41L427.75,283.78L432.29,289.66L434.38,290.47L436.75,289L438.87,289.47L438.87,289.47L438.32,289.89L438.32,289.89L435.27,294.83L432.71,295.26L430.91,299.05L427.04,301.03L426.21,304.48L427.22,305.66L424.94,310.16L420.2,311.75L416.72,316.89L410.88,319.86L409.51,322.33L406.57,322.91L404.25,321.98L402.72,323.85L403.86,329.37L402.65,336.13L408.88,340.98L412.26,341.9L414.66,345.92L419.17,345.24L425.08,339.93L427.76,342.46L424.27,351.41L425.65,355.27L422.75,362.54L422.75,362.54L421.94,363.48L420.97,362.85L420.97,362.85L413.8,358.22L410.26,357.31L410.26,357.31L408.53,352.83L401.26,347.64L399.66,349.82L393.33,352.9L387.83,363.6L390.24,367.07L390.24,367.07L390.24,367.07L390.24,367.07L390.8,371.13L393.58,372.91L392.14,376.91L386.27,381.22L383.38,381.21L382.42,383.77L380.84,384.66L379.13,384.23L375.7,385.46L372.8,383.85L370.54,384.04L368.1,381.04L365.43,379.92L370.64,376.99L370.4,375.39L367.78,375.2L366.93,372.72L370.34,370.38L370.49,366.12L375.18,362.32L380.46,359.75L382.35,353.37L379.19,352.41L379.54,350.04L377.37,349.87L375.49,350.6L375.18,352.47L376.42,353.5L373.1,357.12L367.6,357.62L367.11,356.51L370.93,349.18L370.33,347.25L367.51,345.42L363.45,346.66L363.45,353.7L363.07,354.86L361.91,354.69L360.7,352.91L360.74,349.59L365.15,341.77L363.34,340.76L358.52,342.67L360.31,348.73L359.28,349.91L357.48,351.05L357.73,346.95L354.63,348.12L354.27,351.15L352.92,350.81L351.84,352.02L351.84,352.02L350.49,347.86L350.49,347.86L352.66,343.3L356.12,341.25L355.51,331.33L357.49,328.23L358.87,320.58L363.99,315.27L362.57,302.75L364.97,302.03L373.88,292.53L380.01,293.5L383.38,292.8L387.04,294.37L387.8,293.46L395.55,293.11L395.19,291.65L396.16,291.13L395.14,287.13L393.93,286.68L394.74,281.78L391.3,278.69z"
				}
			]
		}
	}
};
