﻿// (c) ammap.com | SVG (in JSON format) map of Mexico
// areas: {id:"MX-AGU"},{id:"MX-BCN"},{id:"MX-BCS"},{id:"MX-CAM"},{id:"MX-CHP"},{id:"MX-CHH"},{id:"MX-COA"},{id:"MX-OCL"},{id:"MX-DIF"},{id:"MX-DUR"},{id:"MX-GUA"},{id:"MX-GRO"},{id:"MX-HID"},{id:"MX-JAL"},{id:"MX-MEX"},{id:"MX-MIC"},{id:"MX-MOR"},{id:"MX-NAY"},{id:"MX-NLE"},{id:"MX-OAX"},{id:"MX-PUE"},{id:"MX-QUE"},{id:"MX-ROO"},{id:"MX-SLP"},{id:"MX-SIN"},{id:"MX-SON"},{id:"MX-TAB"},{id:"MX-TAM"},{id:"MX-TLA"},{id:"MX-VER"},{id:"MX-YUC"},{id:"MX-ZAC"}
AmCharts.maps.mexicoHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-118.369112",
				"topLatitude":"32.716750",
				"rightLongitude":"-86.725536",
				"bottomLatitude":"14.531518"
			}
		},
		"g":{
			"path":[
				{
					"id":"MX-AGU",
					"title":"Aguascalientes",
					"d":"M390.24,367.07L387.9,364.81L387.83,363.6L389.07,360.73L392.4,356.14L393.33,352.9L394.4,352.17L396.19,351.79L399.66,349.82L400.87,348.9L401.26,347.64L401.99,347.47L402.76,348.86L404.09,350.2L408.53,352.83L409.12,355.27L410.26,357.31L410.26,357.31L410.52,357.9L410.28,359.5L412.24,361.64L407.96,363.61L405.41,367.16L404.69,367.66L401.67,368.7L400.41,368.76L398.24,367.74L396.5,366.33L392.29,365.95z"
				},
				{
					"id":"MX-BCN",
					"title":"Baja California",
					"d":"M106.2,195.13h-0.65l0,0l-0.76,0.12l0.13,0.44l-0.82,0.41l-0.68,0.01l-0.75,0.86l-0.29,-0.74l0.19,-0.78l3.08,-3.76l0.62,-0.15l0.06,0.97l-0.8,0.76l-0.02,0.52L106.2,195.13zM78.85,183.14l0.56,0.45l0.75,2.86l-0.25,1.02l0.38,2.42l-0.68,0.9l0.04,2.09l-0.62,-0.19l-0.54,0.33l-0.65,-0.31l-0.6,-1.42l-0.58,-0.18l-1,0.6l-0.37,-0.15l0.07,-0.78l2.73,-3.03l0.15,-0.68l-0.58,-1.61l0.51,-1.89L78.85,183.14zM136.99,174.58l0.82,0.18l2.68,2.27l-0.54,0.47l-0.6,-0.96l-1.69,-0.95L136.99,174.58zM145.45,173.08l0.34,0.64l-0.27,1.02l-1.16,0.04l-0.35,-1.56L145.45,173.08zM2.59,160.01l-0.64,1.32l0.15,1.03l1.31,1.2l0.23,2.9l-0.67,2.08l-0.75,0.23l-0.56,-1.47l0.21,-0.92l-0.56,-0.37l-0.07,-1.6L0,163.17l0.35,-1l-0.29,-0.96l0.74,-0.62l0.8,0.04L2.59,160.01zM120.37,149.72l-0.02,0.48l1.1,-0.48l0.02,0.32l0.93,0.26l1.27,1.64l0.77,0.39l1.06,2.21l-0.59,0.86l0.12,1.17l1.84,0.83l2.9,-0.18l0.34,0.3l-0.17,4.33l0.62,1.71l1.2,0.37l-0.34,1.9l-2.96,-2.09l-1.72,-2.42l-2.56,-1.82l-0.96,-1.88l-1.37,-0.26l-0.24,-1.09l-2.04,-2.47l-0.16,-0.86l0.77,-1.87l-0.21,-0.98L120.37,149.72zM98.82,137.19l0.64,0.81l-0.45,0.14l-0.34,-0.36L98.82,137.19zM88.9,64.14l-0.85,0.51l-0.47,-0.4l-1.34,0.01l-0.6,2.05l-0.47,0.48l-0.05,1.34l-1.81,2.43l1.4,1.99l-0.62,1.83l0.29,1.14l-0.42,2.67l0.24,0.98l-0.6,0.98l0.96,0.95l0.92,0.13l3.82,2.76l0,0l-0.47,1.74l0.92,4l-1.12,1.46l-0.74,2.41l-0.08,3.53l-0.85,3.16l0.3,0.65l-0.25,2.22l0.62,2.21l1.37,1.26l-0.52,0.66l-0.02,0.65l2.84,1.84l0.59,3.53l-0.08,5.21l1.72,4.04l0.02,2.21l-0.35,1.3l0.21,0.82l-0.52,1.95l0.37,0.33l-0.65,2.16l1,2.06l0.62,0.38l1.73,4l1.23,0.61l0.3,0.9l0.96,0.15l0.64,0.89l-0.02,1.82l0.45,0.94l0.82,0.32l0.44,0.72l1.17,0.12l0.34,-0.86l1.81,0.78l1.21,1.54l0.31,-0.06l0.96,1.18l0.94,0.48l0.68,1.13l1.62,0.83l2.09,2.34l1.52,0.83l0.11,0.61l1.44,0.69l1.98,2.47l1.44,1.17l0.3,0.88l-0.73,0.85l0.01,0.48l2.08,2.55l0.79,1.64l-0.58,1.16l0.45,1.64l-0.33,0.25l0.81,1.69l0.82,0.1l0.53,-0.7l-0.41,-0.38l0.42,-0.62l0.48,0.27l0.47,-0.36l0.41,0.8l0.6,-0.12l-0.04,0.41l0.45,0.12l0.12,2.09l0.39,0.95l1.1,-0.03l1.31,-1.04l1.08,0.62l1.43,4.51l0.77,0.82l0.59,3.53l2.58,1.46l2.44,-0.59l0.48,0.36l0.07,0.73l0.81,-0.15l0.11,0.6l-0.36,0.48l0.25,0.66l-0.59,2.6l1.97,2.8l-0.47,2.03l0.62,1.45l-0.39,1.24l0.93,0.57l0.27,0.99l-0.3,2.49l0,0l-0.64,-1.71l-0.87,-0.26l0,0l-31.69,-0.11l0.23,-0.53l-0.35,-0.49l-0.05,-1.32l0.86,1.21l0.79,-1.39l-1.61,-0.41l-0.35,-1.72l1.52,-2.99l-0.42,-0.96l-0.88,0.53l-0.51,-0.49l1.28,-2.91l0.65,-3.16l-1.27,-2.19l-1.56,-0.63l-0.07,-2.03l-0.44,-0.43l-2.2,-0.1l0.01,-0.81l-0.45,-0.52l-1.54,-0.86l0.12,-0.59l-0.46,-1.17l-0.88,-0.47l-0.56,-1.87l-0.46,-0.07l-0.23,-0.6l-0.96,-0.73l-0.97,-0.07l-0.17,0.33l-0.52,-1.09l-0.68,-0.44l-0.23,0.3l-0.54,-2.72l-0.64,-1.05l-1.06,-0.47l-0.64,0.34l-0.8,-0.98l-0.25,-1.35l-1.16,-0.55l-0.12,-0.37l-0.45,0.03l-3.43,-4.21l-2.91,-1.5l-3.06,-0.4l-1.55,-2.51l-2.41,-1.18l-0.76,-0.03l-2,-1.92l-1.19,0.25l-2,-2.17l-0.89,-0.1L66.84,144l0.25,-2.52l-0.33,-1.5l-1.14,-1.62l-1.57,-0.58l0.62,-3.57l-0.54,-1.2l0.02,-4.19l-1.46,-2.55l-2.06,-1.24l0.19,-1.4l-0.82,-0.77l-0.23,0.4l0.5,0.94l-0.5,0.35l-0.46,-0.7h-0.53l0.58,1.34l-0.31,0.1l-1.06,-2.05l0.57,-5.32l-0.63,-3.55l-0.53,-1.05l-0.6,-0.08l-1.44,-1.26l-0.53,0.01l-2.3,-3.02l-1.55,0.2l-0.25,-0.46l0.74,-5.28l-1.38,-2.71l-2.09,-2.2l-1.85,-3.14l-1.29,-0.96l-0.68,0.08l-0.18,-1l-1.27,-0.92l-0.27,-0.72l-0.41,0.08l-0.12,-0.58l1.02,-0.52l-0.44,-0.9l0.47,-1.24l-1.17,-1.61l-0.33,0.14l-0.85,-1l0.45,-0.1l1.6,0.89l1.05,-0.96l0.19,-2.58l-0.4,-0.61l-1.26,-0.27l-0.57,-0.77l-1.15,-0.2l-0.41,-1.83l-0.48,-0.4h-1.23l-1.23,-1.18l-0.12,-3.02l-0.81,-2.83l-0.47,-0.75l-2.1,-0.71l-0.48,-0.56l-2.14,-5.9l0.04,-1.34l60.19,-5.54l-1.58,2.83l-0.67,0.19l0.5,1.79l-0.35,0.24L88.9,64.14z"
				},
				{
					"id":"MX-BCS",
					"title":"Baja California Sur",
					"d":"M90.77,454.84l1.49,0.37l-0.48,0.42l-1.32,0.17l-0.12,-0.73L90.77,454.84zM184.67,441.89l1.03,0.69l0.7,1.07l-0.01,1.76l-0.83,0.41l-0.44,-0.69l-1.15,-0.2l-0.81,-1.31L184.67,441.89zM189.4,429.56l0.23,0.65l-0.46,0.66l-0.29,-0.57L189.4,429.56zM211.13,294.41l2.79,4.59l0.44,1.91l-1.56,-0.29l-0.71,-1.05l-1.1,-3.81L211.13,294.41zM159.65,290.27l3.12,0.16l1.11,1.44l0.94,0.11l0.81,0.62l1.33,2.43l-0.35,0.83l-6.92,-5.03l-0.31,-0.34L159.65,290.27zM200.38,290.03l1.77,1.59l-0.93,2.03l-0.54,0.03l0.04,-0.83l-0.73,-0.26l0.12,-0.5l-0.46,-0.58l0.18,-0.67l-0.27,-0.46L200.38,290.03zM199.52,288.45l0.87,1.34l-0.59,0.33l-0.62,-0.36l-0.1,-0.78L199.52,288.45zM191.74,274.37l0.92,1.45l1.98,0.54l0.42,0.6l0.06,1.54l0.97,2.16l-0.47,0.09l-2.64,-2.04l-0.68,-2.02l-0.89,-0.9L191.74,274.37zM156.07,269.79l0.21,1.38l-1.1,3.4l0.11,3.08l-0.76,0.68l0.66,1.33l-0.33,1.14l-0.63,0.07l-0.31,0.53l0.16,0.72l1.14,1.27l-0.16,0.29l0.93,0.82l0.44,1.34l-0.67,1.1l0.92,0.78l1.25,1.81l-0.07,0.38l-1.06,-0.54l-0.05,-0.66l-1.78,-1.9l0.19,-0.53l0.57,0.08l0.22,-0.54l-0.12,-1.07l-0.8,-0.98l-1.33,-0.69l-1.22,0.37l-0.7,-0.45l-0.04,-0.58l0.41,-0.08l1.95,-5.17L156.07,269.79zM192.14,268.66l-0.45,1.2l-0.52,0.24l-0.15,-0.74L192.14,268.66zM156.91,263.73l-0.16,4.42l-0.37,1.37l-0.5,-0.35L156.91,263.73zM156.97,258.53l0.16,2.08l-0.17,2.51l-0.28,0.01L156.97,258.53zM190.03,257.61l0.31,3.3l-0.71,-0.44l-0.4,-1.4L190.03,257.61zM183.49,257.57l0.54,1.25l-0.33,0.51l-0.41,-0.2l-0.41,-1.41L183.49,257.57zM182.83,247.79l-0.5,1.02l0.4,1.67l-1.2,-0.74l-1.71,2.67v0.92l-0.56,0.55v0.68l-0.6,0.05l-0.13,-0.76l0.4,-0.45l0.18,-1.68l1.05,-1.74l-0.19,-1.46l0.98,-0.25l0.18,-0.43l0.64,0.4L182.83,247.79zM177.64,245.9l0.18,0.79l-0.45,0.05l-0.17,-0.54L177.64,245.9zM128.55,229.37l1.34,0.32l0.75,1.57l-0.96,-0.63l-1.97,-0.48l-0.12,-0.28L128.55,229.37zM157.11,214.6l1.06,1l-0.34,1.22l-0.62,-0.16l-0.5,-1.41L157.11,214.6zM162.18,209.09l0.42,0.05l0.28,0.62l-0.93,0.04l-0.18,-0.46L162.18,209.09zM78.84,196.69l1.37,0.75l-0.1,0.53l-1.37,-1.02L78.84,196.69zM105.55,195.13h0.65l0,0l0.41,0.41l0.29,-0.41l31.7,0.1l0,0l0.87,0.26l0.64,1.71l0,0l-0.07,0.5l1.29,1.03l0.4,1.96l1.08,1.29l0.42,-0.04l1.23,1.7l2.78,0.86l0.54,0.62l0.94,0.15l1.61,1.11l0.71,0.96l0.7,3.73l1.64,1.81l0.97,2.21l-0.41,0.76l2.6,2.1l2.54,0.65l0.47,0.57l0.93,-0.01l0.15,0.73l-0.57,0.03l-0.89,1.04l-0.23,1.58l1.68,2.42l0.9,0.46l0.04,0.46l0.92,0.66l0.33,1.37l-0.7,0.55l-0.47,1.29l1.17,0.73l0.29,1.17l1.08,0.66l0.69,1.69l1,0.75l1.55,-1.38l-3.45,-3.58l-0.23,-2.91l-0.68,-1.64l0.74,-0.47l1.85,1.4l0.67,1.09l1.35,0.93l0.47,0.75l2.16,1.37l-0.19,3.51l0.35,0.56l2.72,0.85l-0.6,1.63l0.04,1.24l1.15,1.88l0.71,0.31l0.22,0.5l0.07,1.14l-0.35,0.66l1.98,5.16l-0.58,0.94l0.1,1.35l-0.52,0.72l0.11,0.99l0.45,0.58l0.08,1.92l0.63,0.67l0.04,1.05l1.8,1.47l0.22,-0.17l0.8,3.11l1.84,2.4l2.56,0.31l-0.22,1.61l1.17,3.14l0.85,0.85l0.3,1.05l-0.3,0.17l0.38,1.53l0.62,0.81l-0.04,1l0.68,0.54l0.44,1.26l0.86,0.48l0.51,0.9l0.47,-0.13l0.76,0.62l0.25,1.3l1.61,2.21l0.67,2.08l-0.17,1.19l-0.74,1.77l-0.87,0.93l-0.22,3.09l0.22,1.04l1.05,1.39l0.13,2.88l1.06,1.24l0.69,1.57l1.54,1.35l4.34,0.95l1.21,-0.12l0.06,0.28l-1.28,0.5l-0.79,-0.65l-0.42,0.25l0.21,1.46l1.68,-0.13l-0.01,-0.78l1.21,-1.03l0.06,-0.98l-0.91,-2.2l0.28,-1.07l0.71,-0.45l1.56,0.21v0.78l1.06,0.62l0.42,1.12l2.15,0.99l2.06,1.58l0.71,3.23l1.2,0.3l2.6,-0.88l0.04,0.58l0.53,0.49l-0.7,0.86l0.07,2.03l3.24,3.16l-0.28,1.97l0.31,1.69l0.39,0.47l5.38,2.63l-0.31,0.81l1.43,2.07l-0.22,0.69l0.42,0.43l-0.51,4.39l-0.59,1.26l-1.87,2.31l-1.04,0.72l-2.2,0.54l-1.21,0.82l-0.02,0.75l-2.07,1.14l-0.53,1.04l-0.94,0.74l-0.93,0.04l-0.64,0.67h-1.15l-2.42,-2.01l-1.17,-2.77l-1.46,-7.1l-2.5,-4.57l-1.83,-2.44l-6.19,-3.28l-11.64,-11.53L172.33,295l0.12,-0.26l-1.16,-1.24l-1.55,-0.21l0.06,-0.48l-0.64,-0.07l-1.02,-2.97l0.28,-0.11l-0.47,-0.58l-0.99,-0.3l-0.1,1.14l-2.41,-0.2l-0.06,0.75l-0.6,-0.01l0.15,-1.48l-0.73,-2.01l-2.19,-2.41l0.27,-0.25l-0.56,-0.5l-0.68,0.27l0.13,0.44l-1.46,-0.24l-2.01,-0.97l-0.31,-0.69l0.54,-0.03l0.11,-0.76l-0.62,-0.4l-0.17,-0.78l0.65,-0.97l-0.27,-0.16l0.39,-0.72l-0.44,-0.13l0.24,-0.45l-0.42,-0.48l-0.57,0.92l0.29,0.76l-0.39,0.49l0.05,2.53h-0.73l-0.48,-1.15l0.77,-1.55l-0.65,-1.39l0.81,-0.45l0.74,-1.67l0.02,-0.96l-0.86,0.12l0.16,-1.89l0.87,-2.01l0.27,-1.77l0.71,-0.12l0.06,-2.45l-0.5,-0.11l0.06,-1.17l0.58,-0.44l-0.39,-0.33l-0.21,-1.07l0.3,-1l0.3,-0.05l0.13,-2.41l-0.13,-1.28l-0.8,-1.07l-0.34,-2.88l-2.03,-5.36l-0.94,-1.24l-1.93,-1.06l-0.87,-2.85l-1.64,-1.94l-1.58,-0.4l-0.19,0.66l-0.45,0.13l-3.19,-2.33l-0.69,-0.26l-0.67,0.28l-0.79,-1.19l-1.98,-1.4l0.01,-0.44l-0.63,-0.03l-3.59,-2.96l0.97,0.09l1.27,0.94l0.13,-0.24l-1.06,-0.77l-1.08,-0.32l-0.69,0.22l-2.27,-1.98l0.19,-0.19l-0.4,-0.5l0.38,-0.61l-1.73,-2.07l-0.94,-1.98l-0.36,1.05l-1.51,-0.7l0.31,-0.32l0.51,0.16l1.55,-1.56l0.42,-1.29l-0.82,-2.81l-0.6,0.65l-0.38,3.22l-0.56,0.49l-0.7,-0.23l-0.38,0.75l0.06,1.83l-0.45,0.05l-2.14,-1.33l-1.51,-0.26l0.21,-0.53l0.54,0.39l0.07,-0.38l-0.53,-0.2l-1.44,0.22l-0.8,0.89l-0.39,1.19l-0.63,0.28l-0.01,0.58l-0.71,0.4l-0.82,-0.26l-0.8,-0.52l-0.7,-1.41l-1.6,-0.4l-1.61,-3.69l-1.81,-1.34l-2.21,-0.57l-0.45,0.16l-0.18,0.55l-0.44,0.03l-1.28,-1.34l-1.1,-1.99l-1.08,-0.8l-1.22,-0.58l-2.02,-0.3l-0.75,0.66l-2.43,-1.55l-0.51,0.41l-0.48,-0.26l0.06,-0.8l-0.62,-0.39l-0.53,0.11l-0.24,-0.37l-0.02,-3.52l-0.48,-1.57l-2.35,-1.91l-3.33,-1.21l-1.15,-2.25l-1.67,-1.25l-0.07,-1.02l-0.68,-0.46l-0.62,0.95l-0.77,-0.35l-0.31,-0.91l-1.03,-0.53l-0.56,0.27l-1.08,-2.81l-0.79,-0.78l0.8,-0.41l1.06,0.91l2.33,-0.22l1.52,0.23l0.36,0.5l1.37,-0.18l1.62,0.3l0.46,0.49l1.58,0.33l2.77,-0.23l0.59,0.35l2.44,-1.32l0.6,0.35l0.76,-0.15l0.15,-0.6l-0.63,-0.04l1.1,-1.2l0.86,0.29l-0.52,2.48l0.76,1.26l1.5,1.2l1.27,0.37l1.35,1.2l-0.05,0.42l0.8,0.26l1.02,-1.07l0.06,-0.88l2.1,0.72l1.56,2.96l0.89,0.14l0.59,-1.17l-1.57,-1.62l0.12,-1.05l0.67,0.65l0.15,-0.41l-0.57,-0.45l0.27,-0.61l-0.46,-1.74l0.23,-0.9l-1.75,-1.44l-1.03,1.89l0.19,1.14l-3.18,1.21l-1.64,-1.24l0.24,-0.54l0.6,0.5l-0.74,-1.98l1.17,-1.74l-0.54,-0.48L105.55,195.13z"
				},
				{
					"id":"MX-CAM",
					"title":"Campeche",
					"d":"M671.68,444.21l0.5,0.79l-0.68,0.61l-0.54,0.22l-1.06,-0.57l-0.38,0.33l0.39,0.33l-1.66,1.34l-0.54,-0.67l-0.29,0.58l-2.12,0.86l-1.09,0.1l-0.54,-0.57l0.27,-0.32l2.42,-0.39L671.68,444.21zM700.38,390.75l-0.16,7.3l4.12,0.51l0.97,2.01l0.45,0.18l1.11,-0.35l0.94,0.99l0.48,-0.09l0.4,-1.01l0.79,-0.73l0.42,0.28l1.03,1.76l-0.11,0.91l0.57,1.04l1.83,1.17l1.98,4.46l3.86,2.1l1.17,2.49l3.17,3.58l0.79,3.44l0.44,0.46l0,0l1.34,1.81l5.3,4.25l3.41,4.67l-0.18,5.85l-1.17,0.66l-0.41,0.67l0.22,2.52l-0.8,5.13l0.17,1.27l0.99,1.24l0.15,0.71l-0.51,1.37l0.82,0.46l-0.57,1.67l0.47,1.38l0.28,4.7l-0.57,1.26l-2.44,2.83l0.25,2.46l0,0l-0.02,3.33l-45.94,-0.01l0,0l0.02,-1.64l-3.98,-1.58l-0.68,0.42l-0.77,-0.9l-1.56,-0.66l-1.64,-1.55l-3.65,-0.8l-2.79,0.13l-0.3,1.3l0.34,1.82l-0.3,0.72l-1.68,0.11l-1.29,0.64l-2.21,-1.12l-1.5,0.15l-1.31,-0.66l-0.87,-1.43l-3.47,-2.33l-1.22,-1.83l-1.08,-2.59l-0.45,-0.32l0.18,-1.97l-1.11,-1.42l-0.36,-0.16l-0.08,0.42l-0.53,0.13l-0.69,-1.06l-0.99,-0.05l-1.44,-1l-0.63,-0.91l-1.14,-3.72l0,0l3.13,-0.56l9.83,-0.61l0.88,1.41l1.49,0.8l-0.6,1.18l-0.27,-0.39l-0.31,0.34l-0.96,-1.28l-0.73,0.85l-0.68,-0.42l-0.24,0.18l0.17,0.72l-0.45,0.57l0.59,0.74l1.15,-0.25l-0.45,-1.12l0.79,0.04l0.28,0.46l0.57,-0.14l1.1,0.72l0.16,0.56l6.79,1.67l1.43,-0.13l0.16,-0.7l0.73,-0.7l4.45,-1.53l0.82,-2.92l0.63,-0.32l0.35,-1.32l-0.23,-0.7l-1.1,-1l-0.92,0.72l-1.15,-0.61l-0.29,-0.98l0.61,-0.47l-0.07,-0.79l0.97,-1.04l-0.77,0.19l-0.7,1.33l-0.76,0.72l-0.52,-0.05l-0.82,0.76l-0.12,0.56l-0.63,0.03v-0.24l2.5,-2.57l6.81,-3.66l4.79,-3.45l4.86,-4.53l0.47,-0.93l-0.08,-1.02l0.52,-2l-0.21,-2.17l0.67,-1.8l-0.51,-0.56l-0.04,-0.64l0.93,-1.14l0.19,-1.03l3.85,-2.86l1.41,-2.48l-0.98,-2.71l0.3,-1.37l-0.41,-1.28l0.38,-0.29l-0.39,-4.48l0.3,-0.78l-0.45,-3.4l1.34,-3.56l0.44,-3.02L700.38,390.75z"
				},
				{
					"id":"MX-CHP",
					"title":"Chiapas",
					"d":"M607.17,515.28l0.18,-0.64l0,0l-0.06,-0.41l0.4,0.01l0.76,1.15L607.17,515.28zM606.8,511.27l-0.01,-0.78l0,0l-0.12,-2.12l0.52,-1.45l-1.25,-2.93l0.08,-0.85l2.19,-6.28l2.94,-2.62l0.8,-3.49l0.76,-1.02l-0.02,-2l0.34,-0.94l0,0l0.94,-1.13l1.95,-0.86l3.72,-2.89l0,0l2.53,-3.17l0.06,-1.61l1.39,-1.87l1.2,-0.79l0.59,-1.16l0.75,-7.08l1.66,-0.28l0.54,-0.61l2.14,0.85l1.39,1.69l0.77,0.35l2.79,-0.09l-0.35,1.69l-1.42,2.12l-0.14,0.58l0.38,0.93l2.07,2.18l-0.3,1.87l0.36,0.33l1.25,-0.06l0.44,-0.35l0.54,0.2l1.21,1.94l0.04,0.66l0.66,0.87l0.81,0.31l1.91,-0.84l2.42,-2.25l5.83,-4.27l0.57,-0.83l3.29,-1.19l0.39,-0.78l-0.41,-1.75l0.12,-0.37l0.43,0.08l-0.04,-0.44l1.77,0.48l1.95,-0.03l0.71,-1.84l1.45,0.37l-0.12,0.59l0.56,0.3l0.59,-0.44l1.19,0.18l1.21,-0.28l1.06,1.36l0.05,2.01l2.56,1.26l1.27,3.3l-0.75,2.66l4.34,1.2l0.19,0.83l1.31,0.37l1.1,1.79l-0.76,0.28l-0.53,1.03l0,0l-0.65,0.06l0.57,0.98l0.76,-0.04l0.98,1.12l0.83,-0.35l0.93,0.31l-0.02,0.83l0.53,0.74l0.63,0.26l0.33,0.96l1.12,1.16l1.05,0.23l0.3,1.03l1.38,1.37l0.11,0.64l1.34,0.4l0.53,0.62l0.27,-0.29l1.1,0.44l0.24,0.85h1.03l0.88,0.72l1.13,-0.08l0.04,0.55l2.14,1.25l1.38,2.18l0.35,3.22l0.82,-0.1l0.11,0.55l-0.67,0.23l0.23,0.4l0.76,-0.34l0.36,0.51l0.88,-0.31l0.57,0.63l0.57,-0.28l0.53,0.66l-0.15,0.49h1.71l0.38,0.59l0.12,0.58l-0.36,0.35l0.34,0.53l-0.33,0.88l-0.54,0.04l-0.18,0.64l0.36,0.35l-0.77,1.62l0.8,1.06l-0.67,0.44l0.56,0.29l-0.02,0.41l-0.64,-0.05l0.27,1.36l-32.14,-0.27l-12.25,21.07l3.87,5l-1,1.6l-0.85,-0.09l-0.35,0.72l0.13,2.49l-1.05,1.38l0.92,4.29l-0.73,1.17l-0.38,1.54l-0.86,0.71l-4.46,-4.06l-10.99,-11.58l-0.1,-0.85l-0.8,-0.19l-11.16,-10.52l-5.44,-4.29l-6.08,-4.22l-3.82,-1.84l0.28,-0.4l0.75,-0.06l0.29,0.61l0.63,-0.27l0.14,-0.48l-1.12,-1.84l-4.66,-1.01l-0.73,-0.91L606.8,511.27z"
				},
				{
					"id":"MX-CHH",
					"title":"Chihuahua",
					"d":"M374.96,164.76L372.7,168.92L372.72,169.27L374.43,169.88L374.44,170.92L373.78,171.9L372.94,171.58L372.24,171.92L370.51,175.93L369.1,177.04L367.46,177.65L365.19,181.43L364.63,182.53L365.5,183.95L364.56,185.33L361.9,192.14L361.3,192.52L359.53,191.81L359.52,193.36L360.64,193.54L361.13,195L360.79,195.48L358.89,195.86L359.65,197.3L359.59,198.13L359.02,198.95L359.74,199.73L359.88,200.45L358.79,201.61L359.6,206.13L360.73,206.63L360.97,207.46L361.06,208.52L360.58,209.66L361.26,213.34L361.48,218.16L362.02,218.84L363.85,219.63L363.44,221.17L362.29,221.21L361.22,222.21L359.3,223.12L359.74,223.92L359.64,225.23L361.79,227.13L362.87,228.96L362.87,228.96L361.77,229.2L360.62,228.34L360.11,229.02L359.83,228.85L360.27,228.13L359.48,228.01L356.27,229.06L354.76,228.49L353.88,229.3L352.45,229.02L351.77,228.02L350.34,227.78L348.96,226.89L348.23,227.21L347.92,227.95L348.4,228.61L349.94,228.73L349.87,229.73L347.37,230.12L346.22,231.64L344.71,232.18L342.82,235.26L343.06,236.6L342.81,237.37L342.37,237.61L340.66,237.41L338.92,238.32L337.94,238.11L336.22,236.92L334.27,235.03L331.73,235.27L330.51,234.94L329.77,234.26L329.23,234.22L329.22,235.3L327.62,236L327.1,236.58L326.53,236.67L326.12,236.13L324.44,237.09L324.21,236.49L322.65,236.02L321.38,236.27L320.28,234.38L318.64,234.67L317.88,233.58L316.9,233.58L315.32,232.22L313.38,231.99L313.1,231.41L311.84,230.7L310.88,228.76L309.82,228.53L307.91,227.3L306.64,227.24L305.97,226.35L305.2,226.89L304.99,228.18L303.23,228.75L303.28,230.59L302.65,231.06L301.75,234.45L301.78,236.05L300.88,237.58L301.03,238.04L302.15,238.54L302.12,239.61L301.79,240.19L299.81,241.06L298.95,241.93L298.95,243.29L297.95,243.13L297.54,243.49L297.9,245.63L296.98,245.89L295.26,249.88L296.23,251.44L296.84,253.34L294.72,256.76L291.19,259.48L289.96,261.09L289.32,260.81L288.65,259.6L286.64,259.27L286.12,258.41L284.52,258.63L283.44,257.97L283.13,256.65L280.82,257.43L280.5,258.08L280.5,258.08L278.36,255.29L277.77,252.06L274.88,247.17L272.52,246.48L269.33,246.17L265.52,245.04L264.3,240.36L261.19,235.34L261.12,233.46L259.7,232.54L259.38,231.45L259.87,229.45L259.38,228.63L259.78,226.36L258.72,224.03L257.5,224.28L256.89,224.04L256.77,221.14L256.09,220.76L251.2,220.98L251.2,220.98L249.44,220.59L247.42,221.21L243.88,219.37L243.9,218.91L244.63,218.49L244.15,215.05L245.4,211.91L245.36,210.19L243.73,206.12L242.76,204.69L242.13,202.6L239.32,200.9L238.8,200.25L239.5,197.8L239.12,196.14L237.03,193.16L235.21,192.42L234.82,191.73L235.41,188.97L233.85,187.9L233.66,187.29L234.7,185.9L237.23,185.41L238.68,184.56L239.45,184.7L241.22,186.01L241.72,185.98L243.13,184.93L244.27,184.81L245.24,183.59L246.17,183.5L246.77,182.31L244.52,181.45L242.97,179.64L243.39,176.74L242.56,174.79L242.75,173.75L244.23,171.13L243.43,168.48L244.27,167.2L243.81,164.65L245.3,163.39L245.4,160.7L246.78,160.03L247.07,159.52L246.81,153.85L246.97,152.95L247.77,152L247.78,149.4L247.12,143.18L246.37,142.22L245.8,142.2L245.46,141.2L246.05,136.27L247.32,133.7L247.32,132.59L245.87,131.26L245.71,130.27L246.56,129.75L246.84,127.93L244.9,121.78L244.96,120.59L243.86,119.13L243.75,118.32L244.42,116.71L243.38,115.78L243.29,113.36L240.56,110.71L240.6,110.1L242.17,110.02L242.15,108.21L242.64,106.94L242.4,105.34L240.76,102.5L240.24,100.58L241.18,99.3L240.13,98.26L240.13,98.26L254.23,98.22L254.23,85.06L296.28,85.06L297.28,86.13L298.87,86L299.88,86.56L300.75,87.59L302.5,91.62L303.26,92.03L304.39,94.4L307.59,96.36L309.4,96.54L310.65,97.34L311.24,98.82L311.81,98.81L312.18,99.47L312.7,99.47L314.88,102.13L315.13,102.97L316.41,103.42L316.82,103.99L318.32,104.58L319.48,105.58L320.69,108.29L321.89,108.87L322.25,109.63L324.12,110.81L324.67,111.71L324.5,112.18L325.48,112.34L326.94,113.35L327.22,112.98L328.13,113.85L329.02,113.6L329.23,114.22L329.63,113.99L330.19,114.65L330.61,114.66L330.5,115.1L331.7,115.29L332.5,116.64L333.35,117.17L334.26,117.03L334.83,117.76L335.08,119.06L336.23,119.49L337.08,120.51L337.84,122.63L337.86,124.09L338.32,124.84L338.13,125.69L339.24,126.42L339.02,126.75L340.54,128.34L340.46,128.87L341.82,129.97L342.28,131.56L342.12,133.06L342.4,134.06L341.91,136.13L342.27,136.34L342.23,137.42L342.66,138.15L342.35,138.56L342.62,139.63L343.7,140.56L344.84,142.47L346.15,146.38L349.6,149.12L350,149.95L351.13,150.57L351.66,150.24L353.63,151.24L353.75,151.68L354.32,151.86L354.2,152.49L355.42,154.21L356.86,154.77L358.25,156.08L360.22,156.98L363.23,157.4L364.61,158.04L365.01,157.88L365.23,159.16L365.63,158.87L366.63,160.26L368.1,160.57L368.36,160.96L370.7,160.94L372.81,163.03L372.7,163.51L373.3,163.44L373.79,164.19z"
				},
				{
					"id":"MX-COA",
					"title":"Coahuila",
					"d":"M463.62,200.41L463.36,201.02L462.27,201.81L461.32,201.87L459.4,203.17L453.88,202.25L450.21,202.51L449.08,203.14L448.53,205.48L446.84,208.08L446.55,208.87L446.71,211.16L446.08,211.65L443.85,211.53L441.75,212.45L440.56,212.07L439.37,213.11L437.54,216.09L437.79,219.43L440.61,221.5L441.2,221.45L441.9,218.33L442.53,218.4L444.58,219.88L445,225.01L444.16,227.25L443.11,228.02L441.97,230.21L438.77,230.17L436.16,231.87L432.65,232.15L431.78,233.05L430.74,235.78L428.32,238.2L428.34,239.5L432.88,244.28L435.58,246.3L436.63,249.41L438.05,250.56L438.91,250.64L439.29,251.28L438.3,254.18L438.54,256.65L439.38,258.43L440.49,258.57L441.33,259.23L443.46,259.31L443.81,259.67L444.37,263.08L445.19,263.93L448.47,265.81L447.96,266.86L451.56,267.49L452.06,268.29L452.94,268.61L453.33,269.56L452.58,270.45L452.43,271.6L452.09,271.8L450.15,271.77L446.74,270.89L445.43,269.36L443.69,269.19L442.75,269.5L443.04,270.31L441.25,270.88L439.55,274.1L440.44,277.03L440.53,279.19L440.33,279.58L437.92,279.64L437.76,280.01L438.05,280.84L437.73,282.04L439.11,283.59L439.22,284.98L439.87,286.21L438.87,289.47L438.87,289.47L436.75,289L436,289.32L435.82,290.1L434.38,290.47L432.29,289.66L430.92,288.36L429,284.6L427.75,283.78L424.79,283.41L422.52,283.92L421.6,284.8L418.77,284.78L418.15,281.22L416.99,280.9L415.52,281.31L413.36,278.24L411.4,276.58L408.9,275.61L406.36,273.9L396.96,273.29L391.56,274.36L390.93,274.89L390.91,276.52L390.91,276.52L387.86,278.55L387.28,279.56L386.77,281.7L387.27,283.42L386.99,283.94L386.3,284.15L384.2,282.8L381.42,282.64L378,281.05L376.7,279.85L376.08,278.99L375.54,275.87L373.11,273.94L372.51,272.2L370.74,270.08L370.11,266.93L371.47,265.57L373.73,265.12L372.93,263.89L371.59,263.63L370.92,262.81L371.01,261.95L372.41,259.8L373.47,258.99L374.67,255.88L373.47,251.41L373.29,249.42L373.7,247.14L372.02,243.19L371.85,241.8L372.29,238.87L370.91,234.9L368.61,232.77L367.79,231.56L366.57,230.38L363.59,229.59L362.87,228.96L362.87,228.96L361.79,227.13L359.64,225.23L359.74,223.92L359.3,223.12L361.22,222.21L362.29,221.21L363.44,221.17L363.85,219.63L362.02,218.84L361.48,218.16L361.26,213.34L360.58,209.66L361.06,208.52L360.97,207.46L360.73,206.63L359.6,206.13L358.79,201.61L359.88,200.45L359.74,199.73L359.02,198.95L359.59,198.13L359.65,197.3L358.89,195.86L360.79,195.48L361.13,195L360.64,193.54L359.52,193.36L359.53,191.81L361.3,192.52L361.9,192.14L364.56,185.33L365.5,183.95L364.63,182.53L365.19,181.43L367.46,177.65L369.1,177.04L370.51,175.93L372.24,171.92L372.94,171.58L373.78,171.9L374.44,170.92L374.43,169.88L372.72,169.27L372.7,168.92L374.96,164.76L374.96,164.76L375.65,164.83L375.92,164.2L376.34,164.28L376.08,164.85L377.44,165.56L377.54,166.07L377.98,165.62L378.32,166.02L379.93,165.91L380.78,166.29L381.67,165.93L382.18,163.68L382.45,163.88L382.74,162.82L383.56,162.71L384.65,160.99L384.67,160.4L385.29,160.15L385.66,160.44L386.65,159.97L386.82,159.26L387.45,159.48L387.91,159.13L387.71,158.48L386.91,158.03L387.34,157.22L387.51,155.46L388.54,155.24L388.46,154.91L389.17,154L388.79,153.75L388.84,152.85L389.54,151.6L389.41,150.55L390.15,149.95L390.47,148.4L391.01,148.53L391.08,147.29L392.26,146.19L392.14,145.77L392.83,144.21L393.94,144.44L395.32,143.85L395.95,144.17L396.81,143.58L396.73,143.08L399.41,143.6L400.11,142.96L400.52,141.34L401.6,140.35L403,140.67L403.01,141.06L405.14,141.41L406.75,142.83L408.15,143L408.65,142.86L408.67,142.53L409.7,142.4L411.28,142.63L411.55,143.03L412,142.64L414.05,142.32L414.52,142.61L414.46,143.15L415.24,142.9L416.92,143.65L417.35,143.46L417.72,143.78L418.13,143.49L418.41,143.89L420.32,143.33L420.4,142.77L421.01,142.27L421.2,143.76L423.18,142.92L423.38,143.97L424.44,143.44L424.67,143.65L424.26,143.96L424.64,144.98L425.19,145.38L425.52,146.8L426.72,146.59L427.1,147.18L426.82,148.71L427.43,149.15L427.66,147.82L427.97,147.47L428.43,147.61L428.58,149.23L428.09,150.3L428.39,150.64L430.3,150.82L430.86,151.87L433.07,152.36L434.37,154.88L436.01,155.63L437.44,156.66L437.74,157.46L439.71,158.47L440.47,160.15L440.23,160.57L442.61,162.36L443.01,163.24L443.36,166.98L443.82,168.2L444.56,168.27L445.22,170.28L445.9,170.39L446.24,171L446.34,172.32L446.95,172.92L447.14,175.05L448.45,175.69L448.47,176.5L449.72,177.27L449.35,178.39L449.99,179.24L451.23,179.61L451.11,180.02L450.46,180.19L451.15,181.13L450.92,182.5L452.42,184.9L452.38,185.98L453.35,187.1L454.11,187.19L454.41,188.29L457.55,189.66L458.43,191.46L459.24,191.92L459.43,192.94L460.25,194.13L461.16,194.25L461.14,195.34L462.14,196.35L461.96,197.37L462.67,198.43L462.67,199.49L463.34,199.6z"
				},
				{
					"id":"MX-COL",
					"title":"Colima",
					"d":"M372.28,439.49L369.81,441.73L368.79,441.42L368.41,441.7L368.44,443.49L366.58,444.67L365.9,446.37L365.9,446.37L360.39,442.01L355.21,439.24L351.19,437.88L351.33,437.04L351.79,436.99L351.94,436.37L351.49,435.85L350.39,435.25L348.55,436.19L348.3,435.56L346.55,434.82L342.02,433.61L342.35,433.17L342.97,433.58L343.15,433.32L342.56,433.1L342.56,433.1L344.48,433.15L345.96,431.36L347.1,431.84L347.66,431.73L348.14,430.89L349.01,430.31L349.56,430.71L353.33,429.83L354.6,430.21L355.73,429.92L358.83,427.6L362.08,427.92L363.49,427.71L366.71,426.03L369.22,423.62L369.83,423.75L370.31,426.64L370.15,427.66L371.12,428.49L371.33,429.27L372.4,429.75L371.9,431.55L371.97,434.67L371.41,435.99L372.23,437.53z"
				},
				{
					"id":"MX-DIF",
					"title":"Distrito Federal",
					"d":"M488.1,436.52L487.15,436.5L484.8,437.25L483.89,436.45L483.26,436.57L481.96,437.66L480.63,436.49L479.3,436.73L479.3,436.73L476.67,432.35L476.58,431.37L479.75,428.62L480.3,426.64L482.54,424.18L482.87,424.54L482.82,425.6L484.39,427.52L484.87,429.07L487.01,430.86L487.33,432.34L487.8,431.96L488.03,432.45L488.38,434.03L487.91,435.7z"
				},
				{
					"id":"MX-DUR",
					"title":"Durango",
					"d":"M280.5,258.08L280.82,257.43L283.13,256.65L283.44,257.97L284.52,258.63L286.12,258.41L286.64,259.27L288.65,259.6L289.32,260.81L289.96,261.09L291.19,259.48L294.72,256.76L296.84,253.34L296.23,251.44L295.26,249.88L296.98,245.89L297.9,245.63L297.54,243.49L297.95,243.13L298.95,243.29L298.95,241.93L299.81,241.06L301.79,240.19L302.12,239.61L302.15,238.54L301.03,238.04L300.88,237.58L301.78,236.05L301.75,234.45L302.65,231.06L303.28,230.59L303.23,228.75L304.99,228.18L305.2,226.89L305.97,226.35L306.64,227.24L307.91,227.3L309.82,228.53L310.88,228.76L311.84,230.7L313.1,231.41L313.38,231.99L315.32,232.22L316.9,233.58L317.88,233.58L318.64,234.67L320.28,234.38L321.38,236.27L322.65,236.02L324.21,236.49L324.44,237.09L326.12,236.13L326.53,236.67L327.1,236.58L327.62,236L329.22,235.3L329.23,234.22L329.77,234.26L330.51,234.94L331.73,235.27L334.27,235.03L336.22,236.92L337.94,238.11L338.92,238.32L340.66,237.41L342.37,237.61L342.81,237.37L343.06,236.6L342.82,235.26L344.71,232.18L346.22,231.64L347.37,230.12L349.87,229.73L349.94,228.73L348.4,228.61L347.92,227.95L348.23,227.21L348.96,226.89L350.34,227.78L351.77,228.02L352.45,229.02L353.88,229.3L354.76,228.49L356.27,229.06L359.48,228.01L360.27,228.13L359.83,228.85L360.11,229.02L360.62,228.34L361.77,229.2L362.87,228.96L362.87,228.96L363.59,229.59L366.57,230.38L367.79,231.56L368.61,232.77L370.91,234.9L372.29,238.87L371.85,241.8L372.02,243.19L373.7,247.14L373.29,249.42L373.47,251.41L374.67,255.88L373.47,258.99L372.41,259.8L371.01,261.95L370.92,262.81L371.59,263.63L372.93,263.89L373.73,265.12L371.47,265.57L370.11,266.93L370.74,270.08L372.51,272.2L373.11,273.94L375.54,275.87L376.08,278.99L376.7,279.85L378,281.05L381.42,282.64L384.2,282.8L386.3,284.15L386.99,283.94L387.27,283.42L386.77,281.7L387.28,279.56L387.86,278.55L390.91,276.52L390.91,276.52L391.26,277.04L391.3,278.69L392.05,279.03L392.41,280.13L393.94,280.84L394.74,281.78L393.93,286.68L395.14,287.13L396.16,291.13L395.19,291.65L395.17,292.06L395.67,292.43L395.55,293.11L389.48,293.69L387.8,293.46L387.04,294.37L384.38,293.5L383.38,292.8L382.26,292.7L380.01,293.5L377.78,292.8L373.88,292.53L372.17,293.9L371.7,295.24L369.3,297.06L367.23,299.89L364.97,302.03L362.57,302.75L362.34,304.07L363.12,304.58L363.49,306.23L363.18,307.91L363.55,309.8L363.1,311L363.99,315.27L361.19,317.69L358.87,320.58L358.78,322.46L357.49,328.23L356.88,328.6L355.51,331.33L355.43,332.61L356.28,335.7L356.12,341.25L355.87,341.88L352.66,343.3L351.65,344.81L350.49,347.86L350.49,347.86L347.55,349.16L347.15,350.54L346.67,350.57L344.85,349.46L343.9,347.39L341.41,345L339.7,344.57L338.31,342.81L336.96,345.37L336.15,346.22L335.46,346.19L333.26,341.61L334.95,339.85L336.65,338.98L337.25,338.09L337.13,336.85L335.98,336.88L335.46,336.51L334.88,334.05L332.79,333.89L331.46,333.29L329.93,331.54L329.39,331.51L328.48,332.82L326.8,333.17L324.6,330.53L324.6,330.53L322.48,328.35L321.88,328.29L321.03,328.89L318.99,328.74L318.38,327.46L318.25,325.2L317.03,323.86L316.29,322.12L316.56,321.19L315.51,318.27L315.07,315.46L313.35,313.81L312.45,311.83L311.37,310.62L310.74,307.67L310.03,306.61L309.24,304.02L309.5,303.12L308.47,302.19L308.38,299.99L306.64,297.72L306.5,296.65L305.42,296.39L304.53,295.01L303.08,294.05L299.04,292.88L298.37,293.92L295.58,296.04L294.25,296.23L293.56,296.78L292.86,296.29L292.02,296.47L291.43,294.51L290.45,293.1L289.64,288.98L289.44,288.73L288.87,289.15L288.3,288.95L287.09,284.48L285.77,284.17L284.88,281.56L282.58,281.34L282.05,281.78L280.85,280.82L281.18,279.38L279.98,277L279.23,276.35L278.75,274.53L277.74,273.92L278.25,271.96L278.34,266.84L279.67,263.63L279.59,262.95L279.12,263.03L278.52,262.31L280.25,260.09L281.44,259.32L281.29,258.59L280.56,258.75z"
				},
				{
					"id":"MX-GUA",
					"title":"Guanajuato",
					"d":"M465.16,371.7L465.66,372.19L465.55,374.25L464.4,376.16L466.88,376.77L466.84,377.94L466.13,379.38L464.68,380.05L464.12,381.08L463.02,381.25L461.29,379.5L459.77,380.06L457.52,383.4L457.62,384.85L456.95,386.45L456.13,385.97L455.91,387.07L455.25,387.47L452.53,387.09L451.03,387.8L446.45,388.08L445.73,389.49L445.08,393.29L445.22,394.05L446.18,394.76L446.83,396.5L446.82,399.21L447.91,401.07L449.93,402.48L450.65,404.15L450.65,404.15L450.22,405.24L450.82,406.42L450.92,407.74L450.41,409.49L451.08,409.54L451,410.53L449.82,411.68L447.76,411.96L447.03,412.75L446.55,414.15L445.93,414.33L446.26,412.83L445.76,412.59L443.82,413.07L442.44,414.09L439,413.92L436.42,413.01L435.12,412.87L434.51,413.16L434.25,413.06L434.46,412.59L434,410.25L431.79,410.85L430.4,410.41L429.74,410.99L430.07,411.81L428.85,412.33L427.05,411.59L424.51,411.35L424.04,410.85L424.02,407.61L423.57,405.88L424.61,406.4L425.24,406.13L423.9,404.33L422.81,403.58L421.38,403.82L420.75,403.43L418.65,404.12L416.64,406.92L415.73,406.62L413.52,406.76L413.04,406.33L411.86,407.03L411.05,406.94L410.61,406.49L409.93,403.64L410.29,403.24L409.72,402.75L409.17,402.82L408.84,402.28L407.98,402.23L407.98,402.23L408.36,399.46L410.15,396.03L408.58,393.16L406.93,392.73L406.38,391.42L408.39,389.46L408.51,388.63L410.32,387.13L412.23,383.18L414.72,381.27L415.84,378.56L415.73,377.91L416.25,377.17L417.72,377.08L418.15,376.71L418.82,375.34L418.01,374.87L418.59,372.68L417.89,372.56L419.41,367.03L419.29,366.33L420.49,364.97L419.75,364.14L420.97,362.85L420.97,362.85L421.94,363.48L422.75,362.54L422.75,362.54L423.91,363.21L426.82,363.52L428.08,364.25L432.71,365.31L433.94,366.06L435.01,366.02L439.98,369.74L442.72,371.17L445.47,371.14L446.99,370.53L446.84,369.41L447.46,367.58L448.54,366.85L452.43,368.13L455.58,370.13L455.85,370.82L456.33,370.73L458.03,372.86L459.84,372.69L460.23,372.15L460.91,372.99L462.52,373.03z"
				},
				{
					"id":"MX-GRO",
					"title":"Guerrero",
					"d":"M449.19,436.82l0.3,2.94l-1.05,1.92l-0.74,4.23l0.37,1.6l1.75,0.76l0.1,1.19l-0.25,0.72l-1.66,1.81l0.65,0.66l1.33,-0.27l1.51,0.33l0.22,1.08l1.57,1.96l0.04,-0.43l0.62,0.03l0.34,-0.39l0.19,0.37l1.98,-2.18l2.47,-0.58l-0.69,-1.38l0.35,-0.6l1.02,-0.49l0.79,0.43l3.51,-0.23l0.29,-0.58l0.88,-0.42l0.85,0.29l0.44,-1.56l1.76,-0.32l-0.36,-1.72l0.81,-0.05l0.91,1.08l1.98,0.67l0.82,-0.49l0.81,0.13l0,0l0.51,0.84l-0.65,1.12l0.44,0.35l1.08,-0.23l1.12,0.46l2.02,2.67l5.51,0.7l2.3,2.33l0,0l-0.05,1.23l1.35,1.18l1.34,0.62l1.22,2.25l2.99,-0.2l0.22,0.8l-0.83,0.97l4.21,1.78l0.12,1.07l1.4,-0.3l0.47,0.27l0.86,-0.86l1.55,-0.14l1.61,1.98l1.61,0.8l0,0l-1.74,3.95l-0.17,1.41l2.73,6.06l0.6,4.58l-0.92,0.83l-0.18,2.06l0.56,0.52l2.3,0.78l0.45,1.17l-0.11,1.91l0.27,0.59l1.16,0.25l0.42,0.54l0.36,1.56l-0.92,2.88l-0.91,0.92l-1.22,0.23l-0.93,0.67l-0.18,1.35l-4.11,3.59l-0.46,2.02l-4.64,3.54l0,0l-3.56,-3.61l-1.93,-2.51l-1.69,0.16l-0.33,0.56l-1.28,-0.19l-10.62,-3.2l-3.11,-0.65l-4,-0.04l-1.63,-0.53l-2.08,-1.09l-1.81,-1.48l-0.99,-0.26l0.62,-0.64l-0.23,-0.44l-0.98,0.04l0.19,0.43l-0.57,0.25l-1.11,-1.73l-0.88,-0.44l-26.59,-9.48l0.13,-0.58l-0.51,-0.64l-2.49,-1.75l-0.76,-0.98l-6.24,-2.63l0.23,-0.84l-0.91,-1.08l-0.81,-0.57l-2.18,-0.28l-0.1,-0.54l-1.05,-0.38l-0.76,-1.89l-1.86,-1.33l-1.37,-2.35l-3.81,-2.12l-2.2,-0.68l-1.37,0.18l-0.74,0.82l-0.53,-0.32l0,0l-0.82,-1.26l0.11,-3.93l0.76,-0.63l2.64,-0.82l0.86,0.25l1.46,-0.64l0.76,-0.77l1.62,0.37l0.82,-0.28l0.18,-0.32l-1.84,0.03l0.33,-0.9l-0.11,-1.23l-0.65,-1.41l0.58,-1.1l-0.63,-1.23l0.13,-0.34l0.64,-0.03l-0.47,-0.79l0.68,-0.39l0.62,0.14l-0.21,-0.46l0.56,-0.11l0.53,0.82l0.48,-0.77l-0.33,-0.41l1.06,-0.33l0.06,1.05l0.6,-0.38l0.29,0.38l0.15,-0.67l0.67,-0.24l1.13,0.03l1.21,1.9l2,0.91l3.46,-0.51l0.21,-0.46l2.03,-0.46l1.72,0.04l0.47,0.49l2.03,0.47l1.57,-0.19l1.13,0.28l1.18,1.66l0.08,0.82l0.64,0.13l1.42,-1.1l0.62,0.57l1.44,0.23l0.4,0.79l1.49,0.85l0.34,-0.42l0.4,0.3l0.27,1.06l0.81,-0.03l0.77,-1.01l-2.83,-3.79l-0.3,-3.14l-1.22,-4.24l0.47,-1.03l1.1,-0.85l0.42,0.04l0.57,1.57l2.44,-2.92l0.93,-0.53l1.09,-2.45L449.19,436.82zM453.83,455.57l0.07,0.32l0.38,-0.34L453.83,455.57z"
				},
				{
					"id":"MX-HID",
					"title":"Hidalgo",
					"d":"M496.34,374.47L497.18,374.64L497.48,375.39L497.18,378.05L499.01,379.76L500.27,380.42L501.58,380.49L502.44,379.59L504.47,380.21L507,383.63L505.14,386.09L504.51,388.3L505.07,389.36L504.81,389.99L503.36,390.22L502.02,388.83L501.56,388.83L499.17,390.99L498.85,391.85L498.2,392.39L497.87,396.05L497.29,397.35L497.04,399.43L498.21,402.02L499.09,403.1L499.59,402.88L500.92,401.33L503.4,400.17L505.28,397.94L506.88,397.21L509.02,394.88L509.85,394.53L511.31,395.48L511.31,395.48L511.38,398.48L508.52,401L507.61,402.38L503.99,404.23L504.69,405.64L506.81,405.16L507.27,407.35L506.46,412.15L504.92,415.23L505.62,419.96L505.62,419.96L503.24,419.46L502.42,420.93L500.97,422.14L498.88,422.42L497.88,422.19L492.87,423.9L492.87,423.9L492.67,422.49L494.51,418.34L494.34,416.6L488.53,417.21L486.81,419.79L486.57,420L485.92,419.68L485.94,418.78L485.07,417.01L485.27,416.49L486.18,415.96L487.03,415.88L488.14,411.6L487.67,410.26L487.07,410.19L484.34,411.58L480.46,412.65L479.93,416.4L479.24,417.16L477.11,416.15L476.94,418.39L475.73,419.38L475.83,416.89L475.43,415.55L474.74,414.9L474.4,413.65L473.18,412.39L473.88,411.4L472.37,408.27L471.73,408.02L471.6,407.44L466.95,406.75L464.32,405.26L463.14,403.87L463.14,403.87L464.15,397.33L465.73,396.84L466.64,396.16L469.57,395.44L471.89,393.83L471.26,391.81L472.41,389.25L473.57,388.83L474.38,387.63L474.85,385.42L475.68,383.86L475.41,382.75L477.06,381.32L478.27,382.03L482.38,380.74L483.66,377.61L483.66,377.61L485.92,376.86L487.06,379.26L488.4,380.36L489.48,380.32L490.83,377.94L491.75,379.25L493.08,376.29L494.66,374.45z"
				},
				{
					"id":"MX-JAL",
					"title":"Jalisco",
					"d":"M390.24,367.07L392.29,365.95L396.5,366.33L398.24,367.74L400.41,368.76L401.67,368.7L404.69,367.66L405.41,367.16L407.96,363.61L412.24,361.64L410.28,359.5L410.52,357.9L410.26,357.31L410.26,357.31L413.8,358.22L415.93,359.36L418.6,361.71L420.69,362.46L420.97,362.85L420.97,362.85L419.75,364.14L420.49,364.97L419.29,366.33L419.41,367.03L417.89,372.56L418.59,372.68L418.01,374.87L418.82,375.34L418.15,376.71L417.72,377.08L416.25,377.17L415.73,377.91L415.84,378.56L414.72,381.27L412.23,383.18L410.32,387.13L408.51,388.63L408.39,389.46L406.38,391.42L406.93,392.73L408.58,393.16L410.15,396.03L408.36,399.46L407.98,402.23L407.98,402.23L405.18,402.24L403.04,403.28L401.33,403.11L400,403.57L398.32,403.44L397.25,403.78L395.19,405.42L394.13,405.34L393.12,406.39L392.18,406.72L391.9,408.15L388.93,408.88L388.7,409.69L388.26,409.73L387.21,408.43L384.74,407.98L384.44,409.13L383.51,408.93L383.15,409.2L383.13,411.55L382.24,413.06L382.74,413.9L383.24,413.95L383.69,413.39L385.96,413.67L389.17,414.61L389.83,415.25L390.44,417.46L390.11,418.27L389.18,419.01L391.09,423.21L390.46,425.8L393.82,425.73L394.43,426.41L394.49,427.97L392.13,430.47L391.28,432.78L388.97,432.2L387.6,432.92L383.58,436.5L381.38,437.71L379.79,439.45L379.5,439.54L378.24,437.78L377.71,437.68L375.49,439.38L373.94,439.08L372.28,439.49L372.28,439.49L372.23,437.53L371.41,435.99L371.97,434.67L371.9,431.55L372.4,429.75L371.33,429.27L371.12,428.49L370.15,427.66L370.31,426.64L369.83,423.75L369.22,423.62L366.71,426.03L363.49,427.71L362.08,427.92L358.83,427.6L355.73,429.92L354.6,430.21L353.33,429.83L349.56,430.71L349.01,430.31L348.14,430.89L347.66,431.73L347.1,431.84L345.96,431.36L344.48,433.15L342.56,433.1L342.56,433.1L342,432.57L341.37,432.66L341.29,432.15L340.63,432.41L340.14,432.11L339.29,432.24L339.3,431.6L339.81,431.05L339.68,430.59L338.79,430.3L338.56,430.73L337.63,430.92L335.63,429.85L333.74,428.13L334.1,427.41L333.73,426.68L332.89,426.21L332.98,425.36L332.53,425.14L332.31,423.65L331.55,422.91L330.71,422.88L330.75,422.52L327.92,420.41L327.66,419.68L326.23,418.17L325.83,417.06L321.91,411.73L320.79,409.41L321,407.2L320.66,405.98L319.98,405.74L319.85,405.14L317.61,402.8L317.15,401.15L318.2,400.64L319.15,399.51L326.56,398.35L328.06,397.25L328.72,395.64L328.41,394.67L327.13,393.61L327.13,393.61L331.58,387.99L332.75,387.54L335.08,388.01L338.27,385.57L339.52,385.36L341.02,386.09L342.23,387.52L345.31,388.3L347.97,391.31L349.05,391.87L351.35,393.99L352.02,394.77L352.52,396.32L353.03,396.64L353.06,395.18L351.88,393.72L352.17,393.37L351.44,392.62L351.07,391.09L351.52,390.45L352.34,390.27L353.84,381.76L357.88,381.53L358.83,381.13L359.8,380.16L361.51,379.88L363.76,378.6L364.16,377.78L364.56,373.56L364.32,372.08L362.93,370.84L361.19,366.55L356.69,365.95L355.84,364.34L355.73,361.62L355.2,361.14L354.09,361.05L352.89,359.89L351.24,360.41L350.78,357.39L352.02,352.5L351.84,352.02L351.84,352.02L352.92,350.81L354.27,351.15L354.63,348.12L357.73,346.95L358.26,347.32L357.21,350.56L357.48,351.05L359.28,349.91L360.31,348.73L360.15,347.3L358.41,343.46L358.52,342.67L360.68,341.14L363.34,340.76L365.15,341.77L364.98,342.68L363.88,343.5L362.43,345.37L360.74,349.59L360.7,352.91L361.91,354.69L363.07,354.86L363.45,353.7L363.45,346.66L364.08,346.09L367.51,345.42L368.93,345.93L370.33,347.25L370.93,349.18L370.89,350.34L367.11,356.51L367.02,356.96L367.6,357.62L369.53,357.64L370.22,356.84L371.49,357.04L372.2,357.56L373.1,357.12L374.03,355.39L376.42,353.5L375.18,352.47L375.49,350.6L377.37,349.87L379.54,350.04L379.95,350.9L379.19,352.41L379.69,352.85L381.84,352.99L382.35,353.37L381.65,356.84L380.46,359.75L379.72,360.44L378.46,360.64L375.18,362.32L373.41,364.05L370.49,366.12L370.67,367.91L370.34,370.38L368.72,372.26L366.93,372.72L367.78,375.2L368.71,375.74L369.73,375.25L370.4,375.39L370.74,375.97L370.64,376.99L369.47,378.11L365.43,379.92L365.6,380.42L368.1,381.04L368.85,381.85L369.6,383.55L370.54,384.04L372.8,383.85L375.7,385.46L376.69,384.98L377.57,385.05L377.79,384.49L379.13,384.23L380.84,384.66L380.95,384.29L382.42,383.77L382.75,381.75L383.38,381.21L384.75,380.72L386.27,381.22L389.85,378.31L392.14,376.91L393.1,375.6L393.58,372.91L390.8,371.13L390.15,369.28z"
				},
				{
					"id":"MX-MEX",
					"title":"México",
					"d":"M454.28,455.55l-0.38,0.34l-0.07,-0.32L454.28,455.55zM463.14,403.87l1.17,1.4l2.64,1.49l4.64,0.69l0.13,0.58l0.64,0.26l1.51,3.12l-0.7,1l1.22,1.25l0.34,1.25l0.69,0.65l0.4,1.34l-0.1,2.49l1.21,-1l0.17,-2.24l2.13,1.01l0.69,-0.77l0.53,-3.75l3.88,-1.08l2.73,-1.38l0.59,0.06l0.47,1.34l-1.11,4.28l-0.85,0.08l-0.91,0.52l-0.21,0.52l0.87,1.78l-0.01,0.89l0.64,0.32l0.24,-0.2l1.72,-2.58l5.82,-0.61l0.17,1.74l-1.84,4.15l0.19,1.42l0,0l0.97,1.82l0.76,-0.24l0.52,0.6l0,0l0.39,1.82l-0.56,0.61l-0.04,1.09l1.04,3.63l0.12,4.4l0,0l-0.89,0.18l-2.61,2.06l-2.55,-0.94l-0.93,-1.59l-0.98,-0.83l0,0l-0.19,-0.83l0.47,-1.67l-0.35,-1.58l-0.23,-0.5l-0.47,0.38l-0.31,-1.48l-2.14,-1.8l-0.48,-1.54l-1.57,-1.92l0.05,-1.06l-0.33,-0.36l-2.24,2.46l-0.56,1.98l-3.17,2.75l0.1,0.98l2.62,4.38l0,0l-3.95,6.3l-0.45,1.43l-1.56,1.84l-0.24,1l0,0l-0.81,-0.13l-0.82,0.49l-1.98,-0.67l-0.91,-1.08l-0.81,0.05l0.36,1.72l-1.76,0.32l-0.44,1.56l-0.85,-0.29l-0.88,0.42l-0.29,0.58l-3.51,0.23l-0.79,-0.43l-1.02,0.49l-0.35,0.6l0.69,1.38l-2.47,0.58l-1.98,2.18l-0.19,-0.37l-0.34,0.39l-0.62,-0.03l-0.04,0.43l-1.57,-1.96l-0.22,-1.08l-1.51,-0.33l-1.33,0.27l-0.65,-0.66l1.66,-1.81l0.25,-0.72l-0.1,-1.19l-1.75,-0.76l-0.37,-1.6l0.74,-4.23l1.05,-1.92l-0.3,-2.94l0,0l0.56,-0.38l0.23,-1.13l1.5,-1.83l1.1,-2.39l-0.28,-0.98l0.76,-1.78l0.43,-0.6l0.67,-0.12l0.3,-0.62l-0.44,-5.18l-0.57,-0.47l-0.96,-1.95l1.51,0.1l1.44,-0.5l0.29,-0.51l0.28,-2.06l1.33,-1.7l-0.04,-0.61l-0.87,-0.82l0.08,-2.43l0,0l2.55,-0.31l1.92,-2.01l-0.29,-1.73l-0.54,-0.96l0.24,-0.31l0.88,0.6l0.65,-0.13l-0.21,-0.72l0.3,-0.63L463.14,403.87z"
				},
				{
					"id":"MX-MIC",
					"title":"Michoacán",
					"d":"M407.98,402.23L408.84,402.28L409.17,402.82L409.72,402.75L410.29,403.24L409.93,403.64L410.61,406.49L411.05,406.94L411.86,407.03L413.04,406.33L413.52,406.76L415.73,406.62L416.64,406.92L418.65,404.12L420.75,403.43L421.38,403.82L422.81,403.58L423.9,404.33L425.24,406.13L424.61,406.4L423.57,405.88L424.02,407.61L424.04,410.85L424.51,411.35L427.05,411.59L428.85,412.33L430.07,411.81L429.74,410.99L430.4,410.41L431.79,410.85L434,410.25L434.46,412.59L434.25,413.06L434.51,413.16L435.12,412.87L436.42,413.01L439,413.92L442.44,414.09L443.82,413.07L445.76,412.59L446.26,412.83L445.93,414.33L446.55,414.15L447.03,412.75L447.76,411.96L449.82,411.68L451,410.53L451.08,409.54L450.41,409.49L450.92,407.74L450.82,406.42L450.22,405.24L450.65,404.15L450.65,404.15L452.2,405.14L453.42,407.06L453.24,407.81L456.53,410.85L456.53,410.85L456.45,413.28L457.32,414.09L457.35,414.71L456.02,416.41L455.74,418.46L455.45,418.98L454.02,419.47L452.5,419.37L453.46,421.33L454.03,421.8L454.46,426.98L454.16,427.6L453.5,427.71L453.06,428.31L452.3,430.1L452.58,431.08L451.48,433.47L449.98,435.3L449.75,436.43L449.19,436.82L449.19,436.82L446.94,438.2L445.85,440.66L444.92,441.19L442.48,444.11L441.91,442.54L441.49,442.5L440.39,443.35L439.92,444.38L441.14,448.61L441.44,451.76L444.27,455.55L443.5,456.56L442.69,456.58L442.42,455.52L442.02,455.22L441.68,455.63L440.2,454.79L439.8,454L438.36,453.77L437.74,453.2L436.33,454.3L435.68,454.18L435.6,453.35L434.42,451.69L433.29,451.42L431.72,451.61L429.69,451.14L429.22,450.64L427.5,450.6L425.47,451.06L425.26,451.52L421.8,452.02L419.81,451.11L418.6,449.21L417.47,449.18L416.81,449.43L416.66,450.1L416.37,449.72L415.77,450.1L415.71,449.04L414.65,449.38L414.97,449.78L414.49,450.55L413.96,449.73L413.4,449.84L413.61,450.3L412.99,450.16L412.31,450.55L412.78,451.34L412.14,451.37L412.01,451.71L412.64,452.94L412.06,454.04L412.71,455.44L412.82,456.67L412.49,457.57L414.33,457.55L414.15,457.86L413.33,458.14L411.71,457.77L410.95,458.55L409.48,459.19L408.62,458.94L405.99,459.76L405.23,460.39L405.12,464.32L405.94,465.59L405.94,465.59L406.13,466.35L404.85,466.88L401.89,465.42L397.84,464.21L389.93,462.48L384.8,460.09L381.02,459.39L376.07,457.53L375.55,457.76L371.74,455.44L369.97,451.33L367.1,449.1L367.46,448.26L365.9,446.37L365.9,446.37L366.58,444.67L368.44,443.49L368.41,441.7L368.79,441.42L369.81,441.73L372.28,439.49L372.28,439.49L373.94,439.08L375.49,439.38L377.71,437.68L378.24,437.78L379.5,439.54L379.79,439.45L381.38,437.71L383.58,436.5L387.6,432.92L388.97,432.2L391.28,432.78L392.13,430.47L394.49,427.97L394.43,426.41L393.82,425.73L390.46,425.8L391.09,423.21L389.18,419.01L390.11,418.27L390.44,417.46L389.83,415.25L389.17,414.61L385.96,413.67L383.69,413.39L383.24,413.95L382.74,413.9L382.24,413.06L383.13,411.55L383.15,409.2L383.51,408.93L384.44,409.13L384.74,407.98L387.21,408.43L388.26,409.73L388.7,409.69L388.93,408.88L391.9,408.15L392.18,406.72L393.12,406.39L394.13,405.34L395.19,405.42L397.25,403.78L398.32,403.44L400,403.57L401.33,403.11L403.04,403.28L405.18,402.24z"
				},
				{
					"id":"MX-MOR",
					"title":"Morelos",
					"d":"M479.3,436.73L480.63,436.49L481.96,437.66L483.26,436.57L483.89,436.45L484.8,437.25L487.15,436.5L488.1,436.52L488.1,436.52L489.08,437.35L490.01,438.94L492.56,439.88L495.18,437.82L496.07,437.64L496.07,437.64L493.31,444.72L494.58,452.56L494.03,453.28L491.27,450.64L490.76,450.76L489.96,452.02L488.8,452.66L488.19,453.65L485.42,455.55L485.42,455.55L483.12,453.21L477.61,452.52L475.59,449.84L474.46,449.39L473.39,449.62L472.95,449.26L473.6,448.14L473.1,447.31L473.1,447.31L473.34,446.3L474.9,444.46L475.34,443.03z"
				},
				{
					"id":"MX-NAY",
					"title":"Nayarit",
					"d":"M303.72,376.47l0.16,0.81l-0.79,0.37l-0.46,-0.71l0.42,-0.46L303.72,376.47zM298.54,372.12l1.56,0.44l0.4,0.56l-0.51,0.38l-0.15,0.76l-2.29,-0.87l-0.4,-0.53L298.54,372.12zM293.12,366.82l2.62,0.7l0.4,0.44l-0.06,0.59l0.77,0.78l-0.21,0.87l-0.6,0.37l-2.37,-1.27l-0.54,-1.38L293.12,366.82zM292.68,364.72l0.36,1l-0.51,0.23l-0.24,-0.83L292.68,364.72zM317.4,343.32l0.58,1.44l-0.17,1.35l0.55,0.48l-0.21,0.67l0.94,6.35l-0.6,0.03l-0.18,-0.4l-0.75,-4.16l-1.96,-4.49l0.28,-0.25l1.1,1.77l0.76,-0.25l-0.74,-2.17L317.4,343.32zM324.6,330.53l2.2,2.64l1.68,-0.35l0.91,-1.31l0.54,0.03l1.52,1.75l1.33,0.6l2.09,0.16l0.58,2.47l0.52,0.37l1.15,-0.03l0.12,1.24l-0.59,0.89l-1.7,0.87l-1.69,1.76l2.2,4.58l0.69,0.03l0.81,-0.85l1.35,-2.56l1.39,1.76l1.7,0.43l2.49,2.39l0.96,2.07l1.81,1.12l0.48,-0.04l0.4,-1.38l2.94,-1.3l0,0l0.21,2.77l0.42,0.96l0.73,0.43l0,0l0.18,0.48l-1.25,4.89l0.46,3.02l1.66,-0.52l1.2,1.15l1.11,0.09l0.53,0.48l0.11,2.72l0.85,1.62l4.5,0.6l1.74,4.29l1.39,1.24l0.24,1.47l-0.4,4.22l-0.4,0.83l-2.25,1.28l-1.72,0.28l-0.97,0.97l-0.96,0.4l-4.04,0.23l-1.5,8.51l-0.82,0.18l-0.45,0.64l0.38,1.53l0.73,0.75l-0.29,0.35l1.18,1.46l-0.04,1.46l-0.51,-0.32l-0.5,-1.55l-0.68,-0.78l-2.3,-2.12l-1.08,-0.55l-2.66,-3.01l-3.08,-0.79l-1.21,-1.43l-1.5,-0.73l-1.25,0.22l-3.19,2.43l-2.33,-0.46l-1.17,0.45l-4.45,5.62l0,0l-1.22,-1.75l-0.47,-0.08l-0.88,0.73l-3,-0.99l0.77,-0.63l0.92,-2.15l0.36,0.09l0.87,-1.57l1.21,-0.8l0.88,-1.17l0.15,-0.84l1.02,0.35l1.14,-1.62l-0.28,-0.98l0.5,-3.15l-0.65,-2.83l1.39,-2.69l-0.21,-1.25l-0.74,-0.84l-0.93,0.31l-4.66,-3.17l-1.43,-3.57l-2.97,-5.06l-0.73,-2.66l0.18,-3.21l0.8,-0.38l0.46,1.19l0.6,0.1l0.31,0.8l1.98,0.97l0.3,-1.52l-1.02,-0.71l-0.25,0.25l-0.35,-0.75l-1.02,0.34l-0.19,-0.57l0.38,-0.35l-0.07,-0.61l-0.45,-0.06l-0.33,0.42l-0.33,-0.3l0.13,-0.7l-0.52,-0.97l-0.21,-3.39l-0.3,-0.57l0.19,-0.85l-0.58,-0.39l0.25,-0.68l-0.63,-2.11l0.33,-0.17l0,0l2.1,1.24l3.46,0.57l0.36,-0.89l-0.23,-2.04l-0.4,-0.36l-0.21,-1.33l-1.31,-1.3l-0.45,-1.3l0.33,-1.02l1.69,-2.1l0.56,-3.41L324.6,330.53z"
				},
				{
					"id":"MX-NLE",
					"title":"Nuevo León",
					"d":"M466.54,203.14L465.89,203.48L464.61,205.21L461.83,206.01L461.21,206.7L461.48,207.49L461.13,208.56L461.73,209.01L465.73,209.2L465.78,210.08L464.61,211.5L465.88,212.37L465.66,214.83L465.9,216.21L467.05,217.34L467.47,220.53L465.83,221.92L465.02,224.31L465.15,225.43L466.62,225.38L467.87,226.04L468.39,226.82L467.92,228.11L467.69,231.33L468.49,232.15L469.37,231.78L470.04,232.18L470.88,234.08L472.76,234.3L474,238.44L475.82,240.93L477.23,240.8L477.17,241.8L478.34,243.42L479.03,243.51L479.78,242.78L480.41,242.83L480.59,243.43L480.23,244.16L480.99,245.5L480.1,245.83L480.92,246.29L481.29,246.94L484.57,247.4L485.22,247.99L486.41,250.33L487.36,250.87L490.02,249.34L491.09,249.49L494.47,248.8L495.16,249.25L495.3,250.72L496.09,251.73L495.79,255.08L496.38,256.6L495.91,257.37L495.71,259.44L496.4,261.01L495.99,261.81L496.98,262.64L498.97,263.27L499.37,263.53L499.4,264.05L497.86,265.63L497.27,267L496.02,267.62L494.66,269.06L493.88,269.14L492.89,270.27L488.51,271.12L487.52,272.26L486.77,274.29L483.97,274.07L483.36,272.9L482.85,272.86L481.39,274.83L480.13,275.24L479.88,275.64L480.48,277.88L481.15,278.24L480.77,279.91L479.87,280L478.95,280.69L478.48,282.29L477.36,282.74L476.98,281.22L476.6,281.35L476.24,282.39L475.09,282.86L473.97,284.46L472.21,284.36L470.91,286.49L468.04,287.76L466.05,289.11L465.36,291.21L465.58,291.49L467.41,291.4L468.67,294.02L467.81,300.79L469.58,302.88L470.98,306.52L472.35,307.29L473.11,309.63L470.86,309.19L470.5,309.29L470.16,310.8L468.4,311.77L467.69,311.92L465.14,311.24L462.83,312.47L462.17,315.28L460.69,317.05L460.36,318.01L460.75,320.85L460.54,322.62L457.45,322.24L456.65,322.92L457.2,324.27L456.77,325.04L456.77,325.04L452.87,324.3L450.53,327.1L449.03,326.38L447.79,324.91L447.23,323.26L446.98,319.17L446.47,317.9L447.62,312.3L447.51,311.41L446.54,309.95L446.75,305.58L445.87,303.33L443.39,300.2L443.52,298.77L441.73,297.06L441.44,296.25L442.64,294.68L442.69,294.35L442,294.09L442.48,292.52L441.09,292.02L440.04,292.21L438.32,289.89L438.32,289.89L438.87,289.47L438.87,289.47L439.87,286.21L439.22,284.98L439.11,283.59L437.73,282.04L438.05,280.84L437.76,280.01L437.92,279.64L440.33,279.58L440.53,279.19L440.44,277.03L439.55,274.1L441.25,270.88L443.04,270.31L442.75,269.5L443.69,269.19L445.43,269.36L446.74,270.89L450.15,271.77L452.09,271.8L452.43,271.6L452.58,270.45L453.33,269.56L452.94,268.61L452.06,268.29L451.56,267.49L447.96,266.86L448.47,265.81L445.19,263.93L444.37,263.08L443.81,259.67L443.46,259.31L441.33,259.23L440.49,258.57L439.38,258.43L438.54,256.65L438.3,254.18L439.29,251.28L438.91,250.64L438.05,250.56L436.63,249.41L435.58,246.3L432.88,244.28L428.34,239.5L428.32,238.2L430.74,235.78L431.78,233.05L432.65,232.15L436.16,231.87L438.77,230.17L441.97,230.21L443.11,228.02L444.16,227.25L445,225.01L444.58,219.88L442.53,218.4L441.9,218.33L441.2,221.45L440.61,221.5L437.79,219.43L437.54,216.09L439.37,213.11L440.56,212.07L441.75,212.45L443.85,211.53L446.08,211.65L446.71,211.16L446.55,208.87L446.84,208.08L448.53,205.48L449.08,203.14L450.21,202.51L453.88,202.25L459.4,203.17L461.32,201.87L462.27,201.81L463.36,201.02L463.62,200.41L463.62,200.41L464.37,200.24L464.61,201.17L465.38,201.42z"
				},
				{
					"id":"MX-OAX",
					"title":"Oaxaca",
					"d":"M543.58,453.39L544.75,451.21L545.05,450.25L544.56,449.51L544.61,448.65L545.26,448.04L546.41,449.2L547.41,449.55L546.83,450.82L547.44,453.56L548.08,454.46L550.04,456.01L551.34,455.63L552.73,456.44L553.75,458.33L555.13,458.42L554.59,459.32L555.29,459.67L557.76,458.89L559.19,459.41L560.34,459.22L562.37,459.7L562.89,460.14L563.89,463.93L563.67,465.18L562.86,466.3L561.87,468.87L561.15,469.55L561.49,470.27L561.32,471.45L563.49,475.87L565.45,476.45L566.71,475.8L569.58,475.63L572.59,473.53L576.25,472.61L577.46,471.52L577.88,471.59L579.25,472.43L579.07,473.11L577.58,473.77L577.35,474.9L580.71,479.31L584.16,482.1L584.15,483.09L584.79,483.66L584.46,485.03L613.03,486.78L613.03,486.78L612.69,487.72L612.72,489.72L611.96,490.74L611.16,494.23L608.22,496.85L606.03,503.14L605.95,503.99L607.19,506.92L606.67,508.38L606.79,510.49L606.79,510.49L606.83,510.93L604.85,511.82L604.36,511.73L603.84,511.3L603.12,511.37L602.33,510.5L601.46,510.52L600.57,509.01L599.45,509.4L599.47,510.39L598.81,510.44L598.79,511.07L599.91,512.03L604.28,512.35L607.35,514.64L607.35,514.64L607.17,515.28L607.17,515.28L602.46,513.21L599.5,512.3L591.81,511.18L591.57,510.73L594.21,509.83L594.94,509.18L595.34,508.05L592.96,507.21L591.67,508.11L591.28,508.88L590.32,508.93L590.05,509.54L589.54,509.39L589.44,509L590.54,508.06L589.44,507.13L589.68,506.52L588.29,505.47L586.62,505.91L585.32,508.14L584.07,508.11L583.15,508.93L583.36,509.79L582.75,509.85L582.31,510.65L588.73,510.64L590.57,510.88L590.69,511.17L587.05,511.23L583.06,511.9L581.21,511.74L581.05,512.35L579.03,512.52L578.55,512.98L577.92,512.98L577.76,513.98L575.74,514.87L575.4,515.39L575.61,516.17L574.24,516.63L574.06,517.17L572.51,516.99L572.4,517.57L570.43,517.57L570.32,518.04L568.29,518.93L565.85,519.27L564.57,520.12L560.72,521.13L557.99,522.39L558,522.65L556.54,523.05L556.72,523.38L553.77,524.81L549.32,524.54L547.45,525.51L545.88,525.48L542.34,523.99L538.33,523.39L536.78,522.44L534.35,521.68L533.58,521.14L533.31,520.37L529.55,518.67L526.29,518.06L524.27,518.19L521.63,517.46L520.89,517.64L518.32,517.24L517.88,517.63L515.45,517.26L509.77,513.52L504.33,510.62L499.66,509.78L495.84,508.4L495.84,508.4L500.48,504.85L500.94,502.84L505.05,499.25L505.24,497.9L506.17,497.23L507.39,497L508.29,496.09L509.21,493.21L508.85,491.66L508.43,491.12L507.27,490.86L507,490.27L507.11,488.36L506.66,487.19L504.37,486.41L503.81,485.9L503.99,483.83L504.91,483L504.3,478.42L501.57,472.36L501.74,470.94L503.48,466.99L503.48,466.99L504.68,465.59L506.75,464.24L508.32,463.88L511.78,463.87L513.23,463.28L515.42,464.89L516.6,465.25L517.32,465.04L519.09,463.4L519.02,462.97L516.67,461.33L516.23,460.57L518.26,456.24L519.82,455.56L521.41,455.36L521.89,455.7L522.12,456.67L522.02,457.13L520.69,458.03L520.79,458.43L522.1,459.39L522.84,460.47L524.28,463.29L524.64,464.93L525.46,465.63L526.33,464.78L527.24,462.88L529.84,460.3L531.2,460.01L534.92,460.9L536.7,459.42L536.81,458.53L537.1,459.09L538.46,458.19L540.85,457.68L542.77,454.23z"
				},
				{
					"id":"MX-PUE",
					"title":"Puebla",
					"d":"M511.31,395.48L512.01,392.92L512.97,392.17L513.06,391.34L513.94,390.4L514.21,389.38L515.39,389.77L517.42,389.45L517.41,391.24L516.18,391.99L516.34,392.29L517.21,392.1L518.02,392.7L517.65,393.54L517.81,394.38L518.62,395.22L520.85,396.44L521.33,397.56L519.83,400.03L518.22,399.11L517.05,399.87L517.11,403.88L517.57,406.25L518.25,406.8L520.29,406.58L521.15,408.36L521.74,408.56L523.35,407.16L524.57,405.21L525.39,404.55L532.45,407.03L532.53,407.54L530.37,410.53L528.72,414.81L528.52,415.62L528.84,416.6L528.5,417.57L527.83,418.44L526.86,421.07L526.29,421.31L526.04,422.01L527.42,425L526.87,426.38L527.21,426.8L528.64,427.79L532.27,428.61L535.2,429.88L535.67,430.47L535.78,431.75L535.62,432.45L535.09,432.57L530.27,432.35L530.08,433.25L530.6,439.37L530.53,439.92L528.67,442.33L528.67,445.32L529.03,446.43L529.88,447.16L533.69,448.27L533.52,449.02L535.38,452.15L536.81,452.25L537.76,451.2L539.15,450.4L541.73,451.23L543.58,453.39L543.58,453.39L542.77,454.23L540.85,457.68L538.46,458.19L537.1,459.09L536.81,458.53L536.7,459.42L534.92,460.9L531.2,460.01L529.84,460.3L527.24,462.88L526.33,464.78L525.46,465.63L524.64,464.93L524.28,463.29L522.84,460.47L522.1,459.39L520.79,458.43L520.69,458.03L522.02,457.13L522.12,456.67L521.89,455.7L521.41,455.36L519.82,455.56L518.26,456.24L516.23,460.57L516.67,461.33L519.02,462.97L519.09,463.4L517.32,465.04L516.6,465.25L515.42,464.89L513.23,463.28L511.78,463.87L508.32,463.88L506.75,464.24L504.68,465.59L503.48,466.99L503.48,466.99L501.87,466.19L500.27,464.21L498.72,464.35L497.86,465.21L497.39,464.94L495.99,465.25L495.86,464.17L491.66,462.39L492.49,461.42L492.27,460.62L489.29,460.82L488.07,458.57L486.72,457.95L485.37,456.77L485.42,455.55L485.42,455.55L488.19,453.65L488.8,452.66L489.96,452.02L490.76,450.76L491.27,450.64L494.03,453.28L494.58,452.56L493.31,444.72L496.07,437.64L496.07,437.64L495.95,433.24L494.91,429.61L494.95,428.52L495.5,427.91L495.12,426.08L495.12,426.08L495.82,425.79L496.98,426.16L500.01,428.47L501.33,429.85L501.87,431.23L503.05,432.54L507.11,434.78L507.97,434.64L511.04,431.96L511.61,431.92L513.07,432.91L513.84,432.86L515.08,432.02L516.48,429.69L517.32,430.01L520,429.5L520.82,428.95L521.1,427.8L520.16,427.6L519.49,427L519.18,425.83L517.97,424.59L517.38,424.21L515.85,424.71L515.01,424.54L515.14,422.81L511.04,419.4L510.33,418.34L509.84,418.27L508.29,420.1L507.68,420.34L505.62,419.96L505.62,419.96L504.92,415.23L506.46,412.15L507.27,407.35L506.81,405.16L504.69,405.64L503.99,404.23L507.61,402.38L508.52,401L511.38,398.48z"
				},
				{
					"id":"MX-QUE",
					"title":"Querétaro",
					"d":"M483.66,377.61L482.38,380.74L478.27,382.03L477.06,381.32L475.41,382.75L475.68,383.86L474.85,385.42L474.38,387.63L473.57,388.83L472.41,389.25L471.26,391.81L471.89,393.83L469.57,395.44L466.64,396.16L465.73,396.84L464.15,397.33L463.14,403.87L463.14,403.87L462.04,404.66L461.74,405.29L461.95,406.01L461.29,406.13L460.41,405.53L460.17,405.84L460.71,406.8L461,408.53L459.08,410.54L456.53,410.85L456.53,410.85L453.24,407.81L453.42,407.06L452.2,405.14L450.65,404.15L450.65,404.15L449.93,402.48L447.91,401.07L446.82,399.21L446.83,396.5L446.18,394.76L445.22,394.05L445.08,393.29L445.73,389.49L446.45,388.08L451.03,387.8L452.53,387.09L455.25,387.47L455.91,387.07L456.13,385.97L456.95,386.45L457.62,384.85L457.52,383.4L459.77,380.06L461.29,379.5L463.02,381.25L464.12,381.08L464.68,380.05L466.13,379.38L466.84,377.94L466.88,376.77L464.4,376.16L465.55,374.25L465.66,372.19L465.16,371.7L465.16,371.7L464.57,371.13L466.11,370.75L465.83,370.3L466.01,369.82L467.11,369.86L468.62,370.86L469.21,372.75L469.84,373.41L472.33,373.66L474.27,373.16L474.85,373.52L475.91,370.75L476.47,370.38L477.27,370.62L477.75,370.34L478.74,372.54L481.96,375.89L482.78,377.35z"
				},
				{
					"id":"MX-ROO",
					"title":"Quintana Roo",
					"d":"M791.9,396.29l-1.08,2.58l-1.14,1.48l-0.35,0.05l-2.56,3.35l-1.57,0.97l-0.67,-1.71l0.12,-1.91l2.29,-3.75l0.7,-0.36l0.72,0.76l0.34,-0.33l0.46,0.28l1.55,-0.4L791.9,396.29zM731.37,466.16l-0.25,-2.46l2.44,-2.83l0.57,-1.26l-0.28,-4.7l-0.47,-1.38l0.57,-1.67l-0.82,-0.46l0.51,-1.37l-0.15,-0.71l-0.99,-1.24l-0.17,-1.27l0.8,-5.13l-0.22,-2.52l0.41,-0.67l1.17,-0.66l0.18,-5.85l-3.41,-4.67l-5.3,-4.25l-1.34,-1.81l0,0l0.93,-2l0.33,-1.46l-0.17,-0.87l0.56,-0.49l3.54,-0.17l1.39,-1.39l2.43,-1.05l2.43,-0.04l1.18,-0.41l1.92,-1.78l1.08,0.92l0.3,-0.32l-0.27,-0.69l1.87,-1.6l1.78,-1.04l5.51,-1.98l0.46,-0.47l0.79,-2.37l0.51,-0.42l1,0.01l0.93,1.68l0.36,-0.05l-0.25,-2.19l1.5,-2.76l1.17,-0.56l1.14,1l1.54,-0.44l1.51,0.1l3.11,-1.83l3.13,-2.7l1.72,-0.82l0.86,-1.17l0.27,-1.58l0.86,-1.08l0.48,-2.46l1.15,-2.05l0.1,-0.97l-1.33,-3.21l0.47,-3.16l0.88,-0.86l0.13,-0.76l-0.33,-5.31l0,0l1.33,0.09l-0.04,0.41l0.57,0.28l0.67,-0.32l2.09,0.59l0.33,0.39l0.65,-0.25l1.63,0.19l0.44,0.4l0.29,-0.53l2.71,-0.87l0.23,-1.96l-0.63,-0.27l0.64,-0.78l0.46,-0.16l0.44,0.5l1.44,0.39l0.56,0.83l0.34,-0.16l0.54,0.45l0.05,0.79l1.58,2.18l0.97,4.05l0.43,-0.1l0.22,-1.61l0.74,-0.67l-0.07,-0.9l-0.65,-1.07l0.65,0.22l0.11,1.72l-0.64,1.63l0.4,1.16l-0.16,1.37l0.19,0.8l1.2,0.85l-0.69,2.49l-0.75,0.05l-0.31,0.71l-1.27,4.05l-1.18,1.14l-1.11,1.59l0.04,0.49l-1.15,0.68l-0.33,0.81l-1.92,2.16l-3.88,3.04l-1.73,2.42l-1.02,2.47l-1.46,1.73l-1.41,3.98l-0.01,1.89l0.64,1.93l0.42,0.14l0.16,1.15l-0.58,1.37l-0.85,0.83l0.41,-0.93l0.44,0.01l0.56,-1.33l-0.06,-0.59l-0.62,-0.38l0.07,1.29l-1.05,1.79l-0.77,0.28l-0.34,-0.38l-0.92,0.55l-1.62,2.72l-2.43,0.42l-0.19,1.9l1,0.69l0.15,0.59l0.7,-0.34l-0.1,0.78l0.36,0.14l-0.25,0.71l0.58,-0.08l0.89,-1.26l1.58,-0.34l0.6,0.65l0.82,-0.78l-0.27,-0.41l1.72,-0.22l0.54,0.8l-0.74,2.5l-1.98,1.91l-0.47,-0.03l0.08,-0.79l-2.46,1.48l-0.62,1.69v1.25l-0.67,0.79l0.36,0.08l-0.06,0.74l1.4,-0.05l2.03,-2.79l0.8,-0.38l0.45,0.17l-0.34,1.4l0.35,-1.12l0.97,-0.08l-2.21,2.63l-0.28,3.21l-2.04,4.14l-1.12,4.75l-0.9,0.96l-0.82,4.76l-0.45,0.9l-0.04,2.04l-1.44,2.34l-0.56,3.33l-0.73,-0.54l-0.64,0.06l0.02,-0.68l0.56,-0.38l-0.12,-0.96l-0.41,0.1l0.4,-1.48l-0.52,-0.3l-0.15,-0.62l-0.81,-0.24l0.19,-1.03l-2.62,-0.79l-1.04,-1.23l0.74,-0.46l0.34,-2.04l0.93,-1.7l-0.47,-0.53l0.38,-1.24l-0.41,-1.43l-0.73,-0.62l0.24,-0.91l-0.79,-0.29l-2.26,3.58l-1.09,0.38l0.01,0.25l0.98,-0.43l-3.24,5.92l-2.26,0.13l-0.21,-0.27l-1.06,0.42l-1.2,-0.28l-0.92,0.82l-0.88,3.01l-1.06,1.13l-0.45,2.03l-1.09,1.38l-1.15,2.88l-1.42,0.78l-0.58,1.42l-1.62,1.31l0.11,1.6l-0.93,-1.04l-0.91,-0.39l-0.63,-0.95l-1.05,0.04l-0.96,-1.16l-1.8,0.39L731.37,466.16zM782.11,369.68l-0.21,0.54l-2,1.2l-1.46,-0.03l-0.56,0.38l-0.91,-0.52l-0.48,-0.76l1.72,0.56l1.4,-0.1L782.11,369.68z"
				},
				{
					"id":"MX-SLP",
					"title":"San Luis Potosí",
					"d":"M438.32,289.89L440.04,292.21L441.09,292.02L442.48,292.52L442,294.09L442.69,294.35L442.64,294.68L441.44,296.25L441.73,297.06L443.52,298.77L443.39,300.2L445.87,303.33L446.75,305.58L446.54,309.95L447.51,311.41L447.62,312.3L446.47,317.9L446.98,319.17L447.23,323.26L447.79,324.91L449.03,326.38L450.53,327.1L452.87,324.3L456.77,325.04L456.77,325.04L457.67,326.1L457.81,328.16L458.84,328.94L459.32,330.09L458.99,333.72L459.21,336.7L459.41,337.39L460.5,338.31L464.7,339.68L467.97,339.94L470.17,340.67L470.82,340.24L470.77,339.21L471.74,338.65L472.36,338.98L473.17,340.27L474.86,340.83L476.24,341.91L477.07,343.08L477.99,345.61L480.15,348.46L481.93,348.23L483.93,348.62L486.25,348.55L486.96,347.75L488.85,348.94L490.99,348.49L491.95,348.66L491.95,348.66L492.24,349.59L492.77,349.85L495.13,349.81L499.56,351.18L500.22,351.91L501.42,355.47L498.89,355.52L497.82,356.24L498.14,358.79L497.88,359.46L497.47,359.74L495.3,359.48L495.03,359.89L495.41,360.27L496.54,360.27L495.96,360.8L496.31,361.06L496.18,362.29L496.77,363.01L497.22,362.9L497.25,363.38L498.44,364.49L496.74,365.28L496.45,366.1L495.39,366.04L495.44,366.74L494.18,366.74L493.98,367.6L494.87,370.91L496.2,371.13L496.34,374.47L496.34,374.47L494.66,374.45L493.08,376.29L491.75,379.25L490.83,377.94L489.48,380.32L488.4,380.36L487.06,379.26L485.92,376.86L483.66,377.61L483.66,377.61L482.78,377.35L481.96,375.89L478.74,372.54L477.75,370.34L477.27,370.62L476.47,370.38L475.91,370.75L474.85,373.52L474.27,373.16L472.33,373.66L469.84,373.41L469.21,372.75L468.62,370.86L467.11,369.86L466.01,369.82L465.83,370.3L466.11,370.75L464.57,371.13L465.16,371.7L465.16,371.7L462.52,373.03L460.91,372.99L460.23,372.15L459.84,372.69L458.03,372.86L456.33,370.73L455.85,370.82L455.58,370.13L452.43,368.13L448.54,366.85L447.46,367.58L446.84,369.41L446.99,370.53L445.47,371.14L442.72,371.17L439.98,369.74L435.01,366.02L433.94,366.06L432.71,365.31L428.08,364.25L426.82,363.52L423.91,363.21L422.75,362.54L422.75,362.54L424.68,358.57L425.03,357.61L424.77,357.43L424.9,356.88L425.29,356.91L425.65,355.27L424.27,351.41L427.57,344.11L427.76,342.46L425.79,339.88L425.08,339.93L423.62,340.63L419.17,345.24L416.74,345.97L414.66,345.92L413.18,343.9L412.26,341.9L411.19,341.32L408.88,340.98L407.77,339.66L403.59,337.13L402.65,336.13L402.4,334.62L402.6,333.36L403.86,329.37L402.83,326.35L403.34,324.66L402.72,323.85L403.59,322.18L404.25,321.98L406.57,322.91L409.51,322.33L410.03,320.89L410.88,319.86L413.16,319.02L416.72,316.89L420.2,311.75L424.94,310.16L426.04,308.62L427.22,305.66L426.21,304.48L427.04,301.03L427.68,300.41L429.55,299.93L430.91,299.05L431.83,297.27L432.04,295.78L432.71,295.26L434.29,295.33L435.27,294.83L435.96,293.11L437.15,292.11L437.51,290.33z"
				},
				{
					"id":"MX-SIN",
					"title":"Sinaloa",
					"d":"M317.09,341.27l0.42,0.06l0.54,0.94l-0.45,0.73L317.09,341.27zM255.97,275.87l1.17,1.35l0.5,-0.19l0.27,0.31l0.01,0.9l0.59,1.13l-0.27,2.7l-0.48,-0.01l-0.69,-2.11l-1.08,-1.17L255.97,275.87zM251.15,273.82l1.41,0.93l3.59,4.56l0.73,1.14l0.05,1.38l-0.39,0.16l-2.7,-5.14l-2.82,-2.59L251.15,273.82zM250.6,271.52l1.78,1.24l0.21,0.57l-1.66,-0.8L250.6,271.52zM229.02,240.72l1.03,0.12l0,0l0.46,0.38l-0.13,1.01l-0.38,0.28l1.78,1.47l-0.35,-1.14l0.77,-0.64l-0.17,-0.47l-0.31,0.28l-0.46,-0.25l-0.92,-1.8l-0.02,-0.74l0,0l-0.15,-1.56l0.29,-0.19l0.24,1.87l0.39,0.17l0.5,-0.94l0.79,0.91l0.13,0.78l0.48,-0.08l-0.05,0.81l0.34,0.35l2.93,-1.7l1.28,-1.17l2,-0.58l0.11,-2.49l0.47,-0.87l4.09,-0.98l2.06,-3.86l1.86,-0.55l-0.29,-2.49l3.12,-3.88l0.31,-1.78l0,0l4.88,-0.22l0.68,0.38l0.12,2.9l0.62,0.24l1.22,-0.26l1.05,2.33l-0.4,2.26l0.5,0.82l-0.5,2.01l0.33,1.09l1.41,0.91l0.07,1.88l3.11,5.02l1.22,4.68l3.81,1.13l3.19,0.31l2.36,0.7l2.89,4.88l0.59,3.23l2.14,2.79l0,0l0.06,0.67l0.73,-0.16l0.16,0.73l-1.2,0.77l-1.73,2.21l0.6,0.72l0.47,-0.08l0.07,0.68l-1.33,3.21l-0.08,5.12l-0.51,1.97l1,0.61l0.48,1.82l0.75,0.65l1.2,2.37l-0.33,1.45l1.2,0.95l0.53,-0.44l2.3,0.23l0.9,2.61l1.32,0.3l1.21,4.47l0.57,0.2l0.57,-0.42l0.21,0.25l0.81,4.12l0.98,1.41l0.59,1.95l0.83,-0.17l0.7,0.49l0.69,-0.55l1.33,-0.19l2.79,-2.13l0.67,-1.04l4.04,1.18l1.45,0.96l0.9,1.37l1.08,0.26l0.15,1.07l1.74,2.27l0.08,2.2l1.03,0.94l-0.25,0.9l0.79,2.59l0.71,1.07l0.63,2.94l1.08,1.21l0.91,1.98l1.72,1.65l0.44,2.81l1.05,2.92l-0.27,0.93l0.74,1.74l1.22,1.33l0.13,2.26l0.6,1.28l2.04,0.14l0.85,-0.6l0.6,0.07l2.12,2.18l0,0l-0.83,0.61l-0.56,3.41l-1.69,2.1l-0.33,1.02l0.45,1.3l1.31,1.3l0.21,1.33l0.4,0.36l0.23,2.04l-0.36,0.89l-3.46,-0.57l-2.1,-1.24l0,0l0.23,-1.02l-1.5,-1.63l0.25,-0.59l0.74,-0.35l-0.69,-0.57l-0.54,0.7l0.52,1.9l0.54,0.51l-0.56,1.68l0.52,1.68l-0.37,0.56l-3.72,-5.81l-2.97,-2.87l-1.78,-1.1l-4.22,-5.17l-4.67,-4.58l0.44,-0.33l1.15,1.27l0.08,-0.33l-1.45,-1.15l-0.54,0.21l-0.19,0.56l-0.36,-0.33l0.1,-0.69l-0.7,-0.5l-0.92,-1.65l0.31,-0.41l-1.25,-1.96l-2.55,-2.5l0.08,-0.35l-1.39,-1.18l-0.64,-1.1l-2.56,-1.94l0.41,-0.5l-2.2,-3.4l-0.23,-1.22l-7.52,-6.96l0.92,0.2l0.31,-0.36l-0.45,-0.3l0.11,-0.8l-0.56,-0.11l-0.18,0.49l-0.54,0.21l-3.82,-3.04l-1.4,-0.34l-5.04,-3.96l-4.64,-2.85l0.23,-0.56l0.62,0.69l3.14,1.7l0.45,0.74l1,0.13l0.51,0.81l0.62,-0.07l0.75,1.11l0.5,-0.13l-0.54,-0.59l0.07,-0.7l0.71,-0.22l0.04,-0.4l-0.29,-1.18l-1.48,-2.02l-1.28,0.03l0.11,1.39l-1.12,0.24l-1.09,-1.43l-0.6,0.53l-1.04,-0.19l-0.18,-0.93l-1.63,-1.49l-2.1,-0.87l-0.25,-0.46l-0.58,0.4l-1.08,-0.5l-0.79,-1.06l0.07,-1.15l-1.39,-1.6l0.62,-0.28l1.21,1.17l0.69,-1.18l-0.6,-0.45l-0.17,-0.77l-0.29,0.03l0.08,-0.85l0.47,-0.52l-0.71,-0.29l-0.04,-0.5l0.52,-0.64l0.08,-0.78l-1.03,-0.68l-0.28,-1.88l-0.51,-0.7l-1.55,-1.02l-0.02,0.52l-0.88,-0.16l-1.89,-1.7l-0.31,-0.82h-1.64l0.11,-1.13l-1.25,-0.58l-0.56,0.84l0.28,0.65l-0.35,0.58L247.9,270l-5.4,-2.7l0.52,-0.63l-0.38,-0.49l-1.32,0.35l-1.52,-2.32l0.68,-1.33l-0.44,-0.63l-1.19,0.43l-0.4,-0.96l-1.27,-0.09l-0.41,0.23l0.24,0.6l-0.24,0.71l0.48,0.27l-0.68,1.09l-0.5,0.23l-0.06,-0.59l-0.38,-0.15l0.21,-0.44l-0.81,-0.31l-1.19,0.2l0.28,0.81l-0.81,0.23l-1.83,-2.13l1.17,-0.17l0.42,-0.44l0.05,-0.8l0.93,0.87l0.89,-0.43l0.23,-0.99l0.68,0.15l0.46,-0.49l-0.34,-1.31l-1.1,-0.04l-1.02,0.64l-0.87,1.83l-1.57,-0.48l-0.16,0.52l-0.63,-0.11l-0.37,-1.12l-1.72,-1.57l-0.47,0.45l1.6,1.16l0.08,0.75l-1.6,-1.01l-2.87,-0.52l-0.18,-0.33l2.04,0.27l0.07,-1.96l-0.5,-0.04l-1.61,-1.32l-1.08,0.28l-0.37,-0.69l0.17,-2.66l0.24,-0.09l-0.35,-1.08l-0.45,-0.16l-0.04,-0.67l0.7,-2.13l0.35,0.04l0.02,-0.83l2.14,-3.42l0.7,-2.41l1.04,-1.11l0.25,0.11l-0.21,0.99l-0.86,0.28l-0.59,2.71l0.42,0.55l0.31,-0.17l0.38,-0.98l-0.34,-0.58l0.17,-0.27l0.34,0.51l0.81,-1.72L229.02,240.72z"
				},
				{
					"id":"MX-SON",
					"title":"Sonora",
					"d":"M230.04,240.84l-1.03,-0.12l0,0l0.1,-0.52h0.48L230.04,240.84zM228.36,240.13l0.1,-1.54l0.22,0.97L228.36,240.13zM194.32,211.62l0.63,0.87l-0.19,0.34l1.34,0.61l-0.29,0.39l-1.5,-0.91L194.32,211.62zM152.25,158.81l0.48,1.56l-0.27,1.14l0.96,1.2l1.04,2.6l-0.42,0.37l-0.1,1.38l-1.54,3.96l-0.05,1.02l-0.74,0.63l-0.48,-0.47l-0.77,0.11l-1.21,-1.14l-1.34,-0.07l-0.31,-0.56l-0.52,-0.01l-0.13,-0.37l-2.03,-1.13l1.66,-1.22l0.59,-0.87l-0.39,-3.25l0.71,-2.99l0.59,-0.87l1.34,0.23l0.99,-0.9L152.25,158.81zM93.33,85.85l0.83,0.13l-0.05,0.64l-1.46,-0.41l-0.02,-0.35H93.33zM89.6,84.04l1,0.48l0.71,1.44l1.33,0.95L93.17,88l-0.28,0.68l-0.8,-0.65l-0.7,0.08l-1.04,-0.54l-0.88,-0.91l-0.39,-0.99l0.16,-1.44L89.6,84.04zM240.13,98.26l1.05,1.04l-0.94,1.28l0.52,1.91l1.64,2.84l0.24,1.6l-0.5,1.28l0.02,1.81l-1.57,0.07l-0.04,0.62l2.73,2.65l0.08,2.42l1.04,0.92l-0.67,1.61l0.11,0.81l1.1,1.47l-0.06,1.19l1.93,6.15l-0.28,1.81l-0.85,0.53l0.16,0.99l1.45,1.32v1.11l-1.27,2.57l-0.59,4.93l0.34,1l0.57,0.03l0.75,0.96l0.67,6.22l-0.01,2.6l-0.8,0.95l-0.16,0.9l0.25,5.67l-0.29,0.51l-1.38,0.68l-0.1,2.69l-1.49,1.27l0.46,2.54l-0.85,1.28l0.8,2.65l-1.48,2.62l-0.19,1.04l0.83,1.95l-0.42,2.9l1.55,1.81l2.25,0.86l-0.59,1.19l-0.93,0.1l-0.97,1.22l-1.15,0.12l-1.4,1.05l-0.51,0.03l-1.77,-1.31l-0.77,-0.14l-1.45,0.85l-2.53,0.49l-1.04,1.39l0.19,0.6l1.56,1.08l-0.59,2.75l0.39,0.7l1.83,0.74l2.09,2.98l0.38,1.66l-0.7,2.45l0.52,0.65l2.82,1.7l0.63,2.09l0.97,1.42l1.63,4.07l0.04,1.72l-1.25,3.14l0.47,3.45l-0.73,0.42l-0.02,0.46l3.54,1.84l2.02,-0.62l1.77,0.39l0,0l-0.31,1.78l-3.12,3.88l0.29,2.49l-1.86,0.55l-2.06,3.86l-4.09,0.98l-0.47,0.87l-0.11,2.49l-2,0.58l-1.28,1.17l-2.93,1.7l-0.34,-0.35l0.05,-0.81l-0.48,0.08l-0.13,-0.78l-0.79,-0.91l-0.5,0.94l-0.39,-0.17l-0.24,-1.87l-0.29,0.19l0.15,1.56l0,0l-0.42,0.01l-0.24,0.54l-1.26,-1.71l0.12,-1.01l-1.35,-2.45l-2.29,-2.56l-1.45,-1.02l-0.85,-0.13l1.05,0.16l0.05,-0.36l-0.4,-0.93l-0.57,0.04l-0.36,-0.75l-0.64,0.2l-0.07,-0.57l-0.39,-0.09l-0.73,1.06l0.42,0.75l-2.67,-0.07l-0.5,0.65l-2.54,-1l-1.19,-1.04l-0.93,-1.27l0.01,-0.96l-1.03,-2.8l-1.35,-1.86l0.19,-0.15l0.97,1.35l0.18,-0.86l-0.63,-0.42l0.25,-0.38l-0.31,-1.63l-1.73,-1.38l-0.3,0.36l-0.42,-0.41l-1.08,0.96l-1.03,-0.68l-4.98,-1.24l-3.05,-3.03l-1.39,-0.7l0.31,-0.23l-0.41,-0.92l0.08,-1.29l-0.63,-0.39l-0.52,0.37l-0.7,-0.53l-0.15,-1.27l-0.39,-0.05l-0.4,-0.75l0.25,-2.06l-0.62,-1.18l0.23,-0.39l-0.81,-0.79l0.11,-0.77l1.37,-0.98l-0.75,-0.12l-0.24,0.79l0.17,-1.54l0.69,-0.35l-0.69,-0.12l-0.29,-1.11l0.48,-0.37l-0.15,-0.75l0.41,-0.77l0.86,0.18l0.29,-0.52l-0.99,-0.79l-0.82,-0.19l-0.54,0.48l-0.63,-0.53l-3.87,-0.91l-0.33,-0.84l-1.64,0.87l0.56,0.91l-0.19,1.05l-1.22,-0.44l-0.97,-1.01l0.4,-0.56l-0.58,-0.15l-0.02,-0.71l-1.34,-0.27l-1.32,0.75l-1.49,-1.36l-0.98,-0.33l-0.88,-1.28l-0.97,-0.3l-0.69,-0.84l-0.19,-0.87l-1.06,-1.24l-0.08,-0.87l-0.69,-0.9l-0.39,0.08l-0.46,-1.58h-0.4l-1.16,-1.13l-0.1,-1.37l-0.87,-0.75l-5.45,-2.01l-0.16,-1.14l-1.16,-2.62l-4.01,-3.66l-0.48,-1.25l0.57,-0.07l0.51,-0.58l0.53,1.17l0.64,-0.41l-0.02,-0.85l-0.63,-0.49l-0.53,0.38l-0.48,-0.74l-0.27,0.21l-1.28,-1.02l-1.21,-0.29l-0.44,-1.13l-0.97,-0.77l-0.27,-0.74l-1.91,-0.55l0.56,-0.73l-0.42,-0.83l-0.05,-1.32l-0.34,-0.19l0.46,-0.98l-0.47,-1.12l-0.4,-0.14l-0.05,-0.62l-0.69,-0.07l0.53,-1.81l-0.62,-1.81l-0.64,-0.59l-1.32,0.01l-0.82,0.4l-1.66,-0.87l-0.21,-1.1l1,-2.8l-0.3,-0.57l-0.99,-0.54l-0.16,-1.18l-1,-0.83l-1.67,-2.84l-0.93,-0.65l-0.65,-1.94l-1.14,-1.61l-0.33,-1.6l-1.19,-0.57l-0.64,0.18l-0.24,-0.33l0.35,-2.46l-0.62,-1.47l0.13,-3.46l-0.51,-1.41l-1.95,-1.89l-0.11,-3.05l-0.97,-2l-2.41,-2.05l-2.54,-4.66l-0.91,-3.44l0.73,-2.28l0.06,-3.03l0.3,0.08l0.67,-1.01l0.08,-1.12l-0.5,-2.75l-0.31,0.11l-0.19,-0.79l-0.47,0.03l-2.31,-1.36l-0.67,-1.1l-0.82,0.73l-3.88,-0.94l-0.24,-0.35l-0.31,0.24l-2.58,-0.49l-0.1,-0.48l-0.56,-0.27l-1.29,-0.16l0.23,-1.47l-0.57,-1.59l0.06,-0.83l-0.54,-0.92l-1.19,-0.97l-4.33,-1.85l-0.13,-0.59l-0.38,0.14l-0.22,-0.52l-0.38,0.58l-0.79,-0.55l-0.58,0.69l-0.18,0.62l0.35,-0.07l0.21,0.52l-0.71,0.95l-0.71,-0.08l-0.41,1.19l-2.85,-0.1l-3.13,-1.43l-1.44,-1.55l-2.91,-1.6l-0.44,-0.59l-0.75,-0.16l-2.41,-2.33l-2.15,-0.14l-1.28,-0.58l-0.98,-1.17h-0.82l0,0l-3.82,-2.76l-0.92,-0.13l-0.96,-0.95l0.6,-0.98l-0.24,-0.98l0.42,-2.67l-0.29,-1.14l0.62,-1.83l-1.4,-1.99l1.81,-2.43l0.05,-1.34l0.47,-0.48l0.6,-2.05l1.34,-0.01l0.47,0.4l0.85,-0.51l0,0l93.65,34.22L240.13,98.26z"
				},
				{
					"id":"MX-TAB",
					"title":"Tabasco",
					"d":"M620.12,454.48l-4.06,1.46l-0.39,0.56l-1.89,0.16L620.12,454.48zM648.22,447.61l1.14,3.72l0.63,0.91l1.44,1l0.99,0.05l0.69,1.06l0.53,-0.13l0.08,-0.42l0.36,0.16l1.11,1.42l-0.18,1.97l0.45,0.32l1.08,2.59l1.22,1.83l3.47,2.33l0.87,1.43l1.31,0.66l1.5,-0.15l2.21,1.12l1.29,-0.64l1.68,-0.11l0.3,-0.72l-0.34,-1.82l0.3,-1.3l2.79,-0.13l3.65,0.8l1.64,1.55l1.56,0.66l0.77,0.9l0.68,-0.42l3.98,1.58l-0.02,1.64l0,0l-0.21,14.5l-10.56,0.18l0,0l0.53,-1.03l0.76,-0.28l-1.1,-1.79l-1.31,-0.37l-0.19,-0.83l-4.34,-1.2l0.75,-2.66l-1.27,-3.3l-2.56,-1.26l-0.05,-2.01l-1.06,-1.36l-1.21,0.28l-1.19,-0.18l-0.59,0.44l-0.56,-0.3l0.12,-0.59l-1.45,-0.37l-0.71,1.84l-1.95,0.03l-1.77,-0.48l0.04,0.44l-0.43,-0.08l-0.12,0.37l0.41,1.75l-0.39,0.78l-3.29,1.19l-0.57,0.83l-5.83,4.27l-2.42,2.25l-1.91,0.84l-0.81,-0.31l-0.66,-0.87l-0.04,-0.66l-1.21,-1.94l-0.54,-0.2l-0.44,0.35l-1.25,0.06l-0.36,-0.33l0.3,-1.87l-2.07,-2.18l-0.38,-0.93l0.14,-0.58l1.42,-2.12l0.35,-1.69l-2.79,0.09l-0.77,-0.35l-1.39,-1.69l-2.14,-0.85l-0.54,0.61l-1.66,0.28l-0.75,7.08l-0.59,1.16l-1.2,0.79l-1.39,1.87l-0.06,1.61l-2.53,3.17l0,0l-1.93,-0.76l-0.38,-2.2l0.38,-1l-0.17,-1.25l-1.11,-3.08l-0.44,-0.48l-2.51,-0.97l-0.42,-0.58l-1.16,-0.04l-1.44,-2.03l-1.39,-0.39l-1.06,-0.96l0.02,-3.02l-0.56,-1.47l-0.12,-2.83l-0.51,-0.4l0.86,-0.87l0.92,0.51l0.24,-0.29l-2.27,-0.39l1.89,-0.89l0,0l4.46,-1.51l0.14,1.24l2.66,-0.47l0.58,-0.41l-0.29,-0.97l0.71,-0.41l1.04,-0.14l0.23,0.44l0.75,0.06l1.31,-0.24l0.6,-0.63l-0.12,-1.19l3.28,-0.8l0.25,0.68l0.85,-0.87l5.38,-0.23l0.88,0.41l-0.67,0.56l0.07,0.89l0.8,0.04l0.8,-0.44l0.07,0.28h0.67l0.38,-0.56l-1.83,-0.75l1.08,-0.46l2.89,0.28l2.22,-0.3l3.01,-1.63l2.29,-2.75L648.22,447.61z"
				},
				{
					"id":"MX-TAM",
					"title":"Tamaulipas",
					"d":"M516.86,297.07l-0.24,4.46l-0.28,0.09L516.86,297.07zM523.63,270.67l0.46,0.16l-2.84,6.97l-0.33,-1.37l0.25,-0.9l0.58,-0.5l0.14,-1.01L523.63,270.67zM514.93,351.99l-2,1.4l-1.52,-1.64l-0.42,-1.14l-1.2,-1.05l-1.35,-0.17l-1.57,-1.2l-1.15,-0.39l-0.72,-1.3l-2.54,0.29l-0.4,0.7l0.21,0.69l-1.98,0.44l-0.15,-0.6l-0.41,0.18l-0.73,-0.58l-1.11,-0.22l-4.16,0.25l-1.78,1.01l0,0l-0.96,-0.17l-2.14,0.44l-1.89,-1.18l-0.71,0.79l-2.32,0.08l-2,-0.39l-1.79,0.22l-2.15,-2.85l-0.92,-2.52l-0.83,-1.17l-1.38,-1.08l-1.69,-0.56l-0.81,-1.29l-0.62,-0.33l-0.97,0.56l0.05,1.03l-0.65,0.43l-2.2,-0.73l-3.26,-0.26l-4.21,-1.37l-1.09,-0.93l-0.19,-0.69l-0.23,-2.98l0.34,-3.63l-0.48,-1.15l-1.03,-0.78l-0.15,-2.05l-0.89,-1.06l0,0l0.42,-0.77l-0.54,-1.35l0.8,-0.68l3.1,0.38l0.21,-1.77l-0.39,-2.84l0.33,-0.96l1.47,-1.77l0.67,-2.81l2.31,-1.23l2.55,0.68l0.71,-0.14l1.75,-0.97l0.34,-1.51l0.36,-0.1l2.25,0.45l-0.76,-2.34l-1.37,-0.78l-1.4,-3.63l-1.76,-2.09l0.86,-6.77l-1.26,-2.63l-1.84,0.09l-0.22,-0.28l0.69,-2.1l2,-1.35l2.87,-1.27l1.31,-2.13l1.75,0.11l1.12,-1.6l1.15,-0.48l0.36,-1.03l0.38,-0.13l0.39,1.52l1.11,-0.45l0.47,-1.6l0.92,-0.69l0.91,-0.09l0.38,-1.67l-0.67,-0.36l-0.6,-2.24l0.25,-0.4l1.26,-0.41l1.46,-1.97l0.51,0.04l0.6,1.17l2.8,0.23l0.75,-2.03l0.99,-1.14l4.38,-0.85l0.99,-1.13l0.77,-0.08l1.37,-1.44l1.25,-0.63l0.59,-1.37l1.54,-1.57l-0.02,-0.52l-0.4,-0.27l-2,-0.63l-0.99,-0.83l0.41,-0.8l-0.69,-1.57l0.21,-2.07l0.47,-0.77l-0.59,-1.52l0.3,-3.34l-0.8,-1.02l-0.13,-1.47l-0.69,-0.44l-3.39,0.68l-1.06,-0.15l-2.66,1.52l-0.96,-0.54l-1.19,-2.34l-0.65,-0.59l-3.28,-0.46l-0.38,-0.66l-0.82,-0.46l0.9,-0.33l-0.76,-1.34l0.36,-0.72l-0.18,-0.6l-0.63,-0.05l-0.75,0.74l-0.69,-0.09l-1.17,-1.62l0.06,-0.99l-1.42,0.12l-1.81,-2.48l-1.25,-4.14l-1.88,-0.23l-0.85,-1.9l-0.67,-0.4l-0.88,0.38l-0.8,-0.82l0.23,-3.22l0.47,-1.29l-0.52,-0.78l-1.26,-0.66l-1.46,0.05l-0.13,-1.12l0.81,-2.39l1.64,-1.39l-0.42,-3.19l-1.15,-1.14l-0.24,-1.38l0.22,-2.46l-1.27,-0.87l1.17,-1.42l-0.05,-0.88l-4,-0.19l-0.6,-0.45l0.35,-1.07l-0.27,-0.79l0.62,-0.69l2.78,-0.8l1.28,-1.72l0.65,-0.34l0,0l0.18,0.29h1.26l0.11,0.71l0.7,0.18l0.18,-0.39h0.75l0.7,1.05l0.34,-0.27l0.36,0.2l0.71,1.22l-0.38,1.72h0.75l0.44,0.53l-0.34,2.9l-0.99,1.99l1.04,0.14l-0.13,0.93l0.27,0.28l0.74,-0.19l0.36,0.55l0.39,1.93l-0.35,2.01l0.31,0.46l-0.52,0.66l0.16,1.22l0.76,0.16l0.83,1.21l-0.29,0.39l0.46,0.73l1.06,0.31l0.42,1.5l0.77,0.27l1.02,2.08l-0.06,0.78l0.88,1.05l0.47,2.36l0.42,0.22l0.1,2.37l1.22,0.55l0.71,1.17l-0.47,1.26l0.97,1.02l0.81,-0.42l0.8,0.55l0.87,-0.21l0.48,0.13l0.05,0.6l0.75,-0.11l0.74,0.58l0.36,-0.28l1.93,-0.01l0.33,0.89l1.29,0.26l1.52,2.03l2.38,-0.11v0.58l0.31,-0.11l0.18,0.44l0.5,-0.48l0.94,0.46l-0.05,0.42l1.6,-0.35l0.01,0.66l1.35,1.21l1.32,-0.12l0.04,0.76l0.75,0.8l1.49,0.86l0.79,0.07l0.36,0.44l0.54,-0.52l0.7,0.6l1.73,-0.51l0.37,0.72l0.67,0.03l0.1,-0.51l1.26,-0.17l0.35,0.36l2.62,-0.27l0.7,0.42l0.74,-0.35l0.39,0.23l-0.15,0.48l0.83,0.24l2.89,-0.01l1.11,1.91l0.45,-0.13l0.5,0.98l0.39,-0.27l0.73,1.35l1.9,0.57l-0.19,0.31l0.64,0.43l1.51,-0.27l-0.11,-1.67l0.7,-0.59l0.48,0.32l0.18,-0.35l0.93,-0.04l0.07,-0.51l1.62,-0.27l1.37,-0.05l0.35,0.28l-0.33,4.95l-0.98,3.8l-5.65,11.07l-0.79,-0.25l1.81,-3.11l-0.71,-0.57l0.46,-0.61l-0.41,-0.59l-1.12,0.05l0.16,-0.55l-1.54,-0.16l-0.62,-0.79l-1,1.08l0.73,-0.13l0.69,1.12l0.22,-0.19l0.33,1.1l-0.31,0.25l-0.24,-0.53l-0.63,0.2l-0.38,0.77l0.35,0.19l0.31,1.24l-0.77,0.28l-0.3,-1.37l-0.83,0.61l-0.36,-0.59l-0.01,-1.12l-1.79,-0.24l0.06,0.44l-0.87,0.81l0.51,0.81l-0.31,0.94l-0.52,0.08l-0.89,-0.6l-0.21,0.56l0.56,0.09l0.65,0.89l0.31,-0.21l0.58,0.32l-0.19,0.78l0.89,0.66l-0.77,1.06l0.06,1.31l-1.34,2.92l0.4,0.45l0.74,-0.03l0.4,0.74l0.86,0.2l-1.51,1.13l-0.23,0.99l-0.42,0.07l-0.05,0.69l0.6,0.36l0.13,0.78l-0.54,2.97l0.41,0.11l0.33,0.83l-0.87,4.23l-0.51,0.04l-0.28,-0.54l0.13,-1.43l-0.97,0.28l-0.87,-0.65l0.23,0.93l-0.69,0.44l0.41,0.56l-0.3,1.03l0.92,2.21l0.38,0.18l-0.22,0.7l0.6,-0.15l0.12,-1.64l0.76,-0.7l0.24,3.22l-0.68,6.41l-0.35,0.47l-0.23,-0.08l0.26,-0.56l-0.59,-0.08l-0.05,0.5l0.89,0.43l0.04,7.06l0.88,0.46l0.04,0.41l-0.44,0.32l-0.35,2.07l0.18,0.66l0.35,0.09l0.1,-1.98l-0.25,0.04l-0.08,-0.71l0.53,-0.31l-0.94,9.63l0.3,11.01l-0.21,3.59l-0.47,0.65l-0.38,1.92l-1.25,1.51l-0.98,2.08l-0.17,1.21l0.98,0.73l0.05,2.82l-0.39,-0.03l-0.01,0.99l0.56,1.95l0.45,-0.13l1.17,2.73L514.93,351.99z"
				},
				{
					"id":"MX-TLA",
					"title":"Tlaxcala",
					"d":"M505.62,419.96L507.68,420.34L508.29,420.1L509.84,418.27L510.33,418.34L511.04,419.4L515.14,422.81L515.01,424.54L515.85,424.71L517.38,424.21L517.97,424.59L519.18,425.83L519.49,427L520.16,427.6L521.1,427.8L520.82,428.95L520,429.5L517.32,430.01L516.48,429.69L515.08,432.02L513.84,432.86L513.07,432.91L511.61,431.92L511.04,431.96L507.97,434.64L507.11,434.78L503.05,432.54L501.87,431.23L501.33,429.85L500.01,428.47L496.98,426.16L495.82,425.79L495.12,426.08L495.12,426.08L494.59,425.48L493.83,425.73L492.87,423.9L492.87,423.9L497.88,422.19L498.88,422.42L500.97,422.14L502.42,420.93L503.24,419.46z"
				},
				{
					"id":"MX-VER",
					"title":"Veracruz",
					"d":"M524.7,372.6l-0.73,2.05l-0.82,0.98l-0.12,-1.51L524.7,372.6zM517.27,362.08l1.69,3.57l-0.48,-0.14l-0.97,-1.58L517.27,362.08zM519.36,363.12l1.9,2.41l5.33,4.9l-0.65,3.08l-1.71,4.14l-0.52,0.45l-0.18,-2.06l1.77,-3.43l-0.13,-1.33l-1.75,-1.65l-1.29,-2l-2.83,-3.13l-1.48,-3.68l-0.47,0.12l0.08,-0.8L519.36,363.12zM491.95,348.66l1.78,-1.01l4.16,-0.25l1.11,0.22l0.73,0.58l0.41,-0.18l0.15,0.6l1.98,-0.44l-0.21,-0.69l0.4,-0.7l2.54,-0.29l0.72,1.3l1.15,0.39l1.57,1.2l1.35,0.17l1.2,1.05l0.42,1.14l1.52,1.64l2,-1.4l0,0l0.63,5.37l1.66,4.54l-0.12,1.02l-0.4,0.22l0.62,1.35l0.43,3.26l0.83,0.93l0.08,1.11l1.85,3.26l1.51,-0.34l0.52,0.75l-0.38,1.3l0.5,1.74l0.99,0.8l0.07,1.12l0.51,0.17l0.74,2.9l4.69,9.94l0.64,2.94l0.79,1.36l4.18,4.12l0.71,1.22l5.91,6.38l3.46,4.36l0.64,1.38l2.61,2.89l1.15,3.28l0.11,2l0.64,1.06l-0.1,1.11l1.52,2.13l-0.18,1.8l0.67,2.64l1.72,1.32l1.22,0.46l0.17,0.7l0.99,0.45l0.96,1.36l-0.31,0.65l0.21,0.9l0.76,0.66l2.41,0.34l0.3,2.52l0.67,1.77l0.86,0.93l3.52,1.69l0.01,0.72l-2.04,-1.35l-0.97,-0.08l-0.06,0.3l0.47,0.15v0.65l0.75,0.32l0.31,0.61l-0.12,0.24l-0.67,-0.33l-0.34,0.29l0.17,0.5l1.17,-0.13l-0.07,-0.66l0.91,-0.27l0.63,0.3l0.22,-1.19l1.8,1.17l2.71,0.74l9.53,0.24l3,2.35l0.58,1.17l2.21,0.61l3.33,0.3l0.51,0.43l0.57,1.84l0.76,0.77l0.13,0.67l2.8,2.79l0.56,2.39l2.67,1.28l3.79,-0.39l7.27,-1.8l0,0l-1.89,0.89l2.27,0.39l-0.24,0.29l-0.92,-0.51l-0.86,0.87l0.51,0.4l0.12,2.83l0.56,1.47l-0.02,3.02l1.06,0.96l1.39,0.39l1.44,2.03l1.16,0.04l0.42,0.58l2.51,0.97l0.44,0.48l1.11,3.08l0.17,1.25l-0.38,1l0.38,2.2l1.93,0.76l0,0l-3.72,2.89l-1.95,0.86l-0.94,1.13l0,0l-28.57,-1.75l0.33,-1.37l-0.64,-0.57l0.01,-0.99l-3.45,-2.78l-3.36,-4.41l0.23,-1.13l1.49,-0.66l0.18,-0.68l-1.37,-0.84l-0.42,-0.06l-1.21,1.08l-3.66,0.92l-3.01,2.11l-2.87,0.16l-1.26,0.66l-1.96,-0.58l-2.18,-4.43l0.17,-1.17l-0.34,-0.72l0.73,-0.68l0.99,-2.58l0.81,-1.11l0.22,-1.25l-1,-3.79l-0.52,-0.44l-2.03,-0.48l-1.15,0.19l-1.43,-0.52l-2.47,0.79l-0.7,-0.35l0.53,-0.9l-1.38,-0.09l-1.02,-1.89l-1.39,-0.81l-1.31,0.38l-1.96,-1.56l-0.64,-0.9l-0.6,-2.74l0.58,-1.27l-1,-0.35l-1.15,-1.15l-0.65,0.61l-0.05,0.86l0.5,0.74l-0.3,0.96l-1.17,2.18l0,0l-1.85,-2.17l-2.58,-0.82l-1.39,0.8l-0.96,1.05l-1.43,-0.1l-1.86,-3.13l0.17,-0.75l-3.81,-1.12l-0.85,-0.72l-0.36,-1.12v-2.98l1.86,-2.41l0.07,-0.55l-0.52,-6.12l0.18,-0.9l4.82,0.22l0.53,-0.12l0.16,-0.7l-0.11,-1.29l-0.47,-0.59l-2.93,-1.27l-3.63,-0.82l-1.44,-0.99l-0.34,-0.42l0.56,-1.38l-1.38,-2.98l0.24,-0.7l0.57,-0.24l0.98,-2.63l0.67,-0.87l0.34,-0.97l-0.31,-0.98l0.19,-0.81l1.66,-4.28l2.15,-2.98l-0.07,-0.51l-7.06,-2.49l-0.82,0.67l-1.22,1.95l-1.61,1.4l-0.59,-0.19l-0.86,-1.78l-2.04,0.22l-0.68,-0.55l-0.46,-2.37l-0.06,-4.01l1.17,-0.76l1.61,0.92l1.5,-2.48l-0.48,-1.12l-2.22,-1.22l-0.81,-0.83l-0.16,-0.85l0.36,-0.83l-0.81,-0.6l-0.87,0.19l-0.16,-0.3l1.23,-0.76l0.01,-1.79l-2.03,0.32l-1.19,-0.39l-0.27,1.02l-0.88,0.94l-0.08,0.84l-0.97,0.75l-0.7,2.56l0,0l-1.45,-0.95l-0.83,0.36l-2.14,2.33l-1.6,0.73l-1.89,2.23l-2.48,1.15l-1.33,1.55l-0.5,0.22l-0.88,-1.08l-1.17,-2.59l0.25,-2.08l0.58,-1.3l0.33,-3.66l0.65,-0.54l0.31,-0.86l2.39,-2.16h0.46l1.34,1.39l1.45,-0.23l0.25,-0.63l-0.56,-1.05l0.63,-2.21l1.86,-2.46l-2.53,-3.42l-2.03,-0.62l-0.86,0.89l-1.32,-0.06l-1.26,-0.66l-1.83,-1.71l0.3,-2.66l-0.3,-0.75l-0.85,-0.17l0,0l-0.13,-3.35l-1.33,-0.22l-0.89,-3.31l0.21,-0.85h1.26l-0.05,-0.7l1.05,0.05l0.29,-0.82l1.71,-0.79l-1.19,-1.11l-0.04,-0.48l-0.45,0.12l-0.59,-0.73l0.13,-1.23l-0.35,-0.26l0.58,-0.53h-1.14l-0.38,-0.38l0.27,-0.42l2.18,0.26l0.41,-0.27l0.25,-0.67l-0.31,-2.55l1.06,-0.71l2.53,-0.05l-1.2,-3.56l-0.65,-0.73l-4.44,-1.38l-2.36,0.04l-0.53,-0.26L491.95,348.66z"
				},
				{
					"id":"MX-YUC",
					"title":"Yucatán",
					"d":"M771.6,372.46L771.93,377.76L771.79,378.52L770.91,379.39L770.44,382.55L771.77,385.75L771.67,386.72L770.53,388.77L770.04,391.22L769.18,392.3L768.92,393.88L768.06,395.05L766.34,395.87L763.21,398.57L760.1,400.41L758.59,400.3L757.06,400.74L755.92,399.74L754.75,400.3L753.25,403.06L753.5,405.25L753.14,405.3L752.21,403.62L751.2,403.61L750.7,404.03L749.91,406.4L749.45,406.88L743.94,408.86L742.16,409.9L740.28,411.5L740.55,412.19L740.25,412.51L739.17,411.59L737.25,413.37L736.06,413.78L733.63,413.81L731.2,414.86L729.81,416.25L726.27,416.42L725.71,416.91L725.88,417.78L725.56,419.23L724.63,421.24L724.63,421.24L724.19,420.78L723.4,417.34L720.24,413.76L719.06,411.27L715.21,409.17L713.22,404.71L711.4,403.55L710.83,402.51L710.94,401.6L709.91,399.84L709.49,399.56L708.7,400.29L708.3,401.3L707.82,401.39L706.88,400.41L705.76,400.75L705.32,400.57L704.35,398.56L700.22,398.04L700.38,390.75L700.38,390.75L700.45,389.37L701.06,388.78L701.78,387.07L701.63,386.55L701.3,386.76L700.19,390.19L699.63,390.73L699.93,389.18L700.95,386.22L702,384.84L707.6,381.3L710.1,380.73L712.18,379.45L713.1,379.44L713.36,378.99L714.34,378.68L717.24,378.01L717.3,378.41L717.87,378.4L717.75,378.11L718.4,377.75L722.4,377.02L739,374.82L744.03,372.91L744.59,371.51L750.09,370.34L753.32,370.6L754.65,370.23L756.91,368.76L759,369.23L758.83,369.68L760.56,370.31L764.15,370.56L764.65,371.37L765.66,371.94L767.83,372.03L769.73,372.57L770.15,372.16L766.37,371.23z"
				},
				{
					"id":"MX-ZAC",
					"title":"Zacatecas",
					"d":"M390.91,276.52L390.93,274.89L391.56,274.36L396.96,273.29L406.36,273.9L408.9,275.61L411.4,276.58L413.36,278.24L415.52,281.31L416.99,280.9L418.15,281.22L418.77,284.78L421.6,284.8L422.52,283.92L424.79,283.41L427.75,283.78L429,284.6L430.92,288.36L432.29,289.66L434.38,290.47L435.82,290.1L436,289.32L436.75,289L438.87,289.47L438.87,289.47L438.32,289.89L438.32,289.89L437.51,290.33L437.15,292.11L435.96,293.11L435.27,294.83L434.29,295.33L432.71,295.26L432.04,295.78L431.83,297.27L430.91,299.05L429.55,299.93L427.68,300.41L427.04,301.03L426.21,304.48L427.22,305.66L426.04,308.62L424.94,310.16L420.2,311.75L416.72,316.89L413.16,319.02L410.88,319.86L410.03,320.89L409.51,322.33L406.57,322.91L404.25,321.98L403.59,322.18L402.72,323.85L403.34,324.66L402.83,326.35L403.86,329.37L402.6,333.36L402.4,334.62L402.65,336.13L403.59,337.13L407.77,339.66L408.88,340.98L411.19,341.32L412.26,341.9L413.18,343.9L414.66,345.92L416.74,345.97L419.17,345.24L423.62,340.63L425.08,339.93L425.79,339.88L427.76,342.46L427.57,344.11L424.27,351.41L425.65,355.27L425.29,356.91L424.9,356.88L424.77,357.43L425.03,357.61L424.68,358.57L422.75,362.54L422.75,362.54L421.94,363.48L420.97,362.85L420.97,362.85L420.69,362.46L418.6,361.71L415.93,359.36L413.8,358.22L410.26,357.31L410.26,357.31L409.12,355.27L408.53,352.83L404.09,350.2L402.76,348.86L401.99,347.47L401.26,347.64L400.87,348.9L399.66,349.82L396.19,351.79L394.4,352.17L393.33,352.9L392.4,356.14L389.07,360.73L387.83,363.6L387.9,364.81L390.24,367.07L390.24,367.07L390.15,369.28L390.8,371.13L393.58,372.91L393.1,375.6L392.14,376.91L389.85,378.31L386.27,381.22L384.75,380.72L383.38,381.21L382.75,381.75L382.42,383.77L380.95,384.29L380.84,384.66L379.13,384.23L377.79,384.49L377.57,385.05L376.69,384.98L375.7,385.46L372.8,383.85L370.54,384.04L369.6,383.55L368.85,381.85L368.1,381.04L365.6,380.42L365.43,379.92L369.47,378.11L370.64,376.99L370.74,375.97L370.4,375.39L369.73,375.25L368.71,375.74L367.78,375.2L366.93,372.72L368.72,372.26L370.34,370.38L370.67,367.91L370.49,366.12L373.41,364.05L375.18,362.32L378.46,360.64L379.72,360.44L380.46,359.75L381.65,356.84L382.35,353.37L381.84,352.99L379.69,352.85L379.19,352.41L379.95,350.9L379.54,350.04L377.37,349.87L375.49,350.6L375.18,352.47L376.42,353.5L374.03,355.39L373.1,357.12L372.2,357.56L371.49,357.04L370.22,356.84L369.53,357.64L367.6,357.62L367.02,356.96L367.11,356.51L370.89,350.34L370.93,349.18L370.33,347.25L368.93,345.93L367.51,345.42L364.08,346.09L363.45,346.66L363.45,353.7L363.07,354.86L361.91,354.69L360.7,352.91L360.74,349.59L362.43,345.37L363.88,343.5L364.98,342.68L365.15,341.77L363.34,340.76L360.68,341.14L358.52,342.67L358.41,343.46L360.15,347.3L360.31,348.73L359.28,349.91L357.48,351.05L357.21,350.56L358.26,347.32L357.73,346.95L354.63,348.12L354.27,351.15L352.92,350.81L351.84,352.02L351.84,352.02L351.12,351.59L350.69,350.63L350.49,347.86L350.49,347.86L351.65,344.81L352.66,343.3L355.87,341.88L356.12,341.25L356.28,335.7L355.43,332.61L355.51,331.33L356.88,328.6L357.49,328.23L358.78,322.46L358.87,320.58L361.19,317.69L363.99,315.27L363.1,311L363.55,309.8L363.18,307.91L363.49,306.23L363.12,304.58L362.34,304.07L362.57,302.75L364.97,302.03L367.23,299.89L369.3,297.06L371.7,295.24L372.17,293.9L373.88,292.53L377.78,292.8L380.01,293.5L382.26,292.7L383.38,292.8L384.38,293.5L387.04,294.37L387.8,293.46L389.48,293.69L395.55,293.11L395.67,292.43L395.17,292.06L395.19,291.65L396.16,291.13L395.14,287.13L393.93,286.68L394.74,281.78L393.94,280.84L392.41,280.13L392.05,279.03L391.3,278.69L391.26,277.04z"
				}
			]
		}
	}
};
