﻿// (c) ammap.com | SVG (in JSON format) map of France - Low
// areas: {id:"FR-A"},{id:"FR-B"},{id:"FR-C"},{id:"FR-D"},{id:"FR-E"},{id:"FR-F"},{id:"FR-G"},{id:"FR-H"},{id:"FR-I"},{id:"FR-J"},{id:"FR-K"},{id:"FR-L"},{id:"FR-M"},{id:"FR-N"},{id:"FR-O"},{id:"FR-P"},{id:"FR-Q"},{id:"FR-R"},{id:"FR-S"},{id:"FR-T"},{id:"FR-U"},{id:"FR-V"}
AmCharts.maps.franceLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-4.778054",
				"topLatitude":"51.089515",
				"rightLongitude":"9.560176",
				"bottomLatitude":"41.363289"
			}
		},
		"g":{
			"path":[
				{
					"id":"FR-A",
					"title":"Alsace",
					"d":"M498.91,208.16L502.37,206.45L501.41,203.92L503.38,197.19L508.91,190.38L508.19,188.16L513.99,177.9L513.19,176.07L508.87,175.28L510.58,167.67L509.44,165.85L511.28,166.21L508.42,164.55L514.79,162.8L518.37,156.06L515.79,154.05L518.79,149.33L516.51,145.88L512.08,144.43L508.96,148.25L507.83,144.51L509.66,143.35L503.83,141.4L503.38,138.89L507.05,137.45L509.79,129.8L510.96,134.31L517.94,136.33L519.26,138.25L524.5,136.67L528.02,138.94L532.17,131.3L532.17,131.3L538.69,130.52L541.69,132.56L544.49,131.02L556.89,136.82L550.96,147.12L546.08,149.96L540.57,157.24L536.15,172.66L536.66,176.85L534.52,178.43L529.69,189.69L529.39,195.05L531.58,198.9L528.85,204.64L528.49,213.6L526.98,215.84L529.95,223.31L526.45,225.53L527.76,226.24L526.01,229.02L523.64,228.23L524.64,229.71L521.77,232.09L515.83,232.75L512.79,231.37L514.11,228.3L511.23,227.75L511.23,227.75L509.3,222.24L505.95,221.67L507.24,214.26L500.16,210.59z"
				},
				{
					"id":"FR-B",
					"title":"Aquitaine",
					"d":"M241.28,335.78l6.02,2.53l-0.97,2.94l2.51,2.53l2.36,-2.83l1.18,1.28l5.02,-0.57l2.79,4.71l3.37,0.31l-1.89,2.95l7.17,2.5l-1.54,1.83l2.82,1.37l-3.64,3.35l-0.39,2.91l2.1,1.07l-2.08,2.93l2.54,0.92l-1.41,1.34l2.2,1.92l4.3,0.48l-1.41,1.16l2.91,5.01l0,0l-1.57,0.9l1.3,7.39l-5.88,4.86l0.73,3.25l-6.95,4.09l-1.81,5.61l-5.09,1.7l3.3,10.28l-4.98,1.19l-1.88,-2.08l-1.12,4.1l3.38,2.06l-1.83,4.82l-2.21,0.38l1.69,2.66l-4.35,-0.33l0.37,1.87l-5.62,4.99l-2.94,-3.22l-12.15,5.18l-2.89,-1.8l-3.09,2.83l-1.23,-1.66l-2.96,2.32l0.14,3.75l-3.32,-1.89l1.15,-1.43l-1.79,-1.74l-2.47,3.21l-3.47,-0.62l-2.49,2.39l2.21,1.68l-0.29,3.34l-1.37,0.1l1.32,4.06l-2.29,1.72l-1.24,5.08l1.7,2.04l5.9,0.03l3.24,6.27l-1.97,0.51l-0.06,2.97l2.76,-1.96l1.26,5.64l-3.15,2.55l1.2,1.76l-2.32,2.71l0.22,2.61l-2.06,-0.17l-3.14,3.73l0.54,3.53l-4.49,2.63l-1.06,8.81l0,0l-3.38,2.85l-4.63,-1.6l-1.9,2.79l-7.48,-6.7l-0.92,-4.04l-7.86,0.83l-7.1,-4l-1.16,0.91l-6.92,-3.42l1.59,-2.83l-3.04,1.35l-0.4,3.74l-3.57,-1l-1.37,-2.38l3.79,-5.71l-0.27,-3.9l-6.08,-2.04l-3.04,2.38l-0.66,-3.13l-4.36,0.6l-2.39,-3.1l-0.07,-1.33l5.03,-0.85l2.79,-2.55l6.38,-12.24l6.21,-32.32l1.66,-19.24l2.62,-6.67l7.87,1.33l-2.71,-3.5l1.48,-0.02l-5.54,-4.62l-3.3,9.35l-0.63,-1.04l4.34,-49.39l2.59,-4.77l1.39,-1.02l-0.24,3.66l10.89,9.76l4.74,15.92l3.95,3.85l-3.05,-7.07l-1.94,-11.61l0,0l4.97,0.42l0.34,-1.52l0.93,2.95l5.81,1.06l1.76,7.92l0.85,-1.55l7.15,4.43l4.28,-1.6l1.82,1.35l2.17,-6.1l1.98,-1.44l3.28,1.23l5.45,-5.36l-0.78,-4.26l2.28,-5.31l1.17,1.02l4.2,-2.58l3.02,-3.87l0.27,-4.8l2.26,-0.03L241.28,335.78zM211.75,471.63L211.75,471.63l-1.45,2.45l1.69,1.12L211.75,471.63L211.75,471.63zM210.08,478.97l1.73,-1.24l-1.41,-2.66L210.08,478.97z"
				},
				{
					"id":"FR-C",
					"title":"Auvergne",
					"d":"M309.79,293.44L313.12,287.63L320.42,287.48L323.66,285.42L321.81,279.05L324.21,279.07L324.06,277.16L327.86,273.84L329.74,275.55L333.28,275.02L336.37,270.96L340.96,270.84L340.96,270.84L347.95,277.99L350.83,275.54L354.06,277.53L357.12,275.72L358.62,279.49L362.94,277.23L364.1,272.84L365.61,273.26L370.25,282.48L370.48,286.3L374.51,286.74L375.76,289.34L379.12,289.05L381.18,290.92L381.38,298.98L377,302.07L377,302.07L371.55,304.27L374.17,318.6L368.79,320.36L368.46,322.71L371.02,325.33L368.3,330.96L380.59,348.43L379.7,351.96L376.62,354.37L377.25,357.96L379.06,355.49L381.97,358.32L382.07,357.06L384.17,357.85L387.23,355.02L390.89,354.71L396.46,357.82L394.97,358.91L396.6,359.87L395.7,361.45L395.7,361.45L399.29,361.45L399.29,361.45L401.56,364.5L400.18,370.61L396.71,369.15L397.75,371.43L395.59,373.1L396.96,375.44L393.5,376.45L394.22,379.16L390.53,379.74L387.69,385.01L382.63,385.05L382.37,387.31L379.09,387.7L378.02,391.1L375.44,392.52L375.44,392.52L370.53,387.04L367.34,387.59L365.82,384.52L364.31,384.84L364.1,387.74L359.51,388.71L355.07,379.03L351.52,381.85L349.7,381.34L347.63,385.61L345.12,383.21L338.91,398.32L338.91,398.32L333.84,384.92L330.24,386L328.75,381.01L323.26,386.59L321.41,393.92L318.24,397.96L312.78,398.55L310.4,396.93L307.15,397.99L306.63,399.87L303.53,395.28L305.27,389.93L301.93,384.98L300.7,379.01L300.7,379.01L304.08,377.52L302.24,374.09L305.33,372.79L305.6,369.57L307.79,367.9L306.2,364.6L313.08,357.82L312.62,353.39L318.1,355.86L320.08,354.56L318.39,352.96L319.65,344.98L317.31,342.51L319.82,339.78L319.9,335.75L314.28,328.92L321.27,323.67L321.59,321.11L323.55,320.2L323.14,316.45L318.18,301.81L310.7,298.03L312.01,296.29L310.08,295.74z"
				},
				{
					"id":"FR-D",
					"title":"Bourgogne",
					"d":"M341.62,174.83L340.29,178.21L341.62,181.65L337.05,187.03L337.05,187.03L340.89,188.88L341.73,192.6L344.84,195.29L344.98,198.82L340.05,202.94L340.72,210.3L333.51,212.12L333.35,214.61L336.6,216.77L338.69,223.68L333.36,225.6L336.79,231.72L334.17,237.81L338.9,242.49L340.4,254.51L342.89,256.97L340.96,270.84L340.96,270.84L347.95,277.99L350.83,275.54L354.06,277.53L357.12,275.72L358.62,279.49L362.94,277.23L364.1,272.84L365.61,273.26L370.25,282.48L370.48,286.3L374.51,286.74L375.76,289.34L379.12,289.05L381.18,290.92L381.38,298.98L377,302.07L377,302.07L376.64,305.75L380.06,306.45L380.75,308.45L389.81,306.94L392.62,309.22L396.66,307.45L398.03,300.88L402.11,302.57L404.79,300.99L406.86,302.69L409.42,300.26L412.67,308.27L420.26,287.51L425.07,289.58L429.68,287.48L432.49,291.15L435.75,291.85L435.75,291.85L440.01,290.01L437.56,284.88L441.01,280.34L437.65,274.79L438.92,272.34L436.27,269.62L442.02,268.1L439.26,264.96L436.36,265.26L434.9,262.1L433.66,262.76L433.26,259.76L435.91,257.65L434.48,255.45L438.68,253.44L440.93,249.65L444.25,240L442.18,239.19L442.79,234.5L440.65,234.52L440.92,230.98L437.94,230.12L443.35,224.55L441.03,219.97L438.17,221.5L438.17,221.5L435.45,221.23L433.17,223.24L433.49,220.45L429.93,218.61L430.14,216.88L427.61,218.96L423.91,215.02L421.41,216.52L421.01,211.84L419.21,211.52L422.39,209L418.69,202.01L415.72,202.77L417.12,200.82L413.77,199.46L414.12,196.77L405.22,195.34L403.45,196.74L404.22,199.12L394.25,199.54L393.35,201.79L391.35,201.47L390.59,198.88L389.59,200.77L388.13,199.65L385.76,201.73L383.68,200.51L383.04,201.78L376.82,201.53L377.59,198.41L376.81,197.06L375.03,198.21L375.87,196.23L372.52,189.86L370.38,188.95L370.74,186.88L367.37,188.48L365.84,185.38L363.7,185.71L365.36,180.48L360.57,174.39L357.43,174.88L356.85,172.91z"
				},
				{
					"id":"FR-E",
					"title":"Bretagne",
					"d":"M80.29,234.83l7.73,4.48l-0.56,1.7l-6.78,-1L80.29,234.83zM81.25,143.01l0.21,2.23l5.57,-2.26v3.04l3.06,-0.19l-1.32,2.7l4.77,1.54l-0.69,2.18l5.32,4.52l-0.2,3.35l4.49,2.47l-1.11,1.95l1.17,-0.49l1.61,2.8l-0.36,-2.8l2.29,0.66l3.02,-4.87l3.36,-1.43l-0.62,-1.41l2.13,-0.48l0.72,1.47l4.21,-3.72l1.45,1.27l-2.22,3.03l3.88,-1.52l0.79,5.9l1.17,-3.8l0.7,2.17l1.19,-2.62l1.08,1.09l-1.14,-2.05l4.34,-0.34l3.11,5.95l-0.52,3.04l1.94,-1.56l-2,-3.99l1.63,0.87l-0.56,-1.33l-3,-2.72l1.73,-3.06l6.15,-1.81l-1.04,4.65l3.75,2.13l8.54,-1.9l0,0l3.46,9.09l2.79,1.76l2.8,-0.5l4.16,-4.69l7.63,2.23l0,0l1.03,11.19l-2.32,3.9l3.52,16.32l-5.75,2.37l-3.8,11.62l-9.63,-3.62l0.24,1.99l-6.19,2.43l-1.57,3.32l-8.31,0.06l-3.94,2.29l-0.76,-1.38l-4.51,2.7l-0.68,7.18l-2.46,0.69l-0.26,1.95l-5.6,-1.62l-0.78,3.38l-4.4,-0.97l-1.43,1.77l0,0l-1.56,-0.12l-0.26,-2.58l2.52,-0.38l-2.85,-1.59l-12.7,2.33l-8.69,-6.49l0.2,1.53l-4.29,-0.13l-0.19,3.42l2,2.76l-2.14,-0.27l-0.76,-7.5l-5.67,-5.52l-3.09,-0.04l-0.22,-1.53l-3.64,0.92l-3.06,-4.18l-8.32,-2.54l-5.28,0.88l-3.79,-6.89l-1.78,1.18l0.6,1.78l-7.13,-0.14l-1.86,3.72l-7.31,0.01l0.39,-5.65l-2.61,-4.61l-3.72,-2.65l-9.38,-2.09l0.93,-1.58l12.37,-2.63l4.63,1.1l1.57,-2.52l-2.01,-4.6l-6.14,-2.18l-3.95,4.27l0.64,-4.89l-3.25,-0.33l-0.28,-1.57l2.43,-0.16l-0.07,-3.02l1.63,-0.64l-0.13,3.55l1.49,-1.7l-0.13,1.9l2.11,-0.98l2.22,1.36l3.78,-1.44l1.93,1.1l1.62,-2.09l-4.79,-0.08l1.43,-0.97l-0.64,-1.99l-2.28,2.25l-3.54,-0.01l2.41,-3.53l-0.98,-0.78l-7.63,3.58l-3.06,-1.06l-3.82,1.62l-0.17,-11.61l1.95,-2.54l4.96,-1.27l2.84,-3.79l5.85,-0.03l-1.47,-1.08l3.76,-1.42l2.08,0.79l0.01,1.94l4.18,-1.14l-1.13,-0.43l1.5,-1.77l5.28,0.66l2.14,-3.21l1.54,0.01l-0.07,3.34l1.67,0.71l0.25,-2.26l0.08,1.55l3.21,0.85l0.94,-3.69l7.45,1.47l-0.61,2.33l1.47,-1.72l1.71,1l1.39,-4.7l-1.59,-3.84l1.34,0.91l2.09,-3l4.41,2.46L81.25,143.01z"
				},
				{
					"id":"FR-F",
					"title":"Centre",
					"d":"M277.46,138.46L281.49,144.82L281.64,155.78L289.31,162.76L289.91,168.19L292.74,169.83L295.25,168.79L295.15,171.97L297.21,172.25L297.65,174.62L297,179.28L304.93,178.63L306.57,175.79L308.32,178.63L311.75,176.48L314.93,177.56L315.74,181.04L319.62,183.14L319.64,186.78L316.57,189.46L327.44,189.49L329.46,188.13L328.72,186.8L331.32,186.68L332.17,189.09L337.05,187.03L337.05,187.03L340.89,188.88L341.73,192.6L344.84,195.29L344.98,198.82L340.05,202.94L340.72,210.3L333.51,212.12L333.35,214.61L336.6,216.77L338.69,223.68L333.36,225.6L336.79,231.72L334.17,237.81L338.9,242.49L340.4,254.51L342.89,256.97L340.96,270.84L340.96,270.84L336.37,270.96L333.28,275.02L329.74,275.55L327.86,273.84L324.06,277.16L324.21,279.07L321.81,279.05L323.66,285.42L320.42,287.48L313.12,287.63L309.79,293.44L309.79,293.44L301.82,294.03L297.27,292.04L291.47,293.08L289.14,291.23L286.9,295.21L285.1,293.52L282.73,295.34L281.94,293.34L279.26,295.07L278.47,293.02L273.88,297.86L271.33,294.64L269.24,296.34L264.03,295.53L264.03,295.53L264.03,295.53L264.03,295.53L264.03,295.53L264.03,295.53L265.43,292.6L262.89,291.71L262.62,288.19L252.92,282.54L253.02,274.96L244.38,264.3L243.85,260.02L238.71,258.06L239.98,261.03L228.58,262.64L227.73,255.31L222.56,254.83L222.7,251.41L218.48,251.17L217.39,248.44L217.39,248.44L218.34,241.28L222.7,235.17L221.48,234.09L224.33,227.92L223.19,225.53L224.79,221.49L231.08,223.63L231.06,219.13L233.8,220.63L239.89,217.39L240.84,216.09L239.46,214.57L244.27,211.55L247.05,207.54L246.71,203.32L248.81,204.08L250.37,200.89L250.09,195.35L248.22,194.89L248.07,192.82L250.12,192.67L248.89,191.01L250.45,188.91L253.14,188.57L248.24,185.13L248.24,185.13L249.59,183.93L247.09,177.16L253.07,174.02L255.64,169.8L253.98,167.54L255.25,164.6L249.13,159.07L248.99,155.44L248.99,155.44L251.52,152.59L257.05,151.97L259.28,149.9L261.44,150.64L261.7,147.95L270.45,149.72L272.11,148.47L271.68,145.12L275.76,142.76L275.25,139.51z"
				},
				{
					"id":"FR-G",
					"title":"Champagne-Ardenne",
					"d":"M415.86,60.99L418.38,62.12L415.21,66.75L416.09,68.49L413.95,72.95L418.05,76.76L416.34,79.51L416.53,84.24L422.5,83.79L426.61,86.18L429.6,90.63L433.93,90.47L436.47,93.15L435.74,95.88L439.14,95.54L439.14,95.54L433.6,100.31L427.38,97.09L425.16,102.93L427.32,105.65L425.9,109.17L426.9,110.72L424.94,111.41L424.8,117.33L420.67,119.68L422.37,121.46L420.18,122.99L422.88,130.34L421.26,133.32L424.21,133.19L422.47,135.7L424.34,136.33L419.96,140.03L420.11,144.6L418.17,147.36L423.13,150.92L422.68,158.85L425.1,157.79L425.68,160.07L427.67,160.1L431.52,164.3L436.34,165.47L442.17,170.86L439.03,172.85L441.04,173.59L440.41,176.58L444.47,175.55L447.14,180.15L448.08,179.04L449.83,180.53L449.32,182.16L452.99,184.89L450.95,186.05L450.54,190.46L448.77,191.88L454.95,195.09L455.4,200.09L457.87,198.66L459.44,201.73L459.44,201.73L457.08,206.27L454.29,205.82L453.5,208.25L451.4,208.2L451.39,216.58L447.49,217.35L446.27,215.18L444.53,217.3L439.75,217.21L438.17,221.5L438.17,221.5L435.45,221.23L433.17,223.24L433.49,220.45L429.93,218.61L430.14,216.88L427.61,218.96L423.91,215.02L421.41,216.52L421.01,211.84L419.21,211.52L422.39,209L420.79,205.38L420.79,205.38L420.79,205.38L420.79,205.38L418.69,202.01L415.72,202.77L417.12,200.82L413.77,199.46L414.12,196.77L410.26,195.66L405.22,195.34L403.45,196.74L404.22,199.12L394.25,199.54L393.35,201.79L391.35,201.47L390.59,198.88L389.59,200.77L388.13,199.65L385.76,201.73L383.68,200.51L383.04,201.78L376.82,201.53L377.59,198.41L376.81,197.06L375.03,198.21L375.87,196.23L372.52,189.86L370.38,188.95L370.74,186.88L367.37,188.48L365.84,185.38L363.7,185.71L365.36,180.48L360.57,174.39L357.43,174.88L356.85,172.91L356.85,172.91L355.54,167.3L357.8,166.63L356.5,164.29L359.59,163.43L358.92,161.63L362.86,158.75L361.81,156.89L358.36,157.59L359.07,151.15L356.01,149.88L358.04,147.88L356.38,146.73L359.86,146.4L359.78,144L359.78,144L367.78,133.8L366.66,131.97L363.94,132.36L366.14,129.82L364.59,127.14L365.48,125.19L370.72,124.66L366.8,121.24L366.44,114.85L371.95,112.13L375,112.86L375.18,110.61L378.01,108.92L382.7,111.88L384.42,98.43L382.16,95.18L385.96,94.47L386.43,91.59L391.56,86.53L389.74,85.06L391.7,79.39L390.82,73.57L390.82,73.57L394.05,72.9L399.71,74.94L409.93,71.2L410.32,64.79z"
				},
				{
					"id":"FR-H",
					"title":"Corse",
					"d":"M579.43,571.32l1.21,-2.68l4.63,-2.55l-5.58,-0.67l-0.28,-2.29l-4.82,0.04l2.98,-2l-0.77,-1.43l2.48,-0.52l-0.87,-1.86l2.17,-2.8l-2.28,-2.11l-5.83,2.2l-0.63,-3.97l2.32,-0.19l0.49,-2.44l3.62,-2.07l-1.97,-3.49l-1.69,0.66l-4.23,-2.51l1.49,-1.26l-2.22,-3.87l6.43,-1.64l-3.76,-2.17l0.44,-2.47l-2.58,0.89l-0.34,-2.31l4.6,-2.25l1.03,-3l-1.29,-0.54l2.97,-2.62l0.23,-3.34l2.62,1.75l0.55,-2.74l8.85,-2.18l4.55,-5.08l4.03,-0.21l3.19,3.3l1.91,-3.34l-1.47,-5.47l2.15,-5.13l-0.88,-3.95l3.45,-0.98l1.68,1.41l1.22,10.14l-1.95,7.42l3.6,7.14l1.08,19.75l-0.39,5.13l-5.7,8.35l-1.05,17.06l-4.47,2.72l0.37,1.18l1.27,-1.66l2.12,0.59l-3.96,3.53l0.2,3.66l-2.88,2.81l2.09,-0.02l-3.31,2.73l-3.59,-1.65l1.13,-2.4l-2.1,-0.36l0.39,-2.03l-1.66,1.35l-1.7,-1.84l-3.25,0.05l-3.22,-1.58l0.46,-1.61l-2.76,-0.49L579.43,571.32z"
				},
				{
					"id":"FR-I",
					"title":"Franche-Comté",
					"d":"M459.44,201.73L461.45,198.55L462.14,201.12L465.89,196.94L469.85,195.96L472.71,201.36L480.39,199.59L484.08,204.23L489.27,200.5L498.91,208.16L498.91,208.16L500.16,210.59L507.24,214.26L505.95,221.67L509.3,222.24L511.23,227.75L511.23,227.75L505.02,228.3L505.8,230.78L503.24,232.05L500.7,236.95L506.4,235.72L508.03,238.11L503.36,240.96L503.87,243.68L493.39,253.46L494.07,255.35L482.13,262.8L483.47,265.17L482.98,272.06L468.79,284.02L470.71,285.91L466.89,293.67L466.89,293.67L458.79,302.74L452.8,302.97L452.32,300.07L449.38,297.95L445.06,302.51L442.35,302.76L442.42,299.69L440.3,297.75L439.45,299.99L438.34,295.69L435.11,293.84L435.75,291.85L435.75,291.85L440.01,290.01L437.56,284.88L441.01,280.34L437.65,274.79L438.92,272.34L436.27,269.62L442.02,268.1L439.26,264.96L436.36,265.26L434.9,262.1L433.66,262.76L433.26,259.76L435.91,257.65L434.48,255.45L438.68,253.44L440.93,249.65L444.25,240L442.18,239.19L442.79,234.5L440.65,234.52L440.92,230.98L437.94,230.12L443.35,224.55L441.03,219.97L438.17,221.5L438.17,221.5L439.75,217.21L444.53,217.3L446.27,215.18L447.49,217.35L451.39,216.58L451.4,208.2L453.5,208.25L454.29,205.82L457.08,206.27z"
				},
				{
					"id":"FR-J",
					"title":"Île-de-France",
					"d":"M285.85,120.07L287.96,123.63L293.3,124.44L301.51,121.43L305.23,124.39L307.22,123.39L307.82,125.17L311.17,122.94L318.5,127.99L321.08,126.84L322.37,129.66L324.42,127.85L328.62,130.85L331.7,128.58L333.51,130.25L338.37,128.91L339.15,130.2L342.43,129.31L342.57,127.3L345.41,127.99L347.57,131.53L346.6,133.92L350.63,138.55L352.3,137.93L353.3,140.49L354.9,139.21L355.54,142.76L358.78,144.92L359.78,144L359.78,144L359.86,146.4L356.38,146.73L358.04,147.88L356.01,149.88L359.07,151.15L358.36,157.59L361.81,156.89L362.86,158.75L358.92,161.63L359.59,163.43L356.5,164.29L357.8,166.63L355.54,167.3L356.85,172.91L356.85,172.91L341.62,174.83L340.29,178.21L341.62,181.65L337.05,187.03L337.05,187.03L332.17,189.09L331.32,186.68L328.72,186.8L329.46,188.13L327.44,189.49L316.57,189.46L319.64,186.78L319.62,183.14L315.74,181.04L314.93,177.56L311.75,176.48L308.32,178.63L306.57,175.79L304.93,178.63L297,179.28L297.65,174.62L297.21,172.25L295.15,171.97L295.25,168.79L292.74,169.83L289.91,168.19L289.31,162.76L281.64,155.78L281.49,144.82L277.46,138.46L277.46,138.46L278.2,136.05L276.18,136.22L275.26,131.32L276.93,131.5L277.81,129.3L282.48,129.3z"
				},
				{
					"id":"FR-K",
					"title":"Languedoc-Roussillon",
					"d":"M338.91,398.32l6.21,-15.11l2.5,2.4l2.08,-4.26l1.82,0.51l3.54,-2.82l4.45,9.68l4.59,-0.96l0.2,-2.9l1.51,-0.32l1.53,3.06l3.19,-0.54l4.91,5.47l0,0l1.73,8.71l6.89,10.95l-0.87,4.99l3.4,-1.02l5.29,4.14l2.87,-4.24l2.73,-0.47l0.15,3.24l1.76,0.42l0.63,-3.19l2.16,-0.31l5.98,4.23l0,0l2.99,4.8l-0.04,6.1l2.74,0.91l2.41,4.41l-8.41,7.05l1.07,1.25l-1.64,9.12l-5.91,-0.67l-2.47,4.19l1.9,0.66l-0.43,1.32l-5.32,3.08l-0.83,-1.11l0.41,1.55l-3.4,1.65l-0.44,2.25l0,0l-3.96,-1.47l-1.16,-3.81l-5.6,0.42l-13.63,9.25l-5.7,6.6l-7.22,-1.24l-6.3,6.63l-5.65,11.76l-0.62,14.7l0.76,9.2l3.89,1.35l1.37,4.55l-3.67,0.52l-1.89,-2.67l-3.88,-0.5l-7.01,3.93l-4.3,0.4l-0.11,3.59l-3.95,-0.99l-1.93,1.43l-4.04,-3.39l-7.31,-2.5l-4.21,0.81l-5.77,4.22l-3.42,-5.87l-8.54,-2.37l0.39,-3.41l2,-1.04l0,0l7.77,-2.42l1.01,-2.49l7.43,-1.12l-3.81,-3.96l-3.35,1.01l-3.77,-1.38l-2.26,-3.69l0.67,-1.64l4.62,-1.02l-0.26,-3.34l-1.91,-0.72l3.02,-1.15l-2.69,-5.01l0.44,-3.49l-10.13,-4.41l0.57,-8.56l3.79,0.02l-0.5,-2.92l2.1,-2.85l1.76,2.65l5.91,-2.27l1.46,2.27l4.06,-1.18l1.84,1.86l1.8,-4.32l5.74,2.48l8.77,-0.83l2.51,-2.23l0.26,-2.62l-2.44,-2.89l1.25,-5.35l4.54,2.62l9.54,-5.41l3.15,0.92l0.12,-8.13l6.22,1.2l2.13,-4.63l3.28,0.03l0.6,-3.17l3.45,-2.85l-2.2,-3.39l-5.24,-2.02l2.47,-0.87l1.69,-5.34l-6.55,0.59l1.08,-2.34l-2.88,-0.83l-0.37,-1.76l-1.3,0.74l0.98,-10.17l-3.24,-3.74l0.79,-3.27L338.91,398.32zM298.2,523.69l-1,-2.23l-1.21,1.64L298.2,523.69z"
				},
				{
					"id":"FR-L",
					"title":"Limousin",
					"d":"M264.03,295.53L269.24,296.34L271.33,294.64L273.88,297.86L278.47,293.02L279.26,295.07L281.94,293.34L282.73,295.34L285.1,293.52L286.9,295.21L289.14,291.23L291.47,293.08L297.27,292.04L301.82,294.03L309.79,293.44L309.79,293.44L310.08,295.74L312.01,296.29L310.7,298.03L318.18,301.81L323.14,316.45L323.55,320.2L321.59,321.11L321.27,323.67L314.28,328.92L319.9,335.75L319.82,339.78L317.31,342.51L319.65,344.98L318.39,352.96L320.08,354.56L318.1,355.86L312.62,353.39L313.08,357.82L306.2,364.6L307.79,367.9L305.6,369.57L305.33,372.79L302.24,374.09L304.08,377.52L300.7,379.01L300.7,379.01L296,380.39L294.35,378.91L289.95,382.12L283.49,375.93L278.99,374.84L275.25,376.42L275.25,376.42L272.34,371.41L273.75,370.25L269.45,369.77L267.24,367.86L268.66,366.51L266.11,365.59L268.19,362.67L266.09,361.59L266.48,358.68L270.12,355.33L267.3,353.96L268.83,352.13L261.66,349.63L263.55,346.68L260.19,346.37L257.39,341.66L252.37,342.23L251.19,340.95L248.84,343.78L246.32,341.25L247.29,338.31L241.28,335.78L241.28,335.78L244.79,332.69L244.66,330.2L247.6,330.95L248.8,322.63L251.71,323.16L254.41,320.33L253.49,317.92L248.91,315.51L248.74,311.17L250.28,310.33L248.04,305.85L252.59,301.3L256.87,301.8L258.65,296.86L262.03,297.76z"
				},
				{
					"id":"FR-M",
					"title":"Lorraine",
					"d":"M440.08,96.55L442.33,103.11L445.81,101.06L448.09,102.51L449.37,99.78L453.67,100.5L454.8,98.95L458.77,103.06L462.82,103.4L463.46,106.11L468.37,105.95L469.49,103.43L474.13,102.1L479.35,105.54L482.01,104.49L487.32,107.99L486.62,109.2L489.16,111.53L487.76,112.71L492.03,116.97L494.9,124.3L498.92,125L499.03,121.23L503.19,120.59L507.14,122.63L507.86,127.49L509.84,124.86L512.24,127.1L517.92,127.45L520.87,123.88L524.18,123.11L523.81,124.31L526.23,124.04L527.65,128.55L532.17,131.3L532.17,131.3L528.02,138.94L524.5,136.67L519.26,138.25L517.94,136.33L510.96,134.31L509.79,129.8L507.05,137.45L503.38,138.89L503.83,141.4L509.66,143.35L507.83,144.51L508.96,148.25L512.08,144.43L516.51,145.88L518.79,149.33L515.79,154.05L518.37,156.06L514.79,162.8L508.42,164.55L511.28,166.21L509.44,165.85L510.58,167.67L508.87,175.28L513.19,176.07L513.99,177.9L508.19,188.16L508.91,190.38L503.38,197.19L501.41,203.92L502.37,206.45L498.91,208.16L498.91,208.16L489.27,200.5L484.08,204.23L480.39,199.59L472.71,201.36L469.85,195.96L465.89,196.94L462.14,201.12L461.45,198.55L459.44,201.73L459.44,201.73L457.87,198.66L455.4,200.09L454.95,195.09L448.77,191.88L450.54,190.46L450.95,186.05L452.99,184.89L449.32,182.16L449.83,180.53L448.08,179.04L447.14,180.15L444.47,175.55L440.41,176.58L441.04,173.59L439.03,172.85L442.17,170.86L436.34,165.47L431.52,164.3L427.67,160.1L425.68,160.07L425.1,157.79L422.68,158.85L423.13,150.92L418.17,147.36L420.11,144.6L419.96,140.03L424.34,136.33L422.47,135.7L424.21,133.19L421.26,133.32L422.88,130.34L420.18,122.99L422.37,121.46L420.67,119.68L424.8,117.33L424.94,111.41L426.9,110.72L425.9,109.17L427.32,105.65L425.16,102.93L427.38,97.09L433.6,100.31L439.14,95.54L439.14,95.54z"
				},
				{
					"id":"FR-N",
					"title":"Midi-Pyrénées",
					"d":"M210.53,475.05l1.27,2.68l-1.73,1.24L210.53,475.05zM211.3,475.03l0.05,-3.59L211.3,475.03L211.3,475.03L211.3,475.03zM275.25,376.42l3.74,-1.58l4.5,1.09l6.46,6.19l4.4,-3.21l1.65,1.48l4.7,-1.38l0,0l1.23,5.97l3.34,4.94l-1.74,5.36l3.1,4.58l0.53,-1.88l3.25,-1.06l2.38,1.62l5.46,-0.59l3.17,-4.03l1.85,-7.33l5.5,-5.58l1.49,4.99l3.6,-1.08l5.07,13.4l0,0l4.31,4.95l-0.79,3.27l3.24,3.74l-0.98,10.17l1.3,-0.74l0.37,1.76l2.88,0.83l-1.08,2.34l6.55,-0.59l-1.69,5.34l-2.47,0.87l5.24,2.02l2.2,3.39l-3.45,2.85l-0.6,3.17l-3.28,-0.03l-2.13,4.63l-6.22,-1.2l-0.12,8.13l-3.15,-0.92l-9.54,5.41l-4.54,-2.62l-1.25,5.35l2.44,2.89l-0.26,2.62l-2.51,2.23l-8.77,0.83l-5.74,-2.48l-1.8,4.32l-1.84,-1.86l-4.06,1.18l-1.46,-2.27l-5.91,2.27l-1.76,-2.65l-2.1,2.85l0.5,2.92l-3.79,-0.02l-0.57,8.56l10.13,4.41l-0.44,3.49l2.69,5.01l-3.02,1.15l1.91,0.72l0.26,3.34l-4.62,1.02l-0.67,1.64l2.26,3.69l3.77,1.38l3.35,-1.01l3.81,3.96l-7.43,1.12l-1.01,2.49l-7.77,2.42l0,0l-2.53,-0.9l0.41,-1.5l-7.68,-2.18l-2.93,0.23l-1.76,2.74l-3.35,-6.54l-7.76,0.6l-3.74,-4.49l-6.36,-0.05l-9.05,-4.09l-2.64,4.42l1.27,5.18l-10.52,0.02l-2.59,-1.87l-2.73,2.85l-4.91,-3.57l-9.67,2.52l-4.29,-5.95l-6.33,-2.9l0,0l1.06,-8.81l4.49,-2.63l-0.54,-3.53l3.14,-3.73l2.06,0.17l-0.22,-2.61l2.32,-2.71l-1.2,-1.76l3.15,-2.55l-1.26,-5.64l-2.76,1.96l0.06,-2.97l1.97,-0.51l-3.24,-6.27l-5.9,-0.03l-1.7,-2.04l1.24,-5.08l2.29,-1.72l-1.32,-4.06l1.37,-0.1l0.29,-3.34l-2.21,-1.68l2.49,-2.39l3.47,0.62l2.47,-3.21l1.79,1.74l-1.15,1.43l3.32,1.89l-0.14,-3.75l2.96,-2.32l1.23,1.66l3.09,-2.83l2.89,1.8l12.15,-5.18l2.94,3.22l5.62,-4.99l-0.37,-1.87l4.35,0.33l-1.69,-2.66l2.21,-0.38l1.83,-4.82l-3.38,-2.06l1.12,-4.1l1.88,2.08l4.98,-1.19l-3.3,-10.28l5.09,-1.7l1.81,-5.61l6.95,-4.09l-0.73,-3.25l5.88,-4.86l-1.3,-7.39L275.25,376.42z"
				},
				{
					"id":"FR-O",
					"title":"Nord-Pas-de-Calais",
					"d":"M321.47,2.24l2.94,7.09l-1.73,1.82l0.39,4.6l1.48,2.44l3.64,0.14l2.96,5.64l4.65,2.11l1.91,-3.91l8.24,-2.49l1.66,4.24l2.88,1.54l-0.89,2.85l2.17,8.71l3.51,2.16l4.1,-2.73l1.83,0.63l-0.76,2.36l4.48,-0.57l2.16,2.56l-0.07,5.63l2.07,4.18l1.64,-2.99l6.42,1.57l5.09,-2.08l4.7,6.55l1.03,-2.02l1.92,1.11l-3.32,8.96l2.98,0.04l1.25,4.11l-2.91,1.36l-0.76,4.41l0,0l-6.75,-0.88l0.07,-3.27l-3.93,2.24l-0.64,-1.82l-6.54,-2.08l-4.18,2.86l-2.91,-1.91l-2.2,2.36l-5.28,-1.2l-7.93,1.63l-6.56,-3.06l-6.24,2.49l-0.26,-3.67l-4.59,2.17l1.38,-4.35l-2.12,-0.94l-1.08,2.89l-5.31,-2.07l0.08,-1.73l-1.84,1.69l-2.15,-1.58l-2.59,3.29l-1.77,-1.43l0.49,-2.84l4.44,-2.64l-1.81,-2.32l-3.85,1.55l-1.09,-2.1l-0.22,1.68l-2.37,-1.02l-5.01,2.49l-2.67,-0.67l-0.37,-3.33l-5.41,-2.31l0.04,-2.8l-1.61,1.27l-4.3,-3.19l-5.8,2l-0.97,-1.44l0,0l-3.64,-3.14l1.34,-8.96l2.01,1.63l-2.44,-3.65l-0.57,-10.23l2.12,-5.09l-1.35,-4.42l12.03,-6.5l-1.22,-0.23l11.07,-2.04l2.2,-2.26l0.83,2.4l0.69,-2.4l7.64,-0.51L320.75,0L321.47,2.24z"
				},
				{
					"id":"FR-P",
					"title":"Basse-Normandie",
					"d":"M134.84,88.51l13.15,4.35l-0.2,1.48l0.52,-1.41l5.03,-0.71l0.58,-1.84l8.64,0.05l1.5,5.71l-3.34,3.79l5.93,8.96l-1.45,4.62l1.95,-1.78l1.62,1.19l1.71,-2.92l4.54,-0.48l8.72,3.08l15,1.01l7.13,3.33l9.19,-2.8l9.33,-6.55l-4.68,-0.2l7.24,-0.11l0,0l1.05,9.48l3.08,-0.13l-2.62,2.37l3.07,2.39l-0.39,3.58l1.99,0.81l-0.56,4.14l-2.17,1.43l3.34,2.34l-2.65,6.54l2.87,2.1l6.75,0.06l-0.25,2.87l6.12,4.08l0.66,1.86l-1.91,1.93l3.66,2.31l0,0l0.15,3.63l6.12,5.53l-1.27,2.94l1.66,2.25l-2.56,4.23l-5.99,3.14l2.5,6.77l-1.35,1.2l0,0l-2.48,0.37l-3.5,-4.7l-0.61,1.91l-4.29,-0.98l-1.91,-3.82l-4.04,-0.73l-0.41,-6.42l-3.38,-3.5l-6.49,1.45l-3.6,4.97l-2.45,-1.23l-2.08,1.42l0.01,-4.78l-3.99,-0.36l-1.12,-3.35l1.17,-1.09l-2.57,-2.23l-1.74,-0.04l-0.92,3.56l-2.07,-0.94l-1.33,2.39l-1.81,-1.61l-4.7,0.06l-5.88,4.05l-0.5,-2.57l-2.77,0.74l0.7,1.47l-1.92,0.87l-3.55,-3.95l-9.31,-0.55l0,0l-7.63,-2.23l-4.16,4.69l-2.8,0.5l-2.79,-1.76l-3.46,-9.09l0,0l9.05,0.14l-2.41,-1.68l1.05,-1.03l-2.54,1.28l-5.05,-5.76l-0.18,-4.7l-1.66,-0.84l3.05,-6.09l-0.69,-5.96l2.2,0.38l-2.32,-1.12l-0.74,2.4l-0.9,-2.41l-0.62,-11.37l1.94,-0.19l-1.95,-0.82l-0.51,1.57l-3.34,-7.57l-4.26,-2.8l-3.24,-10.28l1.96,-2.35l-0.33,-3.85l-4.1,-2.8L134.84,88.51z"
				},
				{
					"id":"FR-Q",
					"title":"Haute-Normandie",
					"d":"M272.33,66.81l2.96,-0.37l0.15,1.97l10.78,9.83l3.07,7.98l-1.52,-0.06l-2.5,4.39h2.59l-2.25,3.24l-0.04,3.95l2.17,2.83l-1.29,2.19l3.03,0.01l-3.17,6.14l3.73,8.46l-0.62,1.81l-1.29,-1.67l-2.02,0.49l-0.23,2.09l0,0l-3.38,9.23h-4.67l-0.88,2.21l-1.67,-0.18l0.92,4.9l2.02,-0.16l-0.74,2.41l0,0l-2.21,1.05l0.51,3.26l-4.08,2.35l0.43,3.35l-1.66,1.26l-8.76,-1.77l-0.25,2.69l-2.16,-0.74l-2.23,2.07l-5.53,0.61l-2.53,2.86l0,0l-3.66,-2.31l1.91,-1.93l-0.66,-1.86l-6.12,-4.08l0.25,-2.87l-6.75,-0.06l-2.87,-2.1l2.65,-6.54l-3.34,-2.34l2.17,-1.43l0.56,-4.14l-1.99,-0.81l0.39,-3.58l-3.07,-2.39l2.62,-2.37l-3.08,0.13l-1.05,-9.48l0,0l0.41,-1.13l-7.51,-1.25l-1.98,-2.54l3.59,-8.66l-1.21,-1.61l1.31,0.6l2.15,-3.35l15.76,-9.19l15.5,-4.45l5.58,0.63l-0.27,-1.26L272.33,66.81z"
				},
				{
					"id":"FR-R",
					"title":"Pays de la Loire",
					"d":"M121.44,256.7l1.64,1.15l-0.59,2.05l3.11,1.57l0.3,3.31l-2.43,-3.85l-3.83,-2.02l-0.28,-2.03L121.44,256.7zM170.7,165.56l9.31,0.55l3.55,3.95l1.92,-0.87l-0.7,-1.47l2.77,-0.74l0.5,2.57l5.88,-4.05l4.7,-0.06l1.81,1.61l1.33,-2.39l2.07,0.94l0.92,-3.56l1.74,0.04l2.57,2.23l-1.17,1.09l1.12,3.35l3.99,0.36l-0.01,4.78l2.08,-1.42l2.45,1.23l3.6,-4.97l6.49,-1.45l3.38,3.5l0.41,6.42l4.04,0.73l1.91,3.82l4.29,0.98l0.61,-1.91l3.5,4.7l2.48,-0.37l0,0l4.9,3.44l-2.69,0.34l-1.56,2.1l1.23,1.67l-2.05,0.15l0.15,2.07l1.86,0.46l0.28,5.54l-1.56,3.19l-2.09,-0.76l0.33,4.23l-2.77,4.01l-4.81,3.02l1.37,1.52l-0.94,1.3l-6.1,3.24l-2.74,-1.5l0.02,4.51l-6.28,-2.14l-1.6,4.04l1.14,2.39l-2.85,6.16l1.22,1.09l-4.36,6.11l-0.95,7.16l0,0l-2.58,0.24l-1.21,4.48l-2.08,-0.86l-1.79,2.83l-2.07,-0.98l1.52,-2.02l-1.72,-0.3l-8.82,1.04l-3.51,2.3l0.9,-1.71l-1.46,-0.12l-2.56,1.18l0.53,1.92l-2.29,2.16l-7.81,-0.51l-4.5,1.88l3.67,3.26l-0.96,2.19l5.52,4.53l-0.89,3.26l3.45,5.55l-0.9,1.63l1.78,0.88l-1.12,13.47l1.48,-0.97l2.76,1.74l-7.58,4.98l-4.56,-2.38l-4.16,1.91l-1.23,-0.74l1.31,-2.91l-7.73,3.27l0,0l-3.56,0.1l-0.17,2.7l-4.55,-3.84l0.84,2.57l-1.99,-3.06l-5.16,-0.01l-1.94,-3.69l-5.58,-0.97l-6.83,-4.49L138,282l-11.84,-12.79l-0.41,-4.08l1.72,-0.15l5.51,-8.32l-5.02,-5.23l-6.12,-1.09l3.36,-2.17l-0.21,-5.83l-5.31,1.92l-3.16,-2.77l-2.33,1.22l-4.7,-1.94l1.63,-2.93l-2.23,-2.2l4.2,-4.51l0,0l1.43,-1.77l4.4,0.97l0.78,-3.38l5.6,1.62l0.26,-1.95l2.46,-0.69l0.68,-7.18l4.51,-2.7l0.76,1.38l3.94,-2.29l8.31,-0.06l1.57,-3.32l6.19,-2.43l-0.24,-1.99l9.63,3.62l3.8,-11.62l5.75,-2.37l-3.52,-16.32l2.32,-3.9L170.7,165.56z"
				},
				{
					"id":"FR-S",
					"title":"Picardie",
					"d":"M282.69,47.73l0.59,0.47l0,0l0.97,1.44l5.8,-2l4.3,3.19l1.61,-1.27l-0.04,2.8l5.41,2.31l0.37,3.33l2.67,0.67l5.01,-2.49l2.37,1.02l0.22,-1.68l1.09,2.1l3.85,-1.55l1.81,2.32l-4.44,2.64l-0.49,2.84l1.77,1.43l2.59,-3.29l2.15,1.58l1.84,-1.69l-0.08,1.73l5.31,2.07l1.08,-2.89l2.12,0.94l-1.38,4.35l4.59,-2.17l0.26,3.67l6.24,-2.49l6.56,3.06l7.93,-1.63l5.28,1.2l2.2,-2.36l2.91,1.91l4.18,-2.86l6.54,2.08l0.64,1.82l3.93,-2.24l-0.07,3.27l6.75,0.88l0,0l3.7,1.32l0,0l0.88,5.82l-1.96,5.67l1.82,1.47l-5.13,5.06l-0.46,2.88l-3.8,0.71l2.26,3.25l-1.72,13.45l-4.69,-2.96l-2.83,1.69l-0.18,2.25l-3.05,-0.73l-5.5,2.72l0.36,6.39l3.92,3.41l-5.25,0.54l-0.89,1.95l1.55,2.68l-2.2,2.54l2.72,-0.39l1.13,1.82l-8,10.2l0,0l-1,0.92l-3.25,-2.16l-0.64,-3.55l-1.61,1.27l-1,-2.56l-1.67,0.62l-4.04,-4.63l0.97,-2.39l-2.16,-3.54l-2.84,-0.69l-0.14,2.01l-3.28,0.89l-0.78,-1.3l-4.85,1.35l-1.81,-1.67l-3.09,2.26l-4.19,-3l-2.05,1.81l-1.29,-2.82l-2.58,1.15l-7.33,-5.05l-3.35,2.23l-0.6,-1.78l-1.99,1l-3.72,-2.96l-8.22,3.01l-5.34,-0.8l-2.1,-3.56l0,0l0.23,-2.09l2.02,-0.49l1.29,1.67l0.62,-1.81l-3.73,-8.46l3.17,-6.14l-3.03,-0.01l1.29,-2.19l-2.17,-2.83l0.04,-3.95l2.25,-3.24h-2.59l2.5,-4.39l1.52,0.06l-3.07,-7.98l-10.78,-9.83l-0.15,-1.97l-2.96,0.37l0,0l6.01,-9.22l6.88,1.21l-6.2,-5.56l0.68,-5.65L282.69,47.73z"
				},
				{
					"id":"FR-T",
					"title":"Poitou-Charentes",
					"d":"M156.7,315.7l7.04,3.83l2.14,7.39l-1.85,3.58l-1.58,-4.83l-4.89,-4.34L156.7,315.7zM152.41,303.18l1.52,1.4l-1.94,0.28l0.8,1.51l3.66,-1.56l-0.51,1.73l2.49,-0.45l4.75,2.76l-2.4,1.19l-9.32,-3.54l-1.17,-2.49L152.41,303.18zM168.78,299.64l7.73,-3.27l-1.31,2.91l1.23,0.74l4.16,-1.91l4.56,2.38l7.58,-4.98l-2.76,-1.74l-1.48,0.97l1.12,-13.47l-1.78,-0.88l0.9,-1.63l-3.45,-5.55l0.89,-3.26l-5.52,-4.53l0.96,-2.19l-3.67,-3.26l4.5,-1.88l7.81,0.51l2.29,-2.16l-0.53,-1.92l2.56,-1.18l1.46,0.12l-0.9,1.71l3.51,-2.3l8.82,-1.04l1.72,0.3l-1.52,2.02l2.07,0.98l1.79,-2.83l2.08,0.86l1.21,-4.48l2.58,-0.24l0,0l1.09,2.73l4.22,0.24l-0.14,3.42l5.17,0.48l0.85,7.33l11.4,-1.61l-1.26,-2.97l5.14,1.97l0.53,4.27l8.64,10.67l-0.1,7.58l9.7,5.64l0.27,3.52l2.54,0.9l-1.4,2.93l0,0l-2,2.23l-3.37,-0.89l-1.78,4.94l-4.28,-0.5l-4.55,4.55l2.24,4.48l-1.54,0.84l0.17,4.34l4.59,2.41l0.91,2.41l-2.7,2.83l-2.91,-0.54l-1.2,8.32l-2.94,-0.75l0.12,2.5l-3.51,3.09l0,0l-2.69,4.53l-2.26,0.03l-0.27,4.8l-3.02,3.87l-4.2,2.58l-1.17,-1.02l-2.28,5.31l0.78,4.26l-5.45,5.36l-3.28,-1.23l-1.98,1.44l-2.17,6.1l-1.82,-1.35l-4.28,1.6l-7.15,-4.43l-0.85,1.55l-1.76,-7.92l-5.81,-1.06l-0.93,-2.95l-0.34,1.52l-4.97,-0.42l0,0l-4.33,-9.68l-6.24,-4.03l-2.22,-3.68l-8.82,-4.13l-0.06,-5.54l4.3,-1l-1.88,-2.99l2.64,-0.34l1.66,-2.9l-1.86,-5.67l2.81,0.02l-3.18,-7.41l-1.87,-0.65l0.98,-1.15l-3.65,-0.39l5.29,-5.76L168.78,299.64z"
				},
				{
					"id":"FR-U",
					"title":"Provence-Alpes-Côte d'Azur",
					"d":"M422.31,411.26l0.41,0.46l0,0l2.94,2.11l-3.49,4.85l-4.05,-0.68l-0.65,-2.61l2.88,-3.71l0,0l0,0l0,0l1.88,-0.54l0,0L422.31,411.26zM436.87,480.46l1.33,-4.56l-2.69,-3.76l-3.35,1.86l-7.41,0.22l-3.32,-5.71l-3.15,1.16l-1.36,-2.84l0.69,2.52l-2.05,-1.09l1.37,1.6l-2.3,0.9l3.01,1.7l1.6,-1.39l-3.34,3.01l-10.56,-1.85l0.35,-3.51l-2.38,-1.71l-12.58,-0.46l0,0l0.44,-2.25l3.4,-1.65l-0.41,-1.55l0.83,1.11l5.32,-3.08l0.43,-1.32l-1.9,-0.66l2.47,-4.19l5.91,0.67l1.64,-9.12l-1.07,-1.25l8.41,-7.05l-2.41,-4.41l-2.74,-0.91l0.04,-6.1l-2.99,-4.8l0,0l0.05,-3.44l5.73,0.97l1.26,4.96l10,-4.63l2.02,1.74l2.42,-2.16l-0.61,4.8l8.42,1.03l1.16,3.41l2.99,2.08l3.59,-0.77l2.5,-3.39l3.18,2.59l-1.47,-1.45l1.79,-1.42l0.01,-4.09l-3.26,-2.27l0.88,-1.58l-5.65,-0.24l-2.61,-2.15l-0.47,-2.91l3.27,-0.7l-1.67,-3.59l6.48,1.61l2.07,-1.79l-2.78,-2.41l1.91,-6.26l6.08,-0.09l1.7,-2.15l-1.31,-0.93l1.17,-3.09l5.15,-0.06l1.21,-1.23l-1.28,-1.36l2.83,-1.8l1.61,1.14l3.22,-2.82l4.71,0.72l1.83,-1.28l2.67,1.11l-1.32,-8.41l-4.96,-1.02l1.71,-6.12l3.64,-0.16l1.31,3.11l3.58,1.07l2.47,-3.36l5,0.02l0,0l1.76,5.3l2.94,0.33l0.28,6.37l4.67,3.22l2.99,-0.68l3.6,2.26l-0.94,2l3.16,6.16l-4.73,0.35l0.22,3.35l-4.66,5.23l3.86,5.72l-2.31,0.48l-0.22,3.42l4.95,7.32l7.49,1.99l7.04,4.95l13.58,-3.43l0.88,7.64l-8.66,9.75l1.44,5.18l-7.95,4.02l-0.24,2.08l-0.74,-1.74l-6.58,3.05l-1.46,3.78l0.97,1.99l-1.94,-1.08l-2.48,2.04l-3.15,-0.4l-2.97,6.44l-6.06,0.34l-1.19,4.26l-5.88,4.3l5.09,0.32l-2.09,5.63l-3.55,-1.22l-2.69,2.17l-4.65,0.37l-0.85,3.29l-7.35,-1.62l-1.32,4.99l-2.49,-0.12l1.21,-2.85l-4.28,0.06l-4.09,-2.63l-1.66,1.26l2.76,1.95l-4.96,1.03l-1.47,-1.07l0.63,-2.63l-4.7,-1.61l-0.38,-2.05l-2.68,-0.38l-0.74,1.51l-2.84,-3.09L436.87,480.46z"
				},
				{
					"id":"FR-V",
					"title":"Rhône-Alpes",
					"d":"M377,302.07l-0.36,3.68l3.42,0.7l0.69,2l9.06,-1.51l2.81,2.28l4.04,-1.77l1.37,-6.58l4.08,1.69l2.67,-1.57l2.07,1.7l2.56,-2.43l3.26,8.01l7.58,-20.76l4.81,2.07l4.61,-2.1l2.81,3.67l3.26,0.7l0,0l-0.64,1.99l3.23,1.85l1.11,4.3l0.85,-2.24l2.12,1.94l-0.06,3.07l2.71,-0.25l4.32,-4.56l2.94,2.12l0.48,2.9l5.99,-0.23l8.11,-9.06l0,0l4.37,2.95l-2.81,4.91l0.93,2.04l-5.99,2.06l-0.94,5.28l7.09,-0.67l6.93,-5.1l0.59,-1.85l-2.03,0.28l-1.67,-3.62l1.33,-2.89l11.07,-5.82l12.5,1.8l-2.05,4.3l3.9,4.46l-2.81,8.53l4.21,0.78l-0.95,4.55l2.45,-0.97l4.26,6.58l-1.71,4.91l-7.31,2.09l-0.55,6.61l4.49,4.38l3.51,0.7l0.01,7.97l7.76,5.85l-3.2,4.62l1.03,4.21l-10.05,5.16l-0.01,1.86l-5.21,-1.34l-5.67,2.91l0,0l-5,-0.02l-2.47,3.36l-3.58,-1.07l-1.31,-3.11l-3.64,0.16l-1.71,6.12l4.96,1.02l1.32,8.41l-2.67,-1.11l-1.83,1.28l-4.71,-0.72l-3.22,2.82l-1.61,-1.14l-2.83,1.8l1.28,1.36l-1.21,1.23l-5.15,0.06l-1.17,3.09l1.31,0.93l-1.7,2.15l-6.08,0.09l-1.91,6.26l2.78,2.41l-2.07,1.79l-6.48,-1.61l1.67,3.59l-3.27,0.7l0.47,2.91l2.61,2.15l5.65,0.24l-0.88,1.58l3.26,2.27l-0.01,4.09l-1.79,1.42l1.47,1.45l-3.18,-2.59l-2.5,3.39l-3.59,0.77l-2.99,-2.08l-1.16,-3.41l-8.42,-1.03l0.61,-4.8l-2.42,2.16l-2.02,-1.74l-10,4.63l-1.26,-4.96l-5.73,-0.97l-0.05,3.44l0,0l-5.98,-4.23l-2.16,0.31l-0.63,3.19l-1.76,-0.42l-0.15,-3.24l-2.73,0.47l-2.87,4.24l-5.29,-4.14l-3.4,1.02l0.87,-4.99l-6.89,-10.95l-1.73,-8.71l0,0l2.58,-1.42l1.07,-3.4l3.28,-0.39l0.27,-2.26l5.06,-0.05l2.83,-5.27l3.69,-0.58l-0.72,-2.71l3.46,-1.01l-1.37,-2.34l2.16,-1.67l-1.04,-2.28l3.47,1.46l1.38,-6.1l-2.27,-3.06l0,0h-3.6l0,0l0.9,-1.58l-1.63,-0.96l1.49,-1.09l-5.56,-3.1l-3.66,0.3l-3.06,2.83l-2.09,-0.78l-0.1,1.25l-2.92,-2.83l-1.8,2.47l-0.63,-3.59l3.08,-2.4l0.89,-3.53l-12.29,-17.48l2.72,-5.63l-2.56,-2.62l0.32,-2.34l5.38,-1.76l-2.62,-14.33L377,302.07zM422.21,411.13L422.21,411.13l-2.89,0.87l-1.86,3.38l0.65,2.61l4.05,0.68l3.49,-4.85l-2.94,-2.11L422.21,411.13z"
				}
			]
		}
	}
};
