﻿// (c) ammap.com | SVG (in JSON format) map of Colombia
// areas: {id:"CO-AMA"},{id:"CO-ANT"},{id:"CO-ARA"},{id:"CO-ATL"},{id:"CO-BOL"},{id:"CO-BOY"},{id:"CO-CAL"},{id:"CO-CES"},{id:"CO-CHO"},{id:"CO-CAL"},{id:"CO-COR"},{id:"CO-CAQ"},{id:"CO-CAS"},{id:"CO-CUN"},{id:"CO-DC"},{id:"CO-GUA"},{id:"CO-GUV"},{id:"CO-HUI"},{id:"CO-LAG"},{id:"CO-MAG"},{id:"CO-MET"},{id:"CO-NAR"},{id:"CO-NSA"},{id:"CO-PUT"},{id:"CO-QUI"},{id:"CO-RIS"},{id:"CO-SAN"},{id:"CO-SUC"},{id:"CO-SAP"},{id:"CO-TOL"},{id:"CO-VAC"},{id:"CO-VID"},{id:"CO-VAU"}
AmCharts.maps.colombiaLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-79.051463",
				"topLatitude":"12.591398",
				"rightLongitude":"-66.868938",
				"bottomLatitude":"-4.237159"
			}
		},
		"g":{
			"path":[
				{
					"id":"CO-AMA",
					"title":"Amazonas",
					"d":"M302.91,543.31L324.95,536L324.95,536L330.59,536.16L334.32,538.4L336.13,541.12L346.57,541.42L351.61,544.78L356.22,544.4L358.54,541L360.04,541L362.5,543.83L363.64,544.14L366,544.14L368.24,542.6L370.29,542.31L373.06,545.55L376.73,547.75L377.95,547.82L382.11,542.75L383.79,542.62L384.27,544.02L388.24,545.51L390.55,543.94L390.42,541.62L392.63,536.63L398.98,530.39L401.19,529.86L406.51,530.85L408.04,529.74L411.5,523.96L414.94,521.14L420.64,514.9L421.14,513.72L420.92,512.08L420.92,512.08L421.68,511.46L424.72,511.6L436.11,518.46L440.22,519.76L441.8,519.11L444.92,523.27L446.61,530.85L448.23,533.49L451.24,532.27L451.94,530.94L462.35,534.3L465.88,538.14L468.63,539.04L470.09,538.71L469.37,537.5L471.83,535.65L473.85,536.71L474.56,537.63L473.06,543.17L473.12,547.99L471.79,550.11L471.85,551.68L473.84,553.56L474.18,555.32L471.68,556.99L471.41,557.88L472.24,559.72L477.31,563.74L478.46,563.83L479.99,562.7L480.31,561.75L477.93,560.18L478.64,558.46L480,557.58L485.83,557.19L486.03,558.71L484.91,561.89L485.2,562.73L486.56,562.96L494.46,560.32L497.71,563.13L498.43,567.58L505.15,566.68L505.01,563.52L506.02,561.33L506.02,561.33L508.63,574.44L505.58,582.14L487.89,680.28L484.8,693.27L484.81,692.14L483.49,690.77L477.95,686.52L475.53,680.98L473.36,678.26L469.71,675.31L468.09,674.84L462.38,677.77L461.26,677.77L453.18,674.51L480.24,632.51L478.96,630.17L478.05,630.3L475,627.94L474,624.92L470.85,622.09L469.19,621.73L467.45,622.52L459.76,621.77L456.25,617.99L455.92,616.23L447.62,610.79L442.78,612.96L437.64,614.33L434.06,616.33L426.9,615.77L424.82,613.08L420.37,611.16L414.02,610.77L413.24,607.61L408.49,611.01L405.9,614.68L405.14,617.03L401.33,616.69L391.22,621.99L388.25,621.69L376.27,618.24L364.25,622.3L362.08,617.94L359.26,618.37L356.34,616.77L354.63,615.02L353.95,611.64L356.18,609.76L356.98,607.52L355.66,598.43L353.91,595.38L351.26,593.63L349.54,595.23L347.15,596.38L339.17,592.01L338.47,591.25L339.31,587.4L340.96,585.59L337.01,579.77L336.48,575.97L332.45,572.25L328.38,572.47L324.72,571.46L323.61,569.14L314.96,563.58L309.29,562.03L308.25,561.13L306.52,557.75L307.96,554.61L305.14,551.66z"
				},
				{
					"id":"CO-ANT",
					"title":"Antioquia",
					"d":"M290.9,283.09L289.71,282.89L283.39,284.73L276.13,285.79L274.38,288.16L270.39,290.95L265.55,287.71L261.12,287.37L251.73,284.75L252.45,292.76L251.75,293.28L244.98,293.13L240.8,295.04L240.8,295.04L235.86,294.89L235.86,294.89L231.5,289.98L231.14,288.96L231.99,286.06L229.89,280.13L230.7,277.95L230.91,274.8L227.7,274.05L226.96,273.39L226.35,271.74L225.94,266.32L222.5,264.47L210.84,266.64L206.52,266.45L203.13,261.69L202.56,254.72L198.89,246.95L195.91,244.79L195.52,239.37L197.79,238.61L200.84,239.25L202.77,237.64L202.85,236.13L201.59,233L202.26,231.99L208.12,231.77L213.29,233.3L214.06,232.88L215.23,225.86L214.26,222.84L211.59,219.12L209.14,218.23L206.64,216.23L193.6,202.31L190.54,201.63L189.97,197.83L191.47,197.38L193.31,195.83L194.58,190.66L197.46,188.25L199.95,187.5L201.18,185.57L201.18,185.57L201.26,189.99L198.94,189.15L197.96,189.78L197.67,193.73L199.81,194.83L202.08,195.01L204.51,194.42L205.06,193.74L205.58,189.46L203.85,174.07L201.87,171.13L199.61,169.51L197.49,168.86L197.48,167.57L199.28,165.34L207.97,163.08L217.92,154.8L218.16,153.56L218.16,153.56L219.57,155.65L220.01,160.36L221.15,163.45L222.53,164.95L227.2,167.31L228,169.09L227.36,174.66L220.99,181.55L219.53,185.03L218.16,193.43L214.83,197.28L214.43,203.01L215.5,208.74L221.55,217.29L242.25,217.07L249.16,208.5L249.69,205.44L252.45,201.65L253.73,201.42L256.79,203.32L257.48,202.7L258.74,198.43L262.21,197.11L263.91,193.84L268.48,189.49L278.73,189.12L280.4,188.09L284.07,183.4L284.07,183.4L288.38,187.05L294.96,191.37L296.29,193.2L296.69,200.18L297.57,201.26L296.61,205.82L293.85,213.68L298.21,218.58L300.39,216.89L302.73,212.98L303.54,212.45L304.32,212.78L304.94,215.26L302.74,218.65L302.26,223.6L304.78,231.92L309.02,231.73L321.13,220.32L321.13,220.32L320.7,222.29L321.2,227.5L322.5,229.47L322.89,232.16L321.03,233.86L317.76,235.45L313.78,240.88L307,246.31L302.99,247.61L301.5,249.46L301.11,250.87L301.44,254.4L302.49,256.13L302.14,256.99L298.25,261.32L295.64,262.74L295.64,262.74L294.53,264.13L293.41,267.57L293.58,274.4L292.88,275.11z"
				},
				{
					"id":"CO-ARA",
					"title":"Arauca",
					"d":"M489.48,272.13L477.63,262.84L474.39,261.41L467.06,261.27L460.88,263.98L454.84,264.38L442.27,263.87L432.77,261.59L421.27,265.3L417.33,265.36L416.15,264.43L410.64,264.73L401.72,266.6L396.43,270.15L395.57,270.12L390.4,268.19L387.06,263.79L386.83,259.54L386.83,259.54L390.28,255.65L395.41,252.67L395.84,250.28L400.08,241.51L401.14,235.88L403.61,231.98L403.61,231.98L405.67,232.93L407.49,232.91L412.88,230.47L417.02,229.99L422.69,231.42L428.11,231.46L434.34,233.89L440.78,233.02L445.59,230.39L446.49,229.28L453.36,228.33L460.25,229.97L470.88,234.92L473.88,233.45L478.11,233.38L506.54,268.7L506.54,268.7L504.91,270.02L501.6,271.35L492.63,270.99z"
				},
				{
					"id":"CO-ATL",
					"title":"Atlántico",
					"d":"M266.9,74.85L275.33,70.45L276.01,67.92L282.69,61.29L282.69,61.29L283.47,63.54L285.76,65.3L288.5,70.26L288.32,82.99L287.94,84.79L284.41,87.84L280.44,97.16L280.44,97.16L267.32,87.86L266.98,86.09L267.6,82.48L266.58,78.77L266.58,78.77L267.62,77.82L267.25,76.45L266.62,77.11L266.62,77.11z"
				},
				{
					"id":"CO-BOL",
					"title":"Bolívar",
					"d":"M326.93,184.66l-2.67,2.1l-0.83,2.44l0.05,2.65l2.59,8.82l-0.78,6.67l-3.41,6.61l-0.74,6.38l0,0l-12.12,11.41l-4.24,0.19l-2.52,-8.32l0.49,-4.95l2.2,-3.39l-0.62,-2.48l-0.78,-0.32l-0.81,0.53l-2.34,3.9l-2.18,1.69l-4.36,-4.9l2.76,-7.85l0.96,-4.56l-0.88,-1.08l-0.39,-6.99l-1.33,-1.83l-6.58,-4.32l-4.32,-3.65l0,0l1.8,-0.85l1.01,-2.21l0,0l5.03,-1.21l3.71,-7.5l-1.57,-4.47l0.01,-7.48l1.53,-1.33l-2.21,-4.96l-2.52,-3.2l-7.5,-4.45l-1.7,-2.08l-2.07,-4.36l0.23,-5.52l-0.82,-1.91l-1.77,-2.08l-13.78,-11.03l-0.44,-4.92l-1.82,-0.79l-3.78,-4.67l-2.01,-4.63l-2.43,0.74l0,0l0.45,-1.91l1.55,-1.99l-0.54,-9.8l2.55,-1.2l-0.77,-4.31l3.92,-4.52l4.98,-2.74l1.1,0.13l0.39,0.62l0,0l1.02,3.72l-0.62,3.61l0.34,1.76l13.12,9.3l0,0l-1.37,4.52l0.4,1.3l3.45,1.33l2.2,3.09l-0.29,1.61l-2.54,1.34l-0.39,1.09l0.23,3.47l3.35,11.48l-0.52,4.81l2.45,1.08l1.78,-0.23l2.6,1.77l2.81,3.03l9.32,3.38l4.87,3.89l3.32,3.95l5.8,1.9l5.41,0.7l0,0l-0.26,2.81l1.73,2.4l0.58,5.21l-0.25,3.29l1.7,3.25l1.47,7.59l-0.23,4.58L326.93,184.66zM266.62,77.11l-0.72,-0.29l0.17,-1.92l0.83,-0.06l0,0L266.62,77.11z"
				},
				{
					"id":"CO-BOY",
					"title":"Boyacá",
					"d":"M379.5,236.98L385.74,236.57L386.95,235.5L388.2,233.01L392.34,230.65L396.78,230.84L398.38,229.82L398.38,229.82L400.91,231.71L403.61,231.98L403.61,231.98L401.14,235.88L400.08,241.51L395.84,250.28L395.41,252.67L390.28,255.65L386.83,259.54L386.83,259.54L385.28,260.97L384.35,263.07L384.01,269.43L386.08,271.66L383.67,280L388.14,281.92L390.08,285.23L388.31,290.63L385,292L384.23,291.53L383.38,291.86L379.37,297.15L373.99,301.04L369.97,301.59L366.64,298.65L361.44,305.12L360.32,308.26L363.26,311.92L361.95,314.04L359.3,315.06L357.52,317.13L355.93,322.64L357.37,325.67L357.37,325.67L355.63,328.59L351.76,328.47L346.38,323.7L342.32,322.04L337.3,318.35L336.99,317.17L337.7,314.45L339.85,311.81L339.14,307.74L337.56,304.71L335.77,299.02L332.92,295.62L330.01,294.87L326.8,291.7L325.09,292.08L323.1,293.48L322.47,296.17L319.82,298.88L316.66,299.75L311.31,295.76L308.55,294.8L305.06,290.35L304.64,288.82L306.58,286.45L305.9,282.51L304.82,281.27L300.83,283.64L297.43,282.83L292.41,283.89L291.67,284.5L291.67,284.5L290.9,283.09L290.9,283.09L292.88,275.11L293.58,274.4L293.41,267.57L294.53,264.13L295.64,262.74L295.64,262.74L302.21,271.56L303.38,271.9L305.99,270.82L307.04,271.2L308.94,275.25L312.66,278.7L317.13,281.2L319.4,284.57L329.72,282.74L332.28,284.61L333.28,283.94L334.93,275.96L337.37,270.05L338.64,268.34L344.25,271.62L344.73,273.69L343.22,277.78L343.33,280.49L344.84,282.37L347.46,282.62L350.46,280.79L350.12,278.37L350.95,276.42L354.12,275.51L357.83,276.14L368.48,263.72L370.2,259.98L370.09,257.9L368.51,254.24L368.54,250.1L369.75,249.91L372.12,251.38L373.41,255.29L376.53,255.01L377.99,253.74L380.62,246.19L380.22,238.94z"
				},
				{
					"id":"CO-CAU",
					"title":"Cauca",
					"d":"M233.01,477.05L232.56,478.09L227.14,479.91L220.52,479.68L214.95,477.45L212.86,474.1L214.45,466.86L212.42,462.62L211.31,461.62L209.53,461.46L208.33,462.18L205.74,465.16L201.67,466.01L201.67,466.01L202.78,464.04L203.67,456.87L202.7,454.56L194.91,449.75L191.58,450.62L183.03,450.89L183.43,445.39L186.07,442.93L187.37,440.53L181.18,433.89L178.72,429.92L177.96,429.52L173.58,430.01L168.6,429.76L166.57,429.21L163.79,427.21L160.28,420.35L156.27,414.49L155.74,412.75L155.74,412.75L155.9,411.1L157.55,414.09L159.04,414.83L162.07,414.44L163.81,412.76L163.02,411.44L162.34,406.78L165.1,402.26L171.96,394.35L177.7,384.98L177.7,384.98L180.93,389.21L187.46,393.97L194.84,394.65L195.77,393.33L198.18,394.48L200.62,397.21L209.82,392.21L211.67,392L216.68,389.78L217.62,388.03L217.52,386.4L216.83,385.48L217.76,383.88L219.71,383.65L223.21,384.3L228.77,387.22L231.99,387.98L231.99,387.98L231.78,391.05L235.22,396.95L235.22,396.95L244.48,419.17L240.59,419.75L236.81,416.95L235.01,416.37L233.68,417.17L230.84,420.69L228.59,421.3L225.68,420.67L224.73,421.19L220.71,425.73L222.53,432.06L222.53,433.28L221.91,433.82L219.15,434.02L213.53,431.87L210.54,433.12L211.08,441.61L211.89,442.55L214.2,442.54L216.1,443.37L217.9,445.91L217.8,450.13L218.24,451.1L221.26,453.96L225.58,456.66L229.45,456.45L229.45,456.45L229.47,458.21L226.09,464.92L224.7,466.28L224.46,467.56L225.21,471.8L231.15,474.81z"
				},
				{
					"id":"CO-CES",
					"title":"Cesar",
					"d":"M326.93,184.66L328.05,179.78L328.28,175.2L326.8,167.61L325.1,164.36L325.35,161.07L324.78,155.86L323.05,153.46L323.31,150.65L323.31,150.65L325.97,146.41L322.65,142.66L320.14,136.75L316.83,131.53L313.41,129.12L316.02,125.58L317.18,124.94L327.04,124.86L324.79,118.45L315.14,105.3L316.52,100.38L320.41,93.7L337.12,86.21L334.76,82.11L334.84,80.4L336.24,77.47L332.62,73.2L332.43,71.94L333.48,69.99L333.48,69.99L334.9,71.84L336.09,72.16L346,72.21L348.67,73.3L355.55,80.69L356.16,82.27L355.2,86.16L353.9,86.73L351.63,89.6L353.91,91.15L360.56,90.1L363.15,90.42L363.15,90.42L361.9,103.33L360.31,108.09L359.19,117.8L356.02,124.4L349.28,132.74L344.39,140.32L343.8,142.58L343.8,142.58L342.44,145.92L341.46,152.62L341.76,160.28L338.57,164.95L337.93,168.99L340.14,176.85L341.29,177.2L342.45,176.24L342.29,172.86L342.83,172.11L344.27,172L345.64,173.19L345.41,179.08L343.32,179.92L342.68,181.63L345.78,187.25L347.18,192.35L344.43,198.99L342.35,201.57L339.42,202.79L334.93,203.34L334.93,203.34L333.67,201.86L329.39,201.55L328.85,200.46L331.31,194.53z"
				},
				{
					"id":"CO-CHO",
					"title":"Chocó",
					"d":"M179.42,163.15l0.81,0.53l1.92,3.47l0.64,2.56l1.8,2.15l4.39,2.26l2.18,3.48l4.66,3.63l0.82,3.27l2.51,1.55l2.03,-0.48l0,0l-1.24,1.92l-2.48,0.75l-2.89,2.41l-1.27,5.17l-1.84,1.56l-1.49,0.45l0.56,3.8l3.07,0.68l13.04,13.92l2.49,2l2.45,0.88l2.67,3.73l0.97,3.02l-1.17,7.02l-0.76,0.42l-5.17,-1.53l-5.86,0.22l-0.67,1.01l1.26,3.13l-0.09,1.51l-1.93,1.61l-3.04,-0.64l-2.27,0.76l0.39,5.42l2.98,2.16l3.66,7.77l0.57,6.97l3.39,4.76l4.33,0.19l11.65,-2.17l3.45,1.85l0.4,5.41l0.61,1.66l0.74,0.66l3.22,0.75l-0.22,3.16l-0.8,2.17l2.09,5.93l-0.85,2.9l0.35,1.02l4.36,4.91l0,0l-9.91,4.35l-4.22,4.11l4.63,10.53l3.14,2.02l0,0l-0.89,2.86l-2.59,1.48l-5.2,4.46l-7.08,14.32l-0.3,1.86l0.68,3.79l3.2,3.81l-0.56,1.47l-4.61,3.69l-6.39,2.03l-2.25,0.08l-3.85,-2.19l-5.7,-1.9l-4.12,-3.52l-1.33,-0.55l-2.53,0.43l-1.67,-2.33l0,0l0.24,-0.64l-3.92,-0.35l-1.86,-2.99l2.86,-8.39l-0.35,-7.1l-1.31,-6.08l-0.77,-8.85l0.04,-2.96l0.97,-3.52l-0.5,-2.38l-1.52,-6.49l-5.58,-2.58l1.14,-2.69l3.46,-1.64l2.53,0.81l1.33,-0.5l3.15,-3.81l0.4,-2.02l-4.04,-9.44l-6.18,-8.15l0.54,-4.02l2.82,1.78l0.91,-1.72l1.21,-4.52l0.64,-7.25l-2.79,-5.08l-2.4,-0.98l-8.24,-6.69l0.56,-4.15l-1.15,-3.25l-8.61,-7.13l3.39,-10.31l2.43,-0.23l1.14,-2.15l-1.57,-4l0.01,-2.47l0.61,-1.11l3.3,1.68l2.63,5.79l0.94,0.54l10.16,-7.25l0.04,-1.01l-1.65,-2.16l3.08,-5.22l3.28,-1.34l0.71,-2.57l-0.7,-3.66l-2.4,-4.58l-3.66,-3.57l-0.52,-4.7l-1.27,-2.18l-0.96,-0.88l-1.63,0.03l-0.3,-2.05l4.28,-5.18L179.42,163.15zM178.07,342.55l0.95,0.54l0.83,1.89l1.5,0.46l-9.43,2.28l0.41,-1.49l4.34,-4.07L178.07,342.55z"
				},
				{
					"id":"CO-CAL",
					"title":"Caldas",
					"d":"M260.52,322.44L255.53,318.54L251.49,318.32L247.2,316.76L242.6,317.84L241.14,317.85L240.25,317.12L238.61,312.69L239.21,311.28L243.71,307.1L247.79,304.79L250.2,301.23L246.73,298.76L241.24,300.54L240.54,299.64L240.8,295.04L240.8,295.04L244.98,293.13L251.75,293.28L252.45,292.76L251.73,284.75L261.12,287.37L265.55,287.71L270.39,290.95L274.38,288.16L276.13,285.79L283.39,284.73L289.71,282.89L290.9,283.09L290.9,283.09L291.67,284.5L291.67,284.5L290.64,293.95L290.93,295.79L289.08,300.18L287.31,302.78L287.31,302.78L284.8,302.05L280.59,301.94L276.75,302.83L274.39,304.42L271.79,307.78L265.35,308.36L264.2,309.65L262.15,316.92L263.38,319.94z"
				},
				{
					"id":"CO-COR",
					"title":"Córdoba",
					"d":"M284.07,183.4L280.4,188.09L278.73,189.12L268.48,189.49L263.91,193.84L262.21,197.11L258.74,198.43L257.48,202.7L256.79,203.32L253.73,201.42L252.45,201.65L249.69,205.44L249.16,208.5L242.25,217.07L221.55,217.29L215.5,208.74L214.43,203.01L214.83,197.28L218.16,193.43L219.53,185.03L220.99,181.55L227.36,174.66L228,169.09L227.2,167.31L222.53,164.95L221.15,163.45L220.01,160.36L219.57,155.65L218.16,153.56L218.16,153.56L222.66,152.23L224.86,149.88L228.63,139.91L232.05,135.76L239.1,132.17L243.33,131.49L247.07,132.21L247.07,132.21L249.18,135.34L255.26,139.47L259.87,144.12L263.85,145.24L267.09,147.78L268.65,152.03L268.16,155.6L266.91,155.1L263.8,155.48L260.63,156.68L260.57,157.84L262.97,164.09L264.15,171.13L265.35,171.48L267.88,170.8L268.89,171.39L269.29,175.33L272.39,174.5L276.67,170.86L282.5,173.3L285.48,175.96L285.94,179.09L286.87,180.34L286.87,180.34L285.86,182.55z"
				},
				{
					"id":"CO-CAQ",
					"title":"Caquetá",
					"d":"M399.2,492.11L402.77,496L405.51,500.78L406.95,505.19L409.54,505.85L412.54,508.58L419.62,512.75L420.92,512.08L420.92,512.08L421.14,513.72L420.64,514.9L414.94,521.14L411.5,523.96L408.04,529.74L406.51,530.85L401.19,529.86L398.98,530.39L392.63,536.63L390.42,541.62L390.55,543.94L388.24,545.51L384.27,544.02L383.79,542.62L382.11,542.75L377.95,547.82L376.73,547.75L373.06,545.55L370.29,542.31L368.24,542.6L366,544.14L363.64,544.14L362.5,543.83L360.04,541L358.54,541L356.22,544.4L351.61,544.78L346.57,541.42L336.13,541.12L334.32,538.4L330.59,536.16L324.95,536L324.95,536L319.96,534.63L317.21,533.14L313.8,529.67L310.73,528.82L307.16,526.79L304.51,524.26L300.15,522.93L298.84,525.09L293.96,524.18L290.72,522.24L289.82,519.02L291.35,517.62L289.13,512.06L288.32,511.45L282.64,510.53L278.3,508.71L277.26,503.96L277.92,502.03L277.4,500.95L272.84,498.51L270.44,499.97L269.28,499.71L268.01,497.09L268.24,494.41L266.61,490.01L265.44,489.11L263.79,488.71L259.6,489.39L256.16,488.47L254.68,486.2L250.87,484.06L246.29,485.12L242.53,483.76L239.76,480.71L239.43,478.42L238.44,477.17L233.01,477.05L233.01,477.05L231.15,474.81L225.21,471.8L224.46,467.56L224.7,466.28L226.09,464.92L229.47,458.21L229.45,456.45L229.45,456.45L237.3,455.69L238.63,454.74L254.24,434.91L255.01,432.55L263.4,423.25L265.11,420.06L266.41,415.58L267.74,414.34L270.04,415.06L271.25,414.75L275.62,411.18L277.48,408.86L275.95,405.46L275.85,403.92L279.74,398.55L279.74,398.55L286.84,400.77L291.75,404.22L293.61,406.88L293.33,409.8L289.69,415.52L290.31,423.55L292.37,429.69L293.04,437.53L297.06,443.21L300.21,444.83L309.12,446.49L312.76,450.69L317.83,454.35L322.28,454.16L330.05,451.88L332.51,452.44L332.51,452.44L332.76,456.46L336.74,461.67L339.97,464.83L342.44,471.74L351.48,479.03L352.25,480.34L355.41,481.67L357.88,481.56L364.23,476.79L364.74,475.95L364.11,474.08L365.61,471.86L371.06,470.28L373.76,470.96L374.63,472.37L378.07,474.63L380.48,474.57L383,477.02L387.99,483.64L390.87,489.95L392.67,489.27z"
				},
				{
					"id":"CO-CAS",
					"title":"Casanare",
					"d":"M357.37,325.67L355.93,322.64L357.52,317.13L359.3,315.06L361.95,314.04L363.26,311.92L360.32,308.26L361.44,305.12L366.64,298.65L369.97,301.59L373.99,301.04L379.37,297.15L383.38,291.86L384.23,291.53L385,292L388.31,290.63L390.08,285.23L388.14,281.92L383.67,280L386.08,271.66L384.01,269.43L384.35,263.07L385.28,260.97L386.83,259.54L386.83,259.54L387.06,263.79L390.4,268.19L395.57,270.12L396.43,270.15L401.72,266.6L410.64,264.73L416.15,264.43L417.33,265.36L421.27,265.3L432.77,261.59L442.27,263.87L454.84,264.38L460.88,263.98L467.06,261.27L474.39,261.41L477.63,262.84L489.48,272.13L489.48,272.13L487.01,275.05L484.43,281.65L479.1,288.45L475.11,290.66L468.54,291.5L464.69,293.01L455.2,298.76L454.69,301.51L448.17,307.51L445.27,309.04L440.77,316.64L438.41,318.82L438.41,318.82L433.17,322.17L427.87,323.73L418.75,327.85L415.18,330.37L410.37,332.08L401.57,338.61L398.97,339.8L397.78,339.7L396.02,337.87L394.75,337.45L391,337.89L387.55,339.19L384.2,342.26L376.13,343.28L370.8,343.75L362.89,335.32L360.87,332.55L359.98,329.95L357.37,326.49L357.37,326.49z"
				},
				{
					"id":"CO-CUN",
					"title":"Cundinamarca",
					"d":"M287.31,302.78L289.08,300.18L290.93,295.79L290.64,293.95L291.67,284.5L291.67,284.5L292.41,283.89L297.43,282.83L300.83,283.64L304.82,281.27L305.9,282.51L306.58,286.45L304.64,288.82L305.06,290.35L308.55,294.8L311.31,295.76L316.66,299.75L319.82,298.88L322.47,296.17L323.1,293.48L325.09,292.08L326.8,291.7L330.01,294.87L332.92,295.62L335.77,299.02L337.56,304.71L339.14,307.74L339.85,311.81L337.7,314.45L336.99,317.17L337.3,318.35L342.32,322.04L346.38,323.7L351.76,328.47L355.63,328.59L357.37,325.67L357.37,325.67L357.37,326.49L357.37,326.49L354.16,343.17L350.88,344.88L344.16,343.19L340.14,344.59L338.08,344.14L337.16,343.37L335.39,337.27L333.46,336.05L328.24,334.72L326.94,335.71L324.87,339.46L325.6,340.43L326.81,340.73L328.58,344.44L328.75,347.42L327.65,347.98L324.99,348.03L318.32,351.43L314.02,354.73L311.98,355.16L311.98,355.16L311.91,352.57L313.97,343.42L314.48,338.29L316.13,335.11L318.66,331.98L318.45,323.14L316.33,322.02L315.31,322.19L310.98,329.68L309.59,339.27L310.02,346.26L307.82,351.62L304.7,352.08L302.38,355.34L302.49,358.15L301.66,361.32L300.05,364.24L297.74,366.87L297.74,366.87L298.16,364.47L295.88,362.55L295.88,362.55L296.91,359.98L297.17,354L298.54,351.21L298.5,349.97L296.72,346.96L295.74,345.83L294.59,345.49L293.13,345.98L292.15,347.55L289.97,347.97L281.14,344.23L285.42,334.74L284.05,326.3L286.25,321.52L288.06,309.97z"
				},
				{
					"id":"CO-DC",
					"title":"Distrito Capital de Bogotá",
					"d":"M297.74,366.87L300.05,364.24L301.66,361.32L302.49,358.15L302.38,355.34L304.7,352.08L307.82,351.62L310.02,346.26L309.59,339.27L310.98,329.68L315.31,322.19L316.33,322.02L318.45,323.14L318.66,331.98L316.13,335.11L314.48,338.29L313.97,343.42L311.91,352.57L311.98,355.16L311.98,355.16L309.25,355.35L308.21,356.13L302.33,362.54L299.45,367.98L297.85,367.73z"
				},
				{
					"id":"CO-GUA",
					"title":"Guainía",
					"d":"M577.46,353.85L578.61,359.01L581.27,365.67L582.88,366.76L585.57,366.53L586.42,367.09L588.65,370.21L590.95,376.87L594.03,378.23L594.59,380.56L592.38,383.93L588.71,386.39L572.33,401.85L572.72,403.88L575.1,403.66L581.69,405.27L584.6,409.91L586.65,411L593.26,418.35L598.73,421.69L599.48,423.99L597.72,426.5L597.94,427.79L601.99,436.68L607,450.23L609.69,459.9L611.13,468.43L612,469.68L603.56,471.66L603.04,467L604.32,457.43L603.73,453.32L601.98,448.63L600.03,445.2L595.75,439.95L592.66,433.14L589.25,431.92L582.51,435.6L579.2,438.86L578.34,441.07L573.21,446.61L568.96,448.21L566.78,448.18L565.03,447.26L562.75,443.78L561.13,439.75L557.35,438.69L554.85,443.8L555.85,446.97L557.92,447.34L559.14,449.07L508.88,448.91L501.41,446.62L495.36,448.21L491.88,449.75L489.37,449.63L489.37,449.63L488,448.51L480.61,446.93L476.92,443.88L475.95,442.51L475.67,438.79L477.29,437.37L476.67,434.77L476.67,434.77L477.33,433.43L480.7,431.13L482.94,428.46L481.61,426.21L479.76,425.34L478,426.37L470.3,427.82L462.91,427.89L456.72,424.98L454.37,419.93L451.25,416.06L448.63,416.04L447.75,414.87L461.54,405.65L462.37,404.46L462.37,404.46L467.31,403.14L470.39,398.92L470.27,392.65L472.33,389.18L477.46,388.41L477.19,385.38L475.93,383.07L477.28,381.29L480.67,380.08L481.82,380.76L483.86,380.76L488.73,376.48L497.74,373.14L499.27,371.64L499.1,369.21L499.93,368.32L503.7,368.11L505.75,369.17L513.07,367.33L515.97,368.98L516.22,370.36L527.36,368.09L529.54,369.02L533.7,365.18L536.27,364.44L541.21,364.81L543.24,364.16L544.46,362.16L551.09,356.66L563.66,355.83L567.02,357.48L568.44,359.97L573.54,355.26z"
				},
				{
					"id":"CO-GUV",
					"title":"Guaviar",
					"d":"M476.67,434.77L455.66,441.03L446.51,440.82L441.12,445.01L437.11,445.63L433.08,448.12L425.22,457.57L422.37,459.54L419.19,466.92L419.41,471.33L416.33,475.55L413.71,478.1L411.35,478.54L410.04,479.55L408.88,482.75L399.2,492.11L399.2,492.11L392.67,489.27L390.87,489.95L387.99,483.64L383,477.02L380.48,474.57L378.07,474.63L374.63,472.37L373.76,470.96L371.06,470.28L365.61,471.86L364.11,474.08L364.74,475.95L364.23,476.79L357.88,481.56L355.41,481.67L352.25,480.34L351.48,479.03L342.44,471.74L339.97,464.83L336.74,461.67L332.76,456.46L332.51,452.44L332.51,452.44L333.1,425.99L334.2,422.31L343.17,423.45L346.25,423.09L352.3,421.75L359.98,419.14L363.56,413.71L366.25,412.74L367.97,413.73L375.81,411.82L378.95,408.24L385.96,404.66L397,403.65L400.54,404.36L411.36,402.36L424.45,402.56L429.42,401.44L436,401.41L438.54,401.99L438.54,401.99L438.84,404.13L442.56,403.46L449.46,406.08L453.66,406.29L454.79,405.28L455.84,402.52L461.68,404.78L462.37,404.46L462.37,404.46L461.54,405.65L447.75,414.87L448.63,416.04L451.25,416.06L454.37,419.93L456.72,424.98L462.91,427.89L470.3,427.82L478,426.37L479.76,425.34L481.61,426.21L482.94,428.46L480.7,431.13L477.33,433.43z"
				},
				{
					"id":"CO-HUI",
					"title":"Huila",
					"d":"M229.45,456.45L225.58,456.66L221.26,453.96L218.24,451.1L217.8,450.13L217.9,445.91L216.1,443.37L214.2,442.54L211.89,442.55L211.08,441.61L210.54,433.12L213.53,431.87L219.15,434.02L221.91,433.82L222.53,433.28L222.53,432.06L220.71,425.73L224.73,421.19L225.68,420.67L228.59,421.3L230.84,420.69L233.68,417.17L235.01,416.37L236.81,416.95L240.59,419.75L244.48,419.17L235.22,396.95L235.22,396.95L237.32,396.96L241.41,395.71L247.24,390.66L253.35,389.62L253.43,387.36L256.25,382.81L263.54,379.87L274.75,378.18L275.94,378.53L276.16,381.09L274.25,383.75L275.14,384.76L276.95,385.22L279.34,384.9L282.09,382.9L285.62,378.66L285.19,376.44L287.72,371.87L293.33,364.5L295.88,362.55L295.88,362.55L298.16,364.47L297.74,366.87L297.74,366.87L295.66,371.88L293.52,374.83L292.14,379.98L292.62,384.16L288.7,390.19L280.81,395.79L279.74,398.55L279.74,398.55L275.85,403.92L275.95,405.46L277.48,408.86L275.62,411.18L271.25,414.75L270.04,415.06L267.74,414.34L266.41,415.58L265.11,420.06L263.4,423.25L255.01,432.55L254.24,434.91L238.63,454.74L237.3,455.69z"
				},
				{
					"id":"CO-LAG",
					"title":"La Guajira",
					"d":"M363.15,90.42L360.56,90.1L353.91,91.15L351.63,89.6L353.9,86.73L355.2,86.16L356.16,82.27L355.55,80.69L348.67,73.3L346,72.21L336.09,72.16L334.9,71.84L333.48,69.99L333.48,69.99L332.81,67.42L333.59,61.82L336.97,56.99L337.24,55.2L337.24,55.2L343.54,55.1L347.66,54.19L350.88,51.96L351.31,50.81L353.49,48.81L368.91,37.8L379.26,33.63L383.44,33.2L389.94,29.38L391.01,28.29L394.88,20.28L394.59,16.06L393.64,15.46L394.09,14.64L399.42,13.94L402.05,14.19L400.11,16.67L401.17,18.16L403.16,17.92L406.19,15.91L408.44,11.61L413.25,9.39L415.79,7.08L414.81,6.35L412.78,6.53L411.45,7.39L411.96,6.26L413.34,5.49L420.02,6.05L430.45,10.24L432.71,12.09L437.08,20.61L437.1,22.69L436.4,24.01L430.17,28.15L428.43,30.89L425.19,32.57L415.99,34.97L410.09,37.26L401.9,38.7L391.97,56.09L387.5,59.66L380.35,61.4z"
				},
				{
					"id":"CO-MAG",
					"title":"Magdalena",
					"d":"M323.31,150.65L317.9,149.95L312.1,148.05L308.79,144.1L303.92,140.22L294.6,136.84L291.79,133.8L289.18,132.03L287.41,132.26L284.96,131.19L285.48,126.38L282.13,114.9L281.9,111.43L282.29,110.34L284.83,109L285.12,107.39L282.92,104.31L279.48,102.98L279.07,101.68L280.44,97.16L280.44,97.16L284.41,87.84L287.94,84.79L288.32,82.99L288.5,70.26L285.76,65.3L283.47,63.54L282.69,61.29L282.69,61.29L283.77,62.12L297.36,66.8L302.52,67.23L306.13,66.57L304.68,67.57L298.99,67.72L293.78,71.63L293.13,73.88L293.72,75.56L296.77,74.33L298.99,76.28L299.3,77.26L301.89,77.28L303.4,75.56L308.7,61.58L308.4,56.72L310.38,53.6L311.78,52.69L317.64,51.7L323.65,54.64L326.79,55.44L337.24,55.2L337.24,55.2L336.97,56.99L333.59,61.82L332.81,67.42L333.48,69.99L333.48,69.99L332.43,71.94L332.62,73.2L336.24,77.47L334.84,80.4L334.76,82.11L337.12,86.21L320.41,93.7L316.52,100.38L315.14,105.3L324.79,118.45L327.04,124.86L317.18,124.94L316.02,125.58L313.41,129.12L316.83,131.53L320.14,136.75L322.65,142.66L325.97,146.41z"
				},
				{
					"id":"CO-MET",
					"title":"Meta",
					"d":"M438.41,318.82L438.54,401.99L438.54,401.99L436,401.41L429.42,401.44L424.45,402.56L411.36,402.36L400.54,404.36L397,403.65L385.96,404.66L378.95,408.24L375.81,411.82L367.97,413.73L366.25,412.74L363.56,413.71L359.98,419.14L352.3,421.75L346.25,423.09L343.17,423.45L334.2,422.31L333.1,425.99L332.51,452.44L332.51,452.44L330.05,451.88L322.28,454.16L317.83,454.35L312.76,450.69L309.12,446.49L300.21,444.83L297.06,443.21L293.04,437.53L292.37,429.69L290.31,423.55L289.69,415.52L293.33,409.8L293.61,406.88L291.75,404.22L286.84,400.77L279.74,398.55L279.74,398.55L280.81,395.79L288.7,390.19L292.62,384.16L292.14,379.98L293.52,374.83L295.66,371.88L297.74,366.87L297.74,366.87L297.85,367.73L299.45,367.98L302.33,362.54L308.21,356.13L309.25,355.35L311.98,355.16L311.98,355.16L314.02,354.73L318.32,351.43L324.99,348.03L327.65,347.98L328.75,347.42L328.58,344.44L326.81,340.73L325.6,340.43L324.87,339.46L326.94,335.71L328.24,334.72L333.46,336.05L335.39,337.27L337.16,343.37L338.08,344.14L340.14,344.59L344.16,343.19L350.88,344.88L354.16,343.17L357.37,326.49L357.37,326.49L359.98,329.95L360.87,332.55L362.89,335.32L370.8,343.75L376.13,343.28L384.2,342.26L387.55,339.19L391,337.89L394.75,337.45L396.02,337.87L397.78,339.7L398.97,339.8L401.57,338.61L410.37,332.08L415.18,330.37L418.75,327.85L427.87,323.73L433.17,322.17z"
				},
				{
					"id":"CO-NAR",
					"title":"Nariño",
					"d":"M201.67,466.01l-2.93,0.76l-5.95,3.54l-1.64,1.55l0.23,7.78l3.27,11.94l-0.07,0.97l-3.84,1.44l-0.64,3.1l0.89,3.01l0.25,4.84l0,0l-5.74,0.96l-6.62,-1.99l-1.76,-1.15l-1.2,-5.26l0.31,-3.3l-0.84,-1.38l-1.22,-0.4l-1.75,0.39l-4.58,-3l-0.51,-0.89l0.12,-2.41l-0.91,-1.14l-0.84,-0.33l-4.76,1.51l-1.64,-0.22l-1.21,-0.49l-1.91,-2.02l-2.87,-1.19l-4.15,-0.48l-6.11,-4.66l-4.34,-1.59l-4.65,-5.07l-3.03,-0.69l-0.83,0.44l-1.29,-1.82l-3.54,-1.74l-5.45,-6.23l-2.02,-4.51l-2.87,-1.34l-4.23,-0.75l-0.8,-1.35l3.22,-4.94l3.77,-3l1.47,-0.45l3.45,0.64l5.78,2.3l1.39,-0.1l1.71,-6.14l-2.07,-4.13l-2.39,-1.88l-1.35,-5.31l5.01,-9.66l0.35,1.58l1.4,-1.79l2.37,-0.37l0.4,-2.5l1.14,-0.17l3.36,2.89l3.36,-3.33l5.87,1.3l5.59,-1.44l1.51,-1.45l0.38,-2.17l0,0l0.53,1.73l4.01,5.86l3.51,6.86l2.78,2.01l2.03,0.54l4.97,0.26l4.38,-0.5l0.76,0.4l2.47,3.98l6.19,6.64l-1.31,2.4l-2.64,2.46l-0.4,5.5l8.55,-0.27l3.33,-0.87l7.79,4.81l0.96,2.32l-0.89,7.16L201.67,466.01zM148.14,417.31l-3.68,-3.15l0.97,-2.57l2.4,-0.28l1.13,2.05l0.56,2.44L148.14,417.31z"
				},
				{
					"id":"CO-NSA",
					"title":"Norte de Santander",
					"d":"M398.38,229.82L396.78,230.84L392.34,230.65L388.2,233.01L386.95,235.5L385.74,236.57L379.5,236.98L379.5,236.98L378.1,237.18L377.55,236.53L377.66,233.39L376.99,232.76L373.1,234.21L364.85,230.72L364.85,217.39L359.71,207.3L350.92,206.99L348.72,209.69L346,209.92L339.49,207.92L338.04,205.69L334.93,203.34L334.93,203.34L339.42,202.79L342.35,201.57L344.43,198.99L347.18,192.35L345.78,187.25L342.68,181.63L343.32,179.92L345.41,179.08L345.64,173.19L344.27,172L342.83,172.11L342.29,172.86L342.45,176.24L341.29,177.2L340.14,176.85L337.93,168.99L338.57,164.95L341.76,160.28L341.46,152.62L342.44,145.92L343.8,142.58L343.8,142.58L350.24,142.59L358.97,137.16L360.16,138.87L361.1,141.35L360.93,142.3L364.1,144.74L368.46,146.36L373.21,164.56L383.16,174.96L384.6,175.8L386.72,184.8L387.05,188.53L386.34,189.11L384.55,189.12L381.65,194.37L381.13,211.83L384.04,215.57L389.78,216.31L394.22,218.96L393.81,221.55L394.61,224.18L397.87,229.8z"
				},
				{
					"id":"CO-PUT",
					"title":"Putumayo",
					"d":"M233.01,477.05L238.44,477.17L239.43,478.42L239.76,480.71L242.53,483.76L246.29,485.12L250.87,484.06L254.68,486.2L256.16,488.47L259.6,489.39L263.79,488.71L265.44,489.11L266.61,490.01L268.24,494.41L268.01,497.09L269.28,499.71L270.44,499.97L272.84,498.51L277.4,500.95L277.92,502.03L277.26,503.96L278.3,508.71L282.64,510.53L288.32,511.45L289.13,512.06L291.35,517.62L289.82,519.02L290.72,522.24L293.96,524.18L298.84,525.09L300.15,522.93L304.51,524.26L307.16,526.79L310.73,528.82L313.8,529.67L317.21,533.14L319.96,534.63L324.95,536L324.95,536L302.91,543.31L302.91,543.31L301.94,541.91L293.13,535.37L292.09,536.31L288.96,534.47L288.45,531.52L286.34,528.17L284.68,528.08L282.72,529.18L279.51,527.81L276.08,524.7L271.31,521.52L268.51,521.17L267.65,523.59L266.28,524.68L265.18,524.56L262.54,522.87L259.05,522.1L253.24,518.36L245.6,517.75L239.34,512.98L234.09,505.84L225.73,503.47L219.22,503.6L218.94,508.54L213.28,510.69L211.64,510.21L210.52,509.07L206.21,508.07L205.78,508.89L204,509.47L200.03,509.86L193.08,507.13L191.25,504.94L191.25,504.94L191.01,500.1L190.12,497.09L190.75,493.99L194.59,492.54L194.66,491.58L191.39,479.63L191.15,471.85L192.79,470.31L198.74,466.77L201.67,466.01L201.67,466.01L205.74,465.16L208.33,462.18L209.53,461.46L211.31,461.62L212.42,462.62L214.45,466.86L212.86,474.1L214.95,477.45L220.52,479.68L227.14,479.91L232.56,478.09z"
				},
				{
					"id":"CO-QUI",
					"title":"Quindío",
					"d":"M247.91,327.38L257.86,328.11L260.46,326.62L260.46,326.62L260.75,327.17L252.93,337.88L252.61,342.3L247.84,349.4L247.47,352.62L247.47,352.62L245.8,350.64L245.18,348.56L241.25,331.75L242.01,330.21L247.92,329.97L248.4,329.17z"
				},
				{
					"id":"CO-RIS",
					"title":"Risaralda",
					"d":"M260.46,326.62L257.86,328.11L247.91,327.38L247.91,327.38L240.04,324.88L236.87,320.31L233.6,317.13L231.26,315.6L229.48,315.91L229.48,315.91L226.35,313.88L221.72,303.35L225.94,299.24L235.86,294.89L235.86,294.89L240.8,295.04L240.8,295.04L240.54,299.64L241.24,300.54L246.73,298.76L250.2,301.23L247.79,304.79L243.71,307.1L239.21,311.28L238.61,312.69L240.25,317.12L241.14,317.85L242.6,317.84L247.2,316.76L251.49,318.32L255.53,318.54L260.52,322.44L260.52,322.44L258.92,324.54z"
				},
				{
					"id":"CO-SAN",
					"title":"Santander",
					"d":"M321.13,220.32L321.87,213.94L325.28,207.34L326.06,200.67L323.47,191.85L323.42,189.2L324.26,186.76L326.93,184.66L326.93,184.66L331.31,194.53L328.85,200.46L329.39,201.55L333.67,201.86L334.93,203.34L334.93,203.34L338.04,205.69L339.49,207.92L346,209.92L348.72,209.69L350.92,206.99L359.71,207.3L364.85,217.39L364.85,230.72L373.1,234.21L376.99,232.76L377.66,233.39L377.55,236.53L378.1,237.18L379.5,236.98L379.5,236.98L380.22,238.94L380.62,246.19L377.99,253.74L376.53,255.01L373.41,255.29L372.12,251.38L369.75,249.91L368.54,250.1L368.51,254.24L370.09,257.9L370.2,259.98L368.48,263.72L357.83,276.14L354.12,275.51L350.95,276.42L350.12,278.37L350.46,280.79L347.46,282.62L344.84,282.37L343.33,280.49L343.22,277.78L344.73,273.69L344.25,271.62L338.64,268.34L337.37,270.05L334.93,275.96L333.28,283.94L332.28,284.61L329.72,282.74L319.4,284.57L317.13,281.2L312.66,278.7L308.94,275.25L307.04,271.2L305.99,270.82L303.38,271.9L302.21,271.56L295.64,262.74L295.64,262.74L298.25,261.32L302.14,256.99L302.49,256.13L301.44,254.4L301.11,250.87L301.5,249.46L302.99,247.61L307,246.31L313.78,240.88L317.76,235.45L321.03,233.86L322.89,232.16L322.5,229.47L321.2,227.5L320.7,222.29z"
				},
				{
					"id":"CO-SUC",
					"title":"Sucre",
					"d":"M247.07,132.21L248.61,132.62L249.89,132.02L251.4,130.1L252.6,126.99L252.84,124.53L252.17,122.07L249.72,118.13L252.63,109.02L252.95,104.48L252.95,104.48L255.38,103.75L257.39,108.38L261.16,113.05L262.98,113.83L263.43,118.76L277.21,129.79L278.98,131.86L279.81,133.77L279.58,139.29L281.65,143.66L283.34,145.73L290.84,150.18L293.36,153.38L295.57,158.34L294.05,159.67L294.04,167.15L295.61,171.63L291.9,179.13L286.87,180.34L286.87,180.34L285.94,179.09L285.48,175.96L282.5,173.3L276.67,170.86L272.39,174.5L269.29,175.33L268.89,171.39L267.88,170.8L265.35,171.48L264.15,171.13L262.97,164.09L260.57,157.84L260.63,156.68L263.8,155.48L266.91,155.1L268.16,155.6L268.65,152.03L267.09,147.78L263.85,145.24L259.87,144.12L255.26,139.47L249.18,135.34z"
				},
				{
					"id":"CO-SAP",
					"title":"San Andrés, Providencia y Santa Catalina",
					"d":"M0.29,4.2L0,1.89L1.15,0L1.6,0.19L1.2,2.44z"
				},
				{
					"id":"CO-TOL",
					"title":"Tolima",
					"d":"M247.47,352.62L247.84,349.4L252.61,342.3L252.93,337.88L260.75,327.17L260.46,326.62L260.46,326.62L258.92,324.54L260.52,322.44L260.52,322.44L263.38,319.94L262.15,316.92L264.2,309.65L265.35,308.36L271.79,307.78L274.39,304.42L276.75,302.83L280.59,301.94L284.8,302.05L287.31,302.78L287.31,302.78L288.06,309.97L286.25,321.52L284.05,326.3L285.42,334.74L281.14,344.23L289.97,347.97L292.15,347.55L293.13,345.98L294.59,345.49L295.74,345.83L296.72,346.96L298.5,349.97L298.54,351.21L297.17,354L296.91,359.98L295.88,362.55L295.88,362.55L293.33,364.5L287.72,371.87L285.19,376.44L285.62,378.66L282.09,382.9L279.34,384.9L276.95,385.22L275.14,384.76L274.25,383.75L276.16,381.09L275.94,378.53L274.75,378.18L263.54,379.87L256.25,382.81L253.43,387.36L253.35,389.62L247.24,390.66L241.41,395.71L237.32,396.96L235.22,396.95L235.22,396.95L231.78,391.05L231.99,387.98L231.99,387.98L235.66,376.9L239.15,362.19L242.33,357.48L244.71,357.96L247.24,355.93z"
				},
				{
					"id":"CO-VAC",
					"title":"Valle del Cauca",
					"d":"M231.99,387.98L228.77,387.22L223.21,384.3L219.71,383.65L217.76,383.88L216.83,385.48L217.52,386.4L217.62,388.03L216.68,389.78L211.67,392L209.82,392.21L200.62,397.21L198.18,394.48L195.77,393.33L194.84,394.65L187.46,393.97L180.93,389.21L177.7,384.98L177.7,384.98L175.24,383.26L175.98,382.14L179.53,379.88L184.47,373.57L185.81,373.21L188.72,369.49L189.35,365.27L193.18,359.13L189.89,360.11L186.76,362.2L183.59,362.34L182.71,361.86L182.26,359.23L182.75,357.8L185.69,356.93L186.81,353.31L183.79,351.86L181.65,354.1L180.34,357.79L179.44,358.82L177.12,355.84L176.52,349.95L176.99,348.45L180.63,346.87L183.15,346.96L184.3,345.71L184.3,345.71L185.97,348.04L188.5,347.61L189.83,348.15L193.95,351.68L199.65,353.58L203.5,355.77L205.75,355.69L212.14,353.66L216.75,349.97L217.3,348.5L214.11,344.69L213.43,340.9L213.73,339.04L220.8,324.71L226,320.25L228.59,318.77L229.48,315.91L229.48,315.91L231.26,315.6L233.6,317.13L236.87,320.31L240.04,324.88L247.91,327.38L247.91,327.38L248.4,329.17L247.92,329.97L242.01,330.21L241.25,331.75L245.18,348.56L245.8,350.64L247.47,352.62L247.47,352.62L247.24,355.93L244.71,357.96L242.33,357.48L239.15,362.19L235.66,376.9z"
				},
				{
					"id":"CO-VID",
					"title":"Vichada",
					"d":"M438.41,318.82L440.77,316.64L445.27,309.04L448.17,307.51L454.69,301.51L455.2,298.76L464.69,293.01L468.54,291.5L475.11,290.66L479.1,288.45L484.43,281.65L487.01,275.05L489.48,272.13L489.48,272.13L492.63,270.99L501.6,271.35L504.91,270.02L506.54,268.7L506.54,268.7L508.93,267.58L511.21,267.47L513.08,269.84L514.27,270.12L516.19,269.45L520.61,265.22L521.91,264.69L531.33,265.91L539.14,268.01L546.74,265.74L552.28,266.67L559.05,264.41L563.99,265.12L567.2,264.62L572.41,260.92L580.48,261.84L583.43,262.78L586.21,265.13L587.93,265.64L586.5,267.25L586.36,268.59L589.6,273.77L581.11,282.14L579.8,286.62L580.54,290.94L581.28,292.18L579.9,295.05L573.53,298.96L571.69,302.11L573.63,315.81L572.67,325.53L571.27,332.74L574.32,342.04L573.64,343.46L573.43,346.27L574.24,348.95L577.46,353.85L577.46,353.85L573.54,355.26L568.44,359.97L567.02,357.48L563.66,355.83L551.09,356.66L544.46,362.16L543.24,364.16L541.21,364.81L536.27,364.44L533.7,365.18L529.54,369.02L527.36,368.09L516.22,370.36L515.97,368.98L513.07,367.33L505.75,369.17L503.7,368.11L499.93,368.32L499.1,369.21L499.27,371.64L497.74,373.14L488.73,376.48L483.86,380.76L481.82,380.76L480.67,380.08L477.28,381.29L475.93,383.07L477.19,385.38L477.46,388.41L472.33,389.18L470.27,392.65L470.39,398.92L467.31,403.14L462.37,404.46L462.37,404.46L461.68,404.78L455.84,402.52L454.79,405.28L453.66,406.29L449.46,406.08L442.56,403.46L438.84,404.13L438.54,401.99L438.54,401.99z"
				},
				{
					"id":"CO-VAU",
					"title":"Vaupés",
					"d":"M506.02,561.33L505.01,563.52L505.15,566.68L498.43,567.58L497.71,563.13L494.46,560.32L486.56,562.96L485.2,562.73L484.91,561.89L486.03,558.71L485.83,557.19L480,557.58L478.64,558.46L477.93,560.18L480.31,561.75L479.99,562.7L478.46,563.83L477.31,563.74L472.24,559.72L471.41,557.88L471.68,556.99L474.18,555.32L473.84,553.56L471.85,551.68L471.79,550.11L473.12,547.99L473.06,543.17L474.56,537.63L473.85,536.71L471.83,535.65L469.37,537.5L470.09,538.71L468.63,539.04L465.88,538.14L462.35,534.3L451.94,530.94L451.24,532.27L448.23,533.49L446.61,530.85L444.92,523.27L441.8,519.11L440.22,519.76L436.11,518.46L424.72,511.6L421.68,511.46L420.92,512.08L420.92,512.08L419.62,512.75L412.54,508.58L409.54,505.85L406.95,505.19L405.51,500.78L402.77,496L399.2,492.11L399.2,492.11L408.88,482.75L410.04,479.55L411.35,478.54L413.71,478.1L416.33,475.55L419.41,471.33L419.19,466.92L422.37,459.54L425.22,457.57L433.08,448.12L437.11,445.63L441.12,445.01L446.51,440.82L455.66,441.03L476.67,434.77L476.67,434.77L477.29,437.37L475.67,438.79L475.95,442.51L476.92,443.88L480.61,446.93L488,448.51L489.37,449.63L489.37,449.63L489.52,475.77L498.95,475.53L506.3,477.15L510.29,475.74L514.84,478.76L518.45,484.31L517.67,488.84L518.97,493.3L515.59,494.43L512.39,494.16L505.31,489.51L496.07,491.94L491.44,495.04L481.18,495.71L480.63,526.11L485.76,532.12L493.76,538.32L498.25,539.89L499.24,540.95L500.6,545.66L498.88,549.32L498.99,550.61L502.9,557.88L506.34,560.65z"
				}
			]
		}
	}
};
