﻿// (c) ammap.com | SVG (in JSON format) map of Cameroon - Low
// areas: {id:"CM-AD"},{id:"CM-CE"},{id:"CM-EN"},{id:"CM-ES"},{id:"CM-LT"},{id:"CM-NO"},{id:"CM-NW"},{id:"CM-OU"},{id:"CM-SU"},{id:"CM-SW"}
AmCharts.maps.cameroonLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"8.498142",
				"topLatitude":"12.872582",
				"rightLongitude":"16.192723",
				"bottomLatitude":"1.652624"
			}
		},
		"g":{
			"path":[
				{
					"id":"CM-AD",
					"title":"Adamaoua",
					"d":"M284.99,758.83L287.06,756.96L290.46,750.35L289.52,747.42L286.96,744.11L286.49,741.93L286.78,735.07L288.17,734L288.47,731.68L287.53,729.24L284.31,728.01L279.77,727.64L276.93,726.23L276.93,726.23L277.69,724.99L279.39,715.25L278.46,711.93L278.46,711.93L282.04,710.81L287.2,712.38L290.12,710.14L295.05,710.59L299.54,708.12L300.66,704.53L300.01,701.83L301.71,701.86L301.07,700.98L301.8,700.15L302.09,697.29L301.33,695.82L302.11,694.75L304.16,694.51L305.15,693.6L307.34,695.01L311.12,693.7L312.05,690.52L314.48,688.12L314.86,682.77L318.05,680.91L318.18,679.18L316.61,676.65L317.64,674.76L319.3,674.04L318.98,672.55L317.51,672.37L317.36,669.43L316.6,668.7L315.04,668.78L314.94,667.95L317.21,663.42L320.74,662.34L323.99,658.71L328.7,656.92L330.49,654.45L335.2,652.65L340.5,647.36L343.81,646.55L344.79,644.67L348.66,645.47L349.78,644.12L349.78,640.75L340.67,631.21L340.08,627.33L335.88,627.5L333.86,626.83L334.08,625.71L339.02,622.79L344.92,615.09L358.53,600.32L360.55,595.82L363.13,594.03L362.27,586.38L364.11,583.79L364.8,578.05L366.66,575.6L367.45,572.28L370.37,567.27L376.19,562.13L378.14,558.43L382.12,553.52L383.28,550.36L381.66,541.2L385.7,533.7L386.83,532.9L386.83,532.9L396.28,544.11L405.73,553.07L410.49,556.56L418.8,558.48L423.85,558.42L426.52,564.57L425.18,569.11L425.72,575.79L444.64,584.34L461.05,586.44L469.96,590.49L476.89,591.55L488.15,591.3L489.64,591.92L490.89,589.92L490.39,585.74L491.13,583.06L493.71,580.81L497.25,580.68L502.93,582.33L507.34,587.64L512.64,589.53L513.65,591.3L517.44,593.96L518.95,593.83L519.96,591.18L521.73,589.66L525.13,589.03L531.44,585.61L537.25,586.88L541.41,586.37L543.27,585.12L553.52,583.6L554.63,584.16L555.28,585.97L554.78,589.83L555.24,591.09L560.73,593.11L578.8,594.68L580.93,596.65L581.75,603.05L588.14,606.66L587.81,609.78L590.6,611.91L594.53,618.64L598.95,620.12L600.42,622.25L601.41,627.01L601.41,631.6L600.1,636.34L608.62,637.69L620.49,637.24L624.9,645.75L630.05,646.37L631.9,649.23L634.76,650.75L641.49,649.4L650.74,643.51L654.44,643.34L672.11,635.25L678.16,635.25L682.7,632.56L688.76,625.82L693.64,624.64L698.18,626.16L698.18,626.16L696.33,627.17L694,630.22L691.23,635.41L691.53,638.63L692.47,639.35L689.52,646.25L686.75,646.64L684.58,650.64L683.66,656.93L684.13,659.02L681.56,662.51L678.56,670.31L676.99,672.53L676.12,676.57L674.58,678.13L671.48,677.63L665.87,679.95L650.06,714.36L649.62,716.89L650.33,719.38L643.61,729.6L640.89,731.3L624.18,736.89L621.36,739.11L618.37,743.36L614.96,746.38L610.16,747.83L610.16,747.83L608.02,747.39L606.57,744.27L604.79,744.72L601.2,748.59L596.04,748.04L592.55,750.68L570.92,753.33L566.32,749.99L564.36,749.97L549.43,756.4L508.79,757.93L450.85,757.53L450.85,757.53L412.97,756.94L409.37,750.01L392,736.49L387.77,736L376.18,739.3L366.55,739.18L357.05,729.93L355.07,730.67L352.97,733.14L344.54,736.27L339.27,737.08L336.68,739.18L331.74,741.4L325.85,747.95z"
				},
				{
					"id":"CM-CE",
					"title":"Centre",
					"d":"M284.99,758.83L325.85,747.95L331.74,741.4L336.68,739.18L339.27,737.08L344.54,736.27L352.97,733.14L355.07,730.67L357.05,729.93L366.55,739.18L376.18,739.3L387.77,736L392,736.49L409.37,750.01L412.97,756.94L450.85,757.53L450.85,757.53L450.24,766.14L452.18,769.76L454.32,770.88L458.41,777.76L460,785.4L463.78,787.34L464.84,792.59L471.01,802.12L471.01,805.3L466.01,816.81L460.07,826.18L455.59,827.15L450.6,826.83L445.76,829.55L446.37,830.98L451.38,834.41L461.94,844.41L469.33,853.36L468.02,861.79L475.54,864.42L482.01,865.08L487.81,878.5L485.31,900.73L483.16,903.87L478.57,902.74L473.53,903.32L470.05,902.65L465.41,903.67L461.2,903.13L452.89,907.7L450.56,910.45L446.99,922.04L443.08,926.3L442.35,929.91L442.97,931.88L441.7,941.63L439.23,950.39L441.71,952.84L442.3,955.56L441.56,957.78L435.63,960.74L427.99,968.02L417.92,970.02L415.27,972.87L412.16,973.78L411.46,977.09L413.79,982.16L423.22,987.43L422.69,999.88L419.2,1006.95L419.2,1006.95L416.24,1004.31L412.2,996.08L409.76,995.56L407.75,996.08L405.21,1000.3L392.38,1010.54L387.19,1015.92L383.9,1029.52L381.78,1031.84L378.18,1031.21L374.36,1033.63L373.3,1033.32L373.3,1031.74L374.47,1029.52L373.62,1028.15L359.84,1022.67L358.25,1020.14L356.34,1019.61L354.66,1020.36L352.63,1019.4L350.94,1017.29L348.5,1018.03L346.06,1024.57L340.29,1026.44L337.89,1028.99L335.78,1029.34L333.98,1032.74L331.32,1035.24L329.5,1042.32L327.13,1044.56L317.21,1048.87L312.73,1049.7L298.06,1048.87L291.36,1050.81L287.16,1049.56L279.34,1050.54L276.82,1047.2L273.33,1044.56L273.47,1041.64L272.77,1039.83L270.4,1039.48L268.02,1036.63L266.06,1026.48L263.97,1023.7L260.74,1021.23L256.84,1022.28L255.02,1021.9L253.77,1019.95L251.39,1019.81L242.56,1022.23L241.31,1021.16L239.46,1015.53L237.42,1014.39L216.98,1019.47L192.98,1026.76L184.32,1028.01L180.86,1014.81L178.73,1010.77L180.49,1008.31L180.49,1008.31L184.46,1008.13L188.75,1000.39L188.93,995.61L191.36,993.1L191.58,988.52L192.84,983.65L195.36,981.42L200.81,979.61L212.16,986.15L214.5,989.35L216.46,990.19L218.13,984.76L221.21,982.95L220.51,981.56L223.17,977.95L221.63,967.09L225.12,962.78L226.8,956.38L236.38,952.65L239.79,953.32L241.45,951.6L245.66,950.14L249.3,950.13L255.72,947.89L259.22,945.52L266.91,944.15L267.18,939.12L265.64,937.59L261.66,935.61L258.93,930.86L254.97,927.03L254.77,924.3L251.88,922L251.43,919.35L247.06,914.48L246.56,910.77L248.04,909.61L249.5,899.5L249,898.19L247.43,897.5L243.7,899.84L238.5,898.17L236.3,901.81L234.4,908.85L231.26,911.78L229.44,911.38L227.92,907.84L226.19,908.55L224.6,911.31L220.82,912.69L218.29,915.82L214.64,916.93L201.06,911.88L198.61,912.26L195.96,911.08L194.94,909.05L196.6,902.19L201.37,895.27L203.18,894.85L205.84,887.75L203.6,885.66L199.66,885.56L193.82,889.28L191.58,889L192.7,882.45L201.63,875.97L207.65,868.4L207.65,868.4L215.2,869.64L220.93,867.69L232.09,861.78L235.51,857.56L237.28,857.1L244.26,864.9L248.54,865.59L253.07,862.25L256.89,845.68L260.77,840.59L265.78,839.26L265.09,836.75L266.19,831.27L265.68,828.83L268.27,826.32L271.23,825.42L272.59,822.63L276.82,819.05L277.52,815.56L275.58,813.43L276.22,811.88L277.48,811.49L279.63,804.48L277.48,796.75L279.49,792.75L278.82,790.23L286.33,783.55L289.82,778.57L286.15,776.24L285.66,769.7L284.78,767.65L285.6,763.71z"
				},
				{
					"id":"CM-EN",
					"title":"Far North",
					"d":"M508.57,337.03L507.4,336.77L504.07,330L504.07,330L506.33,329.53L507.53,326.22L510.7,323.85L511.13,318.82L515.27,313.12L516.02,309.43L515.62,305.58L517.24,302.8L517.14,297.01L517.66,295.15L520.34,292.38L520.34,289.55L519.07,287.79L517.87,281.79L518.88,276.78L519.69,274.96L524.1,270.88L526.37,262.75L529.3,257.92L531.14,256.55L532.83,253.94L534.5,249.83L534.91,242.69L536.2,241.44L540.22,240.54L545.61,237.86L547.62,233.03L551.48,229.64L553.26,226.84L554.34,226.49L553.95,224.02L556.38,222.42L557.59,220.68L558.88,216.22L562.33,212.3L563.69,207.65L566.09,206.9L567.87,208.29L572.64,209.33L576.58,212.97L580.45,212.9L587.86,209.67L591.07,205.25L596.52,201.81L609.98,196.55L612.81,191.41L619.25,189.92L629.84,185.65L631.93,184.08L632.97,176.3L632.22,172.72L628.64,169.09L625.3,167.22L623.21,164.36L623.3,163.44L628.9,158.47L628.66,151.52L629.53,150.17L628.64,149.02L632.5,144.41L632.11,142.17L634.05,139.56L630.33,131.95L630.56,130.37L633.43,128.45L632.2,125.54L633.52,123.68L634.05,120.67L636.2,119.04L635.69,116.61L634.68,116.1L634.13,114.37L633.28,115.21L631.66,115.35L631.46,116.17L628.43,115.16L629.18,114.29L627.92,111.81L622.95,110.52L624.14,108.21L623.35,108.74L622.98,105.94L619.38,104.25L619.25,102.4L620.35,102.36L619.79,100.91L617.67,100.34L616.36,98.35L615.41,98.92L613.69,97.78L612.67,98.69L612.27,97.58L611.14,97.06L605.33,97.65L600.44,96.2L597.59,97.65L596.88,96.3L596.41,98.32L595.16,96.38L589.47,97.26L585.74,92.93L584.15,92.46L584.78,91.4L584.42,90.51L586.5,89.99L586.1,89.05L586.7,88.47L584.92,88.32L584.33,85.57L586.6,81.92L589.74,80.05L589.74,78.76L591.85,76.61L593.75,72.74L593.75,71.67L592.49,71.24L591.85,68.87L587.84,65.64L588.26,64.14L589.11,63.06L594.18,60.48L595.87,60.05L599.67,61.13L600.3,60.48L601.15,55.75L600.51,54.46L598.19,53.38L598.19,52.52L600.09,52.09L606,58.12L610.44,58.76L612.13,60.05L612.34,60.7L609.8,61.56L608.96,63.06L609.38,63.92L612.34,63.71L613.61,64.35L615.51,63.06L615.51,60.48L619.94,52.74L619.52,43.64L620.58,43.48L622.05,43.91L623.74,46.07L624.61,48.08L623.54,49.83L623.13,52.56L625.69,53.84L626.63,56.59L628.17,56.52L630.32,54.18L630.32,57.53L631.87,57.41L634.57,59.44L639.03,58.96L640.12,59.63L640.82,60.89L639.03,63.76L639.71,65.62L640.82,66.03L642.14,63.5L643.3,62.99L644.31,64.29L645.11,68.32L650.68,68.42L651.93,69.05L654.31,77.28L654.07,82.17L654.72,84.2L653.73,87.09L654.52,87.98L656.72,86.27L657.56,90.18L660.06,95.17L659.98,100.25L658.99,103.21L659.9,106.27L658.98,113.35L660.01,115.83L658.08,118.02L662.44,122.94L665.9,125.23L667.27,125.4L669.28,123.19L670.24,123.1L673.2,124.79L672.86,127.63L674.42,128.09L675.57,130.5L675.03,131.74L673.37,132.33L675.27,134.46L677.29,134.67L678.2,135.52L677.04,137.99L674.78,137.97L675.9,142.41L673.86,144.31L673.61,145.44L674.89,150.36L676.78,151.34L677.33,149.37L679.05,150.9L679.14,153.41L681.52,156.43L680.76,157.99L678.33,158.69L677.55,159.79L679.46,161.27L679.8,163.13L676.85,163.05L676.03,165.09L676.4,166.72L677.53,167.67L677.2,169.28L678.1,170.63L677.7,172.63L678.81,174.92L679.83,175.53L679.63,178.5L683.35,180.36L683.95,183.19L682.98,186.05L679.25,189.07L679.51,190.22L678.33,190.77L676.94,193.07L677.2,193.91L675.32,196.48L676.46,200.89L674.81,202.58L674.14,205.28L674.61,206.51L672.83,207.46L672.98,209.26L672.01,209.75L672.63,211.13L672.43,213.89L673.58,215.07L672.05,216.33L672.98,217.18L672.2,218.61L673.35,221.38L672.77,222.21L673.07,223.82L671.85,225.25L672.91,225.69L672.79,230.03L673.92,230.69L673.09,231.79L674.67,235.21L674.44,239.71L675.75,242.73L677.81,244.65L678.76,250.43L678.9,253.19L676.5,256.03L676.42,259.51L679.67,265.96L682.35,269.36L685.18,276.05L685.49,278.54L684.12,282.06L684.3,287.3L686.86,289.63L690.76,291.05L694.1,294.33L695.17,297.81L698.44,301.55L698.38,305.3L699.88,307.17L699.76,308.41L700.93,309.28L701.21,311.31L705.89,313.05L708.23,316.35L709.78,317.17L712.57,321.48L715.76,323.74L719.33,330.9L721.31,331.81L722.18,333.85L723.79,333.42L728.2,337L736.09,340.57L738.78,342.49L739.66,344.81L730,347.64L714.06,350.18L704.06,346.26L693.58,343.63L691.16,346.94L685.7,344.35L682.95,343.82L680.75,345.03L679.72,347.01L676.16,346.72L671.15,343.72L667.78,343.14L660.95,345.35L655.86,349.33L652.39,351.1L648.57,350.76L644.18,348.54L638.95,348.46L622.34,343.32L616.23,342.2L602.09,343.56L598.03,342.88L590.67,343.53L587.9,344.34L586.13,346.88L586.13,346.88L587.36,339.91L586.56,337.52L576.38,333.38L572,334.27L569.3,330.12L566.26,328.62L564.13,324.69L562.5,323.47L560.61,322.54L555.18,322.27L551.95,320.72L546.07,321.84L534.26,319.52L531.88,320.55L530.01,324.67L530.69,326.9L533.24,329L533.36,330.32L532.56,331.36L526.11,332.78L521.05,335.86L515.64,334.94L508.57,337.03L508.57,337.03z"
				},
				{
					"id":"CM-ES",
					"title":"East",
					"d":"M610.28,748.29L610.67,749.08L609.77,753.17L611.23,756.18L614.32,758.86L616.75,763.19L617.15,765.25L618.44,766.49L620.66,766.98L623.52,766.2L624.45,766.86L628.1,764.61L629.14,764.97L630.29,767.12L630.98,787.45L627.6,798.86L629.34,803.94L631.29,807.16L628.54,811.38L628.29,818.11L625.83,819.45L625.82,821.37L622.83,827.17L623.33,828.19L620.67,830.64L621.17,831.91L625.93,836.01L633.52,837.52L635.96,840.78L637.93,849.33L636.32,850.7L636.08,851.88L637.56,856.94L636.57,857.5L636.16,860.29L637.97,863.22L636.92,866.62L640,872.88L639.15,874.11L640.6,880.96L639.91,882.78L638.68,883.41L640.49,885.85L640.87,896L641.97,898.31L641.69,899.28L643.36,900.25L644.35,902.14L645.79,902.4L650.26,907.96L652.48,909.41L654.39,909.65L654.72,910.76L656.28,911.38L658.04,913.88L663.44,916.12L663.98,917.23L666.13,917.09L667.41,917.45L667.95,918.49L670.94,919.04L672.7,924.54L674.07,924.45L676.25,928.78L678.16,930.32L679.73,935.51L679.25,937.61L680.33,939.57L680.22,943.53L680.91,944.15L680.99,946.49L680.28,947.83L681.06,949.62L683.48,951.52L684.63,955.01L687.15,954.71L688.16,956.2L684.31,958.34L676.23,960.43L675.22,962.05L678.58,962.18L680.3,967.4L694.79,991.08L721.5,1019.1L751.44,1053.97L752.18,1054.65L752.89,1053.78L757.94,1053.07L759,1054.21L760.72,1054.36L764.66,1060.59L769.04,1065.49L770.42,1064.22L772.75,1064.13L774.01,1066.12L775.92,1066.83L776.01,1068.44L778.33,1072.85L779.76,1074.1L781.22,1078.63L781.4,1082.5L779.76,1084.47L777.47,1085.61L778.89,1089.62L778.62,1093.79L781.46,1094.89L779.96,1097.47L779.16,1101.09L780.96,1105.45L779.15,1112.66L780.98,1116.29L780.01,1118.96L780.85,1121.1L782.85,1122.74L784.13,1126.34L787.53,1130.8L789.84,1138.57L789.19,1141.45L792,1144.45L790.81,1146.24L788.7,1147.16L787.41,1148.65L786.83,1148.64L785.85,1146.47L782.1,1146.28L781.11,1146.89L780.47,1152.21L781.36,1157.98L779,1159.93L780.93,1162.52L777.96,1166.44L777.95,1169.67L780.47,1172.1L781.6,1177.81L784.04,1178.13L784.13,1181.42L785.35,1185.45L786.67,1187.22L787.37,1190.92L786.65,1194.72L787.97,1196.79L787.12,1199.09L785.19,1197.75L783.95,1197.75L780.86,1198.76L778.88,1202.05L775.55,1201.62L774.55,1199.36L774.98,1197.03L774.09,1195.36L775.71,1192.24L775.57,1190.87L768.06,1190.91L763.62,1189.5L763.04,1188.12L759.93,1189.09L760.21,1188.22L758.7,1184.48L756.65,1184.28L755.24,1182.77L752.4,1181.65L748.02,1175.92L746.49,1175.18L744.28,1175.46L739.98,1173.42L736.61,1173.47L730.31,1171.4L727.41,1171.98L725.42,1170.56L723.39,1171.31L719.42,1169.08L713.86,1170.99L711.4,1172.84L704.78,1175.67L703.78,1172.72L702.17,1173.66L700.88,1173.28L701,1171L699.22,1168.33L696.03,1165.92L694.33,1165.63L695.21,1163.94L691.35,1162.92L689.52,1163.08L687.65,1165.09L685.99,1162.48L684.97,1162.59L684.38,1165.18L683.81,1165.76L681.81,1165.4L680.37,1168.79L677.02,1168.61L677.05,1166.87L676.11,1166.42L673.66,1168.88L672.79,1166.65L667.95,1163.17L665.99,1166.11L661.35,1166.8L658.76,1164.7L660.39,1162.82L660.8,1160.97L657.27,1159.26L656.74,1155.54L655.04,1156.31L655.58,1158.46L652.92,1158.38L651.52,1160.19L650.21,1160.68L648.44,1159.24L646.11,1160.27L645.81,1156.81L642.96,1157.62L642.89,1156.82L644.09,1156.85L644.24,1156.26L641.44,1154.07L640.71,1154.39L640.78,1155.95L638.66,1155.4L636.94,1153.21L633.34,1153.36L633.02,1151.1L631.25,1150.58L629.35,1147.05L626.37,1144.9L625.35,1145.81L623.67,1144.92L622.53,1146.41L610.97,1150.61L607.18,1147.89L598.23,1147.07L594.09,1147.62L592.72,1148.94L591.62,1149.01L532.5,1149.1L532.5,1149.1L530.67,1107.65L527.84,1077.6L528.05,1074.02L523.6,1076.02L521.44,1079.24L518.19,1079.18L518.09,1080.87L515.97,1080.55L514.7,1082.03L515.86,1084.67L514.48,1086.04L508.92,1087.35L502.19,1083.08L499.09,1084.26L493.6,1079.82L491.52,1081.04L493.28,1085.72L491.38,1086.35L490.42,1082.35L484.7,1077.71L483.32,1079.29L479.88,1079.93L477.49,1077.39L474.63,1080.45L472.62,1079.4L466.47,1078.87L462.12,1076.02L459.58,1077.6L454.92,1076.55L450.78,1076.65L448.98,1075.18L447.07,1075.49L444.63,1073.07L442.62,1072.44L439.12,1066.96L438.17,1048.19L433.29,1039.44L419.15,1025.35L417.18,1022.35L418.14,1009.8L419.2,1006.95L419.2,1006.95L422.69,999.88L423.22,987.43L413.79,982.16L411.46,977.09L412.16,973.78L415.27,972.87L417.92,970.02L427.99,968.02L435.63,960.74L441.56,957.78L442.3,955.56L441.71,952.84L439.23,950.39L441.7,941.63L442.97,931.88L442.35,929.91L443.08,926.3L446.99,922.04L450.56,910.45L452.89,907.7L461.2,903.13L465.41,903.67L470.05,902.65L473.53,903.32L478.57,902.74L483.16,903.87L485.31,900.73L487.81,878.5L482.01,865.08L475.54,864.42L468.02,861.79L469.33,853.36L461.94,844.41L451.38,834.41L446.37,830.98L445.76,829.55L450.6,826.83L455.59,827.15L460.07,826.18L466.01,816.81L471.01,805.3L471.01,802.12L464.84,792.59L463.78,787.34L460,785.4L458.41,777.76L454.32,770.88L452.18,769.76L450.24,766.14L450.85,757.53L450.85,757.53L508.79,757.93L549.43,756.4L564.36,749.97L566.32,749.99L570.92,753.33L592.55,750.68L596.04,748.04L601.2,748.59L604.79,744.72L606.57,744.27L608.02,747.39L610.16,747.83L610.16,747.83z"
				},
				{
					"id":"CM-LT",
					"title":"Littoral",
					"d":"M95.28,960.89L96,962.2l1.66,0.31l1.23,3.02l-1.34,3.27l-1.2,0.91l2.75,0.17l1.46,1.25l-6.72,2.33l-4.35,-1.25l-3.69,-2.16l2.91,-3.63l0,0l0,0l0,0l-0.17,-0.35l-0.14,-0.5l3.75,0.29l1.2,-1.14l-0.14,-2.19L95.28,960.89zM103.86,959.75l0.74,0.28l-0.11,0.97l0.66,-0.68l0.71,0.68l0.54,3.47l-0.69,1.25l-2.6,-0.29l-2.72,-1.65l1.56,-2L103.86,959.75zM96.61,959.65l0.47,2.3l-0.91,0.08l-0.86,-1.65L96.61,959.65zM103.66,958.19l1.23,0.2l0.34,0.83l-1.37,-0.26L103.66,958.19zM101.2,957.93l2.03,1.91l-1.4,1.45l-1.23,-0.26l0.49,1.2l-1.31,0.85l-1.43,-0.8l-1.03,-2.11l3.26,-0.71L101.2,957.93zM100.8,955.65l1.29,1.45l-1.8,1.2l0.07,0.89l-1.42,0.2l-0.54,-0.54l0.09,-2.91L100.8,955.65zM97.77,954.57h-0.01l0,0l0.01,-0.02l0,0V954.57zM100.17,954.46l-0.46,1.08l-0.37,-0.71L100.17,954.46zM98.44,954.02l0.5,0.58l-0.83,1.22l-0.23,2.85l-2.48,1.32l1.24,-2.13l-0.28,-0.95l0.8,-0.17L98.44,954.02zM101.29,951.47l-0.89,2.05l0.06,-2.22L101.29,951.47zM101.26,949.73l0.91,1.12l-0.48,0.53l-1.17,-1.11L101.26,949.73zM102.09,950.21l1.05,0.81l1.46,-0.03l3.14,-4.27l-2.06,-2.69l0.54,-2.32l-0.99,-0.8l-6.01,1.43l-1.35,-1.52l-2.69,-0.27l-0.45,-1.7l1.95,-8.58l6.97,-11.32l-1.42,-3.27l0.46,-5.08l9.15,-15.46l3.71,1.15l2.77,-1.21l-0.22,-3.86l6.03,-7.5l1.15,-6.58l8.62,-8.99l-0.05,-1.88l-2.89,-1.37l0.11,-2.39l4.04,-8.47l4.65,-0.82l0.68,-1.37l-4.98,-8.89l-3.82,-2.89l-2.87,-10.49l0.44,-1.64l3.71,0.56l1.38,-0.56l3.59,-5.2h3.36l0,0l-1.29,7.21l0.48,1.56l3.47,0.92l2.21,-1.92l4.37,-0.12l2.66,2.68l2.18,5.15l-1.58,7.29l2.36,6.46l5.89,2.15l0.81,7.3l1.96,0.27l2.01,4.29l2.72,-0.14l3.3,-7.29l5.88,-3.43l0.43,-3.86l1.29,-1.72l5.59,1.57l7.71,-1.14l0.9,0.85l0.29,4.86l3.07,3.68l0.73,4.46l1.65,1.44l1.98,-1.13l1.32,3.56l4.02,0.7l0,0l-6.03,7.56l-8.92,6.49l-1.12,6.55l2.24,0.28l5.83,-3.71l3.95,0.09l2.24,2.09l-2.66,7.1l-1.82,0.42l-4.76,6.92l-1.66,6.87l1.02,2.02l2.65,1.19l2.45,-0.38l13.58,5.05l3.65,-1.11l2.53,-3.13l3.77,-1.38l1.6,-2.76l1.72,-0.71l1.52,3.53l1.82,0.4l3.14,-2.93l1.9,-7.04l2.2,-3.65l5.2,1.67l3.73,-2.34l1.57,0.69l0.5,1.31l-1.46,10.11l-1.48,1.16l0.5,3.71l4.37,4.87l0.45,2.64l2.89,2.3l0.2,2.73l3.95,3.84l2.74,4.74l3.98,1.99l1.54,1.53l-0.28,5.03l-7.69,1.37l-3.49,2.37l-6.43,2.24l-3.63,0l-4.21,1.46l-1.66,1.72l-3.42,-0.67l-9.58,3.73l-1.68,6.4l-3.49,4.31l1.54,10.85l-2.65,3.62l0.7,1.39l-3.07,1.81l-1.68,5.42l-1.96,-0.83l-2.35,-3.21l-11.35,-6.53l-5.45,1.81l-2.52,2.22l-1.26,4.87l-0.22,4.58l-2.44,2.51l-0.18,4.78l-4.29,7.74l-3.97,0.18l0,0l-0.22,-2.4l-2.79,-1.25l-2.1,-2.5l-2.94,2.09l-4.39,0.01l-6.74,9.44l0.23,7.93l-1.82,1.95l0.28,1.81l-1.82,4.17l-5.45,2.92l-3.63,3.61l-5,1.32l0,0l-0.38,-1.14l0.63,-1.51l-1.14,-2.16l-8.95,-10.41l-7.61,-7.51l-9.98,-7.51l1.4,-1.02l-0.8,0.28l0.6,-1.02l-0.63,-1.48l1.52,-5.01l-3.12,-6.35l-7.49,-11.87l3.4,2.31l1.83,4.73l5.63,0.51l0.74,-0.57l0.14,-2.08l-0.74,2.11l-4.12,-1.37l-2.4,-4.64l0.83,-1.14l-0.11,-2.08l1.29,-2.79l1.46,-0.48l3.37,2.33l0.17,1.11l0.66,-0.68l1.29,2.08l-0.06,-1.05l1.09,0.65l-0.55,1.23l0.89,1.17l0.26,3.19l-0.63,1.76l-2.26,1.62l1.57,1.11l0.11,1.62l1.23,0.68l-1.52,-3.68l1.26,-1.25l0.54,0.63l0.71,-2.16l0.46,-0.2l-0.8,-1.17l0.11,-2.08l-1.66,-3.76l0.6,-1.22l1.12,-0.43l0.37,-1.79l-3.23,-4.16l2.92,-1.05l-0.97,-2.39l-1.57,0.74l-4.69,-0.09l-1.06,-0.77l-0.23,-1.51l0.23,-0.94l1.09,0.6l-0.17,-1.34l2.54,-3.84l2.03,1.42l1.97,-0.34l0.23,0.74l2.26,0.94l-2.46,-2.05l-1.71,0.45l-1.44,-2.21l0.23,-0.91l0.8,0.77l0.37,-0.6l-0.94,-0.29l2.6,-3.05l-4.46,0.8l0.26,0.63l-2,2.33l-1.34,0.03l0.31,0.91l-5.03,1.51l-1.6,-1.14l-0.11,-0.74l-0.06,-0.44l1.23,-2.55l-1.74,1.48l0.09,2.28l-0.6,0.11l-1.03,-0.43l-0.09,-0.6l-1,-0.03l-0.23,-1.45l-0.8,0.09l-0.92,-1.4l-0.63,-0.26l0.83,-1.68l-0.77,-0.06l-0.69,1.31l-1.09,-2.56l0.97,-1.62L102.09,950.21z"
				},
				{
					"id":"CM-NO",
					"title":"North",
					"d":"M729.26,585.63L729.73,587.33L727.79,591.16L728.36,592.63L721.04,599.38L720.46,601.34L717.23,604.01L716.58,606.64L715.51,606.89L713.8,609.14L716.35,611.5L717.02,613.52L713.15,614.36L705.92,621.27L704.07,621.61L698.18,626.16L698.18,626.16L693.64,624.64L688.76,625.82L682.7,632.56L678.16,635.25L672.11,635.25L654.44,643.34L650.74,643.51L641.49,649.4L634.76,650.75L631.9,649.23L630.05,646.37L624.9,645.75L620.49,637.24L608.62,637.69L600.1,636.34L601.41,631.6L601.41,627.01L600.42,622.25L598.95,620.12L594.53,618.64L590.6,611.91L587.81,609.78L588.14,606.66L581.75,603.05L580.93,596.65L578.8,594.68L560.73,593.11L555.24,591.09L554.78,589.83L555.28,585.97L554.63,584.16L553.52,583.6L543.27,585.12L541.41,586.37L537.25,586.88L531.44,585.61L525.13,589.03L521.73,589.66L519.96,591.18L518.95,593.83L517.44,593.96L513.65,591.3L512.64,589.53L507.34,587.64L502.93,582.33L497.25,580.68L493.71,580.81L491.13,583.06L490.39,585.74L490.89,589.92L489.64,591.92L488.15,591.3L476.89,591.55L469.96,590.49L461.05,586.44L444.64,584.34L425.72,575.79L425.18,569.11L426.52,564.57L423.85,558.42L418.8,558.48L410.49,556.56L405.73,553.07L396.28,544.11L386.83,532.9L386.83,532.9L386.95,527.16L384.93,516.52L385.67,511.13L387.92,506.4L392.18,505.28L393.75,506.18L395.99,506.18L398.91,503.93L399.72,501.02L402.8,500.42L403.93,498.53L403.17,494.91L400.48,490.86L400.7,488.6L403.39,487.93L406.31,488.6L410.36,485.94L419.68,488.77L421.05,488.57L426.7,483.97L430.33,483.66L431.98,480.58L433.61,479.36L433.86,474.81L434.83,472.98L437.25,472.08L441.12,472.37L442.92,470.52L445.11,463.35L445.79,454.33L447.65,449.44L446.46,439.85L448.48,435.33L449.15,431.27L452.01,426.2L452.28,424.04L453.49,422.88L453.34,410.45L452.53,409.76L448.59,409.31L448.43,407.07L454.7,403.78L460.95,398.14L463.65,397.67L468.21,394.08L481.06,392.8L482.73,392.22L484.37,390.52L485.96,390.73L488.9,384.34L488.19,383.29L488.55,380.95L488.01,379.66L489.8,377.21L489.35,375.37L490.24,373.23L490.46,369.48L494.06,364.33L492.38,361.69L487.91,359.49L486.75,356.82L486.8,353.88L489.87,351.58L491.78,347.01L491.73,345.96L489.16,343.26L488.91,341.62L495.87,331.84L497.39,331.17L500.81,331.22L504.07,330L504.07,330L507.4,336.77L510.39,336.87L512.43,335.5L515.64,334.94L521.05,335.86L526.11,332.78L532.56,331.36L533.36,330.32L533.24,329L530.69,326.9L530.01,324.67L531.88,320.55L534.26,319.52L546.07,321.84L551.95,320.72L555.18,322.27L560.61,322.54L562.5,323.47L564.13,324.69L566.26,328.62L569.3,330.12L572,334.27L576.38,333.38L586.56,337.52L587.36,339.91L586.13,346.88L586.13,346.88L584.62,353.61L583.52,355.31L574.09,367.47L570.3,370.51L568.9,373.81L568.6,379.89L571.14,382.15L572.72,385.89L580.32,394.3L583.52,396.7L586,397.41L586.58,400.32L589.49,401.84L592.12,406.39L594.88,408.27L599.01,408.96L602.83,415.08L606.04,417.06L606.76,419.2L605.29,423.94L605.53,426.56L610.63,431.25L612.23,433.87L617.11,437.44L616.21,439.63L618.83,443.6L623.95,445.72L636.54,458.41L640.2,461.12L643.91,465.57L645.24,466.29L649.59,466.55L651.07,467.53L653.85,467.37L656.27,465.99L658.77,466.73L659.72,469.38L661.59,470.87L660.08,472.25L661.52,473.13L664.24,473.09L666.87,474.54L668.16,476.14L667.56,479.27L668.08,480.34L672.83,481.04L676.82,483.01L679.84,487.63L681.04,490.94L690.61,500.25L692.11,502.65L692.7,505.66L697.9,514.71L699.29,519.61L710.27,541.26L709.52,546.14L710.37,548.7L712.81,551.66L717.54,564.44L721.86,571.41L730.13,573.47L730.77,574.37L730.12,576.77L730.86,582.36z"
				},
				{
					"id":"CM-NW",
					"title":"North-West",
					"d":"M172.56,659.63L173.48,663.81L175.67,666L179.37,667.52L199.89,666.17L205.44,666.51L206.96,665.67L206.77,661.94L209,661.25L210.46,659.59L212.78,649.57L212.65,644.76L213.65,637.23L214.62,637.18L216.66,639.03L217.32,642.51L216.45,645.71L219.53,648.34L221.97,648.93L222.64,648.17L224.71,649.22L225.32,651.74L237.1,657.35L240.27,657.25L242.62,659.27L242.62,663.48L244.81,666.67L245.15,671.22L247.33,674.25L250.36,676.1L258.77,676.61L264.66,681.15L265.76,686.18L264.63,695.19L266.05,698.88L267.37,707.68L270.4,711.27L278.46,711.93L278.46,711.93L279.39,715.25L277.69,724.99L276.93,726.23L276.93,726.23L274.47,727.92L272.85,731.06L270.97,732.27L266.99,732.55L259.23,731.23L258.1,732.08L257.34,733.03L257.91,737.28L258.88,739.19L257.57,740.83L257.25,745.72L255.29,748.01L248.59,751.92L243.18,753.51L241.07,755.39L230.78,752.85L227.38,752.85L225.68,753.8L218.69,770.41L216.1,773.81L204.39,773.54L187.71,776.57L186.85,782.87L184.7,784.73L182.62,783.88L180.12,781.15L172.25,778.62L166.48,783.32L164.11,783.56L164.11,783.56L155.45,782.04L152.44,780.58L148.77,781.7L146.58,784.14L140.91,781.25L133.76,779.16L129.68,776.62L127.95,773.8L125.97,772.23L122.38,772.92L117.98,768.06L114.97,766.56L112.94,764.58L115.56,759.15L113.13,755.9L112.79,752.2L120.44,748.3L124.38,744.23L126.62,737.52L129.17,732.87L127.95,729.41L129.17,719.82L126.31,715.95L127.66,711.88L128.02,707.15L124.37,703.64L124.37,703.64L126.85,694.41L128.56,689.71L129.55,689.1L130.02,687.32L129.41,683.94L130.04,680.96L131.32,679.34L130.82,678.03L132.31,674.49L133.65,675.5L134.8,675.02L136.3,675.87L139.97,676.02L142.19,677.23L149.88,669.52L151.73,666.46L155.78,663.61L156.86,661.74L170.5,649.44L171.97,649.96L171.86,651.31L173.07,651.92L172.17,653.28L173.58,656.7z"
				},
				{
					"id":"CM-OU",
					"title":"West",
					"d":"M276.93,726.23L279.77,727.64L284.31,728.01L287.53,729.24L288.47,731.68L288.17,734L286.78,735.07L286.49,741.93L286.96,744.11L289.52,747.42L290.46,750.35L287.06,756.96L284.99,758.83L284.99,758.83L284.99,758.83L284.99,758.83L285.6,763.71L284.78,767.65L285.66,769.7L286.15,776.24L289.82,778.57L286.33,783.55L278.82,790.23L279.49,792.75L277.48,796.75L279.63,804.48L277.48,811.49L276.22,811.88L275.58,813.43L277.52,815.56L276.82,819.05L272.59,822.63L271.23,825.42L268.27,826.32L265.68,828.83L266.19,831.27L265.09,836.75L265.78,839.26L260.77,840.59L256.89,845.68L253.07,862.25L248.54,865.59L244.26,864.9L237.28,857.1L235.51,857.56L232.09,861.78L220.93,867.69L215.2,869.64L207.65,868.4L207.65,868.4L203.63,867.7L202.31,864.14L200.34,865.27L198.69,863.83L197.95,859.38L194.89,855.69L194.6,850.83L193.7,849.98L186,851.12L180.4,849.54L179.11,851.26L178.68,855.12L172.8,858.55L169.51,865.85L166.78,865.99L164.77,861.7L162.81,861.43L162.01,854.13L156.12,851.98L153.76,845.52L155.34,838.23L153.16,833.08L150.5,830.4L146.13,830.52L143.92,832.44L140.44,831.51L139.97,829.95L141.26,822.74L141.26,822.74L143.52,821.28L146.3,816.67L148.39,815.16L149.32,812.69L150.09,801.74L151.19,799.54L157.47,795.58L161.29,791.77L164.06,791.15L166.61,789.33L166.24,786.79L164.11,783.56L164.11,783.56L166.48,783.32L172.25,778.62L180.12,781.15L182.62,783.88L184.7,784.73L186.85,782.87L187.71,776.57L204.39,773.54L216.1,773.81L218.69,770.41L225.68,753.8L227.38,752.85L230.78,752.85L241.07,755.39L243.18,753.51L248.59,751.92L255.29,748.01L257.25,745.72L257.57,740.83L258.88,739.19L257.91,737.28L257.34,733.03L258.1,732.08L259.23,731.23L266.99,732.55L270.97,732.27L272.85,731.06L274.47,727.92z"
				},
				{
					"id":"CM-SU",
					"title":"South",
					"d":"M419.2,1006.95L418.14,1009.8L417.18,1022.35L419.15,1025.35L433.29,1039.44L438.17,1048.19L439.12,1066.96L442.62,1072.44L444.63,1073.07L447.07,1075.49L448.98,1075.18L450.78,1076.65L454.92,1076.55L459.58,1077.6L462.12,1076.02L466.47,1078.87L472.62,1079.4L474.63,1080.45L477.49,1077.39L479.88,1079.93L483.32,1079.29L484.7,1077.71L490.42,1082.35L491.38,1086.35L493.28,1085.72L491.52,1081.04L493.6,1079.82L499.09,1084.26L502.19,1083.08L508.92,1087.35L514.48,1086.04L515.86,1084.67L514.7,1082.03L515.97,1080.55L518.09,1080.87L518.19,1079.18L521.44,1079.24L523.6,1076.02L528.05,1074.02L527.84,1077.6L530.67,1107.65L532.5,1149.1L532.5,1149.1L494.16,1149.12L494.29,1147.88L493.13,1147.26L494.95,1145.29L492.92,1140.98L490.76,1140.88L490.69,1139.87L489.32,1138.6L486.43,1140.03L484.73,1140.03L484.54,1139.16L483.46,1139.46L482.77,1138.72L483.71,1138.59L483.37,1137.77L482,1138.17L480.14,1137.51L475.17,1139.11L475.52,1140.85L473.78,1140.73L472.44,1142.3L471.31,1141.03L467.73,1142.37L467.14,1141.22L462.85,1141.08L460.52,1141.85L455.18,1140.7L454.73,1140.95L455.27,1141.66L453.13,1142.48L451.24,1141.47L450.28,1143.19L449.33,1143.19L448.51,1142.41L445.76,1142.03L444.91,1140.2L444.39,1141.14L442.39,1141.04L442.06,1142.15L440.41,1143.04L436.93,1143.73L433.68,1143.21L431.44,1141.77L428.31,1142.15L424.89,1141.56L423.43,1140.5L421.12,1140.5L420.75,1139.39L419.78,1139.04L416.46,1140.38L411.12,1139.89L407.12,1140.73L391.4,1138.21L390.41,1138.29L389.24,1140.25L385.33,1141L381.8,1137.97L377.75,1137.78L376.33,1138.7L373.34,1136.79L371.6,1137.99L365.95,1137.15L364.46,1137.69L361.9,1136.78L361.52,1137.6L359.59,1137.44L358.5,1136.75L353.63,1137.72L352,1137L351.09,1137.89L346.68,1137.59L346.33,1138.6L342.3,1137.38L342.07,1138.18L339.22,1137.69L337.95,1138.65L334.74,1138.61L334.18,1136.09L332.72,1136.35L329.06,1133.56L325.88,1133.63L323.79,1135.19L322.02,1135.07L320.52,1135.9L316.96,1134.63L314.86,1134.87L313.55,1136.02L309.49,1135.49L307.59,1136.36L304.6,1135.4L303.94,1135.54L304.53,1136.25L303.47,1136.6L302.17,1135.68L301.23,1136.23L297.74,1135.53L296.21,1135.95L295.04,1137.06L296.33,1138.3L295.84,1139.15L296.36,1139.93L293.54,1143.37L294.22,1143.91L293.57,1147.7L294.29,1148.75L280.97,1148.79L277.17,1147.42L274.63,1148.68L174.92,1148.87L172.31,1150.32L170.95,1148.61L169.21,1148.74L167.42,1150.19L160.8,1149.6L159.99,1147.98L158.75,1150L146.89,1146.02L145.04,1146.95L144.23,1144.4L142.38,1142.81L138.89,1141.34L137.17,1136.8L137.36,1132.86L136.17,1130.97L135.92,1123.46L136.83,1121.3L135.75,1114.79L136.49,1113.4L136.4,1108.31L138.23,1103.16L138.86,1097.59L140.32,1094.91L140.06,1092.92L141.87,1091.08L141.89,1087.98L143.72,1084.62L142.52,1080.01L143.41,1076.17L144.12,1075.92L144.04,1072.45L144.92,1069.09L146.9,1064.71L149.79,1062.78L151.27,1057.94L150.9,1056.21L152.02,1055.24L146.47,1041.41L144.1,1037.4L144.1,1037.4L149.1,1036.08L152.74,1032.46L158.19,1029.54L160,1025.37L159.72,1023.56L161.54,1021.62L161.31,1013.69L168.05,1004.24L172.44,1004.23L175.38,1002.15L177.47,1004.65L180.27,1005.9L180.49,1008.31L180.49,1008.31L178.73,1010.77L180.86,1014.81L184.32,1028.01L192.98,1026.76L216.98,1019.47L237.42,1014.39L239.46,1015.53L241.31,1021.16L242.56,1022.23L251.39,1019.81L253.77,1019.95L255.02,1021.9L256.84,1022.28L260.74,1021.23L263.97,1023.7L266.06,1026.48L268.02,1036.63L270.4,1039.48L272.77,1039.83L273.47,1041.64L273.33,1044.56L276.82,1047.2L279.34,1050.54L287.16,1049.56L291.36,1050.81L298.06,1048.87L312.73,1049.7L317.21,1048.87L327.13,1044.56L329.5,1042.32L331.32,1035.24L333.98,1032.74L335.78,1029.34L337.89,1028.99L340.29,1026.44L346.06,1024.57L348.5,1018.03L350.94,1017.29L352.63,1019.4L354.66,1020.36L356.34,1019.61L358.25,1020.14L359.84,1022.67L373.62,1028.15L374.47,1029.52L373.3,1031.74L373.3,1033.32L374.36,1033.63L378.18,1031.21L381.78,1031.84L383.9,1029.52L387.19,1015.92L392.38,1010.54L405.21,1000.3L407.75,996.08L409.76,995.56L412.2,996.08L416.24,1004.31z"
				},
				{
					"id":"CM-SW",
					"title":"South-West",
					"d":"M5.84,882.94l0.25,1.49l0.6,0.67l-0.31,0.79l-1.6,-2.17l0.09,-1L5.84,882.94zM7.38,908.34l0.2,-1.68l-1.6,-0.43l-0.51,-1.37l1.04,-0.88l-2.45,-2.73l-1.26,1.08l-0.23,2.08L0,904.92l0.23,2.59l1.26,3.02l3.09,0.14l1.26,-1.48L7.38,908.34zM4.6,891.75L4,891.27l-1,0.6l-0.29,1.34l1.09,0.32L4.6,891.75zM21.73,909.22l1.57,0.17l-2.95,2.85l-14.38,-0.4l1.69,-2.45l1.54,0.48l1.69,-0.71l-0.09,-1.03l-0.34,0.83l-1.12,0.62l-1.34,-0.74l-0.2,-2.42l-1.49,-0.4l-0.57,-1l1.17,-0.91l-0.42,-0.75l0.02,-1.42l-0.89,0.54l-1.29,-1.48l4.72,-2.99L8,895.53l-0.56,-1.84l0.41,-1.34l-2.12,-1.02l3.06,-1.54l-1.12,-2l2.54,-0.66l-0.07,-1.45l3.4,-0.68l-0.18,1.08l0.9,0.51l-0.38,5.22l1.83,1.97l0.89,2.22l0.63,6.55l1.17,2.94l-0.74,1.03l-2.35,-0.85l1.77,1.42l2.63,-1.17l2.63,2l0.11,1.11L21.73,909.22zM4.15,899.73l4.43,-1.97l-1.63,-3.33l0.33,-1.87l-2.16,-0.7l-0.93,1.95l-2.61,-0.15L0,898.71l1.77,2.96L4.15,899.73zM96.1,954.09l-0.47,1.04l-1.16,0.28l0.54,2.82l1.4,-0.43l-0.29,-1.05l0.83,-0.11l0.82,-2.05l0,0l0.01,-0.02l0,0l-0.02,-1.16l-0.48,0.94L96.1,954.09zM164.11,783.56l2.13,3.23l0.36,2.54l-2.55,1.82l-2.77,0.61l-3.82,3.81l-6.27,3.96l-1.1,2.2l-0.77,10.96l-0.93,2.47l-2.09,1.51l-2.78,4.61l-2.26,1.46l0,0h-3.36l-3.59,5.2l-1.38,0.56l-3.71,-0.56l-0.44,1.64l2.87,10.49l3.82,2.89l4.98,8.89l-0.68,1.37l-4.65,0.82l-4.04,8.47l-0.11,2.39l2.89,1.37l0.05,1.88l-8.62,8.99l-1.15,6.58l-6.03,7.5l0.22,3.86l-2.77,1.21l-3.71,-1.15l-9.15,15.46l-0.46,5.08l1.42,3.27l-6.97,11.32l-1.95,8.58l0.45,1.7l2.69,0.27l1.35,1.52l6.01,-1.43l0.99,0.8l-0.54,2.32l2.06,2.69l-3.14,4.27l-1.46,0.03l-1.05,-0.81l0,0l-0.43,-0.88l-1.32,0.63l-0.86,2.19l0.31,1.68l-2.06,-0.68l-0.66,0.97l-1.09,-0.4l-0.54,1.25l-1.14,0.26l-0.2,1.22l-1.52,0.25l0.03,-1.33l-1.4,0.11l-1.03,0.77l-0.37,1.48l-3.37,2.56l-1.74,0.34l-0.89,1.11l-1.46,-0.2l-1.29,2.79l-1.97,-0.17l0.43,1.31l-1.54,0.11l-0.34,1.51l-0.97,0.6l-1.09,-0.6l-0.23,-1.48l-1.49,-0.43l0.17,1.4h-0.92l-0.49,-1.22l0.71,-2.11l-0.74,-1.34l0.77,-0.29l-1.17,-1l-5.2,0.37l-0.2,-0.77h-1.23l-1,0.97l-2.2,-0.94l-3.06,-3.05l-5,-2.59l-1.17,0.34l-0.34,-1.05l-3.6,-2.08l1.17,-2.19l-0.23,-3.25l1.31,-2.96l-0.26,-1.51l-2.46,-4.61l-3.97,-2.02l-0.26,-1.45l-1.69,-1.51l0.92,-3.59l-0.4,-1.99l-0.57,-1.25l-1.86,-1.05l-1.63,-4.47l0.2,-3.08l2.2,-1.6l-0.83,-0.51l-0.43,-1.71l2.29,-2.79l-1.12,-0.77l-0.91,0.54l-1.29,-1.31l0.29,-6.47l-1.06,-1.25l-0.14,0.66l-1.12,-0.68l-2.46,-3.7l-0.77,0.63L32.97,897l0.69,-4.39l-1.34,-0.31l-0.8,1.48l-4.29,1.68h-2.03l-0.92,-2.68l3.06,-6.9l-0.94,0.74l-2.63,5.79l1,3.19l2.15,0.54l0.09,2.39l3.75,6.38l-0.97,1.8l-2.03,0.48l-2.83,-3.02l-2.03,-0.49l-1.86,-1.54l-0.37,-4.3l-2.23,-3.11l3.37,-2.34l0.31,-1.74l-1.17,-1.82l1.12,-0.29l0.51,-1.42l-2.03,1.77l0.86,1.88l-1,2.51l-2.03,0.34l-2.92,-2.08l-0.66,-3.65l0.29,-0.54l1.97,0.23l0.89,-2.48l-0.73,0.23l0.33,-1.33l-0.69,0.82l-0.12,2.21l-2.82,-1.25l0.51,-1.47l-4.55,1l-0.71,1.75l-2.09,-0.61l0.31,2.08l0.72,0.94l-1.29,1l-1.74,-2.85l0.26,-2.48l0.89,1.77L7.09,886l0.09,-2.31l-0.77,-0.09l-0.43,-1.45l-1.12,0.4l-1.14,-0.8l2.16,-3.67l3.55,1.39l4.02,-2.44l-0.56,-2.55l-2,-1.9l0.03,-1.58l1.71,-2.08l3.28,-1.24l-0.16,-2.93l1.67,-0.65l-0.08,-0.94l1.62,-2.06l1.51,-0.57l-1.61,-1.69l2.07,-1.73l2.03,-5.49l2.24,-1.73l0.14,-1.39l3.14,-1.29l4.23,-6.98l-0.25,-10.91l3,-9.78l-0.34,-6.47l1.86,-2.25l1.07,-4l3.99,-6.73l-0.51,-2.93l-8.49,-9.39l-0.08,-2.48l0.95,0.96l2.44,-3.11l0.75,-1.61l-0.67,-1.37l1.74,-2.47l-2.26,-1.74l-0.67,-1.42l2.16,-2.47l2.81,-1.45l2.73,-3.82l1.87,-0.55l6.34,-4.54l14.51,-12.91l1.64,-1.62l1.57,-4.17l1.99,-1.95l2.71,-1.99l5.38,-1.56l4.65,-8.07l1.8,-1.57l-0.28,-0.78l1.25,-0.43l0.04,-3.29l1.3,-3.06l8.56,3.67l3.33,-13.8l6.38,0.73l5.83,-2.95l0.19,-3.69l1.29,-2.37l3.53,1.22l1.73,-0.55l0.19,-0.71l1.71,2.19l3.93,-0.39l0,0l3.65,3.51l-0.36,4.73l-1.34,4.07l2.86,3.87l-1.22,9.58l1.22,3.47l-2.55,4.65l-2.24,6.71l-3.93,4.07l-7.66,3.9l0.34,3.7l2.43,3.25l-2.62,5.43l2.03,1.98l3.01,1.5l4.4,4.86l3.59,-0.69l1.98,1.57l1.72,2.82l4.09,2.54l7.15,2.09l5.67,2.89l2.19,-2.43l3.67,-1.13l3,1.46L164.11,783.56zM91.05,957.56l1.17,-0.4l-0.03,-1.53l-1.83,0.86l-0.22,1.34l-0.62,0.34l0.56,0.58L91.05,957.56zM94.45,956.82l-0.95,0.01l-2.22,0.9l-0.77,1.54l-1.29,-0.55l-4.55,2.83l3.87,3.8l3.57,0.19l1,-0.8l-0.43,-2.17l2.26,-1.85l0.66,-1.88l-1.09,-0.77L94.45,956.82zM35.86,901.64l-3.35,-4.39l0.26,-4.7l-1.23,1.54l-3.75,1.23l-0.03,2.65l2.75,4.13l4.23,3.39l0.23,1.25l2.72,1.37l0.29,-1.51l-1.29,-2.51L35.86,901.64zM84.3,962.4l-1.74,0.94l-0.72,2.05l1.09,2.08l2.69,2.5l0,0l2.69,-3.67l0,0l-0.11,-0.85L84.3,962.4zM32.4,914.15l-0.11,1.4l1.32,-1.03l-0.17,-1.37L32.4,914.15z"
				}
			]
		}
	}
};
