﻿// (c) ammap.com | SVG (in JSON format) map of Burundi - Low
// areas: {id:"BI-BB"},{id:"BI-BL"},{id:"BI-BM"},{id:"BI-BR"},{id:"BI-CA"},{id:"BI-CI"},{id:"BI-GI"},{id:"BI-KI"},{id:"BI-KR"},{id:"BI-KY"},{id:"BI-MA"},{id:"BI-MU"},{id:"BI-MW"},{id:"BI-MY"},{id:"BI-NG"},{id:"BI-RT"},{id:"BI-RY"}
AmCharts.maps.burundiLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"29.000204",
				"topLatitude":"-2.309240",
				"rightLongitude":"30.850462",
				"bottomLatitude":"-4.470164"
			}
		},
		"g":{
			"path":[
				{
					"id":"BI-BB",
					"title":"Bubanza",
					"d":"M181.23,302.97L179.96,305.7L176.7,308.66L177.32,311.25L176.61,311.95L184.73,319.14L185.6,322.27L184.89,323.6L183.55,323.27L182.07,324.56L181.56,329.6L179.13,333.3L178.52,337.93L175.56,341.39L174.38,345.08L172.95,346.11L172.76,349.2L173.6,349.62L170.52,354.46L166.12,354.33L166.12,354.33L161.83,349.55L158.13,352.68L155.69,352.04L153.93,353.75L152.09,353.92L149.08,353.12L143.22,353.4L137.69,356.94L137.1,351.7L114.25,354.62L108.87,358.64L106.35,358.71L102.37,362.2L99.05,362.73L96.97,364.31L92.26,372.65L86.9,367.76L86.16,363.69L83.52,360.32L83.58,359.13L82.37,358.94L82.55,356.38L79.37,356.2L79.37,356.2L76.5,352.85L76.22,347.67L74.6,344.33L74.89,341.02L77.4,337.72L75.25,333.75L74,333.83L73.39,332.69L74.33,329.16L76.39,328.27L74.09,326.95L76.81,322.51L75.42,321.09L75.46,319.81L79.12,316.52L79.23,313.44L80.6,313.16L81.02,309.68L81.45,308.2L83.38,308.62L84.66,305.81L86.09,305.41L82.74,303L83.4,300.95L85.01,301.06L85.01,301.06L88.08,300.79L90.44,301.78L91.99,300.19L95.33,300.74L97.66,299.42L96.5,292.38L97.49,288.96L98.65,288.98L95.75,283.94L95.44,278.21L97.77,277.11L100.1,273.88L99.97,270.48L102.69,270.38L104.84,269L107.66,270.5L112.48,267.3L113.87,268.31L116.91,267.56L118.17,265.83L116.71,262.38L119.03,253.87L121.46,252.71L122.34,250.98L123.54,251.25L126.36,249.67L130.59,250.06L131.7,251.38L131.41,253.21L132.26,253.58L132.48,255.81L134.19,255.43L135.26,256.39L136.07,253.71L139.88,252.89L141.61,249.59L147.71,246.96L151.71,247.47L155.48,246.48L157.56,247.46L158.08,242.48L160.4,240.09L160.4,240.09L165.95,239.76L167.07,242.26L169.51,243.6L167.67,249.07L168.62,250.43L168.16,253.33L169.82,258.4L171.6,260.55L172.75,264.35L171.9,266.37L174.45,273.9L178.8,279.34L177.4,282.24L179.6,283.63L180.32,285.89L179.77,287.1L183.31,292.24L183.29,294.06L182.07,295.68L182.85,297.79z"
				},
				{
					"id":"BI-BL",
					"title":"Bujumbura Rural",
					"d":"M166.12,354.33L167.85,356.75L167.93,358.8L172.77,363.22L173.91,369.04L176.44,372.48L172.52,379.4L174.99,380.72L176.16,383.45L181.97,388.86L184.94,399.01L185.95,399.02L188.44,394.83L192.24,393.49L192.24,393.49L195.52,396.98L191.72,404.05L192.48,406.05L190.96,411.33L193.18,413.24L193.5,415.99L197.64,419.68L197.91,422.59L197.56,423.77L193.11,426.96L191.96,429.23L191.29,439.91L194.76,440.86L194.09,446.72L193.12,447.45L189.79,446.4L187.18,451.26L187.18,451.26L184.16,451.79L181.22,454.52L181.5,458.23L176.25,462.51L175.64,467.04L170.94,474.07L171.02,476.62L169.68,478.78L169.23,486.67L167.49,489.55L164.13,489.84L162.86,491.08L161.58,494.24L163.8,497.41L162.87,500.92L159.1,501.82L157.83,499.81L156.52,502.07L155.03,501.81L154.01,503.63L150.81,503.73L149,503.12L148.53,501.11L147.73,500.92L143.77,502.72L142.5,505.4L140.39,505.81L139.58,506.99L137.47,506.09L137.19,504.83L135.14,506.04L131.68,505.19L127.66,506.19L125.89,505.21L103.16,508.36L103.16,508.36L102.62,503.31L105.92,499.6L105.88,496.46L109.66,488.67L109.81,485.89L111.66,482.13L111.01,480.61L112.44,477.7L113.2,470.83L114.91,469.51L114.39,468.3L115.52,465.8L113.43,459.82L113.49,457.11L115.14,455.83L115.66,451.89L113.56,449.82L111.51,442.97L112.44,439.05L111.38,436.8L113.95,430.7L110.59,426.9L110.59,426.9L115.77,426.57L120.48,424.37L122.15,425.37L124.06,425.15L123.27,424.78L122.56,420.6L123.76,418.99L124.02,416.14L122.22,414.21L123.41,407.49L127.44,408.3L131.11,407.14L128.44,405.34L126.35,405.53L126.96,403.39L126.26,402.4L127.95,402.07L126.48,398.84L127.05,397.62L128.93,397.22L132.59,398.26L133.4,399.59L132.71,396.17L133.66,395.39L132.47,392.29L133.33,392.47L134.86,387.13L134.3,381.32L136.02,378.56L139.07,377.11L138.79,375.86L140.72,374.45L137.94,372.65L129.84,370.35L125.81,371.1L114.48,368.99L113.19,368.99L109.19,374.24L106.71,367.39L102.76,367.97L104.8,382.24L95.15,381.36L96.16,382.18L96.16,382.18L93.72,384.65L94.77,384.98L93.72,386.06L89.02,384.65L88.37,385.34L74.43,384L84.39,383.6L85.92,381.99L85.11,380.39L77.78,380.55L77.49,382.24L73.35,380.22L70.73,381.22L69.86,379.09L72.34,376.22L69.98,370.11L69.9,365.41L72.72,363.69L74.85,363.53L75.22,361.13L78.85,358.85L78.25,357.09L79.37,356.2L79.37,356.2L82.55,356.38L82.37,358.94L83.58,359.13L83.52,360.32L86.16,363.69L86.9,367.76L92.26,372.65L96.97,364.31L99.05,362.73L102.37,362.2L106.35,358.71L108.87,358.64L114.25,354.62L137.1,351.7L137.69,356.94L143.22,353.4L149.08,353.12L152.09,353.92L153.93,353.75L155.69,352.04L158.13,352.68L161.83,349.55z"
				},
				{
					"id":"BI-BM",
					"title":"Bujumbura Mairie",
					"d":"M110.59,426.9L109.83,423.44L111.85,422.12L113.65,418.08L113.31,411.99L114.61,409.36L112.8,406.14L113.2,401.74L115.26,399.78L114.82,397.55L115.78,396.19L115.69,394L112.9,390.3L111.62,389.91L112.63,389.28L112.83,387.58L111.81,386.18L108.36,385.67L107.6,384.54L102.39,382.76L96.16,382.18L96.16,382.18L95.15,381.36L104.8,382.24L102.76,367.97L106.71,367.39L109.19,374.24L113.19,368.99L114.48,368.99L125.81,371.1L129.84,370.35L137.94,372.65L140.72,374.45L138.79,375.86L139.07,377.11L136.02,378.56L134.3,381.32L134.86,387.13L133.33,392.47L132.47,392.29L133.66,395.39L132.71,396.17L133.4,399.59L132.59,398.26L128.93,397.22L127.05,397.62L126.48,398.84L127.95,402.07L126.26,402.4L126.96,403.39L126.35,405.53L128.44,405.34L131.11,407.14L127.44,408.3L123.41,407.49L122.22,414.21L124.02,416.14L123.76,418.99L122.56,420.6L123.27,424.78L124.06,425.15L122.15,425.37L120.48,424.37L115.77,426.57z"
				},
				{
					"id":"BI-BR",
					"title":"Bururi",
					"d":"M238.56,482.58L242.73,482.44L245.44,483.43L247.65,483.08L250.1,480.16L252.41,480.73L254.44,483.91L257.42,485.49L258.09,487.43L256.83,489.73L256.9,491.56L258.2,493.18L256.19,499.46L254.52,510.58L254.58,516.76L252.09,519.8L251.78,527.04L249.61,530.59L249.99,532.91L248.61,535.42L248.37,539.11L251.29,538.96L254.8,540.19L257.7,538.81L261.27,533.22L264.72,530.21L267.97,524.3L267.26,522.63L267.98,522.01L266.84,520L268.59,518.95L270.54,519.15L271.61,517.87L272.69,511.46L275.26,507.13L276.92,506.66L277.48,509.18L276.82,512.49L281.52,514.37L283.33,516.13L282.42,519.34L283.09,521.67L281.27,523.74L281.85,525.29L285.01,525.29L284.88,528.71L293.37,531.45L297.58,531.34L298.98,535.42L302.41,536.21L302.93,537.69L302.93,537.69L300.93,538.92L299.73,541.55L294.36,544.93L297.64,548L296.5,550.14L297.86,550.85L299.42,556.48L293.37,557.49L292.11,560.49L291.11,570L289.38,570.46L287.15,573.64L284.37,582.95L282.9,583.01L278.2,591.04L277.54,595.63L274.92,597.06L274.92,603.19L269.41,610.55L269.41,610.55L266.2,607.71L263.73,601.83L262.45,601.79L261.11,599.92L258.11,601.33L253.77,597.82L251.18,602.86L248.87,603.63L247.27,602.84L245.45,613.78L242.46,618.57L239.46,617.34L233.24,618.39L230.91,620.75L228.76,621.41L225.2,619.89L223.3,622.52L218.47,623.76L216.46,628.89L211.62,635.57L209.93,639.66L208.3,641.09L207.23,640.78L205.62,644.05L203.14,644.58L200.39,647.44L195.03,646.8L193.83,648.73L190.68,648.16L188.11,650.07L184.08,648.37L178.65,651.5L177.51,654.26L178.38,657.16L177.5,659.88L177.5,659.88L171.43,656.23L168.24,651.79L168.03,644.42L163.72,635.51L161.46,627.87L157.26,623.45L155.93,619.32L152.95,617.78L151.39,610.88L149.08,608.42L146.4,602.65L144.74,600.98L140.91,599.47L140.84,595.58L143.93,590L143.67,588.18L140.77,584.87L136.78,583.31L137.13,581.6L135.21,577.42L135.25,572.2L132.71,568.75L132.13,564.92L128.96,562.88L124.52,553.2L120.25,548.47L120.87,546.66L118.27,540.31L114.92,538.07L114.15,536.25L114.55,532.53L112.49,528.8L112.02,524.75L109.28,521.5L110.58,520.05L109.28,513.97L107.58,511.25L103.16,508.36L103.16,508.36L125.89,505.21L127.66,506.19L131.68,505.19L135.14,506.04L137.19,504.83L137.47,506.09L139.58,506.99L140.39,505.81L142.5,505.4L143.77,502.72L147.73,500.92L148.53,501.11L149,503.12L150.81,503.73L154.01,503.63L155.03,501.81L156.52,502.07L157.83,499.81L159.1,501.82L162.87,500.92L163.8,497.41L161.58,494.24L162.86,491.08L164.13,489.84L167.49,489.55L169.23,486.67L169.68,478.78L171.02,476.62L170.94,474.07L175.64,467.04L176.25,462.51L181.5,458.23L181.22,454.52L184.16,451.79L187.18,451.26L187.18,451.26L188.24,452.81L196.12,454.05L196.6,456.26L198.52,458.3L202.7,460.72L202.98,467.08L207.7,472.89L210.46,473.45L212.49,471.74L214.3,472.71L212.87,474.57L213.94,476.21L213.8,478.73L215.7,479.64L216.17,481.92L220.61,483.29L224.32,482.1L223.79,489.74L221.7,491.38L222.74,494.74L219.58,499.42L221.28,504.65L225.22,503.02L231.68,497.77L232.94,494.47L234.62,492.83L236.27,486.75z"
				},
				{
					"id":"BI-CA",
					"title":"Cankuzo",
					"d":"M540.84,386.69L535.64,389.69L530.27,391.17L521.71,398.19L521.55,390.88L515.08,388.6L511.98,382.54L506.19,381.15L502.76,382.12L502.99,375.18L507.24,372.19L510.28,371.95L503.9,369.04L503.42,367.43L498.17,367.88L498.39,366.94L496.39,366.99L494.82,365.85L491.25,370.89L487.94,370.74L486.51,369.2L483.63,369.26L482.8,366.3L479.46,362.52L480.21,361.85L477.54,359.75L478.78,355.23L478.47,352.72L474.88,351.25L472.08,346.02L468.07,344.37L465.89,344.93L462.13,340.76L458.66,343.43L458.44,341.92L454.44,338.53L453.93,340.56L451.43,335.6L447.38,337.49L442.22,336.66L438.36,339.37L437.05,339.21L435.41,335.57L435.72,333.42L437.05,332.5L436.56,329.69L436.56,329.69L438.21,328.13L437.54,326.39L438.32,325.07L440.69,322.86L444.06,322.92L443.66,320.25L446.47,318.34L446.47,318.34L450.43,319.81L451.39,319.28L451.11,314.35L449.64,312.73L451.59,312.67L451.96,310.86L454.88,310.57L456.03,307.97L457.41,307.11L455.94,306.22L456.51,304.06L458.12,304.73L459.2,304.16L455.14,297.74L457.5,292.68L462.9,290.05L465.45,290.11L464.72,287.83L466.65,286.2L470.06,286.5L470.72,283.62L469.93,280.97L470.64,279.9L469.15,276.16L471.21,273.34L472.72,273.49L473.02,269.55L475.39,268.85L476.26,267.64L476.86,268.96L478.32,268.14L478.24,263.28L480.78,263.5L482.73,265L483.19,263.86L485.53,263.76L487.28,262.33L487.58,257.49L488.76,256.17L491.37,255.65L489.76,252.72L492.44,251.56L491.9,250.57L491.9,250.57L497.97,252.11L501.42,248.97L503.68,248.39L506.66,244.69L509.2,245.43L513.76,238.4L517.77,234.64L517.56,233.01L520.67,232.32L521.94,232.75L523.33,236.22L525.14,236.67L525.43,238.69L527.94,239.2L529.24,242.07L531.29,241.53L535.79,243.37L542.76,251L544.91,252.2L544.5,257.27L545.77,259.55L547.93,260.45L552.5,265.39L560.16,258.73L563.94,257.58L565.45,258.11L567.07,261.09L569.35,262.11L571.12,264.25L575.01,264.54L578.11,266.67L597.39,263.56L600.09,261.42L604.32,261.01L607.58,259.56L612,260.85L609.99,263.66L608.79,263.99L608.03,267.01L604.18,271.24L602.76,275.35L601,276.87L601.43,278.06L600.31,281.71L593.82,285.44L596.07,290.03L598.46,291.35L599.99,294.33L605.21,295.24L607.45,298.72L606.11,301.67L606.64,305.29L605.38,310.02L603.78,313.43L601.29,315.91L602.46,317.06L606.7,314.69L610.54,321.1L608.05,331.01L611.32,335.73L609.06,335.86L604.58,338.16L602.27,337.87L599.82,341.38L603.96,348.79L609.54,351.2L605.06,354.35L596.25,357.55L594.73,359.42L588.67,360.47L581.39,363.88L578.04,361.94L577.01,356.1L574.96,355.98L572.33,357.92L572.29,362.04L569.29,366.98L557.47,372.01L551.53,372.73L549.4,376.86L545.1,382.02L542.01,384z"
				},
				{
					"id":"BI-CI",
					"title":"Cibitoke",
					"d":"M142.24,203.19L143.27,204.37L142.97,206.12L146.52,205.76L149.78,210.68L149.42,214.46L151.06,216.62L150.41,217.99L151.03,221.14L154.45,225.78L153.5,227.78L153.93,229.47L156.29,231.41L156.72,235.5L158.41,236.65L160.4,240.09L160.4,240.09L158.08,242.48L157.56,247.46L155.48,246.48L151.71,247.47L147.71,246.96L141.61,249.59L139.88,252.89L136.07,253.71L135.26,256.39L134.19,255.43L132.48,255.81L132.26,253.58L131.41,253.21L131.7,251.38L130.59,250.06L126.36,249.67L123.54,251.25L122.34,250.98L121.46,252.71L119.03,253.87L116.71,262.38L118.17,265.83L116.91,267.56L113.87,268.31L112.48,267.3L107.66,270.5L104.84,269L102.69,270.38L99.97,270.48L100.1,273.88L97.77,277.11L95.44,278.21L95.75,283.94L98.65,288.98L97.49,288.96L96.5,292.38L97.66,299.42L95.33,300.74L91.99,300.19L90.44,301.78L88.08,300.79L85.01,301.06L85.01,301.06L81.4,299.05L83.79,298.72L83.15,297.06L84.81,296.53L85.08,295.1L83.57,293.21L84.25,292.55L85.62,289.96L84.38,289.99L84.3,289.09L82.5,288.2L82.46,287.29L84.11,286.92L83.14,285.75L83.91,284.77L79.14,281.24L79.67,279.6L77.22,279.33L76.42,278.32L77.94,275.95L75.61,276.23L74.27,274.37L72.65,275.18L66.41,274.85L63.7,270.54L61.09,270.57L61.13,267.76L58.53,265L56.22,266.68L54.74,265.26L56.58,261.7L54.71,258.08L55.68,257.06L54.83,255.91L55.38,254.32L51.12,251.79L50.41,250.11L49.71,250.89L47.06,250.11L46.08,247.85L43.61,246.53L42.39,244.57L40.33,244.86L36.25,242.14L34.48,243.01L31.88,241.46L29.28,235.12L29.57,231.47L31.03,228.88L30.62,226.83L29.67,225.17L28.32,225.91L24.84,222.78L22.84,222.93L22.36,221.64L23.15,220.77L21.61,219.62L22.64,218.07L19.91,215.78L19.61,213.1L17.02,210.49L16.47,208.36L9.08,210.53L7.39,208.87L3.39,208.27L0.46,205.14L0,198.51L0.71,195.61L8.73,188.59L12.54,188.63L13.37,177.69L18.13,172.41L18.01,170.89L16.16,169.51L17.07,168.33L16.43,166.53L17.91,166.34L17.79,165.28L15.48,164.62L18.41,163.27L18.72,161.62L15.13,159.32L17.83,153.07L19.95,152.32L17.56,149.16L17.07,144.1L17.39,142.22L19.07,141.61L18.98,139.38L20.32,136.5L23.8,137.02L26.65,134.24L30.63,133.03L31.8,134.7L35.9,134.04L38.27,134.77L42.19,139.17L44.5,137.35L46.5,137.16L45.78,135.46L49.56,132.98L50.1,134.41L53.8,134.24L53.8,135.82L55.84,136.84L55.96,138.17L57.6,139.31L57.7,141.03L61.78,139.14L62.48,140.28L65.3,141.67L67.34,140.86L69.12,143.18L70.44,142.75L72.47,144.52L72.77,146.4L74.81,144.2L76.19,145.39L77.7,144.93L77.85,143.88L79.02,144.79L79.28,143.93L80.71,143.39L81.7,143.11L82.73,144.77L86.95,141.85L88.66,143.69L91.19,143.28L97.22,149.18L103.08,150.6L105.72,153.08L107.29,152.85L110.87,158.88L108.25,165.17L108.93,165.9L110.4,165.47L113.8,169.66L115.68,169.03L115.98,172.97L115.04,175.33L116.25,176.83L116.5,180.39L110.27,184.53L112.84,186.17L111.85,189.91L113.79,190.17L114.79,191.49L115.93,191.13L115.11,194L116.98,196.11L118.03,199.51L116.32,201.24L116.4,202.97L119.69,207.75L119.27,209.42L120.61,210.67L119.83,212.42L121.5,212.14L122.6,214.7L124.38,214.14L124.27,212.13L125.47,211.91L128.66,207.72L130.77,207.03L132.09,208.8L134.68,206.46z"
				},
				{
					"id":"BI-GI",
					"title":"Gitega",
					"d":"M306.07,296.32L305.72,299.26L304.15,299.57L302.29,301.57L301.64,305.88L302.44,307.04L301.4,308.43L300.53,308.09L299.79,309.92L300.46,310.83L296.57,315.09L296.92,316.88L298.04,317.2L297.28,318.5L298.67,325.97L302.68,327.84L305.52,327.46L309.68,323.77L310.59,321.88L312.26,322.37L311.75,320.32L312.59,318.99L317.7,320.12L324.06,331.85L328.53,335.55L329.66,335.13L329.31,338.58L330.63,341.22L335.02,341.41L334.49,342.38L338.35,345.05L337.15,345.28L336.15,346.94L340.16,349.91L337.92,352.66L339.47,353.97L338.54,357.26L339.32,358.64L338.26,360.95L339.51,362.77L335.04,365.42L335.18,366.68L332.45,368.67L332.53,369.96L330.91,369.25L331.51,374.19L330.23,378.24L329.67,379.17L328.38,379.03L327.84,382.35L325.77,381.6L324.53,383.7L325.65,385.94L328.5,386.97L328.75,388.47L331.37,389.19L333.36,392.49L334.21,392.41L334.03,396.06L335.2,397.23L338.23,396.48L337.35,394.63L344.57,390.07L344.57,390.07L344.47,391.25L346.02,391.26L345.49,392.62L346.85,394.97L346.54,396.3L349.61,397.98L349.91,401.69L350.94,401.61L352.56,404.32L357.03,407.41L358.07,409.83L354.38,413.37L352.73,417.12L352.54,421.25L348.8,424.29L352.77,430.15L354.11,438L358.46,442.28L359,444.42L357.45,445.43L358.3,450.49L362.78,456.77L362.07,459.23L363.28,461.41L364.51,461.62L364.1,462.79L365.23,463.14L365.44,468.5L363.28,471.43L363.23,476.07L363.23,476.07L363.34,477.46L361.15,480.8L361.46,486.47L357.51,488.52L355.92,492.38L354.32,493.48L354.45,494.76L353.13,495.27L352.63,497.62L350.51,499.25L350.09,501.17L341.54,501.77L340.76,503.46L337.43,505.05L331.6,506.05L327.95,509.03L327.78,510.94L322.07,515.94L322.39,517.27L330.02,521.13L329.79,522.27L327.55,523.51L324.86,523.48L313.17,529.38L313.29,532.19L309.67,537.44L313.13,540.51L312.7,543.72L313.46,544.53L312.37,545.79L305.92,543.82L303.31,539.92L302.93,537.69L302.93,537.69L302.41,536.21L298.98,535.42L297.58,531.34L293.37,531.45L284.88,528.71L285.01,525.29L281.85,525.29L281.27,523.74L283.09,521.67L282.42,519.34L283.33,516.13L281.52,514.37L276.82,512.49L277.48,509.18L276.92,506.66L275.26,507.13L272.69,511.46L271.61,517.87L270.54,519.15L268.59,518.95L266.84,520L267.98,522.01L267.26,522.63L267.97,524.3L264.72,530.21L261.27,533.22L257.7,538.81L254.8,540.19L251.29,538.96L248.37,539.11L248.61,535.42L249.99,532.91L249.61,530.59L251.78,527.04L252.09,519.8L254.58,516.76L254.52,510.58L256.19,499.46L258.2,493.18L256.9,491.56L256.83,489.73L258.09,487.43L257.42,485.49L254.44,483.91L252.41,480.73L250.1,480.16L247.65,483.08L245.44,483.43L242.73,482.44L238.56,482.58L238.56,482.58L238.56,482.58L238.56,482.58L237.5,479.99L246.47,471.92L255.01,471.03L256.91,471.82L258.46,470.42L262.08,473.74L265.67,473.97L266.07,471.19L263.47,470.05L263.43,467.44L261.45,465.91L261.94,464.75L259.46,459.84L260.02,458.65L254.45,451.87L255.17,447.1L257.61,445.57L257.96,443.78L260.82,443.93L261.58,441.43L262.66,441.74L262.56,440.58L263.46,440.2L264.29,440.86L266.14,439.42L271.99,441.61L273.75,439.98L277.79,440.02L277.93,438.38L280.71,436.64L281.68,426.67L283.54,426.58L282.68,425.64L283.3,424.68L282,424.39L281.44,422.19L283.11,420.68L283.31,417.06L284.96,416.75L283.23,415.52L284.5,414.83L283.21,413.74L284.5,412.71L282.13,409.83L283.74,407.36L283.54,406.01L284.49,405.62L284.38,402.97L285.55,402.05L288.3,402.26L289.37,400.74L287.14,399.61L288.94,398.64L288.41,396.52L282.94,394.1L283.41,393.05L281.56,391.18L279.3,390.91L278.14,391.71L277.17,390.62L275.03,390.6L273.03,388.26L273.69,386.18L275.41,385.98L275.94,383.7L277.15,383.12L277.89,380.06L274.3,376.82L274.36,375.79L270.67,373.64L269.79,369.7L264.46,369.8L262.43,365.87L260.23,366.32L259.01,365.61L259.01,365.61L257.99,362.53L267.8,352.67L268.98,349.01L273.55,345.66L275.33,346.47L277.04,345.42L279.67,345.76L281.69,344.24L276.95,341.33L272,340.67L267.27,334.72L267.5,332.16L267.5,332.16L268.78,327.51L274.4,322.87L277.99,318.4L280.97,317.11L281.43,315.02L281.33,309.08L279.45,309.66L273.82,306.74L272,302.7L272.04,299.69L274.5,298.21L283.04,288.15L285.17,287.75L285.17,287.75L291.03,286.9L294.4,289.23L297.48,289.38L301.61,296.23L304.24,295.47z"
				},
				{
					"id":"BI-KI",
					"title":"Kirundo",
					"d":"M453.91,55.39L454.67,66L457.84,71.61L457.99,74.42L460.18,76.55L461.96,83.81L466.33,87.84L468.48,92.06L468.03,96.77L462.43,102.34L463.19,107.11L468.98,112.79L466.01,117.35L465.76,120.98L466.79,123.14L463.13,134.1L461.84,135.38L449.17,135.77L445.5,140.38L443.39,145.76L442.16,146.64L439.35,145.86L437.18,146.8L434.33,152.43L426.9,159.26L422.87,165.56L420.18,166.38L417.78,161.36L413.21,162.08L406.58,164.76L403.25,167.61L402.15,167.16L387.37,180.86L384.07,179.85L381.87,177.73L379.64,178.05L377.57,183.49L373.71,187.58L373.82,190.35L369.97,195.2L366.93,194.89L362.83,192.06L356.24,196.23L356.24,196.23L351.15,196.16L351.65,193.17L349.28,189.1L346.86,187.21L347.88,184.26L333.91,175.27L336.29,173.96L337.39,171.88L333.2,166.54L333.07,164.83L329.84,165.92L329.85,162.84L329.01,161.76L322.33,159.81L318.68,156.22L313.69,154.36L308.53,155.18L307.75,154.1L307.75,154.1L309.33,149.62L306.89,146.94L307.92,132.44L307.28,129.9L305.87,128.58L304.35,121.99L308.84,114.1L308.76,109.62L310.27,107.9L311.53,102.57L314.28,101.62L316.02,99.45L318.49,99.42L319.79,98.25L319.49,93.61L320.73,90.34L319.12,86.54L319.82,85.37L318.12,82.08L317.96,74.98L315.63,69.28L315.54,66.68L311.8,60.35L312.08,58.19L316.2,53.47L315.97,46.87L316.95,46.23L330.01,51.73L336.47,51.53L340.94,53.21L347.41,59.45L351.86,68.19L362.49,77.66L374.29,82.62L382.32,80.67L385.82,78.87L390.06,80.03L391.56,79.39L395.5,73.76L396.54,65.97L401.2,64.31L401.61,60.33L404.78,53.66L407.43,53.85L411.69,57L414.41,61.17L422.65,62.01L428.45,61.44z"
				},
				{
					"id":"BI-KR",
					"title":"Karuzi",
					"d":"M446.47,318.34L443.66,320.25L444.06,322.92L440.69,322.86L438.32,325.07L437.54,326.39L438.21,328.13L436.56,329.69L436.56,329.69L434.98,329.61L432.55,331.54L429.94,330.61L429.8,335.22L426.36,336.01L416.11,345.36L416.04,347.59L414.28,348.14L412.54,350.21L413.48,351.26L412.96,352.79L407.05,359.23L408.73,363.82L406.47,364.67L402.76,362.74L403.09,367.57L401.09,369.35L398.95,368.13L394.64,371.38L395.03,375.42L393.51,374.83L389.97,375.95L388.42,373.21L385.35,373L385.1,374.43L387.3,375.1L387.55,376.21L383.62,376.23L383.54,379.43L379.06,377.12L378.68,378.24L375.47,379.96L374.4,378.62L373.47,378.92L373.7,380.39L372.56,381.68L368.95,378.95L367.17,379.72L365.24,379.24L366.26,380.23L365.07,382.37L361.86,380.88L359.92,382.23L358.25,381.77L356.11,383.51L351.19,383.98L350.92,383.01L349.98,383.11L349.75,387.5L348.25,388.01L346.22,386.98L345.81,389.6L344.57,390.07L344.57,390.07L337.35,394.63L338.23,396.48L335.2,397.23L334.03,396.06L334.21,392.41L333.36,392.49L331.37,389.19L328.75,388.47L328.5,386.97L325.65,385.94L324.53,383.7L325.77,381.6L327.84,382.35L328.38,379.03L329.67,379.17L330.23,378.24L331.51,374.19L330.91,369.25L332.53,369.96L332.45,368.67L335.18,366.68L335.04,365.42L339.51,362.77L338.26,360.95L339.32,358.64L338.54,357.26L339.47,353.97L337.92,352.66L340.16,349.91L336.15,346.94L337.15,345.28L338.35,345.05L334.49,342.38L335.02,341.41L330.63,341.22L329.31,338.58L329.66,335.13L328.53,335.55L324.06,331.85L317.7,320.12L312.59,318.99L311.75,320.32L312.26,322.37L310.59,321.88L309.68,323.77L305.52,327.46L302.68,327.84L298.67,325.97L297.28,318.5L298.04,317.2L296.92,316.88L296.57,315.09L300.46,310.83L299.79,309.92L300.53,308.09L301.4,308.43L302.44,307.04L301.64,305.88L302.29,301.57L304.15,299.57L305.72,299.26L306.07,296.32L306.07,296.32L310.47,294.22L310.55,291.6L309.46,289.36L310.75,287.37L313.8,286.33L317.47,287L319.96,285.45L323.3,276.73L325.72,273.61L325.82,271.37L333.26,266.7L335.87,262.86L337.44,262.54L342.19,264.02L346.98,260.84L352.74,261.76L357.18,261.29L360.57,259.83L371.01,251.78L376.73,249.91L379.98,247.7L389.12,237.39L389.12,237.39L402.03,236.05L406.06,238.77L408.24,238.91L411.67,241.03L413.51,244.35L419.53,249.22L422.76,253.92L422.04,259.68L422.64,263.97L421.76,266.92L422.6,269.72L421.05,276.69L421.85,278.09L419.73,282.95L419.7,285.28L416.03,289.26L412.93,294.71L412.72,296.87L409.64,299.97L407.24,304.77L407.73,307.62L410.22,309.44L410.36,311.94L412.04,313.38L414.7,313.6L417.54,317.39L420.21,317.59L420.91,318.47L423.6,318.15L430.42,314.63L434.92,315.92L434.96,318.23L436.84,319.06L443.47,315.7z"
				},
				{
					"id":"BI-KY",
					"title":"Kayanza",
					"d":"M221.19,198.81L219.59,199.71L218.16,202.77L219.57,206.98L218.82,211.45L218.08,212.55L214.17,210.95L210.4,216.29L210.29,217.45L214.26,222.2L214.76,224.2L217.52,223.73L219.85,225.63L224.08,225.77L225.38,227.44L230.29,225.87L231.07,227L232.16,226.52L231.57,229.12L232.96,231.07L234.45,231.15L235.76,237.18L234.2,237.7L233.05,239.44L232.67,243.05L237.87,247.02L241.8,245.59L242.7,243.63L244.56,243.01L248.08,239.02L247.41,241.02L247.97,242.01L250.81,243.31L250.2,254.21L251.83,255.1L254.83,260.64L258.71,262.7L264.11,267.38L264.62,269.67L263.67,272.46L265.29,273.23L270.37,272.54L276.1,269.68L278.28,270.08L279.93,272.05L287.47,269.47L290.77,269.35L288.57,273.36L287.25,274.14L285.17,287.75L285.17,287.75L283.04,288.15L274.5,298.21L272.04,299.69L272,302.7L273.82,306.74L279.45,309.66L281.33,309.08L281.43,315.02L280.97,317.11L277.99,318.4L274.4,322.87L268.78,327.51L267.5,332.16L267.5,332.16L264.43,330.72L260.27,330.93L251.99,336.68L250.12,335.7L248.92,336.64L247.81,341.41L243.23,342.8L241.54,340.59L235.04,338.87L233.12,336.99L229.17,329.03L223.75,324.68L222.99,321.89L223.95,319.22L223.18,318.54L218.87,319.75L215.65,321.85L214.28,321.5L213.6,322.72L208.05,322.54L207.92,321.22L206.3,320.93L203.16,315.76L194.09,314.67L190.74,309.53L190,304.45L181.23,302.97L181.23,302.97L182.85,297.79L182.07,295.68L183.29,294.06L183.31,292.24L179.77,287.1L180.32,285.89L179.6,283.63L177.4,282.24L178.8,279.34L174.45,273.9L171.9,266.37L172.75,264.35L171.6,260.55L169.82,258.4L168.16,253.33L168.62,250.43L167.67,249.07L169.51,243.6L167.07,242.26L165.95,239.76L160.4,240.09L160.4,240.09L158.41,236.65L156.72,235.5L156.29,231.41L153.93,229.47L153.5,227.78L154.45,225.78L151.03,221.14L150.41,217.99L151.06,216.62L149.42,214.46L149.78,210.68L146.52,205.76L142.97,206.12L143.27,204.37L142.24,203.19L142.24,203.19L144.58,200.83L148.18,200.9L151.18,201.83L151.19,203.06L153.68,205.04L155.63,204.07L157.8,204.41L160.75,202.17L170.81,210.96L179.28,211.3L178.94,207.92L179.59,207.21L182.43,207.44L186,205.73L189.72,205.43L194.26,202.53L195.45,204.18L200.4,203.74L202.48,205.24L205.18,203.25L208.13,202.74L211.33,197.92L217.95,197.52z"
				},
				{
					"id":"BI-MA",
					"title":"Makamba",
					"d":"M269.41,610.55L270.45,611.29L270.63,613.98L272.58,614.75L269.99,617.34L269,620.95L271.26,622.02L270.93,623.43L274.54,624.22L276.17,623.16L279.4,623.65L278.54,622.26L280.03,622.92L280.51,621.64L281.32,621.72L282.27,623.07L284.02,621.66L286.07,621.9L286.1,620.99L287.68,620.43L288.41,621.9L287.66,622.5L288.8,622.81L288.01,623.75L290.8,624.2L290.33,625.22L291.81,625.83L291.15,627.12L292.56,627.32L292.7,628.46L297.09,627.49L299.01,625.76L299.77,628.69L301.1,629.05L301.11,626.87L303.3,627L303.03,625.34L305.25,624.45L309,624.84L310.04,623.47L312,624.51L311.56,625.56L312.72,626.06L312.94,628.81L315.69,627.88L317.38,628.29L321.09,625.19L322.24,626.85L323.15,626.89L323.92,625.26L324.95,626.52L326.38,626.31L329.19,624.83L329.73,622.34L332.71,622.58L336.78,619.39L336.49,617.72L340.18,617.64L343.05,615.96L344.5,616.12L344.22,617.13L345.83,618.08L346.96,617.25L347.79,618.15L349.11,617.33L350.95,617.89L354.27,617.15L358.89,617.96L363.29,620.3L365.61,620.06L370.78,617.02L372.51,614.59L374.84,613.41L375.12,612.12L379.14,610.03L382.47,610.2L389.06,616.86L390.33,616.83L393.13,613.48L393.83,613.92L393.83,613.92L394.14,614.65L392.81,615.66L393.03,617.78L391.25,620.5L391.51,622.54L389.97,623.79L389.46,625.62L390.13,625.23L390.33,626L387.45,628.03L387.21,629.64L384.17,632.46L383.26,634.85L380.16,636.11L374.83,641.21L373.92,640.53L371.6,641.61L371.64,643.27L369.82,643.49L368.04,646.38L366.66,647.3L365.03,646.9L362.03,649.39L359.02,649.73L356.36,653.85L355.91,655.75L354.43,656.95L354.13,661.42L351.55,663.09L349.63,669.92L348.2,670.33L349.5,672.76L348.83,676.53L346.47,676.46L346.29,677.13L347.81,677.32L347.22,678.56L348.6,681.59L347.42,682.51L346.21,681.13L345.18,681.43L346.37,682.49L344.68,688.12L342.79,688.31L340.99,686.8L341.02,688.13L338.97,689.51L338.63,688.08L337.41,687.79L335.93,688.36L336.11,690.01L335.15,690.8L331.94,689.41L330.29,695.62L329.35,695.51L328.86,693.52L327.99,696.5L326.45,694.62L325.25,695.74L320.57,696.84L318.56,703.42L311.69,708.9L306.98,709.97L306.92,711.11L302.32,712.06L301.59,713.14L300.34,712.9L298.15,713.22L297.97,714.26L295.48,713.11L295.26,714.08L292.59,715.38L292.57,718.67L291.86,718.92L291.3,717.74L288.88,718.46L288.25,720.56L289.59,721.37L289.13,722.54L286.67,723.41L286.23,722.41L281.49,722.67L278.82,718.98L275.61,718.22L273.25,715.82L270.61,717.76L269.26,717.02L265.31,723.23L263.18,729.38L258.99,733.39L256.35,732.84L255.8,734.72L253.06,737.72L252.58,744.96L254.39,747.08L251.71,750.6L249.26,751.71L246.07,750.53L245.65,747.76L243.27,747L240.07,749.14L237.32,746.87L233.81,749.22L231.28,748.22L228.48,745.29L227.13,745.84L222.83,744.15L218.86,744.46L220.31,742.21L219.19,737.5L220.7,733.41L218.84,726.45L214.93,721.94L209.69,717.93L198.96,712.23L196.72,711.91L196.98,709.88L192.9,704.39L193.42,700.93L189.08,696.87L186.68,691.16L186.14,689.03L187.32,683.19L184.57,680.96L184.23,678.1L180.58,675.19L181.76,671.73L180.26,669.01L181.2,665.29L180.91,661.39L177.5,659.88L177.5,659.88L178.38,657.16L177.51,654.26L178.65,651.5L184.08,648.37L188.11,650.07L190.68,648.16L193.83,648.73L195.03,646.8L200.39,647.44L203.14,644.58L205.62,644.05L207.23,640.78L208.3,641.09L209.93,639.66L211.62,635.57L216.46,628.89L218.47,623.76L223.3,622.52L225.2,619.89L228.76,621.41L230.91,620.75L233.24,618.39L239.46,617.34L242.46,618.57L245.45,613.78L247.27,602.84L248.87,603.63L251.18,602.86L253.77,597.82L258.11,601.33L261.11,599.92L262.45,601.79L263.73,601.83L266.2,607.71z"
				},
				{
					"id":"BI-MU",
					"title":"Muramvya",
					"d":"M267.5,332.16L267.27,334.72L272,340.67L276.95,341.33L281.69,344.24L279.67,345.76L277.04,345.42L275.33,346.47L273.55,345.66L268.98,349.01L267.8,352.67L257.99,362.53L259.01,365.61L259.01,365.61L256.72,366.59L255.6,371.76L256.67,374.79L256.3,377.9L253.8,380.52L254,382.47L251.9,384.79L252.24,386.78L250.55,389.69L249.71,389.87L249.1,388.52L242.69,384.22L236.82,386.74L230.99,400.92L223.44,401.16L223.05,402.67L220.68,403.84L219.62,407.06L218.12,407.88L214.87,407.76L213.87,406.18L212.43,402.07L213.8,399.01L212.01,393.05L209.66,393.48L207.01,389.94L204.8,390.59L204.63,384.65L202.64,384.11L201.22,384.88L198.52,384.22L197.24,382.8L192.28,382.47L191.36,386.8L192.24,393.49L192.24,393.49L188.44,394.83L185.95,399.02L184.94,399.01L181.97,388.86L176.16,383.45L174.99,380.72L172.52,379.4L176.44,372.48L173.91,369.04L172.77,363.22L167.93,358.8L167.85,356.75L166.12,354.33L166.12,354.33L170.52,354.46L173.6,349.62L172.76,349.2L172.95,346.11L174.38,345.08L175.56,341.39L178.52,337.93L179.13,333.3L181.56,329.6L182.07,324.56L183.55,323.27L184.89,323.6L185.6,322.27L184.73,319.14L176.61,311.95L177.32,311.25L176.7,308.66L179.96,305.7L181.23,302.97L181.23,302.97L190,304.45L190.74,309.53L194.09,314.67L203.16,315.76L206.3,320.93L207.92,321.22L208.05,322.54L213.6,322.72L214.28,321.5L215.65,321.85L218.87,319.75L223.18,318.54L223.95,319.22L222.99,321.89L223.75,324.68L229.17,329.03L233.12,336.99L235.04,338.87L241.54,340.59L243.23,342.8L247.81,341.41L248.92,336.64L250.12,335.7L251.99,336.68L260.27,330.93L264.43,330.72z"
				},
				{
					"id":"BI-MW",
					"title":"Mwaro",
					"d":"M238.56,482.58L236.27,486.75L234.62,492.83L232.94,494.47L231.68,497.77L225.22,503.02L221.28,504.65L219.58,499.42L222.74,494.74L221.7,491.38L223.79,489.74L224.32,482.1L220.61,483.29L216.17,481.92L215.7,479.64L213.8,478.73L213.94,476.21L212.87,474.57L214.3,472.71L212.49,471.74L210.46,473.45L207.7,472.89L202.98,467.08L202.7,460.72L198.52,458.3L196.6,456.26L196.12,454.05L188.24,452.81L187.18,451.26L187.18,451.26L189.79,446.4L193.12,447.45L194.09,446.72L194.76,440.86L191.29,439.91L191.96,429.23L193.11,426.96L197.56,423.77L197.91,422.59L197.64,419.68L193.5,415.99L193.18,413.24L190.96,411.33L192.48,406.05L191.72,404.05L195.52,396.98L192.24,393.49L192.24,393.49L191.36,386.8L192.28,382.47L197.24,382.8L198.52,384.22L201.22,384.88L202.64,384.11L204.63,384.65L204.8,390.59L207.01,389.94L209.66,393.48L212.01,393.05L213.8,399.01L212.43,402.07L213.87,406.18L214.87,407.76L218.12,407.88L219.62,407.06L220.68,403.84L223.05,402.67L223.44,401.16L230.99,400.92L236.82,386.74L242.69,384.22L249.1,388.52L249.71,389.87L250.55,389.69L252.24,386.78L251.9,384.79L254,382.47L253.8,380.52L256.3,377.9L256.67,374.79L255.6,371.76L256.72,366.59L259.01,365.61L259.01,365.61L260.23,366.32L262.43,365.87L264.46,369.8L269.79,369.7L270.67,373.64L274.36,375.79L274.3,376.82L277.89,380.06L277.15,383.12L275.94,383.7L275.41,385.98L273.69,386.18L273.03,388.26L275.03,390.6L277.17,390.62L278.14,391.71L279.3,390.91L281.56,391.18L283.41,393.05L282.94,394.1L288.41,396.52L288.94,398.64L287.14,399.61L289.37,400.74L288.3,402.26L285.55,402.05L284.38,402.97L284.49,405.62L283.54,406.01L283.74,407.36L282.13,409.83L284.5,412.71L283.21,413.74L284.5,414.83L283.23,415.52L284.96,416.75L283.31,417.06L283.11,420.68L281.44,422.19L282,424.39L283.3,424.68L282.68,425.64L283.54,426.58L281.68,426.67L280.71,436.64L277.93,438.38L277.79,440.02L273.75,439.98L271.99,441.61L266.14,439.42L264.29,440.86L263.46,440.2L262.56,440.58L262.66,441.74L261.58,441.43L260.82,443.93L257.96,443.78L257.61,445.57L255.17,447.1L254.45,451.87L260.02,458.65L259.46,459.84L261.94,464.75L261.45,465.91L263.43,467.44L263.47,470.05L266.07,471.19L265.67,473.97L262.08,473.74L258.46,470.42L256.91,471.82L255.01,471.03L246.47,471.92L237.5,479.99z"
				},
				{
					"id":"BI-MY",
					"title":"Muyinga",
					"d":"M491.9,250.57L492.44,251.56L489.76,252.72L491.37,255.65L488.76,256.17L487.58,257.49L487.28,262.33L485.53,263.76L483.19,263.86L482.73,265L480.78,263.5L478.24,263.28L478.32,268.14L476.86,268.96L476.26,267.64L475.39,268.85L473.02,269.55L472.72,273.49L471.21,273.34L469.15,276.16L470.64,279.9L469.93,280.97L470.72,283.62L470.06,286.5L466.65,286.2L464.72,287.83L465.45,290.11L462.9,290.05L457.5,292.68L455.14,297.74L459.2,304.16L458.12,304.73L456.51,304.06L455.94,306.22L457.41,307.11L456.03,307.97L454.88,310.57L451.96,310.86L451.59,312.67L449.64,312.73L451.11,314.35L451.39,319.28L450.43,319.81L446.47,318.34L446.47,318.34L443.47,315.7L436.84,319.06L434.96,318.23L434.92,315.92L430.42,314.63L423.6,318.15L420.91,318.47L420.21,317.59L417.54,317.39L414.7,313.6L412.04,313.38L410.36,311.94L410.22,309.44L407.73,307.62L407.24,304.77L409.64,299.97L412.72,296.87L412.93,294.71L416.03,289.26L419.7,285.28L419.73,282.95L421.85,278.09L421.05,276.69L422.6,269.72L421.76,266.92L422.64,263.97L422.04,259.68L422.76,253.92L419.53,249.22L413.51,244.35L411.67,241.03L408.24,238.91L406.06,238.77L402.03,236.05L389.12,237.39L389.12,237.39L388.23,235.63L389.69,233.18L388.58,231.97L389.07,229.94L386.49,227.7L391.59,224.45L392.68,222.08L394.7,221.31L391.01,218.45L385.96,217.39L381.47,214.76L376.22,219.22L375.8,220.69L369.58,215.08L371.12,214.29L370.84,213.32L368.56,212.02L367.97,209.37L365.04,207.66L363.94,205.44L364.77,202.61L357.01,197.94L356.24,196.23L356.24,196.23L362.83,192.06L366.93,194.89L369.97,195.2L373.82,190.35L373.71,187.58L377.57,183.49L379.64,178.05L381.87,177.73L384.07,179.85L387.37,180.86L402.15,167.16L403.25,167.61L406.58,164.76L413.21,162.08L417.78,161.36L420.18,166.38L422.87,165.56L426.9,159.26L434.33,152.43L437.18,146.8L439.35,145.86L442.16,146.64L443.39,145.76L445.5,140.38L449.17,135.77L461.84,135.38L463.13,134.1L466.79,123.14L465.76,120.98L466.01,117.35L468.98,112.79L463.19,107.11L462.43,102.34L468.03,96.77L468.48,92.06L466.33,87.84L461.96,83.81L460.18,76.55L457.99,74.42L457.84,71.61L454.67,66L453.91,55.39L453.91,55.39L453.93,52.16L455.44,49.92L456.3,45.87L460.14,41.52L466.2,40.38L470.43,45.71L471.76,45.25L472.99,46.48L475.52,46.85L477.21,44.35L482.49,43.19L483.83,44.01L484.17,45.48L482.78,48.34L483.43,50.01L482.61,51.82L486.49,54.24L486.83,59L488.55,59.64L491.53,58.82L493.06,62.55L494.47,62.5L496.31,65L499.09,66.6L499.69,70.21L503.07,71.49L507.65,71.65L510.54,74.52L508.61,77.58L509.07,78.74L508.15,81.36L504.2,85.87L502.92,89.5L502.7,94.68L501.26,95.92L498.5,104.82L494.9,109.14L494.92,110.75L491.42,111.09L490.61,112.59L491.1,121.87L489.34,123.34L488.34,126.66L486.33,128.14L485.05,131.79L482.15,134.72L477.66,142.08L475.72,147.68L472,151.77L469.73,156.37L473.31,161.94L477.42,161.64L480.56,165.2L482.61,165.96L487.11,162.42L497.43,157.39L499.95,154.53L505.51,153.7L505.13,155.84L506.08,157.52L504.6,162.61L503.2,163.07L503.54,164.91L502.23,165.33L501.84,166.53L499.44,166.65L499.04,168.81L497.72,168.13L497.53,170L495.48,171.66L495.49,172.86L490.86,176.44L488.61,174.12L485.01,175.38L485.11,176.93L483.8,177.21L484.95,179.56L484.37,180.64L481.28,182.72L476.6,183.75L477.12,186.3L475.31,187.53L477.68,189.23L478.91,191.45L477.32,194.5L478.17,195.9L476.76,198.61L477.18,199.93L475.83,203.03L475.17,202.02L474.14,202.3L474.95,203.02L473.91,206L472.44,205.48L471.54,207.39L472.29,208.21L471.2,210.78L471.66,212.2L470.23,212.49L470.49,214.99L469.41,216.14L468.14,216.06L467.49,217.4L467.63,218.62L466.03,221.14L466.12,221.93L468.29,221.43L468.33,222.89L467.15,223.15L469.04,226.23L471.68,224.5L474.66,226.34L475.14,233.3L476.13,234.33L475.64,235.71L479.4,237.83L479.79,239.09L482.25,237.84L484.41,241.24L482.34,241.92L486,242.66L487.62,245.2L489.5,246.11L490.17,249.18z"
				},
				{
					"id":"BI-NG",
					"title":"Ngozi",
					"d":"M356.24,196.23L357.01,197.94L364.77,202.61L363.94,205.44L365.04,207.66L367.97,209.37L368.56,212.02L370.84,213.32L371.12,214.29L369.58,215.08L375.8,220.69L376.22,219.22L381.47,214.76L385.96,217.39L391.01,218.45L394.7,221.31L392.68,222.08L391.59,224.45L386.49,227.7L389.07,229.94L388.58,231.97L389.69,233.18L388.23,235.63L389.12,237.39L389.12,237.39L379.98,247.7L376.73,249.91L371.01,251.78L360.57,259.83L357.18,261.29L352.74,261.76L346.98,260.84L342.19,264.02L337.44,262.54L335.87,262.86L333.26,266.7L325.82,271.37L325.72,273.61L323.3,276.73L319.96,285.45L317.47,287L313.8,286.33L310.75,287.37L309.46,289.36L310.55,291.6L310.47,294.22L306.07,296.32L306.07,296.32L304.24,295.47L301.61,296.23L297.48,289.38L294.4,289.23L291.03,286.9L285.17,287.75L285.17,287.75L287.25,274.14L288.57,273.36L290.77,269.35L287.47,269.47L279.93,272.05L278.28,270.08L276.1,269.68L270.37,272.54L265.29,273.23L263.67,272.46L264.62,269.67L264.11,267.38L258.71,262.7L254.83,260.64L251.83,255.1L250.2,254.21L250.81,243.31L247.97,242.01L247.41,241.02L248.08,239.02L244.56,243.01L242.7,243.63L241.8,245.59L237.87,247.02L232.67,243.05L233.05,239.44L234.2,237.7L235.76,237.18L234.45,231.15L232.96,231.07L231.57,229.12L232.16,226.52L231.07,227L230.29,225.87L225.38,227.44L224.08,225.77L219.85,225.63L217.52,223.73L214.76,224.2L214.26,222.2L210.29,217.45L210.4,216.29L214.17,210.95L218.08,212.55L218.82,211.45L219.57,206.98L218.16,202.77L219.59,199.71L221.19,198.81L221.19,198.81L224.58,201.45L226.77,201.61L229.34,204.4L229.96,203.76L232.78,205.15L234.23,208.03L236.37,206.81L237.61,207.5L239.16,207.51L241.5,205.45L246.02,204.03L248.22,205.2L249.55,204.51L251.99,199.8L252.69,194.91L253.9,194.06L254.12,190.63L255.37,189.79L260.3,190.28L262.82,187.74L265.59,188.02L267.93,188.81L269.23,192.69L273.24,193.35L274.88,195.04L275.27,193.33L277.5,191.25L281.89,190.56L282.64,189.23L284.21,189.6L285.46,188.59L290.25,188.45L290.69,185.82L294.03,185.43L295.27,184.06L294.44,183.46L295.32,180.3L303.51,169.62L307.75,154.1L307.75,154.1L308.53,155.18L313.69,154.36L318.68,156.22L322.33,159.81L329.01,161.76L329.85,162.84L329.84,165.92L333.07,164.83L333.2,166.54L337.39,171.88L336.29,173.96L333.91,175.27L347.88,184.26L346.86,187.21L349.28,189.1L351.65,193.17L351.15,196.16z"
				},
				{
					"id":"BI-RT",
					"title":"Rutana",
					"d":"M459.71,506.17L460.01,507.3L462.5,508.26L462.29,510.86L464.61,515.42L464.55,518.23L466.55,519.91L466.48,525.81L464.89,527.01L464.6,528.87L461.99,530.2L460.21,528.42L459.9,527.36L458.27,527.05L457.71,525.19L458.37,524.4L455.08,522.96L452.13,522.92L449.64,524.84L448.34,522.93L445.68,522.45L441.93,524.6L441.81,525.89L439.96,526.05L440.25,527.13L438.08,529.31L438.66,531.11L438.7,531.98L438.22,534.28L437.66,536.31L435.67,537.15L434.98,540.63L432.83,541.68L433.94,543.71L432.89,545.87L429.49,547.97L429.48,549.89L427.34,551.62L426.73,550.83L423.07,555.43L421.64,556L421.06,555.4L419.54,555.85L418.52,557.53L416.86,557.44L415.6,558.58L416.72,561.36L415.35,562.86L413.46,570.1L410.16,571.68L410.5,573.5L407.47,577.42L408.43,578.13L407.94,581.16L406.74,581.53L407.13,584.75L405.55,587.24L405.92,588.4L401.59,593.84L403.28,598.75L406.87,600.4L406.59,601.82L404.91,602.8L404.48,605.41L402.57,605.97L402.04,608.67L397.96,611.79L395.58,612.07L393.83,613.92L393.83,613.92L393.13,613.48L390.33,616.83L389.06,616.86L382.47,610.2L379.14,610.03L375.12,612.12L374.84,613.41L372.51,614.59L370.78,617.02L365.61,620.06L363.29,620.3L358.89,617.96L354.27,617.15L350.95,617.89L349.11,617.33L347.79,618.15L346.96,617.25L345.83,618.08L344.22,617.13L344.5,616.12L343.05,615.96L340.18,617.64L336.49,617.72L336.78,619.39L332.71,622.58L329.73,622.34L329.19,624.83L326.38,626.31L324.95,626.52L323.92,625.26L323.15,626.89L322.24,626.85L321.09,625.19L317.38,628.29L315.69,627.88L312.94,628.81L312.72,626.06L311.56,625.56L312,624.51L310.04,623.47L309,624.84L305.25,624.45L303.03,625.34L303.3,627L301.11,626.87L301.1,629.05L299.77,628.69L299.01,625.76L297.09,627.49L292.7,628.46L292.56,627.32L291.15,627.12L291.81,625.83L290.33,625.22L290.8,624.2L288.01,623.75L288.8,622.81L287.66,622.5L288.41,621.9L287.68,620.43L286.1,620.99L286.07,621.9L284.02,621.66L282.27,623.07L281.32,621.72L280.51,621.64L280.03,622.92L278.54,622.26L279.4,623.65L276.17,623.16L274.54,624.22L270.93,623.43L271.26,622.02L269,620.95L269.99,617.34L272.58,614.75L270.63,613.98L270.45,611.29L269.41,610.55L269.41,610.55L274.92,603.19L274.92,597.06L277.54,595.63L278.2,591.04L282.9,583.01L284.37,582.95L287.15,573.64L289.38,570.46L291.11,570L292.11,560.49L293.37,557.49L299.42,556.48L297.86,550.85L296.5,550.14L297.64,548L294.36,544.93L299.73,541.55L300.93,538.92L302.93,537.69L302.93,537.69L303.31,539.92L305.92,543.82L312.37,545.79L313.46,544.53L312.7,543.72L313.13,540.51L309.67,537.44L313.29,532.19L313.17,529.38L324.86,523.48L327.55,523.51L329.79,522.27L330.02,521.13L322.39,517.27L322.07,515.94L327.78,510.94L327.95,509.03L331.6,506.05L337.43,505.05L340.76,503.46L341.54,501.77L350.09,501.17L350.51,499.25L352.63,497.62L353.13,495.27L354.45,494.76L354.32,493.48L355.92,492.38L357.51,488.52L361.46,486.47L361.15,480.8L363.34,477.46L363.23,476.07L363.23,476.07L364.6,475.84L368.86,478.75L370.9,479.05L376.6,485.66L378.17,486.29L379.95,490.04L382.56,492.53L385.83,488.89L391.91,484.58L399.06,481.57L412.44,481.98L416.13,485.32L417,488.48L423.19,495.82L425.51,492.49L427.94,492.26L431.72,494.85L435.42,495.14L436.29,495.98L438.56,503.48L446.58,505.45L448.66,507.16L450.73,506.45L454.14,503L456.6,505.14z"
				},
				{
					"id":"BI-RY",
					"title":"Ruyigi",
					"d":"M436.56,329.69L437.05,332.5L435.72,333.42L435.41,335.57L437.05,339.21L438.36,339.37L442.22,336.66L447.38,337.49L451.43,335.6L453.93,340.56L454.44,338.53L458.44,341.92L458.66,343.43L462.13,340.76L465.89,344.93L468.07,344.37L472.08,346.02L474.88,351.25L478.47,352.72L478.78,355.23L477.54,359.75L480.21,361.85L479.46,362.52L482.8,366.3L483.63,369.26L486.51,369.2L487.94,370.74L491.25,370.89L494.82,365.85L496.39,366.99L498.39,366.94L498.17,367.88L503.42,367.43L503.9,369.04L510.28,371.95L507.24,372.19L502.99,375.18L502.76,382.12L506.19,381.15L511.98,382.54L515.08,388.6L521.55,390.88L521.71,398.19L530.27,391.17L535.64,389.69L540.84,386.69L540.84,386.69L544.44,390.92L544.74,394.29L548.93,394.3L553.76,396.8L554.95,398.46L553.03,405.66L551.17,406.91L549.39,409.93L542.24,414.87L541.54,416.91L536.48,420.47L530.71,422.11L523.86,427.16L518.75,428.97L517.54,430.35L507.81,433.4L504.24,436.64L501.23,441.82L499.8,442.25L499.41,439.44L496.24,437.82L493.54,438.94L492.53,441.4L486.73,445.33L483.33,449.46L483.39,450.76L480.6,452.07L478.29,454.58L479.29,457.2L481.75,457.05L481.97,459.64L479.87,462.33L482.25,462.92L481.94,467.18L480.14,467.81L480.01,469.42L478.83,470.25L477.5,471.58L475.3,471.73L473.01,473.2L474.24,474.26L473.98,475.93L472.15,477.69L472.35,478.81L470.41,478.67L469.77,482.85L468.35,482.96L468.33,486.91L466.49,487.2L465.85,488.52L467,490.53L464.9,491.36L465.1,493.53L464.22,494.26L464.29,495.8L463.33,498.01L462.25,499.68L459.9,499.82L460.41,500.89L458.76,502.73L460.42,503.35L459.45,504.7L459.71,506.17L459.71,506.17L456.6,505.14L454.14,503L450.73,506.45L448.66,507.16L446.58,505.45L438.56,503.48L436.29,495.98L435.42,495.14L431.72,494.85L427.94,492.26L425.51,492.49L423.19,495.82L417,488.48L416.13,485.32L412.44,481.98L399.06,481.57L391.91,484.58L385.83,488.89L382.56,492.53L379.95,490.04L378.17,486.29L376.6,485.66L370.9,479.05L368.86,478.75L364.6,475.84L363.23,476.07L363.23,476.07L363.28,471.43L365.44,468.5L365.23,463.14L364.1,462.79L364.51,461.62L363.28,461.41L362.07,459.23L362.78,456.77L358.3,450.49L357.45,445.43L359,444.42L358.46,442.28L354.11,438L352.77,430.15L348.8,424.29L352.54,421.25L352.73,417.12L354.38,413.37L358.07,409.83L357.03,407.41L352.56,404.32L350.94,401.61L349.91,401.69L349.61,397.98L346.54,396.3L346.85,394.97L345.49,392.62L346.02,391.26L344.47,391.25L344.57,390.07L344.57,390.07L345.81,389.6L346.22,386.98L348.25,388.01L349.75,387.5L349.98,383.11L350.92,383.01L351.19,383.98L356.11,383.51L358.25,381.77L359.92,382.23L361.86,380.88L365.07,382.37L366.26,380.23L365.24,379.24L367.17,379.72L368.95,378.95L372.56,381.68L373.7,380.39L373.47,378.92L374.4,378.62L375.47,379.96L378.68,378.24L379.06,377.12L383.54,379.43L383.62,376.23L387.55,376.21L387.3,375.1L385.1,374.43L385.35,373L388.42,373.21L389.97,375.95L393.51,374.83L395.03,375.42L394.64,371.38L398.95,368.13L401.09,369.35L403.09,367.57L402.76,362.74L406.47,364.67L408.73,363.82L407.05,359.23L412.96,352.79L413.48,351.26L412.54,350.21L414.28,348.14L416.04,347.59L416.11,345.36L426.36,336.01L429.8,335.22L429.94,330.61L432.55,331.54L434.98,329.61z"
				}
			]
		}
	}
};
