// (c) ammap.com | SVG (in JSON format) map of Belize - Low
// areas: {id:"BZ-BZ"},{id:"BZ-CY"},{id:"BZ-CZL"},{id:"BZ-OW"},{id:"BZ-SC"},{id:"BZ-TOL"}
AmCharts.maps.belizeLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-89.224282",
				"topLatitude":"18.497391",
				"rightLongitude":"-87.491060",
				"bottomLatitude":"15.892503"
			}
		},
		"g":{
			"path":[
				{
					"id":"BZ-BZ",
					"title":"Belize",
					"d":"M386.45,403.44l0.81,1.44l-0.65,0.68l-2.44,-0.25L386.45,403.44zM332.71,396.26l0.98,1.6l-0.16,1.77l-1.7,0.51v0.84l-0.49,-0.84L332.71,396.26zM492.63,393.73l2.52,0.51l-2.03,0.59l-1.05,-0.68L492.63,393.73zM476.64,389.25l2.19,2.28l-0.16,1.44l-4.71,4.39l0.25,1.18l-1.06,0.17l2.76,-7.85l-0.24,-1.44L476.64,389.25zM332.95,384.61l-0.08,4.56l-0.97,0.59l-0.08,-4.22L332.95,384.61zM387.02,382.92l1.46,0.17l0.16,0.84l-0.97,1.44l-1.38,0.34l-0.24,-0.17l1.22,-1.52L387.02,382.92zM397.98,381.82l1.14,0.68l0.65,2.28l-1.63,1.01l0.33,2.19l-1.14,1.69l0.57,2.03l-0.73,-1.18l-1.22,1.86l1.14,1.27l0.49,2.79l-2.44,3.29l-1.87,0.51l-0.73,-0.51l1.06,-0.08l1.3,-3.12l-1.22,-2.87l0.49,-2.62l-2.84,-0.59l-1.06,1.94l-0.73,-0.59l1.3,-2.28l-1.46,-0.68l0.81,-0.93l-1.22,-2.2l2.68,-1.52l0.65,1.52l2.27,0.76l-2.44,0.17l-0.24,1.69l3.25,0.51l1.38,-0.76l-0.57,-1.94l0.98,-1.35h-0.89l0.16,-2.03L397.98,381.82zM382.63,378.44l-0.65,2.45l-0.89,0.17L382.63,378.44zM393.92,374.38l0.49,1.94l-2.68,1.86L393.92,374.38zM389.94,370.24l1.3,1.27l-0.49,0.76L389.94,370.24zM379.87,368.38l-0.32,2.79l1.54,2.7l-0.65,4.99l-0.65,-0.85l-0.89,0.25l1.06,-2.37l-3,-2.53l-0.97,0.42l-1.22,2.87l1.7,3.72l0.9,0.68l2.11,-0.25l-3.08,2.37l1.46,3.13l-0.08,2.37l0.89,0.08l0.57,-1.52l2.76,0.34l0.89,-1.6l-0.65,2.28l0.49,2.2l-0.49,0.34l-0.73,-1.86l-0.89,0.25l-0.65,2.54l4.06,1.61l-1.87,0.17l0.16,1.01l-1.3,0.51l1.14,0.68l-0.08,0.93l2.19,1.1l-0.81,1.18l-0.89,0.25l1.06,1.52l0.49,4.14l-1.46,-1.6l-1.46,-4.05l0.57,-1.6l-1.05,-0.42l0.89,-1.44l-1.14,-0.42l0.73,-1.18l-2.68,-0.84l-2.52,-3.12l-2.52,-12.33l0.41,-4.22l0.97,-0.59l1.06,-3.04v2.03l0.81,0.76l1.46,-2.96L379.87,368.38zM412.91,368.13l1.06,2.45l-1.54,0.59l-0.89,2.79l-0.88,-0.48l-0.74,2.6l-0.97,1.27l-0.66,-0.3l-0.48,0.55l-1.87,-0.68l-1.79,3.21l-3.09,0.17l-0.97,-1.94l-2.03,-0.68l0.65,-1.69l4.71,-0.17l1.95,0.68l1.3,-2.37l0.89,0.68l-0.24,1.1l1.14,0.59l1.39,-2.31l-0.74,-0.73l0.98,-0.51l-0.16,-2.45L412.91,368.13zM334.17,366.78l0.57,4.14l-0.48,1.27l-0.97,0.25l0.97,0.34l-0.24,3.63l-2.35,2.03l1.06,-5.41l-1.3,-4.56L334.17,366.78zM386.61,365.51l0.49,1.18l-1.06,-0.51L386.61,365.51zM401.87,365.34l0.9,0.93h5.03l-0.57,2.54l-3.57,5.32l-1.7,1.01l-1.38,-0.68l-2.03,0.59l1.63,-1.18l1.79,0.85l1.14,-0.93l-0.57,-1.44l-3,-1.01l-0.41,-1.69l1.3,-1.18v1.44l1.38,0.76l-0.24,-2.2l0.57,0.76l1.3,-0.51l-1.62,-1.01L401.87,365.34zM398.54,365.17l-0.49,3.13l-1.14,-2.96L398.54,365.17zM387.26,360.44l-0.81,3.21l-0.41,-1.52L387.26,360.44zM391.24,361.88l-0.65,-0.17l1.06,-1.27L391.24,361.88zM396.51,358.67l0.73,0.85l-1.38,0.68L396.51,358.67zM388.64,353.34l-0.97,2.2l-0.49,-1.27L388.64,353.34zM301.05,345.06l1.53,1.29l2.04,0.32l0.81,1.18l-0.16,0.34l0.14,0.78l1.25,-1.4l1.38,-0.73l0.24,0.59l-3,2.03l-1.46,-2.62l-3.57,-0.68L301.05,345.06zM407.47,340.66l0.41,2.54l-1.95,-2.11L407.47,340.66zM339.36,337.62l1.54,4.65l-2.68,1.69l-1.22,-1.1l-0.41,-3.89l0.97,-1.18L339.36,337.62zM337.5,327.98l1.14,2.96l-2.76,3.13l-0.65,-0.85L337.5,327.98zM409.66,326.88l1.3,0.93l2.11,-0.59l-2.76,4.48l3.41,8.37l-0.65,1.27l3.41,8.37l-0.49,1.52l2.27,4.56l-1.22,4.9l-1.14,0.68l-0.41,3.04l-2.11,-0.59l0.65,-2.2l1.45,-0.93l-1.61,-2.45l-3.65,1.69l-1.95,4.39l-1.06,-0.08l1.06,-2.28l-0.16,-1.69l2.11,-1.86l-1.06,-3.3l1.3,-6.85l-1.38,-1.94l3.33,-0.93l-0.4,-2.03l0.81,-1.44l-0.41,-1.52l-1.87,-1.61l0.41,-2.62l-0.81,-2.45l-0.73,-0.59l-1.7,0.59l-1.54,-0.93l2.27,-1.61l-1.13,-1.01L409.66,326.88zM338.39,325.61l-0.73,0.59l0.32,0.85l-1.3,0.08l0.16,-0.93L338.39,325.61zM338.47,323.33l-0.89,1.78l-1.13,-0.08l0.41,-1.35L338.47,323.33zM339.04,320.2l-0.73,2.62l-0.81,0.09l0.57,-0.85l-1.87,1.27l-0.16,-1.01L339.04,320.2zM337.58,319.35l0.57,0.76l-1.62,0.68v-1.01L337.58,319.35zM503.02,318.08l1.95,0.25l1.46,2.12l-1.38,3.81l-1.54,0.09l-4.79,-2.03l1.14,-2.28L503.02,318.08zM320.13,316.14l0.57,0.76l-1.22,0.17l-0.24,-0.68L320.13,316.14zM415.84,315.46l0.24,0.68l-1.38,0.85L415.84,315.46zM320.37,303.45l0.65,0.76l1.54,-0.08l-0.81,0.93l-3.25,-0.59L320.37,303.45zM314.93,298.54l1.3,3.47l-0.73,1.61l-1.22,0.51l-1.71,-2.96l-1.7,-1.18l-0.24,-1.35L314.93,298.54zM299.51,296.34l0.32,1.18l-0.73,0.25L299.51,296.34zM326.54,295.83l1.54,2.12l2.19,0.17l5.03,5.67l3.49,1.44l0.97,1.27l-0.97,2.37l-1.38,0.51l-1.14,4.48l0.98,3.98l2.68,-3.13l0.08,2.54l-1.14,1.95h-0.65l0.41,-1.18l-0.89,0.93l-1.79,-0.34l-0.16,1.01l-1.54,0.17l0.16,-1.27l2.03,-0.17l-0.04,-1.29l-2.56,0.86l-1.78,-2.28l0.08,-2.79l2.03,-1.35h1.79l-1.7,-0.59l-2.11,1.44l-0.81,-0.76l3.08,-1.78l1.38,1.01l0.74,-0.17l-0.66,-0.26l0.16,-0.93l-1.62,-0.08l-2.76,1.27l2.19,-2.62l1.62,-0.51l-0.16,-1.01l-4.22,3.05l-0.08,-0.93l1.62,-1.69l-1.3,0.17l1.62,-0.68l1.22,-1.78l-1.06,0.68l-0.4,-0.59l-0.4,0.93l-1.79,1.19l-2.35,-1.27l-0.41,-1.18l-0.73,0.93l-1.13,-2.71l-1.3,-0.42l0.49,-1.1l-0.81,0.68l-1.05,-1.44l0.24,-2.28l1.22,-0.68v1.1l0.98,-0.17l-0.65,-1.18L326.54,295.83zM304.14,291.01l1.46,0.34l1.22,2.12l-0.32,1.52l-1.3,1.1l-2.27,-1.1l1.22,-2.12l-0.57,-1.27L304.14,291.01zM426.06,291.01l1.46,1.27l1.3,-0.25l-1.22,0.51v1.69h-0.73v-1.69l-1.46,-1.18L426.06,291.01zM412.91,290.08l0.73,1.86l2.11,0.42l0.16,1.86l-0.73,0.59l0.9,1.52l2.92,-0.42l1.79,-1.78l1.05,0.25l0.08,1.19l-1.7,0.59l-1.14,2.71l-1.3,0.08l1.38,2.12l3.57,0.76l0.41,1.95l4.22,-2.45l-0.08,2.03l-6.41,2.45l0.33,2.2l-3.41,1.78l-2.84,4.65l-1.54,3.98v4.14l-2.19,1.78l-2.11,0.42l-0.97,2.54l-1.46,1.19l-4.3,-0.08l0.24,-2.45l-1.54,-2.37l2.11,-1.18l-0.65,-1.52l-1.38,0.51l-0.89,2.2l-0.65,-0.76l-1.38,0.17l-0.73,1.18l-1.14,-0.42l0.41,2.62l-1.22,1.94l-1.14,0.25l0.41,-1.1l-1.38,-0.17l-0.33,-0.84l-2.19,0.08l-2.11,1.52l0.25,2.28l-0.57,1.61l-0.97,0.17l0.98,0.76l-1.87,3.21l0.81,2.96h1.63l-2.35,4.06l1.54,3.13l-0.41,1.86l-2.51,4.4l0.49,1.61l-1.3,0.25l-0.89,-1.27l-0.73,1.18l0.57,1.52l-1.13,-0.34l-0.89,3.21l-0.81,-0.08l-0.16,3.55l1.22,1.35l-0.97,-0.68l-2.35,0.51l0.57,1.61l1.14,-0.51l1.14,2.11l1.22,0.08l-0.81,0.93l-3.09,-0.76l-0.32,0.93l-1.3,-0.08l-0.73,1.61l-0.81,-3.21l1.7,-0.93l-0.65,-3.38l1.79,-0.76l-0.4,-1.01l1.3,-0.59l-0.08,-3.55l0.81,0.68l1.22,-0.34l-0.08,-2.03l0.98,-1.44l-0.89,-0.34v-1.6l0.81,-0.08l0.65,1.69l1.14,-0.51l-0.49,-0.76l2.03,0.25l-0.89,-2.37l-1.71,0.17l-1.22,-0.93l1.22,0.09l0.16,-0.68l-2.03,-0.08l-0.89,-3.63l1.14,-2.03l-0.73,-0.42l-0.08,-1.69l3.98,-7.19l3.9,-4.57l0.98,-4.4l2.35,-1.86l1.71,-4.48l2.92,-3.21l-0.16,-1.01l2.44,-2.37l1.38,0.17l1.62,-2.96l1.22,0.51l-2.35,2.45l0.57,1.95l-3.81,2.03l-1.62,2.88l1.14,1.27l5.52,-0.68l2.19,-1.01l0.33,-1.18l6.09,-1.95l0.81,-2.54l-1.62,-1.61l1.79,-3.13l1.46,0.25l2.03,-1.94l4.06,-0.51l-0.41,-2.62h-2.51l0.73,-5.16l-2.43,-0.08l-1.54,-1.27l-2.52,4.23l0.49,2.45h-1.62l-2.6,3.64l-2.52,2.12h-1.05l3.25,-2.2l2.35,-3.64l0.9,-4.32l3,-2.79l-0.16,-4.82L412.91,290.08zM305.68,287.2l-0.24,3.13l-1.13,0.42v-1.61L305.68,287.2zM336.69,285.77l0.73,1.27l-0.73,1.27l-0.24,-0.08l0.24,-1.27l-1.38,-0.85L336.69,285.77zM308.11,283.48l0.57,1.86l-1.38,0.85l-0.89,-0.42l0.81,0.93l-0.65,0.59l-0.73,-0.51l0.65,-2.54L308.11,283.48zM289.2,282.21l-1.46,2.79h-0.89l0.32,-2.03L289.2,282.21zM336.2,281.02l-0.24,0.76l1.3,0.85l-0.73,1.61l-3.08,-2.29L336.2,281.02zM299.18,280.6l0.08,1.61l-1.87,1.19l0.04,-2.19L299.18,280.6zM417.46,280.52l2.11,1.69l-2.58,-1.01l-0.58,0.67l-0.73,-0.34L417.46,280.52zM296.58,280.43l0.49,0.59l-2.35,0.09L296.58,280.43zM425.01,271.88l0.65,1.02l-0.65,-0.76l-1.54,0.08L425.01,271.88zM275.56,270.78l0.16,1.52l0.81,0.25l-0.65,0.25l0.16,1.35l-1.05,0.17l-0.57,-0.59l1.3,-0.34l-1.3,-1.01l1.14,0.08l-0.73,-1.44L275.56,270.78zM276.78,267.99v0.76l1.87,-0.17l-0.49,1.02l-2.35,-0.08L276.78,267.99zM328.57,265.45l2.35,0.17l3.33,2.71l0.49,2.29v0.51l0.24,1.27l-0.85,0.96l-0.85,-1.13l-1.22,-0.17l2.68,2.12v2.12l-0.65,1.44l0.89,0.08l0.25,2.12l-0.97,0.93l-2.27,-2.29l1.46,-3.81h-1.22v-1.52l-1.54,-1.18l0.32,-1.44l-2.6,-3.47l-1.62,-0.93L328.57,265.45zM338.8,260.63l0.49,2.03l-3.41,9.31l1.54,-10.67L338.8,260.63zM318.83,259.52l1.46,1.78l3.49,0.34l1.79,3.39l-2.03,0.09l-0.49,-3.3l-1.54,0.17l0.9,0.76l-3.98,0.25L318.83,259.52zM317.2,258.85l0.73,0.68l-1.14,0.85l-0.32,-1.02L317.2,258.85zM346.19,239.71v6.35l-2.03,4.15l0.81,-3.05l-0.33,-2.29L346.19,239.71zM328.57,237.68l0.98,0.68l0.24,4.74L328,242.5l-3,1.69l-4.79,6.1l-1.87,0.17l-4.38,5.93l2.44,2.03l-2.03,-0.17l-0.4,-1.02l-3.08,0.17l2.11,-2.54l1.73,-0.12l0.22,-0.9l0.74,-0.45l-0.17,-1.07l-1.38,0.51l-1.7,-2.37l-0.32,1.86l-1.46,0.08l-1.14,2.79l0.89,1.69l-1.87,-2.03l-0.24,1.44L306.16,258l0.49,0.85l-1.14,-0.17l0.08,0.93l1.79,0.25l0.73,-1.19l1.22,0.17l-0.73,-2.03l0.49,-0.51l0.73,0.59l-0.08,2.12l-0.97,0.51l0.49,1.02l-4.14,-0.51l-2.68,1.78l-1.54,-0.51v-2.71l-0.57,1.61l-1.95,0.68l0.08,-1.27l1.22,-0.51l0.98,-2.03l1.22,-0.08l0.08,2.29l0.98,0.68l2.84,-1.69l4.55,-7.28l2.11,-1.19l1.87,1.02l1.46,-0.17l0.65,-2.88l2.84,-0.42l4.63,-2.37L328.57,237.68zM352.19,214.29l-1.95,8.81l0.73,7.37l-1.95,3.98l-2.52,0.51l0.33,-3.47l1.06,-0.76l1.3,0.85l1.05,-1.61l0.08,-2.29l-1.95,-1.61l1.87,-9.24L352.19,214.29zM340.83,193.7l2.84,0.42l-3.25,0.51l1.06,2.71l4.06,0.34l-2.11,0.93l-5.6,0.42l-1.3,-1.61l0.33,-0.93l0.73,0.59l0.08,-2.46l1.54,0.25L340.83,193.7zM338.23,191.83l2.03,1.1v0.76l-1.14,-0.76l-0.57,0.68l-0.89,-0.93L338.23,191.83zM340.99,190.9l1.06,1.27l-0.97,-0.59l-0.97,0.85l-0.16,-0.93L340.99,190.9zM342.13,190.64l0.98,1.53l-1.7,-1.25L342.13,190.64zM306.33,167.83l-0.65,3.31l-1.46,0.68l-1.54,2.97l-1.54,1.1l-2.92,8.31l-1.87,11.87l-0.81,0.85l0.32,3.14l-1.3,5.93l-1.71,18.39l-2.52,13.81l-3.81,7.2l-1.79,1.36l-0.32,3.56l-2.19,0.51l-2.19,2.54l-3.98,-2.79l-0.81,0.93l0.08,2.63l1.87,-0.34l-1.14,1.19l-2.27,-0.59l-0.57,0.68l0.33,1.44l2.92,-0.17l0.49,0.59l0.89,-0.59l-0.57,-2.2l2.6,0.85l0.89,-1.44l-1.79,6.61l-2.27,0.34l-1.54,1.35l-1.87,-0.34l-0.49,1.78l0.49,2.46l-1.14,2.46l1.3,16.93l2.35,0.51l0.81,1.78l2.92,2.45l4.55,1.1l2.03,1.69l1.87,-0.68l1.22,1.61l-0.97,2.12l2.03,2.96l5.52,1.69l3.82,-1.95l3.65,2.79l-0.32,2.37l1.54,1.35l0.49,2.12l-1.3,-0.42l-0.81,2.62l-1.46,-0.42l-2.35,1.78l0.16,2.28l-0.65,-2.37l-3.41,-0.25l-2.84,-2.28l-2.27,-0.25l-2.11,1.18l-2.52,3.38l-2.68,6.94l-0.81,7.1l-0.89,0.76l0.65,2.03l-2.68,7.78l-3.08,15.64l-4.87,16.73l-2.03,12.93l-0.24,31.5l1.22,7.01l2.19,2.44l0,0l-11.85,4.28h-13.86l-7.62,-3.6h-49.72l0,0l2.03,-2.13l0,0l6.39,-7.89l-1.46,-16.69l2.52,-5.26l-4.79,-4.36v-44.71l-2.77,-10.82l-0.69,-24.54h-3.46l-2.08,4.33l-1.38,7.22l-2.77,0.72l-2.77,-2.89l0,0h-3.46l0,0v-15.95l-0.74,-0.01l0.83,-35.35l4.16,-13.01h4.68l14.55,-4.88l-0.52,-3.79l-4.16,-2.17l0.52,-28.74l3.12,-2.17v-4.34l-2.6,-3.25v-10.85l2.08,-5.43l0.52,-6.51l3.12,-2.71l5.72,-2.17l5.2,-1.08l13.4,-0.5l-0.1,-0.91l12.68,-4.02l10.91,-1.63l6.42,-3.49l0,0l26.87,2.43l0,0l25.37,1.11l0,0L306.33,167.83z"
				},
				{
					"id":"BZ-CY",
					"title":"Cayo",
					"d":"M177.86,316.77L180.63,319.65L183.4,318.93L184.78,311.71L186.86,307.38L190.33,307.38L191.02,331.92L193.79,342.75L193.79,387.46L198.58,391.82L196.06,397.08L197.53,413.77L191.14,421.66L191.14,421.66L185.05,428.03L185.05,428.03L184.11,428.87L187.56,435.31L191.71,440.35L197.25,439.63L197.25,447.55L193.1,447.55L190.33,451.87L186.86,461.23L184.09,465.56L177.86,467.71L173.42,470.28L168.52,485.03L168.16,504.11L159.84,504.42L158.46,510.89L159.07,511.66L145.99,519.52L143.91,526L140.44,531.03L138.37,537.5L132.13,545.41L132.13,551.16L132.13,551.16L128.43,555L127.25,554.99L126.59,561.22L119.66,562.66L119.66,566.25L124.51,567.69L124.51,571.28L112.04,584.22L105.8,587.09L95.41,594.27L87.1,596.43L82.25,600.02L79.48,605.77L71.16,609.36L65.62,608.64L62.85,604.33L58,603.61L51.76,614.38L32.37,614.38L29.59,618.69L24.05,622.28L19.2,632.33L10.43,633.09L10.43,633.09L12.26,604.84L13.27,604.79L16.59,554.19L15.53,554.18L22.8,441.52L22.63,357.73L22.63,357.73L30.98,355.01L33.75,349.24L41.37,344.91L47.61,339.86L55.92,340.58L58,342.75L90.56,342.75L96.8,340.58L100.26,336.25L102.34,331.92L105.11,329.76L108.57,332.64L127.97,333.37L129.36,329.76L130.74,329.04L134.9,332.64L144.6,332.64L146.68,329.76L153.61,328.31L153.61,323.26L159.15,321.1L164,320.38L169.54,316.77L169.54,316.77z"
				},
				{
					"id":"BZ-CZL",
					"title":"Corozal",
					"d":"M355.11,183.35l1.14,1.87h-1.54L355.11,183.35zM349.92,144.93l-0.89,1.95l0.57,-3.14l2.92,-6.02L349.92,144.93zM369.16,121.25l0.33,2.8l-1.3,1.11l0.24,1.53l-2.27,0.6l0.41,1.44l-3.98,-0.68l-1.87,1.36l2.35,-3.39l0.81,0.76l0.65,-1.44l-1.54,-0.85l1.79,-0.59l0.49,-2.38l1.54,2.46l1.95,-0.59L369.16,121.25zM371.76,113.78l0.41,2.38l-1.71,1.78l-1.22,-0.25l-0.33,-0.93l2.11,-0.34l0.24,-0.68l-1.3,0.34l1.7,-1.19l-0.87,-0.3l-1.32,1.32l0.24,-1.53L371.76,113.78zM376.14,113.53l-0.4,7.13l-1.14,1.27l-1.79,0.34l-0.97,2.21l-2.11,0.42l0.33,-1.02l0.76,0.45l0.14,-1.22l1.71,-1.78l-0.49,-0.51l-1.38,1.61l0.08,-1.1l-0.81,0.42l0.57,-2.8h1.54l0.49,-1.19l0.98,1.02l1.71,-0.25l-0.81,-1.02l-0.91,0.54l-2.33,-0.62l2.19,-0.93l0.65,-1.95L376.14,113.53zM399.92,89.16l3.33,4.17l-1.38,1.86l2.35,4.08l2.11,10.95l1.79,3.23l-0.33,1.95l-1.95,0.08l-6.25,3.57l-1.3,2.55l-5.27,5.35l-2.11,6.96l-1.54,2.29l-0.89,5.01l-3,4.5l-7.87,18.49l-2.11,1.44l-0.41,1.95l-5.11,6.87l-0.41,2.12l-4.46,4.75l-1.14,3.82l-1.95,2.29l-3.25,1.87l-2.43,-0.42l-4.47,1.61l-1.79,-1.1l-1.46,-0.34l-2.11,1.1l0.25,-0.93l-0.81,-0.51l0.81,-1.44l1.54,-0.51l2.19,1.53l2.11,-1.27l0.33,-1.27l0.49,0.93l1.46,-0.68l0.41,0.85l1.3,-1.44l0.08,2.04l2.27,0.17l0.89,-2.03l-2.76,-2.12l1.05,-3.14l1.54,0.09l-0.97,0.85l0.57,0.59l-1.14,0.17l1.62,0.51v-0.76l1.54,-0.17l0.08,-1.1l1.22,0.08l1.46,-1.61l1.14,-0.08l-0.65,-0.85l1.46,-1.53l1.22,0.93l1.46,-1.27l0.16,-0.59l-0.89,0.34l0.65,-0.76l-0.24,-1.95l0.73,-0.17l0.41,-3.14l1.79,-1.27l-0.33,-1.02l0.65,-0.51l-0.25,-1.87h-1.22l0.16,-0.93l-4.46,8.48l-1.54,1.19l-0.65,-0.34l0.73,-1.19l-0.97,0.76l-0.81,4.5l-2.35,0.68l-0.24,1.44l-0.4,-2.54l2.68,-4.58l-1.87,1.1l-1.13,2.2l-0.32,-1.61l2.6,-3.48l-0.49,-1.1l1.38,-4.16l3,-3.48l1.79,-6.28l1.22,-1.19l0.08,0.93l1.14,-0.34l-0.89,-0.85l0.81,-0.08l-0.41,-2.04l1.3,-3.14l0.89,-0.25l0.08,-1.95h0.98l0.08,-1.27l1.95,-1.44l3.09,-4.41l1.3,-0.17l-0.32,-1.78l-0.89,0.68l1.05,-2.38l-1.05,-2.46l-1.95,3.31l0.81,-2.46l-0.73,-0.17l-0.81,2.29l-2.03,1.61l0.16,1.7l0.57,-1.1l0.41,0.42l-1.14,1.7l-1.3,0.17l0.81,-3.73l-0.81,-4.84l1.54,-1.78l0.32,1.95l2.76,0.17l3.98,-5.77l1.46,1.44l2.44,-0.59l0.65,-1.1l-0.24,-0.76l-0.73,0.17l0.49,-0.93l-2.19,0.26v-1.1l-1.62,1.19l0.25,-3.14l2.84,-1.27l1.46,-3.9l1.87,-1.53l1.38,-4.24l-0.57,-2.63l0.97,-3.48l1.7,0.26l1.14,-4.33l3.65,-3.74l0.57,-2.04l1.14,-0.25l-0.24,-1.19l-0.73,0.34l0.73,-2.12l0.89,-0.17l-0.41,2.12l2.11,-1.02l-0.89,-0.25l1.14,-1.36L399.92,89.16zM329.22,42.33l1.38,0.85l-0.49,2.55l-0.89,-1.19V42.33zM246.01,3.08l8.1,0.24l7.67,-1.31l2.66,0.69l0.41,1.79l4.3,3.15l0.41,2.3l1.54,2.21l-1.54,2.04l-2.11,1.02l-0.32,1.11l-1.95,0.43l-0.65,3.57l-3.89,4l-3,1.87l-2.11,0.34l-7.55,5.27l-2.27,0.34l-4.22,3.91l-0.16,4.17l0.81,2.98l3.16,3.15l4.79,-0.93l4.55,-3.15l1.54,0.26l4.38,-2.29l3.9,-0.08l0.57,1.11l-6.09,4.59l-1.95,3.49l0.08,1.96l3.41,0.68l0.49,-1.02l8.04,-2.97l3,-2.04l5.93,-0.42l5.28,-2.38l1.14,1.02l3.17,-2.12l2.76,2.55l-2.11,1.44l1.06,2.3l8.52,-3.4l-2.03,3.23l2.68,-0.68l-4.79,2.55l1.95,1.87l3.57,-3.23l7.79,-0.34l2.6,-2.3l9.41,-5.1l2.19,-1.02l4.79,0.17l3.41,-2.3l-0.57,5.44l-1.05,-0.17l-0.08,0.68L328,45.99l0.9,0.77l1.05,-0.59l-1.54,12.49l1.06,2.46l-1.54,0.09l0.24,1.96l-0.73,1.36l0.89,0.94l0.73,-1.87l0.41,1.11l1.3,0.09l1.22,1.53l-2.19,-0.51l-0.57,1.19l2.52,1.36v1.53l-0.81,0.43l-0.81,-0.93l-0.49,1.53l0.73,2.8l-0.41,8.66l1.71,6.03l-3.57,24.03l0.16,3.57l-1.05,2.04l-0.24,3.74l-1.22,-0.17l-1.22,1.95l-5.28,21.22l-6.09,7.55l-0.89,5.43l1.54,2.04l-1.14,1.36l0.98,0.42l-6.49,4.41l-0.73,1.36l0,0l-25.37,-1.11l0,0l-2.97,-0.27l0,0l-24,-22.13l-11.08,-12.31l-14.55,-9.42l-2.77,-5.8l-6.23,-20.29l-9.01,-6.52l-14.03,-5.98l-4.38,-3.36l-11.77,-0.71l0,0l1.04,-3.29l1.6,-14.92l14.06,-16.22l0.04,-8.14l5.84,-12.83l3.53,-12.87l10.84,-9.67l2.58,-0.94l5.68,1.42l1.58,2.63l1.54,0.59l2.54,-0.38l11.12,-4.75L243.58,0L246.01,3.08z"
				},
				{
					"id":"BZ-OW",
					"title":"Orange Walk",
					"d":"M180.23,79.43L192,80.14L196.38,83.5L210.42,89.48L219.42,96L225.66,116.3L228.43,122.09L242.98,131.51L254.06,143.82L278.06,165.95L278.06,165.95L254.17,163.79L254.17,163.79L247.74,167.28L236.83,168.91L224.15,172.93L224.25,173.84L210.85,174.34L205.65,175.42L199.94,177.59L196.82,180.31L196.3,186.82L194.22,192.25L194.22,203.1L196.82,206.35L196.82,210.69L193.7,212.86L193.18,241.6L197.34,243.77L197.86,247.56L183.31,252.44L178.64,252.44L174.48,265.45L173.65,300.8L174.39,300.81L174.39,316.77L174.39,316.77L169.54,316.77L169.54,316.77L164,320.38L159.15,321.1L153.61,323.26L153.61,328.31L146.68,329.76L144.6,332.64L134.9,332.64L130.74,329.04L129.36,329.76L127.97,333.37L108.57,332.64L105.11,329.76L102.34,331.92L100.26,336.25L96.8,340.58L90.56,342.75L58,342.75L55.92,340.58L47.61,339.86L41.37,344.91L33.75,349.24L30.98,355.01L22.63,357.73L22.63,357.73L22.33,210.15L23.02,169.78L28.07,162.83L34.52,161.7L38.17,156.37L54.21,150.93L57.3,150.76L66.12,158.16L70.31,165.44L71.22,165.73L72.85,164.49L76.55,166.15L80.77,164.73L82.59,164.96L89.89,175.99L102.09,181.76L103.32,184.23L111.35,192.63L111.19,183.08L109.69,178.99L110.11,174.02L116.48,169.3L120.03,168.07L123.8,161.96L129,158.6L129.19,154.4L133.3,149.27L135.9,142.05L140.2,138.07L152.35,133L154.41,129.39L156.16,120.52L162.35,110.1L165.73,99.23L172.94,87.25L178.53,83.25z"
				},
				{
					"id":"BZ-SC",
					"title":"Stann Creek",
					"d":"M252.91,603.65l0.41,2.19l-1.38,0.42l-0.16,-2.19L252.91,603.65zM275.23,601.79l0.97,1.26l1.14,-0.59l-0.08,1.52l-3.41,-0.59l-0.41,1.01l-0.97,-0.34L275.23,601.79zM295.04,577.72l0.49,1.01l-1.06,1.18v-0.93l-1.54,-1.09L295.04,577.72zM259.81,576.96l-0.97,1.94l-0.81,-0.34l0.24,-1.18L259.81,576.96zM299.02,570.23l0.16,0.93l-0.89,0.08L299.02,570.23zM296.75,567.37l0.08,0.51l-0.11,0.97l-0.7,-0.13L296.75,567.37zM310.14,563.83l0.65,1.52l-0.65,-0.25l0.08,0.93l-0.73,0.17L310.14,563.83zM299.59,561.22l0.33,1.1l-0.89,-0.08L299.59,561.22zM304.21,558.95l1.22,2.19l-1.95,-0.59L304.21,558.95zM302.02,557.18l0.16,1.77l-0.97,-1.43L302.02,557.18zM302.02,555.32l0.81,0.25l-0.08,1.6l-1.71,-1.35L302.02,555.32zM302.51,550.78l0.73,0.51l-0.24,1.43l-1.22,-0.59L302.51,550.78zM307.87,549.6l0.41,1.69l-0.89,2.27l0.33,-3.14l-0.41,-0.65L307.87,549.6zM307.22,543.78l0.9,0.76l-0.41,1.18L307.22,543.78zM402.6,543.78l-1.54,0.84l-0.4,-1.1l0.73,-1.01l1.7,-0.08L402.6,543.78zM413.16,535.02l0.73,0.84l-1.71,0.17L413.16,535.02zM313.39,517.08l0.41,0.84l-0.73,0.51L313.39,517.08zM313.47,513.79l0.16,0.84l0.49,-0.59l1.54,0.42l-0.24,0.76l-0.57,-0.34l0.24,0.93l-1.3,-0.67v1.43l-1.38,-1.01L313.47,513.79zM314.69,511.09l-1.3,2.02l0.32,-1.77L314.69,511.09zM327.19,506.62l1.22,0.34l0.73,2.02l-2.27,1.35l0.65,-2.19l-0.49,-0.59l-0.32,1.6l-0.57,-1.26L327.19,506.62zM322.97,492.63l0.41,1.18l-1.14,0.42L322.97,492.63zM329.87,488.92l-0.73,1.35l1.19,3.64l-1.27,-0.69l-0.41,-3.2L329.87,488.92zM335.15,484.54l-2.03,4.05l-0.32,4.64l-1.95,1.77l-0.32,-1.94l1.22,0.84l0.78,-2.08l-0.46,-0.54l0.66,-1.78l-0.17,-1.76l-0.89,1.1l-0.08,-1.18L335.15,484.54zM331.57,465.56l0.81,0.93l-1.95,0.51L331.57,465.56zM332.87,463.2l0.32,0.59l-1.38,0.17l-0.49,1.26v-1.18L332.87,463.2zM343.02,461.85l2.84,0.42l-3.49,1.18l-1.22,-0.59L343.02,461.85zM330.44,459.91v1.01l-1.46,0.68L330.44,459.91zM331.17,457.38l-0.32,1.18l-0.41,-0.51L331.17,457.38zM350.73,453.24l0.16,2.45l-1.62,1.01l-0.08,-3.12L350.73,453.24zM346.83,427.25l2.11,1.6l-0.08,3.55l-3.73,0.08l-2.51,1.86l1.87,-6.08L346.83,427.25zM272.15,423.1l1.14,1.28l0.81,6.42l2.6,4.56l3.25,1.18l4.3,-1.01l1.79,1.35l1.06,9.87l1.79,2.78l-0.49,2.11l0.65,4.3l4.95,10.55l-0.16,3.29l-1.95,5.06l-2.6,1.52l-0.24,1.35l-1.79,-1.1l-4.06,1.01l-7.06,4.47l-0.65,6.24l-2.19,2.28l0.65,4.81l3.98,8.94l2.6,2.44l0.89,-0.17l-1.38,1.35v2.11l1.3,2.44l2.44,1.94l-0.57,0.76l1.3,0.59l-1.54,0.59l-3.25,-1.1l-2.03,0.34l-1.95,4.05l-3.9,0.68l0.08,2.61l-1.54,3.62l-1.14,-3.71l-2.43,0.67l-2.35,2.02l0.08,4.8l-0.97,0.93l2.03,-0.42l1.22,-4.47l2.84,-1.43l-2.27,1.77l-0.97,3.12l1.54,7.33l2.11,3.62l-0.73,3.2l-1.46,1.43l-1.14,3.37l0.89,8.68l-0.97,4.21l-1.62,2.36l-9.26,5.73l-0.81,1.35l-0.97,10.02l-1.87,0.84l-0.97,3.96l1.05,5.3l1.87,4.29l-1.38,1.52l-0.57,2.86l-1.87,0.84l1.3,3.28l-2.84,1.68l-0.16,-1.68l-1.3,0.51l-0.73,-0.92l4.22,-5.13l-0.57,-1.18l0.57,-5.55l-1.14,-2.44l1.54,-9.6l-0.57,0.25l-0.08,-0.84l1.3,-1.6l0.41,1.18l1.22,-0.84l-0.08,-5.56l1.87,-3.45l3.25,-1.01l-0.16,-0.76l1.62,-1.01l-0.57,-1.18l3.73,0.17l2.68,-2.86l0.49,-3.37l-1.62,-1.94l-1.62,-0.25l-0.89,2.53l-2.6,1.09l-2.84,3.03l0.32,2.69l-1.22,2.27l-0.57,0.17l-0.08,-0.84l-1.38,0.25l-4.63,5.31l0.89,2.44l-1.14,2.1l0.16,2.95l1.3,1.85l-0.73,1.35l0.33,2.02l-0.89,3.11l-2.6,0.42l-1.7,2.44l0.89,1.01l1.79,-0.25l1.54,2.86l-1.54,1.77l0.16,-1.18l-0.97,-1.01l-4.14,1.01l-0.32,0.42l-1.06,0.42l-1.05,2.78l-1.3,0.59l4.3,1.68l0.49,-0.84l-1.54,-0.25l-0.89,-2.52l1.54,1.43l1.95,-0.76l1.06,0.59l0.16,0.84l-1.71,2.19l-2.51,0.76l0.65,2.86l0,0l-44.94,-1.92l-0.69,-2.87l4.16,-2.15l0.69,-4.31l-1.39,-7.9l-4.16,-7.18l-8.31,-10.06l2.77,-1.15v-6.04l-4.85,-6.47l-6.23,-3.59l-10.99,-2.13l-36.12,0.69l0,0v-5.75l6.24,-7.91l2.08,-6.47l3.46,-5.03l2.08,-6.47l13.09,-7.86l-0.62,-0.77l1.39,-6.47l8.32,-0.31l0.36,-19.08l4.89,-14.75l4.44,-2.56l6.24,-2.16l2.77,-4.32l3.46,-9.36l2.77,-4.32h4.16v-7.92l-5.54,0.72l-4.16,-5.04l-3.44,-6.44l0.93,-0.84l0,0l4.06,-4.25l0,0h49.72l7.62,3.6H260.3L272.15,423.1zM334.25,415.01l1.95,1.6l-0.97,2.03l-0.05,-2.56l-1.49,-0.9L334.25,415.01zM333.2,412.56l0.49,1.35l-0.65,0.68L333.2,412.56z"
				},
				{
					"id":"BZ-TOL",
					"title":"Toledo",
					"d":"M165.08,706.05l0.24,1.09l-1.14,0.76l-0.33,-0.84l0.81,0.25L165.08,706.05zM170.6,705.13l0.81,0.59l-2.11,-0.08L170.6,705.13zM166.21,704.87l0.57,1.09l-1.3,0.67L166.21,704.87zM150.71,707.56l-1.46,0.84l0.73,-0.84l-0.57,-0.76l0.81,-0.25L150.71,707.56zM164.35,702.86l-0.16,0.84l-0.97,0.08l1.82,0.31l-0.44,-0.57l0.81,-0.25l-0.06,0.89l0.96,-0.56l1.14,1.35l0.89,-1.43l0.81,1.09l-1.79,0.59l-0.81,-0.76h-3.41l-0.32,-1.09L164.35,702.86zM153.31,702.77l1.01,0.66l-0.68,0.77l0.16,1.51l-1.06,-0.08v-1.18l-0.65,0.76l-0.73,-1.43L153.31,702.77zM155.25,701.43l0.41,1.09l0.65,-0.17l-0.97,1.6l-0.73,-0.84L155.25,701.43zM165.32,701.26l3.49,1.6l-2.27,0.67l-0.16,-1.43l-2.27,-0.5L165.32,701.26zM172.71,700.76l0.57,1.09l-1.87,0.59l-0.16,-0.67L172.71,700.76zM153.88,700.25l-0.73,1.01l1.63,-0.34l-1.3,1.6l-0.97,-1.51L153.88,700.25zM158.42,698.4v1.77l-1.79,-0.33l1.06,-0.42l-0.08,-0.84l-1.54,0.84l0.49,-0.92L158.42,698.4zM172.3,694.88l-0.65,2.35l-0.57,-0.59L172.3,694.88zM157.45,693.95l-0.33,0.93l-0.81,-0.25L157.45,693.95zM185.94,691.52l-0.49,1.26l-1.14,-0.08L185.94,691.52zM164.18,691.26l0.41,1.77l-1.14,0.25l1.06,0.34l0.08,1.34l-1.46,0.25l-0.32,-0.75l1.05,-0.59l-0.65,-0.17l-1.3,0.76l-0.08,1.26l-1.3,0.42l-0.33,-0.84l0.98,-0.08l-0.81,-0.92l2.76,-0.76l-0.57,-0.34l0.57,-1.68L164.18,691.26zM173.28,690.68l0.32,1.26l-0.97,-0.25l-1.3,1.51l-0.89,-0.34l0.33,-1.01L173.28,690.68zM164.92,689.25l1.87,0.67l-2.68,0.08L164.92,689.25zM174.74,687.06l0.41,1.09l-1.3,1.18l-0.41,-1.26l0.65,0.59l0.55,-0.99l-0.79,0.15L174.74,687.06zM175.95,686.56l0.33,1.43l-1.3,-0.84L175.95,686.56zM231.97,629.47l0.73,0.93l-0.49,1.43L231.97,629.47zM229.61,629.39l1.7,0.25l-0.65,1.85l-1.22,-0.67L229.61,629.39zM239.52,615.34l0.33,2.1l-1.38,-2.27l3.41,-1.85L239.52,615.34zM132.13,551.16l36.12,-0.69l10.99,2.13l6.24,3.59l4.85,6.47v6.04l-2.77,1.15l8.31,10.06l4.16,7.18l1.39,7.9l-0.69,4.31l-4.16,2.15l0.69,2.87l44.94,1.93l0,0l1.06,0l0.08,1.26l-4.71,0.59l-0.41,4.96l-2.43,1.68l0.24,1.35l-1.3,1.94l0.57,4.04l-0.57,3.28l-2.43,-0.08l-0.57,-1.09l-1.79,0.84v3.53l-3.17,-3.2l-1.3,0.08l1.46,0.76l0.98,5.47l-1.79,-0.34l0.89,2.1l-1.79,1.35l0.16,1.09l1.87,1.01l2.27,-2.52l0.89,1.43l-1.87,1.09l-0.97,1.93l-1.38,-0.67l-2.6,2.19l-1.05,-0.76l0.81,0.09l0.08,-1.09l-0.73,-2.61l-3.9,2.52l-0.16,4.12l-1.46,2.86l0.49,2.61l-1.38,1.18l-2.27,6.56l-5.76,3.95l-4.63,6.22l-4.06,2.1l-0.89,2.27v6.89l-5.93,0.17l-3.25,1.34l-2.11,7.73l-1.14,1.26l0.08,-1.34l-1.46,-2.27l2.27,-2.77l-1.06,-0.92l-1.22,0.17l-1.22,2.35h-1.54l1.46,-1.34l0.89,-2.44l-0.08,-2.6l-2.52,2.44l1.3,2.19l-1.3,1.34l-1.05,-1.26l-2.27,0.25l-1.62,-3.02l-5.19,-4.54l-3.9,-0.08l-1.7,1.01l-0.81,2.02v1.93l1.3,0.59l0.16,1.93l-2.03,2.77l-1.54,-0.17l-1.3,-1.34l-2.44,1.26l0.16,0.93l-5.6,0.59l-1.54,1.18l1.71,0.67l-0.41,1.01l-8.2,-0.76l-0.89,0.67l0.89,1.51l-1.46,-0.08l-1.05,2.77l-3.9,1.01l-0.24,4.2l2.03,4.2l-0.57,2.18l1.95,3.02l1.46,0.17l-4.38,2.44l-0.08,2.94l-2.03,1.01l0.08,1.34l1.54,1.6l-0.57,1.6l-8.04,3.19l-1.62,1.43l-3.33,0.76l-0.89,1.26l-0.65,4.45l-2.19,2.69l-0.73,3.53l-5.84,0.25l-1.46,2.85l-2.19,0.84l-0.49,1.18l-2.43,1.43l-0.57,6.88l-1.06,1.85l-10.79,6.3l-5.76,2.18l-2.03,2.94l-1.78,0.25l-0.81,1.01l-1.22,7.3l3.57,11.5l3.01,6.42l-7.98,3.25L80.19,792l-10.28,-1.76l-3.65,-1.94l-5.55,1.85l-1,-2.74l-4.08,-2.14l-2.5,0.31l-1.54,2.1l-1.94,-3.91l-1.25,1.12l0.01,3.94l-1.3,-0.72l0.04,1.58l-0.9,-0.27l-2.31,-2.62l-0.18,2.9l-1.14,-0.5l-0.08,1.34l-0.82,0.07l-2.01,-3.79l-1.31,-0.69l-5.3,0.99l0.74,1.73l-1.37,0.28l0.03,1.11l-1.93,-0.96l-2.13,0.35l-2.1,-1.89l-4.7,2.89l-3.03,-1.16l-4.97,-3.57l-0.82,0.24l-0.59,2.59l-2.24,0.01l-6.7,2.51l-1.49,-0.73l-0.3,-1.43l-1.02,0.14L0,781.15l2.3,-22.45l8.13,-125.6l0,0l8.77,-0.76l4.85,-10.05l5.54,-3.59l2.77,-4.31h19.4l6.24,-10.77l4.85,0.72l2.77,4.31l5.54,0.72l8.31,-3.59l2.77,-5.74l4.85,-3.59l8.31,-2.15l10.39,-7.18l6.24,-2.87l12.47,-12.93v-3.59l-4.85,-1.44v-3.59l6.93,-1.44l0.67,-6.23l1.17,0.01L132.13,551.16z"
				}
			]
		}
	}
};
