﻿// (c) ammap.com | SVG (in JSON format) map of Angola - Low
// areas: {id:"AO-BGO"},{id:"AO-BGU"},{id:"AO-BIE"},{id:"AO-CAB"},{id:"AO-CCU"},{id:"AO-CNO"},{id:"AO-CUS"},{id:"AO-CNN"},{id:"AO-HUA"},{id:"AO-HUI"},{id:"AO-LUA"},{id:"AO-LNO"},{id:"AO-LSU"},{id:"AO-MAL"},{id:"AO-MOX"},{id:"AO-NAM"},{id:"AO-UIG"},{id:"AO-ZAI"}
AmCharts.maps.angolaLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"11.670058",
				"topLatitude":"-4.372036",
				"rightLongitude":"24.083386",
				"bottomLatitude":"-18.042991"
			}
		},
		"g":{
			"path":[
				{
					"id":"AO-BGO",
					"title":"Bengo",
					"d":"M106.31,267.56l15.36,0.77l0.96,1.13l-0.03,1.09l4.06,3.24l3.83,4.8l5.82,2.86l3.47,0.34l7.31,-1.54l2.41,0.3l1.14,0.95l-0.19,9.32l-3.36,5.69l-0.64,2.3l-0.07,2.54l0.9,2.77l0,0l-3.16,1.66l-10.33,-0.26l-5.06,3.37l-0.6,3.08l3.78,4.27l1.68,4.61l0.14,2.29l-1.83,3.16l-3.46,2.45l-3.65,1.43l-4.5,0.28l-1.33,3.2l3.3,2.05l0.48,2.43l-0.85,1.08l-3.43,1.3l-0.42,1.21l1.11,1.06l3.67,0.07l1.15,0.79l0.64,1.15l-1.16,1.04l-0.14,1.15l2.07,2.22l-0.18,1.23l-2.76,3.05l-0.68,3.41l-2.21,5.16l1.63,0.76l1.06,3.7l2.38,1.09l3.31,-0.21l1.23,2.18l1.4,0.73l4.24,-0.47l3.19,1.63l1.01,1.74l2.53,1.61l1.76,-0.77l0,0l0.69,9.68l-2.43,3.12l2.58,6.3l-1.8,1.94l0.8,2.42l2.26,1.81l0.62,2.28l-1.21,3.28l-2.24,2.61l-3.56,-1.32l-3.86,-4.6l-2.34,-0.33l-3.28,-1.71l-4.65,0.07l-2.4,1.14l-3.01,3.13l-3.99,1.94l-2.94,-1.89l-5.31,0.69l-0.32,-0.87l-2.99,-0.01l-1.8,-0.95l-0.55,0.06l0.39,0.87l-0.97,0.25l-2.7,-4.13l-4.24,-1.76l-0.42,-1.38l-2.11,-0.5l-1.23,1.49l0,0l-2.07,-2.7l-0.85,-3.25l-6.26,-6.94l1.44,-1.48l-1.48,-2.98l0.08,-1.2l-5.83,-9.04l2.04,-2.51l-2.19,-3.9l0.67,-1.6l-1.77,-2.99l0.37,-2.65l-1.4,-3.14l0,0l0.79,-1.32l0.92,0.35l0.41,-1.83l0.64,-0.15l0,0l0.66,-1.65l0,0l0.51,-2.36l4.13,-2.86l3.57,1.4l0.19,-1.26l4.23,0.47l-0.42,-4.67l1.49,-4.65l1.5,-1.1l-0.02,-2.75l3.87,-2.03l1.42,-0.06l-5.53,-10.24l-2.28,1.33l0,0l-3.59,-2.35l-1.51,-2.19l-1.3,-5.58l2.12,-0.66l0.08,-3.82l-6.22,-10.24l0.12,-1.9l-2.64,-3.06l-3.3,-8.02l-2.46,-3.62l1.75,0.7l1.06,-1.48l-2.41,-0.19l-0.81,-0.86l0,0l4.47,-0.88l3.68,-2.46l1.89,0.73l1.07,-1.62l4.26,-1.18l3.27,2.21l2.32,0l1.16,-0.88l4.44,-0.81l1.47,-1.27l3.6,-0.06L106.31,267.56z"
				},
				{
					"id":"AO-BGU",
					"title":"Benguela",
					"d":"M104.98,473.86l5.21,-0.37l3.43,1.54l3.41,-1.09l2.44,0.54l0.7,4.85l0.76,1.08l3.69,1.69l2.38,3.38l2.49,-1.07l3.9,-5.37l3.56,-1.99l2.42,-0.11l5.75,7.02l2.97,5.97l4.7,0.58l3.46,-1.18l5.77,2.81l1.05,0.75l0.28,2.35l2.27,0.47l0,0l-0.17,7.62l1.91,4.71l-0.64,1.05l1.26,2.17l-0.9,1.32l-6.22,1.7l-1.79,2.38l-4.71,2.97l1.28,2.48l-0.8,2.33l1.87,3.74l0.04,2.32l3.55,6l0.84,4.88l-1.29,3.59l3.62,6.26l3.3,1.5l1.12,2.25l2.11,0.85l0,0l-0.96,4.44l-1.98,-0.04l-3.57,2.11l-3.27,-1.3l-5.56,5.6l-4.9,1.78l-2.42,0.63l-6.32,-2.98l-1.07,-0.28l-1.22,0.7l0.15,2.21l-1.12,0.39l-4.87,9.95l-1.1,0.35l-5.95,-0.07l-6.21,-1.36l-2.42,0.66l-4.86,-1.78l-4.7,1.74l-4.65,-0.77l-2.24,-1.83l-1.15,-0.11l-5.79,2.35l0,0l-2.48,0.07l-3.41,-1.57l-2.21,1.27l-1.19,-0.76l-1.51,-3.59l-2.79,-3.54l-0.12,-2.25l1.13,-2.35l-0.31,-1.19l-1.09,-0.62l-10.55,-2.17l-0.85,2.3l-7.94,3l-3.16,-2.32l-2.54,-0.05l-8.01,-2.3l-3.43,-0.03l0,0l0.1,-1.2l-0.82,-0.28l0.34,-2.11l-0.7,-0.29l0.29,-1.64l0.74,0.14l0.26,-1.01l0.69,0.52l1.14,-0.7l1.26,-1.94l1.88,-0.94l-0.64,-2.54l1.03,-0.04l-0.73,-0.27l0.51,-1.96l0.82,0.66l1.73,-1.03l-0.04,-1.33l1.16,1.08l1.04,-1.68l1.63,-0.19l0.56,-1.66l-0.75,-0.38l1.96,-1.23l0.48,0.45l0.59,-1.19l1.73,-0.53l2.07,-3.73l3,-2.42l-1.92,-5.72l0.01,-1.74l9.85,-8.26l0.52,-1.69l2.04,-1.7l0.62,-0.19l-0.1,0.68l1.6,0.54l1.56,-1.12l-0.08,-0.85l1.82,-0.17l0.92,1.46l1.1,0.2l6.49,-5.19l0.53,-1.66l-0.38,-1.11l1.9,-4.14l1.6,-1.32L94,502.77l3.79,-5.18l1.06,-4.94l1.73,-2.06l0.86,-5.76l1.84,-1.65L104.98,473.86z"
				},
				{
					"id":"AO-BIE",
					"title":"Bié",
					"d":"M243.56,413.91L245.11,415.28L244.06,416.29L244.51,417.88L245.99,418.14L246.4,419.62L249.04,420.51L251.96,423.75L254.21,424.07L257.49,423.39L261.62,424.12L267.92,427.43L268.61,426.07L270.85,426.06L271.19,427.71L274.1,428.69L277.18,428.51L281.26,432.02L281.87,435.91L283.4,437.17L285.43,441.33L284.96,444.24L283.3,444.62L281.86,445.94L283.46,447.1L285.5,447.34L286.14,451.13L288.67,454.79L286.99,459.57L288.63,459.19L289.03,460.12L286.62,462.59L288.55,467.41L287.43,469.73L290.08,470.54L292.12,472.12L295.01,471.23L296.33,469.02L298.59,468.41L299.81,466.2L304.51,462.19L304.56,456.76L303.76,453.37L306.48,455.72L307.55,458.08L307.94,461.38L310.21,461.8L312.38,461.28L314.52,463.28L316.33,462.34L319.82,463.02L326.14,461.43L328.64,462.53L332.33,462.6L334.49,461.46L338.53,457.28L342.67,455.35L348.95,453.45L353.41,453.92L353.94,452.86L353.29,449.89L350.11,446.87L351.11,443.02L349.69,441.01L349.3,438.64L350.36,434.98L349.98,433.93L349.98,433.93L361.97,440.94L365.88,445.53L371.92,446.57L373.64,450.03L371.88,452.47L370.8,458.12L370.8,458.12L369.42,458.47L366.19,462.13L364.93,468.66L363.84,469.75L359.33,470.47L360.79,473.56L360.07,474.68L357.65,474.21L356.08,478.66L354.04,480.52L353.77,483.04L355.22,485.48L355.09,487.33L347.71,494.36L347.67,495.52L348.72,496.47L348.39,497.78L347.52,498.84L344.88,499.35L341.56,502.8L338.86,503.2L333.78,507.92L332.8,508.97L332.88,512.52L327.33,519.04L327.44,522.45L325.17,523.67L321.4,527.3L320.73,526.18L319.52,527.24L321.59,533.12L321.15,534.25L318.82,535.69L318.37,537.9L314.87,539.47L315.51,540.83L313.69,543.12L316.26,547.69L316.53,550.04L316.21,551.12L312.32,552.5L309.03,555.38L310.95,559.06L309.24,561.83L309.93,564.03L309.93,564.03L308.74,568.37L307.54,569.39L301.64,570.12L302.93,573.89L302.64,578.42L301.29,581.14L294.66,585.57L289.87,586.55L287.95,586.31L286.09,587.25L283.5,591.03L280.29,593.4L280.04,597.03L278.16,600.08L278.65,601.55L278.2,601.79L273.44,600.35L271.84,598.2L269.61,597.9L264.73,594.41L263.68,589.39L261.11,585.93L259.75,585.29L258.26,585.08L254.62,587.62L248.86,584.27L244.14,586.33L238.22,585.92L237.12,586.48L237.12,586.48L237.61,579.21L236.97,576.46L239.45,568.85L239.86,564.36L240.04,560.58L239.15,556.69L239.73,553.61L239.73,553.61L240.42,543.49L239.08,536.76L238.7,523.08L231.79,519.87L231.33,517.25L229.21,515.88L228.65,514.65L228.53,512.34L232.11,510.01L232.45,508.84L233,504.65L231.32,502.22L230.57,498.7L237.77,492.78L239.26,488.19L242.25,484.23L242.19,480.75L237.58,476.41L236.55,472.72L232.89,470.81L232.86,469.37L230.61,468.14L229.4,466.09L228.04,459.59L223.43,459.9L222.38,458.81L218.78,458.94L216.55,457.06L215.27,457.41L213.18,459.4L208.43,460.11L201.43,457.57L201.43,457.57L203.59,452.81L203.29,449.23L209.2,440.92L211.43,432.75L214.82,435.18L216.13,435.27L218.4,433.87L221.91,435.6L224.13,435.48L229.31,427.22L236.75,423.23L238.49,420.35L241.38,419.11L242.88,416.49L242.39,415.08z"
				},
				{
					"id":"AO-CAB",
					"title":"Cabinda",
					"d":"M55.52,108.92L56.43,109.94L60.86,109.44L61.02,112.3L64.96,115.93L66.3,118.42L70.77,121.09L70.92,122.77L69.76,123.2L68.55,122.67L61.87,125.31L58.9,125.64L56.53,127.94L55.41,130.21L55.8,130.9L52.33,133.7L51.72,135.98L47.88,136.05L47.35,139.55L42.43,141.81L39.98,141.87L39.58,143.05L40.37,144.17L42.84,145.21L42.73,174.56L29.44,175.03L26.53,176.31L26.99,177.5L24.72,174.23L23.53,169.9L25.34,165.52L26.75,165.91L27.66,165.25L27.33,161.3L24.61,154.71L25.14,153.95L22.87,150.38L22.91,148.25L23.61,147.85L21.76,146.16L22.68,148.22L16.83,139.97L24.89,133.45L26.71,127.05L28.86,129.49L31.21,129.3L34.02,126.53L38.85,118.84L46.72,117.06L49.02,113.27L53.82,113.21L52.16,110.92L52.24,108.97L53.39,107.64z"
				},
				{
					"id":"AO-CCU",
					"title":"Cuando-Cubango",
					"d":"M309.93,564.03L323.56,571.9L328.02,571.21L335,575.82L336.13,576.23L338.44,575.36L343.1,579.03L344.7,579.4L345.06,580.76L348.13,583.33L348.48,585.03L350.95,588.57L350.63,590.61L352.08,594.49L351.83,597.15L352.98,599.53L353.93,600.07L354.01,601.66L356.15,605.3L358.62,606.21L364.69,604.25L371.66,608.01L369.91,599.93L372.55,598.5L374.78,598.57L376.95,600.4L381.93,601.11L387.64,599.93L389.32,603.26L391.98,605.44L392.54,608.36L394.06,609.63L395.63,613.6L397.84,614.85L398.28,616.42L405,622.13L405.66,623.62L406.76,623.56L406.79,624.81L408.34,624.66L409.97,625.78L411.37,628.19L414.84,631.64L418.91,633.88L423.93,635.87L427.71,635.51L432.21,636.57L435.13,635.37L437.89,636.02L440.24,634.89L441.89,635.26L443.79,634.36L445.69,635.88L450.41,636.85L451.4,635.74L452.56,635.75L454.37,637.43L456.5,636.99L458.24,638.75L460.78,639.43L465.45,645.26L467.79,645.21L467.4,646.81L468.05,647.69L470.43,647.53L472.15,648.58L473.62,653.33L475.31,655.18L477.92,656.8L480.31,657.13L481.81,658.35L482.64,660.32L482.58,664.6L484.86,665.65L485.73,667.55L487.34,668.78L487.05,670.94L488.62,672.17L489.94,675.73L492.08,677.8L495.2,678.85L495.32,681.9L497.61,682.92L498.54,685.89L500.12,687.15L500.98,690.82L509.34,696.19L509.34,696.19L509.51,697.96L513.05,700.98L512.77,702.4L515.08,705.82L516.24,711.92L516.96,712.87L520.48,716.8L522.33,717.29L523.31,719.21L524.92,719.82L526.86,723.05L533.84,729.13L534.79,731.14L538.1,733.7L543.52,739.55L543.5,740.47L544.85,740.85L545.69,742.62L548.3,744.67L549.25,746.13L549.14,747.34L553.86,749.15L559.1,753.25L559.17,754.13L561.62,756.13L562.83,759.49L565,760.45L565.64,762.46L567.71,763.07L570.52,766.67L575.3,766.91L576.61,768.18L577.96,768.34L579.55,769.89L579.76,771.27L481.42,791.07L478.86,790.28L477.64,789.09L473.31,788.12L470.88,786.34L459.11,787.52L453.67,790.31L453.55,791.6L451.1,791.98L447.94,791.06L447.76,790.26L445.53,790.72L442.61,788.72L437.14,788.73L434.04,787.17L433.1,785.54L428.99,784.61L426.37,782.89L425.11,783.63L423.94,783.13L422.61,784.47L419.15,783.73L416.37,785.29L413.7,784.23L412.08,784.86L409.32,784.35L406.45,782.92L404.61,783.92L400.76,783.5L398.4,785.39L397.02,783.74L396.16,784.09L394.08,782.25L389.54,783.28L381.38,783.17L379.72,782.22L377.47,782.56L376.4,781.28L373.52,780.57L372.43,781.12L368.38,780.15L366.76,781.59L357.04,780.71L354.89,779.97L353.62,778.47L351.44,778.11L350.4,776.57L349.12,776.69L348.18,775.29L342.93,771.45L342.54,769.76L341.66,768.83L340.02,768.51L337.36,764.18L335.75,763.37L335.35,761.66L332.96,758.66L276.39,758.46L276.39,758.46L277.79,751.08L273.74,738.03L273.76,732.24L274.35,725.74L277.25,720.18L278.51,715.14L281.93,711.73L283.42,706.63L283.48,700.33L281.83,690.87L282.03,682.82L280.91,680.53L277.53,677.51L271.01,664.93L267.52,664.02L266.5,662.85L265.73,659.37L264.8,659.93L264.09,658.51L261.27,657.72L259,655.8L258.8,654.12L255.41,651.68L255.42,649.62L252.6,648.24L251.76,647.01L252.25,645.55L250.44,644.74L250.44,644.74L248.03,641.57L248.81,639.77L248.52,638.02L245.84,634.48L246.21,630.31L245.51,627.58L243.51,625.7L244.73,622.74L241.95,621.95L242.3,620.84L241.17,620.72L238.53,618.23L238.8,607.98L237.34,604.68L236.48,599.48L237.57,597.74L238.29,593.51L237.12,589.92L237.76,587.86L237.12,586.48L237.12,586.48L238.22,585.92L244.14,586.33L248.86,584.27L254.62,587.62L258.26,585.08L259.75,585.29L261.11,585.93L263.68,589.39L264.73,594.41L269.61,597.9L271.84,598.2L273.44,600.35L278.2,601.79L278.65,601.55L278.16,600.08L280.04,597.03L280.29,593.4L283.5,591.03L286.09,587.25L287.95,586.31L289.87,586.55L294.66,585.57L301.29,581.14L302.64,578.42L302.93,573.89L301.64,570.12L307.54,569.39L308.74,568.37z"
				},
				{
					"id":"AO-CNO",
					"title":"Cuanza Norte",
					"d":"M147.27,304.12L147.91,306.07L149.74,305.76L153.43,306.76L155.82,305.8L160.04,300.09L162.56,300.33L165.05,301.96L167.62,300.73L170.34,301.05L171,298.96L172.3,298.85L174.42,296.18L174.47,293.09L175.54,291.45L174.52,289.83L173.23,289.83L174.43,286.9L174.04,284.3L178.54,283.23L184.52,283.08L185.97,283.86L186.79,285.1L187.06,288.39L188.81,289.13L193.44,288.33L195.19,286.68L199.72,286.61L202.49,288.66L201.08,289.89L201.72,291.7L203.04,291.29L203.71,291.99L203.95,296.77L203.95,296.77L204.52,304.98L205.2,305.94L203.88,307.48L197.49,309.06L197.75,311.28L194.49,315.9L195.86,318.77L199.4,319.66L200.47,322.11L199.01,324.36L197.2,330.04L195.81,336.93L196.38,340.42L195.97,343.38L194.29,344.49L190.9,344.76L188.14,343.83L182.1,347.13L178.18,347.64L176.8,348.98L176.07,353.67L169.98,354.47L172.87,356.56L173.43,358.96L169.99,361.99L170.1,363.05L171.94,365.01L172.54,368.54L172.24,369.59L169.63,371.87L169.63,371.87L168.2,371.91L166.24,370.39L162.04,369.5L162.39,370.71L161.36,371.7L157.66,371.47L153.28,372.23L151.41,373.84L146.06,374.57L143.28,374.03L143.28,374.03L141.52,374.79L138.99,373.18L137.97,371.44L134.79,369.82L130.54,370.29L129.15,369.56L127.91,367.38L124.6,367.59L122.22,366.5L121.16,362.8L119.53,362.04L121.74,356.88L122.42,353.47L125.19,350.42L125.36,349.19L123.3,346.97L123.43,345.83L124.59,344.79L123.95,343.65L122.8,342.86L119.13,342.79L118.02,341.73L118.45,340.52L121.88,339.22L122.73,338.14L122.25,335.72L118.95,333.66L120.28,330.46L124.78,330.19L128.43,328.75L131.89,326.3L133.72,323.14L133.58,320.86L131.9,316.24L128.12,311.98L128.72,308.89L133.78,305.52L144.11,305.78z"
				},
				{
					"id":"AO-CUS",
					"title":"Cuanza Sul",
					"d":"M143.28,374.03L146.06,374.57L151.41,373.84L153.28,372.23L157.66,371.47L161.36,371.7L162.39,370.71L162.04,369.5L166.24,370.39L168.2,371.91L169.63,371.87L169.63,371.87L174.81,375.53L180.98,376.1L187.4,374.59L202.25,374.53L204.53,371.37L205.76,371.23L209.2,372.24L214.1,371.56L222.77,372.88L224.58,375.08L225.32,377.42L228.5,379.18L229.37,380.35L228.96,383.39L231.07,386.1L231.38,389.19L232.67,391.84L230.02,395.08L230.65,398.87L233.25,399.64L234.53,401.07L235.74,402.64L235.79,406.1L237.82,406.7L243.56,413.91L243.56,413.91L242.39,415.08L242.88,416.49L241.38,419.11L238.49,420.35L236.75,423.23L229.31,427.22L224.13,435.48L221.91,435.6L218.4,433.87L216.13,435.27L214.82,435.18L211.43,432.75L209.2,440.92L203.29,449.23L203.59,452.81L201.43,457.57L201.43,457.57L199.6,459.25L190.26,460.76L188.05,462.26L184.44,463.03L182.29,464.74L181.91,468.44L183.25,470.4L183.4,472.71L184.58,473.6L183.91,476.85L182.71,477.71L183.61,478.88L182.72,482.47L183.44,483.69L179.73,483.47L176.88,486.18L175.68,485.7L173.15,487.23L170.13,487.59L168.06,489.65L165.63,495.72L165.63,495.72L163.36,495.24L163.08,492.89L162.03,492.14L156.26,489.33L152.8,490.51L148.1,489.93L145.13,483.96L139.38,476.94L136.96,477.06L133.41,479.05L129.5,484.41L127.02,485.48L124.63,482.11L120.94,480.41L120.18,479.33L119.48,474.48L117.04,473.94L113.63,475.03L110.19,473.49L104.98,473.86L104.98,473.86L104.46,465.99L103.53,464.24L104.39,462.96L104.2,460.35L105.37,455.17L104.9,452.52L106.54,450.76L106.3,447.68L108.28,435.85L106.48,430.47L101.08,423.19L102.35,422.73L104.19,419.59L96.29,409.47L91.77,404.9L92.66,403.53L92.43,402.04L91.6,399.09L90.26,397.61L90.26,397.61L91.49,396.12L93.61,396.63L94.02,398L98.26,399.77L100.96,403.9L101.93,403.65L101.54,402.78L102.09,402.72L103.89,403.68L106.88,403.69L107.2,404.56L112.51,403.87L115.46,405.76L119.44,403.83L122.46,400.7L124.86,399.57L129.51,399.49L132.79,401.21L135.13,401.54L138.99,406.14L142.55,407.46L144.79,404.85L146,401.57L145.38,399.29L143.12,397.48L142.32,395.06L144.13,393.13L141.54,386.83L143.97,383.71z"
				},
				{
					"id":"AO-CNN",
					"title":"Cunene",
					"d":"M89.43,700.02L96.51,706.36L98.79,705.62L103.76,702.87L109.85,694.59L111.37,694.33L114.27,697.24L116.43,697.62L120.17,693.12L126.71,691.77L127.77,690.59L133.46,687.71L140.91,679.68L144.36,680.58L147.9,680.02L162.03,683.4L165.32,686.15L166.29,689.56L172.2,690.55L173.89,687.1L176.86,683.79L180.35,675.6L183.41,672.53L187.5,664.06L194.63,658.69L196.17,658.76L199.78,656.27L202.01,656.7L205.39,656.02L208.34,657.13L215.45,657.57L220.43,656.26L224.2,656.98L231.87,647.9L234.16,646.11L240.17,643.91L244.87,644.77L250.44,644.74L250.44,644.74L252.25,645.55L251.76,647.01L252.6,648.24L255.42,649.62L255.41,651.68L258.8,654.12L259,655.8L261.27,657.72L264.09,658.51L264.8,659.93L265.73,659.37L266.5,662.85L267.52,664.02L271.01,664.93L277.53,677.51L280.91,680.53L282.03,682.82L281.83,690.87L283.48,700.33L283.42,706.63L281.93,711.73L278.51,715.14L277.25,720.18L274.35,725.74L273.76,732.24L273.74,738.03L277.79,751.08L276.39,758.46L276.39,758.46L268.02,758.92L125.51,758.15L125.03,759.58L122.45,760.69L120.46,760.32L119.59,761.15L115.88,759.99L112.82,760.68L111.44,759.89L110.76,757.9L109.06,756.45L99.05,751.09L96.92,748.9L90.82,745.38L91.4,743.1L88.78,739.44L84.31,737.19L82.83,737.16L82.83,737.16L80.83,731.96L73.69,724.83L72.3,722.33L73.3,720.04L76.8,717.95L78.57,715.41L77.64,713.11L75.63,711.2L76.76,709.45L79.03,708.64L80.15,706.92L81.71,706.84L82.49,705.29L83.04,706L85.44,704.58z"
				},
				{
					"id":"AO-HUA",
					"title":"Huambo",
					"d":"M201.43,457.57L208.43,460.11L213.18,459.4L215.27,457.41L216.55,457.06L218.78,458.94L222.38,458.81L223.43,459.9L228.04,459.59L229.4,466.09L230.61,468.14L232.86,469.37L232.89,470.81L236.55,472.72L237.58,476.41L242.19,480.75L242.25,484.23L239.26,488.19L237.77,492.78L230.57,498.7L231.32,502.22L233,504.65L232.45,508.84L232.11,510.01L228.53,512.34L228.65,514.65L229.21,515.88L231.33,517.25L231.79,519.87L238.7,523.08L239.08,536.76L240.42,543.49L239.73,553.61L239.73,553.61L236.01,554.2L232.63,553.05L228.88,554.21L227.61,553.56L227.08,552.27L225.86,552.45L223.25,553.85L220.86,557.63L217.44,558.22L214.09,555.48L211.8,555.35L201.66,566.64L196.96,568.6L195.16,571.85L190.33,574.17L189.25,573.97L189.24,567.55L184.67,567.75L182.87,566.21L182.37,558.86L180.33,555.35L179.24,554.86L172.15,556.69L169.99,555.84L169.99,555.84L167.89,554.99L166.77,552.74L163.47,551.24L159.85,544.98L161.14,541.39L160.3,536.51L156.75,530.51L156.71,528.19L154.84,524.45L155.64,522.12L154.36,519.64L159.06,516.67L160.86,514.28L167.08,512.58L167.98,511.26L166.73,509.09L167.37,508.04L165.46,503.33L165.63,495.72L165.63,495.72L168.06,489.65L170.13,487.59L173.15,487.23L175.68,485.7L176.88,486.18L179.73,483.47L183.44,483.69L182.72,482.47L183.61,478.88L182.71,477.71L183.91,476.85L184.58,473.6L183.4,472.71L183.25,470.4L181.91,468.44L182.29,464.74L184.44,463.03L188.05,462.26L190.26,460.76L199.6,459.25z"
				},
				{
					"id":"AO-HUI",
					"title":"Huíla",
					"d":"M169.99,555.84L172.15,556.69L179.24,554.86L180.33,555.35L182.37,558.86L182.87,566.21L184.67,567.75L189.24,567.55L189.25,573.97L190.33,574.17L195.16,571.85L196.96,568.6L201.66,566.64L211.8,555.35L214.09,555.48L217.44,558.22L220.86,557.63L223.25,553.85L225.86,552.45L227.08,552.27L227.61,553.56L228.88,554.21L232.63,553.05L236.01,554.2L239.73,553.61L239.73,553.61L239.15,556.69L240.04,560.58L239.86,564.36L239.45,568.85L236.97,576.46L237.61,579.21L237.12,586.48L237.12,586.48L237.76,587.86L237.12,589.92L238.29,593.51L237.57,597.74L236.48,599.48L237.34,604.68L238.8,607.98L238.53,618.23L241.17,620.72L242.3,620.84L241.95,621.95L244.73,622.74L243.51,625.7L245.51,627.58L246.21,630.31L245.84,634.48L248.52,638.02L248.81,639.77L248.03,641.57L250.44,644.74L250.44,644.74L244.87,644.77L240.17,643.91L234.16,646.11L231.87,647.9L224.2,656.98L220.43,656.26L215.45,657.57L208.34,657.13L205.39,656.02L202.01,656.7L199.78,656.27L196.17,658.76L194.63,658.69L187.5,664.06L183.41,672.53L180.35,675.6L176.86,683.79L173.89,687.1L172.2,690.55L166.29,689.56L165.32,686.15L162.03,683.4L147.9,680.02L144.36,680.58L140.91,679.68L133.46,687.71L127.77,690.59L126.71,691.77L120.17,693.12L116.43,697.62L114.27,697.24L111.37,694.33L109.85,694.59L103.76,702.87L98.79,705.62L96.51,706.36L89.43,700.02L89.43,700.02L90.72,699.32L92.32,696.08L89.84,690.12L95.55,678.57L92.93,673.81L93.24,661.64L89.49,660.23L87.14,658.38L86.4,657.23L87.05,654.78L86.29,652.45L84.92,652.12L84.4,653.2L82.02,654.13L80.98,652.87L81.15,649.88L77.34,650.25L76.22,649.23L76.13,648.04L79.81,645.93L80.2,644.73L77.28,641.29L79.68,637.64L78.44,632.65L80.44,630.49L82.81,630.12L87.35,626.06L93.98,622.4L96.45,616.61L96.72,611.82L99.47,608.08L98.79,601.67L99.19,599.18L98.03,598.66L96.92,599.25L95.76,598.45L95.28,597.23L96.09,594.67L94.22,589.9L97.16,583.61L96.81,582.42L94.66,580.96L93.77,578.23L93.77,578.23L99.57,575.87L100.72,575.99L102.96,577.82L107.62,578.59L112.32,576.85L117.18,578.63L119.6,577.97L125.82,579.33L131.77,579.4L132.87,579.05L137.74,569.1L138.87,568.71L138.72,566.49L139.94,565.79L141,566.07L147.32,569.06L149.74,568.42L154.64,566.65L160.21,561.05L163.47,562.35L167.05,560.23L169.03,560.28z"
				},
				{
					"id":"AO-LUA",
					"title":"Luanda",
					"d":"M89.09,319.81l2.28,-1.33l5.53,10.24l-1.41,0.07l-3.87,2.04l0.02,2.75l-1.5,1.1l-1.49,4.65l0.42,4.67l-4.23,-0.47l-0.19,1.26l-3.57,-1.4l-4.13,2.86l-0.51,2.36l0,0l-0.66,1.65l0,0l-0.64,0.15l-0.41,1.83l-0.92,-0.34l-0.79,1.32l0,0l-7.59,-12.47l0.04,-3.26l1.11,0.06l-0.81,0.17l0.64,3.4l0.19,-1.21l1.64,-1.4l2.53,-4.63l2.16,-0.08l0.49,-2.41l2.12,-2.3l0.66,-2.48l2.7,-0.73l1.62,-2.08l3.1,1l1.06,-0.8l1.48,-4.23l-0.26,-2.02L89.09,319.81z"
				},
				{
					"id":"AO-LNO",
					"title":"Lunda Norte",
					"d":"M434.01,232.66L441.67,232.69L441.24,235.75L439.81,237.26L437.55,244.07L437.45,250.85L498.53,250.97L500.46,253.13L501.38,256L500.91,256.85L502.13,258.01L501.61,259.62L502.3,260.41L501.28,262.63L502.12,264.46L501.84,266.83L500.88,267.68L497.91,275.35L498.04,281.1L496.8,283.33L502.19,293.48L503.76,295.02L503.33,296.12L504.23,300.76L505.88,301.9L505.88,301.9L501.95,304.13L499.71,307.79L496.04,307.38L491.26,309.15L487.92,313.45L478.48,315.11L473.66,313.89L471.2,314.96L467.69,314.53L464.98,316.09L461.38,316.36L456.8,318.78L455.83,320.99L451.01,323.78L447.77,328.97L445.82,335.19L443.46,336.54L439.79,337.02L435.89,339.98L431.04,341.14L429.35,346.74L428.45,347.83L427.38,348.6L421.33,349.43L410.18,359.03L408.52,371.48L406.34,375.32L402.87,379.04L401.65,379.96L393.55,381.64L390.01,384.68L383.68,385.54L378.74,389.76L373.09,391.17L369.88,394.61L366.2,396.45L363.64,397.42L355.43,398.54L351.73,402.94L345.8,405.53L335.4,405.58L336.79,406.97L336.05,407.95L337.3,407.98L338.56,409.01L338.56,409.01L334.97,410.75L333.63,412.99L335.73,416.07L334.55,418.46L328.55,418.94L321.8,415.69L317.31,411.91L312.9,410.85L312.91,409.79L310.75,406.89L315.81,402.23L315.78,400.78L312.79,399.34L310.86,397.27L309.75,394.34L308.53,393.71L308.35,391.26L309.12,389.19L307.06,386.13L306.76,384.43L305.31,384.07L304.38,382.97L302.74,377.7L298,375.47L294.32,376.03L293.51,374.95L293.69,372.7L292.27,370.42L287.83,369.28L286.75,368.48L286.04,366.27L283.67,365.79L282.97,364.68L283.02,361.23L280.79,357.91L279.14,352.15L281.44,350.22L289.55,347.66L290.57,346.31L290.5,344L292.48,340.55L290.8,334.62L292.27,326.81L292.22,314.78L289.95,313.32L288.73,309.41L289.43,305.99L291.14,303.8L290.4,302.98L289.69,298.31L289.55,296.17L290.26,294.97L288.72,293.15L289.25,291.7L289.25,291.7L290.47,292.66L292.99,292.71L298.4,291.15L302.13,291.84L306.48,290.26L309.18,290.43L311.26,291.93L312.15,291.19L317.1,291.26L316.46,289.72L316.99,288.35L318.81,288.08L319.7,286.78L322.85,285.84L326.64,285.77L327.32,286.05L327.15,287.04L330.67,287.71L331.79,287.01L331.43,286.36L338.15,286.36L338.39,282.42L350.58,282.48L350.51,284.56L351.6,286.36L379.84,286.13L378.36,281.38L379.41,279.5L379.28,277.06L380.51,275.61L381.63,271.57L379.62,265.74L380.23,265.04L384.8,264.94L385.8,263.27L385.4,261.77L387.18,260.35L388.59,260.26L385.82,255.12L386.27,254.5L385.47,252.43L386.35,247.28L385.88,245.73L387.74,241.31L389.19,239.79L388.26,236.93L425.62,236.86L426.38,232.67z"
				},
				{
					"id":"AO-LSU",
					"title":"Lunda Sul",
					"d":"M506.53,307.46L507.37,310.95L506.51,312.62L506.64,314.33L505.53,316.06L506.21,316.74L505.09,318.41L504.35,321.95L504.64,324.31L502.53,331.4L501.98,337.01L502.55,338.44L501.63,339.26L502.6,347.14L499.14,356.74L501.21,358.95L500.97,360.56L502.85,363.96L503.23,368.3L506.11,369.97L508.2,373.82L509.52,373.2L509.96,376.38L512.95,379.45L514.07,379.87L515.1,379.34L518.78,381.91L519.64,384.89L519.12,385.49L520.13,386.64L521,395.96L523.16,398.52L523.26,400.56L524.48,401.85L525.52,404.71L523.78,410.31L523.05,410.85L524.89,412.42L524.96,415.84L524.96,415.84L522.94,416.69L520.66,416.66L516.37,414.87L513.54,414.72L511.36,416.67L499.8,416.47L497.15,420.68L496.69,426.64L493.11,429.93L492.08,435.55L493.45,438.27L494.52,438.34L494.44,442.25L488.76,444.5L486.58,444.18L486.01,443.46L485.83,443.97L484.42,443.73L483.48,445.47L480.57,445.63L479.6,446.63L477.39,446.94L474.22,448.62L471.32,449.06L470.73,450.62L468.75,451.91L467.46,454.08L465.55,454.79L464.59,454.44L461.43,455.97L462.11,458.04L460.79,459.33L451.97,458.44L448.73,457.22L447.24,457.62L446.23,455.9L444.17,456.12L441.74,454.46L439.15,453.92L438.33,452.67L435.25,452.27L430.9,449.1L428.51,449.98L426.4,449.38L425.48,448.23L422.55,447.66L419.8,445.54L418.74,445.8L415.59,449.52L413.96,449.53L412,448.17L408.93,448.38L406.9,450.49L405.73,450.38L404.75,448.62L403.03,447.91L401.32,448.76L400.51,450.02L397.19,450.81L392.32,448.11L390.59,448.02L389.06,448.86L388.24,450.81L386.11,452.81L381.03,455.99L375.33,455.51L373.62,457.24L370.8,458.12L370.8,458.12L371.88,452.47L373.64,450.03L371.92,446.57L365.88,445.53L361.97,440.94L349.98,433.93L349.98,433.93L349.23,431.34L344.66,427.62L342.76,423.34L342.19,419.47L342.9,418.79L344.4,419.08L343.77,417.8L345.34,416.07L344.41,415.62L345.04,414.98L343.63,412.97L343.03,413.75L341.05,412.31L340.73,412.68L340.51,411.55L339.65,411.57L339.34,409.35L338.56,409.01L338.56,409.01L337.3,407.98L336.05,407.95L336.79,406.97L335.4,405.58L345.8,405.53L351.73,402.94L355.43,398.54L363.64,397.42L366.2,396.45L369.88,394.61L373.09,391.17L378.74,389.76L383.68,385.54L390.01,384.68L393.55,381.64L401.65,379.96L402.87,379.04L406.34,375.32L408.52,371.48L410.18,359.03L421.33,349.43L427.38,348.6L428.45,347.83L429.35,346.74L431.04,341.14L435.89,339.98L439.79,337.02L443.46,336.54L445.82,335.19L447.77,328.97L451.01,323.78L455.83,320.99L456.8,318.78L461.38,316.36L464.98,316.09L467.69,314.53L471.2,314.96L473.66,313.89L478.48,315.11L487.92,313.45L491.26,309.15L496.04,307.38L499.71,307.79L501.95,304.13L505.88,301.9L505.88,301.9L506.26,302.76L505.31,305.34z"
				},
				{
					"id":"AO-MAL",
					"title":"Malange",
					"d":"M203.95,296.77L209.38,297.56L212.78,294.89L216.19,294.43L218.14,292.29L218.97,287.21L220.48,283.95L219.66,279.07L216.43,269.62L216.45,267.1L219.31,265.7L223,265.83L227.61,263.31L231.08,257.68L233.18,256.14L242.38,252.74L244.54,253.16L245.65,254L247.04,257.65L252.02,264.27L254.19,266.12L257.48,266.77L260.92,265.1L261.67,259.33L262.48,258.27L266.01,255.85L268.49,256.28L268.49,256.28L268.45,257.96L269.4,257.93L270,256.98L272.14,258.57L270.45,260.16L272.7,261.62L272.61,263.27L273.72,265.5L277.95,268.41L277.19,271.01L279.17,272.36L278.7,274.42L282,276.09L281.91,277.5L284.12,278.57L283.79,279.91L285.28,280.59L284.66,282.77L286.1,283.63L287,284.08L286.7,286.36L288.35,288.66L287.77,290.46L289.25,291.7L289.25,291.7L288.72,293.15L290.26,294.97L289.55,296.17L289.69,298.31L290.4,302.98L291.14,303.8L289.43,305.99L288.73,309.41L289.95,313.32L292.22,314.78L292.27,326.81L290.8,334.62L292.48,340.55L290.5,344L290.57,346.31L289.55,347.66L281.44,350.22L279.14,352.15L280.79,357.91L283.02,361.23L282.97,364.68L283.67,365.79L286.04,366.27L286.75,368.48L287.83,369.28L292.27,370.42L293.69,372.7L293.51,374.95L294.32,376.03L298,375.47L302.74,377.7L304.38,382.97L305.31,384.07L306.76,384.43L307.06,386.13L309.12,389.19L308.35,391.26L308.53,393.71L309.75,394.34L310.86,397.27L312.79,399.34L315.78,400.78L315.81,402.23L310.75,406.89L312.91,409.79L312.9,410.85L317.31,411.91L321.8,415.69L328.55,418.94L334.55,418.46L335.73,416.07L333.63,412.99L334.97,410.75L338.56,409.01L338.56,409.01L339.34,409.35L339.65,411.57L340.51,411.55L340.73,412.68L341.05,412.31L343.03,413.75L343.63,412.97L345.04,414.98L344.41,415.62L345.34,416.07L343.77,417.8L344.4,419.08L342.9,418.79L342.19,419.47L342.76,423.34L344.66,427.62L349.23,431.34L349.98,433.93L349.98,433.93L350.36,434.98L349.3,438.64L349.69,441.01L351.11,443.02L350.11,446.87L353.29,449.89L353.94,452.86L353.41,453.92L348.95,453.45L342.67,455.35L338.53,457.28L334.49,461.46L332.33,462.6L328.64,462.53L326.14,461.43L319.82,463.02L316.33,462.34L314.52,463.28L312.38,461.28L310.21,461.8L307.94,461.38L307.55,458.08L306.48,455.72L303.76,453.37L304.56,456.76L304.51,462.19L299.81,466.2L298.59,468.41L296.33,469.02L295.01,471.23L292.12,472.12L290.08,470.54L287.43,469.73L288.55,467.41L286.62,462.59L289.03,460.12L288.63,459.19L286.99,459.57L288.67,454.79L286.14,451.13L285.5,447.34L283.46,447.1L281.86,445.94L283.3,444.62L284.96,444.24L285.43,441.33L283.4,437.17L281.87,435.91L281.26,432.02L277.18,428.51L274.1,428.69L271.19,427.71L270.85,426.06L268.61,426.07L267.92,427.43L261.62,424.12L257.49,423.39L254.21,424.07L251.96,423.75L249.04,420.51L246.4,419.62L245.99,418.14L244.51,417.88L244.06,416.29L245.11,415.28L243.56,413.91L243.56,413.91L237.82,406.7L235.79,406.1L235.74,402.64L234.53,401.07L233.25,399.64L230.65,398.87L230.02,395.08L232.67,391.84L231.38,389.19L231.07,386.1L228.96,383.39L229.37,380.35L228.5,379.18L225.32,377.42L224.58,375.08L222.77,372.88L214.1,371.56L209.2,372.24L205.76,371.23L204.53,371.37L202.25,374.53L187.4,374.59L180.98,376.1L174.81,375.53L169.63,371.87L169.63,371.87L172.24,369.59L172.54,368.54L171.94,365.01L170.1,363.05L169.99,361.99L173.43,358.96L172.87,356.56L169.98,354.47L176.07,353.67L176.8,348.98L178.18,347.64L182.1,347.13L188.14,343.83L190.9,344.76L194.29,344.49L195.97,343.38L196.38,340.42L195.81,336.93L197.2,330.04L199.01,324.36L200.47,322.11L199.4,319.66L195.86,318.77L194.49,315.9L197.75,311.28L197.49,309.06L203.88,307.48L205.2,305.94L204.52,304.98z"
				},
				{
					"id":"AO-MOX",
					"title":"Moxico",
					"d":"M370.8,458.12L373.62,457.24L375.33,455.51L381.03,455.99L386.11,452.81L388.24,450.81L389.06,448.86L390.59,448.02L392.32,448.11L397.19,450.81L400.51,450.02L401.32,448.76L403.03,447.91L404.75,448.62L405.73,450.38L406.9,450.49L408.93,448.38L412,448.17L413.96,449.53L415.59,449.52L418.74,445.8L419.8,445.54L422.55,447.66L425.48,448.23L426.4,449.38L428.51,449.98L430.9,449.1L435.25,452.27L438.33,452.67L439.15,453.92L441.74,454.46L444.17,456.12L446.23,455.9L447.24,457.62L448.73,457.22L451.97,458.44L460.79,459.33L462.11,458.04L461.43,455.97L464.59,454.44L465.55,454.79L467.46,454.08L468.75,451.91L470.73,450.62L471.32,449.06L474.22,448.62L477.39,446.94L479.6,446.63L480.57,445.63L483.48,445.47L484.42,443.73L485.83,443.97L486.01,443.46L486.58,444.18L488.76,444.5L494.44,442.25L494.52,438.34L493.45,438.27L492.08,435.55L493.11,429.93L496.69,426.64L497.15,420.68L499.8,416.47L511.36,416.67L513.54,414.72L516.37,414.87L520.66,416.66L522.94,416.69L524.96,415.84L524.96,415.84L525.51,424.01L520.77,426.01L518.26,427.98L517.94,429.11L519.51,432.62L520.24,440.57L522.35,443.64L522.12,446.69L523.07,447.82L524.13,447.54L526.67,444.17L530.9,444.09L533.75,441.37L533.88,437.93L537.07,436.88L545.01,440.85L548.47,440.92L549.32,439.51L552.11,438.45L556.61,440.26L559.35,440.36L562.79,441.55L566.15,440.01L568.67,440.46L580.12,432.27L583.58,432.68L587.51,435.02L589.66,434.89L591.79,435.77L595.4,434.97L598.85,436.75L600.66,436.74L605.22,433.11L606.95,430.21L607.74,429.95L607.29,431.04L608.72,432.31L609.21,433.83L608.52,437.83L608.87,440.13L608.23,441.42L609.68,442.83L609.78,449.11L612,455.22L609.48,457.57L609.75,461.53L607.5,467.17L606.53,468.11L609.17,476.46L608.08,477.7L607.46,480.45L607.12,490.93L607.25,493.07L608.65,496.15L611.34,498.64L611.56,500.56L610.58,501.76L611.61,502.55L611.8,503.71L611.54,506.16L609.25,507.88L605.77,512.71L605.99,515.9L604.52,518.49L604.66,520.65L603.2,527.16L604.55,529.24L606.83,530.41L609.2,532.84L609.94,535.05L509.35,535.76L509.34,696.19L509.34,696.19L500.98,690.82L500.12,687.15L498.54,685.89L497.61,682.92L495.32,681.9L495.2,678.85L492.08,677.8L489.94,675.73L488.62,672.17L487.05,670.94L487.34,668.78L485.73,667.55L484.86,665.65L482.58,664.6L482.64,660.32L481.81,658.35L480.31,657.13L477.92,656.8L475.31,655.18L473.62,653.33L472.15,648.58L470.43,647.53L468.05,647.69L467.4,646.81L467.79,645.21L465.45,645.26L460.78,639.43L458.24,638.75L456.5,636.99L454.37,637.43L452.56,635.75L451.4,635.74L450.41,636.85L445.69,635.88L443.79,634.36L441.89,635.26L440.24,634.89L437.89,636.02L435.13,635.37L432.21,636.57L427.71,635.51L423.93,635.87L418.91,633.88L414.84,631.64L411.37,628.19L409.97,625.78L408.34,624.66L406.79,624.81L406.76,623.56L405.66,623.62L405,622.13L398.28,616.42L397.84,614.85L395.63,613.6L394.06,609.63L392.54,608.36L391.98,605.44L389.32,603.26L387.64,599.93L381.93,601.11L376.95,600.4L374.78,598.57L372.55,598.5L369.91,599.93L371.66,608.01L364.69,604.25L358.62,606.21L356.15,605.3L354.01,601.66L353.93,600.07L352.98,599.53L351.83,597.15L352.08,594.49L350.63,590.61L350.95,588.57L348.48,585.03L348.13,583.33L345.06,580.76L344.7,579.4L343.1,579.03L338.44,575.36L336.13,576.23L335,575.82L328.02,571.21L323.56,571.9L309.93,564.03L309.93,564.03L309.24,561.83L310.95,559.06L309.03,555.38L312.32,552.5L316.21,551.12L316.53,550.04L316.26,547.69L313.69,543.12L315.51,540.83L314.87,539.47L318.37,537.9L318.82,535.69L321.15,534.25L321.59,533.12L319.52,527.24L320.73,526.18L321.4,527.3L325.17,523.67L327.44,522.45L327.33,519.04L332.88,512.52L332.8,508.97L333.78,507.92L338.86,503.2L341.56,502.8L344.88,499.35L347.52,498.84L348.39,497.78L348.72,496.47L347.67,495.52L347.71,494.36L355.09,487.33L355.22,485.48L353.77,483.04L354.04,480.52L356.08,478.66L357.65,474.21L360.07,474.68L360.79,473.56L359.33,470.47L363.84,469.75L364.93,468.66L366.19,462.13L369.42,458.47z"
				},
				{
					"id":"AO-NAM",
					"title":"Namibe",
					"d":"M1.67,713.26l0.92,0.65l-0.19,3.22l1.14,6.56l-1.33,-1.29l-2.07,-5.68l0.01,-2.03L1.67,713.26zM43.3,562.11l3.43,0.03l8.01,2.3l2.54,0.05l3.16,2.32l7.94,-3l0.85,-2.3l10.55,2.17l1.1,0.62l0.31,1.19l-1.12,2.35l0.12,2.26l2.79,3.54l1.52,3.59l1.19,0.76l2.21,-1.27l3.41,1.57l2.48,-0.07l0,0l0.89,2.73l2.15,1.46l0.35,1.19l-2.94,6.29l1.87,4.77l-0.81,2.55l0.48,1.22l1.16,0.8l1.11,-0.59l1.16,0.52l-0.4,2.48l0.67,6.42l-2.74,3.74l-0.27,4.79l-2.47,5.79l-6.63,3.65l-4.54,4.06l-2.37,0.36l-2,2.17l1.24,4.99l-2.4,3.65l2.92,3.44l-0.38,1.2l-3.68,2.11l0.09,1.19l1.12,1.02l3.81,-0.37l-0.17,2.99l1.04,1.26l2.38,-0.93l0.52,-1.07l1.37,0.33l0.76,2.33l-0.65,2.46l0.74,1.14l2.35,1.85l3.75,1.41l-0.31,12.17l2.62,4.77l-5.71,11.55l2.48,5.95l-1.6,3.25l-1.29,0.7l0,0l-4,4.57l-2.4,1.42l-0.55,-0.71l-0.78,1.55l-1.56,0.09l-1.11,1.72l-2.27,0.81l-1.13,1.75l2.01,1.92l0.94,2.3l-1.77,2.54l-3.5,2.09l-1,2.29l1.38,2.5l7.14,7.12l2.01,5.2l0,0l-3.9,1.09l-3.17,-0.64l-0.54,-1.02l-2.56,-0.19l-2.32,0.92l-5.52,0.3l-1.85,1.74l-3.46,1.45l-0.23,0.97l-2.38,1.11l-0.83,1.47l-7.48,3.58l-2.5,2.34l-3.65,0.93l-2.03,-0.36l-1.83,1.16l-1.23,-2.81l-1,-0.13l-1.44,1.21l-1.13,-0.57l-3.07,1l-2.03,-0.1l-3.05,-2.02l-1.01,-1.98l-2.86,0.02l-1.3,-0.76l-6.68,1.94l-3.25,2.52L8.31,750.6l-1.26,1.55l-2.94,-0.9l0.01,-11.24l1.48,-7.81l-0.55,-5.1l0.82,-0.63l-0.47,2.89l0.57,-0.06l1.07,-2.05l0.55,-3.74l-0.38,-5.81l0.57,-7.13l-1.81,-16.5l0.77,-5.62l-3.41,-5.76l-0.22,-1.65l2.27,-4.71l0.92,0.54l0.67,-0.1l0.77,0.56l2.81,-0.96l1.34,-1.98l0.82,-3.51l3.38,-2.31l1.21,-3.21l0.51,-8.77l1.15,-2.75l0.08,-5.49l1.82,-1.62l1.67,-0.79l0.75,0.55l0.62,-0.69l-0.51,-2.75l-1.55,0.34l0.29,-1.3l2.55,-4.51l0.1,-3.11l1.07,-0.55l1.1,-2.66l-0.16,-2.42l1.81,-1.01l1.92,-3.74l-0.81,-2.83l1.22,-1.53l-0.21,-1.97l2.7,-9.32l0.29,-5.44l0.84,-1.28l-1.85,-6.08l1.48,-0.6l0.47,-1.28l-0.89,-2.71l0.4,-2.15l1.53,-1.33l0.26,-3.81l1.4,-0.8l-0.22,-3.21l3.57,-0.53l-0.36,0.65l1.21,0.1l0.86,-1.77l-0.47,-0.2l0.12,-3.92l0.88,-6.54l-0.57,-0.34l0.29,-1.54l0.85,-0.52L43.3,562.11z"
				},
				{
					"id":"AO-UIG",
					"title":"Uíge",
					"d":"M232.54,181.19L233.49,182.17L235.4,182.55L238.77,181.68L243.11,183.66L242.59,186.03L243.43,186.92L243.08,190.56L243.46,191.89L245.29,192.44L245.37,193.94L247.55,194.54L249.12,195.84L249.58,197.22L248.57,199.27L248.52,201.99L249.29,204.62L248.22,206.23L247.6,207.65L249.65,208.63L248.61,209.65L249.76,211.02L249.4,212.34L251.16,213.7L250.59,216.2L251.83,216.93L252.68,221.3L254.51,222.92L254.8,225.68L256.52,227.35L256.75,229.4L258.68,229.7L259.91,230.78L259.83,235.29L261.51,236.27L262,238.11L261.06,240.83L260.06,239.99L259.34,240.34L261.39,245.36L260.57,247L262.29,248.35L263.12,251.77L264.35,251.66L266.62,253.88L268.25,254.05L268.49,256.28L268.49,256.28L266.01,255.85L262.48,258.27L261.67,259.33L260.92,265.1L257.48,266.77L254.19,266.12L252.02,264.27L247.04,257.65L245.65,254L244.54,253.16L242.38,252.74L233.18,256.14L231.08,257.68L227.61,263.31L223,265.83L219.31,265.7L216.45,267.1L216.43,269.62L219.66,279.07L220.48,283.95L218.97,287.21L218.14,292.29L216.19,294.43L212.78,294.89L209.38,297.56L203.95,296.77L203.95,296.77L203.71,291.99L203.04,291.29L201.72,291.7L201.08,289.89L202.49,288.66L199.72,286.61L195.19,286.68L193.44,288.33L188.81,289.13L187.06,288.39L186.79,285.1L185.97,283.86L184.52,283.08L178.54,283.23L174.04,284.3L174.43,286.9L173.23,289.83L174.52,289.83L175.54,291.45L174.47,293.09L174.42,296.18L172.3,298.85L171,298.96L170.34,301.05L167.62,300.73L165.05,301.96L162.56,300.33L160.04,300.09L155.82,305.8L153.43,306.76L149.74,305.76L147.91,306.07L147.27,304.12L147.27,304.12L146.38,301.35L146.44,298.81L147.08,296.51L150.44,290.82L150.63,281.5L149.49,280.55L147.09,280.25L139.78,281.79L136.31,281.45L130.48,278.59L126.66,273.79L122.6,270.55L122.63,269.46L121.67,268.33L106.31,267.56L106.31,267.56L107.36,264.46L110.95,263.74L113.44,261.09L110.7,258.63L110.15,256.45L108.19,254.48L108.94,251.04L111.9,247.68L112.07,246.49L107.95,243.02L106.81,238.37L105.27,235.92L107.65,235.15L112,235.25L116.39,231.48L122.29,229.93L126.84,227.79L128.87,223.12L131.75,221.24L136.34,221.34L139.65,219.87L141.69,217.28L148.55,216.76L153.37,214.8L158.93,206L160.89,204.49L163.53,200.84L158.88,197.2L158.22,191.04L152.52,181.82L152.52,181.82z"
				},
				{
					"id":"AO-ZAI",
					"title":"Zaire",
					"d":"M32.7,191.47l-0.53,1.46l-1.2,0.1l1.07,0.23l-0.74,1.45l-1.22,0.53l-0.14,-2.19L32.7,191.47zM114.27,179.87l2.56,2.1l2.01,-0.89l4.85,-0.22l2.68,1.36l3.14,-0.34l8.06,0.93l2.49,-0.53l4.24,0.98l5.12,-1.44l3.11,0.01l0,0l5.7,9.22l0.67,6.16l4.64,3.64l-2.64,3.66l-1.96,1.51l-5.56,8.8l-4.82,1.96l-6.86,0.52l-2.05,2.59l-3.31,1.47l-4.59,-0.09l-2.88,1.88l-2.02,4.67l-4.55,2.14l-5.9,1.55l-4.39,3.77l-4.35,-0.09l-2.38,0.77l1.54,2.45l1.14,4.64l4.12,3.47l-0.17,1.19l-2.96,3.36l-0.74,3.44l1.96,1.96l0.55,2.18l2.74,2.46l-2.5,2.65l-3.59,0.73l-1.05,3.1l0,0l-4.71,2.73l-3.6,0.07l-1.47,1.27l-4.44,0.81l-1.16,0.88l-2.32,0l-3.27,-2.21l-4.26,1.18l-1.07,1.62l-1.89,-0.73l-3.68,2.46l-4.47,0.88l0,0l-3.35,-8.77l-1.09,-1.24l0.49,-1.18l-1.03,-1.03l-2.53,-5.98l-1.08,-4.86l-2.97,-3.22l-0.15,-7.83l-1.01,-5.8l-4.09,-6.29l-9.08,-9.97l-8.24,-16.74l-5.4,-7.88l1.71,-1.42l0.1,-0.29l0.11,-0.53l3.96,-0.04l-0.27,-0.4l1.6,-0.31l1.55,0.64l-0.49,-1.76l8.27,-3.08l3.88,-0.39l2.67,-1.59l3.58,-0.26l9.95,-4.87l2.54,-0.03l2.12,1.39l6.17,-1.76l5.49,1.75l1.81,-1.49l21.37,0.23L114.27,179.87z"
				}
			]
		}
	}
};
