<?php

use App\Models\AcademyUsers;

$skey 	= "WinWinBizOsAmAOmAr201512"; // you can change it
function convertToDateTimeLocal($date)
{
    return (!empty($date) && $date != '0000-00-00 00:00:00') ? date("Y-m-d", strtotime($date)) . 'T' . date("H:i:s", strtotime($date)) : '';
}
function PerUser($val)
{
    $UserPermissionsData = \Illuminate\Support\Facades\Request::get('UserPermissionsData');
    return (isset($UserPermissionsData->$val) && $UserPermissionsData->$val) ? true : false;
}
function yottausser($email)
{
    $result = AcademyUsers::where('Email','=',$email)->orWhere('Mobile','LIKE',"%$email%")->first();
$AcademyUsers=new AcademyUsers;
$AcademyUsers->setConnection('mysql3');
$result1=$AcademyUsers->where('Email','=',$email)->orWhere('Mobile','LIKE',"%$email%")->first();
//
    if($result1 && $result){
        return true;
    }
}
function startYottaQuery($query){
    $con=new mysqli("localhost", "ebacademy_yotta_med", "Almoasher123", "ebacademy_yotta_med");
    $con->query("SET NAMES 'UTF8'");
    $con->query('SET CHARACTER SET utf8');
    $con->query('SET time_zone = "+02:00');
    $con->query('SET GLOBAL max_allowed_packet=524288000;');
    $return=$con->query($query);
    $con->close();
    return $return;
}
function timeAgo($time)
{
    $time = strtotime($time);
    $time = time() - $time; // to get the time since that moment
    $time = ($time < 1) ? 1 : $time;
    $tokens = array(
        31536000 => 'year',
        2592000 => 'month',
        604800 => 'week',
        86400 => 'day',
        3600 => 'hour',
        60 => 'minute',
        1 => 'second'
    );
    foreach ($tokens as $unit => $text) {
        if ($time < $unit) continue;
        $numberOfUnits = floor($time / $unit);
        return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? 's' : '');
    }
}
function makeDefaultImage($post, $name)
{
    if (!(!empty($post->img_dir) && !empty($post->img) && file_exists(public_path($post->img_dir . $post->img)))) {
        $post->img_dir = '/img/' . $name . '/';
        $post->img = 'default_image.png';
    }
    return $post;
}
function makeDefaultImageGeneral($post, $image_field_name,$path='')
{
    if (empty($post->$image_field_name) || !file_exists(filePath().$path.$post->$image_field_name)) {
        $post->$image_field_name='none.png';
    }
    return $post;
}
function userSystem()
{
    $system = \App\Models\UsersSystems::where('user_id', Auth::user()->id)->first();
    if (!count((array)$system)) {
        $system = new \App\Models\UsersSystems();
        $system->user_id = Auth::user()->id;
        $system->backend_lang = 'en';
        $system->save();
    }
    return $system;
}
function getUserSystem($pars)
{
    $userSystemData = \Illuminate\Support\Facades\Request::get('UserSystem');
    return (isset($userSystemData->$pars)) ? $userSystemData->$pars : '';
}
function byUser($user_id, $string = null)
{
    $user = DB::table('users')->where('id', $user_id)->first();
    if (count($user)) {
        if ($user->img_dir == '' || $user->img == '') {
            $user->img_dir = 'img/Users/';
            $user->img = 'default_user.png';
        }
        return '<div class="zoom_img"><img class="img-polaroid " src="' . asset($user->img_dir . $user->img) . '" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . $string . $user->name . '"></div>';
    }
    return Lang::get('main.no_image');
}
function byAppUser($user_id, $string = null)
{
    $user = \App\Models\AppUsers::find($user_id);
    if (count($user)) {
        if ($user->img_dir == '' && $user->img == '') {
            $user->img_dir = 'img/Users/';
            $user->img = 'default_user.png';
        }
        return '<div class="zoom_img"><img class="img-polaroid " src="' . asset($user->img_dir . $user->img) . '" data-toggle="tooltip" data-placement="top" title="" data-original-title="' . $string . ' { ' . Lang::get('main.' . $user->type) . ' } ' . $user->name . '"></div>';
    }
    return Lang::get('main.no_image');
}
function FileImage($file, $folder_name, $input_name = 'image')
{
    $path = '/img/' . $folder_name . '/' . date('Y/m/d') . '/';
    if (!file_exists(public_path() . $path)) {
        File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
    if (!file_exists(public_path() . $path . 'thumbnail')) {
        File::makeDirectory(public_path() . $path . 'thumbnail', $mode = 0777, true, true);
    }
    //file new name
    $namefile = $folder_name . '_' . rand(0000, 9999) . '_' . time();
    //file extension
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
    $mimtype = $file->getMimeType();
    //making the new name with extension
    $mastername = $namefile . '.' . $ext;
    list($width, $height, $type, $attr) = getimagesize($_FILES[$input_name]['tmp_name']);
    $width_per = round(($width * 10) / 100);
    $height_per = round(($height * 10) / 100);
    $file->move(public_path() . $path, $mastername);
    Image::make(public_path() . $path . $mastername, array(
        'width' => $width_per,
        'height' => $height_per,
    ))->save(public_path() . $path . 'thumbnail/thumbnail_' . $mastername);
    return array('img' => $mastername, 'img_dir' => $path);
}
function FileImages($file, $folder_name, $x, $input_name = 'images')
{
    $path = '/img/' . $folder_name . '/' . date('Y/m/d') . '/';
    if (!file_exists(public_path() . $path)) {
        File::makeDirectory(public_path() . $path, $mode = 0777, true, true);
    }
    if (!file_exists(public_path() . $path . 'thumbnail')) {
        File::makeDirectory(public_path() . $path . 'thumbnail', $mode = 0777, true, true);
    }
    //file new name
    $namefile = $folder_name . '_' . rand(0000, 9999) . '_' . time();
    //file extension
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    //convert the size of the file
    //$size = ImageUploader::GetSize($file->getSize());
    //get the mime type of the file
    $mimtype = $file->getMimeType();
    //making the new name with extension
    $mastername = $namefile . '.' . $ext;
    list($width, $height, $type, $attr) = getimagesize($_FILES[$input_name]['tmp_name'][$x]);
    $width_per = round(($width * 10) / 100);
    $height_per = round(($height * 10) / 100);
    $file->move(public_path() . $path, $mastername);
    switch ($folder_name) {
        case'hotels':
            $imagesResize = [
                0 => ['width' => 60, 'height' => 60],
                1 => ['width' => 260, 'height' => 180],
                2 => ['width' => 400, 'height' => 200],
            ];
            break;
        case'flights':
            $imagesResize = [
                0 => ['width' => 60, 'height' => 60],
                1 => ['width' => 260, 'height' => 180],
                2 => ['width' => 400, 'height' => 200],
            ];
            break;
        default:
            $imagesResize = [];
            break;
    }
    foreach ($imagesResize as $imageSize) {
        $widthS = $imageSize['width'];
        $heightS = $imageSize['height'];
        Image::make(public_path() . $path . $mastername, array(
            'width' => $widthS,
            'height' => $heightS,
        ))->save(public_path() . $path . 'thumbnail/' . $widthS . '_' . $heightS . '_' . $mastername);
    }
    Image::make(public_path() . $path . $mastername, array(
        'width' => $width_per,
        'height' => $height_per,
    ))->save(public_path() . $path . 'thumbnail/thumbnail_' . $mastername);
    return array('img' => $mastername, 'img_dir' => $path);
}
function tableCount($table)
{
    if (Schema::hasTable($table)) {
        $section = DB::table($table)->count();
        return $section;
    }
    return 0;
}
function getDaysName()
{
    $timestamp = strtotime('next Sunday');
    $days = array();
    for ($i = 0; $i < 7; $i++) {
        $days[] = strtolower(strftime('%A', $timestamp));
        $timestamp = strtotime('+1 day', $timestamp);
    }
    return $days;
}
function fileNewName($name, $filePath)
{
    $actual_name = pathinfo($name, PATHINFO_FILENAME);
    $original_name = $actual_name;
    $extension = pathinfo($name, PATHINFO_EXTENSION);
    $i = 1;
    while (file_exists($filePath . $actual_name . "." . $extension)) {
        $actual_name = (string)$original_name . '(' . $i . ')';
        $name = $actual_name . "." . $extension;
        $i++;
    }
    return $name;
}
function uploadFileToE3melbusiness($file, $partner = false, $folder = null)
{
    $filePath = '';
    $folder = ($folder) ? $folder . '/' : $folder;
    if ($partner == true) {
        $filePath = partnerFilePath();
    } else {
        $filePath = filePath();
    }
    $ext = $file->getClientOriginalExtension();
    //file old name
    $old_name = $file->getClientOriginalName();
    $newname = fileNewName($old_name, $filePath);
    if (!file_exists($filePath . $folder)) {
        File::makeDirectory($filePath . $folder, $mode = 0777, true, true);
    }
    $file->move($filePath . $folder, $newname);
    return $newname;
}
function e3mURL($url)
{
    return ($_SERVER['SERVER_NAME'] == 'localhost') ? 'http://localhost/e3melbusinessv5/' . $url : env('WEBSITE_URL') . $url;
}
function assetURL($url = '')
{
    //return 'https://www.e3melbusiness.com/assets/images/'.$url;
    return ($_SERVER['SERVER_NAME'] == 'localhost') ? 'http://'.$_SERVER['SERVER_NAME'].'/e3melbusinessV4/assets/images/' . $url : "https://www.e3melbusiness.com/assets/images/" . $url;
}
function filePath()
{
    //return explode('sa.e3melbusiness.com',public_path())[0].'sa.e3melbusiness.com/assets/images/';
    return ($_SERVER['SERVER_NAME'] != 'e3melbusiness.com') ? explode('e3melbusinessV4', public_path())[0] . 'e3melbusinessV4/assets/images/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/images/';
}
function partnerFilePath()
{
    return ($_SERVER['SERVER_NAME'] != 'e3melbusiness.com') ? explode('e3melbusinessV4', public_path())[0] . 'e3melbusinessV4/assets/images/ourpartners/' : explode('sa.e3melbusiness.com', public_path())[0] . 'sa.e3melbusiness.com/assets/images/ourpartners/';
}
function sendGridEmailToUser($html,$email,$name,$subject){
    $sendEmail = new \SendGrid\Mail\Mail();
    $sendEmail->setFrom('Academy@e3melbusiness.com', 'أكاديمية إعمل بيزنس');
    $sendEmail->setSubject($subject);
    $sendEmail->addTo($email, $name);
    $sendEmail->addContent("text/html", $html);
    try {
        $sendgrid = new \SendGrid(getenv('SENDGRID_API_KEY'));
    }catch (Exception $e){
        echo 'Caught exception: ',  $e->getMessage(), "\n";
    }
    return $sendgrid->send($sendEmail);
}
//encryption
function safe_b64encode($string) {
    $data = base64_encode($string);
    $data = str_replace(array('+','/','='),array('-','_',''),$data);
    return $data;
}
function safe_b64decode($string) {
    $data = str_replace(array('-','_'),array('+','/'),$string);
    $mod4 = strlen($data) % 4;
    if ($mod4) {
        $data .= substr('====', $mod4);
    }
    return base64_decode($data);
}
function encode($value){
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://www.e3melbusiness.com/?page=cronJob&action=encode&value=$value",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
        ),
    ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) {
        //echo "cURL Error #:" . $err;
        return null;
    } else {
        $res=json_decode($response);
        return $res->data;
    }
//    if(!$value){return false;}
//    $text = $value;
//    $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
//    $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
//    $crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $GLOBALS['skey'], $text, MCRYPT_MODE_ECB, $iv);
//    return trim(safe_b64encode($crypttext));
}
function decode($value){
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://www.e3melbusiness.com/?page=cronJob&action=decode&value=$value",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
        ),
    ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) {
        //echo "cURL Error #:" . $err;
        return null;
    } else {
        $res=json_decode($response);
        return $res->data;
    }
//    if(!$value){return false;}
//
//    $crypttext = safe_b64decode($value);
//
//    $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
//
//    $iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
//
//    $decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $GLOBALS['skey'], $crypttext, MCRYPT_MODE_ECB, $iv);
//
//    return trim($decrypttext);
}
function log_user_action($user_id=null,$user_name=null,$user_action=null,$user_action_table=null,$user_action_table_id=null,$data_json=null){
    $log=new \App\Models\UsersSystemLog();
    $log->user_id=$user_id;
    $log->user_name=$user_name;
    $log->user_action=$user_action;
    $log->user_action_table=$user_action_table;
    $log->user_action_table_id=$user_action_table_id;
    $log->data_json=$data_json;
    $log->created_at=date("Y-m-d H:i:s");
    $log->save();
}
function getEloquentSqlWithBindingsListen($query)
{

    try {
        return vsprintf(str_replace('?', '%s', $query->sql), collect($query->bindings)->map(function ($binding) {
            return is_numeric($binding) ? $binding : "'{$binding}'";
        })->toArray());
    } catch (ErrorException $e) {
        if (request('debug')) {
            dd($query->sql, $query->bindings);
        }
    }

}

function modules_statistics($type,$email)
{
    $user=\App\Models\AcademyUsers::select('id')->where('Email', $email)->first();
    $user_id= $user->id;
    $date=date('Y-m-d H:i:s');
    $allData=[];
    if($user_id) {
        if ($type == 'mba') {
            $allData = DB::connection('mysql2')->table('mba_charge_transaction')->where('suspend', '0')->where('user_id', $user_id)->orderBy('end_date','ASC')->first();
            if(!$allData){
                $allData = DB::connection('mysql2')->table('mba_companies_charge_transaction')->where('suspend', '0')->where('user_id', $user_id)->orderBy('end_date','ASC')->first();
                if(!$allData){
                    $allData = DB::connection('mysql2')->table('preparatory_mba_charge_transaction')->where('suspend', '0')->where('user_id', $user_id)->orderBy('end_date','ASC')->first();
                }
            }
        }
        elseif ($type == 'new_mba') {
            $allData = DB::connection('mysql2')->table('new_mba_charge_transaction')->where('suspend', '0')->where('user_id', $user_id)->orderBy('end_date','ASC')->first();
        }
        $statistics = DB::connection('mysql2')->table('modules_statistics')->where('flag', $type)->whereRaw("'$allData->start_date' BETWEEN start_date AND end_date")->first();
        if(!$statistics){
            $statistics=DB::connection('mysql2')->table('modules_statistics')->where('flag', $type)->orderBy('id','ASC')->first();
        }
        if($allData->start_date<'2022-03-24 00:00:00'){
            $statistics->type='old';
        }else{
            $statistics->type='new';
        }
    }
    return $statistics;
}
function courseDuration($course,$type='course'){
    if($type=='diploma'){
        $diploma_courses_ids=\App\Models\DiplomaCourse::where('diploma_id',$course->id)->pluck('related_course')->toArray();
        $times=\App\Models\CoursesCurriculum::whereIn('course_id',$diploma_courses_ids)->pluck('duration')->toArray();
    }elseif($type=='package'){
        $diploma_courses_ids=\App\Models\PackageCourse::where('package_id',$course->id)->pluck('related_course')->toArray();
        $times=\App\Models\CoursesCurriculum::whereIn('course_id',$diploma_courses_ids)->pluck('duration')->toArray();
    }elseif($type=='international_diploma'){
        $diploma_courses_ids=\App\Models\InternationalDiplomaCourse::where('diploma_id',$course->id)->pluck('related_course')->toArray();
        $times=\App\Models\CoursesCurriculum::whereIn('course_id',$diploma_courses_ids)->pluck('duration')->toArray();
    }
    elseif($type=='course'){
        $times=\App\Models\CoursesCurriculum::where('course_id',$course->id)->pluck('duration')->toArray();
    }elseif($type=='mba'){
        $mba_courses_ids=\App\Models\MbaCourses::where('module_id',$course->id)->pluck('related_course')->toArray();
        $times=\App\Models\CoursesCurriculum::whereIn('course_id',$mba_courses_ids)->pluck('duration')->toArray();
    }
    $seconds = 0; //declare minutes either it gives Notice: Undefined variable
    foreach ($times as $time) {
        if (stripos($time, "دقيقية") !== false) {
            switch (strlen(intval($time))){
                case 1:
                    $time='0'.intval($time).':00';
                    break;
                case 2:
                    $time=intval($time).':00';
                    break;
            }
        }elseif (stripos($time, "دقيقة") !== false) {
            switch (strlen(intval($time))){
                case 1:
                    $time='0'.intval($time).':00';
                    break;
                case 2:
                    $time=intval($time).':00';
                    break;
            }
        }
        $hours=0;
        $minute=0;
        $second=0;
        $arr=explode(':', $time);
        if(count($arr)==3){
            list($hours,$minute,$second) = explode(':', $time);
        }elseif(count($arr)==2){
            list($minute,$second) = explode(':', $time);
        }elseif(count($arr)==1){
            list($second) = explode(':', $time);
        }
        $seconds+=(($hours*60))*60;
        $seconds += ($minute*60);
        $seconds += $second;
    }
    $hours = floor(($seconds / 60) / 60);
    $seconds -= ($hours*60)*60;
    $minutes=floor($seconds / 60);
    $seconds-=$minutes*60;
    return sprintf('%02d:%02d:%02d', $hours, $minutes,$seconds);
}
function yottaURL($url)
{
    return ($_SERVER['SERVER_NAME'] == 'localhost') ? 'http://localhost/yotta/' . $url : 'https://www.yottamedicalschool.com/' . $url;
}
function diplomaCoursesCount($diploma){
    $count=\App\Models\DiplomaCourse::where('diploma_id',$diploma->id)->count();
    return $count;
}
function packageCoursesCount($package){
    $count=\App\Models\PackageCourse::where('package_id',$package->id)->count();
    return $count;
}
function internationalDiplomaCoursesCount($diploma){
    $count=\App\Models\InternationalDiplomaCourse::where('diploma_id',$diploma->id)->count();
    return $count;
}
function mbaCoursesCount($mba){
    $count=\App\Models\MbaCourses::where('module_id',$mba->id)->count();
    return $count;
}
function updateAcademyChargeTransaction($user_id){
    $expiredDate=NULL;
    $charge=\App\Models\ChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if(count($charge)){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    $charge=\App\Models\DiplomasChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if(count($charge)){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    $charge=\App\Models\TrainingProgramsChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if(count($charge)){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    $charge=\App\Models\MbaChargeTransaction::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if(count($charge)){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    $charge=\App\Models\MedicalChargeTransactions::where('user_id',$user_id)->orderBy('end_date','DESC')->first();
    if(count($charge)){
        $expiredDate=($charge->end_date>$expiredDate)?$charge->end_date:$expiredDate;
    }
    if($expiredDate){
        $academy_charge_transaction=\App\Models\AcademyChargeTransaction::where('user_id',$user_id)->first();
        if(count($academy_charge_transaction)){
            $type='U';
            $academy_charge_transaction->expired_date=$expiredDate;
            $academy_charge_transaction->save();
        }else{
            $type='R';
            $academy_charge_transaction=new \App\Models\AcademyChargeTransaction();
            $academy_charge_transaction->user_id=$user_id;
            $academy_charge_transaction->expired_date=$expiredDate;
            $academy_charge_transaction->save();
        }
        RegisterOrUpdateCustomerAPI($user_id,$type);
    }
}
function RegisterOrUpdateCustomerAPI($user_id,$type='R'){
    $type=strtoupper($type);
    $user=\App\Models\AcademyUsers::find($user_id);
    $country=\App\Models\Country::find($user->country);
    $countrycode=$country->code;
    $mobilewithdash= $countrycode.'-'.preg_replace('/^'.$countrycode.'/', '', $user->Mobile);
    if(isset($user->id)){
        $data=[
            'SecretKey'=>'Secret',
            'MerchantId'=>'Merchant',
            'memberId'=>$user->id ,
            'sponsorId'=>$user->sponsorId,
            'JoiningDate'=>date("d/m/Y H:i:s", strtotime($user->RegisterDate)),
            'password'=>md5($user->Password),
            'gender'=>'',
            'fullName'=>$user->FullName,
            'BirthdayDate'=>'',
            /*    'DateOfBirthDay'=>22,
                'DateOfBirthMonth'=>4,
                'DateOfBirthYear'=>1991,*/
            'mobileNo'=>$mobilewithdash,//self::getCountryName($user->country,'code').'-'.$user->Mobile
            'emailId'=>$user->Email,
            'status'=>'true',
            /* 'nomDateOfBirthDay'=>date('d',strtotime($user->RegisterDate)),
             'nomDateOfBirthMonth'=>date('m',strtotime($user->RegisterDate)),
             'nomDateOfBirthYear'=>date('Y',strtotime($user->RegisterDate)),*/
            'ValidToDate'=>date("d/m/Y", strtotime(getAcademyExpiredDate($user_id))),
            'postalAddress'=>'',
            'country'=>$country->name,
            'stateProvince'=>'',
            'city'=>'',
            'zipCode'=>'',
        ];
        if($type=='R'){
            $data['username']=$user->Email;
            /* $data['JoiningDay']=date('d',strtotime($user->RegisterDate));
             $data['JoiningMonth']=date('m',strtotime($user->RegisterDate));
             $data['JoiningYear']=date('Y',strtotime($user->RegisterDate));*/
            // $data['JoiningDate']=date("d-m-Y H:i:s", strtotime($user->RegisterDate));
            // 'JoiningDate'=>date("d-m-Y H:i:s", strtotime($user->RegisterDate)),
            //  $data['password']=md5($user->Password);
        }
        // echo json_encode( $data);
        //self::sendApiData($data,$url="https://www.e3melbusiness.com/?page=testapi&action=sendRequest");
        sendApiData($data,"https://mlm.e3melbusiness.com/API/Customer/RegisterOrUpdateCustomer");
    }
}
function getAcademyExpiredDate($user_id){
    $academy=\App\Models\AcademyChargeTransaction::where('user_id',$user_id)->first();
    if(count($academy)){
        return $academy->expired_date;
    }
    return '';
}
function sendApiData($data,$url="")
{
    $date = date('Y-m-d H:i:s');
    if ($url) {
        $user_id = (isset($data['memberId'])) ? $data['memberId'] : '';
        $content = "";
        foreach ($data as $key => $value) {
            $content .= $key . '=' . trim($value) . '&';
        }
        //    echo $content;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
        $json_response = curl_exec($curl);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        //print_r($data);
        //echo '<br><br><br>';
        curl_close($curl);
        //echo $json_response;
        $ip = $_SERVER['REMOTE_ADDR'];
        $mlm_requests = new \App\Models\MlmRequests();
        $mlm_requests->user_id = $user_id;
        $mlm_requests->ip = $ip;
        $mlm_requests->data = $content;
        $mlm_requests->url = $url;
        $mlm_requests->response = $json_response;
        $mlm_requests->createtime = $date;
        $mlm_requests->save();
    }
}
function sendChargeTransactionToCRM($transaction_id,$tag_name,$email,$phone,$type,$name,$period,$start_date,$end_date,$price,$createdTime,$pending=null,$suspend=null){
    $url='https://crmegy.e3melbusiness.com/webservice/subscription.php';
    if($pending==0){
        $date=date('Y-m-d');
        $start_date=date('Y-m-d',strtotime($start_date));
        $end_date=date('Y-m-d',strtotime($end_date));
        if (!(($date >= $start_date) && ($date <= $end_date))&&!($start_date>$date&&$end_date>$date)){
            $pending=2;
        }
    }
    $data=[
        'transaction_id'=>$transaction_id,
        'tag_name'=>$tag_name,
        'email'=>$email,
        'phone'=>$phone,
        'type'=>$type,
        'name'=>$name,
        'period'=>$period,
        'start_date'=>date('Y-m-d',strtotime($start_date)),
        'end_date'=>date('Y-m-d',strtotime($end_date)),
        'unit_price'=>$price,
        'createdtime'=>date('Y-m-d H:i:s',strtotime($createdTime)),
        'pending'=>$pending,
        'suspend'=>$suspend,
    ];
    //print_r($data);
    //print_r($url);
    $content="";
    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
    //echo $content;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
    $json_response = curl_exec($curl);
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    //echo $json_response;
    //echo '<br><br>';
    //echo $json_response;
    //$ip=$_SERVER['REMOTE_ADDR'];
    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
    //self::execquery($query);
    $url='http://crmnew.almoasher.net/webservice/subscription.php';
    //print_r($data);
    //print_r($url);
    $content="";
    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
    //echo $content;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
    $json_response = curl_exec($curl);
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    //echo $json_response;
    //echo '<br><br>';
    //echo $json_response;
    //$ip=$_SERVER['REMOTE_ADDR'];
    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
    //self::execquery($query);
}
function sendChargeTransaction($charge_id){
    $charge=\App\Models\ChargeTransaction::select('charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'charge transaction',$charge->email,$charge->phone,$charge->subscrip_type,'charge for client',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendDiplomasChargeTransaction($charge_id){
    $charge=\App\Models\DiplomasChargeTransaction::select('diplomas_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','diplomas_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'diplomas transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->diploma_name,$charge->period,$charge->start_date,$charge->end_date,$charge->diploma_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendPackagesChargeTransaction($charge_id){
    $charge=\App\Models\PackagessChargeTransaction::select('packages_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','packages_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'packages transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->package_name,$charge->period,$charge->start_date,$charge->end_date,$charge->package_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendCustomChargeTransaction($charge_id){
    $charge=\App\Models\CustomChargeTransaction::select('custom_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','custom_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'custom transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->period,$charge->start_date,$charge->end_date,$charge->custom_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}

function sendTrainingProgramsChargeTransaction($charge_id){
    $charge=\App\Models\TrainingProgramsChargeTransaction::select('training_program_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','training_program_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'training program transaction',$charge->email,$charge->phone,$charge->subscrip_type,$charge->diploma_name,$charge->period,$charge->start_date,$charge->end_date,$charge->diploma_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}

function sendMbaChargeTransaction($charge_id){
    $charge=\App\Models\MbaChargeTransaction::select('mba_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','mba_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'mba transaction',$charge->email,$charge->phone,$charge->subscrip_type,'MBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendPreparatoryMbaChargeTransaction($charge_id){
    $charge=\App\Models\PreparatoryMbaChargeTransaction::select('preparatory_mba_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','preparatory_mba_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'preparatory mba transaction',$charge->email,$charge->phone,$charge->subscrip_type,'MBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}

function sendNewMbaChargeTransaction($charge_id){
    $charge=\App\Models\NewMbaChargeTransaction::select('new_mba_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','new_mba_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'new mba transaction',$charge->email,$charge->phone,$charge->subscrip_type,'MBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendDBAPreliminaryChargeTransaction($charge_id){
    $charge=\App\Models\DBAPreliminaryChargeTransaction::select('dba_preliminary_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','dba_preliminary_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'DBA Preliminary transaction',$charge->email,$charge->phone,$charge->subscrip_type,'DBA Preliminary',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendDBAChargeTransaction($charge_id){
    $charge=\App\Models\DBAChargeTransaction::select('dba_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','dba_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'DBA transaction',$charge->email,$charge->phone,$charge->subscrip_type,'DBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendNewMbaCategoriesChargeTransaction($charge_id){
    $charge=\App\Models\NewMbaCategoriesChargeTransaction::select('new_mba_categories_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','new_mba_categories_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'new mba categories transaction',$charge->email,$charge->phone,$charge->subscrip_type,'MBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendMedicalChargeTransaction($charge_id){
    $charge=\App\Models\MedicalChargeTransactions::select('medical_charge_transactions.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','medical_charge_transactions.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'medical transaction',$charge->email,$charge->phone,$charge->subscrip_type,'Medical',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendGiftCourseChargeTransaction($charge_id){
    $charge=\App\Models\GiftCourseChargeTransactions::select('gift_course_charge_transactions.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','gift_course_charge_transactions.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'gift course transaction',$charge->email,$charge->phone,$charge->subscrip_type,'Medical',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function sendFreeCourseChargeTransaction($charge_id){
    $charge=\App\Models\FreeCourseChargeTransactions::select('free_course_charge_transactions.*','courses.name AS course_name','users.country AS country','users.Email AS email','users.Mobile AS phone')
        ->join('users','users.id','free_course_charge_transactions.user_id')
        ->join('courses','courses.id','free_course_charge_transactions.course_id')
        ->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'free course transaction',$charge->email,$charge->phone,$charge->subscrip_type,'شحن كورس '.$charge->course_name.' لمدة ٧ ايام',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
	function sendGiftBookChargeTransaction($charge_id){
		$charge=\App\Models\GiftBookChargeTransactions::select('books_charge_transaction.*','users.Email AS email','users.Mobile AS phone')->join('users','users.id','books_charge_transaction.user_id')->find($charge_id);
		if(count($charge)){
			sendChargeTransactionToCRM($charge->id,'gift book transaction',$charge->email,$charge->phone,
				$charge->subscrip_type,'Medical',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
		}
	}
function sendLiteVersionChargeTransaction($charge_id){
    $charge=\App\Models\LiteVersionChargeTransaction::select('lite_version_charge_transaction.*','users.country AS country','users.Email AS email','users.Mobile AS phone')->join('users','users.id','lite_version_charge_transaction.user_id')->find($charge_id);
    if(count($charge)){
        sendChargeTransactionToCRM($charge->id,'lite version  transaction',$charge->email,$charge->phone,$charge->subscrip_type,'Lite Version',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime,$charge->pending,$charge->suspend);
    }
}
function calculateSecond($times){
//        global $useridstr;
//        $user_id=self::$sessionhandler2->get($useridstr);
//        $user_id=self::$encryption->decode($user_id);
    //echo'<br><br>';
    $seconds = 0; //declare minutes either it gives Notice: Undefined variable
    // loop throught all the times
    foreach ($times as $time) {
        if (stripos($time, "دقيقية") !== false) {
            switch (strlen(intval($time))){
                case 1:
                    $time='0'.intval($time).':00';
                    break;
                case 2:
                    $time=intval($time).':00';
                    break;
            }

            // echo $time;
            // echo'<br><br>';
        }elseif (stripos($time, "دقيقة") !== false) {
            switch (strlen(intval($time))){
                case 1:
                    $time='0'.intval($time).':00';
                    break;
                case 2:
                    $time=intval($time).':00';
                    break;
            }
            //echo $time;
            //echo'<br><br>';
        }else{
            //echo $time;
            //echo'<br><br>';
        }

        $hours=0;
        $minute=0;
        $second=0;
        $arr=explode(':', $time);
        if(count($arr)==3){
            list($hours,$minute,$second) = explode(':', $time);
        }elseif(count($arr)==2){
            list($minute,$second) = explode(':', $time);
        }elseif(count($arr)==1){
            list($second) = explode(':', $time);
        }

//            if($user_id==5733){
//                echo count(explode(':', $time));die();
//            }
//            echo $minute.'<br>'.$second;
//            echo'<br>---------------------<br>';
//            echo ($minute*60)+$second;
//            echo'<br>---------------------<br>';
        $seconds+=(($hours*60))*60;
        $seconds += ($minute*60);
        $seconds += $second;
        //echo $seconds;
        //echo'<br>---------------------<br>';
    }
    //echo $seconds;
    $hours = floor(($seconds / 60) / 60);
    $seconds -= ($hours*60)*60;
    $minutes=floor($seconds / 60);
    $seconds-=$minutes*60;
    //echo $seconds;
    //echo'<br><br>';
    // returns the time already formatted
    return sprintf('%02d:%02d:%02d', $hours, $minutes,$seconds);
}
function deleteChargeTransactionFromCRM($transaction_id,$tag_name){
    $url='https://crmegy.e3melbusiness.com/webservice/delete_subscription.php';
    $data=[
        'transaction_id'=>$transaction_id,
        'tag_name'=>$tag_name,
    ];
    //print_r($data);
    //print_r($url);
    $content="";
    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
    //echo $content;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
    $json_response = curl_exec($curl);
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    //echo '<br><br>';
    //echo $json_response;
    //echo $json_response;
    //$ip=$_SERVER['REMOTE_ADDR'];
    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
    //self::execquery($query);
    $url='http://ksanew.almoasherbiz.com/webservice/delete_subscription.php';
    //print_r($data);
    //print_r($url);
    $content="";
    foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
    //echo $content;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
    $json_response = curl_exec($curl);
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    //echo '<br><br>';
    //echo $json_response;
    //echo $json_response;
    //$ip=$_SERVER['REMOTE_ADDR'];
    //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
    //self::execquery($query);
}
function getEloquentSqlWithBindings($query)
{
    return vsprintf(str_replace('?', '%s', $query->toSql()), collect($query->getBindings())->map(function ($binding) {
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}
function getLastProjectData($allData,$table='new_mba_modules_users_projects'){
    $item=\Illuminate\Support\Facades\DB::connection('mysql2')->table($table)->select('createdtime','correction')->where('user_id',$allData->user_id)->where('module_id',$allData->module_id)->where('has_another',0)->orderBy('id','DESC')->first();
    if($item){
        return $item;
    }
    return null;
}
function getLastProjectDate($allData,$table='new_mba_modules_users_projects'){
    $item=\Illuminate\Support\Facades\DB::connection('mysql2')->table($table)->select('createdtime')->where('user_id',$allData->user_id)->where('module_id',$allData->module_id)->where('has_another',0)->first();
    if($item){
        return $item->createdtime;
    }
}
