<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrainingProgramsChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'training_program_charge_transaction';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendTrainingProgramsChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendTrainingProgramsChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
