<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use function foo\func;

class Packages extends Model
{
    use SoftDeletes;
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'packages';
    protected $appends = ['courses_count','duration','subscribers'];
    public function getCoursesCountAttribute(){
        return packageCoursesCount($this);
    }
    public function getDurationAttribute(){
        return courseDuration($this,'package');
    }

}
