<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MedicalDiplomas extends Model
{
    use SoftDeletes;
    public $timestamps = false;
    public $connection = 'mysql3';
    protected $table = 'medical_diplomas';
    protected $appends = ['courses_count','duration','subscribers'];

    public function getSubscribersAttribute(){
        return MedicalDiplomasChargeTransaction::where('diploma_id',$this->id)->count();
    }

}
