<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MedicalChargeTransactions extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'medical_charge_transactions';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendMedicalChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendMedicalChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
