<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MbaChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'mba_charge_transaction';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendMbaChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendMbaChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
