<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Mba extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'mba';
    protected $appends = ['courses_count','duration','subscribers'];

    public function getCoursesCountAttribute(){
        return mbaCoursesCount($this);
    }

    public function getDurationAttribute(){
        return courseDuration($this,'mba');
    }
    public function getSubscribersAttribute(){
        return ModulesUsersSummary::where('module_id',$this->id)->count();
    }

}
