<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LiteVersionChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'lite_version_charge_transaction';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendLiteVersionChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendLiteVersionChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
