<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InternationalDiplomas extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'international_diplomas';
    protected $appends = ['courses_count','duration','subscribers'];

    public function getCoursesCountAttribute(){
        return internationalDiplomaCoursesCount($this);
    }

    public function getDurationAttribute(){
        return courseDuration($this,'international_diploma');
    }
    public function getSubscribersAttribute(){
        return InternationalDiplomasChargeTransaction::where('diploma_id',$this->id)->count();
    }

}
