<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GiftCourseChargeTransactions extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'gift_course_charge_transactions';
    protected $guarded=['id'];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendGiftCourseChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendGiftCourseChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
