<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FreeCourseChargeTransactions extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'free_course_charge_transactions';
    protected $guarded=['id'];
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendFreeCourseChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendFreeCourseChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
