<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DiplomasChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'diplomas_charge_transaction';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendDiplomasChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendDiplomasChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
