<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Diplomas extends Model
{
    use SoftDeletes;
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'diplomas';
    protected $appends = ['courses_count','duration','subscribers'];

    public function getCoursesCountAttribute(){
        return diplomaCoursesCount($this);
    }

    public function getDurationAttribute(){
        return courseDuration($this,'diploma');
    }
    public function getSubscribersAttribute(){
        return DiplomasChargeTransaction::where('diploma_id',$this->id)->count();
    }

}
