<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DBAChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'dba_charge_transaction';
    protected static function boot()
    {
        parent::boot();
        static::updated(function ($model) {
            sendDBAChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendDBAChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
