<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ChargeTransaction extends Model
{
    public $timestamps = false;
    public $connection = 'mysql2';
    protected $table = 'charge_transaction';
    protected static function boot()
    {
        static::updated(function ($model) {
            sendChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
        static::created(function ($model) {
            sendChargeTransaction($model->id);
            updateAcademyChargeTransaction($model->user_id);
        });
    }
}
