<?php

namespace App\Http\Controllers\Admin;

use DB;
use App\Http\Controllers\Controller;
use Finagin\Comment\Models\Comment;
use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminAbstractController;

use App\Models\MbaCertificates;
use App\Models\MbaChargeTransaction;
use App\Models\ModulesUsersSummary;
use App\Models\NewMba;
use App\Models\NewMbaCertificates;
use App\Models\NewMbaChargeTransaction;
use App\Models\NewMbaUsersModuleExamsAnswers;
use App\Models\NewMbaUsersModuleExamsQuestions;
use App\Models\NewModulesUsersSummary;
use App\Models\UsersModuleExamsAnswers;
use App\Models\UsersModuleExamsQuestions;
use Illuminate\Support\Facades\DB as FacadesDB;

class NewMbaSummeryController extends AdminAbstractController
{
    function index(Request $request)
    {
        $data['modules'] = NewMba::pluck('id', 'name');

        return view('auth.new_mba_summery.view', $data);
    }
    public function searchForUser(Request $request)
    {
        $params = $request->all();
        $username = isset($params['email']) ? $params['email'] : '';
        $data = $this->getclientdata($username);
        $mba = NewMbaChargeTransaction::where('user_id', $data->id)->first();
        // dd($mba);
        if (isset($data->FullName) && is_object($mba)) {
            $cirtificate = NewMbaCertificates::where('user_id', $data->id)->first();

            echo '
                        <div class="well">
                            <div id="corporateDemoMessage"></div>
                            <div class="col-lg-6">
                                <address>
                                    <strong>Full Name : ' . $data->FullName . '</strong>
                                    <br>
                                    Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                    <br>
                                    Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                    <span id="country" class="hidden">' . $data->country . '</span>
                                  
                                    <div class="clearfix"></div><br/>';
            if (is_object($cirtificate))
                echo 'Cirtificate Serial:' . $cirtificate->serial_number;

            echo     ' </address></div><div class="clearfix"></div> </div>       ';
        } else {
        }
    }
    function getUserSummery(Request $request)
    {
        if ($request->has('email') && $request->email != '') {
            $data = $request->input();

            $userdata = $this->getclientdata($data['email']);
            $modules_users_summaries = NewModulesUsersSummary::leftJoin('new_mba', 'new_mba.id', '=', 'new_mba_modules_users_summary.module_id')
                ->leftJoin('new_mba_modules_projects', 'new_mba_modules_projects.id', '=', 'new_mba_modules_users_summary.project_id')
                ->leftJoin('new_mba_modules_users_projects', 'new_mba_modules_users_projects.id', '=', 'new_mba_modules_users_summary.project')
                ->leftJoin('users', 'users.id', '=', 'new_mba_modules_users_summary.user_id')
                ->select('new_mba_modules_users_summary.*', 'users.email as user_email', 'new_mba.name as mba_name', 'new_mba_modules_projects.title as modules_name', 'new_mba_modules_users_projects.result as result')
                ->where('new_mba_modules_users_summary.user_id', $userdata->id);


            if ($request->has('module_id') && $request->module_id != '') {

                $modules_users_summaries = $modules_users_summaries->where('new_mba_modules_users_summary.module_id', '=', $request->module_id);
            }


            $iTotalRecords = $modules_users_summaries->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'new_mba_modules_users_summary.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'new_mba_modules_users_summary.id';
                    break;
                case 1:
                    $columnName = 'new_mba_modules_users_summary.module_id';
                    break;
                case 2:
                    $columnName = 'new_mba_modules_users_summary.exam_part_1';
                    break;
                case 2:
                    $columnName = 'new_mba_modules_users_summary.exam_part_2';
                    break;
                case 5:
                    $columnName = 'new_mba_modules_users_summary.progress';
                    break;
              
            }
            $search = $data['search']['value'];
            if ($search) {
                $modules_users_summaries = $modules_users_summaries->where(function ($q) use ($search) {
                    $q->where('users.email', 'LIKE', "%$search%")
                        ->orWhere('mba.name', 'LIKE', "%$search%");
                });
            }
            if ($iDisplayLength < 1)
                $iDisplayLength = 20;

            $modules_users_summaries = $modules_users_summaries->skip($iDisplayStart)->take($iDisplayLength)->get();



            foreach ($modules_users_summaries as $modules_users_summary) {

                $records["data"][] = [
                    $modules_users_summary->id,
                    $modules_users_summary->modules_name,
                    $modules_users_summary->exam_part_1,
                    $modules_users_summary->exam_part_2,
                    $modules_users_summary->progress,
                
                    ''
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
        $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)

        $records["draw"] = 0;
        $records["recordsTotal"] = 0;
        $records["recordsFiltered"] = 0;
        $records['postData'] = [];
        return response()->json($records)->setCallback($request->input('callback'));
    }
    function getUseranswers(Request $request)
    {
        if ($request->has('email') && $request->email != '') {
            $data = $request->input();

            $data = $this->getclientdata($data['email']);
            $modules_users_answers = NewMbaUsersModuleExamsAnswers::join('new_mba', 'new_mba.id', '=', 'new_mba_users_module_exams_answers.module_id')

                ->select('new_mba.name AS Name', 'new_mba_users_module_exams_answers.*')
                ->where('new_mba_users_module_exams_answers.user_id', $data->id);


            if ($request->has('module_id') && $request->module_id != '') {

                $modules_users_answers = $modules_users_answers->where('new_mba_users_module_exams_answers.module_id', '=', $request->module_id);
            }


            $iTotalRecords = $modules_users_answers->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'modules_users_answers.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'new_mba_users_module_exams_answers.id';
                    break;
                case 1:
                    $columnName = 'new_mba_users_module_exams_answers.module_id';
                    break;
                case 2:
                    $columnName = 'new_mba_users_module_exams_answers.right_answers';
                    break;
                case 3:
                    $columnName = 'new_mba_users_module_exams_answers.wrong_answers';
                    break;
                case 4:
                    $columnName = 'new_mba_users_module_exams_answers.duration_time';
                    break;
                case 5:
                    $columnName = 'new_mba_users_module_exams_answers.ref';
                    break;
                case 6:
                    $columnName = 'new_mba_users_module_exams_answers.createdtime';
                    break;
            }
            $search = $data['search']['value'];
            if ($search) {
                $modules_users_answers = $modules_users_answers->where(function ($q) use ($search) {
                    $q->where('users.email', 'LIKE', "%$search%")
                        ->orWhere('mba.name', 'LIKE', "%$search%");
                });
            }
            if ($iDisplayLength < 1)
                $iDisplayLength = 20;

            $modules_users_answers = $modules_users_answers->skip($iDisplayStart)->take($iDisplayLength)->get();



            foreach ($modules_users_answers as $modules_users_answer) {

                $records["data"][] = [
                    $modules_users_answer->id,
                    $modules_users_answer->Name,
                    $modules_users_answer->right_answers,
                    $modules_users_answer->right_answers,
                    $modules_users_answer->wrong_answers,
                    $modules_users_answer->ref,
                    $modules_users_answer->createdtime,
                    ''
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
        $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)

        $records["draw"] = 0;
        $records["recordsTotal"] = 0;
        $records["recordsFiltered"] = 0;
        $records['postData'] = [];
        return response()->json($records)->setCallback($request->input('callback'));
    }
    function getUserQuestions(Request $request)
    {
        if ($request->has('email') && $request->email != '') {
            $data = $request->input();

            $userdata = $this->getclientdata($data['email']);
            $ids=NewMbaUsersModuleExamsAnswers::where('user_id',$userdata->id)->pluck('id')->toArray();
            $modules_users_questions = NewMbaUsersModuleExamsQuestions::join('new_mba', 'new_mba.id', '=', 'new_mba_users_module_exams_questions.module_id')

                ->select('new_mba.name AS name', 'new_mba_users_module_exams_questions.*')
                ->whereIn('new_mba_users_module_exams_questions.answer_id', $ids);

            if ($request->has('module_id') && $request->module_id != '') {

                $modules_users_questions = $modules_users_questions->where('new_mba_users_module_exams_questions.module_id', '=', $request->module_id);
            }


            $iTotalRecords = $modules_users_questions->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'new_mba_users_module_exams_questions.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'new_mba_users_module_exams_questions.id';
                    break;
                case 1:
                    $columnName = 'new_mba_users_module_exams_questions.module_id';
                    break;
                case 2:
                    $columnName = 'new_mba_users_module_exams_questions.type';
                    break;
                case 3:
                    $columnName = 'new_mba_users_module_exams_questions.name_en';
                    break;
                case 4:
                    $columnName = 'new_mba_users_module_exams_questions.answer';
                    break;
               
            }
            $search = $data['search']['value'];
            if ($search) {
                $modules_users_questions = $modules_users_questions->where(function ($q) use ($search) {
                    $q->where('mba.name', 'LIKE', "%$search%");
                });
            }
            if ($iDisplayLength < 1)
                $iDisplayLength = 20;

            $modules_users_questions = $modules_users_questions->skip($iDisplayStart)->take($iDisplayLength)->get();



            foreach ($modules_users_questions as $modules_users_question) {

                $records["data"][] = [
                    $modules_users_question->id,
                    $modules_users_question->name,
                    $modules_users_question->type,
                    $modules_users_question->name_en,
                    $modules_users_question->answer,
               
                    ''
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
        $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)

        $records["draw"] = 0;
        $records["recordsTotal"] = 0;
        $records["recordsFiltered"] = 0;
        $records['postData'] = [];
        return response()->json($records)->setCallback($request->input('callback'));
    }
    function exportSummery(Request $request){
        $data = $request->input();

        $userdata = $this->getclientdata($data['email']);
        $modules_users_summaries = NewModulesUsersSummary::leftJoin('new_mba', 'new_mba.id', '=', 'new_mba_modules_users_summary.module_id')
        ->leftJoin('new_mba_modules_projects', 'new_mba_modules_projects.id', '=', 'new_mba_modules_users_summary.project_id')
        ->leftJoin('new_mba_modules_users_projects', 'new_mba_modules_users_projects.id', '=', 'new_mba_modules_users_summary.project')
        ->leftJoin('users', 'users.id', '=', 'new_mba_modules_users_summary.user_id')
        ->select('new_mba.name as mba_name','new_mba_modules_users_summary.exam_part_1','new_mba_modules_users_summary.exam_part_2','new_mba_modules_users_summary.progress')
            ->where('new_mba_modules_users_summary.user_id', $userdata->id);
            if($request->module_id!='')
            $modules_users_summaries=$modules_users_summaries->where('new_mba_modules_users_summary.module_id',$request->module_id);
            $modules_users_summaries=$modules_users_summaries->get();
            $title=['Module Name','Exam degree part 1','Exam degree part 2','Progress'];
         
            $this->export($title,$modules_users_summaries->toArray(),'newmbasummery.csv');

    }
    function exportanswers(Request $request){
        $data = $request->input();

      
        $userdata = $this->getclientdata($data['email']);
        $modules_users_answers = NewMbaUsersModuleExamsAnswers::join('new_mba', 'new_mba.id', '=', 'new_mba_users_module_exams_answers.module_id')

                ->select('new_mba.name AS Name', 'new_mba_users_module_exams_answers.right_answers','new_mba_users_module_exams_answers.wrong_answers','new_mba_users_module_exams_answers.duration_time'
                ,'new_mba_users_module_exams_answers.ref',
            'new_mba_users_module_exams_answers.createdtime')
            ->where('new_mba_users_module_exams_answers.user_id', $userdata->id);


        if ($request->has('module_id') && $request->module_id != '') {

            $modules_users_answers = $modules_users_answers->where('new_mba_users_module_exams_answers.module_id', '=', $request->module_id);
        }
            $modules_users_answers=$modules_users_answers->get();
            $title=['Module Name','correct answer','wrong answer','Duration','from','created time'];
         
            $this->export($title,$modules_users_answers->toArray(),'answers.csv');

    }
    function exportquestions(Request $request){
        $data = $request->input();


        $userdata = $this->getclientdata($data['email']);
        $ids=NewMbaUsersModuleExamsAnswers::where('user_id',$userdata->id)->pluck('id')->toArray();
        $modules_users_questions = NewMbaUsersModuleExamsQuestions::join('new_mba', 'new_mba.id', '=', 'new_mba_users_module_exams_questions.module_id')

            ->select('new_mba.name AS name', 'new_mba_users_module_exams_questions.type','new_mba_users_module_exams_questions.name_en','new_mba_users_module_exams_questions.answer')
            ->whereIn('new_mba_users_module_exams_questions.answer_id', $ids);

     
            if($request->module_id!='')
            $modules_users_questions=$modules_users_questions->where('new_mba_users_module_exams_questions.module_id',$request->module_id);
            $modules_users_questions=$modules_users_questions->get();
            $title=['Course Program Name','Type Of Question ','Questions ','Number of right answers ( Note 1= right answer \ 0 = wrong answer )'];
         
            $this->export($title,$modules_users_questions->toArray(),'Questions.csv');

    }
    
    public function export($titles,$result,$name) {

     
            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename='.$name);

            $output = fopen("php://output", "w");

            fputcsv($output, $titles);

            foreach ($result as $res) {

                fputcsv($output,$res);
            }

            fclose($output);

        

    }
}
