<?php

namespace App\Http\Controllers\Admin;

use DB;
use App\Http\Controllers\Controller;
use Finagin\Comment\Models\Comment;
use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminAbstractController;
use App\Models\Mba;
use App\Models\MbaCertificates;
use App\Models\MbaChargeTransaction;
use App\Models\ModulesUsersSummary;
use App\Models\UsersModuleExamsAnswers;
use App\Models\UsersModuleExamsQuestions;
use Illuminate\Support\Facades\DB as FacadesDB;

class MbaSummeryController extends AdminAbstractController
{
    function index(Request $request)
    {
        $data['modules'] = Mba::pluck('id', 'name');

        return view('auth.mba_summery.view', $data);
    }
    public function searchForUser(Request $request)
    {
        $params = $request->all();
        $username = isset($params['email']) ? $params['email'] : '';
        $data = $this->getclientdata($username);
        $mba = MbaChargeTransaction::where('user_id', $data->id)->first();
        // dd($mba);
        if (isset($data->FullName) && is_object($mba)) {
            $cirtificate = MbaCertificates::where('user_id', $data->id)->first();

            echo '
                        <div class="well">
                            <div id="corporateDemoMessage"></div>
                            <div class="col-lg-6">
                                <address>
                                    <strong>Full Name : ' . $data->FullName . '</strong>
                                    <br>
                                    Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                    <br>
                                    Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                    <span id="country" class="hidden">' . $data->country . '</span>
                                  
                                    <div class="clearfix"></div><br/>';
            if (is_object($cirtificate))
                echo 'Cirtificate Serial:' . $cirtificate->serial_number;

            echo     ' </address></div><div class="clearfix"></div> </div>       ';
        } else {
        }
    }
    function getUserSummery(Request $request)
    {
        if ($request->has('email') && $request->email != '') {
            $data = $request->input();

            $userdata = $this->getclientdata($data['email']);
            $modules_users_summaries = ModulesUsersSummary::leftJoin('mba', 'mba.id', '=', 'modules_users_summary.module_id')
                ->leftJoin('modules_projects', 'modules_projects.id', '=', 'modules_users_summary.project_id')
                ->leftJoin('modules_users_projects', 'modules_users_projects.id', '=', 'modules_users_summary.project')
                ->leftJoin('users', 'users.id', '=', 'modules_users_summary.user_id')
                ->select('modules_users_summary.*', 'users.email as user_email', 'mba.name as mba_name', 'modules_projects.title as modules_name', 'modules_users_projects.result as result')
                ->where('modules_users_summary.user_id', $userdata->id);



            if ($request->has('module_id') && $request->module_id != '') {

                $modules_users_summaries = $modules_users_summaries->where('modules_users_summary.module_id', '=', $request->module_id);
            }


            $iTotalRecords = $modules_users_summaries->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'modules_users_summary.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'modules_users_summary.id';
                    break;
                case 1:
                    $columnName = 'modules_users_summary.module_id';
                    break;
                case 2:
                    $columnName = 'modules_users_summary.exam';
                    break;
                case 3:
                    $columnName = 'modules_users_summary.progress';
                    break;
                case 4:
                    $columnName = 'modules_users_projects.result';
                    break;
            }
            $search = $data['search']['value'];
            if ($search) {
                $modules_users_summaries = $modules_users_summaries->where(function ($q) use ($search) {
                    $q->where('users.email', 'LIKE', "%$search%")
                        ->orWhere('mba.name', 'LIKE', "%$search%");
                });
            }
            if ($iDisplayLength < 1)
                $iDisplayLength = 20;

            $modules_users_summaries = $modules_users_summaries->skip($iDisplayStart)->take($iDisplayLength)->get();



            foreach ($modules_users_summaries as $modules_users_summary) {

                $records["data"][] = [
                    $modules_users_summary->id,
                    $modules_users_summary->modules_name,
                    $modules_users_summary->exam,
                    $modules_users_summary->progress,
                    $modules_users_summary->result,
                    ''
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
        $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)

        $records["draw"] = 0;
        $records["recordsTotal"] = 0;
        $records["recordsFiltered"] = 0;
        $records['postData'] = [];
        return response()->json($records)->setCallback($request->input('callback'));
    }
    function getUseranswers(Request $request)
    {
        if ($request->has('email') && $request->email != '') {
            $data = $request->input();

            $userdata = $this->getclientdata($data['email']);
            $modules_users_answers = UsersModuleExamsAnswers::join('mba', 'mba.id', '=', 'users_module_exams_answers.module_id')

                ->select('mba.name AS Name', 'users_module_exams_answers.*')
                ->where('users_module_exams_answers.user_id', $userdata->id);


            if ($request->has('module_id') && $request->module_id != '') {

                $modules_users_answers = $modules_users_answers->where('users_module_exams_answers.module_id', '=', $request->module_id);
            }


            $iTotalRecords = $modules_users_answers->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'modules_users_answers.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'modules_users_answers.id';
                    break;
                case 1:
                    $columnName = 'modules_users_answers.module_id';
                    break;
                case 2:
                    $columnName = 'modules_users_answers.right_answers';
                    break;
                case 3:
                    $columnName = 'modules_users_answers.wrong_answers';
                    break;
                case 4:
                    $columnName = 'modules_users_answers.duration_time';
                    break;
                case 5:
                    $columnName = 'modules_users_answers.ref';
                    break;
                case 6:
                    $columnName = 'modules_users_answers.createdtime';
                    break;
            }
            $search = $data['search']['value'];
            if ($search) {
                $modules_users_answers = $modules_users_answers->where(function ($q) use ($search) {
                    $q->where('users.email', 'LIKE', "%$search%")
                        ->orWhere('mba.name', 'LIKE', "%$search%");
                });
            }
            if ($iDisplayLength < 1)
                $iDisplayLength = 20;

            $modules_users_answers = $modules_users_answers->skip($iDisplayStart)->take($iDisplayLength)->get();



            foreach ($modules_users_answers as $modules_users_answer) {

                $records["data"][] = [
                    $modules_users_answer->id,
                    $modules_users_answer->Name,
                    $modules_users_answer->right_answers,
                    $modules_users_answer->right_answers,
                    $modules_users_answer->wrong_answers,
                    $modules_users_answer->ref,
                    $modules_users_answer->createdtime,
                    ''
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
        $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)

        $records["draw"] = 0;
        $records["recordsTotal"] = 0;
        $records["recordsFiltered"] = 0;
        $records['postData'] = [];
        return response()->json($records)->setCallback($request->input('callback'));
    }
    function getUserQuestions(Request $request)
    {
        if ($request->has('email') && $request->email != '') {
            $data = $request->input();

            $userdata = $this->getclientdata($data['email']);
            $ids=UsersModuleExamsAnswers::where('user_id',$userdata->id)->pluck('id')->toArray();
            $modules_users_questions = UsersModuleExamsQuestions::join('mba', 'mba.id', '=', 'users_module_exams_questions.module_id')

                ->select('mba.name AS name', 'users_module_exams_questions.*')
                ->whereIn('users_module_exams_questions.answer_id', $ids);

            if ($request->has('module_id') && $request->module_id != '') {

                $modules_users_questions = $modules_users_questions->where('users_module_exams_questions.module_id', '=', $request->module_id);
            }


            $iTotalRecords = $modules_users_questions->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'users_module_exams_questions.id';
            switch ($data['order'][0]['column']) {
                case 0:
                    $columnName = 'users_module_exams_questions.id';
                    break;
                case 1:
                    $columnName = 'users_module_exams_questions.module_id';
                    break;
                case 2:
                    $columnName = 'users_module_exams_questions.type';
                    break;
                case 3:
                    $columnName = 'users_module_exams_questions.name_en';
                    break;
                case 4:
                    $columnName = 'users_module_exams_questions.answer';
                    break;
               
            }
            $search = $data['search']['value'];
            if ($search) {
                $modules_users_questions = $modules_users_questions->where(function ($q) use ($search) {
                    $q->where('mba.name', 'LIKE', "%$search%");
                });
            }
            if ($iDisplayLength < 1)
                $iDisplayLength = 20;

            $modules_users_questions = $modules_users_questions->skip($iDisplayStart)->take($iDisplayLength)->get();



            foreach ($modules_users_questions as $modules_users_question) {

                $records["data"][] = [
                    $modules_users_question->id,
                    $modules_users_question->name,
                    $modules_users_question->type,
                    $modules_users_question->name_en,
                    $modules_users_question->answer,
               
                    ''
                ];
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
        $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)

        $records["draw"] = 0;
        $records["recordsTotal"] = 0;
        $records["recordsFiltered"] = 0;
        $records['postData'] = [];
        return response()->json($records)->setCallback($request->input('callback'));
    }
    function exportSummery(Request $request){
        $data = $request->input();

        $data = $this->getclientdata($data['email']);
        $modules_users_summaries = ModulesUsersSummary::leftJoin('mba', 'mba.id', '=', 'modules_users_summary.module_id')
            ->leftJoin('modules_projects', 'modules_projects.id', '=', 'modules_users_summary.project_id')
            ->leftJoin('modules_users_projects', 'modules_users_projects.id', '=', 'modules_users_summary.project')
            ->leftJoin('users', 'users.id', '=', 'modules_users_summary.user_id')
            ->select('mba.name as mba_name','modules_users_summary.exam','modules_users_summary.progress', 'modules_users_projects.result as result')
            ->where('modules_users_summary.user_id', $data->id);
            if($request->module_id!='')
            $modules_users_summaries=$modules_users_summaries->where('modules_users_summary.module_id',$request->module_id);
            $modules_users_summaries=$modules_users_summaries->get();
            $title=['Module Name','Exam degree','Progress','Percentage'];
         
            $this->export($title,$modules_users_summaries->toArray(),'summery.csv');

    }
    function exportanswers(Request $request){
        $data = $request->input();

      
        $data = $this->getclientdata($data['email']);
        $modules_users_answers = UsersModuleExamsAnswers::join('mba', 'mba.id', '=', 'users_module_exams_answers.module_id')

            ->select('mba.name AS Name', 'users_module_exams_answers.right_answers','users_module_exams_answers.wrong_answers','users_module_exams_answers.duration_time','users_module_exams_answers.ref',
            'users_module_exams_answers.createdtime')
            ->where('users_module_exams_answers.user_id', $data->id);


        if ($request->has('module_id') && $request->module_id != '') {

            $modules_users_answers = $modules_users_answers->where('users_module_exams_answers.module_id', '=', $request->module_id);
        }
            $modules_users_answers=$modules_users_answers->get();
            $title=['Module Name','correct answer','wrong answer','Duration','from','created time'];
         
            $this->export($title,$modules_users_answers->toArray(),'answers.csv');

    }
    function exportquestions(Request $request){
        $data = $request->input();


        $data = $this->getclientdata($data['email']);
        $ids=UsersModuleExamsAnswers::where('user_id',$data->id)->pluck('id')->toArray();
        $modules_users_questions = UsersModuleExamsQuestions::join('mba', 'mba.id', '=', 'users_module_exams_questions.module_id')

            ->select('mba.name AS name', 'users_module_exams_questions.type','users_module_exams_questions.name_en','users_module_exams_questions.answer')
            ->whereIn('users_module_exams_questions.answer_id', $ids);

        if ($request->has('module_id') && $request->module_id != '') {

            $modules_users_questions = $modules_users_questions->where('users_module_exams_questions.module_id', '=', $request->module_id);
        }
         $modules_users_questions=$modules_users_questions->get();
            $title=['Course Program Name','Type Of Question ','Questions ','Number of right answers ( Note 1= right answer \ 0 = wrong answer )'];
         
            $this->export($title,$modules_users_questions->toArray(),'Questions.csv');

    }
    
    public function export($titles,$result,$name) {

     
            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename='.$name);

            $output = fopen("php://output", "w");

            fputcsv($output, $titles);

            foreach ($result as $res) {

                fputcsv($output,$res);
            }

            fclose($output);

        

    }
}
