<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;

class MbaReportController extends Controller
{
    private $_queryArray=[
        'mba_report_crm'=>"INSERT INTO  `mba_report_crm` ( `crm`, `name`, `phone`, `email`, `customer_status`, `assign_to`, `expired_date`, `subscrip_type`, `customer_type`, `last_commment_date`, `code`,start_date,end_date,certificate_date, `created_at`) SELECT *,NOW() FROM (SELECT '' AS CRM,users.FullName AS name,users.Mobile AS mobile,users.Email AS email ,'' AS customer_status,'' AS assign_to,(SELECT MAX(mba_charge_transaction.end_date) FROM mba_charge_transaction WHERE mba_charge_transaction.user_id=users.id) AS expired_date,'' AS subscrip_type,'' AS customer_type,'' AS last_commment_date,mba_certificates.serial_number AS code,(SELECT MIN(start_date) FROM mba_charge_transaction WHERE user_id=users.id),(SELECT MAX(end_date) FROM mba_charge_transaction WHERE user_id=users.id),mba_certificates.createdtime FROM users LEFT JOIN mba_certificates ON mba_certificates.user_id=users.id AND mba_certificates.deleted_at IS NULL WHERE users.id IN(SELECT DISTINCT user_id FROM mba_charge_transaction)) AS DD;",
        'new_mba_report_crm'=>"INSERT INTO  `new_mba_report_crm` ( `crm`, `name`, `phone`, `email`, `customer_status`, `assign_to`, `expired_date`, `subscrip_type`, `customer_type`, `last_commment_date`, `code`,start_date,end_date,certificate_date, `created_at`) SELECT *,NOW() FROM (SELECT '' AS CRM,users.FullName AS name,users.Mobile AS mobile,users.Email AS email ,'' AS customer_status,'' AS assign_to,(SELECT MAX(mba_charge_transaction.end_date) FROM mba_charge_transaction WHERE mba_charge_transaction.user_id=users.id) AS expired_date,'' AS subscrip_type,'' AS customer_type,'' AS last_commment_date,new_mba_certificates.serial_number AS code,(SELECT MIN(start_date) FROM new_mba_charge_transaction WHERE user_id=users.id),(SELECT MAX(end_date) FROM new_mba_charge_transaction WHERE user_id=users.id),new_mba_certificates.createdtime FROM users LEFT JOIN new_mba_certificates ON new_mba_certificates.user_id=users.id AND new_mba_certificates.deleted_at IS NULL WHERE users.id IN(SELECT DISTINCT user_id FROM new_mba_charge_transaction)) AS DD;",
//        'diplomas_report_crm'=>"INSERT INTO  `diplomas_report_crm` ( `crm`,`diploma_id`,`diploma_name`, `name`, `phone`, `email`, `customer_status`, `assign_to`, `expired_date`, `subscrip_type`, `customer_type`, `last_commment_date`, `code`, `created_at`) SELECT *,NOW() FROM (SELECT '' AS CRM,diploma_id,diploma_name,users.FullName AS name,users.Mobile AS mobile,users.Email AS email ,'' AS customer_status,'' AS assign_to,(SELECT MAX(diplomas_charge_transaction.end_date) FROM diplomas_charge_transaction WHERE diplomas_charge_transaction.user_id=users.id) AS expired_date,'' AS subscrip_type,'' AS customer_type,'' AS last_commment_date,diploma_certificates.serial_number AS code FROM users LEFT JOIN diploma_certificates ON diploma_certificates.user_id=users.id AND diploma_certificates.deleted_at IS NULL WHERE users.id IN(SELECT DISTINCT user_id FROM diplomas_charge_transaction)) AS DD;",
        'diplomas_report_crm'=>"INSERT INTO  `diplomas_report_crm` ( `crm`,`type`,`diploma_id`,`diploma_name`, `name`, `phone`, `email`, `customer_status`, `assign_to`, `expired_date`, `subscrip_type`, `customer_type`, `last_commment_date`, `code`,start_date,end_date,certificate_date, `created_at`) SELECT *,NOW() FROM (SELECT * FROM (
                  SELECT '' AS CRM,
                         'diplomas' AS type,
                         diplomas.id AS diploma_id,diplomas.name AS diploma_name,users.FullName AS name,users.Mobile AS mobile,users.Email AS email ,'' AS customer_status,'' AS assign_to,(SELECT MAX(diplomas_charge_transaction.end_date) FROM diplomas_charge_transaction WHERE diplomas_charge_transaction.user_id=users.id AND diplomas_charge_transaction.diploma_id=diplomas.id) AS expired_date,
                         '' AS subscrip_type,'' AS customer_type,'' AS last_commment_date
                          ,diploma_certificates.serial_number AS code,
                         (SELECT MIN(diplomas_charge_transaction.start_date)
                          FROM diplomas_charge_transaction
                          WHERE diplomas_charge_transaction.user_id = users.id) AS start_date,
                          (SELECT MAX(diplomas_charge_transaction.end_date)
                          FROM diplomas_charge_transaction
                          WHERE diplomas_charge_transaction.user_id = users.id) AS end_date,
                         diploma_certificates.createdtime
                  FROM (SELECT DISTINCT user_id,diploma_id FROM `diplomas_charge_transaction`) AS dd
                           INNER JOIN users ON users.id=dd.user_id
                           INNER JOIN diplomas ON diplomas.id=dd.diploma_id
                           LEFT JOIN diploma_certificates ON diploma_certificates.diploma_id=diplomas.id AND diploma_certificates.user_id=users.id

                  UNION

                  SELECT ''                                                                   AS CRM,
                         'international_diplomas' AS type,
                         international_diplomas.id                                            AS diploma_id,
                         international_diplomas.name                                          AS diploma_name,
                         users.FullName                                                       AS name,
                         users.Mobile                                                         AS mobile,
                         users.Email                                                          AS email,
                         ''                                                                   AS customer_status,
                         ''                                                                   AS assign_to,
                         (SELECT MAX(international_diplomas_charge_transaction.end_date)
                          FROM international_diplomas_charge_transaction
                          WHERE international_diplomas_charge_transaction.user_id = users.id) AS expired_date,
                         ''                                                                   AS subscrip_type,
                         ''                                                                   AS customer_type,
                         ''                                                                   AS last_commment_date,
                         international_diploma_certificates.serial_number                     AS code,
                         (SELECT MIN(international_diplomas_charge_transaction.start_date)
                          FROM international_diplomas_charge_transaction
                          WHERE international_diplomas_charge_transaction.user_id = users.id) AS start_date,
                          (SELECT MAX(international_diplomas_charge_transaction.end_date)
                          FROM international_diplomas_charge_transaction
                          WHERE international_diplomas_charge_transaction.user_id = users.id) AS end_date,
                         international_diploma_certificates.createdtime
                         
                  FROM (SELECT DISTINCT user_id, diploma_id FROM `international_diplomas_charge_transaction`) AS dd
                           INNER JOIN users ON users.id = dd.user_id
                           INNER JOIN international_diplomas ON international_diplomas.id = dd.diploma_id
                           LEFT JOIN international_diploma_certificates
                                     ON international_diploma_certificates.diploma_id = international_diplomas.id AND international_diploma_certificates.user_id=users.id
                  UNION
                  SELECT ''                                                             AS CRM,
                         'training_program' AS type,
                         training_program.id                                            AS diploma_id,
                         training_program.name                                          AS diploma_name,
                         users.FullName                                                 AS name,
                         users.Mobile                                                   AS mobile,
                         users.Email                                                    AS email,
                         ''                                                             AS customer_status,
                         ''                                                             AS assign_to,
                         (SELECT MAX(training_program_charge_transaction.end_date)
                          FROM training_program_charge_transaction
                          WHERE training_program_charge_transaction.user_id = users.id) AS expired_date,
                         ''                                                             AS subscrip_type,
                         ''                                                             AS customer_type,
                         ''                                                             AS last_commment_date,
                         training_program_certificates.serial_number                    AS code,
                         (SELECT MIN(training_program_charge_transaction.start_date)
                          FROM training_program_charge_transaction
                          WHERE training_program_charge_transaction.user_id = users.id) AS start_date,
                          (SELECT MAX(training_program_charge_transaction.end_date)
                          FROM training_program_charge_transaction
                          WHERE training_program_charge_transaction.user_id = users.id) AS end_date,
                         training_program_certificates.createdtime
                  FROM (SELECT DISTINCT user_id, diploma_id FROM `training_program_charge_transaction`) AS dd
                           INNER JOIN users ON users.id = dd.user_id
                           INNER JOIN training_program ON training_program.id = dd.diploma_id
                           LEFT JOIN training_program_certificates
                                     ON training_program_certificates.diploma_id = training_program.id AND training_program_certificates.user_id=users.id
              ) AS ww) AS dee;",
    ];
    public function updateMbaDataForReport(Request $request){
        $table_name='mba_report_crm';
        $this->updateReport($table_name);
    }
    public function updateNewMbaDataForReport(Request $request){
        $table_name='new_mba_report_crm';
        $this->updateReport($table_name);
    }

    public function updateDiplomasDataForReport(Request $request){
        $table_name='diplomas_report_crm';
        $this->updateReport($table_name);
    }

    public function CurlRequest($email){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ksanew.almoasherbiz.com/webservice/get_data_for_report.php?email=',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode(['email'=>$email]),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response) ;

    }

    public function mbaReports(Request $request){
        $table_name='mba_report_crm';
        return $this->getDataSearch($request, $table_name);
    }
    public function newMbaReports(Request $request){
        $table_name='new_mba_report_crm';
        return $this->getDataSearch($request, $table_name);
    }

    public function diplomasReports(Request $request){
        $table_name='diplomas_report_crm';
        return $this->getDataSearch($request, $table_name);
    }

    /**
     * @param Request $request
     * @param $table_name
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Foundation\Application|\Illuminate\Http\JsonResponse|\Illuminate\View\View
     */
    public function getDataSearch(Request $request, $table_name)
    {
        if ($request->ajax() || $request->export) {
            $data = $request->input();
            $mba_report_crm = DB::connection('mysql2')->table($table_name)->where(function ($q) {
                $q->whereNotNull('crm')->where('crm', '!=', '');
            });
            if (isset($data['id']) && !empty($data['id'])) {
                $id = $data['id'];
                $mba_report_crm = $mba_report_crm->where('id', '=', "$id");
            }
            if (isset($data['crm']) && !empty($data['crm'])) {
                $crm = $data['crm'];
                $mba_report_crm = $mba_report_crm->where('crm', '=', $crm);
            }
            if (isset($data['name']) && !empty($data['name'])) {
                $name = $data['name'];
                $mba_report_crm = $mba_report_crm->where('name', 'LIKE', "%$name%");
            }
            if (isset($data['email']) && !empty($data['email'])) {
                $email = $data['email'];
                $mba_report_crm = $mba_report_crm->where('email', 'LIKE', "%$email%");
            }
            if (isset($data['phone']) && !empty($data['phone'])) {
                $phone = $data['phone'];
                $mba_report_crm = $mba_report_crm->where('phone', 'LIKE', "%$phone%");
            }
            if (isset($data['customer_status']) && !empty($data['customer_status'])) {
                $customer_status = $data['customer_status'];
                $mba_report_crm = $mba_report_crm->where('customer_status', 'LIKE', "%$customer_status%");
            }
            if (isset($data['assign_to']) && !empty($data['assign_to'])) {
                $assign_to = $data['assign_to'];
                $mba_report_crm = $mba_report_crm->where('assign_to', 'LIKE', "%$assign_to%");
            }
            if (isset($data['date_from'], $data['date_to']) && (!empty($data['date_from']) || !empty($data['date_to']))) {
                $from = (!empty($data['date_from'])) ? $data['date_from'] : 0;
                $to = (!empty($data['date_to'])) ? $data['date_to'] : 0;
                $mba_report_crm = $mba_report_crm->whereBetween('expired_date', [$from, $to]);
            }
            if (isset($data['subscrip_type']) && !empty($data['subscrip_type'])) {
                $subscrip_type = $data['subscrip_type'];
                $mba_report_crm = $mba_report_crm->where('subscrip_type', 'LIKE', "%$subscrip_type%");
            }
            if (isset($data['customer_type']) && !empty($data['customer_type'])) {
                $customer_type = $data['customer_type'];
                $mba_report_crm = $mba_report_crm->where('customer_type', 'LIKE', "%$customer_type%");
            }
            if (isset($data['last_commment_date']) && !empty($data['last_commment_date'])) {
                $last_commment_date = $data['last_commment_date'];
                $mba_report_crm = $mba_report_crm->where('last_commment_date', 'LIKE', "%$last_commment_date%");
            }
            if (isset($data['code']) && !empty($data['code'])) {
                $code = $data['code'];
                $mba_report_crm = $mba_report_crm->where('code', 'LIKE', "%$code%");
            }
            if (isset($data['start_date_from'], $data['start_date_to']) && (!empty($data['start_date_from']) || !empty($data['start_date_to']))) {
                $from = (!empty($data['start_date_from'])) ? $data['start_date_from'] : 0;
                $to = (!empty($data['start_date_to'])) ? $data['start_date_to'] : 0;
                $mba_report_crm = $mba_report_crm->whereBetween('start_date', [$from, $to]);
            }
            if (isset($data['end_date_from'], $data['end_date_to']) && (!empty($data['end_date_from']) || !empty($data['end_date_to']))) {
                $from = (!empty($data['end_date_from'])) ? $data['end_date_from'] : 0;
                $to = (!empty($data['end_date_to'])) ? $data['end_date_to'] : 0;
                $mba_report_crm = $mba_report_crm->whereBetween('end_date', [$from, $to]);
            }
            if (isset($data['certificate_date_from'], $data['certificate_date_to']) && (!empty($data['certificate_date_from']) || !empty($data['certificate_date_to']))) {
                $from = (!empty($data['certificate_date_from'])) ? $data['certificate_date_from'] : 0;
                $to = (!empty($data['certificate_date_to'])) ? $data['certificate_date_to'] : 0;
                $mba_report_crm = $mba_report_crm->whereBetween('certificate_date', [$from, $to]);
            }
            if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
                $diploma_name = $data['diploma_name'];
                $mba_report_crm = $mba_report_crm->where('diploma_name', 'LIKE', "%$diploma_name%");
            }
            $iTotalRecords = $mba_report_crm->count();
            $iDisplayLength = intval($data['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($data['start']);
            $sEcho = intval($data['draw']);
            $records = [];
            $records["data"] = [];
            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;
            $columnName = 'id';
            switch ($data['order'][0]['column']) {
                case 1:
                    $columnName = 'crm';
                    break;
                case 2:
                    $columnName = 'name';
                    break;
                case 3:
                    $columnName = 'phone';
                    break;
                case 4:
                    $columnName = 'email';
                    break;
                case 5:
                    $columnName = 'customer_status';
                    break;
                case 6:
                    $columnName = 'assign_to';
                    break;
                case 7:
                    $columnName = 'expired_date';
                    break;
                case 8:
                    $columnName = 'subscrip_type';
                    break;
                case 9:
                    $columnName = 'customer_type';
                    break;
                case 10:
                    $columnName = 'last_commment_date';
                    break;
                case 11:
                    $columnName = 'code';
                    break;
                case 12:
                    $columnName = 'start_date';
                    break;
                case 13:
                    $columnName = 'end_date';
                    break;
                case 14:
                    $columnName = 'certificate_date';
                    break;
                case 15:
                    $columnName = 'diploma_name';
                    break;
            }
            if ($request->export) {
                $mba_report_crm = $mba_report_crm->orderBy($columnName, $data['order'][0]['dir'])->get();
                $output = ['#', 'CRM', 'Organization Name', 'Primary Phone', 'Primary Email', 'Customer Status', 'Assigned To', 'Expiry Date', 'Subscrip Type', 'Customer type', 'Last Comment Date', 'Code','Start Date','End Date','Certificate Date'];
                if(request()->segment(3)=='diplomas_reports'){
                    $output[]='diploma_name';
                }
                $filename = $table_name . '_' . time() . '.csv';
                $handle = fopen($filename, 'w+');
                fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
                fputcsv($handle, $output);
                foreach ($mba_report_crm as $mba_report) {
                    $dataExport=[
                        $mba_report->id,
                        $mba_report->crm,
                        $mba_report->name,
                        $mba_report->phone,
                        $mba_report->email,
                        $mba_report->customer_status,
                        $mba_report->assign_to,
                        $mba_report->expired_date,
                        $mba_report->subscrip_type,
                        $mba_report->customer_type,
                        $mba_report->last_commment_date,
                        $mba_report->code,
                        $mba_report->start_date,
                        $mba_report->end_date,
                        $mba_report->certificate_date,
                    ];
                    if(request()->segment(3)=='diplomas_reports'){
                        $dataExport[]= $mba_report->diploma_name;
                    }
                    fputcsv($handle,$dataExport);
                }
                fclose($handle);
                $headers = array(
                    'Content-Type' => 'text/csv;',
                    'Content-Disposition' => 'attachment; filename="' . $filename . '"'
                );
                return Response::download($filename, $filename, $headers);
            }
            $mba_report_crm = $mba_report_crm->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
                ->get();
            foreach ($mba_report_crm as $mba_report) {
                $recordsData=[
                    $mba_report->id,
                    $mba_report->crm,
                    $mba_report->name,
                    $mba_report->phone,
                    $mba_report->email,
                    $mba_report->customer_status,
                    $mba_report->assign_to,
                    $mba_report->expired_date,
                    $mba_report->subscrip_type,
                    $mba_report->customer_type,
                    $mba_report->last_commment_date,
                    $mba_report->code,
                    $mba_report->start_date,
                    $mba_report->end_date,
                    $mba_report->certificate_date,
                ];
                if(request()->segment(3)=='diplomas_reports'){
                    $recordsData[]= $mba_report->diploma_name;
                }
                $recordsData[]='';
                $records["data"][] = $recordsData;
            }
            if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
                $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
            }
            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;
            $records['postData'] = $data;
            //return response()->json($data)->setCallback($request->input('callback'));
            return response()->json($records)->setCallback($request->input('callback'));
        }
        $hasData=DB::connection('mysql2')->table($table_name)->whereNull('response')->count();
        return view('auth.crm_reports.' . $table_name,compact('hasData'));
    }

    /**
     * @param $table_name
     */
    public function updateReport($table_name)
    {
        DB::table('cronjob_log')->insert([
            'url'=>request()->fullUrl(),
            'method'=>request()->method(),
            'segments'=>implode('/',request()->segments()),
            'created_at'=>date('Y-m-d H:i:s'),
        ]);
        //TRUNCATE `mba_report_crm`;
        //dd($table_name,$this->_queryArray[$table_name]);
        if (DB::connection('mysql2')->table($table_name)->count() && DB::connection('mysql2')->table($table_name)->selectRaw("DATE_FORMAT(created_at,'%Y-%m-%d') AS created_at")->first()->created_at != date('Y-m-d')) {
//            DB::connection('mysql2')->table($table_name)->truncate();
//            DB::connection('mysql2')->select($this->_queryArray[$table_name]);
            DB::connection('mysql2')->unprepared("TRUNCATE `$table_name`;".$this->_queryArray[$table_name]);
        }elseif(!DB::connection('mysql2')->table($table_name)->count()){
            DB::connection('mysql2')->select($this->_queryArray[$table_name]);
        }
        $diplomas_reports = DB::connection('mysql2')->table($table_name)->whereNull('response')->take(1000)->get();
        foreach ($diplomas_reports as $diplomas_report) {
            $curlRequest = $this->CurlRequest($diplomas_report->email);
            if (isset($curlRequest->data)) {
                DB::connection('mysql2')->table($table_name)->where('id', $diplomas_report->id)->update([
                    'crm' => $curlRequest->data->crm,
                    'assign_to' => $curlRequest->data->assign_to,
                    'subscrip_type' => $curlRequest->data->subscrip_type,
                    'customer_type' => $curlRequest->data->customer_type,
                    'last_commment_date' => $curlRequest->data->last_commment_date,
                    'response' => json_encode($curlRequest),
                    'show' => 1,
                ]);
            } else {
                DB::connection('mysql2')->table($table_name)->where('id', $diplomas_report->id)->update([
                    'response' => json_encode($curlRequest),
                ]);
            }
        }
    }

}
