<?php

namespace App\Http\Controllers\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\DiplomaCertificates;
use App\Models\Record;
use Response;
use DB;
use Illuminate\Http\Response as HttpResponse;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

class CheckUsersController extends AdminAbstractController
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    function index(){
return view('auth.check_users_diploma.view');
    }
    function store(Request $request){
        $validator = Validator::make($request->all(),
        array(
            'file' => 'required|mimes:csv,txt',
        ));

    if ($validator->fails()) {
        $errorMessage = 'File not valid';
        return redirect()->back()->withErrors([$errorMessage]);
    }
 
    $file=$this->uploadfile(Input::file('file'));
    // $file='uploads/04-2022/16503682320L1BypJi9q.csv';
   
    $data=file_get_contents(public_path($file));
    $content = array_map("rtrim", explode("\n", $data));
  
    foreach($content as $key=>$value){
        if($key>0){
            
            $row=explode(',',$value);
            $certificate=DiplomaCertificates::leftJoin('users','users.id','=','diploma_certificates.user_id')
            ->leftJoin('diplomas','diplomas.id','=','diploma_certificates.diploma_id')
            ->where('diplomas.name','like',"%".trim($row[3])."%")
            ->where('users.email',trim($row[2]))
            ->first();
            $record=new Record();
            $record->name=trim($row[0]);
            $record->phone=trim($row[1]);
            $record->email=trim($row[2]);
            $record->diploma=trim($row[3]);
            if(is_object($certificate))
            $record->completed='yes';
            else
            $record->completed='no';
            $record->save();
          
        }
    }
    $records=Record::oldest('id')->get();
    Record::latest('id')->delete();
    return $this->generateReport($records,Input::file('file')->getClientOriginalName());

    }

private function uploadfile($file) {
    $path = 'uploads';
    if (!file_exists($path)) {
        mkdir($path, 0775);
    }
 
    $newdir = $path ;
    $exten = $file->getClientOriginalExtension();
    $filename = time().Str::random(10);
    $filename = $filename . '.' . $exten;
    $file->move($newdir, $filename);
    return $newdir . '/' . $filename;
}
function generateReport($data,$filename){
    $output = ['Name','Number','Email','Diploma','Finish'];
$filename = $filename;
$handle = fopen($filename, 'w+');

fputcsv($handle, $output);
foreach ($data as $one) {
    fputcsv($handle,[
    
        $one->name,
        $one->phone,
        $one->email,
        $one->diploma,
        $one->completed,
      
    ]);
}
fclose($handle);
$headers = array(
    'Content-Type' => 'text/csv;',
    'Content-Disposition' => 'attachment; filename="report.csv"'
);
return Response::download($filename, $filename, $headers);
}
}

