<?php

namespace App\Http\Controllers\Admin;

use App\Models\ActiveChargeTransactionLog;
use App\Models\AddDemoLog;
use App\Models\AlexEventPayment;
use App\Models\ArticlesCategories;
use App\Models\Authors;
use App\Models\AcademyUsers;
use App\Models\CertificatesRequests;
use App\Models\Companies;
use App\Models\CompaniesSuspend;
use App\Models\CoursesCurriculumCertificates;
use App\Models\CustomChargeTransaction;
use App\Models\DBACertificate;
use App\Models\DBAChargeTransaction;
use App\Models\DBAPreliminaryCertificates;
use App\Models\DBAPreliminaryChargeTransaction;
use App\Models\DeletedChargeTransaction;
use App\Models\DeletedCustomChargeTransaction;
use App\Models\DeletedDBAChargeTransaction;
use App\Models\DeletedDBAPreliminaryChargeTransaction;
use App\Models\DeletedDiplomasChargeTransaction;
use App\Models\DeletedGiftBookChargeTransaction;
use App\Models\DeletedGiftCourseChargeTransaction;
use App\Models\DeletedMedicalDiplomasChargeTransaction;
use App\Models\DeletedMedicalDiplomasCoursesUserPlan;
use App\Models\DeletedMedicalDiplomasUsersCourses;
use App\Models\DeletedPackagesChargeTransaction;
use App\Models\DeletedDiplomasCoursesUserPlan;
use App\Models\DeletedDiplomasUsersCourses;
use App\Models\DeletedInternationalDiplomasChargeTransaction;
use App\Models\DeletedMbaChargeTransaction;
use App\Models\DeletedNewMbaCategoriesChargeTransaction;
use App\Models\DeletedNewMbaChargeTransaction;
use App\Models\DeletedPreparatoryMbaChargeTransaction;
use App\Models\DeletedTrainingProgramsChargeTransaction;
use App\Models\DiplomaCertificates;
use App\Models\DiplomaCourse;
use App\Models\InternationalDiplomaCertificates;
use App\Models\MedicalDiplomasChangeLogs;
use App\Models\MedicalDiplomasCourses;
use App\Models\OnlinePaymentLinkGenerated;
use App\Models\PackageCourse;
use App\Models\DiplomasChangeLogs;
use App\Models\GiftBookChargeTransactions;
use App\Models\GiftCourseChargeTransactions;
use App\Models\InternationalDiplomasChargeTransaction;
use App\Models\InternationalDiplomasUsersCourses;
use App\Models\MbaCertificates;
use App\Models\MedicalChargeTransactions;
use App\Models\MedicalDiplomas;
use App\Models\MedicalDiplomasChargeTransaction;
use App\Models\Packages;
use App\Models\PackagesChargeTransaction;
use App\Models\MedicalDiplomasCoursesUsersPlan;
use App\Models\MedicalDiplomasUsersCourses;
use App\Models\NewMbaCategoriesChargeTransaction;
use App\Models\NewMbaCategory;
use App\Models\NewMbaCertificates;
use App\Models\PackagessChargeTransaction;
use App\Models\PreparatoryMbaCertificates;
use App\Models\PreparatoryMbaChargeTransaction;
use App\Models\States;
use App\Models\TrainingProgramCertificate;
use App\Models\TrainingProgramsChargeTransaction;
use App\Models\UserGenderUpdated;
use App\Models\UsersSuspendChargeTransaction;
use App\Models\Webinars;
use App\Models\BlockUsersExceptions;
use App\Models\Categories;
use App\Models\Feedback;
use App\Models\Mba;
use App\Models\Books;
use App\Models\Successstories;
use App\Models\Articles;
use App\Models\Instructors;
use App\Models\LifeTime;
use App\Models\LiteVersionChargeTransaction;
use App\Models\MbaCourses;
use App\Models\MedicalCategories;
use App\Models\ModulesUsersSummary;
use App\Models\NewModulesUsersSummary;
use App\Models\SessionUsers;
use App\Models\User;
use App\Models\Countries;
use App\Models\Diplomas;
use App\Models\TrainingProgram;
use App\Models\InternationalDiplomas;
use App\Models\InternationalDiplomasCoursesUsersPlan;
use App\Models\Courses;
use App\Models\UsersSuspend;
use App\Models\PhotoshopCourseUsers;
use App\Models\PmpCourseUsers;
use App\Models\ChargeTransaction;
use App\Models\DiplomasCoursesUsersPlan;
use App\Models\TrainingProgramCoursesUsersPlan;
use App\Models\DiplomasUsersCourses;
use App\Models\TrainingProgramUsersCourses;
use App\Models\DiplomasChargeTransaction;
use App\Models\MbaChargeTransaction;
use App\Models\NewMbaChargeTransaction;
use App\Models\UsersCurriculumAnswers;
use App\Models\CoursesCurriculum;
use App\Models\UsersSuspendLiteVersion;
use App\Models\CertificatesRequestsStatusLog;
use DB;
use App\Models\UsersSystems;
use Finagin\Comment\Models\Comment;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\helpers\Encryption;
use mysqli;
use Response;
use Illuminate\Support\Facades\Input;
use App\Models\MbaCoursesUserPlan;

class AdminController extends AdminAbstractController
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {

    }

    public function home()
    {

        $countries = Countries::select('name', 'code', 'id')->get();
        $diplomas = Diplomas::where('published', 'yes')->select('name', 'ksa_price', 'tool_eg_price', 'tool_ksa_price', 'id')->where('id', '!=', '59')->get();
        $packages = Packages::where('published', 'yes')->select('name', 'ksa_price', 'tool_eg_price', 'tool_ksa_price', 'id')->get();
        $new_mba_categories = NewMbaCategory::where('published', 'yes')->select('name', 'id')->where('id', '!=', '59')->get();
        $training_programs = TrainingProgram::select('name', 'ksa_price', 'tool_eg_price', 'tool_ksa_price', 'id')->where('id', '!=', '59')->get();
        $international_diplomas = InternationalDiplomas::select('name', 'tool_eg_price', 'tool_ksa_price', 'id')->get();
        $courses = Courses::select('name', 'id')->where('published','yes')->get();
        $gift_courses = Courses::select('name', 'id')->where('courses.show_on', '=', 'courses')->get();
        $books = Books::select('title', 'id')->get();
        $medical_categories = MedicalCategories::select('name', 'id')->get();
        //dd($countries);
        return view('auth.dashboard', compact('countries', 'packages','diplomas', 'courses', 'medical_categories', 'international_diplomas', 'training_programs', 'new_mba_categories', 'gift_courses', 'books'));
    }

    public function profile()
    {
        return view('auth.users.profile');
    }

    public function profilePost(Request $request)
    {
        $data = $request->input();
        $validator = Validator::make($request->all(),
            array(
                'name' => 'required',
                'email' => 'required|unique:users,email,' . Auth::id(),
                'username' => 'required|unique:users,username,' . Auth::id(),
                'old_password' => 'required',
            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            if (Hash::check($request->input('old_password'), Auth::user()->password)) {
                $user = User::find(Auth::user()->id);
                if ($request->hasFile('image')) {
                    $rules = array('image' => 'required|image|mimes:jpeg,gif,bmp,png');
                    $validator = Validator::make(array('image' => $request->file('image')), $rules);
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator->errors())->withInput();
                    }
                    if (file_exists(public_path() . $user->img_dir . $user->img)) {
                        unlink(public_path() . $user->img_dir . $user->img);
                    }
                    if (file_exists(public_path() . $user->img_dir . 'thumbnail/thumbnail_' . $user->img)) {
                        unlink(public_path() . $user->img_dir . 'thumbnail/thumbnail_' . $user->img);
                    }
                    $file = $request->file('image');
                    $image = FileImage($file, 'Users');
                    $user->img = $image['img'];
                    $user->img_dir = $image['img_dir'];
                }
                $user->name = $request->input('name');
                $user->username = $request->input('username');
                $user->email = $request->input('email');
                if (!empty($request->input('new_password'))) {
                    $user->password = Hash::make($request->input('new_password'));
                }
                if ($user->save()) {
                    Session::flash('success', Lang::get('main.updated'));
                    return Redirect::to('admin/profile');
                }
            } else {
                Session::flash('error', Lang::get('main.error_user_password'));
                return Redirect::to('admin/profile');
            }
        }
    }

    public function system()
    {
        $system = UsersSystems::where('user_id', Auth::user()->id)->first();
        if (!count($system)) {
            $system = new UsersSystems();
            $system->user_id = Auth::user()->id;
            $system->save();
        }
        return view('auth.settings.system', compact('system'));
    }

    public function systemPost(Request $request)
    {
        $system = UsersSystems::where('user_id', Auth::user()->id)->first();
        if (!count($system)) {
            $system = new UsersSystems();
            $system->user_id = Auth::user()->id;
            $system->save();
        }

        $data = $request->input();;
        $validator = Validator::make($request->all(),
            array(
                'backend_lang' => 'required',
                'backend_color' => 'required',
                'backend_layout' => 'required',
                'backend_header' => 'required',
                'backend_top_menu_dropdown' => 'required',
                'backend_sidebar_menu_mode' => 'required',
                /*'backend_sidebar_menu_sub_show'=>'required',*/
                'backend_sidebar_menu_style' => 'required',
                'backend_sidebar_menu_position' => 'required',
                'backend_footer' => 'required',

            ));
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
            $system->backend_lang = $data['backend_lang'];
            $system->backend_color = $data['backend_color'];
            $system->backend_layout = $data['backend_layout'];
            $system->backend_header = $data['backend_header'];
            $system->backend_top_menu_dropdown = $data['backend_top_menu_dropdown'];
            $system->backend_sidebar_menu_mode = $data['backend_sidebar_menu_mode'];
            /*$system->backend_sidebar_menu_sub_show=$data['backend_sidebar_menu_sub_show'];*/
            $system->backend_sidebar_menu_style = $data['backend_sidebar_menu_style'];
            $system->backend_sidebar_menu_position = $data['backend_sidebar_menu_position'];
            $system->backend_footer = $data['backend_footer'];
            $system->lastedit_by = Auth::user()->id;
            $system->lastedit_date = date('Y-m-d H:i:s');
            if ($system->save()) {
                Session::flash('success', Lang::get('main.updated'));
                return Redirect::to('admin/system');
            }
        }
    }

    public function annual_report()
    {
        $subscribe_types = ChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = ChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.annual.view', compact('subscribe_types', 'currencies'));
    }

    public function feedback_report()
    {
        return view('auth.feedback_report.view');
    }

    public function training_program_report()
    {
        $subscribe_types = TrainingProgramsChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = TrainingProgramsChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.training_program_report.view', compact('subscribe_types', 'currencies'));
    }

    /*
     * Start Export User Training Programs Courses Certificates
     * Report
     */

    public function export_user_training_programs_courses_certificates_report($user_id, $diploma_id)
    {
        $this->getUserTrainingProgramsCoursesCertificatesReport($user_id, $diploma_id);
    }

    /*
    * Start Export User Diplomas Courses Certificates
    * Report
    */
    public function training_program_report_export(Request $request)
    {
        $data = $request->input();
        $transactions = TrainingProgramsChargeTransaction::leftjoin('users', 'users.id', '=', 'training_program_charge_transaction.user_id')
            ->leftjoin('employees', 'employees.id', '=', 'training_program_charge_transaction.employee_id')
            ->select('training_program_charge_transaction.*', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'employees.username AS employee_name', DB::raw("(SELECT ((SUM(users_diploma_view_completed.completed)/SUM(users_diploma_view_completed.total))*100) AS percentage FROM `users_diploma_view_completed` WHERE users_diploma_view_completed.user_id=training_program_charge_transaction.user_id AND users_diploma_view_completed.diploma_id=training_program_charge_transaction.diploma_id) AS completed"));
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('training_program_charge_transaction.id', '=', "$id");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('training_program_charge_transaction.period', '=', "$period");
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('training_program_charge_transaction.subscrip_type', 'LIKE', "%$subscribe_type%");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('training_program_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('training_program_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('training_program_charge_transaction.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('training_program_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $transactions = $transactions->where('training_program_charge_transaction.diploma_name', 'LIKE', "%$diploma_name%");
        }
        $transactions = $transactions->get();
        $output = ['ID', Lang::get('main.user_name'), Lang::get('main.email'), Lang::get('main.mobile'), Lang::get('main.period'), Lang::get('main.createdtime')
            , Lang::get('main.expired_date'), Lang::get('main.completed'), Lang::get('main.diploma_id'), Lang::get('main.diploma_name'), Lang::get('main.complete%'), Lang::get('main.subscribed_type')
            , Lang::get('main.amount'), Lang::get('main.currency'), Lang::get('main.employee_name')];
        $filename = "report.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);
        foreach ($transactions as $transaction) {
            fputcsv($handle, [
                $transaction->id,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->completed == 100 ? 'Yes' : 'No',
                $transaction->diploma_id,
                $transaction->diploma_name,
                $transaction->completed . '%',
                $transaction->subscrip_type,
                $transaction->amount,
                $transaction->currency,
                $transaction->employee_name,
            ]);
        }
        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="report.csv"'
        );
        return Response::download($filename, 'report.csv', $headers);
    }

    public function training_program_report_search(Request $request)
    {
        $data = $request->input();
        $transactions = TrainingProgramsChargeTransaction::leftjoin('users', 'users.id', '=', 'training_program_charge_transaction.user_id')
            ->leftjoin('employees', 'employees.id', '=', 'training_program_charge_transaction.employee_id')
            ->select('training_program_charge_transaction.*', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'employees.username AS employee_name', DB::raw("(SELECT ((SUM(users_diploma_view_completed.completed)/SUM(users_diploma_view_completed.total))*100) AS percentage FROM `users_diploma_view_completed` WHERE users_diploma_view_completed.user_id=training_program_charge_transaction.user_id AND users_diploma_view_completed.diploma_id=training_program_charge_transaction.diploma_id) AS completed"));
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('training_program_charge_transaction.id', '=', "$id");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('training_program_charge_transaction.period', '=', "$period");
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('training_program_charge_transaction.subscrip_type', 'LIKE', "%$subscribe_type%");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('training_program_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('training_program_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('training_program_charge_transaction.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('training_program_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $transactions = $transactions->where('training_program_charge_transaction.diploma_name', 'LIKE', "%$diploma_name%");
        }

        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'training_program_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'training_program_charge_transaction.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'training_program_charge_transaction.period';
                break;
            case 5:
                $columnName = 'training_program_charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'training_program_charge_transaction.end_date';
                break;
            case 7:
                $columnName = 'training_program_charge_transaction.id';
                break;
            case 8:
                $columnName = 'training_program_charge_transaction.diploma_name';
                break;
            case 9:
                $columnName = 'completed';
                break;
            case 10:
                $columnName = 'training_program_charge_transaction.subscrip_type';
                break;
            case 11:
                $columnName = 'training_program_charge_transaction.amount';
                break;
            case 12:
                $columnName = 'training_program_charge_transaction.currency';
                break;
            case 13:
                $columnName = 'employees.username';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $transactions = $transactions->where(function ($q) use ($search) {
                $q->where('users.FullName', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.period', '=', "$search")
                    ->orWhere('training_program_charge_transaction.subscrip_type', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.diploma_name', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.amount', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.currency', 'LIKE', "%$search%")
                    ->orWhere('employees.username', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.id', '=', $search);
            });
        }

        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $transaction->id,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->completed == 100 ? 'Yes' : 'No',
                $transaction->diploma_name,
                $transaction->completed . '%',
                $transaction->subscrip_type,
                $transaction->amount,
                $transaction->currency,
                $transaction->employee_name,
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function diploma_report()
    {
        $subscribe_types = DiplomasChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = DiplomasChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.diploma_report.view', compact('subscribe_types', 'currencies'));
    }

    /*
     * Start Export User Diplomas Courses Certificates
     * Report
     */

    public function export_user_diplomas_courses_certificates_report($user_id, $diploma_id)
    {
        $this->getUserDiplomasCoursesCertificatesReport($user_id, $diploma_id);
    }

    /*
    * Start Export User Diplomas Courses Certificates
    * Report
    */
    public function diploma_report_export(Request $request)
    {
        ini_set('memory_limit', '8192M');
        $data = $request->input();
        $transactions = DiplomasChargeTransaction::leftjoin('users', 'users.id', '=', 'diplomas_charge_transaction.user_id')
            ->leftjoin('employees', 'employees.id', '=', 'diplomas_charge_transaction.employee_id')
            ->leftjoin('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction.diploma_id')
            ->select('diplomas_charge_transaction.*', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'employees.username AS employee_name', 'diplomas.name AS diploma_name', DB::raw("(SELECT ((SUM(users_diploma_view_completed.completed)/SUM(users_diploma_view_completed.total))*100) AS percentage FROM `users_diploma_view_completed` WHERE users_diploma_view_completed.user_id=diplomas_charge_transaction.user_id AND users_diploma_view_completed.diploma_id=diplomas_charge_transaction.diploma_id) AS completed"));
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('diplomas_charge_transaction.id', '=', "$id");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('diplomas_charge_transaction.period', '=', "$period");
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$subscribe_type%");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('diplomas_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('diplomas_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('diplomas_charge_transaction.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('diplomas_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $transactions = $transactions->where('diplomas_charge_transaction.diploma_name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['markets']) && !empty($data['markets'])) {
            $markets = $data['markets'];
            $transactions = $transactions->where('diplomas_charge_transaction.charge_system', 'LIKE', "%$markets%");
        }
        $transactions = $transactions->get();
        $output = ['ID', Lang::get('main.user_name'), Lang::get('main.email'), Lang::get('main.mobile'), Lang::get('main.period'), Lang::get('main.createdtime')
            , Lang::get('main.expired_date'), Lang::get('main.completed'), Lang::get('main.markets'), Lang::get('main.diploma_id'), Lang::get('main.diploma_name'), Lang::get('main.complete%'), Lang::get('main.subscribed_type')
            , Lang::get('main.amount'), Lang::get('main.currency'), Lang::get('main.employee_name')];
        $filename = "diploma_report.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);
        foreach ($transactions as $transaction) {
            fputcsv($handle, [
                $transaction->id,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->completed == 100 ? 'Yes' : 'No',
                $transaction->charge_system == 'egy' ? 'Egypt ' : 'KSA',
                $transaction->diploma_id,
                $transaction->diploma_name,
                $transaction->completed . '%',
                $transaction->subscrip_type,
                $transaction->amount,
                $transaction->currency,
                $transaction->employee_name,
            ]);
        }
        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="diploma_report.csv"'
        );
        return Response::download($filename, 'diploma_report.csv', $headers);
    }

    public function diploma_report_search(Request $request)
    {
        $data = $request->input();
        $transactions = DiplomasChargeTransaction::leftjoin('users', 'users.id', '=', 'diplomas_charge_transaction.user_id')
            ->leftjoin('employees', 'employees.id', '=', 'diplomas_charge_transaction.employee_id')
            ->leftjoin('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction.diploma_id')
            ->select('diplomas_charge_transaction.*', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'employees.username AS employee_name', 'diplomas.name AS diploma_name', DB::raw("(SELECT ((SUM(users_diploma_view_completed.completed)/SUM(users_diploma_view_completed.total))*100) AS percentage FROM `users_diploma_view_completed` WHERE users_diploma_view_completed.user_id=diplomas_charge_transaction.user_id AND users_diploma_view_completed.diploma_id=diplomas_charge_transaction.diploma_id) AS completed"));

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('diplomas_charge_transaction.id', '=', "$id");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('diplomas_charge_transaction.period', '=', "$period");
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$subscribe_type%");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('diplomas_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('diplomas_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('diplomas_charge_transaction.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('diplomas_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $transactions = $transactions->where('diplomas.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['markets']) && !empty($data['markets'])) {
            $markets = $data['markets'];
            if($markets=='egypt' || $markets=='egyp'){
                $markets='egy';
            }
            $transactions = $transactions->where('diplomas_charge_transaction.charge_system', 'LIKE', "%$markets%");
        }
        if (isset($data['diploma_id']) && !empty($data['diploma_id'])) {
            $diploma_id = $data['diploma_id'];
            $transactions = $transactions->where('diplomas_charge_transaction.diploma_id', $diploma_id);
        }

        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'diplomas_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'diplomas_charge_transaction.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'diplomas_charge_transaction.period';
                break;
            case 5:
                $columnName = 'diplomas_charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'diplomas_charge_transaction.end_date';
                break;
            case 7:
                $columnName = 'diplomas_charge_transaction.id';
                break;
            case 8:
                $columnName = 'diplomas.name';
                break;
            case 9:
                $columnName = 'completed';
                break;
            case 10:
                $columnName = 'diplomas_charge_transaction.charge_system';
                break;
            case 11:
                $columnName = 'diplomas_charge_transaction.subscrip_type';
                break;
            case 12:
                $columnName = 'diplomas_charge_transaction.amount';
                break;
            case 13:
                $columnName = 'diplomas_charge_transaction.currency';
                break;
            case 14:
                $columnName = 'employees.username';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $transactions = $transactions->where(function ($q) use ($search) {
                $q->where('users.FullName', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
                    ->orWhere('diplomas.name', 'LIKE', "%$search%")
                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
                    ->orWhere('diplomas_charge_transaction.charge_system', 'LIKE', "%$search%")
                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
                    ->orWhere('employees.username', 'LIKE', "%$search%")
                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
            });
        }
        //dd(getEloquentSqlWithBindings($transactions));
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $transaction->id,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->completed == 100 ? 'Yes' : 'No',
                $transaction->charge_system == 'egy' ? 'Egypt ' : 'KSA',
                $transaction->diploma_name,
                $transaction->completed . '%',
                $transaction->subscrip_type,
                $transaction->amount,
                $transaction->currency,
                $transaction->employee_name,
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }



    public function courses_report()
    {
        $categories = Categories::pluck('name', 'id');
        $instructors = Instructors::pluck('name', 'id');
        return view('auth.courses_report.view', compact('categories', 'instructors'));
    }

    public function courses_watching_report()
    {
        return view('auth.courses_watching_report.view');
    }

    public function diplomas_report()
    {
        return view('auth.diplomas_report.view');
    }

    public function training_programs_report()
    {
        $subscribe_types = TrainingProgramsChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = TrainingProgramsChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.training_programs_report.view',compact('subscribe_types','currencies'));
    }

    public function training_programs_report_search(Request $request)
    {
        $data = $request->input();
        $transactions = TrainingProgramsChargeTransaction::leftjoin('users', 'users.id', '=', 'training_program_charge_transaction.user_id')
            ->leftjoin('employees', 'employees.id', '=', 'training_program_charge_transaction.employee_id')
            ->select('training_program_charge_transaction.*', 'users.FullName AS username', 'users.Email AS email'
                , 'users.Mobile AS phone', 'employees.username AS employee_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('training_program_charge_transaction.id', '=', "$id");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('training_program_charge_transaction.period', 'LIKE', "%$period%");
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('training_program_charge_transaction.subscrip_type', 'LIKE', "%$subscribe_type%");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('training_program_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('training_program_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('training_program_charge_transaction.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['markets']) && !empty($data['markets'])) {
            $markets = $data['markets'];
            if($markets=='egypt' || $markets=='egyp'){
                $markets='egy';
            }
            $transactions = $transactions->where('training_program_charge_transaction.subscrip_country', 'LIKE', "%$markets%");
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }

        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'training_program_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'training_program_charge_transaction.id';
                break;
            case 1:
                $columnName = 'training_program_charge_transaction.id';
                break;
            case 2:
                $columnName = 'users.FullName';
                break;
            case 3:
                $columnName = 'users.Email';
                break;
            case 4:
                $columnName = 'users.Mobile';
                break;
            case 5:
                $columnName = 'training_program_charge_transaction.period';
                break;
            case 6:
                $columnName = 'training_program_charge_transaction.createtime';
                break;
            case 7:
                $columnName = 'training_program_charge_transaction.end_date';
                break;
            case 8:
                $columnName = 'training_program_charge_transaction.subscrip_country';
                break;
            case 9:
                $columnName = 'training_program_charge_transaction.subscrip_type';
                break;
            case 10:
                $columnName = 'training_program_charge_transaction.amount';
                break;
            case 11:
                $columnName = 'training_program_charge_transaction.currency';
                break;
            case 12:
                $columnName = 'employees.username';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $transactions = $transactions->where(function ($q) use ($search) {
                $q->where('users.FullName', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.period', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.subscrip_type', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.subscrip_country', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.amount', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.currency', 'LIKE', "%$search%")
                    ->orWhere('employees.username', 'LIKE', "%$search%")
                    ->orWhere('training_program_charge_transaction.id', '=', $search);
            });
        }
        if($request->routeIs('training_programs_report_export')){
            $transactions=$transactions->orderBy($columnName, $data['order'][0]['dir'])->get();
            $output = ['ID', Lang::get('main.user_name'), Lang::get('main.email'),
                Lang::get('main.phone'),
                Lang::get('main.period'),
                Lang::get('main.createdtime'),
                Lang::get('main.expired_time'),
                Lang::get('main.expired_time'),
                Lang::get('main.markets'),
                Lang::get('main.subscibe_type'),
                Lang::get('main.amount'),
                Lang::get('main.currency'),
                Lang::get('main.employee_name'),
            ];

            $filename = 'training_programs_report_'.time().'.csv';
            $handle = fopen($filename, 'w+');
            fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            fputcsv($handle, $output);
            foreach ($transactions as $transaction) {
                fputcsv($handle, [
                    $transaction->id,
                    $transaction->username,
                    $transaction->email,
                    $transaction->phone,
                    $transaction->period,
                    $transaction->createtime,
                    $transaction->end_date,
                    $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                    $transaction->subscrip_type,
                    $transaction->amount,
                    $transaction->currency,
                    $transaction->employee_name,
                ]);
            }
            fclose($handle);
            $headers = array(
                'Content-Type' => 'text/csv;',
                'Content-Disposition' => 'attachment; filename="'.$filename.'"'
            );
            return Response::download($filename, $filename, $headers);
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $transaction->id,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                $transaction->subscrip_type,
                $transaction->amount,
                $transaction->currency,
                $transaction->employee_name,
                '',
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }


    public function international_diplomas_report()
    {
        $subscribe_types = TrainingProgramsChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = TrainingProgramsChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.international_diplomas_report.view',compact('subscribe_types','currencies'));
    }

    public function international_diplomas_report_search(Request $request)
    {
        $data = $request->input();
        $transactions = InternationalDiplomasChargeTransaction::leftjoin('users', 'users.id', '=', 'international_diplomas_charge_transaction.user_id')
            ->leftjoin('employees', 'employees.id', '=', 'international_diplomas_charge_transaction.employee_id')
            ->select('international_diplomas_charge_transaction.*', 'users.FullName AS username', 'users.Email AS email'
                , 'users.Mobile AS phone', 'employees.username AS employee_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('international_diplomas_charge_transaction.id', '=', "$id");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('international_diplomas_charge_transaction.period', 'LIKE', "%$period%");
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('international_diplomas_charge_transaction.subscrip_type', 'LIKE', "%$subscribe_type%");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('international_diplomas_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('international_diplomas_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('international_diplomas_charge_transaction.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['markets']) && !empty($data['markets'])) {
            $markets = $data['markets'];
            if($markets=='egypt' || $markets=='egyp'){
                $markets='egy';
            }
            $transactions = $transactions->where('international_diplomas_charge_transaction.subscrip_country', 'LIKE', "%$markets%");
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }

        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'international_diplomas_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'international_diplomas_charge_transaction.id';
                break;
            case 1:
                $columnName = 'international_diplomas_charge_transaction.id';
                break;
            case 2:
                $columnName = 'users.FullName';
                break;
            case 3:
                $columnName = 'users.Email';
                break;
            case 4:
                $columnName = 'users.Mobile';
                break;
            case 5:
                $columnName = 'international_diplomas_charge_transaction.period';
                break;
            case 6:
                $columnName = 'international_diplomas_charge_transaction.createtime';
                break;
            case 7:
                $columnName = 'international_diplomas_charge_transaction.end_date';
                break;
            case 8:
                $columnName = 'international_diplomas_charge_transaction.subscrip_country';
                break;
            case 9:
                $columnName = 'international_diplomas_charge_transaction.subscrip_type';
                break;
            case 10:
                $columnName = 'international_diplomas_charge_transaction.amount';
                break;
            case 11:
                $columnName = 'international_diplomas_charge_transaction.currency';
                break;
            case 12:
                $columnName = 'employees.username';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $transactions = $transactions->where(function ($q) use ($search) {
                $q->where('users.FullName', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
                    ->orWhere('international_diplomas_charge_transaction.period', 'LIKE', "%$search%")
                    ->orWhere('international_diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
                    ->orWhere('international_diplomas_charge_transaction.subscrip_country', 'LIKE', "%$search%")
                    ->orWhere('international_diplomas_charge_transaction.amount', 'LIKE', "%$search%")
                    ->orWhere('international_diplomas_charge_transaction.currency', 'LIKE', "%$search%")
                    ->orWhere('employees.username', 'LIKE', "%$search%")
                    ->orWhere('international_diplomas_charge_transaction.id', '=', $search);
            });
        }
        if($request->routeIs('international_diplomas_report_export')){
            $transactions=$transactions->orderBy($columnName, $data['order'][0]['dir'])->get();
            $output = ['ID', Lang::get('main.user_name'), Lang::get('main.email'),
                Lang::get('main.phone'),
                Lang::get('main.period'),
                Lang::get('main.createdtime'),
                Lang::get('main.expired_time'),
                Lang::get('main.expired_time'),
                Lang::get('main.markets'),
                Lang::get('main.subscibe_type'),
                Lang::get('main.amount'),
                Lang::get('main.currency'),
                Lang::get('main.employee_name'),
            ];

            $filename = 'international_diplomas_report_'.time().'.csv';
            $handle = fopen($filename, 'w+');
            fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            fputcsv($handle, $output);
            foreach ($transactions as $transaction) {
                fputcsv($handle, [
                    $transaction->id,
                    $transaction->username,
                    $transaction->email,
                    $transaction->phone,
                    $transaction->period,
                    $transaction->createtime,
                    $transaction->end_date,
                    $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                    $transaction->subscrip_type,
                    $transaction->amount,
                    $transaction->currency,
                    $transaction->employee_name,
                ]);
            }
            fclose($handle);
            $headers = array(
                'Content-Type' => 'text/csv;',
                'Content-Disposition' => 'attachment; filename="'.$filename.'"'
            );
            return Response::download($filename, $filename, $headers);
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $transaction->id,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                $transaction->subscrip_type,
                $transaction->amount,
                $transaction->currency,
                $transaction->employee_name,
                '',
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }




    public function training_programs_report_search_old(Request $request)
    {
        $data = $request->input();
        $training_program = TrainingProgram::select('training_program.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $training_program = $training_program->where('training_program.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $training_program = $training_program->where('training_program.name', 'LIKE', "%$name%");
        }
        if (isset($data['name_en']) && !empty($data['name_en'])) {
            $name_en = $data['name_en'];
            $training_program = $training_program->where('training_program.en_name', 'LIKE', "%$name_en%");
        }
        if (isset($data['code']) && !empty($data['code'])) {
            $code = $data['code'];
            $training_program = $training_program->where('training_program.code', '=', $code);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $training_program = $training_program->whereBetween('training_program.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating = $data['rating'];
            $training_program = $training_program->where('training_program.rating', '=', $rating);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $training_program = $training_program->where('training_program.url', '=', $url);
        }

        $iTotalRecords = $training_program->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'training_program.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'training_program.id';
                break;
            case 1:
                $columnName = 'training_program.name';
                break;
            case 2:
                $columnName = 'training_program.en_name';
                break;
            case 3:
                $columnName = 'training_program.code';
                break;
            case 4:
                $columnName = 'training_program.createdtime';
                break;
            case 5:
                $columnName = 'training_program.id';
                break;
            case 6:
                $columnName = 'training_program.id';
                break;
            case 7:
                $columnName = 'training_program.id';
                break;
            case 8:
                $columnName = 'training_program.rating';
                break;
            case 9:
                $columnName = 'training_program.url';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $training_program = $training_program->where(function ($q) use ($search) {
                $q->where('training_program.id', '=', $search)
                    ->orWhere('training_program.name', 'LIKE', "%$search%")
                    ->orWhere('training_program.en_name', 'LIKE', "%$search%")
                    ->orWhere('training_program.code', '=', $search)
                    ->orWhere('training_program.rating', '=', $search)
                    ->orWhere('training_program.url', 'LIKE', "%$search%");
            });
        }
        if($request->routeIs('training_programs_report_export')){
            $training_program = $training_program->orderBy($columnName, $data['order'][0]['dir'])->get();
            $output = ['#', Lang::get('main.training_program'), Lang::get('main.name_en'),
                Lang::get('main.code'),
                Lang::get('main.createdtime'),
                Lang::get('main.no_of_courses'),
                Lang::get('main.duration'),
                Lang::get('main.subscribers'),
                Lang::get('main.rating'),
                Lang::get('main.url'),
            ];

            $filename = 'training_programs_report_export_'.time().'.csv';
            $handle = fopen($filename, 'w+');
            fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            fputcsv($handle, $output);
            foreach ($training_program as $diploma) {
                fputcsv($handle, [
                    $diploma->id,
                    $diploma->name,
                    $diploma->en_name,
                    $diploma->code,
                    $diploma->createdtime,
                    $diploma->courses_count,
                    $diploma->duration,
                    $diploma->subscribers,
                    $diploma->rating,
                ]);
            }
            fclose($handle);
            $headers = array(
                'Content-Type' => 'text/csv;',
                'Content-Disposition' => 'attachment; filename="'.$filename.'"'
            );
            return Response::download($filename, $filename, $headers);
        }
        $training_program = $training_program->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($training_program as $diploma) {
            $records["data"][] = [
                $diploma->id,
                $diploma->name,
                $diploma->en_name,
                $diploma->code,
                $diploma->createdtime,
                $diploma->courses_count,
                $diploma->duration,
                $diploma->subscribers,
                $diploma->rating,
                '<a href="' . e3mURL('training_program/' . $diploma->url) . '" target="_blank">' . $diploma->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function mbas_report()
    {
        return view('auth.mbas_report.view');
    }

    public function mbas_report_search(Request $request)
    {
        $data = $request->input();
        $mbas = Mba::select('mba.*', DB::raw("(SELECT COUNT(DISTINCT user_id) FROM `modules_users_summary` WHERE (((" . config('app.MBA_PROGRESS') . "*progress)/100)+((" . config('app.MBA_PROJECT') . "*project)/100)+((" . config('app.MBA_EXAM') . "*exam)/100)) >60 AND module_id=mba.id) AS more_than_60"));
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $mbas = $mbas->where('mba.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $mbas = $mbas->where('mba.name', 'LIKE', "%$name%");
        }
        if (isset($data['name_en']) && !empty($data['name_en'])) {
            $name_en = $data['name_en'];
            $mbas = $mbas->where('mba.en_name', 'LIKE', "%$name_en%");
        }
        if (isset($data['code']) && !empty($data['code'])) {
            $code = $data['code'];
            $mbas = $mbas->where('mba.code', '=', $code);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $mbas = $mbas->whereBetween('mba.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['questions_numbers']) && !empty($data['questions_numbers'])) {
            $questions_numbers = $data['questions_numbers'];
            $mbas = $mbas->where('mba.questions_numbers', '=', $questions_numbers);
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating = $data['rating'];
            $mbas = $mbas->where('mba.rating', '=', $rating);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $mbas = $mbas->where('mba.url', '=', $url);
        }

        $iTotalRecords = $mbas->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'mba.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'mba.id';
                break;
            case 1:
                $columnName = 'mba.name';
                break;
            case 2:
                $columnName = 'mba.en_name';
                break;
            case 3:
                $columnName = 'mba.code';
                break;
            case 4:
                $columnName = 'mba.createdtime';
                break;
            case 5:
                $columnName = 'mba.id';
                break;
            case 6:
                $columnName = 'mba.id';
                break;
            case 7:
                $columnName = 'mba.questions_numbers';
                break;
            case 8:
                $columnName = 'mba.id';
                break;
            case 9:
                $columnName = 'subscribers';
                break;
            case 10:
                $columnName = 'more_than_60';
                break;
            case 11:
                $columnName = 'mba.rating';
                break;
            case 12:
                $columnName = 'mba.url';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $mbas = $mbas->where(function ($q) use ($search) {
                $q->where('mba.id', '=', $search)
                    ->orWhere('mba.name', 'LIKE', "%$search%")
                    ->orWhere('mba.en_name', 'LIKE', "%$search%")
                    ->orWhere('mba.code', '=', $search)
                    ->orWhere('mba.questions_numbers', '=', $search)
                    ->orWhere('mba.rating', '=', $search)
                    ->orWhere('mba.url', 'LIKE', "%$search%");
            });
        }

        $mbas = $mbas->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($mbas as $mba) {
            $records["data"][] = [
                $mba->id,
                $mba->name,
                $mba->en_name,
                $mba->code,
                $mba->createdtime,
                $mba->courses_count,
                $mba->duration,
                $mba->questions_numbers,
                $mba->subscribers,
                $mba->more_than_60,
                $mba->rating,
                '<a href="' . e3mURL('mba/' . $mba->url) . '" target="_blank">' . $mba->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function mba_courses_report()
    {
        $courses = Courses::pluck('name', 'id');
        $modules = Mba::pluck('name', 'id');
        return view('auth.mba_courses_report.view', compact('courses', 'modules'));

    }

    public function courses_report_search(Request $request)
    {
        $data = $request->input();
        $courses = Courses::leftJoin('instractors', 'instractors.id', '=', 'courses.instractor')
            ->select(
                'courses.*',
                'instractors.name AS instructor_name',
                DB::raw("(SELECT GROUP_CONCAT(categories.name) FROM courses_categories INNER JOIN categories ON categories.id=courses_categories.category_id WHERE course_id=courses.id) AS category_name"),
                DB::raw("(
 SELECT 
 COUNT(DISTINCT users_course_view_completed.user_id)
 FROM 
 `users_course_view_completed`
 WHERE 
 ((users_course_view_completed.completed/users_course_view_completed.total)*100)>70
 AND users_course_view_completed.course_id=courses.id
 ) AS watching_more"),
                DB::raw("(
 SELECT 
 COUNT(DISTINCT users_course_view_completed.user_id)
 FROM 
 `users_course_view_completed`
 WHERE 
 users_course_view_completed.completed=users_course_view_completed.total 
 AND course_id=courses.id AND users_course_view_completed.total!=0
 ) AS watching_100")
            );
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $courses = $courses->where('courses.id', '=', "$id");
        }
        if (isset($data['type']) && !empty($data['type'])) {
            $type = $data['type'];
            $courses = $courses->where('courses.show_on', $type);
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $courses = $courses->where('courses.name', 'LIKE', "%$name%");
        }
        if (isset($data['category']) && !empty($data['category'])) {
            $category = $data['category'];
            $courses = $courses->where('category_name', 'LIKE', "%$category%");
        }
        if (isset($data['level']) && !empty($data['level'])) {
            $level = $data['level'];
            $courses = $courses->where('courses.level', 'LIKE', "%$level%");
        }
        if (isset($data['instructor']) && !empty($data['instructor'])) {
            $instructor = $data['instructor'];
            $courses = $courses->where('instractors.id', '=', $instructor);
        }
        if (isset($data['lectures']) && !empty($data['lectures'])) {
            $lectures = $data['lectures'];
            $courses = $courses->where('courses.lectures', '=', $lectures);
        }
//        if (isset($data['duration']) && !empty($data['duration'])) {
//            $duration = $data['duration'];
//            $courses = $courses->where('courses.duration', 'LIKE', "%$duration%");
//        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $courses = $courses->whereBetween('courses.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['views']) && !empty($data['views'])) {
            $views = $data['views'];
            $courses = $courses->where('courses.view', 'LIKE', "%$views%");
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating = $data['rating'];
            $courses = $courses->where('courses.rating', '=', $rating);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $courses = $courses->where('courses.url', '=', $url);
        }

        $iTotalRecords = $courses->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'courses.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'courses.id';
                break;
            case 1:
                $columnName = 'courses.name';
                break;
            case 2:
                $columnName = 'courses.show_on';
                break;
            case 3:
                $columnName = 'category_name';
                break;
            case 4:
                $columnName = 'courses.level';
                break;
            case 5:
                $columnName = 'instractors.name';
                break;
            case 6:
                $columnName = 'courses.lectures';
                break;
            case 7:
                $columnName = 'courses.id';
                break;
            case 8:
                $columnName = 'courses.createdtime';
                break;
            case 9:
                $columnName = 'courses.view';
                break;
            case 10:
                $columnName = 'watching_more';
                break;
            case 11:
                $columnName = 'watching_100';
                break;
            case 12:
                $columnName = 'courses.rating';
                break;
            case 13:
                $columnName = 'courses.url';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $courses = $courses->where(function ($q) use ($search) {
                $q->where('courses.id', '=', $search)
                    ->orWhere('courses.name', 'LIKE', "%$search%")
                    ->orWhere('courses.level', 'LIKE', "%$search%")
                    ->orWhere('instractors.name', 'LIKE', "%$search%")
                    ->orWhere('courses.lectures', '=', $search)
//                    ->orWhere('courses.duration', 'LIKE', "%$search%")
                    ->orWhere('courses.view', '=', $search)
                    ->orWhere('courses.rating', '=', $search)
                    ->orWhere('courses.url', 'LIKE', "%$search%");
            });
        }

        $courses = $courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($courses as $course) {
            $records["data"][] = [
                $course->id,
                $course->name,
                $course->show_on,
                $course->category_name,
                $course->level,
                $course->instructor_name,
                $course->lectures,
                $course->duration,
                $course->createdtime,
                $course->view,
                $course->watching_more,
                $course->watching_100,
                $course->rating,
                '<a href="' . ($course->show_on == 'medical' ? yottaURL('course/' . $course->url . '?preview=1') : e3mURL('courses/' . $course->url . '&preview=1')) . '" target="_blank">' . $course->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function courses_watching_report_search(Request $request)
    {
        $data = $request->input();
        $courses = Courses::
        select(
            'courses.id','courses.name','courses.createdtime',
            DB::raw("(SELECT COUNT(DISTINCT user_id) FROM `users_course_view_completed` WHERE course_id=courses.id AND user_id IN (SELECT user_id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id=courses.id AND ISNULL(courses_curriculum_certificates.deleted_at)) AND ((users_course_view_completed.completed/users_course_view_completed.total)*100)>100) AS watching_less_than_100")
            ,DB::raw("(SELECT 
 COUNT(DISTINCT courses_curriculum_certificates.user_id)
 FROM 
 `courses_curriculum_certificates`
 WHERE 
  courses_curriculum_certificates.course_id=courses.id AND ISNULL(courses_curriculum_certificates.deleted_at)
 ) AS has_certificates")
        );

        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $courses = $courses->where('courses.id', '=', "$id");
        }

        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $courses = $courses->where('courses.name', 'LIKE', "%$name%");
        }

        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $courses = $courses->whereBetween('courses.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }


        $iTotalRecords = $courses->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'courses.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'courses.id';
                break;
            case 1:
                $columnName = 'courses.name';
                break;
            case 2:
                $columnName = 'courses.createdtime';
                break;
            case 3:
                $columnName = 'watching_less_than_100';
                break;
            case 4 :
                $columnName = 'has_certificates';
                break;

        }

        $search = $data['search']['value'];
        if ($search) {
            $courses = $courses->where(function ($q) use ($search) {
                $q->where('courses.id', '=', $search)
                    ->orWhere('courses.name', 'LIKE', "%$search%");
            });
        }
        //echo(getEloquentSqlWithBindings($courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)));die();
        if($request->export){
            $courses=$courses->orderBy($columnName, $data['order'][0]['dir'])->get();
            $output = ['#', Lang::get('main.course'), Lang::get('main.createdtime'), Lang::get('main.watching_less_than_100'), Lang::get('main.certificates')];

            $filename = 'courses_watching_report_'.time().'.csv';
            $handle = fopen($filename, 'w+');
            fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            fputcsv($handle, $output);
            foreach ($courses as $course) {
                fputcsv($handle, [
                    $course->id,
                    $course->name,
                    $course->createdtime,
                    $course->watching_less_than_100,
                    $course->has_certificates,
                ]);
            }
            fclose($handle);
            $headers = array(
                'Content-Type' => 'text/csv;',
                'Content-Disposition' => 'attachment; filename="'.$filename.'"'
            );
            return Response::download($filename, $filename, $headers);
        }
        $courses = $courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($courses as $course) {
            $records["data"][] = [
                $course->id,
                $course->name,
                $course->createdtime,
                $course->watching_less_than_100,
                $course->has_certificates,
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function books_report()
    {
        $authors = Authors::pluck('name', 'id');
        return view('auth.books_report.view', compact('authors'));
    }

    public function books_report_search(Request $request)
    {
        $data = $request->input();
        $books = Books::leftJoin('author', 'books.author_id', '=', 'author.id')
            ->select('books.*', 'author.name AS author_name', 'author.id AS author_id');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $books = $books->where('books.id', '=', "$id");
        }
        if (isset($data['title']) && !empty($data['title'])) {
            $title = $data['title'];
            $books = $books->where('books.title', 'LIKE', "%$title%");
        }
        if (isset($data['title_en']) && !empty($data['title_en'])) {
            $title_en = $data['title_en'];
            $books = $books->where('books.title_en', 'LIKE', "%$title_en%");
        }
        if (isset($data['author']) && !empty($data['author'])) {
            $author = $data['author'];
            $books = $books->where('books.author_id', '=', $author);
        }
        if (isset($data['book']) && !empty($data['book'])) {
            $book = $data['book'];
            $books = $books->where('books.book', 'LIKE', "%$book%");
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating = $data['rating'];
            $books = $books->where('books.rating', '=', $rating);
        }
        if (isset($data['view']) && !empty($data['view'])) {
            $view = $data['view'];
            $books = $books->where('books.view', '=', $view);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $books = $books->whereBetween('books.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $books = $books->where('books.url', 'LIKE', "%$url%");
        }

        $iTotalRecords = $books->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'books.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'books.id';
                break;
            case 1:
                $columnName = 'books.title';
                break;
            case 2:
                $columnName = 'books.title_en';
                break;
            case 3:
                $columnName = 'author.name';
                break;
            case 4:
                $columnName = 'books.book';
                break;
            case 5:
                $columnName = 'books.url';
                break;
            case 6:
                $columnName = 'books.rating';
                break;
            case 7:
                $columnName = 'books.view';
                break;
            case 8:
                $columnName = 'books.createdtime';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $books = $books->where(function ($q) use ($search) {
                $q->where('books.title', 'LIKE', "%$search%")
                    ->orWhere('books.title_en', 'LIKE', "%$search%")
                    ->orWhere('author.name', 'LIKE', "%$search%")
                    ->orWhere('books.book', 'LIKE', "%$search%")
                    ->orWhere('books.url', 'LIKE', "%$search%")
                    ->orWhere('books.description_en', 'LIKE', "%$search%")
                    ->orWhere('books.description', 'LIKE', "%$search%")
                    ->orWhere('books.meta_description', 'LIKE', "%$search%")
                    ->orWhere('books.id', '=', $search)
                    ->orWhere('books.rating', '=', $search)
                    ->orWhere('books.view', '=', $search);
            });
        }

        $books = $books->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($books as $book) {
            $records["data"][] = [
                $book->id,
                $book->title,
                $book->title_en,
                $book->author_name,
                '<a href="' . URL('admin/bookdownload/' . $book->book) . '">' . $book->book . '</a>',
                '<a href="' . e3mURL('books/' . $book->url) . '" target="_blank">' . $book->url . '</a>',
                $book->rating,
                $book->view,
                $book->createdtime,
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    public function articles_report()
    {
        $authors = Authors::pluck('name', 'id');
        $categories = ArticlesCategories::where('id', '<>', 1)->pluck('name', 'id');
        return view('auth.articles_report.view', compact('authors', 'categories'));
    }

    public function workshops_report()
    {
        $instructors = Instructors::pluck('name', 'id');
        return view('auth.workshops_report.view', compact('instructors'));
    }

    public function webinars_report()
    {
        $instructors = Instructors::pluck('name', 'id');
        $webinars = Webinars::pluck('name', 'id');
        return view('auth.webinars_report.view', compact('instructors', 'webinars'));
    }

    function webinars_report_search(Request $request)
    {

        $data = $request->input();
        $webinars = Webinars::select('webinar.*', 'parent.name AS parent_name', 'instractors.name AS instructor_name', 'instractors.url AS instructor_url')
            ->leftJoin('webinar AS parent', 'parent.id', '=', 'webinar.parent_id')
            ->leftJoin('instractors', 'webinar.instractor', '=', 'instractors.id')
            ->where('webinar.type', 'online');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $webinars = $webinars->where('webinar.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $webinars = $webinars->where('webinar.name', 'LIKE', "%$name%");
        }
        if (isset($data['parent']) && !empty($data['parent'])) {
            $parent = $data['parent'];
            $webinars = $webinars->where('parent.id', 'LIKE', "%$parent%");
        }
        if (isset($data['instructor']) && !empty($data['instructor'])) {
            $instructor = $data['instructor'];
            $webinars = $webinars->where('webinar.instractor', '=', $instructor);
        }
        if (isset($data['location']) && !empty($data['location'])) {
            $location = $data['location'];
            $webinars = $webinars->where('webinar.location', '=', $location);
        }
        if (isset($data['type']) && !empty($data['type'])) {
            $type = $data['type'];
            $webinars = $webinars->where('webinar.type', 'LIKE', "%$type%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $webinars = $webinars->whereBetween('webinar.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $webinars = $webinars->where('webinar.url', 'LIKE', "%$url%");
        }


        $iTotalRecords = $webinars->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'webinar.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'webinar.id';
                break;
            case 1:
                $columnName = 'webinar.name';
                break;
            case 2:
                $columnName = 'parent.name';
                break;
            case 3:
                $columnName = 'instractors.name';
                break;
            case 4:
                $columnName = 'webinar.location';
                break;
            case 5:
                $columnName = 'webinar.type';
                break;
            case 6:
                $columnName = 'webinar.createdtime';
                break;
            case 7:
                $columnName = 'webinar.url';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $webinars = $webinars->where(function ($q) use ($search) {
                $q->where('webinar.name', 'LIKE', "%$search%")
                    ->orWhere('webinar.instractor', 'LIKE', "%$search%")
                    ->orWhere('parent.name', 'LIKE', "%$search%")
                    ->orWhere('instractors.name', 'LIKE', "%$search%")
                    ->orWhere('webinar.location', 'LIKE', "%$search%")
                    ->orWhere('webinar.type', 'LIKE', "%$search%")
                    ->orWhere('webinar.url', 'LIKE', "%$search%")
                    ->orWhere('webinar.description', 'LIKE', "%$search%")
                    ->orWhere('webinar.id', '=', $search);
            });
        }

        $webinars = $webinars->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($webinars as $webinar) {
            $records["data"][] = [
                $webinar->id,
                $webinar->name,
                $webinar->parent_name,
                $webinar->instructor_name,
                $webinar->location,
                $webinar->type,
                $webinar->createdtime,
                '<a href="' . e3mURL('webinar/' . $webinar->url) . '" target="_blank">' . $webinar->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    function workshops_report_search(Request $request)
    {
        $data = $request->input();
        $webinars = Webinars::select('webinar.*', 'instractors.name AS instructor_name')
            ->leftJoin('instractors', 'webinar.instractor', '=', 'instractors.id')
            ->where('webinar.type', 'offline');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $webinars = $webinars->where('webinar.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $webinars = $webinars->where('webinar.name', 'LIKE', "%$name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $webinars = $webinars->whereBetween('webinar.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['instructor']) && !empty($data['instructor'])) {
            $instructor = $data['instructor'];
            $webinars = $webinars->where('webinar.instractor', '=', $instructor);
        }
        if (isset($data['views']) && !empty($data['views'])) {
            $views = $data['views'];
            $webinars = $webinars->where('webinar.view', 'LIKE', "%$views%");
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $webinars = $webinars->where('webinar.url', 'LIKE', "%$url%");
        }


        $iTotalRecords = $webinars->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'webinar.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'webinar.id';
                break;
            case 1:
                $columnName = 'webinar.name';
                break;
            case 2:
                $columnName = 'instractors.name';
                break;
            case 3:
                $columnName = 'webinar.createdtime';
                break;
            case 4:
                $columnName = 'webinar.view';
                break;
            case 5:
                $columnName = 'webinar.url';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $webinars = $webinars->where(function ($q) use ($search) {
                $q->where('webinar.name', 'LIKE', "%$search%")
                    ->orWhere('instractors.name', 'LIKE', "%$search%")
                    ->orWhere('webinar.location', 'LIKE', "%$search%")
                    ->orWhere('webinar.view', '=', $search)
                    ->orWhere('webinar.url', 'LIKE', "%$search%")
                    ->orWhere('webinar.id', '=', $search);
            });
        }

        $webinars = $webinars->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($webinars as $webinar) {
            $records["data"][] = [
                $webinar->id,
                $webinar->name,
                $webinar->instructor_name,
                $webinar->createdtime,
                $webinar->view,
                '<a href="' . e3mURL('webinar/' . $webinar->url) . '" target="_blank">' . $webinar->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    function articles_report_search(Request $request)
    {
        $data = $request->input();
        $articles = Articles::select('articles.*', 'author.name AS author_name', 'author.id AS author_id', 'articles_category.id AS category_id', 'articles_category.name AS category_name')
            ->leftJoin('author', 'articles.author_id', '=', 'author.id')
            ->leftJoin('articles_category', 'articles.category_id', '=', 'articles_category.id')
            ->leftJoin('tags_related', function ($join) {
                $join->on('tags_related.src_id', '=', 'articles.id')->where('type', '=', 'articles');
            })
            ->leftJoin('tags', 'tags.id', '=', 'tags_related.tag_id')->distinct()
            ->where('category_id', '<>', 1);
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $articles = $articles->where('articles.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $articles = $articles->where('articles.name', 'LIKE', "%$name%");
        }
        if (isset($data['category']) && !empty($data['category'])) {
            $category = $data['category'];
            $articles = $articles->where('articles.category_id', '=', $category);
        }
        if (isset($data['author']) && !empty($data['author'])) {
            $author = $data['author'];
            $articles = $articles->where('articles.author_id', '=', $author);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $articles = $articles->where('articles.url', 'LIKE', "%$url%");
        }
        if (isset($data['tag']) && !empty($data['tag'])) {
            $tag = $data['tag'];
            $articles = $articles->where('tags.name', 'LIKE', "%$tag%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $articles = $articles->whereBetween('articles.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        $iTotalRecords = $articles->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'articles.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'articles.id';
                break;
            case 1:
                $columnName = 'articles.name';
                break;
            case 2:
                $columnName = 'articles_category.name';
                break;
            case 3:
                $columnName = 'author.name';
                break;
            case 4:
                $columnName = 'articles.id';
                break;
            case 5:
                $columnName = 'articles.createdtime';
                break;
            case 6:
                $columnName = 'articles.url';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $articles = $articles->where(function ($q) use ($search) {
                $q->where('articles.name', 'LIKE', "%$search%")
                    ->orWhere('articles_category.name', 'LIKE', "%$search%")
                    ->orWhere('author.name', 'LIKE', "%$search%")
                    ->orWhere('articles.url', 'LIKE', "%$search%")
                    ->orWhere('articles.description', 'LIKE', "%$search%")
                    ->orWhere('tags.name', 'LIKE', "%$search%")
                    ->orWhere('articles.id', '=', $search);
            });
        }

        $articles = $articles->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($articles as $article) {
            $tags = $article->tag()->get();
            $tags_string = '';
            if (count($tags)) {
                foreach ($tags as $tag) {
                    $tags_string .= '<span class="badge badge-success">' . $tag->name . '</span>';
                }
            }
            $records["data"][] = [
                $article->id,
                $article->name,
                '<a href="' . e3mURL('blog/category/' . $article->category_name) . '" target="_blank">' . $article->category_name . '</a>',
                $article->author_name,
                $tags_string,
                $article->createdtime,
                '<a href="' . e3mURL('blog/' . $article->url) . '" target="_blank">' . $article->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }


    public function successstories_report()
    {
        $instructors = Instructors::pluck('name', 'id');
        return view('auth.successstories_report.view', compact('instructors'));
    }

    function successstories_report_search(Request $request)
    {

        $data = $request->input();
        $successstories = Successstories::select('successtories.*', 'instractors.name AS instructor_name')->leftJoin('instractors', 'successtories.instractor', '=', 'instractors.id');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $successstories = $successstories->where('successtories.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $successstories = $successstories->where('successtories.name', 'LIKE', "%$name%");
        }
        if (isset($data['instructor']) && !empty($data['instructor'])) {
            $instructor = $data['instructor'];
            $successstories = $successstories->where('instractors.id', '=', $instructor);
        }
        if (isset($data['location']) && !empty($data['location'])) {
            $location = $data['location'];
            $successstories = $successstories->where('successtories.location', 'LIKE', "%$location%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $successstories = $successstories->whereBetween('successtories.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['view']) && !empty($data['view'])) {
            $view = $data['view'];
            $successstories = $successstories->where('successtories.view', '=', $view);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $successstories = $successstories->where('successtories.url', 'LIKE', "%$url%");
        }

        $iTotalRecords = $successstories->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'successtories.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'successtories.id';
                break;
            case 1:
                $columnName = 'successtories.name';
                break;
            case 2:
                $columnName = 'instractors.name';
                break;
            case 3:
                $columnName = 'successtories.location';
                break;
            case 4:
                $columnName = 'successtories.createdtime';
                break;
            case 5:
                $columnName = 'successtories.view';
                break;
            case 6:
                $columnName = 'successtories.url';
                break;
        }
        $search = $data['search']['value'];
        if ($search) {
            $successstories = $successstories->where(function ($q) use ($search) {
                $q->where('successtories.name', 'LIKE', "%$search%")
                    ->orWhere('instractors.name', 'LIKE', "%$search%")
                    ->orWhere('successtories.location', 'LIKE', "%$search%")
                    ->orWhere('successtories.meta_description', 'LIKE', "%$search%")
                    ->orWhere('successtories.description', 'LIKE', "%$search%")
                    ->orWhere('successtories.url', 'LIKE', "%$search%")
                    ->orWhere('successtories.view', '=', $search)
                    ->orWhere('successtories.id', '=', $search);
            });
        }

        $successstories = $successstories->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($successstories as $successstory) {
            $records["data"][] = [
                $successstory->id,
                $successstory->name,
                $successstory->instructor_name,
                $successstory->location,
                $successstory->createdtime,
                $successstory->view,
                '<a target="_blank" href="' . e3mURL('successtories/' . $successstory->url) . '">' . $successstory->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    public function mba_courses_report_search(Request $request)
    {
        $data = $request->input();
        $courses = MbaCourses::join('courses', 'courses.id', '=', 'mba_module_courses.related_course')
            ->join('mba', 'mba.id', '=', 'mba_module_courses.module_id')
            ->select('mba_module_courses.*', 'mba.name AS mba_name', 'courses.name AS course_name', 'courses.url AS course_url', 'courses.show_on');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $courses = $courses->where('mba_module_courses.id', '=', "$id");
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $courses = $courses->where('courses.id', '=', $course);
        }
        if (isset($data['mba']) && !empty($data['mba'])) {
            $mba = $data['mba'];
            $courses = $courses->where('mba.id', '=', $mba);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $courses = $courses->whereBetween('mba_module_courses.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $courses = $courses->where('courses.url', '=', $url);
        }

        $iTotalRecords = $courses->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'mba_module_courses.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'mba_module_courses.id';
                break;
            case 1:
                $columnName = 'courses.name';
                break;
            case 2:
                $columnName = 'mba.name';
                break;
            case 3:
                $columnName = 'mba_module_courses.createdtime';
                break;
            case 4:
                $columnName = 'courses.url';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $courses = $courses->where(function ($q) use ($search) {
                $q->where('mba_module_courses.id', '=', $search)
                    ->orWhere('courses.name', 'LIKE', "%$search%")
                    ->orWhere('mba.name', 'LIKE', "%$search%")
                    ->orWhere('courses.url', 'LIKE', "%$search%");
            });
        }

        $courses = $courses->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($courses as $course) {
            $records["data"][] = [
                $course->id,
                $course->course_name,
                $course->mba_name,
                $course->createdtime,
                '<a href="' . ($course->show_on == 'medical' ? yottaURL('course/' . $course->course_url . '?preview=1') : e3mURL('courses/' . $course->course_url . '&preview=1')) . '" target="_blank">' . $course->course_url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }


    public function diplomas_report_search(Request $request)
    {
        $data = $request->input();
        $diplomas = Diplomas::where('published', 'yes')->select('diplomas.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $diplomas = $diplomas->where('diplomas.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $diplomas = $diplomas->where('diplomas.name', 'LIKE', "%$name%");
        }
        if (isset($data['name_en']) && !empty($data['name_en'])) {
            $name_en = $data['name_en'];
            $diplomas = $diplomas->where('diplomas.en_name', 'LIKE', "%$name_en%");
        }
        if (isset($data['code']) && !empty($data['code'])) {
            $code = $data['code'];
            $diplomas = $diplomas->where('diplomas.code', '=', $code);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $diplomas = $diplomas->whereBetween('diplomas.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating = $data['rating'];
            $diplomas = $diplomas->where('diplomas.rating', '=', $rating);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $diplomas = $diplomas->where('diplomas.url', '=', $url);
        }

        $iTotalRecords = $diplomas->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'diplomas.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'diplomas.id';
                break;
            case 1:
                $columnName = 'diplomas.name';
                break;
            case 2:
                $columnName = 'diplomas.en_name';
                break;
            case 3:
                $columnName = 'diplomas.code';
                break;
            case 4:
                $columnName = 'diplomas.createdtime';
                break;
            case 5:
                $columnName = 'diplomas.id';
                break;
            case 6:
                $columnName = 'diplomas.id';
                break;
            case 7:
                $columnName = 'diplomas.id';
                break;
            case 8:
                $columnName = 'diplomas.rating';
                break;
            case 9:
                $columnName = 'diplomas.url';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $diplomas = $diplomas->where(function ($q) use ($search) {
                $q->where('diplomas.id', '=', $search)
                    ->orWhere('diplomas.name', 'LIKE', "%$search%")
                    ->orWhere('diplomas.en_name', 'LIKE', "%$search%")
                    ->orWhere('diplomas.code', '=', $search)
                    ->orWhere('diplomas.rating', '=', $search)
                    ->orWhere('diplomas.url', 'LIKE', "%$search%");
            });
        }

        $diplomas = $diplomas->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($diplomas as $diploma) {
            $records["data"][] = [
                $diploma->id,
                $diploma->name,
                $diploma->en_name,
                $diploma->code,
                $diploma->createdtime,
                $diploma->courses_count,
                $diploma->duration,
                $diploma->subscribers,
                $diploma->rating,
                '<a href="' . e3mURL('diplomas/' . $diploma->url) . '" target="_blank">' . $diploma->url . '</a>',
                '',
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }


    public function training_programs_report_export(Request $request)
    {
        $data = $request->input();
        $training_program = TrainingProgram::select('training_program.*');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $training_program = $training_program->where('training_program.id', '=', "$id");
        }
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $training_program = $training_program->where('training_program.name', 'LIKE', "%$name%");
        }
        if (isset($data['name_en']) && !empty($data['name_en'])) {
            $name_en = $data['name_en'];
            $training_program = $training_program->where('training_program.en_name', 'LIKE', "%$name_en%");
        }
        if (isset($data['code']) && !empty($data['code'])) {
            $code = $data['code'];
            $training_program = $training_program->where('training_program.code', '=', $code);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $training_program = $training_program->whereBetween('training_program.createdtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['rating']) && !empty($data['rating'])) {
            $rating = $data['rating'];
            $training_program = $training_program->where('training_program.rating', '=', $rating);
        }
        if (isset($data['url']) && !empty($data['url'])) {
            $url = $data['url'];
            $training_program = $training_program->where('training_program.url', '=', $url);
        }


        $training_program = $training_program->get();
        $output = ['#', Lang::get('main.training_program'), Lang::get('main.name_en'), Lang::get('main.code'), Lang::get('main.createdtime'), Lang::get('main.no_of_courses')
            , Lang::get('main.duration'), Lang::get('main.subscribers'), Lang::get('main.rating%'), Lang::get('main.url')
        ];

        $filename = "report.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);

        foreach ($training_program as $diploma) {
            fputcsv($handle, [
                $diploma->id,
                $diploma->name,
                $diploma->en_name,
                $diploma->code,
                $diploma->createdtime,
                $diploma->courses_count,
                $diploma->duration,
                $diploma->subscribers,
                $diploma->rating,
                $diploma->url,

            ]);
        }

    }


    public function diploma_exam_report()
    {
        return view('auth.diploma_exam_report.view');
    }

    public function diploma_not_exam_report()
    {
        return view('auth.diploma_not_exam_report.view');
    }

    public function training_program_exam_report()
    {
        return view('auth.training_program_exam_report.view');
    }

    public function training_program_not_exam_report()
    {
        return view('auth.training_program_not_exam_report.view');
    }

    public function alex_event_payment()
    {
        return view('auth.alex_event_payment.view');
    }

    public function mba_users_summary()
    {
        return view('auth.mba_users_summary.view');
    }

    public function new_mba_users_summary()
    {
        return view('auth.new_mba_users_summary.view');
    }

    public function alex_event_payment_search(Request $request)
    {
        $data = $request->input();
        $payments = AlexEventPayment::select('*');
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $payments = $payments->where('alexevent_payment.name', 'LIKE', "%$name%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $payments = $payments->where('alexevent_payment.email', 'LIKE', "%$email%");
        }
        if (isset($data['mobile']) && !empty($data['mobile'])) {
            $mobile = $data['mobile'];
            $payments = $payments->where('alexevent_payment.mobile', 'LIKE', "%$mobile%");
        }
        if (isset($data['statues']) && !empty($data['statues'])) {
            $statues = $data['statues'];
            $payments = $payments->where('alexevent_payment.statues', '=', "$statues");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $payments = $payments->whereBetween('alexevent_payment.create_time', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }

        $iTotalRecords = $payments->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'alexevent_payment.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'alexevent_payment.name';
                break;
            case 2:
                $columnName = 'alexevent_payment.email';
                break;
            case 3:
                $columnName = 'alexevent_payment.mobile';
                break;
            case 4:
                $columnName = 'alexevent_payment.statues';
                break;
            case 5:
                $columnName = 'alexevent_payment.create_time';
                break;
        }

        $payments = $payments->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($payments as $payment) {
            $records["data"][] = [
                $x,
                $payment->name,
                $payment->email,
                $payment->mobile,
                $payment->statues,
                $payment->create_time,
                '',
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function mba_users_summary_search(Request $request)
    {

        $data = $request->input();
        $summaries = ModulesUsersSummary::leftJoin('users', 'users.id', '=', 'modules_users_summary.user_id')
            ->join('mba', 'mba.id', '=', 'modules_users_summary.module_id')
            ->leftjoin("modules_users_projects", function ($join) {
                $join->on("modules_users_projects.user_id", "=", "users.id")
                    ->on('modules_users_projects.id', '=', DB::raw("(SELECT max(id) from modules_users_projects WHERE modules_users_projects.module_id = mba.id AND modules_users_projects.user_id = users.id AND modules_users_projects.project_id = modules_users_summary.project_id)"))
                    ->where('modules_users_projects.has_another', '=', 0)->whereNotNull('modules_users_projects.correction_date');
            })
            ->select(DB::raw("modules_users_summary.*,mba.name AS module_name,users.Email AS user_email,users.FullName AS user_name,users.Mobile AS user_phone, modules_users_projects.correction_date"));
        //$summaries = ModulesUsersSummary::select(DB::raw("SELECT modules_users_summary.*,(((modules_users_summary.progress*15)/100)+((modules_users_summary.project*35)/100)+((modules_users_summary.exam*50)/100)) AS totalProgress,mba.name AS module_name,users.Email AS user_email,users.FullName AS user_name,users.Mobile AS user_phone FROM modules_users_summary INNER JOIN mba ON mba.id=modules_users_summary.module_id INNER JOIN users ON users.id=modules_users_summary.user_id WHERE 1"));
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $summaries = $summaries->where('users.FullName', 'LIKE', "%$name%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $summaries = $summaries->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['mba']) && !empty($data['mba'])) {
            $mba = $data['mba'];
            $summaries = $summaries->where('mba.name', 'LIKE', "%$mba%");
        }
        if (isset($data['project_from'], $data['project_to']) && (!empty($data['project_from']) || !empty($data['project_to']))) {
            $from = (!empty($data['project_from'])) ? $data['project_from'] : 0;
            $to = (!empty($data['project_to'])) ? $data['project_to'] : 0;
            $summaries = $summaries->whereBetween('modules_users_summary.project', [$from, $to]);
        }
        if (isset($data['progress_from'], $data['progress_to']) && (!empty($data['progress_from']) || !empty($data['progress_to']))) {
            $from = (!empty($data['progress_from'])) ? $data['progress_from'] : 0;
            $to = (!empty($data['progress_to'])) ? $data['progress_to'] : 0;
            $summaries = $summaries->whereBetween('modules_users_summary.progress', [$from, $to]);
        }
        if (isset($data['exam_from'], $data['exam_to']) && (!empty($data['exam_from']) || !empty($data['exam_to']))) {
            $from = (!empty($data['exam_from'])) ? $data['exam_from'] : 0;
            $to = (!empty($data['exam_to'])) ? $data['exam_to'] : 0;
            $summaries = $summaries->whereBetween('modules_users_summary.exam', [$from, $to]);
        }
        if (isset($data['correction_date_from'], $data['correction_date_to']) && (!empty($data['correction_date_from']) || !empty($data['correction_date_to']))) {
            $from = $data['correction_date_from'];
            $to = $data['correction_date_to'];
            $summaries = $summaries->whereBetween('modules_users_projects.correction_date', [$from . ' 00:00:00', $to . ' 23:59:59']);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $summaries = $summaries->whereBetween('modules_users_summary.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        $iTotalRecords = $summaries->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'modules_users_summary.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'modules_users_summary.createtime';
                break;
            case 4:
                $columnName = 'modules_users_summary.id';
                break;
            case 5:
                $columnName = 'mba.name';
                break;
            case 6:
                $columnName = 'modules_users_summary.project';
                break;
            case 7:
                $columnName = 'modules_users_summary.progress';
                break;
            case 8:
                $columnName = 'modules_users_summary.exam';
                break;
            case 9:
                $columnName = 'totalProgress';
                break;
            case 10:
                $columnName = 'modules_users_projects.correction_date';
                break;
        }

        $summaries = $summaries->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($summaries as $summary) {
            $statistics = modules_statistics('mba', $summary->user_email);
            $totalProgress = ((($summary->progress * $statistics->max_progress) + ($summary->project * $statistics->max_project) + ($summary->exam * $statistics->max_exam)) / 100);
            $records["data"][] = [
                $x,
                $summary->user_name,
                $summary->user_email,
                $summary->createtime,
                $summary->progress == 100 ? 'Yes' : 'No',
                $summary->module_name,
                $summary->project,
                $summary->progress . '%',
                $summary->exam,
                round($totalProgress, 2) . '%',
                $summary->correction_date,
                '',
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    /* Start New Mba Users Summary Search Function */

    public function new_mba_users_summary_search(Request $request)
    {
        $data = $request->input();
        $summaries = NewModulesUsersSummary::leftJoin('users', 'users.id', '=', 'new_mba_modules_users_summary.user_id')
            ->join('new_mba', 'new_mba.id', '=', 'new_mba_modules_users_summary.module_id')
            ->leftjoin("new_mba_modules_users_projects", function ($join) {
                $join->on("new_mba_modules_users_projects.user_id", "=", "users.id")
                    ->on('new_mba_modules_users_projects.id', '=', DB::raw("(SELECT max(id) from new_mba_modules_users_projects WHERE new_mba_modules_users_projects.module_id = new_mba.id AND new_mba_modules_users_projects.user_id = users.id AND new_mba_modules_users_projects.project_id = new_mba_modules_users_summary.project_id)"))
                    ->where('new_mba_modules_users_projects.has_another', '=', 0)->whereNotNull('new_mba_modules_users_projects.correction_date');
            })
            ->select(DB::raw("new_mba_modules_users_summary.id,users.FullName AS user_name,users.Email AS user_email,createtime,new_mba_modules_users_summary.progress,new_mba.name AS module_name,new_mba_modules_users_summary.project,exam_part_1,exam_part_2,(((new_mba_modules_users_summary.progress*" . config('app.NEW_MBA_PROGRESS') . ")/100)+((new_mba_modules_users_summary.project*" . config('app.NEW_MBA_PROJECT') . ")/100)+((new_mba_modules_users_summary.exam_part_1*" . config('app.NEW_MBA_EXAM_PART_1') . ")/100)+((new_mba_modules_users_summary.exam_part_2*" . config('app.NEW_MBA_EXAM_PART_2') . ")/100)) AS totalProgress,new_mba_modules_users_projects.correction_date"));

        //$summaries = ModulesUsersSummary::select(DB::raw("SELECT modules_users_summary.*,(((modules_users_summary.progress*15)/100)+((modules_users_summary.project*35)/100)+((modules_users_summary.exam*50)/100)) AS totalProgress,mba.name AS module_name,users.Email AS user_email,users.FullName AS user_name,users.Mobile AS user_phone FROM modules_users_summary INNER JOIN mba ON mba.id=modules_users_summary.module_id INNER JOIN users ON users.id=modules_users_summary.user_id WHERE 1"));
        if (isset($data['name']) && !empty($data['name'])) {
            $name = $data['name'];
            $summaries = $summaries->where('users.FullName', 'LIKE', "%$name%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $summaries = $summaries->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['mba']) && !empty($data['mba'])) {
            $mba = $data['mba'];
            $summaries = $summaries->where('new_mba.name', 'LIKE', "%$mba%");
        }
        if (isset($data['project_from'], $data['project_to']) && (!empty($data['project_from']) || !empty($data['project_to']))) {
            $from = (!empty($data['project_from'])) ? $data['project_from'] : 0;
            $to = (!empty($data['project_to'])) ? $data['project_to'] : 0;
            $summaries = $summaries->whereBetween('new_mba_modules_users_summary.project', [$from, $to]);
        }
        if (isset($data['progress_from'], $data['progress_to']) && (!empty($data['progress_from']) || !empty($data['progress_to']))) {
            $from = (!empty($data['progress_from'])) ? $data['progress_from'] : 0;
            $to = (!empty($data['progress_to'])) ? $data['progress_to'] : 0;
            $summaries = $summaries->whereBetween('new_mba_modules_users_summary.progress', [$from, $to]);
        }
        if (isset($data['exam_from'], $data['exam_to']) && (!empty($data['exam_from']) || !empty($data['exam_to']))) {
            $from = (!empty($data['exam_from'])) ? $data['exam_from'] : 0;
            $to = (!empty($data['exam_to'])) ? $data['exam_to'] : 0;
            $summaries = $summaries->whereBetween('new_mba_modules_users_summary.exam', [$from, $to]);
        }
        if (isset($data['correction_date_from'], $data['correction_date_to']) && (!empty($data['correction_date_from']) || !empty($data['correction_date_to']))) {
            $from = $data['correction_date_from'];
            $to = $data['correction_date_to'];
            $summaries = $summaries->whereBetween('modules_users_projects.correction_date', [$from . ' 00:00:00', $to . ' 23:59:59']);
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $summaries = $summaries->whereBetween('new_mba_modules_users_summary.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        $iTotalRecords = $summaries->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'new_mba_modules_users_summary.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'new_mba_modules_users_summary.createtime';
                break;
            case 4:
                $columnName = 'new_mba_modules_users_summary.id';
                break;
            case 5:
                $columnName = 'new_mba.name';
                break;
            case 6:
                $columnName = 'new_mba_modules_users_summary.project';
                break;
            case 7:
                $columnName = 'new_mba_modules_users_summary.progress';
                break;
            case 8:
                $columnName = 'new_mba_modules_users_summary.exam';
                break;
            case 9:
                $columnName = 'totalProgress';
                break;
            case 10:
                $columnName = 'new_mba_modules_users_projects.correction_date';
                break;
        }
        if ($request->export) {
            //dd(getEloquentSqlWithBindings($transactions));
            $titles = ['#', 'Username', 'Email', 'Created Time', 'Progress', 'Module Name', 'Project', 'Progress', 'Exam Part1', 'Exam Part2', 'Progress', 'Correction Date'];
            $name = 'new_mba_modules_users_summary.csv';
            //dd($transactions->get()->toArray());
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $name);
            $output = fopen("php://output", "w");
            fputcsv($output, $titles);
            foreach ($summaries->get()->toArray() as $res) {
                unset($res[count($res) - 1]);
                fputcsv($output, $res);
            }
            fclose($output);
            return '';
        }
        $summaries = $summaries->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($summaries as $summary) {
            $statistics = modules_statistics('new_mba', $summary->user_email);
            $totalProgress = ((($summary->progress * $statistics->max_progress) + ($summary->project * $statistics->max_project) + ($summary->exam_part_1 * $statistics->max_exam_part1) + ($summary->exam_part_2 * $statistics->max_exam_part2)) / 100);

            $records["data"][] = [
                $x,
                $summary->user_name,
                $summary->user_email,
                $summary->createtime,
                $summary->progress == 100 ? 'Yes' : 'No',
                $summary->module_name,
                $summary->project,
                $summary->progress . '%',
                $summary->exam_part_1,
                $summary->exam_part_2,
                round($totalProgress, 2) . '%',
                $summary->correction_date,
                '',
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    /* End New MBA Users Summary Search Function */

    public function feedback_report_search(Request $request)
    {
        $data = $request->input();
        $feedbacks = Feedback::join('system_users', 'system_users.id', '=', 'feedback.user_id')
            ->select('feedback.*', 'system_users.username as username');

        //$summaries = ModulesUsersSummary::select(DB::raw("SELECT modules_users_summary.*,(((modules_users_summary.progress*15)/100)+((modules_users_summary.project*35)/100)+((modules_users_summary.exam*50)/100)) AS totalProgress,mba.name AS module_name,users.Email AS user_email,users.FullName AS user_name,users.Mobile AS user_phone FROM modules_users_summary INNER JOIN mba ON mba.id=modules_users_summary.module_id INNER JOIN users ON users.id=modules_users_summary.user_id WHERE 1"));
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $feedbacks = $feedbacks->where('system_users.username', 'LIKE', "%$username%");
        }
        if (isset($data['message']) && !empty($data['message'])) {
            $message = $data['message'];
            $feedbacks = $feedbacks->where('feedback.message', 'LIKE', "%$message%");
        }
        if (isset($data['date_from'], $data['date_to']) && (!empty($data['date_from']) || !empty($data['date_to']))) {
            $from = (!empty($data['date_from'])) ? $data['date_from'] : 0;
            $to = (!empty($data['date_to'])) ? $data['date_to'] : 0;
            $feedbacks = $feedbacks->whereBetween('feedback.createdtime', [$from, $to]);
        }
        $iTotalRecords = $feedbacks->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'feedback.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'system_users.username';
                break;
            case 2:
                $columnName = 'feedback.message';
                break;
            case 3:
                $columnName = 'feedback.createdtime';
                break;
        }

        $feedbacks = $feedbacks->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($feedbacks as $feedback) {
            $username = $feedback->username;
            if (PerUser('users_edit') && $username != '') {
                $username = '<a target="_blank" href="' . URL('admin/users/' . $feedback->user_id . '/edit') . '">' . $username . '</a>';
            }
            $records["data"][] = [
                $x,
                $username,
                $feedback->message,
                $feedback->createdtime,
                '',
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function life_time_report()
    {
        return view('auth.life_time_report.view');
    }

    public function life_time_report_search(Request $request)
    {
        $data = $request->input();

        $times = ChargeTransaction::join('employees', 'employees.id', '=', 'charge_transaction.employee_id')
            ->join('users', 'users.id', '=', 'charge_transaction.user_id')
            ->select(
                'charge_transaction.id',
                'users.FullName',
                'users.Email', 'users.Mobile',
                'charge_transaction.end_date', 'users.Mobile',
                'charge_transaction.subscrip_type', 'charge_transaction.amount', 'charge_transaction.currency',
                'employees.username'
            );
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $times = $times->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $times = $times->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['mobile']) && !empty($data['mobile'])) {
            $mobile = $data['mobile'];
            $times = $times->where('users.Mobile', 'LIKE', "%$mobile%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $times = $times->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from'], $data['created_time_to'])) {
            $from = $data['created_time_from'];
            $to = $data['created_time_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $times = $times->whereBetween('charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }

        $iTotalRecords = $times->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'charge_transaction.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'charge_transaction.period';
                break;
            case 5:
                $columnName = 'charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'charge_transaction.end_date';
                break;
            case 7:
                $columnName = 'charge_transaction.subscrip_type';
                break;
            case 8:
                $columnName = 'charge_transaction.amount';
                break;
            case 9:
                $columnName = 'charge_transaction.currency';
                break;
            case 10:
                $columnName = 'employees.username';
                break;

        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        if ($request->export) {
            //dd(getEloquentSqlWithBindings($transactions));
            $titles = ['#', 'Username', 'Email', 'Phone', 'Period', 'Created Time', 'Expired Date', 'Subscribe Type', 'Amount', 'Currency', 'Employee Name'];
            $name = 'life_time_report_search.csv';
            //dd($transactions->get()->toArray());
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $name);
            $output = fopen("php://output", "w");
            fputcsv($output, $titles);
            foreach ($times->get()->toArray() as $res) {
                unset($res[count($res) - 1]);
                fputcsv($output, $res);
            }
            fclose($output);
            return '';
        }
        $times = $times->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($times as $time) {
            $records["data"][] = [
                $time->id,
                $time->FullName,
                $time->Email,
                $time->Mobile,
                $time->period,
                $time->createtime,
                $time->end_date,
                $time->subscrip_type,
                $time->amount,
                $time->currency,
                $time->username,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }


    public function life_time_customer_report_per_course()
    {
        $courses = Courses::pluck('name', 'id');
        return view('auth.life_time_customer_report_per_course.view', compact('courses'));
    }

    public function life_time_customer_report_per_course_export()
    {
        ini_set('max_execution_time', '300');
        set_time_limit(300);
        ini_set('memory_limit', '512MB');
        $data = ChargeTransaction::join('employees', 'employees.id', '=', 'charge_transaction.employee_id')
            ->join('users', 'users.id', '=', 'charge_transaction.user_id')
            ->join('users_course_view_completed', 'users_course_view_completed.user_id', '=', 'charge_transaction.user_id')
            ->join('courses', 'courses.id', '=', 'users_course_view_completed.course_id')
            ->select('charge_transaction.*', 'courses.name AS course_name', DB::raw("((users_course_view_completed.completed/users_course_view_completed.total)*100) AS completed"), 'users.FullName', 'users.Email', 'users.Mobile', 'employees.username')->get();
        $output = [Lang::get('main.user_name'), Lang::get('main.email'), Lang::get('main.mobile'), Lang::get('main.period'), Lang::get('main.createdtime')
            , Lang::get('main.expired_date'), Lang::get('main.course'), Lang::get('main.complete%'), Lang::get('main.subscribed_type')
            , Lang::get('main.amount'), Lang::get('main.currency'), Lang::get('main.employee_name')];

        $filename = "report.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);


        foreach ($data as $time) {
            fputcsv($handle, [
                $time->FullName,
                $time->Email,
                $time->Mobile,
                $time->period,
                $time->createtime,
                $time->end_date,
                $time->course_name,
                round($time->completed, 2) . '%',
                $time->subscrip_type,
                $time->amount,
                $time->currency,
                $time->username
            ]);
        }
        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="report.csv"'
        );
        return Response::download($filename, 'report.csv', $headers);
    }

    public function life_time_customer_report_per_course_search(Request $request)
    {
        $data = $request->input();
        $times = ChargeTransaction::join('employees', 'employees.id', '=', 'charge_transaction.employee_id')
            ->join('users', 'users.id', '=', 'charge_transaction.user_id')
            ->join('users_course_view_completed', 'users_course_view_completed.user_id', '=', 'charge_transaction.user_id')
            ->join('courses', 'courses.id', '=', 'users_course_view_completed.course_id')
            ->select('charge_transaction.*',DB::raw("(users_course_view_completed.max_time/60)/60 AS duration"), 'courses.name AS course_name', DB::raw("((users_course_view_completed.completed/users_course_view_completed.total)*100) AS completed"), 'users.FullName', 'users.Email', 'users.Mobile', 'employees.username');
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $times = $times->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['course']) && !empty($data['course'])) {
            $course = $data['course'];
            $times = $times->where('courses.id', $course);
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $times = $times->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['mobile']) && !empty($data['mobile'])) {
            $mobile = $data['mobile'];
            $times = $times->where('users.Mobile', 'LIKE', "%$mobile%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $times = $times->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from'], $data['created_time_to'])) {
            $from = $data['created_time_from'];
            $to = $data['created_time_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $times = $times->whereBetween('charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        $iTotalRecords = $times->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'charge_transaction.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'charge_transaction.period';
                break;
            case 5:
                $columnName = 'charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'charge_transaction.end_date';
                break;
            case 7:
                $columnName = 'courses.id';
                break;
            case 8:
                $columnName = 'completed';
                break;
            case 9:
                $columnName = 'duration';
                break;
            case 10:
                $columnName = 'charge_transaction.subscrip_type';
                break;
            case 11:
                $columnName = 'charge_transaction.amount';
                break;
            case 12:
                $columnName = 'charge_transaction.currency';
                break;
            case 13:
                $columnName = 'employees.username';
                break;

        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        $times = $times->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength);
        $times = $times->get();
        $x = 1;
        foreach ($times as $time) {
            $records["data"][] = [
                $time->id,
                $time->FullName,
                $time->Email,
                $time->Mobile,
                $time->period,
                $time->createtime,
                $time->end_date,
                $time->course_name,
                round($time->completed, 2) . '%',
                $time->duration,
                $time->subscrip_type,
                $time->amount,
                $time->currency,
                $time->username,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function diploma_exam_report_search_old(Request $request)
    {
        $data = $request->input();
        $answers = UsersCurriculumAnswers::join('cources_curriculum', 'cources_curriculum.id', '=', 'users_curriculum_answers.curriculum_id')
            ->join('courses', 'courses.id', '=', 'cources_curriculum.course_id')
            ->join('diplomas_courses', 'diplomas_courses.related_course', '=', 'courses.id')
            ->join('diplomas', 'diplomas.id', '=', 'diplomas_courses.diploma_id')
            ->join('users', 'users.id', '=', 'users_curriculum_answers.user_id')
            ->join('diplomas_charge_transaction', function ($join) {
                $join->on('diplomas_charge_transaction.user_id', '=', 'users.id')
                    ->on('diplomas_charge_transaction.diploma_id', '=', 'diplomas.id');
            })
            ->select('users.FullName', 'users.Email', 'users.Mobile', 'courses.name AS course_name', 'courses.id AS course_id', 'diplomas.name AS diploma_name', 'diplomas.id AS diplomas_id', 'users_curriculum_answers.id', 'users_curriculum_answers.createdtime AS exam_date', 'users_curriculum_answers.quetions_numbers', 'users_curriculum_answers.right_answers', 'diplomas_charge_transaction.start_date')
            ->where('users_curriculum_answers.curriculum_type', '=', 'exam');

        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $answers = $answers->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $answers = $answers->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $answers = $answers->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $answers = $answers->where('courses.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $answers = $answers->where('diplomas.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('diplomas_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['exam_date_from'], $data['exam_date_to'])) {
            $from = $data['exam_date_from'];
            $to = $data['exam_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('users_curriculum_answers.createdtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }

        $iTotalRecords = $answers->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'users_curriculum_answers.id';
        switch ($data['order'][0]['column']) {
//            case 0:
//                $columnName = 'users_curriculum_answers.id';
//                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'courses.name';
                break;
            case 5:
                $columnName = 'diplomas.name';
                break;
            case 6:
                $columnName = 'diplomas_charge_transaction.start_date';
                break;
            case 7:
                $columnName = 'users_curriculum_answers.createdtime';
                break;
//            case 8:
//                $columnName = 'users_curriculum_answers.quetions_numbers/users_curriculum_answers.right_answers';
//                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        $answers = $answers->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($answers as $answer) {
            $records["data"][] = [
                $x,
                $answer->FullName,
                $answer->Email,
                $answer->Mobile,
                $answer->course_name,
                $answer->diploma_name,
                $answer->start_date,
                $answer->exam_date,
                $answer->quetions_numbers . '/' . $answer->right_answers,
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function diploma_exam_report_search(Request $request)
    {
        $data = $request->input();

        $answers = UsersCurriculumAnswers::select('u.FullName', 'u.Email', 'u.Mobile', 'course_name', 'c.id AS course_id', 'd.name AS diploma_name', 'd.id AS diplomas_id', 'users_curriculum_answers.id', 'users_curriculum_answers.createdtime AS exam_date', 'users_curriculum_answers.quetions_numbers', 'users_curriculum_answers.right_answers', 'd_c_t.start_date')
            ->join(
                DB::raw("
                    (select cources_curriculum.id,cources_curriculum.course_id from cources_curriculum) as cc
                "), 'users_curriculum_answers.curriculum_id', '=', 'cc.id')
            ->join(
                DB::raw("
                    (select courses.id,courses.name AS course_name from courses) as c
                "), 'c.id', '=', 'cc.course_id')
            ->join(
                DB::raw("
                    (select diplomas_courses.related_course,diplomas_courses.diploma_id from diplomas_courses) as d_c
                "), 'd_c.related_course', '=', 'c.id')
            ->join(
                DB::raw("
                    (select diplomas.id,diplomas.name from diplomas) as d
                "), 'd.id', '=', 'd_c.diploma_id')
            ->join(
                DB::raw("
                    (select users.id,users.FullName,users.Email,users.Mobile from users) as u
                "), 'u.id', '=', 'users_curriculum_answers.user_id')
            ->join(DB::raw("
                    (select diplomas_charge_transaction.user_id,diplomas_charge_transaction.diploma_id,diplomas_charge_transaction.start_date from diplomas_charge_transaction) as d_c_t
                "), function ($join) {
                $join->on('d_c_t.user_id', '=', 'u.id')
                    ->on('d_c_t.diploma_id', '=', 'd.id');
            })->where('users_curriculum_answers.curriculum_type', '=', 'exam');
//                $answers = UsersCurriculumAnswers::join('cources_curriculum','cources_curriculum.id','=','users_curriculum_answers.curriculum_id')
//            ->join('courses','courses.id','=','cources_curriculum.course_id')
//            ->join('diplomas_courses','diplomas_courses.related_course','=','courses.id')
//            ->join('diplomas','diplomas.id','=','diplomas_courses.diploma_id')
//            ->join('users','users.id','=','users_curriculum_answers.user_id')
//            ->join('diplomas_charge_transaction', function($join){
//                $join->on('diplomas_charge_transaction.user_id','=','users.id')
//                    ->on('diplomas_charge_transaction.diploma_id','=','diplomas.id');
//            })
//            ->select('users.FullName','users.Email','users.Mobile','courses.name AS course_name','courses.id AS course_id','diplomas.name AS diploma_name','diplomas.id AS diplomas_id','users_curriculum_answers.id','users_curriculum_answers.createdtime AS exam_date','users_curriculum_answers.quetions_numbers','users_curriculum_answers.right_answers','diplomas_charge_transaction.start_date')
//            ->where('users_curriculum_answers.curriculum_type','=','exam');
//        dd($answers->toSql());

        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $answers = $answers->where('u.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $answers = $answers->where('u.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $answers = $answers->where('u.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $answers = $answers->where('c.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $answers = $answers->where('d.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('d_c_t.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['exam_date_from'], $data['exam_date_to'])) {
            $from = $data['exam_date_from'];
            $to = $data['exam_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('users_curriculum_answers.createdtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }

        $iTotalRecords = $answers->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'users_curriculum_answers.id';
        switch ($data['order'][0]['column']) {
//            case 0:
//                $columnName = 'users_curriculum_answers.id';
//                break;
            case 1:
                $columnName = 'u.FullName';
                break;
            case 2:
                $columnName = 'u.Email';
                break;
            case 3:
                $columnName = 'u.Mobile';
                break;
            case 4:
                $columnName = 'c.name';
                break;
            case 5:
                $columnName = 'd.name';
                break;
            case 6:
                $columnName = 'd_c_t.start_date';
                break;
            case 7:
                $columnName = 'users_curriculum_answers.createdtime';
                break;
//            case 8:
//                $columnName = 'users_curriculum_answers.quetions_numbers/users_curriculum_answers.right_answers';
//                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        $answers = $answers->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($answers as $answer) {
            $records["data"][] = [
                $x,
                $answer->FullName,
                $answer->Email,
                $answer->Mobile,
                $answer->course_name,
                $answer->diploma_name,
                $answer->start_date,
                $answer->exam_date,
                $answer->quetions_numbers . '/' . $answer->right_answers,
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function diploma_exam_report_export(Request $request)
    {
        $data = $request->input();

        $answers = UsersCurriculumAnswers::select('u.FullName', 'u.Email', 'u.Mobile', 'course_name', 'c.id AS course_id', 'd.name AS diploma_name', 'd.id AS diplomas_id', 'users_curriculum_answers.id', 'users_curriculum_answers.createdtime AS exam_date', 'users_curriculum_answers.quetions_numbers', 'users_curriculum_answers.right_answers', 'd_c_t.start_date')
            ->join(
                DB::raw("
                    (select cources_curriculum.id,cources_curriculum.course_id from cources_curriculum) as cc
                "), 'users_curriculum_answers.curriculum_id', '=', 'cc.id')
            ->join(
                DB::raw("
                    (select courses.id,courses.name AS course_name from courses) as c
                "), 'c.id', '=', 'cc.course_id')
            ->join(
                DB::raw("
                    (select diplomas_courses.related_course,diplomas_courses.diploma_id from diplomas_courses) as d_c
                "), 'd_c.related_course', '=', 'c.id')
            ->join(
                DB::raw("
                    (select diplomas.id,diplomas.name from diplomas) as d
                "), 'd.id', '=', 'd_c.diploma_id')
            ->join(
                DB::raw("
                    (select users.id,users.FullName,users.Email,users.Mobile from users) as u
                "), 'u.id', '=', 'users_curriculum_answers.user_id')
            ->join(DB::raw("
                    (select diplomas_charge_transaction.user_id,diplomas_charge_transaction.diploma_id,diplomas_charge_transaction.start_date from diplomas_charge_transaction) as d_c_t
                "), function ($join) {
                $join->on('d_c_t.user_id', '=', 'u.id')
                    ->on('d_c_t.diploma_id', '=', 'd.id');
            })->where('users_curriculum_answers.curriculum_type', '=', 'exam');
//                $answers = UsersCurriculumAnswers::join('cources_curriculum','cources_curriculum.id','=','users_curriculum_answers.curriculum_id')
//            ->join('courses','courses.id','=','cources_curriculum.course_id')
//            ->join('diplomas_courses','diplomas_courses.related_course','=','courses.id')
//            ->join('diplomas','diplomas.id','=','diplomas_courses.diploma_id')
//            ->join('users','users.id','=','users_curriculum_answers.user_id')
//            ->join('diplomas_charge_transaction', function($join){
//                $join->on('diplomas_charge_transaction.user_id','=','users.id')
//                    ->on('diplomas_charge_transaction.diploma_id','=','diplomas.id');
//            })
//            ->select('users.FullName','users.Email','users.Mobile','courses.name AS course_name','courses.id AS course_id','diplomas.name AS diploma_name','diplomas.id AS diplomas_id','users_curriculum_answers.id','users_curriculum_answers.createdtime AS exam_date','users_curriculum_answers.quetions_numbers','users_curriculum_answers.right_answers','diplomas_charge_transaction.start_date')
//            ->where('users_curriculum_answers.curriculum_type','=','exam');
//        dd($answers->toSql());

        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $answers = $answers->where('u.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $answers = $answers->where('u.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $answers = $answers->where('u.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $answers = $answers->where('c.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $answers = $answers->where('d.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('d_c_t.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['exam_date_from'], $data['exam_date_to'])) {
            $from = $data['exam_date_from'];
            $to = $data['exam_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('users_curriculum_answers.createdtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }


        $answers = $answers->get();
        $output = ['#', Lang::get('main.user_name'), Lang::get('main.email'), Lang::get('main.mobile'), Lang::get('main.course_name'),
            Lang::get('main.diploma_name')
            , Lang::get('main.diploma_start_date'), Lang::get('main.exam_date'), Lang::get('main.exam_result')];

        $filename = "report.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);
        $x = 1;
        foreach ($answers as $answer) {
            fputcsv($handle, [
                $x,
                $answer->FullName,
                $answer->Email,
                $answer->Mobile,
                $answer->course_name,
                $answer->diploma_name,
                $answer->start_date,
                $answer->exam_date,
                $answer->quetions_numbers . '/' . $answer->right_answers,
            ]);
            $x++;
        }
        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="report.csv"'
        );
        return Response::download($filename, 'report.csv', $headers);
    }

    public function diploma_not_exam_report_search(Request $request)
    {
        $data = $request->input();

        $diplomas = DiplomasUsersCourses::join('diplomas_charge_transaction', function ($join) {
            $join->on('diplomas_charge_transaction.user_id', '=', 'diplomas_users_courses.user_id')
                ->on('diplomas_charge_transaction.diploma_id', '=', 'diplomas_users_courses.diploma_id');
        })
            ->join('users', 'diplomas_users_courses.user_id', '=', 'users.id')
            ->join('courses', 'courses.id', '=', 'diplomas_users_courses.course_id')
            ->join('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction.diploma_id')
            ->select('users.id AS user_id', 'users.FullName', 'users.Email', 'users.Mobile', 'courses.id AS course_id', 'courses.name AS course_name', 'diplomas.id AS diploma_id', 'diplomas.name AS diploma_name', 'diplomas_charge_transaction.start_date')
            ->where('diplomas_users_courses.exam', '=', 'not exam');
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $diplomas = $diplomas->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $diplomas = $diplomas->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $diplomas = $diplomas->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $diplomas = $diplomas->where('courses.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $diplomas = $diplomas->where('diplomas.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $diplomas = $diplomas->whereBetween('diplomas_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }

        $iTotalRecords = $diplomas->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'diplomas_users_courses.id';
        switch ($data['order'][0]['column']) {
//            case 0:
//                $columnName = 'users_curriculum_answers.id';
//                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'courses.name';
                break;
            case 5:
                $columnName = 'diplomas.name';
                break;
            case 6:
                $columnName = 'diplomas_charge_transaction.start_date';
                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        $diplomas = $diplomas->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($diplomas as $diploma) {
            $records["data"][] = [
                $x,
                $diploma->FullName,
                $diploma->Email,
                $diploma->Mobile,
                $diploma->course_name,
                $diploma->diploma_name,
                $diploma->start_date,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function diploma_not_exam_report_export(Request $request)
    {
        $data = $request->input();

        $diplomas = DiplomasUsersCourses::join('diplomas_charge_transaction', function ($join) {
            $join->on('diplomas_charge_transaction.user_id', '=', 'diplomas_users_courses.user_id')
                ->on('diplomas_charge_transaction.diploma_id', '=', 'diplomas_users_courses.diploma_id');
        })
            ->join('users', 'diplomas_users_courses.user_id', '=', 'users.id')
            ->join('courses', 'courses.id', '=', 'diplomas_users_courses.course_id')
            ->join('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction.diploma_id')
            ->select('users.id AS user_id', 'users.FullName', 'users.Email', 'users.Mobile', 'courses.id AS course_id', 'courses.name AS course_name', 'diplomas.id AS diploma_id', 'diplomas.name AS diploma_name', 'diplomas_charge_transaction.start_date')
            ->where('diplomas_users_courses.exam', '=', 'not exam');
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $diplomas = $diplomas->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $diplomas = $diplomas->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $diplomas = $diplomas->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $diplomas = $diplomas->where('courses.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $diplomas = $diplomas->where('diplomas.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $diplomas = $diplomas->whereBetween('diplomas_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }


        $diplomas = $diplomas->get();
        $output = ['#', Lang::get('main.user_name'), Lang::get('main.email'), Lang::get('main.mobile'), Lang::get('main.course_name'),
            Lang::get('main.diploma_name')
            , Lang::get('main.diploma_start_date')];

        $filename = "report.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);
        $x = 1;
        foreach ($diplomas as $diploma) {
            fputcsv($handle, [
                $x,
                $diploma->FullName,
                $diploma->Email,
                $diploma->Mobile,
                $diploma->course_name,
                $diploma->diploma_name,
                $diploma->start_date,

            ]);
            $x = $x + 1;
        }
        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="report.csv"'
        );
        return Response::download($filename, 'report.csv', $headers);
    }

    public function training_program_exam_report_search(Request $request)
    {
        $data = $request->input();

        $answers = UsersCurriculumAnswers::select('u.FullName', 'u.Email', 'u.Mobile', 'course_name', 'c.id AS course_id', 'd.name AS diploma_name', 'd.id AS diplomas_id', 'users_curriculum_answers.id', 'users_curriculum_answers.createdtime AS exam_date', 'users_curriculum_answers.quetions_numbers', 'users_curriculum_answers.right_answers', 'd_c_t.start_date')
            ->join(
                DB::raw("
                    (select cources_curriculum.id,cources_curriculum.course_id from cources_curriculum) as cc
                "), 'users_curriculum_answers.curriculum_id', '=', 'cc.id')
            ->join(
                DB::raw("
                    (select courses.id,courses.name AS course_name from courses) as c
                "), 'c.id', '=', 'cc.course_id')
            ->join(
                DB::raw("
                    (select training_program_courses.related_course,training_program_courses.diploma_id from training_program_courses) as d_c
                "), 'd_c.related_course', '=', 'c.id')
            ->join(
                DB::raw("
                    (select training_program.id,training_program.name from training_program) as d
                "), 'd.id', '=', 'd_c.diploma_id')
            ->join(
                DB::raw("
                    (select users.id,users.FullName,users.Email,users.Mobile from users) as u
                "), 'u.id', '=', 'users_curriculum_answers.user_id')
            ->join(DB::raw("
                    (select training_program_charge_transaction.user_id,training_program_charge_transaction.diploma_id,training_program_charge_transaction.start_date from training_program_charge_transaction) as d_c_t
                "), function ($join) {
                $join->on('d_c_t.user_id', '=', 'u.id')
                    ->on('d_c_t.diploma_id', '=', 'd.id');
            })->where('users_curriculum_answers.curriculum_type', '=', 'exam');
//                $answers = UsersCurriculumAnswers::join('cources_curriculum','cources_curriculum.id','=','users_curriculum_answers.curriculum_id')
//            ->join('courses','courses.id','=','cources_curriculum.course_id')
//            ->join('training_program_courses','training_program_courses.related_course','=','courses.id')
//            ->join('diplomas','diplomas.id','=','training_program_courses.diploma_id')
//            ->join('users','users.id','=','users_curriculum_answers.user_id')
//            ->join('diplomas_charge_transaction', function($join){
//                $join->on('diplomas_charge_transaction.user_id','=','users.id')
//                    ->on('diplomas_charge_transaction.diploma_id','=','diplomas.id');
//            })
//            ->select('users.FullName','users.Email','users.Mobile','courses.name AS course_name','courses.id AS course_id','diplomas.name AS diploma_name','diplomas.id AS diplomas_id','users_curriculum_answers.id','users_curriculum_answers.createdtime AS exam_date','users_curriculum_answers.quetions_numbers','users_curriculum_answers.right_answers','diplomas_charge_transaction.start_date')
//            ->where('users_curriculum_answers.curriculum_type','=','exam');
//        dd($answers->toSql());

        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $answers = $answers->where('u.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $answers = $answers->where('u.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $answers = $answers->where('u.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $answers = $answers->where('c.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $answers = $answers->where('d.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('d_c_t.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['exam_date_from'], $data['exam_date_to'])) {
            $from = $data['exam_date_from'];

            $to = $data['exam_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('users_curriculum_answers.createdtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }

        $iTotalRecords = $answers->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'users_curriculum_answers.id';
        switch ($data['order'][0]['column']) {
//            case 0:
//                $columnName = 'users_curriculum_answers.id';
//                break;
            case 1:
                $columnName = 'u.FullName';
                break;
            case 2:
                $columnName = 'u.Email';
                break;
            case 3:
                $columnName = 'u.Mobile';
                break;
            case 4:
                $columnName = 'c.name';
                break;
            case 5:
                $columnName = 'd.name';
                break;
            case 6:
                $columnName = 'd_c_t.start_date';
                break;
            case 7:
                $columnName = 'users_curriculum_answers.createdtime';
                break;
//            case 8:
//                $columnName = 'users_curriculum_answers.quetions_numbers/users_curriculum_answers.right_answers';
//                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        $answers = $answers->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($answers as $answer) {
            $records["data"][] = [
                $x,
                $answer->FullName,
                $answer->Email,
                $answer->Mobile,
                $answer->course_name,
                $answer->diploma_name,
                $answer->start_date,
                $answer->exam_date,
                $answer->quetions_numbers . '/' . $answer->right_answers,
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function training_program_exam_report_export(Request $request)
    {
        $data = $request->input();

        $answers = UsersCurriculumAnswers::select('u.FullName', 'u.Email', 'u.Mobile', 'course_name', 'c.id AS course_id', 'd.name AS diploma_name', 'd.id AS diplomas_id', 'users_curriculum_answers.id', 'users_curriculum_answers.createdtime AS exam_date', 'users_curriculum_answers.quetions_numbers', 'users_curriculum_answers.right_answers', 'd_c_t.start_date')
            ->join(
                DB::raw("
                    (select cources_curriculum.id,cources_curriculum.course_id from cources_curriculum) as cc
                "), 'users_curriculum_answers.curriculum_id', '=', 'cc.id')
            ->join(
                DB::raw("
                    (select courses.id,courses.name AS course_name from courses) as c
                "), 'c.id', '=', 'cc.course_id')
            ->join(
                DB::raw("
                    (select training_program_courses.related_course,training_program_courses.diploma_id from training_program_courses) as d_c
                "), 'd_c.related_course', '=', 'c.id')
            ->join(
                DB::raw("
                    (select training_program.id,training_program.name from training_program) as d
                "), 'd.id', '=', 'd_c.diploma_id')
            ->join(
                DB::raw("
                    (select users.id,users.FullName,users.Email,users.Mobile from users) as u
                "), 'u.id', '=', 'users_curriculum_answers.user_id')
            ->join(DB::raw("
                    (select training_program_charge_transaction.user_id,training_program_charge_transaction.diploma_id,training_program_charge_transaction.start_date from training_program_charge_transaction) as d_c_t
                "), function ($join) {
                $join->on('d_c_t.user_id', '=', 'u.id')
                    ->on('d_c_t.diploma_id', '=', 'd.id');
            })->where('users_curriculum_answers.curriculum_type', '=', 'exam');

        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $answers = $answers->where('u.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $answers = $answers->where('u.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $answers = $answers->where('u.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $answers = $answers->where('c.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $answers = $answers->where('d.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('d_c_t.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['exam_date_from'], $data['exam_date_to'])) {
            $from = $data['exam_date_from'];

            $to = $data['exam_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $answers = $answers->whereBetween('users_curriculum_answers.createdtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        $output = ['#', Lang::get('main.user_name'), Lang::get('main.email'), Lang::get('main.mobile'), Lang::get('main.course_name'),
            Lang::get('main.training_program_name'), Lang::get('main.training_program_start_date')
            , Lang::get('main.exam_date'), Lang::get('main.exam_result')];

        $filename = "report.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);

        $answers = $answers->get();
        $x = 1;
        foreach ($answers as $answer) {
            fputcsv($handle, [
                $x,
                $answer->FullName,
                $answer->Email,
                $answer->Mobile,
                $answer->course_name,
                $answer->diploma_name,
                $answer->start_date,
                $answer->exam_date,
                $answer->quetions_numbers . '/' . $answer->right_answers,
            ]);
            $x++;
        }
        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="report.csv"'
        );
        return Response::download($filename, 'report.csv', $headers);

    }

    public function training_program_not_exam_report_search(Request $request)
    {
        $data = $request->input();

        $diplomas = TrainingProgramUsersCourses::join('training_program_charge_transaction', function ($join) {
            $join->on('training_program_charge_transaction.user_id', '=', 'training_program_users_courses.user_id')
                ->on('training_program_charge_transaction.diploma_id', '=', 'training_program_users_courses.diploma_id');
        })
            ->join('users', 'training_program_users_courses.user_id', '=', 'users.id')
            ->join('courses', 'courses.id', '=', 'training_program_users_courses.course_id')
            ->join('training_program', 'training_program.id', '=', 'training_program_charge_transaction.diploma_id')
            ->select('users.id AS user_id', 'users.FullName', 'users.Email', 'users.Mobile', 'courses.id AS course_id', 'courses.name AS course_name', 'training_program.id AS diploma_id', 'training_program.name AS diploma_name', 'training_program_charge_transaction.start_date')
            ->where('training_program_users_courses.exam', '=', 'not exam');
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $diplomas = $diplomas->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $diplomas = $diplomas->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $diplomas = $diplomas->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['course_name']) && !empty($data['course_name'])) {
            $course_name = $data['course_name'];
            $diplomas = $diplomas->where('courses.name', '=', "$course_name");
        }
        if (isset($data['diploma_name']) && !empty($data['diploma_name'])) {
            $diploma_name = $data['diploma_name'];
            $diplomas = $diplomas->where('diplomas.name', 'LIKE', "%$diploma_name%");
        }
        if (isset($data['diploma_date_from'], $data['diploma_date_to'])) {
            $from = $data['diploma_date_from'];
            $to = $data['diploma_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $diplomas = $diplomas->whereBetween('training_program_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }

        $iTotalRecords = $diplomas->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'training_program_users_courses.id';
        switch ($data['order'][0]['column']) {
//            case 0:
//                $columnName = 'users_curriculum_answers.id';
//                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'courses.name';
                break;
            case 5:
                $columnName = 'training_program.name';
                break;
            case 6:
                $columnName = 'training_program_charge_transaction.start_date';
                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('training_program_charge_transaction.period', '=', "$search")
//                    ->orWhere('training_program_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('training_program_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('training_program_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('training_program_charge_transaction.id', '=', $search);
//            });
//        }
        $diplomas = $diplomas->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($diplomas as $diploma) {
            $records["data"][] = [
                $x,
                $diploma->FullName,
                $diploma->Email,
                $diploma->Mobile,
                $diploma->course_name,
                $diploma->diploma_name,
                $diploma->start_date,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function mba_report()
    {
        $subscribe_types = MbaChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = MbaChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.mba_report.view', compact('subscribe_types', 'currencies'));
    }

    public function new_mba_report()
    {
        $subscribe_types = NewMbaChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = NewMbaChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.new_mba_report.view', compact('subscribe_types', 'currencies'));
    }

    public function dba_preliminary_report()
    {
        $subscribe_types = DBAPreliminaryChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = DBAPreliminaryChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.dba_preliminary_report.view', compact('subscribe_types', 'currencies'));
    }

    public function dba_report()
    {
        $subscribe_types = DBAChargeTransaction::groupBy('subscrip_type')->pluck('subscrip_type');
        $currencies = DBAChargeTransaction::groupBy('currency')->pluck('currency');
        return view('auth.dba_report.view', compact('subscribe_types', 'currencies'));
    }

    public function exportMbaStatistics(Request $request)
    {
        $this->getUserMbaStatisticsReport($request);
    }

    public function exportNewMbaStatistics(Request $request)
    {
        $this->getUserNewMbaStatisticsReport($request);
    }

    public function exportNewMbaCategoryStatistics(Request $request)
    {
        $this->getUserNewMbaCategoryStatisticsReport($request);
    }


    public function exportMbaViews(Request $request)
    {
        $this->getUserMbaViewsReport($request);
    }

    public function exportNewMbaViews(Request $request)
    {
        $this->getUserNewMbaViewsReport($request);
    }

    public function exportMbaTests(Request $request)
    {
        $this->getUserMbaTestsReport($request);
    }


    public function exportNewMbaTests1(Request $request)
    {
        $this->getUserNewMbaTests1Report($request);
    }

    public function exportNewMbaTests2(Request $request)
    {
        $this->getUserNewMbaTests2Report($request);
    }

    public function exportMbaTrainings(Request $request)
    {
        $this->getUserMbaTrainingsReport($request);
    }


    public function exportNewMbaTrainings(Request $request)
    {
        $this->getUserNewMbaTrainingsReport($request);
    }

    public function exportMbaCoursesReport(Request $request)
    {
        $this->getUserMbaCoursesReport($request);
    }

    public function exportNewMbaCoursesReport(Request $request)
    {
        $this->getUserNewMbaCoursesReport($request);
    }

    public function mba_report_search(Request $request)
    {
        $data = $request->input();

        $transactions = MbaChargeTransaction::leftJoin('users', 'mba_charge_transaction.user_id', '=', 'users.id')
            ->leftJoin('employees', 'employees.id', '=', 'mba_charge_transaction.employee_id')
            ->select('mba_charge_transaction.id','mba_charge_transaction.subscrip_country', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'mba_charge_transaction.period', 'mba_charge_transaction.createtime', 'mba_charge_transaction.end_date',
                DB::raw("(SELECT ((((" . config('app.MBA_PROGRESS') . "*SUM(progress))/100)+((" . config('app.MBA_PROJECT') . "*SUM(project))/100)+((" . config('app.MBA_EXAM') . "*SUM(exam))/100))/12) FROM modules_users_summary WHERE modules_users_summary.user_id=mba_charge_transaction.user_id) as completed", 'mba_charge_transaction.subscrip_type', 'mba_charge_transaction.mba_price', 'mba_charge_transaction.currency', 'employees.username AS employee_name')

            );
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('mba_charge_transaction.period', '=', "$period");
        }
        if (isset($data['date_from'], $data['date_to'])) {
            $from = $data['date_from'];
            $to = $data['date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $transactions = $transactions->whereBetween('mba_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('mba_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }

        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('mba_charge_transaction.subscrip_type', '=', "$subscribe_type");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('mba_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('mba_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['markets']) && !empty($data['markets'])) {
            $markets = $data['markets'];
            if($markets=='egypt' || $markets=='egyp'){
                $markets='egy';
            }
            $transactions = $transactions->where('mba_charge_transaction.subscrip_country', 'LIKE', "%$markets%");
        }


        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'mba_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'mba_charge_transaction.period';
                break;
            case 5:
                $columnName = 'mba_charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'mba_charge_transaction.end_date';
                break;
            case 7:
                $columnName = 'completed';
                break;
            case 8:
                $columnName = 'mba_charge_transaction.id';
                break;
            case 9:
                $columnName = 'mba_charge_transaction.subscrip_country';
                break;
            case 10:
                $columnName = 'mba_charge_transaction.subscrip_type';
                break;
            case 11:
                $columnName = 'mba_charge_transaction.mba_price';
                break;
            case 12:
                $columnName = 'mba_charge_transaction.currency';
                break;
            case 13:
                $columnName = 'employees.username';
                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        if ($request->export) {
            //dd(getEloquentSqlWithBindings($transactions));
            $titles = ['#', 'Username', 'Email', 'Phone', 'Period', 'Created Time', 'Expired Date', 'Complete','Market' ,'Subscribe Type', 'Amount', 'Currency', 'Employee Name'];
            $name = 'mba_report.csv';
            //dd($transactions->get()->toArray());
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $name);
            $output = fopen("php://output", "w");
            fputcsv($output, $titles);
            foreach ($transactions->get()->toArray() as $res) {
                unset($res[count($res) - 1]);
                fputcsv($output, $res);
            }
            fclose($output);
            return '';
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $x,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                round($transaction->completed, 2) . '%',
                $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                $transaction->subscrip_type,
                $transaction->mba_price,
                $transaction->currency,
                $transaction->employee_name,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;

        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));

    }

    /* Start New Report Search Function */

    public function new_mba_report_search(Request $request)
    {
        $data = $request->input();

        $transactions = NewMbaChargeTransaction::leftJoin('users', 'new_mba_charge_transaction.user_id', '=', 'users.id')
            ->leftJoin('employees', 'employees.id', '=', 'new_mba_charge_transaction.employee_id')
            ->leftJoin('new_mba_categories', 'new_mba_categories.id', '=', 'new_mba_charge_transaction.category_id')
            ->select('new_mba_charge_transaction.id','new_mba_charge_transaction.subscrip_country', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'new_mba_charge_transaction.period', 'new_mba_charge_transaction.createtime', 'new_mba_charge_transaction.end_date',
                'new_mba_categories.name AS category_name',
                DB::raw("(SELECT ((" . config('app.NEW_MBA_PROGRESS') . "*SUM(progress))/100) FROM new_mba_modules_users_summary WHERE new_mba_modules_users_summary.user_id = new_mba_charge_transaction.user_id) as progress")
                , DB::raw("(SELECT ((" . config('app.NEW_MBA_PROJECT') . "*SUM(project))/100) FROM new_mba_modules_users_summary WHERE new_mba_modules_users_summary.user_id = new_mba_charge_transaction.user_id) as project_progress")
                , DB::raw("(SELECT ((" . config('app.NEW_MBA_EXAM_PART_1') . "*SUM(exam_part_1))/100) FROM new_mba_modules_users_summary WHERE new_mba_modules_users_summary.user_id = new_mba_charge_transaction.user_id) as exam_part_1")
                , DB::raw("(SELECT (" . config('app.NEW_MBA_EXAM_PART_2') . "*SUM(exam_part_2)) FROM new_mba_modules_users_summary WHERE new_mba_modules_users_summary.user_id = new_mba_charge_transaction.user_id) as exam_part_2")
                , DB::raw("(SELECT ((((" . config('app.NEW_MBA_PROGRESS') . "*SUM(progress))/100)+(("
                    . config('app.NEW_MBA_PROJECT') . "*SUM(project))/100)+((" . config('app.NEW_MBA_EXAM_PART_1') .
                    "*SUM(exam_part_1))/100)+((" . config('app.NEW_MBA_EXAM_PART_2') .
                    "*SUM(exam_part_2))/100))/12) FROM new_mba_modules_users_summary WHERE new_mba_modules_users_summary.user_id = new_mba_charge_transaction.user_id) as completed"),
                'new_mba_charge_transaction.subscrip_type', 'new_mba_charge_transaction.mba_price', 'new_mba_charge_transaction.currency',
                'employees.username AS employee_name'


            );
        if (isset($data['category_name']) && !empty($data['category_name'])) {
            $category_name = $data['category_name'];
            $transactions = $transactions->where('new_mba_categories.name', 'LIKE', "%$category_name%");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('new_mba_charge_transaction.period', '=', "$period");
        }
        if (isset($data['date_from'], $data['date_to'])) {
            $from = $data['date_from'];
            $to = $data['date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $transactions = $transactions->whereBetween('new_mba_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('new_mba_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }

        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('new_mba_charge_transaction.subscrip_type', '=', "$subscribe_type");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('new_mba_charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('new_mba_charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['markets']) && !empty($data['markets'])) {
            $markets = $data['markets'];
            if($markets=='egypt' || $markets=='egyp'){
                $markets='egy';
            }
            $transactions = $transactions->where('new_mba_charge_transaction.subscrip_country', 'LIKE', "%$markets%");
        }


        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'new_mba_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'new_mba_categories.name';
                break;
            case 2:
                $columnName = 'users.FullName';
                break;
            case 3:
                $columnName = 'users.Email';
                break;
            case 4:
                $columnName = 'users.Mobile';
                break;
            case 5:
                $columnName = 'new_mba_charge_transaction.period';
                break;
            case 6:
                $columnName = 'new_mba_charge_transaction.createtime';
                break;
            case 7:
                $columnName = 'new_mba_charge_transaction.end_date';
                break;
            case 8:
                $columnName = 'summery';
                break;
            case 9:
                $columnName = 'project_summery';
                break;
            case 10:
                $columnName = 'exam_part_1';
                break;
            case 11:
                $columnName = 'exam_part_2';
                break;
            case 12:
                $columnName = 'completed';
                break;
            case 13:
                $columnName = 'new_mba_charge_transaction.id';
                break;
            case 14:
                $columnName = 'new_mba_charge_transaction.subscrip_country';
                break;
            case 15:
                $columnName = 'new_mba_charge_transaction.subscrip_type';
                break;
            case 16:
                $columnName = 'new_mba_charge_transaction.mba_price';
                break;
            case 17:
                $columnName = 'new_mba_charge_transaction.currency';
                break;
            case 18:
                $columnName = 'employees.username';
                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        if ($request->export) {
            //dd(getEloquentSqlWithBindings($transactions));
            $titles = ['#','Specialization', 'Username', 'Email', 'Phone', 'Period', 'Created Time', 'Expired Date', 'Progress', 'Project Progress', 'Exam Part1', 'Exam Part2', 'Complete','Market', 'Subscribe Type', 'Amount', 'Currency', 'Employee Name'];
            $name = 'new_mba_report.csv';
            //dd($transactions->get()->toArray());
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $name);
            $output = fopen("php://output", "w");
            fputcsv($output, $titles);
            $x = 1;
            foreach ($transactions->get() as $transaction) {
                fputcsv($output, [
                    $x,
                    $transaction->category_name,
                    $transaction->username,
                    $transaction->email,
                    $transaction->phone,
                    $transaction->period,
                    $transaction->createtime,
                    $transaction->end_date,
                    round($transaction->summery, 2) . '%',
                    round($transaction->project_summery, 2) . '%',
                    round($transaction->exam_part_1, 2) . '%',
                    round($transaction->exam_part_2, 2) . '%',
                    round($transaction->completed, 2) . '%',
                    $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                    $transaction->subscrip_type,
                    $transaction->mba_price,
                    $transaction->currency,
                    $transaction->employee_name,
                ]);
                $x++;
            }
            fclose($output);
            return '';
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $x,
                $transaction->category_name,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                round($transaction->summery, 2) . '%',
                round($transaction->project_summery, 2) . '%',
                round($transaction->exam_part_1, 2) . '%',
                round($transaction->exam_part_2, 2) . '%',
                round($transaction->completed, 2) . '%',
                $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',

                $transaction->subscrip_type,
                $transaction->mba_price,
                $transaction->currency,
                $transaction->employee_name,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        $data = $request->input();

        return response()->json($records)->setCallback($request->input('callback'));
    }


    /* Start Dba preliminary Search Function */

    public function dba_preliminary_report_search(Request $request)
    {
        $data = $request->input();

        $transactions = DBAPreliminaryChargeTransaction::leftJoin('users', 'dba_preliminary_charge_transaction.user_id', '=', 'users.id')
            ->leftJoin('employees', 'employees.id', '=', 'dba_preliminary_charge_transaction.employee_id')
            ->select('dba_preliminary_charge_transaction.id', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'dba_preliminary_charge_transaction.period', 'dba_preliminary_charge_transaction.createtime', 'dba_preliminary_charge_transaction.end_date'
                , DB::raw("(SELECT result FROM dba_users_doctor_files WHERE dba_users_doctor_files.user_id = dba_preliminary_charge_transaction.user_id) as completed")
                , DB::raw("(SELECT ROUND(((SELECT SUM(completed) FROM users_course_view_completed WHERE users_course_view_completed.user_id=dba_preliminary_charge_transaction.user_id AND users_course_view_completed.course_id  IN (SELECT related_course FROM dba_preliminary_courses_user_plan WHERE dba_preliminary_courses_user_plan.user_id=dba_preliminary_charge_transaction.user_id AND dba_preliminary_courses_user_plan.published='yes'))/(SELECT COUNT(id) FROM cources_curriculum WHERE cources_curriculum.course_id IN (SELECT related_course FROM dba_preliminary_courses_user_plan WHERE dba_preliminary_courses_user_plan.user_id=dba_preliminary_charge_transaction.user_id AND dba_preliminary_courses_user_plan.published='yes') AND cources_curriculum.type='default' AND ISNULL(deleted_at)))*100)) AS watching"),
                'dba_preliminary_charge_transaction.subscrip_type',
                'employees.username AS employee_name'


            );
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('dba_preliminary_charge_transaction.period', '=', "$period");
        }
        if (isset($data['date_from'], $data['date_to'])) {
            $from = $data['date_from'];
            $to = $data['date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $transactions = $transactions->whereBetween('dba_preliminary_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('dba_preliminary_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }

        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('dba_preliminary_charge_transaction.subscrip_type', '=', "$subscribe_type");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('dba_preliminary_charge_transaction.amount', 'LIKE', "%$amount%");
        }

        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }


        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_preliminary_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'dba_preliminary_charge_transaction.period';
                break;
            case 5:
                $columnName = 'dba_preliminary_charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'dba_preliminary_charge_transaction.end_date';
                break;
            case 11:
                $columnName = 'completed';
                break;
            case 12:
                $columnName = 'watching';
                break;
            case 13:
                $columnName = 'dba_preliminary_charge_transaction.id';
                break;
            case 14:
                $columnName = 'dba_preliminary_charge_transaction.subscrip_type';
                break;

            case 16:
                $columnName = 'employees.username';
                break;
        }

//        $search = $data['search']['value'];
//        if ($search) {
//            $transactions = $transactions->where(function ($q) use ($search) {
//                $q->where('users.FullName', 'LIKE', "%$search%")
//                    ->orWhere('users.Email', 'LIKE', "%$search%")
//                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.period', '=', "$search")
//                    ->orWhere('diplomas_charge_transaction.subscrip_type', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.amount', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.currency', 'LIKE', "%$search%")
//                    ->orWhere('employees.username', 'LIKE', "%$search%")
//                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
//            });
//        }
        if ($request->export) {
            //dd(getEloquentSqlWithBindings($transactions));
            $titles = ['#', 'Username', 'Email', 'Phone', 'Period', 'Created Time', 'Expired Date', 'Complete','Watching', 'Subscribe Type', 'Employee Name'];
            $name = 'dba_preliminary_report.csv';
            //dd($transactions->get()->toArray());
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $name);
            $output = fopen("php://output", "w");
            fputcsv($output, $titles);
            foreach ($transactions->get()->toArray() as $res) {
                unset($res[count($res) - 1]);
                fputcsv($output, $res);
            }
            fclose($output);
            return '';
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $x,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->completed,
                $transaction->watching.'%',
                $transaction->subscrip_type,
                $transaction->employee_name,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    /* Start Dba Report Search Function */

    public function dba_report_search(Request $request)
    {
        $data = $request->input();

        $transactions = DBAChargeTransaction::leftJoin('users', 'dba_charge_transaction.user_id', '=', 'users.id')
            ->leftJoin('employees', 'employees.id', '=', 'dba_charge_transaction.employee_id')
            ->select('dba_charge_transaction.id', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', 'dba_charge_transaction.period', 'dba_charge_transaction.createtime', 'dba_charge_transaction.end_date'
                , DB::raw("(SELECT result FROM dba_users_doctor_files WHERE dba_users_doctor_files.user_id = dba_charge_transaction.user_id) as completed")
                , DB::raw("(SELECT ROUND(((SELECT SUM(completed) FROM users_course_view_completed WHERE users_course_view_completed.user_id=dba_charge_transaction.user_id AND users_course_view_completed.course_id  IN (SELECT related_course FROM dba_preliminary_courses_user_plan WHERE dba_preliminary_courses_user_plan.user_id=dba_charge_transaction.user_id AND dba_preliminary_courses_user_plan.published='yes'))/(SELECT COUNT(id) FROM cources_curriculum WHERE cources_curriculum.course_id IN (SELECT related_course FROM dba_preliminary_courses_user_plan WHERE dba_preliminary_courses_user_plan.user_id=dba_charge_transaction.user_id AND dba_preliminary_courses_user_plan.published='yes') AND cources_curriculum.type='default' AND ISNULL(deleted_at)))*100)) AS watching"),
                'dba_charge_transaction.subscrip_type',
                'employees.username AS employee_name'


            );
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('dba_charge_transaction.period', '=', "$period");
        }
        if (isset($data['date_from'], $data['date_to'])) {
            $from = $data['date_from'];
            $to = $data['date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $transactions = $transactions->whereBetween('dba_charge_transaction.createtime', [$from . ' 00:00:00', $to . ' 23:59:59']);
            }
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('dba_charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }

        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('dba_charge_transaction.subscrip_type', '=', "$subscribe_type");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('dba_charge_transaction.amount', 'LIKE', "%$amount%");
        }

        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }


        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'dba_charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'dba_charge_transaction.period';
                break;
            case 5:
                $columnName = 'dba_charge_transaction.createtime';
                break;
            case 6:
                $columnName = 'dba_charge_transaction.end_date';
                break;
            case 11:
                $columnName = 'completed';
                break;
            case 12:
                $columnName = 'watching';
                break;
            case 13:
                $columnName = 'dba_charge_transaction.id';
                break;
            case 14:
                $columnName = 'dba_charge_transaction.subscrip_type';
                break;
            case 15:
                $columnName = 'employees.username';
                break;
        }


        if ($request->export) {
            //dd(getEloquentSqlWithBindings($transactions));
            $titles = ['#', 'Username', 'Email', 'Phone', 'Period', 'Created Time', 'Expired Date', 'Complete','Warching' ,'Subscribe Type', 'Employee Name'];
            $name = 'dba_report.csv';
            //dd($transactions->get()->toArray());
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $name);
            $output = fopen("php://output", "w");
            fputcsv($output, $titles);
            foreach ($transactions->get()->toArray() as $res) {
                unset($res[count($res) - 1]);
                fputcsv($output, $res);
            }
            fclose($output);
            return '';
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $x,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->completed,
                $transaction->watching.'%',
                $transaction->subscrip_type,
                $transaction->mba_price,
                $transaction->currency,
                $transaction->employee_name,
                ''
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }


    /* End New Report Search Function */
    public function yottadiplomaMakeSuspend(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $diploma_transaction_id = isset($params['diploma_transaction_id']) ? $params['diploma_transaction_id'] : null;
        $suspend = isset($params['suspend']) ? $params['suspend'] : null;
        $this->doYottaDiplomaMakeSuspend($email, $diploma_transaction_id, $suspend);
    }

    public function getyottaDiplomaSuspendCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['user_email']) ? $params['user_email'] : null;
            //$password=post('password');
            $data = $this->getyottaclientdata($username);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $diplomas = $this->getUserYottaDiplomas($data->id);
                if (count($diplomas)) {
                    echo '<div id="yottadiplomaTransactionSuspendMessage"></div>';
                    echo '<div class="form-group"><select name="yottadiplomaTransactionSuspendID" id="yottadiplomaTransactionSuspendID" class="form-control" placeholder="الدبلومة">';
                    echo '<option value="">الدبلومة</option>';
                    foreach ($diplomas as $diploma) {
                        echo '<option data-suspend="' . (($diploma->suspend) ? 0 : 1) . '" value="' . $diploma->id . '">' . $diploma->diploma_name . '</option>';
                    }
                    echo '</select></div>';
                    echo '<button class="btn btn-success input-circle" id="yottadiplomaMakeSuspend" type="submit">Make Suspend</button>';
                } else {
                    echo '<div class="alert alert-danger">Not having any diplomas</div>';
                }

            } else {
                echo '<div class="well">No Data</div>';
            }
        }

    }


    public function diploma()
    {

        $diplomasTargets = $this->getDiplomasTargets();
        $diplomasummary = $this->getdiplomateam();
        $diplomasStartDates = $this->getStartDates();

        return view('auth.diploma.view', compact('diplomasTargets', 'diplomasummary', 'diplomasStartDates'));
    }

    public function training_program()
    {

        $training_programsTargets = $this->getTrainingProgramsTargets();
        $training_programsummary = $this->gettraining_programteam();
        $training_programsStartDates = $this->getTrainingProgramStartDates();

        return view('auth.training_program.view', compact('training_programsTargets', 'training_programsummary', 'training_programsStartDates'));
    }

    public function annual_report_search(Request $request)
    {
        $data = $request->input();
        $transactions = ChargeTransaction::leftjoin('users', 'users.id', '=', 'charge_transaction.user_id')
            ->leftjoin('employees', 'employees.id', '=', 'charge_transaction.employee_id')
            ->select('charge_transaction.*', 'users.FullName AS username', 'users.Email AS email'
                , 'users.Mobile AS phone', 'employees.username AS employee_name');
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $transactions = $transactions->where('charge_transaction.id', '=', "$id");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['period']) && !empty($data['period'])) {
            $period = $data['period'];
            $transactions = $transactions->where('charge_transaction.period', 'LIKE', "%$period%");
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('charge_transaction.subscrip_type', 'LIKE', "%$subscribe_type%");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('charge_transaction.amount', 'LIKE', "%$amount%");
        }
        if (isset($data['currency']) && !empty($data['currency'])) {
            $currency = $data['currency'];
            $transactions = $transactions->where('charge_transaction.currency', 'LIKE', "%$currency%");
        }
        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }
        if (isset($data['created_time_from']) && !empty($data['created_time_from']) && isset($data['created_time_to']) && !empty($data['created_time_to'])) {
            $created_time_from = $data['created_time_from'];
            $created_time_to = $data['created_time_to'];
            $transactions = $transactions->whereBetween('charge_transaction.createtime', [$created_time_from . ' 00:00:00', $created_time_to . ' 23:59:59']);
        }
        if (isset($data['markets']) && !empty($data['markets'])) {
            $markets = $data['markets'];
            if($markets=='egypt' || $markets=='egyp'){
                $markets='egy';
            }
            $transactions = $transactions->where('charge_transaction.subscrip_country', 'LIKE', "%$markets%");
        }
        if (isset($data['end_time_from']) && !empty($data['end_time_from']) && isset($data['end_time_to']) && !empty($data['end_time_to'])) {
            $end_time_from = $data['end_time_from'];
            $end_time_to = $data['end_time_to'];
            $transactions = $transactions->whereBetween('charge_transaction.end_date', [$end_time_from . ' 00:00:00', $end_time_to . ' 23:59:59']);
        }

        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'charge_transaction.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'charge_transaction.id';
                break;
            case 1:
                $columnName = 'charge_transaction.id';
                break;
            case 2:
                $columnName = 'users.FullName';
                break;
            case 3:
                $columnName = 'users.Email';
                break;
            case 4:
                $columnName = 'users.Mobile';
                break;
            case 5:
                $columnName = 'charge_transaction.period';
                break;
            case 6:
                $columnName = 'charge_transaction.createtime';
                break;
            case 7:
                $columnName = 'charge_transaction.end_date';
                break;
            case 8:
                $columnName = 'charge_transaction.subscrip_country';
                break;
            case 9:
                $columnName = 'charge_transaction.subscrip_type';
                break;
            case 10:
                $columnName = 'charge_transaction.amount';
                break;
            case 11:
                $columnName = 'charge_transaction.currency';
                break;
            case 12:
                $columnName = 'employees.username';
                break;
        }

        $search = $data['search']['value'];
        if ($search) {
            $transactions = $transactions->where(function ($q) use ($search) {
                $q->where('users.FullName', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
                    ->orWhere('charge_transaction.period', 'LIKE', "%$search%")
                    ->orWhere('charge_transaction.subscrip_type', 'LIKE', "%$search%")
                    ->orWhere('charge_transaction.subscrip_country', 'LIKE', "%$search%")
                    ->orWhere('charge_transaction.amount', 'LIKE', "%$search%")
                    ->orWhere('charge_transaction.currency', 'LIKE', "%$search%")
                    ->orWhere('employees.username', 'LIKE', "%$search%")
                    ->orWhere('charge_transaction.id', '=', $search);
            });
        }
        if($request->segment(2)=='annual_report_export'){
            $transactions=$transactions->orderBy($columnName, $data['order'][0]['dir'])->get();
            $output = [ 'ID', Lang::get('main.user_name'), Lang::get('main.email'),
                Lang::get('main.phone'),
                Lang::get('main.period'),
                Lang::get('main.createdtime'),
                Lang::get('main.expired_time'),
                Lang::get('main.expired_time'),
                Lang::get('main.markets'),
                Lang::get('main.subscibe_type'),
                Lang::get('main.amount'),
                Lang::get('main.currency'),
                Lang::get('main.employee_name'),
            ];

            $filename = 'annual_report_'.time().'.csv';
            $handle = fopen($filename, 'w+');
            fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            fputcsv($handle, $output);
            foreach ($transactions as $transaction) {
                fputcsv($handle, [
                    $transaction->id,
                    $transaction->username,
                    $transaction->email,
                    $transaction->phone,
                    $transaction->period,
                    $transaction->createtime,
                    $transaction->end_date,
                    $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                    $transaction->subscrip_type,
                    $transaction->amount,
                    $transaction->currency,
                    $transaction->employee_name,
                ]);
            }
            fclose($handle);
            $headers = array(
                'Content-Type' => 'text/csv;',
                'Content-Disposition' => 'attachment; filename="'.$filename.'"'
            );
            return Response::download($filename, $filename, $headers);
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        $x = 1;
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $x,
                $transaction->id,
                $transaction->username,
                $transaction->email,
                $transaction->phone,
                $transaction->period,
                $transaction->createtime,
                $transaction->end_date,
                $transaction->subscrip_country == 'egy' ? 'Egypt ' : 'KSA',
                $transaction->subscrip_type,
                $transaction->amount,
                $transaction->currency,
                $transaction->employee_name,
                '',
            ];
            $x++;
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }


    public function getCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->input();
            $email = $params['email'];
            $type = isset($params['type']) ? $params['type'] : null;
            $data = null;
            $diplomas = Diplomas::where('published', 'yes')->select('id', 'name')->where('published', 'yes')->get();
            $result = AcademyUsers::where('Email', '=', $email)->orWhere('Mobile', 'LIKE', "%$email%")->first();
            if ($result) {
                $user_id = $result->id;
                $result->hasPhotoshopCourse = $this->hasCourse('photoshop', $user_id);
                $result->hasPMPCourse = $this->hasCourse('pmp', $user_id);
                $result->hasBlockException = $this->hasBlockException($user_id) ? 'Yes' : 'No';
                $data = $result;
            }
            if (isset($data)) {
                $htmlResponse = '';
                //print_r($data);
//                $curl = curl_init();
//                curl_setopt_array($curl, array(
//                    CURLOPT_URL => config('globals.user_data_link'),
//                    CURLOPT_RETURNTRANSFER => true,
//                    CURLOPT_ENCODING => "",
//                    CURLOPT_MAXREDIRS => 10,
//                    CURLOPT_TIMEOUT => 30,
//                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//                    CURLOPT_CUSTOMREQUEST => 'POST',
//                    CURLOPT_POSTFIELDS => ['email' => $data->Email],
//                    CURLOPT_HTTPHEADER => array(),
//                ));
//                $response = curl_exec($curl);
//
//                $err = curl_error($curl);
//                //error_log($response . '   error ' . $err, 3, "php.log");
//                curl_close($curl);
//                if ($err) {
//                    $htmlResponse.= "cURL Error #:" . $err;
//                } else {
//                    $response = json_decode($response);
//                    foreach ($response as $key => $value) {
//                        $htmlResponse .= $key . ' : ' . $value . '<br>';
//                    }
//                }
                $sponsor_id = ($data->sponsorId == 0 || $data->sponsorId == null) ? 100 : $data->sponsorId;
                $mlm = AcademyUsers::where('id', $sponsor_id)->first();
                $mlm_name = $mlm ? $mlm->FullName : '';
                $code = \Illuminate\Support\Facades\DB::connection('mysql2')->table('seven_days_free_otp')->where('user_id', $user_id)->whereNull('used_at')->first();
                echo '
                    <div class="user-data">
                       <div id="corporateDemoMessage"></div>
                       <div class="row">
                        <div class="col-lg-6">
                            <address style="text-align: left">';
                if (PerUser('dashboard_search')) {
                    echo '<strong>Full Name : <span id="fullname">' . $data->FullName . '</span></strong>
                                <br>
                                Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button data-clipboard-target="#email" id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                <br>
                                Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                <span id="country" class="hidden">' . $data->country . '</span>
                                <br>
                                Gender : '.(PerUser('dashboard_gender_change')?'<a  href="javascript:;" id="change-gender" data-params="{user_id:\'' . $data->id . '\'}"  data-url="' . URL('admin/editGender') . '" data-type="select" data-pk="1" data-original-title="Select Gender" data-value="' . $allData->gender . '">' . $data->gender . '</a>':'<span>'.$data->gender.'</span>').'
                                <br>
                                Expiration Date : ' . $data->PaymentExpirationDate . '
                                 <br>
                                Last Login Date : ' . $data->last_login_date . ' <br>
                                 ' . ($data->last_diploma_login_date ? 'Last Diploma Login Date : ' . $data->last_diploma_login_date . '<br>' : '') . '
                                 ' . ($data->last_mba_login_date ? 'Last Mba Login Date : ' . $data->last_mba_login_date . '<br>' : '') . '
                                 ' . ($data->last_new_mba_login_date ? 'Last New Mba Login Date : ' . $data->last_new_mba_login_date . '<br>' : '') . '
                                <br>
                                <hr/>';
                    if (in_array($data->leadsource, ['sevendaysfree', 'sevendaysfree2', 'sevendaysfreewebsite'])) {
                        if ($code) {
                            echo '<div style="color:black;">opt Code :<button class="btn btn-success btn-outline btn-circle  showTheCode" data-code="' . $code->otp . '">show Code</button></div><hr/>';
                        }
                    }
                    echo '
                                MLM ID : ' . $data->id . '
                                <br>
                                MLM Sponsor ID : ' . $sponsor_id . '
                                <br>
                                MLM Name : ' . $mlm_name;
                    echo '<hr/>';
                    if (PerUser('dashboard_block_count')) {
                        echo '<br>
                                   Block Count : <span id="blockCount">' . $data->block_count . '</span>';
                    }

                    if (PerUser('dashboard_block_to_date')) {
                        echo '<br>
                                   Block To Date : <span id="blockDateTo">' . $data->block_date_to . '</span>';
                    }
                    if (PerUser('dashboard_block_exception')) {
                        echo '<br>
                                   Block Exception : <span id="blockException">' . $data->hasBlockException . '</span>';
                    }
                    echo '<div style="margin-bottom: 20px;" class="clearfix"></div>';
                }
                if (PerUser('dashboard_reset_password')) {
                    echo '<button class="btn blue e3mb-btn-search" data-id="' . $data->id . '" id="resetPassword">Reset Password</button>';
                }

//                    $userData = $this->registry->admin->getUserDataLogin();
//                    if (in_array($userData->UserLevel, [4, 2])) {
                if (PerUser('dashboard_affiliate')) {
                    if ($data->is_affiliate == 0) {
                        echo '<button class="btn blue e3mb-btn-search" data-id="' . $data->id . '" id="addAffiliate">Affiliate</button>';
                    } else {
                        echo '<br/><span class="label label-info e3mb-label">User Is Affiliate</span>';
                    }
                }
//                    }
                //$isCSS = $this->registry->admin->isCSS();
                if (PerUser('dashboard_photoshop')) {
                    if (/*$isCSS && */
                    !$data->hasPhotoshopCourse) {
                        echo '<button id="addPhotoshopCourse" data-id="' . $data->id . '" class="btn blue e3mb-btn-search">Add Photoshop Course</button>';
                    } else {
                        echo '<br/><span class="label label-info e3mb-label">Has Photoshop Course</span>';
                    }
                }
                if (PerUser('dashboard_open_exams_exceptions')) {
                    $has = DB::connection('mysql2')->table("exams_exceptions")->where('user_id', $data->id)->count();
                    if (!$has) {
                        echo '<button id="addExamException" data-id="' . $data->id . '" class="btn btn-success">Exam Exception</button>';
                    }

                }
                if (PerUser('dashboard_pmp')) {
                    if (/*$isCSS &&*/
                    !$data->hasPMPCourse) {
                        echo '<button id="addPMPCourse" data-id="' . $data->id . '" class="btn blue e3mb-btn-search">Add PMP Course</button>';
                    } else {
                        echo '<span class="label label-info e3mb-label">Has PMP Course</span>';
                    }
                }
                echo '</address>
                            ';
                if ($data->user_type == 'corporate' && PerUser('dashboard_corporate_code')) {
                    echo '<div><div class="form-group col-lg-10 corporate"><label for="corporate_code">Corporate Code</label><input type="text" id="corporate_code" data-id="' . $data->id . '" class="form-control"></div><div class="col-lg-2"><button type="button" id="corporateDemo" style="margin-top: 25px;" class="btn btn-success ">Active</button></div></div>';
                }

                echo '
                    </div>
                    <div class="col-lg-6" style="color: #337ab7;">';

                if (PerUser('dashboard_search_crm')) {
                    echo $htmlResponse;
                }
                if (PerUser('dashboard_suspend')) {
                    if ($data->suspend == 0) {
                        echo '<button class="btn blue e3mb-btn-search" data-id="' . $data->id . '" id="suspend">Suspend</button>';
                    } else {
                        echo '<button class="btn blue e3mb-btn-search" data-id="' . $data->id . '" id="unSuspend">Reactive</button>';
                    }
                    echo '<div id="suspendMessage"></div>';
                }
                if (PerUser('dashboard_visit')) {
                    echo '<button class="btn blue e3mb-btn-search" data-id="' . $data->id . '" id="visitSite">Visit Site</button>';
                }
                if (PerUser('dashboard_demo_24_hours') || PerUser('dashboard_demo_48_hours') || PerUser('dashboard_demo_72_hours') || PerUser('dashboard_demo_1_week') || PerUser('dashboard_demo_1_month')) {
                    if ($addDemo = AddDemoLog::where('user_id', $data->id)->first()) {
                        echo $this->getHtmlIfAddDemoExist($addDemo);
                    } else {
                        echo '<div id="addDemoButtons"><hr><h2>Add Demo</h2>';
                        if (PerUser('dashboard_demo_24_hours')) {
                            echo '<button class="btn btn-success btn-circle addDemo" style="margin: 5px;" data-id="' . $data->id . '" data-type="24_hours">Add 24 H</button>';
                        }
                        if (PerUser('dashboard_demo_48_hours')) {
                            echo '<button class="btn btn-success btn-circle addDemo" style="margin: 5px;" data-id="' . $data->id . '" data-type="48_hours">Add 48 H</button>';
                        }
                        if (PerUser('dashboard_demo_72_hours')) {
                            echo '<button class="btn btn-success btn-circle addDemo" style="margin: 5px;" data-id="' . $data->id . '" data-type="72_hours">Add 72 H</button>';
                        }
                        if (PerUser('dashboard_demo_1_week')) {
                            echo '<button class="btn btn-success btn-circle addDemo" style="margin: 5px;" data-id="' . $data->id . '" data-type="1_week">Add 1 Week</button>';
                        }
                        if (PerUser('dashboard_demo_1_month')) {
                            echo '<button class="btn btn-success btn-circle addDemo" style="margin: 5px;" data-id="' . $data->id . '" data-type="1_month">Add 1 Month</button>';
                        }
                    }

                    echo '<hr></div>';
                }


                if ($type == 'companies_member_add') {
                    echo '                        <div class="col-sm-12">
                                                            <div class="form-group form-md-line-input has-info">
                                                                <select name="company_add_member_type" id="company_add_member_type"
                                                                        class="form-control sel2charge-for-client-sec form-filter edited">
                                                                    <option value="">Select Type</option>
                                                                    <option value="diploma">Diploma</option>
                                                                    <option value="mba">Mba</option>
                                                                    <option value="lifetime">Lifetime</option>
                                                                    <option value="liteversion">Lite Version</option>
                                                                </select>
                                                                <label for="company_add_member_type"></label>
                                                            </div>
                                                        </div>';

                    echo '                        <div id="company_add_member_diploma_block" class="col-sm-12 hidden">
                                                           <div class="form-group form-md-line-input has-info">
                                                                <select name="company_add_member_diploma" id="company_add_member_diploma"
                                                                       class="form-control sel2charge-for-client-sec form-filter edited">
                                                                    <option value="">Select Diploma</option> ';
                    foreach ($diplomas as $diploma) {
                        echo "<option  value='$diploma->id'>$diploma->name</option>";
                    }

                    echo '                                </select>
                                                                <label for="company_add_member_diploma"></label>
                                                            </div>
                                                        </div>';
                }
                if ($type == 'companies_admin_add') {
                    echo '                        <div class="col-sm-12">
                                                            <div class="form-group form-md-line-input has-info">
                                                                <select name="company_add_admin_type" id="company_add_admin_type"
                                                                        class="form-control sel2charge-for-client-sec form-filter edited">
                                                                    <option value="">Select Type</option>
                                                                    <option value="diploma">Diploma</option>
                                                                    <option value="mba">Mba</option>
                                                                    <option value="lifetime">Lifetime</option>
                                                                    <option value="liteversion">Lite Version</option>
                                                                </select>
                                                                <label for="company_add_admin_type"></label>
                                                            </div>
                                                        </div>';

                    echo '                        <div id="company_add_admin_diploma_block" class="col-sm-12 hidden">
                                                           <div class="form-group form-md-line-input has-info">
                                                                <select name="company_add_admin_diploma" id="company_add_admin_diploma"
                                                                       class="form-control sel2charge-for-client-sec form-filter edited">
                                                                    <option value="">Select Diploma</option> ';
                    foreach ($diplomas as $diploma) {
                        echo "<option  value='$diploma->id'>$diploma->name</option>";
                    }

                    echo '                                </select>
                                                                <label for="company_add_admin_diploma"></label>
                                                            </div>
                                                        </div>';
                }

                echo '</div>
                     </div>
                    <div class="clearfix"></div>
                </div>';
            } else {
                echo 0;
            }
        }
    }

    public function dashboard_yotta()
    {
        $diplomas = MedicalDiplomas::select('name', 'ksa_price', 'tool_eg_price', 'tool_ksa_price', 'id')
            //->where('id', '=', '2')
            ->get();

        return view('auth.dashboard_yotta', compact('diplomas'));

    }

    public function getYottaCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->input();
            $email = $params['email'];
            $type = isset($params['type']) ? $params['type'] : null;
            $data = null;
            $result = AcademyUsers::where('Email', '=', $email)->orWhere('Mobile', 'LIKE', "%$email%")->first();

            if ($result) {
                $user_id = $result->id;
                $data = $result;
            }
            if (isset($data)) {
                $htmlResponse = '';
                //print_r($data);
//                $curl = curl_init();
//                curl_setopt_array($curl, array(
//                    CURLOPT_URL => config('globals.user_data_link'),
//                    CURLOPT_RETURNTRANSFER => true,
//                    CURLOPT_ENCODING => "",
//                    CURLOPT_MAXREDIRS => 10,
//                    CURLOPT_TIMEOUT => 30,
//                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//                    CURLOPT_CUSTOMREQUEST => 'POST',
//                    CURLOPT_POSTFIELDS => ['email' => $data->Email],
//                    CURLOPT_HTTPHEADER => array(),
//                ));
//                $response = curl_exec($curl);
//
//                $err = curl_error($curl);
//                //error_log($response . '   error ' . $err, 3, "php.log");
//                curl_close($curl);
//                if ($err) {
//                    echo "cURL Error #:" . $err;
//                } else {
//                    $response = json_decode($response);
//                    foreach ($response as $key => $value) {
//                        $htmlResponse .= $key . ' : ' . $value . '<br>';
//                    }
//                }
                $sponsor_id = ($data->sponsorId == 0 || $data->sponsorId == null) ? 100 : $data->sponsorId;
                $mlm = AcademyUsers::where('id', $sponsor_id)->first();
                $mlm_name = $mlm ? $mlm->FullName : '';
                $code = \Illuminate\Support\Facades\DB::connection('mysql2')->table('seven_days_free_otp')->where('user_id', $user_id)->whereNull('used_at')->first();
                echo '
<h2>Academy User</h2>
                    <div class="user-data">
                       <div id="corporateDemoMessage"></div>
                       <div class="row">
                        <div class="col-lg-6">
                            <address style="text-align: left">';
                if (PerUser('dashboard_search')) {
                    echo '<strong>Full Name : <span id="fullname">' . $data->FullName . '</span></strong>
                                <br>
                                Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button data-clipboard-target="#email" id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                <br>
                                Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                <span id="country" class="hidden">' . $data->country . '</span>
                                <br>
                                Expiration Date : ' . $data->PaymentExpirationDate . '
                                 <br>
                                Last Login Date : ' . $data->last_login_date . ' <br>
                                 ' . ($data->last_diploma_login_date ? 'Last Diploma Login Date : ' . $data->last_diploma_login_date . '<br>' : '') . '
                                 ' . ($data->last_mba_login_date ? 'Last Mba Login Date : ' . $data->last_mba_login_date . '<br>' : '') . '
                                 ' . ($data->last_new_mba_login_date ? 'Last New Mba Login Date : ' . $data->last_new_mba_login_date . '<br>' : '') . '
                                <br>
                                <hr/>';
                    if (in_array($data->leadsource, ['sevendaysfree', 'sevendaysfree2', 'sevendaysfreewebsite'])) {
                        if ($code) {
                            echo '<div style="color:black;">opt Code :<button class="btn btn-success btn-outline btn-circle  showTheCode" data-code="' . $code->otp . '">show Code</button></div><hr/>';
                        }
                    }
                    echo '
                                MLM ID : ' . $data->id . '
                                <br>
                                MLM Sponsor ID : ' . $sponsor_id . '
                                <br>
                                MLM Name : ' . $mlm_name;
                    echo '<hr/>';

                    echo '<div style="margin-bottom: 20px;" class="clearfix"></div>';
                }


                echo '</address>
                            ';


                echo '
                    </div>
                    <div class="col-lg-6" style="color: #337ab7;">';

                if (PerUser('dashboard_search_crm')) {
                    echo $htmlResponse;
                }

                echo '</div>
                     </div>
                    <div class="clearfix"></div>
                </div>';
            } else {
                echo '';
            }
            $AcademyUsers = new AcademyUsers;
            $AcademyUsers->setConnection('mysql3');

            $result1 = $AcademyUsers->where('Email', '=', $email)->orWhere('Mobile', 'LIKE', "%$email%")->first();
//            $query="select * from users where email='$email' AND  Mobile like %$email%
//                    ORDER BY id DESC limit 1";
//
//            $result1=self::startYottaQuery($query);
            if ($result1) {
//                $result1=$result1->fetch_object();
                $user_id = $result1->id;
                $data1 = $result1;

            }
            if (isset($data1)) {
                $htmlResponse1 = '';
                //print_r($data);
//                $curl = curl_init();
//                curl_setopt_array($curl, array(
//                    CURLOPT_URL => config('globals.yotta_user_data_link'),
//                    CURLOPT_RETURNTRANSFER => true,
//                    CURLOPT_ENCODING => "",
//                    CURLOPT_MAXREDIRS => 10,
//                    CURLOPT_TIMEOUT => 30,
//                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//                    CURLOPT_CUSTOMREQUEST => 'POST',
//                    CURLOPT_POSTFIELDS => ['email' => $data1->Email],
//                    CURLOPT_HTTPHEADER => array(),
//                ));
//                $response = curl_exec($curl);
//
//                $err = curl_error($curl);
//                //error_log($response . '   error ' . $err, 3, "php.log");
//                curl_close($curl);
//                if ($err) {
//                    echo "cURL Error #:" . $err;
//                } else {
//                    $response = json_decode($response);
//                    foreach ($response as $key => $value) {
//                        $htmlResponse1 .= $key . ' : ' . $value . '<br>';
//                    }
//                }
                $sponsor_id = ($data->sponsorId == 0 || $data->sponsorId == null) ? 100 : $data->sponsorId;
//                $mlm="select * from users where id='$sponsor_id'
//                    ORDER BY id DESC limit 1";
//
//                $mlm=self::startYottaQuery($mlm);
                $mlm = new AcademyUsers;
                $mlm->setConnection('mysql3');
                $mlm = $mlm->where('id', $sponsor_id)->first();
                $mlm_name = $mlm ? $mlm->FullName : '';
                echo '
<h2>Yotta User</h2>
                    <div class="user-data">
                       <div id="corporateDemoMessage"></div>
                       <div class="row">
                        <div class="col-lg-6">
                            <address style="text-align: left">';
                if (PerUser('dashboard_search')) {
                    echo '<strong>Full Name : <span id="fullname1">' . $data1->FullName . '</span></strong>
                                <br>
                                Email : <a href="mailto:' . $data1->Email . '"><span id="email1">' . $data1->Email . '</span></a> <button data1-clipboard-target="#email" id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                <br>
                                Mobile : <span id="mobile1">' . $data1->Mobile . '</span>
                                <span id="country1" class="hidden">' . $data1->country . '</span>
                                <br>
                                Expiration Date : ' . $data1->PaymentExpirationDate . '
                                 <br>
                                Last Login Date : ' . $data1->last_login_date . ' <br>
                                Last Diploma Login ' . $data1->last_diploma_login_date . ' <br>
                                 ' . ($data1->last_mba_login_date ? 'Last Mba Login Date : ' . $data1->last_mba_login_date . '<br>' : '') . '
                                 ' . ($data1->last_new_mba_login_date ? 'Last New Mba Login Date : ' . $data1->last_new_mba_login_date . '<br>' : '') . '
                                <br>
                                <hr/>';
                    echo '
                                MLM ID : ' . $data1->id . '
                                <br>
                                MLM Sponsor ID : ' . $sponsor_id . '
                                <br>
                                MLM Name : ' . $mlm_name;
                    echo '<hr/>';
                    echo '<button class="btn blue e3mb-btn-search" data-id="' . $data1->id . '" id="yottaresetPassword">Reset Password</button>';


                    echo '<div style="margin-bottom: 20px;" class="clearfix"></div>';
                }


                echo '</address>
                            ';


                echo '
                    </div>
                    <div class="col-lg-6" style="color: #337ab7;">';

                if (PerUser('dashboard_search_crm')) {
                    echo $htmlResponse1;
                }


                echo '</div>
                     </div>
                    <div class="clearfix"></div>
                </div>';
            } else {
                echo '';
            }
        }
    }

    public function resetPassword(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $id = $request->input()['id'];
            $result = AcademyUsers::select('id', 'Mobile as mobile')->where('id', '=', $id)->first();
            if ($result) {
                $mobile = $result->mobile;
                $update_data = ['Password' => $mobile];
                AcademyUsers::where('id', '=', $id)->update($update_data);
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'users', $id, json_encode($update_data));
                $data = true;
            } else {
                $data = false;
            }
            if ($data) {
                $errorMessage = 'The password Now is the Mobile Number';
                return view('auth.message.success_message', compact('errorMessage'));
            }
        }
    }

    public function yottaresetPassword(Request $request)
    {

        if ($request->isMethod('post') && $request->ajax()) {
            $id = $request->input()['id'];
            $result = DB::connection('mysql3')->table('users')->select('id', 'Mobile as mobile')->where('id', '=', $id)->first();
            if ($result) {
                $mobile = $result->mobile;
                $update_data = ['Password' => $mobile];
                DB::connection('mysql3')->table('users')->where('id', '=', $id)->update($update_data);
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'users', $id, json_encode($update_data));
                $data = true;
            } else {
                $data = false;
            }
            if ($data) {
                $errorMessage = 'The password Now is the Mobile Number';
                return view('auth.message.success_message', compact('errorMessage'));
            }
        }
    }


    public function makeUserSuspend(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $suspend = $data['suspend'];
        if ($id) {
            $user = AcademyUsers::find($id);
            if ($user->suspend == $suspend) {
                echo '<div class="alert alert-danger">The User Is Allredy Has This Action</div>';
            } else {
                $chargeTransaction = ChargeTransaction::where('user_id', $user->id)->orderBy('id', 'DESC')->first();
                $date = date('Y-m-d H:i:s');
                $user_id = $user->id;
                $type = ($suspend) ? 'suspend' : 'unsuspend';
                $user_suspend = new UsersSuspend();
                $user_suspend->type = $type;
                $user_suspend->user_id = $user_id;
                $user_suspend->suspendtime = $date;
                $user_suspend->createtime = $date;
                $user_suspend->save();
                log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'users_suspend', $user_suspend->id, json_encode($user_suspend));

                $suspend_date = ($suspend) ? date('Y-m-d H:i:s') : NULL;
                $PaymentExpirationDate = "";
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($user->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;
                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($user->PaymentExpirationDate)));
                    //$customQuery = ",PaymentExpirationDate='$PaymentExpirationDate'";
                    if ($chargeTransaction) {
                        $chargeTransaction->end_date = $PaymentExpirationDate;
                        $chargeTransaction->save();
                        log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'charge_transaction', $chargeTransaction->id, json_encode($chargeTransaction));
                    }
                }
                $user->suspend = $suspend;
                $user->suspend_date = $suspend_date;
                $log_data = ['suspend' => $suspend, 'suspend_date' => $suspend_date];
                if ($PaymentExpirationDate != '') {
                    $user->PaymentExpirationDate = $PaymentExpirationDate;
                    $log_data['PaymentExpirationDate'] = $PaymentExpirationDate;
                }
                $user->save();
                //log_user_action(Auth::user()->id,Auth::user()->username,'update','users',$id,json_encode($log_data));

                echo '<div class="alert alert-success">The User has ' . $type . '</div>';
//                self::suspend_crm(['email' => $user->Email, 'suspend' => $suspend, 'suspend_date' => $suspend_date]);
            }
        }
    }

    public function makeCompanySuspend(Request $request)
    {
        $data = $request->all();
        $id = $data['company_id'];
        if ($id) {
            $company = Companies::findOrFail($id);
            $date = date('Y-m-d H:i:s');
            $company_id = $company->id;
            $type = $company->suspend ? 'unsuspend' : 'suspend';
            $company->suspend = !$company->suspend;
            $end_date = "";
            if ($type == 'unsuspend') {
                $end_date = strtotime(date('Y-m-d H:i:s')) - strtotime($company->suspend_date);
                $days = round($end_date / 86400);
                $end_date = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($company->expiredDate)));
            }
            if ($type == 'suspend') {
                $company->suspend_date = $date;
            } else {
                $company->unsuspend_date = $date;
                //$transaction->suspend_date = null;
            }
            if ($end_date != '') {
                $company->expiredDate = $end_date;
            }
            if ($company->save()) {
                $company_suspend = new CompaniesSuspend();
                $company_suspend->type = $type;
                $company_suspend->company_id = $company_id;
                $company_suspend->suspendtime = $date;
                $company_suspend->createtime = $date;
                $company_suspend->save();
                log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'companies_suspend', $company_suspend->id, json_encode($company_suspend));
            }
            $msg = $company->suspend == 1 ? 'UnSuspend' : 'Suspend';
            $return_data['msg'] = $msg;
            return response()->json($return_data);
        }
    }

    public function visitSite(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        if ($id) {
            $user = AcademyUsers::find($id);
            $date = date('Y-m-d H:i:s');
            $user_id = $user->id;
            $user_email = $user->Email;
            $token = encode("$user_id,$user_email");
            $url = e3mURL("slogin/$token");
            echo $url;

        }
    }

    public function removeSessionUser(Request $request)
    {
        $data = $request->all();
        $session_id = $data['session_id'];
        if ($session_id) {
            $session = SessionUsers::findOrFail($session_id);
            $date = date('Y-m-d H:i:s');
            $session->deleted_at = $date;
            $session->deleted_support_by = Auth::user()->id;
            $session->save();
            log_user_action(Auth::user()->id, Auth::user()->username, 'delete', 'session_users', $session->id, json_encode($session));
            return response()->json(['deleted_at' => $session->deleted_at]);
        }
    }

    public function unblockUser(Request $request)
    {
        $data = $request->all();
        $email = $data['email'];
        if ($email) {
            $user = AcademyUsers::where('Email', '=', "$email")->first();
            if ($user) {
                $user->block_date_to = null;
                $user->block_count = $user->block_count - 1;
                if ($user->save()) {
                    log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'users', $user->id, json_encode($user));
                    return response()->json(['success' => true, 'msg' => 'User unblocked successfully']);
                }
            }

        }
        return response()->json(['success' => false, 'msg' => 'Error Occured try again']);
    }

    public function blockMakeException(Request $request)
    {
        $data = $request->all();
        $email = $data['email'];
        if ($email) {
            $user = AcademyUsers::where('Email', '=', "$email")->first();
            if ($user) {
                if (!$this->hasBlockException($user->id)) {
                    $res = BlockUsersExceptions::where('user_id', '=', $user->id)->first();
                    if (!$res) {
                        $exception_user = new BlockUsersExceptions();
                        $exception_user->user_id = $user->id;
                        $exception_user->add_support_by = Auth::user()->id;
                        $exception_user->createtime = date('Y-m-d H:i:s');
                        if ($exception_user->save()) {
                            log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'block_users_exceptions', $user->id, json_encode($user));
                            return response()->json(['success' => true, 'msg' => 'Exception Made successfully']);
                        }
                    }
                }
            }

        }
        return response()->json(['success' => false, 'msg' => 'Error Occured try again']);
    }

    public function suspendLiteVersion(Request $request)
    {
        $data = $request->all();
        $transaction_id = $data['transaction_id'];
        if ($transaction_id) {
            $transaction = LiteVersionChargeTransaction::findOrFail($transaction_id);
            $date = date('Y-m-d H:i:s');
            $type = $transaction->suspend ? 'unsuspend' : 'suspend';
            $transaction->suspend = !$transaction->suspend;
            /*
             * added
             */
            $end_date = "";
            if ($type == 'unsuspend') {
                $end_date = strtotime(date('Y-m-d H:i:s')) - strtotime($transaction->suspend_date);
                $days = round($end_date / 86400);
                $end_date = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($transaction->end_date)));
            }
            if ($type == 'suspend') {
                $transaction->suspend_date = $date;
                //$transaction->unsuspend_date = null;

            } else {
                $transaction->unsuspend_date = $date;
                //$transaction->suspend_date = null;
            }
            $return_data = [];
            if ($end_date != '') {
                $transaction->end_date = $end_date;
                $return_data['end_date'] = $end_date;
            }
            if ($transaction->save()) {
                $user_suspend = new UsersSuspendLiteVersion();
                $user_suspend->type = $transaction->suspend ? 'suspend' : 'unsuspend';
                $user_suspend->user_id = $transaction->user_id;
                $user_suspend->suspendtime = $date;
                $user_suspend->createtime = $date;
                $user_suspend->save();
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'lite_version_charge_transaction', $transaction->id, json_encode($transaction));
            }
            $msg = $transaction->suspend == 1 ? 'UnSuspend' : 'Suspend';
            $return_data['msg'] = $msg;
            return response()->json($return_data);
        }
    }

    public function suspendChargeTransaction(Request $request)
    {
        $data = $request->all();
        $transaction_id = $data['transaction_id'];
        if ($transaction_id) {
            $transaction = ChargeTransaction::findOrFail($transaction_id);
            $date = date('Y-m-d H:i:s');
            $type = $transaction->suspend ? 'unsuspend' : 'suspend';
            $transaction->suspend = !$transaction->suspend;
            /*
             * added
             */
            $end_date = "";
            if ($type == 'unsuspend') {
                $end_date = strtotime(date('Y-m-d H:i:s')) - strtotime($transaction->suspend_date);
                $days = round($end_date / 86400);
                $end_date = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($transaction->end_date)));
            }
            if ($type == 'suspend') {
                $transaction->suspend_date = $date;
                //$transaction->unsuspend_date = null;

            } else {
                $transaction->unsuspend_date = $date;
                //$transaction->suspend_date = null;
            }
            $return_data = [];
            if ($end_date != '') {
                $transaction->end_date = $end_date;
                $return_data['end_date'] = $end_date;
            }
            if ($transaction->save()) {
                $user_suspend = new UsersSuspendChargeTransaction();
                $user_suspend->type = $transaction->suspend ? 'suspend' : 'unsuspend';
                $user_suspend->user_id = $transaction->user_id;
                $user_suspend->suspendtime = $date;
                $user_suspend->createtime = $date;
                $user_suspend->save();
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'lite_version_charge_transaction', $transaction->id, json_encode($transaction));
            }
            $msg = $transaction->suspend == 1 ? 'UnSuspend' : 'Suspend';
            $return_data['msg'] = $msg;
            return response()->json($return_data);
        }
    }

    public static function suspend_crm($data)
    {
//        $url = config('globals.suspend_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//
//        $json_response = curl_exec($curl);
//        //echo $json_response;
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);

    }

    public function addPhotoshopCourse(Request $request)
    {
        $user_id = $request->all()['user_id'];
        $result = AcademyUsers::find($user_id);
        if (count($result)) {
            $r = PhotoshopCourseUsers::where('user_id', '=', $user_id)->first();
            if (!$r) {
                $pcu = new PhotoshopCourseUsers();
                $pcu->user_id = $user_id;
                if ($pcu->save()) {
                    log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'photoshop_course_users', $pcu->id, json_encode($pcu));
                }
                $this->addCourseException($user_id, 108, 'Photoshop Course Add From Support');
                $message = '<div class="alert alert-success">Success Add Photoshop</div>';
//                header('Content-Type:application/json');
//                echo json_encode(['success' => true, 'message' => $message]);
                return response()->json(['message' => $message, 'success' => true]);
            } else {
                $message = '<div class="alert alert-danger">Already Has Course</div>';
//                header('Content-Type:application/json');
//                echo json_encode(['success' => false, 'message' => $message]);
                return response()->json(['message' => $message, 'success' => false]);

            }

        } else {
            $message = '<div class="alert alert-danger">Error User</div>';
//            header('Content-Type:application/json');
//            echo json_encode(['success' => false, 'message' => $message]);
            return response()->json(['message' => $message, 'success' => false]);
        }
    }

    public function addPMPCourse(Request $request)
    {
        $user_id = $request->all()['user_id'];
        $result = AcademyUsers::find($user_id);
        if (count($result)) {
            $r = PmpCourseUsers::where('user_id', '=', $user_id)->first();
            if (!$r) {
                $pcu = new PmpCourseUsers();
                $pcu->user_id = $user_id;
                if ($pcu->save()) {
                    log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'pmp_course_users', $pcu->id, json_encode($pcu));
                }
                $this->addCourseException($user_id, 123, 'Pmp Course Add From Support');
                $message = '<div class="alert alert-success">Success Add PMP</div>';
//                header('Content-Type:application/json');
//                echo json_encode(['success' => true, 'message' => $message]);
                return response()->json(['message' => $message, 'success' => true]);
            } else {
                $message = '<div class="alert alert-danger">Already Has Course</div>';
//                header('Content-Type:application/json');
//                echo json_encode(['success' => false, 'message' => $message]);
                return response()->json(['message' => $message, 'success' => false]);

            }

        } else {
            $message = '<div class="alert alert-danger">Error User</div>';
//            header('Content-Type:application/json');
//            echo json_encode(['success' => false, 'message' => $message]);
            return response()->json(['message' => $message, 'success' => false]);
        }
    }

    public function saveNewPhone(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $oldPhone = $params['oldPhone'];
            $newPhone = $params['newPhone'];
            $countryID = $params['countryID'];
            $sendSMSEmail = $params['sendSMSEmail'];
            $user_id = $params['user_id'];
            $data = $this->getclientdata($oldPhone);
            if (isset($data->id)) {
                if ($oldPhone != $newPhone) {
                    $save = $this->savePhone($oldPhone, $newPhone, $user_id, $countryID, $sendSMSEmail);
                    if ($save) {
                        if ($sendSMSEmail && $sendSMSEmail == 1) {
                            $this->sendwelcomemail($data->Email);
                        }
                        $errorMessage = self::$SUCCESS_PHONE_CHANGE_MESSAGE;
                        return view('auth.message.success_message', compact('errorMessage'));
                    } else {
                        $errorMessage = self::$ERROR_CHANGE_PHONE_MESSAGE;
                        return view('auth.message.error_message', compact('errorMessage'));
                    }
                } else {
                    $errorMessage = self::$ERROR_PHONE_CHANGE_SAME_MESSAGE;
                    return view('auth.message.error_message', compact('errorMessage'));
                }
            } else {
                $errorMessage = self::$NO_DATA;
                return view('auth.message.error_message', compact('errorMessage'));
            }
        }
    }

    public function saveNewEmail(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $oldEmail = $params['oldEmail'];
            $newEmail = $params['newEmail'];
            $sendSMSEmail = $params['sendSMSEmail'];
            $data = $this->getclientdata($oldEmail);
            if (isset($data->id)) {
                if (filter_var($newEmail, FILTER_VALIDATE_EMAIL)) {
                    if ($oldEmail != $newEmail) {
                        $save = $this->saveEmail($oldEmail, $newEmail, $data->id, $sendSMSEmail);
                        if ($save) {
                            if ($sendSMSEmail && $sendSMSEmail == 1) {
                                //$this->sendwelcomemail($newEmail);
                            }
                            $errorMessage = self::$SUCCESS_EMAIL_CHANGE_MESSAGE;
                            return view('auth.message.success_message', compact('errorMessage'));
                        } else {
                            $errorMessage = self::$ERROR_CHANGE_EMAIL_MESSAGE;
                            return view('auth.message.error_message', compact('errorMessage'));
                        }

                    } else {
                        $errorMessage = self::$ERROR_EMAIL_CHANGE_SAME_MESSAGE;
                        return view('auth.message.error_message', compact('errorMessage'));
                    }
                } else {
                    $errorMessage = self::$ERROR_INVALID_EMAIL_MESSAGE;
                    return view('auth.message.error_message', compact('errorMessage'));
                }
            } else {
                $errorMessage = self::$NO_DATA;
                return view('auth.message.error_message', compact('errorMessage'));
            }
        }
    }

    public function lifeTimeAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $user_mail = $params['email'];
            $employee_id = $params['employee_id'];
            $type = $params['type'];
            $created_time = date("Y-m-d");
            $data = $this->lifeTimeCreate($user_mail, $employee_id, $created_time, $type);
            if ($data) {
                // $this->sendwelcomemail($username);
                $errorMessage = self::$SUCCESS_SEND_CREDENTIALS_MESSAGE;
                return view('auth.message.success_message', compact('errorMessage'));
            } else {
                $errorMessage = SELF::$ERROR_EMAIL_EXIST_MESSAGE;
                return view('auth.message.error_message', compact('errorMessage'));
            }
        }
    }

    public function creatembalink(Request $request)
    {
        $this->createonlinelink($request);
    }

//    public function createonlinelink(Request $request)
//    {
//        $params = $request->all();
//        $onlinetype = isset($params['onlinetype'])?$params['onlinetype']:'';
//        $onlineemail = isset( $params['onlineemail'])? $params['onlineemail']:'';
//        $onlineperiod = isset( $params['onlineperiod'])? $params['onlineperiod']:'';
//        $currency = isset($params['onlinecurrency'])?$params['onlinecurrency']:'';
//        $employee_id = isset($params['employee_id'])?$params['employee_id']:'';
//        $lifetime = '';
//        $salePrice = 0;
//        $salePrice = isset($params['online_price'])?$params['online_price']:'';
//        if (!$salePrice) {
//            if ($onlineperiod == 3) {
//                $salePrice = 136;
//            } else if ($onlineperiod == 6) {
//                $salePrice = 136;
//            } else if ($onlineperiod == 12) {
//                $salePrice = 240;
//            } else if ($onlineperiod == 'lifetime') {
//                $salePrice = 370;
//            } else if ($onlineperiod == 'mba') {
//                $salePrice = 1200;
//            }
//        }
//        if ($onlineperiod == 'lifetime') {
//            $onlineperiod = 12;
//            $lifetime = '-lifetime';
//        } else if ($onlineperiod == 'mba') {
//            $onlineperiod = 12;
//            $lifetime = '-mba';
//        }
//        $onlineemail = str_replace('-', '%20', $onlineemail);
//        $en_email = $onlineemail . '-0-' . $salePrice . '-' . $onlineperiod . '-offer';
//        if ($lifetime != '') {
//            $en_email = $en_email . $lifetime;
//        }
//        $en_email = Encryption::encode($en_email);
//        // echo $project_id;
//        if ($onlinetype == 'winwin') {
//            $subscrip_link = config('globals.winwinbiz_subscribe_link');
//            $link = $subscrip_link . $en_email;
//            echo "<a target='_blank' href='$link'>$link</a>";
//        } else {
//            $payment_id = $this->addAlahlyPayment($onlineemail, $salePrice, $currency, $onlineperiod, $employee_id);
////            $link = "https://e3melbusness.com/?page=alahlypayment&id=" . Encryption::encode($payment_id);
////            $link = "http://localhost/e3melbusinessV4/?page=alahlypayment&id=" . Encryption::encode($payment_id);
//            $link = "http://localhost/e3melbusinessV4/?page=alahlypayment&id=" . Encryption::encode($payment_id);
//            echo "<a target='_blank' href='$link'>$link</a> <br><span>ID: $payment_id</span>";
//
//        }
//
//
//    }
    public function createonlinelink(Request $request)
    {
        $params = $request->all();
        $subscrip_link = config('globals.winwinbiz_subscribe_link');
        $onlineemail = isset($params['onlineemail']) ? $params['onlineemail'] : '';
        $onlineperiod = isset($params['onlineprice_period']) ? $params['onlineprice_period'] : '';
        $onlineprice_period_type = $request->onlineprice_period_type;
        $action = (isset($params['onlineprice_action']) && $onlineprice_period_type != 'other') ? $params['onlineprice_action'] : '';

        $lifetime = '';
        $salePrice = 0;
        $salePrice = isset($params['online_price']) ? $params['online_price'] : '';
        if ($salePrice == '') {
            if ($onlineperiod == 3) {
                $salePrice = 136;
            } else if ($onlineperiod == 6) {
                $salePrice = 136;
            } else if ($onlineperiod == 12) {
                $salePrice = 240;
            } else if ($onlineprice_period_type == 'lifetime') {
                $salePrice = 370;
            } else if ($onlineprice_period_type == 'mba') {
                $salePrice = 1200;
            }
        }
//        if($onlineprice_period_type=='mba'){
////            $onlineperiod=24;
//            $lifetime='-mba';
//        }
        if ($onlineprice_period_type == 'lifetime') {
//            $onlineperiod=12;
            $lifetime = '-lifetime';
        } else if ($onlineprice_period_type == 'mba') {
//            $onlineperiod=24;
            $lifetime = '-mba';
        } else if ($onlineprice_period_type == 'other') {
//            $onlineperiod=24;
            $lifetime = '-other';
        }

        $paymentType = $request->payment_type;
        switch ($onlineprice_period_type) {
            case 'mba':
                $subscribe = 'mba_charge_transaction';
//                    $onlineperiod=24;
                break;
            case 'lifetime':
                $subscribe = 'lifetime';
//                    $onlineperiod=12;
                break;
            case 'other':
                $subscribe = 'other';
//                    $onlineperiod=12;
                break;
            default:
                $subscribe = 'charge_transaction';
        }
        $onlinePaymentLinkGenerated=OnlinePaymentLinkGenerated::create([
            'created_by'=>auth()->id(),
            'email'=>$onlineemail,
            'period'=>$onlineemail,
            'payment_type'=>$paymentType,
            'currency'=>$paymentType == 'alahly'?'USD':'EGP',
            'subscribe'=>$action,
            'action'=>$salePrice,
            'amount'=>$salePrice,
            'all_data'=>json_encode($request->input()),
        ]);
        if ($paymentType == 'alahly') {
//            if($onlineprice_period_type=='mba'){
//                $subscribe='mba_charge_transaction';
//                $onlineperiod=24;
//            }
            $data = [
                'email' => $onlineemail,
                'amount' => $salePrice,
                'currency' => 5,
                'percentage' => 0,
                'subscribe' => $subscribe,
                'period' => $onlineperiod,
                'action' => $action,
                'employee_id' => Auth::user()->id,
            ];
            $link=self::genereateAlahlyOnlineLink($data);
            OnlinePaymentLinkGenerated::where('id',$onlinePaymentLinkGenerated->id)->update(['link'=>$link]);
            echo$link;
        } elseif ($paymentType == 'alahly_eg') {
//            if($onlineprice_period_type=='mba'){
//                $subscribe='mba_charge_transaction';
//                $onlineperiod=24;
//            }
            $data = [
                'email' => $onlineemail,
                'amount' => $salePrice,
                'currency' => 1,
                'percentage' => 0,
                'subscribe' => $subscribe,
                'period' => $onlineperiod,
                'action' => $action,
                'employee_id' => Auth::user()->id,
            ];
            $link=self::genereateAlahlyOnlineLink($data);
            OnlinePaymentLinkGenerated::where('id',$onlinePaymentLinkGenerated->id)->update(['link'=>$link]);
            echo$link;
        }elseif($paymentType=='paymob'){
            $data = [
                'email' => $onlineemail,
                'amount' => $salePrice,
                'currency' => 1,
                'percentage' => 0,
                'subscribe' => $subscribe,
                'period' => $onlineperiod,
                'action' => $action,
                'employee_id' => Auth::user()->id,
            ];
            $link=self::genereatePaymobOnlineLink($data);
            OnlinePaymentLinkGenerated::where('id',$onlinePaymentLinkGenerated->id)->update(['link'=>$link]);
            echo$link;
        } else {
            $onlineemail = str_replace('-', '%20', $onlineemail);
            $en_email = $onlineemail . '-0-' . $salePrice . '-' . $onlineperiod . '-offer';
            if ($lifetime != '') {
                $en_email = $en_email . $lifetime;
            }
            //$en_email=Encryption::encode($en_email);
            $en_email = encode($en_email);
            // echo $project_id;
            $link = $subscrip_link . $en_email;
            OnlinePaymentLinkGenerated::where('id',$onlinePaymentLinkGenerated->id)->update(['link'=>$link]);
            echo "<a  target='_blank' href='$link'>$link</a>";
        }


    }

    public function GeneratePaymentLink(Request $request)
    {
        $params = $request->all();
        $subscrip_link = config('globals.winwinbiz_subscribe_link');
        $onlineemail = isset($params['email']) ? $params['email'] : '';
        $onlineperiod = isset($params['period']) ? $params['period'] : '';
        $percentage = isset($params['percentage']) ? $params['percentage'] : '';
        $action = isset($params['onlineprice_action']) ? $params['onlineprice_action'] : '';
        $salePrice = 0;

        if ($onlineperiod == 3) {
            //$salePrice=67;
            $salePrice = 150;
        } else if ($onlineperiod == '6-800') {
            //$salePrice=110;
            $salePrice = 213;
        } else if ($onlineperiod == '6-900') {
            //$salePrice=110;
            $salePrice = 240;
        } else if ($onlineperiod == 12) {
            //$salePrice=144;
            $salePrice = 320;
        }
        $percentage = ($percentage / 100) * $salePrice;
        $salePrice = ceil($salePrice - $percentage);

        /*  if ($onlineperiod==3){
              $salePrice=60;
          }
          else if ($onlineperiod==6){
              $salePrice=90;
          }
          else if ($onlineperiod==12){
              $salePrice=120;
          }*/
        $paymentType = $request->payment_type;
        if ($paymentType == 'alahly') {
            $data = [
                'email' => $onlineemail,
                'amount' => $salePrice,
                'currency' => 5,
                'percentage' => $percentage,
                'subscribe' => 'charge_transaction',
                'period' => $onlineperiod,
                'action' => $action,
                'employee_id' => Auth::user()->id,
            ];
            self::genereateAlahlyOnlineLink($data);
        } elseif ($paymentType == 'alahly_eg') {
            $data = [
                'email' => $onlineemail,
                'amount' => $salePrice,
                'currency' => 1,
                'percentage' => $percentage,
                'subscribe' => 'charge_transaction',
                'period' => $onlineperiod,
                'action' => $action,
                'employee_id' => Auth::user()->id,
            ];
            self::genereateAlahlyOnlineLink($data);
        } else {
            $onlineemail = str_replace('-', '%20', $onlineemail);
            $en_email = $onlineemail . '-0-' . $salePrice . '-' . $onlineperiod . '-offer';

            $en_email = encode($en_email);
            // echo $project_id;
            $link = $subscrip_link . $en_email;
            echo "<a  target='_blank' href='$link'>$link</a>";
        }

    }
    public function genereatePaymobOnlineLink($data){
        $url = e3mURL('?page=PaymobPayment&action=generateOnlineLink');
        $content = "";
        foreach ($data as $key => $value) {
            $content .= $key . '=' . $value . '&';
        }
        //echo $content;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
        $json_response = curl_exec($curl);
        return $json_response;
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    }
    public function genereateAlahlyOnlineLink($data)
    {
        $url = e3mURL('?page=e3melbusinessPayment&action=generateOnlineLink');
        $content = "";
        foreach ($data as $key => $value) {
            $content .= $key . '=' . $value . '&';
        }
        //echo $content;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
        $json_response = curl_exec($curl);
//        dd($json_response);
        return $json_response;
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
    }


    public function checkPromotionCode(Request $request)
    {
        $params = $request->all();
        $code = isset($params['code']) ? $params['code'] : null;
        $period = isset($params['period']) ? $params['period'] : null;
        $this->checkPromotionCodeAPI($code, $period);
    }

//    public function active(Request $request)
//    {
//        $params = $request->all();
//        $username=isset($params['email'])?$params['email']:'';
//        $period=isset($params['period'])?$params['period']:'';
//        $subscrip_type=isset($params['subscrip_type'])?$params['subscrip_type']:'';
//        $amount=isset($params['amount'])?$params['amount']:'';
//        $pay_type=isset($params['pay_type'])?$params['pay_type']:'';
//        $course_id=isset($params['course_id'])?$params['course_id']:'';
//        $course_name=isset($params['course_name'])?$params['course_name']:'';
//        $packagecode=isset($params['package'])?$params['package']:'';
//        $paymentstatus=isset($params['paymentstatus'])?$params['paymentstatus']:'';
//        $customer_id=isset($params['customer_id'])?$params['customer_id']:'';
//        $pay_type=isset($params['pay_type'])?$params['pay_type']:'';
//        $price=isset($params['price'])?$params['price']:'';
//        $copon_id=isset($params['discount'])?$params['discount']:'';
//        $lifetime=isset($params['lifetime'])?$params['lifetime']:'';
//        if($copon_id){
//            $promotion=$this->getPromotionCode($copon_id);
//            if(count($promotion)){
//                $copon_id=$promotion->id;
//            }
//        }
//        $copon_id=($copon_id)?$copon_id:0;
//
//        $subscrip_country=isset($params['subscrip_country'])?$params['subscrip_country']:'';
//        $currency=isset($params['currency'])?$params['currency']:'';
//        $employe_id=isset($params['employe_id'])?$params['employe_id']:'';
//        if ($pay_type=='onlinepayment'){/*Log*/
//            $parameters=array('email'=> $username,
//                'package'=> $packagecode,
//                'amount'=> $amount,
//                'paymentstatus'=> $paymentstatus,
//                'customer_id'=> $customer_id,
//                'period'=> $period,
//                'subscrip_type'=> $subscrip_type,
//                'subscrip_country'=> $subscrip_country,
//                'currency'=> $currency,
//                'price' =>$price,
//                'copon_id' =>$copon_id,
//                'employe_id' =>$employe_id,
//            );
//            $this->addpayment_transaction( $parameters);
//            /*Log*/;}
//        elseif ($pay_type=='onlinepayment_course')
//        {
//            $parameters=array('email'=> $username,
//                'course_id'=> $course_id,
//                'course_name'=> $course_name,
//                'amount'=> $amount,
//                'paymentstatus'=> $paymentstatus,
//                'customer_id'=> $customer_id,
//                'period'=> $period,
//                'subscrip_type'=> $subscrip_type,
//                'subscrip_country'=> $subscrip_country,
//                'currency'=> $currency,
//            );
//            $this->addpayment_transaction_course( $parameters);
//        }
//
//        $isexist=$this->isexesituser($username);
//
//        if ($isexist===FALSE){
//            echo  'لا يوجد مشترك بهذاالبريد الالكترونى';
//            return;
//        }
//
//
//        if ($pay_type=='onlinepayment_course' || $pay_type=='pay_percourse'){
//            //echo'1<br>';
//            $data=$this->activeuser_course($username,$course_id);
//        }else{
//            //echo'2<br>';
//            if($period=='mba'){
//                $this->activeMBAUser($amount,$username,$period,date('Y-m-d H:i:s'),$subscrip_type,$subscrip_country,$currency,0);
//            }else{
//                $data=$this->activeuser($username,$period,$subscrip_type,$amount,$copon_id,$lifetime);
//                $this->checkPromotionCode_2($username,$copon_id);
//            }
//
//
//        }
////var_dump($data);
//        // $eecoded_id=$this->registry->encryption->encode($id);
//        if ($data===TRUE){
//
//            echo  'تم اضافة المدة بنجاح';
//
//
//        }
//        else {
//
//            echo  'يوجد خطأ';
//
//
//        }
//    }

//    public function subscriptionDiploma(Request $request)
//    {
//        $subscrip_link=config('globals.diplomalink');
//        $params=$request->all();
//        if(isset($params['online_diploma_email'])){
//            $email=$params['online_diploma_email'];
//            $diploma_id=isset($params['online_diploma_id'])?$params['online_diploma_id']:'';
//            $start_date=isset($params['online_start_date'])?$params['online_start_date']:'';
//            $diploma_price=isset($params['online_diploma_amount'])?$params['online_diploma_amount']:'';
//        }else{
//            $email=isset($params['email'])?$params['email']:'';
//            $diploma_id=isset($params['diploma_id'])?$params['diploma_id']:'';
//            $start_date=date('Y-m',strtotime('+1 month')).'-01';
//            $diploma_price=$this->getDiplomaPrice($diploma_id,'ksa_price');
//        }
//
//        $parameters_db=array();
//        $parameters_1=$this->register();
//        foreach ($parameters_1 as $parameter) {
//            //  echo $parameter;
//            //return;
//            $json = json_decode($parameter);
//
//            $key = $json->name;
//            if(isset($params['online_diploma_email'])){
//                $$key =isset($params['online_diploma_'.$key])?$params['online_diploma_'.$key]:'';//post($key);
//            }else{
//                $$key =isset($params[$key])?$params[$key]:'';//post($key);
//            }
//
//            //echo $json->type . "  " . $key . " = " . $$key . ';<br>';
//            if ($$key == "") {
//
//            } else {
//                //echo $key . "=". $$key;
//                $data['name'] = $key;
//                $data['value'] = $$key;
//                $data['type'] = $json->type;
//                $jsondb = json_encode($data);
//                array_push($parameters_db, $jsondb);
//            }
//
//        }
//        $data['name'] = "Password";
//        $data['value'] = $this->randomPassword();
//        $data['type'] = 'string';
//        $jsondb = json_encode($data);
//        array_push($parameters_db, $jsondb);
//        $parameters=array();
//        if($email=="")
//            return;
//        $result_email=  $this->isexesituser($email);
//        /*$parameters_db=array('FullName'=>$FullName,
//                         'email' =>$email,
//                         'country'	=>$country,
//                         'Mobile1'	=>$Mobile1,
//                         'Password' => self::randomPassword() ,
//                         )		;			*/
//        ob_start();
//
//
//        if(!$result_email)
//        {
//            $id=	$this->registry->users->adduser($parameters_db);
//            ob_end_clean();
//
//        }
//        ob_end_clean();
//        //$en_email= $email.'-'.$period.'-'.$employee_id.'-'.$start_date.'-'.$diploma_price.'-'.$diploma_name.'-'.$subscribe_country.'-offer';
//        $period=9;
//        $employee_id=$params['employee_id'];
//        $email=str_replace('-','%20',$email);
//        $start_date=str_replace('-','%20',$start_date);
//        $diploma_name=$this->registry->users->getDiplomasName($diploma_id);
//        $diploma_name=str_replace('-','%20',$diploma_name);
//        $subscribe_country='egy';
//        $currency='دولار';
//        $en_email= $email.'-'.$period.'-'.$employee_id.'-'.$diploma_id.'-'.$start_date.'-'.$diploma_price.'-'.$diploma_name.'-'.$subscribe_country.'-'.$currency;
//
//        $en_email=$this->registry->encryption->encode($en_email);
//        // echo $project_id;
//        $link=$subscrip_link.$en_email;
//
//        if(post('online_diploma_email')){
//            echo  "<a  target='_blank' href='$link'>$link</a>";
//        }else{
//            $parameters=array(
//                'success' => '1',
//                'message' => '<span  class="newloading">سيتم تحويلك  <a href="'.$link.'"> لموقع الدفع الإلكترونى </a> بعد 5 ثوانى</span><script> window.setTimeout(function(){
//                                 window.location.href = "'.$link.'";
//                                 }, 5000);</script>',
//            );
//            echo  json_encode($parameters);
//        }
//
//
//    }

    public function getDiplomaSummaryDate(Request $request)
    {
        $date = $request->all()['date'];
        $diplomasummary = $this->getdiplomateam($date);
        return view('auth.diploma.summary', compact('diplomasummary'));
    }

    public function getTrainingProgramSummaryDate(Request $request)
    {
        $date = $request->all()['date'];
        $training_programsummary = $this->gettraining_programteam($date);
        return view('auth.training_program.summary', compact('training_programsummary'));
    }

    public function changeLifeTime(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $type_id = isset($params['type_id']) ? $params['type_id'] : null;
            $type = isset($params['type']) ? $params['type'] : null;
            return response()->json(['success' => $this->doChangeLifeTime($type_id, $type)]);
        }
    }

    public function companies()
    {
        $companies = $this->getCompanies();
        return view('auth.companies.view', compact('companies'));

    }

    public function addNewCompany(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doAddNewCompany($request);
        }
    }

    public function addCompanyPeriod(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doAddCompanyPeriod($request);
        }
    }

    public function searchForAdminMembersCompany(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doSearchForAdminMembersCompany($request);
        }
    }

    public function searchForExistAdminMembersCompany(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doSearchForExistAdminMembersCompany($request);
        }
    }

    public function showChargeTransactionsAdminMember(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doShowChargeTransactionsAdminMember($request);
        }
    }

    public function addChargeToUser(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            return $this->doAddChargeToUser($request);
        }
    }

    public function removeMember(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $memberID = $request->all()['memberID'];
            $this->doRemoveMember($memberID);
        }
    }

    public function addAdminCompany(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doAddAdminCompany($request);
        }
    }

    public function removeAdmin(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $adminID = isset($params['adminID']) ? $params['adminID'] : null;
            $company_id = isset($params['company_id']) ? $params['company_id'] : null;
            if ($adminID) {
                $this->doRemoveAdmin($company_id, $adminID);
            }
        }
    }

    public function addMemberCompany(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doAddMemberCompany($request);
        }
    }

    public function getUserCertificates(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doGetUserCertificates($request);
        }
    }

    public function getYottaUserCertificates(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doGetYottaUserCertificates($request);
        }
    }


    public function saveCertificateName(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doSaveCertificateName($request);
        }
    }

    public function saveYottaCertificateName(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doSaveYottaCertificateName($request);
        }
    }

    public function editchargecategory(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doeditchargecategory($request);
        }
    }

    public function getMbaSummaryAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetMbaSummaryAjax($request);
        }
    }

    public function getDbaSummaryAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDbaSummaryAjax($request);
        }
    }

    public function getNewMbaSummaryAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaSummaryAjax($request);
        }
    }

    public function getNewMbaCategorySummaryAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaCategorySummaryAjax($request);
        }
    }

    public function getNewMbaProjectSummaryAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaProjectSummaryAjax($request);
        }
    }

    public function getMbaPercentageAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetMbaPercentageAjax($request);
        }
    }

    public function getDbaPercentageAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDbaPercentageAjax($request);
        }
    }

    public function getNewMbaPercentageAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaPercentageAjax($request);
        }
    }

    public function getMbaExamsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetMbaExamsAjax($request);
        }
    }

    public function getNewMbaExams1Ajax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaExams1Ajax($request);
        }
    }

    public function getNewMbaExams2Ajax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaExams2Ajax($request);
        }
    }

    public function getMbaTrainingsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetMbaTrainingsAjax($request);
        }
    }

    public function getNewMbaTrainingsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaTrainingsAjax($request);
        }
    }

    public function getCoursesExamsTrainingsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetCoursesExamsTrainingsAjax($request);
        }
    }

    public function getDbaCoursesExamsTrainingsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDbaCoursesExamsTrainingsAjax($request);
        }
    }
    public function getDbaGenerateCertificateFormAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDbaGenerateCertificateFormAjax($request);
        }
    }

    public function generateDBACertificate(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGenerateDBACertificate($request);
        }
    }

    public function getNewCoursesExamsTrainingsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewCoursesExamsTrainingsAjax($request);
        }
    }

    public function getCoursesExamsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            return response()->json($this->doGetCoursesExamsAjax($request));
        }
    }

    public function getCoursesTrainingsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetCoursesTrainingsAjax($request);
        }
    }

    public function getLiteReportAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetLiteReportAjax($request);
        }
    }
    public function getDiplomaGenerateCerCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['email']) ? $params['email'] : null;
            //$password=post('password');
            $data = $this->getclientdata($username);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $diplomas = $this->getUserCertificateDiplomas($data->id);
                if (count($diplomas)) {
                    echo '<div class="form-group"><select name="diplomaTransactionGenerateCerID" id="diplomaTransactionGenerateCerID" class="form-control" placeholder="الدبلومة">';
                    echo '<option value="">الدبلومة</option>';
                    foreach ($diplomas as $diploma) {
                        echo '<option  value="' . $diploma->id . '">' . $diploma->diploma_name . '</option>';
                    }
                    echo '</select></div>';
                    echo '<div id="diplomaTransactionGenerateCerMessage"></div>';

                } else {
                    echo '<div class="alert alert-danger">Not having any diplomas</div>';
                }

            } else {
                echo '<div class="well">No Data</div>';
            }
        }

    }


    public function getDiplomaSuspendCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['email']) ? $params['email'] : null;
            //$password=post('password');
            $data = $this->getclientdata($username);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $diplomas = $this->getUserDiplomas($data->id,true);//}mdl6qvNOJ5U
                if (count($diplomas)) {
                    echo '<div id="diplomaTransactionSuspendMessage"></div>';
                    echo '<div class="form-group"><select name="diplomaTransactionSuspendID" id="diplomaTransactionSuspendID" class="form-control" placeholder="الدبلومة">';
                    echo '<option value="">الدبلومة</option>';
                    foreach ($diplomas as $diploma) {
                        echo '<option data-suspend="' . (($diploma->suspend) ? 0 : 1) . '" value="' . $diploma->id . '">' . $diploma->diploma_name . '</option>';
                    }
                    echo '</select></div>';
                    echo '<button class="btn btn-success input-circle" id="diplomaMakeSuspend" type="submit">Make Suspend</button>';
                } else {
                    echo '<div class="alert alert-danger">Not having any diplomas</div>';
                }

            } else {
                echo '<div class="well">No Data</div>';
            }
        }

    }
    public function getPackageSuspendCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['email']) ? $params['email'] : null;
            //$password=post('password');
            $data = $this->getclientdata($username);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $packages = $this->getUserPackages($data->id);
                if (count($packages)) {
                    echo '<div id="packageTransactionSuspendMessage"></div>';
                    echo '<div class="form-group"><select name="packageTransactionSuspendID" id="packageTransactionSuspendID" class="form-control" placeholder="الدبلومة">';
                    echo '<option value="">الباكدج</option>';
                    foreach ($packages as $package) {
                        echo '<option data-suspend="' . (($package->suspend) ? 0 : 1) . '" value="' . $package->id . '">' . $package->package_name . '</option>';
                    }
                    echo '</select></div>';
                    echo '<button class="btn btn-success input-circle" id="packageMakeSuspend" type="submit">Make Suspend</button>';
                } else {
                    echo '<div class="alert alert-danger">Not having any packages</div>';
                }

            } else {
                echo '<div class="well">No Data</div>';
            }
        }

    }
    public function getCustomSuspendCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['email']) ? $params['email'] : null;
            //$password=post('password');
            $data = $this->getclientdata($username);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $charges = $this->getUserCustom($data->id);
                if (count($charges)) {
                    echo '<div id="customTransactionSuspendMessage"></div>';
                    echo '<div class="form-group"><select name="customTransactionSuspendID" id="customTransactionSuspendID" class="form-control" placeholder="الدبلومة">';
                    echo '<option value="">الشحنة</option>';
                    foreach ($charges as $charge) {
                        echo '<option data-suspend="' . (($charge->suspend) ? 0 : 1) . '" value="' . $charge->id . '">' . date('Y-m-d',strtotime($charge->start_date)) .' / '.date('Y-m-d',strtotime($charge->end_date)) . '</option>';
                    }
                    echo '</select></div>';
                    echo '<button class="btn btn-success input-circle" id="customMakeSuspend" type="submit">Make Suspend</button>';
                } else {
                    echo '<div class="alert alert-danger">Not having any packages</div>';
                }

            } else {
                echo '<div class="well">No Data</div>';
            }
        }

    }


    public function getTrainingprogramSuspendCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['email']) ? $params['email'] : null;
            //$password=post('password');
            $data = $this->getclientdata($username);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $diplomas = $this->getUserTrainigPrograms($data->id);
                if (count($diplomas)) {
                    echo '<div id="trainingprogramTransactionSuspendMessage"></div>';
                    echo '<div class="form-group"><select name="trainingprogramTransactionSuspendID" id="trainingprogramTransactionSuspendID" class="form-control" placeholder="البرنامج التأهيلى">';
                    echo '<option value="">البرنامج التأهيلى</option>';
                    foreach ($diplomas as $diploma) {
                        echo '<option data-suspend="' . (($diploma->suspend) ? 0 : 1) . '" value="' . $diploma->id . '">' . $diploma->name . '</option>';
                    }
                    echo '</select></div>';
                    echo '<button class="btn btn-success input-circle" id="trainingprogramMakeSuspend" type="submit">Make Suspend</button>';
                } else {
                    echo '<div class="alert alert-danger">Not having any training programs</div>';
                }

            } else {
                echo '<div class="well">No Data</div>';
            }
        }

    }


    public function getInternationalDiplomaSuspendCustomerData(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['email']) ? $params['email'] : null;
            //$password=post('password');
            $data = $this->getclientdata($username);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $diplomas = $this->getUserInternationalDiplomas($data->id);
                if (count($diplomas)) {
                    echo '<div id="internationalDiplomaTransactionSuspendMessage"></div>';
                    echo '<div class="form-group"><select name="internationalDiplomaTransactionSuspendID" id="internationalDiplomaTransactionSuspendID" class="form-control" placeholder="الدبلومة">';
                    echo '<option value="">الدبلومة</option>';
                    foreach ($diplomas as $diploma) {
                        echo '<option data-suspend="' . (($diploma->suspend) ? 0 : 1) . '" value="' . $diploma->id . '">' . $diploma->diploma_name . '</option>';
                    }
                    echo '</select></div>';
                    echo '<button class="btn btn-success input-circle" id="internationalDiplomaMakeSuspend" type="submit">Make Suspend</button>';

                } else {
                    echo '<div class="alert alert-danger">Not having any diplomas</div>';
                }

            } else {
                echo '<div class="well">No Data</div>';
            }
        }

    }

    public function diplomaMakeSuspend(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $diploma_transaction_id = isset($params['diploma_transaction_id']) ? $params['diploma_transaction_id'] : null;
        $suspend = isset($params['suspend']) ? $params['suspend'] : null;
        $this->doDiplomaMakeSuspend($email, $diploma_transaction_id, $suspend);
    }
    public function diplomaMakeCertificate(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $diploma_transaction_id = isset($params['diploma_transaction_id']) ? $params['diploma_transaction_id'] : null;
        $this->doDiplomaMakeCertificate($email, $diploma_transaction_id);
    }

    public function packageMakeSuspend(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $package_transaction_id = isset($params['package_transaction_id']) ? $params['package_transaction_id'] : null;
        $suspend = isset($params['suspend']) ? $params['suspend'] : null;
        $this->doPackageMakeSuspend($email, $package_transaction_id, $suspend);
    }
    public function customMakeSuspend(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $custom_transaction_id = isset($params['custom_transaction_id']) ? $params['custom_transaction_id'] : null;
        $suspend = isset($params['suspend']) ? $params['suspend'] : null;
        $this->doCustomMakeSuspend($email, $custom_transaction_id, $suspend);
    }

    public function trainingprogramMakeSuspend(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $diploma_transaction_id = isset($params['training_program_transaction_id']) ? $params['training_program_transaction_id'] : null;
        $suspend = isset($params['suspend']) ? $params['suspend'] : null;
        $this->doTrainingProgramMakeSuspend($email, $diploma_transaction_id, $suspend);
    }


    public function internationalDiplomaMakeSuspend(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $diploma_transaction_id = isset($params['diploma_transaction_id']) ? $params['diploma_transaction_id'] : null;
        $suspend = isset($params['suspend']) ? $params['suspend'] : null;
        $this->doInternationalDiplomaMakeSuspend($email, $diploma_transaction_id, $suspend);
    }

    public function getListUserCoursesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetListUserCoursesAjax($request);
        }
    }

    public function getCoursesReportAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetCoursesReportAjax($request);
        }
    }

    public function getDemoLogAjax(Request $request)
    {
        try {
            if ($request->isMethod('post') && $request->ajax()) {
                $email = $request->user_email;
                $user_id = DB::connection('mysql2')->table('users')->select('users.id')
                    ->where("Email", "=", $email)->get()[0]->id;
                echo $this->doGetDemoLogAjax($request, $user_id);
            }
        } catch (\Exception $exception) {
            dd($exception->getMessage());
        }
    }
    public function getCompaniesChargesAjax(Request $request)
    {
        try {
            if ($request->isMethod('post') && $request->ajax()) {
                $email = $request->user_email;
                $user_id = DB::connection('mysql2')->table('users')->select('users.id')
                    ->where("Email", "=", $email)->get()[0]->id;
                echo $this->doGetCompaniesChargesAjax($request, $user_id);
            }
        } catch (\Exception $exception) {
            dd($exception->getMessage());
        }
    }

    public function getDiplomasSupplementaryTestsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDiplomasSupplementaryTestsAjax($request);
        }
    }

    public function getPackagesChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetPackagesChargesAjax($request);
        }
    }  public function getCustomChargesAjax(Request $request)
{
    if ($request->isMethod('post') && $request->ajax()) {
        echo $this->doGetCustomChargesAjax($request);
    }
}
    public function getDiplomasChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDiplomasChargesAjax($request);
        }
    }

    public function getCompaniesDiplomasChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetCompaniesDiplomasChargesAjax($request);
        }
    }


    public function getTrainingProgramsChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetTrainingProgramsChargesAjax($request);
        }
    }
    public function getSuspendTrainingProgramLogAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetSuspendTrainingProgramLogAjax($request);
        }
    }
    public function getSuspendLogAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetSuspendLogAjax($request);
        }
    }
    public function getCustomSuspendLogAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetCustomSuspendLogAjax($request);
        }
    }
    public function getPackageSuspendLogAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetPackageSuspendLogAjax($request);
        }
    }

    public function getMbaChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetMbaChargesAjax($request);
        }
    }
    public function getPreparatoryMbaChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetPreparatoryMbaChargesAjax($request);
        }
    }

    public function getNewMbaChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaChargesAjax($request);
        }
    }

    public function getDBAPreliminaryChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDBAPreliminaryChargesAjax($request);
        }
    }

    public function getDBAChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDBAChargesAjax($request);
        }
    }

    public function getDBAChecklistsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetDBAChecklistsAjax($request);
        }
    }

    public function editDBAChecklists(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doeditDBAChecklists($request);
        }
    }

    public function getNewMbaCategoriesChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetNewMbaCategoriesChargesAjax($request);
        }
    }

    public function getChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetChargesAjax($request);
        }
    }


    public function getCvHrInterviewChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetConsultantChargesAjax('consultant_cv_hr_interview_charge_transaction', $request);
        }
    }

    public function getTechnicalInterviewChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetConsultantChargesAjax('consultant_technical_interview_charge_transaction', $request);
        }
    }

    public function getCareerCoachingChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetConsultantChargesAjax('consultant_career_coaching_charge_transaction', $request);
        }
    }

    public function getUsersSuspendAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doGetUsersSuspendAjax($request);
        }
    }

    public function getUsersCvHrInterviewSuspendAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetUsersConsultantSuspendAjax('consultant_cv_hr_interview_charge_transaction_suspend_log', $request);
        }
    }

    public function getUsersTechnicalInterviewSuspendAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetUsersConsultantSuspendAjax('consultant_technical_interview_charge_transaction_suspend_log', $request);
        }
    }

    public function getUsersCareerCoachingSuspendAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetUsersConsultantSuspendAjax('consultant_career_coaching_charge_transaction_suspend_log', $request);
        }
    }

    public function activeConsultantCharge(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetUsersConsultantSuspendAjax('consultant_career_coaching_charge_transaction_suspend_log', $request);
        }
    }


    public function suspendConsultantChargeTransaction(Request $request)
    {
        $data = $request->all();
        $transaction_id = $data['transaction_id'];
        $table = $data['table'];
        if ($transaction_id && $table) {
            $suspend = $data['suspend'];
            $notSuspend = ($suspend) ? 0 : 1;
            $query = "SELECT $table.* FROM $table INNER JOIN users ON users.id=$table.user_id WHERE $table.id='$transaction_id' AND $table.suspend='$notSuspend'";
            $result = DB::connection('mysql2')->select($query);
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                DB::connection('mysql2')->table($table)->where('id', $transaction_id)->update(
                    ['suspend' => $suspend, 'suspend_date' => $date]
                );
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', $table, $transaction_id, json_encode(['suspend' => $suspend, 'suspend_date' => $date]));
                $user_id = $obj->user_id;
                DB::connection('mysql2')->table($table . '_suspend_log')->insert(
                    ['transaction_id' => $transaction_id, 'user_id' => $user_id, 'suspend' => $suspend, 'createtime' => $date]
                );
                $errorMessage = ($notSuspend) ? 'Success Un Suspend' : 'Success Suspend';
                $dataResponse = ['success' => true, 'message' => '<div class="alert alert-success">' . $errorMessage . '</div>'];
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($obj->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;
                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($obj->end_date)));
                    DB::connection('mysql2')->table($table)->where('id', $transaction_id)->update(
                        ['end_date' => $PaymentExpirationDate]
                    );
                    log_user_action(Auth::user()->id, Auth::user()->username, 'update', $table, $transaction_id, json_encode(['end_date' => $PaymentExpirationDate]));
                    $dataResponse['end_date'] = $PaymentExpirationDate;
                }
                return response()->json($dataResponse)->setCallback($request->input('callback'));
            } else {
                return response()->json(['success' => false, 'message' => '<div class="alert alert-danger">Please Refresh and try again</div>', 'q' => $query])->setCallback($request->input('callback'));
                $errorMessage = ($notSuspend) ? 'No Data Or already un suspended' : 'No Data Or already suspended';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }


    public function deleteConsultantChargeTransaction($charge_id)
    {
        $table_name = str_replace('delete_', '', request()->segment(2));
        $chargeTransaction = \Illuminate\Support\Facades\DB::connection('mysql2')->table($table_name)->find($charge_id);
        if ($chargeTransaction) {
            \Illuminate\Support\Facades\DB::connection('mysql')->table('deleted_' . $table_name)->insert(array_merge(collect($chargeTransaction)->toArray(), ['old_id' => $chargeTransaction->id, 'deleted_by_id' => auth()->id()]));
            \Illuminate\Support\Facades\DB::connection('mysql2')->table($table_name)->where('id', $charge_id)->delete();
            return response()->json(['success' => true]);
        }
    }


    public function getInternationalDiplomasChargesAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetInternationalDiplomasChargesAjax($request);
        }
    }

    public function openDiplomaCourses(Request $request)
    {
        $data = $request->all();
        $user_id = $data['user_id'];
        $diploma_id = $data['diploma_id'];
        if ($user_id && $diploma_id) {
            $diplomas_courses = DiplomasCoursesUsersPlan::where('diploma_id', $diploma_id)->where('user_id', $user_id)->get();
            foreach ($diplomas_courses as $diplomas_course) {
                $related_course = $diplomas_course->course_id;
                $sort = $diplomas_course->sort;
                $diploma_user_course = DiplomasUsersCourses::where('diploma_id', $diploma_id)->where('user_id', $user_id)->where('course_id', $related_course)->get();
                if (!count($diploma_user_course)) {
                    $newDiplomaCourse = new DiplomasUsersCourses();
                    $newDiplomaCourse->diploma_id = $diploma_id;
                    $newDiplomaCourse->course_id = $related_course;
                    $newDiplomaCourse->user_id = $user_id;
                    $newDiplomaCourse->createtime = date('Y-m-d H:i:s');
                    $newDiplomaCourse->sort = $sort;
                    $newDiplomaCourse->save();
                }
            }
            $msg = '<div class="text-right alert alert-success"> تم فتح جميع كورسات الدبلومة </div>';
            $return_data['msg'] = $msg;
            return response()->json($return_data);
        }
    }

    public function openyottaDiplomaCourses(Request $request)
    {
        $data = $request->all();
        $user_id = $data['user_id'];
        $diploma_id = $data['diploma_id'];
        if ($user_id && $diploma_id) {
            $diplomas_courses = MedicalDiplomasCoursesUsersPlan::where('diploma_id', $diploma_id)->where('user_id', $user_id)->get();
            foreach ($diplomas_courses as $diplomas_course) {
                $related_course = $diplomas_course->course_id;
                $sort = $diplomas_course->sort;
                $diploma_user_course = MedicalDiplomasUsersCourses::where('diploma_id', $diploma_id)->where('user_id', $user_id)->where('course_id', $related_course)->get();
                if (!count($diploma_user_course)) {
                    $newDiplomaCourse = new MedicalDiplomasUsersCourses();
                    $newDiplomaCourse->diploma_id = $diploma_id;
                    $newDiplomaCourse->course_id = $related_course;
                    $newDiplomaCourse->user_id = $user_id;
                    $newDiplomaCourse->createtime = date('Y-m-d H:i:s');
                    $newDiplomaCourse->sort = $sort;
                    $newDiplomaCourse->save();
                }
            }
            $msg = '<div class="text-right alert alert-success"> تم فتح جميع كورسات الدبلومة </div>';
            $return_data['msg'] = $msg;
            return response()->json($return_data);
        }
    }


    public function openTrainingProgramCourses(Request $request)
    {
        $data = $request->all();
        $user_id = $data['user_id'];
        $training_program_id = $data['training_program_id'];
        if ($user_id && $training_program_id) {
            $training_program_courses = TrainingProgramCoursesUsersPlan::where('diploma_id', $training_program_id)->where('user_id', $user_id)->get();
            foreach ($training_program_courses as $training_program_course) {
                $related_course = $training_program_course->course_id;
                $sort = $training_program_course->sort;
                $training_program_user_course = TrainingProgramUsersCourses::where('diploma_id', $training_program_id)->where('user_id', $user_id)->where('course_id', $related_course)->get();
                if (!count($training_program_user_course)) {
                    $newTrainingProgramCourse = new TrainingProgramUsersCourses();
                    $newTrainingProgramCourse->diploma_id = $training_program_id;
                    $newTrainingProgramCourse->course_id = $related_course;
                    $newTrainingProgramCourse->user_id = $user_id;
                    $newTrainingProgramCourse->createtime = date('Y-m-d H:i:s');
                    $newTrainingProgramCourse->sort = $sort;
                    $newTrainingProgramCourse->save();
                }
            }
            $msg = '<div class="text-right alert alert-success"> تم فتح جميع كورسات برنامج التاهيل </div>';
            $return_data['msg'] = $msg;
            return response()->json($return_data);
        }
    }

    public function openInternationalDiplomaCourses(Request $request)
    {
        $data = $request->all();
        $user_id = $data['user_id'];
        $diploma_id = $data['diploma_id'];
        if ($user_id && $diploma_id) {
            $diplomas_courses = InternationalDiplomasCoursesUsersPlan::where('diploma_id', $diploma_id)->where('user_id', $user_id)->get();
            foreach ($diplomas_courses as $diplomas_course) {
                $related_course = $diplomas_course->course_id;
                $sort = $diplomas_course->sort;
                $diploma_user_course = InternationalDiplomasUsersCourses::where('diploma_id', $diploma_id)->where('user_id', $user_id)->where('course_id', $related_course)->get();
                if (!count($diploma_user_course)) {
                    $newDiplomaCourse = new InternationalDiplomasUsersCourses();
                    $newDiplomaCourse->diploma_id = $diploma_id;
                    $newDiplomaCourse->course_id = $related_course;
                    $newDiplomaCourse->user_id = $user_id;
                    $newDiplomaCourse->createtime = date('Y-m-d H:i:s');
                    $newDiplomaCourse->sort = $sort;
                    $newDiplomaCourse->save();
                }
            }
            $msg = '<div class="text-right alert alert-success"> تم فتح جميع كورسات الدبلومة </div>';
            $return_data['msg'] = $msg;
            return response()->json($return_data);
        }
    }

    public function addUserCourse(Request $request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $course_id = isset($params['course_id']) ? $params['course_id'] : null;
        $this->doAddUserCourse($email, $course_id);
    }

//    public function activeCoursesUsers(Request $request){
//        $params=$request->all();
//        $email = isset($params['email'])?$params['email']:null;
//        $subscribe_country = isset($params['subscribe_country'])?$params['subscribe_country']:null;
//        $period = isset($params['period'])?$params['period']:null;
//        $amount = isset($params['amount'])?$params['amount']:null;
//        $start_date = isset($params['start_date'])?$params['start_date']:null;
//        $subscribe_type = isset($params['subscribe_type'])?$params['subscribe_type']:null;
//        $currency = isset($params['currency'])?$params['currency']:null;
//        $employee_id = isset($params['employee_id'])?$params['employee_id']:null;
//        $partner = isset($params['partner'])?$params['partner']:null;
//        $this->doActiveCoursesUsers($email,$subscribe_country,$period,$amount,$start_date,$subscribe_type,$currency,$employee_id,$partner);
//    }
//
//    public function activeMedical(Request $request){
//        $this->doActiveMedical($request);
//    }

    public function checkCorporateCode(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $this->doCheckCorporateCode($request);
        }
    }

    public function sendCustomerCredentials(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $params = $request->all();
            $username = isset($params['email']) ? $params['email'] : '';
            $data = $this->getclientdata($username);
            if (isset($data->id)) {
                $this->sendwelcomemail($username);
                $errorMessage = 'Sending Credentials Success';
                return view('auth.message.success_message', compact('errorMessage'));
            } else {
                $errorMessage = 'This Email Not Exist';
                return view('auth.message.error_message', compact('errorMessage'));
            }
        }
    }

    public function crm_apis(Request $request)
    {
        return view('auth.crm_apis.view');
    }

    public function user_diplomas_report(Request $request)
    {
        return view('auth.user_diplomas_report.view');
    }
    public function user_yotta_diplomas_report(Request $request)
    {
        return redirect()->to('https://www.e3melbusinessmedical.com/supportAdmin/public/admin/user_diplomas_report');
        return view('auth.user_yotta_diplomas_report.view');
    }

    public function searchForUser(Request $request)
    {
        $params = $request->all();
        $username = isset($params['email']) ? $params['email'] : '';
        $data = $this->getclientdata($username);
        if (isset($data->FullName)) {
            $diplomas = $this->getUserDiplomas($data->id);
            echo '
                        <div class="well">
                            <div id="corporateDemoMessage"></div>
                            <div class="col-lg-6">
                                <address>
                                    <strong>Full Name : ' . $data->FullName . '</strong>
                                    <br>
                                    Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                    <br>
                                    Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                    <span id="country" class="hidden">' . $data->country . '</span>
                                    <br>
                                    Expiration Date : ' . $data->PaymentExpirationDate . '
                                     <br>
                                    Last Login Date : ' . $data->last_login_date . '
                                    <div class="clearfix"></div>
                                   <div class="form-group">
                                       <div class="input-group">
                                            <select name="diploma_id" class="form-control" id="diploma_id">
                                                <option value="">Select Diploma</option>';
            foreach ($diplomas as $diploma) {
                echo '<option value="' . $diploma->diploma_id . '">' . $diploma->diploma_name . '</option>';
            }
            echo '
                                            </select>
                                            <span class="input-group-btn">
                                                <button id="viewReport"  class="btn btn-success input-circle-right" type="button">
                                                <i class="fa fa-search"></i> View Details</button>
                                            </span>
                                        </div>
                                    </div>
                            </address></div><div class="clearfix"></div> </div>       ';
        } else {

        }

    }
    public function searchForYottaUser(Request $request)
    {
        $params = $request->all();
        $username = isset($params['email']) ? $params['email'] : '';
        $data = $this->getclientdata($username,true);
        if (isset($data->FullName)) {
            $diplomas = $this->getUserYottaDiplomas($data->id);
            echo '
                        <div class="well">
                            <div id="corporateDemoMessage"></div>
                            <div class="col-lg-6">
                                <address>
                                    <strong>Full Name : ' . $data->FullName . '</strong>
                                    <br>
                                    Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                    <br>
                                    Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                    <span id="country" class="hidden">' . $data->country . '</span>
                                    <br>
                                    Expiration Date : ' . $data->PaymentExpirationDate . '
                                     <br>
                                    Last Login Date : ' . $data->last_login_date . '
                                    <div class="clearfix"></div>
                                   <div class="form-group">
                                       <div class="input-group">
                                            <select name="diploma_id" class="form-control" id="diploma_id">
                                                <option value="">Select Diploma</option>';
            foreach ($diplomas as $diploma) {
                echo '<option value="' . $diploma->diploma_id . '">' . $diploma->diploma_name . '</option>';
            }
            echo '
                                            </select>
                                            <span class="input-group-btn">
                                                <button id="viewReport"  class="btn btn-success input-circle-right" type="button">
                                                <i class="fa fa-search"></i> View Details</button>
                                            </span>
                                        </div>
                                    </div>
                            </address></div><div class="clearfix"></div> </div>       ';
        } else {

        }

    }

    public function getUserDiplomaReport(Request $request)
    {
        $reports = $this->doGetUserDiplomaReport($request);
        return view('auth.user_diplomas_report.search', compact('reports'));

    }
    public function getUserYottaDiplomaReport(Request $request)
    {
        $reports = $this->doGetUserYottaDiplomaReport($request);
        return view('auth.user_yotta_diplomas_report.search', compact('reports'));

    }

    public function generateDiplomaCertificate(Request $request)
    {
        $this->doGenerateDiplomaCertificate();
    }

    public function generateYottaDiplomaCertificate(Request $request)
    {
        $this->doGenerateYottaDiplomaCertificate($request);
    }


    public function user_international_diplomas_report(Request $request)
    {
        return view('auth.user_international_diplomas_report.view');
    }

    public function searchInternationalForUser(Request $request)
    {
        $params = $request->all();
        $username = isset($params['email']) ? $params['email'] : '';
        $data = $this->getclientdata($username);
        if (isset($data->FullName)) {
            $diplomas = $this->getUserInternationalDiplomas($data->id);
            echo '
                        <div class="well">
                            <div id="corporateDemoMessage"></div>
                            <div class="col-lg-6">
                                <address>
                                    <strong>Full Name : ' . $data->FullName . '</strong>
                                    <br>
                                    Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                    <br>
                                    Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                    <span id="country" class="hidden">' . $data->country . '</span>
                                    <br>
                                    Expiration Date : ' . $data->PaymentExpirationDate . '
                                     <br>
                                    Last Login Date : ' . $data->last_login_date . '
                                    <div class="clearfix"></div>
                                   <div class="form-group">
                                       <div class="input-group">
                                            <select name="diploma_id" class="form-control" id="diploma_id">
                                                <option value="">Select Diploma</option>';
            foreach ($diplomas as $diploma) {
                echo '<option value="' . $diploma->diploma_id . '">' . $diploma->diploma_name . '</option>';
            }
            echo '
                                            </select>
                                            <span class="input-group-btn">
                                                <button id="viewReport"  class="btn btn-success input-circle-right" type="button">
                                                <i class="fa fa-search"></i> View Details</button>
                                            </span>
                                        </div>
                                    </div>
                            </address></div><div class="clearfix"></div> </div>       ';
        } else {

        }

    }

    public function getUserInternationalDiplomaReport(Request $request)
    {
        $reports = $this->doGetUserInternationalDiplomaReport($request);
        return view('auth.user_international_diplomas_report.search', compact('reports'));

    }

    public function generateInternationalDiplomaCertificate(Request $request)
    {
        $this->doGenerateInternationalDiplomaCertificate();
    }


    public function user_training_programs_report(Request $request)
    {
        return view('auth.user_training_programs_report.view');
    }

    public function TrainingProgramsearchForUser(Request $request)
    {
        $params = $request->all();
        $username = isset($params['email']) ? $params['email'] : '';
        $data = $this->getclientdata($username);
        if (isset($data->FullName)) {
            $diplomas = $this->getUserTrainigPrograms($data->id);
            echo '
                        <div class="well">
                            <div id="corporateDemoMessage"></div>
                            <div class="col-lg-6">
                                <address>
                                    <strong>Full Name : ' . $data->FullName . '</strong>
                                    <br>
                                    Email : <a href="mailto:' . $data->Email . '"><span id="email">' . $data->Email . '</span></a> <button id="copyEmail" class="btn blue btn-outline btn-circle btn-sm"><i class="fa fa-clone"></i></button>
                                    <br>
                                    Mobile : <span id="mobile">' . $data->Mobile . '</span>
                                    <span id="country" class="hidden">' . $data->country . '</span>
                                    <br>
                                    Expiration Date : ' . $data->PaymentExpirationDate . '
                                     <br>
                                    Last Login Date : ' . $data->last_login_date . '
                                    <div class="clearfix"></div>
                                   <div class="form-group">
                                       <div class="input-group">
                                            <select name="diploma_id" class="form-control" id="diploma_id">
                                                <option value="">Select Diploma</option>';
            foreach ($diplomas as $diploma) {
                echo '<option value="' . $diploma->diploma_id . '">' . $diploma->diploma_name . '</option>';
            }
            echo '
                                            </select>
                                            <span class="input-group-btn">
                                                <button id="viewReport"  class="btn btn-success input-circle-right" type="button">
                                                <i class="fa fa-search"></i> View Details</button>
                                            </span>
                                        </div>
                                    </div>
                            </address></div><div class="clearfix"></div> </div>       ';
        } else {

        }

    }

    public function getUserTrainingProgramReport(Request $request)
    {
        $reports = $this->doGetUserTrainingProgramReport($request);
        return view('auth.user_training_programs_report.search', compact('reports'));

    }

    public function generateTrainingProgramCertificate(Request $request)
    {
        $this->generateTrainingProgramCertificate();
    }

    public function getAgents(Request $request)
    {
        $this->doGetAgents($request);
    }

    public function send_feedback(Request $request)
    {
        $params = $request->all();
        $message = isset($params['message']) ? $params['message'] : '';
        $feedback = new Feedback();
        $feedback->user_id = Auth::user()->id;
        $feedback->message = $message;
        $feedback->createdtime = date('Y-m-d H:i:s');
        $feedback->save();
    }

    public function getBlockedUserSessionsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doBlockedUserSessionsAjax($request);
        }
    }
    public function getYottaBlockedUserSessionsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doYottaBlockedUserSessionsAjax($request);
        }
    }

    public function getBlockedUserHistoryAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doBlockedUserHistoryAjax($request);
        }
    }
    public function getYotaBlockedUserHistoryAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doYotaBlockedUserHistoryAjax($request);
        }
    }

    public function getGiftCourseChargeTransactionsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGiftCourseChargeTransactionsAjax($request);
        }
    }
    public function getFreeCourseChargeTransactionsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doFreeCourseChargeTransactionsAjax($request);
        }
    }

    public function getGiftBookChargeTransactionsAjax(Request $request)
    {
        try {
            if ($request->isMethod('post') && $request->ajax()) {
                echo $this->doGiftBookChargeTransactionsAjax($request);
            }
        } catch (\Exception $e) {
            dd($e);
        }
    }

    public function getMedicalChargeTransactionsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doMedicalChargeTransactionsAjax($request);
        }
    }

    public function getMedicalDiplomaChargeTransactionsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetMedicalDiplomasChargesAjax($request);
        }
    }

    public function getRenewalDiplomasAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doRenewalDiplomassAjax($request);
        }
    }
    public function getRenewalInternationalDiplomasAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doRenewalInternationalDiplomassAjax($request);
        }
    }

    public function suspendMedicalChargeTransactionAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            return $this->doSuspendMedicalChargeTransactionAjax($request);
        }
    }

    public function suspendGiftCourseChargeTransactionAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            return $this->doSuspendGiftCourseChargeTransactionAjax($request);
        }
    }

    public function openmbaexamAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            return $this->doopenmbaexamAjax($request);
        }
    }
    public function opennewmbaexamAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            return $this->doopennewmbaexamAjax($request);
        }
    }

    public function addCertificateRequest(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $data = $request->all();
            $user = AcademyUsers::where('Email', $data['certificates_requests_customer_email'])->first();

            $certificate_request = New CertificatesRequests();
            $certificate_request->country_id = $request->certificates_requests_country_id?$request->certificates_requests_country_id:0;
            $certificate_request->state_id = $request->certificates_requests_state_id?$request->certificates_requests_state_id:0;
            $certificate_request->user_id = $user->id;
            $certificate_request->customer_name = $data['certificates_requests_customer_name'];
            $certificate_request->customer_email = $data['certificates_requests_customer_email'];
            $certificate_request->customer_contact = $data['certificates_requests_customer_contact'];
            $certificate_request->product = $data['certificates_requests_product'];
            $certificate_request->product_id = $data['certificates_requests_product_id'];
            $certificate_request->language = $data['certificates_requests_language'];
            $certificate_request->certificate = $data['certificates_requests_certificate'];
            $certificate_request->customer_name_on_certificate = $data['certificates_requests_customer_name_on_certificate'];
            $certificate_request->request_date = date('Y-m-d H:i:s');
            $certificate_request->request_status = 'opened';
            $certificate_request->address = $data['certificates_requests_address'];

            $certificate_request->certificate_date = $data['certificate_date'];

            if (isset($data['diploma_start_date'])) {
                $certificate_request->diploma_start_date = $data['diploma_start_date'];
            } else {
                $certificate_request->diploma_start_date = NULL;
            }
            if (isset($data['diploma_end_date'])) {
                $certificate_request->diploma_end_date = $data['diploma_end_date'];
            } else {
                $certificate_request->diploma_end_date = NULL;
            }

            if ($data['certificates_requests_product'] == 'MBA') {
                $mba_certificate = MbaCertificates::where('user_id', $user->id)->first();
                if ($mba_certificate) {
                    $certificate_request->certification_code = $mba_certificate->serial_number;
                }
            } elseif ($data['certificates_requests_product'] == 'Preparatory MBA') {
                $mba_certificate = PreparatoryMbaCertificates::where('user_id', $user->id)->find($request->certificates_requests_product_id);
                if ($mba_certificate) {
                    $certificate_request->certification_code = $mba_certificate->serial_number;
                }
            }elseif ($data['certificates_requests_product'] == 'New Mba') {
                $mba_certificate = NewMbaCertificates::where('user_id', $user->id)->find($request->certificates_requests_product_id);
                if ($mba_certificate) {
                    $certificate_request->certification_code = $mba_certificate->serial_number;
                }
            } elseif ($data['certificates_requests_product'] == 'DBA Preliminary') {
                $mba_certificate = DBAPreliminaryCertificates::where('user_id', $user->id)->first();
                if ($mba_certificate) {
                    $certificate_request->certification_code = $mba_certificate->serial_number;
                }
            }elseif ($data['certificates_requests_product'] == 'DBA') {
                $mba_certificate = DBACertificate::where('user_id', $user->id)->first();
                if ($mba_certificate) {
                    $certificate_request->certification_code = $mba_certificate->serial_number;
                }
            } elseif ($data['certificates_requests_product'] == 'Courses') {
                $courses_certificate = CoursesCurriculumCertificates::find($data['certificates_requests_product_id']);
                if ($courses_certificate) {
                    $certificate_request->certification_code = $courses_certificate->serial_number;
                }
            } elseif ($data['certificates_requests_product'] == 'Diplomas') {
                $diplomas_certificate = DiplomaCertificates::find($data['certificates_requests_product_id']);
                if ($diplomas_certificate) {
                    $certificate_request->certification_code = $diplomas_certificate->serial_number;
                }
            } elseif ($data['certificates_requests_product'] == 'Training Programs') {
                $training_programs_certificate = TrainingProgramCertificate::find($data['certificates_requests_product_id']);
                if ($training_programs_certificate) {
                    $certificate_request->certification_code = $training_programs_certificate->serial_number;
                }
            } elseif ($data['certificates_requests_product'] == 'International Diplomas') {
                $international_diploma_certificates = \Illuminate\Support\Facades\DB::connection('mysql2')->table('international_diploma_certificates')->find($data['certificates_requests_product_id']);
                if ($international_diploma_certificates) {
                    $certificate_request->certification_code = $international_diploma_certificates->serial_number;
                }
            }
            if(!$certificate_request->certification_code){
                $errorMessage = 'Error no certification code found';
                return view('auth.message.error_message', compact('errorMessage'));
            }
//            $certificate_request->date_of_completion=$data['certificates_requests_date_of_completion'];
//            $certificate_request->certification_code=$data['certificates_requests_certificate_code'];
            $certificate_request->opened_date = date('Y-m-d H:i:s');
            $certificate_request->added_at = date('Y-m-d H:i:s');
            $certificate_request->added_by = Auth::user()->id;
            if ($certificate_request->save()) {
                if ($request->certificates_requests_comment) {
                    $user = Auth::user();
                    ($user)->comment($certificate_request, $request->certificates_requests_comment);
                }
                log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'certificates_requests', $certificate_request->id, json_encode($certificate_request));
                $errorMessage = 'Certificate request added successfully';
                return view('auth.message.success_message', compact('errorMessage'));
            }
            $errorMessage = 'Error occurred try again';
            return view('auth.message.error_message', compact('errorMessage'));
        }
    }

    public function certificates_requests()
    {
        $certificatesData = null;
        $status = ['opened', 'done', 'cancelled'/*,'Prepared EGY','Prepared KSA','Delivered to Customer'*/];
        if (PerUser('certificates_requests_dashboard')) {
            $otherQueries = '';
            foreach ($status as $key => $value) {
                $replaceSpaces = str_replace(' ', '_', $value);
                if ($key != count($status)) {
                    $otherQueries .= ',';
                }
                $otherQueries .= "(SELECT COUNT('x') FROM certificates_requests AS " . $replaceSpaces . "CertificateRequest WHERE " . $replaceSpaces . "CertificateRequest.certificate=certificates_requests.certificate AND  " . $replaceSpaces . "CertificateRequest.request_status='$value') AS " . $replaceSpaces . "";
            }
            $query = "SELECT certificate,COUNT('X')AS totalCount$otherQueries FROM `certificates_requests` WHERE certificate IS NOT NULL GROUP BY certificate";
            $certificatesData = DB::connection('mysql2')->select($query);
        }
        return view('auth.certificates_requests.view', compact('certificatesData', 'status'));
    }

    public function certificates_requests_search(Request $request)
    {

        $data = $request->input();
        $adminUserId = 0;

        if (PerUser('certificates_requests_show_all')) {
            $certificates_requests = CertificatesRequests::select('certificates_requests.*')->with('LastComment');
        } else {
            $adminUserId = Auth::user()->id;
            $certificates_requests = CertificatesRequests::select('certificates_requests.*')->with('LastComment')->where("certificates_requests.added_by", $adminUserId);
        }
        $certificates_requests=$certificates_requests
            ->addSelect('country.arab_name as country_name','states.arab_name AS state_name','users.gender')
            ->leftJoin('users','users.id','=','certificates_requests.user_id')
            ->leftJoin('country','country.id','=','certificates_requests.country_id')
            ->leftJoin('states','states.id','=','certificates_requests.state_id')
        ;
        //dd($certificates_requests->toSql());
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $certificates_requests = $certificates_requests->where('certificates_requests.id', '=', "$id");
        }
        if (isset($data['country']) && !empty($data['country'])) {
            $country = $data['country'];
            $certificates_requests = $certificates_requests->where('country.arab_name', 'LIKE', "%$country%");
        }
        if (isset($data['state']) && !empty($data['state'])) {
            $state = $data['state'];
            $certificates_requests = $certificates_requests->where('states.arab_name', 'LIKE', "%$state%");
        }
        if (isset($data['customer_name']) && !empty($data['customer_name'])) {
            $customer_name = $data['customer_name'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_name', 'LIKE', "%$customer_name%");
        }
        if (isset($data['customer_gender']) && !empty($data['customer_gender'])) {
            $customer_gender = $data['customer_gender'];
            $certificates_requests = $certificates_requests->where('users.gender', 'LIKE', "%$customer_gender%");
        }
        if (isset($data['customer_contact']) && !empty($data['customer_contact'])) {
            $customer_contact = $data['customer_contact'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_contact', 'LIKE', "%$customer_contact%");
        }
        if (isset($data['customer_email']) && !empty($data['customer_email'])) {
            $customer_email = $data['customer_email'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_email', 'LIKE', "%$customer_email%");
        }
        if (isset($data['product']) && !empty($data['product'])) {
            $product = $data['product'];
            $certificates_requests = $certificates_requests->where('certificates_requests.product', 'LIKE', "%$product%");
        }
        if (isset($data['certificate']) && !empty($data['certificate'])) {
            $certificate = $data['certificate'];
            $certificates_requests = $certificates_requests->where('certificates_requests.certificate', 'LIKE', "%$certificate%");
        }
        if (isset($data['address']) && !empty($data['address'])) {
            $address = $data['address'];
            $certificates_requests = $certificates_requests->where('certificates_requests.address', 'LIKE', "%$address%");
        }
        if (isset($data['customer_name_on_certificate']) && !empty($data['customer_name_on_certificate'])) {
            $customer_name_on_certificate = $data['customer_name_on_certificate'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_name_on_certificate', 'LIKE', "%$customer_name_on_certificate%");
        }
        if (isset($data['request_time_from']) && !empty($data['request_time_from']) && isset($data['request_time_to']) && !empty($data['request_time_to'])) {
            $request_time_from = $data['request_time_from'];
            $request_time_to = $data['request_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.request_date', [$request_time_from . ' 00:00:00', $request_time_to . ' 23:59:59']);
        }
        if (isset($data['request_status']) && !empty($data['request_status'])) {
            $request_status = $data['request_status'];
            $certificates_requests = $certificates_requests->where('certificates_requests.request_status', 'LIKE', "%$request_status%");
        }
        if (isset($data['request_time_from']) && !empty($data['request_time_from']) && isset($data['request_time_to']) && !empty($data['request_time_to'])) {
            $request_time_from = $data['request_time_from'];
            $request_time_to = $data['request_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.request_date', [$request_time_from . ' 00:00:00', $request_time_to . ' 23:59:59']);
        }
        if (isset($data['done_time_from']) && !empty($data['done_time_from']) && isset($data['done_time_to']) && !empty($data['done_time_to'])) {
            $done_time_from = $data['done_time_from'];
            $done_time_to = $data['done_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.done_date', [$done_time_from . ' 00:00:00', $done_time_to . ' 23:59:59']);
        }
        if (isset($data['cancelled_time_from']) && !empty($data['cancelled_time_from']) && isset($data['cancelled_time_to']) && !empty($data['cancelled_time_to'])) {
            $cancelled_time_from = $data['cancelled_time_from'];
            $cancelled_time_to = $data['cancelled_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.cancelled_date', [$cancelled_time_from . ' 00:00:00', $cancelled_time_to . ' 23:59:59']);
        }
//        if (isset($data['completion_time_from']) && !empty($data['completion_time_from']) && isset($data['completion_time_to']) && !empty($data['completion_time_to'])) {
//            $completion_time_from = $data['completion_time_from'];
//            $completion_time_to = $data['completion_time_to'];
//            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.date_of_completion', [$completion_time_from .' 00:00:00', $completion_time_to.' 23:59:59']);
//        }
        if (isset($data['certification_code']) && !empty($data['certification_code'])) {
            $certification_code = $data['certification_code'];
            $certificates_requests = $certificates_requests->where('certificates_requests.certification_code', 'LIKE', "%$certification_code%");
        }
        if (isset($data['certificate_date_from']) && !empty($data['certificate_date_from']) && isset($data['certificate_date_to']) && !empty($data['certificate_date_to'])) {
            $certificate_date_from = $data['certificate_date_from'];
            $certificate_date_to = $data['certificate_date_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.certificate_date', [$certificate_date_from, $certificate_date_to]);
        }
        if (isset($data['diploma_start_date']) && !empty($data['diploma_start_date'])) {
            $diploma_start_date = $data['diploma_start_date'];
            $certificates_requests = $certificates_requests->where('certificates_requests.diploma_start_date', 'LIKE', "%$diploma_start_date%");
        }

        if (isset($data['diploma_end_date']) && !empty($data['diploma_end_date'])) {
            $diploma_end_date = $data['diploma_end_date'];
            $diploma_end_date = $certificates_requests->where('certificates_requests.diploma_end_date', 'LIKE', "%$diploma_end_date%");
        }

        $iTotalRecords = $certificates_requests->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'certificates_requests.id';
        switch ($data['order'][0]['column']) {
            case 0:
                $columnName = 'certificates_requests.id';
                break;
            case 1:
                $columnName = 'certificates_requests.country_id';
                break;
            case 2:
                $columnName = 'certificates_requests.state_id';
                break;
            case 3:
                $columnName = 'certificates_requests.customer_name';
                break;
            case 4:
                $columnName = 'users.gender';
                break;
            case 5:
                $columnName = 'certificates_requests.customer_contact';
                break;
            case 6:
                $columnName = 'certificates_requests.customer_email';
                break;
            case 7:
                $columnName = 'certificates_requests.product';
                break;
            case 8:
                $columnName = 'certificates_requests.certificate';
                break;
            case 9:
                $columnName = 'certificates_requests.customer_name_on_certificate';
                break;
            case 10:
                $columnName = 'certificates_requests.request_date';
                break;
            case 11:
                $columnName = 'certificates_requests.request_status';
                break;
//            case 9:
//                $columnName = 'certificates_requests.date_of_completion';
//                break;
            case 12:
                $columnName = 'certificates_requests.certification_code';
                break;
            case 13:
                $columnName = 'certificates_requests.certificate_date';
                break;
            case 14:
                $columnName = 'last_comment';
                break;
            case 15:
                $columnName = 'certificates_requests.done_date';
                break;
            case 16:
                $columnName = 'certificates_requests.cancelled_date';
                break;
            case 17:
                $columnName = 'certificates_requests.address';
                break;
            case 18:
                $columnName = 'certificates_requests.diploma_start_date';
                break;
            case 19:
                $columnName = 'certificates_requests.diploma_end_date';
                break;
            case 20:
                $columnName = 'certificates_requests.id';
                break;

        }

        $search = $data['search']['value'];
        if ($search) {
            $certificates_requests = $certificates_requests->where(function ($q) use ($search) {
                $q->where('certificates_requests.customer_name', 'LIKE', "%$search%")
                    ->orWhere('users.gender', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.customer_contact', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.customer_email', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.product', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.certificate', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.customer_name_on_certificate', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.request_status', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.certification_code', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.address', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.diploma_start_date', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.diploma_end_date', 'LIKE', "%$search%")
                    ->orWhere('certificates_requests.id', '=', $search);
            });
        }

        $certificates_requests = $certificates_requests->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();

        foreach ($certificates_requests as $certificate_request) {
            $product_id = '';
            $hours_count = 0;
            $added_by = 0;
            $supportAdminUserName = "";

            $customerEmail = $certificate_request->customer_email;
            $user = AcademyUsers::where('Email', $customerEmail)->first();
            $customerId = $user->id;

            if ($certificate_request->product == 'Courses') {

                $pr = CoursesCurriculumCertificates::find($certificate_request->product_id);

                if ($pr) {

                    $course = Courses::find($pr->course_id);
                    if ($course) {
                        $product_id = $course->name;
                    }

                    $hours_count = $this->getCourseHours($pr->course_id, $customerId);

                }

            } elseif ($certificate_request->product == 'Diplomas') {

                $pr = DiplomaCertificates::find($certificate_request->product_id);

                if ($pr) {

                    $diploma = Diplomas::where('published', 'yes')->find($pr->diploma_id);
                    if ($diploma) {
                        $product_id = $diploma->name;
                    }

//                    $diplomasUsersCourses = DiplomasUsersCourses::where([
//                        ["diploma_id","=",$pr->diploma_id],
//                        ["user_id","=",$customerId]
//                    ])->get();
//                    $arr=[];
//                    foreach($diplomasUsersCourses as $diplomaUserCourse) {
//
//                        $arr[]=$this->getCourseHours($diplomaUserCourse->course_id, $customerId);
//
//                    }
                    $coursesIds = DiplomasUsersCourses::where('diploma_id', $pr->diploma_id)->where('user_id', $customerId)->pluck('course_id')->toArray();
                    $times = CoursesCurriculum::whereIn('course_id', $coursesIds)->pluck('duration')->toArray();
                    $hours_count = calculateSecond($times);
                }
            } elseif ($certificate_request->product == 'New Mba') {
                $pr = NewMbaCategory::find($certificate_request->product_id);
                if ($pr) {
                    $product_id = $pr->name;
                }
            } elseif ($certificate_request->product == 'MBA') {

//                $pr = MbaCertificates::find($certificate_request->product_id);
//
//                if($pr) {
//
//                    $mbaCoursesUsersPlans = MbaCoursesUserPlan::where("user_id", $customerId)->get();
//
//                    foreach($mbaCoursesUsersPlans as $mbaCourseUserPlan) {
//
//                        $hours_count += $this->getCourseHours($mbaCourseUserPlan->related_course, $customerId);
//
//                    }
//
//                }

                $hours_count = 350;

            }

            if (isset($certificate_request->added_by) && !empty($certificate_request->added_by)) {
                $added_by = $certificate_request->added_by;
                $supportAdminUserInfo = User::where('id', $added_by)->first();
                $supportAdminUserName = $supportAdminUserInfo->name;

            }
//            if (($certificate_request->request_status) == "opened") {
//                $action = '<div class="btn-group text-center" id="single-order-' . $certificate_request->id . '">
//                        <button class="btn green btn-xs btn-outline dropd
//
//
//                        own-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
//                            <i class="fa fa-angle-down"></i>
//                        </button>
//                        <ul class="dropdown-menu pull-right">
//                        <li>
//                                <a href="' . URL('admin/certificates_requests/' . $certificate_request->id . '/edit') . '">
//                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
//                                </a>
//                            </li>
//                        </ul>
//                    </div>';
//
//            } else {
//                $action = '<div class="btn-group text-center" id="single-order-' . $certificate_request->id . '">
//                    <button class="btn green btn-xs btn-outline dropdown-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
//                        <i class="fa fa-angle-down"></i>
//                    </button>
//                    <ul class="dropdown-menu pull-right">
//                    ' . ((PerUser('certificates_requests_edit')) ? '<li>
//                            <a href="' . URL('admin/certificates_requests/' . $certificate_request->id . '/edit') . '">
//                                <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
//                            </a>
//                        </li>' : '') . '
//                    </ul>
//                </div>';
//            }
            $action='<div class="btn-group text-center">
                        <button class="btn green btn-xs btn-outline dropd
                        
                        
                        own-toggle" data-toggle="dropdown">' . Lang::get('main.action') . '
                            <i class="fa fa-angle-down"></i>
                        </button>
                        <ul class="dropdown-menu pull-right">';
            if(PerUser('certificates_requests_edit')){
                $action .= '
                        <li>
                                <a href="' . URL('admin/certificates_requests/' . $certificate_request->id . '/edit') . '">
                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.edit') . '
                                </a>
                            </li>
                       ';
            }
            if(PerUser('certificates_requests_view_edit')){
                $action .= '
                        <li>
                                <a href="' . URL('admin/certificates_requests/' . $certificate_request->id . '/view') . '">
                                    <i class="fa fa-comments-o"></i> ' . Lang::get('main.view') . '
                                </a>
                            </li>
                       ';
            }

            $action.=' </ul>
                    </div>';
            $status = '';


//if($certificate_request->request_status =='opened'){}
            $records["data"][] = [
                $certificate_request->id,
                $certificate_request->country_name,
                $certificate_request->state_name,
                $certificate_request->customer_name,
                $certificate_request->gender,
                $certificate_request->customer_contact,
                $certificate_request->customer_email,
                $certificate_request->product,
                $certificate_request->certificate,
                $certificate_request->customer_name_on_certificate,
                $this->handleDate($certificate_request->request_date, $certificate_request->certificates_requests_language),
                // "<a data-url='/post' id='request_status' data-type='select' data-pk='1' >". $certificate_request->request_status ."</a>",
                ((PerUser('certificates_requests_change_status') || (PerUser('certificates_requests_canceled_only') && $certificate_request->request_status == 'opened')) ? '<a href="#"  class="edit-status"  data-type="select" data-value="' . $certificate_request->request_status . '" data-pk="' . $certificate_request->id . '"  data-name="' . $certificate_request->request_status . '">' . $certificate_request->request_status . '</a>' : $certificate_request->request_status),
                //$certificate_request->date_of_completion,  onclick='editstatus(".$certificate_request->id.")'
                $certificate_request->certification_code,
                $certificate_request->certificate_date,
                ($certificate_request->LastComment) ? $certificate_request->LastComment->text : '',
                $this->handleDate($certificate_request->done_date, $certificate_request->certificates_requests_language),
                $this->handleDate($certificate_request->cancelled_date, $certificate_request->certificates_requests_language),
                $certificate_request->address,
                $product_id,
                $supportAdminUserName,
                $this->handleDate($certificate_request->diploma_start_date, $certificate_request->certificates_requests_language),
                $this->handleDate($certificate_request->diploma_end_date, $certificate_request->certificates_requests_language),
                $hours_count,
                $action
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function certificates_requests_export(Request $request)
    {
        $data = $request->input();
        $adminUserId = 0;

        if (PerUser('certificates_requests_show_all')) {
            $certificates_requests = CertificatesRequests::select('certificates_requests.*')->with('LastComment');
        } else {
            $adminUserId = Auth::user()->id;
            $certificates_requests = CertificatesRequests::select('certificates_requests.*')->with('LastComment')->where("added_by", $adminUserId);
        }
        $certificates_requests=$certificates_requests
            ->addSelect('country.arab_name as country_name','states.arab_name AS state_name','users.gender')
            ->leftJoin('users','users.id','=','certificates_requests.user_id')
            ->leftJoin('country','country.id','=','certificates_requests.country_id')
            ->leftJoin('states','states.id','=','certificates_requests.state_id')
        ;
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $certificates_requests = $certificates_requests->where('certificates_requests.id', '=', "$id");
        }
        if (isset($data['customer_name']) && !empty($data['customer_name'])) {
            $customer_name = $data['customer_name'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_name', 'LIKE', "%$customer_name%");
        }
        if (isset($data['customer_gender']) && !empty($data['customer_gender'])) {
            $customer_gender = $data['customer_gender'];
            $certificates_requests = $certificates_requests->where('users.gender', 'LIKE', "%$customer_gender%");
        }
        if (isset($data['customer_contact']) && !empty($data['customer_contact'])) {
            $customer_contact = $data['customer_contact'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_contact', 'LIKE', "%$customer_contact%");
        }
        if (isset($data['customer_email']) && !empty($data['customer_email'])) {
            $customer_email = $data['customer_email'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_email', 'LIKE', "%$customer_email%");
        }
        if (isset($data['product']) && !empty($data['product'])) {
            $product = $data['product'];
            $certificates_requests = $certificates_requests->where('certificates_requests.product', 'LIKE', "%$product%");
        }
        if (isset($data['certificate']) && !empty($data['certificate'])) {
            $certificate = $data['certificate'];
            $certificates_requests = $certificates_requests->where('certificates_requests.certificate', 'LIKE', "%$certificate%");
        }
        if (isset($data['address']) && !empty($data['address'])) {
            $address = $data['address'];
            $certificates_requests = $certificates_requests->where('certificates_requests.address', 'LIKE', "%$address%");
        }
        if (isset($data['customer_name_on_certificate']) && !empty($data['customer_name_on_certificate'])) {
            $customer_name_on_certificate = $data['customer_name_on_certificate'];
            $certificates_requests = $certificates_requests->where('certificates_requests.customer_name_on_certificate', 'LIKE', "%$customer_name_on_certificate%");
        }
        if (isset($data['request_time_from']) && !empty($data['request_time_from']) && isset($data['request_time_to']) && !empty($data['request_time_to'])) {
            $request_time_from = $data['request_time_from'];
            $request_time_to = $data['request_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.request_date', [$request_time_from . ' 00:00:00', $request_time_to . ' 23:59:59']);
        }
        if (isset($data['request_status']) && !empty($data['request_status'])) {
            $request_status = $data['request_status'];
            $certificates_requests = $certificates_requests->where('certificates_requests.request_status', 'LIKE', "%$request_status%");
        }
        if (isset($data['request_time_from']) && !empty($data['request_time_from']) && isset($data['request_time_to']) && !empty($data['request_time_to'])) {
            $request_time_from = $data['request_time_from'];
            $request_time_to = $data['request_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.request_date', [$request_time_from . ' 00:00:00', $request_time_to . ' 23:59:59']);
        }
        if (isset($data['done_time_from']) && !empty($data['done_time_from']) && isset($data['done_time_to']) && !empty($data['done_time_to'])) {
            $done_time_from = $data['done_time_from'];
            $done_time_to = $data['done_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.done_date', [$done_time_from . ' 00:00:00', $done_time_to . ' 23:59:59']);
        }
        if (isset($data['cancelled_time_from']) && !empty($data['cancelled_time_from']) && isset($data['cancelled_time_to']) && !empty($data['cancelled_time_to'])) {
            $cancelled_time_from = $data['cancelled_time_from'];
            $cancelled_time_to = $data['cancelled_time_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.cancelled_date', [$cancelled_time_from . ' 00:00:00', $cancelled_time_to . ' 23:59:59']);
        }

        if (isset($data['certification_code']) && !empty($data['certification_code'])) {
            $certification_code = $data['certification_code'];
            $certificates_requests = $certificates_requests->where('certificates_requests.certification_code', 'LIKE', "%$certification_code%");
        }
        if (isset($data['certificate_date_from']) && !empty($data['certificate_date_from']) && isset($data['certificate_date_to']) && !empty($data['certificate_date_to'])) {
            $certificate_date_from = $data['certificate_date_from'];
            $certificate_date_to = $data['certificate_date_to'];
            $certificates_requests = $certificates_requests->whereBetween('certificates_requests.certificate_date', [$certificate_date_from, $certificate_date_to]);
        }
        if (isset($data['diploma_start_date']) && !empty($data['diploma_start_date'])) {
            $diploma_start_date = $data['diploma_start_date'];
            $certificates_requests = $certificates_requests->where('certificates_requests.diploma_start_date', 'LIKE', "%$diploma_start_date%");
        }

        if (isset($data['diploma_end_date']) && !empty($data['diploma_end_date'])) {
            $diploma_end_date = $data['diploma_end_date'];
            $diploma_end_date = $certificates_requests->where('certificates_requests.diploma_end_date', 'LIKE', "%$diploma_end_date%");
        }

        $certificates_requests = $certificates_requests->get();
        $output = ['ID',Lang::get('main.country'),Lang::get('main.state'), Lang::get('main.name'), Lang::get('main.genderr'), Lang::get('main.contact'), Lang::get('main.email'), Lang::get('main.product'), Lang::get('main.certificate')
            , Lang::get('main.customer_name_on_certificate'), Lang::get('main.request_date'), Lang::get('main.request_status'), Lang::get('main.certification_code'), Lang::get('main.certificate_date'), Lang::get('main.last_comment')
            , Lang::get('main.done_date'), Lang::get('main.cancelled_date'), Lang::get('main.address'), Lang::get('main.product_id'), Lang::get('main.added_by'), Lang::get('main.diploma_start_date'), Lang::get('main.diploma_end_date'), Lang::get('main.hours_count')];
        $filename = "certificates_requests.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);
        foreach ($certificates_requests as $certificate_request) {
            $product_id = '';
            $hours_count = 0;
            $added_by = 0;
            $supportAdminUserName = "";

            $customerEmail = $certificate_request->customer_email;
            $user = AcademyUsers::where('Email', $customerEmail)->first();
            $customerId = $user->id;

            if ($certificate_request->product == 'Courses') {

                $pr = CoursesCurriculumCertificates::find($certificate_request->product_id);

                if ($pr) {

                    $course = Courses::find($pr->course_id);
                    if ($course) {
                        $product_id = $course->name;
                    }

                    $hours_count = $this->getCourseHours($pr->course_id, $customerId);

                }

            } elseif ($certificate_request->product == 'Diplomas') {

                $pr = DiplomaCertificates::find($certificate_request->product_id);

                if ($pr) {

                    $diploma = Diplomas::where('published', 'yes')->find($pr->diploma_id);
                    if ($diploma) {
                        $product_id = $diploma->name;
                    }


                    $coursesIds = DiplomasUsersCourses::where('diploma_id', $pr->diploma_id)->where('user_id', $customerId)->pluck('course_id')->toArray();
                    $times = CoursesCurriculum::whereIn('course_id', $coursesIds)->pluck('duration')->toArray();
                    $hours_count = calculateSecond($times);
                }
            } elseif ($certificate_request->product == 'New Mba') {
                $pr = NewMbaCategory::find($certificate_request->product_id);
                if ($pr) {
                    $product_id = $pr->name;
                }
            } elseif ($certificate_request->product == 'MBA') {

                $hours_count = 350;

            }

            if (isset($certificate_request->added_by) && !empty($certificate_request->added_by)) {
                $added_by = $certificate_request->added_by;
                $supportAdminUserInfo = User::where('id', $added_by)->first();
                $supportAdminUserName = $supportAdminUserInfo->name;

            }

            $status = '';

            fputcsv($handle, [
                $certificate_request->id,
                $certificate_request->country_name,
                $certificate_request->state_name,
                $certificate_request->customer_name,
                $certificate_request->gender,
                $certificate_request->customer_contact,
                $certificate_request->customer_email,
                $certificate_request->product,
                $certificate_request->certificate,
                $certificate_request->customer_name_on_certificate,
                $this->handleDate($certificate_request->request_date, $certificate_request->certificates_requests_language),
                $certificate_request->request_status,
                $certificate_request->certification_code,
                $certificate_request->certificate_date,
                ($certificate_request->LastComment) ? $certificate_request->LastComment->text : '',
                $this->handleDate($certificate_request->done_date, $certificate_request->certificates_requests_language),
                $this->handleDate($certificate_request->cancelled_date, $certificate_request->certificates_requests_language),
                $certificate_request->address,
                $product_id,
                $supportAdminUserName,
                $this->handleDate($certificate_request->diploma_start_date, $certificate_request->certificates_requests_language),
                $this->handleDate($certificate_request->diploma_end_date, $certificate_request->certificates_requests_language),
                $hours_count
            ]);
        }


        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="certificates_requests.csv"'
        );
        return Response::download($filename, 'certificates_requests.csv', $headers);
    }

    public function certificatesRequestsChangeStatus(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doCertificatesRequestsChangeStatus($request);
        }
    }

    public function certificatesRequestsView($id, Request $request)
    {
        $certificate_request = CertificatesRequests::findOrFail($id);
        $product_id = '';
        //dd($certificate_request->comments[0]->commentator());
        //dd($certificate_request->comments[0]->children()->get());
        if ($certificate_request->product == 'Courses') {
            $pr = CoursesCurriculumCertificates::find($certificate_request->product_id);
            if ($pr) {
                $course = Courses::find($pr->course_id);
                if ($course) {
                    $product_id = $course->name;
                }
            }
        } elseif ($certificate_request->product == 'Diplomas') {
            $pr = DiplomaCertificates::find($certificate_request->product_id);
            if ($pr) {
                $diploma = Diplomas::where('published', 'yes')->find($pr->diploma_id);
                if ($diploma) {
                    $product_id = $diploma->name;
                }
            }
        } elseif ($certificate_request->product == 'New Mba') {
            $pr = NewMbaCategory::find($certificate_request->product_id);
            if ($pr) {
                $product_id = $pr->name;
            }
        }
        return view('auth.certificates_requests.edit', compact('certificate_request', 'product_id'));
    }
    public function certificatesRequestsEdit($id, Request $request)
    {
        $certificate_request = CertificatesRequests::findOrFail($id);
        $product_id = '';
        //dd($certificate_request->comments[0]->commentator());
        //dd($certificate_request->comments[0]->children()->get());
        if ($certificate_request->product == 'Courses') {
            $pr = CoursesCurriculumCertificates::find($certificate_request->product_id);
            if ($pr) {
                $course = Courses::find($pr->course_id);
                if ($course) {
                    $product_id = $course->name;
                }
            }
        } elseif ($certificate_request->product == 'Diplomas') {
            $pr = DiplomaCertificates::find($certificate_request->product_id);
            if ($pr) {
                $diploma = Diplomas::where('published', 'yes')->find($pr->diploma_id);
                if ($diploma) {
                    $product_id = $diploma->name;
                }
            }
        } elseif ($certificate_request->product == 'New Mba') {
            $pr = NewMbaCategory::find($certificate_request->product_id);
            if ($pr) {
                $product_id = $pr->name;
            }
        }
        return view('auth.certificates_requests.edit', compact('certificate_request', 'product_id'));
    }

    public function doCertificatesRequestsEdit(Request $request, $id)
    {
        $data = $request->input();
        $certificate_request = CertificatesRequests::findOrFail($id);
        $old_status = $certificate_request->request_status;
        $validator = Validator::make($request->all(),
            array(
//                'certification_code' =>'required',
                'customer_name_on_certificate' => 'required',
                'status' => 'required',
                'language' => 'required',
                'address' => 'required',
            ));

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator->errors())->withInput();
        } else {
//            $certificate_request->certification_code = $data['certification_code'];
            $certificate_request->customer_name_on_certificate = $data['customer_name_on_certificate'];
            $certificate_request->request_status = $data['status'];
            $certificate_request->language = $data['language'];
            $certificate_request->address = $data['address'];
            $certificate_request->lastedited_by = Auth::user()->id;
            $certificate_request->lastedited_at = date("Y-m-d H:i:s");
            if ($certificate_request->save()) {
                if ($certificate_request->request_status != $old_status) {
                    if ($certificate_request->request_status == 'opened') {
                        $certificate_request->opened_date = date("Y-m-d H:i:s");
                        $certificate_request->save();
                    } elseif ($certificate_request->request_status == 'done') {
                        $certificate_request->done_date = date("Y-m-d H:i:s");
                        $certificate_request->save();
                    } elseif ($certificate_request->request_status == 'cancelled') {
                        $certificate_request->cancelled_date = date("Y-m-d H:i:s");
                        $certificate_request->save();
                    }
                    $certificate_request_status_log = new CertificatesRequestsStatusLog();
                    $certificate_request_status_log->certificate_request_id = $certificate_request->id;
                    $certificate_request_status_log->old_status = $old_status;
                    $certificate_request_status_log->new_status = $certificate_request->request_status;
                    $certificate_request_status_log->added_date = date('Y-m-d H:i:s');
                    $certificate_request_status_log->added_by = Auth::user()->id;
                    $certificate_request_status_log->save();
                }
                Session::flash('success', Lang::get('main.update') . Lang::get('main.certificates_requests'));
                return Redirect::to("admin/certificates_requests/$certificate_request->id/edit");
            }
        }
    }

    public function activeCharge(Request $request)
    {
        $data = $request->input();
        $id = $data['id'];
        if ($data['type'] == 'lite') {
            $transaction = LiteVersionChargeTransaction::findOrFail($id);
        } elseif ($data['type'] == 'diplomas') {
            $transaction = DiplomasChargeTransaction::findOrFail($id);
        }elseif ($data['type'] == 'packages') {
            $transaction = PackagessChargeTransaction::findOrFail($id);
        }elseif ($data['type'] == 'custom') {
            $transaction = CustomChargeTransaction::findOrFail($id);
        } elseif ($data['type'] == 'training_program') {
            $transaction = TrainingProgramsChargeTransaction::findOrFail($id);
        } elseif ($data['type'] == 'international_diplomas') {
            $transaction = InternationalDiplomasChargeTransaction::findOrFail($id);
        } elseif ($data['type'] == 'medical') {
            $transaction = MedicalChargeTransactions::findOrFail($id);
        } elseif ($data['type'] == 'medical_diplomas') {
            $transaction = MedicalDiplomasChargeTransaction::findOrFail($id);
        } elseif ($data['type'] == 'mba') {
            $transaction = MbaChargeTransaction::findOrFail($id);
        } elseif ($data['type'] == 'normal') {
            $transaction = ChargeTransaction::findOrFail($id);
        } elseif (in_array($data['type'], ['consultant_career_coaching_charge_transaction', 'consultant_cv_hr_interview_charge_transaction', 'consultant_technical_interview_charge_transaction'])) {
            $transaction = \Illuminate\Support\Facades\DB::connection('mysql2')->table($data['type'])->findOrFail($id);
        } else {
            return response()->json(['succeess' => false]);
        }

        if ($transaction->pending == 1) {
            $old_start_date = $transaction->start_date;
            $old_end_date = $transaction->end_date;
            $transaction->pending = 0;
            if ($data['type'] == 'mba') {
                $trans = MbaChargeTransaction::where('user_id', $transaction->user_id)->OrderBY('createtime', 'DESC')->skip(1)->take(1)->first();
            } else {
                $trans = ChargeTransaction::where('user_id', $transaction->user_id)->OrderBY('createtime', 'DESC')->skip(1)->take(1)->first();
            }
            if (date('Y-m-d H:i:s') <= $trans->end_date) {
                $start_date = $trans->end_date;
                if ($transaction->period == '0.5') {
                    $end_date = date('Y-m-d H:i:s', strtotime($start_date . ' +15 days'));
                } elseif ($transaction->period == '0.25') {
                    $end_date = date('Y-m-d H:i:s', strtotime($start_date . ' +7 days'));
                } else {
                    $end_date = date('Y-m-d H:i:s', strtotime($start_date . ' +' . $transaction->period . ' month'));
                }
            } else {
                $start_date = date('Y-m-d H:i:s');
                //end_date=($period=='0.5')?date('Y-m-d H:i:s',strtotime($date.' +15 days')):date('Y-m-d H:i:s',strtotime($date.' +'.$period.' month'));
                if ($transaction->period == '0.5') {
                    $end_date = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' +15 days'));
                } elseif ($transaction->period == '0.25') {
                    $end_date = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' +7 days'));
                } else {
                    $end_date = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' +' . $transaction->period . ' month'));
                }
            }
//            $start_date=date('Y-m-d H:i:s');
//            if($transaction->period=='0.5'){
//                $end_date=date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s').' +15 days'));
//            }elseif($transaction->period=='0.25'){
//                $end_date=date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s').' +7 days'));
//            }else{
//                $end_date=date('Y-m-d H:i:s',strtotime(date('Y-m-d H:i:s').' +'.$transaction->period.' month'));
//            }
            if ($data['type'] == 'mba') {
                $last_charge = MbaChargeTransaction::where('id', '<>', $id)->where('user_id', $transaction->user_id)->orderBy('id', 'desc')->first();
                if ($last_charge) {
                    $start_date = $last_charge->end_date;
                    $end_date = date('Y-m-d H:i:s', strtotime($start_date . " +$transaction->period months"));
                }
            }
            $transaction->start_date = $start_date;
            $transaction->end_date = $end_date;
            $transaction->save();
            sendChargeTransaction($transaction->id);
            $log = new ActiveChargeTransactionLog();
            $log->transaction_id = $transaction->id;
            $log->transaction_type = $transaction->getTable();
            $log->old_start_date = $old_start_date;
            $log->old_end_date = $old_end_date;
            $log->new_start_date = $transaction->start_date;
            $log->new_end_date = $transaction->end_date;
            $log->user_id = $transaction->user_id;
            $log->employee_id = $transaction->employee_id;
            $log->added_date = date('Y-m-d H:i:s');
            $log->added_by = Auth::user()->id;
            $log->save();
            updateAcademyChargeTransaction($transaction->user_id);
            return response()->json(['success' => true, 'start_date' => date('Y-m-d H:i:s'), 'end_date' => $end_date]);

        }
        return response()->json(['succeess' => false]);

    }

    public function getYottaCoursesReportAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            echo $this->doGetYottaCoursesReportAjax($request);
        }
    }

    public function getYottaCoursesExamsAjax(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            return response()->json($this->doGetYottaCoursesExamsAjax($request));
        }
    }


    public function getCertificatesByProduct(Request $request)
    {
        $output = array();
        $params = $request->all();
        $product = $params['product'];
        $email = $params['email'];
        $user = AcademyUsers::where('Email', $email)->first();
        $return1 = '<option value = "" >product id</option>';
        $return2 = '<option value = "" >certificate</option>';

        if ($product == 'MBA') {
            $mba_certificate = MbaCertificates::where('mba_certificates.user_id', $user->id)->first();
            if ($mba_certificate) {
                $return1 .= '<option value="' . $mba_certificate->id . '">MBA</option>';
            }
            $return2 .= '
                 <option value = "SSBM">SSBM</option>
                 <option value = "EBU">EBU</option>
                 <option value = "التوثيق الخارجية الامريكية"> 
                        التوثيق الخارجيه الامريكيه
                  </option>
                   <option value = "التوثيق الخارجية المصريه"> 
                        التوثيق الخارجيه المصريه
                  </option>
                 <option value = "الجامعة الماليزية">
                 الجامعة الماليزية
                 </option>
                 <option value = "شهادة اكاديمية اعمل بيزنس">
                 شهاده اكاديميه اعمل بيزنس
                 </option>
                  <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option>
            ';
        }elseif ($product == 'Preparatory MBA') {
            $mba_certificate = PreparatoryMbaCertificates::where('user_id', $user->id)->first();
            if ($mba_certificate) {
                $return1 .= '<option value="' . $mba_certificate->id . '">Preparatory MBA</option>';
            }
            $return2 .= '
                 <option value = "SSBM">SSBM</option>
                 <option value = "EBU">EBU</option>
                 <option value = "التوثيق الخارجية الامريكية"> 
                        التوثيق الخارجيه الامريكيه
                  </option>
                  <option value = "التوثيق الخارجية المصريه"> 
                        التوثيق الخارجيه المصريه
                  </option>
                 <option value = "الجامعة الماليزية">
                 الجامعة الماليزية
                 </option>
                 <option value = "شهادة اكاديمية اعمل بيزنس">
                 شهاده اكاديميه اعمل بيزنس
                 </option>
                  <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option>
            ';
        } elseif ($product == 'Courses') {
            $courses_certificates = CoursesCurriculumCertificates::select('courses_curriculum_certificates.*', 'courses.name as course_name')
                ->join('courses', 'courses.id', '=', 'courses_curriculum_certificates.course_id')
                ->where('courses_curriculum_certificates.user_id', $user->id)->get();
            if ($courses_certificates) {
                foreach ($courses_certificates as $certificate) {
                    $return1 .= '<option value="' . $certificate->id . '">' . $certificate->course_name . '</option>';
                }
            }

            $return2 .= '
                 <option value = "EBU">EBU</option>
                 <option value = "شهادة اكاديمية اعمل بيزنس">
                 شهادة اكاديمية اعمل بيزنس
                 </option>
                  <option value = "اعتماد المعهد القومي للجودة">
             اعتماد المعهد القومي للجودة
                </option>
            ';

        } elseif ($product == 'Diplomas') {
            $diplomas_certificates = DiplomaCertificates::select('diploma_certificates.*', 'diplomas.name as diploma_name')
                ->join('diplomas', 'diplomas.id', '=', 'diploma_certificates.diploma_id')
                ->where('diploma_certificates.user_id', $user->id)->get();
            if ($diplomas_certificates) {
                foreach ($diplomas_certificates as $certificate) {
                    $return1 .= '<option value="' . $certificate->id . '">' . $certificate->diploma_name . '</option>';
                }
            }

            $return2 .= '
                <option value = "EBU">EBU</option>
                <option value = "شهادة اكاديمية اعمل بيزنس">
                شهادة اكاديمية اعمل بيزنس
                </option>
                <option value = "شركة الاكاديمية">
                شركة الاكاديمية
                </option>
                <option value = "معهد الجودة">
                معهد الجودة
                </option>
                <option value = "معهد الجود + التوثيق">
                معهد الجود + التوثيق
                </option>
               <option value = "التوثيق الخارجيه الامريكيه">
               التوثيق الخارجيه الامريكيه
                </option>
               <option value = "جمعيه رياده الاعمال">
               جمعيه رياده الاعمال
                </option> 
                <option value = "مركز خدمه المجتمع بكليه ابن رشد للعلوم الاداريه">
              مركز خدمه المجتمع بكليه ابن رشد للعلوم الاداريه
                </option>
                <option value = "التوثيق والتصديق من مركز التعليم المستمر جامعه عجمان ">
                التوثيق والتصديق من مركز التعليم المستمر جامعه عجمان
                </option>
                 <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option>
            ';

        } elseif ($product == 'New Mba') {

            $new_mba_certificates = \Illuminate\Support\Facades\DB::connection('mysql2')
                ->table('new_mba_certificates')
                ->select('new_mba_certificates.id','new_mba_categories.name AS category_name')
                ->join('new_mba_categories', 'new_mba_certificates.category_id', '=', 'new_mba_categories.id')
                ->where('new_mba_certificates.user_id', $user->id)
                ->whereNull('new_mba_certificates.deleted_at')
                ->groupBy('new_mba_certificates.id','new_mba_categories.id')
                ->get();
            if ($new_mba_certificates) {
                foreach ($new_mba_certificates as $certificate) {
                    $return1 .= '<option value="' . $certificate->id . '">' . $certificate->category_name . '</option>';
                }
            }
//            $return1.='
//            <option value=" ادارة اعمال"> ادارة اعمال</option>
//            <option value=" ادارة التسويق"> ادارة التسويق</option>
//            <option value="ادارة الموارد البشرية">ادارة الموارد البشرية</option>
//            <option value="التمويل والبنوك">التمويل والبنوك</option>
//            ';
            $return2 .= '
                 <option value = "SSBM">SSBM</option>
                 <option value = "EBU">EBU</option>
                 <option value = "MARA">مارا</option>
                 <option value = "التوثيق الخارجية الامريكية"> 
                        التوثيق الخارجيه الامريكيه
                  </option>
                   <option value = "التوثيق الخارجية المصريه"> 
                        التوثيق الخارجيه المصريه
                  </option>
                 <option value = "الجامعة الماليزية">
                 الجامعة الماليزية
                 </option>
                 <option value = "شهادة اكاديمية اعمل بيزنس">
                 شهاده اكاديميه اعمل بيزنس
                 </option>
                  <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option>
                 <option value = "اعتماد المعهد القومي للجودة">
             اعتماد المعهد القومي للجودة
                </option>
            ';
        } elseif ($product == 'DBA Preliminary') {
            foreach (\Illuminate\Support\Facades\DB::connection('mysql2')->table('dba_categories')->pluck('name', 'id')->toArray() as $id => $name) {
                $return1 .= '<option value="' . $id . '">' . $name . '</option>';
            }
//            $return1.='
//            <option value=" ادارة اعمال"> ادارة اعمال</option>
//            <option value=" ادارة التسويق"> ادارة التسويق</option>
//            <option value="ادارة الموارد البشرية">ادارة الموارد البشرية</option>
//            <option value="التمويل والبنوك">التمويل والبنوك</option>
//            ';
            $return2 .= '
                 <option value = "SSBM">SSBM</option>
                 <option value = "EBU">EBU</option>
                 <option value = "التوثيق الخارجية الامريكية"> 
                        التوثيق الخارجيه الامريكيه
                  </option>
                  <option value = "التوثيق الخارجية المصريه"> 
                        التوثيق الخارجيه المصريه
                  </option>
                 <option value = "الجامعة الماليزية">
                 الجامعة الماليزية
                 </option>
                 <option value = "شهادة اكاديمية اعمل بيزنس">
                 شهاده اكاديميه اعمل بيزنس
                 </option>
                  <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option>
            ';
        }elseif ($product == 'DBA') {
            foreach (\Illuminate\Support\Facades\DB::connection('mysql2')->table('dba_certificates')->where('user_id',$user->id)->pluck('serial_number', 'id')->toArray() as $id => $name) {
                $return1 .= '<option value="' . $id . '">' . $name . '</option>';
            }
//            $return1.='
//            <option value=" ادارة اعمال"> ادارة اعمال</option>
//            <option value=" ادارة التسويق"> ادارة التسويق</option>
//            <option value="ادارة الموارد البشرية">ادارة الموارد البشرية</option>
//            <option value="التمويل والبنوك">التمويل والبنوك</option>
//            ';
            $return2 .= '
                 <option value = "EBU">EBU</option>
                 <option value = "التوثيق الخارجية الامريكية"> 
                        التوثيق الخارجيه الامريكيه
                  </option>
                  <option value = "التوثيق الخارجية المصريه"> 
                        التوثيق الخارجيه المصريه
                  </option>
                  <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                 <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option>
            ';
        } elseif ($product == 'International Diplomas') {
            $international_diploma_certificates = \Illuminate\Support\Facades\DB::connection('mysql2')->table('international_diploma_certificates')->select('international_diploma_certificates.*', 'international_diplomas.name as course_name')
                ->join('international_diplomas', 'international_diplomas.id', '=', 'international_diploma_certificates.diploma_id')
                ->where('international_diploma_certificates.user_id', $user->id)->get();
            if ($international_diploma_certificates) {
                foreach ($international_diploma_certificates as $certificate) {
                    $return1 .= '<option value="' . $certificate->id . '">' . $certificate->course_name . '</option>';
                }
            }

            $return2 .= '
                 <option value = "EBU">EBU</option>
                 <option value = "شهادة اكاديمية اعمل بيزنس">
                 شهادة اكاديمية اعمل بيزنس
                 </option>
                  <option value = "جمعيه رياده الاعمال">
               جمعيه رياده الاعمال
                </option> 
                 <option value = "التوثيق الخارجيه الامريكيه">
               التوثيق الخارجيه الامريكيه
                </option>
                 <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option> 
                <option value = "التوثيق والتصديق من مركز التعليم المستمر جامعه عجمان ">
                التوثيق والتصديق من مركز التعليم المستمر جامعه عجمان
                </option>
                 <option value = "اعتماد المعهد القومي للجودة">
             اعتماد المعهد القومي للجودة
                </option>
            ';

        } elseif ($product == 'Training Programs') {
            $training_program_certificates = TrainingProgramCertificate::select('training_program_certificates.*', 'training_program.name as training_program_name')
                ->join('training_program', 'training_program.id', '=', 'training_program_certificates.diploma_id')
                ->where('training_program_certificates.user_id', $user->id)->get();
            if ($training_program_certificates) {
                foreach ($training_program_certificates as $certificate) {
                    $return1 .= '<option value="' . $certificate->id . '">' . $certificate->training_program_name . '</option>';
                }
            }

            $return2 .= '
                 <option value = "EBU">EBU</option>
                 <option value = "شهادة اكاديمية اعمل بيزنس">
                 شهادة اكاديمية اعمل بيزنس
                 </option>
                  <option value = "اعتماد جامعة اكاديميون العالمية">
             اعتماد جامعة اكاديميون العالمية
                </option> 
                <option value = "توثيق جامعة اكاديميون العالمية">
             توثيق جامعة اكاديميون العالمية
                </option>
            ';

        }

        $output = [
            "return1" => $return1,
            "return2" => $return2
        ];

        return json_encode($output);
    }

    /***
     *  Start Function getCertificateDate()
     *  That Gets The Certificate Date
     */

    public function getCertificateDate(Request $request)
    {


        $params = $request->all();

        $product = $params['product'];

        $email = $params['email'];

        $certificateId = $params['certificateId'];

        $user = AcademyUsers::where('Email', $email)->first();

        $userId = $user->id;

        if ($product == "MBA") {

            $certificateInfo = MbaCertificates::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();


        } else if ($product == "Courses") {

            $certificateInfo = CoursesCurriculumCertificates::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();

        } else if ($product == "Diplomas") {

            $certificateInfo = DiplomaCertificates::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();

        } else if ($product == "New Mba") {

            $certificateInfo = NewMbaCertificates::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();

        }else if ($product == "Preparatory MBA") {

            $certificateInfo = PreparatoryMbaCertificates::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();

        }else if ($product == "Training Programs") {

            $certificateInfo = TrainingProgramCertificate::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();

        }else if ($product == "International Diplomas") {

            $certificateInfo = InternationalDiplomaCertificates::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();

        }else if ($product == "DBA") {

            $certificateInfo = DBACertificate::where([
                ["id", "=", $certificateId],
                ["user_id", "=", $userId]
            ])->first();

        }
        if($certificateInfo){
            $certificateDate = \Carbon\Carbon::parse($certificateInfo->createdtime)->format("Y-m-d");

            return $certificateDate;
        }
        return '';

    }

    /***
     *  End Function getCertificateDate()
     *  That Gets The Certificate Date
     */

    /***
     *  Start Function getDiplomaDates()
     *  That Gets The Diploma Dates
     */

    public function getDiplomaDates(Request $request)
    {

        $output = array();

        $params = $request->all();

        $email = $params['email'];

        $certificateId = $params['certificateId'];

        $user = AcademyUsers::where('Email', $email)->first();

        $userId = $user->id;

        $diplomaInfo = DiplomaCertificates::where([
            ["id", "=", $certificateId],
            ["user_id", "=", $userId]
        ])->first();

        $diplomaId = $diplomaInfo->diploma_id;

        $diplomaChargeTransaction = DiplomasChargeTransaction::where([
            ["diploma_id", "=", $diplomaId],
            ["user_id", "=", $userId]
        ])->first();

        $diploma_start_date = \Carbon\Carbon::parse($diplomaChargeTransaction->start_date)->format("Y-m-d");

        $diploma_end_date = \Carbon\Carbon::parse($diplomaChargeTransaction->end_date)->format("Y-m-d");

        $output = [

            "diploma_start_date" => $diploma_start_date,

            "diploma_end_date" => $diploma_end_date

        ];

        return json_encode($output);

    }

    /***
     *  End Function getDiplomaDates()
     *  That Gets The Diploma Dates
     */

    public function moccylance(Request $request)
    {
        if ($request->isMethod('post') && $request->ajax()) {
            $validator = Validator::make($request->all(),
                array(
                    'attach' => 'required|mimes:xlsx',
                ));

            if ($validator->fails()) {
                $errorMessage = 'File not valid';
                return view('auth.message.error_message', compact('errorMessage'));
            }
            try {
                \Excel::load(Input::file('attach'), function ($reader) {
                    $added_emails = [];
                    $total = count($reader->toArray());
                    $added = 0;
                    $duplicate = 0;
                    $exist = 0;
                    $checked_emails = [];
                    $checked_phones = [];
                    foreach ($reader->toArray() as $row) {
                        $name = array_values($row)[0];
                        $email = array_values($row)[1];
                        $phone = (int)array_values($row)[2];
                        if (in_array($email, $checked_emails) || in_array($phone, $checked_phones)) {
                            $duplicate++;
                        } else {
                            $checked_emails[] = $email;
                            $checked_phones[] = $phone;
                            $checkEmail = AcademyUsers::where('Email', $email)->first();
                            if ($checkEmail) {
                                $exist++;
                            } else {
                                $checkPhone = AcademyUsers::where('Mobile', $phone)->first();
                                if ($checkPhone) {
                                    $exist++;
                                } else {
                                    $country = '191';
                                    if (in_array(substr($phone, 0, 2), ['02', '20', '12', '10', '15', '01', '11']) || in_array(substr($phone, 0, 3), ['002', '050'])) {
                                        $country = '64';
                                    }
                                    $RegisterIP = $_SERVER['REMOTE_ADDR'];
//                                    $leadsource='Mokylance';
                                    $leadsource = 'Alemny';
                                    $password = $this->mocRandPassword();
                                    $RegisterDate = date("Y-m-d H:i:s");
                                    $register_link = 'https://www.e3melbusiness.com/signup';
                                    $affiliat_product_id = '';
                                    $affiliat_reseller_id = '';
                                    $utm = '';
                                    $DemoExpirationDate = date('Y-m-d H:i:s', strtotime('+30 days'));
                                    $agentid = ($country == '64') ? 108 : 193;//64 is egypt
                                    $user = new AcademyUsers();
                                    $user->FullName = $name;
                                    $user->Email = $email;
                                    $user->Password = $password;
                                    $user->RegisterDate = $RegisterDate;
                                    $user->Mobile = $phone;
                                    $user->country = $country;
                                    $user->RegisterReferrer = $register_link;
                                    $user->leadsource = $leadsource;
                                    $user->RegisterIP = $RegisterIP;
                                    $user->affiliat_product_id = $affiliat_product_id;
                                    $user->affiliat_reseller_id = $affiliat_reseller_id;
                                    $user->DemoExpirationDate = $DemoExpirationDate;
                                    if ($user->save()) {
                                        $id = $user->id;
                                        $added++;
                                        $added_emails[] = $email;
                                        $parameters = array(
                                            'template' => 'welcome_30_mokylance',
                                            'name' => $name,
                                            'email' => $email,
                                            'Email' => $email,
                                            'Password' => $password,
                                            'username' => $name,
                                            'country' => $country,
                                            'phone' => $phone,
                                            'agentid' => $agentid,
                                            'register_link' => $register_link,
                                            'utm' => $utm,
                                            'leadsource' => $leadsource,
                                            'affiliat_reseller_id' => $affiliat_reseller_id,
                                            'affiliat_product_id' => $affiliat_product_id,
                                            'affiliat_user_id' => $id,

                                        );
//                                        $this->sendemail($parameters['Email'],$parameters);
                                        $this->transfer($parameters);

                                    }

                                }
                            }
                        }
                    }
                    $return = ' <table class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th>العدد الكلي</th>
                                        <th>تم ادخال</th>
                                        <th>المكررين في الملف</th>
                                        <th>المدخلين من قبل</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>' . $total . '</td>
                                        <td>' . $added . '</td>
                                        <td>' . $duplicate . '</td>
                                        <td>' . $exist . '</td>
                                    </tr>
                                    </tbody>
                                </table>';
                    if (count($added_emails)) {
                        $return .= ' <br><table class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th>الذين تم ادخالهم</th>
                                    </tr>
                                    </thead>
                                    <tbody>';
                        foreach ($added_emails as $email) {
                            $return .= '<tr>
                                                <td>' . $email . '</td>
                                            </tr>';
                        }
                        $return .= '</tbody>
                                </table>';
                    }
                    echo $return;
                    return;
                })->get();

            } catch (\Exception $e) {
                $errorMessage = 'حدث خطأ برجاء المحاولة مرة أخرى';
                return view('auth.message.error_message', compact('errorMessage'));
            }

        }
    }

    public function addCertificatesRequestComment($id, Request $request)
    {
        $certificate_request = CertificatesRequests::find($id);
        if ($certificate_request) {
            $user = Auth::user();
            if ($request->parent_comment) {
                $comment = Comment::find($request->parent_comment);
                $newComment = $user->comment($comment, $request->comment);
            } else {
                $newComment = ($user)->comment($certificate_request, $request->comment);
            }
            $certificate_request = CertificatesRequests::find($id);
            $comments = $certificate_request->comments;
            $html = view('auth.certificates_requests.comments', compact('comments'))->render();
            return response()->json(['success' => true, 'message' => '<div class="alert alert-success">Success Added Comment</div>', 'html' => $html, 'comment_id' => $newComment->id]);
        }

    }

    public function certificates_requests_change_status(Request $request)
    {

        /*  dd($request->input('pk'));

          $updated=CertificatesRequests::where('id',$request->id)->update($data);
          echo 'updated';*/
        if ($request->ajax()) {
            $data['request_status'] = $request->input('value');
            CertificatesRequests::where('id', $request->input('pk'))->update($data);
            return response()->json(['success' => true]);
        }

    }

    public function deleteGiftCourseChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, GiftCourseChargeTransactions::class, DeletedGiftCourseChargeTransaction::class, 'gift course charge transaction');
    }
    public function deleteGiftBookChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, GiftBookChargeTransactions::class, DeletedGiftBookChargeTransaction::class, 'gift book charge transaction');
    }
    public function deleteChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, ChargeTransaction::class, DeletedChargeTransaction::class, 'charge transaction');
    }

    public function deleteDiplomasChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, DiplomasChargeTransaction::class, DeletedDiplomasChargeTransaction::class, 'diplomas transaction');
    }
    public function deleteYotaMedicalDiplomaChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, MedicalDiplomasChargeTransaction::class, DeletedMedicalDiplomasChargeTransaction::class, 'medical diplomas transaction');
    }

    public function deletePackagesChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, PackagessChargeTransaction::class, DeletedPackagesChargeTransaction::class, 'packages transaction');
    }
    public function deleteCustomChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, CustomChargeTransaction::class, DeletedCustomChargeTransaction::class, 'custom transaction');
    }

    public function deleteTrainingProgramChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, TrainingProgramsChargeTransaction::class, DeletedTrainingProgramsChargeTransaction::class, 'Training Program transaction');
    }

    public function deleteMbaChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, MbaChargeTransaction::class, DeletedMbaChargeTransaction::class, 'mba transaction');
    }
    public function deletePreparatoryMbaChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, PreparatoryMbaChargeTransaction::class, DeletedPreparatoryMbaChargeTransaction::class, 'preparatory mba transaction');
    }

    public function deleteNewMbaChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, NewMbaChargeTransaction::class, DeletedNewMbaChargeTransaction::class, 'new mba transaction');
    }

    public function deleteNewMbaCategoriesChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, NewMbaCategoriesChargeTransaction::class, DeletedNewMbaCategoriesChargeTransaction::class, 'new mba categories transaction');
    }

    public function deleteInternationalDiplomasChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, InternationalDiplomasChargeTransaction::class, DeletedInternationalDiplomasChargeTransaction::class, 'international diplomas transaction');
    }

    public function deleteDBAPreliminaryChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, DBAPreliminaryChargeTransaction::class, DeletedDBAPreliminaryChargeTransaction::class, 'DBA Preliminary transaction');
    }

    public function deleteDBAChargeTransaction($charge_id)
    {
        return $this->doDeleteCharges($charge_id, DBAChargeTransaction::class, DeletedDBAChargeTransaction::class, 'DBA transaction');
    }

    /**
     * @param $charge_id
     * @param $chargeModel
     * @param $deletedChargeModel
     * @return \Illuminate\Http\JsonResponse|void
     * @throws \Exception
     */
    public function doDeleteCharges($charge_id, $chargeModel, $deletedChargeModel, $tag_name)
    {
        $chargeTransaction = $chargeModel::find($charge_id);
        if ($chargeTransaction) {
            $deletedChargeModel::create(array_merge($chargeTransaction->toArray(), ['old_id' => $chargeTransaction->id, 'deleted_by_id' => auth()->id()]));
            $chargeTransaction->delete();
            deleteChargeTransactionFromCRM($chargeTransaction->id, $tag_name);
            return response()->json(['success' => true]);
        }
        return abort(404);
    }

    public function changeUserDiplomaChargeTransaction(Request $request)
    {
        if (isset($request->pk, $request->value['diploma_id']['id'], $request->value['charge_system']['id'])) {
            $charge_id = $request->pk;
            $diploma_id = $request->value['diploma_id']['id'];
            $charge_system = $request->value['charge_system']['id'];
            $chargeTransaction = DiplomasChargeTransaction::find($charge_id);
            if ($chargeTransaction) {
                if ($diploma_id != $chargeTransaction->diploma_id) {
                    $diploma = Diplomas::where('published', 'yes')->find($diploma_id);
                    $field = ($charge_system == 'ksa') ? 'related_course_ksa' : 'related_course';
                    $coursesIDS = DiplomaCourse::where('diploma_id', $diploma_id)->pluck($field)->toArray();
//                    $completed=DB::connection('mysql2')->table('users_course_view_completed')->where('user_id',$chargeTransaction->user_id)->whereIn('course_id',$coursesIDS)->count();
//                    if($completed){
//                        return response()->json(['success'=>false,'message'=>'This user has see number of courses in this diplomas'],\Illuminate\Http\Response::HTTP_BAD_REQUEST);
//                    }
                    $auth_id = auth()->id();
                    $log = DiplomasChangeLogs::create([
                        'transaction_id' => $chargeTransaction->id,
                        'diploma_from_id' => $chargeTransaction->diploma_id,
                        'diploma_to_id' => $diploma_id,
                        'created_by_id' => $auth_id,
                    ]);
                    $now = date('Y-m-d H:i:s');
                    $userCourses = DiplomasUsersCourses::select('diploma_id', 'course_id', 'user_id', 'createtime', 'sort', 'exam', 'published', 'published_by', 'published_date', 'unpublished_by', 'unpublished_date', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->get();
                    DeletedDiplomasUsersCourses::insert($userCourses->toArray());
                    $coursesUserPlan = DiplomasCoursesUsersPlan::select('diploma_id', 'course_id', 'user_id', 'name', 'description', 'sort', 'exam', 'createtime', 'modifiedtime', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->get();
                    DeletedDiplomasCoursesUserPlan::insert($coursesUserPlan->toArray());
                    $chargeTransaction->diploma_id = $diploma_id;
                    $chargeTransaction->diploma_name = $diploma->name;
                    $chargeTransaction->charge_system = $charge_system;
                    $chargeTransaction->save();
                    DiplomasUsersCourses::select('diploma_id', 'course_id', 'user_id', 'createtime', 'sort', 'exam', 'published', 'published_by', 'published_date', 'unpublished_by', 'unpublished_date', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->delete();
                    DiplomasCoursesUsersPlan::select('diploma_id', 'course_id', 'user_id', 'name', 'description', 'sort', 'exam', 'createtime', 'modifiedtime', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->delete();
                    $this->addDiplomaPlanAndFirstMonth($diploma_id, $chargeTransaction->user_id, $charge_system);

                    return response()->json(['success' => true, 'message' => 'Saved successfully']);
                }
                return response()->json(['success' => false, 'message' => 'diploma is same'], \Illuminate\Http\Response::HTTP_BAD_REQUEST);
            }
            return response()->json(['success' => false, 'message' => 'No Charge'], \Illuminate\Http\Response::HTTP_BAD_REQUEST);
        }

    }
    public function changeUserMedicalDiplomaChargeTransaction(Request $request)
    {
        if (isset($request->pk, $request->value['diploma_id']['id'], $request->value['charge_system']['id'])) {
            $charge_id = $request->pk;
            $diploma_id = $request->value['diploma_id']['id'];
            $charge_system = $request->value['charge_system']['id'];
            $chargeTransaction = MedicalDiplomasChargeTransaction::find($charge_id);
            if ($chargeTransaction) {
                if ($diploma_id != $chargeTransaction->diploma_id) {
                    $diploma = MedicalDiplomas::where('published', 'yes')->find($diploma_id);
                    $field = ($charge_system == 'ksa') ? 'related_course_ksa' : 'related_course';
                    $coursesIDS = MedicalDiplomasCourses::where('diploma_id', $diploma_id)->pluck($field)->toArray();
//                    $completed=DB::connection('mysql2')->table('users_course_view_completed')->where('user_id',$chargeTransaction->user_id)->whereIn('course_id',$coursesIDS)->count();
//                    if($completed){
//                        return response()->json(['success'=>false,'message'=>'This user has see number of courses in this diplomas'],\Illuminate\Http\Response::HTTP_BAD_REQUEST);
//                    }
                    $auth_id = auth()->id();
                    $log = MedicalDiplomasChangeLogs::create([
                        'transaction_id' => $chargeTransaction->id,
                        'diploma_from_id' => $chargeTransaction->diploma_id,
                        'diploma_to_id' => $diploma_id,
                        'created_by_id' => $auth_id,
                    ]);
                    $now = date('Y-m-d H:i:s');
                    $userCourses = MedicalDiplomasUsersCourses::select('diploma_id', 'course_id', 'user_id', 'createtime', 'sort', 'exam', 'published', 'published_by', 'published_date', 'unpublished_by', 'unpublished_date', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->get();
                    DeletedMedicalDiplomasUsersCourses::insert($userCourses->toArray());
                    $coursesUserPlan = MedicalDiplomasCoursesUsersPlan::select('diploma_id', 'course_id', 'user_id', 'name', 'description', 'sort', 'exam', 'createtime', 'modifiedtime', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->get();
                    DeletedMedicalDiplomasCoursesUserPlan::insert($coursesUserPlan->toArray());
                    $chargeTransaction->diploma_id = $diploma_id;
                    $chargeTransaction->diploma_name = $diploma->name;
                    $chargeTransaction->charge_system = $charge_system;
                    $chargeTransaction->save();
                    MedicalDiplomasUsersCourses::select('diploma_id', 'course_id', 'user_id', 'createtime', 'sort', 'exam', 'published', 'published_by', 'published_date', 'unpublished_by', 'unpublished_date', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->delete();
                    MedicalDiplomasCoursesUsersPlan::select('diploma_id', 'course_id', 'user_id', 'name', 'description', 'sort', 'exam', 'createtime', 'modifiedtime', 'lastedit_date', 'lastedit_by', 'added_by', 'added_date', 'id AS old_id', DB::raw("'$log->id' AS diplomas_change_log_id"), DB::raw("'$auth_id' AS deleted_by_id"), DB::raw("'$now' AS created_at"))->where('user_id', $chargeTransaction->user_id)->where('diploma_id', $chargeTransaction->diploma_id)->delete();
                    $this->addMedicalDiplomaPlanAndFirstMonth($diploma_id, $chargeTransaction->user_id, $charge_system);

                    return response()->json(['success' => true, 'message' => 'Saved successfully']);
                }
                return response()->json(['success' => false, 'message' => 'diploma is same'], \Illuminate\Http\Response::HTTP_BAD_REQUEST);
            }
            return response()->json(['success' => false, 'message' => 'No Charge'], \Illuminate\Http\Response::HTTP_BAD_REQUEST);
        }

    }
    public function changeCountCustomChargeTransaction(Request $request)
    {

        $params = $request->all();
        $newName = isset($params['value']) ? $params['value'] : null;
        $request_id = isset($params['request_id']) ? $params['request_id'] : null;
        if ($newName  && $request_id ) {
            $table = 'custom_charge_transaction';
            $setData = ["courses_count" => $newName] ;
            DB::connection('mysql2')->table($table)->where('id', $request_id)->update($setData);
            log_user_action(Auth::user()->id, Auth::user()->username, 'update', $table, $request_id, json_encode($setData));

        }


    }

    private function HandleDate($date, $language)
    {
        if(!$date){
            return '';
        }
        $ar_months = [
            '01' => 'يناير',
            '02' => 'فبراير',
            '03' => 'مارس',
            '04' => 'أبريل',
            '05' => 'مايو',
            '06' => 'يونيو',
            '07' => 'يوليو',
            '08' => 'أغسطس',
            '09' => 'سبتمبر',
            '10' => 'أكتوبر',
            '11' => 'نوفمبر',
            '12' => 'ديسمبر',
        ];

        if ($language == 'english')
            return date('d', strtotime($date)) . ' ' . 'of' . ' ' . date('F', strtotime($date)) . ' ' . date('Y', strtotime($date));

        else
            return date('d', strtotime($date)) . ' ' . 'من' . ' ' . $ar_months[date('m', strtotime($date))] . ' ' . date('Y', strtotime($date));
    }

    public function getHtmlIfAddDemoExist($addDemo)
    {
        return '<hr><div class="alert alert-success">This user has added demo before with end date:' . $addDemo->end_date . '</div><hr>';
    }

    public function addDemoToUser(Request $request)
    {
        if ($request->user_id && $request->type) {
            $addDemoLog = AddDemoLog::where('user_id', $request->user_id)->first();
            if ($addDemoLog) {
                return response()->json(['success' => false, 'message' => 'already has demo']);
            }
            $user = AcademyUsers::find($request->user_id);
            if (!$user) {
                return response()->json(['success' => false, 'message' => 'No User']);
            }
            $addDemoLog = AddDemoLog::create([
                'created_by' => auth()->id(),
                'old_DemoExpirationDate' => $user->DemoExpirationDate,
                'user_id' => $request->user_id,
                'demo_type' => $request->type,
                'start_date' => date('Y-m-d H:i:s'),
                'end_date' => date('Y-m-d H:i:s', strtotime(str_replace('_', ' ', $request->type))),
            ]);
            $user->DemoExpirationDate = $addDemoLog->end_date;
            $user->save();
            return response()->json(['success' => true, 'message' => 'Your charge has been Added Successfully.', 'html' => $this->getHtmlIfAddDemoExist($addDemoLog)]);
        }
        return response()->json(['success' => false, 'message' => 'Requried Parameters']);
    }

    function diploma_charge_report(Request $request)
    {
        $reports = DiplomasChargeTransaction::LeftJoin('users', 'users.id', '=', 'diplomas_charge_transaction.user_id')
            ->leftJoin('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction.diploma_id')
            ->select('diplomas.name', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', FacadesDB::raw("(SELECT count(diploma_certificates.id) AS cert_count FROM `diploma_certificates` WHERE diploma_certificates.user_id=diplomas_charge_transaction.user_id AND diploma_certificates.diploma_id=diplomas_charge_transaction.diploma_id) AS finished"));

        $data['diplomas'] = Diplomas::where('published', 'yes')->get();
        return view('auth.diplomas_users_reports.view', $data);
    }

    function diplomas_users_reports_export(Request $request)
    {
        $data = $request->input();
        $reports = DiplomasChargeTransaction::join('users', 'users.id', '=', 'diplomas_charge_transaction.user_id')
            ->leftJoin('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction.diploma_id')
            ->select('diplomas_charge_transaction.id', 'diplomas_charge_transaction.diploma_name', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', FacadesDB::raw("(SELECT count(diploma_certificates.id) AS cert_count FROM `diploma_certificates` WHERE diploma_certificates.user_id=diplomas_charge_transaction.user_id AND diploma_certificates.diploma_id=diplomas_charge_transaction.diploma_id) AS finished"));
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $reports = $reports->where('diplomas_charge_transaction.id', 'LIKE', "%$id%");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $reports = $reports->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $reports = $reports->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $reports = $reports->where('users.Mobile', 'LIKE', "%$phone%");
        }


        if (isset($data['diploma_id']) && !empty($data['diploma_id'])) {
            $diploma_id = $data['diploma_id'];
            $reports = $reports->where('diplomas_charge_transaction.diploma_id', $diploma_id);
        }
        if (isset($data['finished']) && is_numeric($data['finished'])) {
            $finished = (int)$data['finished'];
            $reports = $reports->having('finished', $finished);
        }


        $reports = $reports->get();
        $output = ['ID', Lang::get('main.name'), Lang::get('main.email'), Lang::get('main.phone'), 'Diploma Name', 'Finished'];
        $filename = "diplomas_users_reports.csv";
        $handle = fopen($filename, 'w+');
        fputs($handle, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
        fputcsv($handle, $output);


        foreach ($reports as $report) {
            fputcsv($handle, [
                $report->id,
                $report->username,
                $report->email,
                $report->phone,

                $report->diploma_name,
                $report->finished == 1 ? 'yes' : 'no',


            ]);
        }
        fclose($handle);
        $headers = array(
            'Content-Type' => 'text/csv;',
            'Content-Disposition' => 'attachment; filename="diplomas_users_reports.csv"'
        );
        return Response::download($filename, 'report.csv', $headers);
    }

    function diploma_report_charge_search(Request $request)
    {
        $data = $request->input();
        $reports = DiplomasChargeTransaction::join('users', 'users.id', '=', 'diplomas_charge_transaction.user_id')
            ->leftJoin('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction.diploma_id')
            ->select('diplomas_charge_transaction.id', 'diplomas_charge_transaction.diploma_name', 'users.FullName AS username', 'users.Email AS email', 'users.Mobile AS phone', FacadesDB::raw("(SELECT count(diploma_certificates.id) AS cert_count FROM `diploma_certificates` WHERE diploma_certificates.user_id=diplomas_charge_transaction.user_id AND diploma_certificates.diploma_id=diplomas_charge_transaction.diploma_id) AS finished"));
        if (isset($data['id']) && !empty($data['id'])) {
            $id = $data['id'];
            $reports = $reports->where('diplomas_charge_transaction.id', 'LIKE', "%$id%");
        }
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $reports = $reports->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $reports = $reports->where('users.Email', 'LIKE', "%$email%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $reports = $reports->where('users.Mobile', 'LIKE', "%$phone%");
        }


        if (isset($data['diploma_id']) && !empty($data['diploma_id'])) {
            $diploma_id = $data['diploma_id'];
            $reports = $reports->where('diplomas_charge_transaction.diploma_id', $diploma_id);
        }
        if (isset($data['finished']) && is_numeric($data['finished'])) {
            $finished = (int)$data['finished'];
            $reports = $reports->having('finished', $finished);
        }

        $iTotalRecords = count($reports->get());

        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'diplomas_charge_transaction.id';
        switch ($data['order'][0]['column']) {

            case 0:
                $columnName = 'diplomas_charge_transaction.id';
                break;
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Email';
                break;
            case 3:
                $columnName = 'users.Mobile';
                break;
            case 4:
                $columnName = 'diplomas_charge_transaction.diploma_name';
                break;
            case 5:
                $columnName = 'finished';
                break;


        }

        $search = $data['search']['value'];
        if ($search) {
            $reports = $reports->where(function ($q) use ($search) {
                $q->where('users.FullName', 'LIKE', "%$search%")
                    ->orWhere('users.Email', 'LIKE', "%$search%")
                    ->orWhere('users.Mobile', 'LIKE', "%$search%")
                    ->orWhere('diplomas_charge_transaction.diploma_name', 'LIKE', "%$search%")
                    ->orWhere('diplomas_charge_transaction.id', '=', $search);
            });
        }
        $reports = $reports->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($reports as $report) {
            $records["data"][] = [
                $report->id,
                $report->username,
                $report->email,
                $report->phone,

                $report->diploma_name,
                $report->finished == 1 ? 'yes' : 'no',
                ''

            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }

    public function addExamException(Request $request)
    {
        $user = AcademyUsers::find($request->user_id);
        if ($user) {
            $has = DB::connection('mysql2')->table("exams_exceptions")->where('user_id', $user->id)->count();
            if (!$has) {
                DB::connection('mysql2')->table("exams_exceptions")->insert([
                    'user_id' => $user->id,
                    'note' => 'this has opened from support with user name:' . auth()->user()->name . ' and id:' . auth()->id(),
                    'createtime' => date('Y-m-d H:i:s'),
                ]);
                return response()->json(['success' => true, 'message' => 'Success']);
            }
            return response()->json(['success' => false, 'message' => 'This user already opened exam']);
        }
        return response()->json(['success' => false, 'message' => 'No User Found']);
    }

    public function openExamForCourse(Request $request)
    {
        $user = AcademyUsers::find($request->user_id);
        if ($user) {
            $curriculum = UsersCurriculumAnswers::find($request->curriculum_id);
            if ($curriculum) {

                $new_date = date('Y-m-d H:i:s', strtotime('-8 days'));

                DB::table('open_exam_log')->insert([
                    'user_id' => $user->id,
                    'curriculum_id' => $curriculum->id,
                    'old_date' => $curriculum->createdtime,
                    'new_date' => $new_date,
                    'added_date' => date('Y-m-d H:i:s'),
                    'added_by' => auth()->id(),
                ]);
                $curriculum->createdtime = $new_date;
                $curriculum->save();
                $usersCurriculumAnswers=UsersCurriculumAnswers::where('user_id',$user->id)->where('curriculum_id',$curriculum->curriculum_id)->where('curriculum_type','exam')->whereBetween(DB::raw("DATE_FORMAT(createdtime,'%Y-%m-%d')"),[date('Y-m-d H:i:s',strtotime('-7 days')),date('Y-m-d H:i:s')]);
                foreach ($usersCurriculumAnswers->get() as $usersCurriculumAnswer){
                    DB::table('open_exam_log')->insert([
                        'user_id' => $user->id,
                        'curriculum_id' => $usersCurriculumAnswer->id,
                        'old_date' => $usersCurriculumAnswer->createdtime,
                        'new_date' => $new_date,
                        'added_date' => date('Y-m-d H:i:s'),
                        'added_by' => auth()->id(),
                    ]);
                    $usersCurriculumAnswer->createdtime=$new_date;
                    $usersCurriculumAnswer->save();
                }
                return response()->json(['success' => true, 'message' => 'Success']);
            }
            return response()->json(['success' => false, 'message' => 'No Curriculum Found']);
        }
        return response()->json(['success' => false, 'message' => 'No User Found']);
    }

    public function exportIbnRushdData()
    {
        return view('auth.export_ibn_rushd_data.import');
    }

    public function exportIbnRushdDataPost(Request $request)
    {
        $file = $request->file('import');
        $filename = "export_ibn_rushd_data_" . date('Y-m-d H:i:s') . ".csv";
        $handle = fopen($filename, 'w+');
        fputcsv($handle, array('Name', 'Mobile', 'Email', 'Diploma', 'Finish (Yes Or No)', 'Serial Number'));
        $CSVfp = fopen($file->getPathname(), "r");
        if ($CSVfp !== FALSE) {
            while (!feof($CSVfp)) {
                $data = fgetcsv($CSVfp, 1000, $request->separated ? $request->separated : ',');
                $name = $data[0];
                $mobile = $data[1];
                $email = $data[2];
                $diploma_name = $data[3];
                $user = AcademyUsers::where(function ($q) use ($email, $mobile) {
                    $q->where('email', $email)->orWhere('mobile', $mobile);
                })->first();

                if (!$user) {
                    Session::flash('error', 'No User With email:' . $email . ' OR mobile:' . $mobile);
                    return redirect()->back();
                }
                $diploma = Diplomas::where('name', 'LIKE', "%$diploma_name%")->first();
                if (!$diploma) {
                    Session::flash('error', 'No Diploma With name:' . $diploma_name);
                    return redirect()->back();
                }
//               dd($user);
                $certificate = DiplomaCertificates::where('user_id', $user->id)->where('diploma_id', $diploma->id)->first();
                fputcsv($handle, array($user->FullName, $user->Mobile, $user->Email, $diploma->name, ($certificate ? 'YES' : 'NO'), $certificate->serial_number));

            }

        }
        fclose($CSVfp);
        fclose($handle);

        $headers = array(
            'Content-Type' => 'text/csv',
        );

        return \Illuminate\Support\Facades\Response::download($filename, $filename, $headers);
    }

    public function pluckMarketingGift()
    {
        return view('auth.pluck_marketing_gift.import');
    }

    public function pluckMarketingGiftPost(Request $request)
    {
        $file = $request->file('import');
        $CSVfp = fopen($file->getPathname(), "r");
        if ($CSVfp !== FALSE) {
            $fileData = [];
            while (!feof($CSVfp)) {
                $data = fgetcsv($CSVfp, 1000, $request->separated ? $request->separated : ',');
                if ($data[0] && $data[1] && $data[2] && $data[3] && $data[4] && $data[5]) {
                    $fileData[] = $data;
                    $email = $data[0];
                    $name = $data[1];
                    $mobile = $data[2];
                    $type = $data[3];
                    $courseOrDays = $data[4];
                    $leadsource = $data[5];
                    if (!in_array(strtolower($type), ['period', 'course', 'book'])) {
                        Session::flash('error', 'Type must be period,course it is ' . strtolower($type));
                        return redirect()->back();
                    }
                    if (strtolower($type) == 'course') {
                        $course = Courses::where('name', $courseOrDays)->first();
                        if (!$course) {
                            Session::flash('error', 'can\'t find course with name :' . $courseOrDays);
                            return redirect()->back();
                        }
                    }
                    if (strtolower($type) == 'book') {
                        $course = Books::where('title', $courseOrDays)->first();
                        if (!$course) {
                            Session::flash('error', 'can\'t find book with name :' . $courseOrDays);
                            return redirect()->back();
                        }
                    }
                }


            }
            $createdUsers = 0;
            $demoPeriod = 0;
            $demoCourses = 0;
            foreach ($fileData as $data) {
                if ($data[0] && $data[1] && $data[2] && $data[3] && $data[4] && $data[5]) {
                    $email = $data[0];
                    $name = $data[1];
                    $mobile = $data[2];
                    $type = $data[3];
                    $courseOrDays = $data[4];
                    $leadsource = $data[5];
                    $user = AcademyUsers::where(function ($q) use ($email, $mobile) {
                        $q->where('email', $email)->orWhere('mobile', $mobile);
                    })->first();
                    if (!$user) {
                        $country = '191';
                        if (in_array(substr($mobile, 0, 2), ['02', '20', '12', '10', '15', '01', '11']) || in_array(substr($mobile, 0, 3), ['002', '050'])) {
                            $country = '64';
                        }
                        $user = new AcademyUsers();
                        $user->FullName = $name;
                        $user->password = $mobile;
                        $user->Email = $email;
                        $user->Mobile = $mobile;
                        $user->RegisterDate = date('Y-m-d H:i:s');
                        $user->country = $country;
                        $user->RegisterReferrer = 'https://www.e3melbusiness.com/signup';
                        $user->leadsource = $leadsource;
                        $user->RegisterIP = $_SERVER['REMOTE_ADDR'];
                        $user->save();
                        $createdUsers++;
                    }
                    if (strtolower($type) == 'period') {
                        $DemoExpirationDate = date('Y-m-d H:i:s', strtotime('+' . $courseOrDays . ' days'));
                        AddDemoLog::create([
                            'created_by' => auth()->id(),
                            'old_DemoExpirationDate' => $user->DemoExpirationDate,
                            'user_id' => $user->id,
                            'demo_type' => $courseOrDays . '_days',
                            'start_date' => date('Y-m-d H:i:s'),
                            'end_date' => $DemoExpirationDate,
                        ]);
                        $user->DemoExpirationDate = $DemoExpirationDate;
                        $user->save();
                        $demoPeriod++;
                    } elseif (strtolower($type) == 'course') {
                        $course = Courses::where('name', $courseOrDays)->first();
                        GiftCourseChargeTransactions::create([
                            'user_id' => $user->id,
                            'course_id' => $course->id,
                            'period' => 12,
                            'start_date' => date('Y-m-d H:i:s'),
                            'end_date' => date('Y-m-d H:i:s', strtotime('+1 month')),
                            'createtime' => date('Y-m-d H:i:s'),
                            'subscrip_type' => 'free',
                            'amount' => '0',
                            'subscribe_country' => 'egy',
                            'currency' => 'جنية',
                            'employee_id' => auth()->id(),
                        ]);
                        $demoCourses++;
                    } elseif (strtolower($type) == 'book') {
                        $course = Books::where('title', $courseOrDays)->first();
                        GiftBookChargeTransactions::create([
                            'user_id' => $user->id,
                            'book_id' => $course->id,
                            'period' => 12,
                            'start_date' => date('Y-m-d H:i:s'),
                            'end_date' => date('Y-m-d H:i:s', strtotime('+1 month')),
                            'createtime' => date('Y-m-d H:i:s'),
                            'subscrip_type' => 'free',
                            'amount' => '0',
                            'subscribe_country' => 'egy',
                            'currency' => 'جنية',
                            'employee_id' => auth()->id(),
                        ]);
                        $demoCourses++;
                    }


                }
            }
            $message = 'تم اضافة ';
            $message .= $createdUsers . ' مستخدم ';
            $message .= '<br> تم اضافة ' . $demoCourses . ' كورس ';
            $message .= '<br> تم اضافة ' . $demoPeriod . ' مدة ';
            Session::flash('success', $message);
            return redirect()->back();
        }
    }
    public function getStates(Request $request){
        $states=States::where('country_id',$request->country_id)->pluck('arab_name','id')->toArray();
        $html='';
        foreach ($states as $id=>$name){
            $html.='<option value="'.$id.'">'.$name.'</option>';
        }
        return response()->json(['success'=>true,'html'=>$html]);
    }
    public function getLiveDiplomasSelectorAjax(Request $request){
        $email=$request->email;
        $diplomas=Diplomas::where('type','live')->whereRaw("id NOT IN(SELECT diploma_id FROM diploma_certificates WHERE user_id=(SELECT id FROM users WHERE Email='".$email."' AND deleted_at IS NULL LIMIT 1))")->pluck('name','id')->toArray();
        $html='';
        foreach ($diplomas as $id=>$name){
            $html.='<option value="'.$id.'">'.$name.'</option>';
        }
        return response()->json(['success'=>true,'html'=>$html]);
    }
    public function generateLiveDiplomasCertificate(Request $request){
        $email=$request->email;
        $diploma_id=$request->diploma_id;
        $diploma=Diplomas::where('type','live')->find($diploma_id);
        if($diploma){
            $user=AcademyUsers::where('Email',$email)->first();
            if($user){
                $diplomaCertificate=DiplomaCertificates::where('diploma_id',$diploma->id)->where('user_id',$user->id)->first();
                if($diplomaCertificate){
                    return response()->json(['success'=>false,'message'=>'already has certificate ']);
                }
                $diploma->certificate_increment+=1;
                $diploma->save();
                $serial_number='';
                switch(strlen($diploma->certificate_increment)){
                    case 1:
                        $serial_number= strtoupper($diploma->code).'000'.$diploma->certificate_increment;
                        break;
                    case 2:
                        $serial_number= strtoupper($diploma->code).'00'.$diploma->certificate_increment;
                        break;
                    case 3:
                        $serial_number= strtoupper($diploma->code).'0'.$diploma->certificate_increment;
                        break;
                    case 4:
                        $serial_number= strtoupper($diploma->code).$diploma->certificate_increment;
                        break;
                }
                DiplomaCertificates::create([
                    'serial_number'=>$serial_number,
                    'diploma_id'=>$diploma->id,
                    'user_id'=>$user->id,
                    'user_name'=>$user->FullName,
                    'user_name_en'=>$user->name_en,
                    'createdtime'=>date('Y-m-d H:i:s'),
                ]);
                return response()->json(['success'=>true,'message'=>'Success Add Certificate']);
            }
            return response()->json(['success'=>false,'message'=>'No User']);
        }
        return response()->json(['success'=>false,'message'=>'No Diploma']);
    }
    public function getMbaPercentagesAjax(Request  $request){
        $statisticsMba = modules_statistics('mba', $request->email);
        $statisticsNewMba=modules_statistics('new_mba',$request->email);
        $mbaPercentages=view('auth.include.mba_percentages',compact('statisticsMba'))->render();
        $newMbaPercentages=view('auth.include.new_mba_percentages',compact('statisticsNewMba'))->render();
        return response()->json(['success'=>true,'new_mba_percentages'=>$newMbaPercentages,'mba_percentages'=>$mbaPercentages]);
    }
    public function editGender(Request $request){
        $user=AcademyUsers::find($request->user_id);
        if($user){
            if($user->gender!=$request->value){
                UserGenderUpdated::create([
                    'user_id'=>$user->id,
                    'from_gender'=>$user->gender,
                    'to_gender'=>$request->value,
                    'created_by'=>auth()->id(),
                ]);
                $user->gender=$request->value;
                $user->save();

            }
        }
    }
    public function dba_certificates_report()
    {
        return view('auth.dba_certificates_report.view');
    }
    public function dba_certificates_report_search(Request $request)
    {
        $data = $request->input();

        $transactions = AcademyUsers::select('users.id','users.FullName','users.Mobile','users.Email',
            DB::raw("(SELECT min(start_date) FROM dba_charge_transaction WHERE user_id=users.id) AS start_date"),
            DB::raw("(SELECT MAX(end_date) FROM dba_charge_transaction WHERE user_id=users.id) AS end_date"),
            DB::raw("(SELECT serial_number FROM dba_certificates WHERE user_id=users.id AND deleted_at IS NULL LIMIT 1) AS certificate_code"))
        ->whereRaw('users.id IN(SELECT DISTINCT user_id FROM `dba_charge_transaction`)');
        if (isset($data['username']) && !empty($data['username'])) {
            $username = $data['username'];
            $transactions = $transactions->where('users.FullName', 'LIKE', "%$username%");
        }
        if (isset($data['phone']) && !empty($data['phone'])) {
            $phone = $data['phone'];
            $transactions = $transactions->where('users.Mobile', 'LIKE', "%$phone%");
        }
        if (isset($data['email']) && !empty($data['email'])) {
            $email = $data['email'];
            $transactions = $transactions->where('users.Email', 'LIKE', "%$email%");
        }

        if (isset($data['start_date_from'], $data['start_date_to'])) {
            $from = $data['start_date_from'];
            $to = $data['start_date_to'];
            $from = (empty($from) && !empty($to)) ? date('Y-m-d') : $from;
            $to = (empty($to) && !empty($from)) ? date('Y-m-d') : $to;
            if (!empty($from) && !empty($to)) {
                $transactions = $transactions->whereRaw("(SELECT min(start_date) FROM dba_charge_transaction WHERE user_id=users.id) BETWEEN ? AND ?",[$from,$to]);
            }
        }
        if (isset($data['end_date_from']) && !empty($data['end_date_from']) && isset($data['end_date_to']) && !empty($data['end_date_to'])) {
            $from = $data['end_date_from'];
            $to = $data['end_date_to'];
            $transactions = $transactions->whereRaw("(SELECT MAX(end_date) FROM dba_charge_transaction WHERE user_id=users.id) BETWEEN ? AND ?",[$from,$to]);
        }
        if (isset($data['certificate_code']) && !empty($data['certificate_code'])) {
            $certificate_code = $data['certificate_code'];
            $transactions = $transactions->whereRaw("(SELECT serial_number FROM dba_certificates WHERE user_id=users.id AND deleted_at IS NULL LIMIT 1) LIKE ?",["%$certificate_code%"]);
        }
        if (isset($data['subscribe_type']) && !empty($data['subscribe_type'])) {
            $subscribe_type = $data['subscribe_type'];
            $transactions = $transactions->where('dba_charge_transaction.subscrip_type', '=', "$subscribe_type");
        }
        if (isset($data['amount']) && !empty($data['amount'])) {
            $amount = $data['amount'];
            $transactions = $transactions->where('dba_charge_transaction.amount', 'LIKE', "%$amount%");
        }

        if (isset($data['employee_name']) && !empty($data['employee_name'])) {
            $employee_name = $data['employee_name'];
            $transactions = $transactions->where('employees.username', 'LIKE', "%$employee_name%");
        }


        $iTotalRecords = $transactions->count();
        $iDisplayLength = intval($data['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($data['start']);
        $sEcho = intval($data['draw']);
        $records = [];
        $records["data"] = [];
        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        $columnName = 'users.id';
        switch ($data['order'][0]['column']) {
            case 1:
                $columnName = 'users.FullName';
                break;
            case 2:
                $columnName = 'users.Mobile';
                break;
            case 3:
                $columnName = 'users.Email';
                break;
            case 4:
                $columnName = 'start_date';
                break;
            case 5:
                $columnName = 'end_date';
                break;
            case 6:
                $columnName = 'certificate_code';
                break;
        }


        if ($request->export) {
            //dd(getEloquentSqlWithBindings($transactions));
            $titles = ['#', 'name', 'Phone', 'Email', 'start_date', 'end_date', 'certificate_code'];
            $name = 'dba_report.csv';
            //dd($transactions->get()->toArray());
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename=' . $name);
            $output = fopen("php://output", "w");
            fputcsv($output, $titles);
            foreach ($transactions->get()->toArray() as $res) {
                unset($res[count($res) - 1]);
                fputcsv($output, $res);
            }
            fclose($output);
            return '';
        }
        $transactions = $transactions->orderBy($columnName, $data['order'][0]['dir'])->skip($iDisplayStart)->take($iDisplayLength)
            ->get();
        foreach ($transactions as $transaction) {
            $records["data"][] = [
                $transaction->id,
                $transaction->FullName,
                $transaction->Mobile,
                $transaction->Email,
                $transaction->start_date,
                $transaction->end_date,
                $transaction->certificate_code,
                ''
            ];
        }
        if (isset($data["customActionType"]) && $data["customActionType"] == "group_action") {
            $records["customActionStatus"] = "OK"; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = "Group action successfully has been completed. Well done!"; // pass custom message(useful for getting status of group actions)
        }
        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;
        $records['postData'] = $data;
        //return response()->json($data)->setCallback($request->input('callback'));
        return response()->json($records)->setCallback($request->input('callback'));
    }
}
