<?php

namespace App\Http\Controllers\Admin;

use App\DBAChecklistsUsersPlan;
use App\Models\AcademyUsers;
use App\Models\AddDemoLog;
use App\Models\CertificatesRequests;
use App\Models\ChargeTransaction;
use App\Models\CoursesCurriculum;
use App\Models\CoursesCurriculumCertificates;
use App\Models\CoursesUsersExceptions;
use App\Models\CustomChargeTransaction;
use App\Models\CustomChargeTransactionSuspendLog;
use App\Models\DBACertificate;
use App\Models\DBAChargeTransaction;
use App\Models\DBAChecklistsUserPlan;
use App\Models\DBAPreliminaryChargeTransaction;
use App\Models\DiplomaCertificates;
use App\Models\DiplomasChargeTransaction;
use App\Models\FreeCourseChargeTransactions;
use App\Models\GiftBookChargeTransactions;
use App\Models\GiftCourseChargeTransactions;
use App\Models\GiftBookChargeTransactionsSuspendLog;
use App\Models\InternationalDiplomaCertificates;
use App\Models\InternationalDiplomas;
use App\Models\MbaCertificates;
use App\Models\MbaChargeTransaction;
use App\Models\MedicalDiplomas;
use App\Models\MedicalDiplomasChargeTransaction;
use App\Models\MedicalDiplomasCourses;
use App\Models\MedicalDiplomasCoursesUsersPlan;
use App\Models\MedicalDiplomasUsersCourses;
use App\Models\NewMba;
use App\Models\NewMbaCategoriesChargeTransaction;
use App\Models\NewMbaCategory;
use App\Models\NewMbaCategoryModule;
use App\Models\NewMbaChargeTransaction;
use App\Models\MbaCourses;
use App\Models\MedicalChargeTransactions;
use App\Models\MedicalChargeTransactionsSuspendLog;
use App\Models\DiplomasChargeTransactionSuspendLog;
use App\Models\NewMbaCourses;
use App\Models\PackagesChargeTransactionSuspendLog;
use App\Models\PackagessChargeTransaction;
use App\Models\PreparatoryMbaChargeTransaction;
use App\Models\SessionUsers;
use App\Models\SupportTransaction;
use App\Models\TrainingProgram;
use App\Models\TrainingProgramCertificate;
use App\Models\TrainingProgramChargeTransactionSuspendLog;
use App\Models\TrainingProgramCourse;
use App\Models\TrainingProgramCoursesUsersPlan;
use App\Models\TrainingProgramsChargeTransaction;
use App\Models\Diplomas;
use App\Models\DiplomasTargets;
use App\Models\Courses;
use App\Models\LifeTime;
use App\Models\AlahlyPayment;
use App\Models\PaymentTransaction;
use App\Models\DiplomasCoursesUsersPlan;
use App\Models\DiplomaCourse;
use App\Models\DiplomasUsersCourses;
use App\Models\InternationalDiplomasChargeTransaction;
use App\Models\TrainingProgramTargets;
use App\Models\TrainingProgramUsersCourses;
use App\Models\UsersCurriculumAnswers;
use App\Models\UsersSuspend;
use App\Models\LiteVersionChargeTransaction;
use App\Models\PaymentTransactionCourse;
use App\Models\CompaniesChargeTransaction;
use App\Models\DiplomasCompaniesChargeTransaction;
use App\Models\MbaCompaniesChargeTransaction;
use App\Models\LiteversionCompaniesChargeTransaction;
use App\Models\PromotionCode;
use App\Models\User;
use App\Models\UsersBlockHis;
use App\Models\BlockUsersExceptions;
use Carbon\Carbon;
use DB;
use Illuminate\Database\Eloquent\Model;
use Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Response;

use App\supplementaryTestsAnswers;

class AdminAbstractController extends Controller
{
    protected static $SUCCESS_PHONE_CHANGE_MESSAGE = "The Phone Is Changed";
    protected static $SUCCESS_EMAIL_CHANGE_MESSAGE = "Email Is Changed";
    protected static $ERROR_PHONE_CHANGE_SAME_MESSAGE = "The Old Phone Is Same As New Phone";
    protected static $ERROR_EMAIL_CHANGE_SAME_MESSAGE = "The Old Email Is Same As New Email";
    protected static $NO_DATA = "No Data";
    protected static $ERROR_CHANGE_PHONE_MESSAGE = "To Change Phone Please Try Again";
    protected static $ERROR_CHANGE_EMAIL_MESSAGE = "To Change Email Please Try Again";
    protected static $ERROR_INVALID_EMAIL_MESSAGE = "Invalid Email";
    protected static $SUCCESS_SEND_CREDENTIALS_MESSAGE = "Sending Credentials Success";
    protected static $ERROR_EMAIL_EXIST_MESSAGE = "This Email is already exist";
//    protected static $errorCorporateExpired='الكود لم يعد سارى';
    protected static $errorPromotionCode = 'كود الخصم غير صحيح';
    protected static $transactionAttachPath = "transactionAttach/";
    protected static $Mobile_exsist_message = "هذا الهاتف موجود من قبل";
    protected static $emailexsist_message = "البريد الإلكترونى موجود بالفعل";
    protected static $successRemoveMember = "Member Removed";
    protected static $errorRemoveAllAdmin = "لا يمكن مسح جميع المديرين";
//    private $FullName_json = '"name":"FullName"';
//    private  $dbstring = '"type":"string"';
//    private  $required = '"requier":"required"';
//    private $Mobile_json = '"name":"Mobile"';
//    private  $email_json = '"name":"email"';
//    private  $identification_json = '"name":"identification"';
//    private $country_json = '"name":"country"';
//    private $password_json = '"name":"password"';
//    private  $facebook_json='"name":"facebook"';
//    private   $linkedin_json='"name":"linkedin"';
//    private  $login_type_json='"name":"login_type"';
    private static $imagepath = "assets/images/";
    private static $profileDefaultImage = "user/75x75/anonymous.png";
    private static $successActiveCorporateCode = 'Success Active Corporate Code';
    private static $errorCorporateCode = 'The trial code is incorrect';
    private static $errorCorporateExpired = 'Code not available';


    public function getclientdata($email,$yotta=false)
    {
        $result=new AcademyUsers();
        if($yotta){
            $result=$result->setConnection('mysql3');
        }
        $result = $result->where('email', '=', $email)->orWhere('Mobile', '=', $email)->first();
        if ($result) {
            $user_id = $result->id;
            $result->hasPhotoshopCourse = $this->hasCourse('photoshop', $user_id);
            $result->hasPMPCourse = $this->hasCourse('pmp', $user_id);
        }
        return $result;
    }

    public function getyottaclientdata($email)
    {
        $result = DB::connection('mysql3')->table('users')->where('email', '=', $email)->orWhere('Mobile', '=', $email)->first();
        if ($result) {
            $user_id = $result->id;
            $result->hasPhotoshopCourse = $this->hasCourse('photoshop', $user_id);
            $result->hasPMPCourse = $this->hasCourse('pmp', $user_id);
        }
        return $result;
    }

    public function hasCourse($course, $user_id)
    {
        $result = false;
        if ($course == 'photoshop') {
            $result = DB::connection('mysql2')->select('select id from photoshop_course_users where user_id = ?', [$user_id]);
        } elseif ($course == 'pmp') {
            $result = DB::connection('mysql2')->select('select id from pmp_course_users where user_id = ?', [$user_id]);
        }
        if (count($result)) {
            return true;
        }
        return false;
    }


    public function hasBlockException($user_id)
    {
        $result = BlockUsersExceptions::select('id')->where('user_id', '=', $user_id)->first();
        if ($result) {
            return true;
        }
        return false;
    }

    public function savePhone($oldPhone, $newPhone, $userID, $country, $sendSMSEmail)
    {
        if (!$this->isexesituser_bymobile($newPhone)) {
            $update_data = ['Mobile' => $newPhone, 'country' => $country];
            $result = AcademyUsers::where('Mobile', '=', $oldPhone)->where('id', '=', $userID)->update($update_data);
            if ($result) {
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'users', $userID, json_encode($update_data));
                $this->trackUserWithPhone($userID, $oldPhone, $newPhone, $sendSMSEmail);
                $data = array(
                    'oldPhone' => $oldPhone,
                    'newPhone' => $newPhone,
                    'oldEmail' => $this->getuseremail($userID),
                    'newEmail' => "",
                );
                $this->update_crm_account($data);
                $this->update_crmksa_account($data);

                return true;
            }
        } else {
            return false;
        }
    }

    public function saveEmail($oldEmail, $newEmail, $userID, $sendSMSEmail)
    {
        if ($this->notExistEmail($newEmail)) {
            $update_data = ['Email' => $newEmail];
            $result = AcademyUsers::where('Email', '=', $oldEmail)->where('id', '=', $userID)->update($update_data);
            log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'users', $userID, json_encode($update_data));
            if ($result) {
                $this->trackUserWithEmail($userID, $oldEmail, $newEmail, $sendSMSEmail);
                $data = array(
                    'oldPhone' => "",
                    'newPhone' => "",
                    'oldEmail' => $oldEmail,
                    'newEmail' => $newEmail,
                );
                $this->update_crm_account($data);
                $this->update_crmksa_account($data);

                return true;
            }
        } else {
            return false;
        }
    }

    public function notExistEmail($email)
    {
        $result = AcademyUsers::where('Email', '=', $email)->first();
        if (!$result) {
            return true;
        }
        return false;
    }

    public function trackUserWithPhone($user_id, $old_phone, $new_phone, $send_credentials)
    {
        $record = new SupportTransaction();
        $record->user_id = $user_id;
        $record->employe_id = Auth::user()->id;
        $record->old_email = '';
        $record->new_email = '';
        $record->old_phone = $old_phone;
        $record->new_phone = $new_phone;
        $record->send_credentials = $send_credentials;
        $record->createdtime = date('Y-m-d H:i:s');
        if ($record->save()) {
            log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'support_transaction', $record->id, json_encode($record));
        }
    }

    public function trackUserWithEmail($user_id, $old_email, $new_email, $send_credentials)
    {
        $record = new SupportTransaction();
        $record->user_id = $user_id;
        $record->employe_id = Auth::user()->id;
        $record->old_email = $old_email;
        $record->new_email = $new_email;
        $record->old_phone = '';
        $record->new_phone = '';
        $record->send_credentials = $send_credentials;
        $record->createdtime = date('Y-m-d H:i:s');
        if ($record->save()) {
            log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'support_transaction', $record->id, json_encode($record));
        }
    }

    public function sendwelcomemail($email, $type = null)
    {
        $obj = $this->getclientdata($email);;
        $parameters = array(
            'templatename' => ($type == 'mba') ? 'welcome_mba' : 'welcome',
            'username' => $obj->FullName,
            'Email' => $obj->Email,
            'Password' => $obj->Password,
            //   'link' => $link,
            'email' => $email,
        );
        $this->sendemail($email, $parameters);
        $this->sendsms($obj->Mobile, $obj->Email, $obj->Password);
    }

    public function sendemail($email, $data)
    {
//        $url = config('globals.send_email_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        //echo $content;
//        $curl = curl_init($url);
//        //curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-Type: application/json; charset=utf-8"));
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        // echo $json_response;
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
//        return $json_response;
    }

    public function sendsms($mobile, $email, $password)
    {
        $data = array('access_token' => 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ0b2tlbiI6IjJlYzQ0YTY0MTkxZDc1MTNkMjdkNTM1MDhlNDU4NGY5OTc2MDgxMjc0YjQxNzk3NmM4MjZjYmI3Mzg5MzdmMzMwNTA1OTY2NmVhMGJkOTJiMjZiNjcxZTQ4Nzg0YWU4NmFmYThkMDg1OGI5NTRjYTVhOWZiNWIxZmRlNjBhNmFmZTdiNDdlNzcwMjBmNGE2NDQxODIxNWI0MjBiMWMxMjQiLCJpYXQiOjE1MzI2MTE5NzV9.9pMNSYMVQ0wcCojn_f2sY_ZfKpcjaCQd09L6YPyvCXM',
            'senderName' => 'E3mel.BSNS', 'recipients' => "$mobile", 'messageType' => 'text',
            'messageText' => " بيانات الدخول على إعمل بيزنس  الإيميل : $email كلمة المرور : $password");
        $url = config('globals.sendsms_link');
        //$data=array("apiKey" => "20e2b5c6-d2cc-4ec8-b653-1cc48d232da4", "userName" =>"almoasher");
        $content = "";
        foreach ($data as $key => $value) {
            $content .= $key . '=' . $value . '&';
        }
        //echo $content;
        $curl = curl_init($url);
        //curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-Type: application/json; charset=utf-8"));
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
        $json_response = curl_exec($curl);
        //echo $json_response;
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        //  echo 'Transfer Record '. $data['id'].' Is '. $json_response.'<br>';
        //$response = json_decode($json_response, true);
        //echo $response['name'];
        //var_dump($response);
        return $json_response;
    }

    public function update_crm_account($data)
    {
//        $url = config('globals.update_account_support_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);

    }

    public function update_crmksa_account($data)
    {
//        $url = config('globals.update_account_support_ksa_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);

    }

    public function getuseremail($userID)
    {
        $result = AcademyUsers::select('Email as email')->where('id', '=', $userID)->first();
        if ($result) {
            return $result->email;
        }
        return "";
    }

    public function lifeTimeCreate($user_mail, $employee_id, $created_time, $type)
    {
        $user_id = $this->getIdByEmail($user_mail);
        $user_count = $this->getLifeTimeUserId($user_id);
        if ($user_id > 0 && $user_count == 0) {
            $life_time = new LifeTime();
            $life_time->user_id = $user_id;
            $life_time->employee_id = $employee_id;
            $life_time->type = $type;
            $life_time->created_time = $created_time;
            $life_time->save();
            log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'life_time', $life_time->id, json_encode($life_time));
            return true;
        } else {
            return false;
        }

    }

    public function getIdByEmail($user_mail)
    {
        $result = AcademyUsers::select('id')->where('Email', '=', $user_mail)->first();
        if ($result) {
            return $result->id;
        }
        return 0;
    }

    public function getLifeTimeUserId($user_id)
    {
        $result = LifeTime::select('id')->where('user_id', '=', $user_id)->get();
        if ($result->count()) {
            return count($result);
        }
        return 0;
    }

    public function addAlahlyPayment($email, $price, $currency, $period, $employee_id)
    {
        $user = AcademyUsers::select('*')->where('Email', '=', $email)->first();
        if ($user) {
            $name = $user->FullName;
            $email = $user->Email;
            $phone = $user->Mobile;
            $user_id = $user->id;
            $date = date('Y-m-d H:i:s');
            $payment = new AlahlyPayment();
            $payment->name = $name;
            $payment->email = $email;
            $payment->phone = $phone;
            $payment->user_id = $user_id;
            $payment->price = $price;
            $payment->currency = $currency;
            $payment->period = $period;
            $payment->employee_id = $employee_id;
            $payment->createtime = $date;
            $payment->save();
            log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'alahly_payment', $payment->id, json_encode($payment));
            return $payment->id;
        }
    }

    public function checkPromotionCodeAPI($promotion_code, $period)
    {
        if ($promotion_code) {
            $result = PromotionCode::where('code', '=', $promotion_code)->first();
            header('Content-Type: application/json');
            if ($result) {
                $promotion = $result;
                //if($promotion->user_id==0){
                $date = date('Y-m-d H:i:s');
                if ($promotion->expired_date > $date) {
                    if (($period > 0 && $promotion->period == $period) || $promotion->period == 0) {
                        echo json_encode(['message' => 'يمكنك استخدام هذا الكوبون', 'success' => true]);
                    } else {
                        echo json_encode(['message' => 'هذا الكوبون سارى على المده ' . $promotion->period . ' شهر', 'success' => false]);
                    }
                } else {
                    echo json_encode(['message' => self::$errorCorporateExpired, 'success' => false]);
                }
                /*    }else{
                        echo json_encode(['message'=>self::$errorCorporateUsed,'success' => false]);
                    }*/
            } else {
                echo json_encode(['message' => self::$errorPromotionCode, 'success' => false]);
            }
        } else {
            echo json_encode(['message' => 'خطا فى إرسال البينات', 'success' => false]);
        }
    }
//    public function getPromotionCode($promotion_code){
//        if($promotion_code) {
//            $result = PromotionCode::where('code', '=', $promotion_code)->first();;
//            return $result;
//        }
//    }
    public function addpayment_transaction($parameters)
    {
        $package = $parameters['package'];
        $email = $parameters['email'];
        $amount = $parameters['amount'];
        $customer_id = $parameters['customer_id'];
        $createdtime = date("Y-m-d H:i:s");
        $paymentstatus = $parameters['paymentstatus'];
        $price = $parameters['price'];
        $copon_id = $parameters['copon_id'];
        $payment = new PaymentTransaction();
        $payment->email = $email;
        $payment->package = $package;
        $payment->amount = $amount;
        $payment->createdtime = $createdtime;
        $payment->paymentstatus = $paymentstatus;
        $payment->customer_id = $customer_id;
        $payment->price = $price;
        $payment->coupon_id = $copon_id;
        $payment->save();
        $id = $payment->id;
        log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'payment_transaction', $payment->id, json_encode($payment));
        return $id;
    }

//    public static function addpayment_transaction_course($parameters) {
//        $course_id=$parameters['course_id'];
//        $course_name=$parameters['course_name'];
//        $email=$parameters['email'];
//        $amount=$parameters['amount'];
//        $customer_id=$parameters['customer_id'];
//        $createdtime=date("Y-m-d H:i:s");
//        $paymentstatus=$parameters['paymentstatus'];
//        $payment=new PaymentTransactionCourse();
//        $payment->email=$email;
//        $payment->course_name=$course_name;
//        $payment->course_id=$course_id;
//        $payment->amount=$amount;
//        $payment->createdtime=$createdtime;
//        $payment->paymentstatus=$paymentstatus;
//        $payment->customer_id=$customer_id;
//        $payment->save();
//        log_user_action(Auth::user()->id,Auth::user()->username,'insert','payment_transaction_course',$payment->id,json_encode($payment));
//        $id = $payment->id;
//        return $id;
//    }

    public static function isexesituser($email)
    {
        $user = AcademyUsers::where('Email', '=', $email)->first();
        if ($user) {
            return TRUE;
        }
        return FALSE;
    }
//    public function activeuser_course($email,$course_id,$period=12,$subscrip_type='percourse')
//    {
//        $user_id=$this->getIdByEmail($email);
//        DB::connection('mysql2')->table('my_courses')->insert(
//            ['user_id' => $user_id, 'course_id' => $course_id, 'expire_date' => DB::raw("DATE_ADD(NOW(),INTERVAL  $period MONTH)")]
//        );
//        $user=AcademyUsers::where('Email','=',$email)->first();
//        if($user){
//            $user->type_of_subscribe=$subscrip_type;
//            $user->save();
//        }
//        $this->sendwelcomemail($email);
//        $this->updatelastpaymentdate($email);
//        $user2=AcademyUsers::select('FullName','PaymentExpirationDate as expiry_date','LastPaymentDate  as last_payment_date')->where('Email','=',$email)->first();
//        $expiry_date =$user2->expiry_date;
//        $last_payment_date =$user2->last_payment_date;
//        $data=array('Email' => $email,
//            'subscrip_type' => 'paid',
//            'last_payment_date' =>$last_payment_date,
//        );
//        $this->addDemo($email,3);
//        $this->transfertocrm($data);
//        $this->transfertocrm_ksa($data);
//        /*MLM UPDATE EXPIRED DATE START*/
//        $this->addAcademyChargeTransaction($user_id,$expiry_date);
//        /*MLM UPDATE EXPIRED DATE END*/
//        return   TRUE;
//    }

    public function updatelastpaymentdate($email)
    {
        $user = AcademyUsers::where('Email', '=', $email)->first();
        if ($user) {
            $user->LastPaymentDate = date("Y-m-d H:i:s");
            $user->save();
            log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'users', $user->id, json_encode(['LastPaymentDate' => $user->LastPaymentDate]));
        }
    }

//    public function addDemo($email,$period,$createdby=0){
//        $result = DB::connection('mysql2')->select(DB::raw("SELECT users.*,(SELECT COUNT(demo_log.id) AS count FROM demo_log INNER JOIN users ON users.id=demo_log.user_id WHERE users.Email='$email') as opendemos FROM users WHERE Email='$email'"));
//        if(count($result)){
//            $user = $result[0];
//            if($user->opendemos<$user->NumberOfDemo){
//                //  echo $query;
//                DB::connection('mysql2')->table('users')->where('Email', $email)->update(
//                    ['DemoExpirationDate' => DB::raw("DATE_ADD(NOW(),INTERVAL $period DAY)")]
//                );
//                $this->createDemoLog($this->getIdByEmail($email),$createdby,$period);
//                return $this->getIdByEmail($email);
//            }
//            else{
//                return -500;
//            }
//        }
//    }

//    public function createDemoLog($user_id,$createdby,$period){
//        $id=DB::connection('mysql2')->table('demo_log')->insertGetId(
//            ['user_id' => $user_id, 'createdtime' => date("Y-m-d H:i:s"), 'starttime' => date("Y-m-d H:i:s"), 'endtime' => DB::raw("DATE_ADD(NOW(),INTERVAL  $period DAY)"),'createdby'=>$createdby]
//        );
//        return $id;
//    }

    public function transfertocrm($data)
    {
//        $url = config('globals.crm_transfer_data_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
    }

    public function transfertocrm_ksa($data)
    {
//        $url = config('globals.crm_ksa_transfer_data_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        //echo $json_response;
//        //echo $status;
//        curl_close($curl);
    }
//    public function addAcademyChargeTransaction($user_id,$expired_date){
//        $result=DB::connection('mysql2')->select('select * from academy_charge_transaction where user_id = ?', [$user_id]);
//        //echo $query.'<br>';
//        $type=null;
//        if(count($result)){
//            $type='U';
//            $data=$result[0];
//            if($data->expired_date<$expired_date){
//                $id=$data->id;
//                DB::connection('mysql2')->table('academy_charge_transaction')->where('id', $id)->update(
//                    ['expired_date' => $expired_date]
//                );
//            }
//        }else{
//            $type='R';
//            DB::connection('mysql2')->table('academy_charge_transaction')->insert(
//                ['user_id' => $user_id, 'expired_date' => $expired_date]
//            );
//        }
//        if($type){
//            $this->RegisterOrUpdateCustomerAPI($user_id,$type);
//        }
//        //echo $query.'<br>';
//    }
//    public function RegisterOrUpdateCustomerAPI($user_id,$type='R'){
//
//        $type=strtoupper($type);
//        $user=$this->getuserdetails($user_id);
//        $countrycode=$this->getCountryName($user->country,'code');
//        $mobilewithdash= $countrycode.'-'.preg_replace('/^'.$countrycode.'/', '', $user->Mobile);
//        if(isset($user->id)){
//            $data=[
//                'SecretKey'=>'Secret',
//                'MerchantId'=>'Merchant',
//                'memberId'=>$user->id,
//                'sponsorId'=>$user->sponsorId,
//                'JoiningDate'=>date("d/m/Y H:i:s", strtotime($user->RegisterDate)),
//                'password'=>md5($user->Password),
//                'gender'=>'',
//                'fullName'=>$user->FullName,
//                'BirthdayDate'=>'',
//                /*    'DateOfBirthDay'=>22,
//                    'DateOfBirthMonth'=>4,
//                    'DateOfBirthYear'=>1991,*/
//                'mobileNo'=>$mobilewithdash,//self::getCountryName($user->country,'code').'-'.$user->Mobile
//                'emailId'=>$user->Email,
//                'status'=>'true',
//                /* 'nomDateOfBirthDay'=>date('d',strtotime($user->RegisterDate)),
//                 'nomDateOfBirthMonth'=>date('m',strtotime($user->RegisterDate)),
//                 'nomDateOfBirthYear'=>date('Y',strtotime($user->RegisterDate)),*/
//
//                'ValidToDate'=>date("d/m/Y", strtotime($this->getAcademyExpiredDate($user_id))),
//                'postalAddress'=>'',
//                'country'=>$this->getCountryName($user->country),
//                'stateProvince'=>'',
//                'city'=>'',
//                'zipCode'=>'',
//            ];
//            if($type=='R'){
//                $data['username']=$user->Email;
//
//                /* $data['JoiningDay']=date('d',strtotime($user->RegisterDate));
//                 $data['JoiningMonth']=date('m',strtotime($user->RegisterDate));
//                 $data['JoiningYear']=date('Y',strtotime($user->RegisterDate));*/
//                // $data['JoiningDate']=date("d-m-Y H:i:s", strtotime($user->RegisterDate));
//                // 'JoiningDate'=>date("d-m-Y H:i:s", strtotime($user->RegisterDate)),
//                //  $data['password']=md5($user->Password);
//            }
//            // echo json_encode( $data);
//
//            //self::sendApiData($data,$url="https://www.e3melbusiness.com/?page=testapi&action=sendRequest");
//            $this->sendApiData($data,"https://mlm.e3melbusiness.com/API/Customer/RegisterOrUpdateCustomer");
//        }
//    }

//    public function getuserdetails($user_id) {
//        $company = array();
//        $gives = array();
//        $services = array();
//        $result = DB::connection('mysql2')->select(DB::raw("select users.*,companies.id AS company_id,companies.name AS company_name,companies.address AS company_address,companies.description AS company_description,companies.type AS company_type,country.`code` as countrycode,country.`code` as countrycode,country.`name` as countryname from users
//		          left outer join country on country.id=users.country
//		          left join companies on users.company_id=companies.id
//				  where users.id=$user_id"));
//
//        if (count($result)) {
//            $obj = $result[0];
//            $obj->user_id=$obj->id;
//            $obj->companiesData=$this->isCompany($obj->id);
//        }
//        return $obj;
//    }

//    public function isCompany($user_id){
//        $result = DB::connection('mysql2')->select(DB::raw("SELECT companies.* FROM companies_admins INNER JOIN companies ON companies.id=companies_admins.company_id WHERE companies_admins.user_id='$user_id'"));
//        //echo $query;
//        if(count($result)){
//            $obj = $result[0];
//            return (object)['type'=>'admin','isCompany'=>true,'expiredDate'=>$obj->expiredDate,'companyType'=>$obj->type,'employeesNumbers'=>$obj->employees_numbers];
//        }
//        $result = DB::connection('mysql2')->select(DB::raw("SELECT companies.* FROM companies_requests INNER JOIN companies ON companies.id=companies_requests.company_id WHERE companies_requests.user_id='$user_id' AND deleted=0"));
//        if(count($result)){
//            $obj = $result[0];
//            return (object)['type'=>'member','isCompany'=>true,'expiredDate'=>$obj->expiredDate,'companyType'=>$obj->type,'employeesNumbers'=>$obj->employees_numbers];
//        }
//        return (object)['type'=>null,'isCompany'=>false,'expiredDate'=>null,'companyType'=>null,'employeesNumbers'=>null];
//    }

//    public function getCountryName($country_id,$column='name'){
//        $name='';
//        $result = DB::connection('mysql2')->select(DB::raw("SELECT $column FROM country WHERE id='$country_id'"));
//        if(count($result)){
//            $country = $result[0];
//            $name=$country->$column;
//        }
//        //echo $name;
//        return$name;
//    }

//    public function getAcademyExpiredDate($user_id){
//        $result=DB::connection('mysql2')->select(DB::raw("SELECT * FROM academy_charge_transaction where user_id='$user_id' LIMIT 1"));
//        if(count($result)){
//            $obj=$result[0];
//            return $obj->expired_date;
//        }
//        return '';
//    }

//    public function sendApiData($data,$url=""){
//        $date=date('Y-m-d H:i:s');
//        if($url){
//            $user_id=(isset($data['memberId']))?$data['memberId']:'';
//            $content="";
//            foreach($data as $key=>$value) { $content .= $key.'='.trim($value).'&'; }
//            //    echo $content;
//            $curl = curl_init($url);
//            curl_setopt($curl, CURLOPT_HEADER, false);
//            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//            curl_setopt($curl, CURLOPT_POST, true);
//            curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//            $json_response = curl_exec($curl);
//            $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//            //print_r($data);
//            //echo '<br><br><br>';
//            curl_close($curl);
//            //echo $json_response;
//            $ip=$_SERVER['REMOTE_ADDR'];
//            DB::connection('mysql2')->table('mlm_requests')->insert(
//                ['user_id' => $user_id, 'ip' => $ip, 'data' => $content, 'url' => $url, 'response' => $json_response, 'createtime' => $date]
//            );
//        }
//    }

//    public function activeMBAUser($mba_price,$email,$period,$start_date,$subscribe_type,$subscribe_country,$currency,$employee_id){
//        $request = Request::instance();
//        $params=$request->input();
//        if($email){
//            $start_date=date('Y-m-d H:i:s',strtotime($start_date));
//            $end_date=date('Y-m-d H:i:s',strtotime($start_date."+".$period." months"));
//            $pending=1;
//            $date=date('Y-m-d H:i:s');
//            if(isset($_FILES['attach']['name'])){
//                if(in_array($_FILES['attach']['type'],['image/jpeg','image/png','image/gif'])){
//                    $path = $_FILES['attach']['name'];
//                    $ext = pathinfo($path, PATHINFO_EXTENSION);
//                    $attach='transactionAttach-'.rand(0,9999).time().'.'.$ext;
//                    move_uploaded_file($_FILES['attach']['tmp_name'],filePath().self::$transactionAttachPath.$attach);
//                }else{
//                    echo'تأكد من رفع ملف مناسب';
//                    return'';
//                }
//            }else{
//                $attach='';
//            }
//            $DemoExpirationDate=date('Y-m-d H:i:s',strtotime($start_date.' -1 day'));
//            $DemoStartDate=date('Y-m-d H:i:s',strtotime($start_date.' -1 month'));
//            $result=DB::connection('mysql2')->select(DB::raw("SELECT * FROM mba_charge_transaction WHERE user_id=(select id from users where email='$email')"));
//            if(count($result)){
//                echo'هذا المستخدم مشترك فى MBA';
//                return'';
//                die();
//            }
//            $cs_action=isset($params['cs_action'])?$params['cs_action']:'';
//            $agent_id=isset($params['agentid'])?$params['agentid']:'';
//            $agent_name=isset($params['agentname'])?$params['agentname']:'';
//            $agent_fingre_id=isset($params['fingreprint'])?$params['fingreprint']:'';
//            $payment_method=isset($params['payment_method'])?$params['payment_method']:'';
//            $transaction_id=DB::connection('mysql2')->table('mba_charge_transaction')->insertGetId(
//                ['mba_price' => $mba_price, 'user_id' => $this->getIdByEmail($email), 'period' => $period, 'start_date' => $start_date,'end_date'=>$end_date,'pending'=>$pending,'createtime'=>$date,'subscrip_type'=>$subscribe_type,'subscrip_country'=>$subscribe_country,'currency'=>$currency,'employee_id'=>$employee_id,'attach'=>$attach,'agent_id'=>$agent_id,'agent_name'=>$agent_name,'agent_fingre_id'=>$agent_fingre_id,'payment_method'=>$payment_method,'cs_action'=>$cs_action]
//            );
//            $user=AcademyUsers::where('Email','=',$email)->first();
//            if($user){
//                $user_id=$user->id;
//                //select if not has diploma between start_date and end_date of now
//                $result=DB::table('mba_charge_transaction')
//                    ->where('user_id', $user_id)
//                    ->whereRaw('? between start_date and end_date', [$date])
//                    ->get();
//                if(($user->expired_date<$date&&!$result) || $user->type_of_subscribe=='default'){
//                    //if not expired and is anual do update
//                    AcademyUsers::where('Email','=',$email)->update(['type_of_subscribe' => 'mba','DemoExpirationDate'=>$DemoExpirationDate,'DemoStartDate'=>$DemoStartDate]);
//                }
//            }
//            $data=array('Email' => $email,
//                'subscrip_type' => $subscribe_type,
//                'expiry_date' =>$end_date,
//                'last_payment_date' =>$date,
//                'subscription_period' =>$period,
//                'mba_start_date' =>$start_date,
//            );
//            $this->transfertocrm($data);
//            $this->transfertocrm_ksa($data);
//            $this->update_crm_account($data);
//            $this->update_crm_account_ksa($data);
//
//            $this->sendwelcomemail($email,'mba');
//            $res=DB::connection('mysql2')->select(DB::raw("select PaymentExpirationDate,id,affiliat_reseller_id,affiliat_product_id from users where email='$email' LIMIT 1"));
//            $obj=$res[0];
//            $affiliatData=[
//                'code'=>$obj->affiliat_reseller_id,
//                'product_id'=>$obj->affiliat_product_id,
//                'register_user_id'=>$obj->id,
//                'ip_address'=>$_SERVER['REMOTE_ADDR'],
//                'email'=>$email
//            ];
//            if ($period>=3) {
//                $this->makeProductPaidWithCode($affiliatData);
//            }
//            /*START send transaction to service on crm MBA*/
//            $this->sendMbaChargeTransaction($transaction_id);
//            /*END send transaction to service on crm MBA*/
//            /*MLM UPDATE EXPIRED DATE START*/
//            $this->addAcademyChargeTransaction($user_id,$end_date);
//            /*MLM UPDATE EXPIRED DATE END*/
//            echo  'تم اضافة المدة بنجاح';
//            return true;
//        }
//        echo'يوجد خطأ';
//        return'';
//    }

    public static function update_crm_account_ksa($data)
    {
//        $url = config('globals.update_account_ksa_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
    }

//    public function makeProductPaidWithCode($data){
//        //  echo "send request";
//        $url=config('globals.add_product_with_code_link');
//        $content="";
//        foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
//        $json_response = curl_exec($curl);
////	echo $json_response;
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
//    }

//    public function sendMbaChargeTransaction($charge_id){
//        $result=DB::connection('mysql2')->select(DB::raw("SELECT mba_charge_transaction.*,users.country AS country,users.Email AS email,users.Mobile AS phone FROM mba_charge_transaction INNER JOIN users ON users.id=mba_charge_transaction.user_id WHERE mba_charge_transaction.id='$charge_id'"));
//        foreach ($result as $charge){
//            $this->sendChargeTransactionToCRM($charge->id,'mba transaction',$charge->email,$charge->phone,$charge->subscrip_type,'MBA',$charge->period,$charge->start_date,$charge->end_date,$charge->mba_price,$charge->createtime);
//        }
//    }

//    public function sendChargeTransactionToCRM($transaction_id,$tag_name,$email,$phone,$type,$name,$period,$start_date,$end_date,$price,$createdTime){
//        $url=config('globals.subscription_link');
//        $data=[
//            'transaction_id'=>$transaction_id,
//            'tag_name'=>$tag_name,
//            'email'=>$email,
//            'phone'=>$phone,
//            'type'=>$type,
//            'name'=>$name,
//            'period'=>$period,
//            'start_date'=>date('Y-m-d',strtotime($start_date)),
//            'end_date'=>date('Y-m-d',strtotime($end_date)),
//            'unit_price'=>$price,
//            'createdtime'=>date('Y-m-d H:i:s',strtotime($createdTime)),
//        ];
//        //print_r($data);
//        //print_r($url);
//        $content="";
//        foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
//        //echo '<br><br>';
//        //echo $json_response;
//        //echo $json_response;
//        //$ip=$_SERVER['REMOTE_ADDR'];
//        //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
//        //self::execquery($query);
//        $url=config('globals.subscription_ksa_link');
//        //print_r($data);
//        //print_r($url);
//        $content="";
//        foreach($data as $key=>$value) { $content .= $key.'='.$value.'&'; }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
//        //echo '<br><br>';
//        //echo $json_response;
//        //echo $json_response;
//        //$ip=$_SERVER['REMOTE_ADDR'];
//        //$query="INSERT INTO api_logs_send SET `ip`='$ip',`data`='$content',`url`='$url',`response`='$json_response',`createtime`='$date'";
//        //self::execquery($query);
//    }
//    public function checkPromotionCode_2($email,$promotion_id){
//        $userID= $this->getIdByEmail($email);
//        $username=$email;
//        $promotionID=$promotion_id;
//        $charge_date=date('Y-m-d H:i:s');
//        PromotionCode::where('id','=',$promotionID)->update(['user_id' => $userID,'charge_email' => $username,'charge_from' => 'website','charge_date' => $charge_date,'createdtime' => $charge_date,'take'=>'1']);
//    }

//    public function activeuser($email,$period,$subscrip_type,$amount,$currency,$copon_id=0,$lifetime="")
//    {
//        $request = Request::instance();
//        $params=$request->input();
//        // echo '$lifetime'.$lifetime;exit;
//        $obj=AcademyUsers::where('Email','=',$email)->select('FullName','PaymentExpirationDate','id','affiliat_reseller_id','affiliat_product_id')->first();
//        $type="";
//        $full_name=$obj->FullName;
//        if ($obj->PaymentExpirationDate!=1|| $obj->PaymentExpirationDate!="")
//        {
//            $type="upgrade";
//            if ($obj->PaymentExpirationDate>date("Y-m-d H:i:s")){
//                $dateexpired=0;
//            }else
//            {
//                $dateexpired=1;
//            }
//            $this->updateuserexpireddate($email,$period,$dateexpired,$subscrip_type,$amount);
//            $id=$obj->id;
//            $return=$this->getuserexpireddate($id);
//            if ($return!=""){
//                $expiry_date =$return;
//                $data=array('Email' => $email,
//                    'expiry_date' =>$expiry_date,
//                );
////                $this->update_crm_account($data);
////                $this->update_crm_account_ksa($data);
//            }
//            $pending='0';
//        }
//        else
//        {
//            $pending='1';
//            $type="new";
//        }
//        $employe_id=isset($params['employe_id'])?$params['employe_id']:0;
//        $created_time=date("Y-m-d");
//
//        if ($lifetime=="lifetime") {
//            $this->lifeTime($email, $employe_id, $created_time, $type);
//        }
//        $start_date=null;
//        $end_date=null;
//        $date=date('Y-m-d H:i:s');
//        $result=DB::connection('mysql2')->select(DB::raw("SELECT * FROM charge_transaction WHERE user_id=(select id from users where email='$email') ORDER BY createtime DESC LIMIT 1"));
//        //echo $query.'<br>';
//        if(count($result)){
//            $trans=$result[0];
//            if($date<=$trans->end_date){
//                $start_date=$trans->end_date;
//                $end_date=date('Y-m-d H:i:s',strtotime($trans->end_date.' +'.$period.' month'));
//            }else{
//                $start_date=$date;
//                $end_date=date('Y-m-d H:i:s',strtotime($date.' +'.$period.' month'));
//            }
//        }else{
//            $start_date=$date;
//            $end_date=date('Y-m-d H:i:s',strtotime($date.' +'.$period.' month'));
//        }
//
//        $employe_id=isset($params['employe_id'])?$params['employe_id']:'';
//        $cs_action=isset($params['cs_action'])?$params['cs_action']:'';
//        $agent_id=isset($params['agentid'])?$params['agentid']:'';
//        $agent_name=isset($params['agentname'])?$params['agentname']:'';
//        $agent_fingre_id=isset($params['fingreprint'])?$params['fingreprint']:'';
//        $payment_method=isset($params['payment_method'])?$params['payment_method']:'';
//        $user_id= $this->getIdByEmail($email);
//        $transaction=new ChargeTransaction();
//        $transaction->user_id=$user_id;
//        $transaction->currency=$currency;
//        $transaction->period=$period;
//        $transaction->pending=$pending;
//        $transaction->subscrip_type=$subscrip_type;
//        $transaction->amount=$amount;
//        $transaction->employee_id=$employe_id;
//        $transaction->coupon_id=$copon_id;
//        $transaction->start_date=$start_date;
//        $transaction->end_date=$end_date;
//        $transaction->createtime=$date;
//        $transaction->agent_id=$agent_id;
//        $transaction->agent_name=$agent_name;
//        $transaction->agent_fingre_id=$agent_fingre_id;
//        $transaction->payment_method=$payment_method;
//        $transaction->cs_action=$cs_action;
//        if(isset($_FILES['attach']['name'])){
//            if(in_array($_FILES['attach']['type'],['image/jpeg','image/png','image/gif'])){
//                $path = $_FILES['attach']['name'];
//                $ext = pathinfo($path, PATHINFO_EXTENSION);
//                $filename='transactionAttach-'.rand(0,9999).time().'.'.$ext;
//                move_uploaded_file($_FILES['attach']['tmp_name'],filePath().self::$transactionAttachPath.$filename);
//                $transaction->attach=$filename;
//            }else{
//                return'';
//            }
//        }
//        $transaction->save();
//        //echo $query.'<br>';
//        //echo $query;
//        $return =FALSE;
//        $transaction_id=$transaction->id;
//
//
////echo $query;
//        $this->type_of_subscribe($email);
//        if ($transaction_id) {
//            if ($pending=='1')
//            {
//                $this->updatelastpaymentdate($email);
//                $obj1=AcademyUsers::where('Email','=',$email)->select('FullName','PaymentExpirationDate as expiry_date',',LastPaymentDate  as last_payment_date')->first();
//                $expiry_date =$obj1->expiry_date;
//                $last_payment_date =$obj1->last_payment_date;
//                $data=array('Email' => $email,
//                    'subscrip_type' => $subscrip_type,
//                    'expiry_date' =>$expiry_date,
//                    'last_payment_date' =>$last_payment_date,
//                    'subscription_period' =>$period,
//                    'fullname' =>$full_name,
//                );
//                $this->transfertocrm($data);
//                $this->transfertocrm_ksa($data);
//                $affiliatData=[
//                    'code'=>$obj->affiliat_reseller_id,
//                    'product_id'=>$obj->affiliat_product_id,
//                    'register_user_id'=>$obj->id,
//                    'ip_address'=>$_SERVER['REMOTE_ADDR'],
//                    'email'=>$email,
//                ];
//                if ($period>=3 && $subscrip_type!="") {
//                    $this->makeProductPaidWithCode($affiliatData);
//                }
//            }
//            $return=TRUE;
//            /*START send transaction to service on crm USER CHARGE*/
//            $this->sendChargeTransaction($transaction_id);
//            /*END send transaction to service on crm USER CHARGE*/
//            /*MLM UPDATE EXPIRED DATE START*/
//            $this->addAcademyChargeTransaction($user_id,$end_date);
//            /*MLM UPDATE EXPIRED DATE END*/
//        }
//
//        if ($return===TRUE)
//        {
//            $this->sendwelcomemail($email);
//        }
//        return   $return;
//    }

//    public function updateuserexpireddate($email,$period,$dateexpired=0,$subscrip_type,$amount)
//    {
//        $data=array();
//        $addDate=($period=='0.5')?"INTERVAL 15 DAY":"INTERVAL $period MONTH";
//        if ($dateexpired==0){
//            DB::connection('mysql2')->table('users')->where('Email', $email)->update(
//                ['PaymentExpirationDate' => DB::raw("DATE_ADD(PaymentExpirationDate,$addDate)"),'LastPaymentDate'=>date('Y-m-d H:i:s')]
//            );
//        }
//        else{
//            DB::connection('mysql2')->table('users')->where('Email', $email)->update(
//                ['PaymentExpirationDate' => DB::raw("DATE_ADD(NOW(),$addDate)"),'LastPaymentDate'=>date('Y-m-d H:i:s')]
//            );
//        }
//    }

//    public function getuserexpireddate($id)
//    {
//        $data="";
//        $obj=AcademyUsers::select('PaymentExpirationDate')->where('id', $id)->first();
//        if ($obj) {
//            $data=$obj->PaymentExpirationDate;
//        }
//        return $data;
//    }

//    public function lifeTime($user_mail,$employee_id,$created_time,$type)
//    {
//        $user_id=$this->getIdByEmail($user_mail);
//        $user_count=$this->getLifeTimeUserId($user_id);
//        if($user_id>0&& $user_count==0){
//            $life_time=new LifeTime();
//            $life_time->user_id=$user_id;
//            $life_time->employee_id=$employee_id;
//            $life_time->type=$type;
//            $life_time->created_time=$created_time;
//            $life_time->save();
//            return true;
//        }else{
//            return false;
//        }
//    }

//    public function type_of_subscribe($email,$subscrip_type='annual')
//    {
//        AcademyUsers::where('Email','=',$email)->update(['type_of_subscribe' => $subscrip_type]);
//    }

//    public function sendChargeTransaction($charge_id){
//        $result=DB::connection('mysql2')->select(DB::raw("SELECT charge_transaction.*,users.country AS country,users.Email AS email,users.Mobile AS phone FROM charge_transaction INNER JOIN users ON users.id=charge_transaction.user_id WHERE charge_transaction.id='$charge_id'"));
//        foreach ($result as $charge){
//            $this->sendChargeTransactionToCRM($charge->id,'charge transaction',$charge->email,$charge->phone,$charge->subscrip_type,'charge for client',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime);
//         }
//    }

//    public function getDiplomaPrice($diploma_id,$column='tool_ksa_price'){
//        $diploma=Diplomas::find($diploma_id);
//        if($diploma){
//            return $diploma->$column;
//        }
//    }

//    public function register()
//    {
//        //echo '{' . "$this->firstName_json,$this->dbstring" . '}';
//        $parameters = array('{' . "$this->FullName_json,$this->dbstring" . ",$this->required" . '}',
//            '{' . "$this->Mobile_json,$this->dbstring"  . ",$this->required" . '}',
//            '{' . "$this->email_json,$this->dbstring" .",$this->required" . '}',
//            '{' . "$this->identification_json,$this->dbstring" . '}',
//            '{' . "$this->country_json,$this->dbstring" . '}',
//            '{' . "$this->password_json,$this->dbstring" . ",$this->required" . '}',
//
//            '{' . "$this->facebook_json,$this->dbstring" . '}',
//            '{' . "$this->linkedin_json,$this->dbstring" . '}',
//            '{' . "$this->login_type_json,$this->dbstring" . '}',
//
//        );
//
//        return $parameters ;
//    }

//    public function randomPassword() {
//        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
//        $pass = array(); //remember to declare $pass as an array
//        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
//        for ($i = 0; $i < 8; $i++) {
//            $n = rand(0, $alphaLength);
//            $pass[] = $alphabet[$n];
//        }
//        return implode($pass); //turn the array into a string
//    }

//    public function adduser($parameters) {
//        $request = Request::instance();
//        $params=$request->all();
//        $keys = "";
//        $values = "";
//        $email="";
////        $currentsource=self::$sessionhandler2->get('currentlink');
//        //die('my current session is '.$currentsource);
//        foreach ($parameters as $parameter) {
//            //echo $parameter;
//            $json = json_decode($parameter);
//            $key = $json->name;
//            $value = $json->value;
//            $type = $json->type;
//            $keys = $keys . $key . ',';
//            if ($key == 'email') {
//                $email=	$value;
//                if ( $this->isexesituser($value)===TRUE)
//                {
//                    //echo self::$emailexsist_message;
//                    $errorMessage=  self::$emailexsist_message;
//                    echo view('auth.message.error_message',compact('errorMessage'));
//                    return 0;
//                }
//            }
//            if ($key == 'Mobile') {
//                $Mobile=	$value;
//                if ( $this->isexesituser_bymobile($Mobile)===TRUE)
//                {
//                    //echo self::$emailexsist_message;
//                    $errorMessage=  self::$Mobile_exsist_message;
//                    echo view('auth.message.error_message',compact('errorMessage'));
//                    return 0;
//                }
//            }
//            if ($type == 'string') {
//                $values = $values . "'$value'" . ',';
//            } else {
//                $values = $values . $value . ',';
//            }
//        }
//        $HTTP_REFERER=$_SERVER['HTTP_REFERER'];
//        $RegisterIP=$_SERVER['REMOTE_ADDR'];
//        $keys = $keys . 'RegisterReferrer,';
//        $values = $values . "'$HTTP_REFERER'" . ',';
//        $keys = $keys . 'RegisterIP,';
//        $values = $values . "'$RegisterIP'" . ',';
//        if(isset($params['sponsorId'])){
//            $sponsorId=$params['sponsorId'];
//            $result=AcademyUsers::find($sponsorId);
//            if($result){
//                $keys = $keys . 'sponsorId,';
//                $values = $values . "'$sponsorId'" . ',';
//            }
//        }
//        $query = "insert into users (" . substr($keys, 0, -1) . ')' .
//            " Values (" . substr($values, 0, -1) . ")";
//
//        $result = DB::connection('mysql2')->insert($query);
//        $id = DB::connection('mysql2') -> getPdo() -> lastInsertId();
//        if ($id>0){
//            //self::confirmCompanyEmail($id);
//            self::addAsAffiliate($id);
//            /*  $errorMessage=  self::$success_message;
//              include 'views/message/success_message.php';*/
//            /*add record to crm*/
//            self::transferdatatocrmbyid($id);
//            // self::sendwelcomemail($email);
//        }
//        else
//        {
//            $errorMessage=  self::$problem_message;
//            include 'views/message/error_message.php';
//        }
//        return $id;
//    }

    public function isexesituser_bymobile($mobile)
    {
        $user = AcademyUsers::where('Mobile', '=', $mobile)->first();
        if ($user) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

//    public function addAsAffiliate($user_id){
//        //Exsit customer affiliat id
//        $affiliate_id=Session::get('affiliateID');
//        if($affiliate_id){
//            AcademyUsers::where('id','=',$user_id)->update(['affiliate_id' => $affiliate_id]);
//        }
//
//        //section to send data to arabyclick
//        /*$reseller_id=self::$sessionhandler2->get('AFFILIATELANDINGPAGE');
//        $product_id=self::$sessionhandler2->get('AFFILIATELANDINGPAGEOFFERID');*/
//        $reseller_id=$_COOKIE['AFFILIATELANDINGPAGE'];
//        $product_id=$_COOKIE['AFFILIATELANDINGPAGEOFFERID'];
//
//        if($reseller_id&&$product_id){
//            $query="UPDATE users SET affiliat_reseller_id='$reseller_id',affiliat_product_id='$product_id' WHERE id='$user_id'";
//            self::execquery($query);
//            self::affiliate_senddata($user_id,$reseller_id,$product_id);
//        }else{
//            $reseller_id=$_COOKIE['AFFILIATELANDINGPAGE'];
//            $product_id=$_COOKIE['AFFILIATELANDINGPAGEOFFERID'];
//            if($reseller_id&&$product_id){
//                $query="UPDATE users SET affiliat_reseller_id='$reseller_id',affiliat_product_id='$product_id' WHERE id='$user_id'";
//                self::execquery($query);
//                self::affiliate_senddata($user_id,$reseller_id,$product_id);
//            }
//        }
//    }

    public function getDiplomasTargets()
    {
        $result = DiplomasTargets::join('diplomas', 'diplomas.id', '=', 'diplomas_targets.diploma_id')
            ->select('diplomas_targets.*', 'diplomas.name AS diploma_name');
        if (count($result)) {
            return $result;
        }
        return [];
    }

    public function getdiplomateam($yearMonth = "", $condition = "")
    {
        $date = date('Y-m');
        $yearMonth = (empty($yearMonth)) ? date('Y-m', strtotime($date . " +1 month")) : $yearMonth;
        $result = DB::connection('mysql2')->select(DB::raw("SELECT diplomas.name as diplomaname ,(select count('x') from diplomas_charge_transaction where diplomas_charge_transaction.diploma_id=diplomas.id and diplomas_charge_transaction.employee_id in (23,26,27,28) AND DATE_FORMAT(diplomas_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as salesegy ,(select count('x') from diplomas_charge_transaction where diplomas_charge_transaction.diploma_id=diplomas.id and diplomas_charge_transaction.employee_id in (32) AND DATE_FORMAT(diplomas_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as supportegy ,(select count('x') from diplomas_charge_transaction where diplomas_charge_transaction.diploma_id=diplomas.id and diplomas_charge_transaction.employee_id in (29,30,33,24) AND DATE_FORMAT(diplomas_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as salesksa ,(select count('x') from diplomas_charge_transaction where diplomas_charge_transaction.diploma_id=diplomas.id and diplomas_charge_transaction.employee_id in (31) AND DATE_FORMAT(diplomas_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as supportksa,(SELECT diplomas_targets.target FROM diplomas_targets WHERE diplomas_targets.diploma_id=diplomas.id AND DATE_FORMAT(diplomas_targets.date,'%Y-%m')='$yearMonth') AS available  FROM diplomas GROUP by diplomas.name"));
        if (count($result)) {
            return $result;
        }

        return "";
    }

    public function getStartDates()
    {
        $result = DB::connection('mysql2')->select("SELECT DISTINCT start_date FROM diplomas_charge_transaction");
        return $result;
    }

    public function getTrainingProgramsTargets()
    {
        $result = TrainingProgramTargets::join('training_program', 'training_program.id', '=', 'training_program_targets.diploma_id')
            ->select('training_program_targets.*', 'training_program.name AS training_program_name');
        if (count($result)) {
            return $result;
        }
        return [];
    }

    public function gettraining_programteam($yearMonth = "", $condition = "")
    {
        $date = date('Y-m');
        $yearMonth = (empty($yearMonth)) ? date('Y-m', strtotime($date . " +1 month")) : $yearMonth;
        $result = DB::connection('mysql2')->select(DB::raw("SELECT training_program.name as training_programname ,(select count('x') from training_program_charge_transaction where training_program_charge_transaction.diploma_id=training_program.id and training_program_charge_transaction.employee_id in (23,26,27,28) AND DATE_FORMAT(training_program_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as salesegy ,(select count('x') from training_program_charge_transaction where training_program_charge_transaction.diploma_id=training_program.id and training_program_charge_transaction.employee_id in (32) AND DATE_FORMAT(training_program_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as supportegy ,(select count('x') from training_program_charge_transaction where training_program_charge_transaction.diploma_id=training_program.id and training_program_charge_transaction.employee_id in (29,30,33,24) AND DATE_FORMAT(training_program_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as salesksa ,(select count('x') from training_program_charge_transaction where training_program_charge_transaction.diploma_id=training_program.id and training_program_charge_transaction.employee_id in (31) AND DATE_FORMAT(training_program_charge_transaction.start_date,'%Y-%m')='$yearMonth' ) as supportksa,(SELECT training_program_targets.target FROM training_program_targets WHERE training_program_targets.diploma_id=training_program.id AND DATE_FORMAT(training_program_targets.date,'%Y-%m')='$yearMonth') AS available  FROM training_program GROUP by training_program.name"));
        if (count($result)) {
            return $result;
        }

        return "";
    }

    public function getTrainingProgramStartDates()
    {
        $result = DB::connection('mysql2')->select("SELECT DISTINCT start_date FROM training_program_charge_transaction");
        return $result;
    }

    public function doChangeLifeTime($type_id, $type)
    {
        if ($type && $type_id) {
            LifeTime::where('id', '=', $type_id)->update(['type' => $type]);
            log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'life_time', $type_id, json_encode(['type' => $type]));
            return true;
        }
        return false;
    }

    public function getUserTrainingProgramsCoursesCertificatesReport($user_id, $diploma_id)
    {

        $query = "SELECT 
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers,
answer_2.wrong_answers AS wrong_answers,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers AS right_answers_2,
users_curriculum_answers.wrong_answers AS wrong_answers_2,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage_2
FROM(

select 
(SELECT 
 COUNT(id) 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=training_program_courses_user_plan.course_id AND training_program_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT 
 id AS answer_id 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=training_program_courses_user_plan.course_id AND training_program_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam' ORDER BY right_answers DESC LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =training_program_courses_user_plan.course_id AND ISNULL(courses_curriculum_certificates.deleted_at) AND courses_curriculum_certificates.user_id='$user_id' AND training_program_courses_user_plan.user_id='$user_id' LIMIT 1) AS certificate_id
 FROM training_program_courses_user_plan  
LEFT JOIN courses ON courses.id=training_program_courses_user_plan.course_id 
WHERE training_program_courses_user_plan.diploma_id ='$diploma_id' AND training_program_courses_user_plan.user_id='$user_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id AND ISNULL(courses_curriculum_certificates.deleted_at)
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";
        //echo($query);die();

        $result = DB::connection('mysql2')->select(DB::raw($query));

        header('Content-Type: text/csv; charset=utf-8');

        header('Content-Disposition: attachment; filename=users_diplomas_certificates_report.csv');

        $output = fopen("php://output", "w");

        fputcsv($output, array('Count Id', 'User Exam', 'Course Id', 'Course Name', 'Certificate Id', 'Certificate Serial', 'Right Answer 1', 'Wrong Answer 1', 'Total', 'Percentage 1', 'Add Date'));

        foreach ($result as $res) {

            if (isset($res->wrong_answers) && !empty($res->wrong_answers) && isset($res->quetions_numbers) && !empty($res->quetions_numbers)) {
                $total = $res->wrong_answers . "/" . $res->quetions_numbers;
            } else {
                $total = '';
            }

            if (isset($res->user_exam) && !empty($res->user_exam)) {
                $res->user_exam = "YES";
            } else {
                $res->user_exam = "NO";
            }

            fputcsv($output, [
                $res->count_id,
                $res->user_exam,
                $res->course_id,
                $res->course_name,
                $res->certificate_id,
                $res->serial_number,
                $res->right_answers,
                $res->wrong_answers,
                $total,
                $res->persentage,
                $res->add_date,
            ]);
        }

        fclose($output);

    }

    public function getCompanies()
    {
        $result = DB::connection('mysql2')->select('select id,name from companies where type = ?', ['live']);
        return $result;
    }

    public function doAddNewCompany($request)
    {

        $params = $request->all();
        $employee_id = Auth::user()->id;
        $companyName = isset($params['addCompanyName']) ? $params['addCompanyName'] : null;
        $companyDescription = isset($params['addCompanyDescription']) ? $params['addCompanyDescription'] : null;
        $companyEmployee = isset($params['addCompanyEmployee']) ? $params['addCompanyEmployee'] : null;
        $companyType = 'live';
        if ($companyName && $companyDescription && $companyEmployee && $companyType && in_array($companyType, ['demo', 'live'])) {
            $result = DB::connection('mysql2')->select('select id from companies where name = ?', [$companyName]);
            if (count($result)) {
                echo '<div class="alert alert-danger">This Company is Exist</div>';
                die();
            }
            $date = date('Y-m-d H:i:s');
            $insert_data = ['name' => $companyName, 'description' => $companyDescription, 'employees_numbers' => $companyEmployee, 'type' => $companyType, 'employee_id' => $employee_id, 'createtime' => $date];
            $comp_id = DB::connection('mysql2')->table('companies')->insertGetId($insert_data);
            log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'companies', $comp_id, json_encode($insert_data));
            echo '<div class="alert alert-success">Done Adding New Company Go To Add Company Period</div>';

        }
    }

    public function doAddCompanyPeriod($request)
    {
        $params = $request->all();
        $company_id = isset($params['addCompanyPeriodCompany']) ? $params['addCompanyPeriodCompany'] : null;
        $period = isset($params['addCompanyPeriodPeriod']) ? $params['addCompanyPeriodPeriod'] : null;
        $amount = isset($params['addCompanyPeriodAmount']) ? $params['addCompanyPeriodAmount'] : null;
        $companyType = 'live';
        if ($company_id && $period && $amount && $companyType && in_array($companyType, ['demo', 'live'])) {
            $result = DB::connection('mysql2')->select('select * from companies where id = ? and type = ?', [$company_id, $companyType]);

            if (count($result)) {
                $expiredDate = date('Y-m-d H:i:s', strtotime('+' . $period . ' months'));
                $date = date('Y-m-d H:i:s');
                $update_data = ['expiredDate' => $expiredDate, 'period' => $period, 'amount' => $amount, 'modifiedtime' => $date];
                DB::connection('mysql2')->table('companies')->where('id', $company_id)->update($update_data);
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'companies', $company_id, json_encode($update_data));
                $employee_id = Auth::user()->id;
                $insert_data = ['company_id' => $company_id, 'company_type' => $companyType, 'expiredDate' => $expiredDate, 'period' => $period, 'amount' => $amount, 'employee_id' => $employee_id, 'createtime' => $date];
                DB::connection('mysql2')->table('companies_period_logs')->insert($insert_data);
                //log_user_action(Auth::user()->id,Auth::user()->username,'update','companies',$company_id,json_encode($update_data));
                echo '<div class="alert alert-success">Done Adding Company Period</div>';
            }
        }
    }

    public function doSearchForAdminMembersCompany($request)
    {
        $params = $request->all();
        $company_id = isset($params['company_id']) ? $params['company_id'] : null;
        $companyType = 'live';
        if ($company_id && $companyType && in_array($companyType, ['demo', 'live'])) {
            $result = DB::connection('mysql2')->select('select * from companies where id = ? and type = ?', [$company_id, $companyType]);
            if (count($result)) {
                $company = $result[0];
                $result = AcademyUsers::where('company_id', '=', $company_id)->where('type', '=', 'company')->get();
                $result2 = AcademyUsers::join('companies_requests', 'companies_requests.user_id', '=', 'users.id')->where('companies_requests.company_id', '=', $company_id)->where('deleted', '=', '0')->select('users.*', 'companies_requests.id AS request_id')->get();
                $assets_path = 'https://www.e3melbusiness.com/';
                if (PerUser('companies_suspend')) {
                    echo '<div style="text-align: center" class="col-lg-12">';
                    echo ($company->suspend) ? '<button data-id="' . $company->id . '" class="suspendCompanyButton btn btn-info">UnSuspend</button>' : '<button data-id="' . $company->id . '" class="suspendCompanyButton btn btn-danger">Suspend</button>';
                    echo '</div>';
                }
                echo '<div class="mt-comments">';
                if ($result->count() || $result2->count()) {
                    if ($result->count()) {
                        echo '<span class="caption-subject font-dark bold uppercase">Admins</span>';

                        if ($companyType == 'demo') {
                            //echo '<div class="text-center"><button class="btn btn-success input-circle" id="goLiveCompanyButton">Go Live</button></div>';
                        }
                        foreach ($result as $user) {
                            echo '
                            <div class="mt-comment">
                            
                                <div class="mt-comment-img">
                                    <img style="width: 100%;" src="' . $assets_path . ((empty($user->image)) ? self::$imagepath . self::$profileDefaultImage : self::$imagepath . $user->image) . '"> </div>
                                <div class="mt-comment-body">
                                    <div class="mt-comment-info">
                                        <span class="mt-comment-author">' . $user->FullName . '</span><div class="clearfix"></div>';
                            $user_id = $user->id;
                            $this->check_company_user_charge($user_id);
                            echo '</div>
                                     <div class="mt-comment-text">' . $user->Email . '</div>
                                </div> ';
                            if (count($result) > 1 && PerUser('companies_admin_remove')) {
                                echo '<div style="position: relative; bottom: 30px;text-align:right;float:right;"><a data-id="' . $user->id . '" class="deleteThisAdmin btn btn-danger" data-toggle="modal" href="#removeThisAdmin"><i class="fa fa-trash"></i></a></div>';
                            }
                            echo '</div>';
                        }
                    }
                    if ($result2->count()) {
                        echo '<span class="caption-subject font-dark bold uppercase">Members</span>';

                        foreach ($result2 as $user) {
                            echo '
                    <div class="mt-comment">
                        <div class="mt-comment-img">
                            <img style="width: 100%;" src="' . $assets_path . ((empty($user->image)) ? self::$imagepath . self::$profileDefaultImage : self::$imagepath . $user->image) . '"> </div>
                        <div class="mt-comment-body">
                            <div class="mt-comment-info">
                                <span class="mt-comment-author">' . $user->FullName . '</span><div class="clearfix"></div>';
                            $user_id = $user->id;
                            $this->check_company_user_charge($user_id);
                            echo '</div>
                             <div class="mt-comment-text">' . $user->Email . '</div>
                        </div>';
                            if (PerUser('companies_member_remove')) {
                                echo '<div style="position: relative; bottom: 30px;text-align:right;float:right;"><a data-id="' . $user->request_id . '" class="deleteThisMember btn btn-danger" data-toggle="modal" href="#removeThisMember"><i class="fa fa-trash"></i></a></div>';
                            }

                            echo '</div>';
                        }
                    }
                } else {
                    echo '<div class="alert alert-info">No Data</div>';
                }

                echo '</div>';

            }

        }

    }

    public function doSearchForExistAdminMembersCompany($request)
    {
        $params = $request->all();
        $company_id = isset($params['company_id']) ? $params['company_id'] : null;
        $companyType = 'live';
        if ($company_id && $companyType && in_array($companyType, ['demo', 'live'])) {
            $html = '<option value="">Select Admin Or Member</option>';
            $result = DB::connection('mysql2')->select('select * from companies where id = ? and type = ?', [$company_id, $companyType]);
            if (count($result)) {
                $result = AcademyUsers::where('company_id', '=', $company_id)->where('type', '=', 'company')->get();
                $result2 = AcademyUsers::join('companies_requests', 'companies_requests.user_id', '=', 'users.id')->where('companies_requests.company_id', '=', $company_id)->where('deleted', '=', '0')->select('users.*', 'companies_requests.id AS request_id')->get();

                if ($result->count() || $result2->count()) {
                    if ($result->count()) {
                        $html .= '<optgroup label="Admins">';
                        foreach ($result as $user) {
                            $html .= '<option value="' . $user->id . '">' . $user->FullName . ' - ' . $user->Email . '</option>';
                        }
                        $html .= '</optgroup>';
                    }
                    if ($result2->count()) {
                        $html .= '<optgroup label="Members">';
                        foreach ($result2 as $user) {
                            $html .= '<option value="' . $user->id . '">' . $user->FullName . ' - ' . $user->Email . '</option>';
                        }
                        $html .= '</optgroup>';
                    }
                }
            }
            echo $html;
        }

    }

    public function doShowChargeTransactionsAdminMember($request)
    {
        $company_id = $request->company_id;
        $user_id = $request->user_id;
        $htmlSelector = '';


        $html = '<table class="table table-hover"><thead>
            <tr>
                <th>Type</th>
                <th>Start Date</th>
                <th>End Date</th>
            </tr>
            </thead><tbody>';
        if ($company_id && $user_id) {
            $diplomas = Diplomas::select('id', 'name')->get();
            $training_programs = TrainingProgram::select('id', 'name')->get();
            $new_mba_categories = NewMbaCategory::select('id', 'name')->get();
            $htmlSelector .= '<div class="col-sm-12">
                            <div id="addTransactionMessage"></div>
                            <div class="form-group">
                            <div class="input-group">
                                <select name="addTransactionType" id="addTransactionType"
                                        class="form-control sel2charge-for-client-sec form-filter edited">
                                    <option value="">Select Type</option>
                                    <option value="diploma">Diploma</option>
                                    <option value="mba">Mba</option>
                                    <option value="lifetime">Lifetime</option>
                                    <option value="liteversion">Lite Version</option>
                                    <option value="newmba">New MBA</option>
                                    <option value="trainingprogram">Training Program</option>
                                </select>
                                <label for="company_add_member_type"></label>
                                <span class="input-group-btn">
                                    <button id="addTransaction" data-company-id="' . $company_id . '" data-user-id="' . $user_id . '" class="btn btn-success input-circle-right" type="button">
                                        <i class="fa fa-search"></i> Add Transaction
                                    </button>
                                </span>
                            </div>
                            </div>
                        </div>';

            $htmlSelector .= '<div id="addTransactionDiplomasDiv" class="col-sm-12 hidden">
                               <div class="form-group form-md-line-input has-info">
                                    <select name="addTransactionDiplomas" id="addTransactionDiplomas"
                                           class="form-control sel2charge-for-client-sec form-filter edited">
                                        <option value="">Select Diploma</option> ';
            foreach ($diplomas as $diploma) {
                $htmlSelector .= "<option  value='$diploma->id'>$diploma->name</option>";
            }

            $htmlSelector .= '</select>
                                <label for="company_add_member_diploma"></label>
                            </div>
                        </div>';
            $htmlSelector .= '<div id="addTransactionTrainingDiv" class="col-sm-12 hidden">
                               <div class="form-group form-md-line-input has-info">
                                    <select name="addTransactionTraining" id="addTransactionTraining"
                                           class="form-control sel2charge-for-client-sec form-filter edited">
                                        <option value="">Select TRaining</option> ';
            foreach ($training_programs as $training_program) {
                $htmlSelector .= "<option  value='$training_program->id'>$training_program->name</option>";
            }

            $htmlSelector .= '</select>
                                <label for="company_add_member_diploma"></label>
                            </div>
                        </div>';
            $htmlSelector .= '<div id="addTransactionNEWMBADiv" class="col-sm-12 hidden">
                               <div class="form-group form-md-line-input has-info">
                                    <select name="addTransactionNEWMBA" id="addTransactionNEWMBA"
                                           class="form-control sel2charge-for-client-sec form-filter edited">
                                        <option value="">Select NEWMBA Category</option> ';
            foreach ($new_mba_categories as $new_mba_category) {
                $htmlSelector .= "<option  value='$new_mba_category->id'>$new_mba_category->name</option>";
            }

            $htmlSelector .= '</select>
                                <label for="company_add_member_diploma"></label>
                            </div>
                        </div>';
            $hasCharge = false;
            $company_charge_transaction = DB::connection('mysql2')->table('companies_charge_transaction')
                ->select('companies_charge_transaction.*', 'companies.expiredDate')
                ->join('companies', 'companies.id', '=', 'companies_charge_transaction.company_id')
                ->where('company_id', $company_id)->where('user_id', $user_id)->get();
            foreach ($company_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>Charge Transaction</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
                $hasCharge = true;
            }
            $diplomas_charge_transaction = DB::connection('mysql2')->table('diplomas_companies_charge_transaction')
                ->select('diplomas_companies_charge_transaction.*', 'companies.expiredDate', 'diplomas.name AS diploma_name')
                ->join('companies', 'companies.id', '=', 'diplomas_companies_charge_transaction.company_id')
                ->join('diplomas', 'diplomas.id', '=', 'diplomas_companies_charge_transaction.diploma_id')
                ->where('company_id', $company_id)->where('user_id', $user_id)->get();
            foreach ($diplomas_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>' . $charge->diploma_name . '</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
                $hasCharge = true;
            }
            $training_charge_transaction = DB::connection('mysql2')->table('training_programs_companies_charge_transaction')
                ->select('training_programs_companies_charge_transaction.*', 'companies.expiredDate', 'training_program.name AS diploma_name')
                ->join('companies', 'companies.id', '=', 'training_programs_companies_charge_transaction.company_id')
                ->join('training_program', 'training_program.id', '=', 'training_programs_companies_charge_transaction.diploma_id')
                ->where('company_id', $company_id)->where('user_id', $user_id)->get();
            foreach ($training_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>' . $charge->diploma_name . '</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
                $hasCharge = true;
            }

            $lite_charge_transaction = DB::connection('mysql2')->table('lite_version_companies_charge_transaction')
                ->select('lite_version_companies_charge_transaction.*', 'companies.expiredDate')
                ->join('companies', 'companies.id', '=', 'lite_version_companies_charge_transaction.company_id')
                ->where('company_id', $company_id)->where('user_id', $user_id)->get();
            foreach ($lite_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>Lite Version</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
                $hasCharge = true;
            }
            $mba_charge_transaction = DB::connection('mysql2')->table('mba_companies_charge_transaction')
                ->select('mba_companies_charge_transaction.*', 'companies.expiredDate')
                ->join('companies', 'companies.id', '=', 'mba_companies_charge_transaction.company_id')
                ->where('company_id', $company_id)->where('user_id', $user_id)->get();
            foreach ($mba_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>MBA</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
                $hasCharge = true;
            }
            $new_mba_charge_transaction = DB::connection('mysql2')->table('new_mba_companies_charge_transaction')
                ->select('new_mba_companies_charge_transaction.*', 'companies.expiredDate', 'new_mba_categories.name as name')
                ->join('companies', 'companies.id', '=', 'new_mba_companies_charge_transaction.company_id')
                ->join('new_mba_categories', 'new_mba_categories.id', '=', 'new_mba_companies_charge_transaction.category_id')
                ->where('company_id', $company_id)->where('user_id', $user_id)->get();
            foreach ($new_mba_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>New MBA ' . $charge->name . '</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
                $hasCharge = true;
            }
            if (!$hasCharge) {
                $html .= '<tr><td colspan="3" class="text-center">No Data</td></tr>';

            }

        } else {
            $html .= '<tr><td colspan="3" class="text-center">No Data</td></tr>';
        }
        $html .= '</tbody></table>';
        echo $htmlSelector;
        echo $html;
    }

    public function doAddChargeToUser($request)
    {
        $user_id = $request->user_id;
        $company_id = $request->company_id;
        $diploma_id = $request->diploma_id;
        $training_program_id = $request->training_program_id;
        $new_mba_category = $request->new_mba_category;
        $type = $request->type;
        if ($user_id && $company_id && $type) {
            $table = 'companies_charge_transaction';
            $period = 12;
            switch ($type) {
                case 'diploma':
                    $table = 'diplomas_companies_charge_transaction';
                    $period = 9;
                    break;
                case 'trainingprogram':
                    $table = 'training_programs_companies_charge_transaction';
                    $period = 9;
                    break;
                case 'mba':
                    $table = 'mba_companies_charge_transaction';
                    $period = 12;
                    break;
                case 'newmba':
                    $table = 'new_mba_companies_charge_transaction';
                    $period = 12;
                    break;
                case 'liteversion':
                    $table = 'lite_version_companies_charge_transaction';
                    $period = 12;
                    break;
                case 'lifetime':
                    $table = 'companies_charge_transaction';
                    $period = 12;
                    break;
            }
            $data = DB::connection('mysql2')->table($table)->where('company_id', $company_id)->where('user_id', $user_id);
            if ($type == 'diploma') {
                $data = $data->where('diploma_id', $diploma_id);
            }
            if ($type == 'trainingprogram') {
                $data = $data->where('diploma_id', $training_program_id);
            }
            if ($type == 'newmba') {
                $data = $data->where('category_id', $new_mba_category);
            }

            $data = $data->count();

            if ($data) {
                return response()->json(['success' => false, 'message' => '<div class="alert alert-danger">The user Have Already Taken This Charge transaction</div>'])->setCallback($request->input('callback'));
            }
            $dataInsert = [
                'company_id' => $company_id,
                'user_id' => $user_id,
                'period' => $period,
                'start_date' => date('Y-m-d H:i:s'),
                'end_date' => date('Y-m-d H:i:s', strtotime('+' . $period . ' month')),
            ];
            if ($type == 'diploma') {
                $diploma = Diplomas::find($diploma_id);
                $dataInsert['diploma_id'] = $diploma_id;
                if (count($diploma)) {
                    $dataInsert['diploma_name'] = $diploma->name;
                }
            }
            if ($type == 'trainingprogram') {
                $diploma = TrainingProgram::find($training_program_id);
                $dataInsert['diploma_id'] = $training_program_id;
                if (count($diploma)) {
                    $dataInsert['diploma_name'] = $diploma->name;
                }
            }
            if ($type == 'newmba') {
                $dataInsert['category_id'] = $new_mba_category;
            }
            if ($type == 'liteversion') {
                $dataInsert['courses'] = 1;
            }

            $inser = DB::connection('mysql2')->table($table)->insert($dataInsert);

            if ($type == 'diploma') {
                $this->addDiplomaPlanAndFirstMonth($diploma_id, $user_id);
            }
            if ($type == 'trainingprogram') {
                $this->addTrainingProgramsPlanAndFirstMonth($training_program_id, $user_id);
            }
            if ($type == 'mba') {
                $this->addMbaPlans($user_id);
            }
            if ($type == 'newmba') {
                $this->addNewMbaPlans($user_id, $new_mba_category);
            }
            return response()->json(['success' => true, 'message' => '<div class="alert alert-success">Charge Added Success</div>'])->setCallback($request->input('callback'));
        }
    }

    public function doRemoveMember($memberID)
    {
        $result = DB::connection('mysql2')->select('select * from companies_requests where id = ?', [$memberID]);
        if (count($result)) {
            $date = date('Y-m-d H:i:s');
            $delete_data = ['deleted' => 1, 'deleted_date' => $date];
            DB::connection('mysql2')->table('companies_requests')->where('id', $memberID)->update($delete_data);
            log_user_action(Auth::user()->id, Auth::user()->username, 'delete', 'companies_requests', $memberID, json_encode($delete_data));
            $update_user_data = ['type_of_subscribe' => 'default'];
            DB::connection('mysql2')->table('users')->where('id', $result[0]->user_id)->update($update_user_data);
            //log_user_action(Auth::user()->id,Auth::user()->username,'update','users',$result[0]->user_id,json_encode($update_user_data));
            $update_mycourses_data = ['old' => 1];
            DB::connection('mysql2')->table('my_courses')->where('user_id', $result[0]->user_id)->update($update_mycourses_data);
//            $r_id =  DB::connection('mysql2')->table('my_courses')
//                ->where('user_id', '=', $result[0]->user_id)
//                ->first();
//            $r_id=$r_id->id;
            //log_user_action(Auth::user()->id,Auth::user()->username,'update','my_courses',$r_id,json_encode($update_mycourses_data));
            $errorMessage = self::$successRemoveMember;
            echo view('auth.message.success_message', compact('errorMessage'));
        }
    }

    public function doAddAdminCompany($request)
    {
        $params = $request->all();
        $company_id = isset($params['company_id']) ? $params['company_id'] : null;
        $email = isset($params['email']) ? $params['email'] : null;
        $type = isset($params['type']) ? $params['type'] : null;
        $diploma = isset($params['diploma']) ? $params['diploma'] : null;
        if (!in_array($type, ['diploma', 'mba', 'lifetime', 'liteversion'])) {
            echo '<div class="alert alert-danger">Please Select Type</div>';
            die();
        }
        if ($type == 'diploma') {
            $diplomas = Diplomas::pluck('id')->toArray();
            if (!in_array($diploma, $diplomas)) {
                echo '<div class="alert alert-danger">Please Select Diploma</div>';
                die();
            }
        }
        $result = DB::connection('mysql2')->select('select * from companies where id = ?', [$company_id]);

        if (count($result)) {
            $company = $result[0];
            $result = DB::connection('mysql2')->select('select * from users where Email = ?', [$email]);
            if (count($result)) {
                $user = $result[0];
                if ($user->company_id > 0) {
                    echo '<div class="alert alert-danger">Email Is Already Used For Company </div>';
                    die();
                }
                $user_id = $user->id;
                $PaymentExpirationDate = $company->expiredDate;
                $date = date('Y-m-d H:i:s');
                //$query="UPDATE users SET `company_id`='$company_id' , `type`='company',PaymentExpirationDate='$PaymentExpirationDate',LastPaymentDate='$date' WHERE id='$user_id'";
                $update_user_data = ['company_id' => $company_id, 'type' => 'company'];
                DB::connection('mysql2')->table('users')->where('id', $user_id)->update($update_user_data);
                //log_user_action(Auth::user()->id,Auth::user()->username,'update','users',$user_id,json_encode($update_user_data));
                $insert_admin_data = ['user_id' => $user_id, 'company_id' => $company_id];
                $a_id = DB::connection('mysql2')->table('companies_admins')->insertGetId($insert_admin_data);
                log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'companies_admins', $a_id, json_encode($insert_admin_data));
                $response = $this->checkCRM($email);
                if ($response != false && isset($response->type) && $response->type == 'Organization') {
                    $data = array('Email' => $email,
                        'expiry_date' => $user->PaymentExpirationDate,
                    );
                    $response = $this->update_crm_account_not_support($data);
                } else {
                    $data = array('Email' => $email,
                        'subscrip_type' => 'paid',
                        'last_payment_date' => $user->LastPaymentDate,
                    );
                    $response = $this->transfertocrm($data);
                    $response = $this->transfertocrm_ksa($data);
                }
                //charge
                if ($type == 'diploma') {
                    $period = 9;
                    $charge = new DiplomasCompaniesChargeTransaction();
                    $diploma_name = Diplomas::select('name')->where('id', $diploma)->first()->name;
                    $charge->diploma_id = $diploma;
                    $charge->diploma_name = $diploma_name;
                    $table = 'companies_charge_transaction';
                } elseif ($type == 'mba') {
                    $period = 12;
                    $charge = new MbaCompaniesChargeTransaction();
                    $table = 'mba_companies_charge_transaction';
                } elseif ($type == 'liteversion') {
                    $period = 12;
                    $charge = new LiteversionCompaniesChargeTransaction();
                    $table = 'lite_version_companies_charge_transaction';
                    $charge->courses = 1;
                } else {
                    $period = 12;
                    $charge = new CompaniesChargeTransaction();
                    $table = 'companies_charge_transaction';
                }
                $end_date = date('Y-m-d H:i:s', strtotime("$period months"));
                $charge->period = $period;
                $charge->start_date = $date;
                $charge->end_date = $end_date;
                $charge->company_id = $company->id;
                $charge->user_id = $user_id;
                if ($charge->save()) {
                    //new
                    if ($type == 'diploma') {
                        $this->addDiplomaPlanAndFirstMonth($diploma, $user_id);
                    }
                    log_user_action(Auth::user()->id, Auth::user()->username, 'insert', $table, $charge->id, json_encode($charge));
                }


                echo '<div class="alert alert-success">Done Add Admin To Company </div>';
            } else {
                echo '<div class="alert alert-danger">Please Chose User</div>';
                die();
            }
        } else {
            echo '<div class="alert alert-danger">Please Chose Company</div>';
            die();
        }
    }

    public function checkCRM($email)
    {
//        $curl = curl_init();
//        curl_setopt_array($curl, array(
//            CURLOPT_URL => config('globals.user_data_link'),
//            CURLOPT_RETURNTRANSFER => true,
//            CURLOPT_ENCODING => "",
//            CURLOPT_MAXREDIRS => 10,
//            CURLOPT_TIMEOUT => 30,
//            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//            CURLOPT_CUSTOMREQUEST => 'POST',
//            CURLOPT_POSTFIELDS => ['email' => $email],
//            CURLOPT_HTTPHEADER => array(),
//        ));
//        $response = curl_exec($curl);
//
//        $err = curl_error($curl);
//        error_log($response . '   error ' . $err, 3, "php.log");
//        curl_close($curl);
//        if ($err) {
//            return false;
//        } else {
//            $response = json_decode($response);
//            return $response;
//        }
    }

    public function update_crm_account_not_support($data)
    {
//        $url = config('globals.update_account_link');
//        $content = "";
//        foreach ($data as $key => $value) {
//            $content .= $key . '=' . $value . '&';
//        }
//        //echo $content;
//        $curl = curl_init($url);
//        curl_setopt($curl, CURLOPT_HEADER, false);
//        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//        curl_setopt($curl, CURLOPT_POST, true);
//        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
//        $json_response = curl_exec($curl);
//        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
//        curl_close($curl);
//        return $json_response;
    }

    public function doRemoveAdmin($company_id, $adminID)
    {
        $result = AcademyUsers::where('company_id', '=', $company_id)->get();
        if ($result->count()) {
            $result = AcademyUsers::where('id', '=', $adminID)->where('company_id', '=', $company_id)->get();
            if (count($result) > 0) {
                $r = DB::connection('mysql2')->table('companies_admins')->where('user_id', $adminID)->get();
                DB::connection('mysql2')->table('companies_admins')->where('user_id', $adminID)->delete();
                if (count($r)) {
                    log_user_action(Auth::user()->id, Auth::user()->username, 'delete', 'companies_admins', null, json_encode($r));
                }
                $update_user_data = ['company_id' => 0];
                DB::connection('mysql2')->table('users')->where('id', $adminID)->update($update_user_data);
                //log_user_action(Auth::user()->id,Auth::user()->username,'update','users',$adminID,json_encode($update_user_data));
                $errorMessage = self::$successRemoveMember;
                echo view('auth.message.success_message', compact('errorMessage'));
            }
        } else {
            $errorMessage = self::$errorRemoveAllAdmin;
            echo view('auth.message.error_message', compact('errorMessage'));
        }

    }

    public function doAddMemberCompany($request)
    {
        $params = $request->all();
        $company_id = isset($params['company_id']) ? $params['company_id'] : null;
        $email = isset($params['email']) ? $params['email'] : null;
        $type = isset($params['type']) ? $params['type'] : null;
        $diploma = isset($params['diploma']) ? $params['diploma'] : null;
        if (!in_array($type, ['diploma', 'mba', 'lifetime', 'liteversion'])) {
            echo '<div class="alert alert-danger">Please Select Type</div>';
            die();
        }
        if ($type == 'diploma') {
            $diplomas = Diplomas::pluck('id')->toArray();
            if (!in_array($diploma, $diplomas)) {
                echo '<div class="alert alert-danger">Please Select Diploma</div>';
                die();
            }
        }
        $result = DB::connection('mysql2')->select('select * from companies where id = ?', [$company_id]);
        if (count($result)) {
            $company = $result[0];
            $result = AcademyUsers::where('Email', '=', $email)->first();
            if ($result) {
                $user = $result;
                $user_id = $user->id;
                $date = date('Y-m-d H:i:s');
                $result = DB::connection('mysql2')->select('select * from companies_requests where email = ? and deleted = ?', [$email, 0]);
                if (count($result)) {
                    echo '<div class="alert alert-danger">Email Is Already Used For Company </div>';
                    die();
                }
                $update_user_data = ['type_of_subscribe' => 'percourse', 'type' => 'company'];
                DB::connection('mysql2')->table('users')->where('id', $user_id)->update($update_user_data);
                if ($company->type == 'demo') {
                    DB::connection('mysql2')->insert("insert into my_courses(company_id,user_id,course_id) select '$company_id','$user_id',trail_company_registered.type_id from trail_company_registered where type=?", ['courses']);
                }
                $insert_comp_data = ['user_id' => $user_id, 'company_id' => $company_id, 'email' => $email, 'confirm' => '1', 'createtime' => $date];
                $r_id = DB::connection('mysql2')->table('companies_requests')->insertGetId($insert_comp_data);
                log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'companies_requests', $r_id, json_encode($insert_comp_data));
                $response = $this->checkCRM($email);
                if ($response != false && isset($response->type) && $response->type == 'Organization') {
                    $data = array('Email' => $email,
                        'expiry_date' => $user->PaymentExpirationDate,
                    );
//                    $response = $this->update_crm_account_not_support($data);
                } else {
                    $data = array('Email' => $email,
                        'subscrip_type' => 'paid',
                        'last_payment_date' => $user->LastPaymentDate,
                    );
                    $response = $this->transfertocrm($data);
                    $response = $this->transfertocrm_ksa($data);
                }
                //charge
                if ($type == 'diploma') {
                    $period = 9;
                    $charge = new DiplomasCompaniesChargeTransaction();
                    $diploma_name = Diplomas::select('name')->where('id', $diploma)->first()->name;
                    $charge->diploma_id = $diploma;
                    $charge->diploma_name = $diploma_name;
                    $table = 'companies_charge_transaction';
                } elseif ($type == 'mba') {
                    $period = 12;
                    $charge = new MbaCompaniesChargeTransaction();
                    $table = 'mba_companies_charge_transaction';
                } elseif ($type == 'liteversion') {
                    $period = 12;
                    $charge = new LiteversionCompaniesChargeTransaction();
                    $table = 'lite_version_companies_charge_transaction';
                    $charge->courses = 1;
                } else {
                    $period = 12;
                    $charge = new CompaniesChargeTransaction();
                    $table = 'companies_charge_transaction';
                }
                $end_date = date('Y-m-d H:i:s', strtotime("$period months"));
                $charge->period = $period;
                $charge->start_date = $date;
                $charge->end_date = $end_date;
                $charge->company_id = $company->id;
                $charge->user_id = $user_id;
                if ($charge->save()) {
                    //new
                    if ($type == 'diploma') {
                        $this->addDiplomaPlanAndFirstMonth($diploma, $user_id);
                    }
                    log_user_action(Auth::user()->id, Auth::user()->username, 'insert', $table, $charge->id, json_encode($charge));
                }
                echo '<div class="alert alert-success">Done Add Member To Company </div>';
                die();
            } else {
                echo '<div class="alert alert-danger">Please Chose User</div>';
                die();
            }
        } else {
            echo '<div class="alert alert-danger">Please Chose Company</div>';
            die();
        }
    }

    public function addMbaPlans($user_id)
    {
        $courses = MbaCourses::get();
        $date = date('Y-m-d H:i:s');
        foreach ($courses as $course) {
            $module_id = $course->module_id;
            $related_course = $course->related_course;
            $plan = DB::connection('mysql2')->table('mba_courses_user_plan')->where('user_id', $user_id)->where('module_id', $module_id)->where('related_course', $related_course)->count();
            if (!$plan) {
                DB::connection('mysql2')->table('mba_courses_user_plan')->insert([
                    'user_id' => $user_id,
                    'module_id' => $module_id,
                    'related_course' => $related_course,
                    'image' => $course->image,
                    'name' => $course->name,
                    'sort' => $course->sort,
                    'createdtime' => $date,
                    'modifiedtime' => $date,
                ]);
            }
        }
    }

    public function addNewMbaPlans($user_id, $category_id)
    {
        $modules =NewMba::where('published', 'yes')->pluck('id')->toArray();
        $courses = NewMbaCourses::whereIn('module_id', $modules)->get();
        $mba_modules = NewMba::where('published', 'yes')->get();
        $date = date('Y-m-d H:i:s');
        foreach ($courses as $course) {
            $module_id = $course->module_id;
            $related_course = $course->related_course;
            $part = $course->part;
            $plan = DB::connection('mysql2')->table('new_mba_courses_user_plan')->where('user_id', $user_id)->where('module_id', $module_id)->where('related_course', $related_course)->count();
            if (!$plan) {
                DB::connection('mysql2')->table('new_mba_courses_user_plan')->insert([
                    'user_id' => $user_id,
                    'module_id' => $module_id,
                    'related_course' => $related_course,
                    'image' => $course->image,
                    'part'=>$part,
                    'name' => $course->name,
                    'sort' => $course->sort,
                    'createdtime' => $date,
                    'modifiedtime' => $date,
                ]);
            }
        }
        foreach ($mba_modules as $module) {

            $plan = DB::connection('mysql2')->table('new_mba_module_user_plan')->where('user_id', $user_id)->where('module_id', $module->id)->count();
            if (!$plan) {
                DB::connection('mysql2')->table('new_mba_module_user_plan')->insert([
                    'user_id' => $user_id,
                    'module_id' => $module->id,
                    'name' => $module->name,
                    'description' => $module->description,

                    'image' => $module->image,

                    'sort' => $module->sort,
                    'createdtime' => $date,
                    'modifiedtimme' => $date,
                ]);
            }
        }
    }

    public function addDiplomaPlanAndFirstMonth($diploma, $user_id, $charge_system = 'egy')
    {
        $field = ($charge_system == 'ksa') ? 'related_course_ksa' : 'related_course';
        $q = DiplomasCoursesUsersPlan::where('diploma_id', '=', $diploma)->where('user_id', '=', $user_id)->delete();
        $diploma_courses = DiplomaCourse::where('diploma_id', '=', $diploma)->get();
        if (count($diploma_courses)) {
            foreach ($diploma_courses as $course) {
                if ($course->diploma_id == $diploma) {
                    $new_plan = new DiplomasCoursesUsersPlan();
                    $new_plan->diploma_id = $course->diploma_id;
                    $new_plan->course_id = $course->$field;
                    $new_plan->user_id = $user_id;
                    $new_plan->sort = $course->sort;
                    $new_plan->added_by = Auth::user()->id;
                    $new_plan->save();
                }
            }
        }
        $min_plan_sort = DiplomasCoursesUsersPlan::where('diploma_id', '=', $diploma)->where('user_id', '=', $user_id)->min('sort');
        $plans_with_min_sort = DiplomasCoursesUsersPlan::where('diploma_id', '=', $diploma)->where('user_id', '=', $user_id)->where('sort', '=', $min_plan_sort)->get();
        if (count($plans_with_min_sort)) {
            foreach ($plans_with_min_sort as $plan_with_min_sort) {
                $diploma_user_course = new DiplomasUsersCourses();
                $diploma_user_course->diploma_id = $plan_with_min_sort->diploma_id;
                $diploma_user_course->course_id = $plan_with_min_sort->course_id;
                $diploma_user_course->user_id = $plan_with_min_sort->user_id;
                $diploma_user_course->exam = $plan_with_min_sort->exam;
                $diploma_user_course->sort = $plan_with_min_sort->sort;
                $diploma_user_course->added_by = Auth::user()->id;
                $diploma_user_course->save();
            }
        }
    }
    public function addMedicalDiplomaPlanAndFirstMonth($diploma, $user_id, $charge_system = 'egy')
    {
        $field = ($charge_system == 'ksa') ? 'related_course_ksa' : 'related_course';
        $q = MedicalDiplomasCoursesUsersPlan::where('diploma_id', '=', $diploma)->where('user_id', '=', $user_id)->delete();
        $diploma_courses = MedicalDiplomasCourses::where('diploma_id', '=', $diploma)->get();
        if (count($diploma_courses)) {
            foreach ($diploma_courses as $course) {
                if ($course->diploma_id == $diploma) {
                    $new_plan = new DiplomasCoursesUsersPlan();
                    $new_plan->diploma_id = $course->diploma_id;
                    $new_plan->course_id = $course->$field;
                    $new_plan->user_id = $user_id;
                    $new_plan->sort = $course->sort;
                    $new_plan->added_by = Auth::user()->id;
                    $new_plan->save();
                }
            }
        }
        $min_plan_sort = MedicalDiplomasCoursesUsersPlan::where('diploma_id', '=', $diploma)->where('user_id', '=', $user_id)->min('sort');
        $plans_with_min_sort = MedicalDiplomasCoursesUsersPlan::where('diploma_id', '=', $diploma)->where('user_id', '=', $user_id)->where('sort', '=', $min_plan_sort)->get();
        if (count($plans_with_min_sort)) {
            foreach ($plans_with_min_sort as $plan_with_min_sort) {
                $diploma_user_course = new MedicalDiplomasUsersCourses();
                $diploma_user_course->diploma_id = $plan_with_min_sort->diploma_id;
                $diploma_user_course->course_id = $plan_with_min_sort->course_id;
                $diploma_user_course->user_id = $plan_with_min_sort->user_id;
                $diploma_user_course->exam = $plan_with_min_sort->exam;
                $diploma_user_course->sort = $plan_with_min_sort->sort;
                $diploma_user_course->added_by = Auth::user()->id;
                $diploma_user_course->save();
            }
        }
    }

    public function addTrainingProgramsPlanAndFirstMonth($training_program, $user_id, $charge_system = 'egy')
    {
        $field = ($charge_system == 'ksa') ? 'related_course_ksa' : 'related_course';
        $q = TrainingProgramCoursesUsersPlan::where('diploma_id', '=', $training_program)->where('user_id', '=', $user_id)->delete();
        $diploma_courses = TrainingProgramCourse::where('diploma_id', '=', $training_program)->get();
        if (count($diploma_courses)) {
            foreach ($diploma_courses as $course) {
                if ($course->diploma_id == $training_program) {
                    $new_plan = new TrainingProgramCoursesUsersPlan();
                    $new_plan->diploma_id = $course->diploma_id;
                    $new_plan->course_id = $course->$field;
                    $new_plan->user_id = $user_id;
                    $new_plan->sort = $course->sort;
                    $new_plan->added_by = Auth::user()->id;
                    $new_plan->save();
                }
            }
        }
        $min_plan_sort = TrainingProgramCoursesUsersPlan::where('diploma_id', '=', $training_program)->where('user_id', '=', $user_id)->min('sort');
        $plans_with_min_sort = TrainingProgramCoursesUsersPlan::where('diploma_id', '=', $training_program)->where('user_id', '=', $user_id)->where('sort', '=', $min_plan_sort)->get();
        if (count($plans_with_min_sort)) {
            foreach ($plans_with_min_sort as $plan_with_min_sort) {
                $diploma_user_course = new TrainingProgramUsersCourses();
                $diploma_user_course->diploma_id = $plan_with_min_sort->diploma_id;
                $diploma_user_course->course_id = $plan_with_min_sort->course_id;
                $diploma_user_course->user_id = $plan_with_min_sort->user_id;
                $diploma_user_course->exam = $plan_with_min_sort->exam;
                $diploma_user_course->sort = $plan_with_min_sort->sort;
                $diploma_user_course->added_by = Auth::user()->id;
                $diploma_user_course->save();
            }
        }
    }

    public function doGetUserCertificates($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        if ($email) {
            $result = CoursesCurriculumCertificates::where('users.Email', '=', $email)
                ->join('users', 'users.id', '=', 'courses_curriculum_certificates.user_id')
                ->join('courses', 'courses.id', '=', 'courses_curriculum_certificates.course_id')
                ->select('courses_curriculum_certificates.*', 'courses.name AS course_name')
                ->get();

            //echo  $query;exit;
            $coursesCertificateHtml = "";
            foreach ($result as $coursesCertificate) {
                $coursesCertificateHtml .= '<tr>
                                               <td>' . $coursesCertificate->serial_number . '</td>
                                               <td>' . $coursesCertificate->course_name . '</td>
                                               <td>
                                               '.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'courses\',request_id:\'' . $coursesCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-type="text" data-pk="1" data-original-title="Enter username">' . $coursesCertificate->user_name . '</a>':$coursesCertificate->user_name).'</td>
                                               <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'courses\',request_id:\'' . $coursesCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-type="text" data-pk="1" data-original-title="Enter username">' . $coursesCertificate->user_name_en . '</a>':$coursesCertificate->user_name_en).'</td>
                                               <td>' . $coursesCertificate->createdtime . '</td>
                                            </tr>';
            }
            $result = DiplomaCertificates::where('users.Email', '=', $email)
                ->join('users', 'users.id', '=', 'diploma_certificates.user_id')
                ->join('diplomas', 'diplomas.id', '=', 'diploma_certificates.diploma_id')
                ->select('diploma_certificates.*', 'diplomas.name AS diploma_name')
                ->get();

            $diplomasCertificateHtml = "";
            foreach ($result as $diplomaCertificate) {
                //echo $diplomaCertificate->id;exit;
                $user_id=$diplomaCertificate->user_id;
                $diploma_id=$diplomaCertificate->diploma_id;
                $progress=\Illuminate\Support\Facades\DB::connection('mysql2')->select("SELECT (SUM(t)/COUNT('X'))*100 AS percentage FROM (SELECT course_id,MAX(right_answers/quetions_numbers) AS t FROM `users_curriculum_answers` wHERe user_id=? AND course_id IN(SELECT course_id FROM `diplomas_users_courses` WHERE user_id=? AND diploma_id=?) AND curriculum_type=? GROUP BY course_id) AS dd;",[$user_id,$user_id,$diploma_id,'exam'])[0]->percentage;
                $diplomasCertificateHtml .= '<tr>
                        <td>' . $diplomaCertificate->serial_number . '</td>
                        <td>' . $diplomaCertificate->diploma_name . '</td>
                        <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'diplomas\',request_id:\'' . $diplomaCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $diplomaCertificate->user_name . '</a>':$diplomaCertificate->user_name).'</td>
                        <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'diplomas\',request_id:\'' . $diplomaCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $diplomaCertificate->user_name_en . '</a>':$diplomaCertificate->user_name_en ).'</td>
                        <td>' . $progress. '</td>
                        <td>' . $diplomaCertificate->createdtime . '</td>
                        </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            $result=new InternationalDiplomaCertificates();
            $result->setConnection('mysql2');
            $result = $result->where('users.Email', '=', $email)
                ->join('users', 'users.id', '=', 'international_diploma_certificates.user_id')
                ->join('international_diplomas', 'international_diplomas.id', '=', 'international_diploma_certificates.diploma_id')
                ->select('international_diploma_certificates.*', 'international_diplomas.name AS diploma_name')
                ->get();

            $internationalDiplomasCertificateHtml = "";
            foreach ($result as $diplomaCertificate) {
                $user_id=$diplomaCertificate->user_id;
                $diploma_id=$diplomaCertificate->diploma_id;
                $progress=\Illuminate\Support\Facades\DB::connection('mysql2')->select("SELECT (SUM(t)/COUNT('X'))*100 AS percentage FROM (SELECT course_id,MAX(right_answers/quetions_numbers) AS t FROM `users_curriculum_answers` wHERe user_id=? AND course_id IN(SELECT course_id FROM `international_diplomas_users_courses` WHERE user_id=? AND diploma_id=?) AND curriculum_type=? GROUP BY course_id) AS dd;",[$user_id,$user_id,$diploma_id,'exam'])[0]->percentage;
                //echo $diplomaCertificate->id;exit;
                $internationalDiplomasCertificateHtml .= '<tr>
                        <td>' . $diplomaCertificate->serial_number . '</td>
                        <td>' . $diplomaCertificate->diploma_name . '</td>
                        <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'diplomas\',request_id:\'' . $diplomaCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $diplomaCertificate->user_name . '</a>':$diplomaCertificate->user_name).'</td>
                        <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'diplomas\',request_id:\'' . $diplomaCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $diplomaCertificate->user_name_en . '</a>':$diplomaCertificate->user_name_en).'</td>
                        <td>'.$progress.'</td>
                        <td>' . $diplomaCertificate->createdtime . '</td>
                        </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            $traningresult = TrainingProgramCertificate::where('users.Email', '=', $email)
                ->join('users', 'users.id', '=', 'training_program_certificates.user_id')
                ->join('training_program', 'training_program.id', '=', 'training_program_certificates.diploma_id')
                ->select('training_program_certificates.*', 'training_program.name AS training_name')
                ->get();

            $traningCertificateHtml = "";
            foreach ($traningresult as $traningCertificate) {
                $user_id=$traningCertificate->user_id;
                $diploma_id=$traningCertificate->diploma_id;
                $query="SELECT (SUM(t)/COUNT('X'))*100 AS percentage FROM (SELECT course_id,MAX(right_answers/quetions_numbers) AS t FROM `users_curriculum_answers` wHERe user_id=? AND course_id IN(SELECT course_id FROM `training_program_users_courses` WHERE user_id=? AND diploma_id=?) AND curriculum_type=? GROUP BY course_id) AS dd;";
                $progress=\Illuminate\Support\Facades\DB::connection('mysql2')->select($query,[$user_id,$user_id,$diploma_id,'exam'])[0]->percentage;
//                dd(vsprintf(str_replace('?', '%s', $query), [$user_id,$user_id,$diploma_id,'exam']));
                //echo $diplomaCertificate->id;exit;
                $traningCertificateHtml .= '<tr>
                        <td>' . $traningCertificate->serial_number . '</td>
                        <td>' . $traningCertificate->training_name . '</td>
                        <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'training_program\',request_id:\'' . $traningCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $traningCertificate->user_name . '</a>':$traningCertificate->user_name).'</td>
                        <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'training_program\',request_id:\'' . $traningCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $traningCertificate->user_name_en . '</a>':$traningCertificate->user_name_en).'</td>
                        <td>' . $progress . '</td>
                        <td>' . $traningCertificate->createdtime . '</td>
                        </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            $result = MbaCertificates::join('users', 'users.id', '=', 'mba_certificates.user_id')
                ->select('mba_certificates.*')
                ->where('users.Email', '=', $email)
                ->get();

            $mbaCertificateHtml = "";
            $statistics=modules_statistics('mba', $email);
            $totalMax=$statistics->max_progress+$statistics->max_project+$statistics->max_exam;
            $summaries = DB::connection('mysql2')->select("SELECT modules_users_summary.*,mba.name AS module_name FROM modules_users_summary INNER JOIN mba ON mba.id=modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)");
            $progress=0;
            if (count($summaries)) {
                foreach ($summaries as $allData) {
                    if ($allData->progress > 100) {
                        $allData->progress = 100;
                    }
                    $total = ((($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam * $statistics->max_exam)) / 100);
                    if ($totalMax == 50) {
                        $total = ($total / $totalMax) * 100;
                    }
                    $progress += $total;
                }
                if ($progress) {
                    $progress = ($progress / count($summaries));
                }
            }

            foreach ($result as $mbaCertificate) {
                //echo $diplomaCertificate->id;exit;

                $mbaCertificateHtml .= '<tr>
                                             <td>' . $mbaCertificate->serial_number . '</td>
                                             <td>Master Of Business Administration</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'mba\',request_id:\'' . $mbaCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $mbaCertificate->user_name . '</a>': $mbaCertificate->user_name ).'</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'mba\',request_id:\'' . $mbaCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $mbaCertificate->user_name_en . '</a>':$mbaCertificate->user_name_en).'</td>
                                             <td>' . $progress . '</td>
                                             <td>' . $mbaCertificate->createdtime . '</td>
                                             </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            $result = DB::connection('mysql2')->table('preparatory_mba_certificates')->whereNull('preparatory_mba_certificates.deleted_at')
                ->join('users', 'users.id', '=', 'preparatory_mba_certificates.user_id')
                ->select('preparatory_mba_certificates.*')
                ->where('users.Email', '=', $email)
                ->get();

            $preparatoryMbaCertificateHtml = "";
            foreach ($result as $preparatoryMbaCertificate) {
                //echo $diplomaCertificate->id;exit;
                $preparatoryMbaCertificateHtml .= '<tr>
                                             <td>' . $preparatoryMbaCertificate->serial_number . '</td>
                                             <td>Preparatory Master Of Business Administration</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'mba\',request_id:\'' . $mbaCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $mbaCertificate->user_name . '</a>': $mbaCertificate->user_name ).'</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'mba\',request_id:\'' . $mbaCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $mbaCertificate->user_name_en . '</a>':$mbaCertificate->user_name_en).'</td>
                                             <td>' . $preparatoryMbaCertificate->createdtime . '</td>
                                             </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            $result = DB::connection('mysql2')->table('new_mba_certificates')->whereNull('new_mba_certificates.deleted_at')
                ->leftJoin('new_mba_categories', 'new_mba_categories.id', '=', 'new_mba_certificates.category_id')
                ->join('users', 'users.id', '=', 'new_mba_certificates.user_id')
                ->select('new_mba_certificates.*','new_mba_categories.name as category_name')
                ->where('users.Email', '=', $email)
                ->get();

            $newmbaCertificateHtml = "";
            $statistics = modules_statistics('new_mba', $email);
            $totalMax=$statistics->max_progress+$statistics->max_project+$statistics->max_exam_part1+$statistics->max_exam_part2;
            $summaries = DB::connection('mysql2')->select("SELECT new_mba_modules_users_summary.*,new_mba.name AS module_name FROM new_mba_modules_users_summary INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND new_mba_modules_users_summary.module_id NOT IN(SELECT module_id FROM new_mba_categories_modules)");
            $progress=0;
            if (count($summaries)) {
                foreach ($summaries as $allData) {
                    $hasPartTwo = DB::connection('mysql2')->select("SELECT * FROM `new_mba_courses_user_plan` WHERE user_id='$allData->user_id' AND module_id='$allData->module_id' AND part='Part Two'");

                    if ($hasPartTwo) {
                        $total = ((($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam_part_1 * $statistics->max_exam_part1) + ($allData->exam_part_2 * $statistics->max_exam_part2)) / 100);
//                        if($allData->module_name=='ريادة الأعمال والقيادة')
//                        echo'('.'('.$allData->progress .'*'. $statistics->max_progress.')' .'+'. '('.$allData->project .'*'. $statistics->max_project.')' .'+'. '('.$allData->exam_part_1 .'*'.$statistics->max_exam_part1 .')'.'+'.'('.$allData->exam_part_2 .'*'.$statistics->max_exam_part2 .')'.')'.'/'. 100;;

                    } else {

                        $total = (($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam_part_1 * ($statistics->max_exam_part1 + $statistics->max_exam_part2))) / 100;

//                        echo'('.'('.$allData->progress .'*'. $statistics->max_progress.')' .'+'. '('.$allData->project .'*'. $statistics->max_project.')' .'+'. '('.$allData->exam_part_1 .'*'. '('.$statistics->max_exam_part1.'+'.$statistics->max_exam_part2.')'.')'.')'.'/'. 100;;
                    }
//                    die($total);
                    if ($totalMax == 50) {
                        $total = ($total / $totalMax) * 100;
                    }
                    $progress+=$total;
                }
                if ($progress) {
                    $progress = ($progress / count($summaries));
                }
            }
            foreach ($result as $newmbaCertificate) {
                //echo $diplomaCertificate->id;exit;
                $newmbaCertificateHtml .= '<tr>
                                             <td>' . $newmbaCertificate->serial_number . '</td>
                                             <td>' . $newmbaCertificate->category_name . '</td>
                                             <td>Master Of Business Administration</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'new_mba\',request_id:\'' . $newmbaCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $newmbaCertificate->user_name . '</a>':$newmbaCertificate->user_name).'</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'new_mba\',request_id:\'' . $newmbaCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $newmbaCertificate->user_name_en . '</a>':$newmbaCertificate->user_name_en).'</td>
                                             <td>' . $progress . '</td>
                                             <td>' . $newmbaCertificate->createdtime . '</td>
                                             </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            $result = DB::connection('mysql2')->table('dba_preliminary_certificates')->whereNull('dba_preliminary_certificates.deleted_at')
                ->join('users', 'users.id', '=', 'dba_preliminary_certificates.user_id')
                ->select('dba_preliminary_certificates.*')
                ->where('users.Email', '=', $email)
                ->get();

            $dbaPreliminaryCertificateHtml = "";
            foreach ($result as $dbaPreliminaryCertificate) {
                //echo $diplomaCertificate->id;exit;
                $dbaPreliminaryCertificateHtml .= '<tr>
                                             <td>' . $dbaPreliminaryCertificate->serial_number . '</td>
                                             <td>The Doctor of Business Administration</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'dba_preliminary\',request_id:\'' . $dbaPreliminaryCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $dbaPreliminaryCertificate->user_name . '</a>':$dbaPreliminaryCertificate->user_name).'</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'dba_preliminary\',request_id:\'' . $dbaPreliminaryCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $dbaPreliminaryCertificate->user_name_en . '</a>':$dbaPreliminaryCertificate->user_name_en).'</td>
                                             <td>' . $dbaPreliminaryCertificate->createdtime . '</td>
                                             </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            $result = DB::connection('mysql2')->table('dba_certificates')->whereNull('dba_certificates.deleted_at')
                ->join('users', 'users.id', '=', 'dba_certificates.user_id')
                ->select('dba_certificates.*')
                ->where('users.Email', '=', $email)
                ->get();

            $dbaCertificateHtml = "";
            foreach ($result as $dbaCertificate) {
                //echo $diplomaCertificate->id;exit;
                $dbaCertificateHtml .= '<tr>
                                             <td>' . $dbaCertificate->serial_number . '</td>
                                             <td>The Doctor of Business Administration</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'dba\',request_id:\'' . $dbaCertificate->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $dbaCertificate->user_name . '</a>':$dbaCertificate->user_name).'</td>
                                             <td>'.(PerUser('dashboard_change_certificate_name')?'<a href="javascript:;" class="username" data-params="{request:\'dba\',request_id:\'' . $dbaCertificate->id . '\',request_lang:\'en\'}" data-url="' . URL('admin/saveCertificateName') . '" data-source="saveCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $dbaCertificate->user_name_en . '</a>':$dbaCertificate->user_name_en).'</td>
                                             <td>' . $dbaCertificate->createdtime . '</td>
                                             </tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            echo '<div><!-- TAB NAVIGATION --> 
<!-- TAB CONTENT -->
<div class="certificates-tabs-section show-front courses-certificates-tab-sec" id="courses-certificate">
    <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>Course Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Created Time</th>
                                                </tr>
                                                ' . $coursesCertificateHtml . '
                                            </tbody>
                                        </table>
  </div>
    <div class="certificates-tabs-section diplomas-certificates-tab-sec" id="diplomas-certificates">
    <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>Course Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Percentage</th>
                                                    <th>Created Time</th>
                                                </tr>
                                                ' . $diplomasCertificateHtml . '
                                            </tbody>
                                        </table>
  </div>
  <div class="certificates-tabs-section international-diplomas-certificates-tab-sec" id="international-diplomas-certificates">
    <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>Course Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Progress</th>
                                                    <th>Created Time</th>
                                                </tr>
                                                ' . $internationalDiplomasCertificateHtml . '
                                            </tbody>
                                        </table>
  </div>

     <div class="certificates-tabs-section training-certificates-tab-sec" id="training-certificate">
   <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>Training Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Progress</th>
                                                    <th> Created Time </th>
                                                </tr>  
                                                ' . $traningCertificateHtml . ' 
                                                
                                            </tbody>
                                        </table>
    </div>
</div> 


 <div class="certificates-tabs-section mba-certificates-tab-sec" id="mba-certificate">
   <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>MBA Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Progress</th>
                                                    <th>Created Time</th>
                                                </tr>  
                                                ' . $mbaCertificateHtml . ' 
                                                
                                            </tbody>
                                        </table>
    </div>
    <div class="certificates-tabs-section preparatory-mba-certificates-tab-sec" id="preparatory-mba-certificate">
   <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>MBA Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Created Time</th>
                                                </tr>  
                                                ' . $preparatoryMbaCertificateHtml . ' 
                                                
                                            </tbody>
                                        </table>
    </div>
    <div class="certificates-tabs-section new-mba-certificates-tab-sec" id="new-mba-certificate">
   <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>Category</th>
                                                    <th>MBA Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Progress</th>
                                                    <th>Created Time</th>
                                                </tr>  
                                                ' . $newmbaCertificateHtml . ' 
                                                
                                            </tbody>
                                        </table>
    </div>
     <div class="certificates-tabs-section dba-preliminary-certificates-tab-sec" id="dba-preliminary-certificate">
   <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>DBA Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Created Time</th>
                                                </tr>  
                                                ' . $dbaPreliminaryCertificateHtml . ' 
                                                
                                            </tbody>
                                        </table>
    </div>
    <div class="certificates-tabs-section dba-certificates-tab-sec" id="dba-certificate">
   <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>DBA Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>Created Time</th>
                                                </tr>  
                                                ' . $dbaCertificateHtml . ' 
                                                
                                            </tbody>
                                        </table>
    </div>
</div>';
        }
    }
    public function doGetYottaUserCertificates($request)
    {
        $params=$request->all();
        $email = isset($params['email'])?$params['email']:null;
        if ($email) {
            $result = DB::connection('mysql3')->table('courses_curriculum_certificates')
                ->join('users', 'users.id', '=', 'courses_curriculum_certificates.user_id')
                ->join('courses', 'courses.id', '=', 'courses_curriculum_certificates.course_id')
                ->join('medical_diplomas_courses_user_plan','courses.id','=','medical_diplomas_courses_user_plan.course_id')
                ->select('courses_curriculum_certificates.*', 'courses.name AS course_name')
                ->where('users.Email','=',$email)
                //->where('medical_diplomas_courses_user_plan.diploma_id','2')
                ->groupby('courses_curriculum_certificates.course_id')
                ->get();

            //echo  $query;exit;
            $coursesCertificateHtml = "";
            foreach($result as $coursesCertificate){
                $coursesCertificateHtml .= '<tr><td>' . $coursesCertificate->serial_number . '</td><td>' . $coursesCertificate->course_name . '</td><td><a href="javascript:;" class="username" data-params="{request:\'courses\',request_id:\'' . $coursesCertificate->id . '\',request_lang:\'ar\'}" data-url="'.URL('admin/saveYottaCertificateName').'" data-type="text" data-pk="1" data-original-title="Enter username">' . $coursesCertificate->user_name . '</a></td><td><a href="javascript:;" class="username" data-params="{request:\'courses\',request_id:\'' . $coursesCertificate->id . '\',request_lang:\'en\'}" data-url="'.URL('admin/saveYottaCertificateName').'" data-type="text" data-pk="1" data-original-title="Enter username">' . $coursesCertificate->user_name_en . '</a></td><td>'.$coursesCertificate->createdtime.'</td></tr>';
            }
            $result = DB::connection('mysql3')->table('diploma_certificates')
                ->join('users', 'users.id', '=', 'diploma_certificates.user_id')
                ->join('medical_diplomas', 'medical_diplomas.id', '=', 'diploma_certificates.diploma_id')
                ->select('diploma_certificates.*', 'medical_diplomas.name AS diploma_name')
                ->where('users.Email','=',$email)
                //->where('medical_diplomas.id','2')
                ->get();

            $data = $this->getyottaclientdata($email);
            // $eecoded_id=$this->registry->encryption->encode($id);
            if (isset($data)) {
                $user_id=$data->id;
            }
            $diplomasCertificateHtml = "";
            $diplomasCertificateHtml='<div class="col-lg-12" style="text-align: center; padding:10px;">
    <button class="btn btn-success input-circle" data-user-id="'.$user_id.'" data-diploma-id="2" id="generateyottaDiplomaCertificate" type="submit"> Generate Certificate</button>
</div>
<div id="certificateHtml" class="col-lg-12"></div>';
            foreach($result as $diplomaCertificate){
                //echo $diplomaCertificate->id;exit;
                $diplomasCertificateHtml .= '<tr><td>' . $diplomaCertificate->serial_number . '</td><td>' . $diplomaCertificate->diploma_name . '</td><td><a href="javascript:;" class="username" data-params="{request:\'diplomas\',request_id:\'' . $diplomaCertificate->id . '\',request_lang:\'ar\'}" data-url="'.URL('admin/saveYottaCertificateName').'" data-source="saveYottaCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $diplomaCertificate->user_name . '</a></td><td><a href="javascript:;" class="username" data-params="{request:\'diplomas\',request_id:\'' . $diplomaCertificate->id . '\',request_lang:\'en\'}" data-url="'.URL('admin/saveYottaCertificateName').'" data-source="saveYottaCertificateName" data-type="text" data-pk="1" data-original-title="Enter username">' . $diplomaCertificate->user_name_en . '</a></td><td>'.$diplomaCertificate->createdtime.'</td></tr>';
                // echo $diplomasCertificateHtml ; exit;
            }
            echo '<div><!-- TAB NAVIGATION --> 
<!-- TAB CONTENT -->
<div class="certificates-tabs-section show-front courses-certificates-tab-sec" id="courses-certificate">
    <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>Course Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>created time</th>
                                                </tr>
                                                ' . $coursesCertificateHtml . '
                                            </tbody>
                                        </table>
  </div>
     <div class="certificates-tabs-section diplomas-certificates-tab-sec" id="diplomas-certificate">

   <table id="user" class="table table-bordered table-striped">
                                            <tbody>
                                                <tr>
                                                    <th>Serial Number</th>
                                                    <th>Diploma Name</th>
                                                    <th>User Name Arabic</th>
                                                    <th>User Name English</th>
                                                    <th>created time</th>
                                                </tr>  
                                                ' . $diplomasCertificateHtml . ' 
                                                
                                            </tbody>
                                        </table>
    </div>
</div>';
        }
    }


    public function doGenerateYottaDiplomaCertificate($request){
        $params=$request->all();
        $diploma_id = 2;
        $user_id = isset($params['user_id'])?$params['user_id']:'';
        $result=DB::connection('mysql3')->select("select users.FullName AS user_name,users.name_en,medical_diplomas.code,medical_diplomas_charge_transaction.diploma_id,medical_diplomas_charge_transaction.user_id from medical_diplomas_charge_transaction INNER JOIN users ON users.id=medical_diplomas_charge_transaction.user_id INNER JOIN medical_diplomas ON medical_diplomas.id=medical_diplomas_charge_transaction.diploma_id where diploma_id=$diploma_id and user_id=$user_id");
        if(count($result)){
            $data=$result[0];
            $user_name=$data->user_name;
            $user_name_en=$data->name_en;
            $code=$data->code;
            $resultCourse=DB::connection('mysql3')->select("select course_id FROM medical_diplomas_courses_user_plan WHERE diploma_id ='$diploma_id' AND user_id='$user_id'");
            $makeCertificate=true;
            $user=AcademyUsers::select('country')->where('id','=',$user_id)->first();
            foreach ($resultCourse as $courses){
                $course_id=$courses->course_id;
                if($course_id){
                    $resultCertificate=DB::connection('mysql3')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='$course_id' AND user_id='$user_id'");
                    if(count($resultCertificate)==0){
                        $makeCertificate=false;
                        break;
                    }
                }
            }
            if($makeCertificate){
                $diplomaCertificateResult=DB::connection('mysql3')->select("SELECT * FROM diploma_certificates WHERE diploma_id='$diploma_id' AND user_id='$user_id'");
                if(count($diplomaCertificateResult)==0){
                    $session_id=0;
                    $serial_number=$this->generateYottaDiplomaSerialNumber($diploma_id);
                    $date=date('Y-m-d H:i:s');
                    DB::connection('mysql3')->table('diploma_certificates')->insert(
                        ['serial_number' => $serial_number, 'diploma_id' => $diploma_id, 'user_id' => $user_id,'user_name'=>$user_name,'user_name_en'=>$user_name_en,'session_user_id'=>$session_id,'createdtime'=>$date]
                    );
                    $errorMessage= 'Certificate generated successfully';
                    echo view('auth.message.success_message',compact('errorMessage'));
                    return;
                }
                else{
                    $errorMessage= 'Certificate has already generated';
                    echo view('auth.message.error_message',compact('errorMessage'));
                    return;
                }
//                echo'<br><br>======================================================================<br><br>';
            }
            else{
                $errorMessage= 'Faild to generate certificate';
                echo view('auth.message.error_message',compact('errorMessage'));
                return;
            }

        }
    }

    public function generateYottaDiplomaSerialNumber($diploma_id){
        MedicalDiplomas::where('id', $diploma_id)
            ->update(['certificate_increment'=> DB::raw('certificate_increment+1')]);
        $data=MedicalDiplomas::where('id','=',$diploma_id)->first();
        if($data){
            switch(strlen($data->certificate_increment)){
                case 1:
                    return strtoupper($data->code).'000'.$data->certificate_increment;
                    break;
                case 2:
                    return strtoupper($data->code).'00'.$data->certificate_increment;
                    break;
                case 3:
                    return strtoupper($data->code).'0'.$data->certificate_increment;
                    break;
                case 4:
                    return strtoupper($data->code).$data->certificate_increment;
                    break;
            }
        }
    }

    public function doGetUsersSuspendAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = UsersSuspend::select('users_suspend.type as status', 'users_suspend.createtime as status_date', "users.FullName as user_name")
                ->join('users', 'users.id', '=', 'users_suspend.user_id')
                ->where('users_suspend.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {

                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->status . '</td>
                            <td>' . $allData->status_date . '</td>'
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="4">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="4">لا توجد بيانات متاحة في الجدول</td></tr>';
        }

        echo $html;
    }

    public function doGetUsersConsultantSuspendAjax($table, $request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = DB::connection('mysql2')->table($table)->select($table . '.suspend as status', $table . '.createtime as status_date', "users.FullName as user_name")
                ->join('users', 'users.id', '=', $table . '.user_id')
                ->where($table . '.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {

                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->status . '</td>
                            <td>' . $allData->status_date . '</td>'
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="4">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="4">لا توجد بيانات متاحة في الجدول</td></tr>';
        }

        echo $html;
    }

    public function doeditchargecategory($request)
    {
        $params = $request->all();
        $category_id = isset($params['value']) ? $params['value'] : null;
        $charge_id = isset($params['charge_id']) ? $params['charge_id'] : null;
#//        $condition = "WHERE id='$request_id'";
        // print_r ($newName.$request.$request_lang.$condition);exit;
        if ($category_id && $request && $charge_id) {
            $table = 'new_mba_charge_transaction';

            $setData = ["category_id" => $category_id];
            DB::connection('mysql2')->table($table)->where('id', $charge_id)->update($setData);
            log_user_action(Auth::user()->id, Auth::user()->username, 'update', $table, $charge_id, json_encode($setData));

        }

    }

    public function doSaveCertificateName($request)
    {
        $params = $request->all();
        $newName = isset($params['value']) ? $params['value'] : null;
        $request = isset($params['request']) ? $params['request'] : null;
        $request_id = isset($params['request_id']) ? $params['request_id'] : null;
        $request_lang = isset($params['request_lang']) ? $params['request_lang'] : null;
//        $condition = "WHERE id='$request_id'";
        // print_r ($newName.$request.$request_lang.$condition);exit;
        if ($newName && $request && $request_id && $request_lang && in_array($request, ['courses', 'diplomas', 'mba', 'new_mba', 'training_program','dba','dba_preliminary']) && in_array($request_lang, ['ar', 'en'])) {
            switch ($request) {
                case 'courses':
                    $table = 'courses_curriculum_certificates';
                    break;
                case 'diplomas':
                    $table = 'diploma_certificates';
                    break;
                case 'mba':
                    $table = 'mba_certificates';
                    break;

                case 'training_program':
                    $table = 'training_program_certificates';
                    break;
                case 'new_mba':
                    $table = 'new_mba_certificates';
                    break;
                case 'dba_preliminary':
                    $table = 'dba_preliminary_certificates';
                    break;
                case 'dba':
                    $table = 'dba_certificates';
                    break;
            }
            $setData = ($request_lang == 'ar') ? ["user_name" => $newName] : ["user_name_en" => $newName];
            DB::connection('mysql2')->table($table)->where('id', $request_id)->update($setData);
//            dd(getEloquentSqlWithBindings(DB::connection('mysql2')->table($table)->where('id', $request_id)),$setData);
            log_user_action(Auth::user()->id, Auth::user()->username, 'update', $table, $request_id, json_encode($setData));

        }

    }
    public function doSaveYottaCertificateName($request)
    {
        $params=$request->all();
        $newName = isset($params['value'])?$params['value']:null;
        $request = isset($params['request'])?$params['request']:null;
        $request_id = isset($params['request_id'])?$params['request_id']:null;
        $request_lang = isset($params['request_lang'])?$params['request_lang']:null;
//        $condition = "WHERE id='$request_id'";
        // print_r ($newName.$request.$request_lang.$condition);exit;
        if ($newName && $request && $request_id && $request_lang && in_array($request, ['courses', 'diplomas']) && in_array($request_lang, ['ar', 'en'])) {
            $table = ($request == 'courses') ? "courses_curriculum_certificates" : "diploma_certificates";
            $setData = ($request_lang == 'ar') ? ["user_name"=>$newName] : ["user_name_en"=>$newName];
            DB::connection('mysql3')->table($table)->where('id', $request_id)->update($setData);
            log_user_action(Auth::user()->id,Auth::user()->username,'update',$table,$request_id,json_encode($setData));

        }

    }

    public function calcMbaHours($module_id,$user_id){
        $times=CoursesCurriculum::whereRaw("course_id IN(SELECT mba_courses_user_plan.related_course FROM `mba_courses_user_plan` WHERE module_id='$module_id' AND user_id='$user_id')")->where('type','default')->where('published','yes')->pluck('duration')->toArray();
        $hours_numbers = calculateSecond($times);
        return $hours_numbers;
    }
    public function doGetMbaSummaryAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("SELECT modules_users_summary.*,mba.name AS module_name FROM modules_users_summary INNER JOIN mba ON mba.id=modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)");
            $x = 1;
            //echo$query;
            $html = '';
            $statistics = modules_statistics('mba', $email);
            $totalMax=$statistics->max_progress+$statistics->max_project+$statistics->max_exam;

            if (count($result)) {
                foreach ($result as $allData) {

                    if ($allData->progress > 100) {
                        $allData->progress = 100;
                    }
                    $total=((($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam * $statistics->max_exam)) / 100);
                    if($totalMax==50){
                        $total=($total/$totalMax)*100;
                    }
                    $progressFalse=true;
                    $projectFalse=true;
                    $examFalse=true;
                    $totalFalse=true;
                    if($statistics->type=='old'){
                        if($total>=59){
                            $progressFalse=false;
                            $projectFalse=false;
                            $examFalse=false;
                            $totalFalse=false;
                        }
                    }else{
                        $progressFalse=$allData->progress<$statistics->pass_progress;
                        $projectFalse=$allData->project<$statistics->pass_project;
                        $examFalse=$allData->exam<$statistics->pass_exam;
                        $totalFalse=$allData->progress<$statistics->pass_progress||$allData->project<$statistics->pass_project||$allData->exam<$statistics->pass_exam;
                    }
                    $project=getLastProjectData($allData,'modules_users_projects');
                    $html .= '<tr>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $this->calcMbaHours($allData->module_id,$allData->user_id) . '</td>
                            <td><span class="label label-'.($progressFalse?'danger':'success').'">' . $allData->progress . '</span></td>
                            <td><span class="label label-'.($projectFalse?'danger':'success').'">' . $allData->project . '</span></td>
                            <td>' . ($project?$project->createdtime:'') . '</td>';
                    if(PerUser('mba_report_download_project_correction')){
                        $html.='<td>'.($project&&$project->correction?'<a href="'.e3mURL('assets/images/'.$project->correction).'" target="_blank" class="btn btn-success">Download</a>':'No correction uploaded').'</td>';
                    }
                    $html .= '<td><span class="label label-'.($examFalse?'danger':'success').'">' . $allData->exam . '</span></td>
                            
                            <td><span class="label label-'.($totalFalse?'danger':'success').'">' .  $total. '</span></td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }

    public function doGetDbaSummaryAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("SELECT dba_users_doctor_files.* FROM dba_users_doctor_files WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)");
            $x = 1;
            //echo$query;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {

                    if (is_null($allData->result)) {
                        $allData->result= 'no exam yet';
                    }

                    $html .= '<tr>
                            <td>الدكتوراة المهنية لإدارة الأعمال الأونلاين – DBA</td>
                            <td>' . $allData->result . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }

    public function calcNewMbaHours($module_id,$user_id){
        $times=CoursesCurriculum::whereRaw("course_id IN(SELECT new_mba_courses_user_plan.related_course FROM `new_mba_courses_user_plan` WHERE module_id='$module_id' AND user_id='$user_id')")->where('type','default')->where('published','yes')->pluck('duration')->toArray();
        $hours_numbers = calculateSecond($times);
        return $hours_numbers;
    }
    public function doGetNewMbaSummaryAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("SELECT new_mba_modules_users_summary.*,new_mba.name AS module_name FROM new_mba_modules_users_summary INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND new_mba_modules_users_summary.module_id NOT IN(SELECT module_id FROM new_mba_categories_modules)");
            $x = 1;
            //echo$query;
            $html = '';
            $statistics = modules_statistics('new_mba', $email);
            $totalMax=$statistics->max_progress+$statistics->max_project+$statistics->max_exam_part1+$statistics->max_exam_part2;
            if (count($result)) {
                foreach ($result as $allData) {
                    $hasPartTwo=DB::connection('mysql2')->select("SELECT * FROM `new_mba_courses_user_plan` WHERE user_id='$allData->user_id' AND module_id='$allData->module_id' AND part='Part Two'");

                    if($hasPartTwo){
                        $total=((($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam_part_1 * $statistics->max_exam_part1) + ($allData->exam_part_2 * $statistics->max_exam_part2)) / 100);
//                        if($allData->module_name=='ريادة الأعمال والقيادة')
//                        echo'('.'('.$allData->progress .'*'. $statistics->max_progress.')' .'+'. '('.$allData->project .'*'. $statistics->max_project.')' .'+'. '('.$allData->exam_part_1 .'*'.$statistics->max_exam_part1 .')'.'+'.'('.$allData->exam_part_2 .'*'.$statistics->max_exam_part2 .')'.')'.'/'. 100;;

                    }else{

                        $total=(($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam_part_1 * ($statistics->max_exam_part1+$statistics->max_exam_part2))) / 100;

//                        echo'('.'('.$allData->progress .'*'. $statistics->max_progress.')' .'+'. '('.$allData->project .'*'. $statistics->max_project.')' .'+'. '('.$allData->exam_part_1 .'*'. '('.$statistics->max_exam_part1.'+'.$statistics->max_exam_part2.')'.')'.')'.'/'. 100;;
                    }
//                    die($total);
                    if($totalMax==50){
                        $total=($total/$totalMax)*100;
                    }

                    $progressFalse=true;
                    $projectFalse=true;
                    $examP1False=true;
                    $examP2False=true;
                    $totalFalse=true;
                    if($statistics->type=='old'){
                        if($total>=59){
                            $progressFalse=false;
                            $projectFalse=false;
                            $examP1False=false;
                            $examP2False=false;
                            $totalFalse=false;
                        }
                    }else{
                        $progressFalse=$allData->progress<$statistics->pass_progress;
                        $projectFalse=$allData->project<$statistics->pass_project;
                        $examP1False=$allData->exam_part_1<$statistics->pass_exam_part_1;
                        $examP2False=$allData->exam_part_2<$statistics->pass_exam_part_2;
                        $totalFalse=$allData->progress<$statistics->pass_progress||$allData->project<$statistics->pass_project||$allData->exam_part_1<$statistics->pass_exam_part_1||$allData->exam_part_2<$statistics->pass_exam_part_2;
                    }
                    $project=getLastProjectData($allData);
                    $html .= '<tr>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $this->calcNewMbaHours($allData->module_id,$allData->user_id) . '</td>
                            <td><span class="label label-'.($progressFalse?'danger':'success').'">' . $allData->progress . '</span></td>
                            <td><span class="label label-'.($projectFalse?'danger':'success').'">' . $allData->project . '</span></td>
                            <td>' . ($project?$project->createdtime:'') . '</td>';
                    if(PerUser('new_mba_report_download_project_correction')){
                        $html.='<td>'.($project&&$project->correction?'<a href="'.e3mURL('assets/images/'.$project->correction).'" target="_blank" class="btn btn-success">Download</a>':'No correction uploaded').'</td>';
                    }
                    $html .= '
                            <td><span class="label label-'.($examP1False?'danger':'success').'">' . $allData->exam_part_1 . '</span></td>
                            <td><span class="label label-'.($examP2False?'danger':'success').'">' . $allData->exam_part_2 . '</span></td>
                            <td><span class="label label-'.($totalFalse?'danger':'success').'">' .$total . '</span></td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }
    public function doGetNewMbaCategorySummaryAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $category_result = DB::connection('mysql2')->select("SELECT category_id FROM new_mba_charge_transaction WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) ORDER BY id DESC limit 1");
            $category_id = $category_result[0]->category_id;
            $query="SELECT (SELECT COUNT('X') FROM `new_mba_exams` WHERE module_id=new_mba_modules_users_summary.module_id AND type='Part Two' AND(SELECT COUNT('X') FROM `new_mba_modules_questions` WHERE exam_id=new_mba_exams.id)>0 AND  (SELECT COUNT('X') FROM `new_mba_courses_user_plan` WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND module_id=new_mba_modules_users_summary.module_id AND part='Part Two')>0) AS has_exam_part_2,new_mba_modules_users_summary.*,new_mba.name AS module_name,new_mba.id AS module_id FROM new_mba_modules_users_summary INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND new_mba_modules_users_summary.module_id IN (SELECT module_id FROM new_mba_categories_modules where new_mba_categories_modules.category_id IN(SELECT DISTINCT  category_id FROM new_mba_charge_transaction WHERE user_id=((SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)))) ";
            if($email=='tahm231@hotmail.com'){
                $category_id=1;
                $query="SELECT (SELECT COUNT('X') FROM `new_mba_exams` WHERE module_id=new_mba_modules_users_summary.module_id AND type='Part Two' AND(SELECT COUNT('X') FROM `new_mba_modules_questions` WHERE exam_id=new_mba_exams.id)>0 AND  (SELECT COUNT('X') FROM `new_mba_courses_user_plan` WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND module_id=new_mba_modules_users_summary.module_id AND part='Part Two')>0) AS has_exam_part_2,new_mba_modules_users_summary.*,new_mba.name AS module_name,new_mba.id AS module_id FROM new_mba_modules_users_summary INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND new_mba_modules_users_summary.module_id IN (SELECT module_id FROM new_mba_categories_modules where new_mba_categories_modules.category_id IN($category_id)) ";
            }
            if($email=='fhessahsaedan@gmail.com'){
                $category_id=4;
                $query="SELECT (SELECT COUNT('X') FROM `new_mba_exams` WHERE module_id=new_mba_modules_users_summary.module_id AND type='Part Two' AND(SELECT COUNT('X') FROM `new_mba_modules_questions` WHERE exam_id=new_mba_exams.id)>0 AND  (SELECT COUNT('X') FROM `new_mba_courses_user_plan` WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND module_id=new_mba_modules_users_summary.module_id AND part='Part Two')>0) AS has_exam_part_2,new_mba_modules_users_summary.*,new_mba.name AS module_name,new_mba.id AS module_id FROM new_mba_modules_users_summary INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND new_mba_modules_users_summary.module_id IN (SELECT module_id FROM new_mba_categories_modules where new_mba_categories_modules.category_id IN($category_id)) ";
            }
            if($email=='Ss_mix@hotmail.com'){
                $category_id='1,2';
                $query="SELECT (SELECT COUNT('X') FROM `new_mba_exams` WHERE module_id=new_mba_modules_users_summary.module_id AND type='Part Two' AND(SELECT COUNT('X') FROM `new_mba_modules_questions` WHERE exam_id=new_mba_exams.id)>0 AND  (SELECT COUNT('X') FROM `new_mba_courses_user_plan` WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND module_id=new_mba_modules_users_summary.module_id AND part='Part Two')>0) AS has_exam_part_2,new_mba_modules_users_summary.*,new_mba.name AS module_name,new_mba.id AS module_id FROM new_mba_modules_users_summary INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND new_mba_modules_users_summary.module_id IN (SELECT module_id FROM new_mba_categories_modules where new_mba_categories_modules.category_id IN($category_id)) ";
            }
            //echo $query;
            $result = DB::connection('mysql2')->select($query);
            $x = 1;
            //echo$query;
            $html = '';
            $statistics = modules_statistics('new_mba', $email);
            $totalMax=$statistics->max_progress+$statistics->max_project+$statistics->max_exam_part1+$statistics->max_exam_part2;
            if (count($result)) {
                foreach ($result as $allData) {
                    if($allData->has_exam_part_2==0){
                        $total=(($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam_part_1 * ($statistics->max_exam_part1+$statistics->max_exam_part2))) / 100;
                    }else{
                        $total=((($allData->progress * $statistics->max_progress) + ($allData->project * $statistics->max_project) + ($allData->exam_part_1 * $statistics->max_exam_part1) + ($allData->exam_part_2 * $statistics->max_exam_part2)) / 100);
                    }
                    if($totalMax==50){
                        $total=($total/$totalMax)*100;
                    }
                    $progressFalse=true;
                    $projectFalse=true;
                    $examP1False=true;
                    $examP2False=true;
                    $totalFalse=true;
                    if($statistics->type=='old'){
                        if($total>=59){
                            $progressFalse=false;
                            $projectFalse=false;
                            $examP1False=false;
                            $examP2False=false;
                            $totalFalse=false;
                        }
                    }else{
                        $progressFalse=$allData->progress<$statistics->pass_progress;
                        $projectFalse=$allData->project<$statistics->pass_project;
                        $examP1False=$allData->exam_part_1<$statistics->pass_exam_part_1;
                        $examP2False=$allData->exam_part_2<$statistics->pass_exam_part_2;
                        $totalFalse=$allData->progress<$statistics->pass_progress||$allData->project<$statistics->pass_project||$allData->exam_part_1<$statistics->pass_exam_part_1||$allData->exam_part_2<$statistics->pass_exam_part_2;
                    }
                    $project=getLastProjectData($allData);
                    $html .= '<tr>
                            <td>' . $allData->module_name .'</td>
                            <td>' . $this->calcNewMbaHours($allData->module_id,$allData->user_id) . '</td>
                            <td><span class="label label-'.($progressFalse?'danger':'success').'">' . $allData->progress . '</span></td>
                            <td><span class="label label-'.($projectFalse?'danger':'success').'">' . $allData->project . '</span></td>
                             <td>' . ($project?$project->createdtime:'') . '</td>';
                    if(PerUser('new_mba_report_download_project_correction')){
                        $html.='<td>'.($project&&$project->correction?'<a href="'.e3mURL('assets/images/'.$project->correction).'" target="_blank" class="btn btn-success">Download</a>':'No correction uploaded').'</td>';
                    }
                    $html .= '
                            <td><span class="label label-'.($examP1False?'danger':'success').'">' . $allData->exam_part_1 . '</span></td>
                            <td><span class="label label-'.($examP2False?'danger':'success').'">' . $allData->exam_part_2 . '</span></td>
                            <td><span class="label label-'.($totalFalse?'danger':'success').'">' . $total . '</span></td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }

    public function doGetNewMbaProjectSummaryAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $category_result = DB::connection('mysql2')->select("SELECT category_id FROM new_mba_charge_transaction WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) ORDER BY id DESC limit 1");
            $category_id = $category_result[0]->category_id;
//            $result = DB::connection('mysql2')->select("SELECT new_mba_category_users_projects.*, new_mba_category_projects.title  FROM new_mba_category_users_projects inner join  new_mba_category_projects on new_mba_category_users_projects.project_id = new_mba_category_projects.id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND new_mba_category_users_projects.category_id='$category_id' ORDER BY result DESC");
            $result = DB::connection('mysql2')->select("SELECT new_mba_category_users_projects.*, new_mba_category_projects.title  FROM new_mba_category_users_projects inner join  new_mba_category_projects on new_mba_category_users_projects.project_id = new_mba_category_projects.id WHERE user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) ORDER BY result DESC");
            $x = 1;
            //echo$query;
            $html = '';

            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $allData->title . '</td>
                            <td><a href="'.e3mURL('assets/images/'.$allData->correction).'"  target="_blank">' . $allData->correction . '</a></td>
                            <td>' . $allData->correction_date . '</td>
                            <td>' . $allData->approved . '</td>
                            <td>' . $allData->result . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }


    public function doGetMbaPercentageAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
//            $columnName = 'users_course_view_completed.id';
//            switch ($data['order'][0]['column']) {
//                case 1:
//                    $columnName = 'courses.name';
//                    break;
//                case 2:
//                    $columnName = 'users.FullName';
//                    break;
//                case 3:
//                    $columnName = 'users.Email';
//                    break;
//                case 4:
//                    $columnName = 'ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1)';
//                    break;
//            }
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed 
INNER JOIN users ON users.id=users_course_view_completed.user_id
INNER JOIN courses ON courses.id=users_course_view_completed.course_id
WHERE users.id =(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND course_id IN (SELECT mba_courses_user_plan.related_course FROM mba INNER JOIN mba_courses_user_plan ON mba_courses_user_plan.module_id=mba.id AND mba_courses_user_plan.user_id=users.id)");


//            if (isset($data['course_name']) && !empty($data['course_name'])) {
//                $course_name = $data['course_name'];
//                $query .= " AND courses.name='$course_name' ";
//            }
//            if (isset($data['user_name']) && !empty($data['user_name'])) {
//                $user_name = $data['user_name'];
//                $query .= " AND users.FullName='$user_name' ";
//            }
//            if (isset($data['user_email']) && !empty($data['user_email'])) {
//                $user_email = $data['user_email'];
//                $query .= " AND users.Email='$user_email' ";
//            }
//            if (isset($data['percentage_from']) && !empty($data['percentage_from']) && isset($data['percentage_to']) && !empty($data['percentage_to'])) {
//                $percentage_from = $data['percentage_from'];
//                $percentage_to = $data['percentage_to'];
//                $query .= " AND ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) BETWEEN '$percentage_from' AND '$percentage_to'";
//            }
//            if (isset($data['search']['value']) && !empty($data['search']['value'])) {
//                $search = $data['search']['value'];
//                $query .= " AND (courses.name LIKE '%$search%' OR users.FullName LIKE '%$search%' OR users.Email LIKE '%$search%')";
//            }
//            $orderBy = $data['order'][0]['dir'];
//            $query .= " ORDER BY $columnName $orderBy";
            $x = 1;
            //echo$query;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->percentage . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }

    public function doGetDbaPercentageAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
//            $columnName = 'users_course_view_completed.id';
//            switch ($data['order'][0]['column']) {
//                case 1:
//                    $columnName = 'courses.name';
//                    break;
//                case 2:
//                    $columnName = 'users.FullName';
//                    break;
//                case 3:
//                    $columnName = 'users.Email';
//                    break;
//                case 4:
//                    $columnName = 'ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1)';
//                    break;
//            }
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed 
INNER JOIN users ON users.id=users_course_view_completed.user_id
INNER JOIN courses ON courses.id=users_course_view_completed.course_id
WHERE users.id =(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND course_id IN (SELECT dba_preliminary_courses_user_plan.related_course FROM dba_preliminary_courses_user_plan WHERE dba_preliminary_courses_user_plan.user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1))");


//            if (isset($data['course_name']) && !empty($data['course_name'])) {
//                $course_name = $data['course_name'];
//                $query .= " AND courses.name='$course_name' ";
//            }
//            if (isset($data['user_name']) && !empty($data['user_name'])) {
//                $user_name = $data['user_name'];
//                $query .= " AND users.FullName='$user_name' ";
//            }
//            if (isset($data['user_email']) && !empty($data['user_email'])) {
//                $user_email = $data['user_email'];
//                $query .= " AND users.Email='$user_email' ";
//            }
//            if (isset($data['percentage_from']) && !empty($data['percentage_from']) && isset($data['percentage_to']) && !empty($data['percentage_to'])) {
//                $percentage_from = $data['percentage_from'];
//                $percentage_to = $data['percentage_to'];
//                $query .= " AND ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) BETWEEN '$percentage_from' AND '$percentage_to'";
//            }
//            if (isset($data['search']['value']) && !empty($data['search']['value'])) {
//                $search = $data['search']['value'];
//                $query .= " AND (courses.name LIKE '%$search%' OR users.FullName LIKE '%$search%' OR users.Email LIKE '%$search%')";
//            }
//            $orderBy = $data['order'][0]['dir'];
//            $query .= " ORDER BY $columnName $orderBy";
            $x = 1;
            //echo$query;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->percentage . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }


    public function doGetNewMbaPercentageAjax($request)
    {

        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
//            $columnName = 'users_course_view_completed.id';
//            switch ($data['order'][0]['column']) {
//                case 1:
//                    $columnName = 'courses.name';
//                    break;
//                case 2:
//                    $columnName = 'users.FullName';
//                    break;
//                case 3:
//                    $columnName = 'users.Email';
//                    break;
//                case 4:
//                    $columnName = 'ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1)';
//                    break;
//            }
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("
                    SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed 
INNER JOIN users ON users.id=users_course_view_completed.user_id
INNER JOIN courses ON courses.id=users_course_view_completed.course_id
WHERE users.id =(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND course_id IN (SELECT new_mba_module_courses.related_course FROM new_mba INNER JOIN new_mba_module_courses ON new_mba_module_courses.module_id=new_mba.id)
                    ");


//            if (isset($data['course_name']) && !empty($data['course_name'])) {
//                $course_name = $data['course_name'];
//                $query .= " AND courses.name='$course_name' ";
//            }
//            if (isset($data['user_name']) && !empty($data['user_name'])) {
//                $user_name = $data['user_name'];
//                $query .= " AND users.FullName='$user_name' ";
//            }
//            if (isset($data['user_email']) && !empty($data['user_email'])) {
//                $user_email = $data['user_email'];
//                $query .= " AND users.Email='$user_email' ";
//            }
//            if (isset($data['percentage_from']) && !empty($data['percentage_from']) && isset($data['percentage_to']) && !empty($data['percentage_to'])) {
//                $percentage_from = $data['percentage_from'];
//                $percentage_to = $data['percentage_to'];
//                $query .= " AND ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) BETWEEN '$percentage_from' AND '$percentage_to'";
//            }
//            if (isset($data['search']['value']) && !empty($data['search']['value'])) {
//                $search = $data['search']['value'];
//                $query .= " AND (courses.name LIKE '%$search%' OR users.FullName LIKE '%$search%' OR users.Email LIKE '%$search%')";
//            }
//            $orderBy = $data['order'][0]['dir'];
//            $query .= " ORDER BY $columnName $orderBy";
            $x = 1;
            //echo$query;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->percentage . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;

    }

    public function doGetMbaExamsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT users_module_exams_answers.*,users.Fullname AS user_name,users.Email AS user_email,mba.name AS module_name FROM users_module_exams_answers INNER JOIN users ON users.id=users_module_exams_answers.user_id INNER JOIN mba ON mba.id=users_module_exams_answers.module_id WHERE users.Email='$email'");
            if (count($result)) {
                $x = 1;
                $date = date('Y-m-d');
                $dateW = date('Y-m-d', strtotime('-7 days'));
                foreach ($result as $allData) {
                    $extra = '';

                    $extra .= '<td>';

                    $createdtime = date('Y-m-d', strtotime($allData->createdtime));
                    if (($createdtime >= $dateW) && ($createdtime <= $date)) {
                        if (PerUser('dashboard_mba_open_exam')) {
                            $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="mbaopenexam btn btn-danger">Open Exam</button>';
                        }
                    }
                    $extra .= '</td>';
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                             <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetNewMbaExams1Ajax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT new_mba_users_module_exams_answers.*,users.Fullname AS user_name,users.Email AS user_email,new_mba.name AS module_name 
                                                       FROM new_mba_users_module_exams_answers 
                                                       INNER JOIN users 
                                                       ON users.id=new_mba_users_module_exams_answers.user_id 
                                                       INNER JOIN new_mba 
                                                       ON new_mba.id=new_mba_users_module_exams_answers.module_id 
                                                       WHERE new_mba_users_module_exams_answers.exam_type='Part One' AND users.Email='$email'");
            if (count($result)) {
                $x = 1;
                $date = date('Y-m-d');
                $dateW = date('Y-m-d', strtotime('-7 days'));
                foreach ($result as $allData) {
                    $extra = '';

                    $extra .= '<td>';

                    $createdtime = date('Y-m-d', strtotime($allData->createdtime));
                    if (($createdtime >= $dateW) && ($createdtime <= $date)) {
                        if (PerUser('dashboard_mba_open_exam')) {
                            $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="newmbaopenexam btn btn-danger">Open Exam</button>';
                        }
                    }
                    $extra .= '</td>';
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                             <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>'.
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetNewMbaExams2Ajax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT new_mba_users_module_exams_answers.*,users.Fullname AS user_name,users.Email AS user_email,new_mba.name AS module_name 
                                                       FROM new_mba_users_module_exams_answers 
                                                       INNER JOIN users 
                                                       ON users.id=new_mba_users_module_exams_answers.user_id 
                                                       INNER JOIN new_mba 
                                                       ON new_mba.id=new_mba_users_module_exams_answers.module_id 
                                                       WHERE new_mba_users_module_exams_answers.exam_type='Part Two' AND users.Email='$email'");
            if (count($result)) {
                $x = 1;
                $date = date('Y-m-d');
                $dateW = date('Y-m-d', strtotime('-7 days'));
                foreach ($result as $allData) {
                    $extra = '';

                    $extra .= '<td>';

                    $createdtime = date('Y-m-d', strtotime($allData->createdtime));
                    if (($createdtime >= $dateW) && ($createdtime <= $date)) {
                        if (PerUser('dashboard_mba_open_exam')) {
                            $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="newmbaopenexam btn btn-danger">Open Exam</button>';
                        }
                    }
                    $extra .= '</td>';
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>'.
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }


    public function doGetMbaTrainingsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT users_module_trainings_answers.*,users.Fullname AS user_name,users.Email AS user_email,mba.name AS module_name ,courses.name AS course_name FROM users_module_trainings_answers INNER JOIN users ON users.id=users_module_trainings_answers.user_id INNER JOIN mba ON mba.id=users_module_trainings_answers.module_id INNER JOIN courses ON courses.id=users_module_trainings_answers.course_id WHERE users.Email='$email'");
            if (count($result)) {
                $x = 1;
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetNewMbaTrainingsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT new_mba_users_module_trainings_answers.*,users.Fullname AS user_name,users.Email AS user_email,new_mba.name AS module_name ,courses.name AS course_name
                                                        FROM new_mba_users_module_trainings_answers 
                                                        INNER JOIN users 
                                                        ON users.id=new_mba_users_module_trainings_answers.user_id 
                                                        INNER JOIN new_mba 
                                                        ON new_mba.id=new_mba_users_module_trainings_answers.module_id
                                                         INNER JOIN courses 
                                                        ON courses.id=new_mba_users_module_trainings_answers.course_id 
                                                        WHERE users.Email='$email'");
            if (count($result)) {
                $x = 1;
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetCoursesExamsTrainingsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT users_curriculum_answers.*,users.Fullname AS user_name,users.Email AS user_email,courses.name AS course_name FROM users_curriculum_answers INNER JOIN users ON users.id=users_curriculum_answers.user_id INNER JOIN courses ON courses.id=users_curriculum_answers.course_id WHERE users.Email='$email' AND courses.show_on='mba'");
            if (count($result)) {
                $x = 1;
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->curriculum_type . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetDbaCoursesExamsTrainingsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT users_curriculum_answers.*,users.Fullname AS user_name,users.Email AS user_email,courses.name AS course_name FROM users_curriculum_answers INNER JOIN users ON users.id=users_curriculum_answers.user_id INNER JOIN courses ON courses.id=users_curriculum_answers.course_id WHERE users.Email='$email' AND courses.id IN (SELECT dba_preliminary_courses_user_plan.related_course FROM dba_preliminary_courses_user_plan WHERE dba_preliminary_courses_user_plan.user_id=(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1))");
            if (count($result)) {
                $x = 1;
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->curriculum_type . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetDbaGenerateCertificateFormAjax($request){
        $certificate=null;
        $dba=DBAChargeTransaction::whereRaw("user_id =(SELECT id FROM users  WHERE Email=? AND deleted_at IS NULL LIMIT 1)",[$request->email])->first();
        if($dba->user_id){
            $certificate=DBACertificate::where('user_id',$dba->user_id)->first();
        }
        $html=view('auth.include.dba_generate_certificate',compact('dba','certificate'))->render();
        return $html;
    }
    public function doGenerateDBACertificate($request){
        $dba=DBAChargeTransaction::where('user_id',$request->user_id)->first();
        $certificate=DBACertificate::where('user_id',$request->user_id)->first();

        if(!$certificate){
            $user=AcademyUsers::find($request->user_id);
            $increment=DBACertificate::count()+1;
            $code='DBA-';
            switch(strlen($increment)){
                case 1:
                    $serialNumber= $code.'00000'.$increment;
                    break;
                case 2:
                    $serialNumber= $code.'0000'.$increment;
                    break;
                case 3:
                    $serialNumber= $code.'000'.$increment;
                    break;
                case 4:
                    $serialNumber= $code.'00'.$increment;
                    break;
                case 5:
                    $serialNumber= $code.'0'.$increment;
                    break;
                case 6:
                    $serialNumber= $code.$increment;
                    break;
            }
            $certificate=DBACertificate::create([
                'serial_number'=>$serialNumber,
                'user_id'=>$request->user_id,
                'user_name_en'=>$user->name_en,
                'user_name'=>$user->FullName,
                'employee_id'=>auth()->id(),
            ]);

        }
        $html=view('auth.include.dba_generate_certificate',compact('dba','certificate'))->render();
        return $html;
    }
    public function doGetNewCoursesExamsTrainingsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT users_curriculum_answers.*,users.Fullname AS user_name,users.Email AS user_email,courses.name AS course_name 
                                                    FROM users_curriculum_answers 
                                                    INNER JOIN users 
                                                    ON users.id=users_curriculum_answers.user_id 
                                                    INNER JOIN courses 
                                                    ON courses.id=users_curriculum_answers.course_id 
                                                    WHERE users.Email='$email' AND courses.show_on='new_mba'");
            if (count($result)) {
                $x = 1;
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->curriculum_type . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="6">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="6">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }


    public function doGetCoursesExamsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT users_curriculum_answers.*,users.Fullname AS user_name,users.Email AS user_email,courses.name AS module_name ,
                                                    courses_sections.name AS section_name
                                                    FROM 	users_curriculum_answers 
                                                    INNER JOIN users ON users.id=users_curriculum_answers.user_id 
                                                    INNER JOIN cources_curriculum 
                                                    ON cources_curriculum.id=users_curriculum_answers.curriculum_id 
                                                    INNER JOIN courses 
                                                    ON courses.id=cources_curriculum.course_id INNER JOIN courses_sections 
                                                    ON courses_sections.id=cources_curriculum.section_id 
                                                    WHERE users.Email='$email'");
            $html_exam = '';
            $html_tranning = '';
            if (count($result)) {
                $x_e = 1;
                $x_t = 1;
                foreach ($result as $allData) {
                    if ($allData->curriculum_type == 'exam') {
                        $lastExamId=UsersCurriculumAnswers::where('user_id',$allData->user_id)
                            ->where('course_id',$allData->course_id)
                            ->where('curriculum_id',$allData->curriculum_id)->max('id');
                            ;
                        $html_exam .= '<tr>
                            <td>' . $x_e . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->curriculum_type . '</td>
                            <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>';
                        if (PerUser('dashboard_open_exam')) {
                            $startDate = Carbon::now();
                            $endDate = Carbon::parse($allData->createdtime);
                            $diff = $endDate->diffInDays($startDate);
//                                if($diff<=7){
//                                    dd($startDate,$endDate,$diff);
//                                }
                            $html_exam .= '<td>';
                            $html_exam .= ($diff <= 7&&$lastExamId==$allData->id ? '<button data-user="' . $allData->user_id . '" data-id="' . $allData->id . '" class="openExamForCourse btn btn-success">Open Exam</button>' : '');
                            $html_exam .= '</td>';
                        }
                        $html_exam .= '</tr>';
                        $x_e++;
                    } else {
                        $html_tranning .= '<tr>
                            <td>' . $x_t . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->section_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->curriculum_type . '</td>
                            <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                        $x_t++;
                    }


                }
            }
            if (!$html_exam) {
                $html_exam = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
            if (!$html_tranning) {
                $html_tranning = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        }
        return ['exam' => $html_exam, 'tranning' => $html_tranning];
    }

    public function doGetCoursesTrainingsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $html = '';
        if ($email) {
            $result = DB::connection('mysql2')->select("SELECT users_module_trainings_answers.*,users.Fullname AS user_name,users.Email AS user_email,mba.name AS module_name FROM users_module_trainings_answers INNER JOIN users ON users.id=users_module_trainings_answers.user_id INNER JOIN courses ON courses.id=users_module_trainings_answers.module_id WHERE users.Email='$email'");
            if (count($result)) {
                $x = 1;
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetLiteReportAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $result = DB::connection('mysql2')->select("SELECT lite_version_charge_transaction.*,users.Fullname AS user_name,users.Email AS user_email FROM lite_version_charge_transaction INNER JOIN users ON users.id=lite_version_charge_transaction.user_id  WHERE users.Email='$email'");
        $html = '';
        if (count($result)) {
            $x = 1;
            foreach ($result as $allData) {
                $extra = '';
                if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')))) {
                    $extra .= '<button data-id="' . $allData->id . '" data-type="lite"  class="activeChargeBtn btn btn-info">active</button>';
                }
                $html .= '<tr>         
                            <td>' . $allData->currency . '</td>
                            <td>' . $allData->amount . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->period . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>
                            ' . ((PerUser('dashboard_suspend_lite_version') || (PerUser('dashboard_active_charge_button') && $allData->pending)) ? '<td>' . (($allData->suspend) ? '<button data-id="' . $allData->id . '" class="suspendLiteButton btn btn-info">UnSuspend</button>' : '<button data-id="' . $allData->id . '" class="suspendLiteButton btn btn-danger">Suspend</button>') . $extra . '</td>' : '') . '

                         </tr>';
                $x++;
            }
        } else {
            $html = '<tr><td colspan="' . (PerUser('dashboard_suspend_lite_version') ? '8' : '7') . '">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetDiplomasSupplementaryTestsAjax($request)
    {
        $data = $request->all();

        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = \App\Models\supplementaryTestsAnswers::select('diplomas_supplementary_tests_answers.*', 'users.FullName as user_name', "diplomas.name as diploma_name")
                ->join('users', 'users.id', '=', 'diplomas_supplementary_tests_answers.user_id')
                ->leftJoin('diplomas', 'diplomas.id', '=', 'diplomas_supplementary_tests_answers.diploma_id')
                ->where('diplomas_supplementary_tests_answers.user_id', $user->id)->get();


            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->diploma_name . '</td>
                            <td>' . $allData->right_answers . '</td>
                            <td>' . $allData->wrong_answers . '</td>
                            <td>' . $allData->createdtime . '</td>'
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function getUserDiplomas($user_id,$checkExpired=false)
    {
        $query="";
        if($checkExpired){
            $date=date('Y-m-d H:i:s');
            $query=" AND( ( '$date' BETWEEN start_date AND end_date AND suspend=0) OR suspend=1)";
        }
        $sql="select diplomas_charge_transaction.*,diplomas.name AS diploma_name from diplomas_charge_transaction INNER JOIN diplomas ON diplomas.id=diplomas_charge_transaction.diploma_id WHERE diplomas_charge_transaction.user_id='$user_id' $query";
        $result1 = DB::connection('mysql2')->select($sql);
        $sql="select diplomas_companies_charge_transaction.*,diplomas.name AS diploma_name from diplomas_companies_charge_transaction INNER JOIN diplomas ON diplomas.id=diplomas_companies_charge_transaction.diploma_id WHERE diplomas_companies_charge_transaction.user_id='$user_id' $query";
        $result2 = DB::connection('mysql2')->select($sql);
        return array_merge($result1, $result2);
    }
    public function getUserCertificateDiplomas($user_id)
    {
        $result1 = DB::connection('mysql2')->select("select diplomas_charge_transaction.*,diplomas.name AS diploma_name from diplomas_charge_transaction INNER JOIN diplomas ON diplomas.id=diplomas_charge_transaction.diploma_id WHERE diplomas_charge_transaction.user_id='$user_id' group by diploma_id");
        $result2 = DB::connection('mysql2')->select("select diplomas_companies_charge_transaction.*,diplomas.name AS diploma_name from diplomas_companies_charge_transaction INNER JOIN diplomas ON diplomas.id=diplomas_companies_charge_transaction.diploma_id WHERE diplomas_companies_charge_transaction.user_id='$user_id' group by diploma_id");
        return array_merge($result1, $result2);
    }
    public function getUserPackages($user_id)
    {
        $result1 = DB::connection('mysql2')->select("select packages_charge_transaction.*,packages.name AS package_name from packages_charge_transaction INNER JOIN packages ON packages.id=packages_charge_transaction.package_id WHERE packages_charge_transaction.user_id='$user_id'");
        return $result1;
    }
    public function getUserCustom($user_id)
    {
        $result1 = DB::connection('mysql2')->select("select custom_charge_transaction.* from custom_charge_transaction WHERE custom_charge_transaction.user_id='$user_id'");
        return $result1;
    }

    public function getUserYottaDiplomas($user_id)
    {
        $result1 = DB::connection('mysql3')->select("select medical_diplomas_charge_transaction.*,medical_diplomas.name AS diploma_name from medical_diplomas_charge_transaction INNER JOIN medical_diplomas ON medical_diplomas.id=medical_diplomas_charge_transaction.diploma_id WHERE medical_diplomas_charge_transaction.user_id='$user_id'");
        return $result1;
    }
    public function getUserTrainigPrograms($user_id)
    {
        $result1 = DB::connection('mysql2')->select("select training_program_charge_transaction.*,training_program.name AS name from training_program_charge_transaction INNER JOIN training_program ON training_program.id=training_program_charge_transaction.diploma_id WHERE training_program_charge_transaction.user_id='$user_id'");
        $result2 = DB::connection('mysql2')->select("select training_programs_companies_charge_transaction.*,training_program.name AS name from training_programs_companies_charge_transaction INNER JOIN training_program ON training_program.id=training_programs_companies_charge_transaction.diploma_id WHERE training_programs_companies_charge_transaction.user_id='$user_id'");
        return array_merge($result1, $result2);
    }

    public function getUserInternationalDiplomas($user_id)
    {
        $result = DB::connection('mysql2')->select("select international_diplomas_charge_transaction.*,international_diplomas.name AS diploma_name from international_diplomas_charge_transaction INNER JOIN international_diplomas ON international_diplomas.id=international_diplomas_charge_transaction.diploma_id WHERE international_diplomas_charge_transaction.user_id='$user_id'");
        return $result;
    }

    public function doDiplomaMakeCertificate($email, $diploma_transaction_id)
    {
        if ($email && $diploma_transaction_id) {
            $result = DB::connection('mysql2')->select("SELECT diplomas_charge_transaction.* FROM diplomas_charge_transaction INNER JOIN users ON users.id=diplomas_charge_transaction.user_id WHERE users.Email='$email' AND diplomas_charge_transaction.id='$diploma_transaction_id'");
            if(!count($result)){
                $result = DB::connection('mysql2')->select("SELECT diplomas_companies_charge_transaction.* FROM diplomas_companies_charge_transaction INNER JOIN users ON users.id=diplomas_companies_charge_transaction.user_id WHERE users.Email='$email' AND diplomas_companies_charge_transaction.id='$diploma_transaction_id'");
            }
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                $user_id = $obj->user_id;
                $diploma_id = $obj->diploma_id;
                echo '<a href="https://e3melbusiness.com/?page=cronJob&action=convertDiplomaCertificates&debug=true&user_id='.$user_id.'&diploma_id='.$diploma_id.'" target="_blank" class="btn btn-success input-circle" id="diplomaMakeGenerateCer" type="submit">Generate Certificate</a>';
            } else {
                $errorMessage =  'No Data';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }
    public function doDiplomaMakeSuspend($email, $diploma_transaction_id, $suspend = 1)
    {
        if ($email && $diploma_transaction_id) {
            $notSuspend = ($suspend) ? 0 : 1;
            $result = DB::connection('mysql2')->select("SELECT diplomas_charge_transaction.* FROM diplomas_charge_transaction INNER JOIN users ON users.id=diplomas_charge_transaction.user_id WHERE users.Email='$email' AND diplomas_charge_transaction.id='$diploma_transaction_id' AND diplomas_charge_transaction.suspend='$notSuspend'");
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                DB::connection('mysql2')->table('diplomas_charge_transaction')->where('id', $diploma_transaction_id)->update(
                    ['suspend' => $suspend, 'suspend_date' => $date]
                );
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'diplomas_charge_transaction', $diploma_transaction_id, json_encode(['suspend' => $suspend, 'suspend_date' => $date]));
                $user_id = $obj->user_id;
                $diploma_id = $obj->diploma_id;
                DB::connection('mysql2')->table('diplomas_charge_transaction_suspend_log')->insert(
                    ['transaction_id' => $diploma_transaction_id, 'user_id' => $user_id, 'diploma_id' => $diploma_id, 'suspend' => $suspend, 'createtime' => $date]
                );
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($obj->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;
                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($obj->end_date)));
                    DB::connection('mysql2')->table('diplomas_charge_transaction')->where('id', $diploma_transaction_id)->update(
                        ['end_date' => $PaymentExpirationDate]
                    );
                    log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'diplomas_charge_transaction', $diploma_transaction_id, json_encode(['end_date' => $PaymentExpirationDate]));
                }
                sendDiplomasChargeTransaction($diploma_transaction_id);
                updateAcademyChargeTransaction($user_id);
                $errorMessage = ($notSuspend) ? 'Done Make Un Suspend' : 'Done Make Suspend';
                echo '<div class="alert alert-success">' . $errorMessage . '</div>';
            } else {
                $errorMessage = ($notSuspend) ? 'No Data Or already un suspended' : 'No Data Or already suspended';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }
    public function doPackageMakeSuspend($email, $package_transaction_id, $suspend = 1)
    {
        if ($email && $package_transaction_id) {
            $notSuspend = ($suspend) ? 0 : 1;
            $result = DB::connection('mysql2')->select("SELECT packages_charge_transaction.* FROM packages_charge_transaction INNER JOIN users ON users.id=packages_charge_transaction.user_id WHERE users.Email='$email' AND packages_charge_transaction.id='$package_transaction_id' AND packages_charge_transaction.suspend='$notSuspend'");
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                DB::connection('mysql2')->table('packages_charge_transaction')->where('id', $package_transaction_id)->update(
                    ['suspend' => $suspend, 'suspend_date' => $date]
                );
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'packages_charge_transaction', $package_transaction_id, json_encode(['suspend' => $suspend, 'suspend_date' => $date]));
                $user_id = $obj->user_id;
                $package_id = $obj->package_id;
                DB::connection('mysql2')->table('packages_charge_transaction_suspend_log')->insert(
                    ['transaction_id' => $package_transaction_id, 'user_id' => $user_id, 'package_id' => $package_id, 'suspend' => $suspend, 'createtime' => $date]
                );
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($obj->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;

                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($obj->end_date)));
                    DB::connection('mysql2')->table('packages_charge_transaction')->where('id', $package_transaction_id)->update(
                        ['end_date' => $PaymentExpirationDate]
                    );
                    log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'packages_charge_transaction', $package_transaction_id, json_encode(['end_date' => $PaymentExpirationDate]));
                }
                sendPackagesChargeTransaction($package_transaction_id);
                updateAcademyChargeTransaction($user_id);
                $errorMessage = ($notSuspend) ? 'Done Make Un Suspend' : 'Done Make Suspend';
                echo '<div class="alert alert-success">' . $errorMessage . '</div>';
            } else {
                $errorMessage = ($notSuspend) ? 'No Data Or already un suspended' : 'No Data Or already suspended';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }
    public function doCustomMakeSuspend($email, $custom_transaction_id, $suspend = 1)
    {
        if ($email && $custom_transaction_id) {
            $notSuspend = ($suspend) ? 0 : 1;
            $result = DB::connection('mysql2')->select("SELECT custom_charge_transaction.* FROM custom_charge_transaction INNER JOIN users ON users.id=custom_charge_transaction.user_id WHERE users.Email='$email' AND custom_charge_transaction.id='$custom_transaction_id' AND custom_charge_transaction.suspend='$notSuspend'");
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                DB::connection('mysql2')->table('custom_charge_transaction')->where('id', $custom_transaction_id)->update(
                    ['suspend' => $suspend, 'suspend_date' => $date]
                );
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'custom_charge_transaction', $custom_transaction_id, json_encode(['suspend' => $suspend, 'suspend_date' => $date]));
                $user_id = $obj->user_id;
                DB::connection('mysql2')->table('custom_charge_transaction_suspend_log')->insert(
                    ['transaction_id' => $custom_transaction_id, 'user_id' => $user_id,  'suspend' => $suspend, 'createtime' => $date]
                );
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($obj->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;

                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($obj->end_date)));
                    DB::connection('mysql2')->table('custom_charge_transaction')->where('id', $custom_transaction_id)->update(
                        ['end_date' => $PaymentExpirationDate]
                    );
                    log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'custom_charge_transaction', $custom_transaction_id, json_encode(['end_date' => $PaymentExpirationDate]));
                }
                sendCustomChargeTransaction($custom_transaction_id);
                updateAcademyChargeTransaction($user_id);
                $errorMessage = ($notSuspend) ? 'Done Make Un Suspend' : 'Done Make Suspend';
                echo '<div class="alert alert-success">' . $errorMessage . '</div>';
            } else {
                $errorMessage = ($notSuspend) ? 'No Data Or already un suspended' : 'No Data Or already suspended';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }

    public function doTrainingProgramMakeSuspend($email, $diploma_transaction_id, $suspend = 1)
    {
        if ($email && $diploma_transaction_id) {
            $notSuspend = ($suspend) ? 0 : 1;
            $result = DB::connection('mysql2')->select("SELECT training_program_charge_transaction.* FROM training_program_charge_transaction INNER JOIN users ON users.id=training_program_charge_transaction.user_id WHERE users.Email='$email' AND training_program_charge_transaction.id='$diploma_transaction_id' AND training_program_charge_transaction.suspend='$notSuspend'");
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                DB::connection('mysql2')->table('training_program_charge_transaction')->where('id', $diploma_transaction_id)->update(
                    ['suspend' => $suspend, 'suspend_date' => $date]
                );
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'training_program_charge_transaction', $diploma_transaction_id, json_encode(['suspend' => $suspend, 'suspend_date' => $date]));
                $user_id = $obj->user_id;
                $diploma_id = $obj->diploma_id;
                DB::connection('mysql2')->table('training_program_charge_transaction_suspend_log')->insert(
                    ['transaction_id' => $diploma_transaction_id, 'user_id' => $user_id, 'diploma_id' => $diploma_id, 'suspend' => $suspend, 'createtime' => $date]
                );
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($obj->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;
                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($obj->end_date)));
                    DB::connection('mysql2')->table('training_program_charge_transaction')->where('id', $diploma_transaction_id)->update(
                        ['end_date' => $PaymentExpirationDate]
                    );
                    log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'training_program_charge_transaction', $diploma_transaction_id, json_encode(['end_date' => $PaymentExpirationDate]));
                }
                sendTrainingProgramsChargeTransaction($diploma_transaction_id);
                updateAcademyChargeTransaction($user_id);
                $errorMessage = ($notSuspend) ? 'Done Make Un Suspend' : 'Done Make Suspend';
                echo '<div class="alert alert-success">' . $errorMessage . '</div>';
            } else {
                $errorMessage = ($notSuspend) ? 'No Data Or already un suspended' : 'No Data Or already suspended';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }

    public function doInternationalDiplomaMakeSuspend($email, $diploma_transaction_id, $suspend = 1)
    {
        if ($email && $diploma_transaction_id) {
            $notSuspend = ($suspend) ? 0 : 1;
            $result = DB::connection('mysql2')->select("SELECT international_diplomas_charge_transaction.* FROM international_diplomas_charge_transaction INNER JOIN users ON users.id=international_diplomas_charge_transaction.user_id WHERE users.Email='$email' AND international_diplomas_charge_transaction.id='$diploma_transaction_id' AND international_diplomas_charge_transaction.suspend='$notSuspend'");
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                DB::connection('mysql2')->table('international_diplomas_charge_transaction')->where('id', $diploma_transaction_id)->update(
                    ['suspend' => $suspend, 'suspend_date' => $date]
                );
                log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'international_diplomas_charge_transaction', $diploma_transaction_id, json_encode(['suspend' => $suspend, 'suspend_date' => $date]));
                $user_id = $obj->user_id;
                $diploma_id = $obj->diploma_id;
                DB::connection('mysql2')->table('international_diplomas_charge_transaction_suspend_log')->insert(
                    ['transaction_id' => $diploma_transaction_id, 'user_id' => $user_id, 'diploma_id' => $diploma_id, 'suspend' => $suspend, 'createtime' => $date]
                );
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($obj->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;
                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($obj->end_date)));
                    DB::connection('mysql2')->table('international_diplomas_charge_transaction')->where('id', $diploma_transaction_id)->update(
                        ['end_date' => $PaymentExpirationDate]
                    );
                    log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'international_diplomas_charge_transaction', $diploma_transaction_id, json_encode(['end_date' => $PaymentExpirationDate]));
                }
                $errorMessage = ($notSuspend) ? 'Done Make Un Suspend' : 'Done Make Suspend';
                echo '<div class="alert alert-success">' . $errorMessage . '</div>';
            } else {
                $errorMessage = ($notSuspend) ? 'No Data Or already un suspended' : 'No Data Or already suspended';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }


    public function doGetListUserCoursesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email'])) {
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("SELECT courses.id,courses.name FROM users_courses_charge_transactions INNER JOIN courses ON courses.id=users_courses_charge_transactions.course_id INNER JOIN users ON users.id=users_courses_charge_transactions.user_id WHERE users.Email='$email'");
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $allData->id . '</td>
                            <td>' . $allData->name . '</td>
                         </tr>';
                }
            } else {
                $html = '<tr><td colspan="2">No Data</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="2">No Data</td></tr>';
        }
        return $html;
    }

    public function doGetCoursesReportAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $result = DB::connection('mysql2')->select("SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed 
INNER JOIN users ON users.id=users_course_view_completed.user_id
INNER JOIN courses ON courses.id=users_course_view_completed.course_id
WHERE users.id =(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)");

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->percentage . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetDemoLogAjax($request, $id)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $result = AddDemoLog::with('user')->where('user_id', '=', $id)->get();
//            $result1=DB::table('add_demo_log as demo_log')
//	            ->rightJoin('mysql2.users as u','u.id', 'demo_log.user_id')
//	            ->select('u.FullName AS ', 'u.Email AS user_email', 'demo_log.*')
//                ->where("u.id","=", $id)->get();
            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user->FullName . '</td>
                            <td>' . $allData->user->Email . '</td>
                            <td>' . $allData->demo_type . '</td>
                            <td>' . $allData->old_DemoExpirationDate . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="7">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="7">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetCompaniesChargesAjax($request, $id)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {;
            $x = 1;
            $html = '';
            $company_charge_transaction = DB::connection('mysql2')->table('companies_charge_transaction')
                ->select('companies_charge_transaction.*', 'companies.expiredDate')
                ->join('companies', 'companies.id', '=', 'companies_charge_transaction.company_id')
                ->where('user_id', $id)->get();
            foreach ($company_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>'.$x.'</td>
                        <td>Charge Transaction</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
            }
            $diplomas_charge_transaction = DB::connection('mysql2')->table('diplomas_companies_charge_transaction')
                ->select('diplomas_companies_charge_transaction.*', 'companies.expiredDate', 'diplomas.name AS diploma_name')
                ->join('companies', 'companies.id', '=', 'diplomas_companies_charge_transaction.company_id')
                ->join('diplomas', 'diplomas.id', '=', 'diplomas_companies_charge_transaction.diploma_id')
                ->where('user_id', $id)->get();
            foreach ($diplomas_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>'.$x.'</td>
                        <td>' . $charge->diploma_name . '</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
            }
            $training_charge_transaction = DB::connection('mysql2')->table('training_programs_companies_charge_transaction')
                ->select('training_programs_companies_charge_transaction.*', 'companies.expiredDate', 'training_program.name AS diploma_name')
                ->join('companies', 'companies.id', '=', 'training_programs_companies_charge_transaction.company_id')
                ->join('training_program', 'training_program.id', '=', 'training_programs_companies_charge_transaction.diploma_id')
                ->where('user_id', $id)->get();
            foreach ($training_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>'.$x.'</td>
                        <td>' . $charge->diploma_name . '</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
            }

            $lite_charge_transaction = DB::connection('mysql2')->table('lite_version_companies_charge_transaction')
                ->select('lite_version_companies_charge_transaction.*', 'companies.expiredDate')
                ->join('companies', 'companies.id', '=', 'lite_version_companies_charge_transaction.company_id')
                ->where('user_id', $id)->get();
            foreach ($lite_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>'.$x.'</td>
                        <td>Lite Version</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
            }
            $mba_charge_transaction = DB::connection('mysql2')->table('mba_companies_charge_transaction')
                ->select('mba_companies_charge_transaction.*', 'companies.expiredDate')
                ->join('companies', 'companies.id', '=', 'mba_companies_charge_transaction.company_id')
                ->where('user_id', $id)->get();
            foreach ($mba_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>'.$x.'</td>
                        <td>MBA</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
            }
            $new_mba_charge_transaction = DB::connection('mysql2')->table('new_mba_companies_charge_transaction')
                ->select('new_mba_companies_charge_transaction.*', 'companies.expiredDate', 'new_mba_categories.name as name')
                ->join('companies', 'companies.id', '=', 'new_mba_companies_charge_transaction.company_id')
                ->join('new_mba_categories', 'new_mba_categories.id', '=', 'new_mba_companies_charge_transaction.category_id')
               ->where('user_id', $id)->get();
            foreach ($new_mba_charge_transaction as $charge) {
                $html .= '<tr>
                        <td>'.$x.'</td>
                        <td>New MBA ' . $charge->name . '</td>
                        <td>' . $charge->start_date . '</td>
                        <td>' . $charge->expiredDate . '</td>
                        </tr>';
            }
            if($html==''){
                $html = '<tr><td colspan="4">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="4">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetDiplomasChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = DiplomasChargeTransaction::select('diplomas_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'diplomas_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'diplomas_charge_transaction.coupon_id')
                ->where('diplomas_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    if (PerUser('dashboard_open_diploma_courses') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '<td>';
                    }
                    if (PerUser('dashboard_open_diploma_courses')) {
                        $extra .= '<button data-user-id="' . $user->id . '" style="margin: 5px;" data-diploma-id="' . $allData->diploma_id . '" class="openDiplomaCourses btn btn-danger">فتح الكورسات للعميل</button>';
                    }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="diplomas" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_diplomas_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteDiplomasChargeTransaction btn btn-danger">Delete</button>';
                    }
                    if (PerUser('dashboard_open_diploma_courses') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '</td>';
                    }
                    $html .= '<tr id="view-diplomas_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . (PerUser('dashboard_diplomas_charges_edit') ? '<a href="#" data-name="diplomas_charge_transaction" data-pk="' . $allData->id . '" data-id="' . $allData->diploma_id . '" data-value="' . htmlspecialchars(json_encode(['diploma_id' => ['id' => $allData->diploma_id, 'text' => $allData->diploma_name], 'charge_system' => ['id' => $allData->charge_system, 'text' => ($allData->charge_system == 'ksa' ? 'سعودى' : 'مصرى')]]), ENT_QUOTES, 'UTF-8') . '" data-type="diplomas_charge" class="change-diploma">' . $allData->diploma_name . '</a>' : $allData->diploma_name) . '</td>
                            <td>' . $allData->diploma_price . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetPackagesChargesAjax($request)
    {

        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = PackagessChargeTransaction::select('packages_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'packages_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'packages_charge_transaction.coupon_id')
                ->where('packages_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    if (PerUser('dashboard_open_package_courses') ||PerUser('dashboard_packages_charges_delete') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '<td>';
                    }
                    if (PerUser('dashboard_open_package_courses')) {
                        $extra .= '<button data-user-id="' . $user->id . '" style="margin: 5px;" data-package-id="' . $allData->package_id . '" class="openPackageCourses btn btn-danger">فتح الكورسات للعميل</button>';
                    }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="packages" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_packages_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deletePackagesChargeTransaction btn btn-danger">Delete</button>';
                    }
                    if (PerUser('dashboard_open_package_courses') ||PerUser('dashboard_packages_charges_delete') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '</td>';
                    }
                    $html .= '<tr id="view-packages_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->package_name . '</td>
                            <td>' . $allData->package_price . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetCustomChargesAjax($request)
    {

        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = CustomChargeTransaction::select('custom_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'custom_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'custom_charge_transaction.coupon_id')
                ->where('custom_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    if (PerUser('dashboard_open_custom_courses') ||PerUser('dashboard_custom_charges_delete') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '<td>';
                    }
                    if (PerUser('dashboard_open_custom_courses')) {
                        $extra .= '<button data-user-id="' . $user->id . '" style="margin: 5px;" data-custom-id="' . $allData->custom_id . '" class="openCustomCourses btn btn-danger">فتح الكورسات للعميل</button>';
                    }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="custom" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_custom_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteCustomChargeTransaction btn btn-danger">Delete</button>';
                    }
                    if (PerUser('dashboard_open_custom_courses') ||PerUser('dashboard_custom_charges_delete') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '</td>';
                    }
                    $html .= '<tr id="view-custom_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                          <td>'.(PerUser('dashboard_custom_charges_edit') ? '<a href="javascript:;" class="courses_count" data-params="{request:\'custom\',request_id:\'' . $allData->id . '\',request_lang:\'ar\'}" data-url="' . URL('admin/change_count_custom_charge_transaction') . '" data-type="text" data-pk="1" data-original-title="Enter courses count">' . $allData->courses_count . '</a>' : $allData->courses_count) . '</td>
                            <td>' . $allData->custom_price . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetCompaniesDiplomasChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = DiplomasCompaniesChargeTransaction::select('diplomas_companies_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'diplomas_companies_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'diplomas_companies_charge_transaction.coupon_id')
                ->where('diplomas_companies_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    if (PerUser('dashboard_open_diploma_courses')) {
                        $extra .= '<td>';
                    }
                    if (PerUser('dashboard_open_diploma_courses')) {
                        $extra .= '<button data-user-id="' . $user->id . '" style="margin: 5px;" data-diploma-id="' . $allData->diploma_id . '" class="openDiplomaCourses btn btn-danger">فتح الكورسات للعميل</button>';
                    }

                    if (PerUser('dashboard_open_diploma_courses')) {
                        $extra .= '</td>';
                    }
                    $html .= '<tr id="view-diplomas_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->diploma_name . '</td>
                            <td>' . $allData->diploma_price . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }


    public function doGetTrainingProgramsChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = TrainingProgramsChargeTransaction::select('training_program_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'training_program_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'training_program_charge_transaction.coupon_id')
                ->where('training_program_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    if (PerUser('dashboard_open_training_program_courses') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '<td>';
                    }
                    if (PerUser('dashboard_open_training_program_courses')) {
                        $extra .= '<button data-user-id="' . $user->id . '" data-training-program-id="' . $allData->diploma_id . '" class="openTrainingProgramCourses btn btn-danger">فتح الكورسات للعميل</button>';
                    }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" data-type="training_program" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_training_program_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteTrainingProgramChargeTransaction btn btn-danger">Delete</button>';
                    }
                    if (PerUser('dashboard_open_training_program_courses') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '</td>';
                    }
                    $html .= '<tr id="view-training_program_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->diploma_name . '</td>
                            <td>' . $allData->diploma_price . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetSuspendTrainingProgramLogAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = TrainingProgramChargeTransactionSuspendLog::select('training_program_charge_transaction_suspend_log.suspend as status', 'training_program_charge_transaction_suspend_log.createtime as status_date', 'users.FullName as user_name', 'training_program.name as diploma_name', "training_program_charge_transaction.start_date as start_subscription_date", "training_program_charge_transaction.end_date as end_subscription_date", "training_program_charge_transaction.createtime as charge_date")
                ->join('users', 'users.id', '=', 'training_program_charge_transaction_suspend_log.user_id')
                ->join('training_program', 'training_program.id', '=', 'training_program_charge_transaction_suspend_log.diploma_id')
                ->join('training_program_charge_transaction', 'training_program_charge_transaction.id', '=', 'training_program_charge_transaction_suspend_log.transaction_id')
                ->where('training_program_charge_transaction_suspend_log.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {

                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->diploma_name . '</td>
                            <td>' . $allData->start_subscription_date . '</td>
                            <td>' . $allData->end_subscription_date . '</td>
                            <td>' . $allData->charge_date . '</td>
                             <td>' . ($allData->status == 1 ? 'suspend' : 'unsuspend') . '</td>
                            <td>' . $allData->status_date . '</td>'
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetSuspendLogAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = DiplomasChargeTransactionSuspendLog::select('diplomas_charge_transaction_suspend_log.suspend as status', 'diplomas_charge_transaction_suspend_log.createtime as status_date', 'users.FullName as user_name', 'diplomas.name as diploma_name', "diplomas_charge_transaction.start_date as start_subscription_date", "diplomas_charge_transaction.end_date as end_subscription_date", "diplomas_charge_transaction.createtime as charge_date")
                ->join('users', 'users.id', '=', 'diplomas_charge_transaction_suspend_log.user_id')
                ->join('diplomas', 'diplomas.id', '=', 'diplomas_charge_transaction_suspend_log.diploma_id')
                ->join('diplomas_charge_transaction', 'diplomas_charge_transaction.id', '=', 'diplomas_charge_transaction_suspend_log.transaction_id')
                ->where('diplomas_charge_transaction_suspend_log.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {

                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->diploma_name . '</td>
                            <td>' . $allData->start_subscription_date . '</td>
                            <td>' . $allData->end_subscription_date . '</td>
                            <td>' . $allData->charge_date . '</td>
                             <td>' . ($allData->status == 1 ? 'suspend' : 'unsuspend') . '</td>
                            <td>' . $allData->status_date . '</td>'
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetPackageSuspendLogAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = PackagesChargeTransactionSuspendLog::select('packages_charge_transaction_suspend_log.suspend as status', 'packages_charge_transaction_suspend_log.createtime as status_date', 'users.FullName as user_name', 'packages.name as package_name', "packages_charge_transaction.start_date as start_subscription_date", "packages_charge_transaction.end_date as end_subscription_date", "packages_charge_transaction.createtime as charge_date")
                ->join('users', 'users.id', '=', 'packages_charge_transaction_suspend_log.user_id')
                ->join('packages', 'packages.id', '=', 'packages_charge_transaction_suspend_log.package_id')
                ->join('packages_charge_transaction', 'packages_charge_transaction.id', '=', 'packages_charge_transaction_suspend_log.transaction_id')
                ->where('packages_charge_transaction_suspend_log.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {

                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->package_name . '</td>
                            <td>' . $allData->start_subscription_date . '</td>
                            <td>' . $allData->end_subscription_date . '</td>
                            <td>' . $allData->charge_date . '</td>
                             <td>' . ($allData->status == 1 ? 'suspend' : 'unsuspend') . '</td>
                            <td>' . $allData->status_date . '</td>'
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetCustomSuspendLogAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = CustomChargeTransactionSuspendLog::select('custom_charge_transaction_suspend_log.suspend as status', 'custom_charge_transaction_suspend_log.createtime as status_date', 'users.FullName as user_name', "custom_charge_transaction.start_date as start_subscription_date", "custom_charge_transaction.end_date as end_subscription_date", "custom_charge_transaction.createtime as charge_date")
                ->join('users', 'users.id', '=', 'custom_charge_transaction_suspend_log.user_id')
                ->join('custom_charge_transaction', 'custom_charge_transaction.id', '=', 'custom_charge_transaction_suspend_log.transaction_id')
                ->where('custom_charge_transaction_suspend_log.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {

                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->start_subscription_date . '</td>
                            <td>' . $allData->end_subscription_date . '</td>
                            <td>' . $allData->charge_date . '</td>
                             <td>' . ($allData->status == 1 ? 'suspend' : 'unsuspend') . '</td>
                            <td>' . $allData->status_date . '</td>'
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }


    public function doGetMbaChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = MbaChargeTransaction::select('mba_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'mba_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'mba_charge_transaction.coupon_id')
                ->where('mba_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';

                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    // }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" data-type="mba" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_mba_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteMbaChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    // }

                    $html .= '<tr id="view-mba_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                             <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="6">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="6">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetPreparatoryMbaChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = PreparatoryMbaChargeTransaction::select('preparatory_mba_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'preparatory_mba_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'preparatory_mba_charge_transaction.coupon_id')
                ->where('preparatory_mba_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';

                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    // }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" data-type="preparatory_mba" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_preparatory_mba_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deletePreparatoryMbaChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    // }

                    $html .= '<tr id="view-preparatory_mba_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                             <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="6">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="6">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetNewMbaChargesAjax_old($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = NewMbaChargeTransaction::select('new_mba_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'new_mba_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'new_mba_charge_transaction.coupon_id')
                ->where('new_mba_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';

                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    // }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="new_mba" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_new_mba_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteNewMbaChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    // }

                    $html .= '<tr id="view-new_mba_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                             <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetNewMbaChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = NewMbaChargeTransaction::select('new_mba_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon', 'new_mba_categories.name as category_name')
                ->join('users', 'users.id', '=', 'new_mba_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'new_mba_charge_transaction.coupon_id')
                ->leftJoin('new_mba_categories', 'new_mba_categories.id', '=', 'new_mba_charge_transaction.category_id')
                ->where('new_mba_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';

                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    // }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="new_mba" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_new_mba_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteNewMbaChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    // }
                    $disabled = '';
                    if (isset($allData->category_id) && $allData->category_id != 0) {
                        $disabled = 'style= "pointer-events: none;"';
                    }

                    $html .= '<tr id="view-new_mba_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                             <td><a href="javascript:;" class="category_name" data-params="{charge_id:\'' . $allData->id . '\'}" data-url="' . URL('admin/editchargecategory') . '" data-type="select" data-pk="1" data-original-title="Select Category" data-value="' . $allData->category_id . '" ' . $disabled . '>' . $allData->category_name . '</a></td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                             <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }


    public function doGetDBAPreliminaryChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = DBAPreliminaryChargeTransaction
                ::select('dba_preliminary_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon', 'dba_categories.name as name')
                ->join('users', 'users.id', '=', 'dba_preliminary_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'dba_preliminary_charge_transaction.coupon_id')
                ->leftJoin('dba_categories', 'dba_categories.id', '=', 'dba_preliminary_charge_transaction.category_id')
                ->where('dba_preliminary_charge_transaction.user_id', $user->id)->get();
            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';

                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    // }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="dba_preliminary_charge_transaction" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_dba_preliminary_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteDBAPreliminaryCategoriesChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    // }

                    $html .= '<tr id="view-dba_preliminary_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                             <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetDBAChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = DBAChargeTransaction::select('dba_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon', 'dba_categories.name as name')
                ->join('users', 'users.id', '=', 'dba_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'dba_charge_transaction.coupon_id')
                ->leftJoin('dba_categories', 'dba_categories.id', '=', 'dba_charge_transaction.category_id')
                ->where('dba_charge_transaction.user_id', $user->id)->get();
            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';

                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    // }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="dba_charge_transaction" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_dba_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteDbaChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    // }

                    $html .= '<tr id="view-dba_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                             <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetDBAChecklistsAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = DBAChecklistsUserPlan::select('dba_checklists_user_plan.*', 'users.FullName as user_name')
                ->join('users', 'users.id', '=', 'dba_checklists_user_plan.user_id')
                ->where('dba_checklists_user_plan.user_id', $user->id)->get();
            $x = 1;
            $html = '';
            if (count($result)) {
                $html .= '<ul class="col-lg-12 permissions" style="text-align: center;">';
                foreach ($result as $allData) {
                    $html .= '<li>
                                    <div class="md-checkbox has-success">
                                   
                                        <input name="checklists[]" ' . (($allData->checked == 1) ? 'checked="checked"' : '') . ' type="checkbox" id="checkbox-' . $x . '" value="' . $allData->checklist_id . '" class="md-check">
                                        <label for="checkbox-' . $x . '">
                                            <span class="inc"></span>
                                            <span class="check"></span>
                                            <span class="box"></span> ' . $allData->name . ' </label>
                                    </div>
                                    </li>
                                    ';
                    $x++;
                }
                $html .= '</ul>';

            } else {
                $html = '<label style="text-align: center;">لا توجد بيانات متاحة في الجدول</label>';
            }
        } else {
            $html = '<label style="text-align: center;">لا توجد بيانات متاحة في الجدول</label>';
        }
        return $html;
    }

    public function doeditDBAChecklists($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $dba_checklists_user_plan = DBAChecklistsUserPlan::where('user_id', $user->id)->get();
            if (count((array)$dba_checklists_user_plan)) {
                foreach ($dba_checklists_user_plan as $dba) {
                    $dba->checked = (in_array($dba->checklist_id, ($data['checklists']))) ? 1 : 0;
                    $dba->save();
                }

                if ($dba->save()) {
                    echo 'تم التعديل بنجاح';
                    return;
                }
            } else {
                return abort(404);
            }
        }

    }

    public function doGetNewMbaCategoriesChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();

            $result = NewMbaCategoriesChargeTransaction::select('new_mba_categories_charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon', 'new_mba_categories.name as name')
                ->join('users', 'users.id', '=', 'new_mba_categories_charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'new_mba_categories_charge_transaction.coupon_id')
                ->leftJoin('new_mba_categories', 'new_mba_categories.id', '=', 'new_mba_categories_charge_transaction.category_id')
                ->where('new_mba_categories_charge_transaction.user_id', $user->id)->get();
            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';

                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    // }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="new_mba_categories" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_new_mba_categories_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteNewMbaCategoriesChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    // }

                    $html .= '<tr id="view-new_mba_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                             <td>' . $allData->automation_payment_method . '</td>
                             <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="10">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = ChargeTransaction::select('charge_transaction.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', 'charge_transaction.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', 'charge_transaction.coupon_id')
                ->where('charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    $start_date = '';
                    $end_date = '';
                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    //}
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')) || $allData->end_date == "0000-00-00 00:00:00")) {
                        $extra .= '<button data-id="' . $allData->id . '"  style="margin: 5px;" data-type="normal" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_suspend_charge_button')) {
                        $extra .= '<button data-id="' . $allData->id . '"  style="margin: 5px;" data-type="normal" class="suspendChargeTransaction btn btn-info">' . (($allData->suspend) ? 'Un suspend' : 'Suspend') . '</button>';
                    }
                    if (PerUser('dashboard_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteChargeTransaction btn btn-danger">Delete</button>';
                    }
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    //}
                    if ($allData->start_date == null) {
                        $start_date = '-';
                    } else {
                        $start_date = $allData->start_date;
                    }
                    if ($allData->end_date == null) {
                        $end_date = '-';
                    } else {
                        $end_date = $allData->end_date;
                    }
                    $html .= '<tr id="view-charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $start_date . '</td>
                            <td>' . $end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $allData->automation_payment_method . '</td>
                            <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetConsultantChargesAjax($table, $request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = DB::connection('mysql2')->table($table)->select($table . '.*', 'users.FullName as user_name', 'promotion_code.code as coupon')
                ->join('users', 'users.id', '=', $table . '.user_id')
                ->leftJoin('promotion_code', 'promotion_code.id', '=', $table . '.coupon_id')
                ->where($table . '.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    $start_date = '';
                    $end_date = '';
                    //if( (PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '<td>';
                    //}
                    if ($allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')))) {
                        $extra .= '<button data-id="' . $allData->id . '"  style="margin: 5px;" data-type="' . $table . '" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    $extra .= '<button data-id="' . $allData->id . '"  style="margin: 5px;" data-suspend="' . $allData->suspend . '" data-type="' . $table . '" class="suspendConsultantChargeTransaction btn ' . ($allData->suspend ? 'btn-danger' : 'btn-info') . '">' . (($allData->suspend) ? 'Un suspend' : 'Suspend') . '</button>';
                    $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="' . $table . '" class="deleteConsultantChargeTransaction btn btn-danger">Delete</button>';
                    //if((PerUser('dashboard_active_charge_button') && $allData->pending)){
                    $extra .= '</td>';
                    //}
                    if ($allData->start_date == null) {
                        $start_date = '-';
                    } else {
                        $start_date = $allData->start_date;
                    }
                    if ($allData->end_date == null) {
                        $end_date = '-';
                    } else {
                        $end_date = $allData->end_date;
                    }
                    $html .= '<tr id="view-' . $table . '-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $start_date . '</td>
                            <td>' . $end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>' . $allData->automation_payment_method . '</td>
                            <td>' . $allData->coupon . '</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetInternationalDiplomasChargesAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email = $data['user_email'];
            $user = AcademyUsers::where('Email', $email)->first();
            $result = InternationalDiplomasChargeTransaction::select('international_diplomas_charge_transaction.*', 'users.FullName as user_name')
                ->join('users', 'users.id', '=', 'international_diplomas_charge_transaction.user_id')
                ->where('international_diplomas_charge_transaction.user_id', $user->id)->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData) {
                    $extra = '';
                    if (PerUser('dashboard_open_international_diploma_courses') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '<td>';
                    }
                    if (PerUser('dashboard_open_international_diploma_courses')) {
                        $extra .= '<button data-user-id="' . $user->id . '" style="margin: 5px;" data-diploma-id="' . $allData->diploma_id . '" class="openInternationalDiplomaCourses btn btn-danger">فتح الكورسات للعميل</button>';
                    }
                    if (PerUser('dashboard_active_charge_button') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')))) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" data-type="international_diplomas" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_international_diplomas_charges_delete')) {
                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteInternationalDiplomasChargeTransaction btn btn-danger">Delete</button>';
                    }
                    if (PerUser('dashboard_open_international_diploma_courses') || (PerUser('dashboard_active_charge_button') && $allData->pending)) {
                        $extra .= '</td>';
                    }

                    $html .= '<tr id="view-international_diplomas_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->diploma_name . '</td>
                            <td>' . $allData->diploma_price . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>' .
                        $extra
                        . '</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="8">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doAddUserCourse($email, $course_id)
    {
        if ($email) {
            $result = AcademyUsers::where('Email', '=', $email)->first();
            $result1 = Courses::find($course_id);
            if ($result && $result1) {
                $user = $result;
                $user_id = $user->id;
                $r = DB::connection('mysql2')->select('select * from users_courses_charge_transactions where course_id = ? AND user_id = ?', [$course_id, $user_id]);
                if (count($r)) {
                    echo 'هذا الكورس مضاف من قبل ';
                    return true;
                }
                $date = date('Y-m-d H:i:s');
                $insert_data = ['course_id' => $course_id, 'user_id' => $user_id, 'createtime' => $date];
                $id = DB::connection('mysql2')->table('users_courses_charge_transactions')->insertGetId($insert_data);
                log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'users_courses_charge_transactions', $id, json_encode($insert_data));
                echo 'تم اضافة الكورس بنجاح';
                return true;
            }
        }
    }

//    public function doActiveCoursesUsers($email,$subscribe_country,$period,$amount,$start_date,$subscribe_type,$currency,$employee_id,$partner){
//        if($email){
//            $result=AcademyUsers::where('Email','=',$email)->first();
//            if($result){
//                if(isset($_FILES['attach']['name'])){
//                    if(in_array($_FILES['attach']['type'],['image/jpeg','image/png','image/gif'])){
//                        $path = $_FILES['attach']['name'];
//                        $ext = pathinfo($path, PATHINFO_EXTENSION);
//                        $attach='transactionAttach-'.rand(0,9999).time().'.'.$ext;
//                        move_uploaded_file($_FILES['attach']['tmp_name'],filePath().self::$transactionAttachPath.$attach);
//                    }else{
//                        echo'تأكد من رفع ملف مناسب';
//                        return'';
//                    }
//                }else{
//                    $attach='';
//                }
//                $user=$result;
//                $user_id=$user->id;
//                $chargeResult=DB::connection('mysql2')->select("SELECT * FROM courses_charge_transaction WHERE user_id='$user_id' ORDER BY end_date DESC LIMIT 1");
//                if(count($chargeResult)){
//                    $charge=$chargeResult[0];
//                    $start_date=date('Y-m-d H:i:s',strtotime($charge->end_date."+1 day"));
//                }else{
//                    $start_date=date('Y-m-d H:i:s',strtotime($start_date));
//                }
//
//                $end_date=date('Y-m-d H:i:s',strtotime($start_date."+".$period." months"));
//                $date=date('Y-m-d H:i:s');
//                DB::connection('mysql2')->table('courses_charge_transaction')->insert(
//                    ['user_id' => $user_id, 'period' => $period, 'start_date' => $start_date,'end_date'=>$end_date,'createtime'=>$date,'subscrip_type'=>$subscribe_type,'amount'=>$amount,'subscribe_country'=>$subscribe_country,'currency'=>$currency,'employee_id'=>$employee_id,'attach'=>$attach,'partner'=>$partner]
//                );
//                AcademyUsers::where('id','=',$user_id)->update(['partner' => $partner]);
//
//                echo  'تم اضافة المدة بنجاح';
//                $data=array('Email' => $email,
//                    'subscrip_type' => $subscribe_type,
//                    'expiry_date' =>$end_date,
//                    'last_payment_date' =>$date,
//                    'subscription_period' =>$period,
//                    'courses_start_date' =>$start_date,
//                    'company' =>$partner,
//                );
////                $this->transfertocrm($data);
////                $this->transfertocrm_ksa($data);
////                $this->update_crm_account($data);
////                $this->update_crm_account_ksa($data);
////                /*MLM UPDATE EXPIRED DATE START*/
////                $this->addAcademyChargeTransaction($user_id,$end_date);
//                /*MLM UPDATE EXPIRED DATE END*/
//                $affiliatData=[
//                    'code'=>$user->affiliat_reseller_id,
//                    'product_id'=>$user->affiliat_product_id,
//                    'register_user_id'=>$user->id,
//                    'ip_address'=>$_SERVER['REMOTE_ADDR'],
//                    'email'=>$email
//                ];
//                if ($period>=3) {
//                    //$this->makeProductPaidWithCode($affiliatData);
//                }
//                return true;
//            }
//        }
//    }
//    public function doActiveMedical($request){
//        $params=$request->all();
//        $email = isset($params['email'])?$params['email']:null;
//        $subscribe_country = isset($params['subscribe_country'])?$params['subscribe_country']:null;
//        $period = isset($params['period'])?$params['period']:null;
//        $amount = isset($params['amount'])?$params['amount']:null;
//        $start_date = isset($params['start_date'])?$params['start_date']:null;
//        $subscribe_type = isset($params['subscribe_type'])?$params['subscribe_type']:null;
//        $currency = isset($params['currency'])?$params['currency']:null;
//        $employee_id = isset($params['employee_id'])?$params['employee_id']:null;
//        if($email){
//            $result=AcademyUsers::where('Email','=',$email)->first();
//            if($result){
//                if(isset($_FILES['attach']['name'])){
//                    if(in_array($_FILES['attach']['type'],['image/jpeg','image/png','image/gif'])){
//                        $path = $_FILES['attach']['name'];
//                        $ext = pathinfo($path, PATHINFO_EXTENSION);
//                        $attach='transactionAttach-'.rand(0,9999).time().'.'.$ext;
//                        move_uploaded_file($_FILES['attach']['tmp_name'],filePath().self::$transactionAttachPath.$attach);
//                        }else{
//                        echo'تأكد من رفع ملف مناسب';
//                        return'';
//                    }
//                }else{
//                    $attach='';
//                }
//                $user=$result;
//                $user_id=$user->id;
//                $chargeResult=DB::connection('mysql2')->select("SELECT * FROM medical_charge_transactions WHERE user_id='$user_id' ORDER BY end_date DESC LIMIT 1");
//                if(count($chargeResult)){
//                    $charge=$chargeResult[0];
//                    $start_date=date('Y-m-d H:i:s',strtotime($charge->end_date."+1 day"));
//                }else{
//                    $start_date=date('Y-m-d H:i:s',strtotime($start_date));
//                }
//
//                $end_date=date('Y-m-d H:i:s',strtotime($start_date."+".$period." months"));
//                $date=date('Y-m-d H:i:s');
//
//                $cs_action = isset($params['cs_action'])?$params['cs_action']:null;
//                $agent_id = isset($params['agentid'])?$params['agentid']:null;
//                $agent_name = isset($params['agentname'])?$params['agentname']:null;
//                $agent_fingre_id = isset($params['fingreprint'])?$params['fingreprint']:null;
//                $payment_method = isset($params['payment_method'])?$params['payment_method']:'';
//                $transaction_id=DB::connection('mysql2')->table('medical_charge_transactions')->insertGetId(
//                    ['user_id' => $user_id, 'period' => $period, 'start_date' => $start_date,'end_date'=>$end_date,'createtime'=>$date,'subscrip_type'=>$subscribe_type,'amount'=>$amount,'subscribe_country'=>$subscribe_country,'currency'=>$currency,'employee_id'=>$employee_id,'attach'=>$attach,'agent_id'=>$agent_id,'agent_name'=>$agent_name,'agent_fingre_id'=>$agent_fingre_id,'payment_method'=>$payment_method,'cs_action'=>$cs_action]
//                );
//
//                $r=DB::connection('mysql2')->select("SELECT * FROM medical_charge_transactions_log WHERE user_id='$user_id'");
//
//                if(count($r)){
//                    $log=$r[0];
//                    $log_id=$log->id;
//                    DB::connection('mysql2')->table('medical_charge_transactions_log')->where('id', $log_id)->update(
//                        ['expired_date' => $end_date]
//                    );
//                }else{
//                    DB::connection('mysql2')->table('medical_charge_transactions_log')->insert(
//                        ['user_id' => $user_id, 'expired_date' => $end_date, 'start_date' => $start_date,'createtime' => $date]
//                    );
//                }
//                $data=array('Email' => $email,
//                    'subscrip_type' => $subscribe_type,
//                    'expiry_date' =>$end_date,
//                    'last_payment_date' =>$date,
//                    'subscription_period' =>$period,
//                    'start_date' =>$start_date,
//                );
//                //$this->transfertocrm($data);
//                //$this->transfertocrm_ksa($data);
//                //$this->update_crm_account($data);
//                //$this->update_crm_account_ksa($data);
//                /*START send transaction to service on crm MEDICAL*/
//                //$this->sendMedicalChargeTransaction($transaction_id);
//                /*END send transaction to service on crm MEDICAL*/
//                /*MLM UPDATE EXPIRED DATE START*/
//                //$this->addAcademyChargeTransaction($user_id,$end_date);
//                /*MLM UPDATE EXPIRED DATE END*/
//                echo  'تم اضافة المدة بنجاح';
//                return true;
//            }
//        }
//    }
//
//    public function sendMedicalChargeTransaction($charge_id){
//        $result=DB::connection('mysql2')->select("SELECT medical_charge_transactions.*,users.country AS country,users.Email AS email,users.Mobile AS phone FROM medical_charge_transactions INNER JOIN users ON users.id=medical_charge_transactions.user_id WHERE medical_charge_transactions.id='$charge_id'");
//        foreach ($result as $charge){
//            $this->sendChargeTransactionToCRM($charge->id,'medical transaction',$charge->email,$charge->phone,$charge->subscrip_type,'Medical',$charge->period,$charge->start_date,$charge->end_date,$charge->amount,$charge->createtime);
//        }
//    }

    public function doCheckCorporateCode($request)
    {
        $params = $request->all();
        $user_id = isset($params['user_id']) ? $params['user_id'] : null;
        $corporate_code = isset($params['corporate_code']) ? $params['corporate_code'] : null;
        if ($user_id && $corporate_code) {
            $result = AcademyUsers::find($user_id);
            if ($result) {
                $user = $result;
                $userID = $user->id;
                $result = DB::connection('mysql2')->select("SELECT count(id) AS count FROM corporate_demo WHERE user_id='$userID'");
                if (count($result)) {
                    $count = count($result);
                    //if($count<$user->NumberOfDemo){
                    $date = date('Y-m-d H:i:s');
                    $result = DB::connection('mysql2')->select("SELECT * FROM corporate_demo WHERE code='$corporate_code'");
                    if (count($result)) {
                        $corporate = $result[0];
                        //if($corporate->user_id==0){
                        if ($corporate->expired_date > $date) {
                            $newDate = date('Y-m-d H:i:s', strtotime('+' . $corporate->period . ' Day'));
                            $username = $user->Email;
                            $corporateID = $corporate->id;
                            $charge_date = date('Y-m-d H:i:s');
                            $update_data = ['user_id' => $userID, 'charge_by' => $username, 'charge_from' => 'support', 'charge_date' => $charge_date, 'createdtime' => $charge_date];
                            DB::connection('mysql2')->table('corporate_demo')->where('id', $corporateID)->update($update_data);
                            log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'corporate_demo', $corporateID, json_encode($update_data));
                            AcademyUsers::where('id', '=', $userID)->update(['DemoExpirationDate' => $newDate]);
                            $errorMessage = self::$successActiveCorporateCode;
                            echo view('auth.message.success_message', compact('errorMessage'));
                        } else {
                            $errorMessage = self::$errorCorporateExpired;
                            echo view('auth.message.error_message', compact('errorMessage'));
                        }
                        //}else{
                        //    $errorMessage= self::$errorCorporateUsed;
                        //    include 'views/message/error_message.php';
                        //}
                    } else {
                        $errorMessage = self::$errorCorporateCode;
                        echo view('auth.message.error_message', compact('errorMessage'));
                    }


                    /*}else{

                    }*/
                }
            }
        }

    }

    // Start generate report for user diploma

    public static function calculateSecond($times)
    {
//        global $useridstr;
//        $user_id=self::$sessionhandler2->get($useridstr);
//        $user_id=self::$encryption->decode($user_id);
        //echo'<br><br>';
        $seconds = 0; //declare minutes either it gives Notice: Undefined variable
        // loop throught all the times
        foreach ($times as $time) {
            if (stripos($time, "دقيقية") !== false) {
                switch (strlen(intval($time))) {
                    case 1:
                        $time = '0' . intval($time) . ':00';
                        break;
                    case 2:
                        $time = intval($time) . ':00';
                        break;
                }

                // echo $time;
                // echo'<br><br>';
            } elseif (stripos($time, "دقيقة") !== false) {
                switch (strlen(intval($time))) {
                    case 1:
                        $time = '0' . intval($time) . ':00';
                        break;
                    case 2:
                        $time = intval($time) . ':00';
                        break;
                }
                //echo $time;
                //echo'<br><br>';
            } else {
                //echo $time;
                //echo'<br><br>';
            }

            $hours = 0;
            $minute = 0;
            $second = 0;
            $arr = explode(':', $time);
            if (count($arr) == 3) {
                list($hours, $minute, $second) = explode(':', $time);
            } elseif (count($arr) == 2) {
                list($minute, $second) = explode(':', $time);
            } elseif (count($arr) == 1) {
                list($second) = explode(':', $time);
            }

//            if($user_id==5733){
//                echo count(explode(':', $time));die();
//            }
//            echo $minute.'<br>'.$second;
//            echo'<br>---------------------<br>';
//            echo ($minute*60)+$second;
//            echo'<br>---------------------<br>';
            $seconds += (($hours * 60)) * 60;
            $seconds += ($minute * 60);
            $seconds += $second;
            //echo $seconds;
            //echo'<br>---------------------<br>';
        }
        //echo $seconds;
        $hours = floor(($seconds / 60) / 60);
        $seconds -= ($hours * 60) * 60;
        $minutes = floor($seconds / 60);
        $seconds -= $minutes * 60;
        //echo $seconds;
        //echo'<br><br>';
        // returns the time already formatted
        return sprintf('%02d:%02d:%02d', $hours, $minutes, $seconds);
    }

    /* Start Function That returns course hours */

    public static function getCourseHours($course_id, $user_id)
    {

        $times = CoursesCurriculum::where('course_id', $course_id)->where('type','default')->where('published','yes')->pluck('duration')->toArray();
        $hours_numbers = calculateSecond($times);
        return $hours_numbers;
        $curriculum = array();
        $sections = array();
        // global $useridstr;
        $sections_numbers = 0;
        $hours_numbers = 0;
        $times = [];
//        $user_id=self::$sessionhandler2->get($useridstr);
//        $user_id=self::$encryption->decode($user_id);

//        $query = "select * from courses_sections where course_id=$course_id AND ISNULL(deleted_at) ORDER BY sort ASC";

        $result = DB::connection('mysql2')->select("select * from courses_sections where course_id= '$course_id' AND ISNULL(deleted_at) ORDER BY sort ASC");

        if ($result) {
            foreach ($result as $res) {
                if ($res->type == 'normal') {
                    $sections_numbers++;
                }

                $curriculum = array();
                $section_id = $res->id;

//                $query1 = "SELECT cources_curriculum.*,users_courses_videos.completed
//                                FROM cources_curriculum
//                                LEFT JOIN users_courses_videos
//                                ON users_courses_videos.type_id=cources_curriculum.id
//                                AND users_courses_videos.type='curriculum'
//                                AND user_id='$user_id'
//                                WHERE cources_curriculum.section_id=$section_id
//                                AND ISNULL(cources_curriculum.deleted_at)
//                                ORDER BY sort,id";

                $result1 = DB::connection('mysql2')->select("SELECT cources_curriculum.*,users_courses_videos.completed 
                                FROM cources_curriculum 
                                LEFT JOIN users_courses_videos 
                                ON users_courses_videos.type_id=cources_curriculum.id 
                                AND users_courses_videos.type='curriculum' 
                                AND user_id='$user_id'  
                                WHERE cources_curriculum.section_id='$section_id'
                                AND ISNULL(cources_curriculum.deleted_at) 
                                ORDER BY sort,id");

                //echo $query1;
//                $result1 = self::execquery($query1);
                foreach ($result1 as $res1) {
                    $times[] = $res1->duration;
                    array_push($curriculum, $res1);
                }
                $resources = [];

//                $query3="SELECT * FROM courses_resources WHERE course_id='$course_id' AND section_id='$section_id' AND ISNULL(deleted_at)";

                $result3 = DB::connection('mysql2')->select("SELECT * FROM courses_resources WHERE course_id='$course_id' AND section_id='$section_id' AND ISNULL(deleted_at)");

//                $result3 = self::execquery($query3);

                foreach ($result3 as $res3) {
//                    $res3->file=self::$imagepath.$res3->file;
                    $res3->file = public_path("assets/images/") . $res3->file;
                    $resources[] = $res3;
                }
                //echo$query3;
                $element = array(
                    'id' => $res->id,
                    'name' => $res->name,
                    'curriculum' => $curriculum,
                    'resources' => $resources,
                );
                array_push($sections, $element);
            }
        }
        if ($user_id == 5733) {
            //print_r($times);die();
        }

        $hours_numbers = self::calculateSecond($times, $user_id);
        //echo $hours_numbers;
//        return ['sections'=>$sections,'hours_numbers'=>$hours_numbers,'sections_numbers'=>$sections_numbers] ;
        return $hours_numbers;
    }

    /* End  Function That returns course hours */

    public function doGetUserDiplomaReport($request)
    {

        $reports = [];
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : '';
        $diploma_id = isset($params['diploma_id']) ? $params['diploma_id'] : '';
        $user = AcademyUsers::where('Email', '=', $email)->first();
        if ($user) {
            $user_id = $user->id;
            /*$query="SELECT
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers_2,
answer_2.wrong_answers AS wrong_answers_2,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage_2,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers,
users_curriculum_answers.wrong_answers,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage
FROM(

select
(SELECT
 COUNT(id)
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses.related_course AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT
 id AS answer_id
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses.related_course AND users_curriculum_answers.curriculum_type='exam' LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =diplomas_courses.related_course AND user_id='$user_id') AS certificate_id
 FROM diplomas_courses
LEFT JOIN courses ON courses.id=diplomas_courses.related_course
WHERE diplomas_courses.diploma_id ='$diploma_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";*/

            $query = "SELECT 
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers,
answer_2.wrong_answers AS wrong_answers,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers AS right_answers_2,
users_curriculum_answers.wrong_answers AS wrong_answers_2,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage_2
FROM(

select 
(SELECT 
 COUNT(id) 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses_user_plan.course_id AND diplomas_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT 
 id AS answer_id 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses_user_plan.course_id AND diplomas_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam' ORDER BY right_answers DESC LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =diplomas_courses_user_plan.course_id AND ISNULL(courses_curriculum_certificates.deleted_at) AND courses_curriculum_certificates.user_id='$user_id' AND diplomas_courses_user_plan.user_id='$user_id' LIMIT 1) AS certificate_id
 FROM diplomas_courses_user_plan  
LEFT JOIN courses ON courses.id=diplomas_courses_user_plan.course_id 
WHERE diplomas_courses_user_plan.diploma_id ='$diploma_id' AND diplomas_courses_user_plan.user_id='$user_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id AND ISNULL(courses_curriculum_certificates.deleted_at)
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";
            //echo($query);die();
            $result1 = DB::connection('mysql2')->select(DB::raw($query));

            $reports['diplomas_courses_certificates'] = $result1;
            $reports['user_id'] = $user_id;
            $reports['diploma_id'] = $diploma_id;
        }
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM diplomas_users_courses  INNER JOIN courses  ON courses.id=diplomas_users_courses.course_id  LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=diplomas_users_courses.course_id AND users_course_view_completed.user_id=diplomas_users_courses.user_id WHERE diplomas_users_courses.diploma_id='$diploma_id'  AND diplomas_users_courses.user_id='$user_id' ORDER BY courses.name";
        $result2 = DB::connection('mysql2')->select(DB::raw($query));


        // Start Getdiplomas_users_courses_hours values
        foreach ($result2 as $course_details) {
            $courseId = $course_details->id;
            $reports['diplomas_users_courses_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Getdiplomas_users_courses_hours values

        $reports['diplomas_users_courses'] = $result2;
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM diplomas_courses_user_plan INNER JOIN courses ON courses.id=diplomas_courses_user_plan.course_id LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=diplomas_courses_user_plan.course_id AND users_course_view_completed.user_id=diplomas_courses_user_plan.user_id WHERE diplomas_courses_user_plan.diploma_id='$diploma_id' AND diplomas_courses_user_plan.user_id='$user_id' ORDER BY courses.name";
        $result3 = DB::connection('mysql2')->select(DB::raw($query));
        // Start Get diplomas_courses_user_plan_hours
        foreach ($result3 as $course_details) {
            $courseId = $course_details->id;
            $reports['diplomas_courses_user_plan_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Get diplomas_courses_user_plan_hours

        $reports['diplomas_courses_user_plan'] = $result3;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM diplomas_courses_user_plan WHERE diplomas_courses_user_plan.user_id='$user_id' AND diplomas_courses_user_plan.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql2')->select(DB::raw($query));
        $reports['diplomas_courses_plan_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM diplomas_users_courses WHERE diplomas_users_courses.user_id='$user_id' AND diplomas_users_courses.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql2')->select(DB::raw($query));
        $reports['diplomas_courses_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        return $reports;
    }
    public function doGetUserYottaDiplomaReport($request)
    {

        $reports = [];
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : '';
        $diploma_id = isset($params['diploma_id']) ? $params['diploma_id'] : '';
        $user=new AcademyUsers();
        $user=$user->setConnection('mysql3');
        $user = $user->where('Email', '=', $email)->first();
        if ($user) {
            $user_id = $user->id;
            /*$query="SELECT
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers_2,
answer_2.wrong_answers AS wrong_answers_2,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage_2,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers,
users_curriculum_answers.wrong_answers,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage
FROM(

select
(SELECT
 COUNT(id)
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses.related_course AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT
 id AS answer_id
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses.related_course AND users_curriculum_answers.curriculum_type='exam' LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =diplomas_courses.related_course AND user_id='$user_id') AS certificate_id
 FROM diplomas_courses
LEFT JOIN courses ON courses.id=diplomas_courses.related_course
WHERE diplomas_courses.diploma_id ='$diploma_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";*/

            $query = "SELECT 
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers,
answer_2.wrong_answers AS wrong_answers,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers AS right_answers_2,
users_curriculum_answers.wrong_answers AS wrong_answers_2,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage_2
FROM(

select 
(SELECT 
 COUNT(id) 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=medical_diplomas_courses_user_plan.course_id AND medical_diplomas_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT 
 id AS answer_id 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=medical_diplomas_courses_user_plan.course_id AND medical_diplomas_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam' ORDER BY right_answers DESC LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =medical_diplomas_courses_user_plan.course_id AND ISNULL(courses_curriculum_certificates.deleted_at) AND courses_curriculum_certificates.user_id='$user_id' AND medical_diplomas_courses_user_plan.user_id='$user_id' LIMIT 1) AS certificate_id
 FROM medical_diplomas_courses_user_plan  
LEFT JOIN courses ON courses.id=medical_diplomas_courses_user_plan.course_id 
WHERE medical_diplomas_courses_user_plan.diploma_id ='$diploma_id' AND medical_diplomas_courses_user_plan.user_id='$user_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id AND ISNULL(courses_curriculum_certificates.deleted_at)
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";
            //echo($query);die();
            $result1 = DB::connection('mysql3')->select(DB::raw($query));

            $reports['diplomas_courses_certificates'] = $result1;
            $reports['user_id'] = $user_id;
            $reports['diploma_id'] = $diploma_id;
        }
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM medical_diplomas_users_courses  INNER JOIN courses  ON courses.id=medical_diplomas_users_courses.course_id  LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=medical_diplomas_users_courses.course_id AND users_course_view_completed.user_id=medical_diplomas_users_courses.user_id WHERE medical_diplomas_users_courses.diploma_id='$diploma_id'  AND medical_diplomas_users_courses.user_id='$user_id' ORDER BY courses.name";
        $result2 = DB::connection('mysql3')->select(DB::raw($query));


        // Start Getdiplomas_users_courses_hours values
        foreach ($result2 as $course_details) {
            $courseId = $course_details->id;
            $reports['diplomas_users_courses_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Getdiplomas_users_courses_hours values

        $reports['diplomas_users_courses'] = $result2;
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM medical_diplomas_courses_user_plan INNER JOIN courses ON courses.id=medical_diplomas_courses_user_plan.course_id LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=medical_diplomas_courses_user_plan.course_id AND users_course_view_completed.user_id=medical_diplomas_courses_user_plan.user_id WHERE medical_diplomas_courses_user_plan.diploma_id='$diploma_id' AND medical_diplomas_courses_user_plan.user_id='$user_id' ORDER BY courses.name";
        $result3 = DB::connection('mysql3')->select(DB::raw($query));
        // Start Get diplomas_courses_user_plan_hours
        foreach ($result3 as $course_details) {
            $courseId = $course_details->id;
            $reports['diplomas_courses_user_plan_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Get diplomas_courses_user_plan_hours

        $reports['diplomas_courses_user_plan'] = $result3;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM medical_diplomas_courses_user_plan WHERE medical_diplomas_courses_user_plan.user_id='$user_id' AND medical_diplomas_courses_user_plan.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql3')->select(DB::raw($query));
        $reports['diplomas_courses_plan_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM medical_diplomas_users_courses WHERE medical_diplomas_users_courses.user_id='$user_id' AND medical_diplomas_users_courses.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql3')->select(DB::raw($query));
        $reports['diplomas_courses_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        return $reports;
    }
    public function doGetUserInternationalDiplomaReport($request)
    {

        $reports = [];
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : '';
        $diploma_id = isset($params['diploma_id']) ? $params['diploma_id'] : '';
        $user = AcademyUsers::where('Email', '=', $email)->first();
        if ($user) {
            $user_id = $user->id;
            /*$query="SELECT
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers_2,
answer_2.wrong_answers AS wrong_answers_2,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage_2,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers,
users_curriculum_answers.wrong_answers,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage
FROM(

select
(SELECT
 COUNT(id)
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses.related_course AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT
 id AS answer_id
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=diplomas_courses.related_course AND users_curriculum_answers.curriculum_type='exam' LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =diplomas_courses.related_course AND user_id='$user_id') AS certificate_id
 FROM diplomas_courses
LEFT JOIN courses ON courses.id=diplomas_courses.related_course
WHERE diplomas_courses.diploma_id ='$diploma_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";*/

            $query = "SELECT 
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers,
answer_2.wrong_answers AS wrong_answers,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers AS right_answers_2,
users_curriculum_answers.wrong_answers AS wrong_answers_2,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage_2
FROM(

select 
(SELECT 
 COUNT(id) 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=international_diplomas_courses_user_plan.course_id AND international_diplomas_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT 
 id AS answer_id 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=international_diplomas_courses_user_plan.course_id AND international_diplomas_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam' ORDER BY right_answers DESC LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =international_diplomas_courses_user_plan.course_id AND ISNULL(courses_curriculum_certificates.deleted_at) AND courses_curriculum_certificates.user_id='$user_id' AND international_diplomas_courses_user_plan.user_id='$user_id' LIMIT 1) AS certificate_id
 FROM international_diplomas_courses_user_plan  
LEFT JOIN courses ON courses.id=international_diplomas_courses_user_plan.course_id 
WHERE international_diplomas_courses_user_plan.diploma_id ='$diploma_id' AND international_diplomas_courses_user_plan.user_id='$user_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id AND ISNULL(courses_curriculum_certificates.deleted_at)
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";
            //echo($query);die();
            $result1 = DB::connection('mysql2')->select(DB::raw($query));

            $reports['diplomas_courses_certificates'] = $result1;
            $reports['user_id'] = $user_id;
            $reports['diploma_id'] = $diploma_id;
        }
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM international_diplomas_users_courses  INNER JOIN courses  ON courses.id=international_diplomas_users_courses.course_id  LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=international_diplomas_users_courses.course_id AND users_course_view_completed.user_id=international_diplomas_users_courses.user_id WHERE international_diplomas_users_courses.diploma_id='$diploma_id'  AND international_diplomas_users_courses.user_id='$user_id' ORDER BY courses.name";
        $result2 = DB::connection('mysql2')->select(DB::raw($query));


        // Start Getdiplomas_users_courses_hours values
        foreach ($result2 as $course_details) {
            $courseId = $course_details->id;
            $reports['diplomas_users_courses_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Getdiplomas_users_courses_hours values

        $reports['diplomas_users_courses'] = $result2;
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM international_diplomas_courses_user_plan INNER JOIN courses ON courses.id=international_diplomas_courses_user_plan.course_id LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=international_diplomas_courses_user_plan.course_id AND users_course_view_completed.user_id=international_diplomas_courses_user_plan.user_id WHERE international_diplomas_courses_user_plan.diploma_id='$diploma_id' AND international_diplomas_courses_user_plan.user_id='$user_id' ORDER BY courses.name";
        $result3 = DB::connection('mysql2')->select(DB::raw($query));
        // Start Get diplomas_courses_user_plan_hours
        foreach ($result3 as $course_details) {
            $courseId = $course_details->id;
            $reports['diplomas_courses_user_plan_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Get diplomas_courses_user_plan_hours

        $reports['diplomas_courses_user_plan'] = $result3;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM international_diplomas_courses_user_plan WHERE international_diplomas_courses_user_plan.user_id='$user_id' AND international_diplomas_courses_user_plan.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql2')->select(DB::raw($query));
        $reports['diplomas_courses_plan_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM international_diplomas_users_courses WHERE international_diplomas_users_courses.user_id='$user_id' AND international_diplomas_users_courses.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql2')->select(DB::raw($query));
        $reports['diplomas_courses_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        return $reports;
    }

    public function doGetUserTrainingProgramReport($request)
    {

        $reports = [];
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : '';
        $diploma_id = isset($params['diploma_id']) ? $params['diploma_id'] : '';
        $user = AcademyUsers::where('Email', '=', $email)->first();
        if ($user) {
            $user_id = $user->id;
            /*$query="SELECT
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers_2,
answer_2.wrong_answers AS wrong_answers_2,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage_2,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers,
users_curriculum_answers.wrong_answers,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage
FROM(

select
(SELECT
 COUNT(id)
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=training_program_courses.related_course AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT
 id AS answer_id
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=training_program_courses.related_course AND users_curriculum_answers.curriculum_type='exam' LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =training_program_courses.related_course AND user_id='$user_id') AS certificate_id
 FROM training_program_courses
LEFT JOIN courses ON courses.id=training_program_courses.related_course
WHERE training_program_courses.diploma_id ='$diploma_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";*/

            $query = "SELECT 
`data`.*,
answer_2.createdtime AS add_date,
answer_2.right_answers AS right_answers,
answer_2.wrong_answers AS wrong_answers,
(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage,

courses_curriculum_certificates.serial_number,
users_curriculum_answers.quetions_numbers,
users_curriculum_answers.right_answers AS right_answers_2,
users_curriculum_answers.wrong_answers AS wrong_answers_2,
(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage_2
FROM(

select 
(SELECT 
 COUNT(id) 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=training_program_courses_user_plan.course_id AND training_program_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam') AS count_id,
(SELECT 
 id AS answer_id 
FROM users_curriculum_answers WHERE users_curriculum_answers.user_id='$user_id' AND users_curriculum_answers.course_id=training_program_courses_user_plan.course_id AND training_program_courses_user_plan.user_id='$user_id' AND users_curriculum_answers.curriculum_type='exam' ORDER BY right_answers DESC LIMIT 1) AS user_exam,
courses.id AS course_id,
courses.name AS course_name,
(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =training_program_courses_user_plan.course_id AND ISNULL(courses_curriculum_certificates.deleted_at) AND courses_curriculum_certificates.user_id='$user_id' AND training_program_courses_user_plan.user_id='$user_id' LIMIT 1) AS certificate_id
 FROM training_program_courses_user_plan  
LEFT JOIN courses ON courses.id=training_program_courses_user_plan.course_id 
WHERE training_program_courses_user_plan.diploma_id ='$diploma_id' AND training_program_courses_user_plan.user_id='$user_id'
) AS data
 LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id AND ISNULL(courses_curriculum_certificates.deleted_at)
LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam";
            //echo($query);die();
            $result1 = DB::connection('mysql2')->select(DB::raw($query));

            $reports['training_program_courses_certificates'] = $result1;
            $reports['user_id'] = $user_id;
            $reports['diploma_id'] = $diploma_id;
        }
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM training_program_users_courses  INNER JOIN courses  ON courses.id=training_program_users_courses.course_id  LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=training_program_users_courses.course_id AND users_course_view_completed.user_id=training_program_users_courses.user_id WHERE training_program_users_courses.diploma_id='$diploma_id'  AND training_program_users_courses.user_id='$user_id' ORDER BY courses.name";
        $result2 = DB::connection('mysql2')->select(DB::raw($query));


        // Start Getdiplomas_users_courses_hours values
        foreach ($result2 as $course_details) {
            $courseId = $course_details->id;
            $reports['diplomas_users_courses_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Getdiplomas_users_courses_hours values

        $reports['diplomas_users_courses'] = $result2;
        $query = "SELECT courses.id,courses.name,IF(users_course_view_completed.total,((users_course_view_completed.completed/users_course_view_completed.total)*100),0) AS percentage  FROM training_program_courses_user_plan INNER JOIN courses ON courses.id=training_program_courses_user_plan.course_id LEFT JOIN users_course_view_completed ON users_course_view_completed.course_id=training_program_courses_user_plan.course_id AND users_course_view_completed.user_id=training_program_courses_user_plan.user_id WHERE training_program_courses_user_plan.diploma_id='$diploma_id' AND training_program_courses_user_plan.user_id='$user_id' ORDER BY courses.name";
        $result3 = DB::connection('mysql2')->select(DB::raw($query));
        // Start Get training_program_courses_user_plan_hours
        foreach ($result3 as $course_details) {
            $courseId = $course_details->id;
            $reports['training_program_courses_user_plan_hours'][] = self::getCourseHours($courseId, $user_id);
        }
        // end Get training_program_courses_user_plan_hours

        $reports['training_program_courses_user_plan'] = $result3;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM training_program_courses_user_plan WHERE training_program_courses_user_plan.user_id='$user_id' AND training_program_courses_user_plan.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql2')->select(DB::raw($query));
        $reports['training_program_courses_plan_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        $query = "SELECT IF(SUM(users_course_view_completed.total),((SUM(users_course_view_completed.completed)/SUM(users_course_view_completed.total))*100),0) AS percentage FROM `users_course_view_completed` WHERE course_id IN(SELECT course_id FROM diplomas_users_courses WHERE diplomas_users_courses.user_id='$user_id' AND diplomas_users_courses.diploma_id='$diploma_id') AND user_id='$user_id'";
        $diploma_completed = DB::connection('mysql2')->select(DB::raw($query));
        $reports['training_program_courses_percentage'] = ($diploma_completed) ? $diploma_completed[0]->percentage : 0;
        return $reports;
    }

    // End generate report for user diploma

    public function doGenerateInternationalDiplomaCertificate($request)
    {
        return'';
        $params = $request->all();
        $diploma_id = isset($params['diploma_id']) ? $params['diploma_id'] : '';
        $user_id = isset($params['user_id']) ? $params['user_id'] : '';
        $result = DB::connection('mysql2')->select("select users.FullName AS user_name,users.name_en,international_diplomas.code,international_diplomas_charge_transaction.diploma_id,international_diplomas_charge_transaction.user_id from international_diplomas_charge_transaction INNER JOIN users ON users.id=international_diplomas_charge_transaction.user_id INNER JOIN international_diplomas ON international_diplomas.id=international_diplomas_charge_transaction.diploma_id where diploma_id=$diploma_id and user_id=$user_id");
        if (count($result)) {
            $data = $result[0];
//            $diploma_id=$data->diploma_id;
//            $user_id=$data->user_id;
            $user_name = $data->user_name;
            $user_name_en = $data->name_en;
            $code = $data->code;
            //$query="select related_course FROM diplomas_courses WHERE diploma_id ='$diploma_id'";
            $resultCourse = DB::connection('mysql2')->select("select course_id FROM international_diplomas_courses_user_plan WHERE diploma_id ='$diploma_id' AND user_id='$user_id'");
            $makeCertificate = true;
            $user = AcademyUsers::select('country')->where('id', '=', $user_id)->first();
            foreach ($resultCourse as $courses) {
                //$course_id=$courses->related_course;
                $course_id = $courses->course_id;
                if (!($user->country == 191 && $course_id == 8)) {
                    if (in_array($diploma_id, [53, 54, 49]) && in_array($course_id, [/*53*/ 119, 69/*53*/,/*54*/ 85, 89/*54*/,/*49*/ 80, 164/*49*/])) {
                        if ($diploma_id == 53 && in_array($course_id, [119, 69])) {
                            $result1 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='119' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            $result2 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='69' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($result1) && count($result2)) {
                                $makeCertificate = false;
                            }
                        } elseif ($diploma_id == 54 && in_array($course_id, [85, 89])) {
                            $result1 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='85' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            $result2 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='89' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($result1) && count($result2)) {
                                $makeCertificate = false;
                            }
                        } elseif ($diploma_id == 49 && in_array($course_id, [80, 164])) {
                            $result1 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='80' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            $result2 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='164' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($result1) && count($result2)) {
                                $makeCertificate = false;
                            }
                        }
                    } else {
                        if ($course_id) {
                            $resultCertificate = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='$course_id' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($resultCertificate) == 0) {
                                $makeCertificate = false;
                                break;
                            }
                        }
                    }

                }
            }
            if ($makeCertificate) {
//                echo '$user_id=>'.$user_id.'<br>';
//                echo '$diploma_id=>'.$diploma_id.'<br>';
//                echo 'has diploma certificate<br>';
                $diplomaCertificateResult = DB::connection('mysql2')->select("SELECT * FROM diploma_certificates WHERE diploma_id='$diploma_id' AND user_id='$user_id' AND ISNULL(diploma_certificates.deleted_at)");
                if (count($diplomaCertificateResult) == 0) {
                    $session_id = 0;
                    $serial_number = $this->generateDiplomaSerialNumber($diploma_id);
//                    echo $serial_number.'<br>';
                    $date = date('Y-m-d H:i:s');
                    DB::connection('mysql2')->table('diploma_certificates')->insert(
                        ['serial_number' => $serial_number, 'diploma_id' => $diploma_id, 'user_id' => $user_id, 'user_name' => $user_name, 'user_name_en' => $user_name_en, 'session_user_id' => $session_id, 'createdtime' => $date]
                    );
                    $errorMessage = 'Certificate generated successfully';
                    echo view('auth.message.success_message', compact('errorMessage'));
                    return;
                } else {
                    $errorMessage = 'Certificate has already generated';
                    echo view('auth.message.error_message', compact('errorMessage'));
                    return;
                }
//                echo'<br><br>======================================================================<br><br>';
            } else {
                $errorMessage = 'Faild to generate certificate';
                echo view('auth.message.error_message', compact('errorMessage'));
                return;
            }
//            $query="select GROUP_CONCAT(related_course) AS courses_ids,COUNT(related_course) AS count_ids FROM diplomas_courses WHERE diploma_id ='$diploma_id'";
//            $resultCourse=self::execquery($query);
//            $courses=$resultCourse->fetch_object();
//            $courses_ids=$courses->courses_ids;
//            $count_ids=$courses->count_ids;
//            $query="SELECT COUNT(id) AS count FROM courses_curriculum_certificates WHERE course_id IN ($courses_ids) AND user_id=$user_id";
//            $resultCertificate=self::execquery($query);
//            $certificate=$resultCertificate->fetch_object();
//            if($certificate->count==$count_ids){
//                echo '$user_id=>'.$user_id.'<br>';
//                echo '$diploma_id=>'.$diploma_id.'<br>';
//                echo '$courses_ids=>'.$courses_ids.'<br>';
//                echo '$count_ids=>'.$count_ids.'<br>';
//
//                echo 'has diploma certificate<br>';
//                $query="SELECT * FROM diploma_certificates WHERE diploma_id='$diploma_id' AND user_id='$user_id'";
//                $diplomaCertificateResult=self::execquery($query);
//                if($diplomaCertificateResult->num_rows==0){
//                    $session_id=$_COOKIE[self::$cookieID];
//                    $serial_number=self::generateDiplomaSerialNumber($diploma_id);
//                    echo $serial_number.'<br>';
//                    $date=date('Y-m-d H:i:s');
//                   /* $query="INSERT INTO diploma_certificates (serial_number,diploma_id,user_id,user_name,session_user_id,createdtime) VALUES ('$serial_number','$diploma_id','$user_id','$user_name','$session_id','$date')";
//                    self::execquery($query);*/
//                    echo '<br>has add diploma certificate<br>';
//                }
//                echo'<br><br>======================================================================<br><br>';
//            }
        }
    }
    public function doGenerateDiplomaCertificate($request)
    {
        $params = $request->all();
        $diploma_id = isset($params['diploma_id']) ? $params['diploma_id'] : '';
        $user_id = isset($params['user_id']) ? $params['user_id'] : '';
        $result = DB::connection('mysql2')->select("select users.FullName AS user_name,users.name_en,diplomas.code,diplomas_charge_transaction.diploma_id,diplomas_charge_transaction.user_id from diplomas_charge_transaction INNER JOIN users ON users.id=diplomas_charge_transaction.user_id INNER JOIN diplomas ON diplomas.id=diplomas_charge_transaction.diploma_id where diploma_id=$diploma_id and user_id=$user_id");
        if (count($result)) {
            $data = $result[0];
//            $diploma_id=$data->diploma_id;
//            $user_id=$data->user_id;
            $user_name = $data->user_name;
            $user_name_en = $data->name_en;
            $code = $data->code;
            //$query="select related_course FROM diplomas_courses WHERE diploma_id ='$diploma_id'";
            $resultCourse = DB::connection('mysql2')->select("select course_id FROM diplomas_courses_user_plan WHERE diploma_id ='$diploma_id' AND user_id='$user_id'");
            $makeCertificate = true;
            $user = AcademyUsers::select('country')->where('id', '=', $user_id)->first();
            foreach ($resultCourse as $courses) {
                //$course_id=$courses->related_course;
                $course_id = $courses->course_id;
                if (!($user->country == 191 && $course_id == 8)) {
                    if (in_array($diploma_id, [53, 54, 49]) && in_array($course_id, [/*53*/ 119, 69/*53*/,/*54*/ 85, 89/*54*/,/*49*/ 80, 164/*49*/])) {
                        if ($diploma_id == 53 && in_array($course_id, [119, 69])) {
                            $result1 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='119' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            $result2 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='69' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($result1) && count($result2)) {
                                $makeCertificate = false;
                            }
                        } elseif ($diploma_id == 54 && in_array($course_id, [85, 89])) {
                            $result1 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='85' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            $result2 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='89' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($result1) && count($result2)) {
                                $makeCertificate = false;
                            }
                        } elseif ($diploma_id == 49 && in_array($course_id, [80, 164])) {
                            $result1 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='80' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            $result2 = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='164' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($result1) && count($result2)) {
                                $makeCertificate = false;
                            }
                        }
                    } else {
                        if ($course_id) {
                            $resultCertificate = DB::connection('mysql2')->select("SELECT id FROM courses_curriculum_certificates WHERE course_id ='$course_id' AND user_id='$user_id' AND ISNULL(deleted_at)");
                            if (count($resultCertificate) == 0) {
                                $makeCertificate = false;
                                break;
                            }
                        }
                    }

                }
            }
            if ($makeCertificate) {
//                echo '$user_id=>'.$user_id.'<br>';
//                echo '$diploma_id=>'.$diploma_id.'<br>';
//                echo 'has diploma certificate<br>';
                $diplomaCertificateResult = DB::connection('mysql2')->select("SELECT * FROM diploma_certificates WHERE diploma_id='$diploma_id' AND user_id='$user_id' AND ISNULL(diploma_certificates.deleted_at)");
                if (count($diplomaCertificateResult) == 0) {
                    $session_id = 0;
                    $serial_number = $this->generateDiplomaSerialNumber($diploma_id);
//                    echo $serial_number.'<br>';
                    $date = date('Y-m-d H:i:s');
                    DB::connection('mysql2')->table('diploma_certificates')->insert(
                        ['serial_number' => $serial_number, 'diploma_id' => $diploma_id, 'user_id' => $user_id, 'user_name' => $user_name, 'user_name_en' => $user_name_en, 'session_user_id' => $session_id, 'createdtime' => $date]
                    );
                    $errorMessage = 'Certificate generated successfully';
                    echo view('auth.message.success_message', compact('errorMessage'));
                    return;
                } else {
                    $errorMessage = 'Certificate has already generated';
                    echo view('auth.message.error_message', compact('errorMessage'));
                    return;
                }
//                echo'<br><br>======================================================================<br><br>';
            } else {
                $errorMessage = 'Faild to generate certificate';
                echo view('auth.message.error_message', compact('errorMessage'));
                return;
            }
//            $query="select GROUP_CONCAT(related_course) AS courses_ids,COUNT(related_course) AS count_ids FROM diplomas_courses WHERE diploma_id ='$diploma_id'";
//            $resultCourse=self::execquery($query);
//            $courses=$resultCourse->fetch_object();
//            $courses_ids=$courses->courses_ids;
//            $count_ids=$courses->count_ids;
//            $query="SELECT COUNT(id) AS count FROM courses_curriculum_certificates WHERE course_id IN ($courses_ids) AND user_id=$user_id";
//            $resultCertificate=self::execquery($query);
//            $certificate=$resultCertificate->fetch_object();
//            if($certificate->count==$count_ids){
//                echo '$user_id=>'.$user_id.'<br>';
//                echo '$diploma_id=>'.$diploma_id.'<br>';
//                echo '$courses_ids=>'.$courses_ids.'<br>';
//                echo '$count_ids=>'.$count_ids.'<br>';
//
//                echo 'has diploma certificate<br>';
//                $query="SELECT * FROM diploma_certificates WHERE diploma_id='$diploma_id' AND user_id='$user_id'";
//                $diplomaCertificateResult=self::execquery($query);
//                if($diplomaCertificateResult->num_rows==0){
//                    $session_id=$_COOKIE[self::$cookieID];
//                    $serial_number=self::generateDiplomaSerialNumber($diploma_id);
//                    echo $serial_number.'<br>';
//                    $date=date('Y-m-d H:i:s');
//                   /* $query="INSERT INTO diploma_certificates (serial_number,diploma_id,user_id,user_name,session_user_id,createdtime) VALUES ('$serial_number','$diploma_id','$user_id','$user_name','$session_id','$date')";
//                    self::execquery($query);*/
//                    echo '<br>has add diploma certificate<br>';
//                }
//                echo'<br><br>======================================================================<br><br>';
//            }
        }
    }

    public function generateDiplomaSerialNumber($diploma_id)
    {
        Diplomas::where('id', $diploma_id)
            ->update(['certificate_increment' => DB::raw('certificate_increment+1')]);
        $data = Diplomas::where('id', '=', $diploma_id)->first();
        if ($data) {
            switch (strlen($data->certificate_increment)) {
                case 1:
                    return strtoupper($data->code) . '000' . $data->certificate_increment;
                    break;
                case 2:
                    return strtoupper($data->code) . '00' . $data->certificate_increment;
                    break;
                case 3:
                    return strtoupper($data->code) . '0' . $data->certificate_increment;
                    break;
                case 4:
                    return strtoupper($data->code) . $data->certificate_increment;
                    break;
            }
        }
    }

    public function doGetAgents($request)
    {
        $allData = [];
        $data1 = [];
        $data2 = [];
        header('Content-Type: application/json');
        $params = $request->all();
        $country_id = isset($params['country_id']) ? $params['country_id'] : '';
        //$url=($country_id==64)?'https://crmegy.e3melbusiness.com/webservice/get_agents.php':'https://ksanew.almoasherbiz.com/webservice/get_agents.php';
        $url = 'https://crmegy.e3melbusiness.com/webservice/get_agents.php';
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "country_id=$country_id",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $data1 = json_decode($response);
        }
        $url = 'https://ksanew.almoasherbiz.com/webservice/get_agents.php';
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => "country_id=$country_id",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $data2 = json_decode($response);
        }
        $allDataMerge = array_merge($data1, $data2);
        $dataAgentName = [];
        $dataFingerPrintIDs = [];
        foreach ($allDataMerge as $d) {
            if (!in_array($d->agent_name, $dataAgentName) && (!in_array($d->finger_print_id, $dataFingerPrintIDs) || $d->finger_print_id != '')) {
                $allData[] = $d;
            }
            $dataAgentName[] = $d->agent_name;
            if ($d->finger_print_id != '') {
                $dataFingerPrintIDs[] = $d->finger_print_id;
            }

        }
        //echo  count($allDataMerge).'<br>';
        //print_r($allDataMerge);
        //echo  count($allData).'<br>';
        echo json_encode($allData);
    }

    public function doBlockedUserSessionsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $sessionUsers = SessionUsers::where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->orderBy('deleted_at')->get();
        $html = '';
        if (count($sessionUsers)) {
            $x = 1;
            foreach ($sessionUsers as $sessionUser) {
                $html .= '<tr>         
                            <td>' . $sessionUser->id . '</td>
                            <td>' . $sessionUser->ip_address . '</td>
                            <td>' . $sessionUser->deleted_at . '</td>
                            <td>' . $sessionUser->modifiedtime . '</td>
                            <td>' . $sessionUser->createdtime . '</td>
                            ' . ((PerUser('blocked_user_sessions_delete')) ? '<td>' . ((!$sessionUser->deleted_at) ? '<button data-id="' . $sessionUser->id . '" class="removeSession btn btn-danger">Delete</button>' : '') . '</td>' : '') . '
                         </tr>';
                $x++;
            }
        } else {
            $html = '<tr><td colspan="' . (PerUser('blocked_user_sessions_delete') ? '6' : '5') . '">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doYottaBlockedUserSessionsAjax($request)
    {
        $params=$request->all();
        $email = isset($params['email'])?$params['email']:null;
        $sessionUsers=new SessionUsers();
        $sessionUsers=$sessionUsers->setConnection('mysql3');
        $sessionUsers=$sessionUsers->where('user_id',DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->orderBy('deleted_at')->get();
        $html='';
        if(count($sessionUsers)){
            $x=1;
            foreach ($sessionUsers as $sessionUser){
                $html.='<tr>         
                            <td>'.$sessionUser->id.'</td>
                            <td>'.$sessionUser->ip_address.'</td>
                            <td>'.$sessionUser->deleted_at.'</td>
                            <td>'.$sessionUser->modifiedtime.'</td>
                            <td>'.$sessionUser->createdtime.'</td>
                            '.((PerUser('blocked_user_sessions_delete'))?'<td>'.((!$sessionUser->deleted_at)?'<button data-id="'.$sessionUser->id.'" class="removeSession btn btn-danger">Delete</button>':'').'</td>':'').'
                         </tr>';
                $x++;
            }
        }else{
            $html='<tr><td colspan="'.(PerUser('blocked_user_sessions_delete')?'6':'5').'">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doBlockedUserHistoryAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $sessionUsers = UsersBlockHis::where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->get();
        $html = '';
        if (count($sessionUsers)) {
            $x = 1;
            foreach ($sessionUsers as $sessionUser) {
                $html .= '<tr>         
                            <td>' . $sessionUser->id . '</td>
                            <td>' . $sessionUser->block_number . '</td>
                            <td>' . $sessionUser->block_date . '</td>
                         </tr>';
                $x++;
            }
        } else {
            $html = '<tr><td colspan="3">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doYotaBlockedUserHistoryAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $sessionUsers=new UsersBlockHis();
        $sessionUsers=$sessionUsers->setConnection('mysql3');
        $sessionUsers = $sessionUsers->where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->get();
        $html = '';
        if (count($sessionUsers)) {
            $x = 1;
            foreach ($sessionUsers as $sessionUser) {
                $html .= '<tr>         
                            <td>' . $sessionUser->id . '</td>
                            <td>' . $sessionUser->block_number . '</td>
                            <td>' . $sessionUser->block_date . '</td>
                         </tr>';
                $x++;
            }
        } else {
            $html = '<tr><td colspan="3">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function addCourseException($user_id, $course_id, $note)
    {
        $exception = new CoursesUsersExceptions();
        $exception->user_id = $user_id;
        $exception->course_id = $course_id;
        $exception->note = $note;
        if ($exception->save()) {
            log_user_action(Auth::user()->id, Auth::user()->username, 'insert', 'courses_users_exceptions', $exception->id, json_encode($exception));
        }
    }

    private function check_company_user_charge($user_id)
    {
        $query = "SELECT 
        (SELECT COUNT(id) FROM companies_charge_transaction WHERE user_id='$user_id') AS has_charge,
        (SELECT GROUP_CONCAT(DISTINCT diplomas.name,'') FROM diplomas_companies_charge_transaction INNER JOIN diplomas ON diplomas.id=diplomas_companies_charge_transaction.diploma_id WHERE user_id='$user_id') AS diplomas,
        (SELECT COUNT(id) FROM  lite_version_companies_charge_transaction WHERE user_id='$user_id') AS has_lite_version,
        (SELECT COUNT(id) FROM  mba_companies_charge_transaction WHERE user_id='$user_id') AS has_mba";
        $resultCharges = DB::connection('mysql2')->select($query)[0];
        echo '<div class="charge-t col-lg-12">';
        if ($resultCharges->has_charge) {
            echo '<span class="charge-label label label-success">Charge Transaction</span>';
        }
        if ($resultCharges->diplomas) {
            foreach (explode(',', rtrim($resultCharges->diplomas, ',')) as $item) {
                echo '<span class="charge-label label label-success">' . $item . '</span>';
            }
        }
        if ($resultCharges->has_lite_version) {
            echo '<span class="charge-label label label-success">Lite Version</span>';
        }
        if ($resultCharges->has_mba) {
            echo '<span class="charge-label label label-success">MBA</span>';
        }
        echo '</div>';
    }

    public function doGiftCourseChargeTransactionsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $charge_transactions = GiftCourseChargeTransactions::
        select('gift_course_charge_transactions.*', 'courses.name AS course_name')
            ->leftJoin('courses', 'courses.id', '=', 'gift_course_charge_transactions.course_id')
            ->where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->orderBy('id', 'DESC')->get();
        $html = '';
        if (count($charge_transactions)) {
            $x = 1;
            foreach ($charge_transactions as $transaction) {
                $extra = '';
                if (PerUser('dashboard_active_charge_button') && $transaction->pending && (!$transaction->end_date || ($transaction->end_date > date('Y-m-d H:i:s')))) {
                    $extra .= '<button data-id="' . $transaction->id . '" data-type="gift_course"  class="activeChargeBtn btn btn-info">active</button>';
                }
                if (PerUser('dashboard_gift_course_charge_delete')) {

                    $extra .= '<button data-id="' . $transaction->id . '" style="margin: 5px;" class="deleteGiftCourseChargeTransaction btn btn-danger">Delete</button>';
                }
                $html .= '<tr id="view-gift_course_charge_transactions-' . $transaction->id . '">         
                            <td>' . $transaction->id . '</td>
                            <td>' . $transaction->course_name . '</td>
                            <td>' . $transaction->start_date . '</td>
                            <td>' . $transaction->end_date . '</td>
                            <td>' . (($transaction->suspend == 0) ? '<button class="suspendGiftCourseCharge btn btn-success" data-id="' . $transaction->id . '">Suspend</button>' : '<button class="unSuspendGiftCourseCharge btn btn-success" data-id="' . $transaction->id . '">Un Suspend</button>') . $extra . '</td>
                         </tr>';
                $x++;
            }
        } else {
            $html = '<tr><td colspan="3">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doFreeCourseChargeTransactionsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $charge_transactions = FreeCourseChargeTransactions::
        select('free_course_charge_transactions.*', 'courses.name AS course_name')
            ->leftJoin('courses', 'courses.id', '=', 'free_course_charge_transactions.course_id')
            ->where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->orderBy('id', 'DESC')->get();
        $html = '';
        if (count($charge_transactions)) {
            $x = 1;
            foreach ($charge_transactions as $transaction) {
//                $extra = '';
//                if (PerUser('dashboard_active_charge_button') && $transaction->pending && (!$transaction->end_date || ($transaction->end_date > date('Y-m-d H:i:s')))) {
//                    $extra .= '<button data-id="' . $transaction->id . '" data-type="gift_course"  class="activeChargeBtn btn btn-info">active</button>';
//                }
//                if (PerUser('dashboard_free_course_charge_delete')) {
//
//                    $extra .= '<button data-id="' . $transaction->id . '" style="margin: 5px;" class="deleteFreeCourseChargeTransaction btn btn-danger">Delete</button>';
//                }
                $html .= '<tr id="view-free_course_charge_transactions-' . $transaction->id . '">         
                            <td>' . $transaction->id . '</td>
                            <td>' . $transaction->course_name . '</td>
                            <td>' . $transaction->start_date . '</td>
                            <td>' . $transaction->end_date . '</td>
                            
                         </tr>';
//                <td>' . (($transaction->suspend == 0) ? '<button class="suspendGiftCourseCharge btn btn-success" data-id="' . $transaction->id . '">Suspend</button>' : '<button class="unSuspendGiftCourseCharge btn btn-success" data-id="' . $transaction->id . '">Un Suspend</button>') . $extra . '</td>
                $x++;
            }
        } else {
            $html = '<tr><td colspan="3">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGiftBookChargeTransactionsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $charge_transactions = GiftBookChargeTransactions::
        select('books_charge_transaction.*', 'books.title AS book_title')
            ->leftJoin('books', 'books.id', '=', 'books_charge_transaction.book_id')
            ->where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->orderBy('id', 'DESC')->get();
        $html = '';
        if (count($charge_transactions)) {
            $x = 1;
            foreach ($charge_transactions as $transaction) {
                $extra = '';
                if (PerUser('dashboard_active_charge_button') && $transaction->pending && (!$transaction->end_date || ($transaction->end_date > date('Y-m-d H:i:s')))) {
                    $extra .= '<button data-id="' . $transaction->id . '" data-type="gift_book"  class="activeChargeBtn btn btn-info">active</button>';
                }
                if (PerUser('dashboard_gift_book_charge_delete')) {

                    $extra .= '<button data-id="' . $transaction->id . '" style="margin: 5px;" class="deleteGiftBookChargeTransaction btn btn-danger">Delete</button>';
                }
                $html .= '<tr id="view-books_charge_transaction-' . $transaction->id . '">
                            <td>' . $transaction->id . '</td>
                            <td>' . $transaction->book_title . '</td>
                            <td>' . $transaction->start_date . '</td>
                            <td>' . $transaction->end_date . '</td>
                            <td>' . (($transaction->suspend == 0) ? '<button class="suspendGiftBookCharge btn btn-success" data-id="' . $transaction->id . '">Suspend</button>' : '<button class="unSuspendGiftBookCharge btn btn-success" data-id="' . $transaction->id . '">Un Suspend</button>') . $extra . '</td>
                         </tr>';
                $x++;
            }
        } else {
            $html = '<tr><td colspan="3">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doMedicalChargeTransactionsAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $charge_transactions = MedicalChargeTransactions::where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->orderBy('id', 'DESC')->get();
        $html = '';
        if (count($charge_transactions)) {
            $x = 1;
            foreach ($charge_transactions as $transaction) {
                $extra = '';
                if (PerUser('dashboard_active_charge_button') && $transaction->pending && (!$transaction->end_date || ($transaction->end_date > date('Y-m-d H:i:s')))) {
                    $extra .= '<button data-id="' . $transaction->id . '" data-type="medical"  class="activeChargeBtn btn btn-info">active</button>';
                }
                $html .= '<tr>         
                            <td>' . $transaction->id . '</td>
                            <td>' . $transaction->start_date . '</td>
                            <td>' . $transaction->end_date . '</td>
                            <td>' . (($transaction->suspend == 0) ? '<button class="suspendMedicalCharge btn btn-success" data-id="' . $transaction->id . '">Suspend</button>' : '<button class="unSuspendMedicalCharge btn btn-success" data-id="' . $transaction->id . '">Un Suspend</button>') . $extra . '</td>
                         </tr>';
                $x++;
            }
        } else {
            $html = '<tr><td colspan="3">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doRenewalDiplomassAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $charge_transactions = DiplomasChargeTransaction::where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->join('diplomas', 'diplomas.id', '=', 'diploma_id')->groupBy('diplomas.name', 'diplomas.id')->pluck('diplomas.name', 'diplomas.id')->toArray();
        $html = '<option value="">الدبلومة</option>';
        if (count($charge_transactions)) {
            foreach ($charge_transactions as $id => $name) {
                $html .= '<option value="' . $id . '">' . $name . '</option>';
            }
        }
        return $html;
    }
    public function doRenewalInternationalDiplomassAjax($request)
    {
        $params = $request->all();
        $email = isset($params['email']) ? $params['email'] : null;
        $charge_transactions = InternationalDiplomasChargeTransaction::where('user_id', DB::raw("(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1)"))->join('international_diplomas', 'international_diplomas.id', '=', 'diploma_id')->groupBy('international_diplomas.name', 'international_diplomas.id')->pluck('international_diplomas.name', 'international_diplomas.id')->toArray();
        $html = '<option value="">الدبلومة</option>';
        if (count($charge_transactions)) {
            foreach ($charge_transactions as $id => $name) {
                $html .= '<option value="' . $id . '">' . $name . '</option>';
            }
        }
        return $html;
    }
    public function doGetMedicalDiplomasChargesAjax($request)
    {


        $data = $request->all();


        if (isset($data['user_email']) && !empty($data['user_email'])) {

            $email=$data['user_email'];
            $AcademyUsers=new AcademyUsers;
            $AcademyUsers->setConnection('mysql3');
            $user= $AcademyUsers->where('Email',$email)->first();

            $result=MedicalDiplomasChargeTransaction::select('medical_diplomas_charge_transaction.*','users.FullName as user_name','promotion_code.code as coupon')
                ->join('users','users.id','=','medical_diplomas_charge_transaction.user_id')
                ->leftJoin('promotion_code','promotion_code.id','=','medical_diplomas_charge_transaction.coupon_id')
                ->where('medical_diplomas_charge_transaction.user_id',$user->id)
                //->where('medical_diplomas_charge_transaction.diploma_id','2')
                ->get();

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData){
                    $extra='';
                    if(PerUser('dashboard_yotta')|| (PerUser('dashboard_yotta') && $allData->pending)){
                        $extra.='<td>';
                    }
                    if(PerUser('dashboard_yotta')){
                        $extra.='<button data-user-id="'.$user->id.'" data-diploma-id="'.$allData->diploma_id.'" class="btn btn-danger openyottaDiplomaCourses">فتح الكورسات للعميل</button>';
                    }
                    if(PerUser('dashboard_yotta') && $allData->pending && (!$allData->end_date || ($allData->end_date > date('Y-m-d H:i:s')))){
                        $extra.='<button data-id="'.$allData->id.'" data-type="medical_diplomas" class="activeChargeBtn btn btn-info">active</button>';
                    }
                    if (PerUser('dashboard_diplomas_charges_delete')) {

                        $extra .= '<button data-id="' . $allData->id . '" style="margin: 5px;" class="deleteMedicalDiplomasChargeTransaction btn btn-danger">Delete</button>';
                    }
                    if(PerUser('dashboard_yotta')|| (PerUser('dashboard_yotta') && $allData->pending)){
                        $extra.='</td>';
                    }
                    $html .= '<tr id="view-yotta_medical_diplomas_charge_transaction-' . $allData->id . '">
                            <td>' . $x . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . (PerUser('dashboard_diplomas_charges_edit') ? '<a href="#" data-name="medical_diplomas_charge_transaction" data-pk="' . $allData->id . '" data-id="' . $allData->diploma_id . '" data-value="' . htmlspecialchars(json_encode(['diploma_id' => ['id' => $allData->diploma_id, 'text' => $allData->diploma_name], 'charge_system' => ['id' => $allData->charge_system, 'text' => ($allData->charge_system == 'ksa' ? 'سعودى' : 'مصرى')]]), ENT_QUOTES, 'UTF-8') . '" data-type="medical_diplomas_charge" class="change-diploma">' . $allData->diploma_name . '</a>' : $allData->diploma_name) . '</td>
                            <td>' . $allData->diploma_price . '</td>
                            <td>' . $allData->start_date . '</td>
                            <td>' . $allData->end_date . '</td>
                            <td>' . $allData->createtime . '</td>
                            <td>' . $this->getChargeStatus($allData) . '</td>
                            <td>'.$allData->automation_payment_method.'</td>
                             <td>'.$allData->coupon.'</td>
                            <td>' . $this->getChargeSuspend($allData) . '</td>'.
                        $extra
                        .'</tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="12">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="12">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }

    public function doGetYottaCoursesReportAjax($request)
    {
        $data = $request->all();
        if (isset($data['user_email']) && !empty($data['user_email'])) {
            $email=$data['user_email'];
            $diploma_id=2;
//            $result1=DB::connection('mysql3')->select(DB::raw("SELECT
//`data`.*,
//answer_2.createdtime AS add_date,
//answer_2.right_answers AS right_answers_2,
//answer_2.wrong_answers AS wrong_answers_2,
//(answer_2.right_answers/answer_2.quetions_numbers)*100 AS persentage_2,
//
//courses_curriculum_certificates.serial_number,
//users_curriculum_answers.quetions_numbers,
//users_curriculum_answers.right_answers,
//users_curriculum_answers.wrong_answers,
//(users_curriculum_answers.right_answers/users_curriculum_answers.quetions_numbers)*100 AS persentage
//FROM(
//
//select
//(SELECT
// COUNT(id)
//FROM users_curriculum_answers WHERE users_curriculum_answers.user_id=(SELECT id FROM users WHERE Email='$email') AND users_curriculum_answers.course_id=diplomas_courses_user_plan.course_id AND diplomas_courses_user_plan.user_id=(SELECT id FROM users WHERE Email='$email') AND users_curriculum_answers.curriculum_type='exam') AS count_id,
//(SELECT
// id AS answer_id
//FROM users_curriculum_answers WHERE users_curriculum_answers.user_id=(SELECT id FROM users WHERE Email='$email') AND users_curriculum_answers.course_id=diplomas_courses_user_plan.course_id AND diplomas_courses_user_plan.user_id=(SELECT id FROM users WHERE Email='$email') AND users_curriculum_answers.curriculum_type='exam' LIMIT 1) AS user_exam,
//courses.id AS course_id,
//courses.name AS course_name,
//(SELECT id FROM courses_curriculum_certificates WHERE courses_curriculum_certificates.course_id =diplomas_courses_user_plan.course_id AND courses_curriculum_certificates.user_id=(SELECT id FROM users WHERE Email='$email') AND diplomas_courses_user_plan.user_id=(SELECT id FROM users WHERE Email='$email')) AS certificate_id
// FROM diplomas_courses_user_plan
//LEFT JOIN courses ON courses.id=diplomas_courses_user_plan.course_id
//WHERE diplomas_courses_user_plan.diploma_id ='$diploma_id' AND diplomas_courses_user_plan.user_id=(SELECT id FROM users WHERE Email='$email')
//) AS data
// LEFT JOIN courses_curriculum_certificates ON courses_curriculum_certificates.id=certificate_id
//LEFT JOIN users_curriculum_answers ON users_curriculum_answers.id =courses_curriculum_certificates.users_curriculum_answer_id
//LEFT JOIN users_curriculum_answers AS answer_2 ON answer_2.id =user_exam"));
//
//
//            $reports['diplomas_courses_certificates']=$result1;
//
//        $result2=DB::connection('mysql3')->select(DB::raw("SELECT courses.id,courses.name FROM medical_diplomas_users_courses INNER JOIN courses ON courses.id=medical_diplomas_users_courses.course_id WHERE medical_diplomas_users_courses.diploma_id='$diploma_id' AND medical_diplomas_users_courses.user_id=(SELECT id FROM users WHERE Email='$email') ORDER BY courses.name"));
//        $reports['diplomas_users_courses']=$result2;
//        $result3=DB::connection('mysql3')->select(DB::raw("SELECT courses.id,courses.name FROM medical_diplomas_courses_user_plan INNER JOIN courses ON courses.id=medical_diplomas_courses_user_plan.course_id WHERE medical_diplomas_courses_user_plan.diploma_id='$diploma_id' AND medical_diplomas_courses_user_plan.user_id=(SELECT id FROM users WHERE Email='$email') ORDER BY courses.name"));
//        $reports['diplomas_courses_user_plan']=$result3;

//            $result=DB::connection('mysql3')->select("SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed
//INNER JOIN users ON users.id=users_course_view_completed.user_id
//INNER JOIN courses ON courses.id=users_course_view_completed.course_id
//WHERE users.id =(SELECT id FROM users WHERE Email='$email') AND courses.show_on='medical'");

            $result=DB::connection('mysql3')->select("SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed 
INNER JOIN users ON users.id=users_course_view_completed.user_id
INNER JOIN courses ON courses.id=users_course_view_completed.course_id
INNER JOIN medical_diplomas_courses_user_plan ON courses.id=medical_diplomas_courses_user_plan.course_id
WHERE users.id =(SELECT id FROM users WHERE Email='$email' AND deleted_at IS NULL LIMIT 1) AND courses.show_on='medical' AND medical_diplomas_courses_user_plan.diploma_id='$diploma_id' GROUP BY medical_diplomas_courses_user_plan.course_id ");

            $x = 1;
            $html = '';
            if (count($result)) {
                foreach ($result as $allData){
                    $html .= '<tr>
                            <td>' . $x . '</td>
                            <td>' . $allData->course_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->percentage . '</td>
                         </tr>';
                    $x++;
                }
            } else {
                $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }
        } else {
            $html = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
        }
        return $html;
    }
    public function doGetYottaCoursesExamsAjax($request)
    {
        $params=$request->all();
        $email = isset($params['email'])?$params['email']:null;
        $html = '';
        if($email) {
            $diploma_id=2;
            $result=DB::connection('mysql3')->select("SELECT users_curriculum_answers.*,users.Fullname AS user_name,users.Email AS user_email,courses.name AS module_name FROM 	users_curriculum_answers 
INNER JOIN users ON users.id=users_curriculum_answers.user_id
 INNER JOIN cources_curriculum ON cources_curriculum.id=users_curriculum_answers.curriculum_id
  INNER JOIN courses ON courses.id=cources_curriculum.course_id
  INNER JOIN medical_diplomas_courses_user_plan ON courses.id=medical_diplomas_courses_user_plan.course_id
   WHERE users.Email='$email' AND courses.show_on='medical' AND medical_diplomas_courses_user_plan.diploma_id='$diploma_id' GROUP BY users_curriculum_answers.curriculum_id");
            $html_exam = '';
            $html_tranning = '';
            if (count($result)) {
                $x_e = 1;
                $x_t = 1;

                foreach ($result as $allData){
                    if($allData->curriculum_type=='exam'){
                        $html_exam .= '<tr>
                            <td>' . $x_e . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->curriculum_type . '</td>
                            <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                        $x_e++;
                    }else{
                        $html_tranning .= '<tr>
                            <td>' . $x_t . '</td>
                            <td>' . $allData->module_name . '</td>
                            <td>' . $allData->user_name . '</td>
                            <td>' . $allData->user_email . '</td>
                            <td>' . $allData->curriculum_type . '</td>
                            <td>' . $allData->createdtime . '</td>
                            <td>' . $allData->right_answers . '/' . $allData->quetions_numbers . '</td>
                         </tr>';
                        $x_t++;
                    }


                }
            }
            if(!$html_exam){
                $html_exam = '<tr><td colspan="5">لا توجد بيانات متاحة في الجدول</td></tr>';
            }

        }
        return $html_exam;
    }
    public function doSuspendMedicalChargeTransactionAjax($request)
    {
        if (in_array($request->suspend, [0, 1]) && $request->charge_id) {
            $charge = MedicalChargeTransactions::find($request->charge_id);
            if ($charge->suspend != $request->suspend) {
                $date = date('Y-m-d H:i:s');
                if ($request->suspend == 0) {
                    $datetime1 = new \DateTime($charge->suspend_date);
                    $datetime2 = new \DateTime($date);
                    $interval = $datetime1->diff($datetime2);
                    $end_date = date('Y-m-d h:i:s', strtotime($charge->end_date . ' + ' . $interval->days . ' days'));
                    $charge->end_date = $end_date;
                }
                $charge->suspend = $request->suspend;
                $charge->suspend_date = $date;
                $charge->save();
                $log = new MedicalChargeTransactionsSuspendLog();
                $log->transaction_id = $charge->id;
                $log->user_id = $charge->user_id;
                $log->suspend = $request->suspend;
                $log->createtime = $date;
                $log->save();
                return response()->json(['success' => true, 'message' => '<div class="alert alert-success">Success Suspend</div>'])->setCallback($request->input('callback'));
            } else {
                return response()->json(['success' => false, 'message' => '<div class="alert alert-danger">Please Refresh and try again</div>'])->setCallback($request->input('callback'));
            }
        }
    }

    public function doSuspendGiftCourseChargeTransactionAjax($request)
    {
        if (in_array($request->suspend, [0, 1]) && $request->charge_id) {
            $charge = GiftCourseChargeTransactions::find($request->charge_id);
            if ($charge->suspend != $request->suspend) {
                $date = date('Y-m-d H:i:s');
                if ($request->suspend == 0) {
                    $datetime1 = new \DateTime($charge->suspend_date);
                    $datetime2 = new \DateTime($date);
                    $interval = $datetime1->diff($datetime2);
                    $end_date = date('Y-m-d h:i:s', strtotime($charge->end_date . ' + ' . $interval->days . ' days'));
                    $charge->end_date = $end_date;
                }
                $charge->suspend = $request->suspend;
                $charge->suspend_date = $date;
                $charge->save();
                $log = new GiftBookChargeTransactionsSuspendLog();
                $log->transaction_id = $charge->id;
                $log->user_id = $charge->user_id;
                $log->suspend = $request->suspend;
                $log->createtime = $date;
                $log->save();
                return response()->json(['success' => true, 'message' => '<div class="alert alert-success">Success Suspend</div>'])->setCallback($request->input('callback'));
            } else {
                return response()->json(['success' => false, 'message' => '<div class="alert alert-danger">Please Refresh and try again</div>'])->setCallback($request->input('callback'));
            }
        }
    }

    public function doSuspendGiftBookChargeTransactionAjax($request)
    {
        if (in_array($request->suspend, [0, 1]) && $request->charge_id) {
            $charge = GiftBookChargeTransactions::find($request->charge_id);
            if ($charge->suspend != $request->suspend) {
                $date = date('Y-m-d H:i:s');
                if ($request->suspend == 0) {
                    $datetime1 = new \DateTime($charge->suspend_date);
                    $datetime2 = new \DateTime($date);
                    $interval = $datetime1->diff($datetime2);
                    $end_date = date('Y-m-d h:i:s', strtotime($charge->end_date . ' + ' . $interval->days . ' days'));
                    $charge->end_date = $end_date;
                }
                $charge->suspend = $request->suspend;
                $charge->suspend_date = $date;
                $charge->save();
                $log = new GiftBookChargeTransactionsSuspendLog();
                $log->transaction_id = $charge->id;
                $log->user_id = $charge->user_id;
                $log->suspend = $request->suspend;
                $log->createtime = $date;
                $log->save();
                return response()->json(['success' => true, 'message' => '<div class="alert alert-success">Success Suspend</div>'])->setCallback($request->input('callback'));
            } else {
                return response()->json(['success' => false, 'message' => '<div class="alert alert-danger">Please Refresh and try again</div>'])->setCallback($request->input('callback'));
            }
        }
    }

    public function doopenmbaexamAjax($request)
    {
        if ($request->id) {
            $date = date('Y-m-d');
            $dateW = date('Y-m-d', strtotime('-7 days'));
            $result = DB::connection('mysql2')->select("Select * from  users_module_exams_answers where id='$request->id'");
            if (count($result)) {
                foreach ($result as $allData) {
                    $createdtime = date('Y-m-d', strtotime($allData->createdtime));
                    $createdtimew = date('Y-m-d', strtotime($createdtime . '-7 days'));
                    $result = DB::connection('mysql2')->update("Update  users_module_exams_answers set createdtime='$createdtimew' where id='$request->id' ");
                    if ($result) {
                        return response()->json(['success' => true, 'message' => '<div class="alert alert-success">Success Open Exam</div>'])->setCallback($request->input('callback'));
                    } else {
                        return response()->json(['success' => false, 'message' => '<div class="alert alert-danger">Please Refresh and try again</div>'])->setCallback($request->input('callback'));
                    }
                }
            }
        }
    }
    public function doopennewmbaexamAjax($request)
    {
        if ($request->id) {
            $date = date('Y-m-d');
            $dateW = date('Y-m-d', strtotime('-7 days'));
            $result = DB::connection('mysql2')->select("Select * from  new_mba_users_module_exams_answers where id='$request->id'");
            if (count($result)) {
                foreach ($result as $allData) {
                    $createdtime = date('Y-m-d', strtotime($allData->createdtime));
                    $createdtimew = date('Y-m-d', strtotime($createdtime . '-7 days'));
                    $result = DB::connection('mysql2')->update("Update  new_mba_users_module_exams_answers set createdtime='$createdtimew' where id='$request->id' ");
                    if ($result) {
                        return response()->json(['success' => true, 'message' => '<div class="alert alert-success">Success Open Exam</div>'])->setCallback($request->input('callback'));
                    } else {
                        return response()->json(['success' => false, 'message' => '<div class="alert alert-danger">Please Refresh and try again</div>'])->setCallback($request->input('callback'));
                    }
                }
            }
        }
    }

    public function download_book($file_name)
    {
        $file = filePath() . $file_name;
        return \Response::make(file_get_contents($file), 200, [
            'Content-Type' => 'application/pdf',
            'Content-Disposition' => 'attachment; ' . $file_name,
        ]);

    }

    public function doCertificatesRequestsChangeStatus($request)
    {
        $data = $request->all();
        $certificate_request = CertificatesRequests::findOrFail($data['id']);
        $certificate_request->request_status = $data['status'];
        if ($data['status'] == 'cancelled') {
            $certificate_request->cancelled_date = date('Y-m-d H:i:s');
        } elseif ($data['status'] == 'done') {
            $certificate_request->done_date = date('Y-m-d H:i:s');
        }
        $certificate_request->lastedited_at = date('Y-m-d H:i:s');
        $certificate_request->lastedited_by = Auth::user()->id;
        if ($certificate_request->save()) {
            log_user_action(Auth::user()->id, Auth::user()->username, 'update', 'certificates_requests', $certificate_request->id, json_encode($certificate_request));
        }
    }

    public function getChargeSuspend($charge)
    {
        if ($charge->suspend) {
            return 'Yes';
        }
        return 'No';
    }

    public function getChargeStatus($charge)
    {
        if ($charge->end_date != null && $charge->end_date < date('Y-m-d H:i:s') && $charge->suspend == 0 && $charge->end_date != "0000-00-00 00:00:00") {
            return 'Expired';
        }
        if (!$charge->pending) {
            return 'Active';
        } else {
            return 'Pending';
        }
    }

    public function mocRandPassword()
    {
        $alphabet = '1234567890';
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < 8; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); //turn the array into a string
    }



    public function transfer($data)
    {

        //  if (strtoupper (ip_info2())=='EGYPT' && $data['country']=='64')
        if ($data['country'] == '64') {
            $url = "https://crmegy.e3melbusiness.com/webservice/new_lead.php";

        } else {
            $url = "http://ksanew.almoasherbiz.com/webservice/new_lead.php";
        }

        /* if ( $last=='ksa')
         {
             $url = "http://ksanew.almoasherbiz.com/webservice/new_lead.php";

         }else
         {
             $url = "https://crmegy.e3melbusiness.com/webservice/new_lead.php";

         }*/


        // echo $url;
        $content = "";
        foreach ($data as $key => $value) {
            $content .= $key . '=' . $value . '&';
        }
        //echo $content;
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);

        $json_response = curl_exec($curl);
        print_r($data);
        echo $json_response;
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        curl_close($curl);
        // echo 'Transfer Record '. ' Is '. $json_response.'<br>';
        //$response = json_decode($json_response, true);
        //echo $response['name'];
        //var_dump($response);
    }

    public function getUserMbaStatisticsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = $request->user_id;
            $user = DB::connection('mysql2')->select(DB::raw("select Email from users where id='$user_id'"));
            $obj = $user[0];
            $email = $obj->Email;
            $statistics = modules_statistics('mba', $email);


            $query = "SELECT modules_users_summary.*,mba.name AS module_name 
                        FROM modules_users_summary 
                        INNER JOIN mba ON mba.id=modules_users_summary.module_id 
                        WHERE user_id='$user_id'";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=mba_statistics.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("MBA", "المشاهدة", "المشروع", "الاختبار", "الاجمالى"));

            foreach ($result as $res) {

                fputcsv($output, [
                    $res->module_name,
                    $res->progress,
                    $res->project,
                    $res->exam,
                    ((($res->progress * $statistics->max_progress) + ($res->project * $statistics->max_project) + ($res->exam * $statistics->max_exam)) / 100)
                ]);
            }

            fclose($output);

        }

    }


    public function getUserNewMbaStatisticsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = $request->user_id;
            $user = DB::connection('mysql2')->select(DB::raw("select Email from users where id='$user_id'"));
            $obj = $user[0];
            $email = $obj->Email;
            $statistics = modules_statistics('new_mba', $email);

            $query = "SELECT new_mba_modules_users_summary.*,new_mba.name AS module_name 
                        FROM new_mba_modules_users_summary 
                        INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id 
                        WHERE user_id='$user_id' AND new_mba_modules_users_summary.module_id NOT IN(SELECT module_id FROM new_mba_categories_modules)";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=new_mba_statistics.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("MBA", "المشاهدة", "المشروع", "1الاختبار", "2الاختبار", "الاجمالى"));

            foreach ($result as $res) {

                fputcsv($output, [
                    $res->module_name,
                    $res->progress,
                    $res->project,
                    $res->exam_part_1,
                    $res->exam_part_2,
                    ((($res->progress * $statistics->max_progress) + ($res->project * $statistics->max_project) + ($res->exam_part_1 * $statistics->max_exam_part1) + ($res->exam_part_2 * $statistics->max_exam_part2)) / 100)
                ]);
            }

            fclose($output);

        }

    }

    public function getUserNewMbaCategoryStatisticsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = $request->user_id;
            $user = DB::connection('mysql2')->select(DB::raw("select Email from users where id='$user_id'"));
            $obj = $user[0];
            $email = $obj->Email;
            $statistics = modules_statistics('new_mba', $email);
            $category_result = DB::connection('mysql2')->select("SELECT category_id FROM new_mba_charge_transaction WHERE user_id='$user_id' ORDER BY id DESC limit 1");
            $category_id = $category_result[0]->category_id;
            $query = "SELECT new_mba_modules_users_summary.*,new_mba.name AS module_name 
                        FROM new_mba_modules_users_summary 
                        INNER JOIN new_mba ON new_mba.id=new_mba_modules_users_summary.module_id 
                        WHERE user_id='$user_id' AND new_mba_modules_users_summary.module_id IN(SELECT module_id FROM new_mba_categories_modules  where new_mba_categories_modules.category_id= '$category_id')";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=new_mba_statistics.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("MBA", "المشاهدة", "المشروع", "1الاختبار", "2الاختبار", "الاجمالى"));

            foreach ($result as $res) {

                fputcsv($output, [
                    $res->module_name,
                    $res->progress,
                    $res->project,
                    $res->exam_part_1,
                    $res->exam_part_2,
                    ((($res->progress * $statistics->max_progress) + ($res->project * $statistics->max_project) + ($res->exam_part_1 * $statistics->max_exam_part1) + ($res->exam_part_2 * $statistics->max_exam_part2)) / 100)
                ]);
            }

            fclose($output);

        }

    }

    public function getUserMbaViewsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
                 SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed 
                  INNER JOIN users ON users.id=users_course_view_completed.user_id
                  INNER JOIN courses ON courses.id=users_course_view_completed.course_id
                  WHERE users.id ='$user_id' AND course_id IN (SELECT mba_module_courses.related_course FROM mba INNER JOIN mba_module_courses ON mba_module_courses.module_id=mba.id)
            ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=mba_views.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الكورس", "اسم المستخدم", "البريد الالكترونى", "نسبة المشاهدة"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->course_name,
                    $res->user_name,
                    $res->user_email,
                    $res->percentage
                ]);

                $x++;
            }

            fclose($output);

        }

    }


    public function getUserNewMbaViewsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
            
            SELECT users.FullName AS user_name,users.Email AS user_email,courses.name AS course_name,users_course_view_completed.completed,courses.curriculum_number,ROUND((ifnull(users_course_view_completed.completed,0)/courses.curriculum_number)*100,1) AS percentage FROM users_course_view_completed 
                  INNER JOIN users ON users.id=users_course_view_completed.user_id
                  INNER JOIN courses ON courses.id=users_course_view_completed.course_id
                  WHERE users.id ='$user_id' AND course_id IN (SELECT new_mba_module_courses.related_course FROM new_mba INNER JOIN new_mba_module_courses ON new_mba_module_courses.module_id=new_mba.id)
            
                     ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=new_mba_views.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الكورس", "اسم المستخدم", "البريد الالكترونى", "نسبة المشاهدة"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->course_name,
                    $res->user_name,
                    $res->user_email,
                    $res->percentage
                ]);

                $x++;
            }

            fclose($output);

        }

    }

    public function getUserMbaTestsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
                SELECT users_module_exams_answers.*,users.Fullname AS user_name,users.Email AS user_email,mba.name AS module_name 
                FROM users_module_exams_answers 
                INNER JOIN users ON users.id=users_module_exams_answers.user_id 
                INNER JOIN mba ON mba.id=users_module_exams_answers.module_id WHERE users.id='$user_id'
            ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=mba_tests.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الموديول", "اسم المستخدم", "البريد الالكترونى", "النتيجة", "التاريخ"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->module_name,
                    $res->user_name,
                    $res->user_email,
                    ($res->right_answers . '/' . $res->quetions_numbers),
                    $res->createdtime

                ]);

                $x++;
            }

            fclose($output);

        }

    }


    public function getUserNewMbaTests1Report($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
                SELECT new_mba_users_module_exams_answers.*,users.Fullname AS user_name,users.Email AS user_email,new_mba.name AS module_name 
                FROM new_mba_users_module_exams_answers 
                INNER JOIN users ON users.id=new_mba_users_module_exams_answers.user_id 
                INNER JOIN new_mba ON new_mba.id=new_mba_users_module_exams_answers.module_id WHERE 
                new_mba_users_module_exams_answers.exam_type='Part One' And users.id='$user_id'
            ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=new_mba_tests_part_one.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الموديول", "اسم المستخدم", "البريد الالكترونى", "النتيجة", "التاريخ"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->module_name,
                    $res->user_name,
                    $res->user_email,
                    ($res->right_answers . '/' . $res->quetions_numbers),
                    $res->createdtime
                ]);

                $x++;
            }

            fclose($output);

        }

    }

    public function getUserNewMbaTests2Report($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
                SELECT new_mba_users_module_exams_answers.*,users.Fullname AS user_name,users.Email AS user_email,new_mba.name AS module_name 
                FROM new_mba_users_module_exams_answers 
                INNER JOIN users ON users.id=new_mba_users_module_exams_answers.user_id 
                INNER JOIN new_mba ON new_mba.id=new_mba_users_module_exams_answers.module_id WHERE
                  new_mba_users_module_exams_answers.exam_type='Part Two' And  users.id='$user_id'
            ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=new_mba_tests_part_two.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الموديول", "اسم المستخدم", "البريد الالكترونى", "النتيجة", "التاريخ"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->module_name,
                    $res->user_name,
                    $res->user_email,
                    ($res->right_answers . '/' . $res->quetions_numbers),
                    $res->createdtime
                ]);

                $x++;
            }

            fclose($output);

        }

    }


    public function getUserMbaTrainingsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
                SELECT users_module_trainings_answers.*,users.Fullname AS user_name,users.Email AS user_email,mba.name AS module_name 
                FROM users_module_trainings_answers 
                INNER JOIN users ON users.id=users_module_trainings_answers.user_id 
                INNER JOIN mba ON mba.id=users_module_trainings_answers.module_id WHERE `users`.`id` = '$user_id'
            ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=mba_trainings.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الموديول", "اسم المستخدم", "البريد الالكترونى", "النتيجة", "التاريخ"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->module_name,
                    $res->user_name,
                    $res->user_email,
                    ($res->right_answers . '/' . $res->quetions_numbers),
                    $res->createdtime
                ]);

                $x++;
            }

            fclose($output);

        }
    }


    public function getUserNewMbaTrainingsReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
                
                SELECT new_mba_users_module_trainings_answers.*,users.Fullname AS user_name,users.Email AS user_email,new_mba.name AS module_name 
                                                        FROM new_mba_users_module_trainings_answers 
                                                        INNER JOIN users 
                                                        ON users.id=new_mba_users_module_trainings_answers.user_id 
                                                        INNER JOIN new_mba 
                                                        ON new_mba.id=new_mba_users_module_trainings_answers.module_id 
                                                        WHERE users.id='$user_id'

                
            ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=new_mba_trainings.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الموديول", "اسم المستخدم", "البريد الالكترونى", "النتيجة", "التاريخ"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->module_name,
                    $res->user_name,
                    $res->user_email,
                    ($res->right_answers . '/' . $res->quetions_numbers),
                    $res->createdtime
                ]);

                $x++;
            }

            fclose($output);

        }
    }

    public function getUserMbaCoursesReport($request)
    {

        if (isset($request->user_id) && !empty($request->user_id)) {

            $user_id = (int)$request->user_id;

            $query = "
                SELECT users_curriculum_answers.*,users.Fullname AS user_name,users.Email AS user_email,courses.name AS course_name 
                FROM users_curriculum_answers 
                INNER JOIN users ON users.id=users_curriculum_answers.user_id 
                INNER JOIN courses ON courses.id=users_curriculum_answers.course_id WHERE users.id='$user_id' AND courses.show_on='mba'
            ";

            $result = DB::connection('mysql2')->select(DB::raw($query));

            header('Content-Type: text/csv; charset=utf-8');

            header('Content-Disposition: attachment; filename=mba_courses_report.csv');

            $output = fopen("php://output", "w");

            fputcsv($output, array("#", "اسم الكورس", "اسم المستخدم", "البريد الالكترونى", "النوع", "النتيجة"));

            $x = 1;

            foreach ($result as $res) {

                fputcsv($output, [
                    $x,
                    $res->course_name,
                    $res->user_name,
                    $res->user_email,
                    $res->curriculum_type,
                    ($res->right_answers . '/' . $res->quetions_numbers)
                ]);

                $x++;
            }

            fclose($output);

        }

    }


    public function doYottaDiplomaMakeSuspend($email, $diploma_transaction_id, $suspend = 1)
    {
        if ($email && $diploma_transaction_id) {
            $notSuspend = ($suspend) ? 0 : 1;
            $result=DB::connection('mysql3')->select("SELECT medical_diplomas_charge_transaction.* FROM medical_diplomas_charge_transaction INNER JOIN users ON users.id=medical_diplomas_charge_transaction.user_id WHERE users.Email='$email' AND medical_diplomas_charge_transaction.id='$diploma_transaction_id' AND medical_diplomas_charge_transaction.suspend='$notSuspend'");
            if (count($result)) {
                $obj = $result[0];
                $date = date('Y-m-d H:i:s');
                DB::connection('mysql3')->table('medical_diplomas_charge_transaction')->where('id', $diploma_transaction_id)->update(
                    ['suspend' => $suspend, 'suspend_date' => $date]
                );
                log_user_action(Auth::user()->id,Auth::user()->username,'update','medical_diplomas_charge_transaction',$diploma_transaction_id,json_encode(['suspend' => $suspend, 'suspend_date' => $date]));
                $user_id = $obj->user_id;
                $diploma_id = $obj->diploma_id;
                DB::connection('mysql3')->table('medical_charge_transactions_suspend_log')->insert(
                    ['transaction_id' => $diploma_transaction_id, 'user_id' => $user_id, 'diploma_id' => $diploma_id, 'suspend' => $suspend, 'createtime' => $date]
                );
                if ($suspend == 0) {
                    $PaymentExpirationDate = strtotime(date('Y-m-d H:i:s')) - strtotime($obj->suspend_date);
                    $days = round($PaymentExpirationDate / 86400);
                    //echo$days;
                    //exit();
                    //echo$user->PaymentExpirationDate;
                    $PaymentExpirationDate = date('Y-m-d H:i:s', strtotime(' +' . $days . ' Day', strtotime($obj->end_date)));
                    DB::connection('mysql3')->table('medical_diplomas_charge_transaction')->where('id', $diploma_transaction_id)->update(
                        ['end_date' => $PaymentExpirationDate]
                    );
                    log_user_action(Auth::user()->id,Auth::user()->username,'update','medical_diplomas_charge_transaction',$diploma_transaction_id,json_encode(['end_date' => $PaymentExpirationDate]));
                }
                $errorMessage = ($notSuspend) ? 'Done Make Un Suspend' : 'Done Make Suspend';
                echo '<div class="alert alert-success">' . $errorMessage . '</div>';
            } else {
                $errorMessage = ($notSuspend) ? 'No Data Or already un suspended' : 'No Data Or already suspended';
                echo '<div class="alert alert-danger">' . $errorMessage . '</div>';
            }
        } else {
            echo '<div class="alert alert-danger">All Data Is Required</div>';
        }
    }


}

