// Promo Modal

$(window).on("load", function () {
  // $.ajax({
  //   url: "https://app.asana.com/-/api/0.1/workspaces/",
  //   type: "GET",
  //   dataType: "json",
  //   success: (res) => {
  //     alert(res);
  //   },
  //   error: (err) => {
  //     console.log(err);
  //   },
  // });
  $("#promoModal").modal("show");
  // $("#spFormModal").modal("show");
});

$(".hide-promo-modal-btn").on("click", function (e) {
  e.preventDefault();
  $("#promoModal").modal("hide");
});

$(document).ready(function () {
  const spForm = $("#spForm");
  const validator = spForm.validate({
    rules: {
      name: {
        required: true,
        minlength: 2,
      },
      course: {
        required: true,
      },
      frequency: {
        required: true,
      },
      duration: {
        required: true,
      },
    },
    messages: {
      name: {
        required: "يجب ادخال عنوان الخطة التدريبية",
        minlength: "ادخل حرفين على الأقل",
      },
      course: {
        required: "اختر دورة تدريبية أولاً",
      },
      frequency: {
        required: "يجب اختيار نوع الخطة الدراسية",
      },
      duration: {
        required: "يجب اختيار مدة الخطة الدراسية",
      },
    },
    errorPlacement: function (error, element) {
      if (element?.hasClass("btn-check")) {
        element?.parent()?.parent()?.after(error);
      }
    },
  });
  $(".sp-step-btn.next-btn").on("click", function (e) {
    e.preventDefault();
    const targetInputs = $(this).attr("data-target-field");
    if (targetInputs) {
      const validationInputs = eval(targetInputs);
      let hasError = false;
      for (let i = 0; i < validationInputs.length; i++) {
        if (!validator?.element($(validationInputs[i]))) {
          hasError = true;
        }
      }
      if (!hasError) {
        const currentStep = $($(this).attr("data-current-step"));
        const targetStep = $($(this).attr("data-target-step"));
        if (currentStep?.length && targetStep?.length) {
          currentStep?.removeClass("shown");
          targetStep?.addClass("shown");
        }
      }
    }
  });
  $(".sp-step-btn.prev-btn").on("click", function (e) {
    e.preventDefault();
    const currentStep = $($(this).attr("data-current-step"));
    const targetStep = $($(this).attr("data-target-step"));
    if (currentStep?.length && targetStep?.length) {
      currentStep?.removeClass("shown");
      targetStep?.addClass("shown");
    }
  });

  $("#spSaveButton").on("click", function (e) {
    $("#spSaveButton").addClass('loading').attr('disabled','disabled');
    e.preventDefault();
    if (spForm.valid()) {
      // Save to server
      $.ajax({
        type: "POST",
        url: "?page=coursesPlans&action=savePlan",
        data: $("#spForm").serialize(),
        success: function (data) {
          $("#spSaveButton").removeClass('loading').removeAttr('disabled');
          console.log(data)
          // $.notify(data.message,{ className:(data.success?'success':'error'),position:"top center" });
          Swal.fire(
              'اضافة خطة',
              data.message,
              (data.success?'success':'error')
          )
          console.log(data.redirect)
          if(data.redirect){
            console.log('data.redirect')
            setTimeout(function(){
              console.log('setTimeout')
              window.location.href=data.redirect;
            },4000);
          }
        }
      });
    }
  });

  $("input[name='duration']").on("change", function () {
    const toggler = $("#customDuration");
    const targetWrapper = $("#customTimeWrapper");
    if (targetWrapper) {
      if (toggler.is(":checked")) {
        targetWrapper.removeClass("d-none");
      } else {
        targetWrapper.addClass("d-none");
      }
    }
  });
});
