<?php

Class webinarController Extends baseController {

    public function index()
    {
        if($_SERVER['REQUEST_URI']=='/?page=webinar'){
            return header('Location: /webinar');
        }
        if(strpos($_SERVER['REQUEST_URI'], '?offer_id') !== false){
            $explode=explode('?offer_id',$_SERVER['REQUEST_URI']);
            $implode=implode('&offer_id',$explode);
            return header('Location: '.$implode);
        }
        $webinar_id=get('webinar');
        if (!empty($webinar_id)){
            if($_SERVER['HTTP_HOST']!='localhost'){
                $webinar=$this->registry->users->getWebinarByID($webinar_id);
                if(count($webinar)){
                    if(strpos($_SERVER['REQUEST_URI'], '&offer_id') !== false){
                        $explode=explode('&offer_id',$_SERVER['REQUEST_URI']);
                        return header('Location: /webinar/'.$webinar->url.'&offer_id'.$explode[1]);
                    }
                    //return header('Location: /webinar/'.$webinar->url);
                }
                else{
                    $redirect_url=$this->registry->users->getRedirectUrl($webinar_id);
                    if($redirect_url){
                        return header('Location:' . $redirect_url);
                    }else {
                      self::redirect404();
                        exit;
                    }
                }
            }

            $webinar=$this->registry->users->getsinglewebinar($webinar_id);
            if (!isset($webinar->id)){
                 $redirect_url=$this->registry->users->getRedirectUrl($webinar->url);
                if($redirect_url){
                    return header('Location:' . $redirect_url);
                }else {
                    $webinar_url = $this->registry->users->getOldUrl($webinar_id, 'webinar');
                    if ($webinar_url) {
                        return header('Location: /webinar/' . $webinar_url);
                    } else {
                        self::redirect404();
                        exit;
                    }
                }
            }
            self::display_single_webinar($webinar_id,$webinar);
        }else{

                self::display_all_webinars();

        }
    }
    function display_all_webinars(){
        $webinars=$this->registry->users->getallwebinar(" AND webinar.type='online' order by webinar.id desc ");
        $this->registry->template->webinars=$webinars;
        $this->registry->template->page_body = getviewslink().'/academy/webinar';
        $this->registry->template->show('index_home');
    }
    function offlineWebinars(){
        if($_SERVER['REQUEST_URI']=='/?page=webinar&action=offlineWebinars'){
            return header('Location: /webinar/offline');
        }
        if(strpos($_SERVER['REQUEST_URI'], '?offer_id') !== false){
            $explode=explode('?offer_id',$_SERVER['REQUEST_URI']);
            $implode=implode('&offer_id',$explode);
            return header('Location: '.$implode);
        }
        $webinars=$this->registry->users->getallwebinar(" AND webinar.type='offline' AND webinar.parent_id='0'  order by webinar.id desc ");
        $this->registry->template->webinars=$webinars;
        $this->registry->template->page_body = getviewslink().'/academy/webinar';
        $this->registry->template->show('index_home');
    }
    function display_single_webinar($webinar_id,$webinar)
    {
        $this->registry->template->webinar=$webinar;
        
         $resources=$this->registry->users->getwebinarresources($webinar->id);
        $this->registry->template->resources=$resources;
        $this->registry->template->page_body = getviewslink().'/academy/singlewebinar';
        if($webinar->type=='offline'){
            $supWebinars=$this->registry->users->getSupWebinars($webinar->id);
            $this->registry->template->supWebinars=$supWebinars;
        }
        $this->registry->template->show('index_home');
    }
    function display_single_webinaraudio()
    {
        $webinar_id=get('webinar');
        $webinar=$this->registry->users->getsinglewebinar($webinar_id);
        $this->registry->template->webinar=$webinar;

        $resources=$this->registry->users->getwebinarresources($webinar->id);
        $this->registry->template->resources=$resources;
        $this->registry->template->page_body = getviewslink().'/academy/singlewebinar_test';
        if($webinar->type=='offline'){
            $supWebinars=$this->registry->users->getSupWebinars($webinar->id);
            $this->registry->template->supWebinars=$supWebinars;
        }
        $this->registry->template->show('index_home');
    }
}

?>
