<?php

Class socialloginController Extends baseController {

    protected $_socialConfig=[
        // Location where to redirect users once they authenticate with a provider


        // Providers specifics
        'providers' => [
            'Apple' => [
                'enabled' => true,     // Optional: indicates whether to enable or disable Twitter adapter. Defaults to false
                'keys' => [
                    'key' => '...', // Required: your Twitter consumer key
                    'secret' => '...'  // Required: your Twitter consumer secret
                ]
            ],
            'LinkedIn' => [
                'callback' => $this->siteURL.'?page=sociallogin&social_type=LinkedIn',
                'enabled' => true,     // Optional: indicates whether to enable or disable Twitter adapter. Defaults to false
                "keys"    => array("id" => "86egv9tvdrad2b", "secret" => "aWlKH0uqSmbbTuCb"),
                "scope"   => "r_liteprofile r_emailaddress w_member_social", // optional
            ],
            'Google' => [
                'callback' => $this->siteURL.'?page=sociallogin&social_type=Google',
                'enabled' => true,     // Optional: indicates whether to enable or disable Twitter adapter. Defaults to false
                "keys"    => array ( "id" => "902132941047-2fa3tcrp5dhjshgjdjqkvjtgqth0d79i.apps.googleusercontent.com", "secret" => "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" ),
            ], // To populate in a similar way to Twitter
            'Facebook' => [
                'callback' => $this->siteURL.'?page=sociallogin&social_type=Facebook',
                'enabled' => true,     // Optional: indicates whether to enable or disable Twitter adapter. Defaults to false
                "keys"    => array ( "id" => "318489963509332", "secret" => "0888cb3aa9cb0540542619dd9555ab52" ),
                "scope"   => ['email',], // optional
                "photo_size" => 200, // optional
                'endpoints' => [
                    'api_base_url' => 'https://graph.facebook.com/v2.8/',
                    'authorize_url' => 'https://www.facebook.com/dialog/oauth',
                    'access_token_url' => 'https://graph.facebook.com/oauth/access_token',
                ]
            ],  // And so on
            'Twitter' => [
                'enabled' => true,     // Optional: indicates whether to enable or disable Twitter adapter. Defaults to false
                'keys' => [
                    'key' => '...', // Required: your Twitter consumer key
                    'secret' => '...'  // Required: your Twitter consumer secret
                ],
            ]  // And so on
        ]
    ];
//https://www.e3melbusiness.com/?page=sociallogin&social_type=Facebook
    public function index()
    {
        $social_type=get('social_type');
        $action_type=get('type');
        if($action_type){
            $this->registry->sessionhandler->put( 'ACTION_TYPE',$action_type);
        }
        $action_type=$this->registry->sessionhandler->get( 'ACTION_TYPE');
        if(in_array($social_type,['Facebook','Apple','Twitter','Google','LinkedIn'])){
            require_once( __DIR__."/../includes/vendor/autoload.php" );
            try {
                $hybridauth = new Hybridauth\Hybridauth($this->_socialConfig);
                $adapter = $hybridauth->authenticate($social_type);
                // $adapter = $hybridauth->authenticate('Google');
                // $adapter = $hybridauth->authenticate('Facebook');
                // $adapter = $hybridauth->authenticate('Twitter');
                $tokens = $adapter->getAccessToken();
                $userProfile = $adapter->getUserProfile();
                //print_r($tokens);
                //print_r($userProfile);
                $db=new db(null);
                $social_id=$userProfile->identifier;
                $t=strtolower($social_type);
                $query="SELECT users.* FROM users_social_login INNER JOIN users ON users.id=users_social_login.user_id AND ISNULL(users.deleted_at) WHERE users_social_login.social_id='$social_id' AND users_social_login.type='$t' AND ISNULL(users_social_login.deleted_at)";
                //echo $query;die();
                $result=$db->execquery($query);
                $userExist=false;
                $user=null;
                if($result&&$result->num_rows){
                    $user=$result->fetch_object();
                    $userExist=true;
                }
                if($userExist&&$user){
                    if($action_type=='linkUser'){
                        $this->registry->sessionhandler->put('ERROR_MESSAGE_SOCIAL_LINKED','هذا الحساب مربوط باكونت اخر');
                        return header('Location:?page=profile&tabs=socialLinking');
                    }
                    $decoded_id=$this->registry->encryption->encode($user->id);
                    $this->registry->sessionhandler->put( $this->registry->useridstr,$decoded_id);
                    $session_id=$this->registry->sessionhandler->id();
                    $this->registry->sessionhandler->put( 'session_user',$session_id);
                    $this->registry->users->update_usersession($session_id);
                    $user_action='Social_Login';
                    $user_action_table='users';
                    $user_action_table_id=$user->id;
                    $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
                    self::redirecttopage();
                }else{
                    if($action_type=='linkUser'){
                        $id=$this->registry->encryption->decode($this->registry->sessionhandler->get($this->registry->useridstr));
                        //echo $id;die();
                        if($id){
                            $dataJson=json_encode($userProfile);
                            $query="INSERT INTO users_social_login SET user_id='$id',`type`='$social_type',social_id='$userProfile->identifier',email='$userProfile->email',username='$userProfile->displayName',image='$userProfile->photoURL',data_json='$dataJson'";
                            $db->execquery($query);
                            $this->registry->sessionhandler->put('SUCCESS_MESSAGE_SOCIAL_LINKED','تم ربط حسابك بنجاح');
                            return header('Location:?page=profile&tabs=socialLinking');
                        }

                    }
                    $this->registry->sessionhandler->put( 'SOCIAL_USER_PROFILE',(array)$userProfile);
                    $this->registry->sessionhandler->put( 'SOCIAL_TYPE',$social_type);
                    header("Location:?page=sociallogin&action=signup");
                }
                $adapter->disconnect();
            } catch (\Exception $e) {
                echo $e->getMessage();
            }
        }

    }
    function redirecttopage($ref=false)
    {
        $httpref = $this->registry->sessionhandler->get('HTTP_REFERER');
        //var_dump('referrer is ' . $httpref);die();
        if($ref=='support') {
            $httpref = $this->siteURL.'?page=index' ;
        }
        else {
            $httpref = ($httpref == "") ? $httpref = $this->siteURL . '/?page=index' : $httpref;
        }
        return header('Location:'.$httpref);
    }
    public function resetSocialLogin(){
        $this->registry->sessionhandler->forget('SOCIAL_USER_PROFILE');
        $this->registry->sessionhandler->forget('SOCIAL_TYPE');
        header('Content-Type:application/json');
        echo json_encode(['success'=>true]);
    }
    public function signup(){
        $this->login_redirect();
        //print_r($_COOKIE);
        $userProfile=$this->registry->sessionhandler->get( 'SOCIAL_USER_PROFILE');
        $social_type=$this->registry->sessionhandler->get( 'SOCIAL_TYPE');
        if($userProfile){
            $userProfile=(object)$userProfile;
        }
        $this->registry->template->userProfile=$userProfile;
        $this->registry->template->social_type=$social_type;
        $filters=$this->registry->recruitment->getFilterURL();
        $sponserid=isset($filters['sponserid'])?$filters['sponserid']:'';
        $this->registry->template->sponserid=$sponserid;
        $this->registry->users->saveAffiliateID();
        $this->registry->template->countries =$this->registry->helper->getcountries();
        if($userProfile){
            $this->registry->template->page_body = getviewslink().'/academy/social-linking';
        }else{
            $this->registry->template->page_body = getviewslink().'/academy/social-register';
        }

        $this->registry->template->show('index_home');
    }
    public function login(){
        $HTTP_REFERER=$this->registry->sessionhandler->get( "HTTP_REFERER");
        $HTTP_REFERER=($HTTP_REFERER)?$HTTP_REFERER:$_SERVER['HTTP_REFERER'];
        $this->login_redirect();
        $this->registry->sessionhandler->put('login_type','') ;
        //if ($this->registry->template->IsLogin){header("Location:?page=index");}
        $this->registry->sessionhandler->put( "HTTP_REFERER",$HTTP_REFERER);
        $this->registry->template->page_body = getviewslink().'/academy/social-login';
        $this->registry->template->show('index_home');
    }
    public function unlinkSocialLogin(){
        $user_id=$this->getuserid();
        if($user_id){
            $social_id=post('social_id');
            $social_type=post('social_type');
            if($social_id&&$social_type){
                $db=new db(null);
                $query="UPDATE users_social_login SET deleted_at=NOW() WHERE ISNULL(deleted_at) AND id='$social_id' AND type='$social_type' AND user_id='$user_id' ";
                $db->execquery($query);
                return $this->responseData(['success'=>true,'message'=>'تم حذف الحساب بنجاح']);
            }
            return $this->responseData(['success'=>false,'message'=>'Parameters needed']);
        }

        return $this->responseData(['success'=>false]);
    }

    public function responseData($data){
        header('Content-Type:application/json');
        echo json_encode($data);
    }


}
?>
