<?php

Class recruitmentController Extends baseController
{
    public function singleCompany()
    {
        //$employee_id=$this->getuserrecruitid();
        //if($employee_id){
        $user_id = $this->getuserid();
        if ($user_id) {
            $company_id = get('company_id');
            if ($company_id) {
                /*$employee=$this->registry->recruitment->getSingleEmployee($employee_id);
                if(!$employee->isFull){
                    return header('Location: '.$this->siteURL.'/recruitment/employee/edit/profile');
                }*/
                $company = $this->registry->recruitment->getSingleCompany($company_id);
                if (count($company)) {
                    $companyJobs = $this->registry->recruitment->getCompanyJobs($company->id);
                    $this->registry->template->company = $company;
                    $this->registry->template->user_id = $user_id;
                    $this->registry->template->companyJobs = $companyJobs;
                    $this->registry->template->page_body = getviewslink() . '/recruitment/single_company';
                    $this->registry->template->show('index_home');
                } else {
                    self::jobs();
                }
            } else {
                self::jobs();
            }
        } else {
            return header('Location: ' . $this->siteURL . '/login');
        }


    }

    public function jobs()
    {
        $filters = $this->registry->recruitment->getFilterURL(get('filter'));
        //print_r($filters);
        //die();
        $allJobsCount = $this->registry->recruitment->getJobsCount("", $filters);
        $jobs = $this->registry->recruitment->getSearchJobs("", $filters);
        $countriesJson = $this->registry->recruitment->getCountriesJson();
        $citiesJson = $this->registry->recruitment->getCitiesJson();
        $statesJson = $this->registry->recruitment->getStatesJson();
        $countries = $this->registry->recruitment->getCountriesWithCount(isset($filters['countries']) ? $filters['countries'] : []);
        $cities = $this->registry->recruitment->getCitiesWithCount(isset($filters['cities']) ? $filters['cities'] : []);
        $states = $this->registry->recruitment->getStatesWithCount(isset($filters['states']) ? $filters['states'] : []);
        $careers = $this->registry->recruitment->getCareersWithCount();
        $this->registry->template->countriesJson = $countriesJson;
        $this->registry->template->citiesJson = $citiesJson;
        $this->registry->template->statesJson = $statesJson;
        $this->registry->template->filters = $filters;
        $this->registry->template->jobs = $jobs;
        $this->registry->template->countries = $countries;
        $this->registry->template->cities = $cities;
        $this->registry->template->states = $states;
        $this->registry->template->careers = $careers;
        $this->registry->template->allJobsCount = $allJobsCount;
        $this->registry->template->page_body = getviewslink() . '/recruitment/jobs';
        $this->registry->template->show('index_home');
    }

    public function viewApplicants()
    {

        $job_id = get('job_id');
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    $job = $this->registry->recruitment->getSingleJob($job_id, $company->id);
                    if (count($job)) {
                        $companyJobApplicants = $this->registry->recruitment->getCompanyJobApplicants($job_id);
                        $this->registry->template->job = $job;
                        $this->registry->template->company = $company;
                        $this->registry->template->companyJobApplicants = $companyJobApplicants;
                        $this->registry->template->page_body = getviewslink() . '/recruitment/view_applicants';
                        $this->registry->template->show('index_home');
                    } else {
                        self::index();
                    }
                } else {
                    $this->registry->template->page_body = getviewslink() . '/recruitment/single_company_em';
                    $this->registry->template->show('index_home');
                }
            } else {
                return header('Location: ' . $this->siteURL . '/expired');
            }
        } else {
            return header('Location: ' . $this->siteURL . '/recruitment/login');
        }
    }

    public function index()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    $companyJobs = $this->registry->recruitment->getCompanyJobs($company->id);
                    $this->registry->template->company = $company;
                    $this->registry->template->companyJobs = $companyJobs;
                    $this->registry->template->page_body = getviewslink() . '/recruitment/single_company';
                    $this->registry->template->show('index_home');
                } else {
                    $this->registry->template->page_body = getviewslink() . '/recruitment/single_company_em';
                    $this->registry->template->show('index_home');
                }
            } else {
                return header('Location: ' . $this->siteURL . '/expired');
            }
        } else {
            return header('Location: ' . $this->siteURL . '/login');
        }
    }

    public function viewRecommendations()
    {

        $job_id = get('job_id');
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    if ($company->is_recruitment_company) {
                        $job = $this->registry->recruitment->getSingleJob($job_id, $company->id);
                        if (count($job)) {
                            $companyJobRecommendations = $this->registry->recruitment->getRecommendations($job_id);
                            $this->registry->template->job = $job;
                            $this->registry->template->company = $company;
                            $this->registry->template->companyJobRecommendations = $companyJobRecommendations;
                            $this->registry->template->page_body = getviewslink() . '/recruitment/view_recommendations';
                            $this->registry->template->show('index_home');
                        } else {
                            self::index();
                        }
                    } else {
                        $this->registry->template->page_body = getviewslink() . '/recruitment/single_company_em';
                        $this->registry->template->show('index_home');
                    }
                } else {
                    $this->registry->template->page_body = getviewslink() . '/recruitment/single_company_em';
                    $this->registry->template->show('index_home');
                }
            } else {
                return header('Location: ' . $this->siteURL . '/expired');
            }
        } else {
            return header('Location: ' . $this->siteURL . '/recruitment/login');
        }
    }

    public function seeMoreJobs()
    {
        $filters = $this->registry->recruitment->getFilterURL(post('filter'));
        $skip = post('skip');
        $skip = intval($skip);
        $skip = (is_int($skip)) ? $skip : 0;
        $jobs = $this->registry->recruitment->getSearchJobs("", $filters, "ORDER BY createdtime DESC LIMIT $skip,5");
        $allJobsCount = $this->registry->recruitment->getJobsCount("", $filters);
        include getviewslink() . '/recruitment/wedget/jobs-block.php';
    }

    public function singleJob()
    {
        $currentsource = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
        $this->registry->sessionhandler->put('currentlink', $currentsource);
        self::loginEmployee();
        $employee_id = $this->getuserrecruitid();
        if ($employee_id) {
            $employee = $this->registry->recruitment->getEmployeeDetails($employee_id);
            if (!$employee->isFull) {
                return header('Location: ' . $this->siteURL . '/recruitment/employee/edit/profile');
            }
        }
        $job_id = get('job_id');
        if ($job_id) {
            $job = $this->registry->recruitment->getSingleJob($job_id);
            if (count($job)) {
                $hasApply = $this->registry->recruitment->hasApplyJob($job_id, $this->getuserrecruitid());
                $this->registry->template->hasApply = $hasApply;
                $this->registry->template->job = $job;
                $this->registry->template->countries = $this->registry->recruitment->getCountries();
                $this->registry->template->moreJobs = $this->registry->recruitment->getSearchJobs("AND recruitment_jobs.id!='$job_id'", [], "ORDER BY createdtime DESC LIMIT 10");
                $this->registry->template->page_body = getviewslink() . '/recruitment/single_job';
                $this->registry->template->show('index_home');
            } else {
                self::jobs();
            }
        } else {
            self::jobs();
        }

    }

    public function loginEmployee()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $this->registry->recruitment->addUserEmployeeNotExist($user_id);
            $employee_id = $this->registry->recruitment->loginByUserID($user_id);
            if ($employee_id > 0) {
                $decoded_id = $this->registry->encryption->encode($employee_id);
                $this->registry->sessionhandler->put($this->registry->userrecruitidstr, $decoded_id);
                $session_id = $this->registry->sessionhandler->id();
                $this->registry->sessionhandler->put('session_user', $session_id);
            }
        }
    }

    public function singleEmployee()
    {

        $employee_id = get('employee_id');
        if ($employee_id) {
            $employee = $this->registry->recruitment->getSingleEmployee($employee_id);
            if (count($employee)) {
                $this->registry->template->employee = $employee;
                $this->registry->template->page_body = getviewslink() . '/recruitment/single_employee';
                $this->registry->template->show('index_home');
            } else {
                self::jobs();
            }
        } else {
            $employee_id = $this->getuserrecruitid();
            if ($employee_id) {
                $employee = $this->registry->recruitment->getSingleEmployee($employee_id);
                $this->registry->template->employee = $employee;
                $this->registry->template->page_body = getviewslink() . '/recruitment/single_employee';
                $this->registry->template->show('index_home');
            } else {
                self::jobs();
            }

        }
    }

    public function applyJob()
    {
        $employee_id = $this->getuserrecruitid();
        if ($employee_id) {
            $job_id = get('job_id');
            $job = $this->registry->recruitment->getSingleJob($job_id);
            if (count($job)) {
                $this->registry->recruitment->employeeJobApply($employee_id, $job_id);
            }
        }
    }

    public function employeeProfile()
    {
        $employee_id = $this->getuserrecruitid();
        if ($employee_id) {
            $this->registry->template->page_body = getviewslink() . '/recruitment/employee_profile';
            $this->registry->template->countries = $this->registry->recruitment->getCountries();
            $this->registry->template->show('index_home');
        } else {
            return header('Location: ' . $this->siteURL . '/recruitment/login');
        }
    }

    public function editEmployeeProfile()
    {
        $employee_id = $this->getuserrecruitid();
        if ($employee_id) {
            $this->registry->recruitment->editEmployeeProfile($employee_id);
        }
    }

    public function employeeProfileChangePassword()
    {
        $employee_id = $this->getuserrecruitid();
        if ($employee_id) {
            $this->registry->template->page_body = getviewslink() . '/recruitment/employee_change_password';
            $this->registry->template->countries = $this->registry->recruitment->getCountries();
            $this->registry->template->show('index_home');
        } else {
            return header('Location: ' . $this->siteURL . '/recruitment/login');
        }
    }

    public function changeEmployeePassword()
    {
        $employee_id = $this->getuserrecruitid();
        if ($employee_id) {
            $this->registry->recruitment->changeEmployeePassword($employee_id);
        }

    }

    public function login()
    {
        $this->login_recruitment_redirect();
        $this->registry->template->page_body = getviewslink() . '/recruitment/login';
        $this->registry->template->show('index_home');
    }

    public function submitLogin()
    {
        $email = post('email');
        $password = post('password');
        $rememberme = post('rememberme');
        $user_id = $this->registry->users->loginuser($email, $password);
        if ($user_id > 0) {
            $decoded_id = $this->registry->encryption->encode($user_id);
            $this->registry->sessionhandler->put($this->registry->useridstr, $decoded_id);
            $this->registry->users->rememberme($email, $password, $rememberme);
            $session_id = $this->registry->sessionhandler->id();
            $this->registry->sessionhandler->put('session_user', $session_id);
            $this->registry->users->update_usersession($session_id);
            $this->registry->recruitment->addUserEmployeeNotExist($user_id);
            $id = $this->registry->recruitment->loginRecruitment($email, $password);
            if ($id > 0) {
                $decoded_id = $this->registry->encryption->encode($id);
                $this->registry->sessionhandler->put($this->registry->userrecruitidstr, $decoded_id);
                $this->registry->recruitment->rememberme($email, $password, $rememberme);
                $session_id = $this->registry->sessionhandler->id();
                $this->registry->sessionhandler->put('session_user', $session_id);
            }
            self::redirecttopage();
        }
    }

    public function redirecttopage()
    {
        $httpref = $this->registry->sessionhandler->get('HTTP_REFERER');
        if ($httpref != "" && strpos($httpref, $_SERVER['HTTP_HOST']) !== false) {
            ob_end_clean();
            $data = array("httpref" => $httpref,);
            echo json_encode($data);
        } else {
            echo '<script>window.location.href="recruitment/jobs"</script>';
        }
    }

    public function signup()
    {
        $this->login_recruitment_redirect();
        $this->registry->template->countries = $this->registry->recruitment->getCountries();
        $this->registry->template->page_body = getviewslink() . '/recruitment/signup';
        $this->registry->template->show('index_home');
    }

    public function submitSignUp()
    {
        $this->registry->recruitment->submitSignUp();
    }

    public function forgotpassword()
    {
        $this->login_recruitment_redirect();
        $this->registry->template->page_body = getviewslink() . '/recruitment/forget_password';
        $this->registry->template->show('index_home');
    }

    public function submitForgotPassword()
    {
        $email = post('email');
        if ($email == "")
            return;
        $result_email = $this->registry->recruitment->isEmailExist($email);
        if ($result_email) {
            $resultins = $this->registry->recruitment->insertResetPassword($email);
            //$link= $_SERVER['SERVER_NAME'].'?page=forgetpassword&action=resetpassword&token='.$resultins;
            $link = "http://" . $_SERVER['SERVER_NAME'] . strtok($_SERVER["REQUEST_URI"], '?') . '?page=recruitment&action=resetPassword&token=' . $resultins;
            $text = "<a href='$link'> $link</a>";
            $parameters = array(
                'template' => 'resetpassword',
                'link' => $link,
                'username' => $email,

            );
            $this->registry->emails->sendemail($email, $parameters);
            //$this->mailresetlink($email,$resultins);
            $errorMessage = 'برجاء فحص بريدك الإلكترونى للإسترجاع كلمة المرور، قد يصل البريد الإلكترونى فى مجلد الرسائل الغير مرغوب بها (Spam أو Junk)';
            include_once getviewslink() . '/message/success_message.php';
        } else {
            $errorMessage = 'من فضلك تأكد من البريد الإلكترونى';
            include_once getviewslink() . '/message/error_message.php';
        }
    }

    public function resetPassword()
    {
        $token = get('token');
        if ($token) {
            $this->registry->template->token = $token;
            $this->registry->template->page_body = getviewslink() . '/recruitment/reset_password';
            $this->registry->template->show('index_home');
        } else {
            self::jobs();
        }

    }

    public function submitResetPassword()
    {
        $token = post('token');

        $token_result = $this->registry->recruitment->getPasswordTokens($token);

        if (count($token_result) <= 0) {
            $errorMessage = 'هذا الرابط غير صحيح';
            include_once getviewslink() . '/message/error_message.php';
            return;

        } else {
            $emailtoken = $token_result[0]['email'];
            if ($token_result[0]['used'] == 0) {
                $today = date("Y-m-d H:i:s");
                if ($token_result[0]['extime'] < $today) {
                    $errorMessage = 'هذا الرابط منتهى';
                    include_once getviewslink() . '/message/error_message.php';
                    return;
                } else {

                    // UPDATE NEW PASSWORD & UPDATE PASSWORD TOKENS TABLE

                    $newpassword = post('confirmpassword');
                    $result_resetusertb = $this->registry->recruitment->updateEmployeePassword($emailtoken, $newpassword);
                    $result_tokentb = $this->registry->recruitment->updateEmployeeTokens($token);
                    $this->registry->recruitment->updateEmployeeTokens($token);
                    $errorMessage = 'تم تحديث كلمة المرور';
                    include_once getviewslink() . '/message/success_message.php';

                }
            } else {
                $errorMessage = 'تم استخدام هذا الرابط من قبل';
                include_once getviewslink() . '/message/error_message.php';
                return;
            }
        }

    }


    public function editProfile()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                $industries = $this->registry->recruitment->getIndustries();
                $this->registry->template->countries = $this->registry->recruitment->getCountries();
                $this->registry->template->industries = $industries;
                $this->registry->template->company = $company;
                $this->registry->template->page_body = getviewslink() . '/recruitment/company_profile';
                $this->registry->template->show('index_home');
            } else {
                return header('Location: ' . $this->siteURL . '/expired');
            }
        } else {
            return header('Location: ' . $this->siteURL . '/recruitment/login');
        }
    }

    public function editCompanyProfile()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $this->registry->recruitment->editCompanyProfile($user_id);
            }
        }
    }

    public function addJob()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    $this->registry->template->company = $company;
                    $this->registry->template->countries = $this->registry->recruitment->getCountries();
                    $this->registry->template->currencies = $this->registry->recruitment->getCurrencies();
                    $this->registry->template->jobRoles = $this->registry->recruitment->getJobRoles();
                    $this->registry->template->jobTypes = $this->registry->recruitment->getJobTypes();
                    $this->registry->template->coursesWithCategories = $this->registry->recruitment->coursesWithCategories();
                    $this->registry->template->diplomas = $this->registry->recruitment->diplomas();
                    $this->registry->template->page_body = getviewslink() . '/recruitment/add_job';
                    $this->registry->template->show('index_home');
                } else {
                    return header('Location: ' . $this->siteURL . '/recruitment/edit/profile');
                }
            } else {
                return header('Location: ' . $this->siteURL . '/expired');
            }
        } else {
            return header('Location: ' . $this->siteURL . '/recruitment/login');
        }
    }

    public function saveJob()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    $this->registry->recruitment->saveJob($user_id, $company->id);
                }
            }
        }
    }

    public function editJob()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    $job_id = get('job_id');
                    if ($job_id) {
                        $job = $this->registry->recruitment->getJob($job_id, $company->id);
                        if (count($job)) {
                            $this->registry->template->company = $company;
                            $this->registry->template->job = $job;
                            $this->registry->template->countries = $this->registry->recruitment->getCountries();
                            $this->registry->template->currencies = $this->registry->recruitment->getCurrencies();
                            $this->registry->template->jobRoles = $this->registry->recruitment->getJobRoles();
                            $this->registry->template->jobTypes = $this->registry->recruitment->getJobTypes();
                            $this->registry->template->coursesWithCategories = $this->registry->recruitment->coursesWithCategories();
                            $this->registry->template->diplomas = $this->registry->recruitment->diplomas();
                            $this->registry->template->page_body = getviewslink() . '/recruitment/add_job';
                            $this->registry->template->show('index_home');
                        } else {
                            self::index();
                        }
                    } else {
                        self::index();
                    }
                } else {
                    return header('Location: ' . $this->siteURL . '/recruitment/edit/profile');
                }
            } else {
                return header('Location: ' . $this->siteURL . '/expired');
            }
        } else {
            return header('Location: ' . $this->siteURL . '/recruitment/login');
        }
    }

    public function saveEditJob()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    $job_id = get('job_id');
                    if ($job_id) {
                        $job = $this->registry->recruitment->getJob($job_id, $company->id);
                        if (count($job)) {
                            $this->registry->recruitment->saveEditJob($job_id, $company->id);
                        }
                    }
                }
            }
        }
    }

    public function deleteJob()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $isExpired = $this->registry->users->isExpiredUser($user_id);
            if (!$isExpired) {
                $company = $this->registry->recruitment->hasRecruitment($user_id);
                if (count($company)) {
                    $job_id = get('job_id');
                    if ($job_id) {
                        $job = $this->registry->recruitment->getJob($job_id, $company->id);
                        if (count($job)) {
                            $this->registry->recruitment->deleteJob($job_id, $company->id);
                        }
                    }
                }
            }
        }
    }


    public function logout()
    {
        $this->registry->sessionhandler->forget();
        return header('Location: ' . $this->siteURL . '/recruitment/jobs');
    }


    public function getStates()
    {
        $country_id = post('country_id');
        if ($country_id) {
            $states = $this->registry->recruitment->getStates($country_id);
            echo '<option value="">اختر  المحافظة</option>';
            foreach ($states as $state) {
                echo '<option ' . ((isset($_POST['selected']) && $_POST['selected'] == $state->id) ? 'selected="selected"' : '') . ' value="' . $state->id . '">' . $state->name . '</option>';
            }
        }

    }

    public function getCities()
    {
        $state_id = post('state_id');
        if ($state_id) {
            $cities = $this->registry->recruitment->getCities($state_id);
            echo '<option value="">اختر  المدينة</option>';
            foreach ($cities as $city) {
                echo '<option ' . ((isset($_POST['selected']) && $_POST['selected'] == $city->id) ? 'selected="selected"' : '') . ' value="' . $city->id . '">' . $city->name . '</option>';
            }
        }
    }

    /*public function addCurrency(){
        $this->registry->recruitment->addCurrency();
    }*/
}

?>
