<?php
class recruitment extends db {

    private static $encryption;
    private static $sessionhandler2;
    private static $imagepath = "assets/images/";
    private static $profileDefaultImage = "user/75x75/anonymous.png";
    private static $recruitmentCompaniesLogoPath="assets/images/";
    private static $recruitmentEmployeeImagePath="assets/images/";
    private static $recruitmentEmployeeCVPath="assets/images/";
    private static $successRecruitmentCompanies="تم تعديل بيناتك بنجاح وسيتم تحويلك";
    private static $errorImageRecruitmentCompanies='برجاء رفع صوره مناسبة';
    private static $errorCvRecruitmentEmployee='برجاء رفع ملف مناسبة';
    private static $errorDataRecruitmentEmployee='برجاء ادخال جميع البينات';
    private static $successInsertJob='تم اضافة الوظيفه بنجاح';
    private static $successUpdateJob='تم تعديل الوظيفه بنجاح';
    private static $successSignUp='تم تسجيل بيناتك بنجاح';
    private static $successUpdateEmployeeProfile='تم تعديل الصفحة الشخصية بنجاح';
    private static $successUpdateEmployeePassword='تم تعديل كلمة المرور بنجاح';
    private static $errorInsertJob='برجاء تأكد من اضافة جيع البيانات المطلوبه';
    private static $emailOrPasswordNotExistMessage = "خطأ فى البريد الإلكترونى او كلمة المرور";
    private static $errorPasswordNotMatchEmployee = "كلمة المرور غير متطابقة";
    private static $errorOldPasswordEmployee = "كلمة المرور القديمه غير صحيحة";
    private static $errorEmployeeJobApplyMessage = "لا يمكن تنفيز طلبك ربما قد تم تنفيزه من قبل";
    private static $successEmployeeJobApplyMessage = "تم ارسال طلبك وسيتم التواصل معك فى اقرب وقت";
    private static $errorEmailExistMessage= "البريد الإلكترونى موجود بالفعل";
    private static $companySizeNames=[
        '1_10'=>'1-10 موظف',
        '11_50'=>'11-50 موظف',
        '51_100'=>'51- 100 موظف',
        '101_500'=>'101-500 موظف',
        '501_1000'=>'501-1000 موظف',
        'more_than_1000'=>'أكثر من 1000 موظف',
    ];
    private static $jobCareers=[
        'student'=>'طالب',
        'entry_level'=>'مستوى الدخول',
        'experienced_non_manager'=>'من ذوي الخبرة غير المدير',
        'manager'=>'مدير',
        'senior_management'=>'الإدارة العليا',
    ];private static $maritalStatus=[
    'unspecified'=>'غير محدد',
    'single'=>'غير مرتبط',
    'married'=>'متزوج',
];
    public function __construct() {
        /*** maybe set the db name here later ***/
        self::$encryption=new Encryption();
        self::$sessionhandler2=new SecureSessionHandler();
    }
    public  function getCountries()
    {
        $query="SELECT id,code,arab_name AS name FROM country ";
        $countries=[];
        $result=self::execquery($query);
        if($result){
            while ($obj = $result->fetch_object()) {
                $countries[]=$obj;
            }
        }
        return$countries;
    }
    public  function getStates($country_id)
    {
        $query="SELECT id,code,arab_name AS name FROM states WHERE country_id='$country_id'";
        $states=[];
        $result=self::execquery($query);
        if($result){
            while ($obj = $result->fetch_object()) {
                $states[]=$obj;
            }
        }
        return$states;
    }
    public  function getCities($state_id)
    {
        $query="SELECT id,code,arab_name AS name FROM cities WHERE state_id='$state_id'";
        $cities=[];
        $result=self::execquery($query);
        if($result){
            while ($obj = $result->fetch_object()) {
                $cities[]=$obj;
            }
        }
        return$cities;
    }
    public function submitSignUp(){
        $name=post('name');
        $email=post('email');
        $password=post('password');
        $country_id=post('country_id');
        $mobile=post('mobile');
        $countryMobile=post('countryMobile');
        if($name&&$email&&$password&&$country_id&&$mobile&&$countryMobile){
            if(!self::isEmailExist($email)){
                $date=date('Y-m-d H:i:s');
                $query="INSERT INTO users (`Email`,`Password`,`FullName`,`Mobile`) VALUES ('$email','$password','$name','$countryMobile')";
                //echo$query;
                //die();
                $id=self::execquery_id($query);
                $query="INSERT INTO recruitment_employees (`user_id`,`email`,`password`,`fullname`,`country_id`,`mobile`,`createdtime`) VALUES ('$id','$email','$password','$name','$country_id','$mobile','$date')";
                self::execquery($query);
                $errorMessage= self::$successSignUp;
                include 'views/message/success_message.php';
            }else{
                $errorMessage= self::$errorEmailExistMessage;
                include 'views/message/error_message.php';
            }
        }else{
            $errorMessage= self::$errorInsertJob;
            include 'views/message/error_message.php';
        }
    }
    public static function insertResetPassword($email) {
        $table_name='recruitment_password_tokens';
        $token = md5(uniqid(rand(), true));
        $datetoday = time();
        $end_date=date('Y-m-d H:i:s', strtotime('+1 day', $datetoday));
        $form_data=array('token'=>$token,'email'=>$email,'used'=>0,'extime'=>$end_date);
        $fields = array_keys($form_data);
        $query = "INSERT INTO ".$table_name."
        (`".implode('`,`', $fields)."`)
        VALUES('".implode("','", $form_data)."')";

        //$query = "select id  from companies where email='$email'";
        $id = self::execquery_id($query);
        if($id>0)
        {
            return $token;
        }
    }
    public static function getPasswordTokens($token) {
        $token_list = array();
        $query="select * from recruitment_password_tokens where token='$token'";
        // echo $query;
        $result = self::execquery($query);
        if ($result) {
            while ($obj = $result->fetch_object()) {
                $element = array('token' => $obj->token,
                    'email' => $obj->email,'used'=>$obj->used,'extime'=>$obj->extime );
                array_push($token_list, $element);
            }
        }
        return $token_list;

    }
    public static function updateEmployeeTokens($token) {
        $query = " update recruitment_password_tokens set used=1 where token='$token'";
        //echo($query);
        $id = self::execquery_id($query);
        return $id;
    }
    public function isEmailExist($email){
        $query="SELECT id FROM 	recruitment_employees WHERE email='$email'";
        $result=self::execquery($query);
        if($result&&$result->num_rows){
            return true;
        }
        $query="SELECT id FROM 	users WHERE Email='$email'";
        $result=self::execquery($query);
        if($result&&$result->num_rows){
            return true;
        }
        return false;
    }
    public function hasApplyJob($job_id,$employee_id){
        if($employee_id&&$job_id){
            $query="SELECT id FROM recruitment_employee_job_apply WHERE job_id='$job_id' AND employee_id='$employee_id'";
            $result=self::execquery($query);
            if($result&&$result->num_rows){
                return true;
            }
        }
        return false;
    }
    public function employeeJobApply($employee_id,$job_id){
        if($employee_id&&$job_id&&!self::hasApplyJob($job_id,$employee_id)){
            $date=date('Y-m-d H:i:s');
            $query="INSERT INTO `recruitment_employee_job_apply` (`id`, `job_id`, `employee_id`, `createtime`) VALUES (NULL, '$job_id', '$employee_id', '$date')";
            self::execquery($query);
            $errorMessage= self::$successEmployeeJobApplyMessage;
            include 'views/message/success_message.php';
            return'';
        }
        $errorMessage= self::$errorEmployeeJobApplyMessage;
        include 'views/message/error_message.php';
    }
    public function getSingleEmployee($employee_id){
        $query="SELECT
                `recruitment_employees`.*,
                 nationality.arab_name AS nationality_name,
                 country.arab_name AS country_name,
                 cities.arab_name AS city_name,
                 states.arab_name AS state_name
                 FROM
                 recruitment_employees
                 LEFT JOIN country AS nationality ON nationality.id=recruitment_employees.nationality_id
                 LEFT JOIN country ON country.id=recruitment_employees.country_id
                 LEFT JOIN cities ON cities.id=recruitment_employees.city_id
                 LEFT JOIN states ON states.id=recruitment_employees.state_id
                 WHERE
                `recruitment_employees`.`id`='$employee_id'";
        $result = self::execquery($query);
        $obj=$result->fetch_object();
        if(count($obj)){
            $obj->image=(!empty($obj->image))?self::$recruitmentEmployeeImagePath.$obj->image:self::$imagepath.self::$profileDefaultImage;
            $obj->cv=(!empty($obj->image))?self::$recruitmentEmployeeCVPath.$obj->cv:$obj->cv;
            $obj->marital_status_text=self::$maritalStatus[$obj->marital_status];
            $obj->isFull=true;
            if(empty($obj->fullname)||$obj->birthdate=='0000-00-00'||$obj->nationality_id==0||empty($obj->mobile)||$obj->country_id==0||$obj->city_id==0||$obj->state_id==0||empty($obj->address)||empty($obj->description)) {
                $obj->isFull=false;
            }
        }
        return$obj;
    }

    public function loginRecruitment($email,$password){
        $query="SELECT id FROM recruitment_employees WHERE email='$email' AND password='$password'";
        $id = 0;
        $result = self::execquery($query);
        if ($result) {
            if ($result->num_rows > 0) {
                $obj = mysqli_fetch_object($result);
                $id = $obj->id;
            }
        }
        if ($id <= 0) {
            $errorMessage= self::$emailOrPasswordNotExistMessage;
            include 'views/message/error_message.php';
        }
        return $id;
    }

    public static function 	rememberme($username,$password,$rememberme)
    {
        $cookie_name = 'Academy2017Recruitment';
        $cookie_time = (3600 * 24 * 30);
        if ($rememberme==1||$rememberme=='on'){
            setcookie ($cookie_name, 'user='.$username.'&pass='.$password.'&remember=1', time() + $cookie_time);
        }else{
            setcookie ($cookie_name, '', time() - $cookie_time);
        }
    }
    public function addUserEmployeeNotExist($user_id){
        $query="SELECT * FROM users WHERE id='$user_id'";
        $result=self::execquery($query);
        if($result&&$result->num_rows){
            $user=$result->fetch_object();
            $query="SELECT id FROM recruitment_employees WHERE user_id='$user_id'";
            $result=self::execquery($query);
            if($result&&$result->num_rows==0){
                $email=$user->Email;
                $password=$user->Password;
                $fullname=$user->FullName;
                $mobile=$user->Mobile;
                $date=date('Y-m-d H:i:s');
                $query="INSERT INTO recruitment_employees (`user_id`,`email`,`password`,`fullname`,`mobile`,`createdtime`) VALUES ('$user_id','$email','$password','$fullname','$mobile','$date')";
                self::execquery($query);
            }
        }
    }
    public function loginByUserID($user_id){
        $query="SELECT id FROM recruitment_employees WHERE user_id='$user_id'";
        $result=self::execquery($query);
        $id=0;
        if($result&&$result->num_rows>0){
            $obj=$result->fetch_object();
            $id=$obj->id;
        }
        return $id;
    }
    public function getEmployeeDetails($employee_id){
        $query="SELECT
                recruitment_employees.*,
                nationality.arab_name AS nationality_name,
                country.arab_name AS country_name,
                cities.arab_name AS city_name,
                states.arab_name AS state_name
                FROM
                recruitment_employees
                LEFT JOIN country AS nationality ON nationality.id=recruitment_employees.nationality_id
                LEFT JOIN country ON country.id=recruitment_employees.country_id
                LEFT JOIN cities ON cities.id=recruitment_employees.city_id
                LEFT JOIN states ON states.id=recruitment_employees.state_id
                WHERE
                recruitment_employees.id='$employee_id'";
        $result=self::execquery($query);
        $user=$result->fetch_object();
        if(count($user)){
            if(empty($user->image)||!file_exists(self::$imagepath.$user->image)){
                $user->image=self::$imagepath.self::$profileDefaultImage;
            }else{
                $user->image=self::$imagepath.$user->image;
            }
            $user->cv=self::$recruitmentEmployeeCVPath.$user->cv;
        }
        return $user;
    }
    public function editEmployeeProfile($employee_id){
        $name=post('name');
        $birthdate=post('birthdate');
        $description=post('description');
        $gender=post('gender');
        $nationality_id=post('nationality_id');
        $marital_status=post('marital_status');
        $number_dependants=post('number_dependants');
        $mobile=post('mobile');
        $mobile_1=post('mobile_1');
        $country_id=post('country_id');
        $state_id=post('state_id');
        $city_id=post('city_id');
        $address=post('address');
        $postal_code=post('postal_code');
        $cv=isset($_FILES['cv'])?$_FILES['cv']:false;
        $image=isset($_FILES['image'])?$_FILES['image']:false;
        if($cv&&!in_array($_FILES['cv']['type'],['application/msword','application/vnd.openxmlformats-officedocument.wordprocessingml.document','application/pdf'])){
            $errorMessage= self::$errorCvRecruitmentEmployee;
            include 'views/message/error_message.php';
            return'';
        }
        if($image&&!in_array($_FILES['image']['type'],['image/jpeg','image/png','image/gif'])){
            $errorMessage= self::$errorCvRecruitmentEmployee;
            include 'views/message/error_message.php';
            return'';
        }
        if($name&&$birthdate&&$description&&$gender&&$nationality_id&&$marital_status&&$mobile&&$country_id&&$city_id&&$state_id&&$address&&$postal_code){
            $date=date('Y-m-d H:i:s');
            $query="UPDATE recruitment_employees SET fullname='$name',description='$description',birthdate='$birthdate',gender='$gender',nationality_id='$nationality_id',marital_status='$marital_status',number_dependants='$number_dependants',country_id='$country_id',city_id='$city_id',state_id='$state_id',postal_code='$postal_code',mobile='$mobile',mobile_1='$mobile_1',address='$address',modifiedtime='$date' WHERE id='$employee_id'";
            self::execquery($query);
            if($cv){
                if(in_array($_FILES['cv']['type'],['application/msword','application/vnd.openxmlformats-officedocument.wordprocessingml.document','application/pdf'])){
                    $path = $_FILES['cv']['name'];
                    $ext = pathinfo($path, PATHINFO_EXTENSION);
                    $filename='employeeCV-'.rand(0,9999).time().'.'.$ext;
                    $query="UPDATE `recruitment_employees` SET cv='$filename' WHERE id='$employee_id'";
                    self::execquery($query);
                    move_uploaded_file($_FILES['cv']['tmp_name'],self::$recruitmentEmployeeCVPath.$filename);
                }
            }
            if($image){
                if(in_array($_FILES['image']['type'],['image/jpeg','image/png','image/gif'])){
                    $path = $_FILES['image']['name'];
                    $ext = pathinfo($path, PATHINFO_EXTENSION);
                    $filename='employeeImage-'.rand(0,9999).time().'.'.$ext;
                    $query="UPDATE `recruitment_employees` SET image='$filename' WHERE id='$employee_id'";
                    self::execquery($query);
                    move_uploaded_file($_FILES['image']['tmp_name'],self::$recruitmentEmployeeImagePath.$filename);
                }
            }
            $errorMessage= self::$successUpdateEmployeeProfile;
            include 'views/message/success_message.php';
        }else{
            $errorMessage= self::$errorDataRecruitmentEmployee;
            include 'views/message/error_message.php';
            return'';
        }
    }
    public static function updateEmployeePassword($email,$newpassowrd) {
        $query = " update recruitment_employees set password='$newpassowrd' where Email='$email'";
        $id = self::execquery_id($query);
        return $id;
    }
    public function changeEmployeePassword($employee_id){
        $old_password=post('old_password');
        $new_password=post('new_password');
        $confirm_password=post('confirm_password');

        if($old_password&&$new_password&&$confirm_password){
            $query="SELECT * FROM recruitment_employees WHERE id='$employee_id'";
            $result=self::execquery($query);
            $user=$result->fetch_object();
            if($old_password==$user->password){
                if($new_password==$confirm_password){
                    $query="UPDATE recruitment_employees SET password='$new_password' WHERE id='$employee_id'";
                    self::execquery($query);
                    $errorMessage= self::$successUpdateEmployeePassword;
                    include 'views/message/success_message.php';
                }else{
                    $errorMessage= self::$errorPasswordNotMatchEmployee;
                    include 'views/message/error_message.php';
                    return'';
                }
            }else{
                $errorMessage= self::$errorOldPasswordEmployee;
                include 'views/message/error_message.php';
                return'';
            }
        }else{
            $errorMessage= self::$errorDataRecruitmentEmployee;
            include 'views/message/error_message.php';
            return'';
        }
    }
    public function getJobsCount($q="",$filter=[],$order=""){
        $query="SELECT
                COUNT(`recruitment_jobs`.`id`) AS count_data
                FROM
                recruitment_jobs
                LEFT JOIN recruitment_companies ON recruitment_companies.id=recruitment_jobs.recruitment_company_id
                LEFT JOIN country ON country.id=recruitment_jobs.country_id
                LEFT JOIN cities ON cities.id=recruitment_jobs.city_id
                LEFT JOIN states ON states.id=recruitment_jobs.state_id
               WHERE deleted='0' $q ";
        if(isset($filter['countries'])){
            foreach($filter['countries'] as $country_id){
                if(is_int(intval($country_id))){
                    $query.="AND recruitment_jobs.country_id='$country_id' ";
                }
            }
        }
        if(isset($filter['cities'])&&is_array($filter['cities'])){
            foreach($filter['cities'] as $city_id){
                if(is_int(intval($city_id))){
                    $query.="AND recruitment_jobs.city_id='$city_id' ";
                }
            }
        }
        if(isset($filter['states'])&&is_array($filter['states'])){
            foreach($filter['states'] as $state_id){
                if(is_int(intval($state_id))){
                    $query.="AND recruitment_jobs.state_id='$state_id' ";
                }
            }
        }
        if(isset($filter['careers'])&&is_array($filter['careers'])){
            foreach($filter['careers'] as $career){
                if(is_string($career)&&in_array($career,['student','entry_level','experienced_non_manager','manager','senior_management'])){
                    $query.="AND recruitment_jobs.career='$career' ";
                }
            }
        }
        if(isset($filter['q'])){
            $search=$filter['q'];
            $query.="AND (recruitment_jobs.title LIKE '%$search%' OR country.name LIKE '%$search%' OR country.arab_name LIKE '%$search%' OR cities.name LIKE '%$search%' OR cities.arab_name LIKE '%$search%' OR states.name LIKE '%$search%' OR states.arab_name LIKE '%$search%'  OR recruitment_jobs.description LIKE '%$search%'  OR recruitment_jobs.requirement LIKE '%$search%' OR recruitment_companies.name LIKE '%$search%')";
        }
        $query.=$order;
        $result=self::execquery($query);
        $obj=$result->fetch_object();
        return $obj->count_data;
    }
    public function getSearchJobs($q="",$filter=[],$order="ORDER BY createdtime DESC LIMIT 5"){
        $query="SELECT
                recruitment_jobs.*,
                recruitment_companies.name AS company_name,
                recruitment_companies.logo AS company_logo,
                country.arab_name AS country_name,
                cities.arab_name AS city_name,
                states.arab_name AS state_name
                FROM
                recruitment_jobs
                LEFT JOIN recruitment_companies ON recruitment_companies.id=recruitment_jobs.recruitment_company_id
                LEFT JOIN country ON country.id=recruitment_jobs.country_id
                LEFT JOIN cities ON cities.id=recruitment_jobs.city_id
                LEFT JOIN states ON states.id=recruitment_jobs.state_id
               WHERE deleted='0' $q ";
        if(isset($filter['countries'])){
            foreach($filter['countries'] as $country_id){
                if(is_int(intval($country_id))){
                    $query.="AND recruitment_jobs.country_id='$country_id' ";
                }
            }
        }
        if(isset($filter['cities'])&&is_array($filter['cities'])){
            foreach($filter['cities'] as $city_id){
                if(is_int(intval($city_id))){
                    $query.="AND recruitment_jobs.city_id='$city_id' ";
                }
            }
        }
        if(isset($filter['states'])&&is_array($filter['states'])){
            foreach($filter['states'] as $state_id){
                if(is_int(intval($state_id))){
                    $query.="AND recruitment_jobs.state_id='$state_id' ";
                }
            }
        }
        if(isset($filter['careers'])&&is_array($filter['careers'])){
            foreach($filter['careers'] as $career){
                if(is_string($career)&&in_array($career,['student','entry_level','experienced_non_manager','manager','senior_management'])){
                    $query.="AND recruitment_jobs.career='$career' ";
                }
            }
        }
        if(isset($filter['q'])){
            $search=$filter['q'];
            $query.="AND (recruitment_jobs.title LIKE '%$search%' OR country.name LIKE '%$search%' OR country.arab_name LIKE '%$search%' OR cities.name LIKE '%$search%' OR cities.arab_name LIKE '%$search%' OR states.name LIKE '%$search%' OR states.arab_name LIKE '%$search%'  OR recruitment_jobs.description LIKE '%$search%'  OR recruitment_jobs.requirement LIKE '%$search%' OR recruitment_companies.name LIKE '%$search%')";
        }
        $query.=$order;
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $obj->company_logo=(!empty($obj->company_logo))?self::$recruitmentCompaniesLogoPath.$obj->company_logo:$obj->company_logo;
            $obj->career_text=self::$jobCareers[$obj->career];
            $obj->job_roles_array=self::getJobsRolesBy($obj->id);
            $obj->job_types_array=self::getJobsTypesBy($obj->id);
            $data[]=$obj;
        }
        return $data;
    }

    public function hasRecruitment($user_id){
        $query="SELECT
                      recruitment_companies.*,
                      recruitment_industries.name AS industry_name,
                      country.arab_name AS country_name,
                      cities.arab_name AS city_name,
                      states.arab_name AS state_name
                      FROM
                      recruitment_companies
                      LEFT JOIN recruitment_industries ON recruitment_industries.id=recruitment_companies.industry_id
                      LEFT JOIN country ON country.id=recruitment_companies.country_id
                      LEFT JOIN cities ON cities.id=recruitment_companies.city_id
                      LEFT JOIN states ON states.id=recruitment_companies.state_id
                      WHERE user_id='$user_id'";
        $result=self::execquery($query);
        $user=$result->fetch_object();
        if(count($user)){
            $user->logo=self::$recruitmentCompaniesLogoPath.$user->logo;
            $user->company_size_text=self::$companySizeNames[$user->company_size];
        }
        return $user;
    }
    public function getSingleCompany($user_id){
        $query="SELECT
                      recruitment_companies.*,
                      recruitment_industries.name AS industry_name,
                      country.arab_name AS country_name,
                      cities.arab_name AS city_name,
                      states.arab_name AS state_name
                      FROM
                      recruitment_companies
                      LEFT JOIN recruitment_industries ON recruitment_industries.id=recruitment_companies.industry_id
                      LEFT JOIN country ON country.id=recruitment_companies.country_id
                      LEFT JOIN cities ON cities.id=recruitment_companies.city_id
                      LEFT JOIN states ON states.id=recruitment_companies.state_id
                      WHERE recruitment_companies.id='$user_id'";
        $result=self::execquery($query);
        $user=$result->fetch_object();
        if(count($user)){
            $user->logo=self::$recruitmentCompaniesLogoPath.$user->logo;
            $user->company_size_text=self::$companySizeNames[$user->company_size];
        }
        return $user;
    }
    public function getCountriesJson(){
        $query="SELECT id,arab_name AS name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.country_id=country.id) AS count_data  FROM country";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return json_encode($data);
    }
    public function getCitiesJson(){
        $query="SELECT id,arab_name AS name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.city_id=cities.id) AS count_data FROM cities";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return json_encode($data);
    }
    public function getStatesJson(){
        $query="SELECT id,arab_name AS name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.state_id=states.id) AS count_data FROM states";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return json_encode($data);
    }
    public function getCountriesWithCount($ids=[]){
        $ids=implode("','",$ids);
        $query="SELECT country.id,country.name,country.arab_name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.country_id=country.id) AS count_data FROM country ORDER BY count_data DESC LIMIT 0,10";
        $result=self::execquery($query);
        $data=[];
        $notIds=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
            $notIds[]=$obj->id;
        }
        if(!empty($ids)){
            $notIds=implode("','",$notIds);
            $query="SELECT country.id,country.name,country.arab_name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.country_id=country.id) AS count_data FROM country WHERE id IN ('$ids') AND id NOT IN ('$notIds') ORDER BY count_data DESC";
            $result=self::execquery($query);
            while($obj=$result->fetch_object()){
                $data[]=$obj;
            }
        }
        return $data;
    }
    public function getCitiesWithCount($ids=[]){
        $ids=implode("','",$ids);
        $query="SELECT cities.id,cities.name,cities.arab_name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.city_id=cities.id) AS count_data FROM cities ORDER BY count_data DESC LIMIT 0,10";
        $result=self::execquery($query);
        $data=[];
        $notIds=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
            $notIds[]=$obj->id;
        }
        if(!empty($ids)){
            $notIds=implode("','",$notIds);
            $query="SELECT cities.id,cities.name,cities.arab_name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.city_id=cities.id) AS count_data FROM cities WHERE id IN ('$ids') AND id NOT IN ('$notIds') ORDER BY count_data DESC";
            $result=self::execquery($query);
            while($obj=$result->fetch_object()){
                $data[]=$obj;
            }
        }
        return $data;
    }
    public function getStatesWithCount($ids=[]){
        $ids=implode("','",$ids);
        $query="SELECT states.id,states.name,states.arab_name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.state_id=states.id) AS count_data FROM states ORDER BY count_data DESC LIMIT 0,10";
        $result=self::execquery($query);
        $data=[];
        $notIds=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
            $notIds[]=$obj->id;
        }
        if(!empty($ids)){
            $notIds=implode("','",$notIds);
            $query="SELECT states.id,states.name,states.arab_name,(SELECT COUNT(id) FROM recruitment_jobs WHERE recruitment_jobs.state_id=states.id) AS count_data FROM states WHERE id IN ('$ids') AND id NOT IN ('$notIds') ORDER BY count_data DESC";
            $result=self::execquery($query);
            while($obj=$result->fetch_object()){
                $data[]=$obj;
            }
        }
        return $data;
    }
    public function getCareersWithCount(){
        $query="SELECT (SELECT COUNT(id) FROM `recruitment_jobs` WHERE career='student') AS count_data,'student' AS career
UNION ALL
SELECT (SELECT COUNT(id) FROM `recruitment_jobs` WHERE career='entry_level') AS count_data,'entry_level' AS career
UNION ALL
SELECT (SELECT COUNT(id) FROM `recruitment_jobs` WHERE career='experienced_non_manager') AS count_data,'experienced_non_manager' AS career
UNION ALL
SELECT (SELECT COUNT(id) FROM `recruitment_jobs` WHERE career='manager') AS count_data,'manager' AS career
UNION ALL
SELECT (SELECT COUNT(id) FROM `recruitment_jobs` WHERE career='senior_management') AS count_data,'senior_management' AS career";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $obj->career_text=self::$jobCareers[$obj->career];
            $data[]=$obj;
        }
        return $data;
    }
    public function getIndustries(){
        $query="SELECT * FROM recruitment_industries";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return $data;
    }
    public function getCurrencies(){
        $query="SELECT * FROM recruitment_currencies";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return $data;
    }
    public function getJobRoles(){
        $query="SELECT * FROM recruitment_job_roles";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return $data;
    }
    public function getJobsRolesBy($job_id,$name='name'){
        $query="SELECT recruitment_job_roles.* FROM recruitment_jobs_roles INNER JOIN recruitment_job_roles ON recruitment_job_roles.id=recruitment_jobs_roles.recruitment_job_role_id WHERE recruitment_job_id='$job_id'";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj->$name;
        }
        return $data;
    }
    public function getJobTypes(){
        $query="SELECT * FROM recruitment_job_types";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return $data;
    }
    public function getJobsTypesBy($job_id,$name='name'){
        $query="SELECT recruitment_job_types.* FROM recruitment_jobs_types INNER JOIN recruitment_job_types ON recruitment_job_types.id=recruitment_jobs_types.recruitment_job_type_id WHERE recruitment_job_id='$job_id'";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj->$name;
        }
        return $data;
    }
    public function getCompanyJobs($company_id){
        $query="SELECT
                recruitment_jobs.*,
                recruitment_companies.name AS company_name,
                recruitment_companies.logo AS company_logo,
                country.arab_name AS country_name,
                cities.arab_name AS city_name,
                states.arab_name AS state_name,
                (SELECT COUNT(id) FROM recruitment_employee_job_apply WHERE recruitment_employee_job_apply.job_id=recruitment_jobs.id) AS count_apply
                FROM
                recruitment_jobs
                LEFT JOIN recruitment_companies ON recruitment_companies.id=recruitment_jobs.recruitment_company_id
                LEFT JOIN country ON country.id=recruitment_jobs.country_id
                LEFT JOIN cities ON cities.id=recruitment_jobs.city_id
                LEFT JOIN states ON states.id=recruitment_jobs.state_id
                WHERE
                recruitment_jobs.recruitment_company_id='$company_id' AND `recruitment_jobs`.`deleted`='0'";
        //echo$query;
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $obj->company_logo=(!empty($obj->company_logo))?self::$recruitmentCompaniesLogoPath.$obj->company_logo:$obj->company_logo;
            $obj->career_text=self::$jobCareers[$obj->career];
            $obj->job_roles_array=self::getJobsRolesBy($obj->id);
            $obj->job_types_array=self::getJobsTypesBy($obj->id);
            $data[]=$obj;
        }
        return $data;
    }
    public function getCompanyJobApplicants($job_id){
        $query="SELECT recruitment_employees.*,recruitment_employee_job_apply.createtime AS applicantcreatetime FROM recruitment_employee_job_apply INNER JOIN recruitment_employees ON recruitment_employees.id=recruitment_employee_job_apply.employee_id WHERE job_id='$job_id'";
        $result=self::execquery($query);
        $data=[];
        while($obj=$result->fetch_object()){
            $data[]=$obj;
        }
        return $data;
    }
    public function getSingleJob($job_id,$company_id=0){
        $query="SELECT
                recruitment_jobs.*,
                recruitment_companies.name AS company_name,
                recruitment_companies.logo AS company_logo,
                recruitment_companies.description AS company_description,
                country.arab_name AS country_name,
                cities.arab_name AS city_name,
                states.arab_name AS state_name
                FROM
                recruitment_jobs
                LEFT JOIN recruitment_companies ON recruitment_companies.id=recruitment_jobs.recruitment_company_id
                LEFT JOIN country ON country.id=recruitment_jobs.country_id
                LEFT JOIN cities ON cities.id=recruitment_jobs.city_id
                LEFT JOIN states ON states.id=recruitment_jobs.state_id
                WHERE
               `recruitment_jobs`.`deleted`='0' AND recruitment_jobs.id='$job_id'";
        $query.=($company_id)?" AND recruitment_company_id='$company_id'":'';
        $result=self::execquery($query);
        $obj=$result->fetch_object();
        if(count($obj)){
            $obj->company_logo=(!empty($obj->company_logo))?self::$recruitmentCompaniesLogoPath.$obj->company_logo:$obj->company_logo;
            $obj->career_text=self::$jobCareers[$obj->career];
            $obj->job_roles_array=self::getJobsRolesBy($obj->id);
            $obj->job_types_array=self::getJobsTypesBy($obj->id);
        }
        return$obj;
    }
    public function getJob($job_id,$company_id){
        $query="SELECT `recruitment_jobs`.* FROM recruitment_jobs WHERE `recruitment_jobs`.`id`='$job_id' AND `recruitment_jobs`.`recruitment_company_id`='$company_id' AND `recruitment_jobs`.`deleted`='0'";
        $result=self::execquery($query);
        $obj=$result->fetch_object();
        if(count($obj)){
            $obj->job_roles_array=self::getJobsRolesBy($obj->id,'id');
            $obj->job_types_array=self::getJobsTypesBy($obj->id,'id');
        }
        return $obj;
    }

    public function getRecruitmentCompanyID($user_id){
        $data=self::hasRecruitment($user_id);
        if(count($data)){
            return $data->id;
        }
        $date=date('Y-m-d H:i:s');
        $query="INSERT INTO `recruitment_companies` (`id`, `user_id`, `industry_id`, `name`, `company_size`, `website`, `founded_year`, `facebook`, `linkedin`, `blog`, `twitter`, `description`, `createdtime`) VALUES (NULL, '$user_id', '', '', '', '', '', '', '', '', '', '', '$date')";
        $id=self::execquery_id($query);
        return$id;
    }

    public function editCompanyProfile($user_id){
        $name=post('name');
        $industry_id=post('industry_id');
        $company_size=post('company_size');
        $website=post('website');
        $founded_year=post('founded_year');
        $facebook=post('facebook');
        $linkedin=post('linkedin');
        $blog=post('blog');
        $twitter=post('twitter');
        $description=post('description');
        $country_id=post('country_id');
        $city_id=post('city_id');
        $state_id=post('state_id');
        $logo=isset($_FILES['logo'])?$_FILES['logo']:false;
        if($name&&$country_id&&$city_id&&$state_id&&$industry_id&&$company_size&&$description){
            $id=self::getRecruitmentCompanyID($user_id);
            if($logo){
                if(in_array($_FILES['logo']['type'],['image/jpeg','image/png','image/gif'])){
                    $path = $_FILES['logo']['name'];
                    $ext = pathinfo($path, PATHINFO_EXTENSION);
                    $filename='recruitmentCompany-'.rand(0,9999).time().'.'.$ext;
                    $query="UPDATE `recruitment_companies` SET logo='$filename' WHERE id='$id'";
                    self::execquery($query);
                    move_uploaded_file($_FILES['logo']['tmp_name'],self::$recruitmentCompaniesLogoPath.$filename);
                }else{
                    $errorMessage= self::$errorImageRecruitmentCompanies;
                    include 'views/message/error_message.php';
                    return'';
                }
            }
            $query="UPDATE `recruitment_companies` SET name='$name',industry_id='$industry_id',country_id='$country_id',city_id='$city_id',state_id='$state_id',company_size='$company_size',website='$website',founded_year='$founded_year',facebook='$facebook',linkedin='$linkedin',blog='$blog',twitter='$twitter',description='$description' WHERE id='$id'";
            self::execquery($query);
            $errorMessage = self::$successRecruitmentCompanies;
            include 'views/message/success_message.php';
        }
        $errorMessage = self::$errorDataRecruitmentEmployee;
        include 'views/message/success_message.php';
    }
    public function saveJob($user_id,$company_id){
        $title=post('title');
        $country_id=post('country_id');
        $state_id=post('state_id');
        $city_id=post('city_id');
        $career=post('career');
        $experience_years=post('experience_years');
        $salary_min=post('salary_min');
        $salary_max=post('salary_max');
        $currency_id=post('currency_id');
        $time_period=post('time_period');
        $hidden_salary=post('hidden_salary');
        $salary_info=post('salary_info');
        $num_vacancies=post('num_vacancies');
        $job_roles=isset($_POST['job_roles'])?$_POST['job_roles']:false;
        $job_types=isset($_POST['job_types'])?$_POST['job_types']:false;
        $description=post('description');
        $requirement=post('requirement');
        if($title&&$country_id&&$city_id&&$state_id&&$career&&$experience_years&&$salary_min&&$salary_max&&$currency_id&&$time_period&&$salary_info&&$num_vacancies&&is_array($job_roles)&&is_array($job_types)&&$description&&$requirement){
            $date=date('Y-m-d H:i:s');
            $query="INSERT INTO `recruitment_jobs` (`id`, `user_id`, `recruitment_company_id`, `title`, `country_id`, `city_id`, `state_id`, `career`, `experience_years`, `salary_min`, `salary_max`, `currency_id`, `time_period`, `hidden_salary`, `salary_info`, `num_vacancies`, `description`, `requirement`, `createdtime`) VALUES (NULL, '$user_id', '$company_id', '$title', '$country_id', '$city_id', '$state_id', '$career', '$experience_years', '$salary_min', '$salary_max', '$currency_id', '$time_period', '$hidden_salary', '$salary_info', '$num_vacancies', '$description', '$requirement', '$date')";
            $id=self::execquery_id($query);
            foreach($job_roles as $job_role){
                $query="INSERT INTO `recruitment_jobs_roles` (`id`, `recruitment_job_id`, `recruitment_job_role_id`, `createtime`) VALUES (NULL, '$id', '$job_role','$date')";
                self::execquery($query);
            }
            foreach($job_types as $job_type){
                $query="INSERT INTO `recruitment_jobs_types` (`id`, `recruitment_job_id`, `recruitment_job_type_id`, `createtime`) VALUES (NULL, '$id', '$job_type', '$date')";
                self::execquery($query);
            }
            $errorMessage = self::$successInsertJob;
            include 'views/message/success_message.php';
            return'';
        }
        $errorMessage = self::$errorInsertJob;
        include 'views/message/error_message.php';
    }
    public function saveEditJob($job_id,$company_id){
        $title=post('title');
        $country_id=post('country_id');
        $state_id=post('state_id');
        $city_id=post('city_id');
        $career=post('career');
        $experience_years=post('experience_years');
        $salary_min=post('salary_min');
        $salary_max=post('salary_max');
        $currency_id=post('currency_id');
        $time_period=post('time_period');
        $hidden_salary=post('hidden_salary');
        $salary_info=post('salary_info');
        $num_vacancies=post('num_vacancies');
        $job_roles=isset($_POST['job_roles'])?$_POST['job_roles']:false;
        $job_types=isset($_POST['job_types'])?$_POST['job_types']:false;
        $description=post('description');
        $requirement=post('requirement');
        if($title&&$country_id&&$city_id&&$state_id&&$career&&$experience_years&&$salary_min&&$salary_max&&$currency_id&&$time_period&&$salary_info&&$num_vacancies&&is_array($job_roles)&&is_array($job_types)&&$description&&$requirement){
            $date=date('Y-m-d H:i:s');
            $query="UPDATE `recruitment_jobs` SET `title`='$title', `country_id`='$country_id', `city_id`='$city_id', `state_id`='$state_id', `career`='$career', `experience_years`='$experience_years', `salary_min`='$salary_min', `salary_max`='$salary_max', `currency_id`='$currency_id', `time_period`='$time_period', `hidden_salary`='$hidden_salary', `salary_info`='$salary_info', `num_vacancies`='$num_vacancies', `description`='$description', `requirement`='$requirement', `modifiedtime`='$date' WHERE id='$job_id' AND recruitment_company_id='$company_id'";
            self::execquery($query);
            $query="DELETE FROM recruitment_jobs_roles WHERE recruitment_job_id='$job_id'";
            self::execquery($query);
            $query="DELETE FROM recruitment_jobs_types WHERE recruitment_job_id='$job_id'";
            self::execquery($query);
            foreach($job_roles as $job_role){
                $query="INSERT INTO `recruitment_jobs_roles` (`id`, `recruitment_job_id`, `recruitment_job_role_id`, `createtime`) VALUES (NULL, '$job_id', '$job_role', '$date')";
                self::execquery($query);
            }
            foreach($job_types as $job_type){
                $query="INSERT INTO `recruitment_jobs_types` (`id`, `recruitment_job_id`, `recruitment_job_type_id`, `createtime`) VALUES (NULL, '$job_id', '$job_type', '$date')";
                self::execquery($query);
            }
            $errorMessage = self::$successUpdateJob;
            include 'views/message/success_message.php';
            return'';
        }
        $errorMessage = self::$errorInsertJob;
        include 'views/message/error_message.php';
    }
    public function deleteJob($job_id,$company_id){
        $date=date('Y-m-d H:i:s');
        $query="UPDATE `recruitment_jobs` SET `recruitment_jobs`.`deleted`='1',`recruitment_jobs`.`deletedtime`='$date' WHERE `recruitment_jobs`.`id`='$job_id' AND `recruitment_jobs`.`recruitment_company_id`='$company_id'";
        $result=self::execquery($query);
        echo $result;
    }
    public function getFilterURL($filter){
        $filter=(empty($filter))?(isset($_SERVER['REDIRECT_URL']))?str_replace($_SERVER['REDIRECT_URL'],'',$_SERVER['REQUEST_URI']):"":$filter;
        if (strpos($filter, '?') === false) {
            $filter='?'.$filter;
        }
        parse_str(parse_url($filter,PHP_URL_QUERY),$data);
        return$data;
    }

    /* public function addCurrency(){
         $text=post('text');
         $query="INSERT INTO `recruitment_job_types` (`id`, `name`, `createdtime`, `modifiedtime`) VALUES (NULL, '$text', NOW(), NOW())";
         self::execquery($query);
     }*/
}