<?php
Class recruitController Extends baseController {

    public function index(){

        $recruit_id=get('recruit_id');
        if($recruit_id){
            $recruit=$this->registry->users->getRecruit($recruit_id);
           
            if(count($recruit)){
                $this->viewRecruit($recruit,$recruit_id);
                return'';
            }
        }
        $this->addRecruit();
    }
    public function viewRecruit($recruit,$recruit_id){
        $userID=$this->getuserid();
        if($userID){
            $this->registry->template->countries=$this->registry->users->getCountries();
            $this->registry->template->recruit_id=$recruit_id;
            $this->registry->template->recruit=$recruit;
            
            $this->registry->template->page_body = getviewslink().'/academy/singlerecruit';
            $this->registry->template->show('index_home');
        }else{
            return header('Location: /login');
        }
    }
    public function addRecruit(){
        $userID=$this->getuserid();
        if($userID){
            $isExpiredUser=$this->registry->users->isExpiredUser($userID);
            if(!$isExpiredUser){
                $this->registry->template->countries=$this->registry->users->getCountries();
                $this->registry->template->page_body = getviewslink().'/academy/recruit';
                $this->registry->template->show('index_home');
            }else{
                return header('Location: /subscriptions');
            }


        }else{
            return header('Location: /login');
        }
    }
    public function getStates(){
        $country_id=post('country_id');
        if($country_id){
            $states=$this->registry->users->getStates($country_id);
            echo'<option value="">اختر  المحافظة</option>';
            foreach($states as $state){
                echo'<option value="'.$state->id.'">'.$state->name.'</option>';
            }
        }

    }
    public function getCities(){
        $city_id=post('city_id');
        if($city_id){
            $states=$this->registry->users->getCities($city_id);
            echo'<option value="">اختر  المدينة</option>';
            foreach($states as $state){
                echo'<option value="'.$state->id.'">'.$state->name.'</option>';
            }
        }
    }
    public function saveRecruit(){
        $this->registry->users->saveRecruit($this->siteURL);
    }
    public function registerRecruit(){
        $this->registry->users->registerRecruit();
    }



}

?>
