<?php
class preparatorymbaController Extends baseController
{
    public function index()
    {
        if ($_SERVER['REQUEST_URI'] == '/?page=MBA') {
            return header('Location: /MBA');
        }
        if (strpos($_SERVER['REQUEST_URI'], '?offer_id') !== false) {
            $explode = explode('?offer_id', $_SERVER['REQUEST_URI']);
            $implode = implode('&offer_id', $explode);
            return header('Location: ' . $implode);
        }
        global $location;
        $location = $this->getlocation();
        $module_id = get('module_id');
        $user_id=$this->getuserid();
        $hasModule=$this->registry->users->hasMBA($user_id);
        $this->registry->template->hasMBA =$hasModule ;
        $this->registry->template->courses = $this->registry->users->getMbaHelperCourses($hasModule);
        if (!empty($module_id)) {
            $module = $this->registry->users->getsinglembamodule($module_id);
            //print_r($module);
            if (!isset($module->id)) {
                self::redirect404();
                exit;
            }
            if(isset($_GET['action'])&&$_GET['action']=='projectTab'){
                $user_id=$this->getuserid();
                $projectData=$this->registry->users->getModuleProjectData($module->id,$user_id,$module->hasModule);
                $this->registry->template->projectData=$projectData;
//                if($user_id==601999){
//                    print_r($projectData);
//                }
                $summary=$this->registry->users->getModuleUserSummary($module->id,$user_id);
                $this->registry->template->summary=$summary;
            }
            if(isset($_GET['action'])&&$_GET['action']=='summaryTab'){
                $user_id=$this->getuserid();
                $summary=$this->registry->users->getModuleUserSummary($module->id,$user_id);
                $this->registry->template->summary=$summary;
            }
            self::display_single_mba_module($module_id, $module);
        } else {
            self::get_all_mba();
        }
    }
    public function display_single_mba_module($module_id, $module)
    {
        if(!$module->hasModule){return header('Location: /subscribe');exit;}
        $courses=$this->registry->users->getmbamodulecourses($module->hasModule," and  mba.url='$module_id' AND courses.published='yes'  order by mba_module_courses.sort asc ");
        $this->registry->template->courses=$courses;
        $this->registry->template->module=$module;
        $this->registry->template->page_body = getviewslink() . '/academy/singlemba';
        $this->registry->template->show('index_home');
    }
    public function get_all_mba()
    {
        $mba = $this->registry->users->getallmba();
        $brochure = $this->registry->users->getmbabrochure();
        $accreditations=$this->registry->users->getaccreditationstype('mba',1);
        $this->registry->template->accreditations=$accreditations;
        $this->registry->template->mba = $mba;
        $this->registry->template->brochure = $brochure;
        $user_id=$this->getuserid();
        $this->registry->template->hasMBA = $this->registry->users->hasMBA($user_id);

        $this->registry->template->page_body = getviewslink() . '/academy/preparatorymba';
        $this->registry->template->show('index_home');
    }
    public function downloadProject(){

        $project_id=post('project_id');
        $module_id=post('module_id');
        $user_id=$this->getuserid();
        $this->registry->users->downloadProject($user_id,$project_id,$module_id);
    }
    public function uploadProject(){
        $user_action='Upload Project';
        $user_action_table='modules_users_projects';
        $user_action_table_id=post('project_id');
        $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
        $project_id=post('project_id');
        $module_id=post('module_id');
        $user_id=$this->getuserid();
        $this->registry->users->uploadProject($user_id,$project_id,$module_id);
    }
    public function helperCourses(){
        $user_id=$this->getuserid();
        $hasModule=$this->registry->users->hasMBA($user_id);
        $this->registry->template->hasMBA =$hasModule ;
        $this->registry->template->courses = $this->registry->users->getMbaHelperCourses($hasModule);
        $this->registry->template->page_body = getviewslink() . '/academy/mba';
        $this->registry->template->show('index_home');
    }
    public function singleHelperCourse(){
        $user_id=$this->getuserid();
        $hasModule=$this->registry->users->hasMBA($user_id);
        $this->registry->template->hasMBA =$hasModule ;
        $course_id=get('course_id');
        if($course_id){
            $course=$this->registry->users->getSingleMbaHlperCoure($course_id);
            if(isset($course->id)){
                $course->hasCourse=$hasModule;
                $helperCourse=$hasModule;
                $this->registry->template->helperCourse=$helperCourse;
                $this->registry->template->course=$course;
                $sections=$this->registry->users->getcourse_sections($course->id);
                $this->registry->template->sections=$sections;
                if($this->getuserid()){
                    $this->registry->template->courses_questions=$this->registry->users->getCourseQuestionsAnswers($course->id,$this->getuserid());
                }
                //$courses=$this->registry->users->getallcourses();
                //	$this->registry->template->courses=$courses;
                //faq
                $faqs=$this->registry->users->getfaq($course->id);
                $this->registry->template->faqs=$faqs;
                //faq
                $accreditations=$this->registry->users->getaccreditationstype('course',1);
                $this->registry->template->accreditations=$accreditations;
                $this->registry->template->page_body = getviewslink().'/academy/singlecourse';
                $this->registry->template->show('index_home');
            }else{
                self::helperCourses();
            }
        }
    }
    public function showCurriculum(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $user_id=$this->getuserid();
        if($user_id){
            $hasModule=$this->registry->users->hasMBA($user_id);
            $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
            if($hasModule||$video->isfree){
                $this->registry->template->hasMBA =$hasModule ;
                $this->registry->template->helperCourse =true ;
                $course=$this->registry->users->getSingleMbaHlperCoure($course_id);
                if(isset($course->id)){
                    $this->registry->users->update_last_login_mba($this->getuserid(),$course->id);
                    $course->hasCourse=$hasModule;
                    $this->registry->template->course=$course;
                    $this->registry->template->video=$video;
                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                    $this->registry->template->sections=$sections;
                    $this->registry->template->show('/academy/showvideo');
                }
            }
        }else{
            //$this->registry->sessionhandler->put('HTTP_REFERER','courses/'.$course_id.'/showCurriculum/'.$course_curriculum_id);
            return header('Location: /login');
        }
    }
    public function showCurriculumaudio(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $user_id=$this->getuserid();
        if($user_id){
            $hasModule=$this->registry->users->hasMBA($user_id);
            $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
            if($hasModule||$video->isfree){
                $this->registry->template->hasMBA =$hasModule ;
                $this->registry->template->helperCourse =true ;
                $course=$this->registry->users->getSingleMbaHlperCoure($course_id);
                if(isset($course->id)){
                    $this->registry->users->update_last_login_mba($this->getuserid(),$course->id);
                    $course->hasCourse=$hasModule;
                    $this->registry->template->course=$course;
                    $this->registry->template->video=$video;
                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                    $this->registry->template->sections=$sections;
                    $this->registry->template->page_body = getviewslink().'/academy/showaudio';
                    $this->registry->template->show('index_home');
                }
            }
        }else{
            //$this->registry->sessionhandler->put('HTTP_REFERER','courses/'.$course_id.'/showCurriculum/'.$course_curriculum_id);
            return header('Location: /login');
        }
    }
    public function mbaCourse(){
        global  $location;

        $mba_id=get('mba_id');
        $course_id=get('course_id');
        $module=$this->registry->users->getsinglembamodule($mba_id);
        $course=$this->registry->users->getmbasinglecourse($course_id);
        if($module->hasModule){
            if(isset($course->id)){
                $this->registry->template->hasMBA=$module->hasModule;
                $course->hasCourse=true;
                $course->hasDiplomaExam =false;
                $this->registry->template->course=$course;
                //$sections=$this->registry->users->getcourse_sections($course->id);
                //$this->registry->template->sections=$sections;
                $sections=$this->registry->users->getcourse_sectionsWithNumbers($course->id);
                $this->registry->template->sections=$sections['sections'];
                $this->registry->template->hours_numbers=$sections['hours_numbers'];
                $this->registry->template->sections_numbers=$sections['sections_numbers'];
                $this->registry->template->module=$module;
                $condition = " AND id != ".$course->id;

                $condition .= " AND instractor =" .$course->instractor;
                $condition .= " order by sort DESC limit 3 ";
                $instractorCourses= $this->registry->users->getallcourses(" $location $condition");
                $this->registry->template->instractorCourses = $instractorCourses;
                if($this->getuserid()){
                    $this->registry->users->update_last_login_mba($this->getuserid(),$course->id);
                    $this->registry->template->courses_questions=$this->registry->users->getCourseQuestionsAnswers($course->id,$this->getuserid());
                }
                //$courses=$this->registry->users->getallcourses();
                //	$this->registry->template->courses=$courses;
                //faq
                $faqs=$this->registry->users->getfaq($course->id);
                $this->registry->template->faqs=$faqs;
                //faq
                $accreditations=$this->registry->users->getaccreditationstype('course',1);
                $this->registry->template->accreditations=$accreditations;
                $this->registry->template->page_body = getviewslink().'/academy/singlecourse';
                $this->registry->template->show('index_home');
            }else{
                self::redirect404();
            }
        }else{
            self::redirect404();
        }
    }
    public function mbaCourseShowCurriculum(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $mba_id=get('mba_id');
        //echo $username;

        $userID=$this->getuserid();

        if($userID){
            $module=$this->registry->users->getsinglembamodule($mba_id);

            if(isset($module->id)){
                if($course_curriculum_id>0) {
                    $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                }
                if ($video->isfree=='yes'){
                    $allowPage=true;
                }elseif($module->hasModule){
                    $allowPage=true;
                }

                if($allowPage){
                    global  $location;
                    $location = $this->getlocation();
                    if (!empty($course_id)) {
                        $course = $this->registry->users->getmbasinglecourse($course_id, $location);

                        if (!isset($course->id)) {
                            self::get_all_mba();
                            exit;
                        }
                        $this->registry->template->hasMBA=$module->hasModule;
                        $course->hasCourse=true;
                        $course->hasDiplomaExam =false;
                        if($course_curriculum_id>0){
                            $video=$this->registry->users->getCourseCurriculum($course_id,$course_curriculum_id);

                            if(isset($video->id)){
                                if($course->hasCourse||$video->isfree=='yes'){
                                    $this->registry->template->module=$module;
                                    $this->registry->template->course=$course;
                                    $this->registry->template->video=$video;
                                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                                    $this->registry->template->sections=$sections;
                                    $this->registry->template->show('/academy/showvideo');
                                }else{
                                    return header('Location: /subscribe');
                                }
                            }else{
                                self::display_all_courses();
                            }
                        }else{
                            self::display_all_courses();
                        }
                    }else{
                        self::display_all_courses();
                    }
                }else{
                    return header('Location: /subscribe');
                }
            }else{
                return $this->redirect404();
            }

        }else{
            $this->registry->sessionhandler->put('HTTP_REFERER','MBA/'.$mba_id.'/showCurriculum/'.$course_curriculum_id.'/'.$course_id);
            return header('Location: /login');
        }

    }
    public function mbaCourseShowCurriculumaudio(){
        $course_id=get('course_id');
        $course_curriculum_id=get('curriculum_id');
        $mba_id=get('mba_id');
        //echo $username;

        $userID=$this->getuserid();

        if($userID){
            $module=$this->registry->users->getsinglembamodule($mba_id);
            if(isset($module->id)){
                if($course_curriculum_id>0) {
                    $video = $this->registry->users->getCourseCurriculum($course_id, $course_curriculum_id);
                }
                if ($video->isfree=='yes'){
                    $allowPage=true;
                }elseif($module->hasModule){
                    $allowPage=true;
                }

                if($allowPage){
                    global  $location;
                    $location = $this->getlocation();
                    if (!empty($course_id)) {
                        $course = $this->registry->users->getmbasinglecourse($course_id, $location);
                        if (!isset($course->id)) {
                            self::display_all_courses();
                            exit;
                        }
                        $this->registry->template->hasMBA=$module->hasModule;
                        $course->hasCourse=true;
                        $course->hasDiplomaExam =false;
                        if($course_curriculum_id>0){
                            $video=$this->registry->users->getCourseCurriculum($course_id,$course_curriculum_id);

                            if(isset($video->id)){
                                if($course->hasCourse||$video->isfree=='yes'){



                                    $this->registry->template->module=$module;
                                    $this->registry->template->course=$course;
                                    $this->registry->template->video=$video;
                                    $sections=$this->registry->users->getCourseCurriculumSections($course_id);
                                    $this->registry->template->sections=$sections;
                                    $this->registry->template->page_body = getviewslink().'/academy/showaudio';
                                    $this->registry->template->show('index_home');

                                }else{
                                    return header('Location: /subscribe');
                                }
                            }else{
                                self::display_all_courses();
                            }
                        }else{
                            self::display_all_courses();
                        }
                    }else{
                        self::display_all_courses();
                    }
                }else{
                    return header('Location: /subscribe');
                }
            }else{
                return $this->redirect404();
            }

        }else{
            $this->registry->sessionhandler->put('HTTP_REFERER','MBA/'.$mba_id.'/showCurriculum/'.$course_curriculum_id.'/'.$course_id);
            return header('Location: /login');
        }
    }
    public function startModule(){
        $module_url=post('module_url');
        echo $this->registry->users->startModule($module_url);
    }
    public function showExam(){
        $user_id = $this->getuserid();

        if($user_id){
            $module_id = get('module_id');
            $module = $this->registry->users->getsinglembamodule($module_id);
            if(!isset($module->id)){return self::index();}
            $this->registry->template->module = $module;
            $this->registry->template->page_body = getviewslink() . '/academy/mbaexamlanguage';
            $this->registry->template->show('index_home');
        }else{
            return self::index();
        }
    }
    public function exam()
    {

        $user_id = $this->getuserid();
        if($user_id){
            $module_id = get('module_id');
            $lang = get('lang');
            $module = $this->registry->users->getsinglembamodule($module_id);
            if($module_id&&$module->hasModule){
                $this->registry->template->course = $module;
                //print_r($module);
                $hasExam=$this->registry->users->hasMakeModuleExam($module->id);
                $this->registry->template->hasExam=$hasExam;
                $exam_quetions = $this->registry->users->getMbaModuleExamQuestions($module->id,$module->questions_numbers,$lang);
                $this->registry->template->exam_quetions = $exam_quetions;
                //var_dump($exam_quetions);
                $user_action='Mba Exam';
                $user_action_table='modules_questions';
                $user_action_table_id=$module->id;
                $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
                $this->registry->template->page_body = getviewslink() . '/academy/mbasingleexam';
                $this->registry->template->show('index_home');
            }else{
                return self::index();
            }
        }else{
            return self::index();
        }

    }
    public function endExam()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $module_id = get('module_id');
            if ($module_id) {
                $module = $this->registry->users->getsinglembamodule($module_id);
                if ($module->hasModule) {
                    if (isset($_POST['questions'])) {
                        $questions = $_POST['questions'];
                        $lang=(isset($_GET['lang']))?$_GET['lang']:'ar';
                        $this->registry->users->completeMbaExamQuetions($questions,$module->questions_numbers,$module->id,$lang);
                    } else {
                        $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                        include 'views/message/error_message.php';
                    }
                }
            }
        }
    }

    public function showTraining(){
        $user_id = $this->getuserid();
        if($user_id){
            $module_id = get('module_id');
            $training_id = get('training_id');
            $module = $this->registry->users->getsinglembamodule($module_id);
            if(!isset($module->id)){return self::index();}
            $this->registry->template->module = $module;
            $this->registry->template->page_body = getviewslink() . '/academy/mbatraininglanguage';
            $this->registry->template->show('index_home');
        }else{
            return self::index();
        }
    }

    public function training()
    {
        $user_id = $this->getuserid();
        if($user_id){
            $module_id = get('module_id');
            $training_id = get('training_id');
            $lang = get('lang');
            $module = $this->registry->users->getsinglembamodule($module_id);
            $training=$this->registry->users->getsinglembamoduletraining($module->id,$training_id);
            if($module_id&&$module->hasModule&&isset($training->id)){
                $this->registry->template->course = $module;
                $this->registry->template->training = $training;
                //print_r($module);
                $exam_quetions = $this->registry->users->getMbaModuleTrainingQuestions($module->id,$training->questions_numbers,$training_id,$lang);
                $this->registry->template->exam_quetions = $exam_quetions;
                //var_dump($exam_quetions);
                $user_action='Mba Training';
                $user_action_table='modules_trainings';
                $user_action_table_id=get('training_id');
                $this->registry->users->activity_action($user_action,$user_action_table,$user_action_table_id);
                $this->registry->template->page_body = getviewslink() . '/academy/mbasingletraining';
                $this->registry->template->show('index_home');
            }else{
                return self::index();
            }
        }else{
            return self::index();
        }

    }
    public function endTraining()
    {
        $user_id = $this->getuserid();
        if ($user_id) {
            $module_id = get('module_id');
            $training_id = get('training_id');
            if ($module_id) {
                $module = $this->registry->users->getsinglembamodule($module_id);
                $training=$this->registry->users->getsinglembamoduletraining($module->id,$training_id);
                if ($module->hasModule&&isset($training->id)) {
                    if (isset($_POST['questions'])) {
                        $questions = $_POST['questions'];

                        $this->registry->users->completeMbaTrainingQuetions($questions,$training->questions_numbers,$module->id,$training_id);
                    } else {
                        $errorMessage = 'تأكد من الإجابه على جميع الاسئله';
                        include 'views/message/error_message.php';
                    }
                }
            }
        }
    }
    public function resultView(){
        if($this->getuserid()) {
            $result_id = get('result_id');
            if ($result_id) {
                $lang=get('lang');
                $answer = $this->registry->users->getMbaExamAnswers($result_id,$lang);
                if($answer){
                    $this->registry->template->answer=$answer;
                    //$this->registry->template->showAnswers=true;
                    $this->registry->template->page_body = getviewslink().'/academy/mbasinglereport';
                    $this->registry->template->show('index_home');
                }else {
                    self::index();
                }
            } else {
                self::index();
            }
        }else{
            self::index();
        }
    }
    public function resultViewWedget(){
                  $id=get('id');
                 $lang=get('lang');
                $quetions = $this->registry->users->getMbaExamAnswerswedget($id,$lang);
                if(count($quetions)){
                    $this->registry->template->quetions=$quetions;
                    include(getviewslink() . '/academy/wedget/mba/mba_single_report.php');

            }

    }
    public function resultTrainingView(){
        if($this->getuserid()) {
            $result_id = get('result_id');
            if ($result_id) {
                $lang=get('lang');
                $answer = $this->registry->users->getMbaTrainingAnswers($result_id,$lang);
                if($answer){
                    $this->registry->template->answer=$answer;
                    $this->registry->template->showAnswers=true;
                    $this->registry->template->page_body = getviewslink().'/academy/mbasinglereport';
                    $this->registry->template->show('index_home');
                }else {
                    self::index();
                }
            } else {
                self::index();
            }
        }else{
            self::index();
        }
    }


}
