<?php

Class newsController Extends baseController {
    public function index()
    {

        $news_id=get('news_id');

        if(strpos($_SERVER['REQUEST_URI'], 'attachment_id') !== false){
            self::redirect404();die();
        }

        if($news_id){
            if(is_numeric($news_id)) {
                $news = $this->registry->news->getNewsByID($news_id);
                if (count($news)) {
                    return header('Location: /news/' . $news->url);
                }
            }
            $this->singleNews($news_id);
        }else{
            $this->defaultPage();

        }
    }
    public function searchFilter()
    {

        global  $location;
        $user_id = self::getuserid();

        $IsLogin=false;
        if ($user_id>0){
            $IsLogin=true;
        }

if(post('page')){
    $page=post('page');
}else{
    $page=1;
}


        // die();
        $page_first_result = ($page - 1) * 2;
        $IsLogin=$IsLogin;
        $condition=" published='yes'";

        if(isset($_POST['newest'])&&$_POST['newest']==1){
            $condition .= " ORDER BY news_date DESC";
        }
        elseif(isset($_POST['oldest'])&&$_POST['oldest']==1){
            $condition .= " ORDER BY news_date ASC";
        }else{
            $condition .= " ORDER BY news_date ASC";
        }

        $total = $this->registry->news->getNewsQueryCount($condition);
//        var_dump($total);die();
        $pages = ceil($total / 20);
        $this->registry->template->pages = $pages;
        $this->registry->template->current_page=1;

        $news = $this->registry->news->getNews(" $location $condition limit $page_first_result,20");
    $current_page=$page;
//var_dump($pages);die();
        global $config;
        $assets_path=$config['assets_path'];
        include(getviewslink() . '/academy/wedget/news-content.php');
    }
    private function defaultPage(){
//        var_dump('hi');die();

        //$links = 9;
        global  $location;
        $condition=" published='yes' ORDER BY news_date ASC ";

        $total = $this->registry->news->getNewsCount();
        $pages = ceil($total / 20);
        $this->registry->template->pages = $pages;
        $this->registry->template->current_page=1;
        $this->registry->template->news = $this->registry->news->getNews(" $location $condition limit 0,20" );
        $this->registry->template->page_body = getviewslink().'/academy/news';

        $this->registry->template->show('index_home');
    }
    public function getMoreBlog(){
        $skip=post('skip');
        if($skip){
            $articles=$this->registry->news->getNews(20,'and published=1',0,$skip);

            $assets_path=$GLOBALS['config']['assets_path'];
            $helper=new objects();
            include getviewslink().'/newsarticles.php';
        }
    }
    private function singleNews($news_id){

        $news = $this->registry->news->getnews_byid($news_id);
        if(isset($news->id)){
            $this->registry->template->news=$news;
           $this->registry->template->best_views_articlees = $this->registry->news->getnewestNews("order by views desc limit 9");

            $this->registry->template->page_body = getviewslink().'/academy/single-news';
            $this->registry->template->show('index_home');
        }else{
                     $redirect_url=$this->registry->users->getRedirectUrl($news->url);

                if($redirect_url ){
                    return header('Location:' . $redirect_url);
                }else {
                    $news_url = $this->registry->users->getOldUrl($news_id, 'news');
                    if ($news_url) {
                        $news = $this->registry->news->getnews_byid($news_url);
                          if(isset($news->id)) {
                              return header('Location: /news/' . $news_url);
                          }else{
                              return header('Location: /news');
                          }

                    }
                    else{
                        return header('Location: /news' );
                    }
                }
        }

    }
    public  function getUrlApi(){
        $news_id=get('news_id');
        $data=['success'=>false];
        if($news_id){
            $news=$this->registry->news->getNewsByID($news_id);
            if(count($news)){
                $data=['success'=>true,'url'=>$news->url];
            }
        }
        echo json_encode($data);
    }
}
?>
